/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicPopupMenuUI;
import tvbrowser.core.Settings;

public class ScrollableMenu
extends JMenu {
    private int maxItemsToDisplay = 1;
    private ScrollUpOrDownButtonItem scrollUp = new ScrollUpOrDownButtonItem(ScrollDirection.UP);
    private ScrollUpOrDownButtonItem scrollDown = new ScrollUpOrDownButtonItem(ScrollDirection.DOWN);
    private JSeparator upSeperator = new JSeparator();
    private JSeparator downSeperator = new JSeparator();
    private Vector<Component> scrollableItems = new Vector();
    private int beginIndex = 0;
    private int maxWidth = 10;
    private int maxHeight = 1;

    private void setMaxItemToDisplay() {
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.maxItemsToDisplay = Math.max(dim.height / this.maxHeight - 3, 3);
    }

    public ScrollableMenu() {
        this("");
    }

    public ScrollableMenu(Action a) {
        this("");
        this.setAction(a);
    }

    public ScrollableMenu(String s, boolean b) {
        this(s);
    }

    public ScrollableMenu(String menuTitle) {
        super(menuTitle);
        super.add(this.scrollUp);
        super.add(this.upSeperator);
        super.add(this.downSeperator);
        super.add(this.scrollDown);
        this.getPopupMenu().addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                ScrollableMenu.this.getPopupMenu().setPreferredSize(null);
                ScrollableMenu.this.getPopupMenu().setPreferredSize(new Dimension(Math.max(ScrollableMenu.this.maxWidth, ScrollableMenu.this.getPopupMenu().getPreferredSize().width), ScrollableMenu.this.getPopupMenu().getPreferredSize().height));
            }
        });
    }

    @Override
    public JMenuItem add(JMenuItem menuItem) {
        this.addScrollableComponent(menuItem);
        return menuItem;
    }

    @Override
    public Component add(Component component) {
        this.addScrollableComponent(component);
        return component;
    }

    @Override
    public Component add(Component component, int index) {
        this.addScrollableComponent(component, index);
        return component;
    }

    @Override
    public void insert(String s, int pos) {
        if (pos < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.insert(new JMenuItem(s), pos);
    }

    @Override
    public JMenuItem insert(JMenuItem menuItem, int pos) {
        if (pos < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.addScrollableComponent(menuItem, pos);
        return menuItem;
    }

    @Override
    public JMenuItem insert(Action a, int pos) {
        if (pos < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        JMenuItem menuItem = new JMenuItem((String)a.getValue("Name"), (Icon)a.getValue("SmallIcon"));
        menuItem.setHorizontalTextPosition(11);
        menuItem.setVerticalTextPosition(0);
        menuItem.setEnabled(a.isEnabled());
        menuItem.setAction(a);
        this.insert(menuItem, pos);
        return menuItem;
    }

    @Override
    public JMenuItem getItem(int pos) {
        if (pos < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        JMenuItem menuItem = null;
        Component component = this.getMenuComponent(pos);
        if (component instanceof JMenuItem) {
            menuItem = (JMenuItem)component;
        }
        return menuItem;
    }

    @Override
    public int getItemCount() {
        return this.getMenuComponentCount();
    }

    @Override
    public void remove(JMenuItem menuItem) {
        this.removeScrollableComponent(menuItem);
    }

    @Override
    public void remove(int pos) {
        if (pos < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        if (pos > this.getItemCount()) {
            throw new IllegalArgumentException("index greater than the number of items.");
        }
        this.removeScrollableComponent(this.scrollableItems.elementAt(pos));
    }

    @Override
    public void remove(Component component) {
        this.removeScrollableComponent(component);
    }

    @Override
    public void removeAll() {
        while (this.getMenuComponentCount() > 0) {
            this.remove(0);
        }
        this.maxWidth = 10;
        this.maxHeight = 0;
    }

    @Override
    public int getMenuComponentCount() {
        return this.scrollableItems.size();
    }

    @Override
    public Component getMenuComponent(int n) {
        if (n >= 0 && n < this.scrollableItems.size()) {
            return this.scrollableItems.elementAt(n);
        }
        return null;
    }

    @Override
    public Component[] getMenuComponents() {
        Component[] components = new Component[this.getMenuComponentCount()];
        Iterator<Component> iterator = this.scrollableItems.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            components[index++] = iterator.next();
        }
        return components;
    }

    @Override
    public boolean isMenuComponent(Component component) {
        return this.scrollableItems.contains(component);
    }

    @Override
    public void addSeparator() {
        this.add(new JPopupMenu.Separator());
    }

    protected void addScrollableComponent(Component component, int pos) {
        if (pos < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.scrollableItems.insertElementAt(component, pos);
        this.setPreferedSizeForMenuItems(component);
        if (pos >= this.beginIndex && pos < this.beginIndex + this.maxItemsToDisplay) {
            super.add(component, pos - this.beginIndex + 2);
        }
        while (super.getMenuComponentCount() > this.maxItemsToDisplay + 4) {
            super.remove(super.getMenuComponentCount() - 3);
        }
        this.updateScrollingComponentsVisibility();
    }

    protected void addScrollableComponent(Component component) {
        this.addScrollableComponent(component, this.scrollableItems.size());
    }

    protected void removeScrollableComponent(Component component) {
        this.scrollableItems.remove(component);
        super.remove(component);
        if (this.scrollableItems.size() > this.maxItemsToDisplay && super.getMenuComponentCount() - 4 < this.maxItemsToDisplay) {
            if (this.beginIndex + this.maxItemsToDisplay <= this.scrollableItems.size()) {
                int end = this.beginIndex + this.maxItemsToDisplay - 1;
                Component addComponent = this.scrollableItems.elementAt(end);
                super.add(addComponent, this.maxItemsToDisplay + 1);
            } else if (this.beginIndex > 0 && this.beginIndex <= this.scrollableItems.size()) {
                Component addComponent = this.scrollableItems.elementAt(--this.beginIndex);
                super.add(addComponent, 2);
            }
        } else if (this.beginIndex > 0 && this.beginIndex + this.maxItemsToDisplay > this.scrollableItems.size()) {
            --this.beginIndex;
        }
        this.updateScrollingComponentsVisibility();
    }

    private Component getFirstVisibleAndEnabledComponent() {
        if (super.getMenuComponentCount() > 4) {
            for (int index = 2; index < super.getMenuComponentCount() - 2; ++index) {
                Component component = super.getMenuComponent(index);
                if (!(component instanceof MenuElement) || !component.isEnabled()) continue;
                return component;
            }
        }
        return null;
    }

    private Component getLastVisibleAndEnabledComponent() {
        if (super.getMenuComponentCount() > 4) {
            for (int index = super.getMenuComponentCount() - 3; index > 1; --index) {
                Component component = super.getMenuComponent(index);
                if (!(component instanceof MenuElement) || !component.isEnabled()) continue;
                return component;
            }
        }
        return null;
    }

    private Component getFirstVisibleComponent() {
        if (super.getMenuComponentCount() > 4) {
            return super.getMenuComponent(2);
        }
        return null;
    }

    private Component getLastVisibleComponent() {
        if (super.getMenuComponentCount() > 4) {
            return super.getMenuComponent(super.getMenuComponentCount() - 3);
        }
        return null;
    }

    private void updateScrollingComponentsVisibility() {
        boolean visible = this.scrollableItems.size() > this.maxItemsToDisplay;
        this.scrollDown.setVisible(visible);
        this.scrollUp.setVisible(visible);
        this.upSeperator.setVisible(visible);
        this.downSeperator.setVisible(visible);
        if (visible) {
            this.scrollUp.enableScroll(this.beginIndex > 0);
            this.scrollDown.enableScroll(this.beginIndex + this.maxItemsToDisplay < this.scrollableItems.size());
        }
        this.getPopupMenu().validate();
        this.getPopupMenu().repaint();
    }

    private void setPreferedSizeForMenuItems(Component component) {
        if (component instanceof JComponent && !(component instanceof JPopupMenu.Separator)) {
            KeyStroke s;
            JComponent jcomp = (JComponent)component;
            int width = jcomp.getPreferredSize().width;
            int height = jcomp.getPreferredSize().height;
            if (component instanceof JMenuItem && ((JMenuItem)component).getAccelerator() != null && Settings.LookAndFeel.SELECTED.getString().startsWith("com.jgoodies.looks") && (s = ((JMenuItem)component).getAccelerator()) != null) {
                try {
                    JLabel test = new JLabel(s.toString().replaceAll("\\s+pressed\\s+", "-").trim());
                    width += test.getPreferredSize().width + 20;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            if (jcomp.getBorder() != null) {
                Insets insets = jcomp.getBorder().getBorderInsets(component);
                width += insets.left + insets.right;
            }
            if (width > this.maxWidth || height > this.maxHeight) {
                if (width > this.maxWidth) {
                    this.maxWidth = width;
                }
                if (height > this.maxHeight) {
                    this.maxHeight = height;
                    this.setMaxItemToDisplay();
                }
                for (Component scrollableItem : this.scrollableItems) {
                    if (!(scrollableItem instanceof JComponent) || scrollableItem instanceof JPopupMenu.Separator) continue;
                    JComponent jComponent = (JComponent)scrollableItem;
                    jComponent.setPreferredSize(new Dimension(this.maxWidth, this.maxHeight));
                }
            } else {
                jcomp.setPreferredSize(new Dimension(this.maxWidth, this.maxHeight));
            }
        }
    }

    private void scrollUpClicked() {
        if (this.scrollableItems.size() <= this.maxItemsToDisplay || this.beginIndex == 0) {
            return;
        }
        super.remove(this.maxItemsToDisplay + 1);
        super.add(this.scrollableItems.elementAt(--this.beginIndex), 2);
        this.updateScrollingComponentsVisibility();
        if (this.getLastVisibleComponent() instanceof JSeparator) {
            this.scrollUpClicked();
        }
    }

    private void scrollDownClicked() {
        if (this.scrollableItems.size() <= this.maxItemsToDisplay || this.beginIndex + this.maxItemsToDisplay == this.scrollableItems.size()) {
            return;
        }
        super.remove(2);
        super.add(this.scrollableItems.elementAt(this.beginIndex + this.maxItemsToDisplay), this.maxItemsToDisplay + 1);
        ++this.beginIndex;
        this.updateScrollingComponentsVisibility();
        if (this.getFirstVisibleComponent() instanceof JSeparator) {
            this.scrollDownClicked();
        }
    }

    @Override
    public MenuElement[] getSubElements() {
        ArrayList<MenuElement> elements = new ArrayList<MenuElement>();
        for (Component c : this.scrollableItems) {
            if (!(c instanceof MenuElement)) continue;
            elements.add((MenuElement)((Object)c));
        }
        return elements.toArray(new MenuElement[elements.size()]);
    }

    static {
        JPopupMenu dummy = new JPopupMenu();
        BasicPopupMenuUI ui = (BasicPopupMenuUI)BasicPopupMenuUI.createUI(dummy);
        ui.installUI(dummy);
        ActionMap map = (ActionMap)UIManager.getLookAndFeelDefaults().get("PopupMenu.actionMap");
        if (map != null) {
            Action downAction = map.get("selectNext");
            Action upAction = map.get("selectPrevious");
            map.put("selectNext", new SelectNextItemAction(ScrollDirection.DOWN, downAction));
            map.put("selectPrevious", new SelectNextItemAction(ScrollDirection.UP, upAction));
        }
    }

    private class ScrollUpOrDownButtonItem
    extends JMenuItem {
        private ScrollDirection mDirection = ScrollDirection.UP;
        private Polygon mArrow = null;
        private boolean mIsMouseOver = false;
        private boolean mEnableScroll = false;
        private MyMouseListener mMouseListener;
        private MyActionListener mActionListener;
        private int mInitialDelay = 300;
        private int mRepeatDelay = 50;
        private Timer mTimer = null;

        public ScrollUpOrDownButtonItem(ScrollDirection direction) {
            this.mDirection = direction;
            this.setVisible(false);
            this.setPreferredSize(new Dimension(10, 10));
            this.setSize(new Dimension(10, 10));
            this.setMinimumSize(new Dimension(10, 10));
            this.mMouseListener = new MyMouseListener();
            this.addMouseListener(this.mMouseListener);
            this.mActionListener = new MyActionListener();
            this.mTimer = new Timer(this.mRepeatDelay, this.mActionListener);
            this.mTimer.setInitialDelay(this.mInitialDelay);
        }

        public void enableScroll(boolean enableScroll) {
            this.mEnableScroll = enableScroll;
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics g) {
            Color oldColor = g.getColor();
            g.setColor(ScrollableMenu.this.getBackground());
            Rectangle rect = g.getClipBounds();
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
            if (this.mIsMouseOver && this.mEnableScroll) {
                g.setColor(Color.blue);
            } else if (!this.mEnableScroll) {
                g.setColor(Color.gray);
            } else {
                g.setColor(ScrollableMenu.this.getForeground());
            }
            g.fillPolygon(this.getArrow());
            g.setColor(oldColor);
        }

        private Polygon getArrow() {
            if (this.mArrow == null) {
                this.mArrow = new Polygon();
                if (this.mDirection == ScrollDirection.UP) {
                    this.mArrow.addPoint((int)((double)this.getSize().width / 2.0 - 6.0 + 0.5), (int)((double)this.getSize().height / 2.0 + 3.0 + 0.5));
                    this.mArrow.addPoint((int)((double)this.getSize().width / 2.0 + 6.0 + 0.5), (int)((double)this.getSize().height / 2.0 + 3.0 + 0.5));
                    this.mArrow.addPoint((int)((double)this.getSize().width / 2.0 + 0.5), (int)((double)this.getSize().height / 2.0 - 4.0 + 0.5));
                } else {
                    this.mArrow.addPoint((int)((double)this.getSize().width / 2.0 - 6.0 + 0.5), (int)((double)this.getSize().height / 2.0 - 3.0 + 0.5));
                    this.mArrow.addPoint((int)((double)this.getSize().width / 2.0 + 6.0 + 0.5), (int)((double)this.getSize().height / 2.0 - 3.0 + 0.5));
                    this.mArrow.addPoint((int)((double)this.getSize().width / 2.0 + 0.5), (int)((double)this.getSize().height / 2.0 + 4.0 + 0.5));
                }
            }
            return this.mArrow;
        }

        private void scroll() {
            if (this.mDirection == ScrollDirection.UP) {
                ScrollableMenu.this.scrollUpClicked();
            } else {
                ScrollableMenu.this.scrollDownClicked();
            }
        }

        private void startScrollTimer() {
            if (this.mEnableScroll) {
                this.mTimer.start();
            } else {
                this.mTimer.stop();
            }
        }

        private class MyMouseListener
        extends MouseAdapter {
            private MyMouseListener() {
            }

            @Override
            public void mouseClicked(MouseEvent me) {
                ScrollUpOrDownButtonItem.this.scroll();
            }

            @Override
            public void mouseEntered(MouseEvent me) {
                ScrollUpOrDownButtonItem.this.mIsMouseOver = true;
                ScrollUpOrDownButtonItem.this.repaint();
                ScrollUpOrDownButtonItem.this.startScrollTimer();
            }

            @Override
            public void mouseExited(MouseEvent me) {
                ScrollUpOrDownButtonItem.this.mIsMouseOver = false;
                ScrollUpOrDownButtonItem.this.mTimer.stop();
                ScrollUpOrDownButtonItem.this.repaint();
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                ScrollUpOrDownButtonItem.this.startScrollTimer();
            }

            @Override
            public void mouseReleased(MouseEvent mouseevent) {
                ScrollUpOrDownButtonItem.this.mTimer.stop();
            }
        }

        private class MyActionListener
        implements ActionListener {
            private MyActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                ScrollUpOrDownButtonItem.this.scroll();
            }
        }
    }

    private static class SelectNextItemAction
    extends AbstractAction {
        private ScrollDirection direction;
        private Action wrappedAction;

        SelectNextItemAction(ScrollDirection direction, Action wrappedAction) {
            this.direction = direction;
            this.wrappedAction = wrappedAction;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MenuSelectionManager msm = MenuSelectionManager.defaultManager();
            MenuElement[] path = msm.getSelectedPath();
            int len = path.length;
            if (len > 2 && path[len - 3] instanceof ScrollableMenu && path[len - 2] instanceof JPopupMenu) {
                Component component;
                ScrollableMenu menu = (ScrollableMenu)path[len - 3];
                MenuElement selected = path[len - 1];
                Component component2 = component = this.direction == ScrollDirection.UP ? menu.getFirstVisibleAndEnabledComponent() : menu.getLastVisibleAndEnabledComponent();
                if (component == null || selected == component) {
                    boolean enableScroll;
                    boolean bl = enableScroll = this.direction == ScrollDirection.UP ? menu.scrollUp.mEnableScroll : menu.scrollDown.mEnableScroll;
                    if (enableScroll) {
                        do {
                            if (this.direction == ScrollDirection.UP) {
                                menu.scrollUpClicked();
                                component = menu.getFirstVisibleComponent();
                                enableScroll = menu.scrollUp.mEnableScroll;
                                continue;
                            }
                            menu.scrollDownClicked();
                            component = menu.getLastVisibleComponent();
                            enableScroll = menu.scrollDown.mEnableScroll;
                        } while (component != null && !(component instanceof MenuElement) && component instanceof JSeparator && enableScroll);
                        if (component == null || !component.isEnabled() || !(component instanceof MenuElement)) {
                            return;
                        }
                    } else {
                        for (int index = 0; index < menu.getMenuComponentCount(); ++index) {
                            if (this.direction == ScrollDirection.UP) {
                                menu.scrollDownClicked();
                                continue;
                            }
                            menu.scrollUpClicked();
                        }
                    }
                }
            }
            this.wrappedAction.actionPerformed(e);
        }
    }

    private static enum ScrollDirection {
        UP,
        DOWN;

    }
}

