/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import util.misc.TextLineBreakerFontWidth;

public class TextAreaIcon
implements Icon {
    private static final Logger mLog = Logger.getLogger(TextAreaIcon.class.getName());
    private int mWidth;
    private String[] mTextLineArr;
    private Font mFont;
    private int mMaxLineCount = -1;
    private String mText;
    private int mLineSpace;

    public TextAreaIcon(String text, Font font, int width, int lineSpace) {
        if (width <= 0) {
            mLog.warning("TextAreaIcon width " + width);
        }
        this.mWidth = width;
        this.mFont = font;
        this.mLineSpace = lineSpace;
        this.setText(text);
    }

    public TextAreaIcon(String text, Font font, int width) {
        this(text, font, width, 0);
    }

    public void setMaximumLineCount(int maxLineCount) {
        if (this.mMaxLineCount != maxLineCount) {
            this.mMaxLineCount = maxLineCount;
            if (this.mTextLineArr != null && this.mTextLineArr.length >= this.mMaxLineCount) {
                this.setText(this.mText);
            }
        }
    }

    public int getMaximumLineCount() {
        return this.mMaxLineCount;
    }

    public void setText(String text) {
        this.mText = text;
        StringReader reader = text == null ? null : new StringReader(text);
        try {
            this.setText(reader);
        }
        catch (IOException exc) {
            mLog.log(Level.WARNING, "Reading String failed: '" + text + "'", exc);
        }
    }

    public void setText(Reader textReader) throws IOException {
        if (textReader == null) {
            this.mTextLineArr = null;
        } else {
            TextLineBreakerFontWidth breaker = new TextLineBreakerFontWidth(this.mFont);
            this.mTextLineArr = breaker.breakLines(textReader, this.mWidth, this.mMaxLineCount);
        }
    }

    @Override
    public int getIconHeight() {
        if (this.mTextLineArr == null) {
            return 0;
        }
        return this.getHeightForLineCount(this.mTextLineArr.length);
    }

    @Override
    public int getIconWidth() {
        return this.mWidth;
    }

    public int getLineCount() {
        return this.mTextLineArr.length;
    }

    @Override
    public void paintIcon(Component comp, Graphics grp, int x, int y) {
        if (this.mTextLineArr != null) {
            if (comp != null) {
                grp.setColor(comp.getForeground());
            }
            grp.setFont(this.mFont);
            int fontSize = this.mFont.getSize();
            for (String textLine : this.mTextLineArr) {
                grp.drawString(textLine, x, y += fontSize);
                y += this.mLineSpace;
            }
        }
    }

    public boolean isTextCut() {
        return this.mMaxLineCount > 0 && this.mMaxLineCount == this.mTextLineArr.length && this.mTextLineArr[this.mMaxLineCount - 1].endsWith("\u2026");
    }

    public int getHeightForLineCount(int lines) {
        return lines * (this.mFont.getSize() + this.mLineSpace);
    }
}

