(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    896774,      18330]*)
(*NotebookOutlinePosition[    897652,      18360]*)
(*  CellTagsIndexPosition[    897608,      18356]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["\<\
PolytopeSkeleton.m
Visualizing Convex Polytope Skeletons (with cddmathlink)\
\>", "Title",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[TextData[StyleBox["Komei Fukuda, fukuda@ifor.math.ethz.ch\nSwiss Federal \
Institute of Technology, Lausanne and Zurich\nDecember 17, 2002",
  FontSize->17,
  FontSlant->"Italic"]], "Subtitle",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["Preparation (reading Packages)", "Section",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["Off[General::spell1]; Off[General::spell]", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["$Path = Append[$Path,\"~/Math\"]; ", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[TextData[{
  "We use an extra graphics package available from ",
  StyleBox["MathSource",
    FontSlant->"Italic"],
  ".    It is called View3D which is a part of ExtendGraphics  package wrtten \
by  Tom Wickham-Jones .  The package is available at ",
  StyleBox["http://www.mathsource.com/",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ".  If you install it in a directory which in not in the $Path, you need to \
append the directory to $Path."
}], "Text",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["$Path", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({"/Users/fukuda/Library/Mathematica/4.1/Kernel", 
      "/Users/fukuda/Library/Mathematica/4.1/AddOns/Autoload", 
      "/Users/fukuda/Library/Mathematica/4.1/AddOns/Applications", 
      "/Library/Mathematica/Kernel/", "/Library/Mathematica/Autoload/", 
      "/Library/Mathematica/Applications/", "/Library/Mathematica/", ".", 
      "/Users/fukuda", 
      "/Applications/LocalApps/Mathematica 4.1.app/AddOns/StandardPackages", 
      "/Applications/LocalApps/Mathematica \
4.1.app/AddOns/StandardPackages/StartUp", 
      "/Applications/LocalApps/Mathematica 4.1.app/AddOns/Autoload", 
      "/Applications/LocalApps/Mathematica 4.1.app/AddOns/Applications", 
      "/Applications/LocalApps/Mathematica 4.1.app/AddOns/ExtraPackages", 
      "/Applications/LocalApps/Mathematica \
4.1.app/SystemFiles/Graphics/Packages", 
      "/Applications/LocalApps/Mathematica 4.1.app/Configuration/Kernel", 
      "~/Math", "~/Math", "~/Math"}\)], "Output"]
}, Open  ]],

Cell["Needs[\"ExtendGraphics`View3D`\"];", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[TextData[{
  "cddmathlink is a ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  "  version of libcdd for doing the vertex enumeration and the facet \
enumeration of a convex polyhedron.  cddlib-080.tar.gz is available from \
Fukuda's Homepage:   http:///www.ifor.math.ethz.ch/staff/fukuda/fukuda.html  \
.   Look for \"cdd Homepage\"."
}], "Text",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["cddml=Install[\"~/Math/cddmathlink\"]", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(LinkObject["/Users/fukuda/Math/cddmathlink", 4, 3]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The following packages come with libcdd package and should be installed in \
your favorite directory.  Here I assume it is in \"~/Math\" directory.   They \
are separately available from Fukuda's Homepage: \
http:///www.ifor.math.ethz.ch/staff/fukuda/fukuda.html  .  Look for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Projects."
}], "Text",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["<< PolytopeSkeleton.m", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["<< IOPolyhedra.m", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(Syntax::"com" \(\(:\)\(\ \)\) 
      "Warning: comma encountered with no adjacent expression; the expression \
will be treated as Null. \!\(\" (line 49 of \\\"IOPolyhedra.m\\\")\"\)"\)], \
"Message"]
}, Open  ]],

Cell[CellGroupData[{

Cell["<< UnfoldPolytope.m", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(Syntax::"com" \(\(:\)\(\ \)\) 
      "Warning: comma encountered with no adjacent expression; the expression \
will be treated as Null. \!\(\" (line 90 of \
\\\"UnfoldPolytope.m\\\")\"\)"\)], "Message"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compute theVertices of a Polytope by using cddmathlink", "Section",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["FileNames[\"*\",\"~/Math/ine_3d\"]", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({"~/Math/ine_3d/cube3a.ine", "~/Math/ine_3d/cube3b.ine", 
      "~/Math/ine_3d/cube3.ine", "~/Math/ine_3d/cubocta.ine", 
      "~/Math/ine_3d/cuboctaT.ine", "~/Math/ine_3d/denault1.ine", 
      "~/Math/ine_3d/dodeca.ine", "~/Math/ine_3d/dodecaT.ine", 
      "~/Math/ine_3d/grcubocta.ine", "~/Math/ine_3d/grcuboctaT.ine", 
      "~/Math/ine_3d/hexocta.ine", "~/Math/ine_3d/hexoctaT.ine", 
      "~/Math/ine_3d/icododeca.ine", "~/Math/ine_3d/icododecaT.ine", 
      "~/Math/ine_3d/icosaT.ine", "~/Math/ine_3d/rcubocta.ine", 
      "~/Math/ine_3d/rcuboctaT.ine", "~/Math/ine_3d/rhomtria.ine", 
      "~/Math/ine_3d/rhomtriaT.ine", "~/Math/ine_3d/scube3.ine", 
      "~/Math/ine_3d/zono3_10.ine"}\)], "Output"]
}, Open  ]],

Cell["\<\
The file test.ine is the main output file of cdd+, which gives the \
inequality (facet) representation of the polytope.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["\<\
MatrixForm[inedata=
\tReadPolyhedraData[\"~/Math/ine_3d/hexocta.ine\"]];\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    InterpretationBox[\("m="\[InvisibleSpace]48\[InvisibleSpace]",   n="\
\[InvisibleSpace]4\[InvisibleSpace]" type="\[InvisibleSpace]"integer"\),
      SequenceForm[ "m=", 48, ",   n=", 4, " type=", "integer"],
      Editable->False]], "Print"]
}, Open  ]],

Cell["\<\
amat=-Transpose[Drop[Transpose[inedata],1]];
bvec=Transpose[inedata][[1]];\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["{m,d}=Dimensions[inedata]", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({48, 4}\)], "Output"]
}, Open  ]],

Cell["\<\
{{extlist,linearity},ecdlist,eadlist,icdlist,iadlist}=
\tAllVerticesWithAdjacency[m,d,Flatten[inedata]];\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["vlist = Map[Drop[#, 1]&, extlist]", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({{\(-0.5000000000000002`\), \(-0.5000000000000002`\), 
        0.4999999999999997`}, {\(-0.5999999999999998`\), \
\(-2.2204460492503246`*^-17\), 
        0.6000000000000003`}, {\(-0.5000000000000001`\), 0.5`, 
        0.4999999999999999`}, {\(-2.2204460492503072`*^-16\), \
\(-1.1102230246251578`*^-16\), 
        1.`}, {1.7763568394002483`*^-16, \(-0.6000000000000002`\), 
        0.5999999999999998`}, {0.`, 0.6000000000000001`, 
        0.6`}, {0.49999999999999967`, \(-0.5000000000000003`\), 0.5`}, {0.5`, 
        0.5`, 0.5`}, {0.6`, 8.881784197001252`*^-17, 0.6`}, {1.`, 0.`, 
        0.`}, {0.6`, 0.6`, 0.`}, {0.6000000000000001`, 
        4.440892098500625`*^-17, \(-0.5999999999999999`\)}, {0.6`, \(-0.6`\), 
        0.`}, {0.5`, 
        0.5`, \(-0.5`\)}, {0.5000000000000002`, \(-0.4999999999999999`\), \
\(-0.4999999999999999`\)}, {\(-8.881784197001252`*^-17\), 
        0.6`, \(-0.6`\)}, {\(-8.881784197001258`*^-17\), \
\(-0.5999999999999999`\), \(-0.6`\)}, {0.`, 1.`, 
        0.`}, {5.181040781584065`*^-16, 
        8.881784197001247`*^-17, \(-0.9999999999999997`\)}, \
{7.401486830834381`*^-17, \(-1.`\), 
        4.440892098500629`*^-17}, {\(-0.6000000000000001`\), 
        0.6000000000000001`, 
        2.2944609175586584`*^-17}, {\(-0.4999999999999999`\), 
        0.5`, \(-0.5`\)}, {\(-0.6000000000000006`\), 
        9.769962616701379`*^-17, \(-0.5999999999999991`\)}, \
{\(-0.4999999999999999`\), \(-0.5`\), \(-0.5`\)}, {\(-0.6000000000000004`\), \
\(-0.5999999999999995`\), 4.9589961766590355`*^-17}, {\(-1.`\), 
        1.8503717077085943`*^-16, 4.5642502123478674`*^-17}}\)], "Output"]
}, Open  ]],

Cell["\<\
invertpos[l_List, j_]:=
\tModule[{i,pos={}},
\t\tDo[
\t\t\tIf[Position[l[[i]],j]!={},AppendTo[pos,i]],
\t\t\t{i,1,Length[l]}
\t\t];
\t\tpos
\t];
dualizeIndices[ecd_List, ineLen_Integer]:=
\tMap[invertpos[ecd,#]&, Range[ineLen]];\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["icdlist=dualizeIndices[ecdlist, Length[inedata]]", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({{7, 9, 10}, {4, 8, 9}, {4, 7, 9}, {8, 9, 10}, {7, 13, 20}, {13, 15, 
        20}, {7, 10, 13}, {10, 13, 15}, {16, 18, 22}, {16, 19, 22}, {14, 16, 
        18}, {14, 16, 19}, {17, 19, 24}, {17, 20, 24}, {15, 17, 19}, {15, 17, 
        20}, {1, 2, 26}, {2, 3, 4}, {2, 3, 26}, {1, 2, 4}, {1, 20, 25}, {1, 
        25, 26}, {20, 24, 25}, {24, 25, 26}, {19, 23, 24}, {22, 23, 26}, {19, 
        22, 23}, {23, 24, 26}, {18, 21, 22}, {3, 18, 21}, {21, 22, 26}, {3, 
        21, 26}, {5, 7, 20}, {4, 5, 7}, {1, 5, 20}, {1, 4, 5}, {4, 6, 8}, {6, 
        8, 18}, {3, 4, 6}, {3, 6, 18}, {10, 12, 14}, {12, 15, 19}, {12, 14, 
        19}, {10, 12, 15}, {11, 14, 18}, {8, 11, 18}, {10, 11, 14}, {8, 10, 
        11}}\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Drawing the Skeleton of a Polytope", "Section",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["Defining 3D objects.  ", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["\<\
skel3D[vp_]:= 
\tGraphics3D[
\t\tVisibleSkeleton[vlist, ecdlist, eadlist, 
     \t{amat, bvec}, vp]
     ]; 
\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
facets=Map[(Part[vlist,#]) &, icdlist];
facets1=OrderFacets[facets];
solid3D:= Graphics3D[Polygon /@ facets1]; 
\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Draw a Polytope  by Built-In Graphics", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["\<\
Do[ uvp=circle[a,5,2];
\tShow[solid3D, 
\t\tBoxed->False, 
 \t\tViewPoint -> getMmaViewPoint[uvp,skel3D[uvp]],
 \t\tSphericalRegion->True
 \t],
 \t{a,Pi/11,Pi,Pi/18}
 ]\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.483333],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.65684 .64913 m .68009 .53652 L .56256 .57912 L closepath p .334 .121 .435 r
F P
0 g
s
.64695 .41988 m .68009 .53652 L .56256 .57912 L closepath p .434 .359 .673 r
F P
0 g
s
.42318 .44701 m .53835 .42212 L .56256 .57912 L closepath p .713 .619 .75 r
F P
0 g
s
.53835 .42212 m .56256 .57912 L .64695 .41988 L closepath p .561 .511 .757 r
F P
0 g
s
.40674 .56343 m .42318 .44701 L .56256 .57912 L closepath p .774 .613 .68 r
F P
0 g
s
.41824 .66762 m .40674 .56343 L .56256 .57912 L closepath p .765 .483 .507 r
F P
0 g
s
.54135 .68857 m .65684 .64913 L .56256 .57912 L closepath p .417 .094 .308 r
F P
0 g
s
.54135 .68857 m .41824 .66762 L .56256 .57912 L closepath p .66 .311 .37 r
F P
0 g
s
.5 .27523 m .53835 .42212 L .42318 .44701 L closepath p .721 .705 .835 r
F P
0 g
s
.26321 .52582 m .40674 .56343 L .42318 .44701 L closepath p .861 .697 .677 r
F P
0 g
s
.36084 .38051 m .26321 .52582 L .42318 .44701 L closepath p .888 .809 .765 r
F P
0 g
s
.36084 .38051 m .5 .27523 L .42318 .44701 L closepath p .806 .811 .855 r
F P
0 g
s
.5 .27523 m .53835 .42212 L .64695 .41988 L closepath p .547 .593 .851 r
F P
0 g
s
.40674 .56343 m .26321 .52582 L .41824 .66762 L closepath p .863 .558 .47 r
F P
0 g
s
.76097 .47154 m .68009 .53652 L .64695 .41988 L closepath p .175 .194 .64 r
F P
0 g
s
.64718 .34153 m .5 .27523 L .64695 .41988 L closepath p .342 .523 .889 r
F P
0 g
s
.64718 .34153 m .76097 .47154 L .64695 .41988 L closepath p .061 .255 .748 r
F P
0 g
s
.5 .75807 m .34918 .66239 L .41824 .66762 L closepath p .626 .065 0 r
F P
0 g
s
.26321 .52582 m .34918 .66239 L .41824 .66762 L closepath p .862 .427 .174 r
F P
0 g
s
.54135 .68857 m .5 .75807 L .41824 .66762 L closepath p .566 .066 .028 r
F P
0 g
s
.26321 .52582 m .36084 .38051 L .33546 .34355 L closepath p .918 .978 .732 r
F P
0 g
s
.36084 .38051 m .33546 .34355 L .5 .27523 L closepath p .79 .986 .894 r
F P
0 g
s
.68009 .53652 m .65684 .64913 L .76097 .47154 L closepath p 0 0 .253 r
F P
0 g
s
.5 .27523 m .45357 .28826 L .33546 .34355 L closepath p .361 .819 .715 r
F P
0 g
s
.64718 .34153 m .59455 .30616 L .5 .27523 L closepath p 0 .362 .749 r
F P
0 g
s
.59455 .30616 m .45357 .28826 L .5 .27523 L closepath p .255 0 0 r
F P
0 g
s
.54135 .68857 m .5 .75807 L .65684 .64913 L closepath p .15 0 0 r
F P
0 g
s
.32295 .59653 m .34918 .66239 L .26321 .52582 L closepath p 0 0 .487 r
F P
0 g
s
.29275 .45797 m .33546 .34355 L .26321 .52582 L closepath p 0 0 0 r
F P
0 g
s
.29275 .45797 m .32295 .59653 L .26321 .52582 L closepath p 0 0 .455 r
F P
0 g
s
.76097 .47154 m .66028 .63762 L .65684 .64913 L closepath p .644 .823 .403 r
F P
0 g
s
.5 .75807 m .66028 .63762 L .65684 .64913 L closepath p .514 .877 .654 r
F P
0 g
s
.64718 .34153 m .59455 .30616 L .76097 .47154 L closepath p .671 .159 0 r
F P
0 g
s
.32295 .59653 m .34918 .66239 L .5 .75807 L closepath p .029 .388 .849 r
F P
0 g
s
.41264 .38951 m .45357 .28826 L .33546 .34355 L closepath p .168 0 .005 r
F P
0 g
s
.29275 .45797 m .41264 .38951 L .33546 .34355 L closepath p .057 0 .209 r
F P
0 g
s
.76097 .47154 m .62074 .41788 L .60215 .57046 L closepath p .912 .736 .65 r
F P
0 g
s
.76097 .47154 m .62074 .41788 L .59455 .30616 L closepath p .89 .508 .307 r
F P
0 g
s
.66028 .63762 m .76097 .47154 L .60215 .57046 L closepath p .937 .888 .758 r
F P
0 g
s
.45357 .28826 m .41264 .38951 L .59455 .30616 L closepath p .588 .142 .159 r
F P
0 g
s
.60215 .57046 m .66028 .63762 L .5 .75807 L closepath p .822 .894 .893 r
F P
0 g
s
.4491 .60337 m .5 .75807 L .32295 .59653 L closepath p .452 .58 .891 r
F P
0 g
s
.4491 .60337 m .60215 .57046 L .5 .75807 L closepath p .717 .749 .877 r
F P
0 g
s
.32295 .59653 m .29275 .45797 L .41264 .38951 L closepath p .28 .235 .628 r
F P
0 g
s
.59455 .30616 m .62074 .41788 L .41264 .38951 L closepath p .772 .428 .404 r
F P
0 g
s
.4491 .60337 m .41264 .38951 L .32295 .59653 L closepath p .493 .477 .768 r
F P
0 g
s
.60215 .57046 m .62074 .41788 L .41264 .38951 L closepath p .797 .625 .668 r
F P
0 g
s
.4491 .60337 m .60215 .57046 L .41264 .38951 L closepath p .715 .633 .765 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016R000`400?l00000o`00003ooooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00R_ooool5o`0008_ooooo0025ooooo`Go00001@11
0003o`0008Sooooo0021ooooo`Co00003@110003o`0008Gooooo001nooooo`Go00004P110003o`00
08;ooooo001looooo`;o000000<0:`01o`00002F92P00P2F92P7o`0000h0@@000ol0001oooooo`00
N_ooool2o`000080:`0100?o000009HT:02F92P02@2F92P7o`0000X0@@000ol0001looooo`00N?oo
ool2o`0000@0:`0100?o000009HT:02F92P0402F92P6o`0000L0@@000ol0001iooooo`00M_ooool2
o`0000H0:`0100?o000009HT:02F92P05P2F92P7o`0000<0@@000ol0001fooooo`00M?ooool2o`00
00L0:`0100?o000009HT:02F92P07P2F92P9o`0007?ooooo001booooo`;o00002@0[00400ol00000
UR@X09HT:00U09HT:0Co0000LOooool0073ooooo0_l0000:02/00@03o`00002F92P0UR@X02D0UR@X
0_l000001035KFOo0000o`000?l0001`ooooo`00KOooool3o`0000`0:`0100?o000009HT:02F92P0
8P2F92P3o`0000<0aFeW00?o00000>>2C_l000000_l0001^ooooo`00Joooool2o`0000h0:`0100?o
000009HT:02F92P08@2F92P2o`0000L0aFeW00Go00000>>2C_l00000ZbP0o`00001]ooooo`00JOoo
ool2o`000100:`0100?o000009HT:02F92P07`2F92P2o`0000T0aFeW00Go00000>>2CP3SPTko0000
0:/X0002o`0006_ooooo001Wooooo`;o00004P0[00400ol00000UR@X09HT:00M09HT:0;o00002`35
KFL01Ol00000hh9>0>>2CP3SPTko00000080ZbP00_l0001Yooooo`00IOooool2o`0001<0:`0100?o
000009HT:02F92P06`2F92P3o`0000d0aFeW00?o00000>>2CP3SPTh00P3SPTh01Ol00000ZbP00:/X
002[:03o000006Sooooo001Sooooo`;o00005@0[00400ol00000UR@X09HT:00I09HT:0;o00004035
KFL00ol00000hh9>0>>2CP030>>2CP04o`00002[:000ZbP00:/X00;o0000I_ooool0067ooooo0_l0
000F02/00@03o`00002F92P0UR@X01P0UR@X0_l0000C0<E]I`03o`00003SPTh0hh9>00<0hh9>00?o
00000:/X002[:0000P2[:0000ol0003oooooooooo`1Sooooo`00Goooool2o`0001P0:`0100?o0000
09HT:02F92P05P2F92P2o`0001D0aFeW00?o00000>>2CP3SPTh0103SPTh00ol00000ZbP00:/X0002
0:/X0003o`000?oooooooooo06;ooooo001Nooooo`;o00006@0[00400ol00000UR@X09HT:00C09HT
:0?o00005`35KFL00ol00000hh9>0>>2CP050>>2CP05o`00002[:000ZbP00:/X0?l00000I?ooool0
05kooooo00?o000000h0=Ol000005`0[00400ol00000UR@X09HT:00B09HT:0;o00006P35KFL00ol0
0000hh9>0>>2CP060>>2CP05o`00002[:000ZbP00:/X0?l00000Hoooool005gooooo00Co000000h0
=@0>03D03P0e0_l0000E02/00@03o`00002F92P0UR@X0100UR@X0_l0000M0<E]I`03o`00003SPTh0
hh9>00H0hh9>00Go00000:/X002[:000ZbP0o`00001Rooooo`00GOooool00ol000003P0e00h0=@03
00h0=@;o00004P0[00400ol00000UR@X09HT:00>09HT:0?o00007`35KFL00ol00000hh9>0>>2CP07
0>>2CP05o`00002[:000ZbP00:/X0?l00000HOooool005gooooo00?o000000h0=@0>03D01@0>03D0
0ol00000:`0102/00@0?02/00@03o`00002F92P0UR@X00`0UR@X0_l0000R0<E]I`03o`00003SPTh0
hh9>00P0hh9>00Go00000:/X002[:000ZbP0o`00001Pooooo`00G?ooool00ol000003P0e00h0=@07
00h0=@;o00003`0[00400ol00000UR@X09HT:00:09HT:0;o00009035KFL00ol00000hh9>0>>2CP09
0>>2CP05o`00002[:000ZbP00:/X0?l00000Goooool005cooooo00?o000000h0=@0>03D02@0>03D2
o`0000`0:`0100?o000009HT:02F92P02@2F92P2o`0002L0aFeW00?o00000>>2CP3SPTh02@3SPTh0
1Ol00000ZbP00:/X002[:03o000005kooooo001Kooooo`;o00003@0>03D00ol00000:`0102/00@09
02/00@03o`00002F92P0UR@X00H0UR@X0ol0000Y0<E]I`03o`00003SPTh0hh9>00X0hh9>00Co0000
0:/X002[:03o0000G_ooool005_ooooo00?o000000h0=@0>03D03@0>03D2o`0000P0:`0100?o0000
09HT:02F92P01@2F92P2o`0002`0aFeW00?o00000>>2CP3SPTh02`3SPTh01?l00000ZbP00:/X0?l0
001Mooooo`00F_ooool2o`0001403P0e00?o000002/00@0[00401@0[00400ol00000UR@X09HT:003
09HT:0;o0000;P35KFL00ol00000hh9>0>>2CP0<0>>2CP04o`00002[:000ZbP0o`0005cooooo001J
ooooo`03o`00000>03D03P0e01403P0e0_l0000402/00@03o`00002F92P0UR@X0080UR@X0_l0000`
0<E]I`03o`00003SPTh0hh9>00d0hh9>00Co00000:/X002[:03o0000Foooool005[ooooo00?o0000
00h0=@0>03D04`0>03D2o`000080:`0100?o000009HT:?l000000_l0000c0<E]I`03o`00003SPTh0
hh9>00d0hh9>00Co00000:/X002[:03o0000F_ooool005Wooooo0_l0000G00h0=@04o`00000[007o
0000o`0003H0aFeW00?o00000>>2CP3SPTh03P3SPTh01?l00000ZbP00:/X0?l0001Iooooo`00FOoo
ool00ol000003P0e00h0=@0F00h0=@Ko0000=035KFL00ol00000hh9>0>>2CP0?0>>2CP04o`00002[
:000ZbP0o`0005Sooooo001Hooooo`;o00005P0>03D2o`00000404LlX?l00000]j;3o`000080c9n[
1ol0000]0<E]I`03o`00003SPTh0hh9>0100hh9>00Co00000:/X002[:03o0000Eoooool005Sooooo
0_l0000E00h0=@03o`000017?:00AcbP00;o00000P2gX/<00ol00000c9n[0<bOZ`060<bOZ`Oo0000
9`35KFL00ol00000hh9>0>>2CP0@0>>2CP03o`00002[:03o000005Oooooo001Hooooo`03o`00000>
03D03P0e01803P0e0_l0000304LlX0;o00000`2gX/<00ol00000c9n[0<bOZ`0<0<bOZ`So00007`35
KFL00ol00000hh9>0>>2CP0A0>>2CP03o`00002[:03o000005Kooooo001Gooooo`;o00004P0>03D2
o`0000@0AcbP00Co000007ija01nN/Co00000`2gX/<00ol00000c9n[0<bOZ`0C0<bOZ`Oo00006035
KFL00ol00000hh9>0>>2CP0B0>>2CP03o`00002[:03o000005Gooooo001Gooooo`03o`00000>03D0
3P0e00l03P0e0_l0000604LlX004o`00001nN/@0OW[4o`0000@0]j;300?o00000<bOZ`3<Wj/06@3<
Wj/8o`000100aFeW00?o00000>>2CP3SPTh04`3SPTh00ol00000ZbP0o`00001Dooooo`00E_ooool2
o`0001003P0e00?o000004LlX017?:001P17?:001?l00000OW[407ija?l000050;NR``03o`00003<
Wj/0c9n[0200c9n[1ol000090<E]I`03o`00003SPTh0hh9>01@0hh9>00?o00000:/X0?l00000Dooo
ool005Kooooo0_l0000>00h0=@;o00002017?:001Ol00000OW[407ija01nN/Co000000H0]j;300?o
00000<bOZ`3<Wj/09P3<Wj/7o`0000<0aFeW00?o00000>>2CP3SPTh0503SPTh00ol00000ZbP0o`00
001Booooo`00E_ooool00ol000003P0e00h0=@0;00h0=@;o00002P17?:001Ol00000OW[407ija01n
N/Co000000L0]j;300?o00000<bOZ`3<Wj/0;03<Wj/5o`0001H0hh9>00?o00000:/X0?l00000DOoo
ool005Gooooo0_l0000;00h0=@;o00002`17?:000ol00000OW[407ija00307ija003o`00002gX/<0
]j;300D0]j;300?o00000<bOZ`3<Wj/0;P3<Wj/00ol00000jKbVo`000002o`0001@0hh9>0_l0001A
ooooo`00EOooool2o`0000X03P0e00?o000004LlX017?:002`17?:000ol00000OW[407ija00307ij
a003o`00002gX/<0]j;300H0]j;300?o00000<bOZ`3<Wj/0;@3<Wj/00ol00000jKbV0>VlYP020>Vl
YP?o00004P3SPTh2o`00053ooooo001Dooooo`;o00002@0>03D2o`0000d0AcbP00?o000007ija01n
N/@0101nN/@00ol00000]j;30;NR``070;NR``03o`00003<Wj/0c9n[02`0c9n[00?o00000>VlYP3Y
_:H01@3Y_:H2o`000140hh9>0_l0001?ooooo`00E?ooool2o`0000L03P0e0_l0000?04LlX003o`00
001nN/@0OW[400@0OW[400?o00000;NR``2gX/<0202gX/<00ol00000c9n[0<bOZ`0[0<bOZ`03o`00
003Y_:H0jKbV00L0jKbV0ol0000?0>>2CP;o0000C_ooool005?ooooo0_l0000700h0=@03o`000017
?:00AcbP00l0AcbP00?o000007ija01nN/@0101nN/@00ol00000]j;30;NR``090;NR``03o`00003<
Wj/0c9n[02T0c9n[00?o00000>VlYP3Y_:H02`3Y_:H2o`0000h0hh9>0_l0001=ooooo`00Doooool2
o`0000D03P0e0_l0000A04LlX003o`00001nN/@0OW[400D0OW[400?o00000;NR``2gX/<02P2gX/<0
0ol00000c9n[0<bOZ`0X0<bOZ`03o`00003Y_:H0jKbV00d0jKbV0ol0000<0>>2CP;o0000C?ooool0
05?ooooo0_l0000300h0=@;o00004`17?:000ol00000OW[407ija00607ija003o`00002gX/<0]j;3
00X0]j;300?o00000<bOZ`3<Wj/09`3<Wj/00ol00000jKbV0>VlYP0@0>VlYP?o00002P3SPTh2o`00
04_ooooo001Booooo`;o00000P0>03D2o`0001@0AcbP00?o000007ija01nN/@01`1nN/@00ol00000
]j;30;NR``0;0;NR``03o`00003<Wj/0c9n[02H0c9n[00?o00000>VlYP3Y_:H04`3Y_:H2o`0000T0
hh9>0_l0001:ooooo`00D_ooool2o`00000300h0=Ol00000AcbP01D0AcbP00?o000007ija01nN/@0
1`1nN/@00ol00000]j;30;NR``0<0;NR``;o00009P3<Wj/00ol00000jKbV0>VlYP0E0>VlYP?o0000
1`3SPTh00ol0003oooooooooo`18ooooo`00DOooool01?l000000000o`000?l0000F04LlX003o`00
001nN/@0OW[400P0OW[400?o00000;NR``2gX/<03P2gX/<00ol00000c9n[0<bOZ`0S0<bOZ`03o`00
003Y_:H0jKbV01P0jKbV0_l000060>>2CP03o`000?oooooooooo04Oooooo001Aooooo`;o00006017
?:000ol00000OW[407ija00807ija003o`00002gX/<0]j;300l0]j;300?o00000<bOZ`3<Wj/08P3<
Wj/00ol00000jKbV0>VlYP0J0>VlYP?o0000103SPTh00ol0003oooooooooo`16ooooo`00DOooool2
o`0001P0AcbP00?o000007ija01nN/@02@1nN/@00ol00000]j;30;NR``0?0;NR``03o`00003<Wj/0
c9n[0240c9n[00?o00000>VlYP3Y_:H07@3Y_:H3o`000080hh9>00?o0000ooooooooool0AOooool0
053ooooo0ol0000G04LlX003o`00001nN/@0OW[400X0OW[400?o00000;NR``2gX/<0402gX/<00ol0
0000c9n[0<bOZ`0P0<bOZ`03o`00003Y_:H0jKbV0200jKbV0_l000000`3SPTko0000ooooo`15oooo
o`00D?ooool2o`0000030000M?l00000AcbP01D0AcbP00?o000007ija01nN/@02P1nN/@00ol00000
]j;30;NR``0A0;NR``03o`00003<Wj/0c9n[01h0c9n[00?o00000>VlYP3Y_:H08`3Y_:H3o`0004Go
oooo001?ooooo`;o00000P0007@00ol00000AcbP04LlX00C04LlX003o`00001nN/@0OW[400/0OW[4
00?o00000;NR``2gX/<04P2gX/<00ol00000c9n[0<bOZ`0M0<bOZ`03o`00003Y_:H0jKbV02D0jKbV
0_l00014ooooo`00Coooool2o`000080001d00?o000004LlX017?:004`17?:000ol00000OW[407ij
a00;07ija003o`00002gX/<0]j;301<0]j;300?o00000<bOZ`3<Wj/0703<Wj/00ol00000jKbV0>Vl
YP0T0>VlYP03o`00003_hl;o000004Cooooo001?ooooo`05o`00000007@0001d0000M?l000005017
?:000ol00000OW[407ija00<07ija003o`00002gX/<0]j;301@0]j;300?o00000<bOZ`3<Wj/06`3<
Wj/00ol00000jKbV0>VlYP0R0>VlYP;o000000<0kn?2o`000?ooool0A?ooool004kooooo0_l00003
0000M003o`000017?:00AcbP0180AcbP00?o000007ija01nN/@03@1nN/@00ol00000]j;30;NR``0D
0;NR``03o`00003<Wj/0c9n[01X0c9n[00?o00000>VlYP3Y_:H0803Y_:H2o`0000<0kn?200?o0000
ooooooooool0@oooool004kooooo00?o00000000M00007@00`0007@00ol00000AcbP04LlX00A04Ll
X003o`00001nN/@0OW[400d0OW[400?o00000;NR``2gX/<05@2gX/<00ol00000c9n[0<bOZ`0I0<bO
Z`03o`00003Y_:H0jKbV01l0jKbV00?o00000>oS`P3_hl800P3_hl800ol0003oooooooooo`14oooo
o`00COooool2o`0000D0001d00?o000004LlX017?:004017?:000ol00000OW[407ija00>07ija003
o`00002gX/<0]j;301H0]j;300?o00000<bOZ`3<Wj/0603<Wj/00ol00000jKbV0>VlYP0M0>VlYP;o
0000103_hl800ol0003oooooooooo`15ooooo`00COooool00ol00000001d0000M0040000M003o`00
0017?:00AcbP0100AcbP00?o000007ija01nN/@03P1nN/@00ol00000]j;30;NR``0G0;NR``03o`00
003<Wj/0c9n[01L0c9n[00?o00000>VlYP3Y_:H0703Y_:H00ol00000kn?20>oS`P040>oS`P03o`00
0?oooooooooo04Gooooo001<ooooo`;o00001P0007@00ol00000AcbP04LlX00?04LlX003o`00001n
N/@0OW[400l0OW[400?o00000;NR``2gX/<0602gX/<00ol00000c9n[0<bOZ`0E0<bOZ`03o`00003Y
_:H0jKbV01/0jKbV0_l000060>oS`P03o`000?oooooooooo04Kooooo001<ooooo`;o00001P0007@0
0ol00000AcbP04LlX00?04LlX003o`00001nN/@0OW[40100OW[400?o00000;NR``2gX/<0602gX/<0
0ol00000c9n[0<bOZ`0D0<bOZ`03o`00003Y_:H0jKbV01X0jKbV00?o00000>oS`P3_hl801P3_hl80
0ol0003oooooooooo`16ooooo`00C?ooool00ol00000001d0000M0060000M003o`000017?:00AcbP
00d0AcbP00?o000007ija01nN/@04@1nN/@00ol00000]j;30;NR``0I0;NR``03o`00003<Wj/0c9n[
01<0c9n[00?o00000>VlYP3Y_:H0603Y_:H2o`0000P0kn?200?o0000ooooooooool0Aoooool004_o
oooo0_l000080000M003o`000017?:00AcbP00d0AcbP00?o000007ija01nN/@04@1nN/@00ol00000
]j;30;NR``0J0;NR``03o`00003<Wj/0c9n[0180c9n[00?o00000>VlYP3Y_:H05P3Y_:H2o`0000T0
kn?200?o0000ooooooooool0B?ooool004_ooooo00?o00000000M00007@01`0007@00ol00000AcbP
04LlX00=04LlX003o`00001nN/@0OW[40140OW[400?o00000;NR``2gX/<06`2gX/<2o`000180c9n[
00?o00000>VlYP3Y_:H05@3Y_:H00ol00000kn?20>oS`P090>oS`P03o`000?oooooooooo04Sooooo
001:ooooo`;o00002@0007@00ol00000AcbP04LlX00<04LlX003o`00001nN/@0OW[40180OW[400?o
00000;NR``2gX/<07@2gX/<00ol00000c9n[0<bOZ`0?0<bOZ`03o`00003Y_:H0jKbV01<0jKbV0_l0
000;0>oS`P03o`000?oooooooooo04Wooooo001:ooooo`03o`00000007@0001d00P0001d00?o0000
04LlX017?:003017?:000ol00000OW[407ija00C07ija003o`00002gX/<0]j;301d0]j;300?o0000
0<bOZ`3<Wj/03P3<Wj/00ol00000jKbV0>VlYP0B0>VlYP03o`00003_hl80kn?200/0kn?200?o0000
ooooooooool0BOooool004[ooooo00?o00000000M00007@02@0007@00ol00000AcbP04LlX00:04Ll
X003o`00001nN/@0OW[401@0OW[400?o00000;NR``2gX/<07P2gX/<00ol00000c9n[0<bOZ`0=0<bO
Z`03o`00003Y_:H0jKbV0100jKbV0_l0000=0>oS`P03o`000?oooooooooo04[ooooo0019ooooo`03
o`00000007@0001d00X0001d00?o000004LlX017?:002P17?:000ol00000OW[407ija00D07ija003
o`00002gX/<0]j;301l0]j;300?o00000<bOZ`3<Wj/0303<Wj/00ol00000jKbV0>VlYP0?0>VlYP03
o`00003_hl80kn?200`0kn?20_l0001<ooooo`00BOooool00ol00000001d0000M00:0000M003o`00
0017?:00AcbP00T0AcbP00?o000007ija01nN/@05@1nN/@00ol00000]j;30;NR``0P0;NR``03o`00
003<Wj/0c9n[00X0c9n[00?o00000>VlYP3Y_:H03P3Y_:H2o`0000l0kn?200?o0000ooooooooool0
Boooool004[ooooo00?o00000000M00007@02@0007@00ol00000AcbP04LlX00904LlX003o`00001n
N/@0OW[401D0OW[400?o00000;NR``2gX/<08@2gX/<00ol00000c9n[0<bOZ`090<bOZ`03o`00003Y
_:H0jKbV00`0jKbV0_l0000@0>oS`P03o`000?oooooooooo04cooooo001;ooooo`03o`00000007@0
001d00P0001d00?o000004LlX017?:002@17?:000ol00000OW[407ija00E07ija003o`00002gX/<0
]j;30280]j;300?o00000<bOZ`3<Wj/0203<Wj/00ol00000jKbV0>VlYP0;0>VlYP03o`00003_hl80
kn?20100kn?200?o0000ooooooooool0C?ooool004_ooooo0_l0000:0000M003o`000017?:00AcbP
00L0AcbP00?o000007ija01nN/@05`1nN/@00ol00000]j;30;NR``0R0;NR``03o`00003<Wj/0c9n[
00L0c9n[00?o00000>VlYP3Y_:H02@3Y_:H2o`000180kn?200?o0000ooooooooool0COooool004co
oooo0_l000090000M003o`000017?:00AcbP00L0AcbP00?o000007ija01nN/@05`1nN/@00ol00000
]j;30;NR``0S0;NR``03o`00003<Wj/0c9n[00H0c9n[00?o00000>VlYP3Y_:H0203Y_:H00ol00000
kn?20>oS`P0A0>oS`P;o0000Coooool004gooooo0_l000080000M003o`000017?:00AcbP00H0AcbP
00?o000007ija01nN/@0601nN/@00ol00000]j;30;NR``0T0;NR``03o`00003<Wj/0c9n[00D0c9n[
00?o00000>VlYP3Y_:H01P3Y_:H2o`0001@0kn?200?o0000ooooooooool0C_ooool004gooooo00?o
00000000O?l000001`0007@00ol00000AcbP04LlX00604LlX003o`00001nN/@0OW[401P0OW[400?o
00000;NR``2gX/<09@2gX/<00ol00000c9n[0<bOZ`040<bOZ`03o`00003Y_:H0jKbV00D0jKbV00?o
00000>oS`P3_hl804`3_hl82o`00053ooooo001>ooooo`;o00001`0007@00ol00000AcbP04LlX005
04LlX003o`00001nN/@0OW[401T0OW[400?o00000;NR``2gX/<09P2gX/<00ol00000c9n[0<bOZ`03
0<bOZ`03o`00003Y_:H0jKbV00<0jKbV0_l0000F0>oS`P03o`000?oooooooooo04oooooo001>oooo
o`03o`00000007co000000L0001d00?o000004LlX017?:001017?:000ol00000OW[407ija00J07ij
a003o`00002gX/<0]j;302H0]j;300?o00000<bOZ`3<Wj/00P3<Wj/01?l00000jKbV0>VlYP3Y_:H2
o`0001L0kn?200?o0000ooooooooool0D?ooool004oooooo00?o00000000O?l000001P0007@00ol0
0000AcbP04LlX00404LlX003o`00001nN/@0OW[401X0OW[400?o00000;NR``2gX/<09`2gX/<01?l0
0000c9n[0<bOZol000030>VlYP03o`00003_hl80kn?201H0kn?20_l0001Booooo`00D?ooool00ol0
0000001lo`0000050000M003o`000017?:00AcbP00<0AcbP00?o000007ija01nN/@06`1nN/@00ol0
0000]j;30;NR``0X0;NR``04o`00003<Wj_o00000>VlYP;o00006@3_hl800ol0003oooooooooo`1A
ooooo`00D?ooool01?l00000001l0000O?l000040000M003o`000017?:00AcbP00<0AcbP00?o0000
07ija01nN/@06`1nN/@00ol00000]j;30;NR``0Y0;NR``?o00006P3_hl82o`0005?ooooo001Aoooo
o`04o`00000007`0001lo`0000<0001d00?o000004LlX017?:000P17?:000ol00000OW[407ija00L
07ija003o`00002gX/<0]j;302P0]j;30ol0000K0>oS`P03o`000?oooooooooo05;ooooo001Boooo
o`03o`00000007co000000@0001d00Go000004LlX017?:00AcbPo`00000N07ija003o`00002gX/<0
]j;302<0]j;31Ol000020;Noh003o`00003_hl80kn?201P0kn?200?o0000ooooooooool0Doooool0
05;ooooo00Co00000000O00007co00000`0007@01?l00000AcbP04LlX?l0000P07ija003o`00002g
X/<0]j;301d0]j;31Ol000060;Noh003o`00003Bi>Co000001P0kn?20_l0001Eooooo`00Doooool0
1?l00000001l0000O?l000020000M004o`000017?:00AcbPo`000200OW[400?o00000;NR``2gX/<0
602gX/<5o`0000/0]koP00Co00000=;Ti03Bi>Co00005`3_hl800ol0003oooooooooo`1Dooooo`00
E?ooool01_l00000001l0000O?l00000001do`000080AcbP00?o000007ija01nN/@07P1nN/@00ol0
0000]j;30;NR``0C0;NR``Go00003`2g_n000ol00000d^CT0=;Ti0020=;Ti003o`00003_hl80kn?2
01<0kn?20_l0001Fooooo`00E?ooool01?l00000001l0000O00007`2o`00000304LlX?l00000OW[4
0200OW[400?o00000;NR``2gX/<03`2gX/<4o`0001@0]koP00?o00000=;Ti03Bi>@00`3Bi>@00ol0
0000kn?20>oS`P0B0>oS`P03o`000?oooooooooo05Gooooo001Eooooo`04o`00000007`0001l0000
O0?o00008@1nN/@00ol00000]j;30;NR``0:0;NR``Go00005`2g_n000ol00000d^CT0=;Ti0050=;T
i003o`00003_hl80kn?20100kn?20_l0001Gooooo`00E_ooool01?l00000001l0000O00007`:o`00
01X0OW[400?o00000;NR``2gX/<0102gX/<5o`0001/0]koP00?o00000=;Ti03Bi>@01P3Bi>@00ol0
0000kn?20>oS`P0?0>oS`P;o0000F?ooool005Kooooo00Oo00000000O00007`0001lo`000007HmWo
000000L0LiCT4_l0000807ija003o`00002gX/?o000000Co0000802g_n000ol00000d^CT0=;Ti007
0=;Ti003o`00003_hl80kn?200h0kn?200?o0000ooooooooool0Eoooool005Oooooo00Oo00000000
O00007`0001lo`000007HmWo000001P0LiCT2_l0000T0;Noh003o`00003Bi>@0d^CT00T0d^CT00?o
00000>oS`P3_hl80303_hl82o`0005Wooooo001Gooooo`05o`00000007`0001l0000O?l000000P07
HmT00ol00000LiCT07>Di00M07>Di003o`00002g_n00]koP02<0]koP00?o00000=;Ti03Bi>@02P3B
i>@00ol00000kn?20>oS`P0;0>oS`P03o`000?oooooooooo05Sooooo001Hooooo`04o`00000007`0
001lo`0000<01f?I00?o000007>Di01cU>@0701cU>@00ol00000]koP0;Noh00R0;Noh003o`00003B
i>@0d^CT00`0d^CT00?o00000>oS`P3_hl802@3_hl82o`0005[ooooo001Iooooo`04o`00000007`0
001lo`0000<01f?I00?o000007>Di01cU>@0701cU>@00ol00000]koP0;Noh00Q0;Noh003o`00003B
i>@0d^CT00d0d^CT00?o00000>oS`P3_hl801`3_hl82o`0005_ooooo001Iooooo`04o`00000007`0
001lo`0000@01f?I00?o000007>Di01cU>@06`1cU>@00ol00000]koP0;Noh00P0;Noh003o`00003B
i>@0d^CT00l0d^CT00?o00000>oS`P3_hl801P3_hl82o`0005_ooooo001Jooooo`04o`00000007`0
001lo`0000@01f?I00?o000007>Di01cU>@06P1cU>@00ol00000]koP0;Noh00P0;Noh003o`00003B
i>@0d^CT00l0d^CT00?o00000>oS`P3_hl801@3_hl82o`0005cooooo001Kooooo`03o`00000007co
000000D01f?I00?o000007>Di01cU>@06P1cU>@00ol00000]koP0;Noh00N0;Noh003o`00003Bi>@0
d^CT0140d^CT00?o00000>oS`P3_hl80103_hl800ol0003oooooooooo`1Kooooo`00Foooool01?l0
0000001l0000O?l0000500MSf@03o`00001cU>@0LiCT01T0LiCT00?o00000;Noh02g_n007P2g_n00
0ol00000d^CT0=;Ti00B0=;Ti003o`00003_hl80kn?20080kn?20_l0001Mooooo`00G?ooool00ol0
0000001lo`00000600MSf@03o`00001cU>@0LiCT01P0LiCT00?o00000;Noh02g_n007@2g_n000ol0
0000d^CT0=;Ti00D0=;Ti003o`00003_hl80kn?200;o0000G_ooool005gooooo0_l0000700MSf@;o
00006@1cU>@00ol00000]koP0;Noh00K0;Noh003o`00003Bi>@0d^CT01H0d^CT00Co00000>oS`_l0
003o0000G_ooool005gooooo00?o00000000O?l000002007HmT00ol00000LiCT07>Di00F07>Di003
o`00002g_n00]koP01/0]koP00?o00000=;Ti03Bi>@05P3Bi>@3o`0005oooooo001Nooooo`;o0000
2@07HmT00ol00000LiCT07>Di00E07>Di003o`00002g_n00]koP01X0]koP00?o00000=;Ti03Bi>@0
5P3Bi>@00ol00000Pn2Wo`00001Pooooo`00G_ooool00ol00000001lo`00000900MSf@03o`00001c
U>@0LiCT01D0LiCT00?o00000;Noh02g_n006@2g_n000ol00000d^CT0=;Ti00E0=;Ti004o`000023
h:Oo0000o`00063ooooo001Oooooo`;o00002P07HmT00ol00000LiCT07>Di00D07>Di003o`00002g
_n00]koP01P0]koP00?o00000=;Ti03Bi>@0503Bi>@2o`00000308?PYol0003o0000067ooooo001P
ooooo`;o00002P07HmT00ol00000LiCT07>Di00C07>Di003o`00002g_n00]koP01P0]koP00?o0000
0=;Ti03Bi>@04`3Bi>@01?l00000Pn2W08?PYol0001Sooooo`00H?ooool2o`0000/01f?I00?o0000
07>Di01cU>@04`1cU>@00ol00000]koP0;Noh00F0;Noh003o`00003Bi>@0d^CT01<0d^CT00Co0000
08?PYol0003o0000I?ooool0067ooooo00?o000000MSf@07HmT02P07HmT00ol00000LiCT07>Di00B
07>Di003o`00002g_n00]koP01H0]koP00?o00000=;Ti03Bi>@04@3Bi>@2o`00000308?PYol0003o
oooo06Gooooo001Rooooo`;o00002`07HmT00ol00000LiCT07>Di00A07>Di003o`00002g_n00]koP
01D0]koP00?o00000=;Ti03Bi>@04@3Bi>@01?l00000Pn2W08?PYol0001Wooooo`00I?ooool00ol0
00001f?I00MSf@0900MSf@03o`00001cU>@0LiCT0140LiCT00?o00000;Noh02g_n004`2g_n000ol0
0000d^CT0=;Ti00A0=;Ti004o`000023h:Oo0000o`0006Sooooo001Uooooo`;o00002P07HmT00ol0
0000LiCT07>Di00@07>Di003o`00002g_n00]koP01<0]koP00?o00000=;Ti03Bi>@03`3Bi>@2o`00
000308?PYol0003ooooo06Wooooo001Wooooo`03o`000007HmT01f?I00P01f?I00?o000007>Di01c
U>@03`1cU>@00ol00000]koP0;Noh00B0;Noh003o`00003Bi>@0d^CT00l0d^CT00Co000008?PYol0
003o0000Joooool006Sooooo0_l0000900MSf@;o0000401cU>@00ol00000]koP0;Noh00A0;Noh003
o`00003Bi>@0d^CT00h0d^CT00?o000008?PYol00000KOooool006[ooooo0_l0000900MSf@03o`00
001cU>@0LiCT00d0LiCT00?o00000;Noh02g_n00402g_n000ol00000d^CT0=;Ti00=0=;Ti0;o0000
00<0Pn2Wo`000?ooool0KOooool006cooooo00?o000000MSf@07HmT01`07HmT00ol00000LiCT07>D
i00<07>Di003o`00002g_n00]koP0100]koP00?o00000=;Ti03Bi>@0303Bi>@01?l00000Pn2Wo`00
0?l0001_ooooo`00KOooool2o`0000P01f?I00?o000007>Di01cU>@02`1cU>@00ol00000]koP0;No
h00?0;Noh003o`00003Bi>@0d^CT00`0d^CT00?o000008?PYol00000LOooool006oooooo00?o0000
00MSf@07HmT01P07HmT00ol00000LiCT07>Di00;07>Di003o`00002g_n00]koP00h0]koP00?o0000
0=;Ti03Bi>@02P3Bi>@4o`0007;ooooo001`ooooo`;o00001`07HmT00ol00000LiCT07>Di00:07>D
i003o`00002g_n00]koP00d0]koP00?o00000=;Ti03Bi>@02P3Bi>@00ol00000Pn2Wo`00001doooo
o`00L_ooool00ol000001f?I00MSf@0500MSf@03o`00001cU>@0LiCT00T0LiCT00?o00000;Noh02g
_n003@2g_n000ol00000d^CT0=;Ti0090=;Ti0?o0000MOooool007?ooooo0_l0000600MSf@03o`00
001cU>@0LiCT00T0LiCT00?o00000;Noh02g_n002`2g_n000ol00000d^CT0=;Ti0090=;Ti0;o0000
Moooool007Gooooo00?o000000MSf@07HmT01007HmT00ol00000LiCT07>Di00807>Di003o`00002g
_n00]koP00X0]koP00?o00000=;Ti03Bi>@0203Bi>@3o`0007Sooooo001fooooo`;o00001@07HmT0
0ol00000LiCT07>Di00707>Di003o`00002g_n00]koP00X0]koP00?o00000=;Ti03Bi>@01`3Bi>@3
o`0007Wooooo001hooooo`;o00001007HmT00ol00000LiCT07>Di00707>Di003o`00002g_n00]koP
00P0]koP00?o00000=;Ti03Bi>@01`3Bi>@2o`0007_ooooo001jooooo`03o`000007HmT01f?I0080
1f?I0_l0000707>Di003o`00002g_n00]koP00P0]koP00?o00000=;Ti03Bi>@01@3Bi>@3o`0007co
oooo001kooooo`;o00001007HmT00ol00000LiCT07>Di00407>Di003o`00002g_n00]koP00L0]koP
00?o00000=;Ti03Bi>@01@3Bi>@2o`0007kooooo001mooooo`03o`000007HmT01f?I00801f?I00?o
000007>Di01cU>@0101cU>@00ol00000]koP0;Noh0060;Noh003o`00003Bi>@0d^CT00@0d^CT0_l0
001oooooo`00O_ooool2o`0000<01f?I00?o000007>Di01cU>@00`1cU>@00ol00000]koP0;Noh005
0;Noh003o`00003Bi>@0d^CT00<0d^CT0_l00021ooooo`00P?ooool01Ol000001f?I00MSf@07HmWo
000000@0LiCT00?o00000;Noh02g_n001@2g_n000ol00000d^CT0=;Ti0020=;Ti0;o0000P_ooool0
087ooooo0_l0000200MSf@03o`00001cU>@0LiCT0080LiCT00?o00000;Noh02g_n000`2g_n000ol0
0000d^CT0=;Ti0020=;Ti0;o0000Poooool008?ooooo00Co000000MSf@07HmWo00000`1cU>@00ol0
0000]koP0;Noh0030;Noh003o`00003Bi>@0d^CT00;o0000QOooool008Cooooo0_l000001@07HmWo
000007>Di01cU>Co000000@0]koP00?o00000=;Ti03Bi>@00_l00026ooooo`00Q_ooool3o`000080
LiCT00Co00000;Noh02g_n3o00000P3Bi>@00ol0003oooooooooo`26ooooo`00R?ooool2o`000004
07>Di?l00000]koP0;Noh0?o0000ROooool008Wooooo0ol00000102g_n3o0000o`000?l0002:oooo
o`00Roooool3o`0008cooooo002<ooooo`03o`000?oooooooooo08_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo0000\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-5.00005*^-6, -5.00005*^-6, \
0.00355875, 0.00355875}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.67262 .64122 m .69877 .5249 L .59954 .57459 L closepath p .196 .004 .378 r
F P
0 g
s
.66153 .40832 m .69877 .5249 L .59954 .57459 L closepath p .34 .298 .665 r
F P
0 g
s
.44915 .45153 m .5608 .41844 L .59954 .57459 L closepath p .677 .589 .75 r
F P
0 g
s
.5608 .41844 m .59954 .57459 L .66153 .40832 L closepath p .506 .478 .761 r
F P
0 g
s
.43837 .56787 m .44915 .45153 L .59954 .57459 L closepath p .736 .58 .68 r
F P
0 g
s
.44591 .6707 m .43837 .56787 L .59954 .57459 L closepath p .72 .448 .513 r
F P
0 g
s
.56558 .68627 m .67262 .64122 L .59954 .57459 L closepath p .311 0 .257 r
F P
0 g
s
.56558 .68627 m .44591 .6707 L .59954 .57459 L closepath p .607 .267 .368 r
F P
0 g
s
.5 .27523 m .5608 .41844 L .44915 .45153 L closepath p .693 .681 .834 r
F P
0 g
s
.28463 .53964 m .43837 .56787 L .44915 .45153 L closepath p .823 .658 .679 r
F P
0 g
s
.37205 .39097 m .28463 .53964 L .44915 .45153 L closepath p .856 .765 .761 r
F P
0 g
s
.37205 .39097 m .5 .27523 L .44915 .45153 L closepath p .785 .779 .847 r
F P
0 g
s
.43837 .56787 m .28463 .53964 L .44591 .6707 L closepath p .82 .525 .492 r
F P
0 g
s
.5 .27523 m .5608 .41844 L .66153 .40832 L closepath p .503 .574 .861 r
F P
0 g
s
.28463 .53964 m .37205 .39097 L .32583 .35751 L closepath p .941 .942 .761 r
F P
0 g
s
.37205 .39097 m .32583 .35751 L .5 .27523 L closepath p .826 .964 .896 r
F P
0 g
s
.5 .75807 m .36151 .669 L .44591 .6707 L closepath p .633 .089 0 r
F P
0 g
s
.28463 .53964 m .36151 .669 L .44591 .6707 L closepath p .839 .425 .254 r
F P
0 g
s
.56558 .68627 m .5 .75807 L .44591 .6707 L closepath p .519 .031 .037 r
F P
0 g
s
.31287 .60622 m .36151 .669 L .28463 .53964 L closepath p .693 .257 0 r
F P
0 g
s
.28173 .47266 m .32583 .35751 L .28463 .53964 L closepath p .869 .87 .426 r
F P
0 g
s
.28173 .47266 m .31287 .60622 L .28463 .53964 L closepath p 0 0 .262 r
F P
0 g
s
.75109 .45378 m .69877 .5249 L .66153 .40832 L closepath p 0 .075 .593 r
F P
0 g
s
.63975 .32946 m .5 .27523 L .66153 .40832 L closepath p .262 .501 .896 r
F P
0 g
s
.63975 .32946 m .75109 .45378 L .66153 .40832 L closepath p 0 .156 .697 r
F P
0 g
s
.5 .27523 m .42732 .29358 L .32583 .35751 L closepath p .52 .912 .793 r
F P
0 g
s
.63975 .32946 m .56363 .2992 L .5 .27523 L closepath p 0 .333 .666 r
F P
0 g
s
.56363 .2992 m .42732 .29358 L .5 .27523 L closepath p .197 0 0 r
F P
0 g
s
.56558 .68627 m .5 .75807 L .67262 .64122 L closepath p 0 0 0 r
F P
0 g
s
.69877 .5249 m .67262 .64122 L .75109 .45378 L closepath p 0 0 .082 r
F P
0 g
s
.31287 .60622 m .36151 .669 L .5 .75807 L closepath p 0 .299 .776 r
F P
0 g
s
.75109 .45378 m .65243 .6299 L .67262 .64122 L closepath p .849 .946 .586 r
F P
0 g
s
.5 .75807 m .65243 .6299 L .67262 .64122 L closepath p .671 .967 .773 r
F P
0 g
s
.36409 .39816 m .42732 .29358 L .32583 .35751 L closepath p 0 0 0 r
F P
0 g
s
.28173 .47266 m .36409 .39816 L .32583 .35751 L closepath p 0 0 .054 r
F P
0 g
s
.63975 .32946 m .56363 .2992 L .75109 .45378 L closepath p .742 .22 0 r
F P
0 g
s
.31287 .60622 m .28173 .47266 L .36409 .39816 L closepath p .098 .111 .583 r
F P
0 g
s
.42732 .29358 m .36409 .39816 L .56363 .2992 L closepath p .508 .075 .152 r
F P
0 g
s
.56879 .56558 m .65243 .6299 L .5 .75807 L closepath p .8 .851 .888 r
F P
0 g
s
.42038 .60681 m .5 .75807 L .31287 .60622 L closepath p .369 .542 .895 r
F P
0 g
s
.42038 .60681 m .56879 .56558 L .5 .75807 L closepath p .68 .716 .876 r
F P
0 g
s
.42038 .60681 m .36409 .39816 L .31287 .60622 L closepath p .402 .422 .766 r
F P
0 g
s
.75109 .45378 m .58146 .41029 L .56879 .56558 L closepath p .861 .685 .661 r
F P
0 g
s
.75109 .45378 m .58146 .41029 L .56363 .2992 L closepath p .842 .478 .364 r
F P
0 g
s
.65243 .6299 m .75109 .45378 L .56879 .56558 L closepath p .903 .832 .766 r
F P
0 g
s
.56363 .2992 m .58146 .41029 L .36409 .39816 L closepath p .712 .382 .418 r
F P
0 g
s
.42038 .60681 m .56879 .56558 L .36409 .39816 L closepath p .665 .593 .765 r
F P
0 g
s
.56879 .56558 m .58146 .41029 L .36409 .39816 L closepath p .745 .58 .67 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016R000`400?l00000o`00003ooooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00R_ooool4o`0008cooooo0026ooooo`Co0000100b
0003o`0008Wooooo0022ooooo`Co00002`0b0003o`0008Kooooo001nooooo`Co00004@0b0003o`00
08Cooooo001jooooo`Co0000600b0003o`00087ooooo001gooooo`co00005P0b0002o`0007oooooo
001fooooo`03o`000000003o000000X0PQ<V4ol00005038000?o0000O?ooool007Cooooo0_l00000
0`00003o0000088C9P0M088C9P_o0000NOooool007;ooooo0_l0000200000003o`0000224bH0PQ<V
0280PQ<V0_l000000`2fHF_o00000=MjG@03o`0007Oooooo001aooooo`03o`000000000000000080
000000?o0000088C9P224bH080224bH2o`0000<0]V5[00Go00000=MjG@3GNUgo00000;dh0003o`00
07Cooooo001_ooooo`;o0000100000000ol00000PQ<V088C9P0O088C9P;o00001@2fHF/01Ol00000
egYM0=MjG@3GNUgo000000<0_CP00_l0001booooo`00K_ooool00ol0000000000000000400000003
o`0000224bH0PQ<V01d0PQ<V0_l000080;IQJ`04o`00003GNUd0egYM0=MjG@;o00000`2m>003o`00
06oooooo001/ooooo`;o00001P0000000ol00000PQ<V088C9P0L088C9P;o00002P2fHF/00ol00000
egYM0=MjG@030=MjG@03o`00002m>000_CP000<0_CP00ol0001/ooooo`00J_ooool2o`0000L00000
00?o0000088C9P224bH06`224bH2o`0000`0]V5[00?o00000=MjG@3GNUd0103GNUd00ol00000_CP0
0;dh00040;dh00?o0000J_ooool006Wooooo00?o00000000000000001`0000000ol00000PQ<V088C
9P0H088C9P?o00003P2fHF/00ol00000egYM0=MjG@050=MjG@03o`00002m>000_CP000H0_CP00ol0
001Wooooo`00Ioooool2o`0000T0000000?o0000088C9P224bH05`224bH2o`000140]V5[00?o0000
0=MjG@3GNUd01P3GNUd00ol00000_CP00;dh00080;dh0003o`000?oooooooooo06Cooooo001Uoooo
o`;o00002P0000000ol00000PQ<V088C9P0F088C9P;o00004`2fHF/00ol00000egYM0=MjG@070=Mj
G@;o0000202m>0000ol0003oooooooooo`1Tooooo`00I?ooool00ol0000000000000000:00000003
o`0000224bH0PQ<V01@0PQ<V0_l0000F0;IQJ`03o`00003GNUd0egYM00P0egYM00?o00000;dh002m
>0001P2m>0000ol0003oooooooooo`1Sooooo`00H_ooool2o`0000`0000000?o0000088C9P224bH0
4`224bH2o`0001P0]V5[00?o00000=MjG@3GNUd02@3GNUd00ol00000_CP00;dh00060;dh0003o`00
0?oooooooooo06;ooooo001Qooooo`03o`0000000000000000`0000000?o0000088C9P224bH04@22
4bH2o`0001X0]V5[00?o00000=MjG@3GNUd02P3GNUd00ol00000_CP00;dh00060;dh0003o`000?oo
oooooooo067ooooo001Oooooo`;o00003P0000000ol00000PQ<V088C9P0@088C9P;o0000702fHF/0
0ol00000egYM0=MjG@0;0=MjG@;o00001`2m>0000ol0003oooooooooo`1Pooooo`00GOooool2o`00
00l0000000?o0000088C9P224bH03`224bH2o`0001h0]V5[00?o00000=MjG@3GNUd03@3GNUd00ol0
0000_CP00;dh00050;dh0003o`000?oooooooooo05oooooo001Looooo`03o`0000000000000000l0
000000?o0000088C9P224bH03@224bH2o`000200]V5[00?o00000=MjG@3GNUd03P3GNUd00ol00000
_CP00;dh00050;dh0003o`000?oooooooooo05kooooo001Kooooo`03o`0000000000000000l00000
00?o0000088C9P224bH030224bH2o`0002<0]V5[00?o00000=MjG@3GNUd03P3GNUd00ol00000_CP0
0;dh00050;dh0003o`000?oooooooooo05gooooo001Kooooo`;o0000400000000ol00000PQ<V088C
9P0:088C9P;o00009@2fHF/00ol00000egYM0=MjG@0?0=MjG@;o00001P2m>0000ol0003ooooooooo
o`1Looooo`00F_ooool01?l00000000=00003Ol0000>00000003o`0000224bH0PQ<V00T0PQ<V0_l0
000W0;IQJ`03o`00003GNUd0egYM0140egYM00?o00000;dh002m>000102m>0000ol0003ooooooooo
o`1Kooooo`00F_ooool01Ol00000000=00003@0000go000000`0000000?o0000088C9P224bH02022
4bH2o`0002T0]V5[00?o00000=MjG@3GNUd04P3GNUd00ol00000_CP00;dh00040;dh0003o`000?oo
oooooooo05[ooooo001Jooooo`03o`00000000d0000=0080000=00?o00000000000000002@000000
0ol00000PQ<V088C9P05088C9P?o0000:`2fHF/00ol00000egYM0=MjG@0C0=MjG@03o`00002m>000
_CP000@0_CP000?o0000ooooooooool0FOooool005Wooooo00?o000000003@0000d0100000d00ol0
000000000000000700000003o`0000224bH0PQ<V00@0PQ<V0_l0000^0;IQJ`03o`00003GNUd0egYM
01@0egYM0_l000040;dh0003o`000?oooooooooo05Wooooo001Iooooo`03o`00000000d0000=00D0
000=00?o00000000000000001@0000000ol00000PQ<V088C9P03088C9P;o0000<02fHF/00ol00000
egYM0=MjG@0F0=MjG@03o`00002m>000_CP00080_CP000?o0000ooooooooool0F?ooool005Wooooo
00?o000000003@0000d01P0000d00ol0000000000000000400000004o`0000224bH0PQ<V088C9P;o
0000<`2fHF/00ol00000egYM0=MjG@0F0=MjG@03o`00002m>000_CP00080_CP000?o0000oooooooo
ool0Eoooool005Sooooo00?o000000003@0000d0200000d00ol0000000000000000200000003o`00
00224bH0PQ<V00;o0000=@2fHF/00ol00000egYM0=MjG@0G0=MjG@03o`00002m>000_CP00080_CP0
00?o0000ooooooooool0E_ooool005Sooooo00?o000000003@0000d02@0000d01?l0000000000000
00000003o`0003L0]V5[00?o00000=MjG@3GNUd0603GNUd00ol00000_CP00;dh00020;dh0003o`00
0?oooooooooo05Gooooo001Gooooo`03o`00000000d0000=00/0000=00Co000000000?l0003o0000
>@2fHF/00ol00000egYM0=MjG@0I0=MjG@;o00000`2m>0000ol0003oooooooooo`1Dooooo`00Eooo
ool00ol00000000=00003@0;00003@[o0000<`2fHF/00ol00000egYM0=MjG@0K0=MjG@05o`00002m
>000_CP00;dh0?l00000EOooool005Oooooo00?o000000003@0000d02P0000d01Ol000006AbEo`00
002ZUl?o000000H0_YB[3ol0000T0;IQJ`03o`00003GNUd0egYM01`0egYM00Go00000;dh002m>000
_CP0o`00001Dooooo`00E_ooool00ol00000000=00003@0:00003@04o`00000I79D06AbEo`000080
ZYO300?o00000;jDZ`2nU:/04P2nU:/?o`0001H0]V5[00?o00000=MjG@3GNUd0703GNUd01Ol00000
_CP00;dh002m>03o000005?ooooo001Fooooo`03o`00000000d0000=00T0000=00Ko000001TLU@0I
79Go000006I/a?l000020:ZG``03o`00002nU:/0_YB[0200_YB[3ol000070;IQJ`03o`00003GNUd0
egYM01d0egYM0_l000020;dh0003o`000?oooooooooo053ooooo001Fooooo`03o`00000000d0000=
00P0000=00Oo000001TLU@0I79D06AbEo`00001VK<Co000000<0ZYO300?o00000;jDZ`2nU:/0;P2n
U:/:o`0001l0egYM00Co00000;dh002m>03o0000DOooool005Gooooo00?o000000003@0000d02000
00d00ol000006AbE01TLU@0201TLU@03o`00001VK<Co000000@0ZYO30_l0000e0;jDZ`03o`00003L
[jT0g:nY00Co0000703GNUd00ol00000_CP0o`00001Aooooo`00EOooool00ol00000000=00003@07
00003@03o`00000I79D06AbE00<06AbE00?o000006I/a?l000001P2ZUl<00ol00000_YB[0;jDZ`0b
0;jDZ`03o`00003L[jT0g:nY00@0g:nY1?l0000I0=MjG@03o`00002m>03o0000053ooooo001Doooo
o`03o`00000000d0000=00L0000=00?o000001TLU@0I79D00`0I79D01Ol00000IVc406I/a01VK<Co
000000H0ZYO300?o00000;jDZ`2nU:/0<@2nU:/00ol00000g:nY0=b_Z@080=b_Z@Co00005P3GNUd3
o`0004oooooo001Dooooo`03o`00000000d0000=00H0000=00?o000001TLU@0I79D0100I79D01Ol0
0000IVc406I/a01VK<Co000000L0ZYO300?o00000;jDZ`2nU:/0<02nU:/00ol00000g:nY0=b_Z@0<
0=b_Z@Co0000503GNUd2o`0004kooooo001Dooooo`03o`00000000d0000=00D0000=00?o000001TL
U@0I79D01@0I79D01Ol00000IVc406I/a01VK<Co000000P0ZYO30_l0000`0;jDZ`03o`00003L[jT0
g:nY0100g:nY1?l0000A0=MjG@;o0000COooool005?ooooo00?o000000003@0000d0100000d2o`00
00P06AbE00?o000006I/a01VK<@00P1VK<@00ol00000ZYO30:ZG``070:ZG``03o`00002nU:/0_YB[
02`0_YB[00?o00000=b_Z@3L[jT05@3L[jT4o`0000h0egYM0_l0001<ooooo`00Doooool00ol00000
000=00003@0300003@03o`00000I79D06AbE00L06AbE00?o000006I/a01VK<@00`1VK<@00ol00000
ZYO30:ZG``080:ZG``03o`00002nU:/0_YB[02/0_YB[00?o00000=b_Z@3L[jT06@3L[jT4o`0000/0
egYM0_l0001;ooooo`00Doooool00ol00000000=00003@0200003@03o`00000I79D06AbE00P06AbE
00?o000006I/a01VK<@00`1VK<@00ol00000ZYO30:ZG``090:ZG``03o`00002nU:/0_YB[02X0_YB[
00?o00000=b_Z@3L[jT07@3L[jT4o`0000P0egYM0_l0001:ooooo`00D_ooool00ol00000000=0000
3@0200003@03o`00000I79D06AbE00T06AbE00?o000006I/a01VK<@00`1VK<@00ol00000ZYO30:ZG
``0:0:ZG``03o`00002nU:/0_YB[02T0_YB[00?o00000=b_Z@3L[jT08@3L[jT4o`0000H0egYM00?o
0000ooooooooool0Aoooool005;ooooo00Go000000003@0000d0000=o`00000<01TLU@03o`00001V
K<@0IVc400@0IVc400?o00000:ZG``2ZUl<02P2ZUl<2o`0002T0_YB[00?o00000=b_Z@3L[jT09@3L
[jT4o`0000<0egYM00?o0000ooooooooool0A_ooool0057ooooo00Go000000003@0000d0000=o`00
000<01TLU@03o`00001VK<@0IVc400D0IVc400?o00000:ZG``2ZUl<0302ZUl<00ol00000_YB[0;jD
Z`0V0;jDZ`03o`00003L[jT0g:nY02T0g:nY1Ol00017ooooo`00DOooool01?l00000000=00003Ol0
000=01TLU@03o`00001VK<@0IVc400D0IVc400?o00000:ZG``2ZUl<03@2ZUl<00ol00000_YB[0;jD
Z`0U0;jDZ`03o`00003L[jT0g:nY02d0g:nY0_l00016ooooo`00DOooool00ol00000000=o`00000>
01TLU@03o`00001VK<@0IVc400D0IVc400?o00000:ZG``2ZUl<03P2ZUl<00ol00000_YB[0;jDZ`0T
0;jDZ`03o`00003L[jT0g:nY02/0g:nY0_l000000`3We<Co0000ooooo`15ooooo`00D?ooool00ol0
0000000=o`00000?01TLU@03o`00001VK<@0IVc400H0IVc400?o00000:ZG``2ZUl<03P2ZUl<00ol0
0000_YB[0;jDZ`0S0;jDZ`03o`00003L[jT0g:nY02X0g:nY00Co00000>ODa03We<Co0000Aoooool0
053ooooo0_l0000?01TLU@03o`00001VK<@0IVc400L0IVc400?o00000:ZG``2ZUl<03`2ZUl<2o`00
02<0_YB[00?o00000=b_Z@3L[jT0:03L[jT2o`0000<0imC400?o0000ooooooooool0AOooool0053o
oooo00?o000001TLU@0I79D03P0I79D00ol00000IVc406I/a00706I/a003o`00002ZUl<0ZYO30140
ZYO300?o00000;jDZ`2nU:/0802nU:/00ol00000g:nY0=b_Z@0V0=b_Z@;o0000103We<@2o`0004Oo
oooo001?ooooo`03o`00000I79D06AbE00l06AbE00?o000006I/a01VK<@0201VK<@00ol00000ZYO3
0:ZG``0A0:ZG``03o`00002nU:/0_YB[01h0_YB[00?o00000=b_Z@3L[jT09P3L[jT00ol00000imC4
0>ODa0030>ODa0;o0000B?ooool004oooooo00?o000001TLU@0I79D03`0I79D00ol00000IVc406I/
a00806I/a003o`00002ZUl<0ZYO30180ZYO300?o00000;jDZ`2nU:/07@2nU:/00ol00000g:nY0=b_
Z@0T0=b_Z@;o00001P3We<@2o`0004Sooooo001?ooooo`03o`00000I79D06AbE00h06AbE00?o0000
06I/a01VK<@02@1VK<@00ol00000ZYO30:ZG``0C0:ZG``;o00007@2nU:/00ol00000g:nY0=b_Z@0R
0=b_Z@;o00001`3We<@2o`0004Wooooo001?ooooo`;o00003`0I79D00ol00000IVc406I/a00906I/
a003o`00002ZUl<0ZYO301D0ZYO300?o00000;jDZ`2nU:/06P2nU:/00ol00000g:nY0=b_Z@0Q0=b_
Z@03o`00003We<@0imC400L0imC40_l00019ooooo`00Coooool2o`0000l06AbE00?o000006I/a01V
K<@02P1VK<@00ol00000ZYO30:ZG``0E0:ZG``03o`00002nU:/0_YB[01T0_YB[00?o00000=b_Z@3L
[jT07`3L[jT2o`0000T0imC40_l0001:ooooo`00Coooool2o`0000l06AbE00?o000006I/a01VK<@0
2P1VK<@00ol00000ZYO30:ZG``0F0:ZG``03o`00002nU:/0_YB[01P0_YB[00?o00000=b_Z@3L[jT0
7@3L[jT2o`0000/0imC40_l0001:ooooo`00Coooool2o`0000h06AbE00?o000006I/a01VK<@02`1V
K<@00ol00000ZYO30:ZG``0G0:ZG``03o`00002nU:/0_YB[01L0_YB[00?o00000=b_Z@3L[jT0703L
[jT00ol00000imC40>ODa00:0>ODa003o`00003IlYKo000004[ooooo001?ooooo`;o00003P0I79D0
0ol00000IVc406I/a00;06I/a003o`00002ZUl<0ZYO301P0ZYO30_l0000G0;jDZ`03o`00003L[jT0
g:nY01X0g:nY0_l0000<0>ODa003o`00003IlYKo000004_ooooo001?ooooo`03o`00000004?o0000
00d06AbE00?o000006I/a01VK<@0301VK<@00ol00000ZYO30:ZG``0I0:ZG``03o`00002nU:/0_YB[
01@0_YB[00?o00000=b_Z@3L[jT0603L[jT2o`0000h0imC400?o00000=WbU_l00000Boooool004oo
oooo00?o00000000@ol00000300I79D00ol00000IVc406I/a00=06I/a003o`00002ZUl<0ZYO301X0
ZYO300?o00000;jDZ`2nU:/04`2nU:/00ol00000g:nY0=b_Z@0G0=b_Z@03o`00003We<@0imC400d0
imC400?o00000=WbU_l00000C?ooool004oooooo00?o00000000@ol00000300I79D00ol00000IVc4
06I/a00=06I/a003o`00002ZUl<0ZYO301/0ZYO300?o00000;jDZ`2nU:/04P2nU:/00ol00000g:nY
0=b_Z@0E0=b_Z@;o0000403We<@00ol00000fO:Fo`00001<ooooo`00Coooool00ol000000013o`00
000<01TLU@03o`00001VK<@0IVc400h0IVc400?o00000:ZG``2ZUl<06`2ZUl<00ol00000_YB[0;jD
Z`0@0;jDZ`03o`00003L[jT0g:nY01@0g:nY0_l0000A0>ODa004o`00003IlYH0fO:Fo`0004cooooo
001?ooooo`03o`00000004?o000000`06AbE00?o000006I/a01VK<@03P1VK<@00ol00000ZYO30:ZG
``0L0:ZG``;o0000402nU:/00ol00000g:nY0=b_Z@0C0=b_Z@03o`00003We<@0imC40140imC400?o
00000=WbU_l00000COooool004oooooo00Co00000000@`0004?o00002P0I79D00ol00000IVc406I/
a00?06I/a003o`00002ZUl<0ZYO301h0ZYO300?o00000;jDZ`2nU:/03@2nU:/00ol00000g:nY0=b_
Z@0A0=b_Z@;o00004`3We<@01?l00000fO:F0=WbU_l0001=ooooo`00Coooool01?l0000000130000
@ol0000:01TLU@03o`00001VK<@0IVc400l0IVc400?o00000:ZG``2ZUl<07`2ZUl<00ol00000_YB[
0;jDZ`0<0;jDZ`03o`00003L[jT0g:nY00l0g:nY0_l0000D0>ODa004o`00003IlYH0fO:Fo`0004ko
oooo001?ooooo`04o`00000004<00013o`0000X06AbE00?o000006I/a01VK<@0401VK<@00ol00000
ZYO30:ZG``0O0:ZG``03o`00002nU:/0_YB[00/0_YB[00?o00000=b_Z@3L[jT03P3L[jT00ol00000
imC40>ODa00D0>ODa004o`00003IlYH0fO:Fo`0004kooooo001?ooooo`04o`00000004<00013o`00
00X06AbE00?o000006I/a01VK<@0401VK<@00ol00000ZYO30:ZG``0P0:ZG``03o`00002nU:/0_YB[
00X0_YB[00?o00000=b_Z@3L[jT0303L[jT2o`0001H0imC400Co00000=WbUP3IlYKo0000Coooool0
04oooooo00Co00000000@`0004?o00002@0I79D00ol00000IVc406I/a00A06I/a003o`00002ZUl<0
ZYO30240ZYO30_l0000:0;jDZ`03o`00003L[jT0g:nY00X0g:nY0_l0000H0>ODa004o`00003IlYH0
fO:Fo`0004oooooo001?ooooo`05o`00000004<000130000@ol00000200I79D00ol00000IVc406I/
a00A06I/a003o`00002ZUl<0ZYO302<0ZYO300?o00000;jDZ`2nU:/01`2nU:/00ol00000g:nY0=b_
Z@090=b_Z@03o`00003We<@0imC401L0imC400Go00000=WbUP3IlYH0fO:Fo`00001?ooooo`00Cooo
ool01Ol0000000130000@`0004?o000000P06AbE00?o000006I/a01VK<@04P1VK<@00ol00000ZYO3
0:ZG``0S0:ZG``03o`00002nU:/0_YB[00H0_YB[00?o00000=b_Z@3L[jT01`3L[jT2o`0001X0imC4
00Co00000=WbUP3IlYKo0000D?ooool004oooooo00Go00000000@`0004<00013o`00000801TLU@03
o`00001VK<@0IVc40180IVc400?o00000:ZG``2ZUl<0902ZUl<00ol00000_YB[0;jDZ`050;jDZ`03
o`00003L[jT0g:nY00D0g:nY0_l0000K0>ODa005o`00003IlYH0fO:F0=WbU_l00000D?ooool0053o
oooo00Co00000000@`0004?o00001`0I79D00ol00000IVc406I/a00C06I/a003o`00002ZUl<0ZYO3
02D0ZYO30_l000050;jDZ`03o`00003L[jT0g:nY00@0g:nY00?o00000>ODa03We<@06P3We<@01Ol0
0000fO:F0=WbUP3IlYKo0000057ooooo001@ooooo`05o`00000004<000130000@ol000001P0I79D0
0ol00000IVc406I/a00D06I/a003o`00002ZUl<0ZYO302H0ZYO300Go00000;jDZ`2nU:/0_YB[o`00
00050=b_Z@;o00007@3We<@01Ol00000fO:F0=WbUP3IlYKo0000057ooooo001@ooooo`05o`000000
04<000130000@ol000001P0I79D00ol00000IVc406I/a00D06I/a003o`00002ZUl<0ZYO302L0ZYO3
00Co00000;jDZ`2nU:_o00000`3L[jT2o`0001h0imC400?o00000=WbUP3IlYH00P3IlYH00ol0003o
ooooooooo`1?ooooo`00DOooool01?l0000000130000@ol0000601TLU@03o`00001VK<@0IVc401@0
IVc400?o00000:ZG``2ZUl<0:02ZUl<00ol00000_YB[o`0000020=b_Z@03o`00003We<@0imC401h0
imC400Go00000=WbUP3IlYH0fO:Fo`00001Booooo`00DOooool01?l0000000130000@ol0000501TL
U@03o`00001VK<@0IVc401D0IVc400?o00000:ZG``2ZUl<0:@2ZUl<4o`000200imC400?o00000=Wb
UP3IlYH00P3IlYH00ol0003oooooooooo`1@ooooo`00D_ooool00ol000000013o`00000501TLU@03
o`00001VK<@0IVc401H0IVc400?o00000:ZG``2ZUl<09`2ZUl<4o`000240imC400Go00000=WbUP3I
lYH0fO:Fo`00001Cooooo`00D_ooool01?l0000000130000@ol0000401TLU@03o`00001VK<@0IVc4
01H0IVc400?o00000:ZG``2ZUl<0902ZUl<3o`000080[[OP00?o00000<cIhol000007`3We<@00ol0
0000fO:F0=WbUP020=WbUP03o`000?oooooooooo057ooooo001Cooooo`03o`00000004?o000000@0
6AbE00?o000006I/a01VK<@05P1VK<@00ol00000ZYO30:ZG``0P0:ZG``Co0000102^]n001Ol00000
c=WS0<cIh`3<fN?o000001d0imC400?o00000=WbUP3IlYH00`3IlYH00ol0003oooooooooo`1Aoooo
o`00Doooool00ol000000013o`00000301TLU@03o`00001VK<@0IVc401L0IVc400?o00000:ZG``2Z
Ul<07@2ZUl<3o`0000P0[[OP00?o00000<cIh`3<fN<00P3<fN<2o`0001/0imC400?o00000=WbUP3I
lYH00P3IlYH00ol0003oooooooooo`1Booooo`00Doooool00ol000000013o`00000301TLU@03o`00
001VK<@0IVc401P0IVc400?o00000:ZG``2ZUl<06@2ZUl<3o`0000/0[[OP00?o00000<cIh`3<fN<0
103<fN<00ol00000imC40>ODa00G0>ODa003o`00003IlYH0fO:F00<0fO:F00?o0000ooooooooool0
D_ooool005Cooooo0_l0000301TLU@03o`00001VK<@0IVc401P0IVc400?o00000:ZG``2ZUl<05@2Z
Ul<4o`0000d0[[OP00?o00000<cIh`3<fN<01P3<fN<00ol00000imC40>ODa00F0>ODa003o`00003I
lYH0fO:F0080fO:F00?o0000ooooooooool0Doooool005Cooooo00?o00000000@ol000000P0I79D0
0ol00000IVc406I/a00H06I/a003o`00002ZUl<0ZYO30180ZYO30ol0000A0:jgh003o`00003<fN<0
c=WS00L0c=WS0_l0000E0>ODa003o`00003IlYH0fO:F00<0fO:F00?o0000ooooooooool0Doooool0
05Gooooo0_l000000`0I79Go000006I/a00K06I/a003o`00002ZUl<0ZYO300d0ZYO31?l0000D0:jg
h003o`00003<fN<0c=WS00T0c=WS00?o00000>ODa03We<@04P3We<@00ol00000fO:F0=WbUP020=Wb
UP03o`000?oooooooooo05Cooooo001Eooooo`;o000000<06AbEo`00001VK<@06`1VK<@00ol00000
ZYO30:ZG``0:0:ZG``?o00005`2^]n000ol00000c=WS0<cIh`0;0<cIh`03o`00003We<@0imC40100
imC400?o00000=WbUP3IlYH00`3IlYH00ol0003oooooooooo`1Dooooo`00E_ooool00ol000006AbE
o`00000L06I/a003o`00002ZUl<0ZYO300L0ZYO30ol0000J0:jgh003o`00003<fN<0c=WS00`0c=WS
0_l0000?0>ODa003o`00003IlYH0fO:F00@0fO:F00?o0000ooooooooool0E?ooool005Kooooo00?o
000001TLUOl00000701VK<@00ol00000ZYO30:ZG``030:ZG``Co00007@2^]n000ol00000c=WS0<cI
h`0>0<cIh`03o`00003We<@0imC400`0imC400?o00000=WbUP3IlYH00`3IlYH00ol0003ooooooooo
o`1Eooooo`00E_ooool2o`0001h0IVc400?o00000:ZG`ol000000_l0000P0:jgh003o`00003<fN<0
c=WS0100c=WS00?o00000>ODa03We<@02P3We<@00ol00000fO:F0=WbUP040=WbUP03o`000?oooooo
oooo05Gooooo001Gooooob7o00008`2^]n000ol00000c=WS0<cIh`0A0<cIh`;o00002P3We<@00ol0
0000fO:F0=WbUP030=WbUP03o`000?oooooooooo05Kooooo001Gooooo`03o`000000C<Ko000001`0
GX[U00?o00000:jgh02^]n008P2^]n000ol00000c=WS0<cIh`0C0<cIh`03o`00003We<@0imC400H0
imC400?o00000=WbUP3IlYH0103IlYH00ol0003oooooooooo`1Fooooo`00F?ooool00ol0000004c6
o`00000L05j:i@03o`00002^]n00[[OP0200[[OP00?o00000<cIh`3<fN<05@3<fN<00ol00000imC4
0>ODa0050>ODa003o`00003IlYH0fO:F00@0fO:F00?o0000ooooooooool0E_ooool005Wooooo00?o
0000001<a_l000006`1NR^D00ol00000[[OP0:jgh00P0:jgh003o`00003<fN<0c=WS01H0c=WS0_l0
00040>ODa003o`00003IlYH0fO:F00@0fO:F00?o0000ooooooooool0Eoooool005[ooooo00Co0000
001<a_l0003o00006P1NR^D00ol00000[[OP0:jgh00O0:jgh003o`00003<fN<0c=WS01P0c=WS00Co
00000>ODa03We<Co00001`3IlYH00ol0003oooooooooo`1Gooooo`00Foooool01?l0000004c6001<
a_l0000I05j:i@03o`00002^]n00[[OP01h0[[OP00?o00000<cIh`3<fN<06P3<fN<00ol00000imC4
o`0000060=WbUP03o`000?oooooooooo05Sooooo001Looooo`04o`000000C<H004c6o`0001T0GX[U
00?o00000:jgh02^]n007@2^]n000ol00000c=WS0<cIh`0J0<cIh`?o00001P3IlYH00ol0003ooooo
ooooo`1Hooooo`00G?ooool01Ol0000004c6001<aP00C<Ko000001P0GX[U00?o00000:jgh02^]n00
7@2^]n000ol00000c=WS0<cIh`0I0<cIh`05o`00002[mlD0ZoO50:_gaOl00000103IlYH00ol0003o
ooooooooo`1Iooooo`00GOooool01Ol0000004c6001<aP00C<Ko000001P0GX[U00?o00000:jgh02^
]n006`2^]n000ol00000c=WS0<cIh`0I0<cIh`03o`00002[mlD0ZoO500<0ZoO50_l000020=WbUP03
o`000?oooooooooo05Wooooo001Nooooo`04o`000000C<H004c6001<aP;o00005P1NR^D00ol00000
[[OP0:jgh00K0:jgh003o`00003<fN<0c=WS01P0c=WS00?o00000:_ga@2[mlD01P2[mlD00ol00000
fO:Fo`00001Kooooo`00Goooool00ol0000004c6001<aP02001<aP03o`00001NR^D0GX[U01@0GX[U
00?o00000:jgh02^]n006P2^]n000ol00000c=WS0<cIh`0G0<cIh`03o`00002[mlD0ZoO500L0ZoO5
0_l0001Looooo`00H?ooool00ol0000004c6001<aP02001<aP03o`00001NR^D0GX[U01<0GX[U00?o
00000:jgh02^]n006@2^]n000ol00000c=WS0<cIh`0G0<cIh`03o`00002[mlD0ZoO500L0ZoO500?o
0000ooooooooool0G?ooool0063ooooo00?o0000001<aP00C<H00`00C<H00ol00000GX[U05j:i@0C
05j:i@03o`00002^]n00[[OP01P0[[OP00?o00000<cIh`3<fN<05@3<fN<2o`0000P0ZoO50_l0001O
ooooo`00HOooool00ol0000004c6001<aP03001<aP;o00004`1NR^D00ol00000[[OP0:jgh00H0:jg
h003o`00003<fN<0c=WS01@0c=WS00?o00000:_ga@2[mlD01`2[mlD00ol0003oooooooooo`1Ooooo
o`00H_ooool00ol0000004c6001<aP04001<aP03o`00001NR^D0GX[U0140GX[U00?o00000:jgh02^
]n005P2^]n000ol00000c=WS0<cIh`0D0<cIh`03o`00002[mlD0ZoO500H0ZoO50_l0001Rooooo`00
Hoooool00ol0000004c6001<aP04001<aP03o`00001NR^D0GX[U0100GX[U00?o00000:jgh02^]n00
5P2^]n000ol00000c=WS0<cIh`0C0<cIh`03o`00002[mlD0ZoO500H0ZoO500?o0000ooooooooool0
H_ooool006Cooooo00?o0000001<aP00C<H01000C<H00ol00000GX[U05j:i@0@05j:i@03o`00002^
]n00[[OP01@0[[OP00?o00000<cIh`3<fN<04`3<fN<00ol00000ZoO50:_ga@050:_ga@;o0000IOoo
ool006Gooooo0_l00005001<aP;o0000401NR^D00ol00000[[OP0:jgh00D0:jgh003o`00003<fN<0
c=WS0180c=WS00?o00000:_ga@2[mlD01@2[mlD00ol0003oooooooooo`1Uooooo`00Ioooool00ol0
000004c6001<aP04001<aP03o`00001NR^D0GX[U00h0GX[U00?o00000:jgh02^]n004`2^]n000ol0
0000c=WS0<cIh`0@0<cIh`;o00001P2[mlD2o`0006Sooooo001Xooooo`;o00001@00C<H00ol00000
GX[U05j:i@0=05j:i@03o`00002^]n00[[OP0180[[OP00?o00000<cIh`3<fN<0403<fN<00ol00000
ZoO50:_ga@050:_ga@03o`000?oooooooooo06Sooooo001Zooooo`03o`000000C<H004c600<004c6
00?o000005j:i@1NR^D03@1NR^D00ol00000[[OP0:jgh00A0:jgh003o`00003<fN<0c=WS00l0c=WS
00?o00000:_ga@2[mlD0102[mlD2o`0006_ooooo001[ooooo`;o00001000C<H2o`0000d0GX[U00?o
00000:jgh02^]n004@2^]n000ol00000c=WS0<cIh`0>0<cIh`03o`00002[mlD0ZoO500@0ZoO500?o
0000ooooooooool0Joooool006gooooo00?o0000001<aP00C<H00`00C<H00ol00000GX[U05j:i@0;
05j:i@03o`00002^]n00[[OP00l0[[OP00?o00000<cIh`3<fN<03P3<fN<00ol00000ZoO50:_ga@03
0:_ga@;o0000K_ooool006kooooo0_l00004001<aP03o`00001NR^D0GX[U00/0GX[U00?o00000:jg
h02^]n003P2^]n000ol00000c=WS0<cIh`0=0<cIh`03o`00002[mlD0ZoO500<0ZoO500?o0000oooo
ooooool0K_ooool0073ooooo00?o0000001<aP00C<H00P00C<H00ol00000GX[U05j:i@0:05j:i@03
o`00002^]n00[[OP00h0[[OP00?o00000<cIh`3<fN<02`3<fN<2o`0000@0ZoO50_l0001aooooo`00
LOooool2o`0000<004c600?o000005j:i@1NR^D02P1NR^D00ol00000[[OP0:jgh00<0:jgh003o`00
003<fN<0c=WS00/0c=WS00?o00000:_ga@2[mlD00`2[mlD00ol0003oooooooooo`1aooooo`00Looo
ool01?l0000004c6001<aP00C<H2o`0000X0GX[U00?o00000:jgh02^]n00302^]n000ol00000c=WS
0<cIh`0:0<cIh`03o`00002[mlD0ZoO50080ZoO50_l0001dooooo`00M?ooool2o`0000<004c600?o
000005j:i@1NR^D0201NR^D00ol00000[[OP0:jgh00;0:jgh003o`00003<fN<0c=WS00T0c=WS00?o
00000:_ga@2[mlD00P2[mlD00ol0003oooooooooo`1dooooo`00M_ooool01Ol0000004c6001<aP00
C<Ko000000T0GX[U00?o00000:jgh02^]n002P2^]n000ol00000c=WS0<cIh`090<cIh`03o`00002[
mlD0ZoO50080ZoO500?o0000ooooooooool0MOooool007Oooooo0_l00002001<aP03o`00001NR^D0
GX[U00L0GX[U00?o00000:jgh02^]n002@2^]n000ol00000c=WS0<cIh`080<cIh`04o`00002[mlD0
ZoO50:_ga@;o0000N?ooool007Wooooo00?o0000001<aP00C<H00_l0000705j:i@03o`00002^]n00
[[OP00T0[[OP00?o00000<cIh`3<fN<01`3<fN<01Ol00000ZoO50:_ga@2[mlGo000007[ooooo001j
ooooo`;o00000P00C<H00ol00000GX[U05j:i@0505j:i@03o`00002^]n00[[OP00L0[[OP00?o0000
0<cIh`3<fN<01P3<fN<2o`000080ZoO50_l0001kooooo`00O?ooool01?l0000004c6001<a_l00006
05j:i@03o`00002^]n00[[OP00L0[[OP00?o00000<cIh`3<fN<01@3<fN<01Ol00000ZoO50:_ga@2[
mlGo000007gooooo001mooooo`;o000000<004c6o`00001NR^D01@1NR^D00ol00000[[OP0:jgh006
0:jgh003o`00003<fN<0c=WS00@0c=WS00?o00000:_ga@2[mlD00_l0001nooooo`00Ooooool01?l0
000004c6o`000?l0000405j:i@03o`00002^]n00[[OP00D0[[OP00?o00000<cIh`3<fN<0103<fN<0
1?l00000ZoO50:_gaOl00020ooooo`00P?ooool2o`000003001<a_l00000GX[U00<0GX[U00?o0000
0:jgh02^]n00102^]n000ol00000c=WS0<cIh`030<cIh`04o`00002[mlGo0000o`00087ooooo0022
ooooo`03o`000000C<Ko000000<0GX[U00?o00000:jgh02^]n00102^]n000ol00000c=WS0<cIh`02
0<cIh`03o`00002[mlGo000008?ooooo0023ooooo`?o00000`1NR^D00ol00000[[OP0:jgh0020:jg
h004o`00003<fN<0c=WS0<cIh`Co0000Q?ooool008Gooooo0_l0000205j:i@03o`00002^]n00[[OP
0080[[OP00Ko00000<cIh`3<fN?o00000:_gaOl00026ooooo`00Q_ooool3o`00000305j:iOl00000
[[OP0080[[OP00?o00000<cIhol000000_l00027ooooo`00R?ooool3o`000080[[OP00Co00000<cI
hol0003o0000ROooool008Wooooo0ol00000102^]n3o0000o`000?l0002:ooooo`00Roooool00ol0
0000[[OPo`00002<ooooo`00S?ooool00ol0003oooooooooo`2;ooooo`00oooooolKooooo`00oooo
oolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooo
oolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooo
oolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooo
oolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooo
oolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooo
oolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooo
oolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooo
oolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooo
oolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooo
oolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooo
oolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooo
oolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooo
oolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooo
oolKooooo`00\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-5.00005*^-6, -5.00005*^-6, \
0.00355875, 0.00355875}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.47621 .45416 m .58185 .41311 L .63473 .56796 L closepath p .637 .561 .752 r
F P
0 g
s
.5 .27523 m .58185 .41311 L .47621 .45416 L closepath p .664 .659 .835 r
F P
0 g
s
.47119 .57044 m .47621 .45416 L .63473 .56796 L closepath p .696 .546 .68 r
F P
0 g
s
.31094 .5517 m .47119 .57044 L .47621 .45416 L closepath p .785 .622 .68 r
F P
0 g
s
.38662 .40027 m .31094 .5517 L .47621 .45416 L closepath p .824 .726 .757 r
F P
0 g
s
.38662 .40027 m .5 .27523 L .47621 .45416 L closepath p .763 .75 .841 r
F P
0 g
s
.4747 .67248 m .47119 .57044 L .63473 .56796 L closepath p .673 .409 .514 r
F P
0 g
s
.47119 .57044 m .31094 .5517 L .4747 .67248 L closepath p .776 .492 .505 r
F P
0 g
s
.68388 .63248 m .71242 .51198 L .63473 .56796 L closepath p .002 0 .286 r
F P
0 g
s
.67184 .39558 m .71242 .51198 L .63473 .56796 L closepath p .215 .219 .647 r
F P
0 g
s
.58185 .41311 m .63473 .56796 L .67184 .39558 L closepath p .44 .442 .765 r
F P
0 g
s
.58835 .68293 m .68388 .63248 L .63473 .56796 L closepath p .171 0 .178 r
F P
0 g
s
.58835 .68293 m .4747 .67248 L .63473 .56796 L closepath p .547 .214 .356 r
F P
0 g
s
.5 .27523 m .58185 .41311 L .67184 .39558 L closepath p .451 .556 .871 r
F P
0 g
s
.31094 .5517 m .38662 .40027 L .32197 .37174 L closepath p .931 .892 .769 r
F P
0 g
s
.38662 .40027 m .32197 .37174 L .5 .27523 L closepath p .839 .931 .89 r
F P
0 g
s
.31094 .5517 m .37742 .67486 L .4747 .67248 L closepath p .804 .41 .307 r
F P
0 g
s
.30901 .61606 m .37742 .67486 L .31094 .5517 L closepath p .823 .365 0 r
F P
0 g
s
.27803 .48748 m .32197 .37174 L .31094 .5517 L closepath p .974 .903 .557 r
F P
0 g
s
.27803 .48748 m .30901 .61606 L .31094 .5517 L closepath p .825 .525 0 r
F P
0 g
s
.5 .75807 m .37742 .67486 L .4747 .67248 L closepath p .619 .094 0 r
F P
0 g
s
.58835 .68293 m .5 .75807 L .4747 .67248 L closepath p .462 0 .029 r
F P
0 g
s
.5 .27523 m .40391 .30106 L .32197 .37174 L closepath p .653 .97 .851 r
F P
0 g
s
.62758 .31802 m .5 .27523 L .67184 .39558 L closepath p .167 .475 .895 r
F P
0 g
s
.53006 .29504 m .40391 .30106 L .5 .27523 L closepath p .109 0 0 r
F P
0 g
s
.62758 .31802 m .53006 .29504 L .5 .27523 L closepath p .282 0 0 r
F P
0 g
s
.73211 .43653 m .71242 .51198 L .67184 .39558 L closepath p 0 0 .497 r
F P
0 g
s
.62758 .31802 m .73211 .43653 L .67184 .39558 L closepath p 0 .034 .59 r
F P
0 g
s
.58835 .68293 m .5 .75807 L .68388 .63248 L closepath p 0 0 0 r
F P
0 g
s
.71242 .51198 m .68388 .63248 L .73211 .43653 L closepath p 0 0 0 r
F P
0 g
s
.30901 .61606 m .37742 .67486 L .5 .75807 L closepath p 0 .194 .659 r
F P
0 g
s
.32183 .41013 m .40391 .30106 L .32197 .37174 L closepath p 0 0 0 r
F P
0 g
s
.27803 .48748 m .32183 .41013 L .32197 .37174 L closepath p 0 0 0 r
F P
0 g
s
.73211 .43653 m .63934 .62256 L .68388 .63248 L closepath p .939 .964 .694 r
F P
0 g
s
.5 .75807 m .63934 .62256 L .68388 .63248 L closepath p .772 .997 .846 r
F P
0 g
s
.62758 .31802 m .53006 .29504 L .73211 .43653 L closepath p .749 .24 0 r
F P
0 g
s
.30901 .61606 m .27803 .48748 L .32183 .41013 L closepath p 0 0 .491 r
F P
0 g
s
.40391 .30106 m .32183 .41013 L .53006 .29504 L closepath p .408 0 .122 r
F P
0 g
s
.39483 .61165 m .5 .75807 L .30901 .61606 L closepath p .265 .497 .892 r
F P
0 g
s
.39483 .61165 m .32183 .41013 L .30901 .61606 L closepath p .282 .352 .758 r
F P
0 g
s
.53252 .56266 m .63934 .62256 L .5 .75807 L closepath p .772 .81 .883 r
F P
0 g
s
.39483 .61165 m .53252 .56266 L .5 .75807 L closepath p .639 .684 .877 r
F P
0 g
s
.53006 .29504 m .53855 .40574 L .32183 .41013 L closepath p .646 .329 .421 r
F P
0 g
s
.73211 .43653 m .53855 .40574 L .53006 .29504 L closepath p .787 .439 .398 r
F P
0 g
s
.73211 .43653 m .53855 .40574 L .53252 .56266 L closepath p .81 .637 .667 r
F P
0 g
s
.63934 .62256 m .73211 .43653 L .53252 .56266 L closepath p .862 .779 .768 r
F P
0 g
s
.39483 .61165 m .53252 .56266 L .32183 .41013 L closepath p .609 .553 .766 r
F P
0 g
s
.53252 .56266 m .53855 .40574 L .32183 .41013 L closepath p .691 .535 .67 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016R000`400?l00000o`00003oo`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00RP3oool5o`0008/0oooo00260?ooo`Co0000100K
0004o`0008P0oooo00220?ooo`Co00002@0K0002o`00000404P00?l0003o0000o`0008D0oooo001n
0?ooo`Co00003`0K0002o`000080B0000ol000220?ooo`00N`3oool3o`0001D06`0000?o000004P0
001800000P180003o`0007l0oooo001g0?ooo`Co0000400K000<o`0000@0B0000ol0001l0?ooo`00
L`3oool4o`0000<06`004Ol0000606P07`;o000000<0YEA[o`000039L6D01Ol0000304P000?o0000
N@3oool00700oooo2_l0000F06P07`05o`00002UE6/0YEA[0:EDJol000000P39L6D2o`000080_cd0
1?l0000204P000?o0000MP3oool006l0oooo00?o000000000?l00000701X01l2o`0000@0YEA[00?o
00000<U`I@39L6D00P39L6D00ol00000_cd00;lm00030;lm00Co000000@0B000o`000?l0003o0000
L`3oool006h0oooo00?o000000000?l000006`1X01l2o`0000H0YEA[00?o00000<U`I@39L6D00`39
L6D00ol00000_cd00;lm00060;lm00Oo0000L03oool006d0oooo00?o000000000?l000006P1X01l2
o`0000P0YEA[00?o00000<U`I@39L6D01039L6D2o`0000X0_cd01_l0001]0?ooo`00K03oool00ol0
00000000o`00000J06P07`03o`00002UE6/0YEA[00T0YEA[00?o00000<U`I@39L6D01@39L6D00ol0
0000_cd00;lm000;0;lm00Go0000JP3oool006/0oooo00Co000000000000003o0000601X01l2o`00
00`0YEA[00?o00000<U`I@39L6D01P39L6D2o`0000l0_cd00_l0001Y0?ooo`00JP3oool01?l00000
000000000?l0000G06P07`;o00003P2UE6/00ol00000bG1U0<U`I@080<U`I@03o`00002o?@00_cd0
00d0_cd000?o00000?ooo`3oool0I`3oool006P0oooo0_l0000200000003o`00001X01l0J00O01@0
J00O0_l0000@0:EDJ`03o`000039L6D0bG1U00T0bG1U0_l0000>0;lm0003o`00003oool0oooo06H0
oooo001W0?ooo`05o`0000000000000000000?l000005P1X01l00ol00000YEA[0:EDJ`0@0:EDJ`03
o`000039L6D0bG1U00/0bG1U00?o00000;lm002o?@00302o?@000ol00000oooo0?ooo`1U0?ooo`00
IP3oool00ol0000000000000000200000003o`00001X01l0J00O0180J00O0_l0000C0:EDJ`03o`00
0039L6D0bG1U00`0bG1U00?o00000;lm002o?@00302o?@000ol00000oooo0?ooo`1T0?ooo`00I@3o
ool00ol0000000000000000200000003o`00001X01l0J00O0140J00O0_l0000E0:EDJ`03o`000039
L6D0bG1U00d0bG1U0_l0000=0;lm0003o`00003oool0oooo06<0oooo001T0?ooo`03o`0000000000
00000080000000?o000006P07`1X01l0401X01l2o`0001L0YEA[00?o00000<U`I@39L6D03`39L6D0
0ol00000_cd00;lm000;0;lm0003o`00003oool0oooo0680oooo001S0?ooo`03o`00000000000000
0080000000?o000006P07`1X01l0401X01l00ol00000YEA[0:EDJ`0G0:EDJ`03o`000039L6D0bG1U
0100bG1U0_l0000<0;lm0003o`00003oool0oooo0640oooo001Q0?ooo`;o00001@0000000ol00000
J00O06P07`0>06P07`;o00006P2UE6/00ol00000bG1U0<U`I@0B0<U`I@03o`00002o?@00_cd000X0
_cd000?o00000?ooo`3oool0H03oool00600oooo00?o0000000000000000100000000ol00000J00O
06P07`0=06P07`;o0000702UE6/00ol00000bG1U0<U`I@0C0<U`I@;o00002P2o?@000ol00000oooo
0?ooo`1P0?ooo`00G`3oool00ol0000000000000000400000003o`00001X01l0J00O00`0J00O0_l0
000O0:EDJ`03o`000039L6D0bG1U01@0bG1U00?o00000;lm002o?@00202o?@000ol00000oooo0?oo
o`1O0?ooo`00GP3oool00ol0000000000000000400000003o`00001X01l0J00O00/0J00O0_l0000Q
0:EDJ`03o`000039L6D0bG1U01D0bG1U00?o00000;lm002o?@00202o?@000ol00000oooo0?ooo`1N
0?ooo`00G@3oool00ol0000000000000000500000003o`00001X01l0J00O00X0J00O00?o00000:ED
J`2UE6/08@2UE6/00ol00000bG1U0<U`I@0F0<U`I@;o00002@2o?@000ol00000oooo0?ooo`1M0?oo
o`00G03oool00ol0000000000000000500000003o`00001X01l0J00O00T0J00O0_l0000T0:EDJ`03
o`000039L6D0bG1U01P0bG1U00?o00000;lm002o?@001`2o?@000ol00000oooo0?ooo`1L0?ooo`00
F`3oool00ol0000000000000000500000003o`00001X01l0J00O00P0J00O0_l0000V0:EDJ`03o`00
0039L6D0bG1U01T0bG1U0_l000080;lm0003o`00003oool0oooo05/0oooo001J0?ooo`03o`000000
0000000000H0000000?o000006P07`1X01l01P1X01l2o`0002P0YEA[00?o00000<U`I@39L6D06`39
L6D00ol00000_cd00;lm00060;lm0003o`00003oool0oooo05X0oooo001J0?ooo`03o`0000000000
000000D0000000?o000006P07`1X01l01P1X01l00ol00000YEA[0:EDJ`0X0:EDJ`03o`000039L6D0
bG1U01`0bG1U00?o00000;lm002o?@001P2o?@000ol00000oooo0?ooo`1I0?ooo`00F@3oool2o`00
00H0000000?o000006P07`1X01l01@1X01l2o`0002/0YEA[00?o00000<U`I@39L6D07@39L6D2o`00
00L0_cd000?o00000?ooo`3oool0F03oool005T0oooo0_l0000500000003o`00001X01l0J00O00@0
J00O0_l0000]0:EDJ`03o`000039L6D0bG1U01l0bG1U00?o00000;lm002o?@00102o?@000ol00000
oooo0?ooo`1H0?ooo`00F@3oool2o`0000D0000000?o000006P07`1X01l00P1X01l2o`0002l0YEA[
00?o00000<U`I@39L6D08039L6D2o`0000D0_cd000?o00000?ooo`3oool0E`3oool005P0oooo00?o
000000000?l00000100000000ol00000J00O06P07`0206P07`03o`00002UE6/0YEA[02l0YEA[00?o
00000<U`I@39L6D08P39L6D00ol00000_cd00;lm00030;lm0003o`00003oool0oooo05H0oooo001H
0?ooo`03o`000000003o000000<0000000Co000006P07`1X01l0J00O0_l0000c0:EDJ`03o`000039
L6D0bG1U0280bG1U0_l000040;lm0003o`00003oool0oooo05D0oooo001H0?ooo`03o`000000003o
00000080000000?o000006P07`1X01l00_l0000e0:EDJ`03o`000039L6D0bG1U02@0bG1U00?o0000
0;lm002o?@000P2o?@000ol00000oooo0?ooo`1D0?ooo`00E`3oool01?l00000000000000?l00002
000000?o0000=`2UE6/00ol00000bG1U0<U`I@0U0<U`I@03o`00002o?@00_cd00080_cd000?o0000
0?ooo`3oool0D`3oool005L0oooo00Go000000000000003o000000000002o`0003T0YEA[00?o0000
0<U`I@39L6D09P39L6D2o`0000<0_cd000?o00000?ooo`3oool0DP3oool005H0oooo00Co00000000
0000000000000ol0000L0:EDJb;o00009`39L6D01Ol00000_cd00;lm002o?@3o000005<0oooo001F
0?ooo`04o`00000000000000000001oo00007P2`R:/01?l00000cj>Z0<nSZP3?XjX7o`000240bG1U
0_l000000`2o?@3o00000?ooo`1B0?ooo`00EP3oool01ol00000000000000000003o000009^=a?l0
0000>P2`R:/00ol00000cj>Z0<nSZP080<nSZPOo00007039L6D00ol00000_cd0o`00001B0?ooo`00
E@3oool01?l000000000000000000003o`00000309^=a?l00000/8R[03P0/8R[00?o00000<nSZP3?
XjX03`3?XjX7o`0001H0bG1U0ol0001A0?ooo`00E@3oool01?l000000000000000000003o`000080
Vhg40_l0000g0;28Z`03o`00003?XjX0cj>Z01H0cj>Z1_l0000B0<U`I@;o0000D03oool005D0oooo
00Go000000000000003o00000000O@02o`0000@0Vhg400?o00000;28Z`2`R:/0=02`R:/00ol00000
cj>Z0<nSZP0L0<nSZPOo00003039L6D2o`0004l0oooo001D0?ooo`04o`00000000000000o`000080
001m00?o000004QJ`_l00000102KSL@2o`0003@0/8R[00?o00000<nSZP3?XjX08`3?XjX7o`0000H0
bG1U0_l0001>0?ooo`00E03oool01?l00000000000000?l000020000O@03o`000018F/;o000000H0
Vhg400?o00000;28Z`2`R:/0<@2`R:/00ol00000cj>Z0<nSZP0Z0<nSZPOo000000<0bG1Uo`00003o
ool0C03oool005<0oooo00Co000000000000003o00000`0007d00ol00000B5[2o`00000709^=a003
o`00002`R:/0/8R[0300/8R[00?o00000<nSZP3?XjX0<@3?XjX3o`0004`0oooo001C0?ooo`04o`00
000000000000o`000080001m00Go000004QJ`P18F/80B5[2o`00000709^=a0;o0000<02`R:/00ol0
0000cj>Z0<nSZP0a0<nSZP03o`00003LalCo000004`0oooo001C0?ooo`03o`000000003o000000<0
001m00Go000004QJ`P18F/80B5[2o`00000909^=a003o`00002`R:/0/8R[02d0/8R[00?o00000<nS
ZP3?XjX0;`3?XjX2o`0000030=c7a?l0003o000004`0oooo001B0?ooo`04o`00000000000000o`00
00<0001m00Go000004QJ`P18F/80B5[2o`00000:09^=a003o`00002`R:/0/8R[02`0/8R[00?o0000
0<nSZP3?XjX0;P3?XjX01Ol00000g<O40=c7a03LalCo000004d0oooo001B0?ooo`03o`000000003o
000000@0001m00?o000004QJ`P18F/800P18F/800ol00000Vhg409^=a00809^=a0;o0000:`2`R:/0
0ol00000cj>Z0<nSZP0]0<nSZP;o00000`3Lal@2o`0004d0oooo001B0?ooo`;o00001@0007d00ol0
0000B5[204QJ`P0204QJ`P03o`00002KSL@0Vhg400X0Vhg400?o00000;28Z`2`R:/0:02`R:/00ol0
0000cj>Z0<nSZP0[0<nSZP;o00001@3Lal@2o`0004d0oooo001A0?ooo`03o`000000003o000000D0
001m00?o000004QJ`P18F/800P18F/800ol00000Vhg409^=a00;09^=a0;o0000:02`R:/00ol00000
cj>Z0<nSZP0Z0<nSZP03o`00003Lal@0g<O400@0g<O400?o00000?3f/Ol00000C@3oool00540oooo
0_l000060000O@03o`000018F/80B5[200<0B5[200?o000009^=a02KSL@0302KSL@00ol00000/8R[
0;28Z`0U0;28Z`03o`00003?XjX0cj>Z02P0cj>Z0_l000070=c7a0;o0000CP3oool00500oooo00?o
000000000?l000001P0007d00ol00000B5[204QJ`P0304QJ`P03o`00002KSL@0Vhg400d0Vhg400?o
00000;28Z`2`R:/0902`R:/00ol00000cj>Z0<nSZP0W0<nSZP03o`00003Lal@0g<O400H0g<O400?o
00000?3f/Ol00000CP3oool00500oooo0_l000070000O@03o`000018F/80B5[200@0B5[200?o0000
09^=a02KSL@03@2KSL@2o`0002@0/8R[00?o00000<nSZP3?XjX09@3?XjX2o`0000T0g<O400?o0000
0?3f/Ol00000CP3oool00500oooo0_l000070000O@03o`000018F/80B5[200@0B5[200?o000009^=
a02KSL@03`2KSL@00ol00000/8R[0;28Z`0Q0;28Z`03o`00003?XjX0cj>Z02@0cj>Z00?o00000=c7
a03Lal@0203Lal@01?l00000l?Ja0?3f/Ol0001>0?ooo`00C`3oool2o`0000P0001m00?o000004QJ
`P18F/801018F/800ol00000Vhg409^=a00@09^=a003o`00002`R:/0/8R[0200/8R[00?o00000<nS
ZP3?XjX08P3?XjX2o`0000/0g<O400Co00000?3f/@3`m[7o0000CP3oool004l0oooo00?o00000000
O@0007d01`0007d00ol00000B5[204QJ`P0504QJ`P03o`00002KSL@0Vhg40100Vhg40_l0000P0;28
Z`03o`00003?XjX0cj>Z0240cj>Z00?o00000=c7a03Lal@02P3Lal@01?l00000l?Ja0?3f/Ol0001?
0?ooo`00C`3oool00ol00000001m0000O@070000O@03o`000018F/80B5[200D0B5[200?o000009^=
a02KSL@04P2KSL@00ol00000/8R[0;28Z`0M0;28Z`03o`00003?XjX0cj>Z01l0cj>Z0_l0000=0=c7
a004o`00003`m[40l?Jao`0004l0oooo001>0?ooo`03o`00000007d0001m00P0001m00?o000004QJ
`P18F/801@18F/800ol00000Vhg409^=a00C09^=a0;o00007@2`R:/00ol00000cj>Z0<nSZP0M0<nS
ZP;o00003P3Lal@01Ol00000l?Ja0?3f/@3`m[7o000004l0oooo001>0?ooo`03o`00000007d0001m
00P0001m00?o000004QJ`P18F/801P18F/800ol00000Vhg409^=a00D09^=a003o`00002`R:/0/8R[
01X0/8R[00?o00000<nSZP3?XjX0703?XjX00ol00000g<O40=c7a00>0=c7a005o`00003`m[40l?Ja
0?3f/Ol00000C`3oool004h0oooo00?o00000000O@0007d01`0007d00ol00000B5[204QJ`P0704QJ
`P03o`00002KSL@0Vhg401D0Vhg400?o00000;28Z`2`R:/06@2`R:/00ol00000cj>Z0<nSZP0J0<nS
ZP;o0000403Lal@01Ol00000l?Ja0?3f/@3`m[7o00000500oooo001?0?ooo`03o`00000007d0001m
00H0001m00?o000004QJ`P18F/801`18F/800ol00000Vhg409^=a00F09^=a0;o00006@2`R:/00ol0
0000cj>Z0<nSZP0I0<nSZP03o`00003Lal@0g<O40100g<O400Go00000?3f/@3`m[40l?Jao`00001@
0?ooo`00C`3oool00ol00000001m0000O@060000O@03o`000018F/80B5[200P0B5[200?o000009^=
a02KSL@05`2KSL@00ol00000/8R[0;28Z`0F0;28Z`03o`00003?XjX0cj>Z01L0cj>Z0_l0000B0=c7
a003o`00003`m[40l?Ja0080l?Ja00?o00000?ooo`3oool0CP3oool004l0oooo00?o00000000O@00
07d01P0007d00ol00000B5[204QJ`P0804QJ`P03o`00002KSL@0Vhg401P0Vhg400?o00000;28Z`2`
R:/05@2`R:/00ol00000cj>Z0<nSZP0F0<nSZP03o`00003Lal@0g<O40180g<O400?o00000?3f/@3`
m[400P3`m[400ol00000oooo0?ooo`1>0?ooo`00C`3oool00ol00000001m0000O@060000O@03o`00
0018F/80B5[200P0B5[200?o000009^=a02KSL@06@2KSL@2o`0001D0/8R[00?o00000<nSZP3?XjX0
503?XjX2o`0001@0g<O400?o00000?3f/@3`m[400P3`m[400ol00000oooo0?ooo`1?0?ooo`00C`3o
ool00ol00000001m0000O@060000O@03o`000018F/80B5[200T0B5[200?o000009^=a02KSL@06P2K
SL@00ol00000/8R[0;28Z`0B0;28Z`03o`00003?XjX0cj>Z01<0cj>Z00?o00000=c7a03Lal@0503L
al@00ol00000l?Ja0?3f/@020?3f/@03o`00003oool0oooo04l0oooo001@0?ooo`03o`00000007d0
001m00D0001m00?o000004QJ`P18F/802@18F/800ol00000Vhg409^=a00K09^=a003o`00002`R:/0
/8R[0140/8R[00?o00000<nSZP3?XjX04@3?XjX2o`0001H0g<O400?o00000?3f/@3`m[400`3`m[40
0ol00000oooo0?ooo`1?0?ooo`00D03oool00ol00000001m0000O@050000O@03o`000018F/80B5[2
00X0B5[200?o000009^=a02KSL@06`2KSL@2o`000140/8R[00?o00000<nSZP3?XjX03`3?XjX2o`00
01P0g<O400?o00000?3f/@3`m[400`3`m[400ol00000oooo0?ooo`1?0?ooo`00D03oool00ol00000
001m0000O@050000O@03o`000018F/80B5[200X0B5[200?o000009^=a02KSL@07@2KSL@00ol00000
/8R[0;28Z`0>0;28Z`03o`00003?XjX0cj>Z00h0cj>Z00?o00000=c7a03Lal@05`3Lal@00ol00000
l?Ja0?3f/@030?3f/@03o`00003oool0oooo0500oooo001@0?ooo`03o`00000007d0001m00D0001m
00?o000004QJ`P18F/802P18F/800ol00000Vhg409^=a00N09^=a0;o00003P2`R:/00ol00000cj>Z
0<nSZP0<0<nSZP;o00006P3Lal@00ol00000l?Ja0?3f/@030?3f/@03o`00003oool0oooo0500oooo
001@0?ooo`03o`00000007d0001m00D0001m00?o000004QJ`P18F/802`18F/800ol00000Vhg409^=
a00O09^=a003o`00002`R:/0/8R[00X0/8R[00?o00000<nSZP3?XjX0303?XjX00ol00000g<O40=c7
a00I0=c7a003o`00003`m[40l?Ja00@0l?Ja00?o00000?ooo`3oool0D03oool00540oooo00?o0000
0000O@0007d0100007d00ol00000B5[204QJ`P0;04QJ`P03o`00002KSL@0Vhg40200Vhg400?o0000
0;28Z`2`R:/02@2`R:/00ol00000cj>Z0<nSZP0:0<nSZP;o0000703Lal@00ol00000l?Ja0?3f/@04
0?3f/@03o`00003oool0oooo0500oooo001A0?ooo`03o`00000007d0001m00@0001m00?o000004QJ
`P18F/802`18F/800ol00000Vhg409^=a00Q09^=a0;o00002@2`R:/00ol00000cj>Z0<nSZP090<nS
ZP03o`00003Lal@0g<O401/0g<O400?o00000?3f/@3`m[40103`m[400ol00000oooo0?ooo`1A0?oo
o`00D@3oool00ol00000001m0000O@040000O@03o`000018F/80B5[200`0B5[200?o000009^=a02K
SL@08P2KSL@00ol00000/8R[0;28Z`060;28Z`03o`00003?XjX0cj>Z00L0cj>Z0_l0000N0=c7a003
o`00003`m[40l?Ja00@0l?Ja00?o00000?ooo`3oool0D@3oool00540oooo00?o00000000O@0007d0
0`0007d00ol00000B5[204QJ`P0=04QJ`P03o`00002KSL@0Vhg402<0Vhg400?o00000;28Z`2`R:/0
1@2`R:/00ol00000cj>Z0<nSZP060<nSZP03o`00003Lal@0g<O401d0g<O400?o00000?3f/@3`m[40
1@3`m[400ol00000oooo0?ooo`1A0?ooo`00DP3oool00ol00000001m0000O@020000O@03o`000018
F/80B5[200d0B5[200?o000009^=a02KSL@0902KSL@2o`0000D0/8R[00?o00000<nSZP3?XjX0103?
XjX2o`000200g<O400?o00000?3f/@3`m[401@3`m[400ol00000oooo0?ooo`1A0?ooo`00DP3oool0
0ol00000001m0000O@020000O@03o`000018F/80B5[200h0B5[200?o000009^=a02KSL@09@2KSL@0
0ol00000/8R[0;28Z`020;28Z`03o`00003?XjX0cj>Z0080cj>Z0_l0000Q0=c7a003o`00003`m[40
l?Ja00H0l?Ja00?o00000?ooo`3oool0D@3oool00580oooo00?o00000000O@0007d00P0007d00ol0
0000B5[204QJ`P0>04QJ`P03o`00002KSL@0Vhg402H0Vhg40_l000020;28Z`05o`00003?XjX0cj>Z
0<nSZ_l000008`3Lal@00ol00000l?Ja0?3f/@050?3f/@03o`00003oool0oooo0580oooo001B0?oo
o`03o`00000007d0001m0080001m00?o000004QJ`P18F/803P18F/800ol00000Vhg409^=a00X09^=
a004o`00002`R:_o00000<nSZP;o00008`3Lal@00ol00000l?Ja0?3f/@060?3f/@03o`00003oool0
oooo0580oooo001B0?ooo`03o`00000007d0001m0080001m00?o000004QJ`P18F/803`18F/800ol0
0000Vhg409^=a00X09^=a0?o00009@3Lal@00ol00000l?Ja0?3f/@060?3f/@03o`00003oool0oooo
0580oooo001C0?ooo`05o`00000007d0001m0000OOl000004@18F/800ol00000Vhg409^=a00X09^=
a0?o0000903Lal@00ol00000l?Ja0?3f/@070?3f/@03o`00003oool0oooo0580oooo001C0?ooo`05
o`00000007d0001m0000OOl000004P18F/800ol00000Vhg409^=a00T09^=a0?o000000<0XjoPo`00
0035cn800_l0000R0=c7a003o`00003`m[40l?Ja00H0l?Ja00?o00000?ooo`3oool0D`3oool005<0
oooo00Go00000000O@0007d0001mo`00000B04QJ`P03o`00002KSL@0Vhg40240Vhg40ol000040:>_
h004o`000035cn80aLoR0<G?hP;o00007`3Lal@00ol00000l?Ja0?3f/@070?3f/@03o`00003oool0
oooo05<0oooo001C0?ooo`05o`00000007d0001m0000OOl000004P18F/800ol00000Vhg409^=a00N
09^=a0?o00001`2S[n000ol00000aLoR0<G?hP030<G?hP;o00007@3Lal@00ol00000l?Ja0?3f/@07
0?3f/@03o`00003oool0oooo05<0oooo001D0?ooo`04o`00000007d0001mo`0001<0B5[200?o0000
09^=a02KSL@06P2KSL@3o`0000T0XjoP00?o00000<G?hP35cn801P35cn800ol00000g<O40=c7a00I
0=c7a003o`00003`m[40l?Ja00P0l?Ja00?o00000?ooo`3oool0D`3oool005@0oooo00Co00000000
O@0007go00004`18F/800ol00000Vhg409^=a00G09^=a0?o0000302S[n000ol00000aLoR0<G?hP07
0<G?hP;o00006@3Lal@00ol00000l?Ja0?3f/@070?3f/@03o`00003oool0oooo05@0oooo001D0?oo
o`04o`00000007d0001mo`0001<0B5[200?o000009^=a02KSL@0502KSL@3o`0000l0XjoP00?o0000
0<G?hP35cn802@35cn82o`0001H0g<O400?o00000?3f/@3`m[40203`m[400ol00000oooo0?ooo`1D
0?ooo`00E03oool01?l00000001m0000OOl0000D04QJ`P03o`00002KSL@0Vhg40100Vhg40ol0000B
0:>_h003o`000035cn80aLoR00/0aLoR0_l0000D0=c7a003o`00003`m[40l?Ja00P0l?Ja00?o0000
0?ooo`3oool0E03oool005@0oooo00Co00000000O@0007go00005018F/800ol00000Vhg409^=a00=
09^=a0?o00005@2S[n000ol00000aLoR0<G?hP0=0<G?hP;o00004@3Lal@00ol00000l?Ja0?3f/@09
0?3f/@03o`00003oool0oooo05@0oooo001E0?ooo`;o00005@18F/800ol00000Vhg409^=a00:09^=
a0?o0000602S[n000ol00000aLoR0<G?hP0?0<G?hP;o00003`3Lal@00ol00000l?Ja0?3f/@080?3f
/@03o`00003oool0oooo05D0oooo001E0?ooo`;o00005P18F/800ol00000Vhg409^=a00609^=a0?o
00006P2S[n000ol00000aLoR0<G?hP0B0<G?hP;o0000303Lal@00ol00000l?Ja0?3f/@090?3f/@03
o`00003oool0oooo05D0oooo001E0?ooo`;o00005P18F/800ol00000Vhg409^=a00309^=a0?o0000
7@2S[n000ol00000aLoR0<G?hP0D0<G?hP;o00002P3Lal@00ol00000l?Ja0?3f/@090?3f/@03o`00
003oool0oooo05D0oooo001E0?ooo`;o00005P18F/800ol00000Vhg409^=a003o`000200XjoP00?o
00000<G?hP35cn805P35cn800ol00000g<O40=c7a0060=c7a003o`00003`m[40l?Ja00X0l?Ja00?o
00000?ooo`3oool0E@3oool005D0oooo0_l0000A04QJ`PSo00008`2S[n000ol00000aLoR0<G?hP0G
0<G?hP;o00001P3Lal@00ol00000l?Ja0?3f/@0:0?3f/@03o`00003oool0oooo05D0oooo001F0?oo
o`03o`000018F/80B5[200<0B5[23?l0000604=oi003o`00002S[n00XjoP0280XjoP00?o00000<G?
hP35cn806@35cn82o`0000<0g<O400?o00000?3f/@3`m[402P3`m[400ol00000oooo0?ooo`1F0?oo
o`00EP3oool6o`0001<0@goT00?o00000:>_h02S[n008@2S[n000ol00000aLoR0<G?hP0K0<G?hP;o
000000<0g<O4o`00003`m[402`3`m[400ol00000oooo0?ooo`1F0?ooo`00F03oool00ol00000@goT
04=oi00E04=oi003o`00002S[n00XjoP01l0XjoP00?o00000<G?hP35cn807P35cn83o`0000/0l?Ja
00?o00000?ooo`3oool0EP3oool005T0oooo00?o000004=oi013On@05@13On@00ol00000XjoP0:>_
h00N0:>_h003o`000035cn80aLoR01d0aLoR00Co00000<Gof035omP0aOoH1Ol000060?3f/@03o`00
003oool0oooo05H0oooo001J0?ooo`;o00005@13On@00ol00000XjoP0:>_h00N0:>_h003o`000035
cn80aLoR01`0aLoR00?o00000<Gof035omP01`35omP4o`0000030?3f/Ol00000oooo05P0oooo001K
0?ooo`;o00005@13On@00ol00000XjoP0:>_h00M0:>_h003o`000035cn80aLoR01/0aLoR00?o0000
0<Gof035omP03035omP2o`0005T0oooo001M0?ooo`03o`000013On@0@goT01<0@goT00?o00000:>_
h02S[n00702S[n000ol00000aLoR0<G?hP0J0<G?hP03o`000035omP0aOoH00`0aOoH00?o00000?oo
o`3oool0F@3oool005h0oooo0_l0000C04=oi003o`00002S[n00XjoP01`0XjoP00?o00000<G?hP35
cn806@35cn800ol00000aOoH0<Gof00;0<Gof0;o0000G03oool005l0oooo0_l0000C04=oi003o`00
002S[n00XjoP01X0XjoP00?o00000<G?hP35cn806@35cn800ol00000aOoH0<Gof00;0<Gof003o`00
003oool0oooo05`0oooo001P0?ooo`;o00004`13On@00ol00000XjoP0:>_h00I0:>_h003o`000035
cn80aLoR01P0aLoR00?o00000<Gof035omP02P35omP2o`0005l0oooo001R0?ooo`;o00004P13On@0
0ol00000XjoP0:>_h00H0:>_h003o`000035cn80aLoR01L0aLoR00?o00000<Gof035omP02P35omP0
0ol00000oooo0?ooo`1O0?ooo`00H`3oool2o`000140@goT00?o00000:>_h02S[n00602S[n000ol0
0000aLoR0<G?hP0F0<G?hP03o`000035omP0aOoH00X0aOoH00?o00000?ooo`3oool0H03oool006@0
oooo0ol0000@04=oi003o`00002S[n00XjoP01L0XjoP00?o00000<G?hP35cn805@35cn800ol00000
aOoH0<Gof0090<Gof0;o0000H`3oool006D0oooo0ol0000@04=oi003o`00002S[n00XjoP01H0XjoP
00?o00000<G?hP35cn805035cn800ol00000aOoH0<Gof0090<Gof003o`00003oool0oooo06<0oooo
001W0?ooo`;o00003`13On@00ol00000XjoP0:>_h00E0:>_h003o`000035cn80aLoR01@0aLoR00?o
00000<Gof035omP02035omP2o`0006H0oooo001X0?ooo`?o00003P13On@00ol00000XjoP0:>_h00D
0:>_h003o`000035cn80aLoR01<0aLoR00?o00000<Gof035omP02035omP00ol00000oooo0?ooo`1V
0?ooo`00J@3oool00ol00000036Xo`00000>04=oi003o`00002S[n00XjoP01<0XjoP00?o00000<G?
hP35cn804P35cn800ol00000aOoH0<Gof0070<Gof0;o0000J@3oool006X0oooo0ol0000>04=oi003
o`00002S[n00XjoP0180XjoP00?o00000<G?hP35cn804@35cn800ol00000aOoH0<Gof0070<Gof003
o`00003oool0oooo06T0oooo001/0?ooo`?o00003013On@00ol00000XjoP0:>_h00B0:>_h003o`00
0035cn80aLoR0100aLoR00?o00000<Gof035omP01P35omP2o`0006`0oooo001]0?ooo`?o00003013
On@00ol00000XjoP0:>_h00A0:>_h003o`000035cn80aLoR00l0aLoR00?o00000<Gof035omP01P35
omP00ol00000oooo0?ooo`1/0?ooo`00K`3oool2o`0000`0@goT00?o00000:>_h02S[n00402S[n00
0ol00000aLoR0<G?hP0>0<G?hP03o`000035omP0aOoH00H0aOoH00?o00000?ooo`3oool0K@3oool0
0700oooo0ol0000:04=oi003o`00002S[n00XjoP00l0XjoP00?o00000<G?hP35cn803P35cn800ol0
0000aOoH0<Gof0050<Gof0;o0000L03oool00740oooo0ol0000:04=oi003o`00002S[n00XjoP00h0
XjoP00?o00000<G?hP35cn803@35cn800ol00000aOoH0<Gof0050<Gof003o`00003oool0oooo0700
oooo001c0?ooo`;o00002P13On@00ol00000XjoP0:>_h00=0:>_h003o`000035cn80aLoR00`0aLoR
00?o00000<Gof035omP01035omP2o`0007<0oooo001d0?ooo`?o00002@13On@00ol00000XjoP0:>_
h00<0:>_h003o`000035cn80aLoR00/0aLoR00?o00000<Gof035omP01035omP00ol00000oooo0?oo
o`1c0?ooo`00MP3oool2o`0000P0@goT00?o00000:>_h02S[n00302S[n000ol00000aLoR0<G?hP0:
0<G?hP03o`000035omP0aOoH00<0aOoH0_l0001f0?ooo`00M`3oool2o`0000P0@goT00?o00000:>_
h02S[n002`2S[n000ol00000aLoR0<G?hP090<G?hP03o`000035omP0aOoH00<0aOoH00?o00000?oo
o`3oool0MP3oool007P0oooo0ol0000704=oi003o`00002S[n00XjoP00T0XjoP00?o00000<G?hP35
cn802@35cn800ol00000aOoH0<Gof0020<Gof0;o0000N@3oool007X0oooo0_l0000604=oi003o`00
002S[n00XjoP00T0XjoP00?o00000<G?hP35cn802035cn800ol00000aOoH0<Gof0020<Gof003o`00
003oool0oooo07T0oooo001k0?ooo`;o00001P13On@00ol00000XjoP0:>_h0080:>_h003o`000035
cn80aLoR00L0aLoR00?o00000<Gof035omP00P35omP00ol00000oooo0?ooo`1j0?ooo`00O@3oool2
o`0000D0@goT00?o00000:>_h02S[n001`2S[n000ol00000aLoR0<G?hP060<G?hP04o`000035omP0
aOoH0<Gof0;o0000O@3oool007h0oooo0_l0000504=oi003o`00002S[n00XjoP00H0XjoP00?o0000
0<G?hP35cn801@35cn801Ol00000aOoH0<Gof035omSo000007l0oooo00200?ooo`;o00000`13On@0
0ol00000XjoP0:>_h0060:>_h003o`000035cn80aLoR00@0aLoR00?o00000<Gof035omP00_l00020
0?ooo`00P@3oool2o`0000<0@goT00?o00000:>_h02S[n00102S[n000ol00000aLoR0<G?hP040<G?
hP04o`000035omP0aOoHo`000880oooo00220?ooo`;o00000`13On@00ol00000XjoP0:>_h0030:>_
h003o`000035cn80aLoR00<0aLoR00Co00000<Gof?l0003o0000P`3oool008@0oooo0_l000000`13
OnCo00000:>_h0040:>_h003o`000035cn80aLoR0080aLoR00?o00000<Gof?l00000Q@3oool008D0
oooo0_l000000`13OnCo00000:>_h0030:>_h004o`000035cn80aLoR0<G?hP?o0000QP3oool008L0
oooo00?o000004=oi?l000000`2S[n000ol00000aLoR0<G?hP02o`0008P0oooo00280?ooo`?o0000
0P2S[n001?l00000aLoRo`000?l000290?ooo`00R@3oool2o`0000030:>_h?l00000aLoR00;o0000
RP3oool008/0oooo0ol0002<0?ooo`00S03oool00ol00000oooo0?ooo`2;0?ooo`00o`3ooolK0?oo
o`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?oo
o`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?oo
o`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?oo
o`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?oo
o`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?oo
o`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?oo
o`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?oo
o`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?oo
o`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?oo
o`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?oo
o`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?oo
o`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?oo
o`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?oo
o`00o`3ooolK0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-5.00005*^-6, -5.00005*^-6, \
0.00355875, 0.00355875}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.50377 .45486 m .60098 .40621 L .66737 .55927 L closepath p .594 .532 .754 r
F P
0 g
s
.5 .27523 m .60098 .40621 L .50377 .45486 L closepath p .633 .638 .838 r
F P
0 g
s
.50456 .57112 m .50377 .45486 L .66737 .55927 L closepath p .653 .513 .68 r
F P
0 g
s
.34123 .56184 m .50456 .57112 L .50377 .45486 L closepath p .746 .588 .68 r
F P
0 g
s
.40401 .40824 m .34123 .56184 L .50377 .45486 L closepath p .792 .691 .754 r
F P
0 g
s
.40401 .40824 m .5 .27523 L .50377 .45486 L closepath p .738 .723 .837 r
F P
0 g
s
.504 .67296 m .50456 .57112 L .66737 .55927 L closepath p .622 .367 .511 r
F P
0 g
s
.50456 .57112 m .34123 .56184 L .504 .67296 L closepath p .732 .457 .512 r
F P
0 g
s
.34123 .56184 m .39633 .67987 L .504 .67296 L closepath p .765 .387 .34 r
F P
0 g
s
.3111 .62572 m .39633 .67987 L .34123 .56184 L closepath p .863 .415 .095 r
F P
0 g
s
.34123 .56184 m .40401 .40824 L .32366 .38575 L closepath p .908 .841 .768 r
F P
0 g
s
.28124 .50193 m .32366 .38575 L .34123 .56184 L closepath p .989 .873 .623 r
F P
0 g
s
.28124 .50193 m .3111 .62572 L .34123 .56184 L closepath p .943 .61 .182 r
F P
0 g
s
.69003 .62312 m .72028 .49805 L .66737 .55927 L closepath p 0 0 .134 r
F P
0 g
s
.67733 .38198 m .72028 .49805 L .66737 .55927 L closepath p .042 .11 .609 r
F P
0 g
s
.60098 .40621 m .66737 .55927 L .67733 .38198 L closepath p .358 .4 .768 r
F P
0 g
s
.6091 .67859 m .69003 .62312 L .66737 .55927 L closepath p 0 0 .057 r
F P
0 g
s
.6091 .67859 m .504 .67296 L .66737 .55927 L closepath p .476 .149 .332 r
F P
0 g
s
.40401 .40824 m .32366 .38575 L .5 .27523 L closepath p .838 .894 .879 r
F P
0 g
s
.5 .27523 m .60098 .40621 L .67733 .38198 L closepath p .39 .537 .882 r
F P
0 g
s
.5 .75807 m .39633 .67987 L .504 .67296 L closepath p .591 .083 .011 r
F P
0 g
s
.6091 .67859 m .5 .75807 L .504 .67296 L closepath p .391 0 .002 r
F P
0 g
s
.5 .27523 m .38415 .31036 L .32366 .38575 L closepath p .747 .99 .884 r
F P
0 g
s
.49523 .29392 m .38415 .31036 L .5 .27523 L closepath p 0 0 0 r
F P
0 g
s
.61086 .30766 m .5 .27523 L .67733 .38198 L closepath p .06 .445 .878 r
F P
0 g
s
.61086 .30766 m .49523 .29392 L .5 .27523 L closepath p .277 0 0 r
F P
0 g
s
.28742 .42472 m .38415 .31036 L .32366 .38575 L closepath p .57 .832 .474 r
F P
0 g
s
.28124 .50193 m .28742 .42472 L .32366 .38575 L closepath p .819 .843 .379 r
F P
0 g
s
.3111 .62572 m .39633 .67987 L .5 .75807 L closepath p .469 0 0 r
F P
0 g
s
.70404 .42053 m .72028 .49805 L .67733 .38198 L closepath p 0 0 .324 r
F P
0 g
s
.61086 .30766 m .70404 .42053 L .67733 .38198 L closepath p .572 .091 0 r
F P
0 g
s
.6091 .67859 m .5 .75807 L .69003 .62312 L closepath p 0 0 0 r
F P
0 g
s
.3111 .62572 m .28124 .50193 L .28742 .42472 L closepath p 0 0 .321 r
F P
0 g
s
.72028 .49805 m .69003 .62312 L .70404 .42053 L closepath p .907 .836 .376 r
F P
0 g
s
.38415 .31036 m .28742 .42472 L .49523 .29392 L closepath p .28 0 .065 r
F P
0 g
s
.37335 .61763 m .5 .75807 L .3111 .62572 L closepath p .135 .439 .875 r
F P
0 g
s
.37335 .61763 m .28742 .42472 L .3111 .62572 L closepath p .12 .259 .734 r
F P
0 g
s
.61086 .30766 m .49523 .29392 L .70404 .42053 L closepath p .72 .232 .084 r
F P
0 g
s
.70404 .42053 m .62124 .6159 L .69003 .62312 L closepath p .951 .926 .743 r
F P
0 g
s
.5 .75807 m .62124 .6159 L .69003 .62312 L closepath p .821 .984 .882 r
F P
0 g
s
.49484 .56187 m .62124 .6159 L .5 .75807 L closepath p .741 .773 .879 r
F P
0 g
s
.37335 .61763 m .49484 .56187 L .5 .75807 L closepath p .592 .654 .88 r
F P
0 g
s
.49523 .29392 m .49388 .40451 L .28742 .42472 L closepath p .571 .266 .412 r
F P
0 g
s
.70404 .42053 m .49388 .40451 L .49523 .29392 L closepath p .728 .395 .416 r
F P
0 g
s
.37335 .61763 m .49484 .56187 L .28742 .42472 L closepath p .545 .51 .767 r
F P
0 g
s
.62124 .6159 m .70404 .42053 L .49484 .56187 L closepath p .819 .73 .767 r
F P
0 g
s
.49484 .56187 m .49388 .40451 L .28742 .42472 L closepath p .632 .489 .669 r
F P
0 g
s
.70404 .42053 m .49388 .40451 L .49484 .56187 L closepath p .759 .592 .67 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016R000`400?l00000o`00003ooooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00R_ooool5o`0008_ooooo0027ooooo`?o00000P00
00000ol00000AP0004H00003o`0008Sooooo0024ooooo`?o00001@0000000ol00000AP0004H00003
04H000Co0000Q?ooool0083ooooo1?l0000700000003o`0000160000AP0000P0AP000ol00021oooo
o`00OOooool3o`0000/0000000?o000004H0001600002`160004o`0007gooooo001jooooo`?o0000
2`000008o`0000d0AP000ol0001jooooo`00Moooool3o`0000L000001ol000001P17013o00000994
JOl00000^VEZo`000080^3/E2?l0000804H000?o0000Moooool007?ooooo1?l00004000000Ko0000
1P170102o`000080TTAY00?o00000;YUJP2jIFX00_l000080;Pk5@So00000`160004o`0007?ooooo
001`ooooo`?o00000P000006o`0000X0A`0@0_l000040994J@03o`00002jIFX0^VEZ0080^VEZ0_l0
000>0;Pk5@[o0000L?ooool006gooooo2?l0000?04L04003o`00002BA6T0TTAY00@0TTAY00?o0000
0;YUJP2jIFX0102jIFX00ol00000^3/E0;Pk5@0C0;Pk5@Co0000K_ooool006_ooooo0ol0000D04L0
40;o00001`2BA6T00ol00000^VEZ0;YUJP050;YUJP;o00005P2h>aD00ol0003oooooooooo`1/oooo
o`00Joooool00ol00000A`0@04L0400C04L04003o`00002BA6T0TTAY00L0TTAY00?o00000;YUJP2j
IFX01`2jIFX00ol00000^3/E0;Pk5@0D0;Pk5@03o`000?oooooooooo06_ooooo001Zooooo`03o`00
00170100A`0@0180A`0@0_l0000:0994J@03o`00002jIFX0^VEZ00P0^VEZ0_l0000E0;Pk5@03o`00
0?oooooooooo06[ooooo001Yooooo`03o`0000170100A`0@0140A`0@0_l0000<0994J@03o`00002j
IFX0^VEZ00X0^VEZ0_l0000D0;Pk5@03o`000?oooooooooo06Wooooo001Xooooo`03o`0000170100
A`0@0140A`0@00?o00000994J@2BA6T0302BA6T00ol00000^VEZ0;YUJP0<0;YUJP03o`00002h>aD0
^3/E0180^3/E00?o0000ooooooooool0J?ooool006Oooooo00?o000004L04017010040170102o`00
00l0TTAY00?o00000;YUJP2jIFX03@2jIFX2o`000180^3/E0_l0001Yooooo`00I_ooool00ol00000
A`0@04L0400@04L04003o`00002BA6T0TTAY00l0TTAY00?o00000;YUJP2jIFX03`2jIFX2o`000140
^3/E0_l0001Xooooo`00I_ooool00ol00000A`0@04L0400>04L040;o00004P2BA6T00ol00000^VEZ
0;YUJP0A0;YUJP03o`00002h>aD0^3/E00l0^3/E0_l0001Wooooo`00IOooool00ol00000A`0@04L0
400=04L040;o0000502BA6T00ol00000^VEZ0;YUJP0B0;YUJP;o0000402h>aD2o`0006Kooooo001T
ooooo`03o`0000170100A`0@00d0A`0@00?o00000994J@2BA6T0502BA6T00ol00000^VEZ0;YUJP0D
0;YUJP03o`00002h>aD0^3/E00h0^3/E0_l0001Uooooo`00Hoooool00ol00000A`0@04L0400<04L0
40;o00005`2BA6T00ol00000^VEZ0;YUJP0E0;YUJP;o00003`2h>aD2o`0006Cooooo001Rooooo`03
o`0000170100A`0@00`0A`0@00?o00000994J@2BA6T05P2BA6T00ol00000^VEZ0;YUJP0H0;YUJP;o
00003@2h>aD2o`0006Cooooo001Qooooo`03o`0000170100A`0@00/0A`0@0_l0000I0994J@03o`00
002jIFX0^VEZ01X0^VEZ00?o00000;Pk5@2h>aD02`2h>aD2o`0006?ooooo001Pooooo`03o`000017
0100A`0@00X0A`0@0_l0000K0994J@03o`00002jIFX0^VEZ01/0^VEZ0_l0000<0;Pk5@;o0000H_oo
ool0063ooooo00?o000004L0401701002@1701000ol00000TTAY0994J@0K0994J@03o`00002jIFX0
^VEZ01d0^VEZ00?o00000;Pk5@2h>aD02P2h>aD2o`00067ooooo001Oooooo`03o`0000170100A`0@
00P0A`0@0_l0000N0994J@03o`00002jIFX0^VEZ01h0^VEZ0_l0000;0;Pk5@;o0000H?ooool005ko
oooo00?o000004L040170100201701000ol00000TTAY0994J@0N0994J@03o`00002jIFX0^VEZ0200
^VEZ0_l000090;Pk5@03o`00002B5`3o000005oooooo001Mooooo`03o`0000170100A`0@00L0A`0@
0_l0000Q0994J@03o`00002jIFX0^VEZ0280^VEZ00?o00000;Pk5@2h>aD01`2h>aD00ol00000TQL0
o`00001Nooooo`00G?ooool00ol00000A`0@04L0400704L04003o`00002BA6T0TTAY0240TTAY00?o
00000;YUJP2jIFX08`2jIFX2o`0000P0^3/E00?o0000098G0?l00000GOooool005_ooooo00?o0000
04L0401701001P170102o`0002@0TTAY00?o00000;YUJP2jIFX09@2jIFX00ol00000^3/E0;Pk5@06
0;Pk5@03o`00002B5`3o000005cooooo001Kooooo`03o`0000170100A`0@00@0A`0@0_l0000V0994
J@03o`00002jIFX0^VEZ02H0^VEZ0_l000070;Pk5@03o`00002B5`3o000005_ooooo001Jooooo`03
o`0000170100A`0@00@0A`0@00?o00000994J@2BA6T09P2BA6T00ol00000^VEZ0;YUJP0X0;YUJP;o
00001@2h>aD00ol00000TQL0o`00001Kooooo`00FOooool00ol00000A`0@04L0400304L040;o0000
:@2BA6T00ol00000^VEZ0;YUJP0Z0;YUJP03o`00002h>aD0^3/E00<0^3/E00?o0000098G0?l00000
F_ooool005Sooooo00?o000004L0401701000`1701000ol00000TTAY0994J@0Y0994J@03o`00002j
IFX0^VEZ02/0^VEZ0_l000040;Pk5@03o`00002B5`3o000005Wooooo001Gooooo`03o`0000170100
A`0@0080A`0@0_l0000/0994J@03o`00002jIFX0^VEZ02d0^VEZ0_l000030;Pk5@;o0000FOooool0
05Kooooo00Co000004L040170100A`0@0_l0000^0994J@03o`00002jIFX0^VEZ02l0^VEZ00Co0000
0;Pk5@2h>aD0^3/E0_l0001Hooooo`00EOooool01Ol00000A`0@04L04017013o000002/0TTAY3?l0
000/0;YUJP;o00000P2h>aD2o`0005Oooooo001Eooooo`04o`000017013o0000o`000280TTAY2_l0
00050:5mZ`03o`000032Uj/0`YN[00@0`YN[3?l0000R0;YUJP04o`00002h>aGo0000o`0005Oooooo
001Dooooo`03o`000017013o000001/0TTAY2Ol0000?0:5mZ`03o`000032Uj/0`YN[0100`YN[3?l0
000G0;YUJPCo0000E_ooool005?ooooo0ol0000B0994J@[o0000602QOJ/00ol00000`YN[0<:GZ`0L
0<:GZ`_o00003P2jIFX2o`0005Kooooo001Booooo`;o00002P2BA6T:o`000280XGf[00?o00000<:G
Z`32Uj/09`32Uj/<o`0000@0^VEZ00?o0000ooooooooool0Doooool0057ooooo00Co00000994J@2B
A6T0TTAY2Ol0000/0:5mZ`03o`000032Uj/0`YN[03<0`YN[1_l0001Dooooo`00D?ooool5o`0003D0
XGf[00?o00000<:GZ`32Uj/0=P32Uj/00ol00000dK[4o`00001Dooooo`00D?ooool00ol00000Rh;4
o`00000g0:5mZ`03o`000032Uj/0`YN[03@0`YN[0_l000000`3A^/Co0000o`00001Dooooo`00D?oo
ool2o`00000308^2a?l0003o000003D0XGf[00?o00000<:GZ`32Uj/0<`32Uj/01?l00000dK[40=6j
a03A^/@3o`0005?ooooo001@ooooo`;o00000`2;P/@00ol00000XGf[0:5mZ`0b0:5mZ`03o`000032
Uj/0`YN[0340`YN[0_l000040=6ja0?o0000Doooool0053ooooo00?o000001i2^ol000000`2;P/@2
o`000380XGf[00?o00000<:GZ`32Uj/0<032Uj/00ol00000dK[40=6ja0030=6ja004o`00003ckKko
0000o`0005?ooooo001@ooooo`?o00001@2;P/@2o`000300XGf[00?o00000<:GZ`32Uj/0;P32Uj/2
o`0000H0dK[400Co00000??]__l0003o0000Doooool0053ooooo0ol0000708^2a003o`00002QOJ/0
XGf[02d0XGf[00?o00000<:GZ`32Uj/0;@32Uj/00ol00000dK[40=6ja0050=6ja006o`00003ckKh0
lnfno`00003XeV3o0000D_ooool0053ooooo0_l000000`0N@[_o000008^2a00608^2a0;o0000;@2Q
OJ/00ol00000`YN[0<:GZ`0[0<:GZ`;o0000203A^/@00ol00000lnfno`0000020>SFH003o`000?oo
oooooooo053ooooo001@ooooo`;o000000<07T:ko`00002;P/@0202;P/@00ol00000XGf[0:5mZ`0Z
0:5mZ`03o`000032Uj/0`YN[02X0`YN[00?o00000=6ja03A^/@01`3A^/@01?l00000lnfn0??]__l0
00020>SFH003o`000?oooooooooo053ooooo001@ooooo`;o00000P0N@[/00ol00000Rh;408^2a007
08^2a0;o0000:P2QOJ/00ol00000`YN[0<:GZ`0X0<:GZ`;o00002P3A^/@01?l00000lnfn0??]__l0
00020>SFH003o`000?oooooooooo053ooooo001@ooooo`;o00000P0N@[/00ol00000Rh;408^2a009
08^2a003o`00002QOJ/0XGf[02L0XGf[00?o00000<:GZ`32Uj/09`32Uj/00ol00000dK[40=6ja00:
0=6ja004o`00003ckKh0lnfno`0000<0j=IP00?o0000ooooooooool0Coooool0053ooooo0_l00003
01i2^`03o`00002;P/@0Rh;400T0Rh;40_l0000W0:5mZ`03o`000032Uj/0`YN[02D0`YN[0_l0000<
0=6ja005o`00003ckKh0lnfn0??]__l000000`3XeV000ol0003oooooooooo`1?ooooo`00Coooool0
0ol00000001Bo`00000301i2^`03o`00002;P/@0Rh;400/0Rh;400?o00000:5mZ`2QOJ/0902QOJ/0
0ol00000`YN[0<:GZ`0T0<:GZ`03o`00003A^/@0dK[400`0dK[400Go00000??]_P3ckKh0lnfno`00
00030>SFH003o`000?oooooooooo04oooooo001?ooooo`04o`0000000580001Bo`0000<07T:k00?o
000008^2a02;P/@02`2;P/@2o`0002@0XGf[00?o00000<:GZ`32Uj/08P32Uj/2o`0000h0dK[400?o
00000??]_P3ckKh00P3ckKh01Ol00000j=IP0>SFH03XeV3o0000057ooooo001?ooooo`04o`000000
0580001Bo`0000<07T:k00?o000008^2a02;P/@03@2;P/@2o`000280XGf[00?o00000<:GZ`32Uj/0
8@32Uj/00ol00000dK[40=6ja00>0=6ja003o`00003ckKh0lnfn0080lnfn00Go00000>SFH03XeV00
j=IPo`00001Aooooo`00Coooool01?l00000001B0000D_l0000301i2^`03o`00002;P/@0Rh;400l0
Rh;400?o00000:5mZ`2QOJ/07`2QOJ/00ol00000`YN[0<:GZ`0O0<:GZ`;o00004@3A^/@00ol00000
lnfn0??]_P020??]_P03o`00003XeV00j=IP0080j=IP00?o0000ooooooooool0C_ooool004oooooo
00Co00000000DP0005;o0000100N@[/00ol00000Rh;408^2a00?08^2a0;o00007`2QOJ/00ol00000
`YN[0<:GZ`0N0<:GZ`03o`00003A^/@0dK[40100dK[400?o00000??]_P3ckKh00`3ckKh00ol00000
j=IP0>SFH0020>SFH003o`000?oooooooooo04kooooo001?ooooo`04o`0000000580001Bo`0000@0
7T:k00?o000008^2a02;P/@04@2;P/@00ol00000XGf[0:5mZ`0M0:5mZ`03o`000032Uj/0`YN[01/0
`YN[0_l0000C0=6ja003o`00003ckKh0lnfn00<0lnfn00?o00000>SFH03XeV000P3XeV000ol0003o
ooooooooo`1>ooooo`00Coooool01?l00000001B0000D_l0000501i2^`03o`00002;P/@0Rh;40140
Rh;40_l0000M0:5mZ`03o`000032Uj/0`YN[01X0`YN[00?o00000=6ja03A^/@04P3A^/@00ol00000
lnfn0??]_P040??]_P03o`00003XeV00j=IP0080j=IP00?o0000ooooooooool0C_ooool004oooooo
00Co00000000DP0005;o00001@0N@[/00ol00000Rh;408^2a00C08^2a003o`00002QOJ/0XGf[01X0
XGf[00?o00000<:GZ`32Uj/06@32Uj/00ol00000dK[40=6ja00C0=6ja003o`00003ckKh0lnfn00@0
lnfn00?o00000>SFH03XeV000`3XeV000ol0003oooooooooo`1=ooooo`00Coooool01?l00000001B
0000D_l0000601i2^`03o`00002;P/@0Rh;401<0Rh;40_l0000J0:5mZ`03o`000032Uj/0`YN[01L0
`YN[0_l0000E0=6ja003o`00003ckKh0lnfn00D0lnfn00?o00000>SFH03XeV000`3XeV000ol0003o
ooooooooo`1=ooooo`00Coooool01Ol00000001B0000DP0005;o000000D07T:k00?o000008^2a02;
P/@05@2;P/@00ol00000XGf[0:5mZ`0G0:5mZ`03o`000032Uj/0`YN[01H0`YN[00?o00000=6ja03A
^/@05@3A^/@00ol00000lnfn0??]_P040??]_P03o`00003XeV00j=IP00@0j=IP00?o0000oooooooo
ool0COooool004oooooo00Go00000000DP000580001Bo`00000601i2^`03o`00002;P/@0Rh;401D0
Rh;40_l0000G0:5mZ`03o`000032Uj/0`YN[01@0`YN[0_l0000H0=6ja003o`00003ckKh0lnfn00@0
lnfn00?o00000>SFH03XeV00103XeV000ol0003oooooooooo`1=ooooo`00Coooool01Ol00000001B
0000DP0005;o000000H07T:k00?o000008^2a02;P/@05`2;P/@00ol00000XGf[0:5mZ`0D0:5mZ`03
o`000032Uj/0`YN[01<0`YN[00?o00000=6ja03A^/@05`3A^/@00ol00000lnfn0??]_P050??]_P03
o`00003XeV00j=IP00<0j=IP00?o0000ooooooooool0C_ooool004oooooo00Go00000000DP000580
001Bo`00000601i2^`03o`00002;P/@0Rh;401P0Rh;40_l0000D0:5mZ`03o`000032Uj/0`YN[0140
`YN[0_l0000J0=6ja003o`00003ckKh0lnfn00D0lnfn00?o00000>SFH03XeV000`3XeV000ol0003o
ooooooooo`1>ooooo`00D?ooool01?l00000001B0000D_l0000701i2^`03o`00002;P/@0Rh;401T0
Rh;40_l0000B0:5mZ`03o`000032Uj/0`YN[0100`YN[00?o00000=6ja03A^/@06@3A^/@00ol00000
lnfn0??]_P060??]_P03o`00003XeV00j=IP00<0j=IP00?o0000ooooooooool0C_ooool0053ooooo
00Co00000000DP0005;o00001`0N@[/00ol00000Rh;408^2a00K08^2a003o`00002QOJ/0XGf[00l0
XGf[00?o00000<:GZ`32Uj/03P32Uj/2o`0001`0dK[400?o00000??]_P3ckKh01P3ckKh00ol00000
j=IP0>SFH0030>SFH003o`000?oooooooooo04kooooo001@ooooo`04o`0000000580001Bo`0000P0
7T:k00?o000008^2a02;P/@06`2;P/@2o`0000l0XGf[00?o00000<:GZ`32Uj/03@32Uj/00ol00000
dK[40=6ja00K0=6ja003o`00003ckKh0lnfn00L0lnfn00?o00000>SFH03XeV000P3XeV000ol0003o
ooooooooo`1?ooooo`00D?ooool01?l00000001B0000D_l0000801i2^`03o`00002;P/@0Rh;401d0
Rh;400?o00000:5mZ`2QOJ/0302QOJ/00ol00000`YN[0<:GZ`0;0<:GZ`;o00007P3A^/@00ol00000
lnfn0??]_P070??]_P03o`00003XeV00j=IP0080j=IP00?o0000ooooooooool0Coooool0057ooooo
00Co00000000DP0005;o0000200N@[/00ol00000Rh;408^2a00M08^2a0;o0000302QOJ/00ol00000
`YN[0<:GZ`0:0<:GZ`03o`00003A^/@0dK[401h0dK[400?o00000??]_P3ckKh01`3ckKh00ol00000
j=IP0>SFH0020>SFH003o`000?oooooooooo04oooooo001Aooooo`04o`0000000580001Bo`0000P0
7T:k00?o000008^2a02;P/@07`2;P/@00ol00000XGf[0:5mZ`090:5mZ`03o`000032Uj/0`YN[00P0
`YN[0_l0000P0=6ja003o`00003ckKh0lnfn00P0lnfn00?o00000>SFH03XeV000P3XeV000ol0003o
ooooooooo`1?ooooo`00DOooool01?l00000001B0000D_l0000901i2^`03o`00002;P/@0Rh;401l0
Rh;40_l000090:5mZ`03o`000032Uj/0`YN[00L0`YN[00?o00000=6ja03A^/@0803A^/@00ol00000
lnfn0??]_P080??]_P05o`00003XeV00j=IP0>SFH?l00000D_ooool0057ooooo00Co00000000DP00
05;o00002@0N@[/00ol00000Rh;408^2a00Q08^2a003o`00002QOJ/0XGf[00H0XGf[00?o00000<:G
Z`32Uj/01@32Uj/2o`000280dK[400?o00000??]_P3ckKh02@3ckKh01Ol00000j=IP0>SFH03XeV3o
000005;ooooo001Aooooo`04o`0000000580001Bo`0000T07T:k00?o000008^2a02;P/@08P2;P/@2
o`0000H0XGf[00?o00000<:GZ`32Uj/01032Uj/00ol00000dK[40=6ja00R0=6ja003o`00003ckKh0
lnfn00T0lnfn00Go00000>SFH03XeV00j=IPo`00001Booooo`00D_ooool00ol00000001Bo`00000:
01i2^`03o`00002;P/@0Rh;402<0Rh;40_l000040:5mZ`03o`000032Uj/0`YN[0080`YN[0_l0000U
0=6ja003o`00003ckKh0lnfn00T0lnfn00Go00000>SFH03XeV00j=IPo`00001Booooo`00D_ooool0
0ol00000001Bo`00000:01i2^`03o`00002;P/@0Rh;402D0Rh;400Go00000:5mZ`2QOJ/0XGf[o`00
00030<:GZ`03o`00003A^/@0dK[402@0dK[400?o00000??]_P3ckKh02P3ckKh01?l00000j=IP0>SF
H?l0001Cooooo`00D_ooool00ol00000001Bo`00000;01i2^`03o`00002;P/@0Rh;402D0Rh;40_l0
00000`2QOJ_o00000<:GZ`02o`0002L0dK[400?o00000??]_P3ckKh02@3ckKh01Ol00000j=IP0>SF
H03XeV3o000005?ooooo001Booooo`04o`0000000580001Bo`0000X07T:k00?o000008^2a02;P/@0
9`2;P/@3o`0002P0dK[400?o00000??]_P3ckKh02P3ckKh01Ol00000j=IP0>SFH03XeV3o000005?o
oooo001Cooooo`03o`00000005;o000000/07T:k00?o000008^2a02;P/@09P2;P/@3o`0002P0dK[4
00?o00000??]_P3ckKh02P3ckKh01Ol00000j=IP0>SFH03XeV3o000005?ooooo001Cooooo`03o`00
000005;o000000/07T:k00?o000008^2a02;P/@0902;P/@2o`00000309NWhOl00000_LGQ00;o0000
9@3A^/@00ol00000lnfn0??]_P0;0??]_P04o`00003XeV00j=IPo`0005Cooooo001Cooooo`03o`00
000005;o000000`07T:k00?o000008^2a02;P/@08@2;P/@2o`0000<0UjOQ00Co00000;g5h@2maN40
_LGQ0_l0000S0=6ja003o`00003ckKh0lnfn00/0lnfn00Co00000>SFH03XeV3o0000E?ooool005?o
oooo00?o00000000D_l00000300N@[/00ol00000Rh;408^2a00N08^2a0?o00001@2GYn400ol00000
_LGQ0;g5h@030;g5h@?o0000803A^/@00ol00000lnfn0??]_P0;0??]_P04o`00003XeV00j=IPo`00
05Cooooo001Dooooo`;o0000300N@[/00ol00000Rh;408^2a00L08^2a0;o0000202GYn400ol00000
_LGQ0;g5h@060;g5h@;o00007@3A^/@00ol00000lnfn0??]_P0<0??]_P04o`00003XeV00j=IPo`00
05Cooooo001Dooooo`;o00003@0N@[/00ol00000Rh;408^2a00I08^2a0;o00002P2GYn400ol00000
_LGQ0;g5h@080;g5h@;o00006`3A^/@00ol00000lnfn0??]_P0<0??]_P03o`00003XeV3o000005Go
oooo001Dooooo`;o00003@0N@[/00ol00000Rh;408^2a00G08^2a0;o0000302GYn400ol00000_LGQ
0;g5h@0:0;g5h@;o0000603A^/@00ol00000lnfn0??]_P0=0??]_P03o`00003XeV3o000005Gooooo
001Dooooo`03o`00000005;o000000d07T:k00?o000008^2a02;P/@0502;P/@2o`0000h0UjOQ00?o
00000;g5h@2maN40302maN42o`0001H0dK[400?o00000??]_P3ckKh03@3ckKh00ol00000j=IPo`00
001Eooooo`00EOooool2o`0000d07T:k00?o000008^2a02;P/@04@2;P/@3o`000100UjOQ00?o0000
0;g5h@2maN403P2maN43o`0001<0dK[400?o00000??]_P3ckKh03@3ckKh00ol00000j=IPo`00001E
ooooo`00EOooool2o`0000h07T:k00?o000008^2a02;P/@03P2;P/@2o`0001<0UjOQ00?o00000;g5
h@2maN404@2maN42o`000100dK[400?o00000??]_P3ckKh03P3ckKh2o`0005Kooooo001Eooooo`;o
00003P0N@[/00ol00000Rh;408^2a00<08^2a0;o00005@2GYn400ol00000_LGQ0;g5h@0C0;g5h@;o
00003P3A^/@00ol00000lnfn0??]_P0>0??]_P;o0000E_ooool005Gooooo0_l0000?01i2^`03o`00
002;P/@0Rh;400T0Rh;40_l0000G09NWh@03o`00002maN40_LGQ01D0_LGQ0_l0000;0=6ja003o`00
003ckKh0lnfn00l0lnfn0_l0001Fooooo`00EOooool2o`0000l07T:k00?o000008^2a02;P/@01`2;
P/@2o`0001T0UjOQ00?o00000;g5h@2maN405`2maN42o`0000T0dK[400?o00000??]_P3ckKh03P3c
kKh00ol00000j=IPo`00001Fooooo`00E_ooool00ol000007T:k01i2^`0=01i2^`03o`00002;P/@0
Rh;400@0Rh;40ol0000K09NWh@03o`00002maN40_LGQ01T0_LGQ0ol000050=6ja003o`00003ckKh0
lnfn00l0lnfn0_l0001Gooooo`00E_ooool00ol000007T:k01i2^`0>01i2^`04o`00002;P/@0Rh;4
08^2a0;o00007P2GYn400ol00000_LGQ0;g5h@0L0;g5h@;o00000`3A^/@00ol00000lnfn0??]_P0?
0??]_P;o0000Eoooool005Kooooo0_l0000?01i2^`04o`00002;P/Co0000o`000200UjOQ00?o0000
0;g5h@2maN407P2maN42o`0000030=6ja?l00000lnfn0100lnfn0_l0001Gooooo`00E_ooool2o`00
00`07T:k1Ol0000R09NWh@03o`00002maN40_LGQ0200_LGQ1_l0000=0??]_P;o0000Eoooool005Oo
oooo00Co000001i2^`0N@[/07T:k2Ol00004029`g`03o`00002GYn40UjOQ0200UjOQ00?o00000;g5
h@2maN40802maN400ol00000d__Q0=;kh@030=;kh@Wo0000103ckKh00ol0003oooooooooo`1Foooo
o`00Eoooool4o`0000h08W3O00?o000009NWh@2GYn407`2GYn400ol00000_LGQ0;g5h@0O0;g5h@03
o`00003Bnn40d__Q00d0d__Q1Ol0001Hooooo`00FOooool00ol000008W3O029`g`0>029`g`03o`00
002GYn40UjOQ01h0UjOQ00?o00000;g5h@2maN407P2maN400ol00000d__Q0=;kh@0@0=;kh@03o`00
0?oooooooooo05Sooooo001Jooooo`03o`00000RL=l08W3O00h08W3O00?o000009NWh@2GYn407@2G
Yn400ol00000_LGQ0;g5h@0M0;g5h@03o`00003Bnn40d__Q0100d__Q00?o0000ooooooooool0FOoo
ool005_ooooo0_l0000?029`g`03o`00002GYn40UjOQ01`0UjOQ00?o00000;g5h@2maN40702maN40
0ol00000d__Q0=;kh@0?0=;kh@;o0000G?ooool005gooooo00?o0000029`g`0RL=l03@0RL=l00ol0
0000UjOQ09NWh@0K09NWh@03o`00002maN40_LGQ01/0_LGQ00?o00000=;kh@3Bnn403`3Bnn400ol0
003oooooooooo`1Looooo`00G_ooool2o`0000h08W3O00?o000009NWh@2GYn406P2GYn400ol00000
_LGQ0;g5h@0J0;g5h@03o`00003Bnn40d__Q00h0d__Q0_l0001Oooooo`00H?ooool00ol000008W3O
029`g`0<029`g`03o`00002GYn40UjOQ01T0UjOQ00?o00000;g5h@2maN406P2maN400ol00000d__Q
0=;kh@0=0=;kh@03o`000?oooooooooo05oooooo001Qooooo`03o`00000RL=l08W3O00`08W3O00?o
000009NWh@2GYn40602GYn400ol00000_LGQ0;g5h@0I0;g5h@03o`00003Bnn40d__Q00d0d__Q00?o
0000ooooooooool0H?ooool006;ooooo0_l0000=029`g`03o`00002GYn40UjOQ01L0UjOQ00?o0000
0;g5h@2maN40602maN400ol00000d__Q0=;kh@0<0=;kh@;o0000Hoooool006Cooooo00?o0000029`
g`0RL=l02P0RL=l00ol00000UjOQ09NWh@0G09NWh@03o`00002maN40_LGQ01L0_LGQ00?o00000=;k
h@3Bnn40303Bnn400ol0003oooooooooo`1Sooooo`00IOooool2o`0000/08W3O00?o000009NWh@2G
Yn405P2GYn400ol00000_LGQ0;g5h@0F0;g5h@03o`00003Bnn40d__Q00/0d__Q0_l0001Vooooo`00
Ioooool00ol000008W3O029`g`09029`g`03o`00002GYn40UjOQ01H0UjOQ00?o00000;g5h@2maN40
502maN400ol00000d__Q0=;kh@0;0=;kh@03o`000?oooooooooo06Kooooo001Xooooo`03o`00000R
L=l08W3O00T08W3O00?o000009NWh@2GYn405@2GYn400ol00000_LGQ0;g5h@0D0;g5h@03o`00003B
nn40d__Q00X0d__Q00?o0000ooooooooool0Ioooool006Wooooo0_l0000:029`g`03o`00002GYn40
UjOQ01@0UjOQ00?o00000;g5h@2maN404`2maN400ol00000d__Q0=;kh@090=;kh@;o0000J_ooool0
06_ooooo00?o0000029`g`0RL=l0200RL=l00ol00000UjOQ09NWh@0C09NWh@03o`00002maN40_LGQ
0180_LGQ00?o00000=;kh@3Bnn402@3Bnn400ol0003oooooooooo`1Zooooo`00K?ooool2o`0000T0
8W3O00?o000009NWh@2GYn404P2GYn400ol00000_LGQ0;g5h@0A0;g5h@03o`00003Bnn40d__Q00P0
d__Q0_l0001]ooooo`00K_ooool00ol000008W3O029`g`07029`g`03o`00002GYn40UjOQ0140UjOQ
00?o00000;g5h@2maN40402maN400ol00000d__Q0=;kh@080=;kh@03o`000?oooooooooo06gooooo
001_ooooo`03o`00000RL=l08W3O00L08W3O00?o000009NWh@2GYn40402GYn400ol00000_LGQ0;g5
h@0?0;g5h@03o`00003Bnn40d__Q00P0d__Q00?o0000ooooooooool0K_ooool0073ooooo0_l00008
029`g`03o`00002GYn40UjOQ00l0UjOQ00?o00000;g5h@2maN403P2maN400ol00000d__Q0=;kh@07
0=;kh@;o0000LOooool007;ooooo00?o0000029`g`0RL=l01@0RL=l00ol00000UjOQ09NWh@0?09NW
h@03o`00002maN40_LGQ00h0_LGQ00?o00000=;kh@3Bnn401P3Bnn400ol0003oooooooooo`1aoooo
o`00Loooool2o`0000H08W3O00?o000009NWh@2GYn403P2GYn400ol00000_LGQ0;g5h@0=0;g5h@03
o`00003Bnn40d__Q00D0d__Q0_l0001dooooo`00MOooool00ol000008W3O029`g`04029`g`03o`00
002GYn40UjOQ00d0UjOQ00?o00000;g5h@2maN40302maN400ol00000d__Q0=;kh@050=;kh@03o`00
0?oooooooooo07Cooooo001fooooo`03o`00000RL=l08W3O00@08W3O00?o000009NWh@2GYn40302G
Yn400ol00000_LGQ0;g5h@0;0;g5h@03o`00003Bnn40d__Q00D0d__Q00?o0000ooooooooool0MOoo
ool007Oooooo0_l00005029`g`03o`00002GYn40UjOQ00/0UjOQ00?o00000;g5h@2maN402P2maN40
0ol00000d__Q0=;kh@040=;kh@;o0000N?ooool007Wooooo00?o0000029`g`0RL=l00`0RL=l00ol0
0000UjOQ09NWh@0:09NWh@03o`00002maN40_LGQ00T0_LGQ00?o00000=;kh@3Bnn40103Bnn400ol0
003oooooooooo`1hooooo`00N_ooool2o`0000@08W3O00?o000009NWh@2GYn402@2GYn400ol00000
_LGQ0;g5h@080;g5h@03o`00003Bnn40d__Q00<0d__Q0_l0001kooooo`00O?ooool00ol000008W3O
029`g`02029`g`03o`00002GYn40UjOQ00P0UjOQ00?o00000;g5h@2maN40202maN400ol00000d__Q
0=;kh@020=;kh@03o`000?oooooooooo07_ooooo001mooooo`03o`00000RL=l08W3O00808W3O00?o
000009NWh@2GYn401`2GYn400ol00000_LGQ0;g5h@070;g5h@03o`00003Bnn40d__Q0080d__Q00?o
0000ooooooooool0O?ooool007kooooo0_l00003029`g`03o`00002GYn40UjOQ00H0UjOQ00?o0000
0;g5h@2maN401P2maN401?l00000d__Q0=;kh@3Bnn42o`0007oooooo0020ooooo`04o`00000RL=l0
8W3Oo`0000P0UjOQ00?o00000;g5h@2maN401@2maN401Ol00000d__Q0=;kh@3Bnn7o0000087ooooo
0021ooooo`;o000000<08W3Oo`00002GYn401P2GYn400ol00000_LGQ0;g5h@040;g5h@03o`00003B
nn40d__Q00;o0000P_ooool008?ooooo00?o0000029`gol000001P2GYn400ol00000_LGQ0;g5h@03
0;g5h@04o`00003Bnn40d__Qo`0008Cooooo0024ooooo`03o`00000RL=oo000000D0UjOQ00?o0000
0;g5h@2maN400`2maN400ol00000d__Qo`000025ooooo`00QOooool3o`0000@0UjOQ00?o00000;g5
h@2maN400P2maN43o`0008Kooooo0027ooooo`;o00000`2GYn401?l00000_LGQ0;g5h@2maN42o`00
08Sooooo0028ooooo`;o00000P2GYn400ol00000_LGQ0;g5h@02o`0008Wooooo002:ooooo`05o`00
002GYn7o00000;g5hOl00000Roooool008_ooooo0ol0002<ooooo`00S?ooool00ol0003ooooooooo
o`2;ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooo
oolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooo
oolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooo
oolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooo
oolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooo
oolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooo
oolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooo
oolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooo
oolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooo
oolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooo
oolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooo
oolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooo
oolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooo
oolKooooo`00oooooolKooooo`00oooooolKooooo`00\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-5.00005*^-6, -5.00005*^-6, \
0.00355875, 0.00355875}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.53124 .45363 m .61766 .39786 L .69667 .54859 L closepath p .544 .501 .758 r
F P
0 g
s
.5 .27523 m .61766 .39786 L .53124 .45363 L closepath p .598 .618 .842 r
F P
0 g
s
.53784 .56992 m .53124 .45363 L .69667 .54859 L closepath p .606 .478 .68 r
F P
0 g
s
.37465 .56997 m .53784 .56992 L .53124 .45363 L closepath p .706 .555 .68 r
F P
0 g
s
.42372 .41472 m .37465 .56997 L .53124 .45363 L closepath p .758 .658 .751 r
F P
0 g
s
.42372 .41472 m .5 .27523 L .53124 .45363 L closepath p .712 .698 .834 r
F P
0 g
s
.37465 .56997 m .41768 .68394 L .53323 .67212 L closepath p .722 .358 .36 r
F P
0 g
s
.31871 .63494 m .41768 .68394 L .37465 .56997 L closepath p .856 .428 .203 r
F P
0 g
s
.53784 .56992 m .37465 .56997 L .53323 .67212 L closepath p .686 .42 .514 r
F P
0 g
s
.37465 .56997 m .42372 .41472 L .33052 .39916 L closepath p .878 .795 .764 r
F P
0 g
s
.29076 .51562 m .33052 .39916 L .37465 .56997 L closepath p .965 .824 .653 r
F P
0 g
s
.29076 .51562 m .31871 .63494 L .37465 .56997 L closepath p .959 .624 .316 r
F P
0 g
s
.53323 .67212 m .53784 .56992 L .69667 .54859 L closepath p .564 .318 .502 r
F P
0 g
s
.42372 .41472 m .33052 .39916 L .5 .27523 L closepath p .828 .857 .868 r
F P
0 g
s
.5 .27523 m .61766 .39786 L .67754 .36786 L closepath p .318 .516 .892 r
F P
0 g
s
.61766 .39786 m .69667 .54859 L .67754 .36786 L closepath p .253 .348 .768 r
F P
0 g
s
.69054 .61338 m .72166 .48345 L .69667 .54859 L closepath p 0 0 0 r
F P
0 g
s
.67754 .36786 m .72166 .48345 L .69667 .54859 L closepath p 0 0 .529 r
F P
0 g
s
.62724 .67334 m .69054 .61338 L .69667 .54859 L closepath p 0 0 0 r
F P
0 g
s
.62724 .67334 m .53323 .67212 L .69667 .54859 L closepath p .387 .066 .295 r
F P
0 g
s
.5 .75807 m .41768 .68394 L .53323 .67212 L closepath p .552 .057 .033 r
F P
0 g
s
.62724 .67334 m .5 .75807 L .53323 .67212 L closepath p .302 0 0 r
F P
0 g
s
.5 .27523 m .36864 .32105 L .33052 .39916 L closepath p .804 .981 .896 r
F P
0 g
s
.46059 .29588 m .36864 .32105 L .5 .27523 L closepath p 0 0 0 r
F P
0 g
s
.59003 .29883 m .5 .27523 L .67754 .36786 L closepath p 0 .41 .838 r
F P
0 g
s
.59003 .29883 m .46059 .29588 L .5 .27523 L closepath p .24 0 0 r
F P
0 g
s
.2618 .44114 m .36864 .32105 L .33052 .39916 L closepath p .783 .954 .626 r
F P
0 g
s
.29076 .51562 m .2618 .44114 L .33052 .39916 L closepath p .958 .903 .53 r
F P
0 g
s
.31871 .63494 m .41768 .68394 L .5 .75807 L closepath p .568 0 0 r
F P
0 g
s
.31871 .63494 m .29076 .51562 L .2618 .44114 L closepath p .77 .486 0 r
F P
0 g
s
.62724 .67334 m .5 .75807 L .69054 .61338 L closepath p .568 .912 .695 r
F P
0 g
s
.66737 .40657 m .72166 .48345 L .67754 .36786 L closepath p .804 .433 0 r
F P
0 g
s
.59003 .29883 m .66737 .40657 L .67754 .36786 L closepath p .702 .183 0 r
F P
0 g
s
.35658 .62451 m .5 .75807 L .31871 .63494 L closepath p 0 .363 .831 r
F P
0 g
s
.35658 .62451 m .2618 .44114 L .31871 .63494 L closepath p 0 .13 .672 r
F P
0 g
s
.36864 .32105 m .2618 .44114 L .46059 .29588 L closepath p .109 0 0 r
F P
0 g
s
.72166 .48345 m .69054 .61338 L .66737 .40657 L closepath p .992 .865 .523 r
F P
0 g
s
.59003 .29883 m .46059 .29588 L .66737 .40657 L closepath p .672 .204 .133 r
F P
0 g
s
.66737 .40657 m .59857 .6102 L .69054 .61338 L closepath p .927 .87 .762 r
F P
0 g
s
.5 .75807 m .59857 .6102 L .69054 .61338 L closepath p .834 .95 .894 r
F P
0 g
s
.45738 .56325 m .59857 .6102 L .5 .75807 L closepath p .706 .738 .876 r
F P
0 g
s
.35658 .62451 m .45738 .56325 L .5 .75807 L closepath p .538 .623 .884 r
F P
0 g
s
.46059 .29588 m .44949 .40666 L .2618 .44114 L closepath p .48 .188 .391 r
F P
0 g
s
.66737 .40657 m .44949 .40666 L .46059 .29588 L closepath p .664 .344 .421 r
F P
0 g
s
.45738 .56325 m .44949 .40666 L .2618 .44114 L closepath p .565 .438 .666 r
F P
0 g
s
.35658 .62451 m .45738 .56325 L .2618 .44114 L closepath p .467 .461 .768 r
F P
0 g
s
.59857 .6102 m .66737 .40657 L .45738 .56325 L closepath p .775 .686 .766 r
F P
0 g
s
.66737 .40657 m .44949 .40666 L .45738 .56325 L closepath p .706 .547 .67 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016R000`400?l00000o`00003ooooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00Roooool4o`0008_ooooo0028ooooo`?o0000100m
0004o`0008Oooooo0025ooooo`Co00002P0m0004o`0008?ooooo0022ooooo`?o000000<00000o`00
000m00003`0m0005o`0007kooooo001oooooo`?o00000P000002o`0001H0?@001?l0001jooooo`00
O?ooool3o`0000<000000_l0000L03d000Co0000M_ooool007Wooooo0ol00003000002So0000Looo
ool007Oooooo0_l00002000000Go000000<0NS1To`00002YF6/00_l0000P0:`d8P03o`00002c;P3o
000007;ooooo001dooooo`?o000000@00000o`000?l0003o00000P0K0002o`000080NS1T00Co0000
0:UHJ`2YF6/0ZEQ[0_l0000O0:`d8P03o`00002c;P3o0000077ooooo001aooooo`Oo0000100K0000
0ol00000NS1T07X`I00207X`I003o`00002YF6/0ZEQ[00<0ZEQ[0_l0000N0:`d8P03o`00002c;P3o
0000073ooooo001^ooooo`Ko00001`0K00000ol00000NS1T07X`I00307X`I003o`00002YF6/0ZEQ[
00D0ZEQ[00?o00000:`d8P2/=2806`2/=2800ol00000/bh00;<^0002o`0006kooooo001[ooooo`Go
00002@0K0002o`0000H0NS1T00?o00000:UHJ`2YF6/01P2YF6/2o`0001`0[3@R00Go00000;<^002c
;P00/bh0o`00001]ooooo`00J?ooool5o`0000/06`0000?o000007X`I01j<6@01@1j<6@00ol00000
ZEQ[0:UHJ`090:UHJ`;o00006`2/=2801Ol00000/bh00;<^002c;P3o000006cooooo001Wooooo`;o
00003@0K0002o`0000P0NS1T00?o00000:UHJ`2YF6/02`2YF6/2o`0001X0[3@R00Go00000;<^002c
;P00/bh0o`00001[ooooo`00Ioooool00ol000006`0001/0000;01/00003o`00001j<6@0NS1T00P0
NS1T00?o00000:UHJ`2YF6/03@2YF6/2o`0001P0[3@R00?o00000;<^002c;P000P2c;P02o`0006Wo
oooo001Vooooo`03o`00000K00006`0000/06`0000?o000007X`I01j<6@02@1j<6@00ol00000ZEQ[
0:UHJ`0?0:UHJ`;o00005`2/=2800ol00000/bh00;<^00030;<^0003o`000?oooooooooo06Kooooo
001Uooooo`03o`00000K00006`0000X06`000_l0000<07X`I003o`00002YF6/0ZEQ[0140ZEQ[0_l0
000F0:`d8P03o`00002c;P00/bh000<0/bh000?o0000ooooooooool0IOooool006Cooooo00?o0000
01/0000K00002P0K00000ol00000NS1T07X`I00<07X`I003o`00002YF6/0ZEQ[01<0ZEQ[0_l0000D
0:`d8P03o`00002c;P00/bh000@0/bh000?o0000ooooooooool0I?ooool006?ooooo00?o000001/0
000K00002@0K0002o`0000l0NS1T00?o00000:UHJ`2YF6/05@2YF6/00ol00000[3@R0:`d8P0B0:`d
8P03o`00002c;P00/bh000@0/bh00_l0001Tooooo`00H_ooool00ol000006`0001/0000901/00003
o`00001j<6@0NS1T00l0NS1T00?o00000:UHJ`2YF6/05P2YF6/2o`0001<0[3@R00?o00000;<^002c
;P001@2c;P000ol0003oooooooooo`1Qooooo`00HOooool00ol000006`0001/0000901/00003o`00
001j<6@0NS1T0100NS1T00?o00000:UHJ`2YF6/0602YF6/2o`000180[3@R00?o00000;<^002c;P00
1@2c;P000ol0003oooooooooo`1Pooooo`00H?ooool00ol000006`0001/0000801/000;o00004`1j
<6@00ol00000ZEQ[0:UHJ`0J0:UHJ`;o0000402/=2800ol00000/bh00;<^00060;<^0003o`000?oo
oooooooo05oooooo001Oooooo`03o`00000K00006`0000P06`0000?o000007X`I01j<6@04P1j<6@0
0ol00000ZEQ[0:UHJ`0M0:UHJ`;o00003`2/=2800ol00000/bh00;<^00060;<^00;o0000Goooool0
05kooooo00?o000001/0000K00001`0K0002o`0001D0NS1T00?o00000:UHJ`2YF6/07`2YF6/2o`00
00h0[3@R00?o00000;<^002c;P001`2c;P000ol0003oooooooooo`1Looooo`00GOooool00ol00000
6`0001/0000701/00003o`00001j<6@0NS1T01D0NS1T00?o00000:UHJ`2YF6/08@2YF6/2o`0000`0
[3@R00?o00000;<^002c;P00202c;P000ol0003oooooooooo`1Kooooo`00GOooool00ol000006`00
01/0000601/00003o`00001j<6@0NS1T01H0NS1T00?o00000:UHJ`2YF6/08`2YF6/00ol00000[3@R
0:`d8P0:0:`d8P03o`00002c;P00/bh000P0/bh000?o0000ooooooooool0F_ooool005cooooo00?o
000001/0000K00001@0K0002o`0001T0NS1T00?o00000:UHJ`2YF6/0902YF6/2o`0000/0[3@R00?o
00000;<^002c;P00202c;P000ol0003oooooooooo`1Iooooo`00Foooool00ol000006`0001/00005
01/00003o`00001j<6@0NS1T01T0NS1T00?o00000:UHJ`2YF6/09P2YF6/2o`0000X0[3@R00?o0000
0;<^002c;P001`2c;P000ol0003oooooooooo`1Iooooo`00F_ooool00ol000006`0001/0000401/0
00;o0000701j<6@00ol00000ZEQ[0:UHJ`0X0:UHJ`;o0000202/=2800ol00000/bh00;<^00070;<^
00;o0000F_ooool005Wooooo00?o000001/0000K0000100K00000ol00000NS1T07X`I00L07X`I003
o`00002YF6/0ZEQ[02X0ZEQ[0_l000070:`d8P03o`00002c;P00/bh000D0/bh000?o00000<e^0?l0
0000F_ooool005Sooooo00?o000001/0000K0000100K00000ol00000NS1T07X`I00M07X`I003o`00
002YF6/0ZEQ[02`0ZEQ[0_l000060:`d8P03o`00002c;P00/bh000@0/bh000?o00000<e^0?l00000
F_ooool005Oooooo00?o000001/0000K00000`0K0002o`000200NS1T00?o00000:UHJ`2YF6/0;P2Y
F6/2o`0000@0[3@R00?o00000;<^002c;P00102c;P001?l00000cFh00<e^0?l0001Iooooo`00E_oo
ool00ol000006`0001/0000301/00003o`00001j<6@0NS1T0200NS1T00?o00000:UHJ`2YF6/0<02Y
F6/2o`0000<0[3@R00?o00000;<^002c;P000P2c;P001Ol00000cFh00<e^003=KP3o000005Wooooo
001Eooooo`03o`00000K00006`0000806`000_l0000R07X`I003o`00002YF6/0ZEQ[03<0ZEQ[00Go
00000:`d8P2/=280[3@Ro`0000030;<^0005o`00003=KP00cFh00<e^0?l00000FOooool005Cooooo
00?o000001/0000K00000P0K00000ol00000NS1T07X`I00R07X`I003o`00002YF6/0ZEQ[03@0ZEQ[
0_l000020:`d8P04o`00002c;P00/bh0o`0000@0cFh000?o0000ooooooooool0E_ooool005?ooooo
00?o000001/0000K00000P0K00000ol00000NS1T07X`I00S07X`I003o`00002YF6/0ZEQ[03H0ZEQ[
0ol000020;<^0003o`00003=KP00cFh00080cFh000?o0000ooooooooool0E_ooool005?ooooo00?o
000001/0000K00000_l0000V07X`I003o`00002YF6/0ZEQ[03P0ZEQ[0ol000060<e^0003o`000?oo
oooooooo05Gooooo001Booooo`04o`00000K00006`00o`0002D0NS1T@Ol000060<e^0003o`000?oo
oooooooo05Gooooo001Aooooo`04o`00000K003o0000o`000200NS1T1_l00003091`ZP03o`00002d
S:/0]8b[03P0]8b[00?o00000<J_a?l000001P3=KP000ol0003oooooooooo`1Eooooo`00D?ooool0
0ol000006`00o`00000L07X`I0Ko00002@2@L:X00ol00000]8b[0;B<Z`0g0;B<Z`03o`000036[lCo
000000;o00001P3=KP000ol0003oooooooooo`1Dooooo`00Coooool00ol000006`00o`00000G07X`
I0Ko00003`2@L:X00ol00000]8b[0;B<Z`0e0;B<Z`;o00000P36[l@2o`0000030?gMQOl00000cFh0
00@0cFh000?o0000ooooooooool0E?ooool004kooooo0ol0000B07X`I0Ko00005@2@L:X00ol00000
]8b[0;B<Z`0d0;B<Z`03o`000036[l@0aZo40080aZo40_l000020?gMQ@03o`00003=KP00cFh00080
cFh000?o0000ooooooooool0E?ooool004gooooo0_l0000?07X`I0Go00006`2@L:X00ol00000]8b[
0;B<Z`0c0;B<Z`03o`000036[l@0aZo40080aZo400Ko00000>gN``3]g/?o00000?gMQOl000050<e^
0003o`000?oooooooooo05?ooooo001<ooooo`;o00002P1j<6@6o`000200T72Z00?o00000;B<Z`2d
S:/0<@2dS:/2o`0000D0aZo400Co00000>gN``3]g/?o00000P3mgHD00ol00000cFh00<e^00020<e^
0003o`000?oooooooooo05?ooooo001;ooooo`03o`00001j<6@0NS1T00@0NS1T1_l0000V091`ZP03
o`00002dS:/0]8b[0300]8b[00?o00000<J_a036[l@01@36[l@01?l00000kMk30>gN`ol000030?gM
Q@03o`00003=KP00cFh00080cFh000?o0000ooooooooool0D_ooool004[ooooo00?o000007X`I?l0
00001Ol0000/091`ZP03o`00002dS:/0]8b[02l0]8b[00?o00000<J_a036[l@01@36[l@01Ol00000
kMk30>gN``3]g/?o000000<0oMf500?o00000<e^003=KP000P3=KP000ol0003oooooooooo`1Boooo
o`00BOooool3o`000380T72Z00?o00000;B<Z`2dS:/0;@2dS:/2o`0000P0aZo400Go00000>gN``3]
g/<0kMk3o`0000040?gMQ@05o`00003=KP00cFh00<e^0?l00000E?ooool004Wooooo00?o000007Mf
a?l00000<P2@L:X00ol00000]8b[0;B<Z`0/0;B<Z`03o`000036[l@0aZo400P0aZo400Go00000>gN
``3]g/<0kMk3o`0000050?gMQ@05o`00003=KP00cFh00<e^0?l00000Doooool004Wooooo0_l00000
0`1gM/Co0000o`00000`091`ZP03o`00002dS:/0]8b[02/0]8b[00?o00000<J_a036[l@02036[l@0
0ol00000kMk30>gN``020>gN``03o`00003mgHD0oMf500@0oMf500Co00000<e^003=KP3o0000Dooo
ool004[ooooo00Co000007Mfa01gM/@0MgK40_l0000_091`ZP03o`00002dS:/0]8b[02P0]8b[0_l0
000;0<J_a003o`00003]g/<0kMk30080kMk300?o00000?gMQ@3mgHD0103mgHD01?l00000cFh00<e^
0?l0001Cooooo`00B_ooool2o`0000@0MgK400?o0000091`ZP2@L:X0;02@L:X00ol00000]8b[0;B<
Z`0W0;B<Z`03o`000036[l@0aZo400/0aZo400?o00000>gN``3]g/<00`3]g/<00ol00000oMf50?gM
Q@040?gMQ@04o`00003=KP00cFh0o`0005;ooooo001:ooooo`;o00001@1gM/@2o`0002`0T72Z00?o
00000;B<Z`2dS:/09P2dS:/00ol00000aZo40<J_a00;0<J_a003o`00003]g/<0kMk300@0kMk300?o
00000?gMQ@3mgHD01@3mgHD00ol00000cFh0o`00001Booooo`00Boooool2o`0000H0MgK400?o0000
091`ZP2@L:X0:@2@L:X00ol00000]8b[0;B<Z`0T0;B<Z`;o00003P36[l@00ol00000kMk30>gN``04
0>gN``03o`00003mgHD0oMf500D0oMf500Co00000<e^003=KP3o0000DOooool004_ooooo0_l00007
07Mfa0;o0000:@2@L:X00ol00000]8b[0;B<Z`0S0;B<Z`03o`000036[l@0aZo400h0aZo400?o0000
0>gN``3]g/<0103]g/<00ol00000oMf50?gMQ@060?gMQ@03o`00003=KP3o0000057ooooo001;oooo
o`03o`0000008Jco000000P0MgK400?o0000091`ZP2@L:X09P2@L:X00ol00000]8b[0;B<Z`0R0;B<
Z`03o`000036[l@0aZo400h0aZo400?o00000>gN``3]g/<01@3]g/<00ol00000oMf50?gMQ@070?gM
Q@;o0000DOooool004_ooooo00?o0000000Q[?l000002@1gM/@2o`0002H0T72Z00?o00000;B<Z`2d
S:/0802dS:/2o`000140aZo400?o00000>gN``3]g/<01@3]g/<00ol00000oMf50?gMQ@080?gMQ@;o
0000D?ooool004cooooo00?o0000000Q[?l000002P1gM/@2o`0002@0T72Z00?o00000;B<Z`2dS:/0
7`2dS:/00ol00000aZo40<J_a00A0<J_a003o`00003]g/<0kMk300D0kMk300?o00000?gMQ@3mgHD0
203mgHD2o`00053ooooo001<ooooo`03o`0000008Jco000000`0MgK400?o0000091`ZP2@L:X08@2@
L:X00ol00000]8b[0;B<Z`0N0;B<Z`03o`000036[l@0aZo40140aZo400?o00000>gN``3]g/<01P3]
g/<00ol00000oMf50?gMQ@090?gMQ@03o`000?oooooooooo04kooooo001<ooooo`04o`0000008J`0
026/o`0000`0MgK40_l0000Q091`ZP03o`00002dS:/0]8b[01`0]8b[0_l0000D0<J_a003o`00003]
g/<0kMk300H0kMk300?o00000?gMQ@3mgHD02P3mgHD00ol0003oooooooooo`1=ooooo`00COooool0
0ol00000026/o`00000>07Mfa003o`00002@L:X0T72Z01h0T72Z00?o00000;B<Z`2dS:/06`2dS:/0
0ol00000aZo40<J_a00D0<J_a003o`00003]g/<0kMk300L0kMk300?o00000?gMQ@3mgHD02@3mgHD0
0ol0003oooooooooo`1=ooooo`00COooool01?l00000026/000Q[?l0000>07Mfa0;o00007P2@L:X0
0ol00000]8b[0;B<Z`0I0;B<Z`;o00005P36[l@00ol00000kMk30>gN``080>gN``03o`00003mgHD0
oMf500T0oMf500?o0000ooooooooool0COooool004gooooo00Go0000000Q[0008J`0026/o`00000?
07Mfa003o`00002@L:X0T72Z01/0T72Z00?o00000;B<Z`2dS:/0602dS:/00ol00000aZo40<J_a00F
0<J_a003o`00003]g/<0kMk300P0kMk300?o00000?gMQ@3mgHD0203mgHD00ol0003oooooooooo`1>
ooooo`00C_ooool01?l00000026/000Q[?l0000@07Mfa0;o00006`2@L:X00ol00000]8b[0;B<Z`0G
0;B<Z`03o`000036[l@0aZo401L0aZo400?o00000>gN``3]g/<0203]g/<00ol00000oMf50?gMQ@08
0?gMQ@03o`000?oooooooooo04kooooo001>ooooo`05o`0000008J`0026/000Q[?l000004@1gM/@2
o`0001T0T72Z00?o00000;B<Z`2dS:/05@2dS:/2o`0001T0aZo400?o00000>gN``3]g/<02@3]g/<0
0ol00000oMf50?gMQ@080?gMQ@03o`000?oooooooooo04kooooo001>ooooo`05o`0000008J`0026/
000Q[?l000004`1gM/@00ol00000T72Z091`ZP0F091`ZP03o`00002dS:/0]8b[01@0]8b[00?o0000
0<J_a036[l@06@36[l@00ol00000kMk30>gN``090>gN``03o`00003mgHD0oMf500P0oMf500?o0000
ooooooooool0C_ooool004kooooo00?o0000000Q[0008J`00P008J`00ol00000MgK407Mfa00A07Mf
a0;o00005P2@L:X00ol00000]8b[0;B<Z`0C0;B<Z`03o`000036[l@0aZo401X0aZo400?o00000>gN
``3]g/<02@3]g/<00ol00000oMf50?gMQ@080?gMQ@03o`000?oooooooooo04kooooo001?ooooo`05
o`0000008J`0026/000Q[?l000005@1gM/@00ol00000T72Z091`ZP0C091`ZP03o`00002dS:/0]8b[
0140]8b[0_l0000L0<J_a003o`00003]g/<0kMk300X0kMk300?o00000?gMQ@3mgHD01`3mgHD00ol0
003oooooooooo`1?ooooo`00Coooool00ol00000026/000Q[002000Q[003o`00001gM/@0MgK401<0
MgK40_l0000C091`ZP03o`00002dS:/0]8b[0100]8b[00?o00000<J_a036[l@07036[l@00ol00000
kMk30>gN``0;0>gN``03o`00003mgHD0oMf500H0oMf500?o0000ooooooooool0Coooool004oooooo
00?o0000000Q[0008J`00P008J`00ol00000MgK407Mfa00E07Mfa003o`00002@L:X0T72Z0100T72Z
00?o00000;B<Z`2dS:/03`2dS:/00ol00000aZo40<J_a00M0<J_a003o`00003]g/<0kMk300/0kMk3
00?o00000?gMQ@3mgHD01P3mgHD00ol0003oooooooooo`1?ooooo`00D?ooool00ol00000026/000Q
[002000Q[003o`00001gM/@0MgK401D0MgK40_l0000@091`ZP03o`00002dS:/0]8b[00d0]8b[0_l0
000O0<J_a003o`00003]g/<0kMk300`0kMk300?o00000?gMQ@3mgHD01P3mgHD00ol0003ooooooooo
o`1?ooooo`00D?ooool00ol00000026/000Q[002000Q[003o`00001gM/@0MgK401L0MgK40_l0000>
091`ZP03o`00002dS:/0]8b[00`0]8b[00?o00000<J_a036[l@07`36[l@00ol00000kMk30>gN``0<
0>gN``03o`00003mgHD0oMf500H0oMf500?o0000ooooooooool0Coooool0053ooooo00?o0000000Q
[0008J`00`008J`00ol00000MgK407Mfa00H07Mfa003o`00002@L:X0T72Z00`0T72Z00?o00000;B<
Z`2dS:/02P2dS:/00ol00000aZo40<J_a00P0<J_a003o`00003]g/<0kMk300`0kMk300?o00000?gM
Q@3mgHD01@3mgHD00ol0003oooooooooo`1@ooooo`00D?ooool00ol00000026/000Q[003000Q[003
o`00001gM/@0MgK401T0MgK40_l0000<091`ZP03o`00002dS:/0]8b[00P0]8b[0_l0000R0<J_a003
o`00003]g/<0kMk300d0kMk300?o00000?gMQ@3mgHD01@3mgHD00ol0003oooooooooo`1@ooooo`00
DOooool00ol00000026/000Q[003000Q[003o`00001gM/@0MgK401X0MgK400?o0000091`ZP2@L:X0
2@2@L:X00ol00000]8b[0;B<Z`070;B<Z`03o`000036[l@0aZo40280aZo400?o00000>gN``3]g/<0
3@3]g/<00ol00000oMf50?gMQ@050?gMQ@03o`000?oooooooooo053ooooo001Aooooo`03o`000000
8J`0026/00<0026/00?o000007Mfa01gM/@06`1gM/@2o`0000T0T72Z00?o00000;B<Z`2dS:/01P2d
S:/00ol00000aZo40<J_a00S0<J_a003o`00003]g/<0kMk300d0kMk300?o00000?gMQ@3mgHD01@3m
gHD00ol0003oooooooooo`1@ooooo`00DOooool00ol00000026/000Q[004000Q[003o`00001gM/@0
MgK401`0MgK400?o0000091`ZP2@L:X01P2@L:X00ol00000]8b[0;B<Z`040;B<Z`;o00009@36[l@0
0ol00000kMk30>gN``0?0>gN``03o`00003mgHD0oMf500<0oMf500?o0000ooooooooool0DOooool0
05;ooooo00?o0000000Q[0008J`00`008J`00ol00000MgK407Mfa00M07Mfa0;o00001P2@L:X00ol0
0000]8b[0;B<Z`030;B<Z`03o`000036[l@0aZo402D0aZo400?o00000>gN``3]g/<03`3]g/<00ol0
0000oMf50?gMQ@030?gMQ@03o`000?oooooooooo057ooooo001Booooo`03o`0000008J`0026/00@0
026/00?o000007Mfa01gM/@07P1gM/@2o`0000@0T72Z00?o00000;B<Z`2dS:/00P2dS:/00ol00000
aZo40<J_a00V0<J_a003o`00003]g/<0kMk300l0kMk300?o00000?gMQ@3mgHD00`3mgHD00ol0003o
ooooooooo`1Aooooo`00D_ooool00ol00000026/000Q[004000Q[003o`00001gM/@0MgK40200MgK4
00Go0000091`ZP2@L:X0T72Zo`0000020;B<Z`;o0000:036[l@00ol00000kMk30>gN``0@0>gN``03
o`00003mgHD0oMf500<0oMf500?o0000ooooooooool0DOooool005;ooooo00?o0000000Q[0008J`0
1@008J`00ol00000MgK407Mfa00P07Mfa0;o000000@0T72Zo`00002dS:_o0000:P36[l@00ol00000
kMk30>gN``0@0>gN``03o`00003mgHD0oMf500<0oMf500?o0000ooooooooool0DOooool005?ooooo
00?o0000000Q[0008J`010008J`00ol00000MgK407Mfa00R07Mfa0?o0000:`36[l@00ol00000kMk3
0>gN``0@0>gN``03o`00003mgHD0oMf50080oMf500?o0000ooooooooool0D_ooool005?ooooo00?o
0000000Q[0008J`01@008J`00ol00000MgK407Mfa00Q07Mfa0Co0000:@36[l@00ol00000kMk30>gN
``0A0>gN``03o`00003mgHD0oMf50080oMf500?o0000ooooooooool0D_ooool005?ooooo00?o0000
000Q[0008J`01@008J`00ol00000MgK407Mfa00P07Mfa003o`000029Wn;o00000080];cP0ol0000V
0<J_a003o`00003]g/<0kMk30140kMk300?o00000?gMQ@3mgHD00P3mgHD00ol0003oooooooooo`1B
ooooo`00E?ooool00ol00000026/000Q[005000Q[003o`00001gM/@0MgK401d0MgK40_l0000208VO
hP03o`00002d_>00];cP00<0];cP0ol0000S0<J_a003o`00003]g/<0kMk30140kMk300?o00000?gM
Q@3mgHD00P3mgHD00ol0003oooooooooo`1Booooo`00E?ooool00ol00000026/000Q[005000Q[003
o`00001gM/@0MgK401/0MgK40_l0000508VOhP03o`00002d_>00];cP00D0];cP0ol0000O0<J_a003
o`00003]g/<0kMk301<0kMk300Co00000?gMQ@3mgHGo0000EOooool005Cooooo00?o0000000Q[000
8J`01P008J`00ol00000MgK407Mfa00I07Mfa003o`000029Wn80RIoR00D0RIoR00?o00000;Blh02d
_>00202d_>03o`0001`0aZo400?o00000>gN``3]g/<04`3]g/<01?l00000oMf50?gMQOl0001Eoooo
o`00E?ooool00ol00000026/000Q[007000Q[003o`00001gM/@0MgK401H0MgK40_l0000808VOhP03
o`00002d_>00];cP00/0];cP0ol0000I0<J_a003o`00003]g/<0kMk301<0kMk300Co00000?gMQ@3m
gHGo0000EOooool005Gooooo00?o0000000Q[0008J`01P008J`00ol00000MgK407Mfa00D07Mfa0;o
00002P29Wn800ol00000];cP0;Blh00>0;Blh0?o00005@36[l@00ol00000kMk30>gN``0D0>gN``04
o`00003mgHD0oMf5o`0005Gooooo001Eooooo`03o`0000008J`0026/00L0026/00?o000007Mfa01g
M/@04P1gM/@00ol00000RIoR08VOhP0:08VOhP03o`00002d_>00];cP0140];cP0ol0000B0<J_a003
o`00003]g/<0kMk301@0kMk300Co00000?gMQ@3mgHGo0000EOooool005Gooooo00?o0000000Q[000
8J`01`008J`00ol00000MgK407Mfa00@07Mfa0;o00003P29Wn800ol00000];cP0;Blh00C0;Blh0?o
00003`36[l@00ol00000kMk30>gN``0D0>gN``03o`00003mgHGo000005Kooooo001Fooooo`03o`00
00008J`0026/00L0026/00?o000007Mfa01gM/@03@1gM/@2o`000100RIoR00?o00000;Blh02d_>00
5P2d_>03o`0000/0aZo400?o00000>gN``3]g/<05@3]g/<00ol00000oMf5o`00001Fooooo`00E_oo
ool00ol00000026/000Q[007000Q[003o`00001gM/@0MgK400`0MgK400?o000008VOhP29Wn804029
Wn800ol00000];cP0;Blh00I0;Blh0?o00002036[l@00ol00000kMk30>gN``0E0>gN``03o`00003m
gHGo000005Kooooo001Fooooo`03o`0000008J`0026/00P0026/00?o000007Mfa01gM/@02@1gM/@2
o`0001<0RIoR00?o00000;Blh02d_>00702d_>03o`0000D0aZo400?o00000>gN``3]g/<05P3]g/<2
o`0005Kooooo001Gooooo`03o`0000008J`0026/00L0026/00?o000007Mfa01gM/@01`1gM/@2o`00
01H0RIoR00?o00000;Blh02d_>007P2d_>03o`0000030<J_a?l00000kMk301P0kMk30_l0001Foooo
o`00Eoooool00ol00000026/000Q[008000Q[003o`00001gM/@0MgK400D0MgK400?o000008VOhP29
Wn805P29Wn800ol00000];cP0;Blh00Q0;Blh0oo0000303]g/<00ol0003oooooooooo`1Eooooo`00
Eoooool00ol00000026/000Q[008000Q[003o`00001gM/@0MgK400<0MgK40_l0000I08VOhP03o`00
002d_>00];cP0280];cP00?o00000=Gci03Eln@02`3Eln@=o`0005Oooooo001Gooooo`03o`000000
8J`0026/00T0026/00?o000007Mfa01gM/@00_l0000K08VOhP03o`00002d_>00];cP0240];cP00?o
00000=Gci03Eln@05P3Eln@00ol0003oooooooooo`1Gooooo`00F?ooool00ol00000026/000Q[008
000Q[003o`00001gM/Co000001d0RIoR00?o00000;Blh02d_>00802d_>000ol00000eO?T0=Gci00F
0=Gci003o`000?oooooooooo05Sooooo001Hooooo`03o`0000008J`0026/00L0026/1?l0000N08VO
hP03o`00002d_>00];cP01l0];cP00?o00000=Gci03Eln@0503Eln@2o`0005_ooooo001Hooooo`03
o`0000008J`0026/00<0026/1?l00004001Le003o`000029Wn80RIoR01/0RIoR00?o00000;Blh02d
_>007P2d_>000ol00000eO?T0=Gci00D0=Gci0;o0000G?ooool005Wooooo00?o0000000Q[?l00000
0_l00009001Le003o`000029Wn80RIoR01X0RIoR00?o00000;Blh02d_>007@2d_>000ol00000eO?T
0=Gci00D0=Gci0;o0000GOooool005Wooooo0_l0000=001Le003o`000029Wn80RIoR01T0RIoR00?o
00000;Blh02d_>007@2d_>000ol00000eO?T0=Gci00B0=Gci0?o0000G_ooool005_ooooo00?o0000
001Le000G=@02`00G=@00ol00000RIoR08VOhP0H08VOhP03o`00002d_>00];cP01`0];cP00?o0000
0=Gci03Eln@04P3Eln@00ol00000TNVao`00001Oooooo`00G?ooool2o`0000`005cD00?o000008VO
hP29Wn806029Wn800ol00000];cP0;Blh00J0;Blh003o`00003Eln@0eO?T0180eO?T00?o0000097Y
/Ol00000H?ooool005kooooo00?o0000001Le000G=@02P00G=@00ol00000RIoR08VOhP0G08VOhP03
o`00002d_>00];cP01X0];cP00?o00000=Gci03Eln@0403Eln@2o`000003097Y/Ol0003ooooo063o
oooo001Oooooo`;o00002`00G=@00ol00000RIoR08VOhP0F08VOhP03o`00002d_>00];cP01T0];cP
00?o00000=Gci03Eln@0403Eln@01?l00000TNVa097Y/Ol0001Rooooo`00HOooool00ol0000005cD
001Le009001Le003o`000029Wn80RIoR01D0RIoR00?o00000;Blh02d_>00602d_>000ol00000eO?T
0=Gci00@0=Gci004o`00002AjK40TNVao`0006?ooooo001Rooooo`03o`000000G=@005cD00T005cD
00?o000008VOhP29Wn805@29Wn800ol00000];cP0;Blh00G0;Blh003o`00003Eln@0eO?T00l0eO?T
00Co0000097Y/@2AjK7o0000I?ooool006?ooooo0_l0000:001Le003o`000029Wn80RIoR01@0RIoR
00?o00000;Blh02d_>005P2d_>000ol00000eO?T0=Gci00>0=Gci0;o00000P2AjK400ol0003ooooo
ooooo`1Sooooo`00IOooool00ol0000005cD001Le008001Le003o`000029Wn80RIoR01<0RIoR00?o
00000;Blh02d_>005@2d_>000ol00000eO?T0=Gci00>0=Gci005o`00002AjK40TNVa097Y/Ol00000
I_ooool006Kooooo0_l00009001Le003o`000029Wn80RIoR0180RIoR00?o00000;Blh02d_>005@2d
_>000ol00000eO?T0=Gci00=0=Gci005o`00002AjK40TNVa097Y/Ol00000Ioooool006Sooooo00?o
0000001Le000G=@01`00G=@00ol00000RIoR08VOhP0A08VOhP03o`00002d_>00];cP01@0];cP00?o
00000=Gci03Eln@0303Eln@2o`0000<0TNVa00?o0000ooooooooool0I_ooool006Wooooo0_l00008
001Le003o`000029Wn80RIoR0140RIoR00?o00000;Blh02d_>004P2d_>000ol00000eO?T0=Gci00<
0=Gci004o`00002AjK40TNVa097Y/@;o0000JOooool006_ooooo00?o0000001Le000G=@01P00G=@0
0ol00000RIoR08VOhP0@08VOhP03o`00002d_>00];cP0180];cP00?o00000=Gci03Eln@02`3Eln@0
1Ol00000TNVa097Y/@2AjK7o000006_ooooo001/ooooo`;o00001`00G=@00ol00000RIoR08VOhP0?
08VOhP03o`00002d_>00];cP0140];cP00?o00000=Gci03Eln@02P3Eln@2o`000080TNVa0_l0001/
ooooo`00K_ooool00ol0000005cD001Le005001Le003o`000029Wn80RIoR00h0RIoR00?o00000;Bl
h02d_>00402d_>000ol00000eO?T0=Gci00:0=Gci005o`00002AjK40TNVa097Y/Ol00000K_ooool0
06oooooo0_l00006001Le003o`000029Wn80RIoR00h0RIoR00?o00000;Blh02d_>003`2d_>000ol0
0000eO?T0=Gci0090=Gci003o`00002AjK40TNVa00;o0000Koooool0077ooooo00?o0000001Le000
G=@01000G=@2o`0000h0RIoR00?o00000;Blh02d_>003P2d_>000ol00000eO?T0=Gci0080=Gci0;o
00000P2AjK400ol0003oooooooooo`1_ooooo`00L_ooool2o`0000H005cD00?o000008VOhP29Wn80
2`29Wn800ol00000];cP0;Blh00=0;Blh003o`00003Eln@0eO?T00P0eO?T00?o0000097Y/@2AjK40
0_l0001booooo`00M?ooool00ol0000005cD001Le004001Le003o`000029Wn80RIoR00X0RIoR00?o
00000;Blh02d_>003@2d_>000ol00000eO?T0=Gci0070=Gci004o`00002AjK40TNVao`0007Cooooo
001eooooo`03o`000000G=@005cD00@005cD00?o000008VOhP29Wn802@29Wn800ol00000];cP0;Bl
h00<0;Blh003o`00003Eln@0eO?T00H0eO?T0_l000000`2AjK7o0000o`00001eooooo`00M_ooool2
o`0000D005cD00?o000008VOhP29Wn802@29Wn800ol00000];cP0;Blh00:0;Blh003o`00003Eln@0
eO?T00H0eO?T00Co0000097Y/@2AjK7o0000Moooool007Sooooo00?o0000001Le000G=@00`00G=@0
0ol00000RIoR08VOhP0808VOhP03o`00002d_>00];cP00X0];cP00?o00000=Gci03Eln@01@3Eln@0
1?l00000TNVao`000?l0001hooooo`00NOooool2o`0000@005cD00?o000008VOhP29Wn801`29Wn80
0ol00000];cP0;Blh0090;Blh003o`00003Eln@0eO?T00@0eO?T0_l000000`2AjK7o0000ooooo`1i
ooooo`00Noooool00ol0000005cD001Le002001Le003o`000029Wn80RIoR00H0RIoR00?o00000;Bl
h02d_>00202d_>000ol00000eO?T0=Gci0040=Gci004o`00002AjK7o0000o`0007_ooooo001loooo
o`;o00000`00G=@00ol00000RIoR08VOhP0508VOhP03o`00002d_>00];cP00P0];cP00?o00000=Gc
i03Eln@00`3Eln@00ol00000TNVao`00001mooooo`00O_ooool01Ol0000005cD001Le000G=Co0000
00L0RIoR00?o00000;Blh02d_>001P2d_>000ol00000eO?T0=Gci0030=Gci0?o0000O_ooool007oo
oooo0_l00002001Le003o`000029Wn80RIoR00@0RIoR00?o00000;Blh02d_>001@2d_>000ol00000
eO?T0=Gci0020=Gci0?o0000P?ooool0087ooooo00Co0000001Le000G=Co00001@29Wn800ol00000
];cP0;Blh0050;Blh004o`00003Eln@0eO?T0=Gci0?o0000POooool008;ooooo0_l000000`00G=Co
000008VOhP0308VOhP03o`00002d_>00];cP00@0];cP00Co00000=Gci03Eln@0eO?T0_l00023oooo
o`00Q?ooool00ol0000005cDo`00000408VOhP03o`00002d_>00];cP0080];cP00?o00000=Gci03E
ln@00ol00024ooooo`00QOooool00ol0000005cDo`00000308VOhP03o`00002d_>00];cP0080];cP
00Co00000=Gci?l0003o0000Q_ooool008Kooooo0ol0000208VOhP06o`00002d_>00];cP0;Blh?l0
0000eO?T0_l00027ooooo`00R?ooool2o`00000408VOh_l00000];cP0;Blh0?o0000ROooool008Wo
oooo0ol000020;Blh0;o0000R_ooool008_ooooo0ol0002<ooooo`00S?ooool00ol0003ooooooooo
o`2;ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooo
oolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooo
oolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooo
oolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooo
oolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooo
oolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooo
oolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooo
oolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooo
oolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooo
oolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooo
oolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooo
oolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooo
oolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooo
oolKooooo`00oooooolKooooo`00oooooolKooooo`00\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-5.00005*^-6, -5.00005*^-6, \
0.00355875, 0.00355875}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.4104 .57603 m .4409 .687 L .56177 .66998 L closepath p .675 .323 .369 r
F P
0 g
s
.33127 .64347 m .4409 .687 L .4104 .57603 L closepath p .829 .421 .273 r
F P
0 g
s
.4104 .57603 m .5704 .56684 L .55806 .45048 L closepath p .664 .522 .68 r
F P
0 g
s
.5704 .56684 m .4104 .57603 L .56177 .66998 L closepath p .636 .379 .512 r
F P
0 g
s
.4104 .57603 m .44521 .41961 L .34205 .4116 L closepath p .846 .753 .76 r
F P
0 g
s
.44521 .41961 m .4104 .57603 L .55806 .45048 L closepath p .724 .628 .75 r
F P
0 g
s
.30586 .5282 m .34205 .4116 L .4104 .57603 L closepath p .929 .774 .668 r
F P
0 g
s
.30586 .5282 m .33127 .64347 L .4104 .57603 L closepath p .934 .608 .397 r
F P
0 g
s
.55806 .45048 m .63136 .38822 L .72174 .53604 L closepath p .486 .468 .762 r
F P
0 g
s
.5 .27523 m .63136 .38822 L .55806 .45048 L closepath p .56 .599 .849 r
F P
0 g
s
.5704 .56684 m .55806 .45048 L .72174 .53604 L closepath p .553 .439 .679 r
F P
0 g
s
.44521 .41961 m .5 .27523 L .55806 .45048 L closepath p .685 .674 .834 r
F P
0 g
s
.56177 .66998 m .5704 .56684 L .72174 .53604 L closepath p .496 .26 .487 r
F P
0 g
s
.44521 .41961 m .34205 .4116 L .5 .27523 L closepath p .812 .821 .858 r
F P
0 g
s
.5 .27523 m .63136 .38822 L .67212 .35366 L closepath p .233 .493 .897 r
F P
0 g
s
.63136 .38822 m .72174 .53604 L .67212 .35366 L closepath p .114 .28 .756 r
F P
0 g
s
.5 .75807 m .4409 .687 L .56177 .66998 L closepath p .503 .017 .036 r
F P
0 g
s
.64223 .66726 m .5 .75807 L .56177 .66998 L closepath p .191 0 0 r
F P
0 g
s
.64223 .66726 m .56177 .66998 L .72174 .53604 L closepath p .272 0 .236 r
F P
0 g
s
.24533 .45861 m .35775 .3327 L .34205 .4116 L closepath p .899 .983 .715 r
F P
0 g
s
.5 .27523 m .35775 .3327 L .34205 .4116 L closepath p .832 .954 .895 r
F P
0 g
s
.30586 .5282 m .24533 .45861 L .34205 .4116 L closepath p .99 .884 .61 r
F P
0 g
s
.67212 .35366 m .716 .46862 L .72174 .53604 L closepath p 0 0 .377 r
F P
0 g
s
.64223 .66726 m .68501 .60355 L .72174 .53604 L closepath p 0 0 0 r
F P
0 g
s
.68501 .60355 m .716 .46862 L .72174 .53604 L closepath p .86 .809 .323 r
F P
0 g
s
.42762 .30083 m .35775 .3327 L .5 .27523 L closepath p .31 .785 .689 r
F P
0 g
s
.56576 .2919 m .5 .27523 L .67212 .35366 L closepath p 0 .373 .773 r
F P
0 g
s
.56576 .2919 m .42762 .30083 L .5 .27523 L closepath p .172 0 0 r
F P
0 g
s
.33127 .64347 m .4409 .687 L .5 .75807 L closepath p .618 .052 0 r
F P
0 g
s
.33127 .64347 m .30586 .5282 L .24533 .45861 L closepath p .925 .596 .136 r
F P
0 g
s
.34491 .63198 m .5 .75807 L .33127 .64347 L closepath p 0 .267 .744 r
F P
0 g
s
.34491 .63198 m .24533 .45861 L .33127 .64347 L closepath p 0 0 .544 r
F P
0 g
s
.64223 .66726 m .5 .75807 L .68501 .60355 L closepath p .709 .982 .801 r
F P
0 g
s
.35775 .3327 m .24533 .45861 L .42762 .30083 L closepath p 0 0 0 r
F P
0 g
s
.62321 .39544 m .716 .46862 L .67212 .35366 L closepath p .907 .509 .103 r
F P
0 g
s
.56576 .2919 m .62321 .39544 L .67212 .35366 L closepath p .75 .23 0 r
F P
0 g
s
.716 .46862 m .68501 .60355 L .62321 .39544 L closepath p .987 .829 .599 r
F P
0 g
s
.56576 .2919 m .42762 .30083 L .62321 .39544 L closepath p .61 .16 .156 r
F P
0 g
s
.5 .75807 m .57206 .60573 L .68501 .60355 L closepath p .827 .907 .894 r
F P
0 g
s
.42176 .56672 m .57206 .60573 L .5 .75807 L closepath p .668 .706 .876 r
F P
0 g
s
.34491 .63198 m .42176 .56672 L .5 .75807 L closepath p .474 .591 .89 r
F P
0 g
s
.42176 .56672 m .40739 .41207 L .24533 .45861 L closepath p .483 .378 .659 r
F P
0 g
s
.42762 .30083 m .40739 .41207 L .24533 .45861 L closepath p .365 .087 .352 r
F P
0 g
s
.34491 .63198 m .42176 .56672 L .24533 .45861 L closepath p .368 .402 .765 r
F P
0 g
s
.62321 .39544 m .57206 .60573 L .68501 .60355 L closepath p .89 .814 .767 r
F P
0 g
s
.62321 .39544 m .40739 .41207 L .42762 .30083 L closepath p .592 .284 .416 r
F P
0 g
s
.57206 .60573 m .62321 .39544 L .42176 .56672 L closepath p .729 .645 .765 r
F P
0 g
s
.62321 .39544 m .40739 .41207 L .42176 .56672 L closepath p .649 .501 .67 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016R000`400?l00000o`00003ooooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00Roooool4o`0008_ooooo0028ooooo`?o0000100/
0003o`0008Sooooo0025ooooo`?o00002P0/0004o`0008Cooooo0022ooooo`?o00004@0/0004o`00
083ooooo001oooooo`?o0000600/0003o`0007gooooo001looooo`?o00005P0/000;o`0007[ooooo
001iooooo`?o00001P0/000Co`0000T0W2PW00Co00000;lj0?l0003o0000N?ooool007Oooooo2ol0
000M09`X9`04o`00002o>P00_cX0o`0007Oooooo001eooooo`;o000000<0GAIJo`00002GB6X00_l0
000S09`X9`04o`00002o>P00_cX00;lj00;o0000MOooool007;ooooo1?l0000205dFFP04o`00002G
B6X0UdQZ09M8JP;o00008P2L:2L00ol00000_cX00;lj00020;lj00;o0000Loooool0073ooooo0_l0
000200000005o`00001M5UX0GAIJ05dFF_l000001@2GB6X2o`000240W2PW00?o00000;lj002o>P00
0`2o>P02o`00077ooooo001^ooooo`;o00000`0000001Ol00000GAIJ05dFFP1M5U[o000000P0UdQZ
0_l0000O09`X9`03o`00002o>P00_cX000D0_cX000?o0000ooooooooool0K_ooool006cooooo0_l0
0003000000;o0000101M5UX00ol00000UdQZ09M8JP0809M8JP;o00007P2L:2L00ol00000_cX00;lj
00050;lj00;o0000K_ooool006[ooooo0_l0000400000003o`00001M5UX0GAIJ00@0GAIJ00?o0000
09M8JP2GB6X02P2GB6X2o`0001`0W2PW00?o00000;lj002o>P001`2o>P02o`0006cooooo001Woooo
o`?o00001@0000000ol00000GAIJ05dFFP0505dFFP03o`00002GB6X0UdQZ00`0UdQZ0_l0000K09`X
9`03o`00002o>P00_cX000P0_cX00_l0001Zooooo`00IOooool2o`0000L0000000?o000005dFFP1M
5UX01P1M5UX00ol00000UdQZ09M8JP0>09M8JP;o00006P2L:2L00ol00000_cX00;lj00090;lj00;o
0000J?ooool006Cooooo00?o00000000000000001P0000000ol00000GAIJ05dFFP0605dFFP03o`00
002GB6X0UdQZ0140UdQZ0_l0000H09`X9`03o`00002o>P00_cX000/0_cX000?o0000ooooooooool0
IOooool006Cooooo00?o00000000000000001@0000000ol00000GAIJ05dFFP0705dFFP03o`00002G
B6X0UdQZ01<0UdQZ0_l0000G09`X9`03o`00002o>P00_cX000/0_cX00_l0001Uooooo`00Hoooool0
0ol00000000000000004000000;o00002P1M5UX00ol00000UdQZ09M8JP0E09M8JP;o00005@2L:2L0
0ol00000_cX00;lj000=0;lj00;o0000Hoooool006;ooooo00?o0000000000000000100000000ol0
0000GAIJ05dFFP0:05dFFP03o`00002GB6X0UdQZ01L0UdQZ0_l0000D09`X9`03o`00002o>P00_cX0
00h0_cX00_l0001Qooooo`00HOooool00ol0000000000000000400000003o`00001M5UX0GAIJ00/0
GAIJ00?o000009M8JP2GB6X06@2GB6X3o`000180W2PW00?o00000;lj002o>P003`2o>P000ol0003o
ooooooooo`1Nooooo`00H?ooool00ol0000000000000000400000003o`00001M5UX0GAIJ00/0GAIJ
00?o000009M8JP2GB6X07@2GB6X2o`000100W2PW00?o00000;lj002o>P00402o>P02o`0005kooooo
001Oooooo`03o`0000000000000000@0000000?o000005dFFP1M5UX0301M5UX00ol00000UdQZ09M8
JP0O09M8JP;o00003`2L:2L00ol00000_cX00;lj000@0;lj00;o0000GOooool005kooooo00?o0000
0000000000000`000002o`0000l0GAIJ00?o000009M8JP2GB6X08@2GB6X2o`0000d0W2PW00?o0000
0;lj002o>P003`2o>P000ol00000j88Jo`00001Mooooo`00GOooool00ol000000000000000030000
0003o`00001M5UX0GAIJ00l0GAIJ00?o000009M8JP2GB6X08`2GB6X2o`0000`0W2PW00?o00000;lj
002o>P003@2o>P001Ol00000j88J0>R26P3XPQ[o000005cooooo001Looooo`03o`00000000000000
00<0000000?o000005dFFP1M5UX0401M5UX00ol00000UdQZ09M8JP0U09M8JP;o00002P2L:2L00ol0
0000_cX00;lj000<0;lj0003o`00003XPQX0j88J0080j88J00?o0000ooooooooool0F_ooool005_o
oooo00?o00000000000000000`0000000ol00000GAIJ05dFFP0@05dFFP03o`00002GB6X0UdQZ02P0
UdQZ0_l0000909`X9`03o`00002o>P00_cX000X0_cX000?o00000>R26P3XPQX00`3XPQX00ol0003o
ooooooooo`1Jooooo`00F_ooool00ol0000000000000000300000003o`00001M5UX0GAIJ0140GAIJ
00?o000009M8JP2GB6X0:P2GB6X2o`0000P0W2PW00?o00000;lj002o>P00202o>P000ol00000j88J
0>R26P050>R26P03o`000?oooooooooo05Wooooo001Iooooo`03o`0000000000000000<0000000?o
000005dFFP1M5UX04P1M5UX00ol00000UdQZ09M8JP0/09M8JP;o00001P2L:2L00ol00000_cX00;lj
00070;lj0003o`00003XPQX0j88J00H0j88J00?o0000ooooooooool0FOooool005Wooooo00Co0000
00000000000000000_l0000E05dFFP03o`00002GB6X0UdQZ02h0UdQZ0_l0000509`X9`03o`00002o
>P00_cX000D0_cX000?o00000>R26P3XPQX0203XPQX00ol0003oooooooooo`1Hooooo`00F?ooool0
1Ol00000000000000000003o000001L0GAIJ00?o000009M8JP2GB6X0<02GB6X2o`0000<0W2PW00?o
00000;lj002o>P00102o>P000ol00000j88J0>R26P090>R26P03o`000?oooooooooo05Sooooo001G
ooooo`05o`0000000000000000000?l000005`1M5UX00ol00000UdQZ09M8JP0c09M8JP;o00000P2L
:2L00ol00000_cX00;lj00020;lj0003o`00003XPQX0j88J00X0j88J00?o0000ooooooooool0F?oo
ool005Kooooo00Go00000000000000000000o`00000H05dFFP03o`00002GB6X0UdQZ03D0UdQZ0_l0
00001@2L:2Oo00000;lj002o>P3o000000h0j88J00?o0000ooooooooool0Eoooool005Gooooo00Go
00000000000000000000o`00000I05dFFP03o`00002GB6X0UdQZ03L0UdQZ0_l000000`2o>P3o0000
0>R26P0>0>R26P03o`000?oooooooooo05Oooooo001Dooooo`03o`0000000000000000;o00006P1M
5UX00ol00000UdQZ09M8JP0a09M8JP[o0000403XPQX00ol0003oooooooooo`1Fooooo`00Doooool0
1?l00000000000000?l0000L05dFFP03o`00002GB6X0UdQZ0280UdQZ3ol000060:J0Z`05o`00002j
YL?o00000?cDVOl000003`3XPQX00ol0003oooooooooo`1Fooooo`00D_ooool01?l0000000000000
0?l0000L05dFFP03o`00002GB6X0UdQZ01@0UdQZ3ol0000D0:J0Z`04o`00002jYL<0^ZG3o`000080
o=BI00?o00000>R26P3XPQX0303XPQX00ol0003oooooooooo`1Fooooo`00DOooool01?l000000000
00000?l0000M05dFFP03o`00002GB6X0UdQZ00D0UdQZ3ol0000R0:J0Z`06o`00002jYL<0^ZG3o`00
003Sd<Co00000P3le9T2o`0000d0j88J00?o0000ooooooooool0EOooool0053ooooo00Co00000000
0000003o0000701M5UX:o`000300YX2[00Oo00000;ZU``2jYL<0^ZG3o`00003Sd<Co000000@0o=BI
00?o00000>R26P3XPQX02P3XPQX00ol0003oooooooooo`1Eooooo`00Coooool01?l0000000000000
0?l0000J05dFFP?o00000P1kH:P00ol00000YX2[0:J0Z`0c0:J0Z`;o0000102jYL<00ol00000hm34
o`0000050?cDV@03o`00003XPQX0j88J00X0j88J00?o0000ooooooooool0E?ooool004oooooo0ol0
000G05dFFPCo00001@1kH:P00ol00000YX2[0:J0Z`0b0:J0Z`03o`00002jYL<0^ZG300@0^ZG300Co
00000>?@a03Sd<Co00001@3le9T00ol00000j88J0>R26P090>R26P03o`000?oooooooooo05Cooooo
001>ooooo`;o00005P1M5UX3o`0000T0Nf2X00?o00000:J0Z`2VP:/0<@2VP:/00ol00000^ZG30;ZU
``040;ZU``05o`00003Sd<@0hm340>?@a?l000001P3le9T2o`0000X0j88J00?o0000ooooooooool0
Doooool004gooooo0_l0000C05dFFPCo0000301kH:P00ol00000YX2[0:J0Z`0`0:J0Z`03o`00002j
YL<0^ZG300D0^ZG300Go00000>?@a03Sd<@0hm34o`0000080?cDV@03o`00003XPQX0j88J00L0j88J
00?o0000ooooooooool0Doooool004cooooo0_l0000A05dFFP?o0000401kH:P00ol00000YX2[0:J0
Z`0_0:J0Z`03o`00002jYL<0^ZG300H0^ZG300Go00000>?@a03Sd<@0hm34o`0000090?cDV@03o`00
003XPQX0j88J00H0j88J00?o0000ooooooooool0Doooool004_ooooo0_l0000>05dFFPCo0000501k
H:P00ol00000YX2[0:J0Z`0]0:J0Z`03o`00002jYL<0^ZG300L0^ZG300?o00000>?@a03Sd<@00P3S
d<@00ol00000o=BI0?cDV@070?cDV@;o00001`3XPQX00ol0003oooooooooo`1Booooo`00B_ooool2
o`0000/0GAIJ1?l0000H07]PZ003o`00002VP:/0YX2[02/0YX2[0_l000090;ZU``03o`00003Sd<@0
hm3400<0hm3400?o00000?cDV@3le9T02@3le9T00ol00000j88J0>R26P040>R26P03o`000?oooooo
oooo05;ooooo0019ooooo`03o`00001M5UX0GAIJ00P0GAIJ0ol0000L07]PZ003o`00002VP:/0YX2[
02X0YX2[00?o00000;ZU``2jYL<02@2jYL<00ol00000hm340>?@a0030>?@a003o`00003le9T0o=BI
00X0o=BI00?o00000>R26P3XPQX0103XPQX00ol0003oooooooooo`1Aooooo`00B?ooool00ol00000
GAIJ05dFFP0505dFFPCo00007`1kH:P00ol00000YX2[0:J0Z`0Y0:J0Z`03o`00002jYL<0^ZG300X0
^ZG300?o00000>?@a03Sd<@0103Sd<@00ol00000o=BI0?cDV@0:0?cDV@;o0000103XPQX00ol0003o
ooooooooo`1Aooooo`00Aoooool00ol00000GAIJ05dFFP0305dFFP?o00008`1kH:P00ol00000YX2[
0:J0Z`0X0:J0Z`03o`00002jYL<0^ZG300/0^ZG300?o00000>?@a03Sd<@0103Sd<@00ol00000o=BI
0?cDV@0<0?cDV@05o`00003XPQX0j88J0>R26_l00000Doooool004Kooooo00?o000005dFFP1M5UX0
1?l0000V07]PZ003o`00002VP:/0YX2[02L0YX2[00?o00000;ZU``2jYL<02`2jYL<00ol00000hm34
0>?@a0050>?@a003o`00003le9T0o=BI00d0o=BI00Go00000>R26P3XPQX0j88Jo`00001Booooo`00
AOooool4o`0002X0Nf2X00?o00000:J0Z`2VP:/09@2VP:/2o`0000h0^ZG300?o00000>?@a03Sd<@0
1P3Sd<@00ol00000o=BI0?cDV@0=0?cDV@04o`00003XPQX0j88Jo`0005;ooooo0014ooooo`;o0000
;@1kH:P00ol00000YX2[0:J0Z`0T0:J0Z`03o`00002jYL<0^ZG300h0^ZG300?o00000>?@a03Sd<@0
1P3Sd<@00ol00000o=BI0?cDV@0>0?cDV@;o000000<0j88Jo`000?ooool0D?ooool004Cooooo00?o
000005iV`ol00000;01kH:P00ol00000YX2[0:J0Z`0S0:J0Z`03o`00002jYL<0^ZG300l0^ZG300?o
00000>?@a03Sd<@01P3Sd<@00ol00000o=BI0?cDV@0@0?cDV@;o0000DOooool004Gooooo00Co0000
05iV`ol0003o0000:P1kH:P00ol00000YX2[0:J0Z`0R0:J0Z`03o`00002jYL<0^ZG300l0^ZG300?o
00000>?@a03Sd<@01`3Sd<@00ol00000o=BI0?cDV@0A0?cDV@03o`000?oooooooooo04oooooo0015
ooooo`04o`00001NI/<0GVK305iV``;o0000:01kH:P00ol00000YX2[0:J0Z`0Q0:J0Z`03o`00002j
YL<0^ZG30100^ZG300?o00000>?@a03Sd<@0203Sd<@00ol00000o=BI0?cDV@0A0?cDV@03o`000?oo
oooooooo04kooooo0016ooooo`03o`00001NI/<0GVK30080GVK300?o000007]PZ01kH:P09P1kH:P0
0ol00000YX2[0:J0Z`0N0:J0Z`;o00004`2jYL<00ol00000hm340>?@a0080>?@a003o`00003le9T0
o=BI0140o=BI00?o0000ooooooooool0C_ooool004Kooooo0_l0000405iV``;o00009P1kH:P00ol0
0000YX2[0:J0Z`0M0:J0Z`03o`00002jYL<0^ZG301<0^ZG300?o00000>?@a03Sd<@0203Sd<@00ol0
0000o=BI0?cDV@0A0?cDV@03o`000?oooooooooo04kooooo0017ooooo`03o`00001NI/<0GVK300@0
GVK300?o000007]PZ01kH:P08`1kH:P00ol00000YX2[0:J0Z`0L0:J0Z`03o`00002jYL<0^ZG301<0
^ZG300?o00000>?@a03Sd<@02P3Sd<@00ol00000o=BI0?cDV@0?0?cDV@;o0000D?ooool004Oooooo
0_l0000605iV``;o00008`1kH:P00ol00000YX2[0:J0Z`0K0:J0Z`03o`00002jYL<0^ZG301@0^ZG3
00?o00000>?@a03Sd<@02P3Sd<@00ol00000o=BI0?cDV@0?0?cDV@;o0000D?ooool004Sooooo00?o
000005iV``1NI/<01P1NI/<2o`000240Nf2X00?o00000:J0Z`2VP:/06P2VP:/00ol00000^ZG30;ZU
``0E0;ZU``03o`00003Sd<@0hm3400X0hm3400?o00000?cDV@3le9T03`3le9T2o`00053ooooo0018
ooooo`;o00002@1NI/<00ol00000Nf2X07]PZ00N07]PZ003o`00002VP:/0YX2[01T0YX2[00?o0000
0;ZU``2jYL<05P2jYL<00ol00000hm340>?@a00:0>?@a003o`00003le9T0o=BI00l0o=BI0_l0001@
ooooo`00BOooool00ol00000GVK305iV``0805iV``;o00007P1kH:P00ol00000YX2[0:J0Z`0G0:J0
Z`;o0000602jYL<00ol00000hm340>?@a00<0>?@a003o`00003le9T0o=BI00d0o=BI00?o00000=c?
D_l00000D?ooool004Wooooo0_l0000;05iV``;o0000701kH:P00ol00000YX2[0:J0Z`0F0:J0Z`03
o`00002jYL<0^ZG301P0^ZG300?o00000>?@a03Sd<@0303Sd<@00ol00000o=BI0?cDV@0=0?cDV@03
o`00003Lce;o0000053ooooo001:ooooo`;o0000301NI/<00ol00000Nf2X07]PZ00I07]PZ003o`00
002VP:/0YX2[01D0YX2[00?o00000;ZU``2jYL<06@2jYL<00ol00000hm340>?@a00<0>?@a003o`00
003le9T0o=BI00d0o=BI00?o00000=c?D_l00000D?ooool004[ooooo0_l0000=05iV``;o00006@1k
H:P00ol00000YX2[0:J0Z`0D0:J0Z`03o`00002jYL<0^ZG301T0^ZG300?o00000>?@a03Sd<@03P3S
d<@00ol00000o=BI0?cDV@0<0?cDV@04o`00003Lce80g<mBo`0004oooooo001:ooooo`03o`000000
08_o000000h0GVK300?o000007]PZ01kH:P05P1kH:P00ol00000YX2[0:J0Z`0C0:J0Z`03o`00002j
YL<0^ZG301X0^ZG300?o00000>?@a03Sd<@03P3Sd<@00ol00000o=BI0?cDV@0<0?cDV@04o`00003L
ce80g<mBo`0004oooooo001;ooooo`;o00003`1NI/<2o`0001L0Nf2X00?o00000:J0Z`2VP:/0402V
P:/2o`0001d0^ZG300?o00000>?@a03Sd<@03P3Sd<@00ol00000o=BI0?cDV@0;0?cDV@05o`00003L
ce80g<mB0=c?D_l00000Coooool004_ooooo00?o00000000Rol00000401NI/<2o`0001D0Nf2X00?o
00000:J0Z`2VP:/03`2VP:/00ol00000^ZG30;ZU``0M0;ZU``03o`00003Sd<@0hm3400l0hm3400?o
00000?cDV@3le9T02P3le9T01Ol00000g<mB0=c?DP3Lce;o000004oooooo001<ooooo`;o00004P1N
I/<00ol00000Nf2X07]PZ00B07]PZ003o`00002VP:/0YX2[00h0YX2[00?o00000;ZU``2jYL<07@2j
YL<00ol00000hm340>?@a00@0>?@a003o`00003le9T0o=BI00X0o=BI00Go00000=c?DP3Lce80g<mB
o`00001?ooooo`00C?ooool00ol00000002;o`00000B05iV``;o00004P1kH:P00ol00000YX2[0:J0
Z`0=0:J0Z`03o`00002jYL<0^ZG301h0^ZG300?o00000>?@a03Sd<@0403Sd<@00ol00000o=BI0?cD
V@0:0?cDV@05o`00003Lce80g<mB0=c?D_l00000Coooool004gooooo00?o00000000Rol000004`1N
I/<00ol00000Nf2X07]PZ00?07]PZ003o`00002VP:/0YX2[00`0YX2[00?o00000;ZU``2jYL<07`2j
YL<00ol00000hm340>?@a00@0>?@a003o`00003le9T0o=BI00T0o=BI00?o00000=c?DP3Lce800P3L
ce800ol0003oooooooooo`1=ooooo`00COooool00ol00000002;o`00000D05iV``;o00003`1kH:P0
0ol00000YX2[0:J0Z`0:0:J0Z`;o00008P2jYL<00ol00000hm340>?@a00A0>?@a003o`00003le9T0
o=BI00P0o=BI00?o00000=c?DP3Lce800P3Lce800ol0003oooooooooo`1=ooooo`00C_ooool00ol0
0000002;o`00000E05iV``;o00003@1kH:P00ol00000YX2[0:J0Z`090:J0Z`03o`00002jYL<0^ZG3
0240^ZG300?o00000>?@a03Sd<@04P3Sd<@00ol00000o=BI0?cDV@080?cDV@03o`00003Lce80g<mB
0080g<mB00?o0000ooooooooool0COooool004kooooo00?o00000000Rol000005`1NI/<00ol00000
Nf2X07]PZ00:07]PZ003o`00002VP:/0YX2[00P0YX2[00?o00000;ZU``2jYL<08P2jYL<00ol00000
hm340>?@a00B0>?@a003o`00003le9T0o=BI00P0o=BI00?o00000=c?DP3Lce800P3Lce800ol0003o
ooooooooo`1=ooooo`00Coooool00ol00000002;o`00000G05iV``;o00002P1kH:P00ol00000YX2[
0:J0Z`070:J0Z`03o`00002jYL<0^ZG302<0^ZG300?o00000>?@a03Sd<@04`3Sd<@00ol00000o=BI
0?cDV@060?cDV@03o`00003Lce80g<mB00<0g<mB00?o0000ooooooooool0COooool004oooooo00?o
00000000Rol000006@1NI/<2o`0000P0Nf2X00?o00000:J0Z`2VP:/01P2VP:/00ol00000^ZG30;ZU
``0T0;ZU``03o`00003Sd<@0hm3401<0hm3400?o00000?cDV@3le9T01P3le9T00ol00000g<mB0=c?
DP020=c?DP03o`000?oooooooooo04kooooo001@ooooo`03o`00000008_o000001X0GVK300?o0000
07]PZ01kH:P01@1kH:P00ol00000YX2[0:J0Z`050:J0Z`03o`00002jYL<0^ZG302@0^ZG300?o0000
0>?@a03Sd<@0503Sd<@00ol00000o=BI0?cDV@060?cDV@03o`00003Lce80g<mB0080g<mB00?o0000
ooooooooool0C_ooool0053ooooo00Co00000000R`0008_o00006P1NI/<2o`0000H0Nf2X00?o0000
0:J0Z`2VP:/00P2VP:/2o`0002L0^ZG300?o00000>?@a03Sd<@0503Sd<@00ol00000o=BI0?cDV@06
0?cDV@05o`00003Lce80g<mB0=c?D_l00000DOooool0057ooooo00?o00000000Rol00000701NI/<0
0ol00000Nf2X07]PZ00307]PZ005o`00002VP:/0YX2[0:J0Zol00000:@2jYL<00ol00000hm340>?@
a00E0>?@a003o`00003le9T0o=BI00@0o=BI00?o00000=c?DP3Lce800P3Lce800ol0003ooooooooo
o`1?ooooo`00DOooool01?l00000002;0000Rol0000L05iV``;o00000`1kH:P01?l00000YX2[0:J0
Zol0000Z0;ZU``03o`00003Sd<@0hm3401D0hm3400?o00000?cDV@3le9T0103le9T01Ol00000g<mB
0=c?DP3Lce;o000005;ooooo001Booooo`03o`00000008_o000001h0GVK30_l00000101kH:So0000
0:J0Zol0000Z0;ZU``03o`00003Sd<@0hm3401H0hm3400?o00000?cDV@3le9T0103le9T01Ol00000
g<mB0=c?DP3Lce;o000005;ooooo001Booooo`04o`00000008/0002;o`0001l0GVK30ol0000[0;ZU
``03o`00003Sd<@0hm3401L0hm3400?o00000?cDV@3le9T00`3le9T01?l00000g<mB0=c?D_l0001C
ooooo`00Doooool00ol00000002;o`00000O05iV``Co0000:P2jYL<00ol00000hm340>?@a00G0>?@
a003o`00003le9T0o=BI0080o=BI00Go00000=c?DP3Lce80g<mBo`00001Cooooo`00Doooool01?l0
0000002;0000Rol0000M05iV``03o`00001iUn?o00000080ZkCP1?l0000V0;ZU``03o`00003Sd<@0
hm3401L0hm3400?o00000?cDV@3le9T00P3le9T01?l00000g<mB0=c?D_l0001Dooooo`00E?ooool0
1?l00000002;0000Rol0000K05iV``05o`00001iUn<0NIOS07VGhol000001@2[]>04o`000240^ZG3
00?o00000>?@a03Sd<@06@3Sd<@01ol00000o=BI0?cDV@3le9Wo00000=c?D_l00000EOooool005Co
oooo00Co00000000R`0008_o00006P1NI/<00ol00000NIOS07VGh`0207VGh`03o`00002[]>00ZkCP
00L0ZkCP0ol0000N0;ZU``03o`00003Sd<@0hm3401T0hm3400Oo00000?cDV@3le9T0o=BIo`00003L
ce;o000005Gooooo001Eooooo`04o`00000008/0002;o`0001L0GVK30_l0000507VGh`03o`00002[
]>00ZkCP00X0ZkCP1?l0000J0;ZU``03o`00003Sd<@0hm3401T0hm3400Co00000?cDV@3le9T0o=BI
0_l0001Fooooo`00EOooool01?l00000002;0000Rol0000F05iV``03o`00001iUn<0NIOS00H0NIOS
00?o00000:^dh02[]>003@2[]>04o`0001H0^ZG300?o00000>?@a03Sd<@06@3Sd<@01_l00000o=BI
0?cDVOl00000g<mBo`0005Kooooo001Fooooo`04o`00000008/0002;o`0001@0GVK300?o000007VG
h`1iUn<01`1iUn<00ol00000ZkCP0:^dh00A0:^dh0Co00004@2jYL<00ol00000hm340>?@a00K0>?@
a004o`00003le9Wo0000o`0005Oooooo001Fooooo`04o`00000008/0002;o`0001<0GVK300?o0000
07VGh`1iUn<02@1iUn<00ol00000ZkCP0:^dh00D0:^dh0Co00003@2jYL<00ol00000hm340>?@a00K
0>?@a004o`00003le9Wo0000o`0005Oooooo001Gooooo`04o`00000008/0002;o`000140GVK300?o
000007VGh`1iUn<02P1iUn<00ol00000ZkCP0:^dh00H0:^dh0?o00002P2jYL<00ol00000hm340>?@
a00K0>?@a003o`00003le9Wo000005Sooooo001Gooooo`05o`00000008/0002;0000Rol000003P1N
I/<2o`0000d0NIOS00?o00000:^dh02[]>006`2[]>04o`0000H0^ZG300?o00000>?@a03Sd<@0703S
d<@2o`0005Sooooo001Gooooo`05o`00000008/0002;0000Rol000003@1NI/<00ol00000NIOS07VG
h`0>07VGh`03o`00002[]>00ZkCP01h0ZkCP1?l000000`2jYL?o00000>?@a00>0>?@a17o0000FOoo
ool005Sooooo00Go00000000R`0008/0002;o`00000;05iV``03o`00001iUn<0NIOS00l0NIOS00?o
00000:^dh02[]>008P2[]>0Ao`0000h0dnST00?o00000;GkcOl00000FOooool005Sooooo00Go0000
0000R`0008/0002;o`00000:05iV``03o`00001iUn<0NIOS0140NIOS00?o00000:^dh02[]>008P2[
]>000ol00000dnST0=?Xi00J0=?Xi003o`00002enlgo000005[ooooo001Iooooo`05o`00000008/0
002;0000Rol000001`1NI/<2o`0001@0NIOS00?o00000:^dh02[]>008@2[]>000ol00000dnST0=?X
i00J0=?Xi003o`00002enlgo000005_ooooo001Iooooo`05o`00000008/0002;0000Rol000001P1N
I/<00ol00000NIOS07VGh`0E07VGh`03o`00002[]>00ZkCP0200ZkCP00?o00000=?Xi03Cj>@06@3C
j>@01?l00000]O_=0;GkcOl0001Kooooo`00F_ooool01Ol00000002;0000R`0008_o000000@0GVK3
00?o000007VGh`1iUn<05P1iUn<00ol00000ZkCP0:^dh00O0:^dh003o`00003Cj>@0dnST01P0dnST
0_l000020;Gkc@03o`000?oooooooooo05[ooooo001Jooooo`03o`00000008/0002;0080002;00Co
000005iV``1NI/?o00006@1iUn<00ol00000ZkCP0:^dh00O0:^dh003o`00003Cj>@0dnST01L0dnST
00Go00000;Gkc@2enld0]O_=o`00001Mooooo`00Foooool01ol00000002;0000R`0008_o000005iV
`ol000006`1iUn<00ol00000ZkCP0:^dh00M0:^dh003o`00003Cj>@0dnST01L0dnST00?o00000;Gk
c@2enld00P2enld00ol0003oooooooooo`1Kooooo`00Foooool00ol00000002;0000R`020000R`;o
00006`1iUn<00ol00000ZkCP0:^dh00M0:^dh003o`00003Cj>@0dnST01H0dnST00?o00000;Gkc@2e
nld00P2enld00ol0003oooooooooo`1Looooo`00G?ooool01?l00000002;0000Rol000020014_P03
o`00001iUn<0NIOS01T0NIOS00?o00000:^dh02[]>00702[]>000ol00000dnST0=?Xi00E0=?Xi003
o`00002enld0]O_=0080]O_=00?o0000ooooooooool0GOooool005cooooo00?o00000000Rol00000
1000A;h00ol00000NIOS07VGh`0H07VGh`03o`00002[]>00ZkCP01/0ZkCP00?o00000=?Xi03Cj>@0
5@3Cj>@00ol00000]O_=0;Gkc@030;Gkc@03o`000?oooooooooo05gooooo001Mooooo`;o00001@00
A;h00ol00000NIOS07VGh`0G07VGh`03o`00002[]>00ZkCP01/0ZkCP00?o00000=?Xi03Cj>@04`3C
j>@2o`0000D0]O_=00?o0000ooooooooool0G_ooool005oooooo00?o00000014_P00A;h00`00A;h2
o`0001P0NIOS00?o00000:^dh02[]>006@2[]>000ol00000dnST0=?Xi00C0=?Xi003o`00002enld0
]O_=00@0]O_=00?o0000ooooooooool0Goooool0063ooooo0_l000050014_P03o`00001iUn<0NIOS
01D0NIOS00?o00000:^dh02[]>006@2[]>000ol00000dnST0=?Xi00B0=?Xi003o`00002enld0]O_=
00D0]O_=00?o0000ooooooooool0Goooool006;ooooo00?o00000014_P00A;h00`00A;h00ol00000
NIOS07VGh`0E07VGh`03o`00002[]>00ZkCP01L0ZkCP00?o00000=?Xi03Cj>@04P3Cj>@00ol00000
]O_=0;Gkc@050;Gkc@03o`000?oooooooooo063ooooo001Sooooo`03o`000000A;h004Bn00<004Bn
00?o000007VGh`1iUn<0501iUn<00ol00000ZkCP0:^dh00G0:^dh003o`00003Cj>@0dnST0140dnST
00?o00000;Gkc@2enld01@2enld00ol0003oooooooooo`1Qooooo`00I?ooool2o`0000@004Bn00?o
000007VGh`1iUn<04`1iUn<00ol00000ZkCP0:^dh00F0:^dh003o`00003Cj>@0dnST0100dnST0_l0
00080;Gkc@03o`000?oooooooooo067ooooo001Vooooo`03o`000000A;h004Bn008004Bn0_l0000D
07VGh`03o`00002[]>00ZkCP01D0ZkCP00?o00000=?Xi03Cj>@03`3Cj>@00ol00000]O_=0;Gkc@07
0;Gkc@03o`000?oooooooooo06;ooooo001Wooooo`;o00001000A;h00ol00000NIOS07VGh`0A07VG
h`03o`00002[]>00ZkCP01@0ZkCP00?o00000=?Xi03Cj>@03`3Cj>@00ol00000]O_=0;Gkc@060;Gk
c@;o0000IOooool006Wooooo00?o00000014_P00A;h00P00A;h00ol00000NIOS07VGh`0A07VGh`03
o`00002[]>00ZkCP01<0ZkCP00?o00000=?Xi03Cj>@03P3Cj>@00ol00000]O_=0;Gkc@060;Gkc@03
o`000?oooooooooo06Gooooo001Zooooo`;o00000`00A;h00ol00000NIOS07VGh`0@07VGh`03o`00
002[]>00ZkCP0180ZkCP00?o00000=?Xi03Cj>@03P3Cj>@00ol00000]O_=0;Gkc@050;Gkc@;o0000
J?ooool006cooooo00Co00000014_P00A;h004Bn0_l0000@07VGh`03o`00002[]>00ZkCP0180ZkCP
00?o00000=?Xi03Cj>@03@3Cj>@00ol00000]O_=0;Gkc@050;Gkc@03o`000?oooooooooo06Sooooo
001]ooooo`03o`000000A;h004Bn008004Bn00?o000007VGh`1iUn<03P1iUn<00ol00000ZkCP0:^d
h00@0:^dh003o`00003Cj>@0dnST00`0dnST0_l000060;Gkc@;o0000Joooool006kooooo0_l00003
0014_P03o`00001iUn<0NIOS00d0NIOS00?o00000:^dh02[]>00402[]>000ol00000dnST0=?Xi00;
0=?Xi003o`00002enld0]O_=00D0]O_=00?o0000ooooooooool0Joooool0073ooooo00Go00000014
_P00A;h004Bno`00000?07VGh`03o`00002[]>00ZkCP00l0ZkCP00?o00000=?Xi03Cj>@02P3Cj>@0
0ol00000]O_=0;Gkc@040;Gkc@;o0000K_ooool0077ooooo0_l000020014_P03o`00001iUn<0NIOS
00`0NIOS00?o00000:^dh02[]>003P2[]>000ol00000dnST0=?Xi00:0=?Xi003o`00002enld0]O_=
00<0]O_=0_l0001`ooooo`00Loooool00ol0000004Bn0014_P02o`0000`0NIOS00?o00000:^dh02[
]>003P2[]>000ol00000dnST0=?Xi0090=?Xi003o`00002enld0]O_=00<0]O_=00?o0000oooooooo
ool0L?ooool007Cooooo0_l000020014_P03o`00001iUn<0NIOS00X0NIOS00?o00000:^dh02[]>00
302[]>000ol00000dnST0=?Xi0080=?Xi0;o0000102enld2o`0007?ooooo001fooooo`04o`000000
A;h004Bno`0000/0NIOS00?o00000:^dh02[]>00302[]>000ol00000dnST0=?Xi0070=?Xi003o`00
002enld0]O_=00<0]O_=00?o0000ooooooooool0Loooool007Oooooo00Co00000014_P00A;ko0000
2`1iUn<00ol00000ZkCP0:^dh00:0:^dh003o`00003Cj>@0dnST00L0dnST00?o00000;Gkc@2enld0
0P2enld2o`0007Kooooo001hooooo`;o000000<004Bno`000?l000002@1iUn<00ol00000ZkCP0:^d
h00:0:^dh003o`00003Cj>@0dnST00H0dnST00?o00000;Gkc@2enld00P2enld00ol0003ooooooooo
o`1fooooo`00N_ooool01?l0000004Bn0014__l0000907VGh`03o`00002[]>00ZkCP00P0ZkCP00?o
00000=?Xi03Cj>@01P3Cj>@01?l00000]O_=0;Gkc@2enld2o`0007Wooooo001kooooo`;o000000<0
04Bno`00001iUn<01`1iUn<00ol00000ZkCP0:^dh0080:^dh003o`00003Cj>@0dnST00D0dnST00Go
00000;Gkc@2enld0]O_=o`00001kooooo`00OOooool00ol0000004Bno`00000707VGh`03o`00002[
]>00ZkCP00L0ZkCP00?o00000=?Xi03Cj>@0103Cj>@2o`000080]O_=0_l0001looooo`00O_ooool0
0ol0000004Bno`00000707VGh`03o`00002[]>00ZkCP00H0ZkCP00?o00000=?Xi03Cj>@00`3Cj>@0
1Ol00000]O_=0;Gkc@2enlgo000007kooooo001oooooo`Co00001@1iUn<00ol00000ZkCP0:^dh005
0:^dh003o`00003Cj>@0dnST00<0dnST00?o00000;Gkc@2enld00_l0001oooooo`00POooool00ol0
000004Bno`00000507VGh`03o`00002[]>00ZkCP00@0ZkCP00?o00000=?Xi03Cj>@00P3Cj>@01?l0
0000]O_=0;GkcOl00021ooooo`00P_ooool3o`0000@0NIOS00?o00000:^dh02[]>000`2[]>000ol0
0000dnST0=?Xi0020=?Xi004o`00002enlgo0000o`0008;ooooo0024ooooo`;o00000`1iUn<00ol0
0000ZkCP0:^dh0030:^dh003o`00003Cj>@0dnST00Co0000Q?ooool008Gooooo0ol0000207VGh`03
o`00002[]>00ZkCP0080ZkCP00Go00000=?Xi?l00000]O_=o`000026ooooo`00Qoooool2o`000003
07VGhol00000ZkCP0080ZkCP00?o00000=?Xi?l000000_l00027ooooo`00R?ooool2o`00000407VG
hol00000ZkCP0:^dh0?o0000ROooool008Wooooo0ol00000102[]>3o0000o`000?l0002:ooooo`00
Roooool00ol00000ZkCPo`00002<ooooo`00S?ooool00ol0003oooooooooo`2;ooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-5.00005*^-6, -5.00005*^-6, \
0.00355875, 0.00355875}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.44775 .57999 m .46544 .68902 L .58904 .66657 L closepath p .625 .282 .369 r
F P
0 g
s
.34815 .65113 m .46544 .68902 L .44775 .57999 L closepath p .792 .404 .319 r
F P
0 g
s
.44775 .57999 m .60159 .5619 L .58364 .44545 L closepath p .619 .487 .68 r
F P
0 g
s
.60159 .5619 m .44775 .57999 L .58904 .66657 L closepath p .58 .332 .505 r
F P
0 g
s
.44775 .57999 m .46794 .42283 L .35769 .4228 L closepath p .814 .715 .756 r
F P
0 g
s
.46794 .42283 m .44775 .57999 L .58364 .44545 L closepath p .688 .598 .75 r
F P
0 g
s
.32577 .53944 m .35769 .4228 L .44775 .57999 L closepath p .89 .728 .675 r
F P
0 g
s
.32577 .53944 m .34815 .65113 L .44775 .57999 L closepath p .894 .58 .446 r
F P
0 g
s
.46794 .42283 m .35769 .4228 L .5 .27523 L closepath p .792 .789 .849 r
F P
0 g
s
.46794 .42283 m .5 .27523 L .58364 .44545 L closepath p .655 .652 .835 r
F P
0 g
s
.58364 .44545 m .64158 .37749 L .74166 .52177 L closepath p .416 .43 .766 r
F P
0 g
s
.5 .27523 m .64158 .37749 L .58364 .44545 L closepath p .517 .58 .858 r
F P
0 g
s
.60159 .5619 m .58364 .44545 L .74166 .52177 L closepath p .489 .396 .676 r
F P
0 g
s
.58904 .66657 m .60159 .5619 L .74166 .52177 L closepath p .412 .188 .462 r
F P
0 g
s
.23786 .47638 m .35163 .34488 L .35769 .4228 L closepath p .939 .956 .755 r
F P
0 g
s
.5 .27523 m .35163 .34488 L .35769 .4228 L closepath p .84 .919 .886 r
F P
0 g
s
.32577 .53944 m .23786 .47638 L .35769 .4228 L closepath p .973 .838 .647 r
F P
0 g
s
.34815 .65113 m .32577 .53944 L .23786 .47638 L closepath p .961 .625 .287 r
F P
0 g
s
.5 .75807 m .46544 .68902 L .58904 .66657 L closepath p .441 0 .022 r
F P
0 g
s
.6535 .66048 m .5 .75807 L .58904 .66657 L closepath p .05 0 0 r
F P
0 g
s
.6535 .66048 m .58904 .66657 L .74166 .52177 L closepath p .117 0 .145 r
F P
0 g
s
.39764 .30851 m .35163 .34488 L .5 .27523 L closepath p .472 .886 .77 r
F P
0 g
s
.5 .27523 m .64158 .37749 L .66091 .33986 L closepath p .134 .466 .891 r
F P
0 g
s
.53891 .28721 m .5 .27523 L .66091 .33986 L closepath p 0 .341 .692 r
F P
0 g
s
.53891 .28721 m .39764 .30851 L .5 .27523 L closepath p .076 0 0 r
F P
0 g
s
.64158 .37749 m .74166 .52177 L .66091 .33986 L closepath p 0 .19 .718 r
F P
0 g
s
.34815 .65113 m .46544 .68902 L .5 .75807 L closepath p .634 .084 0 r
F P
0 g
s
.67321 .59397 m .70295 .45406 L .74166 .52177 L closepath p .982 .866 .492 r
F P
0 g
s
.66091 .33986 m .70295 .45406 L .74166 .52177 L closepath p .754 .399 0 r
F P
0 g
s
.6535 .66048 m .67321 .59397 L .74166 .52177 L closepath p .798 .92 .537 r
F P
0 g
s
.33849 .63976 m .23786 .47638 L .34815 .65113 L closepath p .63 .21 0 r
F P
0 g
s
.33849 .63976 m .5 .75807 L .34815 .65113 L closepath p 0 .161 .614 r
F P
0 g
s
.35163 .34488 m .23786 .47638 L .39764 .30851 L closepath p 0 0 0 r
F P
0 g
s
.6535 .66048 m .5 .75807 L .67321 .59397 L closepath p .792 .997 .861 r
F P
0 g
s
.57329 .3878 m .70295 .45406 L .66091 .33986 L closepath p .913 .521 .24 r
F P
0 g
s
.53891 .28721 m .57329 .3878 L .66091 .33986 L closepath p .743 .24 .031 r
F P
0 g
s
.38944 .5721 m .3694 .42043 L .23786 .47638 L closepath p .379 .304 .646 r
F P
0 g
s
.39764 .30851 m .3694 .42043 L .23786 .47638 L closepath p .21 0 .285 r
F P
0 g
s
.33849 .63976 m .38944 .5721 L .23786 .47638 L closepath p .237 .326 .753 r
F P
0 g
s
.53891 .28721 m .39764 .30851 L .57329 .3878 L closepath p .535 .098 .157 r
F P
0 g
s
.33849 .63976 m .38944 .5721 L .5 .75807 L closepath p .397 .555 .894 r
F P
0 g
s
.5 .75807 m .54266 .6027 L .67321 .59397 L closepath p .808 .864 .89 r
F P
0 g
s
.38944 .5721 m .54266 .6027 L .5 .75807 L closepath p .625 .675 .878 r
F P
0 g
s
.57329 .3878 m .3694 .42043 L .39764 .30851 L closepath p .506 .21 .398 r
F P
0 g
s
.70295 .45406 m .67321 .59397 L .57329 .3878 L closepath p .948 .776 .636 r
F P
0 g
s
.57329 .3878 m .54266 .6027 L .67321 .59397 L closepath p .849 .763 .767 r
F P
0 g
s
.57329 .3878 m .3694 .42043 L .38944 .5721 L closepath p .584 .452 .667 r
F P
0 g
s
.54266 .6027 m .57329 .3878 L .38944 .5721 L closepath p .681 .605 .765 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016R000`400?l00000o`00003oo`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00RP3oool5o`0008/0oooo00270?ooo`?o00001@0C
0004o`0008L0oooo00240?ooo`?o0000300C0003o`0008@0oooo00210?ooo`?o0000400C0005o`00
0840oooo001m0?ooo`Co0000300C0007o`0000<0R1TX00Co00000;hm1ol0003o0000O`3oool007X0
oooo0ol0000901<000Oo00002`286BP00ol00000_Sd70;hm1`03o`0007`0oooo001g0?ooo`?o0000
1P0C0006o`000180R1TX00?o00000;hm1`2n?@L00`2n?@L2o`0007X0oooo001d0?ooo`?o00000P0C
0007o`0001P0R1TX00?o00000;hm1`2n?@L01@2n?@L2o`0007P0oooo001a0?ooo`So000080286BP0
0ol00000_Sd70;hm1`060;hm1`;o0000MP3oool006h0oooo1?l0000W08PI:003o`00002n?@L0_Sd7
00P0_Sd70ol0001c0?ooo`00K@3oool01?l000000000o`000021=FD2o`0002H0R1TX00?o00000;hm
1`2n?@L02`2n?@L2o`000740oooo001/0?ooo`04o`000000003o0000o`0000<0PCEU0ol0000T08PI
:003o`00002n?@L0_Sd700`0_Sd70_l0001_0?ooo`00JP3oool2o`00000300000?l0003o000000L0
PCEU0_l0000R08PI:003o`00002n?@L0_Sd700h0_Sd70ol0001/0?ooo`00J@3oool01_l000000000
00000?l00000=@18o`0000T0PCEU0_l0000P08PI:003o`00002n?@L0_Sd70140_Sd70_l0001Z0?oo
o`00J03oool01?l00000000000000?l0000203D0B003o`000021=FD0PCEU00T0PCEU0ol0000N08PI
:003o`00002n?@L0_Sd70180_Sd70_l0001X0?ooo`00I`3oool01?l00000000000000?l0000303D0
B003o`000021=FD0PCEU00`0PCEU0_l0000L08PI:003o`00002n?@L0_Sd701@0_Sd70_l0001V0?oo
o`00I@3oool2o`000080000000Go000003D0B00e04P0=@18o`00000A084eI@;o00006P286BP00ol0
0000_Sd70;hm1`0F0;hm1`?o0000H`3oool006@0oooo00Go00000000000000000000o`00000403D0
B003o`000021=FD0PCEU0140PCEU0_l0000I08PI:003o`00002n?@L0_Sd701P0_Sd70_l0001Q0?oo
o`00H`3oool01Ol00000000000000000003o000000D0=@1800?o0000084eI@21=FD04`21=FD3o`00
01H0R1TX00?o00000;hm1`2n?@L06@2n?@L2o`000600oooo001R0?ooo`05o`000000000000000000
0?l000001P0e04P00ol00000PCEU084eI@0F084eI@;o00005@286BP00ol00000_Sd70;hm1`0F0;hm
1`;o000000<0jHDmo`00003oool0G`3oool00680oooo00Co000000000000003o00001P0e04P00ol0
0000PCEU084eI@0I084eI@;o00004`286BP00ol00000_Sd70;hm1`0D0;hm1`;o0000103YQCd00ol0
0000oooo0?ooo`1M0?ooo`00H@3oool01?l00000000000000?l0000703D0B003o`000021=FD0PCEU
01/0PCEU0_l0000A08PI:003o`00002n?@L0_Sd701<0_Sd700?o00000>V5?@3YQCd0103YQCd00ol0
0000oooo0?ooo`1M0?ooo`00H03oool01?l00000000000000?l0000803D0B003o`000021=FD0PCEU
01d0PCEU0ol0000?08PI:003o`00002n?@L0_Sd70100_Sd70_l000070>V5?@;o0000GP3oool005l0
oooo00Co000000000000003o00002@0e04P00ol00000PCEU084eI@0P084eI@;o00003@286BP00ol0
0000_Sd70;hm1`0>0;hm1`;o00002P3YQCd00ol00000oooo0?ooo`1L0?ooo`00GP3oool01?l00000
000000000?l0000903D0B003o`000021=FD0PCEU02<0PCEU0_l0000;08PI:003o`00002n?@L0_Sd7
00`0_Sd70_l0000<0>V5?@03o`00003oool0oooo05`0oooo001M0?ooo`04o`00000000000000o`00
00X0=@1800?o0000084eI@21=FD09@21=FD3o`0000T0R1TX00?o00000;hm1`2n?@L02@2n?@L2o`00
00h0jHDm0_l0001M0?ooo`00G03oool01?l00000000000000?l0000;03D0B003o`000021=FD0PCEU
02P0PCEU0_l0000708PI:003o`00002n?@L0_Sd700L0_Sd70_l0000A0>V5?@03o`00003oool0oooo
05/0oooo001L0?ooo`03o`000000003o000000`0=@1800?o0000084eI@21=FD0:P21=FD2o`0000D0
R1TX00?o00000;hm1`2n?@L01@2n?@L2o`0001<0jHDm0_l0001L0?ooo`00F`3oool00ol000000000
o`00000<03D0B003o`000021=FD0PCEU02d0PCEU0_l0000408PI:003o`00002n?@L0_Sd700<0_Sd7
00?o00000>V5?@3YQCd0503YQCd00ol00000oooo0?ooo`1J0?ooo`00FP3oool00ol000000000o`00
000=03D0B003o`000021=FD0PCEU02l0PCEU0ol000000`286BSo00000;hm1`020;hm1`;o00005`3Y
QCd2o`0005/0oooo001I0?ooo`03o`000000003o000000h0=@1800?o0000084eI@21=FD0<P21=FD2
o`0000030;hm1ol0003o000001T0jHDm0_l0001K0?ooo`00F03oool00ol000000000o`00000?03D0
B003o`000021=FD0PCEU0340PCEU1Ol0000K0>V5?@;o0000FP3oool005L0oooo00?o000000000?l0
00003`0e04P00ol00000PCEU084eI@0/084eI@Ko00000P2ELjX2o`0000030?;6X_l0003o000001T0
jHDm0_l0001J0?ooo`00EP3oool00ol000000000o`00000@03D0B003o`000021=FD0PCEU02H0PCEU
1_l0000709EcZP04o`00002^V/?o0000o`000080l/JR0_l0000G0>V5?@03o`000031IP3o000005T0
oooo001E0?ooo`04o`00000000000000o`000100=@1800?o0000084eI@21=FD08@21=FD5o`0000`0
UG>Z00?o00000:jJ``2^V/<00_l000040?;6XP;o00005P3YQCd2o`0005T0oooo001E0?ooo`03o`00
0000003o00000140=@1800?o0000084eI@21=FD06`21=FD6o`000100UG>Z00Co00000:jJ``2^V/?o
00000P3I`l@00ol00000l/JR0?;6XP030?;6XP;o0000503YQCd2o`0005T0oooo001D0?ooo`03o`00
0000003o00000140=@1800?o0000084eI@21=FD05P21=FD6o`0001D0UG>Z00Go00000:jJ``2^V/<0
[Y[3o`0000020=W3a003o`00003baZ80l/JR00D0l/JR00?o00000>V5?@3YQCd04P3YQCd2o`0005P0
oooo001C0?ooo`03o`000000003o00000180=@1800?o0000084eI@21=FD04021=FD6o`0001X0UG>Z
00?o00000:jJ``2^V/<00P2^V/<01Ol00000fL?40=W3a03I`lCo000000L0l/JR0_l0000B0>V5?@;o
0000F03oool00580oooo00?o000000000?l000004`0e04P00ol00000PCEU084eI@0:084eI@Ko0000
7`2ELjX00ol00000[Y[30:jJ``030:jJ``05o`00003I`l@0fL?40=W3a?l000002@3baZ82o`000100
jHDm00?o00000<5V0?l00000E`3oool00540oooo00?o000000000?l00000500e04P00ol00000PCEU
084eI@05084eI@Go0000902ELjX00ol00000[Y[30:jJ``040:jJ``03o`00003I`l@0fL?40080fL?4
00?o00000?;6XP3baZ80203baZ82o`0000l0jHDm0_l0001G0?ooo`00D03oool00ol000000000o`00
000D03D0B003o`000021=FD0PCEU00Ko0000:02ELjX00ol00000[Y[30:jJ``050:jJ``03o`00003I
`l@0fL?40080fL?400?o00000?;6XP3baZ802P3baZ82o`0000d0jHDm00?o00000<5V0?l00000EP3o
ool004l0oooo00?o000000000?l00000500e04P4o`0002d0UG>Z00?o00000:jJ``2^V/<01P2^V/<0
0ol00000fL?40=W3a0030=W3a003o`00003baZ80l/JR00/0l/JR0_l0000;0>V5?@03o`000031IP3o
000005H0oooo001?0?ooo`;o00004P0e04P3o`000003065=YOl00000UG>Z02d0UG>Z00?o00000:jJ
``2^V/<01P2^V/<00ol00000fL?40=W3a0040=W3a003o`00003baZ80l/JR00d0l/JR0_l0000:0>V5
?@03o`000031IP3o000005D0oooo001>0?ooo`;o00004@0e04P2o`0000@0HDfU00?o000009EcZP2E
LjX0:`2ELjX00ol00000[Y[30:jJ``070:jJ``03o`00003I`l@0fL?400D0fL?400?o00000?;6XP3b
aZ803P3baZ82o`0000P0jHDm00?o00000<5V0?l00000E@3oool004d0oooo0_l0000?03D0B0?o0000
1P1QCJD00ol00000UG>Z09EcZP0Z09EcZP03o`00002^V/<0[Y[300P0[Y[300?o00000=W3a03I`l@0
1@3I`l@00ol00000l/JR0?;6XP0@0?;6XP;o00001`3YQCd00ol00000`FH0o`00001D0?ooo`00C03o
ool2o`0000h0=@180_l0000:065=Y@03o`00002ELjX0UG>Z02P0UG>Z00?o00000:jJ``2^V/<02@2^
V/<00ol00000fL?40=W3a0060=W3a003o`00003baZ80l/JR0140l/JR00?o00000>V5?@3YQCd0103Y
QCd00ol00000`FH0o`00001D0?ooo`00B`3oool2o`0000`0=@180ol0000<065=Y@03o`00002ELjX0
UG>Z02L0UG>Z00?o00000:jJ``2^V/<02P2^V/<00ol00000fL?40=W3a0060=W3a003o`00003baZ80
l/JR0180l/JR0_l000040>V5?@03o`000031IP3o000005@0oooo001:0?ooo`;o00002`0e04P2o`00
00l0HDfU00?o000009EcZP2ELjX09P2ELjX00ol00000[Y[30:jJ``0;0:jJ``03o`00003I`l@0fL?4
00H0fL?400?o00000?;6XP3baZ80503baZ82o`0000<0jHDm00?o00000<5V0?l00000D`3oool004T0
oooo0_l0000903D0B0?o00004@1QCJD00ol00000UG>Z09EcZP0U09EcZP03o`00002^V/<0[Y[300`0
[Y[300?o00000=W3a03I`l@01`3I`l@00ol00000l/JR0?;6XP0E0?;6XP;o000000@0jHDmo`000031
IP3o0000D`3oool004P0oooo0_l0000803D0B0;o0000501QCJD00ol00000UG>Z09EcZP0T09EcZP03
o`00002^V/<0[Y[300`0[Y[300?o00000=W3a03I`l@0203I`l@00ol00000l/JR0?;6XP0G0?;6XP;o
00000P31IP000ol00000oooo0?ooo`1@0?ooo`00B03oool00ol00000=@1803D0B00503D0B0;o0000
5P1QCJD00ol00000UG>Z09EcZP0S09EcZP03o`00002^V/<0[Y[300d0[Y[300?o00000=W3a03I`l@0
2@3I`l@00ol00000l/JR0?;6XP0H0?;6XP03o`000031IP3o00000580oooo00170?ooo`03o`00000e
04P0=@1800<0=@180ol0000H065=Y@03o`00002ELjX0UG>Z0280UG>Z00?o00000:jJ``2^V/<03P2^
V/<00ol00000fL?40=W3a0090=W3a003o`00003baZ80l/JR01P0l/JR00Co00000<5V0031IP3o0000
D@3oool004H0oooo00?o000003D0B00e04P00P0e04P2o`0001`0HDfU00?o000009EcZP2ELjX0802E
LjX00ol00000[Y[30:jJ``0?0:jJ``03o`00003I`l@0fL?400X0fL?400?o00000?;6XP3baZ805`3b
aZ82o`0000030<5V0?l00000oooo0500oooo00150?ooo`03o`00000e04P0=@1800?o00007P1QCJD0
0ol00000UG>Z09EcZP0O09EcZP03o`00002^V/<0[Y[30100[Y[300?o00000=W3a03I`l@02P3I`l@0
0ol00000l/JR0?;6XP0F0?;6XP03o`00003kgGgo00000080`FH000?o00000?ooo`3oool0CP3oool0
04@0oooo00Co000003D0B?l0003o00008@1QCJD00ol00000UG>Z09EcZP0N09EcZP03o`00002^V/<0
[Y[30140[Y[300?o00000=W3a03I`l@02`3I`l@00ol00000l/JR0?;6XP0E0?;6XP06o`00003kgGd0
nmemo`000031IP3o0000D03oool004<0oooo0ol0000S065=Y@03o`00002ELjX0UG>Z01d0UG>Z00?o
00000:jJ``2^V/<04P2^V/<00ol00000fL?40=W3a00;0=W3a003o`00003baZ80l/JR01D0l/JR00Co
00000?_MO@3kgGd0nmem0_l0001@0?ooo`00@P3oool2o`0002D0HDfU00?o000009EcZP2ELjX0702E
LjX00ol00000[Y[30:jJ``0B0:jJ``03o`00003I`l@0fL?400d0fL?400?o00000?;6XP3baZ80503b
aZ801ol00000nmem0?_MO@3kgGgo00000<5V0?l00000C`3oool00480oooo00?o000003aC`?l00000
901QCJD00ol00000UG>Z09EcZP0K09EcZP03o`00002^V/<0[Y[301<0[Y[300?o00000=W3a03I`l@0
3@3I`l@00ol00000l/JR0?;6XP0D0?;6XP03o`00003kgGd0nmem0080nmem0_l0001?0?ooo`00@`3o
ool01?l00000?5?0o`000?l0000R065=Y@03o`00002ELjX0UG>Z01X0UG>Z00?o00000:jJ``2^V/<0
502^V/<00ol00000fL?40=W3a00>0=W3a003o`00003baZ80l/JR0180l/JR00?o00000?_MO@3kgGd0
0`3kgGd00ol00000`FH0o`00001>0?ooo`00A03oool00ol00000?5?003aC`002o`000240HDfU00?o
000009EcZP2ELjX0602ELjX00ol00000[Y[30:jJ``0E0:jJ``03o`00003I`l@0fL?400h0fL?400?o
00000?;6XP3baZ804P3baZ800ol00000nmem0?_MO@040?_MO@;o0000CP3oool004@0oooo00?o0000
03aC`00lDl000P0lDl000ol00000HDfU065=Y@0N065=Y@03o`00002ELjX0UG>Z01L0UG>Z00?o0000
0:jJ``2^V/<05P2^V/<00ol00000fL?40=W3a00?0=W3a003o`00003baZ80l/JR0140l/JR00?o0000
0?_MO@3kgGd01@3kgGd2o`0004d0oooo00150?ooo`03o`00000lDl00?5?00080?5?00_l0000N065=
Y@03o`00002ELjX0UG>Z01H0UG>Z00?o00000:jJ``2^V/<05`2^V/<00ol00000fL?40=W3a00?0=W3
a003o`00003baZ80l/JR0140l/JR00?o00000?_MO@3kgGd01@3kgGd2o`0004d0oooo00150?ooo`03
o`00000lDl00?5?000@0?5?000?o0000065=Y@1QCJD06`1QCJD00ol00000UG>Z09EcZP0E09EcZP03
o`00002^V/<0[Y[301L0[Y[300?o00000=W3a03I`l@04@3I`l@00ol00000l/JR0?;6XP0@0?;6XP03
o`00003kgGd0nmem00H0nmem0_l0001<0?ooo`00AP3oool00ol00000?5?003aC`00403aC`0;o0000
6`1QCJD00ol00000UG>Z09EcZP0D09EcZP03o`00002^V/<0[Y[301P0[Y[300?o00000=W3a03I`l@0
4@3I`l@00ol00000l/JR0?;6XP0?0?;6XP03o`00003kgGd0nmem00L0nmem0_l0001<0?ooo`00A`3o
ool00ol00000?5?003aC`00503aC`0;o00006@1QCJD00ol00000UG>Z09EcZP0C09EcZP03o`00002^
V/<0[Y[301T0[Y[300?o00000=W3a03I`l@04P3I`l@00ol00000l/JR0?;6XP0>0?;6XP03o`00003k
gGd0nmem00P0nmem0_l0001;0?ooo`00A`3oool00ol00000?5?003aC`00703aC`003o`00001QCJD0
HDfU01H0HDfU00?o000009EcZP2ELjX04P2ELjX00ol00000[Y[30:jJ``0J0:jJ``03o`00003I`l@0
fL?40180fL?400?o00000?;6XP3baZ803P3baZ800ol00000nmem0?_MO@080?_MO@;o0000B`3oool0
04P0oooo00?o000003aC`00lDl001`0lDl02o`0001L0HDfU00?o000009EcZP2ELjX0402ELjX00ol0
0000[Y[30:jJ``0K0:jJ``03o`00003I`l@0fL?401<0fL?400?o00000?;6XP3baZ803@3baZ800ol0
0000nmem0?_MO@090?_MO@03o`00003oool0oooo04T0oooo00190?ooo`03o`00000lDl00?5?000P0
?5?000?o0000065=Y@1QCJD0501QCJD00ol00000UG>Z09EcZP0?09EcZP03o`00002^V/<0[Y[301`0
[Y[300?o00000=W3a03I`l@04`3I`l@00ol00000l/JR0?;6XP0=0?;6XP03o`00003kgGd0nmem00X0
nmem00?o00000?ooo`3oool0B03oool004T0oooo00?o000003aC`00lDl002@0lDl02o`0001@0HDfU
00?o000009EcZP2ELjX03P2ELjX00ol00000[Y[30:jJ``0M0:jJ``03o`00003I`l@0fL?401@0fL?4
00?o00000?;6XP3baZ802`3baZ800ol00000nmem0?_MO@0;0?_MO@03o`00003oool0oooo04P0oooo
001:0?ooo`03o`00000lDl00?5?000X0?5?00_l0000B065=Y@03o`00002ELjX0UG>Z00d0UG>Z00?o
00000:jJ``2^V/<07@2^V/<00ol00000fL?40=W3a00E0=W3a003o`00003baZ80l/JR00/0l/JR00?o
00000?_MO@3kgGd0303kgGd00ol00000oooo0?ooo`170?ooo`00B`3oool00ol00000?5?003aC`00;
03aC`003o`00001QCJD0HDfU00l0HDfU00?o000009EcZP2ELjX0302ELjX00ol00000[Y[30:jJ``0N
0:jJ``03o`00003I`l@0fL?401H0fL?400?o00000?;6XP3baZ802P3baZ800ol00000nmem0?_MO@0<
0?_MO@03o`00003oool0oooo04L0oooo001;0?ooo`03o`00000lDl00?5?000`0?5?00_l0000?065=
Y@03o`00002ELjX0UG>Z00/0UG>Z00?o00000:jJ``2^V/<07`2^V/<00ol00000fL?40=W3a00F0=W3
a003o`00003baZ80l/JR00X0l/JR00?o00000?_MO@3kgGd02`3kgGd00ol00000oooo0?ooo`180?oo
o`00C03oool00ol00000?5?003aC`00=03aC`003o`00001QCJD0HDfU00`0HDfU00?o000009EcZP2E
LjX02P2ELjX00ol00000[Y[30:jJ``0P0:jJ``03o`00003I`l@0fL?401L0fL?400?o00000?;6XP3b
aZ802@3baZ800ol00000nmem0?_MO@0:0?_MO@03o`00003oool0oooo04T0oooo001<0?ooo`03o`00
000lDl00?5?000h0?5?00_l0000=065=Y@03o`00002ELjX0UG>Z00P0UG>Z00?o00000:jJ``2^V/<0
8@2^V/<00ol00000fL?40=W3a00G0=W3a003o`00003baZ80l/JR00P0l/JR00?o00000?_MO@3kgGd0
2P3kgGd2o`0004/0oooo001=0?ooo`03o`00000lDl00?5?000l0?5?000?o0000065=Y@1QCJD02P1Q
CJD00ol00000UG>Z09EcZP0709EcZP03o`00002^V/<0[Y[30280[Y[300?o00000=W3a03I`l@0603I
`l@00ol00000l/JR0?;6XP070?;6XP03o`00003kgGd0nmem00T0nmem0_l0001<0?ooo`00CP3oool0
0ol00000?5?003aC`00?03aC`0;o00002P1QCJD00ol00000UG>Z09EcZP0609EcZP03o`00002^V/<0
[Y[302<0[Y[300?o00000=W3a03I`l@0603I`l@00ol00000l/JR0?;6XP070?;6XP03o`00003kgGd0
nmem00P0nmem0_l0001=0?ooo`00CP3oool00ol00000?5?003aC`00A03aC`0;o0000201QCJD00ol0
0000UG>Z09EcZP0509EcZP03o`00002^V/<0[Y[302<0[Y[300?o00000=W3a03I`l@06@3I`l@00ol0
0000l/JR0?;6XP070?;6XP03o`00003kgGd0nmem00L0nmem00?o00000<c[ROl00000C@3oool004l0
oooo00?o000003aC`00lDl004P0lDl000ol00000HDfU065=Y@05065=Y@03o`00002ELjX0UG>Z00@0
UG>Z00?o00000:jJ``2^V/<0902^V/<00ol00000fL?40=W3a00J0=W3a003o`00003baZ80l/JR00H0
l/JR00?o00000?_MO@3kgGd01P3kgGd00ol00000c>^9o`00001>0?ooo`00D03oool00ol00000?5?0
03aC`00B03aC`0;o00001@1QCJD00ol00000UG>Z09EcZP0309EcZP03o`00002^V/<0[Y[302D0[Y[3
00?o00000=W3a03I`l@06P3I`l@00ol00000l/JR0?;6XP050?;6XP03o`00003kgGd0nmem00H0nmem
00Co00000<c[R@3<jhWo0000CP3oool00500oooo00?o000003aC`00lDl00500lDl000ol00000HDfU
065=Y@02065=Y@03o`00002ELjX0UG>Z0080UG>Z00?o00000:jJ``2^V/<09P2^V/<00ol00000fL?4
0=W3a00K0=W3a003o`00003baZ80l/JR00@0l/JR00?o00000?_MO@3kgGd01@3kgGd01?l00000c>^9
0<c[ROl0001?0?ooo`00D@3oool00ol00000?5?003aC`00D03aC`0;o00000`1QCJD01?l00000UG>Z
09EcZ_l0000Y0:jJ``03o`00003I`l@0fL?401/0fL?400?o00000?;6XP3baZ80103baZ800ol00000
nmem0?_MO@040?_MO@04o`00003<jhT0c>^9o`000500oooo001A0?ooo`03o`00000lDl00?5?001H0
?5?00_l00000101QCJGo000009EcZ_l0000Z0:jJ``03o`00003I`l@0fL?401`0fL?400?o00000?;6
XP3baZ800`3baZ800ol00000nmem0?_MO@030?_MO@05o`00003<jhT0c>^90<c[ROl00000D03oool0
0580oooo00?o000003aC`00lDl005`0lDl03o`0002/0[Y[300?o00000=W3a03I`l@0703I`l@00ol0
0000l/JR0?;6XP030?;6XP03o`00003kgGd0nmem0080nmem00Go00000<c[R@3<jhT0c>^9o`00001A
0?ooo`00D`3oool00ol00000?5?003aC`00G03aC`0?o0000:@2^V/<00ol00000fL?40=W3a00N0=W3
a005o`00003baZ80l/JR0?;6X_l00000103kgGd01Ol00000c>^90<c[R@3<jhWo00000580oooo001C
0?ooo`03o`00000lDl00?5?001L0?5?000?o000009n/h02O[>001Ol0000T0:jJ``03o`00003I`l@0
fL?401h0fL?400Go00000?;6XP3baZ80l/JRo`0000030?_MO@03o`00003<jhT0c>^90080c>^900?o
00000?ooo`3oool0D03oool005@0oooo00?o000003aC`00lDl005@0lDl000ol00000IHkTo`000006
09n/h0Go00007`2^V/<00ol00000fL?40=W3a00O0=W3a004o`00003baZ80l/JRo`000080nmem00?o
00000<c[R@3<jhT00P3<jhT00ol00000oooo0?ooo`1A0?ooo`00E@3oool00ol00000?5?003aC`00C
03aC`004o`00001US^@0IHkTo`0000/0WjcP1Ol0000J0:jJ``03o`00003I`l@0fL?401l0fL?400Ko
00000?;6XP3baZ;o00000?_MOOl000040<c[R@03o`00003oool0oooo0580oooo001E0?ooo`03o`00
000lDl00?5?00180?5?000?o000006F>i01US^@00P1US^@00ol00000WjcP09n/h00=09n/h0Go0000
5@2^V/<00ol00000fL?40=W3a00P0=W3a004o`00003baZ;o0000o`0000D0c>^900?o00000?ooo`3o
ool0DP3oool005H0oooo00?o000003aC`00lDl004@0lDl000ol00000IHkT06F>i00306F>i003o`00
002O[>00WjcP0140WjcP1?l0000A0:jJ``03o`00003I`l@0fL?40200fL?40ol000050<c[R@03o`00
003oool0oooo05<0oooo001F0?ooo`03o`00000lDl00?5?00100?5?000?o000006F>i01US^@0101U
S^@00ol00000WjcP09n/h00E09n/h0Go0000302^V/<00ol00000fL?40=W3a00K0=W3a0Oo00001@3<
jhT00ol00000oooo0?ooo`1D0?ooo`00E`3oool00ol00000?5?003aC`00>03aC`003o`00001US^@0
IHkT00H0IHkT00?o000009n/h02O[>006@2O[>05o`0000H0[Y[300?o00000=W3a03I`l@03`3I`l@=
o`0000@0c]gS00?o00000<[og?l000001@3<jhT00ol00000oooo0?ooo`1D0?ooo`00F03oool00ol0
0000?5?003aC`00<03aC`003o`00001US^@0IHkT00L0IHkT00?o000009n/h02O[>007P2O[>05o`00
00030:jJ`ol00000fL?400@0fL?43?l0000@0<kMh`04o`00003:om`0b_oLo`0000@0c>^900?o0000
0?ooo`3oool0E@3oool005P0oooo00?o000003aC`00lDl00300lDl000ol00000IHkT06F>i00806F>
i003o`00002O[>00WjcP0280WjcP1ol0000K0<kMh`04o`00003:om`0b_oLo`0000D0c>^900?o0000
0?ooo`3oool0E@3oool005T0oooo00?o000003aC`00lDl002P0lDl000ol00000IHkT06F>i00:06F>
i003o`00002O[>00WjcP0280WjcP00?o00000<kMh`3>gN<07@3>gN<01Ol00000b_oL0<[og03:omco
000000@0c>^900?o00000?ooo`3oool0EP3oool005X0oooo00?o000003aC`00lDl00200lDl000ol0
0000IHkT06F>i00;06F>i003o`00002O[>00WjcP0280WjcP00?o00000<kMh`3>gN<0703>gN<00ol0
0000b_oL0<[og0020<[og005o`00003<jhT0c>^90<c[ROl00000F@3oool005X0oooo00?o000003aC
`00lDl00200lDl000ol00000IHkT06F>i00<06F>i003o`00002O[>00WjcP0200WjcP00?o00000<kM
h`3>gN<0703>gN<00ol00000b_oL0<[og0020<[og003o`00003<jhT0c>^90080c>^900?o00000?oo
o`3oool0E`3oool005/0oooo00?o000003aC`00lDl001P0lDl000ol00000IHkT06F>i00=06F>i003
o`00002O[>00WjcP0200WjcP00?o00000<kMh`3>gN<06`3>gN<00ol00000b_oL0<[og0030<[og005
o`00003<jhT0c>^90<c[ROl00000FP3oool005`0oooo00?o000003aC`00lDl00100lDl000ol00000
IHkT06F>i00?06F>i003o`00002O[>00WjcP01l0WjcP00?o00000<kMh`3>gN<06P3>gN<00ol00000
b_oL0<[og0040<[og004o`00003<jhT0c>^9o`0005/0oooo001L0?ooo`03o`00000lDl00?5?000<0
?5?000?o000006F>i01US^@0401US^@00ol00000WjcP09n/h00N09n/h003o`00003>gN<0c]gS01X0
c]gS00?o00000<[og03:om`0103:om`01Ol00000c>^90<c[R@3<jhWo000005/0oooo001M0?ooo`03
o`00000lDl00?5?00080?5?000?o000006F>i01US^@04@1US^@00ol00000WjcP09n/h00M09n/h003
o`00003>gN<0c]gS01T0c]gS00?o00000<[og03:om`01@3:om`01?l00000c>^90<c[ROl0001L0?oo
o`00G@3oool01Ol00000?5?003aC`00lDl3o000001D0IHkT00?o000009n/h02O[>00702O[>000ol0
0000c]gS0<kMh`0H0<kMh`03o`00003:om`0b_oL00H0b_oL00?o00000<c[ROl00000G@3oool005h0
oooo00?o000003aC`?l000005P1US^@00ol00000WjcP09n/h00L09n/h003o`00003>gN<0c]gS01L0
c]gS00?o00000<[og03:om`01P3:om`01?l00000c>^90<c[ROl0001M0?ooo`00G`3oool2o`0001L0
IHkT00?o000009n/h02O[>006P2O[>000ol00000c]gS0<kMh`0G0<kMh`03o`00003:om`0b_oL00L0
b_oL00?o00000<c[ROl00000GP3oool005l0oooo00?o0000000YWOl000005P1US^@00ol00000WjcP
09n/h00J09n/h003o`00003>gN<0c]gS01H0c]gS00?o00000<[og03:om`0203:om`00ol00000c>^9
o`00001N0?ooo`00H03oool00ol0000002VMo`00000F06F>i003o`00002O[>00WjcP01T0WjcP00?o
00000<kMh`3>gN<05@3>gN<00ol00000b_oL0<[og0080<[og003o`00003<jhWo000005l0oooo001Q
0?ooo`Co00005@1US^@00ol00000WjcP09n/h00H09n/h003o`00003>gN<0c]gS01@0c]gS00?o0000
0<[og03:om`02@3:om`2o`000600oooo001S0?ooo`03o`000000:Igo000001@0IHkT00?o000009n/
h02O[>005`2O[>000ol00000c]gS0<kMh`0D0<kMh`03o`00003:om`0b_oL00X0b_oL0_l0001P0?oo
o`00I03oool00ol0000002VMo`00000D06F>i003o`00002O[>00WjcP01H0WjcP00?o00000<kMh`3>
gN<04`3>gN<00ol00000b_oL0<[og00:0<[og0;o0000H@3oool006D0oooo1?l0000B06F>i003o`00
002O[>00WjcP01H0WjcP00?o00000<kMh`3>gN<04P3>gN<00ol00000b_oL0<[og00:0<[og0;o0000
HP3oool006L0oooo00?o0000000YWOl000004P1US^@00ol00000WjcP09n/h00D09n/h003o`00003>
gN<0c]gS0180c]gS00?o00000<[og03:om`02P3:om`00ol00000oooo0?ooo`1R0?ooo`00J03oool3
o`000180IHkT00?o000009n/h02O[>004`2O[>000ol00000c]gS0<kMh`0A0<kMh`03o`00003:om`0
b_oL00T0b_oL0_l0001U0?ooo`00JP3oool3o`000100IHkT00?o000009n/h02O[>004`2O[>000ol0
0000c]gS0<kMh`0@0<kMh`03o`00003:om`0b_oL00T0b_oL00?o00000?ooo`3oool0I@3oool006/0
oooo00?o0000000YWOl00000401US^@00ol00000WjcP09n/h00B09n/h003o`00003>gN<0c]gS00h0
c]gS0_l0000:0<[og0;o0000J03oool006`0oooo0ol0000?06F>i003o`00002O[>00WjcP0140WjcP
00?o00000<kMh`3>gN<03P3>gN<00ol00000b_oL0<[og0090<[og003o`00003oool0oooo06P0oooo
001^0?ooo`?o00003P1US^@00ol00000WjcP09n/h00@09n/h003o`00003>gN<0c]gS00d0c]gS00?o
00000<[og03:om`0203:om`2o`0006/0oooo001_0?ooo`?o00003@1US^@00ol00000WjcP09n/h00@
09n/h003o`00003>gN<0c]gS00`0c]gS00?o00000<[og03:om`01`3:om`2o`0006d0oooo001a0?oo
o`;o00003@1US^@00ol00000WjcP09n/h00?09n/h003o`00003>gN<0c]gS00/0c]gS00?o00000<[o
g03:om`01`3:om`00ol00000oooo0?ooo`1]0?ooo`00LP3oool3o`0000`0IHkT00?o000009n/h02O
[>003@2O[>000ol00000c]gS0<kMh`0;0<kMh`03o`00003:om`0b_oL00H0b_oL0_l0001`0?ooo`00
L`3oool3o`0000/0IHkT00?o000009n/h02O[>003@2O[>000ol00000c]gS0<kMh`0:0<kMh`03o`00
003:om`0b_oL00H0b_oL00?o00000?ooo`3oool0L03oool007D0oooo0_l0000;06F>i003o`00002O
[>00WjcP00`0WjcP00?o00000<kMh`3>gN<02@3>gN<00ol00000b_oL0<[og0050<[og0;o0000L`3o
ool007H0oooo0_l0000:06F>i003o`00002O[>00WjcP00/0WjcP00?o00000<kMh`3>gN<02@3>gN<0
0ol00000b_oL0<[og0050<[og003o`00003oool0oooo07<0oooo001h0?ooo`;o00002@1US^@00ol0
0000WjcP09n/h00:09n/h003o`00003>gN<0c]gS00P0c]gS00?o00000<[og03:om`0103:om`2o`00
07H0oooo001i0?ooo`;o00002@1US^@00ol00000WjcP09n/h00909n/h003o`00003>gN<0c]gS00L0
c]gS00?o00000<[og03:om`0103:om`00ol00000oooo0?ooo`1f0?ooo`00NP3oool2o`0000P0IHkT
00?o000009n/h02O[>002@2O[>000ol00000c]gS0<kMh`060<kMh`03o`00003:om`0b_oL00<0b_oL
0_l0001i0?ooo`00O03oool2o`0000L0IHkT00?o000009n/h02O[>001`2O[>000ol00000c]gS0<kM
h`060<kMh`03o`00003:om`0b_oL00<0b_oL00?o00000?ooo`3oool0N@3oool007d0oooo0_l00006
06F>i003o`00002O[>00WjcP00L0WjcP00?o00000<kMh`3>gN<01@3>gN<00ol00000b_oL0<[og002
0<[og0;o0000O03oool007h0oooo0_l0000606F>i003o`00002O[>00WjcP00H0WjcP00?o00000<kM
h`3>gN<0103>gN<00ol00000b_oL0<[og0020<[og003o`00003oool0oooo07`0oooo00200?ooo`;o
0000101US^@00ol00000WjcP09n/h00609n/h003o`00003>gN<0c]gS00<0c]gS00Co00000<[og03:
om`0b_oL0_l0001o0?ooo`00P@3oool2o`0000@0IHkT00?o000009n/h02O[>00102O[>000ol00000
c]gS0<kMh`030<kMh`05o`00003:om`0b_oL0<[og?l00000P@3oool008<0oooo00?o000006F>i01U
S^@00P1US^@00ol00000WjcP09n/h00309n/h003o`00003>gN<0c]gS0080c]gS00?o00000<[og03:
om`00_l000220?ooo`00Q03oool2o`000080IHkT00?o000009n/h02O[>000`2O[>001_l00000c]gS
0<kMh`3>gN?o00000<[og0;o0000Q03oool008D0oooo0_l0000206F>i005o`00002O[>00WjcP09n/
h?l000000`3>gN<00ol00000b_oLo`0000260?ooo`00Q`3oool00ol00000IHkTo`00000309n/h003
o`00003>gN<0c]gS00?o0000Q`3oool008P0oooo0ol0000209n/h004o`00003>gN?o0000o`0008T0
oooo002:0?ooo`;o000000@0WjcPo`000?l0003o0000RP3oool008/0oooo0ol0002<0?ooo`00S03o
ool00ol00000oooo0?ooo`2;0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00
o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00
o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00
o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00
o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00
o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00
o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00
o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00
o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00
o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00
o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00
o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00
o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00
o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-5.00005*^-6, -5.00005*^-6, \
0.00355875, 0.00355875}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.486 .58183 m .49073 .68996 L .6144 .66191 L closepath p .567 .232 .36 r
F P
0 g
s
.36872 .65777 m .49073 .68996 L .486 .58183 L closepath p .751 .379 .348 r
F P
0 g
s
.486 .58183 m .63075 .55515 L .60739 .43861 L closepath p .567 .45 .679 r
F P
0 g
s
.63075 .55515 m .486 .58183 L .6144 .66191 L closepath p .515 .277 .491 r
F P
0 g
s
.486 .58183 m .4914 .42433 L .37684 .43254 L closepath p .781 .681 .753 r
F P
0 g
s
.4914 .42433 m .486 .58183 L .60739 .43861 L closepath p .65 .57 .751 r
F P
0 g
s
.34973 .54914 m .37684 .43254 L .486 .58183 L closepath p .851 .687 .678 r
F P
0 g
s
.34973 .54914 m .36872 .65777 L .486 .58183 L closepath p .852 .549 .476 r
F P
0 g
s
.4914 .42433 m .37684 .43254 L .5 .27523 L closepath p .77 .759 .843 r
F P
0 g
s
.4914 .42433 m .5 .27523 L .60739 .43861 L closepath p .622 .632 .839 r
F P
0 g
s
.60739 .43861 m .64786 .36592 L .75546 .50603 L closepath p .328 .385 .769 r
F P
0 g
s
.5 .27523 m .64786 .36592 L .60739 .43861 L closepath p .468 .562 .868 r
F P
0 g
s
.63075 .55515 m .60739 .43861 L .75546 .50603 L closepath p .411 .344 .672 r
F P
0 g
s
.23889 .49384 m .35026 .35716 L .37684 .43254 L closepath p .937 .908 .768 r
F P
0 g
s
.5 .27523 m .35026 .35716 L .37684 .43254 L closepath p .836 .882 .876 r
F P
0 g
s
.34973 .54914 m .23889 .49384 L .37684 .43254 L closepath p .939 .787 .665 r
F P
0 g
s
.6144 .66191 m .63075 .55515 L .75546 .50603 L closepath p .302 .094 .422 r
F P
0 g
s
.36872 .65777 m .34973 .54914 L .23889 .49384 L closepath p .942 .614 .379 r
F P
0 g
s
.37177 .31851 m .35026 .35716 L .5 .27523 L closepath p .615 .956 .835 r
F P
0 g
s
.5 .27523 m .64786 .36592 L .64397 .32698 L closepath p .025 .434 .868 r
F P
0 g
s
.5105 .28499 m .37177 .31851 L .5 .27523 L closepath p 0 0 0 r
F P
0 g
s
.5105 .28499 m .5 .27523 L .64397 .32698 L closepath p .276 0 0 r
F P
0 g
s
.5 .75807 m .49073 .68996 L .6144 .66191 L closepath p .365 0 0 r
F P
0 g
s
.36872 .65777 m .49073 .68996 L .5 .75807 L closepath p .625 .094 0 r
F P
0 g
s
.66054 .65315 m .5 .75807 L .6144 .66191 L closepath p 0 0 0 r
F P
0 g
s
.66054 .65315 m .6144 .66191 L .75546 .50603 L closepath p 0 0 .009 r
F P
0 g
s
.64786 .36592 m .75546 .50603 L .64397 .32698 L closepath p 0 .074 .631 r
F P
0 g
s
.33724 .64758 m .5 .75807 L .36872 .65777 L closepath p .505 0 0 r
F P
0 g
s
.33724 .64758 m .23889 .49384 L .36872 .65777 L closepath p .794 .338 0 r
F P
0 g
s
.35026 .35716 m .23889 .49384 L .37177 .31851 L closepath p .646 .881 .527 r
F P
0 g
s
.65519 .585 m .68244 .44034 L .75546 .50603 L closepath p .994 .841 .584 r
F P
0 g
s
.64397 .32698 m .68244 .44034 L .75546 .50603 L closepath p .891 .497 .056 r
F P
0 g
s
.66054 .65315 m .65519 .585 L .75546 .50603 L closepath p .922 .967 .668 r
F P
0 g
s
.36165 .57909 m .337 .43125 L .23889 .49384 L closepath p .238 .207 .619 r
F P
0 g
s
.37177 .31851 m .337 .43125 L .23889 .49384 L closepath p 0 0 .175 r
F P
0 g
s
.33724 .64758 m .36165 .57909 L .23889 .49384 L closepath p .057 .223 .72 r
F P
0 g
s
.66054 .65315 m .5 .75807 L .65519 .585 L closepath p .828 .975 .888 r
F P
0 g
s
.51982 .38415 m .68244 .44034 L .64397 .32698 L closepath p .878 .502 .325 r
F P
0 g
s
.5105 .28499 m .51982 .38415 L .64397 .32698 L closepath p .707 .225 .102 r
F P
0 g
s
.33724 .64758 m .36165 .57909 L .5 .75807 L closepath p .3 .512 .894 r
F P
0 g
s
.51982 .38415 m .337 .43125 L .37177 .31851 L closepath p .399 .116 .364 r
F P
0 g
s
.5105 .28499 m .37177 .31851 L .51982 .38415 L closepath p .442 .017 .134 r
F P
0 g
s
.5 .75807 m .51151 .60126 L .65519 .585 L closepath p .782 .823 .885 r
F P
0 g
s
.36165 .57909 m .51151 .60126 L .5 .75807 L closepath p .576 .644 .881 r
F P
0 g
s
.68244 .44034 m .65519 .585 L .51982 .38415 L closepath p .899 .722 .654 r
F P
0 g
s
.51982 .38415 m .337 .43125 L .36165 .57909 L closepath p .506 .395 .661 r
F P
0 g
s
.51982 .38415 m .51151 .60126 L .65519 .585 L closepath p .805 .716 .766 r
F P
0 g
s
.51151 .60126 m .51982 .38415 L .36165 .57909 L closepath p .627 .565 .765 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.52449 .58154 m .51621 .68981 L .63722 .65607 L closepath p .5 .171 .341 r
F P
0 g
s
.39229 .6633 m .51621 .68981 L .52449 .58154 L closepath p .708 .348 .364 r
F P
0 g
s
.52449 .58154 m .65716 .54666 L .6287 .43004 L closepath p .507 .408 .677 r
F P
0 g
s
.65716 .54666 m .52449 .58154 L .63722 .65607 L closepath p .436 .209 .469 r
F P
0 g
s
.52449 .58154 m .51504 .42409 L .39887 .44065 L closepath p .748 .649 .751 r
F P
0 g
s
.51504 .42409 m .52449 .58154 L .6287 .43004 L closepath p .608 .541 .753 r
F P
0 g
s
.37696 .55717 m .39887 .44065 L .52449 .58154 L closepath p .813 .649 .679 r
F P
0 g
s
.37696 .55717 m .39229 .6633 L .52449 .58154 L closepath p .808 .517 .496 r
F P
0 g
s
.51504 .42409 m .39887 .44065 L .5 .27523 L closepath p .746 .731 .838 r
F P
0 g
s
.51504 .42409 m .5 .27523 L .6287 .43004 L closepath p .587 .612 .844 r
F P
0 g
s
.24764 .51045 m .35344 .36915 L .39887 .44065 L closepath p .916 .857 .769 r
F P
0 g
s
.5 .27523 m .35344 .36915 L .39887 .44065 L closepath p .823 .845 .865 r
F P
0 g
s
.37696 .55717 m .24764 .51045 L .39887 .44065 L closepath p .901 .74 .673 r
F P
0 g
s
.39229 .6633 m .37696 .55717 L .24764 .51045 L closepath p .905 .588 .435 r
F P
0 g
s
.6287 .43004 m .64983 .35382 L .76219 .48914 L closepath p .213 .329 .766 r
F P
0 g
s
.5 .27523 m .64983 .35382 L .6287 .43004 L closepath p .41 .543 .879 r
F P
0 g
s
.65716 .54666 m .6287 .43004 L .76219 .48914 L closepath p .311 .279 .661 r
F P
0 g
s
.63722 .65607 m .65716 .54666 L .76219 .48914 L closepath p .151 0 .358 r
F P
0 g
s
.35086 .33037 m .35344 .36915 L .5 .27523 L closepath p .722 .988 .876 r
F P
0 g
s
.5 .27523 m .64983 .35382 L .62164 .31558 L closepath p 0 .398 .82 r
F P
0 g
s
.48166 .28534 m .35086 .33037 L .5 .27523 L closepath p 0 0 0 r
F P
0 g
s
.48166 .28534 m .5 .27523 L .62164 .31558 L closepath p .282 0 0 r
F P
0 g
s
.5 .75807 m .51621 .68981 L .63722 .65607 L closepath p .27 0 0 r
F P
0 g
s
.39229 .6633 m .51621 .68981 L .5 .75807 L closepath p .601 .088 0 r
F P
0 g
s
.34093 .65519 m .5 .75807 L .39229 .6633 L closepath p .588 .015 0 r
F P
0 g
s
.34093 .65519 m .24764 .51045 L .39229 .6633 L closepath p .858 .404 .051 r
F P
0 g
s
.35344 .36915 m .24764 .51045 L .35086 .33037 L closepath p .83 .972 .661 r
F P
0 g
s
.66292 .64546 m .5 .75807 L .63722 .65607 L closepath p 0 0 0 r
F P
0 g
s
.66292 .64546 m .63722 .65607 L .76219 .48914 L closepath p 0 0 0 r
F P
0 g
s
.64983 .35382 m .76219 .48914 L .62164 .31558 L closepath p 0 0 .481 r
F P
0 g
s
.33929 .58737 m .31124 .44396 L .24764 .51045 L closepath p .039 .07 .565 r
F P
0 g
s
.35086 .33037 m .31124 .44396 L .24764 .51045 L closepath p 0 0 .003 r
F P
0 g
s
.34093 .65519 m .33929 .58737 L .24764 .51045 L closepath p 0 .081 .64 r
F P
0 g
s
.63128 .57704 m .65479 .42808 L .76219 .48914 L closepath p .96 .79 .629 r
F P
0 g
s
.62164 .31558 m .65479 .42808 L .76219 .48914 L closepath p .917 .522 .21 r
F P
0 g
s
.66292 .64546 m .63128 .57704 L .76219 .48914 L closepath p .953 .941 .732 r
F P
0 g
s
.34093 .65519 m .33929 .58737 L .5 .75807 L closepath p .179 .459 .883 r
F P
0 g
s
.46539 .38473 m .31124 .44396 L .35086 .33037 L closepath p .256 0 .306 r
F P
0 g
s
.48166 .28534 m .35086 .33037 L .46539 .38473 L closepath p .324 0 .086 r
F P
0 g
s
.66292 .64546 m .5 .75807 L .63128 .57704 L closepath p .834 .937 .895 r
F P
0 g
s
.46539 .38473 m .65479 .42808 L .62164 .31558 L closepath p .828 .468 .375 r
F P
0 g
s
.48166 .28534 m .46539 .38473 L .62164 .31558 L closepath p .654 .192 .143 r
F P
0 g
s
.5 .75807 m .47989 .60148 L .63128 .57704 L closepath p .751 .784 .88 r
F P
0 g
s
.33929 .58737 m .47989 .60148 L .5 .75807 L closepath p .519 .613 .886 r
F P
0 g
s
.46539 .38473 m .31124 .44396 L .33929 .58737 L closepath p .409 .326 .65 r
F P
0 g
s
.47989 .60148 m .46539 .38473 L .33929 .58737 L closepath p .566 .524 .767 r
F P
0 g
s
.65479 .42808 m .63128 .57704 L .46539 .38473 L closepath p .848 .672 .663 r
F P
0 g
s
.46539 .38473 m .47989 .60148 L .63128 .57704 L closepath p .761 .673 .765 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016R000`400?l00000o`00003oo`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00R`3oool4o`0008/0oooo00280?ooo`?o00001018
0003o`0008P0oooo00250?ooo`Co00002@180003o`0008D0oooo00220?ooo`So00002`180003o`00
0880oooo001o0?ooo`Ko00000P1B01H00ol00000Yc4T0:La9005o`0000T0B0000ol0001o0?ooo`00
O@3oool5o`0000D0DP0F00?o00000:La902W<B@01@2W<B@5o`0000L0B0000ol0001l0?ooo`00NP3o
ool5o`0000P0DP0F00?o00000:La902W<B@02P2W<B@5o`0000D0B0000ol0001i0?ooo`00M`3oool5
o`0000X0DP0F00?o00000:La902W<B@0402W<B@5o`0000<0B0000ol0001f0?ooo`00M03oool5o`00
00d0DP0F00?o00000:La902W<B@05@2W<B@5o`00000404P00?l0003o0000o`0007<0oooo001a0?oo
o`Go0000401B01H00ol00000Yc4T0:La900J0:La90Oo0000L03oool006l0oooo1?l0000C05805P03
o`00002W<B@0Yc4T01l0Yc4T1Ol0001]0?ooo`00K03oool4o`0001H0DP0F00?o00000:La902W<B@0
902W<B@2o`0006/0oooo001Y0?ooo`Co0000601B01H00ol00000Yc4T0:La900S0:La90;o000000<0
dgMOo`00003oool0JP3oool006H0oooo1?l0000K05805P03o`00002W<B@0Yc4T0200Yc4T0ol00003
0==gG`;o0000JP3oool006<0oooo1?l0000N05805P03o`00002W<B@0Yc4T01h0Yc4T0_l000070==g
G`;o0000J@3oool00680oooo0_l0000Q05805P03o`00002W<B@0Yc4T01`0Yc4T0_l000090==gG`03
o`00003ZQCGo000006P0oooo001R0?ooo`04o`00001104ko0000o`0001l0DP0F00?o00000:La902W
<B@06P2W<B@2o`0000/0dgMO00Co00000>Z5=@3ZQCGo0000I`3oool00640oooo00?o00000440CP11
04h00P1104h2o`0001d0DP0F00?o00000:La902W<B@0602W<B@2o`0000h0dgMO00?o00000>Z5=Ol0
0000I`3oool00640oooo00?o00000440CP1104h0101104h2o`0001X0DP0F00?o00000:La902W<B@0
5P2W<B@3o`000100dgMO00Co00000>Z5=@3ZQCGo0000IP3oool00600oooo0_l000080440CP;o0000
601B01H00ol00000Yc4T0:La900D0:La90;o00004`3CMel01Ol00000jXDe0>Z5=@3ZQCGo000006D0
oooo001O0?ooo`;o00002`1104h2o`0001H0DP0F00?o00000:La902W<B@04P2W<B@2o`0001D0dgMO
00?o00000>Z5=@3ZQCD00P3ZQCD00ol00000oooo0?ooo`1R0?ooo`00G`3oool2o`0000d0@@1>0_l0
000D05805P03o`00002W<B@0Yc4T0100Yc4T0_l0000H0==gG`03o`00003ZQCD0jXDe0080jXDe00?o
00000?ooo`3oool0H@3oool005h0oooo00?o000000000?l000003`1104h2o`000180DP0F00?o0000
0:La902W<B@03P2W<B@2o`0001X0dgMO00?o00000>Z5=@3ZQCD00`3ZQCD00ol00000oooo0?ooo`1P
0?ooo`00GP3oool2o`000180@@1>0_l0000@05805P03o`00002W<B@0Yc4T00/0Yc4T0ol0000L0==g
G`03o`00003ZQCD0jXDe00<0jXDe00?o00000?ooo`3oool0H03oool005d0oooo00?o000000000?l0
0000501104h2o`0000d0DP0F00?o00000:La902W<B@02P2W<B@2o`000200dgMO00?o00000>Z5=@3Z
QCD00`3ZQCD00ol00000oooo0?ooo`1O0?ooo`00G@3oool00ol000000000o`00000F0440CP;o0000
2`1B01H00ol00000Yc4T0:La90080:La90;o00008P3CMel00ol00000jXDe0>Z5=@040>Z5=@03o`00
003oool0oooo05h0oooo001L0?ooo`03o`000000003o000001T0@@1>0_l0000905805P03o`00002W
<B@0Yc4T00H0Yc4T0_l0000T0==gG`03o`00003ZQCD0jXDe00D0jXDe00?o00000?ooo`3oool0G@3o
ool005/0oooo00Co000000000000003o00006`1104h2o`0000L0DP0F00?o00000:La902W<B@0102W
<B@2o`0002H0dgMO00?o00000>Z5=@3ZQCD01P3ZQCD00ol00000oooo0?ooo`1L0?ooo`00F`3oool0
1?l00000000000000?l0000M0440CP;o00001@1B01H01?l00000Yc4T0:La902W<B@3o`0002T0dgMO
00?o00000>Z5=@3ZQCD01@3ZQCD00ol00000oooo0?ooo`1L0?ooo`00FP3oool01?l0000000000000
0?l0000P0440CP;o00000P1B01H00ol00000Yc4T0:La9002o`0002`0dgMO00?o00000>Z5=@3ZQCD0
1P3ZQCD00ol00000oooo0?ooo`1K0?ooo`00FP3oool01?l00000000000000?l0000R0440CPGo0000
;P3CMel00ol00000jXDe0>Z5=@070>Z5=@03o`00003oool0oooo05X0oooo001I0?ooo`05o`000000
0000000000000?l000008`1104h4o`0002h0dgMO00?o00000>Z5=@3ZQCD0203ZQCD00ol00000oooo
0?ooo`1I0?ooo`00F@3oool01?l00000000000000?l0000Q0440CP?o000000@0J5>Vo`00003I[:T0
fJbY1Ol0000Z0==gG`03o`00003ZQCD0jXDe00P0jXDe00?o00000?ooo`3oool0F03oool005P0oooo
00Go00000000000000000000o`00000N0440CP?o00000`1XDjH3o`0000H0fJbY1?l0000V0==gG`03
o`00003ZQCD0jXDe00T0jXDe00?o00000?ooo`3oool0E`3oool005L0oooo00?o0000000000000000
0P0000000ol00000@@1>0440CP0J0440CP;o00001@1XDjH01Ol00000T8K4o`000032[<?o000000T0
fJbY1?l0000R0==gG`03o`00003ZQCD0jXDe00T0jXDe00?o00000?ooo`3oool0E`3oool005L0oooo
00Go00000000000000000000o`00000J0440CP?o00001`1XDjH00ol00000T8K4o`0000020<:/``03
o`00003I[:T0fJbY00X0fJbY1Ol0000N0==gG`03o`00003ZQCD0jXDe00T0jXDe00?o00000?ooo`3o
ool0EP3oool005H0oooo00?o00000000000000000P0000000ol00000@@1>0440CP0E0440CP?o0000
2@1XDjH01?l00000T8K40926a?l000030<:/``03o`00003I[:T0fJbY00h0fJbY1?l0000J0==gG`03
o`00003ZQCD0jXDe00X0jXDe00?o00000?ooo`3oool0E@3oool005H0oooo00?o0000000000000000
0P0000000ol00000@@1>0440CP0C0440CP;o0000301XDjH01?l00000T8K40926a?l000040<:/``03
o`00003I[:T0fJbY0140fJbY1Ol0000E0==gG`03o`00003ZQCD0jXDe00/0jXDe00?o00000?ooo`3o
ool0E03oool005D0oooo00?o00000000000000000P0000000ol00000@@1>0440CP0A0440CP?o0000
3@1XDjH01Ol00000T8K40926a02@Q/Co000000D0`Zc300?o00000=V/Z@3I[:T05@3I[:T4o`000140
dgMO00?o00000>Z5=@3ZQCD0303ZQCD00ol00000oooo0?ooo`1C0?ooo`00E@3oool00ol000000000
0000000200000003o`00001104h0@@1>00h0@@1>0ol0000?06QCYP03o`00002@Q/@0T8K40080T8K4
00?o00000<:/``32[<<01032[<<00ol00000fJbY0=V/Z@0H0=V/Z@Go00003@3CMel00ol00000jXDe
0>Z5=@0;0>Z5=@03o`00003oool0oooo05<0oooo001D0?ooo`03o`0000000000000000<0000000?o
00000440CP1104h02`1104h3o`000180J5>V00?o00000926a02@Q/@00`2@Q/@00ol00000`Zc30<:/
``030<:/``03o`00003I[:T0fJbY01d0fJbY1?l000090==gG`03o`00003ZQCD0jXDe00`0jXDe00?o
00000?ooo`3oool0DP3oool005<0oooo00?o00000000000000000`0000000ol00000@@1>0440CP0:
0440CP;o0000501XDjH00ol00000T8K40926a0040926a003o`000032[<<0`Zc300@0`Zc300?o0000
0=V/Z@3I[:T0803I[:T4o`0000D0dgMO00?o00000>Z5=@3ZQCD03@3ZQCD00ol00000oooo0?ooo`1A
0?ooo`00D`3oool00ol0000000000000000300000003o`00001104h0@@1>00L0@@1>0ol0000F06QC
YP03o`00002@Q/@0T8K400@0T8K400?o00000<:/``32[<<01@32[<<00ol00000fJbY0=V/Z@0S0=V/
Z@Go000000<0dgMOo`00003ZQCD03P3ZQCD00ol00000oooo0?ooo`1@0?ooo`00DP3oool00ol00000
00000000000400000003o`00001104h0@@1>00@0@@1>0ol0000H06QCYP03o`00002@Q/@0T8K400D0
T8K400?o00000<:/``32[<<01P32[<<00ol00000fJbY0=V/Z@0W0=V/Z@?o00003`3ZQCD00ol00000
oooo0?ooo`1?0?ooo`00DP3oool00ol0000000000000000300000003o`00001104h0@@1>00<0@@1>
0_l0000J06QCYP03o`00002@Q/@0T8K400H0T8K400?o00000<:/``32[<<01`32[<<00ol00000fJbY
0=V/Z@0W0=V/Z@04o`00003ebZ7o0000o`0000h0jXDe00?o00000?ooo`3oool0CP3oool00540oooo
00?o0000000000000000100000000ol00000@@1>0440CP03o`0001`0J5>V00?o00000926a02@Q/@0
1P2@Q/@00ol00000`Zc30<:/``080<:/``03o`00003I[:T0fJbY02H0fJbY00Co00000?G:X@3ebZ40
mLZQ0_l0000<0>Z5=@03o`00003oool0oooo04h0oooo001A0?ooo`03o`0000000000000000@00000
0ol0000N06QCYP03o`00002@Q/@0T8K400L0T8K400?o00000<:/``32[<<02@32[<<00ol00000fJbY
0=V/Z@0U0=V/Z@03o`00003ebZ40mLZQ00<0mLZQ00?o00000>Z5=@3ZQCD02P3ZQCD00ol00000oooo
0?ooo`1=0?ooo`00D03oool00ol0000000000000000400000003o`00001XDjH0J5>V01h0J5>V00?o
00000926a02@Q/@0202@Q/@00ol00000`Zc30<:/``090<:/``03o`00003I[:T0fJbY02@0fJbY00?o
00000?G:X@3ebZ401@3ebZ42o`0000/0jXDe00?o00000?ooo`3oool0C03oool00500oooo00?o0000
000000000000100000000ol00000J5>V06QCYP0N06QCYP03o`00002@Q/@0T8K400P0T8K400?o0000
0<:/``32[<<02P32[<<00ol00000fJbY0=V/Z@0S0=V/Z@03o`00003ebZ40mLZQ00L0mLZQ0_l0000:
0>Z5=@03o`00003oool0oooo04/0oooo001?0?ooo`03o`0000000000000000@000000_l0000O06QC
YP03o`00002@Q/@0T8K400T0T8K400?o00000<:/``32[<<02`32[<<00ol00000fJbY0=V/Z@0R0=V/
Z@03o`00003ebZ40mLZQ00T0mLZQ0_l000090>Z5=@03o`00003oool0oooo04X0oooo001>0?ooo`03
o`0000000000000000@0000000?o000000TAT?l000007`1XDjH00ol00000T8K40926a0090926a003
o`000032[<<0`Zc300`0`Zc300?o00000=V/Z@3I[:T08@3I[:T00ol00000mLZQ0?G:X@0;0?G:X@;o
00001`3ZQCD00ol00000oooo0?ooo`1:0?ooo`00CP3oool00ol0000000000000000300000005o`00
00094I002A6@00TAT?l000007@1XDjH00ol00000T8K40926a00:0926a003o`000032[<<0`Zc300d0
`Zc300?o00000=V/Z@3I[:T0803I[:T00ol00000mLZQ0?G:X@0=0?G:X@;o00001P3ZQCD00ol00000
oooo0?ooo`190?ooo`00C@3oool00ol0000000000000000300000003o`0000094I002A6@00802A6@
00?o000006QCYP1XDjH06P1XDjH00ol00000T8K40926a00;0926a003o`000032[<<0`Zc300h0`Zc3
00?o00000=V/Z@3I[:T07`3I[:T00ol00000mLZQ0?G:X@0?0?G:X@03o`00003ZQCD0jXDe00@0jXDe
00?o00000?ooo`3oool0B03oool004d0oooo00?o00000000000000000P0000000ol000002A6@00TA
T00300TAT003o`00001XDjH0J5>V01X0J5>V00?o00000926a02@Q/@02`2@Q/@00ol00000`Zc30<:/
``0?0<:/``03o`00003I[:T0fJbY01h0fJbY00?o00000?G:X@3ebZ40403ebZ42o`0000D0jXDe00?o
00000?ooo`3oool0A`3oool004`0oooo00?o00000000000000000P0000000ol000002A6@00TAT004
00TAT003o`00001XDjH0J5>V01T0J5>V00?o00000926a02@Q/@0302@Q/@00ol00000`Zc30<:/``0@
0<:/``03o`00003I[:T0fJbY01`0fJbY00?o00000?G:X@3ebZ404`3ebZ42o`0000@0jXDe00?o0000
0?ooo`3oool0AP3oool004`0oooo00Go00000000000000000000o`00000700TAT003o`00001XDjH0
J5>V01T0J5>V00?o00000926a02@Q/@03@2@Q/@00ol00000`Zc30<:/``0?0<:/``03o`00003I[:T0
fJbY01`0fJbY00?o00000?G:X@3ebZ405@3ebZ42o`0000<0jXDe00?o00000?ooo`3oool0A@3oool0
04/0oooo00Go00000000000000000000o`00000900TAT003o`00001XDjH0J5>V01L0J5>V00?o0000
0926a02@Q/@03P2@Q/@00ol00000`Zc30<:/``0@0<:/``03o`00003I[:T0fJbY01/0fJbY00?o0000
0?G:X@3ebZ405`3ebZ42o`0000030>Z5=Ol00000oooo04H0oooo001:0?ooo`05o`00000000000000
00000?l000002P094I000ol00000J5>V06QCYP0F06QCYP03o`00002@Q/@0T8K400l0T8K400?o0000
0<:/``32[<<04@32[<<00ol00000fJbY0=V/Z@0J0=V/Z@03o`00003ebZ40mLZQ01T0mLZQ00?o0000
0>Z5=Ol00000AP3oool004X0oooo00Co000000000000003o00002`094I000ol00000J5>V06QCYP0F
06QCYP03o`00002@Q/@0T8K400l0T8K400?o00000<:/``32[<<04P32[<<00ol00000fJbY0=V/Z@0I
0=V/Z@03o`00003ebZ40mLZQ01X0mLZQ0ol000150?ooo`00B@3oool01?l00000000000000?l0000<
00TAT003o`00001XDjH0J5>V01D0J5>V00?o00000926a02@Q/@0402@Q/@00ol00000`Zc30<:/``0C
0<:/``03o`00003I[:T0fJbY01P0fJbY00?o00000?G:X@3ebZ40703ebZ42o`0004@0oooo00190?oo
o`03o`000000003o000000d02A6@00?o000006QCYP1XDjH0501XDjH00ol00000T8K40926a00A0926
a003o`000032[<<0`Zc301@0`Zc300?o00000=V/Z@3I[:T05`3I[:T00ol00000mLZQ0?G:X@0M0?G:
X@;o0000@`3oool004P0oooo00?o000000000?l000003`094I000ol00000J5>V06QCYP0C06QCYP03
o`00002@Q/@0T8K40140T8K400?o00000<:/``32[<<05@32[<<00ol00000fJbY0=V/Z@0E0=V/Z@03
o`00003ebZ40mLZQ01d0mLZQ00?o00000??`^ol00000@`3oool004P0oooo0_l0000@00TAT003o`00
001XDjH0J5>V0180J5>V00?o00000926a02@Q/@04P2@Q/@00ol00000`Zc30<:/``0F0<:/``03o`00
003I[:T0fJbY01@0fJbY00?o00000?G:X@3ebZ406`3ebZ42o`0000030??`^ol00000oooo04<0oooo
00170?ooo`;o00004@094I000ol00000J5>V06QCYP0B06QCYP03o`00002@Q/@0T8K40180T8K400?o
00000<:/``32[<<05P32[<<00ol00000fJbY0=V/Z@0D0=V/Z@03o`00003ebZ40mLZQ01X0mLZQ00Co
00000??`^`3cl;_o0000A@3oool004H0oooo0_l0000B00TAT003o`00001XDjH0J5>V0140J5>V00?o
00000926a02@Q/@04`2@Q/@00ol00000`Zc30<:/``0G0<:/``03o`00003I[:T0fJbY01<0fJbY00?o
00000?G:X@3ebZ40603ebZ42o`0000<0lo2k00?o00000?ooo`3oool0@`3oool004H0oooo00?o0000
00TAT0094I004@094I000ol00000J5>V06QCYP0@06QCYP03o`00002@Q/@0T8K401@0T8K400?o0000
0<:/``32[<<06032[<<00ol00000fJbY0=V/Z@0B0=V/Z@03o`00003ebZ40mLZQ01L0mLZQ00?o0000
0??`^`3cl;/00P3cl;/00ol00000oooo0?ooo`140?ooo`00A@3oool2o`0001@02A6@00?o000006QC
YP1XDjH03`1XDjH00ol00000T8K40926a00D0926a003o`000032[<<0`Zc301T0`Zc300?o00000=V/
Z@3I[:T04@3I[:T00ol00000mLZQ0?G:X@0E0?G:X@;o0000103cl;/00ol00000oooo0?ooo`150?oo
o`00A@3oool00ol0000001BSo`00000C00TAT003o`00001XDjH0J5>V00h0J5>V00?o00000926a02@
Q/@05@2@Q/@00ol00000`Zc30<:/``0J0<:/``03o`00003I[:T0fJbY0100fJbY00?o00000?G:X@3e
bZ40503ebZ400ol00000lo2k0??`^`040??`^`03o`00003oool0oooo04D0oooo00160?ooo`03o`00
00005:?o000001802A6@00?o000006QCYP1XDjH03P1XDjH00ol00000T8K40926a00E0926a003o`00
0032[<<0`Zc301/0`Zc300?o00000=V/Z@3I[:T03P3I[:T00ol00000mLZQ0?G:X@0C0?G:X@;o0000
1P3cl;/00ol00000oooo0?ooo`160?ooo`00A`3oool00ol0000001BSo`00000A00TAT003o`00001X
DjH0J5>V00d0J5>V00?o00000926a02@Q/@05P2@Q/@00ol00000`Zc30<:/``0L0<:/``03o`00003I
[:T0fJbY00d0fJbY00?o00000?G:X@3ebZ404P3ebZ400ol00000lo2k0??`^`060??`^`03o`00003o
ool0oooo04H0oooo00170?ooo`04o`0000005:<001BSo`0001002A6@00?o000006QCYP1XDjH0301X
DjH00ol00000T8K40926a00H0926a003o`000032[<<0`Zc301`0`Zc300?o00000=V/Z@3I[:T0303I
[:T00ol00000mLZQ0?G:X@0@0?G:X@;o0000203cl;/00ol00000oooo0?ooo`170?ooo`00B03oool0
0ol0000001BS000DX`02o`0000l02A6@00?o000006QCYP1XDjH02`1XDjH00ol00000T8K40926a00H
0926a003o`000032[<<0`Zc301`0`Zc300?o00000=V/Z@3I[:T0303I[:T00ol00000mLZQ0?G:X@0?
0?G:X@03o`00003cl;/0lo2k00L0lo2k00?o00000?ooo`3oool0B03oool004P0oooo00?o0000000D
X`005:<00P005:<00ol000002A6@00TAT00<00TAT003o`00001XDjH0J5>V00X0J5>V00?o00000926
a02@Q/@06@2@Q/@00ol00000`Zc30<:/``0M0<:/``03o`00003I[:T0fJbY00/0fJbY00?o00000?G:
X@3ebZ403@3ebZ42o`0000X0lo2k00?o00000?ooo`3oool0B03oool004T0oooo00?o0000000DX`00
5:<00P005:<00ol000002A6@00TAT00;00TAT003o`00001XDjH0J5>V00X0J5>V00?o00000926a02@
Q/@06@2@Q/@00ol00000`Zc30<:/``0N0<:/``03o`00003I[:T0fJbY00X0fJbY00?o00000?G:X@3e
bZ40303ebZ400ol00000lo2k0??`^`090??`^`03o`00003oool0oooo04T0oooo001:0?ooo`03o`00
00005:<001BS008001BS00?o000000TAT0094I002P094I000ol00000J5>V06QCYP0906QCYP03o`00
002@Q/@0T8K401X0T8K400?o00000<:/``32[<<07`32[<<00ol00000fJbY0=V/Z@090=V/Z@03o`00
003ebZ40mLZQ00/0mLZQ00?o00000??`^`3cl;/02@3cl;/00ol00000oooo0?ooo`1:0?ooo`00BP3o
ool00ol0000001BS000DX`03000DX`03o`0000094I002A6@00T02A6@00?o000006QCYP1XDjH0201X
DjH00ol00000T8K40926a00K0926a003o`000032[<<0`Zc30200`Zc300?o00000=V/Z@3I[:T01`3I
[:T00ol00000mLZQ0?G:X@0:0?G:X@;o0000303cl;/00ol00000oooo0?ooo`1:0?ooo`00B`3oool0
0ol0000001BS000DX`03000DX`03o`0000094I002A6@00T02A6@00?o000006QCYP1XDjH01`1XDjH0
0ol00000T8K40926a00K0926a003o`000032[<<0`Zc30240`Zc300?o00000=V/Z@3I[:T01P3I[:T0
0ol00000mLZQ0?G:X@090?G:X@03o`00003cl;/0lo2k00/0lo2k00?o00000?ooo`3oool0B`3oool0
04`0oooo00?o0000000DX`005:<00`005:<2o`0000T02A6@00?o000006QCYP1XDjH01P1XDjH00ol0
0000T8K40926a00L0926a003o`000032[<<0`Zc30280`Zc300?o00000=V/Z@3I[:T01@3I[:T00ol0
0000mLZQ0?G:X@070?G:X@;o00003@3cl;/00ol00000oooo0?ooo`1<0?ooo`00C03oool00ol00000
01BS000DX`05000DX`03o`0000094I002A6@00H02A6@00?o000006QCYP1XDjH01@1XDjH00ol00000
T8K40926a00M0926a003o`000032[<<0`Zc30280`Zc300?o00000=V/Z@3I[:T01@3I[:T00ol00000
mLZQ0?G:X@060?G:X@03o`00003cl;/0lo2k00d0lo2k00?o00000?ooo`3oool0C03oool004d0oooo
00?o0000000DX`005:<01@005:<00ol000002A6@00TAT00500TAT003o`00001XDjH0J5>V00D0J5>V
00?o00000926a02@Q/@07@2@Q/@00ol00000`Zc30<:/``0S0<:/``03o`00003I[:T0fJbY00@0fJbY
00?o00000?G:X@3ebZ40103ebZ42o`0000l0lo2k00?o00000?ooo`3oool0C@3oool004h0oooo00?o
0000000DX`005:<01@005:<00ol000002A6@00TAT00400TAT003o`00001XDjH0J5>V00@0J5>V00?o
00000926a02@Q/@07P2@Q/@00ol00000`Zc30<:/``0T0<:/``03o`00003I[:T0fJbY00<0fJbY00?o
00000?G:X@3ebZ400`3ebZ400ol00000lo2k0??`^`0?0??`^`03o`00003oool0oooo04d0oooo001>
0?ooo`03o`0000005:<001BS00H001BS00?o000000TAT0094I0010094I000ol00000J5>V06QCYP03
06QCYP03o`00002@Q/@0T8K401h0T8K400?o00000<:/``32[<<09@32[<<00ol00000fJbY0=V/Z@02
0=V/Z@04o`00003ebZ40mLZQ0?G:X@;o00004@3cl;/00ol00000oooo0?ooo`1>0?ooo`00C`3oool0
0ol0000001BS000DX`06000DX`;o000010094I000ol00000J5>V06QCYP0206QCYP03o`00002@Q/@0
T8K401l0T8K400?o00000<:/``32[<<09P32[<<01?l00000fJbY0=V/ZOl000030?G:X@03o`00003c
l;/0lo2k0100lo2k00?o00000?ooo`3oool0C`3oool004l0oooo00?o0000000DX`005:<020005:<0
1Ol000002A6@00TAT0094I3o000000<0J5>V00?o00000926a02@Q/@0802@Q/@00ol00000`Zc30<:/
``0W0<:/``04o`00003I[:Wo00000?G:X@;o00004`3cl;/00ol00000oooo0?ooo`1?0?ooo`00D03o
ool00ol0000001BS000DX`08000DX`04o`0000094I002A6@o`0000<0J5>V00?o00000926a02@Q/@0
802@Q/@00ol00000`Zc30<:/``0X0<:/``?o0000503cl;/00ol00000oooo0?ooo`1@0?ooo`00D@3o
ool00ol0000001BS000DX`08000DX`03o`0000094I3o00000080J5>V00?o00000926a02@Q/@08P2@
Q/@00ol00000`Zc30<:/``0U0<:/``Co0000503cl;/00ol00000oooo0?ooo`1A0?ooo`00D@3oool0
0ol0000001BS000DX`09000DX`05o`0000094I3o000006QCY_l00000902@Q/@00ol00000`Zc30<:/
``0O0<:/``Ko00000`30b>400ol00000lo2k0??`^`0B0??`^`03o`00003oool0oooo0540oooo001B
0?ooo`03o`0000005:<001BS00T001BS0ol0000U0926a003o`000032[<<0`Zc301T0`Zc31_l00008
0<38h@03o`00003EknGo00000180lo2k00?o00000?ooo`3oool0DP3oool005<0oooo00?o0000000D
X`005:<02@005:<6o`000240T8K400?o00000<:/``32[<<04P32[<<7o`0000d0`<SQ00Co00000=G_
i@3EknGo00004@3cl;/00ol00000oooo0?ooo`1C0?ooo`00D`3oool00ol0000001BS000DX`09000D
X`03o`000024W>80Q9cR00<0Q9cR2_l0000G0926a003o`000032[<<0`Zc300`0`Zc31_l0000C0<38
h@03o`00003EknD0eNoU0080eNoU00?o00000??`^`3cl;/03P3cl;/00ol00000oooo0?ooo`1C0?oo
o`00E03oool00ol0000001BS000DX`08000DX`;o00003P24W>89o`0000h0T8K400?o00000<:/``32
[<<01P32[<<6o`0001T0`<SQ00?o00000=G_i@3EknD00P3EknD00ol00000lo2k0??`^`0=0??`^`03
o`00003oool0oooo05@0oooo001E0?ooo`03o`0000005:<001BS00L001BS00?o000002eeh_l00000
5P24W>8:o`0000@0T8K400?o00000<:/``32[<<01_l0000N0<38h@03o`00003EknD0eNoU00@0eNoU
00?o00000??`^`3cl;/0303cl;/00ol00000oooo0?ooo`1D0?ooo`00E@3oool00ol0000001BS000D
X`07000DX`04o`00000]MN80;GGRo`0001l0Q9cR1ol0000S0<38h@03o`00003EknD0eNoU00D0eNoU
00?o00000??`^`3cl;/02`3cl;/00ol00000oooo0?ooo`1E0?ooo`00EP3oool00ol0000001BS000D
X`06000DX`05o`00000]MN80;GGR02eeh_l000008P24W>800ol00000`<SQ0<38h@0S0<38h@03o`00
003EknD0eNoU00H0eNoU00?o00000??`^`3cl;/02@3cl;/00ol00000oooo0?ooo`1F0?ooo`00EP3o
ool00ol0000001BS000DX`06000DX`03o`00000]MN80;GGR0080;GGR00?o000008BLhP24W>807`24
W>800ol00000`<SQ0<38h@0R0<38h@03o`00003EknD0eNoU00L0eNoU00?o00000??`^`3cl;/02@3c
l;/00ol00000oooo0?ooo`1F0?ooo`00E`3oool00ol0000001BS000DX`05000DX`03o`00000]MN80
;GGR00<0;GGR00?o000008BLhP24W>807P24W>800ol00000`<SQ0<38h@0Q0<38h@03o`00003EknD0
eNoU00T0eNoU00?o00000??`^`3cl;/01`3cl;/00ol00000oooo0?ooo`1G0?ooo`00F03oool00ol0
000001BS000DX`04000DX`03o`00000]MN80;GGR00@0;GGR00?o000008BLhP24W>807@24W>800ol0
0000`<SQ0<38h@0P0<38h@03o`00003EknD0eNoU00X0eNoU00?o00000??`^`3cl;/01P3cl;/00ol0
0000oooo0?ooo`1H0?ooo`00F03oool00ol0000001BS000DX`04000DX`03o`00000]MN80;GGR00D0
;GGR00?o000008BLhP24W>807@24W>800ol00000`<SQ0<38h@0O0<38h@03o`00003EknD0eNoU00X0
eNoU00?o00000??`^`3cl;/01P3cl;/00ol00000oooo0?ooo`1H0?ooo`00F@3oool00ol0000001BS
000DX`03000DX`03o`00000]MN80;GGR00H0;GGR00?o000008BLhP24W>807024W>800ol00000`<SQ
0<38h@0N0<38h@03o`00003EknD0eNoU00`0eNoU00?o00000??`^`3cl;/0103cl;/00ol00000oooo
0?ooo`1I0?ooo`00FP3oool00ol0000001BS000DX`02000DX`03o`00000]MN80;GGR00L0;GGR00?o
000008BLhP24W>806`24W>800ol00000`<SQ0<38h@0M0<38h@03o`00003EknD0eNoU00d0eNoU00?o
00000??`^`3cl;/00`3cl;/00ol00000oooo0?ooo`1J0?ooo`00FP3oool00ol0000001BS000DX`02
000DX`03o`00000]MN80;GGR00P0;GGR00?o000008BLhP24W>806P24W>800ol00000`<SQ0<38h@0L
0<38h@03o`00003EknD0eNoU00l0eNoU00?o00000??`^`3cl;/00P3cl;/00ol00000oooo0?ooo`1J
0?ooo`00F`3oool01Ol0000001BS000DX`005:?o000000/0;GGR00?o000008BLhP24W>806@24W>80
0ol00000`<SQ0<38h@0L0<38h@03o`00003EknD0eNoU00l0eNoU00Go00000??`^`3cl;/0lo2ko`00
001M0?ooo`00G03oool01?l0000001BS000DXol0000<02eehP03o`000024W>80Q9cR01P0Q9cR00?o
00000<38h@30b>406`30b>400ol00000eNoU0=G_i@0A0=G_i@04o`00003cl;/0lo2ko`0005d0oooo
001L0?ooo`04o`0000005:<001BSo`0000d0;GGR00?o000008BLhP24W>805`24W>800ol00000`<SQ
0<38h@0J0<38h@03o`00003EknD0eNoU0180eNoU00?o00000??`^ol00000GP3oool005d0oooo00?o
0000000DXol000003P0]MN800ol00000Q9cR08BLhP0G08BLhP03o`000030b>40`<SQ01T0`<SQ00?o
00000=G_i@3EknD04P3EknD2o`0005l0oooo001M0?ooo`03o`0000005:?o000000h0;GGR00?o0000
08BLhP24W>805`24W>800ol00000`<SQ0<38h@0H0<38h@03o`00003EknD0eNoU0180eNoU00?o0000
0?ooo`3oool0G`3oool005h0oooo0_l0000?02eehP03o`000024W>80Q9cR01H0Q9cR00?o00000<38
h@30b>405`30b>400ol00000eNoU0=G_i@0A0=G_i@;o0000HP3oool005l0oooo0_l0000?02eehP03
o`000024W>80Q9cR01D0Q9cR00?o00000<38h@30b>405P30b>400ol00000eNoU0=G_i@0A0=G_i@03
o`00003oool0oooo0680oooo001Q0?ooo`03o`00000]MN80;GGR00d0;GGR00?o000008BLhP24W>80
5024W>800ol00000`<SQ0<38h@0F0<38h@03o`00003EknD0eNoU0100eNoU00?o00000?ooo`3oool0
H`3oool00680oooo0_l0000>02eehP03o`000024W>80Q9cR01<0Q9cR00?o00000<38h@30b>405@30
b>400ol00000eNoU0=G_i@0?0=G_i@;o0000IP3oool006@0oooo00?o000002eehP0]MN80300]MN80
0ol00000Q9cR08BLhP0B08BLhP03o`000030b>40`<SQ01@0`<SQ00?o00000=G_i@3EknD03`3EknD0
0ol00000oooo0?ooo`1V0?ooo`00I@3oool2o`0000d0;GGR00?o000008BLhP24W>804P24W>800ol0
0000`<SQ0<38h@0B0<38h@03o`00003EknD0eNoU00h0eNoU0_l0001Y0?ooo`00I`3oool2o`0000`0
;GGR00?o000008BLhP24W>804@24W>800ol00000`<SQ0<38h@0B0<38h@03o`00003EknD0eNoU00d0
eNoU00?o00000?ooo`3oool0J@3oool006T0oooo00?o000002eehP0]MN802P0]MN800ol00000Q9cR
08BLhP0@08BLhP03o`000030b>40`<SQ0140`<SQ00?o00000=G_i@3EknD0303EknD2o`0006`0oooo
001Z0?ooo`;o00002`0]MN800ol00000Q9cR08BLhP0?08BLhP03o`000030b>40`<SQ0100`<SQ00?o
00000=G_i@3EknD0303EknD00ol00000oooo0?ooo`1/0?ooo`00K03oool00ol00000;GGR02eehP09
02eehP03o`000024W>80Q9cR00h0Q9cR00?o00000<38h@30b>404030b>400ol00000eNoU0=G_i@0:
0=G_i@;o0000K`3oool006d0oooo0_l0000:02eehP03o`000024W>80Q9cR00d0Q9cR00?o00000<38
h@30b>403`30b>400ol00000eNoU0=G_i@0:0=G_i@03o`00003oool0oooo06l0oooo001_0?ooo`03
o`00000]MN80;GGR00P0;GGR00?o000008BLhP24W>803024W>800ol00000`<SQ0<38h@0>0<38h@03
o`00003EknD0eNoU00X0eNoU00?o00000?ooo`3oool0L03oool00700oooo0_l0000902eehP03o`00
0024W>80Q9cR00/0Q9cR00?o00000<38h@30b>403@30b>400ol00000eNoU0=G_i@090=G_i@;o0000
L`3oool00780oooo00?o000002eehP0]MN801`0]MN800ol00000Q9cR08BLhP0;08BLhP03o`000030
b>40`<SQ00`0`<SQ00?o00000=G_i@3EknD0203EknD00ol00000oooo0?ooo`1c0?ooo`00L`3oool2
o`0000P0;GGR00?o000008BLhP24W>802P24W>800ol00000`<SQ0<38h@0;0<38h@03o`00003EknD0
eNoU00L0eNoU0_l0001f0?ooo`00M@3oool2o`0000H0;GGR00?o000008BLhP24W>802P24W>800ol0
0000`<SQ0<38h@0:0<38h@03o`00003EknD0eNoU00L0eNoU00?o00000?ooo`3oool0MP3oool007L0
oooo00?o000002eehP0]MN80100]MN800ol00000Q9cR08BLhP0908BLhP03o`000030b>40`<SQ00X0
`<SQ00?o00000=G_i@3EknD01@3EknD2o`0007T0oooo001h0?ooo`;o00001@0]MN800ol00000Q9cR
08BLhP0808BLhP03o`000030b>40`<SQ00T0`<SQ00?o00000=G_i@3EknD01@3EknD00ol00000oooo
0?ooo`1i0?ooo`00NP3oool00ol00000;GGR02eehP0302eehP03o`000024W>80Q9cR00L0Q9cR00?o
00000<38h@30b>402030b>400ol00000eNoU0=G_i@050=G_i@03o`00003oool0oooo07X0oooo001k
0?ooo`;o0000100]MN800ol00000Q9cR08BLhP0608BLhP03o`000030b>40`<SQ00L0`<SQ00?o0000
0=G_i@3EknD0103EknD2o`0007d0oooo001m0?ooo`03o`00000]MN80;GGR0080;GGR00?o000008BL
hP24W>801P24W>800ol00000`<SQ0<38h@060<38h@03o`00003EknD0eNoU00<0eNoU00?o00000?oo
o`3oool0O@3oool007h0oooo0_l0000302eehP03o`000024W>80Q9cR00D0Q9cR00?o00000<38h@30
b>401@30b>400ol00000eNoU0=G_i@020=G_i@;o0000P03oool00800oooo00Go000002eehP0]MN80
;GGRo`00000608BLhP03o`000030b>40`<SQ00@0`<SQ00?o00000=G_i@3EknD00P3EknD00ol00000
oooo0?ooo`200?ooo`00P@3oool2o`000080;GGR00?o000008BLhP24W>800`24W>800ol00000`<SQ
0<38h@030<38h@04o`00003EknD0eNoU0=G_i@;o0000P`3oool008<0oooo00Co000002eehP0]MN;o
00001024W>800ol00000`<SQ0<38h@030<38h@04o`00003EknD0eNoUo`0008D0oooo00240?ooo`;o
000000<0;GGRo`000024W>800P24W>800ol00000`<SQ0<38h@020<38h@04o`00003EknGo0000o`00
08H0oooo00260?ooo`?o00000P24W>801ol00000`<SQ0<38h@30b>7o00000=G_iOl00000R03oool0
08P0oooo0_l0000208BLhP03o`000030b>40`<SQ00;o0000R@3oool008T0oooo0_l000000`24W>;o
00000<38h@02o`0008X0oooo002;0?ooo`?o0000S03oool008`0oooo00?o00000?ooo`3oool0R`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00001\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-5.00005*^-6, -5.00005*^-6, \
0.00355875, 0.00355875}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.56256 .57912 m .54135 .68857 L .65684 .64913 L closepath p .417 .094 .308 r
F P
0 g
s
.41824 .66762 m .54135 .68857 L .56256 .57912 L closepath p .66 .311 .37 r
F P
0 g
s
.56256 .57912 m .68009 .53652 L .64695 .41988 L closepath p .434 .359 .673 r
F P
0 g
s
.68009 .53652 m .56256 .57912 L .65684 .64913 L closepath p .334 .121 .435 r
F P
0 g
s
.56256 .57912 m .53835 .42212 L .42318 .44701 L closepath p .713 .619 .75 r
F P
0 g
s
.53835 .42212 m .56256 .57912 L .64695 .41988 L closepath p .561 .511 .757 r
F P
0 g
s
.40674 .56343 m .42318 .44701 L .56256 .57912 L closepath p .774 .613 .68 r
F P
0 g
s
.40674 .56343 m .41824 .66762 L .56256 .57912 L closepath p .765 .483 .507 r
F P
0 g
s
.26321 .52582 m .36084 .38051 L .42318 .44701 L closepath p .888 .809 .765 r
F P
0 g
s
.5 .27523 m .36084 .38051 L .42318 .44701 L closepath p .806 .811 .855 r
F P
0 g
s
.53835 .42212 m .42318 .44701 L .5 .27523 L closepath p .721 .705 .835 r
F P
0 g
s
.40674 .56343 m .26321 .52582 L .42318 .44701 L closepath p .861 .697 .677 r
F P
0 g
s
.53835 .42212 m .5 .27523 L .64695 .41988 L closepath p .547 .593 .851 r
F P
0 g
s
.41824 .66762 m .40674 .56343 L .26321 .52582 L closepath p .863 .558 .47 r
F P
0 g
s
.64695 .41988 m .64718 .34153 L .76097 .47154 L closepath p .061 .255 .748 r
F P
0 g
s
.5 .27523 m .64718 .34153 L .64695 .41988 L closepath p .342 .523 .889 r
F P
0 g
s
.68009 .53652 m .64695 .41988 L .76097 .47154 L closepath p .175 .194 .64 r
F P
0 g
s
.41824 .66762 m .54135 .68857 L .5 .75807 L closepath p .566 .066 .028 r
F P
0 g
s
.34918 .66239 m .5 .75807 L .41824 .66762 L closepath p .626 .065 0 r
F P
0 g
s
.34918 .66239 m .26321 .52582 L .41824 .66762 L closepath p .862 .427 .174 r
F P
0 g
s
.33546 .34355 m .36084 .38051 L .5 .27523 L closepath p .79 .986 .894 r
F P
0 g
s
.36084 .38051 m .26321 .52582 L .33546 .34355 L closepath p .918 .978 .732 r
F P
0 g
s
.65684 .64913 m .68009 .53652 L .76097 .47154 L closepath p 0 0 .253 r
F P
0 g
s
.5 .27523 m .64718 .34153 L .59455 .30616 L closepath p 0 .362 .749 r
F P
0 g
s
.45357 .28826 m .33546 .34355 L .5 .27523 L closepath p .361 .819 .715 r
F P
0 g
s
.45357 .28826 m .5 .27523 L .59455 .30616 L closepath p .255 0 0 r
F P
0 g
s
.5 .75807 m .54135 .68857 L .65684 .64913 L closepath p .15 0 0 r
F P
0 g
s
.32295 .59653 m .29275 .45797 L .26321 .52582 L closepath p 0 0 .455 r
F P
0 g
s
.33546 .34355 m .29275 .45797 L .26321 .52582 L closepath p 0 0 0 r
F P
0 g
s
.34918 .66239 m .32295 .59653 L .26321 .52582 L closepath p 0 0 .487 r
F P
0 g
s
.66028 .63762 m .5 .75807 L .65684 .64913 L closepath p .514 .877 .654 r
F P
0 g
s
.66028 .63762 m .65684 .64913 L .76097 .47154 L closepath p .644 .823 .403 r
F P
0 g
s
.64718 .34153 m .76097 .47154 L .59455 .30616 L closepath p .671 .159 0 r
F P
0 g
s
.34918 .66239 m .32295 .59653 L .5 .75807 L closepath p .029 .388 .849 r
F P
0 g
s
.41264 .38951 m .29275 .45797 L .33546 .34355 L closepath p .057 0 .209 r
F P
0 g
s
.45357 .28826 m .33546 .34355 L .41264 .38951 L closepath p .168 0 .005 r
F P
0 g
s
.60215 .57046 m .62074 .41788 L .76097 .47154 L closepath p .912 .736 .65 r
F P
0 g
s
.59455 .30616 m .62074 .41788 L .76097 .47154 L closepath p .89 .508 .307 r
F P
0 g
s
.66028 .63762 m .60215 .57046 L .76097 .47154 L closepath p .937 .888 .758 r
F P
0 g
s
.45357 .28826 m .41264 .38951 L .59455 .30616 L closepath p .588 .142 .159 r
F P
0 g
s
.5 .75807 m .4491 .60337 L .60215 .57046 L closepath p .717 .749 .877 r
F P
0 g
s
.32295 .59653 m .4491 .60337 L .5 .75807 L closepath p .452 .58 .891 r
F P
0 g
s
.66028 .63762 m .5 .75807 L .60215 .57046 L closepath p .822 .894 .893 r
F P
0 g
s
.41264 .38951 m .29275 .45797 L .32295 .59653 L closepath p .28 .235 .628 r
F P
0 g
s
.41264 .38951 m .62074 .41788 L .59455 .30616 L closepath p .772 .428 .404 r
F P
0 g
s
.4491 .60337 m .41264 .38951 L .32295 .59653 L closepath p .493 .477 .768 r
F P
0 g
s
.62074 .41788 m .60215 .57046 L .41264 .38951 L closepath p .797 .625 .668 r
F P
0 g
s
.41264 .38951 m .4491 .60337 L .60215 .57046 L closepath p .715 .633 .765 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.59954 .57459 m .56558 .68627 L .67262 .64122 L closepath p .311 0 .257 r
F P
0 g
s
.44591 .6707 m .56558 .68627 L .59954 .57459 L closepath p .607 .267 .368 r
F P
0 g
s
.59954 .57459 m .69877 .5249 L .66153 .40832 L closepath p .34 .298 .665 r
F P
0 g
s
.69877 .5249 m .59954 .57459 L .67262 .64122 L closepath p .196 .004 .378 r
F P
0 g
s
.59954 .57459 m .5608 .41844 L .44915 .45153 L closepath p .677 .589 .75 r
F P
0 g
s
.5608 .41844 m .59954 .57459 L .66153 .40832 L closepath p .506 .478 .761 r
F P
0 g
s
.43837 .56787 m .44915 .45153 L .59954 .57459 L closepath p .736 .58 .68 r
F P
0 g
s
.43837 .56787 m .44591 .6707 L .59954 .57459 L closepath p .72 .448 .513 r
F P
0 g
s
.28463 .53964 m .37205 .39097 L .44915 .45153 L closepath p .856 .765 .761 r
F P
0 g
s
.5 .27523 m .37205 .39097 L .44915 .45153 L closepath p .785 .779 .847 r
F P
0 g
s
.5608 .41844 m .44915 .45153 L .5 .27523 L closepath p .693 .681 .834 r
F P
0 g
s
.43837 .56787 m .28463 .53964 L .44915 .45153 L closepath p .823 .658 .679 r
F P
0 g
s
.44591 .6707 m .43837 .56787 L .28463 .53964 L closepath p .82 .525 .492 r
F P
0 g
s
.5608 .41844 m .5 .27523 L .66153 .40832 L closepath p .503 .574 .861 r
F P
0 g
s
.32583 .35751 m .37205 .39097 L .5 .27523 L closepath p .826 .964 .896 r
F P
0 g
s
.37205 .39097 m .28463 .53964 L .32583 .35751 L closepath p .941 .942 .761 r
F P
0 g
s
.44591 .6707 m .56558 .68627 L .5 .75807 L closepath p .519 .031 .037 r
F P
0 g
s
.36151 .669 m .5 .75807 L .44591 .6707 L closepath p .633 .089 0 r
F P
0 g
s
.36151 .669 m .28463 .53964 L .44591 .6707 L closepath p .839 .425 .254 r
F P
0 g
s
.32583 .35751 m .28173 .47266 L .28463 .53964 L closepath p .869 .87 .426 r
F P
0 g
s
.36151 .669 m .31287 .60622 L .28463 .53964 L closepath p .693 .257 0 r
F P
0 g
s
.31287 .60622 m .28173 .47266 L .28463 .53964 L closepath p 0 0 .262 r
F P
0 g
s
.66153 .40832 m .63975 .32946 L .75109 .45378 L closepath p 0 .156 .697 r
F P
0 g
s
.5 .27523 m .63975 .32946 L .66153 .40832 L closepath p .262 .501 .896 r
F P
0 g
s
.69877 .5249 m .66153 .40832 L .75109 .45378 L closepath p 0 .075 .593 r
F P
0 g
s
.5 .27523 m .63975 .32946 L .56363 .2992 L closepath p 0 .333 .666 r
F P
0 g
s
.42732 .29358 m .32583 .35751 L .5 .27523 L closepath p .52 .912 .793 r
F P
0 g
s
.42732 .29358 m .5 .27523 L .56363 .2992 L closepath p .197 0 0 r
F P
0 g
s
.5 .75807 m .56558 .68627 L .67262 .64122 L closepath p 0 0 0 r
F P
0 g
s
.67262 .64122 m .69877 .5249 L .75109 .45378 L closepath p 0 0 .082 r
F P
0 g
s
.36151 .669 m .31287 .60622 L .5 .75807 L closepath p 0 .299 .776 r
F P
0 g
s
.65243 .6299 m .5 .75807 L .67262 .64122 L closepath p .671 .967 .773 r
F P
0 g
s
.65243 .6299 m .67262 .64122 L .75109 .45378 L closepath p .849 .946 .586 r
F P
0 g
s
.36409 .39816 m .28173 .47266 L .32583 .35751 L closepath p 0 0 .054 r
F P
0 g
s
.42732 .29358 m .32583 .35751 L .36409 .39816 L closepath p 0 0 0 r
F P
0 g
s
.63975 .32946 m .75109 .45378 L .56363 .2992 L closepath p .742 .22 0 r
F P
0 g
s
.36409 .39816 m .28173 .47266 L .31287 .60622 L closepath p .098 .111 .583 r
F P
0 g
s
.42732 .29358 m .36409 .39816 L .56363 .2992 L closepath p .508 .075 .152 r
F P
0 g
s
.5 .75807 m .42038 .60681 L .56879 .56558 L closepath p .68 .716 .876 r
F P
0 g
s
.31287 .60622 m .42038 .60681 L .5 .75807 L closepath p .369 .542 .895 r
F P
0 g
s
.65243 .6299 m .5 .75807 L .56879 .56558 L closepath p .8 .851 .888 r
F P
0 g
s
.42038 .60681 m .36409 .39816 L .31287 .60622 L closepath p .402 .422 .766 r
F P
0 g
s
.56879 .56558 m .58146 .41029 L .75109 .45378 L closepath p .861 .685 .661 r
F P
0 g
s
.56363 .2992 m .58146 .41029 L .75109 .45378 L closepath p .842 .478 .364 r
F P
0 g
s
.65243 .6299 m .56879 .56558 L .75109 .45378 L closepath p .903 .832 .766 r
F P
0 g
s
.36409 .39816 m .58146 .41029 L .56363 .2992 L closepath p .712 .382 .418 r
F P
0 g
s
.36409 .39816 m .42038 .60681 L .56879 .56558 L closepath p .665 .593 .765 r
F P
0 g
s
.58146 .41029 m .56879 .56558 L .36409 .39816 L closepath p .745 .58 .67 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.31094 .5517 m .38662 .40027 L .47621 .45416 L closepath p .824 .726 .757 r
F P
0 g
s
.5 .27523 m .38662 .40027 L .47621 .45416 L closepath p .763 .75 .841 r
F P
0 g
s
.63473 .56796 m .58185 .41311 L .47621 .45416 L closepath p .637 .561 .752 r
F P
0 g
s
.58185 .41311 m .47621 .45416 L .5 .27523 L closepath p .664 .659 .835 r
F P
0 g
s
.47119 .57044 m .31094 .5517 L .47621 .45416 L closepath p .785 .622 .68 r
F P
0 g
s
.47119 .57044 m .47621 .45416 L .63473 .56796 L closepath p .696 .546 .68 r
F P
0 g
s
.4747 .67248 m .47119 .57044 L .31094 .5517 L closepath p .776 .492 .505 r
F P
0 g
s
.47119 .57044 m .4747 .67248 L .63473 .56796 L closepath p .673 .409 .514 r
F P
0 g
s
.63473 .56796 m .58835 .68293 L .68388 .63248 L closepath p .171 0 .178 r
F P
0 g
s
.4747 .67248 m .58835 .68293 L .63473 .56796 L closepath p .547 .214 .356 r
F P
0 g
s
.63473 .56796 m .71242 .51198 L .67184 .39558 L closepath p .215 .219 .647 r
F P
0 g
s
.71242 .51198 m .63473 .56796 L .68388 .63248 L closepath p .002 0 .286 r
F P
0 g
s
.58185 .41311 m .63473 .56796 L .67184 .39558 L closepath p .44 .442 .765 r
F P
0 g
s
.58185 .41311 m .5 .27523 L .67184 .39558 L closepath p .451 .556 .871 r
F P
0 g
s
.32197 .37174 m .38662 .40027 L .5 .27523 L closepath p .839 .931 .89 r
F P
0 g
s
.38662 .40027 m .31094 .5517 L .32197 .37174 L closepath p .931 .892 .769 r
F P
0 g
s
.30901 .61606 m .27803 .48748 L .31094 .5517 L closepath p .825 .525 0 r
F P
0 g
s
.32197 .37174 m .27803 .48748 L .31094 .5517 L closepath p .974 .903 .557 r
F P
0 g
s
.37742 .67486 m .30901 .61606 L .31094 .5517 L closepath p .823 .365 0 r
F P
0 g
s
.37742 .67486 m .31094 .5517 L .4747 .67248 L closepath p .804 .41 .307 r
F P
0 g
s
.4747 .67248 m .58835 .68293 L .5 .75807 L closepath p .462 0 .029 r
F P
0 g
s
.37742 .67486 m .5 .75807 L .4747 .67248 L closepath p .619 .094 0 r
F P
0 g
s
.5 .27523 m .62758 .31802 L .67184 .39558 L closepath p .167 .475 .895 r
F P
0 g
s
.5 .27523 m .62758 .31802 L .53006 .29504 L closepath p .282 0 0 r
F P
0 g
s
.40391 .30106 m .32197 .37174 L .5 .27523 L closepath p .653 .97 .851 r
F P
0 g
s
.40391 .30106 m .5 .27523 L .53006 .29504 L closepath p .109 0 0 r
F P
0 g
s
.67184 .39558 m .62758 .31802 L .73211 .43653 L closepath p 0 .034 .59 r
F P
0 g
s
.71242 .51198 m .67184 .39558 L .73211 .43653 L closepath p 0 0 .497 r
F P
0 g
s
.5 .75807 m .58835 .68293 L .68388 .63248 L closepath p 0 0 0 r
F P
0 g
s
.68388 .63248 m .71242 .51198 L .73211 .43653 L closepath p 0 0 0 r
F P
0 g
s
.37742 .67486 m .30901 .61606 L .5 .75807 L closepath p 0 .194 .659 r
F P
0 g
s
.32183 .41013 m .27803 .48748 L .32197 .37174 L closepath p 0 0 0 r
F P
0 g
s
.40391 .30106 m .32197 .37174 L .32183 .41013 L closepath p 0 0 0 r
F P
0 g
s
.63934 .62256 m .5 .75807 L .68388 .63248 L closepath p .772 .997 .846 r
F P
0 g
s
.63934 .62256 m .68388 .63248 L .73211 .43653 L closepath p .939 .964 .694 r
F P
0 g
s
.62758 .31802 m .73211 .43653 L .53006 .29504 L closepath p .749 .24 0 r
F P
0 g
s
.32183 .41013 m .27803 .48748 L .30901 .61606 L closepath p 0 0 .491 r
F P
0 g
s
.40391 .30106 m .32183 .41013 L .53006 .29504 L closepath p .408 0 .122 r
F P
0 g
s
.39483 .61165 m .32183 .41013 L .30901 .61606 L closepath p .282 .352 .758 r
F P
0 g
s
.30901 .61606 m .39483 .61165 L .5 .75807 L closepath p .265 .497 .892 r
F P
0 g
s
.5 .75807 m .39483 .61165 L .53252 .56266 L closepath p .639 .684 .877 r
F P
0 g
s
.63934 .62256 m .5 .75807 L .53252 .56266 L closepath p .772 .81 .883 r
F P
0 g
s
.53006 .29504 m .53855 .40574 L .73211 .43653 L closepath p .787 .439 .398 r
F P
0 g
s
.32183 .41013 m .53855 .40574 L .53006 .29504 L closepath p .646 .329 .421 r
F P
0 g
s
.53252 .56266 m .53855 .40574 L .73211 .43653 L closepath p .81 .637 .667 r
F P
0 g
s
.63934 .62256 m .53252 .56266 L .73211 .43653 L closepath p .862 .779 .768 r
F P
0 g
s
.32183 .41013 m .39483 .61165 L .53252 .56266 L closepath p .609 .553 .766 r
F P
0 g
s
.53855 .40574 m .53252 .56266 L .32183 .41013 L closepath p .691 .535 .67 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.34123 .56184 m .40401 .40824 L .50377 .45486 L closepath p .792 .691 .754 r
F P
0 g
s
.5 .27523 m .40401 .40824 L .50377 .45486 L closepath p .738 .723 .837 r
F P
0 g
s
.66737 .55927 m .60098 .40621 L .50377 .45486 L closepath p .594 .532 .754 r
F P
0 g
s
.60098 .40621 m .50377 .45486 L .5 .27523 L closepath p .633 .638 .838 r
F P
0 g
s
.50456 .57112 m .34123 .56184 L .50377 .45486 L closepath p .746 .588 .68 r
F P
0 g
s
.50456 .57112 m .50377 .45486 L .66737 .55927 L closepath p .653 .513 .68 r
F P
0 g
s
.504 .67296 m .50456 .57112 L .34123 .56184 L closepath p .732 .457 .512 r
F P
0 g
s
.50456 .57112 m .504 .67296 L .66737 .55927 L closepath p .622 .367 .511 r
F P
0 g
s
.3111 .62572 m .28124 .50193 L .34123 .56184 L closepath p .943 .61 .182 r
F P
0 g
s
.32366 .38575 m .28124 .50193 L .34123 .56184 L closepath p .989 .873 .623 r
F P
0 g
s
.40401 .40824 m .34123 .56184 L .32366 .38575 L closepath p .908 .841 .768 r
F P
0 g
s
.39633 .67987 m .3111 .62572 L .34123 .56184 L closepath p .863 .415 .095 r
F P
0 g
s
.39633 .67987 m .34123 .56184 L .504 .67296 L closepath p .765 .387 .34 r
F P
0 g
s
.66737 .55927 m .6091 .67859 L .69003 .62312 L closepath p 0 0 .057 r
F P
0 g
s
.504 .67296 m .6091 .67859 L .66737 .55927 L closepath p .476 .149 .332 r
F P
0 g
s
.66737 .55927 m .72028 .49805 L .67733 .38198 L closepath p .042 .11 .609 r
F P
0 g
s
.72028 .49805 m .66737 .55927 L .69003 .62312 L closepath p 0 0 .134 r
F P
0 g
s
.60098 .40621 m .66737 .55927 L .67733 .38198 L closepath p .358 .4 .768 r
F P
0 g
s
.32366 .38575 m .40401 .40824 L .5 .27523 L closepath p .838 .894 .879 r
F P
0 g
s
.60098 .40621 m .5 .27523 L .67733 .38198 L closepath p .39 .537 .882 r
F P
0 g
s
.504 .67296 m .6091 .67859 L .5 .75807 L closepath p .391 0 .002 r
F P
0 g
s
.39633 .67987 m .5 .75807 L .504 .67296 L closepath p .591 .083 .011 r
F P
0 g
s
.5 .27523 m .61086 .30766 L .67733 .38198 L closepath p .06 .445 .878 r
F P
0 g
s
.5 .27523 m .61086 .30766 L .49523 .29392 L closepath p .277 0 0 r
F P
0 g
s
.38415 .31036 m .32366 .38575 L .5 .27523 L closepath p .747 .99 .884 r
F P
0 g
s
.38415 .31036 m .5 .27523 L .49523 .29392 L closepath p 0 0 0 r
F P
0 g
s
.28742 .42472 m .28124 .50193 L .32366 .38575 L closepath p .819 .843 .379 r
F P
0 g
s
.38415 .31036 m .32366 .38575 L .28742 .42472 L closepath p .57 .832 .474 r
F P
0 g
s
.39633 .67987 m .3111 .62572 L .5 .75807 L closepath p .469 0 0 r
F P
0 g
s
.72028 .49805 m .67733 .38198 L .70404 .42053 L closepath p 0 0 .324 r
F P
0 g
s
.67733 .38198 m .61086 .30766 L .70404 .42053 L closepath p .572 .091 0 r
F P
0 g
s
.5 .75807 m .6091 .67859 L .69003 .62312 L closepath p 0 0 0 r
F P
0 g
s
.28742 .42472 m .28124 .50193 L .3111 .62572 L closepath p 0 0 .321 r
F P
0 g
s
.69003 .62312 m .72028 .49805 L .70404 .42053 L closepath p .907 .836 .376 r
F P
0 g
s
.38415 .31036 m .28742 .42472 L .49523 .29392 L closepath p .28 0 .065 r
F P
0 g
s
.37335 .61763 m .28742 .42472 L .3111 .62572 L closepath p .12 .259 .734 r
F P
0 g
s
.3111 .62572 m .37335 .61763 L .5 .75807 L closepath p .135 .439 .875 r
F P
0 g
s
.61086 .30766 m .70404 .42053 L .49523 .29392 L closepath p .72 .232 .084 r
F P
0 g
s
.62124 .6159 m .5 .75807 L .69003 .62312 L closepath p .821 .984 .882 r
F P
0 g
s
.62124 .6159 m .69003 .62312 L .70404 .42053 L closepath p .951 .926 .743 r
F P
0 g
s
.5 .75807 m .37335 .61763 L .49484 .56187 L closepath p .592 .654 .88 r
F P
0 g
s
.62124 .6159 m .5 .75807 L .49484 .56187 L closepath p .741 .773 .879 r
F P
0 g
s
.49523 .29392 m .49388 .40451 L .70404 .42053 L closepath p .728 .395 .416 r
F P
0 g
s
.28742 .42472 m .49388 .40451 L .49523 .29392 L closepath p .571 .266 .412 r
F P
0 g
s
.28742 .42472 m .37335 .61763 L .49484 .56187 L closepath p .545 .51 .767 r
F P
0 g
s
.62124 .6159 m .49484 .56187 L .70404 .42053 L closepath p .819 .73 .767 r
F P
0 g
s
.49388 .40451 m .49484 .56187 L .28742 .42472 L closepath p .632 .489 .669 r
F P
0 g
s
.49484 .56187 m .49388 .40451 L .70404 .42053 L closepath p .759 .592 .67 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.37465 .56997 m .42372 .41472 L .53124 .45363 L closepath p .758 .658 .751 r
F P
0 g
s
.5 .27523 m .42372 .41472 L .53124 .45363 L closepath p .712 .698 .834 r
F P
0 g
s
.69667 .54859 m .61766 .39786 L .53124 .45363 L closepath p .544 .501 .758 r
F P
0 g
s
.61766 .39786 m .53124 .45363 L .5 .27523 L closepath p .598 .618 .842 r
F P
0 g
s
.53784 .56992 m .37465 .56997 L .53124 .45363 L closepath p .706 .555 .68 r
F P
0 g
s
.53784 .56992 m .53124 .45363 L .69667 .54859 L closepath p .606 .478 .68 r
F P
0 g
s
.31871 .63494 m .29076 .51562 L .37465 .56997 L closepath p .959 .624 .316 r
F P
0 g
s
.33052 .39916 m .29076 .51562 L .37465 .56997 L closepath p .965 .824 .653 r
F P
0 g
s
.42372 .41472 m .37465 .56997 L .33052 .39916 L closepath p .878 .795 .764 r
F P
0 g
s
.53323 .67212 m .53784 .56992 L .37465 .56997 L closepath p .686 .42 .514 r
F P
0 g
s
.41768 .68394 m .31871 .63494 L .37465 .56997 L closepath p .856 .428 .203 r
F P
0 g
s
.41768 .68394 m .37465 .56997 L .53323 .67212 L closepath p .722 .358 .36 r
F P
0 g
s
.53784 .56992 m .53323 .67212 L .69667 .54859 L closepath p .564 .318 .502 r
F P
0 g
s
.33052 .39916 m .42372 .41472 L .5 .27523 L closepath p .828 .857 .868 r
F P
0 g
s
.61766 .39786 m .69667 .54859 L .67754 .36786 L closepath p .253 .348 .768 r
F P
0 g
s
.61766 .39786 m .5 .27523 L .67754 .36786 L closepath p .318 .516 .892 r
F P
0 g
s
.69667 .54859 m .62724 .67334 L .69054 .61338 L closepath p 0 0 0 r
F P
0 g
s
.53323 .67212 m .62724 .67334 L .69667 .54859 L closepath p .387 .066 .295 r
F P
0 g
s
.69667 .54859 m .72166 .48345 L .67754 .36786 L closepath p 0 0 .529 r
F P
0 g
s
.72166 .48345 m .69667 .54859 L .69054 .61338 L closepath p 0 0 0 r
F P
0 g
s
.53323 .67212 m .62724 .67334 L .5 .75807 L closepath p .302 0 0 r
F P
0 g
s
.41768 .68394 m .5 .75807 L .53323 .67212 L closepath p .552 .057 .033 r
F P
0 g
s
.5 .27523 m .59003 .29883 L .67754 .36786 L closepath p 0 .41 .838 r
F P
0 g
s
.36864 .32105 m .33052 .39916 L .5 .27523 L closepath p .804 .981 .896 r
F P
0 g
s
.5 .27523 m .59003 .29883 L .46059 .29588 L closepath p .24 0 0 r
F P
0 g
s
.36864 .32105 m .5 .27523 L .46059 .29588 L closepath p 0 0 0 r
F P
0 g
s
.2618 .44114 m .29076 .51562 L .33052 .39916 L closepath p .958 .903 .53 r
F P
0 g
s
.36864 .32105 m .33052 .39916 L .2618 .44114 L closepath p .783 .954 .626 r
F P
0 g
s
.41768 .68394 m .31871 .63494 L .5 .75807 L closepath p .568 0 0 r
F P
0 g
s
.2618 .44114 m .29076 .51562 L .31871 .63494 L closepath p .77 .486 0 r
F P
0 g
s
.5 .75807 m .62724 .67334 L .69054 .61338 L closepath p .568 .912 .695 r
F P
0 g
s
.67754 .36786 m .59003 .29883 L .66737 .40657 L closepath p .702 .183 0 r
F P
0 g
s
.72166 .48345 m .67754 .36786 L .66737 .40657 L closepath p .804 .433 0 r
F P
0 g
s
.35658 .62451 m .2618 .44114 L .31871 .63494 L closepath p 0 .13 .672 r
F P
0 g
s
.31871 .63494 m .35658 .62451 L .5 .75807 L closepath p 0 .363 .831 r
F P
0 g
s
.36864 .32105 m .2618 .44114 L .46059 .29588 L closepath p .109 0 0 r
F P
0 g
s
.69054 .61338 m .72166 .48345 L .66737 .40657 L closepath p .992 .865 .523 r
F P
0 g
s
.59003 .29883 m .66737 .40657 L .46059 .29588 L closepath p .672 .204 .133 r
F P
0 g
s
.59857 .6102 m .5 .75807 L .69054 .61338 L closepath p .834 .95 .894 r
F P
0 g
s
.59857 .6102 m .69054 .61338 L .66737 .40657 L closepath p .927 .87 .762 r
F P
0 g
s
.5 .75807 m .35658 .62451 L .45738 .56325 L closepath p .538 .623 .884 r
F P
0 g
s
.59857 .6102 m .5 .75807 L .45738 .56325 L closepath p .706 .738 .876 r
F P
0 g
s
.46059 .29588 m .44949 .40666 L .66737 .40657 L closepath p .664 .344 .421 r
F P
0 g
s
.2618 .44114 m .44949 .40666 L .46059 .29588 L closepath p .48 .188 .391 r
F P
0 g
s
.2618 .44114 m .35658 .62451 L .45738 .56325 L closepath p .467 .461 .768 r
F P
0 g
s
.44949 .40666 m .45738 .56325 L .2618 .44114 L closepath p .565 .438 .666 r
F P
0 g
s
.59857 .6102 m .45738 .56325 L .66737 .40657 L closepath p .775 .686 .766 r
F P
0 g
s
.45738 .56325 m .44949 .40666 L .66737 .40657 L closepath p .706 .547 .67 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.33127 .64347 m .30586 .5282 L .4104 .57603 L closepath p .934 .608 .397 r
F P
0 g
s
.34205 .4116 m .30586 .5282 L .4104 .57603 L closepath p .929 .774 .668 r
F P
0 g
s
.4104 .57603 m .44521 .41961 L .55806 .45048 L closepath p .724 .628 .75 r
F P
0 g
s
.44521 .41961 m .4104 .57603 L .34205 .4116 L closepath p .846 .753 .76 r
F P
0 g
s
.5704 .56684 m .4104 .57603 L .55806 .45048 L closepath p .664 .522 .68 r
F P
0 g
s
.56177 .66998 m .5704 .56684 L .4104 .57603 L closepath p .636 .379 .512 r
F P
0 g
s
.4409 .687 m .33127 .64347 L .4104 .57603 L closepath p .829 .421 .273 r
F P
0 g
s
.4409 .687 m .4104 .57603 L .56177 .66998 L closepath p .675 .323 .369 r
F P
0 g
s
.5 .27523 m .44521 .41961 L .55806 .45048 L closepath p .685 .674 .834 r
F P
0 g
s
.72174 .53604 m .63136 .38822 L .55806 .45048 L closepath p .486 .468 .762 r
F P
0 g
s
.63136 .38822 m .55806 .45048 L .5 .27523 L closepath p .56 .599 .849 r
F P
0 g
s
.5704 .56684 m .55806 .45048 L .72174 .53604 L closepath p .553 .439 .679 r
F P
0 g
s
.5704 .56684 m .56177 .66998 L .72174 .53604 L closepath p .496 .26 .487 r
F P
0 g
s
.34205 .4116 m .44521 .41961 L .5 .27523 L closepath p .812 .821 .858 r
F P
0 g
s
.63136 .38822 m .72174 .53604 L .67212 .35366 L closepath p .114 .28 .756 r
F P
0 g
s
.63136 .38822 m .5 .27523 L .67212 .35366 L closepath p .233 .493 .897 r
F P
0 g
s
.56177 .66998 m .64223 .66726 L .5 .75807 L closepath p .191 0 0 r
F P
0 g
s
.56177 .66998 m .64223 .66726 L .72174 .53604 L closepath p .272 0 .236 r
F P
0 g
s
.4409 .687 m .5 .75807 L .56177 .66998 L closepath p .503 .017 .036 r
F P
0 g
s
.24533 .45861 m .30586 .5282 L .34205 .4116 L closepath p .99 .884 .61 r
F P
0 g
s
.35775 .3327 m .34205 .4116 L .5 .27523 L closepath p .832 .954 .895 r
F P
0 g
s
.35775 .3327 m .34205 .4116 L .24533 .45861 L closepath p .899 .983 .715 r
F P
0 g
s
.72174 .53604 m .64223 .66726 L .68501 .60355 L closepath p 0 0 0 r
F P
0 g
s
.72174 .53604 m .716 .46862 L .67212 .35366 L closepath p 0 0 .377 r
F P
0 g
s
.716 .46862 m .72174 .53604 L .68501 .60355 L closepath p .86 .809 .323 r
F P
0 g
s
.5 .27523 m .56576 .2919 L .67212 .35366 L closepath p 0 .373 .773 r
F P
0 g
s
.35775 .3327 m .5 .27523 L .42762 .30083 L closepath p .31 .785 .689 r
F P
0 g
s
.5 .27523 m .56576 .2919 L .42762 .30083 L closepath p .172 0 0 r
F P
0 g
s
.4409 .687 m .33127 .64347 L .5 .75807 L closepath p .618 .052 0 r
F P
0 g
s
.24533 .45861 m .30586 .5282 L .33127 .64347 L closepath p .925 .596 .136 r
F P
0 g
s
.34491 .63198 m .24533 .45861 L .33127 .64347 L closepath p 0 0 .544 r
F P
0 g
s
.33127 .64347 m .34491 .63198 L .5 .75807 L closepath p 0 .267 .744 r
F P
0 g
s
.5 .75807 m .64223 .66726 L .68501 .60355 L closepath p .709 .982 .801 r
F P
0 g
s
.35775 .3327 m .24533 .45861 L .42762 .30083 L closepath p 0 0 0 r
F P
0 g
s
.67212 .35366 m .56576 .2919 L .62321 .39544 L closepath p .75 .23 0 r
F P
0 g
s
.716 .46862 m .67212 .35366 L .62321 .39544 L closepath p .907 .509 .103 r
F P
0 g
s
.68501 .60355 m .716 .46862 L .62321 .39544 L closepath p .987 .829 .599 r
F P
0 g
s
.56576 .2919 m .62321 .39544 L .42762 .30083 L closepath p .61 .16 .156 r
F P
0 g
s
.5 .75807 m .34491 .63198 L .42176 .56672 L closepath p .474 .591 .89 r
F P
0 g
s
.57206 .60573 m .5 .75807 L .68501 .60355 L closepath p .827 .907 .894 r
F P
0 g
s
.57206 .60573 m .5 .75807 L .42176 .56672 L closepath p .668 .706 .876 r
F P
0 g
s
.24533 .45861 m .34491 .63198 L .42176 .56672 L closepath p .368 .402 .765 r
F P
0 g
s
.40739 .41207 m .42176 .56672 L .24533 .45861 L closepath p .483 .378 .659 r
F P
0 g
s
.24533 .45861 m .40739 .41207 L .42762 .30083 L closepath p .365 .087 .352 r
F P
0 g
s
.57206 .60573 m .68501 .60355 L .62321 .39544 L closepath p .89 .814 .767 r
F P
0 g
s
.42762 .30083 m .40739 .41207 L .62321 .39544 L closepath p .592 .284 .416 r
F P
0 g
s
.57206 .60573 m .42176 .56672 L .62321 .39544 L closepath p .729 .645 .765 r
F P
0 g
s
.42176 .56672 m .40739 .41207 L .62321 .39544 L closepath p .649 .501 .67 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.34815 .65113 m .32577 .53944 L .44775 .57999 L closepath p .894 .58 .446 r
F P
0 g
s
.35769 .4228 m .32577 .53944 L .44775 .57999 L closepath p .89 .728 .675 r
F P
0 g
s
.44775 .57999 m .46794 .42283 L .58364 .44545 L closepath p .688 .598 .75 r
F P
0 g
s
.46794 .42283 m .44775 .57999 L .35769 .4228 L closepath p .814 .715 .756 r
F P
0 g
s
.60159 .5619 m .44775 .57999 L .58364 .44545 L closepath p .619 .487 .68 r
F P
0 g
s
.58904 .66657 m .60159 .5619 L .44775 .57999 L closepath p .58 .332 .505 r
F P
0 g
s
.46544 .68902 m .34815 .65113 L .44775 .57999 L closepath p .792 .404 .319 r
F P
0 g
s
.46544 .68902 m .44775 .57999 L .58904 .66657 L closepath p .625 .282 .369 r
F P
0 g
s
.35769 .4228 m .46794 .42283 L .5 .27523 L closepath p .792 .789 .849 r
F P
0 g
s
.5 .27523 m .46794 .42283 L .58364 .44545 L closepath p .655 .652 .835 r
F P
0 g
s
.74166 .52177 m .64158 .37749 L .58364 .44545 L closepath p .416 .43 .766 r
F P
0 g
s
.64158 .37749 m .58364 .44545 L .5 .27523 L closepath p .517 .58 .858 r
F P
0 g
s
.60159 .5619 m .58364 .44545 L .74166 .52177 L closepath p .489 .396 .676 r
F P
0 g
s
.60159 .5619 m .58904 .66657 L .74166 .52177 L closepath p .412 .188 .462 r
F P
0 g
s
.23786 .47638 m .32577 .53944 L .35769 .4228 L closepath p .973 .838 .647 r
F P
0 g
s
.35163 .34488 m .35769 .4228 L .5 .27523 L closepath p .84 .919 .886 r
F P
0 g
s
.35163 .34488 m .35769 .4228 L .23786 .47638 L closepath p .939 .956 .755 r
F P
0 g
s
.23786 .47638 m .32577 .53944 L .34815 .65113 L closepath p .961 .625 .287 r
F P
0 g
s
.58904 .66657 m .6535 .66048 L .5 .75807 L closepath p .05 0 0 r
F P
0 g
s
.58904 .66657 m .6535 .66048 L .74166 .52177 L closepath p .117 0 .145 r
F P
0 g
s
.46544 .68902 m .5 .75807 L .58904 .66657 L closepath p .441 0 .022 r
F P
0 g
s
.5 .27523 m .53891 .28721 L .66091 .33986 L closepath p 0 .341 .692 r
F P
0 g
s
.64158 .37749 m .5 .27523 L .66091 .33986 L closepath p .134 .466 .891 r
F P
0 g
s
.35163 .34488 m .5 .27523 L .39764 .30851 L closepath p .472 .886 .77 r
F P
0 g
s
.5 .27523 m .53891 .28721 L .39764 .30851 L closepath p .076 0 0 r
F P
0 g
s
.64158 .37749 m .74166 .52177 L .66091 .33986 L closepath p 0 .19 .718 r
F P
0 g
s
.46544 .68902 m .34815 .65113 L .5 .75807 L closepath p .634 .084 0 r
F P
0 g
s
.74166 .52177 m .6535 .66048 L .67321 .59397 L closepath p .798 .92 .537 r
F P
0 g
s
.74166 .52177 m .70295 .45406 L .66091 .33986 L closepath p .754 .399 0 r
F P
0 g
s
.70295 .45406 m .74166 .52177 L .67321 .59397 L closepath p .982 .866 .492 r
F P
0 g
s
.33849 .63976 m .23786 .47638 L .34815 .65113 L closepath p .63 .21 0 r
F P
0 g
s
.34815 .65113 m .33849 .63976 L .5 .75807 L closepath p 0 .161 .614 r
F P
0 g
s
.35163 .34488 m .23786 .47638 L .39764 .30851 L closepath p 0 0 0 r
F P
0 g
s
.5 .75807 m .6535 .66048 L .67321 .59397 L closepath p .792 .997 .861 r
F P
0 g
s
.66091 .33986 m .53891 .28721 L .57329 .3878 L closepath p .743 .24 .031 r
F P
0 g
s
.70295 .45406 m .66091 .33986 L .57329 .3878 L closepath p .913 .521 .24 r
F P
0 g
s
.23786 .47638 m .33849 .63976 L .38944 .5721 L closepath p .237 .326 .753 r
F P
0 g
s
.3694 .42043 m .38944 .5721 L .23786 .47638 L closepath p .379 .304 .646 r
F P
0 g
s
.23786 .47638 m .3694 .42043 L .39764 .30851 L closepath p .21 0 .285 r
F P
0 g
s
.53891 .28721 m .57329 .3878 L .39764 .30851 L closepath p .535 .098 .157 r
F P
0 g
s
.5 .75807 m .33849 .63976 L .38944 .5721 L closepath p .397 .555 .894 r
F P
0 g
s
.54266 .6027 m .5 .75807 L .67321 .59397 L closepath p .808 .864 .89 r
F P
0 g
s
.54266 .6027 m .5 .75807 L .38944 .5721 L closepath p .625 .675 .878 r
F P
0 g
s
.39764 .30851 m .3694 .42043 L .57329 .3878 L closepath p .506 .21 .398 r
F P
0 g
s
.67321 .59397 m .70295 .45406 L .57329 .3878 L closepath p .948 .776 .636 r
F P
0 g
s
.54266 .6027 m .67321 .59397 L .57329 .3878 L closepath p .849 .763 .767 r
F P
0 g
s
.38944 .5721 m .3694 .42043 L .57329 .3878 L closepath p .584 .452 .667 r
F P
0 g
s
.54266 .6027 m .38944 .5721 L .57329 .3878 L closepath p .681 .605 .765 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016R000`400?l00000o`00003oo`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00RP3oool5o`0008/0oooo00270?ooo`?o00001@0C
0004o`0008L0oooo00240?ooo`?o0000300C0003o`0008@0oooo00210?ooo`?o0000400C0005o`00
0840oooo001m0?ooo`Co0000300C0007o`0000<0R1TX00Co00000;hm1ol0003o0000O`3oool007X0
oooo0ol0000901<000Oo00002`286BP00ol00000_Sd70;hm1`03o`0007`0oooo001g0?ooo`?o0000
1P0C0006o`000180R1TX00?o00000;hm1`2n?@L00`2n?@L2o`0007X0oooo001d0?ooo`?o00000P0C
0007o`0001P0R1TX00?o00000;hm1`2n?@L01@2n?@L2o`0007P0oooo001a0?ooo`So000080286BP0
0ol00000_Sd70;hm1`060;hm1`;o0000MP3oool006h0oooo1?l0000W08PI:003o`00002n?@L0_Sd7
00P0_Sd70ol0001c0?ooo`00K@3oool01?l000000000o`000021=FD2o`0002H0R1TX00?o00000;hm
1`2n?@L02`2n?@L2o`000740oooo001/0?ooo`04o`000000003o0000o`0000<0PCEU0ol0000T08PI
:003o`00002n?@L0_Sd700`0_Sd70_l0001_0?ooo`00JP3oool2o`00000300000?l0003o000000L0
PCEU0_l0000R08PI:003o`00002n?@L0_Sd700h0_Sd70ol0001/0?ooo`00J@3oool01_l000000000
00000?l00000=@18o`0000T0PCEU0_l0000P08PI:003o`00002n?@L0_Sd70140_Sd70_l0001Z0?oo
o`00J03oool01?l00000000000000?l0000203D0B003o`000021=FD0PCEU00T0PCEU0ol0000N08PI
:003o`00002n?@L0_Sd70180_Sd70_l0001X0?ooo`00I`3oool01?l00000000000000?l0000303D0
B003o`000021=FD0PCEU00`0PCEU0_l0000L08PI:003o`00002n?@L0_Sd701@0_Sd70_l0001V0?oo
o`00I@3oool2o`000080000000Go000003D0B00e04P0=@18o`00000A084eI@;o00006P286BP00ol0
0000_Sd70;hm1`0F0;hm1`?o0000H`3oool006@0oooo00Go00000000000000000000o`00000403D0
B003o`000021=FD0PCEU0140PCEU0_l0000I08PI:003o`00002n?@L0_Sd701P0_Sd70_l0001Q0?oo
o`00H`3oool01Ol00000000000000000003o000000D0=@1800?o0000084eI@21=FD04`21=FD3o`00
01H0R1TX00?o00000;hm1`2n?@L06@2n?@L2o`000600oooo001R0?ooo`05o`000000000000000000
0?l000001P0e04P00ol00000PCEU084eI@0F084eI@;o00005@286BP00ol00000_Sd70;hm1`0F0;hm
1`;o000000<0jHDmo`00003oool0G`3oool00680oooo00Co000000000000003o00001P0e04P00ol0
0000PCEU084eI@0I084eI@;o00004`286BP00ol00000_Sd70;hm1`0D0;hm1`;o0000103YQCd00ol0
0000oooo0?ooo`1M0?ooo`00H@3oool01?l00000000000000?l0000703D0B003o`000021=FD0PCEU
01/0PCEU0_l0000A08PI:003o`00002n?@L0_Sd701<0_Sd700?o00000>V5?@3YQCd0103YQCd00ol0
0000oooo0?ooo`1M0?ooo`00H03oool01?l00000000000000?l0000803D0B003o`000021=FD0PCEU
01d0PCEU0ol0000?08PI:003o`00002n?@L0_Sd70100_Sd70_l000070>V5?@;o0000GP3oool005l0
oooo00Co000000000000003o00002@0e04P00ol00000PCEU084eI@0P084eI@;o00003@286BP00ol0
0000_Sd70;hm1`0>0;hm1`;o00002P3YQCd00ol00000oooo0?ooo`1L0?ooo`00GP3oool01?l00000
000000000?l0000903D0B003o`000021=FD0PCEU02<0PCEU0_l0000;08PI:003o`00002n?@L0_Sd7
00`0_Sd70_l0000<0>V5?@03o`00003oool0oooo05`0oooo001M0?ooo`04o`00000000000000o`00
00X0=@1800?o0000084eI@21=FD09@21=FD3o`0000T0R1TX00?o00000;hm1`2n?@L02@2n?@L2o`00
00h0jHDm0_l0001M0?ooo`00G03oool01?l00000000000000?l0000;03D0B003o`000021=FD0PCEU
02P0PCEU0_l0000708PI:003o`00002n?@L0_Sd700L0_Sd70_l0000A0>V5?@03o`00003oool0oooo
05/0oooo001L0?ooo`03o`000000003o000000`0=@1800?o0000084eI@21=FD0:P21=FD2o`0000D0
R1TX00?o00000;hm1`2n?@L01@2n?@L2o`0001<0jHDm0_l0001L0?ooo`00F`3oool00ol000000000
o`00000<03D0B003o`000021=FD0PCEU02d0PCEU0_l0000408PI:003o`00002n?@L0_Sd700<0_Sd7
00?o00000>V5?@3YQCd0503YQCd00ol00000oooo0?ooo`1J0?ooo`00FP3oool00ol000000000o`00
000=03D0B003o`000021=FD0PCEU02l0PCEU0ol000000`286BSo00000;hm1`020;hm1`;o00005`3Y
QCd2o`0005/0oooo001I0?ooo`03o`000000003o000000h0=@1800?o0000084eI@21=FD0<P21=FD2
o`0000030;hm1ol0003o000001T0jHDm0_l0001K0?ooo`00F03oool00ol000000000o`00000?03D0
B003o`000021=FD0PCEU0340PCEU1Ol0000K0>V5?@;o0000FP3oool005L0oooo00?o000000000?l0
00003`0e04P00ol00000PCEU084eI@0/084eI@Ko00000P2ELjX2o`0000030?;6X_l0003o000001T0
jHDm0_l0001J0?ooo`00EP3oool00ol000000000o`00000@03D0B003o`000021=FD0PCEU02H0PCEU
1_l0000709EcZP04o`00002^V/?o0000o`000080l/JR0_l0000G0>V5?@03o`000031IP3o000005T0
oooo001E0?ooo`04o`00000000000000o`000100=@1800?o0000084eI@21=FD08@21=FD5o`0000`0
UG>Z00?o00000:jJ``2^V/<00_l000040?;6XP;o00005P3YQCd2o`0005T0oooo001E0?ooo`03o`00
0000003o00000140=@1800?o0000084eI@21=FD06`21=FD6o`000100UG>Z00Co00000:jJ``2^V/?o
00000P3I`l@00ol00000l/JR0?;6XP030?;6XP;o0000503YQCd2o`0005T0oooo001D0?ooo`03o`00
0000003o00000140=@1800?o0000084eI@21=FD05P21=FD6o`0001D0UG>Z00Go00000:jJ``2^V/<0
[Y[3o`0000020=W3a003o`00003baZ80l/JR00D0l/JR00?o00000>V5?@3YQCd04P3YQCd2o`0005P0
oooo001C0?ooo`03o`000000003o00000180=@1800?o0000084eI@21=FD04021=FD6o`0001X0UG>Z
00?o00000:jJ``2^V/<00P2^V/<01Ol00000fL?40=W3a03I`lCo000000L0l/JR0_l0000B0>V5?@;o
0000F03oool00580oooo00?o000000000?l000004`0e04P00ol00000PCEU084eI@0:084eI@Ko0000
7`2ELjX00ol00000[Y[30:jJ``030:jJ``05o`00003I`l@0fL?40=W3a?l000002@3baZ82o`000100
jHDm00?o00000<5V0?l00000E`3oool00540oooo00?o000000000?l00000500e04P00ol00000PCEU
084eI@05084eI@Go0000902ELjX00ol00000[Y[30:jJ``040:jJ``03o`00003I`l@0fL?40080fL?4
00?o00000?;6XP3baZ80203baZ82o`0000l0jHDm0_l0001G0?ooo`00D03oool00ol000000000o`00
000D03D0B003o`000021=FD0PCEU00Ko0000:02ELjX00ol00000[Y[30:jJ``050:jJ``03o`00003I
`l@0fL?40080fL?400?o00000?;6XP3baZ802P3baZ82o`0000d0jHDm00?o00000<5V0?l00000EP3o
ool004l0oooo00?o000000000?l00000500e04P4o`0002d0UG>Z00?o00000:jJ``2^V/<01P2^V/<0
0ol00000fL?40=W3a0030=W3a003o`00003baZ80l/JR00/0l/JR0_l0000;0>V5?@03o`000031IP3o
000005H0oooo001?0?ooo`;o00004P0e04P3o`000003065=YOl00000UG>Z02d0UG>Z00?o00000:jJ
``2^V/<01P2^V/<00ol00000fL?40=W3a0040=W3a003o`00003baZ80l/JR00d0l/JR0_l0000:0>V5
?@03o`000031IP3o000005D0oooo001>0?ooo`;o00004@0e04P2o`0000@0HDfU00?o000009EcZP2E
LjX0:`2ELjX00ol00000[Y[30:jJ``070:jJ``03o`00003I`l@0fL?400D0fL?400?o00000?;6XP3b
aZ803P3baZ82o`0000P0jHDm00?o00000<5V0?l00000E@3oool004d0oooo0_l0000?03D0B0?o0000
1P1QCJD00ol00000UG>Z09EcZP0Z09EcZP03o`00002^V/<0[Y[300P0[Y[300?o00000=W3a03I`l@0
1@3I`l@00ol00000l/JR0?;6XP0@0?;6XP;o00001`3YQCd00ol00000`FH0o`00001D0?ooo`00C03o
ool2o`0000h0=@180_l0000:065=Y@03o`00002ELjX0UG>Z02P0UG>Z00?o00000:jJ``2^V/<02@2^
V/<00ol00000fL?40=W3a0060=W3a003o`00003baZ80l/JR0140l/JR00?o00000>V5?@3YQCd0103Y
QCd00ol00000`FH0o`00001D0?ooo`00B`3oool2o`0000`0=@180ol0000<065=Y@03o`00002ELjX0
UG>Z02L0UG>Z00?o00000:jJ``2^V/<02P2^V/<00ol00000fL?40=W3a0060=W3a003o`00003baZ80
l/JR0180l/JR0_l000040>V5?@03o`000031IP3o000005@0oooo001:0?ooo`;o00002`0e04P2o`00
00l0HDfU00?o000009EcZP2ELjX09P2ELjX00ol00000[Y[30:jJ``0;0:jJ``03o`00003I`l@0fL?4
00H0fL?400?o00000?;6XP3baZ80503baZ82o`0000<0jHDm00?o00000<5V0?l00000D`3oool004T0
oooo0_l0000903D0B0?o00004@1QCJD00ol00000UG>Z09EcZP0U09EcZP03o`00002^V/<0[Y[300`0
[Y[300?o00000=W3a03I`l@01`3I`l@00ol00000l/JR0?;6XP0E0?;6XP;o000000@0jHDmo`000031
IP3o0000D`3oool004P0oooo0_l0000803D0B0;o0000501QCJD00ol00000UG>Z09EcZP0T09EcZP03
o`00002^V/<0[Y[300`0[Y[300?o00000=W3a03I`l@0203I`l@00ol00000l/JR0?;6XP0G0?;6XP;o
00000P31IP000ol00000oooo0?ooo`1@0?ooo`00B03oool00ol00000=@1803D0B00503D0B0;o0000
5P1QCJD00ol00000UG>Z09EcZP0S09EcZP03o`00002^V/<0[Y[300d0[Y[300?o00000=W3a03I`l@0
2@3I`l@00ol00000l/JR0?;6XP0H0?;6XP03o`000031IP3o00000580oooo00170?ooo`03o`00000e
04P0=@1800<0=@180ol0000H065=Y@03o`00002ELjX0UG>Z0280UG>Z00?o00000:jJ``2^V/<03P2^
V/<00ol00000fL?40=W3a0090=W3a003o`00003baZ80l/JR01P0l/JR00Co00000<5V0031IP3o0000
D@3oool004H0oooo00?o000003D0B00e04P00P0e04P2o`0001`0HDfU00?o000009EcZP2ELjX0802E
LjX00ol00000[Y[30:jJ``0?0:jJ``03o`00003I`l@0fL?400X0fL?400?o00000?;6XP3baZ805`3b
aZ82o`0000030<5V0?l00000oooo0500oooo00150?ooo`03o`00000e04P0=@1800?o00007P1QCJD0
0ol00000UG>Z09EcZP0O09EcZP03o`00002^V/<0[Y[30100[Y[300?o00000=W3a03I`l@02P3I`l@0
0ol00000l/JR0?;6XP0F0?;6XP03o`00003kgGgo00000080`FH000?o00000?ooo`3oool0CP3oool0
04@0oooo00Co000003D0B?l0003o00008@1QCJD00ol00000UG>Z09EcZP0N09EcZP03o`00002^V/<0
[Y[30140[Y[300?o00000=W3a03I`l@02`3I`l@00ol00000l/JR0?;6XP0E0?;6XP06o`00003kgGd0
nmemo`000031IP3o0000D03oool004<0oooo0ol0000S065=Y@03o`00002ELjX0UG>Z01d0UG>Z00?o
00000:jJ``2^V/<04P2^V/<00ol00000fL?40=W3a00;0=W3a003o`00003baZ80l/JR01D0l/JR00Co
00000?_MO@3kgGd0nmem0_l0001@0?ooo`00@P3oool2o`0002D0HDfU00?o000009EcZP2ELjX0702E
LjX00ol00000[Y[30:jJ``0B0:jJ``03o`00003I`l@0fL?400d0fL?400?o00000?;6XP3baZ80503b
aZ801ol00000nmem0?_MO@3kgGgo00000<5V0?l00000C`3oool00480oooo00?o000003aC`?l00000
901QCJD00ol00000UG>Z09EcZP0K09EcZP03o`00002^V/<0[Y[301<0[Y[300?o00000=W3a03I`l@0
3@3I`l@00ol00000l/JR0?;6XP0D0?;6XP03o`00003kgGd0nmem0080nmem0_l0001?0?ooo`00@`3o
ool01?l00000?5?0o`000?l0000R065=Y@03o`00002ELjX0UG>Z01X0UG>Z00?o00000:jJ``2^V/<0
502^V/<00ol00000fL?40=W3a00>0=W3a003o`00003baZ80l/JR0180l/JR00?o00000?_MO@3kgGd0
0`3kgGd00ol00000`FH0o`00001>0?ooo`00A03oool00ol00000?5?003aC`002o`000240HDfU00?o
000009EcZP2ELjX0602ELjX00ol00000[Y[30:jJ``0E0:jJ``03o`00003I`l@0fL?400h0fL?400?o
00000?;6XP3baZ804P3baZ800ol00000nmem0?_MO@040?_MO@;o0000CP3oool004@0oooo00?o0000
03aC`00lDl000P0lDl000ol00000HDfU065=Y@0N065=Y@03o`00002ELjX0UG>Z01L0UG>Z00?o0000
0:jJ``2^V/<05P2^V/<00ol00000fL?40=W3a00?0=W3a003o`00003baZ80l/JR0140l/JR00?o0000
0?_MO@3kgGd01@3kgGd2o`0004d0oooo00150?ooo`03o`00000lDl00?5?00080?5?00_l0000N065=
Y@03o`00002ELjX0UG>Z01H0UG>Z00?o00000:jJ``2^V/<05`2^V/<00ol00000fL?40=W3a00?0=W3
a003o`00003baZ80l/JR0140l/JR00?o00000?_MO@3kgGd01@3kgGd2o`0004d0oooo00150?ooo`03
o`00000lDl00?5?000@0?5?000?o0000065=Y@1QCJD06`1QCJD00ol00000UG>Z09EcZP0E09EcZP03
o`00002^V/<0[Y[301L0[Y[300?o00000=W3a03I`l@04@3I`l@00ol00000l/JR0?;6XP0@0?;6XP03
o`00003kgGd0nmem00H0nmem0_l0001<0?ooo`00AP3oool00ol00000?5?003aC`00403aC`0;o0000
6`1QCJD00ol00000UG>Z09EcZP0D09EcZP03o`00002^V/<0[Y[301P0[Y[300?o00000=W3a03I`l@0
4@3I`l@00ol00000l/JR0?;6XP0?0?;6XP03o`00003kgGd0nmem00L0nmem0_l0001<0?ooo`00A`3o
ool00ol00000?5?003aC`00503aC`0;o00006@1QCJD00ol00000UG>Z09EcZP0C09EcZP03o`00002^
V/<0[Y[301T0[Y[300?o00000=W3a03I`l@04P3I`l@00ol00000l/JR0?;6XP0>0?;6XP03o`00003k
gGd0nmem00P0nmem0_l0001;0?ooo`00A`3oool00ol00000?5?003aC`00703aC`003o`00001QCJD0
HDfU01H0HDfU00?o000009EcZP2ELjX04P2ELjX00ol00000[Y[30:jJ``0J0:jJ``03o`00003I`l@0
fL?40180fL?400?o00000?;6XP3baZ803P3baZ800ol00000nmem0?_MO@080?_MO@;o0000B`3oool0
04P0oooo00?o000003aC`00lDl001`0lDl02o`0001L0HDfU00?o000009EcZP2ELjX0402ELjX00ol0
0000[Y[30:jJ``0K0:jJ``03o`00003I`l@0fL?401<0fL?400?o00000?;6XP3baZ803@3baZ800ol0
0000nmem0?_MO@090?_MO@03o`00003oool0oooo04T0oooo00190?ooo`03o`00000lDl00?5?000P0
?5?000?o0000065=Y@1QCJD0501QCJD00ol00000UG>Z09EcZP0?09EcZP03o`00002^V/<0[Y[301`0
[Y[300?o00000=W3a03I`l@04`3I`l@00ol00000l/JR0?;6XP0=0?;6XP03o`00003kgGd0nmem00X0
nmem00?o00000?ooo`3oool0B03oool004T0oooo00?o000003aC`00lDl002@0lDl02o`0001@0HDfU
00?o000009EcZP2ELjX03P2ELjX00ol00000[Y[30:jJ``0M0:jJ``03o`00003I`l@0fL?401@0fL?4
00?o00000?;6XP3baZ802`3baZ800ol00000nmem0?_MO@0;0?_MO@03o`00003oool0oooo04P0oooo
001:0?ooo`03o`00000lDl00?5?000X0?5?00_l0000B065=Y@03o`00002ELjX0UG>Z00d0UG>Z00?o
00000:jJ``2^V/<07@2^V/<00ol00000fL?40=W3a00E0=W3a003o`00003baZ80l/JR00/0l/JR00?o
00000?_MO@3kgGd0303kgGd00ol00000oooo0?ooo`170?ooo`00B`3oool00ol00000?5?003aC`00;
03aC`003o`00001QCJD0HDfU00l0HDfU00?o000009EcZP2ELjX0302ELjX00ol00000[Y[30:jJ``0N
0:jJ``03o`00003I`l@0fL?401H0fL?400?o00000?;6XP3baZ802P3baZ800ol00000nmem0?_MO@0<
0?_MO@03o`00003oool0oooo04L0oooo001;0?ooo`03o`00000lDl00?5?000`0?5?00_l0000?065=
Y@03o`00002ELjX0UG>Z00/0UG>Z00?o00000:jJ``2^V/<07`2^V/<00ol00000fL?40=W3a00F0=W3
a003o`00003baZ80l/JR00X0l/JR00?o00000?_MO@3kgGd02`3kgGd00ol00000oooo0?ooo`180?oo
o`00C03oool00ol00000?5?003aC`00=03aC`003o`00001QCJD0HDfU00`0HDfU00?o000009EcZP2E
LjX02P2ELjX00ol00000[Y[30:jJ``0P0:jJ``03o`00003I`l@0fL?401L0fL?400?o00000?;6XP3b
aZ802@3baZ800ol00000nmem0?_MO@0:0?_MO@03o`00003oool0oooo04T0oooo001<0?ooo`03o`00
000lDl00?5?000h0?5?00_l0000=065=Y@03o`00002ELjX0UG>Z00P0UG>Z00?o00000:jJ``2^V/<0
8@2^V/<00ol00000fL?40=W3a00G0=W3a003o`00003baZ80l/JR00P0l/JR00?o00000?_MO@3kgGd0
2P3kgGd2o`0004/0oooo001=0?ooo`03o`00000lDl00?5?000l0?5?000?o0000065=Y@1QCJD02P1Q
CJD00ol00000UG>Z09EcZP0709EcZP03o`00002^V/<0[Y[30280[Y[300?o00000=W3a03I`l@0603I
`l@00ol00000l/JR0?;6XP070?;6XP03o`00003kgGd0nmem00T0nmem0_l0001<0?ooo`00CP3oool0
0ol00000?5?003aC`00?03aC`0;o00002P1QCJD00ol00000UG>Z09EcZP0609EcZP03o`00002^V/<0
[Y[302<0[Y[300?o00000=W3a03I`l@0603I`l@00ol00000l/JR0?;6XP070?;6XP03o`00003kgGd0
nmem00P0nmem0_l0001=0?ooo`00CP3oool00ol00000?5?003aC`00A03aC`0;o0000201QCJD00ol0
0000UG>Z09EcZP0509EcZP03o`00002^V/<0[Y[302<0[Y[300?o00000=W3a03I`l@06@3I`l@00ol0
0000l/JR0?;6XP070?;6XP03o`00003kgGd0nmem00L0nmem00?o00000<c[ROl00000C@3oool004l0
oooo00?o000003aC`00lDl004P0lDl000ol00000HDfU065=Y@05065=Y@03o`00002ELjX0UG>Z00@0
UG>Z00?o00000:jJ``2^V/<0902^V/<00ol00000fL?40=W3a00J0=W3a003o`00003baZ80l/JR00H0
l/JR00?o00000?_MO@3kgGd01P3kgGd00ol00000c>^9o`00001>0?ooo`00D03oool00ol00000?5?0
03aC`00B03aC`0;o00001@1QCJD00ol00000UG>Z09EcZP0309EcZP03o`00002^V/<0[Y[302D0[Y[3
00?o00000=W3a03I`l@06P3I`l@00ol00000l/JR0?;6XP050?;6XP03o`00003kgGd0nmem00H0nmem
00Co00000<c[R@3<jhWo0000CP3oool00500oooo00?o000003aC`00lDl00500lDl000ol00000HDfU
065=Y@02065=Y@03o`00002ELjX0UG>Z0080UG>Z00?o00000:jJ``2^V/<09P2^V/<00ol00000fL?4
0=W3a00K0=W3a003o`00003baZ80l/JR00@0l/JR00?o00000?_MO@3kgGd01@3kgGd01?l00000c>^9
0<c[ROl0001?0?ooo`00D@3oool00ol00000?5?003aC`00D03aC`0;o00000`1QCJD01?l00000UG>Z
09EcZ_l0000Y0:jJ``03o`00003I`l@0fL?401/0fL?400?o00000?;6XP3baZ80103baZ800ol00000
nmem0?_MO@040?_MO@04o`00003<jhT0c>^9o`000500oooo001A0?ooo`03o`00000lDl00?5?001H0
?5?00_l00000101QCJGo000009EcZ_l0000Z0:jJ``03o`00003I`l@0fL?401`0fL?400?o00000?;6
XP3baZ800`3baZ800ol00000nmem0?_MO@030?_MO@05o`00003<jhT0c>^90<c[ROl00000D03oool0
0580oooo00?o000003aC`00lDl005`0lDl03o`0002/0[Y[300?o00000=W3a03I`l@0703I`l@00ol0
0000l/JR0?;6XP030?;6XP03o`00003kgGd0nmem0080nmem00Go00000<c[R@3<jhT0c>^9o`00001A
0?ooo`00D`3oool00ol00000?5?003aC`00G03aC`0?o0000:@2^V/<00ol00000fL?40=W3a00N0=W3
a005o`00003baZ80l/JR0?;6X_l00000103kgGd01Ol00000c>^90<c[R@3<jhWo00000580oooo001C
0?ooo`03o`00000lDl00?5?001L0?5?000?o000009n/h02O[>001Ol0000T0:jJ``03o`00003I`l@0
fL?401h0fL?400Go00000?;6XP3baZ80l/JRo`0000030?_MO@03o`00003<jhT0c>^90080c>^900?o
00000?ooo`3oool0D03oool005@0oooo00?o000003aC`00lDl005@0lDl000ol00000IHkTo`000006
09n/h0Go00007`2^V/<00ol00000fL?40=W3a00O0=W3a004o`00003baZ80l/JRo`000080nmem00?o
00000<c[R@3<jhT00P3<jhT00ol00000oooo0?ooo`1A0?ooo`00E@3oool00ol00000?5?003aC`00C
03aC`004o`00001US^@0IHkTo`0000/0WjcP1Ol0000J0:jJ``03o`00003I`l@0fL?401l0fL?400Ko
00000?;6XP3baZ;o00000?_MOOl000040<c[R@03o`00003oool0oooo0580oooo001E0?ooo`03o`00
000lDl00?5?00180?5?000?o000006F>i01US^@00P1US^@00ol00000WjcP09n/h00=09n/h0Go0000
5@2^V/<00ol00000fL?40=W3a00P0=W3a004o`00003baZ;o0000o`0000D0c>^900?o00000?ooo`3o
ool0DP3oool005H0oooo00?o000003aC`00lDl004@0lDl000ol00000IHkT06F>i00306F>i003o`00
002O[>00WjcP0140WjcP1?l0000A0:jJ``03o`00003I`l@0fL?40200fL?40ol000050<c[R@03o`00
003oool0oooo05<0oooo001F0?ooo`03o`00000lDl00?5?00100?5?000?o000006F>i01US^@0101U
S^@00ol00000WjcP09n/h00E09n/h0Go0000302^V/<00ol00000fL?40=W3a00K0=W3a0Oo00001@3<
jhT00ol00000oooo0?ooo`1D0?ooo`00E`3oool00ol00000?5?003aC`00>03aC`003o`00001US^@0
IHkT00H0IHkT00?o000009n/h02O[>006@2O[>05o`0000H0[Y[300?o00000=W3a03I`l@03`3I`l@=
o`0000@0c]gS00?o00000<[og?l000001@3<jhT00ol00000oooo0?ooo`1D0?ooo`00F03oool00ol0
0000?5?003aC`00<03aC`003o`00001US^@0IHkT00L0IHkT00?o000009n/h02O[>007P2O[>05o`00
00030:jJ`ol00000fL?400@0fL?43?l0000@0<kMh`04o`00003:om`0b_oLo`0000@0c>^900?o0000
0?ooo`3oool0E@3oool005P0oooo00?o000003aC`00lDl00300lDl000ol00000IHkT06F>i00806F>
i003o`00002O[>00WjcP0280WjcP1ol0000K0<kMh`04o`00003:om`0b_oLo`0000D0c>^900?o0000
0?ooo`3oool0E@3oool005T0oooo00?o000003aC`00lDl002P0lDl000ol00000IHkT06F>i00:06F>
i003o`00002O[>00WjcP0280WjcP00?o00000<kMh`3>gN<07@3>gN<01Ol00000b_oL0<[og03:omco
000000@0c>^900?o00000?ooo`3oool0EP3oool005X0oooo00?o000003aC`00lDl00200lDl000ol0
0000IHkT06F>i00;06F>i003o`00002O[>00WjcP0280WjcP00?o00000<kMh`3>gN<0703>gN<00ol0
0000b_oL0<[og0020<[og005o`00003<jhT0c>^90<c[ROl00000F@3oool005X0oooo00?o000003aC
`00lDl00200lDl000ol00000IHkT06F>i00<06F>i003o`00002O[>00WjcP0200WjcP00?o00000<kM
h`3>gN<0703>gN<00ol00000b_oL0<[og0020<[og003o`00003<jhT0c>^90080c>^900?o00000?oo
o`3oool0E`3oool005/0oooo00?o000003aC`00lDl001P0lDl000ol00000IHkT06F>i00=06F>i003
o`00002O[>00WjcP0200WjcP00?o00000<kMh`3>gN<06`3>gN<00ol00000b_oL0<[og0030<[og005
o`00003<jhT0c>^90<c[ROl00000FP3oool005`0oooo00?o000003aC`00lDl00100lDl000ol00000
IHkT06F>i00?06F>i003o`00002O[>00WjcP01l0WjcP00?o00000<kMh`3>gN<06P3>gN<00ol00000
b_oL0<[og0040<[og004o`00003<jhT0c>^9o`0005/0oooo001L0?ooo`03o`00000lDl00?5?000<0
?5?000?o000006F>i01US^@0401US^@00ol00000WjcP09n/h00N09n/h003o`00003>gN<0c]gS01X0
c]gS00?o00000<[og03:om`0103:om`01Ol00000c>^90<c[R@3<jhWo000005/0oooo001M0?ooo`03
o`00000lDl00?5?00080?5?000?o000006F>i01US^@04@1US^@00ol00000WjcP09n/h00M09n/h003
o`00003>gN<0c]gS01T0c]gS00?o00000<[og03:om`01@3:om`01?l00000c>^90<c[ROl0001L0?oo
o`00G@3oool01Ol00000?5?003aC`00lDl3o000001D0IHkT00?o000009n/h02O[>00702O[>000ol0
0000c]gS0<kMh`0H0<kMh`03o`00003:om`0b_oL00H0b_oL00?o00000<c[ROl00000G@3oool005h0
oooo00?o000003aC`?l000005P1US^@00ol00000WjcP09n/h00L09n/h003o`00003>gN<0c]gS01L0
c]gS00?o00000<[og03:om`01P3:om`01?l00000c>^90<c[ROl0001M0?ooo`00G`3oool2o`0001L0
IHkT00?o000009n/h02O[>006P2O[>000ol00000c]gS0<kMh`0G0<kMh`03o`00003:om`0b_oL00L0
b_oL00?o00000<c[ROl00000GP3oool005l0oooo00?o0000000YWOl000005P1US^@00ol00000WjcP
09n/h00J09n/h003o`00003>gN<0c]gS01H0c]gS00?o00000<[og03:om`0203:om`00ol00000c>^9
o`00001N0?ooo`00H03oool00ol0000002VMo`00000F06F>i003o`00002O[>00WjcP01T0WjcP00?o
00000<kMh`3>gN<05@3>gN<00ol00000b_oL0<[og0080<[og003o`00003<jhWo000005l0oooo001Q
0?ooo`Co00005@1US^@00ol00000WjcP09n/h00H09n/h003o`00003>gN<0c]gS01@0c]gS00?o0000
0<[og03:om`02@3:om`2o`000600oooo001S0?ooo`03o`000000:Igo000001@0IHkT00?o000009n/
h02O[>005`2O[>000ol00000c]gS0<kMh`0D0<kMh`03o`00003:om`0b_oL00X0b_oL0_l0001P0?oo
o`00I03oool00ol0000002VMo`00000D06F>i003o`00002O[>00WjcP01H0WjcP00?o00000<kMh`3>
gN<04`3>gN<00ol00000b_oL0<[og00:0<[og0;o0000H@3oool006D0oooo1?l0000B06F>i003o`00
002O[>00WjcP01H0WjcP00?o00000<kMh`3>gN<04P3>gN<00ol00000b_oL0<[og00:0<[og0;o0000
HP3oool006L0oooo00?o0000000YWOl000004P1US^@00ol00000WjcP09n/h00D09n/h003o`00003>
gN<0c]gS0180c]gS00?o00000<[og03:om`02P3:om`00ol00000oooo0?ooo`1R0?ooo`00J03oool3
o`000180IHkT00?o000009n/h02O[>004`2O[>000ol00000c]gS0<kMh`0A0<kMh`03o`00003:om`0
b_oL00T0b_oL0_l0001U0?ooo`00JP3oool3o`000100IHkT00?o000009n/h02O[>004`2O[>000ol0
0000c]gS0<kMh`0@0<kMh`03o`00003:om`0b_oL00T0b_oL00?o00000?ooo`3oool0I@3oool006/0
oooo00?o0000000YWOl00000401US^@00ol00000WjcP09n/h00B09n/h003o`00003>gN<0c]gS00h0
c]gS0_l0000:0<[og0;o0000J03oool006`0oooo0ol0000?06F>i003o`00002O[>00WjcP0140WjcP
00?o00000<kMh`3>gN<03P3>gN<00ol00000b_oL0<[og0090<[og003o`00003oool0oooo06P0oooo
001^0?ooo`?o00003P1US^@00ol00000WjcP09n/h00@09n/h003o`00003>gN<0c]gS00d0c]gS00?o
00000<[og03:om`0203:om`2o`0006/0oooo001_0?ooo`?o00003@1US^@00ol00000WjcP09n/h00@
09n/h003o`00003>gN<0c]gS00`0c]gS00?o00000<[og03:om`01`3:om`2o`0006d0oooo001a0?oo
o`;o00003@1US^@00ol00000WjcP09n/h00?09n/h003o`00003>gN<0c]gS00/0c]gS00?o00000<[o
g03:om`01`3:om`00ol00000oooo0?ooo`1]0?ooo`00LP3oool3o`0000`0IHkT00?o000009n/h02O
[>003@2O[>000ol00000c]gS0<kMh`0;0<kMh`03o`00003:om`0b_oL00H0b_oL0_l0001`0?ooo`00
L`3oool3o`0000/0IHkT00?o000009n/h02O[>003@2O[>000ol00000c]gS0<kMh`0:0<kMh`03o`00
003:om`0b_oL00H0b_oL00?o00000?ooo`3oool0L03oool007D0oooo0_l0000;06F>i003o`00002O
[>00WjcP00`0WjcP00?o00000<kMh`3>gN<02@3>gN<00ol00000b_oL0<[og0050<[og0;o0000L`3o
ool007H0oooo0_l0000:06F>i003o`00002O[>00WjcP00/0WjcP00?o00000<kMh`3>gN<02@3>gN<0
0ol00000b_oL0<[og0050<[og003o`00003oool0oooo07<0oooo001h0?ooo`;o00002@1US^@00ol0
0000WjcP09n/h00:09n/h003o`00003>gN<0c]gS00P0c]gS00?o00000<[og03:om`0103:om`2o`00
07H0oooo001i0?ooo`;o00002@1US^@00ol00000WjcP09n/h00909n/h003o`00003>gN<0c]gS00L0
c]gS00?o00000<[og03:om`0103:om`00ol00000oooo0?ooo`1f0?ooo`00NP3oool2o`0000P0IHkT
00?o000009n/h02O[>002@2O[>000ol00000c]gS0<kMh`060<kMh`03o`00003:om`0b_oL00<0b_oL
0_l0001i0?ooo`00O03oool2o`0000L0IHkT00?o000009n/h02O[>001`2O[>000ol00000c]gS0<kM
h`060<kMh`03o`00003:om`0b_oL00<0b_oL00?o00000?ooo`3oool0N@3oool007d0oooo0_l00006
06F>i003o`00002O[>00WjcP00L0WjcP00?o00000<kMh`3>gN<01@3>gN<00ol00000b_oL0<[og002
0<[og0;o0000O03oool007h0oooo0_l0000606F>i003o`00002O[>00WjcP00H0WjcP00?o00000<kM
h`3>gN<0103>gN<00ol00000b_oL0<[og0020<[og003o`00003oool0oooo07`0oooo00200?ooo`;o
0000101US^@00ol00000WjcP09n/h00609n/h003o`00003>gN<0c]gS00<0c]gS00Co00000<[og03:
om`0b_oL0_l0001o0?ooo`00P@3oool2o`0000@0IHkT00?o000009n/h02O[>00102O[>000ol00000
c]gS0<kMh`030<kMh`05o`00003:om`0b_oL0<[og?l00000P@3oool008<0oooo00?o000006F>i01U
S^@00P1US^@00ol00000WjcP09n/h00309n/h003o`00003>gN<0c]gS0080c]gS00?o00000<[og03:
om`00_l000220?ooo`00Q03oool2o`000080IHkT00?o000009n/h02O[>000`2O[>001_l00000c]gS
0<kMh`3>gN?o00000<[og0;o0000Q03oool008D0oooo0_l0000206F>i005o`00002O[>00WjcP09n/
h?l000000`3>gN<00ol00000b_oLo`0000260?ooo`00Q`3oool00ol00000IHkTo`00000309n/h003
o`00003>gN<0c]gS00?o0000Q`3oool008P0oooo0ol0000209n/h004o`00003>gN?o0000o`0008T0
oooo002:0?ooo`;o000000@0WjcPo`000?l0003o0000RP3oool008/0oooo0ol0002<0?ooo`00S03o
ool00ol00000oooo0?ooo`2;0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00
o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00
o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00
o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00
o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00
o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00
o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00
o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00
o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00
o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00
o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00
o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00
o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00
o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-5.00005*^-6, -5.00005*^-6, \
0.00355875, 0.00355875}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.36872 .65777 m .34973 .54914 L .486 .58183 L closepath p .852 .549 .476 r
F P
0 g
s
.37684 .43254 m .34973 .54914 L .486 .58183 L closepath p .851 .687 .678 r
F P
0 g
s
.486 .58183 m .4914 .42433 L .60739 .43861 L closepath p .65 .57 .751 r
F P
0 g
s
.4914 .42433 m .486 .58183 L .37684 .43254 L closepath p .781 .681 .753 r
F P
0 g
s
.63075 .55515 m .486 .58183 L .60739 .43861 L closepath p .567 .45 .679 r
F P
0 g
s
.6144 .66191 m .63075 .55515 L .486 .58183 L closepath p .515 .277 .491 r
F P
0 g
s
.49073 .68996 m .36872 .65777 L .486 .58183 L closepath p .751 .379 .348 r
F P
0 g
s
.49073 .68996 m .486 .58183 L .6144 .66191 L closepath p .567 .232 .36 r
F P
0 g
s
.37684 .43254 m .4914 .42433 L .5 .27523 L closepath p .77 .759 .843 r
F P
0 g
s
.5 .27523 m .4914 .42433 L .60739 .43861 L closepath p .622 .632 .839 r
F P
0 g
s
.75546 .50603 m .64786 .36592 L .60739 .43861 L closepath p .328 .385 .769 r
F P
0 g
s
.64786 .36592 m .60739 .43861 L .5 .27523 L closepath p .468 .562 .868 r
F P
0 g
s
.63075 .55515 m .60739 .43861 L .75546 .50603 L closepath p .411 .344 .672 r
F P
0 g
s
.23889 .49384 m .34973 .54914 L .37684 .43254 L closepath p .939 .787 .665 r
F P
0 g
s
.35026 .35716 m .37684 .43254 L .5 .27523 L closepath p .836 .882 .876 r
F P
0 g
s
.35026 .35716 m .37684 .43254 L .23889 .49384 L closepath p .937 .908 .768 r
F P
0 g
s
.63075 .55515 m .6144 .66191 L .75546 .50603 L closepath p .302 .094 .422 r
F P
0 g
s
.23889 .49384 m .34973 .54914 L .36872 .65777 L closepath p .942 .614 .379 r
F P
0 g
s
.35026 .35716 m .5 .27523 L .37177 .31851 L closepath p .615 .956 .835 r
F P
0 g
s
.5 .27523 m .5105 .28499 L .37177 .31851 L closepath p 0 0 0 r
F P
0 g
s
.64786 .36592 m .5 .27523 L .64397 .32698 L closepath p .025 .434 .868 r
F P
0 g
s
.5 .27523 m .5105 .28499 L .64397 .32698 L closepath p .276 0 0 r
F P
0 g
s
.49073 .68996 m .5 .75807 L .6144 .66191 L closepath p .365 0 0 r
F P
0 g
s
.49073 .68996 m .36872 .65777 L .5 .75807 L closepath p .625 .094 0 r
F P
0 g
s
.6144 .66191 m .66054 .65315 L .5 .75807 L closepath p 0 0 0 r
F P
0 g
s
.6144 .66191 m .66054 .65315 L .75546 .50603 L closepath p 0 0 .009 r
F P
0 g
s
.64786 .36592 m .75546 .50603 L .64397 .32698 L closepath p 0 .074 .631 r
F P
0 g
s
.33724 .64758 m .23889 .49384 L .36872 .65777 L closepath p .794 .338 0 r
F P
0 g
s
.36872 .65777 m .33724 .64758 L .5 .75807 L closepath p .505 0 0 r
F P
0 g
s
.35026 .35716 m .23889 .49384 L .37177 .31851 L closepath p .646 .881 .527 r
F P
0 g
s
.75546 .50603 m .66054 .65315 L .65519 .585 L closepath p .922 .967 .668 r
F P
0 g
s
.75546 .50603 m .68244 .44034 L .64397 .32698 L closepath p .891 .497 .056 r
F P
0 g
s
.68244 .44034 m .75546 .50603 L .65519 .585 L closepath p .994 .841 .584 r
F P
0 g
s
.23889 .49384 m .33724 .64758 L .36165 .57909 L closepath p .057 .223 .72 r
F P
0 g
s
.337 .43125 m .36165 .57909 L .23889 .49384 L closepath p .238 .207 .619 r
F P
0 g
s
.23889 .49384 m .337 .43125 L .37177 .31851 L closepath p 0 0 .175 r
F P
0 g
s
.5 .75807 m .66054 .65315 L .65519 .585 L closepath p .828 .975 .888 r
F P
0 g
s
.64397 .32698 m .5105 .28499 L .51982 .38415 L closepath p .707 .225 .102 r
F P
0 g
s
.68244 .44034 m .64397 .32698 L .51982 .38415 L closepath p .878 .502 .325 r
F P
0 g
s
.5 .75807 m .33724 .64758 L .36165 .57909 L closepath p .3 .512 .894 r
F P
0 g
s
.37177 .31851 m .337 .43125 L .51982 .38415 L closepath p .399 .116 .364 r
F P
0 g
s
.5105 .28499 m .51982 .38415 L .37177 .31851 L closepath p .442 .017 .134 r
F P
0 g
s
.51151 .60126 m .5 .75807 L .65519 .585 L closepath p .782 .823 .885 r
F P
0 g
s
.51151 .60126 m .5 .75807 L .36165 .57909 L closepath p .576 .644 .881 r
F P
0 g
s
.65519 .585 m .68244 .44034 L .51982 .38415 L closepath p .899 .722 .654 r
F P
0 g
s
.36165 .57909 m .337 .43125 L .51982 .38415 L closepath p .506 .395 .661 r
F P
0 g
s
.51151 .60126 m .65519 .585 L .51982 .38415 L closepath p .805 .716 .766 r
F P
0 g
s
.51151 .60126 m .36165 .57909 L .51982 .38415 L closepath p .627 .565 .765 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016R000`400?l00000o`00003oo`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00R`3oool3o`0008`0oooo00280?ooo`?o00000P00
0004o`0008T0oooo00250?ooo`?o00001P0000000ol00000AP0004H00003o`0008H0oooo00220?oo
o`?o000020000005o`000080AP000ol000230?ooo`00O`3oool3o`0000H000001Ol0000207448P03
o`00002d>AX0]3TJ00?o00000P160003o`000800oooo001l0?ooo`?o00001@000004o`0000L0L@@R
00?o00000;@i6P2d>AX00`2d>AX3o`000080AP000ol0001m0?ooo`00N@3oool3o`0000@000001?l0
000;07448P03o`00002d>AX0]3TJ00H0]3TJ1?l000001016003o0000o`000?l0001j0?ooo`00MP3o
ool3o`00008000001Ol0000?07448P03o`00002d>AX0]3TJ00X0]3TJ0ol000000`16003o0000o`00
001h0?ooo`00L`3oool3o`00000300000?l0003o000000;o00005@1a12800ol00000]3TJ0;@i6P0<
0;@i6PKo0000M@3oool00700oooo1ol0000I07448P03o`00002d>AX0]3TJ0100]3TJ1Ol0001b0?oo
o`00K@3oool6o`0001d0L@@R00?o00000;@i6P2d>AX04`2d>AX5o`0006l0oooo001Z0?ooo`Co0000
8P1a12800ol00000]3TJ0;@i6P0F0;@i6PGo0000K03oool006P0oooo0_l0000V07448P03o`00002d
>AX0]3TJ01X0]3TJ1?l0001Y0?ooo`00J03oool00ol00000IQeMo`000002o`0002<0L@@R00?o0000
0;@i6P2d>AX07@2d>AX4o`0006H0oooo001W0?ooo`;o0000101V7Ed2o`000240L@@R00?o00000;@i
6P2d>AX0802d>AX2o`0006D0oooo001V0?ooo`;o00001`1V7Ed2o`0001l0L@@R00?o00000;@i6P2d
>AX07P2d>AX2o`0000030>20Dol00000oooo06@0oooo001U0?ooo`03o`00000002co000000T0IQeM
0ol0000L07448P03o`00002d>AX0]3TJ01`0]3TJ0_l000040>20D`03o`00003oool0oooo0680oooo
001U0?ooo`03o`00000002co000000`0IQeM0_l0000K07448P03o`00002d>AX0]3TJ01T0]3TJ0_l0
00060>20D`;o0000H`3oool006@0oooo00?o00000000;?l000003`1V7Ed2o`0001T0L@@R00?o0000
0;@i6P2d>AX05P2d>AX3o`0000P0h81C0_l0001S0?ooo`00H`3oool01?l00000000/0000;?l0000A
06HMG@?o00005P1a12800ol00000]3TJ0;@i6P0D0;@i6P;o0000303PP5<2o`000680oooo001R0?oo
o`05o`00000002`0000/0000;?l00000501V7Ed2o`0001@0L@@R00?o00000;@i6P2d>AX04P2d>AX2
o`0000h0h81C0_l0001R0?ooo`00HP3oool01?l00000000/0000;?l0000G06HMG@;o00004P1a1280
0ol00000]3TJ0;@i6P0@0;@i6P;o0000403PP5<00ol00000i7l>o`00001Q0?ooo`00H@3oool01Ol0
0000000/0000;00002co000001T0IQeM0ol0000?07448P03o`00002d>AX0]3TJ00h0]3TJ0_l0000C
0>20D`03o`00003TO`ko00000600oooo001P0?ooo`03o`00000002`0000/0080000/00?o000006HM
G@1V7Ed06P1V7Ed2o`0000d0L@@R00?o00000;@i6P2d>AX0302d>AX2o`0001D0h81C00?o00000>Ao
3_l00000H03oool005l0oooo00?o00000000;00002`00P0002`00ol00000IQeM06HMG@0M06HMG@;o
00002`1a12800ol00000]3TJ0;@i6P0:0;@i6P;o00005`3PP5<01?l00000i7l>0>Ao3_l0001O0?oo
o`00G`3oool00ol00000000/0000;0020000;003o`00001V7Ed0IQeM01l0IQeM0ol0000807448P03
o`00002d>AX0]3TJ00P0]3TJ0_l0000J0>20D`04o`00003TO`h0i7l>o`0005h0oooo001N0?ooo`03
o`00000002`0000/00<0000/00?o000006HMG@1V7Ed08P1V7Ed2o`0000L0L@@R00?o00000;@i6P2d
>AX0102d>AX3o`0001`0h81C00Co00000>Ao3P3TO`ko0000GP3oool005d0oooo00?o00000000;000
02`00`0002`00ol00000IQeM06HMG@0U06HMG@;o00001@1a12800ol00000]3TJ0;@i6P020;@i6P;o
00007`3PP5<01Ol00000i7l>0>Ao3P3TO`ko000005d0oooo001L0?ooo`03o`00000002`0000/00@0
000/00?o000006HMG@1V7Ed09`1V7Ed3o`000080L@@R00?o00000;@i6P2d>AX00_l0000R0>20D`04
o`00003TO`h0i7l>o`0005d0oooo001L0?ooo`03o`00000002`0000/00@0000/00?o000006HMG@1V
7Ed0:P1V7Ed5o`0002@0h81C00Go00000>Ao3P3TO`h0i7l>o`00001L0?ooo`00F`3oool00ol00000
000/0000;0050000;003o`00001V7Ed0IQeM02X0IQeM1?l0000U0>20D`03o`00003TO`h0i7l>0080
i7l>00?o00000?ooo`3oool0F@3oool005X0oooo00?o00000000;00002`01@0002`00ol00000IQeM
06HMG@0W06HMG@Co00000P21IJT00ol00000i[RWo`000002o`0002<0h81C00Go00000>Ao3P3TO`h0
i7l>o`00001K0?ooo`00F@3oool00ol00000000/0000;0060000;003o`00001V7Ed0IQeM02@0IQeM
0ol00005085UZ@?o00000`3V^:L3o`000200h81C00?o00000>Ao3P3TO`h00P3TO`h00ol00000oooo
0?ooo`1H0?ooo`00F@3oool00ol00000000/0000;0060000;003o`00001V7Ed0IQeM0200IQeM1?l0
0007085UZ@05o`00002PT<?o00000<jga?l000001@3V^:L3o`0001d0h81C00?o00000>Ao3P3TO`h0
0`3TO`h00ol00000oooo0?ooo`1G0?ooo`00F03oool00ol00000000/0000;0060000;003o`00001V
7Ed0IQeM01d0IQeM1?l0000:085UZ@06o`00002PT<<0X933o`00003>]lCo0000203V^:L3o`0001/0
h81C00?o00000>Ao3P3TO`h00P3TO`h00ol00000oooo0?ooo`1G0?ooo`00E`3oool00ol00000000/
0000;0070000;003o`00001V7Ed0IQeM01X0IQeM0ol0000=085UZ@05o`00002PT<<0X9330:2@`ol0
00000P3>]l@00ol00000i[RW0>JhY`080>JhY`;o00006@3PP5<00ol00000i7l>0>Ao3P030>Ao3P03
o`00003oool0oooo05H0oooo001F0?ooo`03o`00000002`0000/00P0000/00?o000006HMG@1V7Ed0
5P1V7Ed4o`0000l0PFFY00?o00000:2@``2PT<<00P2PT<<01Ol00000c[O40<jga03>]lCo000000/0
i[RW0ol0000F0>20D`03o`00003TO`h0i7l>00<0i7l>00?o00000?ooo`3oool0EP3oool005D0oooo
00?o00000000;00002`0200002`00ol00000IQeM06HMG@0C06HMG@Co00004`21IJT00ol00000X933
0:2@``020:2@``05o`00003>]l@0c[O40<jga?l000003P3V^:L3o`0001@0h81C00?o00000>Ao3P3T
O`h00`3TO`h00ol00000oooo0?ooo`1E0?ooo`00E@3oool00ol00000000/0000;0080000;003o`00
001V7Ed0IQeM00l0IQeM1?l0000F085UZ@03o`00002PT<<0X93300<0X93300?o00000<jga03>]l@0
0P3>]l@00ol00000i[RW0>JhY`0>0>JhY`?o00004@3PP5<00ol00000i7l>0>Ao3P040>Ao3P03o`00
003oool0oooo05@0oooo001D0?ooo`03o`00000002`0000/00T0000/00?o000006HMG@1V7Ed0301V
7Ed3o`0001T0PFFY00?o00000:2@``2PT<<0102PT<<00ol00000c[O40<jga0030<jga003o`00003V
^:L0i[RW0100i[RW0ol0000>0>20D`03o`00003TO`h0i7l>00@0i7l>00?o00000?ooo`3oool0E03o
ool005<0oooo00?o00000000;00002`02@0002`00ol00000IQeM06HMG@0906HMG@Co00006`21IJT0
0ol00000X9330:2@``050:2@``03o`00003>]l@0c[O400<0c[O400?o00000>JhY`3V^:L04`3V^:L3
o`0000`0h81C00?o00000>Ao3P3TO`h0103TO`h00ol00000oooo0?ooo`1C0?ooo`00DP3oool00ol0
0000000/0000;00:0000;003o`00001V7Ed0IQeM00D0IQeM1?l0000N085UZ@03o`00002PT<<0X933
00D0X93300?o00000<jga03>]l@01@3>]l@00ol00000i[RW0>JhY`0E0>JhY`;o00002P3PP5<00ol0
0000i7l>0>Ao3P050>Ao3P03o`00003oool0oooo0580oooo001B0?ooo`03o`00000002`0000/00X0
000/00?o000006HMG@1V7Ed00P1V7Ed3o`000280PFFY00?o00000:2@``2PT<<01@2PT<<00ol00000
c[O40<jga0060<jga003o`00003V^:L0i[RW01H0i[RW0ol000070>20D`03o`00003TO`h0i7l>00D0
i7l>00?o00000?ooo`3oool0DP3oool00540oooo00?o00000000;00002`02P0002`00ol00000IQeM
o`000003o`0002@0PFFY00?o00000:2@``2PT<<01P2PT<<00ol00000c[O40<jga0060<jga003o`00
003V^:L0i[RW01T0i[RW0ol000050>20D`03o`00003TO`h0i7l>00D0i7l>00?o00000?ooo`3oool0
D@3oool00500oooo00?o00000000;00002`02P0002`3o`0002L0PFFY00?o00000:2@``2PT<<01`2P
T<<00ol00000c[O40<jga0070<jga003o`00003V^:L0i[RW01/0i[RW0ol000020>20D`03o`00003T
O`h0i7l>00H0i7l>00?o00000?ooo`3oool0D03oool004l0oooo00?o00000000;00002`02P0002`0
0ol00000?3BNo`00000W085UZ@03o`00002PT<<0X93300P0X93300?o00000<jga03>]l@0203>]l@0
0ol00000i[RW0>JhY`0M0>JhY`?o0000203TO`h00ol00000oooo0?ooo`1@0?ooo`00C`3oool00ol0
0000000/0000;0080000;0;o00000P0l=9h00ol00000PFFY085UZ@0T085UZ@03o`00002PT<<0X933
00T0X93300?o00000<jga03>]l@0203>]l@00ol00000i[RW0>JhY`0P0>JhY`;o00001`3TO`h00ol0
0000oooo0?ooo`1?0?ooo`00CP3oool00ol00000000/0000;0070000;0;o0000100l=9h00ol00000
PFFY085UZ@0S085UZ@03o`00002PT<<0X93300X0X93300?o00000<jga03>]l@02@3>]l@00ol00000
i[RW0>JhY`0O0>JhY`03o`00003neiGo000000H0i7l>00?o00000?ooo`3oool0C`3oool004d0oooo
00?o00000000;00002`01`0002`00ol00000?3BN03`dWP0503`dWP03o`000021IJT0PFFY0280PFFY
00?o00000:2@``2PT<<02P2PT<<00ol00000c[O40<jga00:0<jga003o`00003V^:L0i[RW01h0i[RW
00Co00000?kGU@3neiGo00001P3TO`h00ol00000oooo0?ooo`1>0?ooo`00C03oool00ol00000000/
0000;0060000;0;o0000200l=9h00ol00000PFFY085UZ@0Q085UZ@03o`00002PT<<0X93300/0X933
00?o00000<jga03>]l@02P3>]l@00ol00000i[RW0>JhY`0N0>JhY`05o`00003neiD0o]NE0?kGUOl0
00001P3TO`h00ol00000oooo0?ooo`1=0?ooo`00C03oool00ol00000000/0000;0050000;003o`00
000l=9h0?3BN00P0?3BN00?o0000085UZ@21IJT08021IJT00ol00000X9330:2@``0<0:2@``03o`00
003>]l@0c[O400/0c[O400?o00000>JhY`3V^:L0703V^:L00ol00000o]NE0?kGU@030?kGU@03o`00
003TO`h0i7l>00<0i7l>00?o00000?ooo`3oool0C@3oool004/0oooo00?o00000000;00002`01000
02`2o`0000/0?3BN00?o0000085UZ@21IJT07`21IJT00ol00000X9330:2@``0=0:2@``03o`00003>
]l@0c[O400`0c[O400?o00000>JhY`3V^:L06`3V^:L00ol00000o]NE0?kGU@040?kGU@03o`00003T
O`h0i7l>00<0i7l>00?o00000?ooo`3oool0C03oool004X0oooo00?o00000000;00002`00`0002`2
o`0000d0?3BN00?o0000085UZ@21IJT07P21IJT00ol00000X9330:2@``0>0:2@``03o`00003>]l@0
c[O400`0c[O400?o00000>JhY`3V^:L06`3V^:L00ol00000o]NE0?kGU@050?kGU@03o`00003TO`h0
i7l>00<0i7l>00?o00000?ooo`3oool0B`3oool004T0oooo00?o00000000;00002`00`0002`00ol0
0000?3BN03`dWP0=03`dWP03o`000021IJT0PFFY01h0PFFY00?o00000:2@``2PT<<03P2PT<<00ol0
0000c[O40<jga00=0<jga003o`00003V^:L0i[RW01X0i[RW00?o00000?kGU@3neiD01P3neiD00ol0
0000i7l>0>Ao3P020>Ao3P03o`00003oool0oooo04/0oooo00190?ooo`04o`00000002`0000/0000
;0;o00004@0l=9h00ol00000PFFY085UZ@0L085UZ@03o`00002PT<<0X93300l0X93300?o00000<jg
a03>]l@03P3>]l@00ol00000i[RW0>JhY`0I0>JhY`03o`00003neiD0o]NE00L0o]NE00?o00000>Ao
3P3TO`h00P3TO`h00ol00000oooo0?ooo`1:0?ooo`00B03oool01Ol00000000/0000;00002co0000
01<0?3BN00?o0000085UZ@21IJT06`21IJT00ol00000X9330:2@``0@0:2@``03o`00003>]l@0c[O4
00h0c[O400?o00000>JhY`3V^:L06@3V^:L00ol00000o]NE0?kGU@080?kGU@;o00000P3TO`h00ol0
0000oooo0?ooo`1:0?ooo`00A`3oool00ol00000000/0000;002o`0001@0?3BN00?o0000085UZ@21
IJT06P21IJT00ol00000X9330:2@``0A0:2@``03o`00003>]l@0c[O400l0c[O400?o00000>JhY`3V
^:L05`3V^:L00ol00000o]NE0?kGU@0;0?kGU@04o`00003TO`h0i7l>o`0004/0oooo00160?ooo`04
o`00000002`0000/o`0001H0?3BN00?o0000085UZ@21IJT06@21IJT00ol00000X9330:2@``0B0:2@
``03o`00003>]l@0c[O40100c[O400?o00000>JhY`3V^:L05P3V^:L00ol00000o]NE0?kGU@0<0?kG
U@04o`00003TO`h0i7l>o`0004X0oooo00160?ooo`?o00005`0l=9h00ol00000PFFY085UZ@0H085U
Z@03o`00002PT<<0X93301<0X93300?o00000<jga03>]l@0403>]l@00ol00000i[RW0>JhY`0F0>Jh
Y`03o`00003neiD0o]NE00d0o]NE00?o00000>Ao3_l00000BP3oool004D0oooo0_l0000I03`dWP03
o`000021IJT0PFFY01P0PFFY00?o00000:2@``2PT<<04`2PT<<00ol00000c[O40<jga00A0<jga003
o`00003V^:L0i[RW01D0i[RW00?o00000?kGU@3neiD03P3neiD00ol00000i7l>o`0000190?ooo`00
A03oool00ol00000?3BN03`dWP0J03`dWP03o`000021IJT0PFFY01H0PFFY00?o00000:2@``2PT<<0
502PT<<00ol00000c[O40<jga00B0<jga003o`00003V^:L0i[RW01@0i[RW00?o00000?kGU@3neiD0
3`3neiD00ol00000i7l>o`0000180?ooo`00@`3oool2o`0001`0?3BN00?o0000085UZ@21IJT05@21
IJT00ol00000X9330:2@``0D0:2@``03o`00003>]l@0c[O401<0c[O400?o00000>JhY`3V^:L0503V
^:L00ol00000o]NE0?kGU@0@0?kGU@;o0000B03oool004<0oooo00?o000000hi^?l000006`0l=9h0
0ol00000PFFY085UZ@0D085UZ@03o`00002PT<<0X93301D0X93300?o00000<jga03>]l@0503>]l@0
0ol00000i[RW0>JhY`0B0>JhY`03o`00003neiD0o]NE0180o]NE0_l000170?ooo`00A03oool01?l0
00003SVho`000?l0000I03`dWP03o`000021IJT0PFFY01<0PFFY00?o00000:2@``2PT<<05P2PT<<0
0ol00000c[O40<jga00E0<jga003o`00003V^:L0i[RW0140i[RW00?o00000?kGU@3neiD04`3neiD0
0ol00000oooo0?ooo`150?ooo`00A@3oool01?l000003SVh00hi^?l0000H03`dWP03o`000021IJT0
PFFY01<0PFFY00?o00000:2@``2PT<<05P2PT<<00ol00000c[O40<jga00E0<jga003o`00003V^:L0
i[RW0140i[RW00?o00000?kGU@3neiD0503neiD00ol00000oooo0?ooo`140?ooo`00A@3oool01Ol0
00003SVh00hi^00>>KSo000001P0?3BN00?o0000085UZ@21IJT04@21IJT00ol00000X9330:2@``0G
0:2@``03o`00003>]l@0c[O401H0c[O400?o00000>JhY`3V^:L0403V^:L00ol00000o]NE0?kGU@0D
0?kGU@;o0000A@3oool004H0oooo00Co000000hi^00>>KP03SVh0_l0000F03`dWP03o`000021IJT0
PFFY0100PFFY00?o00000:2@``2PT<<0602PT<<00ol00000c[O40<jga00G0<jga003o`00003V^:L0
i[RW00l0i[RW00?o00000?kGU@3neiD04`3neiD00ol00000k?N[o`0000150?ooo`00AP3oool00ol0
00003SVh00hi^00300hi^003o`00000l=9h0?3BN01<0?3BN00?o0000085UZ@21IJT03`21IJT00ol0
0000X9330:2@``0I0:2@``03o`00003>]l@0c[O401L0c[O400?o00000>JhY`3V^:L03P3V^:L00ol0
0000o]NE0?kGU@0C0?kGU@03o`00003/mj_o000004H0oooo00170?ooo`03o`00000>>KP03SVh00<0
3SVh0_l0000C03`dWP03o`000021IJT0PFFY00h0PFFY00?o00000:2@``2PT<<06P2PT<<00ol00000
c[O40<jga00H0<jga003o`00003V^:L0i[RW00d0i[RW00?o00000?kGU@3neiD04P3neiD00ol00000
k?N[o`0000170?ooo`00B03oool00ol000003SVh00hi^00400hi^003o`00000l=9h0?3BN0100?3BN
00?o0000085UZ@21IJT03@21IJT00ol00000X9330:2@``0K0:2@``03o`00003>]l@0c[O401T0c[O4
00?o00000>JhY`3V^:L0303V^:L00ol00000o]NE0?kGU@0@0?kGU@;o00000P3/mj/00ol00000oooo
0?ooo`150?ooo`00B03oool00ol000003SVh00hi^00500hi^003o`00000l=9h0?3BN00l0?3BN00?o
0000085UZ@21IJT03@21IJT00ol00000X9330:2@``0K0:2@``03o`00003>]l@0c[O401T0c[O400?o
00000>JhY`3V^:L0303V^:L00ol00000o]NE0?kGU@0?0?kGU@05o`00003/mj/0k?N[0>cgZol00000
B03oool004T0oooo00?o000000hi^00>>KP01@0>>KP2o`000100?3BN00?o0000085UZ@21IJT02`21
IJT00ol00000X9330:2@``0L0:2@``03o`00003>]l@0c[O401X0c[O400?o00000>JhY`3V^:L02`3V
^:L00ol00000o]NE0?kGU@0>0?kGU@05o`00003/mj/0k?N[0>cgZol00000B@3oool004X0oooo00?o
000000hi^00>>KP01P0>>KP00ol00000?3BN03`dWP0=03`dWP03o`000021IJT0PFFY00X0PFFY00?o
00000:2@``2PT<<07@2PT<<00ol00000c[O40<jga00K0<jga003o`00003V^:L0i[RW00X0i[RW00?o
00000?kGU@3neiD0303neiD2o`0000@0k?N[00?o00000?ooo`3oool0A`3oool004X0oooo00?o0000
00hi^00>>KP01`0>>KP2o`0000d0?3BN00?o0000085UZ@21IJT02@21IJT00ol00000X9330:2@``0N
0:2@``03o`00003>]l@0c[O401/0c[O400?o00000>JhY`3V^:L02@3V^:L00ol00000o]NE0?kGU@0<
0?kGU@03o`00003/mj/0k?N[00<0k?N[00?o00000?ooo`3oool0B03oool004/0oooo00?o000000hi
^00>>KP0200>>KP00ol00000?3BN03`dWP0:03`dWP03o`000021IJT0PFFY00P0PFFY00?o00000:2@
``2PT<<07`2PT<<00ol00000c[O40<jga00L0<jga003o`00003V^:L0i[RW00P0i[RW00?o00000?kG
U@3neiD02`3neiD00ol00000k?N[0>cgZ`030>cgZ`03o`00003oool0oooo04T0oooo001;0?ooo`03
o`00000>>KP03SVh00T03SVh0_l0000:03`dWP03o`000021IJT0PFFY00P0PFFY00?o00000:2@``2P
T<<07`2PT<<00ol00000c[O40<jga00M0<jga003o`00003V^:L0i[RW00L0i[RW00?o00000?kGU@3n
eiD02P3neiD00ol00000k?N[0>cgZ`040>cgZ`03o`00003oool0oooo04T0oooo001<0?ooo`03o`00
000>>KP03SVh00X03SVh00?o000003`dWP0l=9h01`0l=9h00ol00000PFFY085UZ@07085UZ@03o`00
002PT<<0X9330200X93300?o00000<jga03>]l@07@3>]l@00ol00000i[RW0>JhY`070>JhY`03o`00
003neiD0o]NE00P0o]NE0_l000060>cgZ`03o`00003oool0oooo04X0oooo001=0?ooo`03o`00000>
>KP03SVh00X03SVh00?o000003`dWP0l=9h01`0l=9h00ol00000PFFY085UZ@05085UZ@03o`00002P
T<<0X9330240X93300?o00000<jga03>]l@07P3>]l@00ol00000i[RW0>JhY`060>JhY`03o`00003n
eiD0o]NE00L0o]NE00?o00000>cgZ`3/mj/01@3/mj/00ol00000oooo0?ooo`1;0?ooo`00C@3oool0
0ol000003SVh00hi^00;00hi^0;o00001`0l=9h00ol00000PFFY085UZ@04085UZ@03o`00002PT<<0
X9330280X93300?o00000<jga03>]l@07`3>]l@00ol00000i[RW0>JhY`050>JhY`03o`00003neiD0
o]NE00H0o]NE00?o00000>cgZ`3/mj/01P3/mj/00ol00000oooo0?ooo`1;0?ooo`00CP3oool00ol0
00003SVh00hi^00<00hi^003o`00000l=9h0?3BN00@0?3BN00?o0000085UZ@21IJT00`21IJT00ol0
0000X9330:2@``0S0:2@``03o`00003>]l@0c[O401l0c[O400?o00000>JhY`3V^:L0103V^:L00ol0
0000o]NE0?kGU@060?kGU@03o`00003/mj/0k?N[00H0k?N[00?o00000?ooo`3oool0C03oool004l0
oooo00?o000000hi^00>>KP0300>>KP2o`0000@0?3BN00?o0000085UZ@21IJT00P21IJT00ol00000
X9330:2@``0T0:2@``03o`00003>]l@0c[O40200c[O400?o00000>JhY`3V^:L00`3V^:L00ol00000
o]NE0?kGU@040?kGU@;o0000203/mj/00ol00000oooo0?ooo`1=0?ooo`00C`3oool00ol000003SVh
00hi^00>00hi^005o`00000l=9h0?3BN03`dW_l000001021IJT00ol00000X9330:2@``0T0:2@``03
o`00003>]l@0c[O40240c[O400?o00000>JhY`3V^:L00P3V^:L00ol00000o]NE0?kGU@030?kGU@03
o`00003/mj/0k?N[00P0k?N[00?o00000?ooo`3oool0C@3oool00500oooo00?o000000hi^00>>KP0
3P0>>KP01?l00000?3BN03`dW_l00003085UZ@03o`00002PT<<0X93302@0X93300?o00000<jga03>
]l@08P3>]l@00ol00000i[RW0>JhY`020>JhY`03o`00003neiD0o]NE0080o]NE00?o00000>cgZ`3/
mj/0203/mj/00ol00000oooo0?ooo`1>0?ooo`00D@3oool00ol000003SVh00hi^00>00hi^0;o0000
00@0?3BNo`000021IJWo00009`2PT<<00ol00000c[O40<jga00S0<jga005o`00003V^:L0i[RW0>Jh
Yol000000P3neiD2o`0000X0k?N[00?o00000?ooo`3oool0C`3oool00540oooo00?o000000hi^00>
>KP0400>>KP3o`0002P0X93300?o00000<jga03>]l@0903>]l@01_l00000i[RW0>JhYol00000o]NE
o`0000`0k?N[00?o00000?ooo`3oool0C`3oool00580oooo00?o000000hi^00>>KP0400>>KP5o`00
02D0X93300?o00000<jga03>]l@0903>]l@01Ol00000i[RWo`00003neiGo000000`0k?N[00?o0000
0?ooo`3oool0D03oool00580oooo00?o000000hi^00>>KP0400>>KP00ol00000TjCQ09>Th@0209>T
h@Oo00007P2PT<<00ol00000c[O40<jga00U0<jga0?o0000303/mj/00ol00000oooo0?ooo`1A0?oo
o`00D`3oool00ol000003SVh00hi^00>00hi^003o`00001<PnCo000000X0TjCQ1ol0000G0:2@``03
o`00003>]l@0c[O40240c[O41_l0000=0>cgZ`03o`00003oool0oooo0540oooo001D0?ooo`03o`00
000>>KP03SVh00d03SVh00Co000004b3i01<PnCo0000402CY>47o`000100X93300?o00000<jga03>
]l@05`3>]l@:o`0000D0b=;R00?o00000>cgZ`3/mj/02P3/mj/00ol00000oooo0?ooo`1B0?ooo`00
E03oool00ol000003SVh00hi^00=00hi^005o`00001<Pn@0C8?T04b3i?l000005P2CY>47o`0000T0
X93300?o00000<jga03>]l@0303>]l@;o`0000h0b=;R0_l0000<0>cgZ`03o`00003oool0oooo0580
oooo001E0?ooo`03o`00000>>KP03SVh00/03SVh00?o000004b3i01<Pn@00P1<Pn@00ol00000TjCQ
09>Th@0K09>Th@Oo00000P2PT<<00ol00000c[O40<jga0020<jga0[o00006038d^800ol00000doWS
o`00000;0>cgZ`03o`00003oool0oooo05<0oooo001F0?ooo`03o`00000>>KP03SVh00X03SVh00?o
000004b3i01<Pn@00`1<Pn@00ol00000TjCQ09>Th@0Q09>Th@Oo00008@38d^801?l00000doWS0=?i
hol0000:0>cgZ`03o`00003oool0oooo05@0oooo001F0?ooo`03o`00000>>KP03SVh00X03SVh00?o
000004b3i01<Pn@0101<Pn@00ol00000TjCQ09>Th@0R09>Th@03o`000038d^80b=;R0280b=;R00Go
00000=?ih`3CnN<0doWSo`00000:0>cgZ`03o`00003oool0oooo05@0oooo001G0?ooo`03o`00000>
>KP03SVh00P03SVh00?o000004b3i01<Pn@01P1<Pn@00ol00000TjCQ09>Th@0Q09>Th@03o`000038
d^80b=;R0240b=;R00?o00000=?ih`3CnN<00P3CnN<00ol00000k?N[0>cgZ`070>cgZ`03o`00003o
ool0oooo05D0oooo001G0?ooo`03o`00000>>KP03SVh00P03SVh00?o000004b3i01<Pn@01`1<Pn@0
0ol00000TjCQ09>Th@0P09>Th@03o`000038d^80b=;R0200b=;R00?o00000=?ih`3CnN<00`3CnN<0
0ol00000k?N[0>cgZ`060>cgZ`03o`00003oool0oooo05H0oooo001H0?ooo`03o`00000>>KP03SVh
00H03SVh00?o000004b3i01<Pn@0201<Pn@00ol00000TjCQ09>Th@0P09>Th@03o`000038d^80b=;R
01l0b=;R00?o00000=?ih`3CnN<0103CnN<00ol00000k?N[0>cgZ`060>cgZ`03o`00003oool0oooo
05H0oooo001I0?ooo`03o`00000>>KP03SVh00D03SVh00?o000004b3i01<Pn@02@1<Pn@00ol00000
TjCQ09>Th@0O09>Th@03o`000038d^80b=;R01h0b=;R00?o00000=?ih`3CnN<01@3CnN<00ol00000
k?N[0>cgZ`050>cgZ`03o`00003oool0oooo05L0oooo001I0?ooo`03o`00000>>KP03SVh00D03SVh
00?o000004b3i01<Pn@02P1<Pn@00ol00000TjCQ09>Th@0N09>Th@03o`000038d^80b=;R01d0b=;R
00?o00000=?ih`3CnN<01`3CnN<00ol00000k?N[0>cgZ`030>cgZ`03o`00003oool0oooo05P0oooo
001J0?ooo`03o`00000>>KP03SVh00<03SVh00?o000004b3i01<Pn@0301<Pn@00ol00000TjCQ09>T
h@0M09>Th@03o`000038d^80b=;R01d0b=;R00?o00000=?ih`3CnN<01`3CnN<00ol00000k?N[0>cg
Z`030>cgZ`03o`00003oool0oooo05P0oooo001K0?ooo`03o`00000>>KP03SVh00803SVh00?o0000
04b3i01<Pn@0301<Pn@00ol00000TjCQ09>Th@0L09>Th@03o`000038d^80b=;R01d0b=;R00?o0000
0=?ih`3CnN<0203CnN<00ol00000k?N[0>cgZ`020>cgZ`03o`00003oool0oooo05T0oooo001K0?oo
o`03o`00000>>KP03SVh00803SVh00?o000004b3i01<Pn@03@1<Pn@00ol00000TjCQ09>Th@0K09>T
h@03o`000038d^80b=;R01`0b=;R00?o00000=?ih`3CnN<02@3CnN<01Ol00000k?N[0>cgZ`3/mj_o
000005`0oooo001L0?ooo`04o`00000>>KP03SVho`000140C8?T00?o000009>Th@2CY>406P2CY>40
0ol00000b=;R0<SBhP0K0<SBhP03o`00003CnN<0doWS00X0doWS00Go00000>cgZ`3/mj/0k?N[o`00
001L0?ooo`00G03oool01?l000003SVh00hi^?l0000B04b3i003o`00002CY>40TjCQ01T0TjCQ00?o
00000<SBhP38d^806P38d^800ol00000doWS0=?ih`0;0=?ih`04o`00003/mj/0k?N[o`0005d0oooo
001M0?ooo`03o`00000>>KSo00000180C8?T00?o000009>Th@2CY>406@2CY>400ol00000b=;R0<SB
hP0I0<SBhP03o`00003CnN<0doWS00`0doWS00?o00000>cgZol00000GP3oool005h0oooo0_l0000C
04b3i003o`00002CY>40TjCQ01P0TjCQ00?o00000<SBhP38d^806038d^800ol00000doWS0=?ih`0=
0=?ih`03o`00003/mj_o000005h0oooo001P0?ooo`03o`00001<Pn@0C8?T0140C8?T00?o000009>T
h@2CY>405`2CY>400ol00000b=;R0<SBhP0G0<SBhP03o`00003CnN<0doWS00h0doWS0_l0001O0?oo
o`00H@3oool2o`000180C8?T00?o000009>Th@2CY>405P2CY>400ol00000b=;R0<SBhP0F0<SBhP03
o`00003CnN<0doWS00h0doWS0_l0001P0?ooo`00H`3oool00ol00000C8?T04b3i00?04b3i003o`00
002CY>40TjCQ01H0TjCQ00?o00000<SBhP38d^805@38d^800ol00000doWS0=?ih`0>0=?ih`03o`00
003oool0oooo0600oooo001T0?ooo`03o`00001<Pn@0C8?T00l0C8?T00?o000009>Th@2CY>405@2C
Y>400ol00000b=;R0<SBhP0E0<SBhP03o`00003CnN<0doWS00`0doWS0_l0001S0?ooo`00I@3oool2
o`000100C8?T00?o000009>Th@2CY>40502CY>400ol00000b=;R0<SBhP0D0<SBhP03o`00003CnN<0
doWS00`0doWS00?o00000?ooo`3oool0H`3oool006L0oooo00?o000004b3i01<Pn@03P1<Pn@00ol0
0000TjCQ09>Th@0C09>Th@03o`000038d^80b=;R01<0b=;R00?o00000=?ih`3CnN<02`3CnN<2o`00
06H0oooo001X0?ooo`;o00003`1<Pn@00ol00000TjCQ09>Th@0B09>Th@03o`000038d^80b=;R0180
b=;R00?o00000=?ih`3CnN<02`3CnN<00ol00000oooo0?ooo`1V0?ooo`00JP3oool00ol00000C8?T
04b3i00<04b3i003o`00002CY>40TjCQ0180TjCQ00?o00000<SBhP38d^804@38d^800ol00000doWS
0=?ih`0:0=?ih`;o0000J@3oool006/0oooo0_l0000=04b3i003o`00002CY>40TjCQ0140TjCQ00?o
00000<SBhP38d^804038d^800ol00000doWS0=?ih`0:0=?ih`03o`00003oool0oooo06T0oooo001]
0?ooo`03o`00001<Pn@0C8?T00/0C8?T00?o000009>Th@2CY>403`2CY>400ol00000b=;R0<SBhP0@
0<SBhP03o`00003CnN<0doWS00T0doWS0_l0001/0?ooo`00KP3oool2o`0000`0C8?T00?o000009>T
h@2CY>403P2CY>400ol00000b=;R0<SBhP0?0<SBhP03o`00003CnN<0doWS00T0doWS00?o00000?oo
o`3oool0K03oool00700oooo00?o000004b3i01<Pn@02@1<Pn@00ol00000TjCQ09>Th@0>09>Th@03
o`000038d^80b=;R00h0b=;R00?o00000=?ih`3CnN<0203CnN<2o`0006l0oooo001a0?ooo`03o`00
001<Pn@0C8?T00T0C8?T00?o000009>Th@2CY>403@2CY>400ol00000b=;R0<SBhP0>0<SBhP03o`00
003CnN<0doWS00L0doWS00?o00000?ooo`3oool0K`3oool00780oooo0_l0000:04b3i003o`00002C
Y>40TjCQ00`0TjCQ00?o00000<SBhP38d^803@38d^800ol00000doWS0=?ih`060=?ih`;o0000LP3o
ool007@0oooo00?o000004b3i01<Pn@0201<Pn@00ol00000TjCQ09>Th@0;09>Th@03o`000038d^80
b=;R00`0b=;R00?o00000=?ih`3CnN<01P3CnN<00ol00000oooo0?ooo`1b0?ooo`00M@3oool2o`00
00P0C8?T00?o000009>Th@2CY>402`2CY>400ol00000b=;R0<SBhP0;0<SBhP03o`00003CnN<0doWS
00D0doWS0_l0001e0?ooo`00M`3oool00ol00000C8?T04b3i00604b3i003o`00002CY>40TjCQ00X0
TjCQ00?o00000<SBhP38d^802P38d^800ol00000doWS0=?ih`050=?ih`03o`00003oool0oooo07D0
oooo001h0?ooo`;o00001`1<Pn@00ol00000TjCQ09>Th@0909>Th@03o`000038d^80b=;R00T0b=;R
00?o00000=?ih`3CnN<0103CnN<2o`0007P0oooo001j0?ooo`03o`00001<Pn@0C8?T00D0C8?T00?o
000009>Th@2CY>40202CY>400ol00000b=;R0<SBhP080<SBhP03o`00003CnN<0doWS00@0doWS00?o
00000?ooo`3oool0N03oool007/0oooo00?o000004b3i01<Pn@0101<Pn@00ol00000TjCQ09>Th@08
09>Th@03o`000038d^80b=;R00L0b=;R00?o00000=?ih`3CnN<00`3CnN<2o`0007/0oooo001l0?oo
o`;o00001@1<Pn@00ol00000TjCQ09>Th@0709>Th@03o`000038d^80b=;R00H0b=;R00?o00000=?i
h`3CnN<00`3CnN<00ol00000oooo0?ooo`1k0?ooo`00OP3oool00ol00000C8?T04b3i00304b3i003
o`00002CY>40TjCQ00H0TjCQ00?o00000<SBhP38d^801@38d^800ol00000doWS0=?ih`020=?ih`;o
0000OP3oool007l0oooo0_l0000404b3i003o`00002CY>40TjCQ00D0TjCQ00?o00000<SBhP38d^80
1@38d^801Ol00000doWS0=?ih`3CnN?o00000800oooo00210?ooo`03o`00001<Pn@0C8?T0080C8?T
00?o000009>Th@2CY>40102CY>400ol00000b=;R0<SBhP040<SBhP03o`00003CnN<0doWS00;o0000
P@3oool00880oooo0_l0000204b3i003o`00002CY>40TjCQ00<0TjCQ00?o00000<SBhP38d^801038
d^801?l00000doWS0=?ihol000230?ooo`00Q03oool01?l00000C8?T04b3i?l0000409>Th@03o`00
0038d^80b=;R00<0b=;R00Co00000=?ihol0003o0000Q03oool008D0oooo0_l000000`1<PnCo0000
09>Th@0209>Th@03o`000038d^80b=;R0080b=;R00?o00000=?ihol00000QP3oool008L0oooo00?o
000004b3i?l000000P2CY>401?l00000b=;R0<SBhP38d^83o`0008L0oooo00280?ooo`;o00000P2C
Y>400ol00000b=;R0<SBhP02o`0008T0oooo00290?ooo`;o000000<0TjCQo`000038d^800_l0002:
0?ooo`00R`3oool3o`0008`0oooo002<0?ooo`03o`00003oool0oooo08/0oooo003o0?oooa/0oooo
003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo
003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo
003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo
003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo
003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo
003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo
003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo
003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo
003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo
003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo
003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo
003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo
003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo
003o0?oooa/0oooo0000\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-5.00005*^-6, -5.00005*^-6, \
0.00355875, 0.00355875}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Draw a  Polytope  by a New VisibleSkeleton Graphics", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["\<\
Do[ uvp=circle[a,5,2];
\tShow[skel3D[uvp], 
\t\tBoxed->False, 
 \t\tViewPoint -> getMmaViewPoint[uvp,skel3D[uvp]],
 \t\tSphericalRegion->True
 \t],
 \t{a,Pi/11,Pi,Pi/18}
 ]\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->1.33333,
  AnimationCycleOffset->0.0625,
  AnimationCycleRepetitions->Infinity],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.0025 w
[ .01 .012 ] 0 setdash
.40674 .56343 m
.56256 .57912 L
s
.42318 .44701 m
.56256 .57912 L
s
.53835 .42212 m
.56256 .57912 L
s
.64695 .41988 m
.56256 .57912 L
s
.68009 .53652 m
.56256 .57912 L
s
.65684 .64913 m
.56256 .57912 L
s
.54135 .68857 m
.56256 .57912 L
s
.41824 .66762 m
.56256 .57912 L
s
.42318 .44701 m
.40674 .56343 L
s
.53835 .42212 m
.42318 .44701 L
s
.26321 .52582 m
.42318 .44701 L
s
.5 .27523 m
.42318 .44701 L
s
.36084 .38051 m
.42318 .44701 L
s
.64695 .41988 m
.53835 .42212 L
s
.5 .27523 m
.53835 .42212 L
s
.26321 .52582 m
.40674 .56343 L
s
.41824 .66762 m
.40674 .56343 L
s
.68009 .53652 m
.64695 .41988 L
s
.5 .27523 m
.64695 .41988 L
s
.76097 .47154 m
.64695 .41988 L
s
.64718 .34153 m
.64695 .41988 L
s
.41824 .66762 m
.26321 .52582 L
s
.41824 .66762 m
.34918 .66239 L
s
.41824 .66762 m
.5 .75807 L
s
.41824 .66762 m
.54135 .68857 L
s
.36084 .38051 m
.26321 .52582 L
s
.36084 .38051 m
.5 .27523 L
s
.33546 .34355 m
.36084 .38051 L
s
.76097 .47154 m
.68009 .53652 L
s
.65684 .64913 m
.68009 .53652 L
s
.64718 .34153 m
.5 .27523 L
s
.33546 .34355 m
.5 .27523 L
s
.0035 w
[ ] 0 setdash
.59455 .30616 m
.5 .27523 L
s
.45357 .28826 m
.5 .27523 L
s
.0025 w
[ .01 .012 ] 0 setdash
.54135 .68857 m
.5 .75807 L
s
.54135 .68857 m
.65684 .64913 L
s
.0035 w
[ ] 0 setdash
.33546 .34355 m
.26321 .52582 L
s
.29275 .45797 m
.26321 .52582 L
s
.32295 .59653 m
.26321 .52582 L
s
.34918 .66239 m
.26321 .52582 L
s
.65684 .64913 m
.76097 .47154 L
s
.65684 .64913 m
.66028 .63762 L
s
.65684 .64913 m
.5 .75807 L
s
.64718 .34153 m
.76097 .47154 L
s
.59455 .30616 m
.64718 .34153 L
s
.34918 .66239 m
.32295 .59653 L
s
.5 .75807 m
.34918 .66239 L
s
.29275 .45797 m
.33546 .34355 L
s
.45357 .28826 m
.33546 .34355 L
s
.41264 .38951 m
.33546 .34355 L
s
.59455 .30616 m
.76097 .47154 L
s
.62074 .41788 m
.76097 .47154 L
s
.60215 .57046 m
.76097 .47154 L
s
.66028 .63762 m
.76097 .47154 L
s
.45357 .28826 m
.59455 .30616 L
s
.41264 .38951 m
.45357 .28826 L
s
.5 .75807 m
.4491 .60337 L
s
.5 .75807 m
.60215 .57046 L
s
.5 .75807 m
.32295 .59653 L
s
.5 .75807 m
.66028 .63762 L
s
.41264 .38951 m
.29275 .45797 L
s
.32295 .59653 m
.29275 .45797 L
s
.66028 .63762 m
.60215 .57046 L
s
.62074 .41788 m
.59455 .30616 L
s
.41264 .38951 m
.59455 .30616 L
s
.32295 .59653 m
.41264 .38951 L
s
.32295 .59653 m
.4491 .60337 L
s
.41264 .38951 m
.62074 .41788 L
s
.60215 .57046 m
.62074 .41788 L
s
.4491 .60337 m
.41264 .38951 L
s
.60215 .57046 m
.4491 .60337 L
s
.60215 .57046 m
.41264 .38951 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.1,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016R000`400?l00000o`00003oo`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00RP3oool5000008/0oooo00250?ooo`D000000P3o
ool3o`0000<00000R03oool00840oooo10000000103ooooo00000?ooo`3oool3o`0000030?ooool0
003o00000080oooo00Co00000000000000000000Q@3oool007h0oooo1@0000040?ooo`;o0000103o
ool00ol00000oooo0?ooo`040?ooo`04o`0000000000000000000880oooo001l0?ooo`80000000D0
oooo0000003oool0ooooo`000007000000H0oooo00?o00000?ooo`3oool01@3oool3000007l0oooo
001j0?ooo`8000000P3oool010000000ooooo`000?l000020?ooo`;o0000103oool700000003o`00
003oool0oooo00<0oooo0_l000020?ooo`<00000O03oool007P0oooo0P0000020?ooo`;o000000<0
00000?ooo`3oool00P3oool00ol00000oooo0?ooo`030?ooo`03o`00003oool0oooo0080oooo00?o
00000?ooo`3oool01P0000020?ooo`03o`00003oool0oooo0080oooo0`00001i0?ooo`00MP3oool2
00000080oooo0_l000020?ooo`050000003oool0oooo0?ooool000001P3oool00ol00000oooo0?oo
o`020?ooo`03o`00003oool0oooo00H0oooo1`0000000ol00000oooo0?ooo`03000007H0oooo001d
0?ooo`8000001`3oool00`000000oooo0?ooo`080?ooo`03o`00003oool0oooo00<0oooo00?o0000
0?ooo`3oool03@3oool9000007<0oooo001b0?ooo`8000000P3oool2o`0000D0oooo00@000000?oo
o`3ooooo00003@3oool00ol00000oooo0?ooo`040?ooo`03o`00003oool0oooo00d0oooo1000001a
0?ooo`00L03oool2000000<0oooo00?o00000?ooo`3oool0103oool010000000oooo0?ooool0000F
0?ooo`03o`00003oool0oooo00T0oooo0_l00002000000040?ooo`000000000000000700oooo001]
0?ooo`<000000_l0000:0?ooo`030000003ooooo000000P0oooo00?o00000?ooo`3oool03@3oool0
0ol00000oooo0?ooo`070?ooo`<0000000Go00000?ooo`3oool000000?ooo`03000006h0oooo001[
0?ooo`8000000P3oool00ol00000oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo00?o0000
0?ooo`3oool01@3oool00ol00000oooo0?ooo`0=0?ooo`8000001P3oool01_l000000000o`000000
0000oooo000006d0oooo001Y0?ooo`8000000_l0000>0?ooo`030000003oool0oooo00P0oooo00?o
00000?ooo`3oool01P3oool00ol00000oooo0?ooo`070?ooo`04o`00003oool0oooo0?ooo`800000
2@3oool01@000000ooooo`0000000000oooo00800000J`3oool006L0oooo0P000002o`0000l0oooo
00?o00000000003oool02@3oool00ol00000oooo0?ooo`070?ooo`03o`00003oool0oooo00L0oooo
00?o00000000000000002`3oool01@000000oooo0?ooo`3oool000000080oooo0P00001Y0?ooo`00
I@3oool200000180oooo00?o00000000003oool0503oool00ol00000oooo0?ooo`050?ooo`<00000
00?o00000?ooo`3oool02P3oool00`000000oooo0?ooo`020?ooo`0500000?l0003o00000?ooo`00
0000J03oool006<0oooo0P000002o`0001<0oooo00<000000?ooo`3oool06@3oool200000100oooo
00<000000?ooo`3oool00`3oool010000000ooooo`00003oool2000006H0oooo001Q0?ooo`800000
0_l0000@0?ooo`;o00000P3oool00`000000oooo0?ooo`080?ooo`03o`00003oool0oooo00d0oooo
0P0000080?ooo`03o`00003oool0oooo00P0oooo00<000000?ooo`3oool00`3oool01P000000oooo
0?ooo`3ooooo0000000006D0oooo001O0?ooo`8000004`3oool00ol00000oooo0?ooo`020?ooo`03
0000003oool0oooo00P0oooo00?o00000?ooo`3oool02P3oool00ol0000000000000000;0?ooo`03
o`00003oool0oooo00L0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo0680oooo001N0?ooo`8000006@3oool00`000000oooo0?ooo`070?ooo`03o`00
003oool0oooo00T0oooo0`00000>0?ooo`03o`00003oool0oooo00H0oooo00<000000?ooo`3oool0
1@3oool01@000000oooo0?ooo`3oool0000006@0oooo001N0?ooo`030000003oool000000100oooo
00?o00000?ooo`3oool0103oool00`000000oooo0?ooo`0B0?ooo`8000000P3oool00ol00000oooo
0?ooo`0E0?ooo`030000003oool0oooo00H0oooo00D000000?ooo`3ooooo00000000001S0?ooo`00
G@3oool010000000ooooo`00003oool2000000d0oooo00?o00000?ooo`3oool01@3oool00`000000
oooo0?ooo`0@0?ooo`800000103oool00ol00000oooo0?ooo`0F0?ooo`030000003oool0oooo00H0
oooo00D000000?ooool00000oooo0000001R0?ooo`00G@3oool00`000000oooo0?ooo`030?ooo`80
00002P3oool00ol00000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo00?o00000?ooo`3o
ool00`3oool3000001L0oooo00?o00000?ooo`3oool01@3oool00`000000oooo0?ooo`070?ooo`05
0000003oool0oooo0?ooo`000000H@3oool005d0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`0?0?ooo`030000003oool0oooo00P0oooo00Co00000?ooo`3oool0oooo0P00000K0?oo
o`03o`00003oool0oooo00@0oooo00<000000?ooo`3oool0203oool01@000000oooo0?ooo`3oool0
00000600oooo001L0?ooo`030000003oool0oooo0080oooo00?o00000?ooo`3oool00P3oool20000
00@0oooo00?o00000?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`03o`00003oool0oooo
00800000303oool00ol00000oooo0?ooo`0?0?ooo`03o`00003oool0oooo00<0oooo00<000000?oo
o`3oool02@3oool01@000000oooo0?ooo`3oool0000005l0oooo001L0?ooo`030000003oool0oooo
00<0oooo00?o00000?ooo`3oool00`3oool2000000030?ooool00000oooo00T0oooo00<000000?oo
o`3oool0203oool00ol0000000000000000>0?ooo`03o`00003oool0oooo01H0oooo00<000000?oo
o`3oool01`3oool00ol00000oooo000000030?ooo`030000003oool0oooo05`0oooo001K0?ooo`80
00001P3oool00ol00000oooo0?ooo`040?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3o
ool01P3oool300000140oooo00?o00000?ooo`3oool0403oool00ol00000oooo0?ooo`020?ooo`03
0000003oool0oooo00L0oooo00Co00000?ooo`3oool000000P3oool00`000000oooo0?ooo`1L0?oo
o`00F`3oool00`000000oooo0?ooo`0=0?ooo`800000203oool00`000000oooo0?ooo`050?ooo`80
0000503oool00ol00000oooo0?ooo`0A0?ooo`05o`00003oool0oooo0?ooo`0000002@3oool01Ol0
0000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0F`3oool005X0oooo0P00000:0?oo
o`;o00001@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00<0oooo0P0000020?oo
o`03o`00003oool0oooo02H0oooo00Co00000?ooo`3oool000003P3oool010000000oooo0?ooo`00
001L0?ooo`00FP3oool00`000000oooo0?ooo`080?ooo`03o`00003oool0oooo00H0oooo0P000004
0?ooo`030000003oool0oooo0080oooo0P0000040?ooo`03o`00003oool0oooo02T0oooo00<00000
0?ooo`3oool03@3oool010000000oooo0?ooo`00001K0?ooo`00FP3oool00`000000oooo0?ooo`08
0?ooo`;o00002@3oool200000080oooo00<000000?ooo`0000000P0000050?ooo`03o`00003oool0
oooo01<0oooo00?o00000?ooo`3oool0503oool00ol0000000000?ooo`0>0?ooo`040000003oool0
oooo000005X0oooo001I0?ooo`8000002@3oool01?l00000oooo0?ooool0000:0?ooo`040000003o
ool00000000000P0oooo00?o00000?ooo`3oool04`3oool00ol00000oooo0?ooo`0E0?ooo`030000
003oool0oooo00H0oooo00?o00000?ooo`3oool01@3oool010000000oooo0?ooo`00001I0?ooo`00
F@3oool00`000000oooo0?ooo`070?ooo`03o`00003oool0oooo00`0oooo1P00000M0?ooo`03o`00
003oool0oooo01@0oooo00<00000o`00003oool01P3oool00ol00000oooo0?ooo`060?ooo`040000
003oool0oooo000005P0oooo001H0?ooo`8000005P3oool2000000040?ooo`000000oooo00000080
oooo1`00000F0?ooo`03o`00003oool0oooo01@0oooo00<000000?ooo`3oool01P3oool00ol00000
oooo0?ooo`070?ooo`040000003oool0oooo000005L0oooo001H0?ooo`8000003`3oool00ol00000
oooo0?ooo`030?ooo`030000003oool0oooo008000000P3oool00`000000oooo0?ooo`040?ooo`03
o`00003oool0000000H000009`3oool00`000000oooo0?ooo`050?ooo`03o`00003oool0oooo00P0
oooo00<000000?ooo`000000E`3oool005P0oooo00<000000?ooo`3oool01P3oool00ol00000oooo
0?ooo`060?ooo`03o`00003oool0oooo008000000`3oool2000000<0oooo00<000000?ooo`3oool0
0`3oool00ol00000oooo0?ooo`060?ooo`P000007`3oool00`000000ooooo`00000A0?ooo`030000
003oool0000005H0oooo001G0?ooo`800000203oool00ol00000oooo0?ooo`070?ooo`800000103o
ool010000000oooo0?ooo`0000030?ooo`050000003oool0oooo0?ooool000004@3oool700000003
o`00003oool0oooo01D0oooo00@000000?ooo`3ooooo00004@3oool00`000000oooo0000001E0?oo
o`00E`3oool00`000000oooo0?ooo`060?ooo`03o`00003oool0oooo00H0oooo0P0000060?ooo`04
0000003oool0oooo000000@0oooo00<000000?ooo`3oool06@3oool800000100oooo00D000000?oo
o`3oool0ooooo`0000030?ooo`03o`00003oool0oooo00/0oooo00<000000?ooo`000000E03oool0
05H0oooo0P00000@0?ooo`030000003oool0oooo0080oooo00Go00000?ooo`3oool0oooo00000002
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool06@3oool00ol00000oooo0?ooo`04
0?ooo`L000002@3oool00`000000oooo0?ooo`050?ooo`03o`00003oool0oooo00`0oooo00<00000
0?ooo`000000D`3oool005H0oooo0P00000>0?ooo`8000001@3oool01?l00000oooo0?ooo`000003
0?ooo`030000003oool0oooo00<0oooo00?o00000000003oool09`3oool7000000<0oooo00<00000
0?ooo`3oool00`3oool2o`0000l0oooo00<000000?ooo`000000DP3oool005H0oooo00<000000?oo
o`3oool01@3oool00ol00000oooo0?ooo`030?ooo`800000203oool00ol00000oooo000000030?oo
o`030000003oool0oooo00<0oooo00?o00000?ooo`000000;P3oool5000000@0oooo0_l0000@0?oo
o`030000003oool000000540oooo001E0?ooo`8000001P3oool00ol00000oooo0?ooo`020?ooo`80
00002`3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooool000000`3oool00`00
0000oooo0?ooo`0F0?ooo`;o00000P3oool4o`000080oooo1?l000020?ooo`Co00000P3oool2o`00
000300000?l0000000000080000000Co00000?ooool00000oooo0_l0000>0?ooo`800000D@3oool0
05D0oooo0P0000050?ooo`03o`00003oool0oooo0080oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`030?ooo`050000003oool0oooo0?ooool00000103oool00`000000oooo0?ooo`0?
0?ooo`;o00000P3oool2o`0000030?ooool00000oooo01D0oooo00<000000?ooo`3oool00P3oool3
000000<0oooo00?o00000?ooo`3oool0303oool200000500oooo001D0?ooo`8000002@3oool20000
00d0oooo00D000000?ooo`3oool0ooooo`0000020?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool0303oool2o`0000L0oooo00?o00000?ooo`3oool0503oool00`000000oooo0?ooo`03
0?ooo`04o`00003oool0000000000140oooo0P00001?0?ooo`00E03oool2000000L0oooo0P00000?
0?ooo`050000003oool0oooo0?ooool000000P3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo00D0oooo1?l0000;0?ooo`03o`00003oool0oooo01@0oooo00<000000?ooo`3oool01@3o
ool00ol00000oooo00000002000000040?ooool0003o0000o`0000/0oooo0P00001>0?ooo`00D`3o
ool2000000H0oooo00?o00000000003oool0403oool00`000000oooo0?ooo`020?ooo`03o`00003o
ool000000080oooo00?o00000?ooo`3oool01P3oool00`000000oooo0?ooo`02o`0002L0oooo00<0
00000?ooo`3oool02`3oool200000080oooo00?o00000?ooo`3oool02@3oool2000004d0oooo001C
0?ooo`8000001@3oool200000140oooo00<000000?ooo`3oool01@3oool010000000oooo0?ooool0
00050?ooo`;o00000P3oool00`00003o00000?ooo`0X0?ooo`030000003oool0oooo0080oooo00?o
00000?ooo`3oool0203oool300000080oooo0_l000080?ooo`800000C03oool005<0oooo0P000003
0?ooo`8000004`3oool00`000000oooo0?ooo`060?ooo`0300000?l00000oooo00<0oooo0_l00005
0?ooo`030000003oool0oooo0180oooo00?o00000?ooo`3oool04P3oool00`000000oooo0?ooo`02
0?ooo`03o`00003oool0oooo0080oooo00?o00000?ooo`3oool01P3oool3000000030?ooool00000
oooo00L0oooo0P00001;0?ooo`00DP3oool200000080oooo0P00000D0?ooo`030000003oool0oooo
00L0oooo00@00000o`000?l0003o00002P3oool00`000000oooo0?ooo`0A0?ooo`03o`00003oool0
oooo0180oooo00D000000?ooo`3oool0ooooo`0000050?ooo`03o`00003oool0oooo00T0oooo0P00
00090?ooo`800000BP3oool00580oooo0P0000000`3oool000000?ooo`0E0?ooo`030000003oool0
oooo00L0oooo00<00000o`00003oool0303oool200000140oooo00?o00000?ooo`3oool04P3oool0
0`000000oooo0?ooo`080?ooo`03o`00003oool0oooo00X0oooo0`000002o`0000D0oooo00<00000
0?ooo`3oool0B03oool00540oooo00@000000?ooo`00000000000P3oool00ol00000oooo0?ooo`0A
0?ooo`030000003oool0oooo00@0oooo0_l000020?ooo`030000003ooooo000000h0oooo00<00000
0?ooo`3oool03P3oool00ol00000oooo0?ooo`0B0?ooo`030000003oool0oooo00P0oooo00?o0000
0?ooo`3oool03@3oool200000003o`00003oool0oooo00<0oooo00<000000?ooo`3oool0A`3oool0
0540oooo0P0000040?ooo`03o`00003oool0oooo0140oooo00<000000?ooo`3oool00P3oool2o`00
00@0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0R0?ooo`030000003ooooo0000
01X0oooo0`000002o`000080oooo00<000000?ooo`3oool0AP3oool00540oooo0P0000030?ooo`03
o`00003oool0oooo0180oooo00<000000?ooo`3oool02@3oool01@000000oooo0?ooo`3ooooo0000
00d0oooo00<000000?ooo`3oool08@3oool00`000000ooooo`00000M0?ooo`<000000P3oool00`00
0000oooo0?ooo`150?ooo`00D03oool3000001L0oooo00@000000?ooool0003o00002@3oool00`00
0000oooo0?ooo`020?ooo`03o`00003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00ol0
0000oooo0?ooo`0A0?ooo`0300000?l00000oooo00T0oooo00?o00000?ooo`3oool0503oool20000
00030?ooo`000000oooo04D0oooo001@0?ooo`80000000<0oooo0000003oool05@3oool00`00003o
00000?ooo`090?ooo`03o`0000000000oooo00@0oooo00?o00000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`03o`00003oool0oooo0100oooo00<000000?ooool000002P3oool00ol00000
oooo0?ooo`0F0?ooo`<00000A@3oool004l0oooo0P0000020?ooo`0300000?l00000oooo0140oooo
0_l000000`000000oooo0?ooo`0:0?ooo`03o`0000000000oooo01<0oooo00<000000?ooo`3oool0
2P3oool00ol00000oooo0?ooo`0@0?ooo`030000003oool0oooo00/0oooo00?o00000?ooo`3oool0
5`3oool2000004@0oooo001?0?ooo`8000000P3oool00`000000oooo0?ooo`0@0?ooo`04o`00003o
ool0oooo000000/0oooo00?o00000?ooo`0000005@3oool00`000000oooo0?ooo`090?ooo`03o`00
003oool0oooo0100oooo00<000000?ooo`3oool0903oool00`00003o0000000000140?ooo`00C`3o
ool01@000000oooo0?ooool0000000000140oooo00Co00000?ooo`3oool00000303oool00ol00000
oooo000000070?ooo`03o`00003oool0oooo00`0oooo00<000000?ooo`3oool06`3oool00`00003o
00000?ooo`0R0?ooo`80000000?o00000000003oool0A03oool004h0oooo0P0000030?ooo`030000
003oool0oooo00/0oooo0_l000050?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
1@3oool00ol00000oooo0?ooo`0<0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0
803oool2000000<0oooo00<000000?ooo`3oool0@`3oool004h0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`090?ooo`03o`00003oool0oooo00D0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`060?ooo`03o`00003oool0oooo00`0oooo00<000000?ooo`3oool01`3o
ool00ol00000oooo0?ooo`0>0?ooo`03o`0000000000oooo00`0oooo00?o00000?ooo`3oool04@3o
ool00`000000ooooo`0000020?ooo`030000003oool0oooo04@0oooo001=0?ooo`80000000<0oooo
o`00003oool00P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00/0oooo00Co0000
0?ooo`3oool00000603oool00`000000oooo0?ooo`060?ooo`03o`00003oool0oooo00l0oooo00<0
00000?ooo`3oool02`3oool00ol00000oooo0?ooo`0?0?ooo`80000000D0ooooo`00003oool0oooo
000000170?ooo`00C@3oool010000000oooo0?ooool000030?ooo`030000003oool0oooo00D0oooo
0_l000090?ooo`030000003oool0oooo00/0oooo00Co00000?ooo`3oool000002`3oool00ol00000
oooo0?ooo`0;0?ooo`030000003oool0oooo00D0oooo00?o00000?ooo`3oool03`3oool00`000000
oooo0?ooo`0<0?ooo`03o`00003oool0oooo00d0oooo00@000000?ooo`3ooooo00000`3oool00`00
0000oooo0?ooo`150?ooo`00C03oool2000000030?ooool00000oooo00<0oooo00<000000?ooo`3o
ool00`3oool2o`0000X0oooo00<000000?ooo`3oool02`3oool01Ol00000oooo0?ooo`3oool00000
00`0oooo00?o00000?ooo`3oool02`3oool00`000000oooo0?ooo`040?ooo`03o`00003oool0oooo
00d0oooo00?o00000000003oool0703oool2000000H0oooo00<000000?ooo`3oool0AP3oool004`0
oooo0P0000000`3ooooo00000?ooo`030?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3o
ool02`3oool00ol00000oooo0?ooo`020?ooo`030000003oool0oooo00X0oooo00?o00000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0C0?ooo`03o`0000000000oooo01/0oooo00<000000?ooo`3o
ool00_l000040?ooo`030000003oool0oooo04H0oooo001<0?ooo`030000003oool0oooo00H0oooo
00<00000o`000?l000003@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01T0oooo
00<000000?ooo`3oool04@3oool00ol00000oooo0000000J0?ooo`8000000P3oool00ol00000oooo
0?ooo`030?ooo`030000003oool0oooo04L0oooo001;0?ooo`80000000?o00000?ooo`3oool01@3o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0303o
ool00ol00000oooo0?ooo`0;0?ooo`030000003oool0oooo00l0oooo00Co00000?ooo`3oool00000
403oool00ol00000oooo0?ooo`050?ooo`8000000`3oool00ol00000oooo0?ooo`030?ooo`030000
003oool0oooo04P0oooo001;0?ooo`030000003ooooo000000<0oooo0_l000020?ooo`030000003o
ool0oooo00d0oooo00<000000?ooo`3oool0303oool00ol00000oooo0?ooo`020?ooo`030000003o
ool0oooo00d0oooo00?o00000?ooo`3oool02`3oool200000080oooo00?o00000?ooo`3oool03@3o
ool00`000000oooo0?ooo`0>0?ooo`03o`00003oool0oooo00@0oooo00<000000?ooo`3oool02@3o
ool00`000000oooo0?ooo`180?ooo`00BP3oool200000005o`00003oool0oooo0?ooool00000103o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00?o00000?ooo`3oool00P3o
ool00`000000oooo0?ooo`0>0?ooo`03o`00003oool0oooo00`0oooo00<000000?ooool000003`3o
ool00`000000oooo0?ooo`0?0?ooo`04o`00003oool0oooo0?ooo`8000000`3oool2o`0000H0oooo
00<000000?ooo`3oool0B@3oool004X0oooo00<00000o`00003oool00P3oool00ol00000oooo0?oo
o`030?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00ol00000oooo0?oo
o`040?ooo`030000003oool0oooo01d0oooo00<00000o`00003oool02P3oool01Ol00000oooo0?oo
o`3oool0000001@0oooo00<000000?ooo`3oool00P3oool00ol00000oooo0?ooo`060?ooo`030000
003oool0oooo04T0oooo001:0?ooo`0300000?l0003o000000T0oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`0=0?ooo`03o`00003oool0oooo00@0oooo00<000000?ooo`3oool0403o
ool00ol00000oooo0?ooo`0;0?ooo`030000003oool0oooo00P0oooo00?o00000?ooo`3oool00P3o
ool00`000000oooo0?ooo`0@0?ooo`8000003@3oool00`000000oooo0?ooo`1:0?ooo`00B@3oool0
0`00003o0000o`00000:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0503oool0
0`000000oooo0?ooo`0A0?ooo`03o`00003oool0oooo00/0oooo00<000000?ooo`3oool01P3oool0
0ol00000oooo0?ooo`030?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0303oool2
000004`0oooo00190?ooo`0400000?l00000ooooo`0000T0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`0E0?ooo`030000003oool0oooo0180oooo00?o00000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00h0oooo0P000000103ooooo00000?ooo`3o
ool2o`0000T0oooo00<000000?ooo`3oool0B`3oool004X0oooo00<00000o`00003oool00P3oool3
o`0000@0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0
oooo01h0oooo00Co00000?ooo`3oool000002`3oool00`000000oooo0?ooo`0<0?ooo`8000000`3o
ool00ol00000ooooo`00000:0?ooo`030000003oool0oooo04`0oooo001;0?ooo`0300000?l00000
oooo00@0oooo00Ko00000?ooo`3ooooo000000000?l0000:0?ooo`030000003oool0oooo00h0oooo
00?o00000?ooo`3oool0103oool00`000000oooo0?ooo`0N0?ooo`05o`00003oool0oooo0?ooo`00
0000103oool00ol00000oooo0?ooo`030?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool00`3oool2o`0000/0oooo00<000000?ooo`3oool0C03oool004/0oooo0P00000:0?ooo`030000
0?l00000oooo00L0oooo00<000000?ooo`3oool03`3oool00ol00000oooo0?ooo`050?ooo`030000
003oool0oooo01<0oooo00?o00000?ooo`3oool0203oool01Ol00000oooo0?ooo`3oool0000000<0
oooo00?o00000?ooo`3oool00`3oool00`000000oooo0?ooo`090?ooo`800000103oool2o`000003
0?ooool00000oooo00T0oooo00<000000?ooo`3oool0C@3oool004`0oooo0P0000000ol00000oooo
0?ooo`060?ooo`040000003oool0oooo0?ooo`?o00000`3oool00`000000oooo0?ooo`0?0?ooo`03
o`00003oool0oooo00D0oooo00<000000?ooo`3oool0503oool00ol00000oooo0?ooo`0<0?ooo`03
0000003ooooo000000H0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`02o`0000@0
oooo00?o00000?ooo`3oool0203oool2000004l0oooo001=0?ooo`80000000?o00000?ooo`3oool0
1@3oool00`000000oooo0?ooo`040?ooo`03o`00003oool0000001X0oooo00<000000?ooo`3oool0
5@3oool00ol00000oooo0?ooo`0<0?ooo`0300000?l00000oooo00D0oooo00<000000?ooo`3oool0
1P3oool2000000030?ooool0003o00000140oooo00<000000?ooo`3oool0CP3oool004d0oooo00@0
00000?ooo`00003o00001P3oool00`000000oooo0?ooo`060?ooo`0300000?l0003o000000;o0000
5P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`0C0?ooo`800000D03oool004h0oooo0P0000070?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool01@3oool3o`000140oooo00<000000?ooo`3oool0603o
ool00ol00000oooo0?ooo`030?ooo`03o`00003oool0oooo00D0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`030?ooo`8000000_l0000:0?ooo`03o`00003oool0oooo00L0oooo00<0
00000?ooo`3oool0C`3oool004h0oooo00<000000?ooo`0000000P3oool00ol00000oooo0?ooo`02
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0203oool00ol00000oooo0?ooo`05
0?ooo`03o`00003oool0oooo00L0oooo00<000000?ooo`3oool0603oool00ol00000oooo0?ooo`02
0?ooo`03o`00003oool0oooo0080oooo00Go00000?ooo`3oool0oooo000000040?ooo`040000003o
ool0oooo0?ooo`8000003P3oool00ol00000oooo0?ooo`060?ooo`030000003oool0oooo0500oooo
001?0?ooo`030000003oool000000080oooo00Go00000?ooo`3oool0oooo000000060?ooo`030000
003oool0oooo00/0oooo1?l000000`3ooooo00000?ooo`080?ooo`030000003oool0oooo01T0oooo
00?o00000?ooo`3oool00P3oool01Ol00000oooo0?ooo`3ooooo000000@0oooo00@000000?ooo`3o
ool000000P3oool00ol0000000000?ooo`0>0?ooo`03o`00003oool0oooo00H0oooo0P00001B0?oo
o`00D03oool00`000000oooo000000020?ooo`04o`00003oool0oooo000000D0oooo00<000000?oo
o`3oool04@3oool4o`000080oooo0ol000000`3oool000000?ooo`0O0?ooo`04o`00003oool0oooo
o`0000H0oooo00@000000?ooo`00003o00000P00000@0?ooo`03o`00003oool0oooo00H0oooo00<0
00000?ooo`3oool0D@3oool00500oooo00@000000?ooo`3oool00000103oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo01X0oooo00?o00000000003oool01?l0000H0?ooo`03o`00003o
ool0oooo00T0oooo0_l00003000001X0oooo0P00001C0?ooo`00D@3oool010000000oooo0?ooo`00
00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool04P3oool00ol00000oooo0?oo
o`070?ooo`030000003oool0oooo00D0oooo1?l000020?ooo`?o00003P3oool00ol00000oooo0?oo
o`070?ooo`03o`00003oool00000008000006`3oool00`000000oooo0?ooo`1B0?ooo`00DP3oool0
0`000000oooo000000040?ooo`050000003oool0oooo0?ooo`000000503oool00ol00000oooo0?oo
o`070?ooo`030000003oool0oooo00h0oooo00Co00000?ooo`3oool0oooo0ol000080?ooo`?o0000
00<0ooooo`000?l000001@0000020?ooo`030000003oool0oooo0100oooo00?o00000?ooo`3oool0
1@3oool00`000000oooo0?ooo`1C0?ooo`00DP3oool010000000oooo0?ooo`0000030?ooo`040000
0?l00000oooo000001D0oooo00?o00000?ooo`3oool0203oool00`000000oooo0?ooo`0G0?ooo`?o
00000`3oool5000000H0oooo00<000000?ooo`0000004@3oool00ol00000oooo0?ooo`040?ooo`80
0000E@3oool005<0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00000E0?oo
o`03o`00003oool0oooo00P0oooo00<000000?ooo`3oool0603oool5000000;o00002@3oool01000
0000oooo0?ooo`00000@0?ooo`03o`00003oool0oooo00@0oooo00<000000?ooo`3oool0E03oool0
05@0oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`030000003oool0oooo01h0oooo00<0
00000?ooo`3oool04`3oool5000000<0oooo00Go00000?ooo`3oool0ooooo`0000070?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool03@3oool00ol00000oooo0?ooo`030?ooo`800000
EP3oool005@0oooo00@000000?ooo`3oool0oooo0P000000103oool000000?ooool0000O0?ooo`03
0000003oool0oooo00l0oooo100000070?ooo`03o`00003oool0oooo00X0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo05D0oooo001E0?ooo`040000
003oool0oooo0?ooo`<000000P3oool00ol00000oooo0?ooo`0B0?ooo`03o`00003oool0oooo00L0
oooo00<000000?ooo`3oool02P3oool5000000P0oooo00?o00000?ooo`3oool00`3oool00ol00000
oooo0?ooo`020?ooo`;o00000P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0100
oooo0P00001G0?ooo`00EP3oool010000000oooo0?ooo`3oool:000000l0oooo00?o00000?ooo`3o
ool0203oool00`000000oooo0?ooo`040?ooo`D00000303oool00ol00000oooo0?ooo`040?ooo`03
o`00003oool0oooo00@0oooo00?o00000000003oool01`3oool00`000000oooo0?ooo`0:0?ooo`03
o`00003oool0oooo0080oooo0P00001H0?ooo`00EP3oool01`000000oooo0?ooo`3oool000000?oo
o`0000001`3ooolB000000P0oooo00<000000?ooo`0000001000000@0?ooo`03o`00003oool0oooo
00@0oooo00?o00000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
00T0oooo00?o00000?ooo`3oool00P3oool00`000000oooo0?ooo`1G0?ooo`00E`3oool01`000000
oooo0?ooo`3oool000000?ooo`0000000`3oool2o`000100oooo00?o00000?ooo`3oool02P00000A
0?ooo`;o00002@3oool00ol00000oooo0?ooo`050?ooo`040000003oool0ooooo`0000P0oooo00<0
00000?ooo`3oool0203oool01?l00000oooo0?ooo`3oool2000005T0oooo001G0?ooo`050000003o
ool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`020?ooo`03o`00003oool0oooo01P0oooo
00<000000?ooo`3oool03`3oool00ol00000oooo0?ooo`0A0?ooo`050000003oool0oooo0?ooool0
0000203oool00`000000oooo0?ooo`070?ooo`05o`00003oool0oooo0?ooo`000000FP3oool005P0
oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo
00h0oooo00?o00000?ooo`3oool04@3oool00`000000oooo0?ooo`030?ooo`03o`00003oool0oooo
00H0oooo00<000000?ooo`3oool02@3oool2000005X0oooo001I0?ooo`040000003oool0oooo0000
00<0oooo00<000000?ooo`3oool0403oool00ol00000oooo0?ooo`090?ooo`030000003oool0oooo
01X0oooo00?o00000?ooo`3oool0103oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
00L0oooo0P00001K0?ooo`00F@3oool010000000oooo0?ooo`0000040?ooo`050000003oool0oooo
0?ooool000003@3oool00ol00000oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo0_l0000?
0?ooo`03o`00003oool0oooo00<0oooo00<000000?ooo`3oool01`3oool00ol00000oooo0?ooo`05
0?ooo`030000003oool0oooo00<0oooo00?o00000?ooo`3oool00P00001K0?ooo`00FP3oool01000
0000oooo0?ooo`0000040?ooo`050000003oool0oooo0?ooool000003@3oool00ol00000oooo0?oo
o`080?ooo`030000003oool0oooo00P0oooo00?o00000?ooo`3oool03P3oool00ol00000oooo0?oo
o`040?ooo`030000003oool0oooo00P0oooo00?o00000?ooo`3oool0103oool00`000000oooo0?oo
o`030?ooo`04o`00003oool00000000005`0oooo001K0?ooo`030000003oool0000000D0oooo00D0
00000?ooo`3oool0ooooo`00000<0?ooo`03o`00003oool0oooo00T0oooo00<000000?ooo`3oool0
603oool00ol00000oooo0?ooo`030?ooo`030000003oool0oooo00X0oooo00?o00000?ooo`3oool0
103oool01@000000oooo0?ooo`3ooooo00000080oooo00<000000?ooo`3oool0F`3oool005/0oooo
00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00<0
oooo0_l0000I0?ooo`030000003oool0oooo0180oooo00D000000?ooo`3ooooo00000?ooo`020000
05d0oooo001L0?ooo`030000003oool0000000H0oooo00<000000?ooo`3oool00P3oool00ol00000
oooo0?ooo`0C0?ooo`030000003oool0oooo0080oooo00?o00000?ooo`3oool0603oool00`000000
oooo0?ooo`0>0?ooo`;o0000103oool00`000000oooo0?ooo`02000005h0oooo001M0?ooo`800000
1`3oool2000000<0oooo00?o00000?ooo`3oool01P3oool00ol00000oooo0?ooo`0:0?ooo`030000
003oool0oooo01H0oooo00?o00000?ooo`3oool00P3oool00`000000oooo0?ooo`0A0?ooo`03o`00
003oool0oooo0080oooo00@000000?ooo`0000000000GP3oool005d0oooo00<000000?ooo`000000
203oool01@000000oooo0?ooo`3ooooo000000L0oooo00?o00000?ooo`3oool02P3oool00`00003o
00000?ooo`0F0?ooo`03o`00003oool0oooo0080oooo00<000000?ooo`3oool05P3oool3000005l0
oooo001N0?ooo`8000002@3oool00`000000oooo0?ooo`080?ooo`03o`00003oool0oooo00X0oooo
00<000000?ooo`3oool05P3oool01Ol00000oooo0?ooo`3oool0000001L0oooo00Co00000000003o
ool00000H03oool005h0oooo00<000000?ooo`0000002@3oool01@000000oooo0?ooo`3ooooo0000
00D0oooo00?o00000?ooo`3oool02@3oool00ol00000oooo0000000G0?ooo`05o`00003oool0oooo
0?ooo`0000005`3oool01000003o000000000000001P0?ooo`00G`3oool2000000X0oooo00D00000
0?ooo`3oool0ooooo`00000<0?ooo`;o0000103oool00`000000oooo0?ooo`0H0?ooo`030000003o
ool0oooo01@0oooo1@00001Q0?ooo`00H03oool2000000X0oooo00D000000?ooo`3oool0ooooo`00
000:0?ooo`03o`00003oool0oooo00@0oooo00<000000?ooo`3oool0603oool00`000000oooo0?oo
o`0C0?ooo`040000003oool00000000006<0oooo001P0?ooo`8000002`3oool00`000000oooo0?oo
o`050?ooo`03o`00003oool0oooo0080oooo00?o00000?ooo`3oool01P3oool00`000000oooo0?oo
o`0C0?ooo`04o`00003oool0oooo000001@0oooo0P0000000`3oool000000000001T0?ooo`00H@3o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0080oooo00?o00000?ooool000003@3o
ool00`000000oooo0?ooo`0C0?ooo`04o`00003oool0oooo00000180oooo0`0000000`3oool00000
0?ooo`1U0?ooo`00HP3oool200000080oooo1?l000020?ooo`?o000000<000000?ooo`3oool00P3o
ool4o`0000/0oooo00<000000?ooo`3oool04`3oool00ol00000oooo0000000?0?ooo`8000000P3o
ool010000000oooo0?ooo`00001W0?ooo`00I03oool00`000000oooo0?ooo`080?ooo`03o`000000
0000oooo00Ko0000303oool00`000000oooo0?ooo`0B0?ooo`03o`0000000000oooo00d0oooo0P00
00030?ooo`040000003oool00000000006P0oooo001U0?ooo`8000002P3oool00`000000oooo0?oo
o`020?ooo`03o`00003ooooo00000080oooo0ol000060?ooo`030000003oool0oooo01<0oooo00<0
00000?ooo`3oool0203oool2000000D0oooo0P0000000`3oool000000?ooo`1Y0?ooo`00I`3oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo0080oooo00?o00000?ooo`3oool0103oool0
0ol00000oooo0?ooo`03o`0000030000003oool0oooo0180oooo00<000000?ooo`3oool01`3oool2
000000H0oooo00@000000?ooo`0000000000J`3oool006P0oooo0P0000090?ooo`8000003`3oool0
0ol0000000000?ooo`03o`0000h0oooo00?o00000000003oool0103oool2000000T0oooo00<00000
0?ooo`000000K@3oool006X0oooo0P0000090?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool00P3oool00ol00000oooo0?ooo`03o`0000P0oooo00<000000?ooo`3oool00P3oool20000
00T0oooo0P0000000`3oool000000?ooo`1]0?ooo`00K03oool00`000000oooo0?ooo`070?ooo`04
0000003oool0ooooo`0000/0oooo00<000000?ooo`3oool0203oool00ol00000oooo0?ooo`03o`00
0080oooo0`00000<0?ooo`040000003oool00000000006l0oooo001]0?ooo`800000203oool01000
0000oooo0?ooool0000:0?ooo`030000003oool0oooo00h0oooo00?o00000000000000003@3oool0
0`000000oooo0000001a0?ooo`00K`3oool00`000000oooo0?ooo`060?ooo`040000003oool0oooo
o`0000X0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0:0?ooo`@00000LP3oool0
0700oooo0P0000070?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0000007@0oooo001b0?ooo`030000003oool0oooo00D0
oooo00@000000?ooo`3ooooo0000203oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
00T0oooo0`00001e0?ooo`00L`3oool2000000H0oooo00@000000?ooo`3ooooo0000203oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00T0oooo0P00001g0?ooo`00M@3oool00`000000
oooo0?ooo`040?ooo`040000003oool0ooooo`0000L0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`080?ooo`<00000N03oool007H0oooo0P0000050?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`070?ooo`<00000N@3oool007P0oooo
0P0000040?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`070?ooo`800000N`3oool007X0oooo00<000000?ooo`3oool00P3oool200000003o`00003o
ool0oooo00@0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`<00000O03o
ool007/0oooo0P0000040?ooo`0300000?l00000oooo00@0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`050?ooo`800000OP3oool007d0oooo00<000000?ooo`3oool00P3oool00`00
003o00000?ooo`040?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0103oool20000
07l0oooo001n0?ooo`8000000`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool00`3oool200000840oooo00200?ooo`070000003oool0oooo0?ooo`00
0000ooooo`0000020?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool20000
0880oooo00210?ooo`8000000P3oool00`00003o00000?ooo`020?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool00P3oool2000008<0oooo00230?ooo`050000003oool0oooo00000?l0
00000P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00800000Q@3oool008@0oooo
0P0000001@3oool000000?ooo`3oool0000000@0oooo00<000000?ooo`3oool00P0000260?ooo`00
QP3oool300000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`260?ooo`00
R03oool200000004o`0000000000oooo0?ooo`<00000R@3oool008T0oooo0`000000103oool00000
00000000002:0?ooo`00R`3oool3000008`0oooo002<0?ooo`030000003oool0oooo08/0oooo003o
0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o
0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o
0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o
0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o
0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o
0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o
0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o
0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o
0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o
0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o
0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o
0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o
0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o
0?oooa/0oooo003o0?oooa/0oooo0000\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-5.00005*^-6, -5.00005*^-6, \
0.00355875, 0.00355875}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.0025 w
[ .01 .012 ] 0 setdash
.43837 .56787 m
.59954 .57459 L
s
.44915 .45153 m
.59954 .57459 L
s
.5608 .41844 m
.59954 .57459 L
s
.66153 .40832 m
.59954 .57459 L
s
.69877 .5249 m
.59954 .57459 L
s
.67262 .64122 m
.59954 .57459 L
s
.56558 .68627 m
.59954 .57459 L
s
.44591 .6707 m
.59954 .57459 L
s
.44915 .45153 m
.43837 .56787 L
s
.5608 .41844 m
.44915 .45153 L
s
.28463 .53964 m
.44915 .45153 L
s
.5 .27523 m
.44915 .45153 L
s
.37205 .39097 m
.44915 .45153 L
s
.28463 .53964 m
.43837 .56787 L
s
.44591 .6707 m
.43837 .56787 L
s
.66153 .40832 m
.5608 .41844 L
s
.5 .27523 m
.5608 .41844 L
s
.37205 .39097 m
.28463 .53964 L
s
.37205 .39097 m
.5 .27523 L
s
.32583 .35751 m
.37205 .39097 L
s
.44591 .6707 m
.28463 .53964 L
s
.44591 .6707 m
.36151 .669 L
s
.44591 .6707 m
.5 .75807 L
s
.44591 .6707 m
.56558 .68627 L
s
.32583 .35751 m
.28463 .53964 L
s
.36151 .669 m
.28463 .53964 L
s
.0035 w
[ ] 0 setdash
.28173 .47266 m
.28463 .53964 L
s
.31287 .60622 m
.28463 .53964 L
s
.0025 w
[ .01 .012 ] 0 setdash
.69877 .5249 m
.66153 .40832 L
s
.5 .27523 m
.66153 .40832 L
s
.75109 .45378 m
.66153 .40832 L
s
.63975 .32946 m
.66153 .40832 L
s
.63975 .32946 m
.5 .27523 L
s
.32583 .35751 m
.5 .27523 L
s
.0035 w
[ ] 0 setdash
.56363 .2992 m
.5 .27523 L
s
.42732 .29358 m
.5 .27523 L
s
.0025 w
[ .01 .012 ] 0 setdash
.56558 .68627 m
.5 .75807 L
s
.56558 .68627 m
.67262 .64122 L
s
.75109 .45378 m
.69877 .5249 L
s
.67262 .64122 m
.69877 .5249 L
s
.0035 w
[ ] 0 setdash
.36151 .669 m
.31287 .60622 L
s
.5 .75807 m
.36151 .669 L
s
.67262 .64122 m
.75109 .45378 L
s
.67262 .64122 m
.65243 .6299 L
s
.67262 .64122 m
.5 .75807 L
s
.28173 .47266 m
.32583 .35751 L
s
.42732 .29358 m
.32583 .35751 L
s
.36409 .39816 m
.32583 .35751 L
s
.63975 .32946 m
.75109 .45378 L
s
.56363 .2992 m
.63975 .32946 L
s
.36409 .39816 m
.28173 .47266 L
s
.31287 .60622 m
.28173 .47266 L
s
.42732 .29358 m
.56363 .2992 L
s
.36409 .39816 m
.42732 .29358 L
s
.5 .75807 m
.42038 .60681 L
s
.5 .75807 m
.56879 .56558 L
s
.5 .75807 m
.31287 .60622 L
s
.5 .75807 m
.65243 .6299 L
s
.31287 .60622 m
.36409 .39816 L
s
.31287 .60622 m
.42038 .60681 L
s
.56363 .2992 m
.75109 .45378 L
s
.58146 .41029 m
.75109 .45378 L
s
.56879 .56558 m
.75109 .45378 L
s
.65243 .6299 m
.75109 .45378 L
s
.58146 .41029 m
.56363 .2992 L
s
.36409 .39816 m
.56363 .2992 L
s
.65243 .6299 m
.56879 .56558 L
s
.42038 .60681 m
.36409 .39816 L
s
.56879 .56558 m
.42038 .60681 L
s
.36409 .39816 m
.58146 .41029 L
s
.56879 .56558 m
.58146 .41029 L
s
.56879 .56558 m
.36409 .39816 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.1,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016R000`400?l00000o`00003oo`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00RP3oool4000008`0oooo00260?ooo`D0000000<0
ooooo`00000000000`0000290?ooo`00PP3oool400000080oooo00L00000o`00003ooooo00000?oo
ool0000000000080oooo0P0000270?ooo`00OP3oool400000080oooo0P0000020?ooo`04o`00003o
ool0ooooo`0000L0oooo0`0000240?ooo`00NP3oool4000000D0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`020?ooo`<00000P@3oool007L0oooo3000000?0?ooo`030000003oool0
oooo00@0oooo0`00001n0?ooo`00MP3oool00`000000oooo000000050?ooo`8000000`3ooolC0000
00D0oooo0`00001l0?ooo`00M03oool2000000030?ooo`000000oooo00@0oooo00<000000?ooo`3o
ool01@3oool00ol00000oooo0?ooo`020?ooo`03o`00003oool0oooo0080oooo00?o00000?ooo`3o
ool0103oool<000007P0oooo001b0?ooo`8000000P3oool00`000000oooo0?ooo`0;0?ooo`03o`00
003oool0oooo00<0oooo00?o00000?ooo`3oool00`3oool00ol00000oooo0?ooo`030?ooo`030000
003oool0oooo0080oooo0P0000000`3oool000000?ooo`03000007L0oooo001a0?ooo`030000003o
ool0oooo0080oooo00@000000?ooo`0000000000403oool00ol00000oooo0?ooo`0:0?ooo`040000
003oool00000000000<0oooo00D000000?ooo`3oool000000?ooo`03000007@0oooo001_0?ooo`80
0000103oool00`000000oooo000000090?ooo`03o`00003oool0oooo01<0oooo0P0000050?ooo`05
0000003oool0oooo0?ooo`0000000P3oool300000780oooo001^0?ooo`030000003oool0oooo0080
oooo0`00000:0?ooo`03o`00003oool0oooo00h0oooo00Co00000?ooo`3oool0oooo0P0000080?oo
o`040000003oool0oooo0?ooo`8000000`3oool3000006l0oooo001/0?ooo`8000000`3oool20000
00030?ooo`000000oooo00T0oooo00?o00000?ooo`3oool01`3oool00ol00000oooo0?ooo`050?oo
o`04o`00003oool00000000000D0oooo0P0000030?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool00`3oool2000006d0oooo001Z0?ooo`8000001`3oool00`000000oooo0?ooo`0C0?oo
o`03o`00003oool0oooo00D0oooo0P0000090?ooo`040000003oool0oooo000000H0oooo00<00000
0?ooo`3oool0103oool3000006X0oooo001Y0?ooo`040000003oool0oooo0?ooo`800000103oool0
0`000000oooo0?ooo`060?ooo`03o`00003oool0oooo00T0oooo00?o00000?ooo`3oool00`3oool3
000000030?ooool00000oooo00/0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`06
0?ooo`<00000I`3oool006L0oooo0P0000030?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool01P3oool00ol00000oooo0?ooo`0>0?ooo`8000004@3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool0I03oool006D0oooo0P00000:0?ooo`03
0000003oool0oooo00H0oooo00?o00000?ooo`3oool03@3oool2000001<0oooo0P0000080?ooo`80
0000203oool00`000000oooo0?ooo`1T0?ooo`00I03oool010000000oooo0?ooo`3oool2000000L0
oooo00<000000?ooo`3oool0503oool2000000T0oooo00?o00000?ooo`3oool02P3oool2000000T0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`1S0?ooo`00HP3oool200000080oooo
0P0000080?ooo`030000003oool0oooo00D0oooo00?o00000?ooo`3oool02`3oool2000000/0oooo
00?o00000?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00D0oooo
0P00001T0?ooo`00H@3oool3000000`0oooo00<000000?ooo`3oool0103oool00ol00000oooo0?oo
o`0:0?ooo`80000000<0ooooo`00003oool02`3oool00ol00000oooo0?ooo`090?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`1Q0?ooo`00G`3oool3
000000d0oooo00<000000?ooo`3oool0103oool00ol00000oooo0?ooo`090?ooo`8000000P3oool0
0ol00000oooo0?ooo`0;0?ooo`03o`00003oool0oooo00T0oooo00@000000?ooo`3oool0oooo0P00
00080?ooo`8000001`3oool00`000000oooo0?ooo`1P0?ooo`00G@3oool2000000l0oooo00<00000
0?ooo`3oool03`3oool2000001h0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool00000H@3oool005`0oooo0`00000?
0?ooo`030000003oool0oooo0080oooo00?o00000?ooo`3oool0203oool200000200oooo00<00000
0?ooo`3oool03P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool0GP3o
ool005/0oooo0P00000@0?ooo`030000003oool0oooo0080oooo00?o00000?ooo`3oool01`3oool2
000001P0oooo00?o00000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo00H0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo05d0oooo001K
0?ooo`800000403oool01@000000oooo0?ooo`3ooooo000000P0oooo0P0000090?ooo`03o`00003o
ool0oooo00h0oooo00?o00000?ooo`3oool0203oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo00H0oooo0P0000000`3oool000000?ooo`030?ooo`030000003oool0oooo05`0oooo001J
0?ooo`040000003oool0oooo000000h0oooo00<000000?ooo`3oool02@3oool2000000/0oooo00?o
00000?ooo`3oool03`3oool00ol00000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo05/0oooo001J
0?ooo`050000003oool0oooo0?ooo`000000303oool01@000000oooo0?ooo`3ooooo000000H0oooo
0P00000<0?ooo`03o`00003oool0oooo01X0oooo00<000000?ooo`3oool04P3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo05X0oooo001J0?ooo`030000003oool0oooo0080oooo00<0
0000o`000?l000002@3oool010000000oooo0?ooool000040?ooo`<00000:`3oool00`000000oooo
0?ooo`090?ooo`800000203oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo05T0oooo
001I0?ooo`030000003oool0oooo00@0oooo00<000000?ooool000001`3oool010000000oooo0?oo
ool000030?ooo`8000009@3oool00ol00000oooo0?ooo`060?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool01@3oool3000000@0oooo00<000000?ooo`3oool0F@3oool005T0oooo00<0
0000o`00003oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00<0oooo0P00
000W0?ooo`03o`00003oool0oooo00H0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`040?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0F03oool005T0oooo00<0
0000o`00003oool01P3oool010000000oooo0?ooool000030?ooo`0400000?l00000oooo0?ooo`80
0000503oool00ol00000oooo0?ooo`0C0?ooo`03o`00003oool0oooo00H0oooo00<000000?ooo`3o
ool04P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0E`3oool005P0
oooo00<00000o`00003oool0203oool020000000oooo0?ooool00000oooo00000?l00000oooo0P00
000F0?ooo`03o`00003oool0oooo01<0oooo00?o00000?ooo`3oool01P3oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`1F0?ooo`00F03oool00`00003o00000?ooo`090?ooo`040000003oool0ooooo`0000<00000603o
ool00ol00000oooo0?ooo`0L0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo05D0oooo001G0?ooo`030000003oool0
oooo00/0oooo00D000000?ooo`0000000000o`00000h0?ooo`030000003oool0oooo00l0oooo00D0
00000?ooo`3oool0oooo000000050?ooo`8000000`3oool00`000000oooo0?ooo`1D0?ooo`00E`3o
ool00`000000oooo0?ooo`0;0?ooo`X00000:`3oool00ol00000oooo0?ooo`050?ooo`030000003o
ool0oooo01<0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0000005D0oooo
001G0?ooo`0300000?l00000oooo00X0oooo00D000000?ooo`00003o0000000000060?ooo`l00000
703oool00ol00000oooo0?ooo`050?ooo`030000003oool0oooo0180oooo00<000000?ooo`000000
1`3oool01@000000oooo0?ooo`3oool0000005@0oooo001F0?ooo`030000003ooooo000000X0oooo
00@000000?ooo`3oool000000P3oool01@000000oooo0?ooo`3ooooo00000100oooo3`00000>0?oo
o`03o`00003oool0oooo00D0oooo00<000000?ooo`3oool04P3oool2000000P0oooo00D000000?oo
o`3oool0oooo0000001C0?ooo`00EP3oool00`000000ooooo`0000090?ooo`060000003oool0oooo
0000003oool000000P3oool01@000000oooo0?ooo`3ooooo000001<0oooo00?o00000?ooo`3oool0
203oool?00000003o`00003oool0oooo00@0oooo00<000000?ooo`3oool04P3oool00ol000000000
0?ooo`080?ooo`8000000P3oool00`000000oooo0?ooo`1@0?ooo`00EP3oool00`000000ooooo`00
00080?ooo`070000003oool0oooo0?ooo`000000oooo000000030?ooo`050000003oool0oooo0?oo
ool000004@3oool00ol00000oooo0?ooo`0H0?ooo`X000001P3oool2o`000080oooo1?l000030?oo
o`03o`00003ooooo0000008000002@3oool010000000oooo0?ooo`00001A0?ooo`00E@3oool00`00
0000oooo0?ooo`080?ooo`080000003oool0oooo0?ooool0000000000?ooo`0000040?ooo`800000
=@3oool00`00003o0000o`000004000000;o0000303oool01Ol00000oooo0000003oool0000000T0
oooo00<000000?ooo`000000D@3oool005D0oooo00<000000?ooo`3oool01`3oool02@000000oooo
0?ooo`3ooooo00000?ooo`000000oooo000000060?ooo`050000003oool0oooo0?ooool00000:@3o
ool6o`0000030?ooo`000000oooo00D0oooo1000000:0?ooo`03o`00003oool0000000@0oooo0P00
00060?ooo`030000003oool000000500oooo001D0?ooo`040000003oool0ooooo`0000H0oooo00<0
00000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0000000H0oooo00D000000?ooo`3oool0
ooooo`00000<0?ooo`03o`00003oool0oooo01L0oooo0_l000000`3ooooo00000?ooo`040?ooo`03
0000003oool0oooo00P0oooo100000080?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool0103oool3000004l0oooo001D0?ooo`040000003oool0ooooo`0000D0oooo00<000000?ooo`3o
ool0103oool01@000000oooo0?ooo`3oool0000000L0oooo00D000000?ooo`3oool0ooooo`00000;
0?ooo`03o`00003oool0oooo01<0oooo0_l000060?ooo`03o`00003oool0oooo0080oooo00<00000
0?ooo`3oool0303oool4000000`0oooo00<000000?ooo`3oool01@3oool2000004h0oooo001D0?oo
o`030000003ooooo000000D0oooo00<000000?ooo`3oool00`3oool00ol00000oooo000000030?oo
o`030000003oool0oooo00H0oooo0P00000<0?ooo`03o`00003oool0oooo0180oooo0_l000080?oo
o`03o`00003oool0oooo0080oooo00<000000?ooo`3oool0403oool4000000/0oooo0P0000040?oo
o`800000C@3oool005<0oooo00@000000?ooo`3ooooo00000`3oool2000000D0oooo00Co00000?oo
o`3oool00000103oool00`000000oooo0?ooo`070?ooo`050000003oool0oooo0?ooool000001`3o
ool00ol00000oooo0?ooo`0=0?ooo`?o0000403oool00`000000oooo0?ooo`0B0?ooo`03o`00003o
ool0oooo00@000002@3oool00`000000oooo0?ooo`020?ooo`800000C03oool005<0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`04o`00003oool0oooo000000D0oooo00<0
00000?ooo`3oool0203oool01@000000oooo0?ooo`3ooooo00000140oooo0_l0000F0?ooo`030000
003oool0oooo0140oooo00?o00000?ooo`3oool00P3oool00`000000oooo0?ooo`04000000/0oooo
0P00001;0?ooo`00D`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00P0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`090?ooo`050000003oool0oooo0?ooool00000
3`3oool00ol00000oooo0?ooo`0C0?ooo`04o`00003oool0oooo000001<0oooo00?o00000?ooo`3o
ool00`3oool00`000000oooo0?ooo`030?ooo`@00000103oool3000000030?ooo`000000000004X0
oooo001B0?ooo`060000003oool0oooo0?ooool0000000002`3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool01@3oool00ol00000oooo0?ooo`030?oo
o`;o00006@3oool01?l00000oooo0?ooo`00000S0?ooo`@000000`3oool010000000oooo0?ooo`00
00190?ooo`00DP3oool01@000000oooo0?ooo`3oool0000000P0oooo00Go00000?ooo`3oool0oooo
000000060?ooo`030000003oool0oooo00X0oooo0P0000020?ooo`Co0000103oool00ol00000oooo
0?ooo`0I0?ooo`04o`00003oool0oooo000002L0oooo100000030?ooo`030000003oool0oooo04H0
oooo001A0?ooo`050000003oool0oooo0?ooo`0000002@3oool01?l00000oooo0?ooo`0000070?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool00P3oool2o`0001l0oooo00Co00000?oo
o`3oool000004P3oool00ol00000oooo0?ooo`0F0?ooo`D00000A`3oool00540oooo00D000000?oo
o`3oool00000o`0000080?ooo`05o`00003oool0oooo0?ooo`0000001`3oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo00?o00008P3oool00`000000oooo0?ooo`0@0?ooo`03o`00003o
ool0oooo00D0oooo00<000000?ooo`3oool04P3oool2000004H0oooo001A0?ooo`030000003oool0
000000T0oooo00?o00000?ooo`3oool00P3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo00h0oooo00<00000o`000?l000000P3oool00ol00000oooo0?ooo`0O0?ooo`030000003oool0
oooo00l0oooo00?o00000?ooo`3oool01P3oool00`000000oooo0?ooo`0@0?ooo`@00000AP3oool0
0500oooo00<000000?ooo`0000003`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
00X0oooo00Ko00000?ooo`3oool0oooo00000?l0000R0?ooo`03o`00003oool0000001/0oooo00<0
00000?ooo`3oool03P3oool010000000oooo0000000000170?ooo`00D03oool200000080oooo00?o
00000?ooo`3oool02P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00T0oooo00?o
00000?ooo`3oool00`3oool2000000<0oooo0_l0000L0?ooo`03o`00003oool0000002X0oooo0P00
00030?ooo`030000003oool0oooo04D0oooo001@0?ooo`050000003oool0oooo0?ooool000001P3o
ool00ol00000oooo0?ooo`030?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203o
ool00ol00000oooo0?ooo`060?ooo`030000003oool0oooo0080oooo00?o00000?ooo`3oool06P3o
ool00ol0000000000?ooo`0W0?ooo`800000103oool2000004L0oooo001?0?ooo`030000003oool0
oooo0080oooo00?o00000?ooo`3oool0103oool00ol00000oooo0?ooo`030?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool00`3oool2o`0000`0oooo00<000000?ooo`3oool00P3oool0
0ol00000oooo0?ooo`0I0?ooo`030000003oool0oooo00l0oooo00?o00000?ooo`3oool0503oool0
0`000000oooo0?ooo`020?ooo`<00000B03oool004l0oooo00<000000?ooo`3oool00P3oool00ol0
0000oooo0?ooo`030?ooo`03o`00003oool0oooo00@0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`020?ooo`03o`00003oool0oooo00T0oooo00Go00000?ooo`3oool0oooo0000000O
0?ooo`030000003oool0oooo00l0oooo00?o00000?ooo`3oool02@3oool00`000000oooo0?ooo`06
0?ooo`800000103oool010000000oooo0000000000180?ooo`00C`3oool00`000000oooo0?ooo`0>
0?ooo`030000003oool0oooo00T0oooo00D000000?ooo`3oool0ooooo`00000<0?ooo`03o`00003o
ool0oooo0080oooo0P0000030?ooo`03o`00003oool0oooo01L0oooo00<000000?ooo`3oool03P3o
ool00ol00000oooo0?ooo`0:0?ooo`030000003oool0oooo00@0oooo0P0000050?ooo`040000003o
ool00000000004T0oooo001?0?ooo`8000003`3oool00`000000oooo0?ooo`090?ooo`0300000?l0
0000oooo00h0oooo00?o00000?ooo`3oool0103oool01@000000oooo0?ooo`3ooooo000001P0oooo
00<00000o`00003oool0703oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00L0oooo
0P0000190?ooo`00C`3oool200000080oooo00?o00000?ooo`3oool00P3oool00ol00000oooo0?oo
o`050?ooo`030000003oool0oooo00T0oooo00?o00000000003oool05P3oool01@000000oooo0?oo
o`3ooooo000001L0oooo00<00000o`00003oool07`3oool2000000T0oooo0P00001:0?ooo`00C`3o
ool200000080oooo00?o00000?ooo`3oool00P3oool00ol00000oooo0?ooo`050?ooo`030000003o
ool0oooo00P0oooo00?o00000?ooo`000000603oool00`000000oooo0?ooo`0H0?ooo`0300000?l0
0000oooo00d0oooo00?o00000?ooo`3oool03@3oool2000000P0oooo00<000000?ooo`3oool00P00
001:0?ooo`00C`3oool2000000030?ooool00000oooo00<0oooo00?o00000?ooo`3oool01@3oool0
0`000000oooo0?ooo`050?ooo`;o0000103oool00`000000oooo0?ooo`0G0?ooo`030000003oool0
oooo0080oooo00?o00000?ooo`3oool04P3oool00`00003o00000?ooo`0=0?ooo`03o`00003oool0
oooo00`0oooo0P0000090?ooo`050000003oool000000?ooo`000000BP3oool004l0oooo0P000000
0`3ooooo00000?ooo`0;0?ooo`030000003oool0oooo00@0oooo00?o00000?ooo`3oool0103oool0
0`000000oooo0?ooo`0=0?ooo`03o`00003oool0oooo00P0oooo0P0000030?ooo`03o`00003oool0
oooo0140oooo00<000000?ooo`3oool0303oool00ol00000oooo0?ooo`0;0?ooo`80000000<0oooo
0000003oool01`3oool01@000000oooo0000003oool0000004/0oooo001?0?ooo`030000003oool0
000000d0oooo00<000000?ooo`3oool00`3oool00ol00000oooo0?ooo`060?ooo`030000003oool0
oooo00`0oooo00?o00000?ooo`3oool02P3oool01@000000oooo0?ooo`3ooooo00000180oooo00<0
00000?ooo`3oool0303oool00ol00000oooo0?ooo`090?ooo`800000103oool00`000000oooo0?oo
o`070?ooo`030000003oool0000004/0oooo001?0?ooo`030000003oool0000000<0oooo00?o0000
0?ooo`3oool01P3oool00`000000oooo0?ooo`02o`0000/0oooo00<000000?ooo`3oool02`3oool0
0ol00000oooo0?ooo`0<0?ooo`030000003oool0oooo01<0oooo00<000000?ooool000005`3oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo00H0oooo00<000000?ooo`000000C03oool0
04l0oooo00<000000?ooo`0000000`3oool00ol00000oooo0?ooo`060?ooo`030000003ooooo0000
00d0oooo00<000000?ooo`3oool02`3oool00ol00000oooo0?ooo`0=0?ooo`030000003oool0oooo
0080oooo00?o00000?ooo`3oool03@3oool00`000000ooooo`00000E0?ooo`8000003@3oool01P00
0000oooo0?ooo`000000oooo000004`0oooo001?0?ooo`030000003oool000000080oooo00?o0000
0?ooo`3oool01`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo01/0oooo00<00000
0?ooo`3oool00P3oool00ol00000oooo0?ooo`0;0?ooo`050000003oool0oooo0?ooool000002P3o
ool00ol00000oooo0?ooo`050?ooo`8000003P3oool010000000oooo0?ooo`0000020?ooo`030000
003oool0oooo04X0oooo001?0?ooo`030000003oool000000080oooo00?o00000?ooo`3oool01@3o
ool2o`0000030000003oool0oooo00h0oooo00<000000?ooo`3oool0703oool2000000<0oooo00?o
00000?ooo`3oool02P3oool01@000000oooo0?ooo`3ooooo000000X0oooo00?o00000?ooo`3oool0
103oool00`000000oooo0?ooo`0:0?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`00
0000C@3oool004l0oooo00@000000?ooool0000000001`3oool2o`0000030?ooo`000000oooo0100
oooo00<000000?ooo`3oool02P3oool00ol00000oooo0?ooo`0A0?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool02`3oool00ol00000oooo0?ooo`030?ooo`8000003@3oool00`000000
oooo0?ooo`030?ooo`040000003oool0oooo000004d0oooo001?0?ooo`040000003oool0oooo0000
00X0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0:0?ooo`03o`00003oool0oooo
0180oooo00<000000?ooo`3oool00P3oool00ol00000oooo0?ooo`070?ooo`030000003oool0oooo
00/0oooo00Co00000?ooo`3oool0oooo0P00000@0?ooo`050000003oool0oooo0?ooo`0000000P3o
ool00`000000oooo0?ooo`1<0?ooo`00C`3oool010000000oooo0?ooo`0000030?ooo`;o00001@3o
ool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00T0oooo00?o00000?ooo`3oool04`3o
ool00`000000oooo0?ooo`020?ooo`03o`00003oool0oooo00H0oooo00<000000?ooo`3oool00P3o
ool00ol00000oooo0?ooo`090?ooo`030000003oool0oooo00l0oooo00?o00000000003oool00P3o
ool010000000oooo0?ooo`00001>0?ooo`00C`3oool01000003o00000?ooo`0000020?ooo`03o`00
003oool0oooo00D0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`090?ooo`03o`00
003oool0oooo01@0oooo00<000000?ooo`3oool00P3oool00ol00000oooo0?ooo`050?ooo`030000
003oool0oooo0080oooo00?o00000?ooo`3oool01`3oool200000100oooo0_l000001@3oool00000
0?ooo`3oool000000080oooo00<000000?ooo`3oool0C@3oool004l0oooo00@00000o`000?l00000
00002@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0240oooo0P00000:0?ooo`03
0000003oool0oooo0080oooo00?o00000?ooo`3oool0103oool00ol0000000000000000D0?ooo`05
0000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`1=0?ooo`00C`3oool01@000000
ooooo`000?l00000000000P0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0S0?oo
o`040000003oool0oooo0?ooo`;o0000103oool00`000000oooo0?ooo`020?ooo`03o`00003oool0
oooo00@0oooo00<000000?ooo`3oool03P3oool2o`0000@0oooo00@000000?ooo`3oool000000`3o
ool00`000000oooo0?ooo`1=0?ooo`00C`3oool01@00003o0000o`00003oool0000000P0oooo00<0
00000?ooo`3oool04P3oool00`000000oooo0?ooo`070?ooo`03o`00003oool0oooo01T0oooo00<0
00000?ooo`3oool00P3oool01Ol00000oooo0?ooo`3oool0000000T0oooo0P00000@0?ooo`03o`00
003oool0oooo00L0oooo00@000000?ooo`3oool00000D03oool004l0oooo00D000000?ooool0003o
0000000000020?ooo`;o0000103oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00L0
oooo00?o00000?ooo`3oool06P3oool00`000000oooo0?ooo`020?ooo`04o`00003oool0oooo0000
00L0oooo0P0000000`3ooooo00000?ooo`0H0?ooo`050000003oool0oooo0?ooo`000000D03oool0
0500oooo00@00000o`000?l000000000103oool01?l00000oooo0?ooo`000002o`0001<0oooo00<0
00000?ooo`3oool01`3oool00ol00000oooo0?ooo`0K0?ooo`8000001@3oool00`000000oooo0?oo
o`030?ooo`03o`0000000000oooo00l0oooo0_l000090?ooo`8000000`3oool00`000000oooo0?oo
o`1?0?ooo`00D03oool01@00003o00000?ooo`3oool0000000H0oooo00@000000?ooo`3ooooo0000
4`3oool00`000000oooo0?ooo`060?ooo`03o`00003oool0oooo01d0oooo00D000000?ooo`3oool0
oooo000000050?ooo`8000003`3oool2o`0000/0oooo0P0000030?ooo`030000003oool0oooo04l0
oooo001@0?ooo`050000003ooooo00000?ooo`0000001P3oool00`000000oooo0?ooo`040?ooo`?o
00003@3oool00`000000oooo0?ooo`0W0?ooo`050000003oool0oooo00000?l000000P3oool20000
0080oooo00Co00000?ooo`3ooooo0000203oool00ol00000oooo0?ooo`0<0?ooo`800000103oool0
0`000000oooo0?ooo`1?0?ooo`00D@3oool01@00003o00000?ooo`00003o000000D0oooo00<00000
0?ooo`3oool02P3oool4o`0000H0oooo00<000000?ooo`3oool0:03oool01P000000oooo0000003o
oooo0000000000@0oooo00Co00000?ooo`3ooooo00001`3oool00ol00000oooo0?ooo`0=0?ooo`80
00000`3oool00`000000oooo0?ooo`1@0?ooo`00D@3oool01P000000oooo0?ooo`000000ooooo`00
00<0oooo00<000000?ooo`3oool04@3oool4o`0000030000003oool0oooo00H0oooo00?o00000?oo
o`3oool0803oool4000000L0oooo00?o00000?ooo`3oool01@3oool00ol00000oooo0?ooo`0>0?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool0D03oool00580oooo00<000000?ooo`00
00001@3oool00`000000oooo0?ooo`0F0?ooo`0300000?l0003o000000;o00000`3oool00ol00000
oooo0?ooo`0O0?ooo`@000000`3oool00ol00000oooo0?ooo`060?ooo`;o00004`3oool01@000000
oooo0?ooo`3oool0000005<0oooo001B0?ooo`040000003ooooo0000000000<0oooo00?o00000000
003oool05`3oool00`000000oooo0?ooo`040?ooo`Co00000`3oool4o`0001D0oooo0`0000020?oo
o`030000003oool0000000<0oooo00?o00000?ooool000000`3oool2o`0001@0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`1A0?ooo`00D`3oool00`00003o0000000000040?ooo`03
0000003oool0oooo01H0oooo00<000000?ooo`3oool04@3oool4o`000080oooo1?l000020?ooo`?o
000010000002o`000080oooo00D000000?ooo`3oool0oooo000000030?ooo`;o0000603oool20000
00@0oooo00<000000?ooo`3oool0D@3oool005<0oooo00<000000?ooo`0000000`3oool00`000000
ooooo`00000G0?ooo`030000003oool0oooo00D0oooo00?o00000?ooo`3oool05@3oool3000000H0
oooo00Co00000?ooo`000000oooo0ol00002000000040?ooool0003o0000o`0001L0oooo0P000003
0?ooo`030000003oool0oooo0580oooo001C0?ooo`030000003oool0000000<0oooo00<000000?oo
o`3oool0603oool00`000000oooo0?ooo`040?ooo`03o`00003oool0oooo0180oooo0`00000;0?oo
o`030000003oool0oooo00@0oooo00<000000?ooool000000_l0000E0?ooo`030000003oool00000
00<0oooo00<000000?ooo`3oool0DP3oool005@0oooo0P0000030?ooo`030000003oool0oooo0080
oooo00?o00000?ooo`3oool04`3oool00`000000oooo0?ooo`040?ooo`03o`00003oool0oooo00h0
oooo1000000=0?ooo`030000003oool0oooo00H0oooo00D00000o`00003oool0ooooo`00000D0?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool0D`3oool005@0oooo00H000000?ooo`00
003o00000?ooo`0000050?ooo`03o`00003oool0oooo0180oooo00<000000?ooo`3oool04P3oool3
00000140oooo00<000000?ooo`3oool00`3oool2o`000080oooo0P00000E0?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool0D`3oool005D0oooo0P0000000ol0000000000?ooo`060?oo
o`03o`00003oool0oooo0180oooo00<000000?ooo`3oool03@3oool4000001@0oooo00@000000?oo
o`3oool0oooo0_l000060?ooo`050000003oool0oooo0?ooool00000403oool00`000000oooo0000
00020?ooo`030000003oool0oooo05@0oooo001E0?ooo`80000000<0oooo0000003oool06`3oool0
0`000000oooo0?ooo`0:0?ooo`<000005`3oool00`000000oooo0?ooo`070?ooo`05o`00003oool0
oooo0?ooo`0000000`3oool00ol00000oooo0?ooo`0<0?ooo`040000003oool0oooo00000080oooo
00<000000?ooo`3oool0E03oool005H0oooo00<000000?ooo`0000002P3oool00ol00000oooo0?oo
o`0?0?ooo`030000003oool0oooo00<0oooo00Co00000?ooo`3oool0oooo0`00000J0?ooo`040000
003ooooo0000o`0000H0oooo00?o00000?ooo`3oool00P3oool200000080oooo00?o00000?ooo`3o
ool02P3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo05@0oooo001F0?ooo`03
0000003oool0000000/0oooo00?o00000?ooo`3oool03P3oool00`000000oooo0?ooo`030?ooo`@0
00007@3oool00`00003o00000?ooo`070?ooo`03o`00003oool0oooo00@0oooo00<000000?ooo`3o
ool0303oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo05D0oooo001F0?ooo`80
00000P3oool00ol00000oooo0?ooo`080?ooo`03o`00003oool0oooo00h0oooo00<000000?ooo`00
00000P0000000ol00000oooo0?ooo`0M0?ooo`030000003oool0oooo00P0oooo00?o00000?ooo`3o
ool01@3oool010000000oooo0?ooool000090?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool0E@3oool005L0oooo8@0000030?ooo`03o`00003oool0oooo01/0oooo00?o00000?ooo`00
00004`3oool2000000030?ooool00000oooo00L0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`1F0?ooo`00E`3oool01@000000oooo0000003ooooo000000/0oooo0ol0000<0?ooo`03
0000003oool0oooo01l0oooo00Co00000?ooo`3oool000005@3oool00`000000ooooo`0000060?oo
o`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`1F0?ooo`00F03oool01@00
0000oooo0000003ooooo000000d0oooo00?o00000?ooo`3oool02P3oool00`000000oooo0?ooo`0M
0?ooo`04o`00003oool0oooo000000X0oooo00?o00000?ooo`3oool02P3oool00`000000oooo0?oo
o`050?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`1F0?ooo`00F@3o
ool00`000000oooo0000000K0?ooo`030000003oool0oooo0080oooo00?o00000?ooo`3oool05@3o
ool00ol00000oooo0?ooo`030?ooo`030000003oool0oooo00P0oooo00?o00000?ooo`3oool02`3o
ool2000000@0oooo00<000000?ooo`3oool00P3oool00`000000oooo0000001I0?ooo`00FP3oool0
10000000oooo00000000000J0?ooo`050000003oool0oooo0?ooool000005P3oool00ol00000oooo
0?ooo`040?ooo`030000003oool0oooo00L0oooo00?o00000?ooo`3oool03P3oool01000003o0000
0?ooo`0000050?ooo`030000003oool0000005T0oooo001K0?ooo`040000003ooooo0000000000d0
oooo0_l0000:0?ooo`050000003oool0oooo0?ooool000005@3oool00ol00000oooo0?ooo`040?oo
o`030000003oool0oooo00P0oooo00?o00000?ooo`3oool03`3oool00`00003o0000000000060?oo
o`030000003oool0oooo05P0oooo001L0?ooo`040000003ooooo0000000000h0oooo00?o00000?oo
o`3oool0203oool010000000oooo0?ooool0000L0?ooo`030000003oool0oooo01X0oooo0`000006
0?ooo`030000003oool0oooo05P0oooo001L0?ooo`050000003oool0ooooo`0000000000603oool0
0`000000oooo0?ooo`0B0?ooo`;o00002@3oool00`000000oooo0?ooo`0I0?ooo`050000003oool0
oooo0?ooo`0000000`3oool2000005/0oooo001M0?ooo`050000003oool0oooo0?ooo`0000003`3o
ool00ol00000oooo0?ooo`060?ooo`030000003oool0oooo00l0oooo0_l0000:0?ooo`030000003o
ool0oooo00P0oooo00?o00000?ooo`3oool03P3oool00`000000oooo0?ooo`030?ooo`80000000<0
oooo000000000000F`3oool005h0oooo00@000000?ooo`3oool0oooo0P00000>0?ooo`03o`00003o
ool0oooo00D0oooo00<000000?ooool000006`3oool00`000000oooo0?ooo`080?ooo`03o`00003o
ool0oooo00d0oooo00<000000?ooo`3oool01P3oool3000005/0oooo001O0?ooo`0300000?l00000
oooo0080oooo00<000000?ooo`3oool0303oool00ol00000oooo0?ooo`050?ooo`0300000?l00000
oooo00/0oooo0_l0000=0?ooo`030000003oool0oooo00L0oooo00?o00000?ooo`3oool03@3oool0
0`000000oooo0?ooo`060?ooo`<00000G03oool00600oooo00<00000o`00003oool00P3oool00`00
0000oooo0?ooo`0C0?ooo`0300000?l00000oooo00T0oooo0_l0000>0?ooo`030000003oool0oooo
00P0oooo00?o00000?ooo`3oool0303oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
05`0oooo001P0?ooo`030000003ooooo000000<0oooo00<000000?ooo`3oool03@3oool00ol00000
oooo0?ooo`030?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool05@3oool2000000H0
oooo1000001O0?ooo`00H@3oool00`000000oooo0?ooo`030?ooo`8000003P3oool00ol00000oooo
0?ooo`020?ooo`030000003oool0oooo00D0oooo00?o00000?ooo`3oool0403oool00`000000oooo
0?ooo`0D0?ooo`030000003oool0oooo00@0oooo0P0000000`3oool000000?ooo`1P0?ooo`00HP3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00`0oooo00?o00000?ooo`3oool00P3o
ool00`000000oooo0?ooo`030?ooo`03o`00003oool0oooo0100oooo00<000000?ooo`3oool0203o
ool00ol00000oooo0?ooo`090?ooo`040000003oool0oooo0?ooo`8000000`3oool200000680oooo
001S0?ooo`0300000?l00000oooo00@0oooo00<000000?ooo`3oool0403oool00`000000oooo0?oo
o`020?ooo`03o`00003oool0oooo0140oooo00<000000?ooo`3oool0203oool00ol00000oooo0?oo
o`080?ooo`030000003oool0oooo00800000103oool00`000000oooo0?ooo`1R0?ooo`00I03oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo00d0oooo00Co00000?ooool0000000005P3o
ool00`000000oooo0?ooo`080?ooo`03o`00003oool0oooo00P0oooo0P0000060?ooo`800000I@3o
ool006D0oooo0P0000050?ooo`8000003P3oool2o`00000300000?l00000oooo01@0oooo00<00000
0?ooo`3oool04P3oool2000000H0oooo00<000000?ooo`3oool0I@3oool006L0oooo00@00000o`00
0?l0003o00000`3oool00`00003o0000o`0000030?ooo`Co00000P3oool5o`00000300000?l00000
oooo01<0oooo00<000000?ooo`3oool0403oool3000000D0oooo0P00001X0?ooo`00J03oool20000
00D0oooo00<000000?ooo`3oool02`3oool00ol00000oooo000000030?ooo`Co00003@3oool00`00
0000oooo0?ooo`0?0?ooo`8000001`3oool00`000000oooo0?ooo`1X0?ooo`00JP3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo00/0oooo00?o00000?ooo`000000203oool4o`000080
oooo0ol000020?ooo`030000003oool0oooo00P0oooo00?o00000?ooo`3oool00P3oool3000000H0
oooo0P00001[0?ooo`00J`3oool2000000@0oooo0P00000=0?ooo`030000003oool0oooo00l0oooo
00?o00000?ooo`0000000ol000070?ooo`03o`0000000000000000<0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`1[0?ooo`00K@3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`020?ooo`03o`00003o
ool0oooo00?o00000P0000040?ooo`030000003oool0oooo00<0oooo0P00001^0?ooo`00KP3oool2
000000@0oooo00<000000?ooo`3oool02@3oool00ol00000oooo0000000@0?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo06h0oooo001`0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0203oool00ol0
0000oooo0000000@0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool00P3oool20000
00@0oooo0P00001a0?ooo`00L@3oool2000000<0oooo00<000000?ooo`3oool0203oool00ol00000
oooo0000000>0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`1a0?ooo`00L`3oool010000000oooo0?ooo`3oool2000000P0oooo00?o00000?ooo`00
00003P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0080oooo0P00001d0?ooo`00
M03oool2000000<0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00D0oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo07@0
oooo001f0?ooo`050000003oool0oooo0?ooo`0000002@3oool00`000000oooo0?ooo`0:0?ooo`03
0000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo
07D0oooo001g0?ooo`8000000P3oool00`000000oooo0?ooo`050?ooo`03o`00003oool0000000/0
oooo00<000000?ooo`3oool0103oool01@000000oooo0?ooo`3oool0000000<0oooo0P00001h0?oo
o`00N@3oool00`000000oooo0?ooo`02000000H0oooo00?o00000000003oool02P3oool00`000000
oooo0?ooo`070?ooo`050000003oool0oooo0?ooo`000000NP3oool007X0oooo0P0000020?ooo`03
0000003oool0oooo00@0oooo00?o00000000003oool0203oool00`000000oooo0?ooo`060?ooo`80
00000P3oool2000007/0oooo001l0?ooo`040000003oool0oooo000000H0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`030?ooo`030000003oool0000000<0oooo00<000000?ooo`3o
ool0N`3oool007d0oooo0P0000000`3oool000000?ooo`050?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool00P3oool00`000000oooo000000020?ooo`800000OP3oool007l0oooo00@0
00000?ooo`0000000000103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0080oooo
00<000000?ooo`0000000P3oool00`000000oooo0?ooo`1n0?ooo`00P03oool2000000030?ooo`00
0000oooo0080oooo00?o00000000003oool01@3oool00`000000oooo0?ooo`030?ooo`040000003o
ool0000000000840oooo00220?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool0103o
ool020000000oooo0?ooo`000000oooo0000003oool00000P`3oool008<0oooo0`0000030?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool01@0000240?ooo`00Q@3oool200000080oooo
00<000000?ooo`3oool00P3oool01P000000oooo000000000000oooo000008H0oooo00260?ooo`<0
000000<0oooo0000003oool00P3oool00`000000oooo00000002000008L0oooo00280?ooo`<00000
0P3oool010000000oooo0000000000290?ooo`00R@3oool3000000040?ooo`0000000000000008X0
oooo002;0?ooo`030000003oool0000008`0oooo002<0?ooo`030000003oool0oooo08/0oooo003o
0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o
0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o
0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o
0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o
0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o
0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o
0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o
0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o
0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o
0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o
0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o
0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o
0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o
0?oooa/0oooo003o0?oooa/0oooo0000\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-5.00005*^-6, -5.00005*^-6, \
0.00355875, 0.00355875}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.0025 w
[ .01 .012 ] 0 setdash
.47621 .45416 m
.63473 .56796 L
s
.47621 .45416 m
.47119 .57044 L
s
.58185 .41311 m
.47621 .45416 L
s
.31094 .5517 m
.47621 .45416 L
s
.5 .27523 m
.47621 .45416 L
s
.38662 .40027 m
.47621 .45416 L
s
.47119 .57044 m
.63473 .56796 L
s
.31094 .5517 m
.47119 .57044 L
s
.4747 .67248 m
.47119 .57044 L
s
.58185 .41311 m
.63473 .56796 L
s
.67184 .39558 m
.63473 .56796 L
s
.71242 .51198 m
.63473 .56796 L
s
.68388 .63248 m
.63473 .56796 L
s
.58835 .68293 m
.63473 .56796 L
s
.4747 .67248 m
.63473 .56796 L
s
.67184 .39558 m
.58185 .41311 L
s
.5 .27523 m
.58185 .41311 L
s
.38662 .40027 m
.31094 .5517 L
s
.38662 .40027 m
.5 .27523 L
s
.32197 .37174 m
.38662 .40027 L
s
.32197 .37174 m
.31094 .5517 L
s
.27803 .48748 m
.31094 .5517 L
s
.30901 .61606 m
.31094 .5517 L
s
.37742 .67486 m
.31094 .5517 L
s
.4747 .67248 m
.31094 .5517 L
s
.4747 .67248 m
.37742 .67486 L
s
.4747 .67248 m
.5 .75807 L
s
.4747 .67248 m
.58835 .68293 L
s
.5 .27523 m
.67184 .39558 L
s
.32197 .37174 m
.5 .27523 L
s
.0035 w
[ ] 0 setdash
.62758 .31802 m
.5 .27523 L
s
.53006 .29504 m
.5 .27523 L
s
.40391 .30106 m
.5 .27523 L
s
.0025 w
[ .01 .012 ] 0 setdash
.71242 .51198 m
.67184 .39558 L
s
.73211 .43653 m
.67184 .39558 L
s
.62758 .31802 m
.67184 .39558 L
s
.58835 .68293 m
.5 .75807 L
s
.58835 .68293 m
.68388 .63248 L
s
.73211 .43653 m
.71242 .51198 L
s
.68388 .63248 m
.71242 .51198 L
s
.0035 w
[ ] 0 setdash
.37742 .67486 m
.30901 .61606 L
s
.5 .75807 m
.37742 .67486 L
s
.27803 .48748 m
.32197 .37174 L
s
.40391 .30106 m
.32197 .37174 L
s
.32183 .41013 m
.32197 .37174 L
s
.68388 .63248 m
.73211 .43653 L
s
.68388 .63248 m
.63934 .62256 L
s
.68388 .63248 m
.5 .75807 L
s
.62758 .31802 m
.73211 .43653 L
s
.53006 .29504 m
.62758 .31802 L
s
.32183 .41013 m
.27803 .48748 L
s
.30901 .61606 m
.27803 .48748 L
s
.40391 .30106 m
.53006 .29504 L
s
.32183 .41013 m
.40391 .30106 L
s
.30901 .61606 m
.32183 .41013 L
s
.30901 .61606 m
.39483 .61165 L
s
.5 .75807 m
.30901 .61606 L
s
.5 .75807 m
.39483 .61165 L
s
.5 .75807 m
.53252 .56266 L
s
.5 .75807 m
.63934 .62256 L
s
.53006 .29504 m
.73211 .43653 L
s
.53855 .40574 m
.53006 .29504 L
s
.32183 .41013 m
.53006 .29504 L
s
.53855 .40574 m
.73211 .43653 L
s
.53252 .56266 m
.73211 .43653 L
s
.63934 .62256 m
.73211 .43653 L
s
.63934 .62256 m
.53252 .56266 L
s
.39483 .61165 m
.32183 .41013 L
s
.53252 .56266 m
.39483 .61165 L
s
.32183 .41013 m
.53855 .40574 L
s
.53252 .56266 m
.32183 .41013 L
s
.53252 .56266 m
.53855 .40574 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.1,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016R000`400?l00000o`00003ooooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00R_ooool5o`0008_ooooo0026ooooo`Co000000Co
ooooo`000?l0003ooooo1?l00028ooooo`00P_ooool4o`000006ooooool0003o0000ooooool0003o
oooo0_l000001?oooooo0000o`000?ooool3o`0008Gooooo001nooooo`Co00000oooool2o`0000;o
oooo00Co0000oooooooooooo00001?ooool2o`0000;ooooo0ol00022ooooo`00Noooool3o`0001Co
oooo0_l00004ooooo`?o0000Ooooool007Oooooo1?l00006ooooo`;o00001?ooool01?l0003ooooo
ooooooooool<o`0000Cooooo0ol0001looooo`00Loooool4o`0000?ooooo4_l00003ooooo`07o`00
0?oooooo0000o`000?oooooo0000ooooo`05o`0000?ooooo0ol0001iooooo`00L?ooool:o`0000co
oooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`02ooooo`06o`000?oooooooooooooo
ool0003ooooo0ol00002ooooo`Co00000_ooool3o`0007Kooooo001_ooooo`03o`000?oooooo0000
00[ooooo0_l00007ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_l000001Ooo
oooo0000oooooooooooo000000;ooooo00?o0000ooooool000001Oooool4o`000004ooooool0003o
0000o`0007?ooooo001^ooooo`03o`000?oooooo000000[ooooo00?o0000ooooooooool03Oooool3
o`0000Kooooo00Oo0000ooooooooooooooooo`000?oooooo000000Sooooo1ol0001`ooooo`00KOoo
ool00ol0003oooooo`00000Cooooo`03o`000?oooooooooo00Cooooo0_l00008ooooo`03o`000?oo
oooooooo00Cooooo0_l0000:ooooo`Ko0000KOooool006cooooo00?o0000ooooool000002?ooool2
o`0000Wooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`06ooooo`04o`000?oooooo
ooooo`0000Gooooo0ol0000=ooooo`Go0000J_ooool006_ooooo00Co0000oooooooooooo00001_oo
ool2o`0000[ooooo00?o0000ooooooooool00oooool2o`000003ooooool0003ooooo00Oooooo00?o
0000ooooool000001oooool3o`0000oooooo0_l0001Yooooo`00J_ooool01?l0003oooooooooool0
000Gooooo`;o00000oooool00ol0003oooooooooo`07ooooo`;o00002_ooool00ol0003ooooooooo
o`0=ooooo`03o`000?oooooooooo06Oooooo001Xooooo`;o00000_ooool00ol0003oooooooooo`02
ooooo`;o00004?ooool2o`0000Gooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08
ooooo`?o00003_ooool00ol0003oooooooooo`1Vooooo`00Ioooool01Ol0003ooooooooooooooooo
000000Cooooo00?o0000ooooooooool03?ooool01?l0003oooooooooool00007ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool02_ooool2o`0000kooooo00?o0000ooooooooool0IOoo
ool006Kooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0@ooooo`04o`000?oooooo
0000o`0001?ooooo00?o0000ooooooooool02oooool2o`0000kooooo00?o0000ooooooooool0I?oo
ool006Gooooo00?o0000ooooooooool00_ooool01?l0003oooooo`000?l0000?ooooo`?o00005Ooo
ool2o`0000kooooo0_l0000<ooooo`0300000?l0003ooooo06Cooooo001Tooooo`03o`000?oooooo
oooo00;ooooo0ol0000@ooooo`;o00003?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
000000gooooo0ol0000;ooooo`0300000?oooooo000006Cooooo001Sooooo`03o`000?oooooooooo
00;ooooo00?o0000ooooooooool03oooool2o`0000kooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`0@ooooo`;o00002_ooool00`00003oooooo`00001Sooooo`00HOooool2o`0000?o
oooo0ol0000@ooooo`;o00003_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo01;o
oooo00?o0000ooooooooool01oooool01000003oooooooooool0001Rooooo`00H?ooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooo000000oooooo0ol0000?ooooo`03o`000?oooooooooo00Wo
oooo00Go0000ooooooooooooooooo`00000@ooooo`?o00002_ooool00ol0003oooooooooo`1Poooo
o`00Goooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00cooooo0_l0000Oooooo`04
o`000?ooooooooooo`0001;ooooo0_l0000:ooooo`03o`000?oooooooooo05oooooo001Nooooo`03
o`000?oooooooooo00;o00000_ooool00ol0003oooooooooo`0;ooooo`;o00008Oooool01Ol0003o
oooooooooooooooo000001;ooooo0_l00007ooooo`0400000?ooooooooooo`00063ooooo001Moooo
o`04o`000?oooooo0000o`0000Cooooo00?o0000ooooooooool02_ooool01Ol0003ooooooooooooo
oooo000001;ooooo00?o0000ooooooooool02_ooool01Ol0003ooooooooooooooooo000001Cooooo
0_l00005ooooo`0500000?ooooooooooooooool00000Goooool005cooooo00?o0000ooooooooool0
1Oooool00ol0003oooooooooo`09ooooo`;o00000oooool00ol0003oooooooooo`0Aooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool05_ooool3o`0000Gooooo00D00000oooooooooooo
ooooo`00001Nooooo`00Foooool2o`0000Kooooo00?o0000ooooooooool02?ooool2o`0000Cooooo
00?o0000ooooooooool04Oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00?ooooo
00?o0000ooooooooool04oooool2o`0000Sooooo00?o0000ooooooooool0Foooool005[ooooo0ol0
0006ooooo`03o`000?oooooooooo00Kooooo0_l0000Jooooo`03o`000?oooooooooo00_ooooo00?o
0000ooooooooool00oooool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo00Kooooo00?o
0000ooooooooool0F_ooool005[ooooo00Co0000oooooooooooo00001?ooool00ol0003ooooooooo
o`06ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool08Oooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo01Gooooo00Go0000oooooooooooooooo00000004ooooo`03o`00
0?oooooooooo05Wooooo001Iooooo`;o00001Oooool2o`0000Oooooo0_l00006ooooo`03o`000?oo
oooooooo02;ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Fooooo`;o000000?o
oooo00000?ooool01?ooool00ol0003oooooooooo`1Hooooo`00FOooool2o`0000Gooooo0_l00005
ooooo`;o00001oooool00ol0003oooooooooo`0Sooooo`03o`000?oooooooooo01kooooo0_l00000
0oooool00000ooooo`03ooooo`03o`000?oooooooooo05Sooooo001Iooooo`;o00001Oooool00ol0
003oooooo`000002ooooo`;o00008Oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo
023ooooo0_l00005ooooo`03o`000?oooooooooo05Oooooo001Hooooo`03o`000?oooooo000000Co
oooo00?o0000ooooooooool00_ooool4o`00023ooooo00?o0000ooooooooool02oooool00ol0003o
ooooooooo`06ooooo`03o`000?oooooooooo01Sooooo0_l00005ooooo`03o`000?oooooooooo05Ko
oooo001Hooooo`03o`000?oooooo000000?ooooo00Co0000oooooooooooooooo0_l00004ooooo`03
o`000?oooooooooo00?ooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0<ooooo`03
o`000?oooooooooo00Gooooo00?o0000ooooooooool06_ooool2o`0000Cooooo00?o0000oooooooo
ool0EOooool005Sooooo00?o0000ooooool000000_ooool00ol0003oooooooooo`02o`0000Wooooo
00?o0000ooooool00000:Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo01Kooooo
1?l000000`00003o0000ooooo`03ooooo`03o`000?oooooooooo05Cooooo001Gooooo`04o`000?oo
oooo0000o`0000;ooooo0ol0000<ooooo`?o0000:?ooool00ol0003oooooooooo`0Iooooo`Co0000
1Oooool01?l00000000000000?l00004ooooo`03o`000?oooooooooo05?ooooo001Gooooo`05o`00
0?oooooo0000o`000?ooool00_l0000>ooooo`04o`000?ooooooooooo`0002Oooooo00?o0000oooo
ooooool05Oooool2o`0000_ooooo00Co000000000?oooooooooo0_l00003ooooo`03o`000?oooooo
oooo05;ooooo001Fooooo`04o`000?ooooooooooooooo`?o00003_ooool00ol0003oooooooooo`0;
ooooob;o00001oooool00ol0003oooooooooo`04ooooo`;o00000_ooool2o`0000kooooo00H00000
oooooooooooooooo00000?l00003ooooo`03o`000?oooooooooo057ooooo001Fooooo`04o`000?oo
oooooooooooooaoo00003_ooool00ol0003oooooooooo`0=ooooo`04o`000?ooooooooooooooo`So
000000Coooooo`000?oooooooooo0_l0000Jooooo`;o000000?oooooo`000?ooool0D_ooool005Ko
oooo00?o0000ooooooooool00_l000000ooooooo0000ooooo`0Eooooo`03o`000?oooooooooo017o
oooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`08ooooo`Oo00007?ooool00ol0003o
ooooo`00001Booooo`00EOooool01?l0003oooooooooooooool3o`000003ooooool0003ooooo01Go
oooo00?o0000ooooooooool08?ooool00ol0003oooooooooo`06ooooo`;o000000?oooooo`000?oo
ool01?ooool7o`0000_ooooo00Go0000oooooooooooooooo00000006ooooo`?o0000DOooool005Go
oooo00Co0000oooooooooooooooo0ol00002ooooo`;o00002Oooool00ol0003oooooooooo`0;oooo
o`03o`000?oooooooooo01gooooo00?o0000ooooooooool00_ooool2o`0000Kooooo00?o0000oooo
ooooool02Oooool6o`0000Gooooo00Go0000oooooooooooooooo00000007ooooo`0300000?l0003o
0000053ooooo001Eooooo`03o`000?oooooooooo00Co00001?ooool00ol0003oooooooooo`06oooo
o`03o`000?oooooooooo00cooooo00?o0000ooooooooool07?ooool01Ol0003ooooooooooooooooo
000001[ooooo1ol00003ooooo`0300000?oooooooooo00Gooooo00<00000o`000?l00000Coooool0
05Cooooo00Co0000oooooooooooo00000_ooool00ol0003oooooo`000004ooooo`;o00001Oooool0
0ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool03Oooool2
o`0002Gooooo1ol00006ooooo`;o0000C_ooool005Cooooo00Co0000oooooooooooo00000_ooool0
0ol0003oooooo`000006ooooo`03o`000?oooooooooo023ooooo00?o0000ooooooooool03?ooool0
0ol0003oooooo`00000=ooooo`03o`000?oooooooooo01cooooo1ol000000`00003o0000ooooo`1<
ooooo`00Doooool01?l0003oooooooooool00003ooooo`03o`000?oooooo000000Oooooo00?o0000
ooooooooool05Oooool2o`0000Sooooo00?o0000ooooooooool02?ooool2o`0000Cooooo00?o0000
ooooooooool02oooool00ol0003oooooooooo`0Sooooo`?o0000C?ooool005?ooooo00Co0000oooo
oooooooo00000_ooool01Ol0003ooooooooooooooooo000000Oooooo0ol0000Fooooo`03o`000?oo
oooooooo00Gooooo00?o0000ooooooooool01_ooool2o`0000Kooooo00?o0000ooooooooool03?oo
ool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00Cooooo00<00000ooooooooool01ooo
ool00ol0003oooooo`00001<ooooo`00Doooool00ol0003oooooo`000003ooooo`05o`000?oooooo
ooooooooool000002Oooool00ol0003oooooooooo`0]ooooo`03o`000?oooooooooo00cooooo00?o
0000ooooooooool04Oooool00ol0003oooooooooo`04ooooo`0300000?oooooooooo00Gooooo0_l0
00000ooooooo0000o`00001<ooooo`00D_ooool01?l0003oooooooooool00003ooooo`05o`000?oo
ooooooooooooool000002?ooool00ol0003oooooo`00000Hooooo`?o00001oooool2o`0000[ooooo
00?o0000ooooooooool07oooool00ol0003oooooooooo`06ooooo`0300000?oooooooooo00?ooooo
00Go0000ooooooooooooooooo`00001=ooooo`00D_ooool00ol0003oooooo`000004ooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool01?ooool01?l0003oooooooooooooool2o`0001Wo
oooo0_l00003ooooo`;o00002oooool00ol0003oooooooooo`0Pooooo`03o`000?oooooooooo00Ko
oooo00@00000oooooooooooooooo0_l00003ooooo`;o0000COooool005;ooooo0_l00005ooooo`03
o`000?oooooooooo00;ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0Gooooo`;o
00003oooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo01[ooooo0_l00005ooooo`;o
0000COooool0057ooooo00?o0000ooooool000001Oooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo00_ooooo0_l0000Eooooo`?o000000?oooooo`000?ooool03Oooool00ol0003ooooo
ooooo`0>ooooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool01?ooool00ol0003ooooo
o`00001=ooooo`00DOooool2o`0000Gooooo0_l00005ooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooooooool01oooool00ol0003oooooooooo`0@ooooo`;o00000_ooool01?l0003ooooooooo
ool0000=ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool03Oooool00ol0003ooooo
ooooo`06ooooo`;o000000<00000ooooooooool01?ooool2o`00000300000?oooooooooo04_ooooo
001@ooooo`03o`000?oooooo000000Gooooo0_l00005ooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooooooool02?ooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00kooooo00?o
0000ooooooooool03oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00Gooooo00Co
0000ooooooooool000001Oooool00ol0003oooooo`00001>ooooo`00D?ooool2o`0000Kooooo0_l0
0006ooooo`04o`000?ooooooooooo`0000cooooo0_l0000<ooooo`;o00002_ooool3o`0000Wooooo
00?o0000ooooooooool07oooool00ol0003oooooooooo`03ooooo`;o00001?ooool00`00003ooooo
ooooo`02ooooo`03o`000?oooooo000004kooooo001@ooooo`;o00001oooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`0=ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool07oooool00ol0003ooooooooo
o`02ooooo`03o`000?oooooooooo00Cooooo00D00000ooooooooooooooooo`000002ooooo`03o`00
0?oooooooooo04cooooo001?ooooo`;o00002?ooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo013ooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`06ooooo`03o`000?oo
oooooooo00kooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0?ooooo`;o00002ooo
ool01?l0003oooooooooool0001>ooooo`00Coooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00Gooooo00?o0000ooooooooool04?ooool2o`0000?ooooo00?o0000ooooooooool02Ooo
ool00ol0003oooooooooo`07ooooo`;o00001Oooool00ol0003oooooooooo`0@ooooo`03o`000?oo
oooooooo00kooooo00?o0000ooooooooool02_ooool01?l0003oooooooooool0001?ooooo`00Cooo
ool00ol0003oooooooooo`06ooooo`;o00001oooool00ol0003oooooooooo`0Booooo`03o`000?oo
oooo000000cooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo017ooooo00?o0000ooooooooool02_ooool3o`0000_ooooo00<00000ooooool000000_oo
ool00ol0003oooooooooo`1=ooooo`00C_ooool00ol0003oooooooooo`07ooooo`;o00001_ooool2
o`0001Gooooo0_l0000<ooooo`03o`000?oooooooooo00[ooooo00Go0000ooooooooooooooooo`00
000Cooooo`03o`000?oooooooooo00Wooooo0_l0000=ooooo`0600000?l0003oooooooooo`00003o
0000Coooool004kooooo00?o0000ooooooooool01oooool2o`0000Kooooo00?o0000ooooool00000
4?ooool2o`0000Cooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`0Looooo`;o0000
3oooool01Ol0003oooooooooo`00003o000004oooooo001>ooooo`;o00002?ooool00ol0003ooooo
ooooo`07ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool01Oooool00ol0003ooooo
ooooo`0Gooooo`?o00007?ooool2o`000003ooooool0003ooooo00gooooo00Go000000000?oooooo
ooooo`00001@ooooo`00Coooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Oooooo
00?o0000ooooooooool03?ooool00ol0003oooooooooo`07ooooo`;o00002?ooool00ol0003ooooo
ooooo`0>ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`0@ooooo`05o`000?ooooooooooooooool00000D?ooool004oooooo00?o0000ooooooooool0
1_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
5oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00kooooo0_l0000Cooooo`03o`00
0?oooooooooo00;ooooo0_l0000Booooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
C_ooool004oooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooooooool02?ooool2o`0000kooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo01?ooooo00Co0000oooooooooooo0000
1_ooool00ol0003oooooooooo`0;ooooo`06o`000?oooooooooo00000?oooooo0000D?ooool004oo
oooo0_l00007ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`06ooooo`;o00004Oooool2o`0000Cooooo00?o0000ooooooooool03_ooool00ol0003o
ooooooooo`03o`00013ooooo0ol00007ooooo`03o`000?oooooooooo00[ooooo00Ko0000oooooooo
oooooooo00000?l0001Aooooo`00Coooool2o`0000Oooooo00?o0000ooooooooool02Oooool00ol0
003oooooooooo`0Jooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool00oooool00ol0
003oooooooooo`0=ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool02oooool01?l0
003oooooooooooooool2o`00057ooooo001@ooooo`;o00001_ooool00ol0003oooooooooo`09oooo
o`04o`000?ooooooooooooooo`;o00006?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooo
oooo017ooooo0_l00009ooooo`03o`000?oooooooooo00[ooooo00Oo0000ooooooooooooooooo`00
0000003o0000057ooooo001@ooooo`03o`000?oooooo000000Gooooo00Go0000oooooooooooooooo
o`000008ooooo`03o`000?oooooo000001_ooooo0_l0000Aooooo`03o`000?oooooooooo00Gooooo
0_l00008ooooo`;o00000oooool00ol0003oooooooooo`0Booooo`07o`000?ooooooooooo`000?oo
ool00000o`00001Aooooo`00D?ooool00ol0003oooooooooo`05ooooo`05o`000?oooooooooooooo
ool000002?ooool00ol0003oooooooooo`0Looooo`;o00004?ooool00ol0003oooooooooo`07oooo
o`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Aoooo
o`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0D?ooool0053ooooo00?o0000oooooooo
ool01?ooool2o`0000;ooooo00?o0000ooooooooool01Oooool3o`0001kooooo00Co0000ooooool0
003o00003_ooool00ol0003oooooooooo`08ooooo`04o`000?ooooooooooooooo`;o00001oooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo00[ooooo0ol00003ooooo`03o`000?oooooo
oooo053ooooo001@ooooo`04o`000?ooooooooooo`0000?ooooo0_l000000ooooooo0000ooooo`06
ooooo`05o`000?ooooooooooooooool000007Oooool01Ol0003ooooooooooooooooo000000cooooo
00?o0000ooooooooool03?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00?ooooo
00?o0000ooooooooool02Oooool2o`0000Gooooo00?o0000ooooooooool0D?ooool0057ooooo00Co
0000oooooooooooo00000_ooool2o`0000gooooo00?o0000ooooooooool08?ooool00ol0003ooooo
ooooo`09ooooo`03o`000?oooooooooo00[ooooo1?l0000>ooooo`03o`000?oooooooooo00Wooooo
00?o0000ooooooooool01?ooool00ol0003oooooooooo`1@ooooo`00DOooool01_l0003ooooooooo
oooooooo0000ooooo`;o00001Oooool2o`0000Kooooo00?o0000ooooooooool08Oooool2o`0000Wo
oooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00_o
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo057o
oooo001Aooooo`03o`000?oooooooooo00Cooooo0_l00002ooooo`;o00002Oooool00ol0003ooooo
ooooo`0Rooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool01oooool2o`0000kooooo
00?o0000ooooooooool02oooool3o`0000Kooooo00?o0000ooooooooool0DOooool0057ooooo00?o
0000ooooooooool00oooool00ol0003oooooo`00000=ooooo`03o`000?oooooooooo01[ooooo00?o
0000ooooooooool01_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Kooooo00?o
0000ooooooooool01oooool2o`0000Gooooo00?o0000ooooooooool02Oooool2o`000003ooooool0
003ooooo00Gooooo00<00000o`000?ooool0D_ooool005;ooooo00Co0000oooooooooooooooo1?l0
000=ooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool01oooool2o`0000Gooooo00?o
0000ooooooooool01?ooool2o`0000cooooo00?o0000ooooooooool00oooool01?l0003ooooooooo
ool0000:ooooo`03o`000?oooooooooo00Cooooo00<00000o`000?ooool0D_ooool005;ooooo00Co
0000oooooooooooooooo0ol0000?ooooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool0
2Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo0_l0000?ooooo`03o`00
0?oooooooooo00Gooooo00?o0000ooooooooool00_ooool2o`0000?ooooo00?o0000ooooooooool0
1_ooool00ol0003oooooooooo`1Aooooo`00D_ooool00ol0003oooooooooo`02ooooo`Co00000_oo
ool3o`0000Sooooo00?o0000ooooooooool06Oooool00ol0003oooooooooo`0:ooooo`;o00000_oo
ool01Ol0003ooooooooooooooooo000001Wooooo00Go0000ooooooooooooooooo`000005ooooo`03
o`000?oooooooooo00Gooooo00?o0000ooooooooool0D_ooool005;ooooo00?o0000ooooooooool0
0_ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Co000000?oooooo`000?ooool0
:Oooool01?l0003oooooo`000?ooool2o`0001Cooooo0_l00004ooooo`04o`000?ooooooooooo`00
00Gooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`1Booooo`00D_ooool00ol0003o
ooooooooo`02ooooo`;o00000_ooool00ol0003oooooooooo`0;ooooo`Co00000_ooool3o`0002;o
oooo0ol0000Hooooo`03o`000?oooooo000000[ooooo00?o0000ooooooooool01_ooool00ol0003o
ooooooooo`1Booooo`00Doooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`06ooooo`04o`000?ooooooooooooooo`?o00002oooool00ol0
003oooooooooo`0=ooooo`?o00006Oooool2o`000003ooooool0003o000000Kooooo00?o0000oooo
ooooool01_ooool00`00003o0000ooooo`1Cooooo`00Doooool01Ol0003ooooooooooooooooo0000
00;ooooo00Co0000oooooooooooo00003?ooool00ol0003oooooooooo`0?ooooo`Co00001?ooool0
0ol0003oooooooooo`0:ooooo`?o000000?oooooo`000?ooool00ol00003ooooo`?o00000oooool4
o`0000;ooooo1?l00002ooooo`Co00002?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooo
oooo05?ooooo001Cooooo`05o`000?ooooooooooooooool000000_ooool00ol0003oooooooooo`0=
ooooo`03o`000?oooooooooo01Gooooo1_l00002ooooo`[o000000Goooooo`000?l0003o0000oooo
o`02o`0001Gooooo0_l000000ooooooo0000ooooo`05ooooo`03o`000?oooooooooo00Oooooo00?o
0000ooooooooool0Doooool005?ooooo00Go0000ooooooooooooooooo`000003ooooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Gooooo`03o`000?oo
oooooooo00Cooooo0ol00007ooooo`03o`000?oooooooooo00?ooooo0_l0000Aooooo`;o000000Co
ooooo`000?oooooo00001_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo05?ooooo
001Dooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool00oooool00ol0003ooooo
ooooo`07ooooo`03o`000?oooooooooo01Kooooo00Co0000oooooooooooooooo0ol00009ooooo`03
o`000?oooooooooo00Kooooo00?o0000ooooooooool04?ooool01Ol0003ooooooooooooooooo0000
00Cooooo00?o0000ooooooooool01oooool00`00003o0000ooooo`1Dooooo`00E?ooool01?l0003o
ooooooooool0000:ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool05_ooool4o`00
00cooooo00?o0000ooooooooool01oooool2o`0000_ooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`06ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0E?ooool005Co
oooo00Co0000oooooooooooo00004oooool00ol0003oooooooooo`0Dooooo`?o00003oooool00ol0
003oooooooooo`09ooooo`;o00002?ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo
00Oooooo00<00000o`000?ooool0EOooool005Cooooo00Co0000oooooooooooo00001?ooool00ol0
003oooooooooo`06ooooo`;o00001Oooool00ol0003oooooooooo`0@ooooo`?o00004_ooool00ol0
003oooooooooo`0;ooooo`;o00001Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo0000
00Wooooo00<00000o`000?ooool0EOooool005Cooooo00Co0000oooooooooooo00001Oooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool03Oooool3o`00
01Gooooo00?o0000ooooooooool03Oooool2o`0000Wooooo00?o0000ooooooooool01Oooool00ol0
003oooooooooo`09ooooo`03o`000?oooooooooo05Cooooo001Eooooo`;o00001oooool00ol0003o
ooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo0ol00008ooooo`03o`000?oooooooooo00go
oooo00?o0000ooooooooool03_ooool3o`0000Oooooo00?o0000ooooooooool01Oooool2o`0000Wo
oooo00?o0000ooooooooool0EOooool005Gooooo0_l0000Cooooo`04o`000?ooooooooooo`0000So
oooo0ol0000;ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool03_ooool01?l0003o
ooooooooooooool2o`0000Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`09oooo
o`03o`000?oooooooooo05Gooooo001Eooooo`;o00005?ooool00ol0003oooooo`000005ooooo`?o
00003_ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo01Cooooo0_l0000:ooooo`03
o`000?oooooooooo00Wooooo00?o0000ooooooooool0EOooool005Gooooo0_l00008ooooo`03o`00
0?oooooooooo00[ooooo0_l00002ooooo`?o00004Oooool00ol0003oooooooooo`0<ooooo`03o`00
0?oooooooooo00_ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`06ooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`1Eooooo`00EOoo
ool2o`0000Sooooo00?o0000ooooooooool01_ooool8o`0002?ooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`0:ooooo`;o00001_ooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo00?ooooo00<00000o`000?ooool0E_ooool005Kooooo00?o0000ooooooooool00oooool<
o`0000Kooooo0_l0000Sooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02oooool0
1?l0003oooooo`000?l00003ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`1Fooooo`00E_ooool6o`0000Gooooo00?o0000ooooooooool02oooool2
o`0001?ooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooo
oooo00kooooo00Co0000oooooooooooooooo0_l000000ooooooo0000ooooo`0;ooooo`03o`000?oo
oooooooo05Kooooo001Hooooo`03o`000?oooooooooo01Gooooo0_l0000Booooo`03o`000?oooooo
oooo00_ooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooo
oooo00Cooooo0ol0000;ooooo`03o`000?oooooooooo05Kooooo001Iooooo`03o`000?oooooooooo
01Gooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool05Oooool01?l0003oooooooooooooool5o`0000?ooooo00Co0000
ooooo`00003o0000F?ooool005[ooooo0_l00006ooooo`03o`000?oooooooooo00cooooo00?o0000
ooooooooool00_l0000>ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool07?ooool0
0ol0003oooooooooo`07ooooo`Ko0000FOooool005_ooooo0_l00006ooooo`03o`000?oooooooooo
00cooooo00Go0000ooooooooooooooooo`00000Kooooo`04o`000?ooooooooooooooo`;o00004_oo
ool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00cooooo0_l0001Iooooo`00GOooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool07?ooool0
1?l0003oooooo`000?l0000Dooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool03?oo
ool00ol0003oooooooooo`1Iooooo`00G_ooool2o`0001?ooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`0Fooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`0;ooooo`;o0000G?ooool005oooooo0_l0000Cooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09ooooo`;o00005_ooool01Ol0
003ooooooooooooooooo000000gooooo00?o0000ooooooooool0G?ooool0063ooooo0_l00003oooo
o`03o`000?oooooooooo00gooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`07oooo
o`03o`000?oooooooooo00Sooooo0_l0000Jooooo`03o`000?oooooooooo00Sooooo0P000002o`00
05oooooo001Rooooo`;o000000?oooooo`000?ooool03oooool00ol0003oooooooooo`0<ooooo`03
o`000?oooooooooo00Oooooo00?o0000ooooool000006Oooool00ol0003oooooooooo`08ooooo`03
00000?oooooo0000067ooooo001Sooooo`;o000000?oooooo`000?ooool03_ooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool05?ooool00ol0003ooooo
o`00000:ooooo`0300000?oooooo000006;ooooo001Tooooo`Co00003oooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo00Wooooo0_l00004ooooo`03o`000?oooooooooo01Cooooo0_l0
0008ooooo`0300000?oooooooooo00;o0000Hoooool006Gooooo0ol0000@ooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`04ooooo`03o`000?oooooo
oooo01?ooooo0_l00008ooooo`0400000?ooooooooooo`0006Gooooo001Wooooo`;o00003oooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool05?ooool0
0ol0003oooooooooo`06ooooo`0400000?oooooo0000o`0006Kooooo001Xooooo`?o00003_ooool0
0ol0003oooooooooo`07ooooo`Go00002?ooool00ol0003oooooooooo`0Cooooo`03o`000?oooooo
oooo00?ooooo0P000003ooooo`03o`000?oooooooooo06Kooooo001Yooooo`03o`000?oooooo0000
00kooooo00?o0000ooooooooool01oooool4o`0000Sooooo00?o0000ooooooooool04_ooool00ol0
003oooooooooo`03ooooo`0400000?ooooooooooooooo`;o0000JOooool006[ooooo0ol00003oooo
o`?o00000oooool4o`000003ooooool0003o000000?o00000_ooool2o`000005ooooool0003ooooo
ooooool000000_ooool4o`000003ooooool0003ooooo01;ooooo00?o0000ooooool000000oooool0
1@00003ooooooooooooooooo000006_ooooo001/ooooo`?o00003?ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00Oooooo1Ol00002ooooo`Co00002?ooool00ol0003oooooooooo`02
000000Cooooo0_l0001/ooooo`00KOooool3o`0000cooooo00?o0000ooooooooool01oooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00_ooooo0ol000001Ooooooo0000ooooool00000
000000Gooooo00?o0000ooooooooool0K?ooool006oooooo0_l0000<ooooo`03o`000?oooooooooo
013ooooo00?o0000ooooooooool03_ooool01?l0003oooooooooo`000005ooooo`03o`000?oooooo
oooo06gooooo001`ooooo`?o00002_ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo
00kooooo00Co0000ooooooooool000001?ooool2o`00073ooooo001aooooo`?o00002_ooool00ol0
003oooooooooo`06ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool03Oooool00ol0
003oooooooooo`05ooooo`03o`000?oooooooooo073ooooo001cooooo`;o00002_ooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool03?ooool00ol0003o
oooo00000004ooooo`;o0000Loooool007Cooooo0ol00009ooooo`03o`000?oooooooooo00Cooooo
00?o0000ooooooooool01Oooool00ol0003oooooooooo`0;ooooo`03o`000?ooool0000000Cooooo
00?o0000ooooooooool0Loooool007Kooooo0_l00008ooooo`03o`000?oooooooooo00Cooooo00?o
0000ooooooooool01Oooool00ol0003oooooooooo`0:ooooo`03o`000?ooool0000000?ooooo0_l0
001fooooo`00Moooool2o`0000Sooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`09
ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0M_ooool007Sooooo0ol00007oooo
o`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02Oooool00ol000000000ooooo`02oooo
o`;o0000NOooool007[ooooo0_l00006ooooo`03o`000?oooooooooo00?ooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`08ooooo`03o`000000003ooooo00;ooooo00?o0000oooooooo
ool0NOooool007_ooooo0_l00006ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`07ooooo`03o`000000003ooooo00;ooooo00?o0000ooooooooool0
N_ooool007gooooo0_l00005ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`06ooooo`04o`000?ooooooooooooooo`;o0000OOooool007kooooo0_l0
0005ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003oooooooooo`05ooooo`05o`00
0000003oooooooooool00000Ooooool0083ooooo0_l00003ooooo`03o`000?oooooooooo00Kooooo
00?o0000ooooooooool01?ooool00ol000000000ooooo`02o`00083ooooo0021ooooo`;o00000ooo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00Co000000000?oooooo0000
P_ooool008;ooooo0_l00003ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool0
0oooool01?l0003oooooo`000?l00023ooooo`00Q?ooool2o`000005ooooool0003oooooooooool0
00000_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooo000008Gooooo0025ooooo`;o0000
00Ooooooo`000?ooooooooooo`000?oooooo000000?ooooo0ol00026ooooo`00Qoooool01ol0003o
ooooo`000?oooooo0000ooooool000000_ooool2o`0008Sooooo0028ooooo`?o00000_ooool01?l0
003oooooo`000?l00029ooooo`00ROooool2o`000003ooooool00000000000;o0000R_ooool008_o
oooo0ol0002<ooooo`00S?ooool00ol0003oooooooooo`2;ooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-5.00005*^-6, -5.00005*^-6, \
0.00355875, 0.00355875}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.0025 w
[ .01 .012 ] 0 setdash
.50377 .45486 m
.66737 .55927 L
s
.50377 .45486 m
.50456 .57112 L
s
.60098 .40621 m
.50377 .45486 L
s
.34123 .56184 m
.50377 .45486 L
s
.5 .27523 m
.50377 .45486 L
s
.40401 .40824 m
.50377 .45486 L
s
.50456 .57112 m
.66737 .55927 L
s
.34123 .56184 m
.50456 .57112 L
s
.504 .67296 m
.50456 .57112 L
s
.40401 .40824 m
.34123 .56184 L
s
.32366 .38575 m
.34123 .56184 L
s
.28124 .50193 m
.34123 .56184 L
s
.3111 .62572 m
.34123 .56184 L
s
.39633 .67987 m
.34123 .56184 L
s
.504 .67296 m
.34123 .56184 L
s
.60098 .40621 m
.66737 .55927 L
s
.67733 .38198 m
.66737 .55927 L
s
.72028 .49805 m
.66737 .55927 L
s
.69003 .62312 m
.66737 .55927 L
s
.6091 .67859 m
.66737 .55927 L
s
.504 .67296 m
.66737 .55927 L
s
.40401 .40824 m
.5 .27523 L
s
.32366 .38575 m
.40401 .40824 L
s
.67733 .38198 m
.60098 .40621 L
s
.5 .27523 m
.60098 .40621 L
s
.504 .67296 m
.39633 .67987 L
s
.504 .67296 m
.5 .75807 L
s
.504 .67296 m
.6091 .67859 L
s
.5 .27523 m
.67733 .38198 L
s
.32366 .38575 m
.5 .27523 L
s
.0035 w
[ ] 0 setdash
.61086 .30766 m
.5 .27523 L
s
.49523 .29392 m
.5 .27523 L
s
.38415 .31036 m
.5 .27523 L
s
.0025 w
[ .01 .012 ] 0 setdash
.28124 .50193 m
.32366 .38575 L
s
.38415 .31036 m
.32366 .38575 L
s
.28742 .42472 m
.32366 .38575 L
s
.39633 .67987 m
.3111 .62572 L
s
.5 .75807 m
.39633 .67987 L
s
.72028 .49805 m
.67733 .38198 L
s
.0035 w
[ ] 0 setdash
.70404 .42053 m
.67733 .38198 L
s
.61086 .30766 m
.67733 .38198 L
s
.0025 w
[ .01 .012 ] 0 setdash
.6091 .67859 m
.5 .75807 L
s
.6091 .67859 m
.69003 .62312 L
s
.0035 w
[ ] 0 setdash
.28742 .42472 m
.28124 .50193 L
s
.3111 .62572 m
.28124 .50193 L
s
.70404 .42053 m
.72028 .49805 L
s
.69003 .62312 m
.72028 .49805 L
s
.38415 .31036 m
.49523 .29392 L
s
.28742 .42472 m
.38415 .31036 L
s
.3111 .62572 m
.28742 .42472 L
s
.3111 .62572 m
.37335 .61763 L
s
.5 .75807 m
.3111 .62572 L
s
.61086 .30766 m
.70404 .42053 L
s
.49523 .29392 m
.61086 .30766 L
s
.69003 .62312 m
.70404 .42053 L
s
.69003 .62312 m
.62124 .6159 L
s
.69003 .62312 m
.5 .75807 L
s
.5 .75807 m
.37335 .61763 L
s
.5 .75807 m
.49484 .56187 L
s
.5 .75807 m
.62124 .6159 L
s
.49523 .29392 m
.70404 .42053 L
s
.49388 .40451 m
.49523 .29392 L
s
.28742 .42472 m
.49523 .29392 L
s
.37335 .61763 m
.28742 .42472 L
s
.49484 .56187 m
.37335 .61763 L
s
.62124 .6159 m
.70404 .42053 L
s
.62124 .6159 m
.49484 .56187 L
s
.28742 .42472 m
.49388 .40451 L
s
.49484 .56187 m
.28742 .42472 L
s
.49388 .40451 m
.70404 .42053 L
s
.49484 .56187 m
.70404 .42053 L
s
.49484 .56187 m
.49388 .40451 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.1,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016R000`400?l00000o`00003oo`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00RP3oool5000008/0oooo00270?ooo`<000000_l0
00000`00003o0000o`000003000008P0oooo00240?ooo`<000000`3oool01Ol00000oooo0000003o
oooo000000<0oooo100000240?ooo`00P03oool400000080oooo0_l000030?ooo`0300000?l00000
oooo00<0oooo0_l000030?ooo`<00000P@3oool007d0oooo0`0000050?ooo`03o`00003oool0oooo
00<0oooo00<000000?ooo`3oool01@3oool00ol00000oooo0?ooo`030?ooo`@00000O@3oool007X0
oooo0`0000070?ooo`04o`00003oool0oooo0?ooo`P0000000Go00000?ooo`3oool0ooooo`000008
0?ooo`<00000NP3oool007L0oooo0`0000070?ooo`L0000000Ko00000000003oool00000o`000000
00020?ooo`P00000203oool3000007L0oooo001c0?ooo`@00000103oool6000000H0oooo0P000002
0?ooo`0300000?l00000oooo0080000000<0ooooo`00003oool01@3oool8000000<0oooo1000001c
0?ooo`00L03oool300000080oooo1P0000040?ooo`03o`00003oool0oooo00<0oooo0P0000040?oo
o`0300000?l00000oooo0080oooo0P0000070?ooo`03o`00003oool0oooo00@0oooo2P00001`0?oo
o`00K@3oool8000000l0oooo00<000000?ooo`3oool0103oool00`00003o00000?ooo`040?ooo`03
0000003oool0oooo00L0oooo00?o00000?ooo`3oool02@3oool4000006h0oooo001[0?ooo`<00000
3@3oool2o`0000D0oooo0P0000000`3ooooo00000?ooo`040?ooo`030000003oool0oooo00D0oooo
0P0000080?ooo`03o`00003oool0oooo00/0oooo00<000000?ooo`3oool0K03oool006/0oooo00<0
00000?ooo`3oool0303oool00ol00000oooo0?ooo`040?ooo`040000003oool0ooooo`0000H0oooo
00<000000?ooo`3oool01P3oool00ol0000000000?ooo`070?ooo`03o`00003oool0oooo00/0oooo
00<000000?ooo`3oool0J`3oool006X0oooo00<000000?ooo`3oool04P3oool200000080oooo00?o
00000?ooo`3oool01@3oool00`00003o00000?ooo`070?ooo`03o`0000000000000001D0oooo00<0
00000?ooo`3oool0JP3oool006T0oooo00<000000?ooo`3oool02`3oool00ol00000oooo0?ooo`03
0?ooo`800000303oool00`00003o00000?ooo`0:0?ooo`8000001`3oool3o`0000X0oooo00<00000
0?ooo`3oool0J@3oool006P0oooo00<000000?ooo`3oool02`3oool00ol00000oooo0?ooo`030?oo
o`030000003oool0oooo00`0oooo00<00000o`00003oool0303oool00`000000oooo0?ooo`070?oo
o`03o`00003oool0oooo00P0oooo00<000000?ooo`3oool0J03oool006L0oooo0P00000<0?ooo`03
o`00003oool0oooo0080oooo0P0000050?ooo`03o`00003oool0oooo00L0oooo00<00000o`00003o
ool02@3oool01?l00000oooo0?ooo`3oool200000180oooo0P00001Y0?ooo`00IP3oool2000000T0
oooo0_l000060?ooo`030000003oool0oooo00@0oooo00?o00000?ooo`3oool0203oool00`000000
oooo0?ooo`0:0?ooo`03o`00003oool0oooo0080oooo0P0000070?ooo`?o00001`3oool2000006P0
oooo001V0?ooo`030000003oool0oooo00L0oooo00?o00000?ooo`3oool0103oool2000000H0oooo
00?o00000?ooo`3oool02@3oool00`000000oooo0?ooo`0;0?ooo`03o`00003oool0oooo00<0oooo
00<000000?ooo`3oool01`3oool00ol00000oooo0?ooo`050?ooo`800000I`3oool006D0oooo00<0
00000?ooo`3oool01`3oool00ol00000oooo0?ooo`030?ooo`800000503oool00`00003o00000?oo
o`0B0?ooo`800000403oool2000006H0oooo001T0?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool0503oool00`00003o00000?ooo`0=0?ooo`03o`00003oool0oooo00@0oooo00<00000
0?ooo`3oool01`3oool2o`0000D0oooo0P00001U0?ooo`00H`3oool2000000L0oooo0_l000040?oo
o`8000002P3oool00ol00000oooo0?ooo`0:0?ooo`0300000?l00000oooo00d0oooo00?o00000?oo
o`3oool01@3oool2000000T0oooo00?o00000?ooo`3oool00`3oool2000006@0oooo001R0?ooo`80
00001P3oool2o`0000D0oooo00<000000?ooo`3oool02@3oool00ol00000oooo0?ooo`0:0?ooo`03
0000003ooooo000000l0oooo00?o00000?ooo`3oool01P3oool2000000d0oooo0P00001T0?ooo`00
H@3oool2000000`0oooo0P00000;0?ooo`03o`00003oool0oooo00/0oooo00<000000?ooo`3oool0
403oool00ol00000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00Co00000?ooo`3oool0
oooo0P00001S0?ooo`00H03oool00`000000oooo0?ooo`030?ooo`;o00001@3oool2000001/0oooo
00<000000?ooo`3oool06`3oool2000000P0oooo00Co00000?ooo`3oool0oooo0P00001R0?ooo`00
H03oool00`000000oooo0?ooo`020?ooo`03o`00003oool0oooo00@0oooo00<000000?ooo`3oool0
6`3oool00`000000oooo0?ooo`0B0?ooo`03o`00003oool0oooo00P0oooo00<000000?ooo`3oool0
1P3oool01?l00000oooo0?ooo`3oool200000640oooo001O0?ooo`030000003oool0oooo00P0oooo
0P00000>0?ooo`03o`00003oool0oooo00d0oooo00<000000?ooool000004P3oool00ol00000oooo
0?ooo`090?ooo`8000002@3oool2o`0000800000H03oool005h0oooo00D000000?ooo`3oool0oooo
o`0000060?ooo`030000003oool0oooo00d0oooo00?o00000?ooo`3oool03P3oool00`000000oooo
o`00000C0?ooo`03o`00003oool0oooo00X0oooo0P0000090?ooo`030000003oool0000005l0oooo
001M0?ooo`050000003oool0oooo0?ooool000001@3oool2000000l0oooo00?o00000?ooo`3oool0
3`3oool010000000oooo0?ooool0000C0?ooo`03o`00003oool0oooo00/0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0000001N0?ooo`00G03oool01@000000oooo0?ooo`3ooooo000000D0
oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`0S0?ooo`800000203oool00`000000
oooo0000001M0?ooo`00F`3oool200000003o`00003oool0oooo00@0oooo0P00000T0?ooo`030000
003oool0oooo01H0oooo00?o00000?ooo`3oool0303oool00`000000oooo0?ooo`060?ooo`030000
0?l00000000005`0oooo001K0?ooo`030000003oool0oooo00@0oooo0P00000B0?ooo`03o`00003o
ool0oooo0140oooo00<000000?ooo`3oool05P3oool00ol00000oooo0?ooo`0=0?ooo`8000001`3o
ool00`00003o00000000001K0?ooo`00FP3oool00`00003o0000o`0000040?ooo`030000003oool0
oooo0180oooo00?o00000?ooo`3oool04@3oool010000000oooo0?ooool0000F0?ooo`03o`00003o
ool0oooo00h0oooo0P0000040?ooo`04o`0000000000oooo000005/0oooo001I0?ooo`8000000P3o
ool01?l00000oooo00000000000D0?ooo`03o`00003oool0oooo0180oooo00@000000?ooo`3ooooo
0000:@3oool00`00003o00000?ooo`030?ooo`<00000FP3oool005P0oooo0`0000001Ol00000oooo
0?ooo`000000oooo00Co00009P3oool010000000oooo0?ooool0000W0?ooo`;o000000<0oooo0000
00000000103oool3000005T0oooo001G0?ooo`050000003oool000000?ooool000000P0000080?oo
o`?o00008@3oool010000000oooo0?ooool0000H0?ooo`03o`00003oool0oooo00H0oooo1?l00007
0?ooo`8000000`3oool2000005T0oooo001F0?ooo`030000003oool0oooo00<000003@3oool00ol0
0000oooo0?ooo`070?ooo`03o`00003oool0oooo01@0oooo00<000000?ooo`3oool06P3oool01?l0
0000oooo0?ooo`3oool2o`0000l0oooo00@000000?ooo`3oool0oooo0P00001H0?ooo`00E@3oool0
1@000000oooo0?ooo`3oool000000180oooo0ol000030?ooo`03o`00003oool0oooo0100oooo3000
000G0?ooo`?o00004P3oool200000080oooo0P00001G0?ooo`00E03oool2000000030?ooo`000000
00000080oooo00?o00000?ooo`3oool04@3oool00ol00000ooooo`000002o`0000L0oooo2P000005
0?ooo`040000003oool0ooooo`0000<0oooo3000000:0?ooo`;o0000503oool00ol00000oooo0000
0003000005L0oooo001D0?ooo`050000003oool000000?ooo`0000000P3oool00ol00000oooo0?oo
o`0C0?ooo`03o`0000000000000000L000003`3oool010000000oooo0?ooool0000?0?ooo``00000
503oool00ol00000oooo0?ooo`04000005H0oooo001C0?ooo`<000000P3oool010000000oooo0?oo
ool0000<0?ooo`X00000603oool010000000oooo0?ooool0000D0?ooo`;o00001@3oool;000000T0
oooo00Co00000?ooo`3oool0oooo0`00001F0?ooo`00DP3oool2000000<0oooo00D000000?ooo`3o
ool0ooooo`0000020?ooo`X00000203oool00ol00000oooo0?ooo`040?ooo`;o00004@3oool01000
0000oooo0?ooool0000C0?ooo`03o`00003oool0oooo0100oooo300000040?ooo`030000003oool0
oooo05<0oooo001A0?ooo`040000003oool0oooo0?ooo`T000006`3oool00ol00000oooo0?ooo`0>
0?ooo`030000003oool0oooo01<0oooo00?o00000?ooo`3oool07@3oool6000005@0oooo001@0?oo
o`D000009`3oool2o`0000`0oooo00<000000?ooo`3oool03`3oool2o`0000d0oooo00?o00000?oo
o`3oool03`3oool00ol00000oooo0?ooo`020?ooo`80000000<0oooo0000003oool0D`3oool00500
oooo00<000000?ooo`0000002@3oool00ol00000oooo0?ooo`0@0?ooo`03o`00003oool0oooo00`0
oooo00?o00000?ooo`3oool02@3oool010000000oooo0?ooool0000=0?ooo`03o`00003oool0oooo
00d0oooo00?o00000?ooo`3oool03`3oool01?l00000oooo0?ooo`3oool2000000030?ooo`000000
000005@0oooo001@0?ooo`80000000D0oooo000000000000oooo000000050?ooo`03o`00003oool0
oooo0100oooo00?o00000?ooo`3oool03@3oool00ol00000oooo0?ooo`080?ooo`040000003oool0
ooooo`0001h0oooo00?o00000?ooo`3oool03P3oool01?l00000oooo0?ooo`0000020?ooo`@00000
D`3oool00500oooo0P0000030?ooo`8000001@3oool00ol00000oooo0?ooo`0?0?ooo`03o`00003o
ool0oooo0140oooo0_l000060?ooo`040000003oool0ooooo`0000T0oooo0_l0000C0?ooo`03o`00
003oool0oooo00h0oooo00?o00000000000000000`3oool4000005<0oooo001@0?ooo`030000003o
ool000000080oooo0`0000040?ooo`03o`00003oool0oooo00l0oooo00?o00000?ooo`3oool04`3o
ool00ol00000oooo0?ooo`030?ooo`040000003oool0ooooo`0000L0oooo0_l0000V0?ooo`030000
003oool0oooo00<0oooo00@000000?ooo`0000000000D`3oool00500oooo0`0000050?ooo`800000
<03oool00`000000oooo0?ooo`0^0?ooo`8000001P3oool010000000oooo00000000001C0?ooo`00
D03oool3000000L0oooo00<000000?ooo`3oool0:P3oool3o`0000030000003oool0oooo00@0oooo
0_l0000J0?ooo`03o`00003oool0oooo00X0oooo00@000000?ooo`3ooooo0000103oool01P000000
oooo0?ooo`000000oooo00000580oooo001@0?ooo`80000000<0oooo0000000000001P3oool20000
00l0oooo00?o00000?ooo`3oool06`3oool010000000oooo0?ooool000020?ooo`03o`00003oool0
oooo01X0oooo00?o00000?ooo`3oool0203oool2000000<0oooo00?o00000?ooo`3oool00P3oool0
1P000000oooo000000000000oooo00000580oooo001@0?ooo`80000000<0oooo0000000000001`3o
ool00ol0000000000?ooo`0=0?ooo`03o`00003oool0oooo01/0oooo00@000000?ooo`3ooooo0000
803oool00ol00000oooo0?ooo`060?ooo`030000003oool0oooo00<0oooo00Go00000?ooo`3oool0
oooo000000020?ooo`040000003oool0000000000580oooo001@0?ooo`80000000<0oooo00000000
0000203oool00ol0000000000000000;0?ooo`03o`00003oool0oooo01`0oooo00<000000?ooo`3o
ool00_l0000O0?ooo`03o`00003oool0oooo00@0oooo0P0000060?ooo`05o`00003oool0oooo0?oo
o`0000000P3oool010000000oooo00000000001B0?ooo`00D03oool2000000030?ooo`0000000000
00P0oooo00Co00000?ooo`3oool00000:@3oool01P00003o00000?ooool00000ooooo`0002@0oooo
00<000000?ooo`3oool02P3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo04l0
oooo001@0?ooo`8000000`3oool00`000000oooo0?ooo`090?ooo`8000009P3oool01Ol000000000
0?ooo`3ooooo000002@0oooo0P00000<0?ooo`050000003oool0oooo0?ooo`0000000`3oool00`00
0000oooo0?ooo`1?0?ooo`00C`3oool00`000000oooo000000030?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool0103oool00ol00000oooo0?ooo`0M0?ooo`030000003oool0oooo00D0
oooo0ol0000K0?ooo`03o`0000000000oooo00d0oooo00D000000?ooo`3oool0oooo000000020?oo
o`800000D@3oool004l0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`0;0?oo
o`800000103oool00ol00000oooo0?ooo`0I0?ooo`05o`00003oool0oooo0?ooo`0000002P3oool0
0ol00000oooo0?ooo`0G0?ooo`8000002`3oool01?l00000oooo0?ooo`0000040?ooo`030000003o
ool0oooo00800000D@3oool004l0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?oo
o`040?ooo`03o`00003oool0oooo00H0oooo0P0000000`3ooooo00000?ooo`0J0?ooo`03o`00003o
ool0oooo0080oooo00<000000?ooo`3oool08@3oool010000000oooo0?ooool0000:0?ooo`04o`00
003oool0oooo000000@0oooo00D000000?ooo`3oool0oooo0000001A0?ooo`00C`3oool010000000
oooo0000000000030?ooo`030000003oool0oooo00@0oooo00?o00000?ooo`3oool0203oool00`00
003o00000?ooo`0I0?ooo`03o`00003oool0oooo00<0oooo00@000000?ooo`3ooooo00002@3oool2
o`0001<0oooo0P00000>0?ooo`04o`00003oool0oooo000000@0oooo00@000000?ooo`3oool0oooo
0P00001@0?ooo`00C`3oool010000000oooo0000000000040?ooo`030000003oool0oooo00<0oooo
00?o00000?ooo`3oool02@3oool2000001D0oooo0_l000080?ooo`040000003oool0ooooo`0000/0
oooo00?o00000?ooo`3oool03`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1>0?ooo`00C`3oool010000000oooo
0?ooo`0000040?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04@3oool00ol00000
oooo0?ooo`090?ooo`030000003ooooo000000`0oooo00?o00000?ooo`3oool0303oool2000000L0
oooo00?o00000?ooo`3oool02@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool0CP3oool004l0oooo00@000000?ooo`3oool000001@3oool00`000000
oooo0?ooo`0=0?ooo`04o`00003oool0oooo0?ooo`800000403oool00ol00000oooo0?ooo`0:0?oo
o`030000003oool0oooo00l0oooo00?o00000?ooo`3oool0203oool00`000000oooo0?ooo`070?oo
o`03o`00003oool0oooo00P0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo04h0oooo001?0?ooo`040000003oool0oooo000000D0oooo00<000000?oo
o`3oool03@3oool00ol00000oooo0?ooo`030?ooo`030000003oool0oooo01X0oooo00<000000?oo
o`3oool0403oool00ol00000oooo0?ooo`060?ooo`030000003oool0oooo00T0oooo00?o00000?oo
o`3oool01P3oool00ol0000000000?ooo`050?ooo`030000003oool0oooo0080oooo0P00001?0?oo
o`00C`3oool010000000oooo0?ooo`0000060?ooo`030000003oool0oooo0080oooo00?o00000?oo
o`3oool01P3oool00ol00000oooo0?ooo`050?ooo`8000002P3oool2o`0000h0oooo00<000000?oo
o`3oool04@3oool00ol00000oooo0?ooo`030?ooo`800000303oool00ol00000oooo0?ooo`060?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`1=0?oo
o`00C`3oool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3oool00P3oool00ol0
0000oooo0?ooo`060?ooo`03o`00003oool0oooo00L0oooo00<000000?ooo`3oool01@3oool2o`00
0100oooo00<000000?ooool000005P3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`1=0?ooo`00C`3oool01@000000
oooo0?ooo`3oool0000000H0oooo00D000000?ooo`3oool0ooooo`00000C0?ooo`8000005`3oool0
0`000000ooooo`00000D0?ooo`800000603oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo00<0oooo00?o00000000003oool0CP3oool004l0oooo00D000000?ooo`3oool0oooo00000006
0?ooo`030000003oool0oooo01L0oooo00<000000?ooool00000503oool00`000000ooooo`00000C
0?ooo`040000003oool0ooooo`000100oooo00?o00000?ooo`3oool00`3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo0080oooo00?o00000000003oool0C`3oool004l0oooo00D00000
o`00003oool0oooo000000060?ooo`030000003oool0oooo00P0oooo00?o00000?ooo`3oool03@3o
ool2000001@0oooo00<000000?ooool000004@3oool2000001@0oooo00?o00000?ooo`3oool00`3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0CP3o
ool00500oooo00@000000?ooo`3oool000001`3oool00`000000oooo0?ooo`070?ooo`03o`00003o
ool0oooo00`0oooo00?o00000?ooo`3oool00P00000B0?ooo`030000003oool0oooo0100oooo00<0
00000?ooo`3oool01P3oool2o`0000d0oooo00Oo00000?ooo`3oool0oooo0000003ooooo000000H0
oooo00@000000?ooo`3ooooo00000P3oool00`000000oooo0?ooo`1>0?ooo`00D03oool010000000
oooo0?ooo`0000070?ooo`040000003oool0ooooo`0000D0oooo00?o00000?ooo`3oool04P3oool0
0`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00h0oooo0P00000;0?ooo`03o`00003oool0
oooo00X0oooo00Oo00000?ooo`3oool0oooo0000003ooooo000000H0oooo00<000000?ooool00000
0`3oool00`000000oooo0?ooo`1>0?ooo`00D03oool01@000000oooo0?ooo`00003o000000L0oooo
00<000000?ooool000004@3oool2o`0000P0oooo0P00000?0?ooo`030000003ooooo000000d0oooo
00<000000?ooo`3oool06`3oool010000000oooo0?ooool000060?ooo`0300000?l00000oooo0080
oooo00<000000?ooo`3oool0C`3oool00500oooo00H000000?ooo`3oool000000?ooool000060?oo
o`030000003ooooo00000100oooo00?o00000?ooo`3oool02P3oool00`000000oooo0?ooo`0<0?oo
o`030000003ooooo000000/0oooo0P00000A0?ooo`;o00002`3oool010000000oooo0?ooool00006
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0C`3oool00540oooo00@000000?oo
o`3oool00000203oool00`00003o00000?ooo`0M0?ooo`800000303oool00`000000ooooo`00000:
0?ooo`030000003oool0oooo01<0oooo00?o00000?ooo`3oool01P3oool00ol00000oooo00000009
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0C`3oool00540oooo00@000000?oo
o`3oool000000P3oool00ol00000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00?o0000
0?ooo`3oool01P3oool00ol00000oooo0?ooo`0@0?ooo`030000003oool0oooo00T0oooo00<00000
0?ooool00000203oool2000001L0oooo00?o00000?ooo`3oool01@3oool00ol0000000000?ooo`08
0?ooo`03o`0000000000oooo00<0oooo00<000000?ooo`3oool0C`3oool00540oooo00@000000?oo
o`3oool000000`3oool00ol00000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo00?o0000
0?ooo`3oool01@3oool00ol00000oooo0?ooo`0B0?ooo`8000002@3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo0200oooo00@000000?ooo`3ooooo00001@3oool00ol00000oooo0000
00030?ooo`030000003oool0oooo0500oooo001A0?ooo`040000003oool0oooo000000@0oooo00?o
00000?ooo`3oool00P3oool01@00003o00000?ooo`3ooooo000000L0oooo00?o00000?ooo`3oool0
5@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo0P00000L0?ooo`?o0000
0`3oool01@000000oooo0?ooo`3ooooo000000@0oooo00Co00000?ooo`3oool000000`3oool00`00
0000oooo0?ooo`1@0?ooo`00D@3oool010000000oooo0?ooo`0000090?ooo`0300000?l00000oooo
00H0oooo00?o00000?ooo`3oool06@3oool2000000H0oooo00<000000?ooool00000103oool00`00
0000oooo0?ooo`0O0?ooo`04o`00003oool0oooo000000<0oooo00?o00000?ooo`3oool01@3oool0
1@000000oooo0?ooo`3oool000000580oooo001B0?ooo`030000003oool0000000X0oooo00<00000
0?ooo`3oool0103oool00ol00000oooo0?ooo`0L0?ooo`800000103oool00`000000ooooo`000002
0?ooo`8000009@3oool00`000000oooo0?ooo`02o`0000L0oooo00D000000?ooo`3oool0oooo0000
001B0?ooo`00DP3oool00`000000oooo000000070?ooo`06o`00003oool0oooo0000003ooooo0000
0`3oool00ol00000oooo0?ooo`0O0?ooo`090000003oool0oooo0?ooo`000000ooooo`00003oool0
000002H0oooo00D00000o`000?l00000ooooo`0000030?ooo`03o`00003oool0oooo0080oooo00@0
00000?ooo`3oool00000D`3oool00580oooo00<000000?ooo`000000203oool01Ol00000oooo0?oo
o`00003o000002H0oooo0P0000000`3oool000000?ooo`02000002L0oooo00P000000?ooo`3ooooo
00000?ooool00000ooooo`0000@0oooo00D000000?ooo`3oool0oooo0000001C0?ooo`00DP3oool0
10000000oooo0?ooo`0000080?ooo`03o`00003oool0000000;o00009`3oool3000002P0oooo00<0
00000?ooo`3oool00`3oool2o`0000D0oooo00D000000?ooo`3oool0oooo0000001C0?ooo`00D`3o
ool00`000000oooo000000090?ooo`;o000000<000000?ooo`3oool09P3oool3000002D0oooo0ol0
00000`000000oooo0?ooo`04o`0000H0oooo00D000000?ooo`3oool0oooo0000001C0?ooo`00D`3o
ool00`000000oooo000000090?ooo`04o`00003oool00000o`0000<0oooo0ol000030?ooo`Co0000
0P3oool3o`0001<0oooo0P0000000`3oool000000?ooo`02000001<0oooo0_l000020?ooo`Co0000
0P3oool4o`0000@0oooo00<000000?ooo`3oool02`3oool010000000oooo0?ooo`00001D0?ooo`00
D`3oool00`000000oooo000000090?ooo`04o`00003oool0oooo00000180oooo00?o00000?ooo`3o
ool01?l000020?ooo`Co00000P3oool2o`00008000000`3oool010000000ooooo`00003oool20000
00@0oooo0_l000030?ooo`?o00000`3oool2o`000180oooo00<000000?ooo`3oool00_l000090?oo
o`040000003oool0oooo000005@0oooo001C0?ooo`030000003oool0000000/0oooo00?o00000000
0?l000007`3oool3000000030?ooool00000oooo0080oooo00<00000o`000?l000000ol000030000
0003o`00003oool0oooo01d0oooo00<000000?ooool000000P3oool01?l00000oooo0?ooool00005
0?ooo`040000003oool0oooo000005@0oooo001D0?ooo`8000002`3oool01?l0000000000?ooool0
000L0?ooo`800000203oool00`000000ooooo`0000060?ooo`8000007@3oool00`000000oooo0?oo
o`030?ooo`04o`00003oool0ooooo`0000D0oooo00@000000?ooo`3oool00000E03oool005@0oooo
0P0000070?ooo`03o`00003oool0oooo0080oooo00?o00000000003oool06P3oool2000000X0oooo
00<000000?ooool00000203oool2000001/0oooo00<000000?ooo`3oool00P3oool00ol00000oooo
0?ooo`020?ooo`03o`00003oool0oooo0080oooo00<000000?ooo`000000E@3oool005@0oooo0P00
00070?ooo`03o`00003oool0oooo0080oooo00?o00000000003oool00P3oool2o`0001@0oooo0P00
000<0?ooo`030000003ooooo000000X0oooo0P00000H0?ooo`030000003oool0oooo00P0oooo00?o
00000?ooo`3oool00P3oool00`000000oooo0000001E0?ooo`00E03oool00`000000oooo00000005
0?ooo`03o`00003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool00ol00000oooo0?ooo`0?
0?ooo`8000003P3oool00`000000ooooo`00000<0?ooo`8000005@3oool00ol0000000000?ooo`0>
0?ooo`030000003oool0000005D0oooo001E0?ooo`8000003@3oool00`000000oooo0?ooo`0A0?oo
o`<00000403oool00`000000oooo0?ooo`0>0?ooo`<000004`3oool00`000000oooo0?ooo`020?oo
o`03o`00003oool0oooo00P0oooo00<000000?ooo`000000E@3oool005D0oooo0P00000<0?ooo`03
o`00003oool0000000H0oooo00?o00000?ooo`3oool01`3oool2000001<0oooo00<000000?ooo`3o
ool04@3oool2000000`0oooo0_l000020?ooo`030000003oool0oooo00<0oooo00?o00000?ooo`3o
ool0103oool01?l00000oooo0?ooo`3oool2000005H0oooo001E0?ooo`800000103oool00ol00000
oooo0?ooo`050?ooo`03o`00003oool0000000L0oooo00?o00000?ooo`3oool0103oool2000001D0
oooo00<000000?ooool000004`3oool2000000T0oooo00?o00000?ooo`3oool00P3oool00`000000
oooo0?ooo`020?ooo`03o`00003oool0oooo00D0oooo00Co00000?ooo`3oool0oooo0P00001F0?oo
o`00E@3oool2000000@0oooo00?o00000?ooo`3oool01P3oool00ol00000oooo000000070?ooo`04
o`00003oool0oooo0?ooo`8000005`3oool00`000000ooooo`00000E0?ooo`8000002`3oool00`00
0000oooo0?ooo`020?ooo`03o`00003oool0oooo00L0oooo00?o00000?ooo`3oool00P00001F0?oo
o`00E@3oool2000000<0oooo00?o00000?ooo`3oool02@3oool00`000000oooo0?ooo`070?ooo`80
00006@3oool00`000000ooooo`00000G0?ooo`80000000<0ooooo`000?l000001P3oool00`000000
oooo0?ooo`0<0?ooo`05o`00003oool000000?ooo`000000EP3oool005H0oooo00D000000?ooo`3o
ool0ooooo`00000;0?ooo`030000003oool0oooo00@0oooo0`000000103ooooo0000o`000?l0000G
0?ooo`030000003ooooo000001T0oooo0`0000050?ooo`030000003oool0oooo00l0oooo0P00001G
0?ooo`00EP3oool00`000000oooo0?ooo`0=0?ooo`03o`0000000000oooo0080oooo0P0000070?oo
o`03o`00003oool0oooo01@0oooo00<000000?ooo`3oool0603oool01?l00000oooo0?ooo`3oool2
000000<0oooo00<000000?ooo`3oool00P3oool00ol00000oooo0?ooo`0:0?ooo`800000E`3oool0
05H0oooo0P00000>0?ooo`03o`0000000000oooo00800000803oool00`000000oooo0?ooo`0N0?oo
o`80000000<0oooo0000003oool00`3oool00ol00000oooo0?ooo`090?ooo`03o`00000000000000
05L0oooo001F0?ooo`80000000?o00000?ooo`3oool02@3oool5000000d0oooo0_l0000C0?ooo`03
0000003ooooo000001D0oooo0_l000090?ooo`H00000303oool00ol0000000000000001G0?ooo`00
E`3oool01000003o00000?ooo`3oool9000000<0oooo00?o00000000003oool03P3oool00ol00000
oooo0?ooo`0@0?ooo`030000003ooooo000001<0oooo0_l0000;0?ooo`030000003oool0oooo0080
oooo00?o00000000000000001`0000040?ooo`030000003oool0oooo05H0oooo001G0?ooo`@00000
3P3oool00`000000oooo0?ooo`0=0?ooo`03o`00003oool0oooo00l0oooo00<000000?ooool00000
7`3oool00`000000oooo0?ooo`0=0?ooo`D00000F03oool005P0oooo0P00000@0?ooo`030000003o
ool0oooo01h0oooo00<000000?ooool00000403oool2o`0000`0oooo00<000000?ooo`3oool0403o
ool00`000000oooo0?ooo`1H0?ooo`00FP3oool00`000000oooo0?ooo`0;0?ooo`04o`00003oool0
oooo000000l0oooo0ol0000=0?ooo`030000003oool0oooo00l0oooo00?o00000?ooo`3oool02`3o
ool00`000000oooo0?ooo`030?ooo`03o`00003oool0oooo00X0oooo00<000000?ooo`3oool0F@3o
ool005/0oooo0P00000<0?ooo`04o`00003oool0oooo00000140oooo00?o00000?ooo`3oool02P3o
ool00`000000oooo0?ooo`0>0?ooo`03o`00003oool0oooo00/0oooo00<000000?ooo`3oool0103o
ool00ol00000oooo0?ooo`080?ooo`800000G03oool005d0oooo00<000000?ooo`3oool02P3oool0
1?l00000oooo0?ooo`00000M0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0103o
ool00ol00000oooo0?ooo`080?ooo`030000003oool0oooo05`0oooo001N0?ooo`8000003P3oool0
0`000000oooo0?ooo`0@0?ooo`03o`00003oool0oooo00L0oooo00<000000?ooool000002`3oool2
o`0000d0oooo00<000000?ooo`3oool03P3oool2000005l0oooo001O0?ooo`8000003P3oool00`00
0000oooo0?ooo`0@0?ooo`03o`00003oool0oooo00H0oooo00<000000?ooool000002P3oool00ol0
0000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0G`3oool00640
oooo0P0000080?ooo`03o`00003oool0oooo0080oooo00<000000?ooo`3oool0403oool00ol00000
oooo0?ooo`050?ooo`030000003ooooo000000T0oooo00?o00000?ooo`3oool03@3oool00`000000
oooo0?ooo`050?ooo`03o`00003oool0oooo00@0oooo0P00001R0?ooo`00HP3oool2000000L0oooo
00?o00000?ooo`3oool00`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo00H0oooo
0_l0000@0?ooo`030000003oool0oooo00H0oooo00?o00000?ooo`3oool00`3oool2000006<0oooo
001T0?ooo`030000003oool0oooo00D0oooo00?o00000?ooo`3oool00P3oool00`000000oooo0?oo
o`0B0?ooo`;o00000`3oool00`000000oooo0?ooo`050?ooo`03o`00003oool0oooo00l0oooo00<0
00000?ooo`3oool01P3oool00ol00000oooo0?ooo`030?ooo`030000003oool0oooo06<0oooo001U
0?ooo`8000001@3oool00ol00000oooo0?ooo`030?ooo`030000003oool0oooo01<0oooo00Co0000
0?ooo`3oool000001P3oool00ol00000oooo0?ooo`0?0?ooo`030000003oool0oooo00H0oooo00?o
00000?ooo`3oool00P3oool2000006H0oooo001W0?ooo`<000002@3oool00`000000oooo0?ooo`0F
0?ooo`0300000?l00000oooo01@0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`1V
0?ooo`00J03oool00`000000oooo000000090?ooo`030000003oool0oooo01@0oooo00Go00000000
0?l00000ooooo`00000C0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0I`3oool0
06T0oooo0P0000030?ooo`03o`00003oool0oooo00@0oooo00<000000?ooo`3oool0503oool00`00
003o0000o`00000C0?ooo`030000003oool0oooo00L0oooo00Co00000?ooo`0000000000JP3oool0
06/0oooo0`0000000ol00000oooo0?ooo`050?ooo`030000003oool0oooo00L0oooo0_l000020?oo
o`Co00000P3oool2o`00000300000?l0003o000000;o00000P3oool4o`000080oooo1?l000040?oo
o`030000003oool0oooo00P0oooo0P00001/0?ooo`00K03oool300000003o`00003oool0oooo00?o
00000P3oool00`00003o0000o`000002o`000080oooo0_l0000<0?ooo`0300000?l00000oooo0140
oooo00<00000o`000?l000000`3oool4o`0000<00000K@3oool006h0oooo0P0000080?ooo`030000
003oool0oooo0140oooo00<00000o`00003oool0403oool00`000000oooo0?ooo`070?ooo`800000
K`3oool006l0oooo00<000000?ooo`0000001`3oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo00l0oooo00<000000?ooo`3oool01`3oool200000700oooo001`0?ooo`<000001`3oool0
0`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool01`3oool2
00000740oooo001b0?ooo`8000001P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool01@3oool2000007<0oooo001c0?ooo`8000001P3oool00`000000
oooo0?ooo`0>0?ooo`0300000?l00000oooo00d0oooo00<000000?ooo`3oool0103oool3000007@0
oooo001e0?ooo`8000001@3oool00`000000oooo0?ooo`0=0?ooo`0300000?l00000oooo00`0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`1d0?ooo`00MP3oool2000000D0oooo00<0
00000?ooo`3oool0303oool00`00003o00000?ooo`0;0?ooo`030000003oool0oooo00<0oooo0`00
001g0?ooo`00M`3oool2000000D0oooo00<000000?ooo`3oool02`3oool00`00003o00000?ooo`0:
0?ooo`030000003oool0oooo00<0oooo0`00001h0?ooo`00N@3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`030?oo
o`800000NP3oool007X0oooo0`0000030?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`030?ooo`800000N`3oool007`0oooo0P0000030?ooo`030000
003oool0oooo00P0oooo00<00000o`00003oool0203oool010000000oooo0?ooo`3oool2000007d0
oooo001m0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01`3oool00`00003o0000
0?ooo`070?ooo`040000003oool0oooo0?ooo`800000OP3oool007h0oooo0`0000020?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool01P3oool010000000oooo0?ooo`3oool2000007l0
oooo00200?ooo`80000000<0oooo0000003oool01`3oool00`000000oooo0?ooo`050?ooo`050000
003oool0oooo0?ooo`000000P@3oool00840oooo0P0000000`3oool000000?ooo`060?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool00P0000220?ooo`00P`3oool00`000000oooo0000
00060?ooo`030000003oool0oooo00<0oooo00@000000?ooo`0000000000Q03oool008@0oooo0`00
00050?ooo`030000003oool0oooo00<0oooo00<000000?ooo`000000Q@3oool008D0oooo0`000004
0?ooo`030000003oool0oooo0080oooo0`0000260?ooo`00Q`3oool2000000<0oooo00@000000?oo
o`3oool0oooo0P0000280?ooo`00R03oool200000080oooo00<000000?ooo`3oool00P0000290?oo
o`00RP3oool01@000000oooo0000003oool0000008/0oooo002;0?ooo`<00000S03oool008`0oooo
00<000000?ooo`3oool0R`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0
oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0
oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0
oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0
oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0
oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0
oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0
oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0
oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0
oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0
oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0
oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0
oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0
oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00001\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-5.00005*^-6, -5.00005*^-6, \
0.00355875, 0.00355875}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.0025 w
[ .01 .012 ] 0 setdash
.53124 .45363 m
.69667 .54859 L
s
.53124 .45363 m
.53784 .56992 L
s
.61766 .39786 m
.53124 .45363 L
s
.37465 .56997 m
.53124 .45363 L
s
.5 .27523 m
.53124 .45363 L
s
.42372 .41472 m
.53124 .45363 L
s
.37465 .56997 m
.53784 .56992 L
s
.42372 .41472 m
.37465 .56997 L
s
.33052 .39916 m
.37465 .56997 L
s
.29076 .51562 m
.37465 .56997 L
s
.31871 .63494 m
.37465 .56997 L
s
.41768 .68394 m
.37465 .56997 L
s
.53323 .67212 m
.37465 .56997 L
s
.53784 .56992 m
.69667 .54859 L
s
.53323 .67212 m
.53784 .56992 L
s
.42372 .41472 m
.5 .27523 L
s
.33052 .39916 m
.42372 .41472 L
s
.61766 .39786 m
.69667 .54859 L
s
.67754 .36786 m
.61766 .39786 L
s
.5 .27523 m
.61766 .39786 L
s
.67754 .36786 m
.69667 .54859 L
s
.72166 .48345 m
.69667 .54859 L
s
.69054 .61338 m
.69667 .54859 L
s
.62724 .67334 m
.69667 .54859 L
s
.53323 .67212 m
.69667 .54859 L
s
.53323 .67212 m
.41768 .68394 L
s
.53323 .67212 m
.5 .75807 L
s
.53323 .67212 m
.62724 .67334 L
s
.5 .27523 m
.67754 .36786 L
s
.33052 .39916 m
.5 .27523 L
s
.0035 w
[ ] 0 setdash
.59003 .29883 m
.5 .27523 L
s
.46059 .29588 m
.5 .27523 L
s
.36864 .32105 m
.5 .27523 L
s
.0025 w
[ .01 .012 ] 0 setdash
.29076 .51562 m
.33052 .39916 L
s
.36864 .32105 m
.33052 .39916 L
s
.2618 .44114 m
.33052 .39916 L
s
.41768 .68394 m
.31871 .63494 L
s
.5 .75807 m
.41768 .68394 L
s
.2618 .44114 m
.29076 .51562 L
s
.31871 .63494 m
.29076 .51562 L
s
.0035 w
[ ] 0 setdash
.62724 .67334 m
.5 .75807 L
s
.62724 .67334 m
.69054 .61338 L
s
.72166 .48345 m
.67754 .36786 L
s
.66737 .40657 m
.67754 .36786 L
s
.59003 .29883 m
.67754 .36786 L
s
.31871 .63494 m
.2618 .44114 L
s
.31871 .63494 m
.35658 .62451 L
s
.5 .75807 m
.31871 .63494 L
s
.36864 .32105 m
.46059 .29588 L
s
.2618 .44114 m
.36864 .32105 L
s
.66737 .40657 m
.72166 .48345 L
s
.69054 .61338 m
.72166 .48345 L
s
.59003 .29883 m
.66737 .40657 L
s
.46059 .29588 m
.59003 .29883 L
s
.69054 .61338 m
.66737 .40657 L
s
.69054 .61338 m
.59857 .6102 L
s
.69054 .61338 m
.5 .75807 L
s
.5 .75807 m
.35658 .62451 L
s
.5 .75807 m
.45738 .56325 L
s
.5 .75807 m
.59857 .6102 L
s
.46059 .29588 m
.66737 .40657 L
s
.44949 .40666 m
.46059 .29588 L
s
.2618 .44114 m
.46059 .29588 L
s
.2618 .44114 m
.44949 .40666 L
s
.35658 .62451 m
.2618 .44114 L
s
.45738 .56325 m
.2618 .44114 L
s
.45738 .56325 m
.35658 .62451 L
s
.59857 .6102 m
.66737 .40657 L
s
.59857 .6102 m
.45738 .56325 L
s
.44949 .40666 m
.66737 .40657 L
s
.45738 .56325 m
.44949 .40666 L
s
.45738 .56325 m
.66737 .40657 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.1,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016R000`400?l00000o`00003oo`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00R`3oool4000008/0oooo00280?ooo`<000001?l0
0004000008L0oooo00250?ooo`@0000000Ko00000?ooo`3ooooo00000?ooool000040?ooo`@00000
P`3oool00880oooo0`0000000`3oool000000?ooo`040?ooo`03o`00003oool0oooo0080oooo0ol0
00030?ooo`D00000OP3oool007l0oooo0`0000020?ooo`8000000_l000020?ooo`03o`00003oool0
oooo00<0oooo00Go00000?ooo`3oool0ooooo`0000070?ooo`@00000NP3oool007`0oooo0`000003
0?ooo`80000000<0ooooo`00003oool00`3oool00ol00000oooo0?ooo`040?ooo`03o`00003oool0
oooo00`0oooo1000001f0?ooo`00N@3oool3000000<0oooo:000001c0?ooo`00M`3oool200000080
oooo1@0000000`3oool00000o`000002000000<0oooo00?o00000?ooo`3oool00P3oool00ol00000
oooo0?ooo`090?ooo`03o`00003oool0oooo00T0oooo00<000000?ooo`000000LP3oool007@0oooo
0`000000103oool000000000000000020?ooo`80000000<0ooooo`00000000000`3oool2000000L0
oooo00?o00000?ooo`3oool02`3oool2o`0000P0oooo00<000000?ooo`000000L@3oool00740oooo
1`0000040?ooo`060000003oool0ooooo`00003oool000001@3oool2000000D0oooo00?o00000?oo
o`3oool0103oool00ol00000oooo0?ooo`060?ooo`03o`00003oool0oooo00H0oooo00<000000?oo
o`000000L03oool006h0oooo1P0000070?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool00`3oool00ol00000oooo0000000<0?ooo`03o`00003oool0oooo00H0oooo00?o00000?ooo`3o
ool01@3oool00`000000oooo0?ooo`02000006h0oooo001[0?ooo`D000002@3oool2000000030?oo
ool0003o000000<0oooo00<000000?ooo`3oool00P3oool01?l00000oooo0?ooo`3oool2000000/0
oooo00?o00000?ooo`3oool0203oool00ol00000oooo0?ooo`030?ooo`050000003oool0oooo0?oo
o`000000K@3oool006P0oooo1@00000;0?ooo`040000003oool0ooooo`0000@0oooo00<000000?oo
o`3oool00P3oool00ol00000oooo0?ooo`040?ooo`80000000?o00000?ooo`3oool04P3oool00ol0
0000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`000000K03oool006L0oooo0P00000=0?oo
o`8000000P3oool00ol00000oooo0?ooo`030?ooo`030000003oool0oooo00/0oooo0P0000090?oo
o`03o`00003oool0oooo00P0oooo00?o00000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0
000006/0oooo001W0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`0<0?ooo`03o`0000000000000000P0oooo00?o00000?ooo`3oool02P3oool3o`00
00030000003oool0oooo0080oooo0P00001Y0?ooo`00IP3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00;o00001`3oool01@000000oooo0?ooo`3ooooo000000X0oooo00?o00000?oo
o`3oool00P0000070?ooo`03o`00003oool0oooo00`0oooo00?o00000000003oool0103oool00`00
0000oooo0?ooo`1V0?ooo`00I@3oool00`000000oooo0?ooo`0:0?ooo`80000000<0ooooo`000?l0
00002@3oool010000000oooo0?ooool0000@0?ooo`8000005P3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo06D0oooo001T0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool0303oool00`000000ooooo`00000C0?ooo`800000503oool00`00003o0000o`0000040?ooo`03
0000003oool0oooo06@0oooo001S0?ooo`8000002P3oool2000000030?ooool0003o000000`0oooo
00<000000?ooo`3oool0303oool00ol00000oooo0?ooo`060?ooo`030000003oool0oooo0080oooo
00?o00000?ooo`3oool03@3oool00`000000ooooo`0000040?ooo`800000I03oool00680oooo00<0
00000?ooo`0000002@3oool010000000oooo0?ooool0000>0?ooo`030000003oool0oooo00`0oooo
00?o00000?ooo`3oool01`3oool2000000<0oooo00?o00000?ooo`3oool03@3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo0640oooo001Q0?ooo`030000003oool0000000T0oooo00@0
00000?ooo`3ooooo00003`3oool00`00003o00000?ooo`0=0?ooo`03o`00003oool0oooo00P0oooo
0P0000020?ooo`03o`00003oool0oooo00d0oooo00<000000?ooo`3oool00ol000020?ooo`030000
003oool0oooo0600oooo001P0?ooo`040000003oool0oooo000000L0oooo0P00000C0?ooo`030000
0?l00000oooo00d0oooo00?o00000?ooo`3oool02P3oool200000100oooo00<000000?ooo`3oool0
0`3oool01?l00000oooo0?ooo`00001Q0?ooo`00G`3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo00;o0000403oool00`00003o00000?ooo`0M0?ooo`80000000?o00000?ooo`3oool0
303oool00`000000oooo0?ooo`060?ooo`800000G`3oool005h0oooo00<000000?ooo`3oool01`3o
ool200000080oooo00?o00000?ooo`3oool0403oool00`000000oooo0?ooo`0O0?ooo`8000003P3o
ool00`000000oooo0?ooo`040?ooo`;o000000<0oooo0000003oool0G@3oool005d0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooool000004`3o
ool00`000000oooo0?ooo`0>0?ooo`03o`00003oool0oooo0100oooo0P00000<0?ooo`030000003o
ool0oooo00H0oooo00?o00000?ooo`000000G@3oool005d0oooo00D000000?ooo`3oool0oooo0000
00040?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool03P3oool00ol00000oooo0?oo
o`0B0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`1J0?ooo`00G03oool01@000000oooo0?ooo`3oool0000000<0oooo0P0000020?ooo`;o0000503o
ool00ol0000000000?ooo`0@0?ooo`03o`00003oool0oooo0180oooo0P00000;0?ooo`030000003o
ool0oooo00L0oooo00?o00000000003oool0FP3oool005/0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`02o`0001D0oooo00?o00000?ooo`0000004@3oool00ol00000oooo0?ooo`0B
0?ooo`04o`00003oool00000000000X0oooo00<000000?ooo`3oool0103oool2o`0000030?ooo`00
0000oooo05X0oooo001J0?ooo`030000003oool0oooo00@0oooo0P00000I0?ooo`04o`00003oool0
oooo000002L0oooo00?o00000?ooo`3oool00P0000080?ooo`030000003oool0oooo00L0oooo0P00
001J0?ooo`00F@3oool00`000000oooo0?ooo`030?ooo`8000000P3oool2o`0001X0oooo00<00000
0?ooo`3oool09P3oool01?l00000oooo0?ooo`3oool2000000L0oooo00@000000?ooool0003o0000
103oool00`00003o00000000001J0?ooo`00F03oool00`000000oooo0?ooo`040?ooo`040000003o
ool0ooooo`0001`0oooo00<000000?ooo`3oool03`3oool00ol00000oooo0?ooo`0J0?ooo`800000
1P3oool00`000000oooo0?ooo`040?ooo`030000003oool0000005X0oooo001G0?ooo`030000003o
ool0oooo00<0oooo0P0000020?ooo`03o`00003oool0oooo01L0oooo00Go00000?ooo`3oool0oooo
0000000A0?ooo`03o`00003oool0oooo01H0oooo00?o00000?ooo`3oool00`3oool2000000;o0000
0P3oool00`000000oooo0?ooo`040?ooo`040000003oool0oooo000005T0oooo001F0?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`000000703oool01Ol00000oooo0?ooo`3oool000000180
oooo00?o00000?ooo`3oool05P3oool00ol00000oooo0?ooo`030?ooo`03o`0000000000000000<0
oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooool00000000005T0oooo001E0?ooo`03
0000003oool0oooo0080oooo0P0000020?ooo`;o00006P3oool01Ol00000oooo0?ooo`3oool00000
01<0oooo00?o00000?ooo`3oool05`3oool01Ol00000oooo0?ooo`3ooooo000000<0oooo00D00000
0?ooo`3oool0oooo000000030?ooo`050000003oool0ooooo`0000000000F@3oool005@0oooo00<0
00000?ooo`3oool00P3oool01@000000oooo0?ooo`3ooooo000001`0oooo00Go00000?ooo`3oool0
oooo0000000^0?ooo`03o`00003oool0oooo00D0oooo0P0000020?ooo`040000003oool0oooo0000
0080oooo00?o00000?ooo`000000F03oool005<0oooo00<000000?ooo`3oool00P3oool010000000
oooo0?ooo`000004o`0001h0oooo00<000000?ooo`3oool0:`3oool2o`0000T0oooo0`0000020?oo
o`060000003oool0ooooo`00003oool00000F03oool005<0oooo00<000000?ooo`3oool00P000002
0?ooo`030000003oool0000000D0oooo1?l0000H0?ooo`030000003oool0oooo0140oooo00?o0000
0?ooo`3oool05P3oool01?l00000oooo0?ooool0000:0?ooo`<000001P3oool00`000000oooo0?oo
o`1E0?ooo`00DP3oool010000000oooo0?ooo`0000030?ooo`050000003oool0oooo00000?l00000
2`3oool3o`0000`0oooo00?o00000?ooo`3oool0@@0000060?ooo`030000003oool0oooo05D0oooo
001A0?ooo`040000003oool00000000000H0oooo00<000000?ooo`3oool04@3oool3o`0000<0oooo
1P0000030?ooo`030000003oool0oooo0180oooo00?o00000?ooo`3oool04@3oool2o`000100oooo
00<000000?ooo`0000000`3oool01?l00000oooo0?ooo`00001G0?ooo`00D03oool00`000000oooo
000000020?ooo`800000603oool6000000Co00001@3oool00`000000oooo0?ooo`0B0?ooo`03o`00
003oool0oooo0100oooo00?o00000?ooo`3oool03`3oool00`000000oooo0000000200000080oooo
00Go00000?ooo`3oool0oooo0000001F0?ooo`00C`3oool00`000000oooo000000020?ooo`030000
003oool0oooo0180oooo1P0000080?ooo`03o`00003ooooo000000@0oooo00<000000?ooo`3oool0
;`3oool00ol00000oooo0?ooo`030?ooo`8000000P3oool2000000040?ooo`000000ooooo`0000<0
oooo00<000000?ooo`3oool0E03oool004h0oooo0`0000090?ooo`050000003oool0oooo0?ooool0
0000103oool6000000d0oooo00?o00000?ooo`3oool00`3oool2o`0000030000003oool0oooo0240
oooo0_l0000<0?ooo`03o`00003oool0oooo0080oooo00<000000?ooo`3oool00P3oool200000080
oooo00<00000o`00003oool00P3oool00`000000oooo0?ooo`1D0?ooo`00C@3oool2000000030?oo
o`000000000000P0oooo00@000000?ooo`3oool0oooo1@00000C0?ooo`03o`00003oool0oooo00D0
oooo00<00000o`00003oool0803oool00ol00000oooo0?ooo`0=0?ooo`04o`00003oool0oooo0000
00@0oooo00H000000?ooo`3oool000000?ooo`0000050?ooo`030000003oool0oooo05<0oooo001<
0?ooo`@00000203oool6000000030?ooool00000oooo01d0oooo00@000000?ooo`3oool0oooo0ol0
000>0?ooo`03o`00003oool0oooo00X0oooo00?o00000?ooo`3oool03`3oool2000000D0oooo00@0
00000?ooo`3oool000000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo05<0oooo
001;0?ooo`030000003oool0oooo00@0oooo1P0000000`3oool000000?ooo`0S0?ooo`030000003o
ool0oooo00@0oooo00?o00000?ooo`3oool02`3oool00ol00000oooo0?ooo`070?ooo`03o`00003o
ool0oooo0140oooo00<000000?ooo`3oool01@3oool010000000oooo0?ooo`0000030?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool0DP3oool004X0oooo2000000S0?ooo`03o`00003o
ool0oooo00H0oooo00<000000?ooo`3oool01`3oool3o`0000T0oooo00?o00000?ooo`3oool01@3o
ool00ol00000oooo0?ooo`0A0?ooo`040000003oool0ooooo`0000@0oooo00D000000?ooo`3oool0
oooo000000030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0DP3oool004T0oooo
0`00000Y0?ooo`03o`00003oool0oooo00H0oooo00<000000?ooo`3oool02P3oool00ol00000oooo
0?ooo`0=0?ooo`03o`00003oool0oooo0100oooo0P0000030?ooo`03o`00003oool0oooo0080oooo
00D000000?ooo`3oool0oooo000000030?ooo`03o`0000000000oooo0080oooo00<000000?ooo`3o
ool0DP3oool004T0oooo00<000000?ooo`000000303oool00`000000oooo0?ooo`040?ooo`03o`00
003oool0oooo0180oooo00?o00000?ooo`3oool01`3oool00`000000oooo0?ooo`0=0?ooo`;o0000
7@3oool00`000000oooo0?ooo`040?ooo`05o`00003oool0oooo0?ooo`0000000`3oool01`000000
oooo0?ooo`3ooooo00000?ooo`0000000`3oool00`000000oooo0?ooo`1A0?ooo`00B@3oool20000
00030?ooo`000000000000X0oooo00<000000?ooo`3oool0103oool00ol00000oooo0?ooo`0B0?oo
o`03o`00003oool0oooo00L0oooo00<000000?ooo`3oool03`3oool00ol00000oooo0?ooo`040?oo
o`;o00004`3oool00`000000oooo0?ooo`050?ooo`04o`00003oool0oooo000000@0oooo00<00000
0?ooo`3oool0103oool010000000oooo0?ooo`00001C0?ooo`00BP3oool010000000oooo0?ooo`3o
ool2000000L0oooo00<000000?ooo`3oool01P3oool00ol00000oooo0?ooo`0L0?ooo`030000003o
ool0oooo01<0oooo0_l0000C0?ooo`8000002`3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo00@0oooo00@000000?ooo`3oool00000D`3oool004X0oooo0P0000040?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0B0?ooo`?o00004P3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3ooooo0000
0`3oool010000000oooo0?ooo`00001B0?ooo`00BP3oool2000000D0oooo0P00000P0?ooo`03o`00
003oool0oooo00T0oooo00<000000?ooo`3oool04`3oool00ol00000ooooo`00000@0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool0103oool010000000oooo0?ooool000040?ooo`03
0000003oool000000580oooo001;0?ooo`8000001P3oool00`000000oooo0?ooo`0M0?ooo`03o`00
003oool0oooo00T0oooo00<000000?ooo`3oool0403oool2o`0000030?ooool00000oooo00l0oooo
0P00000>0?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3oool0ooooo`0000030?ooo`04
0000003oool0oooo00000540oooo001;0?ooo`8000001`3oool3000000X0oooo00?o00000?ooo`3o
ool03P3oool00ol00000oooo0?ooo`0:0?ooo`030000003oool0oooo00h0oooo0_l000030?ooo`03
o`00003oool0oooo0080oooo0ol000080?ooo`030000003oool0oooo00h0oooo00<00000o`00003o
ool0103oool01@000000oooo0?ooo`3ooooo000000@0oooo00<000000?ooo`000000D@3oool004/0
oooo0`0000080?ooo`030000003oool0oooo00P0oooo00?o00000?ooo`3oool03P3oool00ol00000
oooo0?ooo`0:0?ooo`030000003oool0oooo01/0oooo00?o00000?ooo`3oool0103oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01`3oool200000540
oooo001;0?ooo`<000001`3oool010000000oooo0000000000090?ooo`03o`00003oool0oooo01X0
oooo00<000000?ooo`3oool02`3oool2o`0001<0oooo0P00000A0?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool0203oool200000500oooo001<0?ooo`030000003oool0000000H0oooo
00@000000?ooo`3oool0oooo0P00000T0?ooo`030000003oool0oooo00X0oooo00?o00000?ooo`3o
ool01P3oool00ol00000oooo0?ooo`070?ooo`;o000000<000000?ooo`3oool04@3oool01@000000
oooo0?ooo`3ooooo000000<0oooo00<000000?ooo`3oool0203oool200000500oooo001<0?ooo`03
0000003oool0000000`0oooo00<000000?ooo`3oool04`3oool00ol00000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00T0oooo00?o00000?ooo`3oool01`3oool00ol00000oooo0?ooo`080?ooo`03
00000?l00000oooo0140oooo00<000000?ooo`3oool00P3oool01Ol00000oooo0?ooo`3oool00000
00<0oooo00?o00000?ooo`3oool01@3oool00`000000oooo0?ooo`1>0?ooo`00C03oool010000000
oooo00000000000<0?ooo`8000004`3oool00ol00000oooo0?ooo`0;0?ooo`030000003oool0oooo
01<0oooo00?o00000?ooo`3oool01P3oool200000080oooo00?o00000?ooo`3oool03`3oool00`00
0000oooo0?ooo`030?ooo`04o`00003oool0oooo000000<0oooo00?o00000?ooo`3oool01P3oool0
0`000000oooo0?ooo`1=0?ooo`00C@3oool3000000@0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`020?ooo`03o`00003oool0oooo00X0oooo00?o00000?ooo`3oool0303oool00`00
0000oooo0?ooo`070?ooo`03o`00003oool0oooo00T0oooo00?o00000?ooo`3oool01@3oool00`00
0000oooo0?ooo`050?ooo`03o`00003oool0oooo00`0oooo00<000000?ooo`3oool00`3oool01Ol0
0000oooo0?ooo`3oool000000080oooo00?o00000?ooo`3oool01P3oool00`000000oooo0?ooo`1=
0?ooo`00C@3oool010000000oooo0000000000030?ooo`030000003oool0oooo00P0oooo0P000002
0?ooo`03o`00003oool0oooo01T0oooo00<000000?ooo`3oool01P3oool00ol00000oooo0?ooo`0@
0?ooo`8000002@3oool00ol00000oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool0203oool00ol0000000000?ooo`1>0?ooo`00C@3oool01`000000oooo0000003oool0
00000?ooo`0000003@3oool00`000000ooooo`00000K0?ooo`030000003oool0oooo00D0oooo00?o
00000?ooo`3oool0403oool00`000000oooo0?ooo`0:0?ooo`03o`00003oool0oooo00T0oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo04h0oooo001>
0?ooo`060000003oool0oooo0000003oool000003P3oool2000001/0oooo00<000000?ooo`3oool0
4`3oool01Ol00000oooo0?ooo`3oool000000100oooo0_l000070?ooo`030000003oool0oooo00D0
oooo00Co00000?ooo`3oool000002P3oool00`000000oooo0?ooo`1>0?ooo`00CP3oool01@000000
oooo0?ooo`3oool000000140oooo0P0000090?ooo`03o`00003oool0oooo00d0oooo00@000000?oo
o`3oool0oooo0_l0000@0?ooo`04o`00003oool00000000001<0oooo00?o00000?ooo`3oool00`3o
ool00`000000oooo0?ooo`070?ooo`03o`00003oool0000000<0oooo00?o00000?ooo`3oool0103o
ool00`000000oooo0?ooo`1>0?ooo`00CP3oool01@000000oooo0000003oool0000001<0oooo00<0
00000?ooo`3oool01P3oool00ol00000oooo0?ooo`0=0?ooo`040000003oool0ooooo`0001<0oooo
00<000000?ooo`3oool0503oool00ol00000oooo0?ooo`020?ooo`030000003oool0oooo00P0oooo
00?o00000000003oool00P3oool00ol00000oooo0?ooo`030?ooo`03o`0000000000oooo04l0oooo
001>0?ooo`040000003oool000000?ooo`800000403oool00ol00000oooo0?ooo`02000000D0oooo
00?o00000?ooo`3oool03P3oool00`000000oooo0?ooo`0C0?ooo`0300000?l00000oooo01P0oooo
00?o00000?ooo`0000002`3oool01@000000oooo0?ooo`3ooooo000000D0oooo00?o00000000003o
ool0C`3oool004l0oooo00<000000?ooo`0000000P00000@0?ooo`03o`00003oool0oooo0080oooo
00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0A0?ooo`800000703oool00`000000oooo
0?ooo`0:0?ooo`050000003oool0oooo0?ooool00000103oool00ol0000000000?ooo`1@0?ooo`00
C`3oool01P000000oooo00000?l00000oooo00000100oooo00?o00000?ooo`3oool00P3oool20000
0180oooo00?o00000000003oool04@3oool00`000000oooo0?ooo`0L0?ooo`0300000?l00000oooo
00X0oooo00?o00000000003oool01P3oool00ol0000000000?ooo`1@0?ooo`00C`3oool01P000000
oooo0000003ooooo0000000001L0oooo00<000000?ooo`3oool03P3oool00ol00000oooo0000000A
0?ooo`030000003oool0oooo01d0oooo00D000000?ooo`3oool0ooooo`0000080?ooo`03o`000000
0000oooo00L0oooo00<000000?ooo`3oool0C`3oool00500oooo0P0000020?ooo`03o`0000000000
oooo01H0oooo0P00000@0?ooo`030000003oool0oooo00d0oooo0P0000050?ooo`03o`00003oool0
oooo01L0oooo00<000000?ooo`3oool00`3oool00ol00000oooo0?ooo`060?ooo`040000003oool0
ooooo`0000D0oooo00<000000?ooo`3oool0C`3oool00500oooo00<000000?ooo`0000000P3oool0
0`000000oooo0?ooo`0E0?ooo`04o`00003oool00000000000T0oooo00?o00000?ooo`3oool00P3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00D0oooo00?o00000?ooo`3oool05`3o
ool00`000000oooo0?ooo`040?ooo`03o`00003oool0oooo00D0oooo00@00000o`00003ooooo0000
0`3oool00ol00000oooo0000001A0?ooo`00D03oool00`000000oooo000000030?ooo`0300000?l0
003o000000d0oooo00?o00000?ooo`3oool00`3oool00ol00000oooo0?ooo`020?ooo`030000003o
ool0oooo00D0oooo00?o00000?ooo`3oool0103oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo00H0oooo00?o00000?ooo`3oool05`3oool00`000000oooo0?ooo`0<0?ooo`050000003o
ool0oooo0?ooool000000P3oool00ol0000000000?ooo`1A0?ooo`00D03oool00`000000oooo0?oo
o`030?ooo`040000003oool0ooooo`0000`0oooo00?o00000?ooo`3oool02@3oool2000000@0oooo
00?o00000?ooo`3oool01@3oool00`000000oooo0?ooo`080?ooo`8000008P3oool00`000000oooo
0?ooo`080?ooo`?o00000P3oool02@000000oooo0?ooo`3ooooo00000?ooool00000oooo0000001B
0?ooo`00D@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00`0oooo00?o00000?oo
o`3oool02`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool08P3oool00`000000oooo0?ooo`0;0?ooo`05o`00003oool000000?ooool000000`3oool0
0ol00000oooo0000001B0?ooo`00D@3oool00`000000oooo000000030?ooo`030000003oool0oooo
0080oooo00?o00000?ooo`3oool0303oool00ol00000oooo0?ooo`060?ooo`03o`00000000000000
00T0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo
00d0oooo00<000000?ooool000001@3oool00`000000oooo0?ooo`1@0?ooo`00D@3oool00`000000
oooo000000040?ooo`030000003oool0oooo0080oooo00?o00000?ooo`3oool02`3oool00ol00000
oooo0?ooo`050?ooo`05o`00003oool0oooo0?ooo`000000203oool00`000000oooo0?ooo`040?oo
o`8000003@3oool00ol00000oooo0?ooo`0E0?ooo`030000003oool0oooo00l0oooo00@00000o`00
0?l0003o00000P3oool00`000000oooo0?ooo`1A0?ooo`00DP3oool2000000@0oooo00<000000?oo
o`3oool00`3oool00ol00000oooo0?ooo`0:0?ooo`03o`00003oool0oooo00X0oooo0P0000060?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool03@3oool00ol00000oooo0?ooo`0E0?oo
o`030000003oool0oooo00l0oooo00<000000?ooool000000_l000000`3oool000000?ooo`1B0?oo
o`00DP3oool2000000D0oooo00<000000?ooo`3oool02`3oool01Ol00000oooo0?ooo`3ooooo0000
00@0oooo00?o00000?ooo`3oool01`3oool2000000@0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`0>0?ooo`03o`00003oool0oooo01D0oooo00<000000?ooo`3oool0303oool2o`00
00030?ooo`000000oooo00;o00000P3oool00`000000oooo0?ooo`1A0?ooo`00DP3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo0_l000040?ooo`03o`00003oool0oooo00D0
oooo00?o00000?ooo`3oool02P3oool01@000000oooo0?ooo`3oool000000080oooo0P00000X0?oo
o`030000003oool0oooo00L0oooo0_l000020?ooo`;o00000`3oool010000000ooooo`000?l00002
0?ooo`030000003oool0oooo0540oooo001B0?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool01P3oool00ol00000oooo0?ooo`020?ooo`03o`00003oool0oooo00<0oooo00?o00000?oo
o`3oool0303oool2000000040?ooo`000000oooo000002X0oooo00<000000?ooool000000ol00002
0?ooo`;o00002@3oool00`000000ooooo`0000030?ooo`030000003oool0oooo0540oooo001C0?oo
o`8000001@3oool00`000000oooo0?ooo`0=0?ooo`03o`00003oool0oooo0180oooo0`00000W0?oo
o`Co000000<000000?ooo`3oool03`3oool01ol0000000000?ooo`3ooooo00000?ooo`000000E03o
ool005<0oooo0P0000060?ooo`030000003oool0oooo00P0oooo0_l000020?ooo`;o00004`3oool4
000001@0oooo00?o00000?ooo`3oool01@3oool2o`000080oooo1?l000050?ooo`030000003oool0
oooo00l0oooo00?o00000?ooo`0000000P3oool00ol00000oooo0000001D0?ooo`00D`3oool00`00
0000oooo000000050?ooo`030000003oool0oooo00X0oooo0ol0000C0?ooo`030000003oool00000
0080oooo0`00000A0?ooo`?o00000`3oool2o`0000d0oooo00<000000?ooo`3oool03P3oool01?l0
0000oooo0?ooo`0000020?ooo`03o`00003oool0000005@0oooo001D0?ooo`8000001P3oool00`00
0000oooo0?ooo`0:0?ooo`Co00000P3oool4o`000080oooo1?l000020?ooo`06o`00000000000000
o`00003oool000001?l00000103oool00000000000000002o`0000<0oooo1?l000020?ooo`Co0000
503oool00`000000oooo0?ooo`0A0?ooo`060000003oool0ooooo`00003oool00000E03oool005@0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0:0?ooo`03o`00003ooooo000000h0
oooo0P0000050?ooo`030000003oool0oooo00D0oooo0`00000;0?ooo`03o`00003oool0oooo0140
oooo00<000000?ooo`3oool02`3oool2o`0000@0oooo00?o00000?ooo`0000000P3oool00`000000
oooo0?ooo`1C0?ooo`00E03oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo
00Ko00000?ooo`3ooooo00000?ooool0000<0?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool0203oool3000000P0oooo00?o00000?ooo`3oool04@3oool00`000000oooo0?ooo`0:0?oo
o`03o`00003oool0oooo00@0oooo00?o00000?ooo`0000000P3oool00`000000oooo0?ooo`1C0?oo
o`00E03oool00`000000oooo000000070?ooo`030000003oool0oooo00D0oooo00Go00000?ooo`3o
ool0ooooo`0000040?ooo`03o`00003oool0oooo00D0oooo0P0000080?ooo`030000003oool0oooo
00/0oooo0`0000040?ooo`03o`00003oool0oooo0180oooo00<000000?ooo`3oool04`3oool01000
003o00000?ooo`00001E0?ooo`00E@3oool2000000L0oooo00<000000?ooo`3oool0103oool00ol0
0000oooo0?ooo`080?ooo`03o`00003oool0oooo0080oooo0P00000:0?ooo`030000003oool0oooo
00h0oooo0`0000000`3ooooo00000?ooo`0B0?ooo`030000003oool0oooo00P0oooo00?o00000?oo
o`3oool02@3oool01000003o00000?ooo`00001E0?ooo`00E@3oool2000000P0oooo00<000000?oo
o`3oool03`3oool01?l00000oooo0?ooo`00000<0?ooo`030000003oool0oooo0140oooo0`00000B
0?ooo`030000003oool0oooo00L0oooo00?o00000?ooo`3oool01P3oool02?l00000oooo0?ooo`3o
ool00000o`00003oool00000E@3oool005D0oooo0P0000080?ooo`050000003oool0oooo0?ooool0
00001`3oool00ol00000oooo0?ooo`040?ooo`8000003P3oool00`000000oooo0?ooo`0C0?ooo`<0
00003`3oool00`000000oooo0?ooo`060?ooo`03o`00003oool0oooo00L0oooo00Oo00000?ooo`3o
ool0oooo00000?l00000000005H0oooo001F0?ooo`030000003oool0oooo00L0oooo00@000000?oo
o`3ooooo00001`3oool00ol00000oooo0?ooo`020?ooo`8000000P3oool2o`0000`0oooo00<00000
0?ooo`3oool04@3oool00ol00000oooo0?ooo`020?ooo`<000002`3oool00`000000oooo0?ooo`0@
0?ooo`03o`00003oool0oooo0080oooo00<000000?ooo`000000EP3oool005H0oooo00<000000?oo
o`3oool01`3oool00`000000ooooo`0000090?ooo`04o`00003oool0oooo000000H0oooo00?o0000
0?ooo`3oool02@3oool00`000000oooo0?ooo`0A0?ooo`03o`00003oool0oooo00D0oooo0`000008
0?ooo`030000003oool0oooo00@0oooo00?o00000?ooo`3oool03P3oool00`000000oooo0000001F
0?ooo`00EP3oool2000000T0oooo00<000000?ooo`3oool0203oool00ol0000000000000000C0?oo
o`030000003oool0oooo0140oooo00?o00000?ooo`3oool0203oool3000000D0oooo00<000000?oo
o`3oool00`3oool00ol00000oooo0?ooo`0@0?ooo`800000EP3oool005L0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`070?ooo`800000303oool00ol00000oooo0?ooo`070?ooo`03
0000003oool0oooo0100oooo00?o00000?ooo`3oool02`3oool3000000030?ooo`000000oooo00@0
oooo00?o00000?ooo`3oool02@3oool00ol00000oooo0?ooo`050?ooo`800000EP3oool005L0oooo
0P0000060?ooo`04o`00003oool0oooo000000L0oooo00<000000?ooo`3oool03@3oool00ol00000
oooo0?ooo`060?ooo`030000003oool0oooo0240oooo3`0000040?ooo`03o`00003oool0oooo00D0
oooo00<000000?ooo`3oool0E@3oool005L0oooo0P0000050?ooo`05o`00003oool0oooo0?ooo`00
00001@3oool2000000<0oooo00?o00000?ooo`3oool02`3oool00ol00000oooo0?ooo`050?ooo`03
0000003oool0oooo0280oooo00@000000?ooool0003o00002P3oool=000005L0oooo001G0?ooo`03
0000003oool0oooo00<0oooo00?o00000?ooo`3oool00`3oool00`000000oooo0?ooo`02000000D0
oooo00?o00000?ooo`3oool03P3oool2o`0000<0oooo00<000000?ooo`3oool0403oool00ol00000
oooo0?ooo`0>0?ooo`030000003ooooo000000l0oooo00?o00000?ooo`3oool0103oool00`000000
oooo0?ooo`1G0?ooo`00F03oool00`000000oooo0?ooo`080?ooo`030000003oool0000000P0oooo
00?o00000?ooo`3oool03`3oool01?l00000oooo0?ooo`00000B0?ooo`03o`00003oool0oooo00d0
oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`1H0?ooo`00F03oool00`000000oooo
0?ooo`070?ooo`@000006`3oool01?l00000oooo0?ooo`00000A0?ooo`03o`00003oool0oooo00d0
oooo00<000000?ooo`3oool03P3oool00ol00000oooo0?ooo`030?ooo`800000F`3oool005P0oooo
00@000000?ooo`3ooooo00000P3oool4000000@0oooo00<000000?ooo`3oool06`3oool00`000000
oooo0?ooo`0?0?ooo`03o`00003oool0oooo00`0oooo00<00000o`00003oool03`3oool00ol00000
oooo0?ooo`020?ooo`800000G03oool005T0oooo00<00000o`00000000000P0000090?ooo`030000
003oool0oooo00D0oooo00?o00000?ooo`3oool04@3oool00ol000000000o`00000N0?ooo`030000
003oool0oooo00l0oooo00?o00000?ooo`3oool00P3oool2000005d0oooo001I0?ooo`8000003@3o
ool00`000000oooo0?ooo`040?ooo`03o`00003oool0oooo0180oooo00<000000?ooool000007@3o
ool00`000000oooo0?ooo`0?0?ooo`03o`00003oool0oooo00<00000GP3oool005/0oooo0`00000;
0?ooo`030000003oool0oooo00@0oooo00?o00000?ooo`3oool04@3oool00`000000oooo0?ooo`0?
0?ooo`03o`00003oool0oooo00P0oooo00?o00000?ooo`000000503oool00`000000oooo0000001O
0?ooo`00G03oool3000000/0oooo00<000000?ooo`3oool00`3oool00ol00000oooo0?ooo`0B0?oo
o`050000003oool0oooo0?ooool00000303oool00ol00000oooo0?ooo`070?ooo`03o`00003oool0
000001@0oooo00<000000?ooo`000000H03oool005h0oooo0P00000;0?ooo`030000003oool0oooo
01L0oooo00<000000?ooo`3oool00P3oool00ol00000oooo0?ooo`090?ooo`03o`00003oool0oooo
00H0oooo00Co00000?ooo`3oool000004@3oool01Ol0000000000000003oool000000640oooo001O
0?ooo`80000000<0oooo000000000000203oool00`000000oooo0?ooo`0F0?ooo`030000003oool0
oooo00<0oooo00?o00000?ooo`3oool0203oool00ol00000oooo0?ooo`080?ooo`030000003oool0
oooo0100oooo00@000000?ooo`3oool00000HP3oool00640oooo00@000000?ooo`3oool00000203o
ool00`000000oooo0?ooo`020?ooo`03o`00003oool0oooo0100oooo00<000000?ooo`3oool0503o
ool01Ol00000oooo0?ooo`3oool000000180oooo00@000000?ooo`3oool00000H`3oool00680oooo
00<000000?ooo`3oool02@3oool01@000000oooo0?ooo`3ooooo000001<0oooo00<000000?ooo`3o
ool01@3oool2o`0000/0oooo00?o00000?ooo`3oool00P3oool00`000000oooo0?ooo`0?0?ooo`04
0000003oool0oooo000006@0oooo001S0?ooo`8000000P3oool3000000D0oooo00D000000?ooo`3o
ool0ooooo`00000B0?ooo`030000003oool0oooo00L0oooo00?o00000?ooo`3oool01`3oool00ol0
0000oooo0?ooo`020?ooo`030000003oool0oooo00h0oooo0P0000020?ooo`030000003oool0oooo
06<0oooo001U0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool010000000
oooo0?ooool0000B0?ooo`030000003oool0oooo00`0oooo00?o00000?ooo`3oool01P3oool00`00
0000oooo0?ooo`0>0?ooo`050000003ooooo00000?ooo`000000IP3oool006H0oooo0P0000090?oo
o`030000003oool0oooo0180oooo00<000000?ooo`3oool02P3oool3o`0000030?ooool0003o0000
00D0oooo00<000000?ooo`3oool03@3oool01@000000oooo0?ooool00000000006L0oooo001X0?oo
o`030000003oool0oooo0080oooo0P0000030?ooo`030000003oool0oooo0140oooo00<000000?oo
o`3oool02`3oool5o`000080oooo0_l000000`000000oooo0?ooo`0<0?ooo`8000000P3oool00ol0
000000000?ooo`1W0?ooo`00J@3oool2000000@0oooo00H000000?ooo`3oool0oooo00000?l0000B
0?ooo`030000003oool0oooo0080oooo1?l000030?ooo`03o`00003ooooo000000H0oooo00<00000
0?ooool000000`3oool3o`0000<0oooo0ol0000010000000oooo0?ooool00002000006T0oooo001[
0?ooo`030000003oool0oooo00@0oooo0`00000=0?ooo`;o00000P3oool01?l000000000o`000?l0
000:0?ooo`03o`00003oool0oooo00D0oooo00<000000?ooo`3oool02`3oool01@000000oooo0?oo
o`3oool0000006/0oooo001/0?ooo`8000001P3oool2000000@0oooo1?l000020?ooo`;o00001@3o
ool00`000000oooo0?ooo`0:0?ooo`03o`00003oool0oooo00@0oooo00<000000?ooo`3oool02P3o
ool200000080oooo0P00001/0?ooo`00KP3oool00`000000oooo0?ooo`040?ooo`03o`000000003o
000000l0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0:0?ooo`050000003oool0
oooo0?ooo`000000KP3oool006l0oooo0P0000060?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool03`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00800000K`3oool0
0740oooo00<000000?ooo`3oool0103oool2000000h0oooo00<000000?ooo`3oool0203oool00ol0
0000oooo0?ooo`030?ooo`030000003oool0oooo00P0oooo0P0000020?ooo`030000003oool0oooo
06l0oooo001b0?ooo`8000001@3oool2000000d0oooo00<000000?ooo`3oool0203oool00ol00000
oooo0?ooo`020?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool00P00001b0?ooo`00
M03oool00`000000oooo0?ooo`030?ooo`800000303oool00`000000oooo0?ooo`070?ooo`03o`00
003oool0oooo00<0oooo00<000000?ooo`3oool01`3oool010000000oooo0?ooo`00001d0?ooo`00
M@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0
1`3oool00ol00000oooo0?ooo`020?ooo`030000003oool0oooo00H0oooo0P0000000`3oool00000
0000001e0?ooo`00MP3oool2000000@0oooo0P00000;0?ooo`030000003oool0oooo00X0oooo00<0
00000?ooo`3oool01P3oool010000000oooo0?ooo`00001g0?ooo`00N03oool00`000000oooo0?oo
o`020?ooo`8000002P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00D0oooo00@0
00000?ooo`0000000000N03oool007T0oooo0P0000030?ooo`8000002@3oool00`000000oooo0?oo
o`050?ooo`05o`00003oool0oooo0?ooo`0000001P3oool2000000030?ooo`000000oooo07T0oooo
001k0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`050?ooo`04o`00003oool0oooo000000H0oooo00@000000?ooo`0000000000N`3oool007`0oooo
0P0000030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool01Ol00000oooo
0?ooo`3oool0000000D0oooo00<000000?ooo`000000O@3oool007h0oooo00D000000?ooo`3oool0
oooo000000070?ooo`030000003oool0oooo00<0oooo00Co00000?ooo`3oool000001@3oool30000
07h0oooo001o0?ooo`8000000P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool00P3oool300000800oooo00210?ooo`040000003oool0oooo000000D0
oooo00<000000?ooo`3oool01@3oool010000000oooo0?ooo`3oool300000840oooo00220?ooo`80
000000<0oooo0000003oool00`3oool00`000000oooo0?ooo`020?ooo`03o`00003oool0000000<0
oooo0P0000230?ooo`00Q03oool3000000@0oooo00H000000?ooo`3oool0ooooo`00000000020?oo
o`<00000Q03oool008D0oooo00<000000?ooo`0000000`3oool01`000000oooo0?ooool00000oooo
0000003oool00P0000260?ooo`00QP3oool300000080oooo00H000000?ooo`3oool0oooo0000003o
ool2000008L0oooo00280?ooo`80000000@0oooo0000003oool0oooo0`0000290?ooo`00R@3oool3
00000004o`00003oool00000000008X0oooo002;0?ooo`<00000S03oool008`0oooo00<000000?oo
o`3oool0R`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool0
0?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool0
0?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool0
0?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool0
0?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool0
0?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool0
0?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool0
0?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool0
0?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool0
0?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool0
0?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool0
0?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool0
0?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool0
0?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00001\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-5.00005*^-6, -5.00005*^-6, \
0.00355875, 0.00355875}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.0025 w
[ .01 .012 ] 0 setdash
.4104 .57603 m
.5704 .56684 L
s
.4104 .57603 m
.55806 .45048 L
s
.44521 .41961 m
.4104 .57603 L
s
.34205 .4116 m
.4104 .57603 L
s
.30586 .5282 m
.4104 .57603 L
s
.33127 .64347 m
.4104 .57603 L
s
.4409 .687 m
.4104 .57603 L
s
.56177 .66998 m
.4104 .57603 L
s
.55806 .45048 m
.72174 .53604 L
s
.55806 .45048 m
.5704 .56684 L
s
.63136 .38822 m
.55806 .45048 L
s
.5 .27523 m
.55806 .45048 L
s
.44521 .41961 m
.55806 .45048 L
s
.5704 .56684 m
.72174 .53604 L
s
.56177 .66998 m
.5704 .56684 L
s
.44521 .41961 m
.5 .27523 L
s
.34205 .4116 m
.44521 .41961 L
s
.63136 .38822 m
.72174 .53604 L
s
.67212 .35366 m
.63136 .38822 L
s
.5 .27523 m
.63136 .38822 L
s
.56177 .66998 m
.72174 .53604 L
s
.56177 .66998 m
.4409 .687 L
s
.56177 .66998 m
.5 .75807 L
s
.56177 .66998 m
.64223 .66726 L
s
.34205 .4116 m
.5 .27523 L
s
.30586 .5282 m
.34205 .4116 L
s
.35775 .3327 m
.34205 .4116 L
s
.24533 .45861 m
.34205 .4116 L
s
.67212 .35366 m
.72174 .53604 L
s
.64223 .66726 m
.72174 .53604 L
s
.0035 w
[ ] 0 setdash
.716 .46862 m
.72174 .53604 L
s
.68501 .60355 m
.72174 .53604 L
s
.0025 w
[ .01 .012 ] 0 setdash
.5 .27523 m
.67212 .35366 L
s
.35775 .3327 m
.5 .27523 L
s
.0035 w
[ ] 0 setdash
.56576 .2919 m
.5 .27523 L
s
.42762 .30083 m
.5 .27523 L
s
.0025 w
[ .01 .012 ] 0 setdash
.4409 .687 m
.33127 .64347 L
s
.5 .75807 m
.4409 .687 L
s
.24533 .45861 m
.30586 .5282 L
s
.33127 .64347 m
.30586 .5282 L
s
.0035 w
[ ] 0 setdash
.33127 .64347 m
.24533 .45861 L
s
.33127 .64347 m
.34491 .63198 L
s
.5 .75807 m
.33127 .64347 L
s
.64223 .66726 m
.5 .75807 L
s
.64223 .66726 m
.68501 .60355 L
s
.35775 .3327 m
.42762 .30083 L
s
.24533 .45861 m
.35775 .3327 L
s
.716 .46862 m
.67212 .35366 L
s
.62321 .39544 m
.67212 .35366 L
s
.56576 .2919 m
.67212 .35366 L
s
.62321 .39544 m
.716 .46862 L
s
.68501 .60355 m
.716 .46862 L
s
.56576 .2919 m
.62321 .39544 L
s
.42762 .30083 m
.56576 .2919 L
s
.5 .75807 m
.34491 .63198 L
s
.5 .75807 m
.42176 .56672 L
s
.5 .75807 m
.57206 .60573 L
s
.68501 .60355 m
.5 .75807 L
s
.24533 .45861 m
.42762 .30083 L
s
.24533 .45861 m
.40739 .41207 L
s
.34491 .63198 m
.24533 .45861 L
s
.42176 .56672 m
.24533 .45861 L
s
.68501 .60355 m
.62321 .39544 L
s
.68501 .60355 m
.57206 .60573 L
s
.42762 .30083 m
.62321 .39544 L
s
.40739 .41207 m
.42762 .30083 L
s
.42176 .56672 m
.34491 .63198 L
s
.57206 .60573 m
.62321 .39544 L
s
.57206 .60573 m
.42176 .56672 L
s
.40739 .41207 m
.62321 .39544 L
s
.42176 .56672 m
.40739 .41207 L
s
.42176 .56672 m
.62321 .39544 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.1,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016R000`400?l00000o`00003oo`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00R`3oool4000008/0oooo00280?ooo`<000000ol0
0000103oool000000000000000280?ooo`00Q@3oool300000080oooo00?o00000?ooo`3oool00_l0
00030?ooo`@00000Q03oool00880oooo0`0000060?ooo`03o`00003ooooo000000D0oooo00<00000
0?ooo`3oool0100000200?ooo`00O`3oool3000000D0oooo00Go00000?ooo`3oool0ooooo`000005
0?ooo`04o`00003oool0oooo000000D0oooo0`00001m0?ooo`00O03oool3000000L0oooo00Go0000
0?ooo`3oool0ooooo`0000070?ooo`03o`00003oool0oooo00/00000NP3oool007T0oooo0`000000
0`3oool00000000000030?oooa<000001@3oool01P000000oooo0?ooo`3oool000000?ooo`800000
N03oool007L0oooo2`00000<0?ooo`03o`00003oool0oooo00h0oooo00@000000?ooo`3oool00000
M`3oool007D0oooo100000000`3oool00000000000060?ooo`03o`00003oool0oooo00X0oooo00?o
00000?ooo`3oool00`3oool2o`0000H0oooo0`0000030?ooo`800000M@3oool00780oooo1@000000
0`3oool000000?ooo`020?ooo`8000000`3oool00ol00000oooo0?ooo`050?ooo`03o`00003oool0
oooo00/0oooo00?o00000?ooo`3oool01@3oool2000000@0oooo0P00001c0?ooo`00L03oool30000
00030?ooo`000000oooo0080oooo00<000000?ooo`3oool00`3oool200000003o`00003oool0oooo
00H0oooo00?o00000?ooo`3oool0303oool00ol00000oooo0?ooo`060?ooo`@000000P3oool20000
0740oooo001^0?ooo`<000000P3oool01@000000oooo0?ooo`3oool0000000P0oooo0P0000060?oo
o`03o`00003oool0oooo01H0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0
oooo06h0oooo001/0?ooo`8000000`3oool2000000@0oooo00<000000?ooo`3oool0103oool01?l0
0000oooo0?ooo`3oool2000000@0oooo00?o00000?ooo`3oool01@3oool00ol00000oooo0?ooo`07
0?ooo`03o`00003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool2000006h0oooo001Z0?oo
o`<000000`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00?o00000?oo
o`3oool0103oool2000000X0oooo00?o00000?ooo`3oool0203oool00ol00000oooo0?ooo`040?oo
o`030000003oool0oooo00<0oooo0`0000000`3oool000000000001/0?ooo`00I`3oool4000000@0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`020?ooo`03o`00003oool0oooo00L0
oooo0P0000090?ooo`03o`00003oool0oooo00P0oooo00?o00000?ooo`3oool0103oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00800000JP3oool006D0oooo0`0000060?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool0303oool01?l00000oooo00000000000J0?ooo`03
0000003oool0oooo00L0oooo1000001X0?ooo`00I03oool2000000L0oooo00<000000?ooo`3oool0
1P3oool010000000oooo0?ooool0000<0?ooo`04o`00003oool0oooo0?ooo`8000004`3oool00ol0
0000oooo0?ooo`020?ooo`030000003oool0oooo00T0oooo00<000000?ooo`000000I`3oool006@0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`070?ooo`030000003ooooo000000`0
oooo00?o00000?ooo`3oool0103oool2000000@0oooo00?o00000?ooo`3oool02`3oool00ol00000
oooo0?ooo`020?ooo`030000003oool0oooo00/0oooo0P00001U0?ooo`00H`3oool00`000000oooo
0?ooo`040?ooo`8000002P3oool00`00003o00000?ooo`0E0?ooo`8000000P3oool00ol00000oooo
0?ooo`0<0?ooo`05o`00003oool0oooo0?ooo`0000003@3oool4000006<0oooo001R0?ooo`030000
0?l00000oooo00@0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0G0?ooo`800000
00<0ooooo`00003oool04@3oool00`000000oooo0?ooo`0=0?ooo`<00000H@3oool00640oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`090?ooo`03o`00003oool0000000d0oooo00?o
00000?ooo`3oool02`3oool3000000h0oooo0_l000020?ooo`030000003oool0oooo00l0oooo0P00
001O0?ooo`00H03oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00T0oooo00?o0000
0?ooo`0000003P3oool00ol00000oooo0?ooo`0>0?ooo`8000003P3oool00ol00000oooo0000000B
0?ooo`800000GP3oool005l0oooo00D000000?ooo`3oool0ooooo`0000020?ooo`030000003oool0
oooo00T0oooo00Co00000?ooo`3oool000003@3oool00ol00000oooo0?ooo`0A0?ooo`8000003@3o
ool00ol00000oooo0000000B0?ooo`800000G@3oool005h0oooo00<000000?ooo`3oool00P3oool0
0ol0000000000000000?0?ooo`030000003oool0oooo00/0oooo00?o00000?ooo`3oool03P3oool0
0ol00000oooo0?ooo`020?ooo`8000003@3oool00`000000oooo0?ooo`0?0?ooo`0300000?l00000
000005d0oooo001M0?ooo`030000003oool0oooo0080oooo00?o00000000003oool02`3oool00ol0
0000oooo0?ooo`020?ooo`030000003oool0oooo01`0oooo00?o00000?ooo`3oool0103oool20000
00/0oooo00?o00000000003oool03P3oool01@00003o00000?ooo`3oool0000005`0oooo001L0?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool02P3oool00ol00000oooo0?ooo`030?oo
o`030000003oool0oooo01d0oooo00?o00000?ooo`3oool01@3oool2000000X0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo05X0oooo001K0?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool02P3oool00ol00000oooo0?ooo`030?ooo`03
0000003oool0oooo00/0oooo00?o00000?ooo`3oool0403oool00ol00000oooo0?ooo`070?ooo`80
00002@3oool00`000000oooo0?ooo`0:0?ooo`0300000?l00000oooo00<0oooo00<000000?ooo`3o
ool0FP3oool005X0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0A0?ooo`030000
003oool0oooo00/0oooo00?o00000?ooo`3oool0703oool2000000P0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo05T0oooo001I0?ooo`030000003o
ool0oooo00<0oooo00@000000?ooo`3ooooo0000203oool00ol00000oooo0?ooo`060?ooo`030000
003oool0oooo00X0oooo00?o00000?ooo`3oool07`3oool2000000H0oooo00<000000?ooool00000
1`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo05T0oooo001I0?ooo`040000003o
ool0oooo0?ooo`8000000`3oool00ol00000oooo0?ooo`050?ooo`03o`00003oool0oooo00L0oooo
00<000000?ooo`3oool02P3oool00ol00000oooo0?ooo`0B0?ooo`03o`00003oool0oooo00`0oooo
0P0000050?ooo`030000003ooooo000000D0oooo00<000000?ooo`3oool01`3oool00ol000000000
0?ooo`1I0?ooo`00F03oool01@000000oooo0?ooo`3oool0000000@0oooo00?o00000?ooo`3oool0
1@3oool00ol00000oooo0?ooo`080?ooo`030000003oool0oooo01l0oooo00?o00000?ooo`3oool0
3P3oool2000000<0oooo00@000000?ooo`3ooooo00000`3oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo05P0oooo001G0?ooo`050000003oool0oooo0?ooo`0000001@3oool00ol00000
oooo0?ooo`0?0?ooo`030000003oool0oooo0240oooo00?o00000?ooo`3oool03`3oool200000080
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo05P0
oooo001F0?ooo`050000003oool0oooo0?ooo`0000002`3oool00ol00000oooo0?ooo`0:0?ooo`03
0000003oool0oooo00X0oooo00?o00000?ooo`3oool0503oool00ol00000oooo0?ooo`0A0?ooo`80
000000D0oooo0000003ooooo00000000000>0?ooo`030000003oool0oooo05L0oooo001E0?ooo`05
0000003oool0oooo0?ooo`0000002`3oool00ol00000oooo0?ooo`0;0?ooo`030000003oool0oooo
00X0oooo00?o00000?ooo`3oool0:P3oool200000003o`000000003o000000h0oooo00<000000?oo
o`3oool0E`3oool005@0oooo00<000000?ooo`3oool00P0000070?ooo`05o`00003oool0oooo0?oo
ool000003P3oool00`000000oooo0?ooo`090?ooo`03o`00003oool0oooo02D0oooo2P0000000`3o
oooo00000?ooo`0<0?ooo`03o`0000000000oooo05L0oooo001C0?ooo`040000003oool0oooo0000
00T0oooo00?o00000?ooo`3oool0403oool00`000000oooo0?ooo`090?ooo`03o`00003oool0oooo
01H0oooo3`0000060?ooo`050000003oool000000?ooo`0000003P3oool00ol0000000000?ooo`1G
0?ooo`00DP3oool010000000oooo0?ooo`00000:0?ooo`03o`00003ooooo000000l0oooo00<00000
0?ooo`3oool0503oool?00000003o`00003oool0oooo0100oooo00Go00000000003oool0oooo0000
00020?ooo`030000003oool0oooo00/0oooo00?o00000000003oool0E`3oool00540oooo00@00000
0?ooo`3oool000002`3oool2o`000100oooo00<000000?ooo`3oool01@3oool?00000100oooo00?o
00000?ooo`3oool03P3oool01ol0000000000?ooo`3oool000000?ooo`0000000P3oool2000000/0
oooo00?o00000?ooo`000000E`3oool00500oooo00@000000?ooo`3oool00000303oool3o`0000d0
oooo2P0000040?ooo`03o`00003oool0oooo01P0oooo00?o00000?ooo`3oool03P3oool01`000000
oooo0?ooo`3oool000000?ooo`000000103oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo05D0oooo001?0?ooo`040000003oool0oooo000000X0oooo00Co00000?ooool0003o00001@3o
ool4o`000080oooo00Co000000000000000000000P3oool00`000000oooo0?ooo`090?ooo`03o`00
003oool0oooo02L0oooo0P0000040?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`1D0?ooo`00C`3oool3000000X0oooo00Ko00000?ooo`3ooooo0000
0?ooool000070?ooo`@000001@3oool01000003o0000o`000?l000020?ooo`Co000000<0ooooo`00
0?l000009`3oool00ol0000000000?ooo`050?ooo`040000003oool0oooo000000D0oooo00<00000
0?ooo`3oool01`3oool00ol00000oooo0000001F0?ooo`00CP3oool2000000/0oooo00Oo00000?oo
o`3oool0ooooo`00003ooooo000000@0oooo0`0000090?ooo`030000003oool0oooo00P0oooo00?o
00000?ooool000006P3oool00ol00000oooo0?ooo`080?ooo`03o`0000000000oooo00D0oooo00D0
00000?ooo`3oool0oooo000000060?ooo`8000001`3oool01?l00000oooo0?ooo`00001E0?ooo`00
C@3oool2000000P0oooo0_l000090?ooo`@00000303oool00`000000oooo0?ooo`070?ooo`03o`00
003oool0oooo00@0oooo0_l0000E0?ooo`03o`00003oool0oooo00P0oooo00<000000?ooo`3oool0
1@3oool01@000000oooo0?ooo`3oool0000000D0oooo00Co00000?ooo`3oool000001`3oool00ol0
0000oooo0000001E0?ooo`00C03oool2000000L0oooo0_l000080?ooo`<00000403oool00`000000
oooo0?ooo`070?ooo`03o`00003oool0oooo00H0oooo00?o00000?ooo`3oool04P3oool00ol00000
oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00D000000?ooo`3oool0oooo000000050?oo
o`05o`00003oool0oooo0?ooo`0000001P3oool00ol00000oooo0000001E0?ooo`00B`3oool20000
00h0oooo100000030?ooo`03o`00003oool0oooo00h0oooo00<000000?ooo`3oool04P3oool4o`00
00h0oooo00?o00000?ooo`3oool01@3oool00ol0000000000?ooo`080?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool00`3oool01?l00000oooo0?ooo`3oool2000000L0oooo00<00000
0?ooo`3oool0DP3oool004X0oooo0P0000050?ooo`;o0000103oool4000000<0oooo00Go00000?oo
o`3oool0ooooo`00000@0?ooo`030000003oool0oooo01P0oooo0ol0000@0?ooo`8000002@3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00?o00000?ooo`3oool00P3oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo0580oooo00190?ooo`030000003oool0oooo
00@0oooo00Co00000?ooo`3oool0oooo0`0000070?ooo`03o`00003oool0oooo0080oooo00?o0000
0?ooo`3oool03@3oool00`000000oooo0?ooo`050?ooo`03o`00003oool0oooo01<0oooo00?o0000
0?ooo`3oool0303oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool02P3oool01@000000oooo0?ooo`3ooooo00000080oooo00<000000?ooo`3oool0D@3o
ool004P0oooo00@000000?ooo`3oool0oooo0_l000020?ooo`@000002@3oool00ol00000oooo0?oo
o`0C0?ooo`030000003oool0oooo00D0oooo00?o00000?ooo`3oool05P3oool3o`0000D0oooo00Co
00000?ooo`3oool00000303oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo
00?o00000?ooo`3oool00P3oool2000000050?ooool00000oooo0?ooo`000000D`3oool004L0oooo
00H000000?ooo`3oool0ooooo`00003oool3000002<0oooo00<000000?ooo`3oool01@3oool00ol0
0000oooo0?ooo`0I0?ooo`03o`00003oool0oooo0080oooo0_l000000`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00ol00000oooo0?ooo`040?oo
o`050000003ooooo00000?ooo`000000D`3oool004H0oooo00<000000?ooo`3oool01000000V0?oo
o`030000003oool0oooo00D0oooo00?o00000?ooo`3oool0703oool3o`00000300000?l00000oooo
00/0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`060?ooo`03o`00003oool0oooo
00@0oooo00D00000o`00003oool0oooo0000001B0?ooo`00A@3oool4000001/0oooo00?o00000?oo
o`3oool0303oool00`000000oooo0?ooo`0U0?ooo`8000000P3oool00ol00000oooo0?ooo`090?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool01@3oool00ol00000oooo0?ooo`050?oo
o`040000003oool0oooo00000580oooo00140?ooo`8000005P3oool00ol00000oooo0?ooo`050?oo
o`03o`00003oool0oooo00`0oooo00<000000?ooo`3oool0903oool01000003o00000?ooool0000=
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool03P3oool2000000030?ooo`000000
oooo0500oooo00140?ooo`<000005@3oool00ol00000oooo0?ooo`060?ooo`03o`00003oool0oooo
00/0oooo00<000000?ooo`3oool08`3oool01@000000oooo0?ooo`3ooooo000000@0oooo0_l00007
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool03@3oool00ol00000oooo0?ooo`02
00000540oooo00150?ooo`@000004P3oool00ol00000oooo0?ooo`0E0?ooo`030000003oool0oooo
00@0oooo00?o00000?ooo`3oool06`3oool00`000000oooo0?ooo`090?ooo`03o`00003oool0oooo
00<0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`03o`00003oool0oooo
00<0oooo00Go00000?ooo`3oool0oooo0000001A0?ooo`00A@3oool010000000oooo0?ooo`3oool2
000002P0oooo00<000000?ooo`3oool0103oool00ol00000oooo0?ooo`0J0?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`060?ooo`03o`00003oool0
oooo00@0oooo00Go00000?ooo`3oool0oooo0000001@0?ooo`00AP3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo01T0oooo00?o00000?ooo`3oool02P3oool00`000000oooo0?ooo`02
0?ooo`03o`00003oool0oooo01T0oooo0P0000060?ooo`03o`00003oool0oooo00L0oooo0ol00000
0`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00?o00000?ooo`3oool01`3oool0
0`000000oooo0?ooo`1>0?ooo`00AP3oool3000000<0oooo0P00000<0?ooo`03o`00003oool0oooo
00X0oooo00?o00000?ooo`3oool02P3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo
00H0oooo00?o00000?ooo`3oool02P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
0140oooo00<000000?ooo`3oool0CP3oool004L0oooo00<000000?ooo`000000103oool00`000000
oooo0?ooo`090?ooo`03o`00003oool0oooo00/0oooo00?o00000?ooo`3oool02@3oool00`000000
oooo0?ooo`0L0?ooo`030000003oool0oooo00L0oooo00?o00000?ooo`3oool02@3oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo00l0oooo0P00001@0?ooo`00A`3oool2000000030?oo
o`000000oooo00<0oooo0P0000080?ooo`03o`00003oool0oooo00`0oooo00?o00000?ooo`3oool0
2@3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00P0oooo00?o00000?ooo`3oool0
2@3oool010000000oooo0?ooo`3oool2o`0000L0oooo00<000000?ooo`3oool0203oool00ol00000
oooo0?ooo`020?ooo`04o`00003oool0000000000500oooo00180?ooo`030000003oool0oooo00H0
oooo0P0000060?ooo`03o`00003oool0oooo01P0oooo00<000000?ooo`3oool00P3oool00ol00000
oooo0?ooo`0D0?ooo`03o`0000000000oooo01H0oooo00<000000?ooo`3oool00`3oool00ol00000
oooo0?ooo`040?ooo`030000003oool0oooo00P0oooo00?o00000?ooo`3oool00P3oool01?l00000
oooo00000000001@0?ooo`00B03oool2000000T0oooo00<000000?ooo`3oool07P3oool00`000000
oooo0?ooo`020?ooo`03o`00003oool0oooo01<0oooo00?o00000000003oool05`3oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo00T0oooo00?o00000?ooo`3oool00P3oool00ol00000
00000000001@0?ooo`00B@3oool01@000000oooo0?ooo`3oool0000000H0oooo0P00000C0?ooo`03
o`00003oool0oooo00P0oooo00D000000?ooo`3oool0ooooo`00000E0?ooo`8000003P3oool00ol0
0000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo0ol000020?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`000000D03oool004T0oooo0P0000020?ooo`030000003oool0oooo00H0
oooo0P0000000ol00000oooo0?ooo`0>0?ooo`03o`00003oool0oooo00P0oooo00<000000?ooo`3o
ool05P3oool00`000000oooo0?ooo`0>0?ooo`03o`00003oool0oooo00L0oooo00<000000?ooo`3o
ool02P3oool00ol00000oooo0000000?0?ooo`030000003oool000000500oooo001:0?ooo`800000
0P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00l0oooo00?o00000?ooo`3oool0
1`3oool00`000000oooo0?ooo`0E0?ooo`0300000?l00000oooo00l0oooo00?o00000?ooo`3oool0
1`3oool00`000000oooo0?ooo`0<0?ooo`0300000?l00000oooo00X0oooo00Ko00000?ooo`3oool0
00000?ooo`00001@0?ooo`00BP3oool2000000/0oooo00Co00000?ooo`00000000003`3oool00ol0
0000oooo0?ooo`070?ooo`030000003oool0oooo01<0oooo00?o00000000003oool04@3oool00ol0
0000oooo0?ooo`060?ooo`030000003oool0oooo00h0oooo00<00000o`00003oool02@3oool01ol0
0000oooo0?ooo`00003o00000?ooo`000000C`3oool004X0oooo00<000000?ooo`000000103oool0
0`000000oooo0?ooo`030?ooo`05o`00003oool0oooo0?ooo`000000603oool010000000oooo0?oo
ool0000B0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool03P3oool00`000000oooo
o`00000:0?ooo`06o`00003oool00000o`00003oool00000C`3oool004/0oooo0P0000040?ooo`03
0000003oool0oooo00P0oooo0P00000G0?ooo`030000003ooooo00000100oooo0P00000M0?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool00P3oool2o`0000L0oooo00D000000?ooool0
0000oooo0000001?0?ooo`00B`3oool00`000000oooo000000040?ooo`030000003oool0oooo00T0
oooo0P00000;0?ooo`03o`00003oool0oooo00L0oooo00<000000?ooool000003`3oool00`00003o
00000?ooo`0M0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool00`3oool00ol00000
oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`000000C`3oool004`0oooo0P0000080?ooo`03
o`00003oool0oooo00L0oooo00<000000?ooo`3oool02@3oool00ol00000oooo0?ooo`060?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool05@3oool00ol00000oooo0?ooo`050?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool0103oool00ol00000oooo0?ooo`030?ooo`05
0000003oool0oooo0?ooo`000000C`3oool004`0oooo00<000000?ooo`0000001`3oool00ol00000
oooo0?ooo`080?ooo`8000002P3oool00ol00000oooo0?ooo`050?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool05P3oool00ol00000oooo0?ooo`050?ooo`030000003oool0oooo0100
oooo00<000000?ooo`3oool01`3oool01Ol00000oooo0?ooo`00003o00000080oooo00<000000?oo
o`3oool0C@3oool004d0oooo00<000000?ooo`0000001@3oool00ol00000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00l0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0H0?ooo`03
o`00003oool0oooo00@0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`080?ooo`04
o`0000000000oooo0?ooo`;o000000<000000?ooo`3oool0C@3oool004d0oooo00<000000?ooo`00
00001@3oool00`00003o0000o`00000<0?ooo`8000003`3oool00`00003o00000?ooo`0:0?ooo`80
00008P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00P0oooo00H000000?ooo`3o
ool0ooooo`000000001?0?ooo`00CP3oool00`000000oooo000000040?ooo`040000003oool0oooo
o`0000d0oooo0P0000060?ooo`03o`00003oool0oooo00@0oooo00<00000o`00003oool02@3oool0
0`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`02o`0000030000003oool0oooo04d0oooo001>0?ooo`030000003oool00000
00D0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`030?ooo`03o`00003oool0oooo
00@0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo
0180oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
04d0oooo001?0?ooo`030000003oool0000000T0oooo0ol0000;0?ooo`800000103oool00ol00000
oooo0?ooo`030?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool07@3oool00ol00000
oooo0?ooo`030?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool01P3oool01`00003o
0000o`000?l00000ooooo`0000000000C`3oool004l0oooo00<000000?ooo`000000303oool00ol0
0000oooo0?ooo`0:0?ooo`8000000P3oool00ol00000oooo0?ooo`030?ooo`030000003oool0oooo
00D0oooo00?o00000000003oool07`3oool00ol00000oooo0?ooo`030?ooo`030000003oool0oooo
01<0oooo00<000000?ooo`3oool00P3oool2o`000080oooo00H000000?ooo`3oool0ooooo`000000
001@0?ooo`00D03oool00`000000oooo000000040?ooo`030000003oool0oooo00L0oooo0_l0000:
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00ol0000000000?ooo`0P
0?ooo`03o`00003oool0oooo0080oooo00<000000?ooo`3oool04`3oool01?l0000000000?ooo`3o
ool2o`0000@0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1>0?ooo`00D03oool0
10000000oooo0?ooo`0000030?ooo`030000003oool0oooo00T0oooo00?o00000?ooo`3oool0203o
ool2000000D0oooo00?o00000000003oool00`3oool200000280oooo00?o00000?ooo`3oool00P3o
ool00`000000oooo0?ooo`0A0?ooo`;o000000<0oooo0000003oool01`3oool01@00003o00000?oo
o`3oool000000540oooo001A0?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool05P3o
ool00`000000oooo0?ooo`020?ooo`03o`0000000000oooo0080oooo00<000000?ooo`3oool09`3o
ool00`000000oooo0?ooo`0;0?ooo`Co00001P3oool00`000000oooo0?ooo`040?ooo`0600000?l0
0000oooo0?ooool000000000D@3oool00540oooo00@000000?ooo`3oool000000P3oool00`000000
oooo0?ooo`0<0?ooo`?o00001`3oool01ol0000000000000003ooooo00000?ooo`0000000P3oool0
0`00003o00000?ooo`0X0?ooo`030000003oool0oooo00D0oooo1?l0000<0?ooo`030000003oool0
oooo00@0oooo00D000000?ooo`3oool0oooo0000001B0?ooo`00DP3oool00`000000oooo0000000D
0?ooo`03o`00003oool0oooo00D0oooo00So00000?ooo`00000000000?ooo`000000oooo000002L0
oooo00Co00000?ooo`3oool00000103oool2o`000180oooo00<000000?ooo`3oool0103oool01@00
0000oooo0?ooo`3oool000000580oooo001B0?ooo`040000003oool0oooo000001H0oooo0_l00003
0?ooo`04o`00003oool0oooo0?ooo`<00000:03oool01?l00000ooooo`00000000020?ooo`;o0000
5@3oool00`000000oooo0?ooo`02o`0000050?ooo`000000ooooo`0000000000D`3oool005<0oooo
00<000000?ooo`000000603oool00ol00000oooo0?ooo`040?ooo`@000006P3oool2o`0000<0oooo
1?l000020?ooo`Co000000<0oooo0000003oool0603oool00`000000ooooo`0000020?ooo`050000
003oool0ooooo`0000000000D`3oool005<0oooo00H000000?ooo`3oool000000?ooo`00000J0?oo
o`04o`000000003o000000000080oooo100000080?ooo`Co00000`3oool3o`0000<0oooo00?o0000
0?ooo`3oool02`3oool01?l00000oooo0?ooo`00000I0?ooo`0300000?l00000oooo0080oooo00@0
00000?ooool000000000E03oool005@0oooo00<000000?ooo`3oool00P00000I0?ooo`03o`000000
003o000000;o000000<000000?ooool000000ol00004000000;o00007@3oool00ol00000oooo0000
000K0?ooo`070000003oool0oooo0?ooo`000000oooo0000001E0?ooo`00E03oool01P000000oooo
0?ooo`000000oooo000001L0oooo00?o000000000?l000000`3oool00`000000oooo0?ooo`070?oo
o`<000006`3oool01?l00000oooo0?ooo`00000I0?ooo`03o`00003oool0000000<0oooo00<00000
0?ooo`000000E@3oool005D0oooo00@000000?ooo`3oool000005`3oool2000000060?ooool00000
oooo0?ooool000000000303oool4000001L0oooo00Co00000?ooo`3oool00000603oool01?l00000
oooo0?ooo`0000030?ooo`800000EP3oool005D0oooo00@000000?ooo`3oool000005P3oool00`00
0000oooo0?ooo`060?ooo`030000003oool0oooo00d0oooo1000000F0?ooo`030000003oool0oooo
01D0oooo00Go00000?ooo`3oool0oooo000000020?ooo`0300000?l00000000005H0oooo001F0?oo
o`040000003oool0oooo000001@0oooo00<000000?ooo`3oool01`3oool00`00003o00000?ooo`0A
0?ooo`@000004@3oool00`000000oooo0?ooo`0K0?ooo`040000003oool00000000005L0oooo001F
0?ooo`040000003oool0oooo000001<0oooo00<000000?ooo`3oool0103oool00ol00000oooo0?oo
o`020?ooo`030000003oool0oooo01@0oooo1000000=0?ooo`030000003oool0oooo01<0oooo00?o
00000?ooo`3oool01@3oool010000000oooo00000000001G0?ooo`00E`3oool010000000oooo0000
0000000A0?ooo`0300000?l00000oooo00D0oooo00?o00000?ooo`3oool00P3oool00`000000oooo
o`000002o`0001H0oooo0`0000080?ooo`03o`00003oool0000001@0oooo00?o00000?ooo`3oool0
1P3oool00`000000oooo0000001H0?ooo`00E`3oool00`000000oooo0?ooo`02000000h0oooo0P00
00090?ooo`05o`00003oool0oooo0?ooo`000000103oool00ol00000oooo0?ooo`0F0?ooo`@00000
103oool00ol00000oooo0000000C0?ooo`03o`00003oool0oooo00P0oooo0P00001H0?ooo`00E`3o
ool01@000000oooo0?ooo`3oool0000000d0oooo00<000000?ooo`3oool02@3oool00ol00000oooo
0?ooo`020?ooo`030000003oool0oooo01h0oooo100000000ol0000000000?ooo`0>0?oooa400000
F@3oool005P0oooo00D000000?ooo`3oool0oooo0000000;0?ooo`030000003oool0oooo00l0oooo
00<000000?ooo`3oool0103oool2o`0001`0oooo4@0000020?ooo`03o`00003oool0oooo00T0oooo
00<00000o`0000000000F@3oool005P0oooo00D000000?ooo`3oool0oooo0000000:0?ooo`030000
0?l00000oooo0140oooo00<000000?ooo`3oool01@3oool00ol00000oooo0?ooo`0J0?ooo`030000
003oool0oooo00h0oooo00?o00000?ooo`3oool02@3oool00`00003o00000000001J0?ooo`00F@3o
ool01@000000oooo0000003oool0000000L0oooo0P00000?0?ooo`03o`00003oool0oooo0080oooo
00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`0>0?ooo`03o`00003oool0oooo00T0oooo
00<000000?ooo`000000F`3oool005T0oooo00D000000?ooo`000000oooo000000060?ooo`030000
003oool0oooo00l0oooo00?o00000?ooo`3oool00`3oool00`000000oooo0?ooo`070?ooo`03o`00
003oool0oooo01H0oooo00<000000?ooo`3oool06@3oool010000000oooo0?ooo`00001K0?ooo`00
FP3oool200000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0@0?ooo`03o`00
003oool0oooo00<0oooo00<000000?ooo`3oool0203oool00ol00000oooo0?ooo`0D0?ooo`030000
0?l00000oooo00d0oooo00?o00000?ooo`3oool0203oool2000000030?ooool00000000005`0oooo
001J0?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool00000o`00000B0?ooo`03o`00
003oool0oooo00<0oooo00<000000?ooo`3oool02@3oool00ol00000oooo0?ooo`0C0?ooo`030000
003oool0oooo00`0oooo00?o00000?ooo`3oool0203oool01@000000oooo0?ooool00000000005d0
oooo001K0?ooo`070000003oool0oooo0?ooo`000000oooo0000000K0?ooo`030000003oool0oooo
01d0oooo00<000000?ooo`3oool0303oool00ol00000oooo0?ooo`080?ooo`060000003oool0oooo
o`00003oool00000G@3oool005/0oooo00<000000?ooo`3oool00P3oool2000001/0oooo00<00000
0?ooo`3oool02`3oool3o`0000l0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo05`0oooo001L0?ooo`040000003oool0oooo00000080oooo00<00000
0?ooo`3oool04P3oool00ol00000oooo0?ooo`040?ooo`030000003oool0oooo00d0oooo00?o0000
0?ooo`3oool0303oool00`000000oooo0?ooo`090?ooo`03o`00003oool0oooo00T0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`1M0?ooo`00G03oool010000000oooo00000?l00003
0?ooo`030000003oool0oooo0140oooo00?o00000?ooo`3oool0103oool00`000000oooo0?ooo`0K
0?ooo`030000003ooooo000000T0oooo00?o00000?ooo`3oool02@3oool00`000000oooo0?ooo`02
0?ooo`03o`0000000000oooo05h0oooo001M0?ooo`8000001@3oool00`000000oooo0?ooo`0A0?oo
o`03o`00003oool0oooo00<0oooo00<000000?ooo`3oool03`3oool3o`0000T0oooo00<000000?oo
ool00000203oool00ol00000oooo0?ooo`080?ooo`8000001@3oool00`000000oooo0?ooo`1N0?oo
o`00G`3oool00`000000oooo0?ooo`030?ooo`8000004@3oool00ol00000oooo0?ooo`040?ooo`03
0000003oool0oooo0140oooo00?o00000?ooo`3oool01@3oool010000000oooo0?ooool0000B0?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool0G`3oool00600oooo100000030?ooo`03
0000003oool0oooo01D0oooo00<000000?ooo`3oool06@3oool010000000oooo0?ooool000050?oo
o`03o`00003oool0oooo00T0oooo00<000000?ooo`3oool0103oool00ol0000000000?ooo`1P0?oo
o`00HP3oool00`000000oooo000000030?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3o
ool04`3oool01Ol00000oooo0?ooo`3oool0000000P0oooo00?o00000?ooo`3oool02@3oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo0600oooo001S0?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool03@3oool00ol00000oooo0?ooo`040?ooo`030000003oool0oooo01@0
oooo00Co00000?ooo`3oool000001`3oool00ol00000oooo0?ooo`090?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool0H@3oool006@0oooo0P0000020?ooo`<000003P3oool00ol00000
oooo0?ooo`040?ooo`030000003oool0oooo01D0oooo00?o00000000003oool00`3oool00ol00000
oooo0?ooo`0;0?ooo`8000001`3oool00ol0000000000?ooo`1R0?ooo`00IP3oool010000000oooo
0?ooo`3oool3000000d0oooo00?o00000?ooo`3oool0103oool00`000000oooo0?ooo`0E0?ooo`03
0000003ooooo00000080oooo0_l0000;0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3o
ool0HP3oool006L0oooo0P0000040?ooo`<000002P3oool00ol00000oooo0?ooo`040?ooo`030000
003oool0oooo01@0oooo00@000000?ooo`3oool0oooo0ol000060?ooo`;o00000`3oool00`00003o
0000o`0000030?ooo`?o00000P00001U0?ooo`00J@3oool00`000000oooo0?ooo`020?ooo`030000
003oool000000140oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`06o`000080oooo
0_l000040?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0I@3oool006X0oooo0P00
00030?ooo`040000003oool0oooo0?ooo`<00000303oool00`000000oooo0?ooo`0?0?ooo`?o0000
00<000000?ooo`3oool00`3oool00ol00000oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo
0P00001X0?ooo`00K03oool010000000oooo0?ooo`3oool2000000@0oooo00<000000?ooo`3oool0
0P3oool00ol00000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo0_l000020?ooo`Co0000
1@3oool00`000000oooo0?ooo`020?ooo`03o`00003oool0oooo00P0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`1X0?ooo`00K@3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo00H0oooo00?o00000?ooo`3oool01@3oool00`00003o0000o`0000020?ooo`;o0000303o
ool00`000000oooo0?ooo`0<0?ooo`8000001P3oool2000006/0oooo001^0?ooo`8000000`3oool0
0`000000oooo0?ooo`030?ooo`8000001Ol000020?ooo`03o`0000000000oooo0140oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo06/0oooo001`0?oo
o`050000003oool0oooo0?ooo`0000001P3oool00ol00000oooo0?ooo`060?ooo`030000003oool0
oooo00l0oooo00D000000?ooo`3oool0ooooo`0000080?ooo`030000003oool0oooo00@0oooo0P00
001^0?ooo`00L@3oool200000080oooo00<000000?ooo`3oool0103oool00ol00000oooo0?ooo`05
0?ooo`030000003oool0oooo00h0oooo00D000000?ooo`3oool0ooooo`0000080?ooo`030000003o
ool0oooo00<0oooo0P00001`0?ooo`00L`3oool00`000000oooo0?ooo`02000000`0oooo00<00000
0?ooo`3oool03P3oool010000000oooo0?ooool000080?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool0L03oool007@0oooo0P0000020?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00P0oooo0P000004
0?ooo`800000L`3oool007H0oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo07<0oooo001g0?ooo`040000003oool0oooo000000D0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`0:0?ooo`040000003oool0ooooo`0000H0oooo00<0
00000?ooo`3oool00P3oool2000007H0oooo001h0?ooo`80000000<0oooo0000000000002@3oool0
0`000000oooo0?ooo`0:0?ooo`040000003oool0ooooo`0000D0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`1f0?ooo`00NP3oool010000000oooo0?ooo`0000090?ooo`030000003o
ool0oooo00P0oooo00@000000?ooo`3ooooo00001@3oool010000000oooo0?ooo`3oool2000007T0
oooo001k0?ooo`80000000<0oooo0000003oool00P3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0000007/0
oooo001m0?ooo`030000003oool0000000<0oooo00D000000?ooo`3oool0oooo000000090?ooo`03
0000003oool0oooo00@0oooo0P0000020?ooo`800000O03oool007h0oooo00<000000?ooo`000000
0`3oool01@000000oooo0?ooo`3oool0000000P0oooo00<000000?ooool000000`3oool01@000000
oooo0?ooo`3oool0000007h0oooo001o0?ooo`@000001@3oool00`000000oooo0?ooo`050?ooo`03
0000003ooooo000000<0oooo00<000000?ooo`3oool00P00001o0?ooo`00P@3oool00`000000oooo
000000050?ooo`030000003oool0oooo00@0oooo00<00000o`00003oool00P3oool010000000oooo
0?ooo`0000210?ooo`00PP3oool3000000050?ooo`000000oooo0?ooo`0000001@3oool00`000000
oooo0?ooo`020?ooo`040000003oool0000000000880oooo00240?ooo`80000000@0oooo0000003o
ool000001@3oool00`000000oooo0?ooo`04000008@0oooo00250?ooo`@0000000<0oooo0000003o
ool00`3oool01@000000oooo0000003oool0000008H0oooo00270?ooo`80000000<0oooo0000003o
ool00P3oool00`00003o000000000002000008L0oooo00280?ooo`@000000P3oool3000008T0oooo
00290?ooo`<0000000@0oooo0000000000000000RP3oool008/0oooo00<000000?ooo`000000S03o
ool008`0oooo00<000000?ooo`3oool0R`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo
6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo
6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo
6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo
6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo
6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo
6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo
6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo
6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo
6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo
6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo
6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo
6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo
6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00001\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-5.00005*^-6, -5.00005*^-6, \
0.00355875, 0.00355875}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.0025 w
[ .01 .012 ] 0 setdash
.44775 .57999 m
.60159 .5619 L
s
.44775 .57999 m
.58364 .44545 L
s
.46794 .42283 m
.44775 .57999 L
s
.35769 .4228 m
.44775 .57999 L
s
.32577 .53944 m
.44775 .57999 L
s
.34815 .65113 m
.44775 .57999 L
s
.46544 .68902 m
.44775 .57999 L
s
.58904 .66657 m
.44775 .57999 L
s
.46794 .42283 m
.58364 .44545 L
s
.46794 .42283 m
.5 .27523 L
s
.35769 .4228 m
.46794 .42283 L
s
.58364 .44545 m
.74166 .52177 L
s
.58364 .44545 m
.60159 .5619 L
s
.64158 .37749 m
.58364 .44545 L
s
.5 .27523 m
.58364 .44545 L
s
.60159 .5619 m
.74166 .52177 L
s
.58904 .66657 m
.60159 .5619 L
s
.35769 .4228 m
.5 .27523 L
s
.32577 .53944 m
.35769 .4228 L
s
.35163 .34488 m
.35769 .4228 L
s
.23786 .47638 m
.35769 .4228 L
s
.23786 .47638 m
.32577 .53944 L
s
.34815 .65113 m
.32577 .53944 L
s
.58904 .66657 m
.74166 .52177 L
s
.58904 .66657 m
.46544 .68902 L
s
.58904 .66657 m
.5 .75807 L
s
.58904 .66657 m
.6535 .66048 L
s
.5 .27523 m
.64158 .37749 L
s
.5 .27523 m
.66091 .33986 L
s
.35163 .34488 m
.5 .27523 L
s
.0035 w
[ ] 0 setdash
.53891 .28721 m
.5 .27523 L
s
.39764 .30851 m
.5 .27523 L
s
.0025 w
[ .01 .012 ] 0 setdash
.64158 .37749 m
.74166 .52177 L
s
.66091 .33986 m
.64158 .37749 L
s
.46544 .68902 m
.34815 .65113 L
s
.5 .75807 m
.46544 .68902 L
s
.0035 w
[ ] 0 setdash
.66091 .33986 m
.74166 .52177 L
s
.70295 .45406 m
.74166 .52177 L
s
.67321 .59397 m
.74166 .52177 L
s
.6535 .66048 m
.74166 .52177 L
s
.0025 w
[ .01 .012 ] 0 setdash
.34815 .65113 m
.23786 .47638 L
s
.0035 w
[ ] 0 setdash
.34815 .65113 m
.33849 .63976 L
s
.5 .75807 m
.34815 .65113 L
s
.35163 .34488 m
.39764 .30851 L
s
.23786 .47638 m
.35163 .34488 L
s
.6535 .66048 m
.5 .75807 L
s
.6535 .66048 m
.67321 .59397 L
s
.70295 .45406 m
.66091 .33986 L
s
.57329 .3878 m
.66091 .33986 L
s
.53891 .28721 m
.66091 .33986 L
s
.23786 .47638 m
.39764 .30851 L
s
.23786 .47638 m
.3694 .42043 L
s
.33849 .63976 m
.23786 .47638 L
s
.38944 .5721 m
.23786 .47638 L
s
.53891 .28721 m
.57329 .3878 L
s
.39764 .30851 m
.53891 .28721 L
s
.38944 .5721 m
.33849 .63976 L
s
.5 .75807 m
.33849 .63976 L
s
.5 .75807 m
.38944 .5721 L
s
.5 .75807 m
.54266 .6027 L
s
.67321 .59397 m
.5 .75807 L
s
.39764 .30851 m
.57329 .3878 L
s
.3694 .42043 m
.39764 .30851 L
s
.57329 .3878 m
.70295 .45406 L
s
.67321 .59397 m
.70295 .45406 L
s
.67321 .59397 m
.57329 .3878 L
s
.67321 .59397 m
.54266 .6027 L
s
.3694 .42043 m
.57329 .3878 L
s
.38944 .5721 m
.3694 .42043 L
s
.38944 .5721 m
.57329 .3878 L
s
.54266 .6027 m
.38944 .5721 L
s
.54266 .6027 m
.57329 .3878 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.1,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016R000`400?l00000o`00003ooooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00R_ooool5o`0008_ooooo0027ooooo`?o000000D0
0000o`00000000000000ooooo`04o`0008Oooooo0024ooooo`?o00001?ooool01000003ooooo0000
00000003ooooo`0400000?l0003o0000o`0008Cooooo0021ooooo`?o000000?ooooo000000000000
1?ooool00`00003oooooooooo`03ooooo`0300000?oooooooooo00Go0000POooool007gooooo1?l0
0003ooooo`0500000?ooooooooooooooo`0000000_ooool00`00003oooooo`000006o`0000?ooooo
00Co000000000?l0003o0000Ooooool007[ooooo0ol00003ooooo`8000001?ooool7o`0000;ooooo
00D00000oooooooooooooooo00000004ooooo`03o`000000003ooooo00?o0000O?ooool007Oooooo
0ol00004ooooo`8000001_l000000`00003oooooooooo`06ooooo`0300000?oooooooooo00Kooooo
00?o0000ooooo`0000000oooool2o`0007[ooooo001dooooo`?o00000_ooool7o`00013ooooo00<0
0000ooooooooool00oooool00`00003oooooo`000004ooooo`<000000_l0001hooooo`00LOooool8
o`000003ooooo`000000000000Sooooo00<00000ooooooooool00oooool00`00003oooooooooo`03
ooooo`0300000?oooooooooo00Cooooo00<00000ooooool000001_ooool01000003oooooo`000?l0
001fooooo`00K_ooool4o`0000Oooooo00<00000ooooooooool01oooool00`00003oooooooooo`04
ooooo`0300000?oooooooooo00_ooooo00<00000o`000?ooool02?ooool01000003o0000o`000?l0
001cooooo`00KOooool01?l0003oooooo`000?ooool2o`0000;ooooo0P00000;ooooo`0300000?oo
oooooooo00Gooooo00<00000ooooooooool03?ooool00ol0003oooooooooo`0:ooooo`0300000?l0
003o0000077ooooo001/ooooo`04o`000?oooooo0000o`0000?ooooo0ol0000Dooooo`0300000?oo
oooooooo00Cooooo00<00000ooooooooool01_ooool00ol0000000000000000<ooooo`;o0000Kooo
ool006[ooooo0_l000000ooooooo0000o`000004ooooo`0300000?oooooooooo00;o00006_ooool0
0`00003oooooooooo`05ooooo`04o`000?oooooooooo000000gooooo0ol0001/ooooo`00JOooool0
1_l0003oooooooooool0003oooooo`00008000001oooool2o`0000Kooooo00<00000ooooooooool0
4?ooool00`00003oooooooooo`04ooooo`03o`000?oooooooooo017ooooo0_l0001Zooooo`00J?oo
ool01ol0003oooooooooool0003ooooo00000?l000002oooool3o`0000;ooooo00<00000oooooooo
ool01oooool00`00003oooooooooo`0?ooooo`03o`000?oooooooooo00;ooooo00<00000oooooooo
ool02oooool2000000;o0000J?ooool006Oooooo00Co0000oooooooooooo00000oooool00ol0003o
ooooooooo`0<ooooo`;o00002_ooool00`00003oooooooooo`0?ooooo`03o`000?oooooooooo00?o
oooo00<00000ooooooooool03Oooool00`00003o0000o`00001Vooooo`00IOooool2o`0000;ooooo
00Go000000000?ooooooooooo`00000Aooooo`;o00001oooool00`00003oooooooooo`0@ooooo`03
o`000?oooooooooo00Cooooo00<00000ooooooooool03oooool3o`0006?ooooo001Tooooo`05o`00
0?ooooooooooooooool000001?ooool00ol0003oooooooooo`0;ooooo`0300000?oooooooooo00?o
oooo0_l00005ooooo`0300000?oooooooooo00Wooooo00<00000ooooooooool01Oooool00ol0003o
ooooooooo`0Hooooo`;o0000HOooool006?ooooo00Go000000000000003oooooo`000005ooooo`03
o`000?oooooooooo00[ooooo00<00000ooooooooool01_ooool3o`0000kooooo00<00000oooooooo
ool01Oooool00ol0003oooooooooo`06ooooo`0300000?oooooooooo013ooooo0_l0001Pooooo`00
H_ooool01Ol000000000oooooooooooo000000Kooooo00?o0000ooooooooool02Oooool00`00003o
ooooooooo`0:ooooo`;o00003Oooool00`00003oooooooooo`05ooooo`03o`000?oooooooooo00Ko
oooo00<00000ooooooooool03Oooool2o`000003ooooool0003ooooo05oooooo001Rooooo`04o`00
0?ooooooooooo`0000Kooooo00?o0000ooooooooool06Oooool2o`0001?ooooo00?o0000oooooooo
ool01oooool00`00003oooooooooo`0:ooooo`;o00000_ooool00`00003oooooo`00001Oooooo`00
HOooool01?l000000000ooooool00007ooooo`03o`000?oooooooooo00Sooooo00<00000oooooooo
ool03Oooool00`00003oooooooooo`02o`00017ooooo00?o0000ooooooooool04oooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo05gooooo001Pooooo`04o`000?ooool00000o`0000So
oooo00?o0000ooooooooool02?ooool00`00003oooooooooo`0=ooooo`0300000?oooooooooo00;o
oooo0ol00008ooooo`0300000?oooooooooo00Cooooo00?o0000ooooooooool02Oooool2000000Go
oooo0_l00007ooooo`;o0000G_ooool005oooooo00Co0000oooooooooooo00002Oooool00ol0003o
ooooooooo`07ooooo`0300000?oooooooooo00kooooo00<00000ooooooooool01Oooool2o`0000Ko
oooo00<00000ooooooooool01?ooool00ol0003oooooooooo`0;ooooo`0300000?oooooooooo00;o
00002_ooool00ol0003oooooooooo`1Looooo`00G_ooool01?l0003oooooooooool00009ooooo`03
o`000?oooooooooo00Oooooo00<00000ooooooooool06Oooool2o`0000Gooooo00<00000oooooooo
ool00oooool00ol0003oooooooooo`0<ooooo`;o00001oooool00`00003oooooooooo`02ooooo`03
o`000?oooooooooo05cooooo001Mooooo`04o`000?ooooooooooo`0000[ooooo00?o0000oooooooo
ool09Oooool3o`0000;ooooo00<00000ooooooooool01?ooool00ol0003oooooooooo`09ooooo`;o
00000_ooool00`00003oooooooooo`04ooooo`0300000?oooooooooo00;ooooo0_l0001Mooooo`00
G?ooool01?l0003oooooooooool00003ooooo`0300000?oooooooooo00Gooooo00?o0000oooooooo
ool01Oooool00`00003oooooooooo`0Pooooo`;o00001oooool00ol0003oooooooooo`07ooooo`;o
00001Oooool00`00003oooooooooo`02ooooo`0300000?oooooooooo00Cooooo00?o0000oooooooo
ool0Foooool005cooooo00?o0000ooooool000001?ooool00`00003oooooooooo`05ooooo`03o`00
0?oooooooooo00Cooooo00<00000ooooooooool04Oooool00`00003oooooooooo`0?ooooo`;o0000
1Oooool00ol0003oooooooooo`05ooooo`;o00002?ooool00`00003oooooooooo`08ooooo`;o0000
G?ooool005_ooooo00?o0000ooooool000001Oooool00`00003oooooooooo`04ooooo`03o`000?oo
oooooooo00Cooooo00<00000ooooooooool04_ooool00`00003oooooooooo`0Aooooo`;o00001?oo
ool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool0F_oo
ool005[ooooo00?o0000ooooool000003Oooool00ol0003oooooooooo`0Iooooo`0300000?oooooo
oooo017ooooo00<00000ooooool000000_l000000ooooooo0000ooooo`02ooooo`;o00003_ooool0
0`00003oooooooooo`06ooooo`;o0000Foooool005Wooooo00?o0000ooooool000003_ooool00ol0
003oooooooooo`02ooooo`0300000?oooooooooo02Wooooo00@00000oooooooooooooooo0_l00000
0ooooooo0000o`00000?ooooo`8000002?ooool2o`0005_ooooo001Hooooo`03o`000?oooooo0000
00oooooo00Go0000oooooooooooooooo0000000_ooooo`Go00003oooool01000003oooooooooo`00
0008ooooo`;o0000F_ooool005Oooooo00?o0000ooooool000002Oooool00`00003oooooooooo`03
ooooo`05o`000?ooooooooooooooo`000000:_ooool6o`0000;ooooo0_l000000ooooooo0000o`00
000Iooooo`;o0000F_ooool005Kooooo00?o0000ooooool000002_ooool00`00003oooooooooo`03
ooooo`03o`000?oooooooooo01Wooooo00<00000ooooooooool02_ooool6o`0000Cooooo00D00000
oooooooooooo0000ooooo`02o`0000;ooooo0_l00009ooooo`0300000?oooooooooo00_ooooo00?o
0000ooooool00000FOooool005Gooooo00Co0000oooooooooooo00002_ooool00`00003ooooooooo
o`03ooooo`03o`000?oooooooooo01Wooooo00<00000ooooooooool01Oooool5o`0000[ooooo00<0
0000ooooool000000_ooool2o`0000Cooooo0_l00006ooooo`0300000?oooooooooo00Gooooo00<0
0000ooooooooool01Oooool2o`0005Wooooo001Eooooo`03o`000?oooooo000000_ooooo00<00000
ooooooooool00oooool00ol000000000ooooo`0Hooooo`0300000?oooooooooo00Ko00004?ooool0
1?l0003oooooooooool00002ooooo`03o`000?oooooooooo00?ooooo0_l00003ooooo`0300000?oo
oooooooo00Oooooo00<00000ooooooooool01?ooool2o`0005Wooooo001Dooooo`03o`000?oooooo
0000017ooooo00?o000000000?ooool05_ooool6o`0001Gooooo00Go0000ooooo`00003oooooo`00
0002ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool02oooool00`00003ooooooooo
o`04ooooo`;o0000F?ooool005?ooooo00?o0000ooooool000004_ooool00ol0003oooooooooo`0@
ooooo`Ko00006_ooool00ol0003oooooooooo`02ooooo`05o`000?ooooooooooooooool000001ooo
ool2o`0001;ooooo0_l0001Hooooo`00D_ooool00ol0003oooooo`00000?ooooo`0500000?oooooo
ooooooooool000003?ooool6o`0001oooooo00?o0000ooooooooool00oooool01Ol0003ooooooooo
oooooooo000000Oooooo00@00000ooooool0003o00004?ooool00ol0003oooooo`00001Gooooo`00
DOooool00ol0003oooooo`00000@ooooo`0500000?ooool00000ooooool000001oooool5o`0000oo
oooo00<00000ooooooooool04_ooool00ol0003oooooooooo`03ooooo`0300000?l0003ooooo00?o
oooo00?o0000ooooooooool00oooool00`00003oooooooooo`02ooooo`;o00002Oooool00`00003o
ooooooooo`03ooooo`;o0000Eoooool0053ooooo00?o0000ooooool000004Oooool200000004oooo
ool0003oooooooooo`Ko00005?ooool00`00003oooooooooo`0Aooooo`03o`000?oooooooooo00Co
oooo00<00000o`000?ooool00oooool00ol0003oooooooooo`02ooooo`0300000?oooooooooo00Go
oooo0_l00007ooooo`0300000?oooooooooo00?ooooo00?o0000ooooool00000E_ooool004oooooo
00?o0000ooooool000004_ooool2000000Co000010000002ooooo`@000000oooool3000000?ooooo
10000002ooooo`03o`00000000000000017ooooo00?o0000ooooooooool01_ooool00ol0003ooooo
ooooo`03ooooo`03o`000?oooooooooo00_ooooo0_l00006ooooo`0300000?oooooooooo00;ooooo
00?o0000ooooool00000E_ooool004oooooo0_l0000Booooo`?o000000?oooooo`000?ooool06_oo
ool01000003oooooooooo`00000?ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0
1?ooool00ol0003oooooooooo`0=ooooo`;o00002_ooool00ol0003oooooo`00001Eooooo`00C_oo
ool2o`00013ooooo00@00000o`000?l0003ooooo0P0000000ooooooo0000ooooo`0Jooooo`030000
0?oooooooooo00?ooooo10000008ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
1Oooool00ol000000000ooooo`0>ooooo`;o00002?ooool00ol0003oooooo`00001Eooooo`00COoo
ool2o`0000oooooo0ol00002ooooo`0500000?ooool00000ooooool000006oooool00`00003ooooo
ooooo`09ooooo`@0000000?oooooo`000?ooool02Oooool01?l0003oooooooooo`000004ooooo`03
o`000?oooooooooo013ooooo0_l00002ooooo`0300000?oooooooooo00;ooooo00?o0000ooooool0
0000E?ooool004cooooo0_l0000<ooooo`8000000_l0000:ooooo`03o`000?oooooooooo02Sooooo
00?o0000ooooo`0000000`000006ooooo`04o`000?oooooooooo000000?ooooo00<00000ooooool0
00004oooool01?l0003oooooooooo`000003ooooo`03o`000?oooooo000005Cooooo001;ooooo`;o
00003?ooool3o`0000cooooo00?o0000ooooooooool09oooool00ol0003oooooooooo`06ooooo`<0
000000?oooooo`000?ooool00_ooool00`00003oooooooooo`02ooooo`03o`000?oooooooooo01;o
oooo0_l000001oooool00000oooooooooooo0000ooooool00000E?ooool004[ooooo0_l0000;oooo
o`;o00003_ooool00`00003o0000ooooo`0Wooooo`03o`000?oooooooooo00[ooooo00<00000o`00
0?ooool00`0000001Ol0003ooooooooooooooooo000001Kooooo0_l00003ooooo`03o`000?oooooo
000005?ooooo0019ooooo`;o00002Oooool3o`0000_ooooo00<00000ooooooooool00_ooool00`00
003o0000ooooo`0Hooooo`0300000?oooooooooo00_ooooo00?o0000ooooooooool03?ooool00ol0
003oooooooooo`02ooooo`03o`000000003ooooo00;ooooo00?o0000ooooooooool05Oooool2o`00
0004ooooool0003oooooo`0005?ooooo0018ooooo`;o00002?ooool2o`00000300000?oooooooooo
00_ooooo00<00000ooooooooool00oooool00ol0003oooooooooo`0Gooooo`0300000?oooooooooo
00[ooooo00?o0000ooooooooool03?ooool02Ol0003oooooooooooooool00000ooooo`00003ooooo
00000002ooooo`03o`000?oooooooooo01Kooooo00<00000o`000?l000000_ooool00ol0003ooooo
ooooo`1@ooooo`00B?ooool00ol0003oooooooooo`04ooooo`0300000?l0003o0000013ooooo00<0
0000ooooooooool00oooool00ol0003oooooooooo`0Gooooo`0300000?oooooooooo00Wooooo00?o
0000ooooooooool03Oooool01?l0003oooooooooo`000002ooooo`0300000?oooooooooo00;ooooo
00<00000o`000?ooool05_ooool01P00003oooooooooool0003oooooo`0005;ooooo0017ooooo`03
o`000?oooooooooo00?ooooo0ol0000Hooooo`03o`000?oooooooooo02;ooooo00?o0000oooooooo
ool03_ooool00ol0003ooooo00000009ooooo`03o`000000003ooooo01Kooooo00<00000ooooool0
00000_ooool00ol0003oooooooooo`1?ooooo`00A_ooool00ol0003oooooooooo`02ooooo`;o0000
7?ooool00ol000000000ooooo`0Pooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool0
2_ooool00ol000000000ooooo`0Gooooo`;o000000?oooooo`000?ooool0D?ooool004Gooooo00?o
0000ooooooooool00ol000000`00003oooooooooo`0Kooooo`03o`000?ooool0000001oooooo00?o
0000ooooooooool04?ooool00ol0003oooooooooo`0:ooooo`04o`000?ooooooooooooooo`800000
4oooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo04kooooo0014ooooo`04o`000?oo
oooo0000o`00008000005oooool00`00003oooooooooo`05ooooo`04o`000?oooooooooo000001Co
oooo00<00000ooooooooool01_ooool00ol0003oooooooooo`0@ooooo`0300000?l0003ooooo00Co
oooo00<00000ooooooooool01Oooool00ol0003oooooooooo`02ooooo`0300000?oooooooooo013o
oooo00Ko000000000?oooooo0000ooooool0001@ooooo`00@oooool3o`0001_ooooo00<00000oooo
ooooool01Oooool00ol0003oooooooooo`0Eooooo`0300000?oooooooooo00Gooooo00?o0000oooo
ooooool04?ooool00`00003oooooo`000005ooooo`0300000?oooooooooo00Gooooo00?o0000oooo
ooooool05Oooool01?l0003ooooo00000?ooool2o`00053ooooo0012ooooo`;o00007?ooool00`00
003oooooooooo`06ooooo`03o`000?oooooooooo01Gooooo00<00000ooooooooool01?ooool00ol0
003oooooooooo`0Booooo`03o`000?oooooooooo00Gooooo00<00000ooooooooool01Oooool00ol0
003oooooooooo`04ooooo`<000003Oooool01ol0003oooooooooo`00003o0000ooooool00000Cooo
ool004;ooooo00?o000000000?l000009?ooool01Ol0003oooooooooooooool0000001Wooooo00?o
0000ooooooooool04?ooool01000003oooooooooool00007ooooo`0300000?oooooooooo00Gooooo
00?o0000ooooooooool01oooool00`00003oooooooooo`0:ooooo`03o`000?oooooooooo00;ooooo
0_l0001?ooooo`00@oooool01?l000000000o`000?l0000Rooooo`05o`000?ooooooooooooooo`00
00006?ooool00ol0003oooooooooo`0@ooooo`0500000?ooooooooooooooool000004?ooool00ol0
003oooooooooo`09ooooo`0300000?oooooooooo00Kooooo00?o0000ooooooooool00oooool00ol0
003oooooo`00001>ooooo`00A?ooool00ol0003oooooooooo`02o`0001Kooooo00<00000oooooooo
ool02?ooool01Ol0003oooooooooooooool0000001Kooooo00?o0000ooooooooool04?ooool00`00
003oooooooooo`02ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool02_ooool00`00
003oooooooooo`05ooooo`03o`000?oooooooooo00?ooooo00<00000o`000?l00000C_ooool004Co
oooo00?o0000ooooooooool00P0000000ol0003oooooooooo`0Cooooo`0300000?oooooooooo00So
oooo00?o0000ooooooooool00_ooool00`00003oooooooooo`0?ooooo`0400000?ooooooooooo`00
01Sooooo00?o0000ooooooooool01Oooool00`00003oooooooooo`07ooooo`03o`000?oooooooooo
00[ooooo00<00000ooooooooool01?ooool00ol0003oooooooooo`04ooooo`0300000?l0003o0000
04gooooo0015ooooo`05o`000?ooooooooooooooo`0000000_l0000Booooo`0300000?oooooooooo
00Wooooo00?o0000ooooooooool05?ooool00`00003oooooo`00000Iooooo`03o`000?oooooooooo
00Gooooo00<00000ooooooooool01oooool00ol0003oooooooooo`0=ooooo`<0000000?oooooo`00
0?ooool01_ooool2o`0004gooooo0015ooooo`03o`000?oooooooooo00;ooooo00<00000ooooool0
00004Oooool00`00003oooooooooo`09ooooo`03o`000?oooooooooo01?ooooo00<00000ooooool0
00004_ooool00`00003oooooooooo`04ooooo`03o`000?oooooooooo00Oooooo00<00000oooooooo
ool01oooool00ol0003oooooooooo`0?ooooo`0300000?l0003ooooo00Oooooo0_l0001<ooooo`00
A_ooool00ol0003oooooooooo`04ooooo`;o00006oooool00ol0003oooooooooo`03ooooo`030000
0?oooooooooo00gooooo00<00000o`000?ooool04Oooool00`00003oooooooooo`05ooooo`03o`00
0?oooooooooo00Oooooo00<00000ooooooooool01oooool00ol0003oooooooooo`0?ooooo`03o`00
0?oooooooooo00Oooooo0_l0001<ooooo`00Aoooool00ol0003oooooooooo`02ooooo`<000000_l0
000Iooooo`03o`000?oooooooooo00Cooooo00<00000ooooooooool03?ooool00ol0003ooooooooo
o`0@ooooo`0300000?oooooooooo00Kooooo00?o0000ooooooooool04_ooool00ol0003ooooooooo
o`0>ooooo`03o`000?oooooooooo008000001Oooool00`00003o0000o`00001;ooooo`00Aoooool0
0ol0003oooooooooo`05ooooo`0300000?oooooo000000_ooooo00<00000ooooooooool02_ooool0
0ol0003oooooooooo`05ooooo`0300000?oooooooooo00[ooooo00?o0000ooooooooool06_ooool0
0ol0003oooooooooo`0Booooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool00_ooool0
0`00003oooooooooo`03ooooo`;o0000Boooool004Sooooo00?o0000ooooooooool01oooool2o`00
00Wooooo00<00000ooooooooool02oooool00ol0003oooooooooo`0@ooooo`03o`000?ooool00000
013ooooo00<00000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`0300000?oooooooooo
00Wooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo
04Wooooo0019ooooo`03o`000?oooooooooo00Gooooo0P0000000ooooooo0000ooooo`07ooooo`03
00000?oooooooooo00_ooooo00?o0000ooooooooool03oooool01?l0003oooooooooo`00000?oooo
o`0300000?oooooooooo00Wooooo00?o0000ooooooooool01oooool00`00003oooooooooo`09oooo
o`03o`000?oooooooooo00gooooo00?o0000ooooooooool01Oooool3000000;ooooo00?o0000oooo
ooooool0B?ooool004Wooooo00?o0000ooooooooool01oooool01000003oooooo`000?l00006oooo
o`0300000?oooooooooo00_ooooo00?o0000ooooooooool01Oooool00`00003oooooooooo`06oooo
o`04o`000?oooooooooo000000oooooo00<00000ooooooooool02_ooool00ol0003oooooooooo`08
ooooo`0300000?oooooooooo00Wooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`09
ooooo`0300000?oooooo000004[ooooo001:ooooo`03o`000?oooooooooo00Oooooo00<00000oooo
ooooool00_l0000Booooo`03o`000?oooooooooo00Gooooo00<00000ooooooooool01Oooool01Ol0
003oooooooooooooool0000001_ooooo00?o0000ooooooooool02Oooool00`00003oooooooooo`09
ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool200000003o`000?oooooo
oooo04Oooooo001;ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool03oooool00ol0
003oooooooooo`06ooooo`0300000?oooooooooo00?ooooo00?o0000ooooooooool03oooool00`00
003oooooooooo`0<ooooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`08ooooo`80000000?ooooo00000?l00000BOooool004_ooooo00?o0000oooooooo
ool02?ooool300000004ooooool0003o0000000000kooooo00?o0000ooooooooool01oooool01@00
003ooooooooooooooooo0000017ooooo00<00000ooooooooool03Oooool00ol0003oooooooooo`0F
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool01?ooool2000000Cooooo00<00000
o`000?ooool0BOooool004cooooo00?o0000ooooooooool02_ooool01000003oooooooooool0000>
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool01?ooool00`00003oooooooooo`08
ooooo`0300000?oooooooooo00kooooo00?o0000ooooooooool02Oooool00`00003oooooooooo`0;
ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool00_ooool2000000Gooooo00<00000
o`000?ooool0B_ooool004cooooo00?o000000000?ooool03?ooool01000003oooooo`000?l0000=
ooooo`03o`000?oooooooooo00Oooooo00<00000o`000?ooool01_ooool00`00003oooooooooo`0I
ooooo`03o`000?oooooooooo00Wooooo00<00000ooooooooool02oooool00ol0003oooooooooo`08
ooooo`04o`000?ooool00000000000Wooooo0_l0001;ooooo`00COooool00ol000000000ooooo`0;
ooooo`05o`00000000000000ooooool000003?ooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00Kooooo00<00000ooooooooool06Oooool00ol0003oooooooooo`0:ooooo`0300000?oo
oooooooo00_ooooo00?o0000ooooooooool01oooool00ol000000000ooooo`08ooooo`0300000?l0
003o000004cooooo001>ooooo`03o`000?oooooooooo00[ooooo00Go0000ooooooooool00000oooo
o`02o`0000[ooooo00?o0000ooooooooool01_ooool00ol0003ooooo00000007ooooo`0300000?oo
oooooooo00Kooooo00<00000ooooooooool04?ooool00ol0003oooooooooo`0:ooooo`0300000?oo
oooooooo00_ooooo00Co0000oooooooooooooooo10000002ooooo`03o`000?oooooooooo00Oooooo
00<00000o`000?l00000COooool004kooooo00?o0000ooooooooool04?ooool00`00003o0000o`00
0008ooooo`03o`000?oooooooooo00Gooooo00Go0000oooooooooooooooo0000000>ooooo`030000
0?oooooooooo013ooooo00?o0000ooooooooool06Oooool00ol000000000ooooo`07ooooo`03o`00
0?oooooooooo00Kooooo00@00000o`000?oooooo0000COooool004oooooo00?o0000ooooooooool0
4_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
4?ooool00`00003oooooooooo`0Aooooo`03o`000?oooooooooo01Oooooo0P0000000ooooooo0000
ooooo`07ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooool00000C_ooool0053ooooo00?o
0000ooooooooool04_ooool2o`00008000000oooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo00Wooooo00<00000ooooooooool06Oooool00ol0003oooooooooo`0;ooooo`0300000?oo
oooooooo00Gooooo0P000005ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?oo
ool00`00003oooooo`000002ooooo`03o`000?oooooooooo04cooooo001@ooooo`03o`000000003o
oooo00Wooooo00<00000ooooooooool02?ooool00ol0003ooooo00000002ooooo`03o`000?oooooo
oooo00;ooooo00?o0000ooooooooool01_ooool01@00003oooooooooooooool0000000Gooooo00<0
0000ooooooooool04oooool00ol0003oooooooooo`0;ooooo`0300000?oooooooooo00?ooooo0P00
0008ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00oooool00`00003oooooo`00
0002ooooo`03o`000?oooooooooo04gooooo001Aooooo`03o`000?oooooooooo00Sooooo00<00000
ooooooooool02Oooool2o`0000?ooooo00Co000000000?oooooo00002Oooool01@00003ooooooooo
ooooool0000000Cooooo00<00000ooooooooool05?ooool00ol0003oooooooooo`0;ooooo`04o`00
000000000000000000cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`02ooooo`03
00000?oooooo000000;ooooo00?o0000ooooooooool0C_ooool0057ooooo00?o0000ooooooooool0
2?ooool00`00003oooooooooo`0;ooooo`;o000000Coooooo`000?oooooo00002oooool01000003o
ooooooooo`000003ooooo`0300000?oooooooooo01Gooooo00?o0000ooooooooool01Oooool40000
01?ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`03ooooo`05o`000?oooooooooo
ooooool00000D?ooool005;ooooo00?o000000000?ooool05oooool3o`0000?ooooo0`00000Soooo
o`80000000?o0000ooooo`0000000`000008ooooo`0300000?oooooooooo00kooooo00?o0000oooo
ooooool00oooool01_l0003oooooooooo`00003oooooo`0000?ooooo00?o0000ooooooooool0Cooo
ool005?ooooo00?o0000ooooooooool05oooool3o`0000Gooooo00<00000ooooooooool06?ooool4
000000;ooooo0P0000000ooooooo0000ooooo`0=ooooo`0300000?oooooooooo00oooooo00Go0000
ooooooooooooooooo`000002ooooo`0300000?oooooo000000?ooooo00?o0000ooooooooool0D?oo
ool005?ooooo00?o000000000?ooool05oooool00ol0003oooooooooo`05o`0000?ooooo0`000002
ooooo`03o`0000000000000000Gooooo0P000003ooooo`<000003?ooool00ol0003oooooooooo`0<
ooooo`0300000?oooooooooo00oooooo00Wo0000ooooooooooooooooo`000?ooool00000ooooool0
00001?ooool00ol0003oooooooooo`1@ooooo`00E?ooool00ol0003oooooooooo`06ooooo`030000
0?oooooooooo00cooooo00?o0000ooooool000001_ooool5o`000004ooooo`00003oooooo`0000<0
00000_ooool2000001Cooooo00?o0000ooooooooool03?ooool00`00003oooooooooo`0@ooooo`04
o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`1Aoooo
o`00EOooool00ol0003oooooooooo`05ooooo`0300000?oooooooooo00_ooooo00Co0000oooooooo
oooo00002oooool5o`00000300000?oooooooooo01Oooooo00?o0000ooooooooool07oooool01_l0
003oooooooooool0003oooooo`0000Cooooo00?o0000ooooooooool0D_ooool005Gooooo00?o0000
00000?ooool01_ooool00`00003oooooooooo`09ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool02Oooool01000003oooooooooooooool5o`0001Gooooo00?o0000ooooooooool08?oo
ool01?l000000000o`000?l00005ooooo`03o`000?oooooooooo05;ooooo001Fooooo`03o`000?oo
oooooooo017ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`07ooooo`0300000?oo
oooooooo00Oooooo1?l0000Aooooo`03o`000?oooooooooo023ooooo0ol00005ooooo`03o`000?oo
oooooooo05?ooooo001Fooooo`03o`000000003ooooo013ooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`04ooooo`8000001Oooool00`00003oooooooooo`02ooooo`8000000oooool5
o`0000cooooo00?o0000ooooooooool03?ooool00`00003oooooooooo`0<ooooo`Oo00001Oooool0
0ol0003oooooooooo`1Dooooo`00Eoooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo
00Kooooo00?o0000ooooooooool00_ooool00`00003oooooooooo`05ooooo`0300000?oooooooooo
00Cooooo00<00000ooooooooool01Oooool5o`0000Kooooo00?o0000ooooooooool03Oooool00`00
003oooooo`00000<o`0000Cooooo00?o0000ooooool000001Oooool00ol0003oooooooooo`1Doooo
o`00F?ooool00ol0003oooooooooo`03ooooo`0300000?oooooooooo00Kooooo00?o0000oooooooo
ool01oooool01Ol0003oooooooooooooool0000000Sooooo00<00000ooooooooool04Oooool5o`00
0003ooooool0003ooooo00Cooooo3?l0000?ooooo`0500000?l0003oooooooooool000001?ooool0
0ol0003oooooooooo`1Eooooo`00F?ooool00ol0003oooooooooo`03ooooo`0300000?oooooooooo
00Kooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09ooooo`0300000?oooooooooo
00Oooooo0P00000=ooooo`Oo00006_ooool01@00003o0000oooooooooooo000000Gooooo00?o0000
ooooooooool0EOooool005Wooooo00?o0000ooooooooool00oooool00`00003oooooooooo`04oooo
o`03o`000?oooooooooo00Wooooo00<00000o`000?ooool05Oooool00`00003oooooooooo`0;oooo
o`03o`000?oooooooooo01cooooo00<00000o`000?ooool00_ooool00ol0003oooooooooo`02oooo
o`03o`000?oooooooooo05Kooooo001Jooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool02Oooool00`00003oooooo`00000Gooooo`0300000?oooooooooo00[ooooo00?o0000oooooooo
ool07?ooool00ol0003oooooooooo`02ooooo`05o`000?ooooooooooooooool00000FOooool005[o
oooo00?o000000000?ooool02?ooool00ol0003oooooooooo`08ooooo`0500000?oooooooooooooo
ool000002_ooool00`00003oooooooooo`0<ooooo`0300000?oooooooooo00Kooooo00?o0000oooo
ooooool03Oooool00`00003oooooooooo`0:ooooo`0300000?oooooo000000Cooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`1Gooooo`00Foooool00ol0003oooooooooo`06ooooo`03
o`000?oooooooooo00gooooo00?o0000ooooooooool02?ooool00`00003oooooooooo`0=ooooo`03
00000?oooooooooo00Gooooo00?o0000ooooooooool03Oooool00`00003oooooooooo`09ooooo`03
00000?oooooo000000Gooooo00Go0000ooooooooooooooooo`00001Jooooo`00G?ooool01Ol0003o
ooooooooooooool0000000;ooooo00?o0000ooooooooool01oooool2000000Kooooo00?o0000oooo
ooooool01oooool00`00003oooooooooo`0>ooooo`0300000?oooooooooo00Cooooo00?o0000oooo
ooooool03?ooool00`00003oooooooooo`09ooooo`0300000?oooooo000000Kooooo00Co0000oooo
oooooooo0000Foooool005cooooo00Oo000000000?oooooooooo00000?oooooo000000Sooooo0P00
0008ooooo`03o`000?oooooooooo00Oooooo00<00000ooooooooool05?ooool00ol0003ooooooooo
o`0=ooooo`0300000?oooooooooo00[ooooo00?o0000ooooooooool01?ooool01Ol0003ooooooooo
oooooooo000005_ooooo001Mooooo`06o`000?oooooooooo00000?oooooo00004oooool00ol0003o
ooooooooo`0Jooooo`80000000?oooooo`000?ooool06?ooool00`00003oooooo`000007ooooo`04
o`000?ooooooooooo`0005cooooo001Mooooo`05o`000000003oooooooooool000001_ooool20000
00gooooo00?o0000ooooooooool06oooool00`00003o0000ooooo`0Gooooo`0300000?oooooo0000
00Sooooo00?o0000ooooool00000GOooool005kooooo00?o0000ooooool000001_ooool00`00003o
ooooooooo`0=ooooo`03o`000?oooooooooo00Kooooo00<00000ooooooooool04oooool00ol0003o
ooooooooo`0=ooooo`0300000?oooooooooo00Gooooo00<00000ooooool000002?ooool01?l0003o
ooooooooool0001Mooooo`00Goooool2o`0000Gooooo00<00000ooooooooool03oooool00ol0003o
ooooooooo`05ooooo`0300000?oooooooooo01;ooooo00?o0000ooooooooool00P00000<ooooo`03
00000?oooooooooo00Kooooo00?o0000ooooooooool01oooool00ol0003oooooo`00001Nooooo`00
Goooool00ol000000000o`00000Fooooo`03o`000?oooooooooo00Gooooo00<00000ooooooooool0
4_ooool00ol0003oooooooooo`02ooooo`0300000?oooooooooo00Wooooo00<00000ooooooooool0
1Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooo000005kooooo001Pooooo`03o`000000
003o0000008000005?ooool00ol0003oooooooooo`04ooooo`0300000?oooooooooo01;ooooo00?o
0000ooooooooool03_ooool00`00003oooooooooo`02ooooo`80000000?o0000ooooooooool02?oo
ool00ol0003oooooo`00001Oooooo`00HOooool4o`0001Gooooo00?o0000ooooooooool06?ooool0
0ol0003oooooooooo`05ooooo`8000002oooool00`00003oooooo`00000;ooooo`;o0000H?ooool0
06;ooooo00@00000o`000000003o00005?ooool00ol0003oooooooooo`0Gooooo`03o`000?oooooo
oooo00Sooooo00<00000ooooooooool01oooool00`00003oooooo`00000<ooooo`;o0000H?ooool0
06Cooooo00?o000000000?l000005?ooool00ol0003oooooooooo`03ooooo`0300000?oooooooooo
013ooooo00?o0000ooooooooool02Oooool00`00003oooooooooo`02ooooo`0300000?oooooooooo
00;ooooo00?o0000ooooooooool02_ooool2o`00067ooooo001Uooooo`Co00000P00000@ooooo`03
o`000?oooooooooo00?ooooo00<00000ooooooooool04?ooool00ol0003oooooooooo`0<ooooo`07
00000?ooool00000ooooo`00003oooooo`000009ooooo`80000000?oooooo`000?l00000H_ooool0
06Oooooo00Go0000ooooool0003ooooo0000000@ooooo`03o`000?oooooooooo00;ooooo00<00000
ooooooooool03oooool00ol0003oooooooooo`0>ooooo`<0000000Coooooo`000?oooooooooo1000
0002ooooo`8000000_ooool00ol0003oooooooooo`1Rooooo`00J?ooool3o`0000?ooooo1000000;
ooooo`05o`000?ooooooooooooooo`0000004Oooool00ol0003oooooooooo`0<ooooo`D0000000?o
000000000?ooool02Oooool2o`0006Gooooo001Zooooo`?o00001oooool2000000Oooooo00?o0000
ooooooooool04oooool00ol0003oooooooooo`06ooooo`@000001?ooool00`00003oooooo`00000;
ooooo`03o`000?oooooooooo06Gooooo001[ooooo`03o`000?oooooo000000Sooooo00<00000oooo
ooooool01Oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00;ooooo0P000009oooo
o`0300000?l0003o000000[ooooo0_l0001Xooooo`00K?ooool3o`0000_ooooo0P000002ooooo`05
o`000?ooooooooooooooo`0000003oooool01?l000000000ooooooooool2000000_ooooo00?o0000
ooooooooool02Oooool00ol0003oooooooooo`1Xooooo`00K_ooool3o`0000_ooooo00@00000oooo
oooooooo00000_ooool00`00003oooooooooo`07ooooo`8000000_ooool200000003o`000?oooooo
oooo00cooooo00<00000o`000?ooool02Oooool2o`0006_ooooo001_ooooo`?o00003Oooool01?l0
00000000000000000003ooooo`8000000_ooool2000000Kooooo00?o0000ooooooooool02oooool0
0`00003o0000ooooo`08ooooo`;o0000KOooool0077ooooo0_l0000=ooooo`04o`000?ooool00000
ooooo`8000003?ooool00ol0003oooooooooo`0:ooooo`0300000?l0003ooooo00Sooooo00?o0000
ooooooooool0KOooool007;ooooo0ol0000<ooooo`03o`000000003ooooo00gooooo00?o0000oooo
ooooool02oooool00ol0003oooooooooo`06ooooo`;o0000L?ooool007?ooooo0ol0000;ooooo`03
o`000?ooool0000000gooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`06ooooo`03
o`000?oooooooooo073ooooo001eooooo`;o00002oooool00ol0003ooooo0000000<ooooo`03o`00
0?oooooooooo00Sooooo00<00000o`000?ooool01_ooool2o`0007?ooooo001fooooo`;o00002_oo
ool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00Sooooo00<00000o`000?ooool01_oo
ool00ol0003oooooooooo`1cooooo`00N?ooool2o`0000Wooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`07ooooo`0300000?l0003ooooo00Gooooo0_l0001fooooo`00NOooool2o`00
00Wooooo00?o000000000?ooool02Oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Cooooo00?o0000ooooooooool0M_ooool007[ooooo0_l00008ooooo`03o`000000003ooooo00Wo
oooo00?o0000ooooooooool01Oooool00`00003o0000ooooo`04ooooo`;o0000NOooool007cooooo
0_l00007ooooo`03o`000000003ooooo00Oooooo00?o0000ooooooooool01Oooool00`00003o0000
ooooo`04ooooo`03o`000?oooooooooo07Wooooo001mooooo`;o00001_ooool00ol000000000oooo
o`07ooooo`03o`000?oooooooooo00Cooooo00<00000o`000?ooool00oooool2o`0007cooooo001n
ooooo`;o00001_ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`1looooo`00P?ooool2o`0000Cooooo00?o0000oooo
ooooool01_ooool00ol0003oooooooooo`03ooooo`04o`000?ooooooooooooooo`;o0000Ooooool0
087ooooo0_l00004ooooo`03o`000000003ooooo00Cooooo00?o0000ooooooooool00oooool01Ol0
003ooooooooooooooooo0000087ooooo0023ooooo`03o`000?oooooooooo00;ooooo00?o0000oooo
ooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;o0000P_ooool008Co
oooo0_l00002ooooo`03o`000000003ooooo00?ooooo00Ko0000ooooooooooooooooo`000?ooool2
o`0008Cooooo0025ooooo`;o00000_ooool01Ol0003ooooooooooooooooo000000?ooooo00?o0000
ooooool00000Q_ooool008Oooooo00?o0000ooooool000000oooool00ol0003ooooo00000003o`00
08Oooooo0028ooooo`?o000000@00000ooooool0003ooooo0_l00029ooooo`00R_ooool2o`000004
ooooool0003o0000o`0008[ooooo002;ooooo`?o0000S?ooool008cooooo00?o0000ooooooooool0
Roooool00?oooooo6oooool00?oooooo6oooool00?oooooo6oooool00?oooooo6oooool00?oooooo
6oooool00?oooooo6oooool00?oooooo6oooool00?oooooo6oooool00?oooooo6oooool00?oooooo
6oooool00?oooooo6oooool00?oooooo6oooool00?oooooo6oooool00?oooooo6oooool00?oooooo
6oooool00?oooooo6oooool00?oooooo6oooool00?oooooo6oooool00?oooooo6oooool00?oooooo
6oooool00?oooooo6oooool00?oooooo6oooool00?oooooo6oooool00?oooooo6oooool00?oooooo
6oooool00?oooooo6oooool00?oooooo6oooool00?oooooo6oooool00?oooooo6oooool00?oooooo
6oooool00?oooooo6oooool00?oooooo6oooool00?oooooo6oooool00?oooooo6oooool00?oooooo
6oooool00?oooooo6oooool00?oooooo6oooool00?oooooo6oooool00?oooooo6oooool00?oooooo
6oooool00?oooooo6oooool00?oooooo6oooool00?oooooo6oooool00?oooooo6oooool00?oooooo
6oooool00?oooooo6oooool00?oooooo6oooool00?oooooo6oooool00?oooooo6oooool00?oooooo
6oooool00?oooooo6oooool00?oooooo6oooool00?oooooo6oooool00?oooooo6oooool00?oooooo
6oooool00?oooooo6oooool00?oooooo6oooool00?oooooo6oooool00?oooooo6oooool00?oooooo
6oooool00?oooooo6oooool00?oooooo6oooool00?oooooo6oooool00?oooooo6oooool00?oooooo
6oooool00?oooooo6oooool00?oooooo6oooool00001\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-5.00005*^-6, -5.00005*^-6, \
0.00355875, 0.00355875}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.0025 w
[ .01 .012 ] 0 setdash
.486 .58183 m
.63075 .55515 L
s
.486 .58183 m
.60739 .43861 L
s
.4914 .42433 m
.486 .58183 L
s
.37684 .43254 m
.486 .58183 L
s
.34973 .54914 m
.486 .58183 L
s
.36872 .65777 m
.486 .58183 L
s
.49073 .68996 m
.486 .58183 L
s
.6144 .66191 m
.486 .58183 L
s
.4914 .42433 m
.60739 .43861 L
s
.4914 .42433 m
.5 .27523 L
s
.37684 .43254 m
.4914 .42433 L
s
.60739 .43861 m
.75546 .50603 L
s
.60739 .43861 m
.63075 .55515 L
s
.64786 .36592 m
.60739 .43861 L
s
.5 .27523 m
.60739 .43861 L
s
.37684 .43254 m
.5 .27523 L
s
.34973 .54914 m
.37684 .43254 L
s
.35026 .35716 m
.37684 .43254 L
s
.23889 .49384 m
.37684 .43254 L
s
.63075 .55515 m
.75546 .50603 L
s
.6144 .66191 m
.63075 .55515 L
s
.23889 .49384 m
.34973 .54914 L
s
.36872 .65777 m
.34973 .54914 L
s
.5 .27523 m
.64786 .36592 L
s
.35026 .35716 m
.5 .27523 L
s
.0035 w
[ ] 0 setdash
.5 .27523 m
.64397 .32698 L
s
.5105 .28499 m
.5 .27523 L
s
.37177 .31851 m
.5 .27523 L
s
.0025 w
[ .01 .012 ] 0 setdash
.49073 .68996 m
.36872 .65777 L
s
.5 .75807 m
.49073 .68996 L
s
.6144 .66191 m
.49073 .68996 L
s
.6144 .66191 m
.75546 .50603 L
s
.6144 .66191 m
.5 .75807 L
s
.6144 .66191 m
.66054 .65315 L
s
.64786 .36592 m
.75546 .50603 L
s
.64397 .32698 m
.64786 .36592 L
s
.36872 .65777 m
.23889 .49384 L
s
.36872 .65777 m
.33724 .64758 L
s
.5 .75807 m
.36872 .65777 L
s
.35026 .35716 m
.37177 .31851 L
s
.23889 .49384 m
.35026 .35716 L
s
.0035 w
[ ] 0 setdash
.64397 .32698 m
.75546 .50603 L
s
.68244 .44034 m
.75546 .50603 L
s
.65519 .585 m
.75546 .50603 L
s
.66054 .65315 m
.75546 .50603 L
s
.23889 .49384 m
.37177 .31851 L
s
.23889 .49384 m
.337 .43125 L
s
.33724 .64758 m
.23889 .49384 L
s
.36165 .57909 m
.23889 .49384 L
s
.66054 .65315 m
.5 .75807 L
s
.66054 .65315 m
.65519 .585 L
s
.68244 .44034 m
.64397 .32698 L
s
.51982 .38415 m
.64397 .32698 L
s
.5105 .28499 m
.64397 .32698 L
s
.36165 .57909 m
.33724 .64758 L
s
.5 .75807 m
.33724 .64758 L
s
.37177 .31851 m
.51982 .38415 L
s
.37177 .31851 m
.5105 .28499 L
s
.337 .43125 m
.37177 .31851 L
s
.5105 .28499 m
.51982 .38415 L
s
.5 .75807 m
.36165 .57909 L
s
.5 .75807 m
.51151 .60126 L
s
.65519 .585 m
.5 .75807 L
s
.51982 .38415 m
.68244 .44034 L
s
.65519 .585 m
.68244 .44034 L
s
.337 .43125 m
.51982 .38415 L
s
.36165 .57909 m
.337 .43125 L
s
.65519 .585 m
.51982 .38415 L
s
.65519 .585 m
.51151 .60126 L
s
.36165 .57909 m
.51982 .38415 L
s
.51151 .60126 m
.36165 .57909 L
s
.51151 .60126 m
.51982 .38415 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.1,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016R000`400?l00000o`00003oo`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00R`3oool3000008`0oooo00280?ooo`<000000P3o
ool4000008T0oooo00250?ooo`<0000000Oo00000?ooo`3oool0ooooo`00003oool000000080oooo
0`0000260?ooo`00PP3oool3000000D0oooo00?o00000?ooool000001@0000000ol00000oooo0000
0002000008<0oooo001o0?ooo`<000000P3oool2o`000080oooo1@0000020?ooo`030000003oool0
oooo00<000000P3oool300000800oooo001l0?ooo`<000000`3oool2o`0000@0000000Go00000?oo
o`3oool0ooooo`0000020?ooo`030000003oool0oooo0080oooo00Co000000000000000000000P3o
ool3000007d0oooo001i0?ooo`<00000103oool4000000/0oooo00<00000o`00003oool01@3oool0
0ol00000000000000002000000040?ooo`0000000000000007X0oooo001f0?ooo`<000000P3oool5
000000l0oooo00<000000?ooool000001P3oool01?l00000oooo0?ooo`3oool3000000030?ooo`00
0000000007P0oooo001c0?ooo`<0000000<0oooo0000000000000P0000020?ooo`03o`00003oool0
oooo00H0oooo00?o00000?ooo`3oool00`3oool01Ol00000oooo0?ooo`3oool0000000P0oooo00?o
00000?ooo`3oool00`3oool6000007D0oooo001`0?ooo`L000003P3oool00ol00000oooo0?ooo`04
0?ooo`05o`00003oool0oooo0?ooo`0000004P3oool500000780oooo001]0?ooo`H000001P3oool2
o`0000T0oooo00?o00000?ooo`3oool0103oool00ol00000oooo0?ooo`020?ooo`040000003oool0
ooooo`0000P0oooo0_l000080?ooo`D00000K`3oool006X0oooo1000000:0?ooo`03o`00003oool0
oooo0100oooo00?o00000?ooo`3oool00P3oool010000000oooo0?ooool0000:0?ooo`03o`00003o
ool0oooo00P0oooo1@00001/0?ooo`00J03oool2000002H0oooo00D000000?ooo`3oool0ooooo`00
000H0?ooo`@00000J@3oool006P0oooo00<000000?ooo`0000000P0000070?ooo`;o0000303oool0
0ol00000oooo0?ooo`0;0?ooo`050000003oool0oooo0?ooool00000303oool2o`0000d0oooo1000
001V0?ooo`00I`3oool2000000@0oooo0P0000030?ooo`;o00003@3oool00ol00000oooo0?ooo`07
0?ooo`03o`00003oool0oooo0080oooo00<000000?ooo`3oool0403oool00ol00000oooo0?ooo`0=
0?ooo`800000I@3oool006H0oooo0P0000070?ooo`8000003`3oool00ol00000oooo0?ooo`080?oo
o`03o`00003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00ol00000oooo0?ooo`0H0?oo
o`80000000<0oooo0000003oool0I03oool006D0oooo0`0000060?ooo`;o000000@0oooo00000000
000000005`3oool00ol00000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00?o00000?oo
o`3oool03@3oool2o`0000L0oooo0P0000040?ooo`030000003oool0oooo0680oooo001U0?ooo`03
0000003oool0000000D0oooo00?o00000?ooo`3oool0103oool2000001D0oooo00?o00000?ooo`3o
ool00`3oool00`000000oooo0?ooo`030?ooo`03o`00003oool0oooo00h0oooo00?o00000?ooo`3o
ool00P3oool2000000H0oooo0P00001S0?ooo`00I03oool00`000000oooo0000000?0?ooo`800000
1P3oool00ol00000oooo0?ooo`0@0?ooo`030000003oool0oooo00@0oooo00?o00000?ooo`3oool0
3P3oool01?l0000000000000000000080?ooo`800000H`3oool006<0oooo00@000000?ooo`3oool0
00000P3oool2o`0000d0oooo0`0000020?ooo`03o`00003oool0oooo0140oooo00<000000?ooo`3o
ool0503oool200000080oooo00?o00000?ooo`3oool01`3oool200000680oooo001R0?ooo`800000
0P3oool00`00003o0000o`00000B0?ooo`8000003P3oool00ol00000oooo0?ooo`030?ooo`030000
003oool0oooo0180oooo0P0000050?ooo`03o`00003oool0oooo00H0oooo0P00001R0?ooo`00HP3o
ool2000000030?ooo`000000oooo01H0oooo0P00000<0?ooo`03o`00003oool0oooo00<0oooo00<0
00000?ooo`3oool01P3oool00ol00000oooo0?ooo`070?ooo`800000203oool00ol00000oooo0?oo
o`040?ooo`80000000<0oooo0000003oool0H03oool00640oooo0P000002o`0000030000003oool0
oooo0180oooo00?o00000?ooo`3oool00P3oool3000000T0oooo00?o00000?ooo`3oool00`3oool0
0`000000oooo0?ooo`060?ooo`03o`00003oool0oooo00D0oooo0P00000A0?ooo`050000003oool0
00000?ooo`000000H03oool00600oooo00<000000?ooool000000P3oool00`000000oooo0?ooo`0B
0?ooo`03o`00003oool0oooo00D0oooo0P0000070?ooo`03o`00003oool0oooo00<0oooo00<00000
0?ooo`3oool01`3oool00ol00000oooo0?ooo`020?ooo`8000003`3oool2o`000080oooo00D00000
0?ooo`000000oooo0000001P0?ooo`00G`3oool01P000000oooo0?ooool00000oooo000001@0oooo
00?o00000?ooo`3oool0203oool2000000/0oooo00<000000?ooo`3oool02P3oool2000001<0oooo
00Go00000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo05d0oooo001O0?ooo`060000
003oool0oooo0?ooool000000000503oool00ol00000oooo0?ooo`0:0?ooo`<00000203oool00`00
0000oooo0?ooo`080?ooo`800000603oool00`000000oooo000000020?ooo`030000003oool0oooo
05`0oooo001N0?ooo`030000003oool000000080oooo00?o00000000003oool08`3oool2000000L0
oooo00<000000?ooo`3oool0103oool3000000030?ooool00000oooo01L0oooo00<000000?ooo`00
00000P3oool00`000000oooo0?ooo`1L0?ooo`00G@3oool00`000000oooo000000030?ooo`030000
003oool0oooo0140oooo00?o00000?ooo`3oool0403oool00ol000000000000000050?ooo`030000
003oool0oooo0080oooo0P0000050?ooo`03o`00003oool0oooo01@0oooo00Co00000?ooo`000000
00000`3oool00`000000oooo0?ooo`1K0?ooo`00G03oool00`000000oooo000000040?ooo`030000
003oool0oooo0100oooo00?o00000?ooo`3oool04@3oool00ol00000oooo0?ooo`0300000080oooo
00<000000?ooo`3oool00P0000080?ooo`03o`00003oool0oooo0180oooo00Ko00000?ooo`3oool0
00000?ooo`0000020?ooo`030000003oool0oooo05/0oooo001L0?ooo`030000003oool0oooo00@0
oooo00<00000o`00003oool03`3oool00ol00000oooo0?ooo`0B0?ooo`03o`00003oool0oooo00<0
oooo1@00000T0?ooo`050000003oool0oooo0?ooo`000000G03oool005/0oooo0P0000060?ooo`03
00000?l00000oooo02X0oooo1000000U0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool0F@3oool005X0oooo00<000000?ooo`0000001@3oool010000000oooo0?ooool0000V0?ooo`@0
00000P3oool00`000000oooo00000002000000T0oooo00?o00000?ooo`3oool03`3oool00ol00000
oooo0?ooo`040?ooo`8000000`3oool00`000000oooo0?ooo`1I0?ooo`00F@3oool00`000000oooo
000000060?ooo`030000003oool0oooo00h0oooo00?o00000?ooo`3oool04`3oool3000000D0oooo
0`0000030?ooo`<000001`3oool00ol00000oooo0?ooo`0>0?ooo`03o`00003oool0oooo00D0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1H0?ooo`00F@3oool2000000L0oooo00<0
00000?ooo`3oool03@3oool00ol00000oooo0?ooo`0@0?ooo`@0000000<0ooooo`00003oool0103o
ool01@000000oooo0000003oool0000000D0oooo0`0000050?ooo`03o`00003oool0oooo00`0oooo
00?o00000?ooo`3oool01P3oool2000000@0oooo00<000000?ooo`3oool0E`3oool005P0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`0=0?ooo`03o`00003oool0oooo00d0oooo1000
00050?ooo`03o`00003oool0oooo0080oooo00H000000?ooo`3oool000000?ooo`0000080?ooo`<0
00006`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo05L0oooo001G0?ooo`800000
203oool00`000000oooo0?ooo`020?ooo`03o`00003oool0oooo01D0oooo0`0000090?ooo`05o`00
003oool0oooo0?ooo`0000000`3oool010000000oooo0?ooo`00000:0?ooo`8000006@3oool00`00
0000oooo000000030?ooo`030000003oool0oooo05H0oooo001F0?ooo`8000002@3oool00`000000
oooo0?ooo`020?ooo`03o`00003oool0oooo0140oooo1000000<0?ooo`04o`00003oool0oooo0000
00@0oooo00D000000?ooo`3oool0oooo0000000;0?ooo`<000002P3oool00ol00000oooo0?ooo`09
0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool0EP3oool005D0oooo0P000009
0?ooo`030000003oool0oooo00@0oooo00?o00000?ooo`3oool01@3oool00ol00000oooo0?ooo`04
0?ooo`@000004`3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000003@3o
ool01?l0000000000000000000070?ooo`03o`00003oool0oooo00X0oooo00@000000?ooo`3oool0
00000P3oool00`000000oooo0?ooo`1E0?ooo`00E@3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo00/0oooo00Co00000?ooo`3oool0oooo1000000F0?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0;0?ooo`03o`00003oool0oooo00<0
00000`3oool00ol00000oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool0E03oool005@0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0:0?ooo`03o`00
003oool0000000800000603oool00ol0000000000?ooo`050?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool0403oool300000003o`00003oool0oooo00/0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`1D0?ooo`00D`3oool2000000X0oooo00<000000?ooo`3oool01P3o
ool00ol00000oooo0?ooo`04000001/0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo01<0oooo0`00000<0?ooo`050000003oool0oooo0?ooo`000000
0P3oool00`000000oooo0?ooo`1C0?ooo`00DP3oool2000000/0oooo00<000000?ooo`3oool01@3o
ool4000001h0oooo00<00000o`00003oool01@3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo00/0oooo00?o00000?ooo`3oool01`3oool2000000X0oooo00<000000?ooo`3oool00P3o
ool010000000oooo0?ooo`00001D0?ooo`00DP3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo0080oooo0`0000020?ooo`03o`00003ooooo000001H0oooo1?l000020?ooo`03o`000000
003o000000;o0000103oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00X0oooo00?o
00000?ooo`3oool00P3oool00ol00000oooo0?ooo`040?ooo`<000001`3oool00`000000oooo0?oo
o`030?ooo`030000003oool0000005@0oooo001A0?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`0000000`0000050?ooo`;o00001P3oool2o`0000<0oooo1?l000020?ooo`Co0000203oool0
0`000000ooooo`0000050?ooo`03o`000000003o000000<0oooo0ol000000`3oool000000?ooo`0<
0?ooo`05o`00003oool0oooo0?ooool000002@3oool3000000D0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`1A0?ooo`00D03oool00`000000oooo0?ooo`0:0?ooo`<000002@3oool4
o`0000<0oooo00?o00000?ooo`3oool0503oool00`000000ooooo`0000070?ooo`030000003oool0
oooo00D0oooo00?o00000?ooo`0000001?l000090?ooo`03o`00003ooooo000000d0oooo0`000002
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0D03oool004l0oooo0P00000;0?oo
o`030000003oool0000000L0oooo0_l000000`3ooooo0000o`00000K0?ooo`040000003oool0oooo
o`0000L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`030?ooo`Co00005P3oool3
000000H0oooo00<000000?ooo`000000DP3oool004l0oooo00<000000?ooo`3oool0203oool20000
0080oooo00<000000?ooo`3oool0103oool01ol00000oooo0?ooo`3ooooo00000?ooool000006@3o
ool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3o
ool5o`000180oooo0P0000040?ooo`040000003oool0oooo00000540oooo001>0?ooo`030000003o
ool0oooo00L0oooo0P0000040?ooo`030000003oool0oooo00P0oooo00?o00000?ooo`3oool0603o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3o
ool2o`000080oooo00?o00000?ooo`3oool03`3oool00`000000oooo000000040?ooo`030000003o
ool000000540oooo001=0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01@3oool0
0`00003o0000o`00000R0?ooo`030000003oool0oooo0080oooo00?o00000?ooo`3oool01@3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00L0oooo00Co00000?ooo`3ooooo0000103o
ool2o`0000d0oooo00@000000?ooo`3oool000001P3oool00`000000oooo0?ooo`1>0?ooo`00C03o
ool00`000000oooo0?ooo`060?ooo`800000203oool00`000000oooo0?ooo`0;0?ooo`03o`00003o
ool0oooo01<0oooo00<000000?ooo`3oool00`3oool00ol00000oooo0?ooo`050?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool02P3oool00ol00000oooo0?ooo`040?ooo`03o`00003o
ool0oooo00X0oooo00D000000?ooo`3oool0oooo000000060?ooo`030000003oool0oooo04d0oooo
001<0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool2o`000080oooo00<0
00000?ooo`3oool01P3oool00ol00000oooo0?ooo`030?ooo`03o`00003oool0oooo0140oooo00<0
00000?ooo`3oool0103oool00ol00000oooo0?ooo`050?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool0703oool00`000000oooo0?ooo`030?ooo`070000003oool0oooo0?ooo`000000
oooo0000001?0?ooo`00B`3oool00`000000oooo0?ooo`040?ooo`8000001@3oool2o`0000@0oooo
00<000000?ooo`3oool01P3oool00ol00000oooo0?ooo`040?ooo`03o`00003oool0oooo00l0oooo
00<000000?ooo`3oool01@3oool00ol00000oooo0?ooo`050?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool00`3oool00ol00000oooo0?ooo`0<0?ooo`?o00001P3oool00`000000oooo
0?ooo`040?ooo`070000003oool0oooo0?ooo`000000oooo0000001>0?ooo`00BP3oool00`000000
oooo0?ooo`030?ooo`8000003@3oool00`000000oooo0?ooo`050?ooo`03o`00003oool0oooo01H0
oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0080
oooo00?o00000?ooo`3oool00`3oool00ol00000oooo0?ooo`0:0?ooo`03o`00003oool0oooo00<0
oooo00<000000?ooo`3oool01@3oool01`000000oooo0?ooo`3oool000000?ooo`000000C@3oool0
04T0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`;o0000203oool00`00
0000oooo0?ooo`050?ooo`03o`00003oool0oooo01H0oooo00<000000?ooo`3oool03P3oool00`00
0000oooo0?ooo`0=0?ooo`040000003oool0ooooo`0000H0oooo00?o00000?ooo`3oool03@3oool2
o`0000030?ooo`000000oooo00L0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1;
0?ooo`00B03oool2000000<0oooo0P0000050?ooo`03o`00003oool0oooo00T0oooo00<000000?oo
o`3oool03P3oool00ol00000oooo0?ooo`0;0?ooo`030000003oool0oooo00L0oooo00?o00000?oo
o`3oool01@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00L0oooo00?o00000?oo
o`3oool03P3oool00ol0000000000?ooo`080?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool0BP3oool004P0oooo00D000000?ooo`3oool0oooo000000020?ooo`;o00003`3oool00`00
0000oooo0?ooo`0>0?ooo`03o`00003oool0oooo00X0oooo00<000000?ooo`3oool0203oool00ol0
0000oooo0?ooo`050?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool01`3oool00ol0
0000oooo0?ooo`0?0?ooo`030000003oool0oooo00P0oooo0P0000000`3oool000000000001<0?oo
o`00A`3oool00`000000oooo0?ooo`0200000080oooo00?o00000?ooo`3oool03`3oool00`000000
oooo0?ooo`040?ooo`03o`00003oool0oooo00P0oooo00?o00000?ooo`3oool0203oool00`000000
oooo0?ooo`090?ooo`03o`00003oool0oooo00D0oooo00<000000?ooo`3oool03P3oool00ol00000
00000?ooo`0H0?ooo`040000003oool0oooo0?ooo`;o0000203oool010000000oooo00000000001;
0?ooo`00AP3oool2000000030?ooo`000000oooo01D0oooo00<000000?ooo`3oool0103oool00ol0
0000oooo0?ooo`0B0?ooo`030000003oool0oooo00X0oooo00?o00000?ooo`3oool01@3oool00`00
0000oooo0?ooo`0=0?ooo`04o`00003oool0oooo000001P0oooo00<000000?ooo`3oool00`3oool0
0ol00000oooo0?ooo`060?ooo`040000003oool00000000004X0oooo00160?ooo`<0000000<0oooo
o`000?l00000503oool00`000000oooo0?ooo`030?ooo`03o`00003oool0oooo0180oooo00<00000
0?ooo`3oool04`3oool00`000000oooo0?ooo`0<0?ooo`05o`00003oool0oooo0?ooo`000000203o
ool00ol00000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`000000BP3o
ool004@0oooo0`0000000`3ooooo0000o`00000F0?ooo`030000003oool0oooo00<0oooo00?o0000
0?ooo`3oool02`3oool00ol00000oooo0?ooo`040?ooo`030000003oool0oooo01<0oooo00<00000
0?ooo`3oool04@3oool00`000000oooo0?ooo`050?ooo`03o`00003oool0oooo00d0oooo00<00000
0?ooo`3oool01P3oool3o`0000D0oooo00<000000?ooo`000000B@3oool004@0oooo00<00000o`00
003oool06P3oool00`000000oooo0?ooo`0A0?ooo`03o`00003oool0oooo0080oooo00<000000?oo
o`3oool0303oool00ol00000oooo0?ooo`050?ooo`030000003oool0oooo00X0oooo00?o00000?oo
o`3oool01@3oool00`000000oooo0?ooo`040?ooo`03o`00003oool0oooo00d0oooo00<000000?oo
o`3oool02@3oool00ol00000oooo0?ooo`030?ooo`<00000B03oool004<0oooo0P00000L0?ooo`03
0000003oool0oooo0180oooo00Co00000?ooo`3oool000003`3oool00ol00000oooo0?ooo`040?oo
o`030000003oool0oooo00X0oooo00?o00000?ooo`3oool01P3oool00`000000oooo0?ooo`040?oo
o`03o`00003oool0oooo00d0oooo00<000000?ooo`3oool0303oool2o`000080oooo0P0000180?oo
o`00@`3oool00`00003o00000000000K0?ooo`050000003oool0oooo0?ooool000004P3oool00`00
0000oooo0?ooo`0>0?ooo`03o`00003oool0oooo00@0oooo00<000000?ooo`3oool02@3oool00ol0
0000oooo0?ooo`080?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool03`3oool00ol0
0000oooo0?ooo`02000004L0oooo00140?ooo`0400000?l000000000000001T0oooo00D000000?oo
o`3oool0ooooo`00000A0?ooo`030000003oool0oooo00l0oooo00?o00000?ooo`3oool0103oool0
0`000000oooo0?ooo`0E0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04`3oool0
0`000000oooo0?ooo`150?ooo`00A@3oool010000000oooo0?ooo`000002o`0001H0oooo00D00000
0?ooo`3oool0ooooo`00000A0?ooo`0300000?l00000oooo01H0oooo00<000000?ooo`3oool05@3o
ool00`000000oooo0?ooo`030?ooo`03o`00003oool0oooo00/0oooo00<000000?ooo`3oool04P3o
ool2o`0000030000003oool0oooo04@0oooo00150?ooo`070000003oool0oooo0?ooo`000000oooo
o`00000F0?ooo`040000003oool0ooooo`000100oooo00@000000?ooo`3ooooo00005P3oool00`00
0000oooo0?ooo`070?ooo`03o`00003oool0oooo00`0oooo00<000000?ooo`3oool00P3oool00ol0
0000oooo0?ooo`0;0?ooo`030000003oool0oooo01@0oooo0P0000150?ooo`00AP3oool200000080
oooo0P00000F0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool00P3oool00ol00000
oooo0?ooo`0<0?ooo`03o`00003oool0oooo00@0oooo00<000000?ooo`3oool01P3oool00ol00000
oooo0?ooo`0>0?ooo`050000003oool0oooo0?ooool000003@3oool00`000000oooo0?ooo`0@0?oo
o`;o000000@0oooo0000003oool00000A@3oool004H0oooo0P0000040?ooo`040000003ooooo0000
o`000180oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0B0?ooo`03o`00003oool0
oooo00@0oooo00<000000?ooo`3oool01@3oool00ol00000oooo0?ooo`0?0?ooo`050000003oool0
oooo0?ooool00000303oool00`000000oooo0?ooo`0?0?ooo`;o00000P3oool00`000000oooo0000
00160?ooo`00A`3oool2000000@0oooo0P0000000`3ooooo00000?ooo`0@0?ooo`030000003ooooo
000000h0oooo00<000000?ooo`3oool04`3oool00ol00000oooo0?ooo`040?ooo`030000003oool0
oooo01P0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0;0?ooo`;o00001@3oool0
0`000000oooo000000170?ooo`00B03oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
0100oooo00<000000?ooool000003@3oool00`000000oooo0?ooo`070?ooo`03o`00003oool0oooo
00X0oooo00?o00000?ooo`3oool0103oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool02P3oool00ol00000oooo0?ooo`030?ooo`8000000P3oool00`00
0000oooo0?ooo`150?ooo`00B03oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00?o
0000303oool00`00003o00000?ooo`0=0?ooo`030000003oool0oooo00L0oooo00?o00000?ooo`3o
ool04@3oool00`000000oooo0?ooo`030?ooo`03o`00003oool0oooo01<0oooo00@000000?ooo`3o
oooo00002`3oool00`000000oooo0?ooo`0?0?ooo`050000003oool000000?ooo`000000B03oool0
04T0oooo0P0000060?ooo`8000000`3oool00ol00000oooo0?ooo`0:0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02@3oool00ol00000oooo0?ooo`0@0?ooo`030000003oool0oooo
0080oooo00?o00000?ooo`3oool05@3oool00`000000ooooo`00000;0?ooo`030000003oool0oooo
00H0oooo0_l000060?ooo`050000003oool000000?ooo`000000B@3oool004X0oooo0P0000070?oo
o`030000003oool0oooo00<0oooo00?o00000?ooo`3oool01`3oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo01d0oooo00D000000?ooo`3oool0ooooo`00000I0?ooo`030000003ooooo
000000X0oooo00<000000?ooo`3oool0103oool2o`0000H0oooo0P0000001@3oool000000?ooo`3o
ool0000004T0oooo001:0?ooo`030000003oool0000000L0oooo0P0000040?ooo`03o`00003oool0
oooo00H0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0G0?ooo`03o`00003oool0
oooo00@0oooo00<000000?ooo`3oool06`3oool00`000000ooooo`0000090?ooo`040000003oool0
oooo0?ooo`;o00002@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo04P0oooo001;
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool00P3oool00ol00000oooo0?ooo`04
0?ooo`03o`0000000000oooo00T0oooo00<000000?ooo`3oool03P3oool00ol00000oooo0?ooo`07
0?ooo`03o`00003oool0oooo00@0oooo00<000000?ooool00000703oool00`000000oooo0?ooo`08
0?ooo`040000003ooooo0000o`0000X0oooo00@000000?ooo`3oool000000P3oool00`000000oooo
0?ooo`190?ooo`00B`3oool00`000000oooo0?ooo`090?ooo`8000001@3oool3o`0000030?ooool0
0000000000X0oooo00<000000?ooo`3oool03`3oool00ol00000oooo0?ooo`050?ooo`03o`00003o
ool0oooo00D0oooo00<000000?ooool000007@3oool00`000000oooo0?ooo`050?ooo`;o000000<0
00000?ooo`3oool02P3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo04T0oooo
001<0?ooo`030000003oool0000000X0oooo00<000000?ooo`3oool01@3oool2o`0000030000003o
ool0oooo00L0oooo00<000000?ooo`3oool04@3oool00ol00000oooo0?ooo`0<0?ooo`0300000?l0
0000oooo01d0oooo00<000000?ooo`3oool00`3oool2o`000080oooo00<000000?ooo`3oool0203o
ool200000080oooo00D000000?ooo`3oool0oooo0000001<0?ooo`00C@3oool00`000000oooo0000
000:0?ooo`030000003oool0oooo00D0oooo0_l000000`000000oooo0?ooo`050?ooo`030000003o
ool0oooo0240oooo00<000000?ooo`3oool07@3oool01?l000000000o`000?l000060?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`1;0?ooo`00C@3o
ool010000000oooo0?ooo`00000:0?ooo`8000001`3oool010000000oooo0?ooo`3oool2o`000003
0?ooo`000000oooo02<0oooo00<000000?ooo`3oool07P3oool00ol0000000000?ooo`060?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`1;0?ooo`00
CP3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`0F0?ooo`03o`00003oool0oooo0080oooo00?o00000?ooo`3oool0
0`3oool00ol00000oooo0000000L0?ooo`?o00000P3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000004h0
oooo001?0?ooo`030000003oool0oooo00`0oooo0P0000020?ooo`03o`00003oool0000000@0oooo
00<000000?ooo`3oool00P3oool4o`000180oooo00Go00000?ooo`3oool0ooooo`0000040?ooo`04
o`00003oool0oooo000001D0oooo1?l000090?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0103oool2000000@0oooo00D000000?ooo`3oool0oooo0000001?0?ooo`00C`3oool01000
0000oooo0?ooo`00000=0?ooo`050000003ooooo00000?ooo`000000103oool00`000000oooo0?oo
o`080?ooo`?o00003P3oool01?l00000oooo0?ooool000030?ooo`05o`00003oool0oooo0?ooo`00
00004@3oool2o`0000`0oooo00Go00000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
04d0oooo001@0?ooo`040000003oool0oooo000000d0oooo00@000000?ooool0000000000`3oool0
0`000000oooo0?ooo`0<0?ooo`03o`00003oool0oooo00h0oooo00?o00000?ooo`3oool0103oool0
0`000000oooo0?ooo`0:0?ooo`;o00000P3oool2o`0000h0oooo00Go00000?ooo`3oool0oooo0000
00040?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`1>0?ooo`00D@3oool010000000oooo0?ooo`00000=0?ooo`80000000@0oooo0000003oool00000
4P3oool4o`000140oooo00<000000?ooo`3oool0103oool2o`000080oooo0_l0000D0?ooo`03o`00
003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000020?ooo`8000002P3oool00`000000
oooo0?ooo`1?0?ooo`00D@3oool00`000000oooo0?ooo`0@0?ooo`<000006@3oool3o`0000@0oooo
00Co00000?ooo`3ooooo0000103oool00`00003o0000o`0000020?ooo`;o00006P3oool00ol00000
oooo0?ooo`030?ooo`060000003oool0oooo0000003oool000001`3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo04l0oooo001B0?ooo`030000003oool0oooo0100oooo1@00000I0?oo
o`03o`00003oool0oooo00Ko00000P3oool00ol0000000000?ooo`0U0?ooo`050000003oool00000
0?ooo`0000001`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0500oooo001B0?oo
o`050000003oool0oooo0?ooo`000000303oool00ol00000oooo000000040?ooo`L000005P3oool3
o`0000D0oooo00<000000?ooo`3oool09@3oool3000000L0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`1A0?ooo`00D`3oool01@000000oooo0?ooo`3oool0000000/0oooo00Co0000
0000003oool000002P3oool7000000h0oooo00Co00000?ooo`3oool0oooo0_l000030?ooo`030000
003oool0oooo01d0oooo00Co00000?ooo`3oool0oooo1P00000=0?ooo`030000003oool0oooo0540
oooo001D0?ooo`050000003oool0oooo0?ooo`0000002`3oool010000000oooo0?ooo`00000@0?oo
o`L000003@3oool01?l00000oooo0?ooo`00000I0?ooo`X000001@3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0DP3oool005@0oooo00<000000?oo
o`3oool03@3oool01@000000oooo0?ooo`3oool0000001H0oooo1`0000020?ooo`03o`00003oool0
oooo0080oooo00?o00000?ooo`0000003P3oool;000000H0oooo00?o00000?ooo`3oool01@3oool2
000000D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`1B0?ooo`00E@3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool05`3oool01?l0
0000oooo0?ooo`3oool700000080oooo00<000000?ooo`3oool00P3oool:00000140oooo00?o0000
0?ooo`3oool0103oool00`000000oooo000000040?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool0D`3oool005H0oooo00D000000?ooo`3oool0oooo000000080?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool05@3oool00ol00000oooo0?ooo`040?ooo`03o`00003oool0
oooo0080oooo1`00000Q0?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3oool0E03o
ool005H0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`050?ooo`0300000?l00000
oooo00@0oooo00<000000?ooo`3oool04@3oool00ol00000oooo0?ooo`070?ooo`03o`00003oool0
oooo00@0oooo00@000000?ooo`3ooooo00008@3oool01@000000oooo0?ooo`3oool0000000X0oooo
00<000000?ooo`3oool0E03oool005L0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`030?ooo`030000003ooooo000000H0oooo00<000000?ooo`3oool03`3oool00ol00000oooo0?oo
o`0?0?ooo`030000003oool0oooo01`0oooo00?o00000?ooo`3oool00P3oool00`000000oooo0?oo
o`020?ooo`030000003oool0000000L0oooo00<000000?ooo`3oool0E@3oool005L0oooo00<00000
0?ooo`3oool0203oool010000000oooo0?ooool000060?ooo`030000003oool0oooo00d0oooo00?o
00000?ooo`3oool0403oool00`000000oooo0?ooo`030?ooo`;o00005`3oool01Ol00000oooo0?oo
o`3oool0000000D0oooo00<000000?ooo`0000001P3oool00`000000oooo0?ooo`1F0?ooo`00F03o
ool00`000000oooo0?ooo`030?ooo`040000003oool0oooo000000<0oooo00?o00000?ooo`3oool0
103oool00`000000oooo0?ooo`0I0?ooo`03o`00003oool0oooo00@0oooo00<000000?ooo`3oool0
1@3oool00ol00000oooo0?ooo`0D0?ooo`04o`00003oool0oooo000000H0oooo0P0000070?ooo`03
0000003oool0oooo05H0oooo001I0?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool0
00002`3oool00`000000oooo0?ooo`080?ooo`;o00003P3oool00ol00000oooo0?ooo`040?ooo`03
0000003oool0oooo01`0oooo00?o00000?ooo`0000001`3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo05L0oooo001I0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`000000
303oool00`000000oooo0?ooo`060?ooo`03o`00003oool0oooo00l0oooo00?o00000?ooo`3oool0
0`3oool00`000000oooo0?ooo`080?ooo`03o`00003oool0oooo0180oooo00<000000?ooo`3oool0
103oool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo05P0oooo001J0?ooo`030000
003oool0oooo0080oooo0P00000>0?ooo`030000003oool0oooo01L0oooo00?o00000?ooo`3oool0
0`3oool00`000000oooo0?ooo`090?ooo`03o`00003oool0oooo0140oooo00<000000?ooo`3oool0
0`3oool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3oool0F03oool005/0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`03o`00003oool0oooo00H0oooo
00@000000?ooo`3oool0oooo0_l0000I0?ooo`030000003oool0oooo00/0oooo00?o00000?ooo`3o
ool03`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`1I0?ooo`00F`3oool00`000000oooo0?ooo`020?ooo`800000
103oool00ol00000oooo0?ooo`070?ooo`030000003ooooo000001/0oooo00<000000?ooo`3oool0
3P3oool2o`0000`0oooo00<000000?ooo`3oool02@3oool01@000000oooo0?ooo`3oool0000005`0
oooo001L0?ooo`060000003oool0oooo0000003oool00000103oool00ol00000oooo0?ooo`080?oo
o`030000003oool0oooo01D0oooo00?o00000?ooo`3oool00P3oool00`000000oooo0?ooo`0@0?oo
o`03o`00003oool0oooo00P0oooo00<00000o`00003oool02P3oool01@000000oooo0?ooo`3oool0
000005`0oooo001L0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool02@3oool2
o`000080oooo00<000000?ooo`3oool0503oool00ol00000oooo0?ooo`020?ooo`030000003oool0
oooo0140oooo00?o00000?ooo`3oool01P3oool00`000000ooooo`0000040?ooo`030000003oool0
oooo00@0oooo00@000000?ooo`3oool00000G@3oool005d0oooo00<000000?ooo`0000000`3oool0
0`000000oooo0?ooo`070?ooo`03o`00003oool0oooo0080oooo00<000000?ooo`3oool0503oool0
0ol00000oooo0?ooo`020?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`050?ooo`030000003oool0000005h0oooo001N0?ooo`800000303oool00ol0
0000oooo0?ooo`040?ooo`030000003oool0oooo01<0oooo00?o00000?ooo`3oool00P3oool00`00
0000oooo0?ooo`0C0?ooo`?o00000P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`000000GP3oool005l0oooo0`0000030?ooo`030000003ooooo000000`0
oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0F0?ooo`03o`0000000000oooo00l0
oooo0P00001O0?ooo`00H@3oool2000000<0oooo00@00000o`000?l0003o00002`3oool00`000000
oooo0?ooo`0F0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool00`3oool00ol00000
00000?ooo`080?ooo`800000H03oool006<0oooo1@00000=0?ooo`030000003oool0oooo0140oooo
00?o00000?ooo`3oool00P3oool00`000000oooo0?ooo`0E0?ooo`040000003oool0oooo0?ooo`;o
000000<0oooo0000003oool00`3oool4000000030?ooo`000000oooo0640oooo001T0?ooo`030000
003oool0oooo00@000002`3oool00`000000oooo0?ooo`0@0?ooo`03o`00003oool0oooo0080oooo
00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`020?ooo`D000001@3oool2000006<0oooo
001U0?ooo`8000000`3oool2000000<0oooo0P0000060?ooo`030000003oool0oooo00l0oooo00?o
00000?ooo`3oool00P3oool00`000000oooo0?ooo`0D0?ooo`040000003oool0oooo0?ooo`<00000
203oool00`000000oooo0?ooo`1S0?ooo`00I`3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool03P3oool00ol00000oooo0?ooo`020?ooo`030000003o
ool0oooo01<0oooo0`0000030?ooo`030000003oool0oooo00D0oooo0P00001V0?ooo`00J03oool2
00000080oooo0P0000070?ooo`8000000P3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0
oooo00h0oooo0P0000020?ooo`800000303oool00`000000oooo0?ooo`1V0?ooo`00JP3oool01@00
0000oooo0?ooo`3oool0000000P0oooo00<000000?ooo`000000503oool00`000000oooo0?ooo`0<
0?ooo`8000000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00D0oooo0P00001Y
0?ooo`00J`3oool200000080oooo00<000000?ooo`3oool0203oool400000100oooo00<000000?oo
o`3oool01P3oool4000000H0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo06T0oooo001]0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool00`3oool2000000H0oooo00Go00000?ooo`3oool0oooo000000050?ooo`8000002`3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo00@0oooo0P00001/0?ooo`00KP3oool200000003
0?ooo`000000oooo00T0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`04
o`00003oool0oooo0?ooo`8000000P3oool2000000`0oooo00<000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`1/0?ooo`00L03oool00`000000oooo000000090?ooo`030000003oool0oooo00P0
oooo0P0000000ol00000oooo0000000200000100oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`030?ooo`800000K`3oool00740oooo00<000000?ooo`0000002@3oool00`000000oooo
0?ooo`090?ooo`05o`00003oool0oooo0?ooo`000000403oool01@000000oooo0?ooo`3oool00000
00D0oooo00<000000?ooo`3oool0K`3oool00780oooo0P00000:0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool03@3oool01@000000oooo0?ooo`3oool0000000@0oooo0P00001b0?oo
o`00M03oool00`000000oooo000000080?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0780oooo001e0?ooo`<00000
1`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00@000000?ooo`3oool0
0000103oool2000007D0oooo001g0?ooo`8000001`3oool00`000000oooo0?ooo`070?ooo`040000
003oool0oooo000000`0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`1e0?oo
o`00N03oool2000000L0oooo00<000000?ooo`3oool01P3oool010000000oooo0?ooo`00000;0?oo
o`040000003oool0oooo000000<0oooo0P00001h0?ooo`00NP3oool3000000D0oooo00<000000?oo
o`3oool01@3oool010000000oooo0?ooo`00000:0?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool0N03oool007/0oooo00<000000?ooo`000000103oool00`000000oooo0?ooo`080?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`0000000`3oool2000007/0oooo001l0?ooo`80
00001@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`00
00000`3oool00`000000oooo0?ooo`1k0?ooo`00OP3oool00`000000oooo000000030?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool01@3oool00`000000oooo000000020?ooo`800000
OP3oool007l0oooo0`0000030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000001`3o
ool01@000000oooo0?ooo`3oool000000800oooo00210?ooo`8000000`3oool00`000000oooo0?oo
o`020?ooo`030000003oool0000000H0oooo00<000000?ooo`3oool00P0000210?ooo`00PP3oool2
00000080oooo00<000000?ooo`3oool00P3oool2000000H0oooo00@000000?ooo`3oool00000P`3o
ool008@0oooo0P0000000`3oool000000?ooo`030?ooo`030000003oool0oooo00<0oooo00@00000
0?ooo`0000000000Q03oool008D0oooo0P0000000`3oool000000?ooo`020?ooo`030000003oool0
oooo0080oooo00<000000?ooo`000000QP3oool008L0oooo00<000000?ooo`0000000P3oool01000
0000oooo0?ooo`3oool3000008L0oooo00280?ooo`8000000P3oool00`000000oooo0?ooo`020000
08T0oooo00290?ooo`80000000<0oooo0000003oool00P00002:0?ooo`00R`3oool3000008`0oooo
002<0?ooo`030000003oool0oooo08/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0
oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0
oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0
oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0
oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0
oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0
oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0
oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0
oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0
oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0
oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0
oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0
oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0
oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo0000\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-5.00005*^-6, -5.00005*^-6, \
0.00355875, 0.00355875}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.0025 w
[ .01 .012 ] 0 setdash
.52449 .58154 m
.65716 .54666 L
s
.52449 .58154 m
.6287 .43004 L
s
.51504 .42409 m
.52449 .58154 L
s
.39887 .44065 m
.52449 .58154 L
s
.37696 .55717 m
.52449 .58154 L
s
.39229 .6633 m
.52449 .58154 L
s
.51621 .68981 m
.52449 .58154 L
s
.63722 .65607 m
.52449 .58154 L
s
.51504 .42409 m
.6287 .43004 L
s
.51504 .42409 m
.5 .27523 L
s
.39887 .44065 m
.51504 .42409 L
s
.39887 .44065 m
.5 .27523 L
s
.37696 .55717 m
.39887 .44065 L
s
.35344 .36915 m
.39887 .44065 L
s
.24764 .51045 m
.39887 .44065 L
s
.24764 .51045 m
.37696 .55717 L
s
.39229 .6633 m
.37696 .55717 L
s
.6287 .43004 m
.76219 .48914 L
s
.6287 .43004 m
.65716 .54666 L
s
.64983 .35382 m
.6287 .43004 L
s
.5 .27523 m
.6287 .43004 L
s
.65716 .54666 m
.76219 .48914 L
s
.63722 .65607 m
.65716 .54666 L
s
.5 .27523 m
.64983 .35382 L
s
.35344 .36915 m
.5 .27523 L
s
.0035 w
[ ] 0 setdash
.5 .27523 m
.62164 .31558 L
s
.48166 .28534 m
.5 .27523 L
s
.35086 .33037 m
.5 .27523 L
s
.0025 w
[ .01 .012 ] 0 setdash
.51621 .68981 m
.39229 .6633 L
s
.5 .75807 m
.51621 .68981 L
s
.63722 .65607 m
.51621 .68981 L
s
.39229 .6633 m
.24764 .51045 L
s
.39229 .6633 m
.34093 .65519 L
s
.5 .75807 m
.39229 .6633 L
s
.35344 .36915 m
.35086 .33037 L
s
.24764 .51045 m
.35344 .36915 L
s
.63722 .65607 m
.76219 .48914 L
s
.63722 .65607 m
.5 .75807 L
s
.63722 .65607 m
.66292 .64546 L
s
.64983 .35382 m
.76219 .48914 L
s
.62164 .31558 m
.64983 .35382 L
s
.0035 w
[ ] 0 setdash
.24764 .51045 m
.35086 .33037 L
s
.24764 .51045 m
.31124 .44396 L
s
.34093 .65519 m
.24764 .51045 L
s
.33929 .58737 m
.24764 .51045 L
s
.62164 .31558 m
.76219 .48914 L
s
.65479 .42808 m
.76219 .48914 L
s
.63128 .57704 m
.76219 .48914 L
s
.66292 .64546 m
.76219 .48914 L
s
.33929 .58737 m
.34093 .65519 L
s
.5 .75807 m
.34093 .65519 L
s
.35086 .33037 m
.46539 .38473 L
s
.35086 .33037 m
.48166 .28534 L
s
.31124 .44396 m
.35086 .33037 L
s
.66292 .64546 m
.5 .75807 L
s
.66292 .64546 m
.63128 .57704 L
s
.65479 .42808 m
.62164 .31558 L
s
.46539 .38473 m
.62164 .31558 L
s
.48166 .28534 m
.62164 .31558 L
s
.48166 .28534 m
.46539 .38473 L
s
.5 .75807 m
.33929 .58737 L
s
.5 .75807 m
.47989 .60148 L
s
.63128 .57704 m
.5 .75807 L
s
.31124 .44396 m
.46539 .38473 L
s
.33929 .58737 m
.31124 .44396 L
s
.33929 .58737 m
.46539 .38473 L
s
.47989 .60148 m
.33929 .58737 L
s
.46539 .38473 m
.65479 .42808 L
s
.63128 .57704 m
.65479 .42808 L
s
.63128 .57704 m
.46539 .38473 L
s
.63128 .57704 m
.47989 .60148 L
s
.47989 .60148 m
.46539 .38473 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.1,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016R000`400?l00000o`00003ooooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00Roooool4o`0008_ooooo0028ooooo`?o00000_oo
ool2000000?o0000R?ooool008Gooooo1?l00002ooooo`80000000?ooooo00000?ooool00_ooool3
o`0008Gooooo0022ooooo`So000000<00000ooooo`0000001?ooool300000004ooooool0003o0000
o`0008;ooooo001oooooo`Ko00000_ooool00ol0003ooooo00000005o`0000Gooooo00@00000oooo
oooooooooooo0ol0001oooooo`00OOooool5o`000003ooooo`000000000000;ooooo00?o0000oooo
ooooool00_ooool00`00003oooooooooo`05o`0000Oooooo0ol0001looooo`00N_ooool5o`0000?o
oooo00<00000ooooooooool00_ooool00ol0003oooooooooo`07ooooo`0300000?oooooooooo00Go
00001Oooool3o`0007Wooooo001gooooo`Go00002_ooool00ol0003ooooo00000009ooooo`030000
0?oooooooooo00Cooooo1Ol00003ooooo`?o0000M_ooool007Cooooo1Ol00006ooooo`0300000?oo
oooooooo00Cooooo00?o000000000?ooool01?ooool00`00003oooooooooo`0<ooooo`8000001Ol0
00001?oooooo0000o`000?l0001cooooo`00LOooool5o`0000Sooooo00<00000ooooooooool01Ooo
ool00ol0003oooooooooo`04ooooo`0300000?oooooooooo00Cooooo00<00000ooooooooool01ooo
ool00`00003oooooooooo`02ooooo`Oo0000L?ooool006oooooo1?l0000:ooooo`0300000?oooooo
oooo00Kooooo00?o0000ooooooooool01?ooool00`00003oooooooooo`04ooooo`0300000?oooooo
oooo00Sooooo00<00000ooooooooool01_ooool5o`0006gooooo001/ooooo`Co00002_ooool00`00
003oooooooooo`09ooooo`03o`000?oooooooooo00Cooooo00<00000ooooooooool01Oooool00`00
003oooooooooo`0:ooooo`0300000?oooooooooo00Sooooo0_l0001[ooooo`00JOooool4o`0000co
oooo00<00000ooooooooool02?ooool00`00003o0000ooooo`0?ooooo`0300000?oooooooooo00[o
oooo00<00000ooooooooool01Oooool2o`000003ooooool00000000006[ooooo001Vooooo`Co0000
3_ooool00`00003oooooooooo`09ooooo`0300000?l0003ooooo01gooooo00@00000oooooooooooo
oooo0ol00003ooooo`;o000000<00000ooooooooool0Ioooool006?ooooo1?l0000Looooo`030000
0?oooooo000000Oooooo00<00000ooooooooool02?ooool00`00003oooooooooo`0;ooooo`;o0000
00<00000ooooooooool01?ooool2o`0006Wooooo001Rooooo`;o00004?ooool2000000gooooo00<0
0000ooooool000001oooool00`00003oooooooooo`09ooooo`0300000?oooooooooo00Sooooo0_l0
0003ooooo`0300000?oooooooooo00?ooooo00?o0000ooooool00000J?ooool006;ooooo00Co0000
ooooool0003o00003?ooool20000017ooooo00?o0000ooooooooool01_ooool00`00003ooooooooo
o`09ooooo`0300000?oooooooooo00Gooooo0_l00006ooooo`0300000?oooooooooo00;ooooo00Co
0000oooooooooooo0000Ioooool0067ooooo00?o000000000?ooool00_ooool2o`0001gooooo00?o
0000ooooooooool01_ooool00`00003oooooooooo`0?ooooo`;o00002oooool200000004ooooool0
003oooooo`0006Oooooo001Qooooo`03o`000000003ooooo00Cooooo0_l00005ooooo`8000004?oo
ool01000003oooooooooool0000Hooooo`?o00003oooool01@00003o0000oooooooooooo000006Ko
oooo001Pooooo`;o000000<00000ooooooooool01Oooool2o`0000;ooooo00<00000ooooooooool0
4?ooool01000003oooooooooool0000Fooooo`;o00004oooool01Ol0003ooooooooooooooooo0000
06Gooooo001Oooooo`;o000000?ooooo00000?ooool02?ooool2o`0001;ooooo00D00000oooooooo
ooooooooo`000009ooooo`0300000?oooooooooo00Sooooo0_l00002ooooo`0300000?oooooooooo
013ooooo00?o0000ooooo`0000000P0000000ol0003oooooooooo`1Rooooo`00Goooool2o`0000Wo
oooo00@00000oooooooooooooooo0_l0000Dooooo`03o`000?oooooooooo00Oooooo00<00000oooo
ooooool01_ooool2o`0000Gooooo00<00000ooooooooool04?ooool01?l0003oooooooooooooool2
o`0006?ooooo001Nooooo`03o`000?oooooo000000Sooooo00<00000ooooooooool01?ooool2o`00
01;ooooo00?o0000ooooooooool01oooool00`00003oooooooooo`04ooooo`;o00006_ooool00ol0
003oooooooooo`02ooooo`;o0000H_ooool005kooooo0_l00003ooooo`0300000?oooooooooo00;o
oooo00<00000ooooooooool01oooool2o`0000[ooooo00<00000ooooooooool00oooool00ol0003o
ooooooooo`07ooooo`0400000?ooooooooooooooo`?o00007?ooool00ol0003oooooooooo`02oooo
o`0300000?l0003ooooo067ooooo001Mooooo`03o`000?oooooo000000?ooooo00<00000oooooooo
ool03_ooool2o`0000Oooooo00<00000ooooooooool00oooool00ol0003oooooooooo`0:ooooo`;o
00003_ooool00`00003oooooooooo`0?ooooo`04o`000?oooooooooo000000;ooooo00?o0000oooo
ooooool0Goooool005gooooo00?o0000ooooool000000oooool30000013ooooo0_l00004ooooo`03
00000?oooooooooo00Cooooo00?o0000ooooooooool02?ooool2o`00017ooooo00<00000oooooooo
ool03_ooool01?l0003oooooooooo`000003ooooo`03o`000?oooooooooo05kooooo001Looooo`03
o`000?oooooo000000Cooooo00?o0000ooooooooool04_ooool2o`0000Wooooo00?o0000oooooooo
ool01_ooool2o`0001Cooooo00<00000ooooooooool03Oooool00ol0003oooooooooo`05ooooo`03
o`000?oooooooooo05gooooo001Kooooo`04o`000?ooooooooooo`0000Cooooo00<00000oooooooo
ool05?ooool2o`0000Oooooo00?o0000ooooooooool01?ooool2o`0000?ooooo00<00000oooooooo
ool08?ooool00ol0003oooooooooo`05ooooo`0300000?l0003ooooo05gooooo001Kooooo`04o`00
0?ooooooooooo`0000Gooooo00<00000ooooooooool05?ooool00`00003o0000o`000005ooooo`04
o`000?ooooooooooooooo`?o00001Oooool00`00003oooooooooo`0Booooo`0300000?oooooooooo
00cooooo00?o000000000?ooool01Oooool00ol0003oooooooooo`1Looooo`00F_ooool01?l0003o
ooooooooool00003ooooo`0400000?oooooooooo000001Kooooo00<00000ooooooooool00_l00002
ooooo`03o`000?oooooooooo00;o00002?ooool00`00003oooooooooo`0Booooo`0300000?oooooo
oooo00cooooo00?o000000000?ooool01_ooool00ol0003oooooooooo`1Kooooo`00F_ooool01?l0
003oooooooooool00002ooooo`0300000?oooooooooo01Oooooo00<00000ooooooooool00oooool5
o`00023ooooo00<00000ooooooooool02oooool00ol000000000ooooo`07ooooo`03o`000?oooooo
oooo05[ooooo001Iooooo`07o`000?ooooooooooooooool0003ooooo00000006ooooo`0300000?oo
oooooooo013ooooo00<00000ooooooooool01Oooool4o`00023ooooo00<00000ooooooooool02ooo
ool00ol000000000ooooo`08ooooo`03o`000?oooooooooo05Wooooo001Iooooo`04o`000?oooooo
ooooo`0000Wooooo00<00000ooooooooool05Oooool3o`000004ooooool0003oooooooooo`Go0000
:_ooool00ol0003oooooooooo`07ooooo`0300000?l0003ooooo05Wooooo001Hooooo`05o`000?oo
ooooooooooooool000002_ooool00`00003oooooooooo`0=ooooo`0400000?ooooooooooooooo`?o
00000oooool3o`0000Kooooo1?l000000oooool00000ooooo`0Gooooo`0300000?oooooooooo00Wo
oooo00?o0000ooooooooool02?ooool00`00003o0000ooooo`1Hooooo`00Eoooool00ol0003ooooo
ooooo`02ooooo`03o`000000003ooooo00Wooooo00<00000ooooooooool03?ooool01000003ooooo
o`000?l00005ooooo`05o`000?oooooo0000ooooool000002Oooool4o`0001Kooooo00<00000oooo
ooooool02?ooool00`00003o0000ooooo`0:ooooo`03o`000?oooooooooo05Oooooo001Gooooo`06
o`000?ooooooooooooooool0000000006Oooool3o`0000Oooooo00?o0000ooooool000000_ooool0
0ol0003oooooooooo`08ooooo`0300000?oooooo000000Co00004_ooool00`00003oooooooooo`07
ooooo`0300000?oooooo000000_ooooo00?o0000ooooooooool0E_ooool005Kooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`0Eooooo`?o000000<00000ooooooooool01_ooool01?l0
003oooooooooool00003ooooo`03o`000?oooooooooo00Oooooo00<00000ooooooooool01?ooool4
o`0001Oooooo00@00000oooooooooooo00003?ooool00ol0003oooooooooo`1Eooooo`00E_ooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo00_ooooo00<00000ooooooooool01Oooool2
o`0000cooooo00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`0Aooooo`Go00004_oo
ool01000003oooooooooool0000=ooooo`03o`000?oooooooooo05Cooooo001Eooooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooooooool03Oooool01000003oooooooooooooool3o`0000gooooo
00Go0000ooooooooooooooooo`000005ooooo`03o`000?oooooooooo01Gooooo1?l00008ooooo`03
00000?oooooooooo00Kooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`1Cooooo`00
EOooool01_l0003oooooooooooooool00000o`00013ooooo0ol00006ooooo`0300000?oooooooooo
00Kooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
00Cooooo00<00000ooooooooool04Oooool5o`0000?ooooo00<00000ooooooooool01oooool00ol0
003oooooooooo`0;ooooo`03o`000?oooooooooo05?ooooo001Dooooo`03o`000?oooooooooo00;o
oooo00<00000o`000?ooool03?ooool3o`0000Wooooo00<00000ooooooooool01_ooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01?ooool00`00003o
ooooooooo`0Fooooo`Co000000D00000oooooooooooooooo00000004ooooo`03o`000?oooooooooo
00cooooo00?o0000ooooooooool0D_ooool005?ooooo00?o0000ooooooooool00_ooool00`00003o
0000ooooo`0;ooooo`;o00002oooool00`00003oooooooooo`06ooooo`03o`000?oooooooooo00Co
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`03ooooo`0300000?oooooooooo01[o
oooo1?l000000`00003oooooooooo`02ooooo`03o`000?oooooooooo00gooooo00?o0000oooooooo
ool0DOooool005?ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`07ooooo`?o0000
1oooool00`00003oooooooooo`0<ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
1?ooool01000003o0000ooooooooool6000000;ooooo10000003ooooo`<000004?ooool00`00003o
0000o`000003o`000003ooooool0003ooooo00kooooo00?o0000ooooooooool0D?ooool005;ooooo
00?o0000ooooooooool01?ooool00ol0003oooooooooo`04ooooo`?o00002_ooool00`00003ooooo
ooooo`0;ooooo`03o`000?oooooooooo00Gooooo00?o00000000000000000_ooool2000000;ooooo
00Go0000oooooooooooooooo0000000Booooo`@000000_ooool4000000;ooooo0_l000000`00003o
ooooooooo`02ooooo`?o00003oooool00ol0003oooooooooo`1?ooooo`00D_ooool01ol0003ooooo
ooooooooool00000ooooool000001Oooool2o`0000kooooo00@00000ooooooooool000002?ooool0
1?l0003oooooooooooooool2000000;ooooo00<00000o`000?ooool02?ooool01?l0003ooooooooo
o`00000Oooooo`0300000?ooool0000000Cooooo00Co0000ooooool0003o00003_ooool00ol0003o
ooooooooo`1>ooooo`00DOooool01Ol0003oooooooooooooool0000000;ooooo00?o0000oooooooo
ool00ol0000Cooooo`0300000?oooooooooo00;ooooo0`0000000ooooooo0000ooooo`02000000Go
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0Nooooo`0500000?ooool00000oooo
o`0000000oooool01?l0003oooooooooooooool2o`0000cooooo00?o0000ooooooooool0C_ooool0
057ooooo00Co0000ooooooooool000000oooool3o`0001Gooooo0`000006ooooo`03o`000?oooooo
oooo00Oooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0Oooooo`0300000?oooooo
oooo00;ooooo00<00000o`000?ooool01?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo04gooooo001@ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool05?ooool30000
00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo
02Cooooo00?o0000ooooo`0000001Oooool2o`0000_ooooo00?o0000ooooooooool0C?ooool0053o
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Booooo`80000000Cooooo00000?oo
ool000001_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00[ooooo00?o00000000
0?ooool06_ooool00`00003oooooooooo`06ooooo`03o`000?oooooooooo00;ooooo0P000003oooo
o`;o00002_ooool00ol0003oooooooooo`1;ooooo`00Coooool01?l0003oooooooooo`000003oooo
o`;o00004?ooool2000000Gooooo00<00000ooooooooool01Oooool00ol0003oooooooooo`09oooo
o`03o`000?oooooooooo00_ooooo00?o0000ooooooooool06?ooool00`00003oooooooooo`03oooo
o`0500000?ooooooooooooooool000001_ooool00`00003oooooooooo`02ooooo`;o00002Oooool0
0ol0003oooooooooo`1:ooooo`00C_ooool01?l0003oooooooooo`000003ooooo`03o`000?oooooo
000000oooooo00<00000ooooooooool03Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooo
oooo00_ooooo00<00000o`000?ooool05oooool00`00003oooooooooo`04ooooo`0500000?oooooo
ooooooooool000001oooool00`00003oooooooooo`03ooooo`;o00001oooool00ol000000000oooo
o`1:ooooo`00C_ooool00ol0003ooooo00000003ooooo`05o`000?ooooooooooooooool000006ooo
ool00`00003oooooo`00000<ooooo`03o`000?oooooooooo00_ooooo00<00000ooooool000007_oo
ool01@00003ooooooooooooooooo000000[ooooo0`000002ooooo`;o00001_ooool00ol0003ooooo
ooooo`19ooooo`00COooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooooooool02?ooool2000000Wooooo00<00000ooooooooool01?ooool00ol0003ooooooooo
o`0;ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool06oooool01@00003ooooooooo
oooooooo000000gooooo00D00000ooooooooooooooooo`000006ooooo`03o`000?oooooooooo04So
oooo001=ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00oooool00ol0003ooooo
ooooo`06ooooo`8000002oooool00`00003oooooooooo`04ooooo`03o`000000003ooooo00_ooooo
00?o0000ooooooooool03oooool00ol0003oooooooooo`0Aooooo`0300000?oooooooooo00[ooooo
00?o0000ooooooooool03_ooool01000003oooooo`000?l00005ooooo`03o`000?oooooooooo04Oo
oooo001<ooooo`03o`000?ooool0000000;ooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`03ooooo`0300000?oooooooooo00gooooo00<00000ooooooooool00oooool00ol0003ooooo
ooooo`0<ooooo`03o`000?oooooooooo00_ooooo00<00000ooooooooool00_ooool00ol0003ooooo
ooooo`0@ooooo`0300000?oooooooooo00Wooooo00?o0000ooooooooool04?ooool00`00003ooooo
ooooo`02o`0000Cooooo00?o0000ooooooooool0A_ooool004cooooo00Go000000000?oooooooooo
o`000007ooooo`03o`000?oooooooooo00;ooooo00<00000ooooooooool03_ooool00`00003ooooo
ooooo`03ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool02_ooool00`00003ooooo
ooooo`02ooooo`03o`000?oooooooooo00oooooo00<00000ooooooooool02?ooool00`00003ooooo
o`00000Cooooo`0400000?ooooooooooooooo`;o00000oooool00ol0003oooooooooo`15ooooo`00
Boooool01Ol000000000oooooooooooo000000Wooooo00Co0000ooooooooool000005_ooool00ol0
003oooooooooo`02ooooo`0300000?oooooooooo00Wooooo00?o0000ooooooooool02_ooool00`00
003oooooooooo`03ooooo`03o`000?oooooooooo01Wooooo00<00000ooooool000005_ooool30000
00;o000000?oooooo`000?ooool0A_ooool004[ooooo00Go0000ooooooooooooooooo`000008oooo
o`80000000?o0000ooooooooool05_ooool00ol0003oooooooooo`04ooooo`0300000?oooooooooo
00Sooooo00?o0000ooooooooool02_ooool00`00003oooooooooo`04ooooo`03o`000?oooooooooo
01Wooooo00<00000o`000?ooool06?ooool01@00003oooooo`000?oooooo000004Kooooo001:oooo
o`04o`000?ooooooooooo`0000Sooooo00@00000oooooooooooo00004oooool00`00003ooooooooo
o`02ooooo`03o`000?oooooooooo00Gooooo00<00000ooooooooool01oooool00ol0003ooooooooo
o`0Booooo`03o`000?oooooooooo00[ooooo00<00000ooooooooool02oooool00`00003o0000oooo
o`0Kooooo`?o0000AOooool004Wooooo00Co000000000?oooooo00003?ooool00ol0003ooooooooo
o`0Aooooo`0500000?ooooooooooooooool000004_ooool00ol0003oooooooooo`0Cooooo`03o`00
0?oooooooooo00Sooooo00<00000ooooooooool03Oooool00ol0003oooooooooo`0Looooo`;o0000
A?ooool004Wooooo00?o000000000?l000001_ooool2000000Gooooo00?o0000ooooooooool04Ooo
ool01000003oooooooooool0000;ooooo`0300000?oooooooooo00Gooooo00?o0000ooooooooool0
2_ooool00`00003oooooooooo`07ooooo`03o`000?oooooooooo00Kooooo00<00000ooooooooool0
3_ooool00ol0003oooooooooo`0Mooooo`;o0000@oooool004Sooooo00?o000000000?l000001Ooo
ool2000000Sooooo00?o0000ooooooooool04?ooool01000003oooooooooool0000<ooooo`030000
0?oooooooooo00Cooooo00?o0000ooooooooool02_ooool00`00003oooooooooo`08ooooo`03o`00
0?oooooooooo01Gooooo00?o000000000?ooool07?ooool01000003o000000000?l00013ooooo`00
B?ooool2o`0000;ooooo0P00000<ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0
3?ooool00`00003oooooooooo`03ooooo`03o`000?oooooooooo00[ooooo00<00000ooooooooool0
2Oooool00ol0003oooooooooo`0Dooooo`03o`000000003ooooo01_ooooo0_l000000`00003o0000
ooooo`13ooooo`00Aoooool2o`0000;ooooo00<00000ooooooooool03?ooool00ol0003ooooooooo
o`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool02_ooool00`00003ooooooooo
o`09ooooo`03o`000?oooooooooo00;ooooo00<00000ooooooooool03oooool00ol000000000oooo
o`0Hooooo`80000000Co0000oooooooooooo0000AOooool004Kooooo0_l0000Booooo`03o`000?oo
oooooooo00oooooo00<00000ooooool000005Oooool00ol0003oooooooooo`0Gooooo`05o`000?oo
ooooooooooooo`0000004Oooool00ol000000000ooooo`0Gooooo`0300000?l0003o000000?ooooo
00?o0000ooooooooool0@oooool004Kooooo00?o00000000000000004Oooool00ol0003ooooooooo
o`0?ooooo`0300000?l0003ooooo017ooooo00D00000ooooooooooooooooo`00000Jooooo`03o`00
0?ooool0000001;ooooo00?o0000ooooooooool05oooool01_l0003oooooooooooooool00000o`00
04Kooooo0015ooooo`;o000000<00000ooooooooool04Oooool00ol0003oooooooooo`0>ooooo`03
00000?l0003ooooo01;ooooo00@00000oooooooooooo00003Oooool00`00003oooooooooo`0;oooo
o`03o`000000003ooooo017ooooo00?o0000ooooooooool04oooool2000000;o00000oooool00`00
003o0000ooooo`16ooooo`00AOooool01?l000000000o`000000000Booooo`03o`000?oooooooooo
00kooooo00?o0000ooooooooool04oooool00`00003oooooo`00000=ooooo`0300000?oooooooooo
00cooooo00?o0000ooooooooool04?ooool00ol0003ooooo0000000Aooooo`80000000?oooooo`00
0?ooool00oooool00`00003oooooo`000017ooooo`00A_ooool00ol000000000o`000002ooooo`<0
00003Oooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo01Gooooo00?o0000oooooooo
ool02oooool00`00003oooooooooo`0:ooooo`0400000?ooooooooooo`00013ooooo00Co0000oooo
ooooool000004_ooool2o`0000Kooooo00?o0000ooooooooool0A_ooool004Oooooo00?o0000oooo
ool000001?ooool00`00003oooooooooo`0:ooooo`03o`000?oooooooooo00gooooo00?o0000oooo
ooooool05_ooool00ol0003oooooooooo`0;ooooo`0300000?oooooooooo00[ooooo00D00000oooo
ooooooooooooo`00000?ooooo`05o`000?ooooooooooooooo`0000003?ooool2000000;ooooo00?o
0000ooooooooool01_ooool00ol0003oooooooooo`16ooooo`00Aoooool01?l0003oooooooooool0
0006ooooo`8000002?ooool00ol0003oooooooooo`0<ooooo`03o`000000003ooooo01Oooooo00<0
0000o`000?ooool05oooool00`00003oooooooooo`03ooooo`03o`000?oooooooooo00cooooo00Go
0000oooooooooooooooo0000000;ooooo`0300000?oooooooooo00;o00001_ooool00`00003ooooo
o`000019ooooo`00B?ooool00ol0003ooooo00000002o`0000Kooooo00<00000ooooooooool01_oo
ool00ol0003oooooooooo`0;ooooo`03o`000000003ooooo01Sooooo00?o0000ooooooooool05Ooo
ool00`00003oooooooooo`04ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool03ooo
ool00ol0003oooooooooo`05ooooo`0300000?oooooo000004[ooooo0018ooooo`06o`000?oooooo
oooo00000?oooooo00002?ooool3000000?ooooo00?o0000ooooooooool02_ooool00ol0003ooooo
0000000Iooooo`03o`000000003ooooo01gooooo00?o0000ooooooooool02oooool00ol0003ooooo
ooooo`09ooooo`8000000_ooool2o`0000Oooooo00@00000oooooooooooo0000B_ooool004Wooooo
00Ko0000ooooooooool00000ooooool0000:ooooo`0400000?ooooooooooo`0000cooooo00?o0000
ooooo`0000006Oooool00ol0003oooooooooo`0:ooooo`0300000?oooooooooo00Kooooo00<00000
ooooooooool02?ooool00ol0003oooooooooo`0:ooooo`05o`000?ooooooooooooooo`0000001_oo
ool01@00003ooooooooooooooooo000000_ooooo00?o0000ooooooooool0BOooool004[ooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`0:ooooo`03o`0000000000000000Wooooo00?o
0000ooooooooool06_ooool01?l0003oooooooooo`000009ooooo`0300000?oooooooooo00Kooooo
00<00000ooooooooool02Oooool00ol0003oooooooooo`09ooooo`05o`000?ooooooooooooooo`00
00002Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo04[ooooo001:ooooo`07o`00
0?ooooooooooooooo`00003oooooo`00000;ooooo`04o`000?oooooooooo000000Oooooo00?o0000
ooooooooool06oooool01Ol0003oooooooooooooool0000000Sooooo00<00000ooooooooool01Ooo
ool00`00003oooooooooo`0;ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool00ooo
ool01000003ooooo000000000003ooooo`;o00002Oooool01000003oooooooooool0001<ooooo`00
Boooool01ol0003oooooooooooooool00000ooooool000002oooool00ol0003oooooooooo`02oooo
o`<000000_ooool01?l0003oooooooooo`00000Jooooo`03o`000?oooooooooo00;ooooo00<00000
ooooooooool03Oooool00`00003oooooooooo`0<ooooo`03o`000?oooooooooo00Kooooo00?o0000
ooooooooool00_ooool2o`00000300000?oooooooooo00;ooooo00?o0000ooooooooool02Oooool0
0`00003oooooo`00001=ooooo`00C?ooool01_l0003oooooooooooooool00000ooooo`;o00002Ooo
ool00ol0003oooooooooo`05ooooo`0300000?l0003ooooo00;ooooo00<00000ooooooooool06?oo
ool00ol0003oooooooooo`0Rooooo`03o`000?oooooooooo00Gooooo00?o000000000?ooool01ooo
ool2o`0000_ooooo00<00000ooooool00000C_ooool004cooooo00?o0000ooooooooool01Oooool0
0ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Gooooo00Go0000oooooooooooooooo0000
000Kooooo`03o`000?oooooooooo02;ooooo00?o0000ooooooooool01?ooool00`00003o0000oooo
o`07ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool0C?ooool004gooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Gooooo00?o0000
ooooooooool00_l00002000001Wooooo00?o0000ooooooooool01?ooool00`00003oooooooooo`03
ooooo`0300000?oooooooooo00?ooooo00<00000ooooooooool04?ooool01?l0003ooooo00000000
0003ooooo`03o`000?oooooooooo00Cooooo0_l0000?ooooo`03o`000?oooooooooo04gooooo001>
ooooo`05o`000?ooooooooooooooo`0000000oooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo00Cooooo00?o0000ooooooooool01Oooool00`00003oooooooooo`03000001?ooooo00?o
0000ooooooooool01Oooool00`00003oooooooooo`02ooooo`0300000?oooooooooo00;ooooo00<0
0000ooooooooool03Oooool2000000;ooooo00<00000o`000?ooool01?ooool00ol0003ooooooooo
o`02ooooo`0300000?l0003ooooo00gooooo00@00000oooooooooooo0000Coooool004kooooo00?o
0000ooooooooool00_ooool01@00003ooooooooooooooooo000000Kooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`0;ooooo`0400000?ooooooooooooooo`8000003Oooool00ol0003o
ooooooooo`06ooooo`0300000?oooooooooo00;ooooo00@00000ooooooooool000003_ooool20000
00Kooooo00?o0000ooooooooool00_ooool01?l0003oooooooooooooool2o`0000kooooo00@00000
oooooooooooo0000D?ooool004oooooo00?o0000ooooooooool00_ooool01000003ooooooooooooo
ool2o`0000Cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`04ooooo`0300000?oo
oooooooo00_ooooo00@00000oooooooooooooooo0P000007ooooo`03o`000?oooooooooo00_ooooo
00<00000ooooooooool02oooool2000000_ooooo00Co0000oooooooooooo00000oooool00ol0003o
oooo0000000=ooooo`0400000?ooooooooooo`00057ooooo001?ooooo`03o`000?oooooooooo00So
oooo00Go0000ooooooooooooooooo`000003ooooo`03o`000?oooooooooo00Gooooo00<00000oooo
ooooool04Oooool01000003oooooooooooooool300000003o`000?oooooooooo00Sooooo00<00000
ooooooooool03?ooool2000000kooooo00Co0000ooooool0003ooooo0_l00002ooooo`0300000?oo
oooooooo00kooooo00?o0000ooooooooool0Coooool0053ooooo00?o0000ooooooooool01?ooool0
1@00003ooooooooooooooooo000000;ooooo00Go0000ooooooooooooooooo`000007ooooo`030000
0?oooooooooo01Sooooo00?o0000ooooooooool00`000006ooooo`0400000?oooooooooo000000Co
oooo1000000Cooooo`?o00005?ooool00ol0003oooooooooo`1@ooooo`00DOooool00ol0003ooooo
ooooo`03ooooo`0300000?oooooooooo00;ooooo00?o0000ooooool000000_ooool00ol0003ooooo
ooooo`0Rooooo`03o`000?oooooooooo00;ooooo00<00000ooooooooool00`0000000oooool00000
o`000003000001Oooooo1?l0000Aooooo`0400000?ooooooooooo`0005?ooooo001Aooooo`03o`00
0?oooooooooo00Cooooo00<00000ooooooooool00_ooool01Ol0003oooooo`000?oooooo000002Co
oooo00?o0000ooooooooool02?ooool01000003o0000o`000?l0000Cooooo`Ko00000oooool00ol0
003oooooooooo`02ooooo`0300000?oooooooooo00Wooooo00D00000ooooooooooooooooo`00001C
ooooo`00D_ooool00ol0003oooooooooo`09ooooo`?o00009Oooool00ol0003oooooooooo`0Ioooo
o`Ko00002?ooool00ol0003oooooo`000003ooooo`0300000?oooooooooo00Sooooo00D00000oooo
ooooooooooooo`00001Dooooo`00Doooool00ol0003oooooooooo`09ooooo`Ko00001_ooool00`00
003oooooooooo`0Hooooo`03o`000?oooooooooo00Kooooo0P000005ooooo`8000000oooool7o`00
00gooooo00Co0000oooooooooooo00000oooool00`00003oooooooooo`0;ooooo`03o`000?oooooo
oooo05?ooooo001Cooooo`03o`000?oooooooooo00Gooooo00D00000ooooooooooooooooo`000005
ooooo`[o00005oooool00ol0003oooooooooo`04ooooo`8000001?ooool00`00003oooooo`000005
o`0001?ooooo00?o0000ooooooooool00_ooool01?l0003oooooooooo`00000=ooooo`03o`000?oo
oooooooo05?ooooo001Dooooo`03o`000?oooooooooo00Gooooo00<00000ooooooooool00_l0000:
ooooo`0400000?ooooooooooooooo`Wo00003_ooool00ol0003oooooooooo`06ooooo`Ko00001?oo
ool00`00003oooooooooo`0Booooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool02Ooo
ool01@00003ooooooooooooooooo000005Kooooo001Eooooo`03o`000?oooooooooo00Gooooo00D0
0000ooooool0003oooooo`000009ooooo`0300000?oooooooooo00[ooooo2_l00004ooooo`03o`00
0?oooooooooo00Ko00000oooool00`00003oooooooooo`0Hooooo`03o`000?oooooooooo00Cooooo
00?o0000ooooooooool02?ooool01@00003ooooooooooooooooo000005Kooooo001Eooooo`03o`00
0?oooooooooo00Oooooo00Co0000oooooooooooo00007oooool7o`00000300000?oooooooooo00Ko
oooo00<00000ooooooooool01oooool2000000kooooo00?o0000ooooooooool01Oooool00ol00000
0000ooooo`07ooooo`0500000?ooooooooooooooool00000Eoooool005Kooooo00?o0000oooooooo
ool01_ooool01Ol0003ooooooooooooooooo000002;ooooo00?o0000ooooo`0000005Oooool00`00
003oooooooooo`0;ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool02Oooool00ol0
003oooooooooo`1Fooooo`00E_ooool00ol0003oooooooooo`06ooooo`03o`000000003ooooo00;o
oooo00?o0000ooooooooool01Oooool00`00003oooooooooo`0Fooooo`0300000?l0003ooooo02?o
oooo00?o0000ooooooooool01oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo05Ko
oooo001Gooooo`03o`000?oooooooooo00Gooooo00?o0000ooooo`0000000oooool00ol0003ooooo
ooooo`04ooooo`0300000?oooooooooo01Gooooo00<00000ooooool000002oooool00`00003ooooo
ooooo`0<ooooo`0300000?oooooooooo00Kooooo00?o0000ooooooooool02?ooool00`00003o0000
ooooo`04ooooo`0500000?ooooooooooooooool00000FOooool005Sooooo00?o0000ooooooooool0
1?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00?ooooo00<00000ooooooooool0
5?ooool01000003oooooooooool0000;ooooo`0300000?oooooooooo00gooooo00<00000oooooooo
ool01?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00;ooooo00D00000oooooooo
ooooooooo`00001Jooooo`00F?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Go
oooo00?o0000ooooooooool00_ooool00`00003oooooooooo`0Hooooo`03o`000?oooooooooo00So
oooo00<00000ooooooooool03_ooool00`00003oooooooooo`03ooooo`03o`000?oooooooooo00[o
oooo00Go0000oooooooooooooooo00000004ooooo`03o`000?oooooooooo05Sooooo001Iooooo`03
o`000?oooooooooo00?ooooo00Go0000oooooooooooooooo00000004ooooo`03o`000?oooooooooo
01Cooooo0P000006ooooo`03o`000?oooooooooo00Sooooo00<00000ooooooooool04Oooool00`00
003oooooo`00000;ooooo`0400000?ooooooooooo`0000Kooooo00?o0000ooooooooool0FOooool0
05[ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`02ooooo`0300000?oooooooooo
00;ooooo00?o0000ooooooooool04Oooool2000000Sooooo00?o0000ooooooooool07Oooool00ol0
003oooooooooo`0:ooooo`0400000?ooooooooooo`0000Gooooo00?o0000ooooooooool0F_ooool0
05[ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`03ooooo`0300000?oooooooooo
00;ooooo00?o0000ooooo`0000006_ooool00ol0003oooooooooo`0Looooo`03o`000?ooool00000
00_ooooo00D00000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo05[ooooo001Koooo
o`05o`000?ooooooooooooooool000002oooool00ol000000000ooooo`0<ooooo`8000002oooool0
0ol0003oooooooooo`08ooooo`0300000?oooooooooo017ooooo00?o0000ooooooooool02oooool0
1@00003oooooooooo`00003o000000?ooooo00?o0000ooooooooool0Foooool005cooooo00Co0000
oooooooooooo00002?ooool01P00003ooooooooooooooooo0000000000[ooooo0P00000=ooooo`03
o`000?oooooooooo00Sooooo00<00000ooooooooool04?ooool00ol0003oooooooooo`03ooooo`80
00002Oooool01000003oooooooooool00002ooooo`03o`000?oooooooooo05_ooooo001Looooo`04
o`000?ooooooooooo`0000Sooooo00<00000ooooooooool00_ooool00ol0003oooooooooo`0Goooo
o`03o`000?oooooooooo00Oooooo00<00000ooooooooool04?ooool00ol0003oooooooooo`06oooo
o`0300000?oooooooooo00Wooooo00?o0000ooooool00000G_ooool005gooooo00?o0000ooooool0
00002Oooool00`00003oooooooooo`02ooooo`03o`000?oooooooooo00Cooooo00<00000oooooooo
ool04?ooool00ol0003oooooooooo`06ooooo`0300000?oooooooooo013ooooo00?o0000oooooooo
ool03?ooool00`00003oooooooooo`03ooooo`;o0000Goooool005gooooo00?o0000ooooool00000
3_ooool00ol0003oooooooooo`03ooooo`0300000?oooooooooo017ooooo00?o0000ooooooooool0
6?ooool00ol0003oooooooooo`0:ooooo`80000000?ooooo0000000000000oooool00ol0003ooooo
ooooo`1Oooooo`00G_ooool2o`0000gooooo00<00000ooooool000000oooool00`00003ooooooooo
o`0Booooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool03Oooool4000000;o0000H_oo
ool005oooooo0_l000000`00003oooooooooo`08ooooo`8000000_ooool00ol0003oooooooooo`0E
ooooo`03o`000?oooooooooo00Kooooo00<00000ooooooooool03Oooool00ol0003oooooooooo`0>
ooooo`80000000?oooooo`000?ooool0Hoooool0067ooooo00Co0000oooooooooooooooo10000002
ooooo`D0000000?oooooo`000?ooool05Oooool00ol0003oooooooooo`06ooooo`0300000?oooooo
oooo00gooooo00?o0000ooooooooool03?ooool2000000;ooooo00?o0000ooooooooool0Hoooool0
06;ooooo0_l0000:ooooo`0500000?ooool0000000000?l000005Oooool00ol0003oooooooooo`06
ooooo`0300000?oooooooooo00cooooo00?o0000ooooooooool01oooool4000000;ooooo00@00000
ooooool0003o0000I_ooool006Cooooo00?o0000ooooooooool02?ooool01@00003oooooooooo`00
003o000001Cooooo00?o0000ooooooooool01_ooool00`00003oooooooooo`0;ooooo`03o`000?oo
oooooooo00Cooooo0P000009ooooo`03o`000?oooooooooo06Kooooo001Uooooo`;o00002Oooool0
1P00003ooooooooooooooooo0000ooooo`<000004?ooool00ol0003oooooooooo`0Booooo`03o`00
0?oooooooooo00?ooooo0P000007ooooo`8000000_l0001Yooooo`00Ioooool2o`0000cooooo00?o
0000ooooooooool01?ooool3000000[ooooo00?o0000ooooooooool04_ooool01?l0003ooooo0000
00000009ooooo`80000000?oooooo`000?ooool0J_ooool006Wooooo00?o0000ooooooooool01ooo
ool01000003oooooooooool0000;ooooo`8000001Oooool00ol0003oooooooooo`0Aooooo`03o`00
00000000000000cooooo0_l0001/ooooo`00J_ooool2o`0000Sooooo00@00000oooooooooooo0000
3?ooool01P00003oooooooooooooool00000o`0000Oooooo00<00000ooooooooool01?ooool40000
0003o`000?oooooooooo00Wooooo0P0000000ooooooo0000ooooo`1]ooooo`00K?ooool00ol0003o
ooooooooo`06ooooo`0400000?ooooooooooo`00013ooooo00?o000000000?ooool01Oooool00`00
003oooooooooo`02000000Kooooo00?o0000ooooooooool02?ooool01000003oooooo`000?l0001_
ooooo`00KOooool2o`0000[ooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`02oooo
o`H000001oooool00ol0003oooooooooo`08ooooo`0300000?oooooo0000077ooooo001_ooooo`03
o`000?oooooooooo00Gooooo00@00000oooooooooooo00003_ooool00ol0003oooooooooo`05oooo
o`0300000?oooooooooo00Kooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`1`oooo
o`00L?ooool2o`0000Kooooo00@00000oooooooooooo00003Oooool00ol0003oooooooooo`04oooo
o`0300000?oooooooooo00Kooooo00?o0000ooooooooool01oooool2000000;o0000Loooool007;o
oooo00?o0000ooooooooool01?ooool01000003oooooooooool0000=ooooo`03o`000?oooooooooo
00cooooo00?o0000ooooooooool01_ooool00`00003oooooo`00001eooooo`00Loooool2o`0000So
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00Ko
oooo00<00000o`000?l00000M_ooool007Gooooo0_l00005ooooo`0300000?l0003ooooo00_ooooo
00?o0000ooooooooool00_ooool00`00003oooooooooo`05ooooo`03o`000?oooooooooo00Oooooo
00?o0000ooooooooool0M_ooool007Oooooo00?o0000ooooooooool00oooool00`00003o0000oooo
o`0:ooooo`03o`000?oooooooooo00;ooooo00<00000ooooooooool01Oooool00ol0003ooooooooo
o`04ooooo`0300000?l0003o000007Wooooo001hooooo`;o00001?ooool00`00003o0000ooooo`09
ooooo`03o`000?oooooooooo00;ooooo00<00000ooooooooool01?ooool00ol0003oooooooooo`03
ooooo`80000000?o0000ooooooooool0NOooool007[ooooo00?o0000ooooooooool00oooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00;ooooo00<00000ooooooooool00oooool00ol0
003oooooooooo`05ooooo`03o`000?oooooooooo07[ooooo001kooooo`;o00001?ooool00ol0003o
ooooooooo`06ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool00_ooool2000000;o
0000OOooool007gooooo00Ko0000oooooooooooooooo00000?l00008ooooo`03o`000?oooooooooo
00Kooooo00Oo0000oooooooooooooooo00000?oooooo000007oooooo001nooooo`;o00000oooool0
0ol0003oooooooooo`05ooooo`04o`000?oooooooooo000000Cooooo00Go0000oooooooooooooooo
00000002o`00083ooooo0020ooooo`05o`000?ooooooooooooooool000001_ooool01?l0003ooooo
ooooo`000003ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0P?ooool0087ooooo
0_l00002ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooo`0000000oooool01?l0003ooooo
ooooooooool2o`0008?ooooo0023ooooo`04o`000?ooool00000o`0000Cooooo00?o0000ooooo`00
00000oooool01?l0003oooooooooool00025ooooo`00Q?ooool2o`000003ooooool0003ooooo00;o
oooo00?o0000ooooooooool00_ooool01?l0003oooooo`000?l00026ooooo`00Q_ooool3o`0000;o
oooo00Oo0000ooooooooooooooooo`000?oooooo000008Sooooo0028ooooo`;o00000_ooool00ol0
00000000ooooo`02o`0008Wooooo0029ooooo`;o000000?oooooo`00000000000_l0002:ooooo`00
Roooool3o`0008cooooo002<ooooo`03o`000?oooooooooo08_ooooo003ooooooa_ooooo003ooooo
oa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooo
oa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooo
oa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooo
oa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooo
oa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooo
oa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooo
oa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooo
oa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooo
oa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooo
oa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooo
oa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooo
oa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooo
oa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooo
oa_ooooo0000\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-5.00005*^-6, -5.00005*^-6, \
0.00355875, 0.00355875}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.0025 w
[ .01 .012 ] 0 setdash
.56256 .57912 m
.68009 .53652 L
s
.56256 .57912 m
.64695 .41988 L
s
.53835 .42212 m
.56256 .57912 L
s
.42318 .44701 m
.56256 .57912 L
s
.40674 .56343 m
.56256 .57912 L
s
.41824 .66762 m
.56256 .57912 L
s
.54135 .68857 m
.56256 .57912 L
s
.65684 .64913 m
.56256 .57912 L
s
.42318 .44701 m
.5 .27523 L
s
.42318 .44701 m
.53835 .42212 L
s
.40674 .56343 m
.42318 .44701 L
s
.36084 .38051 m
.42318 .44701 L
s
.26321 .52582 m
.42318 .44701 L
s
.53835 .42212 m
.64695 .41988 L
s
.53835 .42212 m
.5 .27523 L
s
.26321 .52582 m
.40674 .56343 L
s
.41824 .66762 m
.40674 .56343 L
s
.64695 .41988 m
.76097 .47154 L
s
.64695 .41988 m
.68009 .53652 L
s
.64718 .34153 m
.64695 .41988 L
s
.5 .27523 m
.64695 .41988 L
s
.41824 .66762 m
.26321 .52582 L
s
.41824 .66762 m
.34918 .66239 L
s
.54135 .68857 m
.41824 .66762 L
s
.5 .75807 m
.41824 .66762 L
s
.36084 .38051 m
.5 .27523 L
s
.36084 .38051 m
.33546 .34355 L
s
.26321 .52582 m
.36084 .38051 L
s
.68009 .53652 m
.76097 .47154 L
s
.65684 .64913 m
.68009 .53652 L
s
.5 .27523 m
.64718 .34153 L
s
.33546 .34355 m
.5 .27523 L
s
.0035 w
[ ] 0 setdash
.5 .27523 m
.59455 .30616 L
s
.45357 .28826 m
.5 .27523 L
s
.0025 w
[ .01 .012 ] 0 setdash
.5 .75807 m
.54135 .68857 L
s
.65684 .64913 m
.54135 .68857 L
s
.0035 w
[ ] 0 setdash
.26321 .52582 m
.33546 .34355 L
s
.26321 .52582 m
.29275 .45797 L
s
.34918 .66239 m
.26321 .52582 L
s
.32295 .59653 m
.26321 .52582 L
s
.65684 .64913 m
.76097 .47154 L
s
.65684 .64913 m
.5 .75807 L
s
.65684 .64913 m
.66028 .63762 L
s
.64718 .34153 m
.76097 .47154 L
s
.59455 .30616 m
.64718 .34153 L
s
.32295 .59653 m
.34918 .66239 L
s
.5 .75807 m
.34918 .66239 L
s
.33546 .34355 m
.41264 .38951 L
s
.33546 .34355 m
.45357 .28826 L
s
.29275 .45797 m
.33546 .34355 L
s
.59455 .30616 m
.76097 .47154 L
s
.62074 .41788 m
.76097 .47154 L
s
.60215 .57046 m
.76097 .47154 L
s
.66028 .63762 m
.76097 .47154 L
s
.45357 .28826 m
.59455 .30616 L
s
.45357 .28826 m
.41264 .38951 L
s
.5 .75807 m
.32295 .59653 L
s
.5 .75807 m
.4491 .60337 L
s
.60215 .57046 m
.5 .75807 L
s
.66028 .63762 m
.5 .75807 L
s
.29275 .45797 m
.41264 .38951 L
s
.32295 .59653 m
.29275 .45797 L
s
.66028 .63762 m
.60215 .57046 L
s
.62074 .41788 m
.59455 .30616 L
s
.41264 .38951 m
.59455 .30616 L
s
.32295 .59653 m
.41264 .38951 L
s
.4491 .60337 m
.32295 .59653 L
s
.41264 .38951 m
.62074 .41788 L
s
.60215 .57046 m
.62074 .41788 L
s
.4491 .60337 m
.41264 .38951 L
s
.60215 .57046 m
.4491 .60337 L
s
.60215 .57046 m
.41264 .38951 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.1,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016R000`400?l00000o`00003ooooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00R_ooool5o`0008_ooooo0025ooooo`Go00000_oo
ool2o`000004ooooool0003o0000o`0008Sooooo0021ooooo`Co000000Coooooo`000?oooooooooo
0ol00002ooooo`04o`000?ooooooooooooooo`?o0000QOooool007kooooo1Ol00004ooooo`;o0000
0_ooool00ol0003oooooo`000005ooooo`03o`000?oooooo000000;o0000P_ooool007cooooo0_l0
00001?oooooo0000ooooooooool8o`0000?ooooo00Co0000oooooooooooo00000oooool01?l0003o
ooooooooooooool3o`0007oooooo001jooooo`;o00000_ooool01?l0003oooooo`000?l00002oooo
o`;o00001?ooool8o`0000Gooooo0ol000001?oooooo0000o`000?l0001looooo`00N?ooool2o`00
00;ooooo0ol00004ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01Oooool6o`00
00?ooooo00Co0000oooooooooooooooo0ol0001iooooo`00M_ooool2o`0000;ooooo0_l00002oooo
o`05o`000?ooooooooooooooool000001_ooool00ol0003oooooooooo`0;ooooo`Oo00000oooool3
o`0007Kooooo001dooooo`;o00001oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool03Oooool9o`0007?ooooo001booooo`;o00000_ooool2o`0000Go
oooo00Co0000oooooooooooo00001oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo
00Cooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`03ooooo`Co0000LOooool0073o
oooo0_l00003ooooo`03o`000?oooooooooo00Cooooo00Co0000oooooooooooo00003oooool00ol0
003oooooooooo`04ooooo`03o`000?oooooooooo00[ooooo0ol000001?oooooo0000o`000?l0001`
ooooo`00KOooool5o`0000[ooooo00?o0000ooooool000004?ooool00ol0003oooooooooo`05oooo
o`03o`000?oooooooooo00Oooooo0ol000001Ooooooo0000ooooool0003ooooo00?o0000K_ooool0
06_ooooo0_l00002ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02Oooool00ol0
003oooooooooo`0Eooooo`;o00001oooool01Ol0003oooooo`000?oooooo000006gooooo001Yoooo
o`Co00003_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00oooooo00Co0000oooo
oooooooooooo0_l00009ooooo`Co000000?oooooo`000?l00000Joooool006Oooooo1?l0000?oooo
o`;o00002_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Oooooo0ol0000;oooo
o`03o`000?oooooooooo00;o00000_ooool2o`0006Wooooo001Uooooo`;o00004_ooool2o`0001Go
oooo00?o0000ooooooooool01Oooool4o`0000cooooo00?o0000ooooooooool00_ooool3o`000003
ooooool0003ooooo06Oooooo001Sooooo`Co00004oooool00ol0003oooooooooo`0Dooooo`03o`00
0?oooooooooo00;ooooo0_l0000@ooooo`03o`000?oooooooooo00?ooooo00Co0000ooooool0003o
oooo0_l0001Vooooo`00HOooool4o`00013ooooo0_l00002ooooo`03o`000?oooooooooo00Sooooo
00?o0000ooooooooool02_ooool00ol0003oooooooooo`02o`0000Sooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
Hoooool005oooooo0_l0000Cooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`0;ooooo`;o00002oooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00Cooooo00?o0000ooooooooool00ol0001Tooooo`00G_ooool2o`0001Wooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`09ooooo`?o00003_ooool00ol0003oooooooooo`06
ooooo`03o`000?oooooooooo00Gooooo00Go0000ooooooooooooooooo`00001Tooooo`00G_ooool0
0ol0003oooooo`00000@ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`07ooooo`;o00000_ooool00ol0003oooooooooo`0Eooooo`03o`000?oooooo
oooo00Kooooo00?o0000ooooooooool00_l0001Sooooo`00GOooool01?l0003oooooooooooooool2
o`0000gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0@ooooo`;o00001?ooool0
0ol0003oooooooooo`0Fooooo`03o`000?oooooooooo00Kooooo00Go0000ooooool0003oooooo`00
001Rooooo`00GOooool01?l0003oooooooooool00002ooooo`;o00002_ooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo00kooooo0ol00007ooooo`03o`000?oooooooooo00gooooo00?o
0000ooooooooool01Oooool00ol0003oooooooooo`07ooooo`05o`000?ooooooooooooooool00000
HOooool005gooooo00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`0?ooooo`03o`00
0?oooooooooo00Sooooo00Co0000oooooooooooooooo0_l0000:ooooo`03o`000?oooooooooo00ko
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`08ooooo`05o`000?oooooooooooooo
ool00000H?ooool005cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`02ooooo`;o
00001?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo00Co0000ooooool0
003o00007_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Wooooo00Go0000oooo
ooooooooooooo`00001Oooooo`00G?ooool00ol0003oooooooooo`09ooooo`;o000000?oooooo`00
0?ooool02Oooool00ol0003oooooooooo`08ooooo`?o00009oooool00ol0003oooooooooo`07oooo
o`03o`000?oooooo000000?ooooo00?o0000ooooooooool0G?ooool005_ooooo0_l0000=ooooo`03
o`000?oooooooooo00Wooooo00?o0000ooooooooool01_ooool3o`00017ooooo00?o0000oooooooo
ool04?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Oooooo00Co0000oooooooo
oooo00000_ooool00ol0003oooooooooo`1Looooo`00Foooool00ol0003oooooooooo`05ooooo`03
o`000?oooooooooo00Gooooo0_l00008ooooo`03o`000?oooooooooo00Gooooo0_l0000Dooooo`03
o`000?oooooooooo017ooooo00Go0000ooooooooooooooooo`000009ooooo`05o`000?oooooooooo
ooooool000000_ooool00ol0003oooooooooo`1Kooooo`00F_ooool2o`0000Sooooo00Co0000oooo
ool0003o00001Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00?ooooo0_l0000G
ooooo`03o`000?oooooooooo017ooooo00Co0000oooooooooooo00003_ooool01?l0003ooooooooo
ool0001Looooo`00F_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Kooooo0_l0
0004ooooo`03o`000?oooooooooo00;ooooo0_l00004ooooo`03o`000?oooooooooo01;ooooo00?o
0000ooooooooool05?ooool00ol0003oooooooooo`0=ooooo`04o`000?ooooooooooo`0005_ooooo
001Jooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool01oooool2o`0000;ooooo00?o
0000ooooool000000_l00006ooooo`03o`000?oooooooooo02Wooooo0_l0000?ooooo`04o`000?oo
ooooooooo`0005[ooooo001Iooooo`;o00003?ooool00ol0003oooooooooo`08ooooo`04o`000?oo
oooo0000o`0000Sooooo00?o0000ooooooooool0:oooool00ol0003oooooooooo`06ooooo`03o`00
0?oooooooooo00Gooooo00Co0000oooooooooooo0000FOooool005Wooooo00?o0000ooooooooool0
1oooool00ol0003oooooooooo`0<ooooo`Ko00007?ooool00ol0003oooooooooo`0Eooooo`;o0000
1oooool00ol0003oooooooooo`06ooooo`04o`000?ooooooooooo`0005Sooooo001Hooooo`;o0000
2Oooool00ol0003oooooooooo`0:ooooo`;o000000Coooooo`000?oooooo00000_ooool7o`0001Go
oooo00?o0000ooooooooool05Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Oo
oooo00Co0000oooooooooooo0000Eoooool005Sooooo0_l00008ooooo`03o`000?oooooooooo00Co
oooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02o`0000;ooooo00?o0000oooooooo
ool01?ooool00ol0003oooooo`000006o`0000oooooo00?o0000ooooooooool05Oooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooool00000Eoooool005Sooooo
00?o0000ooooooooool03oooool00ol0003oooooooooo`02o`0000?ooooo0_l00003ooooo`03o`00
0?oooooooooo00?ooooo00?o0000ooooooooool01_ooool8o`0000Oooooo00?o0000ooooooooool0
5Oooool00ol0003oooooo`00000Aooooo`03o`000?oooooo000005Kooooo001Gooooo`;o00004_oo
ool2o`0000Cooooo00Co0000oooooooooooo00000oooool01Ol0003ooooooooooooooooo0000017o
oooo1ol0000Hooooo`04o`000?ooooooooooo`00017ooooo00?o0000ooooool00000EOooool005Oo
oooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`06ooooo`;o00001_ooool01?l0003o
ooooooooool00004ooooo`03o`000?oooooo000001Wooooo2?l0000@ooooo`05o`000?oooooooooo
ooooool000000oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooo000005Cooooo001Foooo
o`;o00002?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00;ooooo00Go0000oooo
ooooooooooooo`000002ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool06Oooool0
0ol0003oooooooooo`04ooooo`Oo00002Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooo
oooo00cooooo00?o0000ooooool00000Doooool005Kooooo0_l00007ooooo`03o`000?oooooooooo
00Cooooo0_l00005ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`0Hooooo`03o`000?oooooooooo00_ooooo1ol00003ooooo`03o`000?oooooo
oooo00?ooooo0_l0000?ooooo`03o`000?oooooo000005;ooooo001Fooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool00oooool2o`0000Sooooo00?o0000ooooool000000oooool00ol0
003oooooooooo`03ooooo`03o`000?oooooo000001[ooooo00?o0000ooooooooool04Oooool5o`00
00Gooooo0_l0000?ooooo`03o`000?oooooo0000057ooooo001Eooooo`;o00002oooool2o`0000_o
oooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`00
01Sooooo1Ol00002ooooo`Co00000_ooool4o`0000;ooooo1?l000000ooooooo0000o`000003o`00
00;ooooo00?o0000ooooool000003oooool2o`00057ooooo001Eooooo`;o00001Oooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool00oooool01Ol0003o
oooooooooooooooo000000Cooooo00?o0000ooooooooool03oooool2o`0000?ooooo00?o0000oooo
ool000005_ooool00ol0003oooooooooo`02ooooo`Co000000?oooooo`000?ooool03_ooool2o`00
053ooooo001Dooooo`;o00001_ooool00ol0003oooooooooo`02o`0000gooooo00Go0000oooooooo
ooooooooo`000002ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool03Oooool00ol0
003oooooooooo`05ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool01Oooool2o`00
00?ooooo0_l0000<ooooo`;o0000Coooool005Cooooo0_l00005ooooo`04o`000?oooooo0000o`00
00oooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool01_ooool3o`0000_ooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`07
ooooo`?o00000_ooool00ol0003oooooooooo`0:ooooo`;o0000C_ooool005?ooooo0_l00006oooo
o`;o00004Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooo000000_ooooo00?o0000oooo
ooooool00_l0000Wooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01Oooool2o`00
00kooooo0_l0001=ooooo`00Doooool2o`0000Gooooo0_l0000Aooooo`03o`000?oooooooooo00Go
oooo00Co0000oooooooooooo00001Oooool2o`0000;ooooo0_l0000Yooooo`03o`000?oooooooooo
00?ooooo00Go0000ooooooooooooooooo`000005ooooo`?o000000?oooooo`000?l000002Oooool2
o`0004cooooo001Cooooo`;o00000oooool2o`0001?ooooo00?o0000ooooooooool01_ooool2o`00
00Cooooo0_l00005ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04_ooool00ol0
003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01_ooool4o`00
00Wooooo0_l0001;ooooo`00D_ooool2o`0000;ooooo0_l000000ooooooo0000ooooo`0Aooooo`03
o`000?oooooooooo00Oooooo1?l0000:ooooo`03o`000?oooooooooo017ooooo00?o0000oooooooo
ool04_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Sooooo0_l000001?oooooo
0000o`000?l00005ooooo`;o0000B_ooool005;ooooo0_l000001Ooooooo0000oooooooooooo0000
01?ooooo00?o0000ooooooooool01oooool2o`0000gooooo0_l0000Aooooo`03o`000?oooooooooo
01;ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0:ooooo`?o000000?oooooo`00
0?ooool01?ooool00ol0003oooooooooo`18ooooo`00DOooool01?l0003oooooo`000?l00002oooo
o`03o`000?oooooooooo017ooooo00?o0000ooooooooool01?ooool2o`0000;ooooo00?o0000oooo
ool000003_ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo01;ooooo00Co0000oooo
oooooooo00005oooool2o`0000Kooooo00?o0000ooooooooool0Aoooool0057ooooo0_l0000Hoooo
o`03o`000?oooooooooo00;ooooo0_l00004ooooo`03o`000?oooooooooo00oooooo00?o0000oooo
ooooool08_ooool01?l0003oooooooooool0000Iooooo`Co00000oooool00ol0003oooooooooo`16
ooooo`00DOooool2o`0001Sooooo00?o0000ooooooooool02Oooool01Ol0003ooooooooooooooooo
000000gooooo00?o0000ooooooooool08Oooool00ol0003oooooo`000009ooooo`03o`000?oooooo
oooo017ooooo0ol00002ooooo`03o`000?oooooooooo04Gooooo001@ooooo`?o00000_ooool00ol0
003oooooooooo`0Booooo`04o`000?oooooo0000o`0000Wooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool04Oooool0
0ol0003oooooooooo`09ooooo`03o`000?oooooooooo01Cooooo1?l00016ooooo`00D?ooool2o`00
0004ooooool0003oooooo`0001Cooooo0_l0000:ooooo`;o00001Oooool00ol0003oooooooooo`0;
ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo01Kooooo0ol00015ooooo`00Coooool2o`0000;ooooo0_l0000Boooo
o`?o00003?ooool2o`0001Cooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0@oooo
o`;o00002oooool00ol0003oooooooooo`0Hooooo`;o0000A?ooool004oooooo0_l00002ooooo`03
o`000?oooooooooo013ooooo00Co0000oooooooooooo00002oooool00ol0003oooooo`00000Eoooo
o`03o`000?oooooooooo00Wooooo00?o0000ooooooooool04?ooool2o`0002Gooooo0ol00014oooo
o`00Coooool01Ol0003ooooooooooooooooo0000017ooooo00Co0000oooooooooooo00003_ooool0
0ol0003oooooooooo`05ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool06oooool0
0ol0003oooooooooo`0Rooooo`Co0000AOooool004kooooo0_l00002ooooo`;o00003Oooool2o`00
00Gooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
00cooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo
01;ooooo0_l000001?oooooo0000ooooool00015ooooo`00C_ooool01?l0003oooooooooool00002
ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0=
ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`07
ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0A
ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0A?ooool004gooooo0_l000000ooo
oooo0000ooooo`02ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool02oooool01?l0
003oooooooooool0000Hooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool03oooool0
0ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00kooooo0_l000001Ooooooo0000oooooooo
oooo000004Oooooo001=ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool2
o`0000Wooooo00?o0000ooooooooool02oooool01?l0003oooooooooool0000;ooooo`03o`000?oo
oooooooo00_ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0=ooooo`03o`000?oo
oooo000000kooooo00?o0000ooooooooool03Oooool01?l0003oooooooooool00003ooooo`03o`00
0?oooooooooo04Gooooo001<ooooo`;o00001_ooool00ol0003oooooooooo`03ooooo`;o00002_oo
ool00ol0003oooooooooo`0;ooooo`05o`000?ooooooooooooooool000003?ooool00ol0003ooooo
ooooo`0;ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool03Oooool2o`0001gooooo
0_l00002ooooo`05o`000?ooooooooooooooool00000B?ooool004cooooo0ol00005ooooo`03o`00
0?oooooooooo00oooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0Booooo`03o`00
0?oooooo000001cooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`16ooooo`00C?oo
ool00ol0003oooooo`000006ooooo`?o00003Oooool00ol0003oooooooooo`0Aooooo`03o`000?oo
oooooooo01Wooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`0>ooooo`03o`000?oo
oooooooo00Oooooo0_l00002ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0Aooo
ool004_ooooo0ol00007ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool04Oooool0
0ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool04_ooool0
0ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00Gooooo0_l00003ooooo`03o`000?oooooo
oooo00?ooooo00?o0000ooooooooool0B?ooool004_ooooo00?o0000ooooooooool00oooool2o`00
00;ooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo
00;ooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0;ooooo`;o00000_ooool00ol0
003oooooooooo`0:ooooo`04o`000?ooooooooooo`00017ooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0B?ooool0
04[ooooo0_l00004ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool03?ooool00ol0
003oooooooooo`0=ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool03_ooool00ol0
003oooooooooo`0<ooooo`03o`000?oooooo000000cooooo00Co0000oooooooooooo00004Oooool0
1?l0003oooooooooooooool2o`0000_ooooo00?o0000ooooooooool0BOooool004[ooooo0_l00003
ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0<
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool07Oooool2o`0000_ooooo00Go0000
ooooooooooooooooo`00000Dooooo`03o`000?oooooooooo00;ooooo0_l00007ooooo`03o`000?oo
oooooooo04Wooooo001:ooooo`?o00002Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo00gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooo
oooo00_ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooo
oooo013ooooo0_l00003ooooo`;o00002?ooool00ol0003oooooooooo`1:ooooo`00BOooool3o`00
00[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo
017ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo
00oooooo0_l0000=ooooo`;o0000C?ooool004Wooooo0_l000000ooooooo0000ooooo`08ooooo`03
o`000?oooooooooo00Wooooo00?o0000ooooooooool05Oooool00ol0003oooooooooo`0Booooo`03
o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0>ooooo`;o
000000?oooooo`000?ooool03?ooool00ol0003oooooooooo`1;ooooo`00B_ooool2o`0000?ooooo
0ol00004ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool03_ooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo01kooooo00Co0000oooooooooooo00001_ooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo00cooooo0_l00003ooooo`04o`000?oooooo0000o`00
00Wooooo00?o0000ooooooooool0C?ooool004_ooooo0_l00005ooooo`03o`000?oooooooooo00?o
00002_ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool07_ooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool00oooool00ol0
003oooooooooo`0;ooooo`03o`000?oooooooooo00?ooooo0_l0000;ooooo`03o`000?oooooooooo
04cooooo001;ooooo`;o00002_ooool2o`0000Sooooo00?o0000ooooooooool03oooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool02?ooool01Ol0003o
oooooooooooooooo000000;ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`09oooo
o`;o00001?ooool2o`000003ooooool0003ooooo00Wooooo00?o0000ooooooooool0COooool004co
oooo0ol00008ooooo`04o`000?ooooooooooooooo`?o00000oooool00ol0003oooooooooo`0?oooo
o`03o`000?oooooooooo00Gooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`0<oooo
o`03o`000?oooooooooo00Kooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`03oooo
o`04o`000?ooooooooooo`0000[ooooo0_l0001?ooooo`00COooool3o`0000Oooooo00?o0000oooo
ooooool01?ooool00ol0003oooooo`00000Jooooo`03o`000?oooooooooo01Gooooo00?o0000oooo
ooooool03?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Kooooo0_l000000ooo
oooo0000o`00000Aooooo`03o`000?oooooooooo04kooooo001=ooooo`04o`000?oooooo0000o`00
00Kooooo00?o0000ooooooooool01_ooool5o`0001Kooooo00?o0000ooooooooool09?ooool2o`00
00Kooooo00?o0000ooooooooool01Oooool01?l0003oooooooooool0000Booooo`;o0000D?ooool0
04kooooo0_l00007ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01Oooool3o`00
00Sooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool00oooool00ol0003oooooo`000005ooooo`03o`000?oooooooooo
00?ooooo0ol0000;ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0Coooool004ko
oooo00?o0000ooooool000000_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Co
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Oo
oooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;o
oooo00Go0000ooooooooooooooooo`000004ooooo`04o`000?ooooooooooooooo`?o00003Oooool0
0ol0003oooooooooo`06ooooo`03o`000?oooooooooo053ooooo001?ooooo`03o`000?oooooo0000
00;ooooo00Go0000ooooooooooooooooo`000006ooooo`03o`000?oooooooooo00_ooooo1?l00000
0ooooooo0000ooooo`08ooooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool00_ooool0
1?l0003oooooooooool00005ooooo`05o`000?ooooooooooo`000?ooool00ol0000?ooooo`03o`00
0?oooooooooo00Kooooo0_l0001Booooo`00D?ooool00ol0003oooooo`000002ooooo`04o`000?oo
ooooooooo`0000Gooooo00?o0000ooooooooool04Oooool4o`0000;ooooo0ol000000ooooooo0000
ooooo`0Oooooo`03o`000?oooooooooo00Oooooo00?o0000ooooool000000ol0000@ooooo`03o`00
0?oooooooooo00Kooooo00?o0000ooooooooool0DOooool0053ooooo00Co0000oooooooooooo0000
1?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo01[ooooo0_l000000ooooooo0000
o`000002o`0001Sooooo00?o0000ooooooooool02?ooool2o`000004ooooool0003o0000o`0001[o
oooo0_l0001Cooooo`00DOooool01?l0003oooooooooool00003ooooo`03o`000?oooooooooo00;o
oooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Go
oooo1?l00002ooooo`?o00003_ooool01Ol0003ooooooooooooooooo000000?ooooo0_l00002oooo
o`?o00006oooool00ol0003oooooooooo`1Booooo`00D_ooool00ol0003oooooo`000004ooooo`05
o`000?ooooooooooooooool000005?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00kooooo00Co0000oooooooooooooooo0ol00008ooooo`;o000000Coooooo`000?l0003ooooo1Ol0
0002ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`1Cooooo`00D_ooool01?l0003oooooooooool00003ooooo`;o000000?oooooo`000?ooool05?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo01Oooooo0ol00003ooooo`Go00001_oo
ool00ol0003oooooo`00000Aooooo`03o`000?oooooooooo00Cooooo0_l0001Eooooo`00Doooool0
1?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0001Gooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`0Hooooo`Oo00002Oooool01?l0003oooooooooool0000@ooooo`03
o`000?oooooooooo00Cooooo00?o0000ooooooooool0E?ooool005Cooooo00Ko0000oooooooooooo
0000ooooool00002ooooo`03o`000?oooooooooo01kooooo00?o0000ooooooooool04oooool5o`00
00?ooooo00Go0000ooooooooooooooooo`000007ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool03Oooool00ol0003oooooooooo`03ooooo`;o0000E_ooool005Cooooo00Co0000oooo
oooooooooooo0_l000001?oooooo0000ooooool0000Oooooo`03o`000?oooooooooo00oooooo1?l0
0007ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool00oooool00ol0003ooooooooo
o`0Booooo`03o`000?oooooooooo05Gooooo001Eooooo`04o`000?ooooooooooooooo`?o00000_oo
ool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02_oo
ool5o`0000Sooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`;o00000_oo
ool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo013ooooo0_l0001Gooooo`00E_ooool0
1?l0003oooooooooooooool:o`0000oooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`04ooooo`Go00003?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo0_l0
0008ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool00_ooool2o`0005Sooooo001F
ooooo`07o`000?ooooooooooooooool0003oooooo`000007oooooa;o00002?ooool00ol0003ooooo
o`000004o`00013ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`06ooooo`03o`00
0?oooooooooo00Oooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo05Oooooo001Gooooo`07o`000?ooooooooooooooool0003oooooo`000003ooooo`;o
00004?ooool00ol0003oooooooooo`0:o`00017ooooo0_l00009ooooo`03o`000?oooooooooo00Go
oooo00Co0000oooooooooooo00002?ooool00ol0003oooooooooo`08ooooo`04o`000?oooooooooo
ooooo`;o0000FOooool005Oooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooo
oooo00;ooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooo
oooo017ooooo00Go0000ooooooooooooooooo`000008ooooo`03o`000?oooooooooo00Oooooo00Go
0000ooooooooooooooooo`00001Jooooo`00F?ooool01?l0003oooooooooool00003ooooo`03o`00
0?oooooooooo01cooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0Aooooo`03o`00
0?oooooooooo00?ooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`09ooooo`;o0000
F_ooool005Wooooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`0@ooooo`03o`00
0?oooooooooo00Wooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo00gooooo00?o0000ooooooooool01oooool2o`0005_ooooo001Iooooo`04o`000?oo
ooooooooo`0000Cooooo00Go0000ooooooooooooooooo`00000=ooooo`03o`000?oooooooooo00Wo
oooo00?o0000ooooooooool02Oooool2o`0000oooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`07ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`02o`0005_ooooo001Jooooo`04o`000?ooooooooooo`0000Cooooo00Go0000oooooooo
ooooooooo`00000=ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`0>ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`04ooooo`03o`000?oooooooooo00?ooooo00Co0000ooooool0003o0000G?ooool0
05_ooooo00?o0000ooooool000001Oooool01Ol0003ooooooooooooooooo000000cooooo00?o0000
ooooooooool02Oooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`04ooooo`05o`000?ooooooooooooooool000000_oo
ool00ol0003oooooooooo`1Kooooo`00Foooool01?l0003oooooooooool00005ooooo`03o`000?oo
oooooooo01Wooooo00?o0000ooooooooool00oooool2o`0001Wooooo00?o0000ooooooooool04_oo
ool01Ol0003oooooooooool0003ooooo00;o0000GOooool005cooooo00?o0000ooooool000001_oo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo00kooooo0_l00004ooooo`03o`000?oo
oooooooo00;o0000G_ooool005gooooo0_l00007ooooo`;o00000oooool00ol0003oooooooooo`06
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool00_ooool01?l0003oooooo`000?l0
001Nooooo`00GOooool00ol0003oooooo`000008ooooo`05o`000?ooooooooooooooool000001ooo
ool00ol0003oooooooooo`0:ooooo`;o00005oooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo01Kooooo0ol0001Oooooo`00G_ooool2o`0000Wooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo01Kooooo00Go0000ooooooooooooooooo`00
000Gooooo`;o000000?oooooo`000?ooool0Goooool005kooooo00?o0000ooooool000002Oooool0
1Ol0003ooooooooooooooooo000000Gooooo00?o0000ooooooooool02Oooool00ol0003oooooo`00
000Gooooo`05o`000?ooooooooooooooool000005oooool4o`00063ooooo001Oooooo`;o00002_oo
ool01Ol0003ooooooooooooooooo000000cooooo0_l00004ooooo`03o`000?oooooooooo01Sooooo
00?o0000ooooooooool05?ooool2o`000003ooooool0003o0000067ooooo001Pooooo`;o00002_oo
ool01Ol0003ooooooooooooooooo000000[ooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`0Hooooo`03o`000?oooooooooo01?ooooo00Co0000ooooo`00003o0000Hoooool0063ooooo
0_l0000;ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`06ooooo`03o`000?oooooooooo01?ooooo00Co0000oooooooooooo00005?ooool00`00003o
0000ooooo`02o`0006Cooooo001Qooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
0_ooool00ol0003oooooo`00000=ooooo`03o`000?oooooooooo01?ooooo00Co0000oooooooooooo
00004oooool2o`000003ooooool0003ooooo06Gooooo001Rooooo`;o00000_ooool4o`0000;ooooo
1?l00004ooooo`Co00002oooool00ol0003oooooooooo`0Cooooo`03o`000?oooooo000000oooooo
0P000002ooooo`04o`000?ooooooooooo`0006Oooooo001Tooooo`03o`000?oooooooooo00Sooooo
0_l000000ooooooo0000o`000005o`0000_ooooo00?o0000ooooooooool04_ooool2o`0000oooooo
00H00000ooooooooooooooooo`000?ooool2o`0006Sooooo001Uooooo`;o00002_ooool01Ol0003o
oooooooooooooooo000000?ooooo00?o0000ooooooooool00ol00005ooooo`03o`000?oooooooooo
01?ooooo00?o0000ooooooooool02Oooool2000000Cooooo0_l000000ooooooo0000ooooo`1Yoooo
o`00Ioooool00ol0003oooooooooo`08ooooo`05o`000?ooooooooooooooool000002?ooool01?l0
003oooooooooooooool2o`0001Cooooo00?o0000ooooooooool02?ooool2000000Gooooo00Co0000
ooooool0003o0000Joooool006Sooooo0_l00009ooooo`;o00000_ooool00ol0003oooooooooo`0;
ooooo`04o`000?ooooooooooooooo`;o00003Oooool2o`0000Kooooo0P000008ooooo`03o`000?oo
oooo000006gooooo001Zooooo`;o00002Oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooo
oooo00?ooooo00Co0000oooooooooooooooo0_l00007ooooo`03o`000?oooooooooo00?ooooo0P00
0008ooooo`;o000000?oooooo`000?ooool0KOooool006cooooo00?o0000ooooooooool01oooool0
1Ol0003ooooooooooooooooo000000[ooooo00?o0000ooooooooool02Oooool00ol0003ooooooooo
o`04ooooo`04o`000?ooool00000000000_ooooo00Co0000ooooool0003o0000Koooool006gooooo
0_l00008ooooo`04o`000?ooooooooooo`0000[ooooo00?o0000ooooooooool03Oooool3o`000080
00003?ooool00ol0003oooooo`00001aooooo`00Koooool00ol0003oooooooooo`06ooooo`04o`00
0?ooooooooooo`0000[ooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0:ooooo`Co
0000L_ooool0073ooooo0_l00007ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
3Oooool00ol000000000ooooo`0:ooooo`03o`000?oooooo000007Cooooo001booooo`03o`000?oo
oooooooo00Gooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0=ooooo`03o`000?oo
oooooooo00Wooooo0ol0001eooooo`00Loooool2o`0000Kooooo00Co0000oooooooooooo00002?oo
ool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00Wooooo0_l0001gooooo`00MOooool0
0ol0003oooooooooo`04ooooo`04o`000?ooooooooooo`0000Oooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`08ooooo`?o0000N?ooool007Kooooo0_l00005ooooo`04o`000?oooooo
ooooo`0000Kooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`07ooooo`?o0000NOoo
ool007Sooooo0_l00004ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool0
0ol000000000ooooo`07ooooo`;o0000Noooool007[ooooo00?o0000ooooooooool00_ooool2o`00
0003ooooool0003ooooo00Cooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`05oooo
o`?o0000O?ooool007_ooooo0_l00004ooooo`03o`000?oooooo000000Cooooo00?o0000oooooooo
ool01oooool00ol0003oooooooooo`05ooooo`;o0000O_ooool007gooooo00?o0000ooooooooool0
0_ooool00ol0003oooooo`000004ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0
1?ooool2o`0007oooooo001nooooo`;o00000oooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo00Gooooo00?o0000ooooooooool00oooool2o`00087ooooo0020ooooo`05o`000?oooooo
ooooooooool000001?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00;ooooo0_l0
0022ooooo`00POooool2o`0000;ooooo0_l00003ooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool00_ooool2o`0008?ooooo0023ooooo`03o`000?oooooooooo00;o00000_ooool00ol0
003oooooooooo`02ooooo`0400000?l0003oooooooooo`;o0000QOooool008Cooooo0_l000001Ooo
oooo0000o`000?oooooo000000Cooooo00?o0000ooooooooool00_l00026ooooo`00Q_ooool3o`00
00;ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`26ooooo`00R?ooool4o`00
0003ooooo`00003o000000;o0000ROooool008Wooooo0ol000001?oooooo0000o`000?l0002:oooo
o`00Roooool3o`0008cooooo002<ooooo`03o`000?oooooooooo08_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo0000\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-5.00005*^-6, -5.00005*^-6, \
0.00355875, 0.00355875}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.0025 w
[ .01 .012 ] 0 setdash
.59954 .57459 m
.69877 .5249 L
s
.59954 .57459 m
.66153 .40832 L
s
.5608 .41844 m
.59954 .57459 L
s
.44915 .45153 m
.59954 .57459 L
s
.43837 .56787 m
.59954 .57459 L
s
.44591 .6707 m
.59954 .57459 L
s
.56558 .68627 m
.59954 .57459 L
s
.67262 .64122 m
.59954 .57459 L
s
.44915 .45153 m
.5 .27523 L
s
.44915 .45153 m
.5608 .41844 L
s
.43837 .56787 m
.44915 .45153 L
s
.37205 .39097 m
.44915 .45153 L
s
.28463 .53964 m
.44915 .45153 L
s
.28463 .53964 m
.43837 .56787 L
s
.44591 .6707 m
.43837 .56787 L
s
.5608 .41844 m
.66153 .40832 L
s
.5608 .41844 m
.5 .27523 L
s
.37205 .39097 m
.5 .27523 L
s
.37205 .39097 m
.32583 .35751 L
s
.28463 .53964 m
.37205 .39097 L
s
.44591 .6707 m
.28463 .53964 L
s
.44591 .6707 m
.36151 .669 L
s
.56558 .68627 m
.44591 .6707 L
s
.5 .75807 m
.44591 .6707 L
s
.28463 .53964 m
.32583 .35751 L
s
.36151 .669 m
.28463 .53964 L
s
.0035 w
[ ] 0 setdash
.28463 .53964 m
.28173 .47266 L
s
.31287 .60622 m
.28463 .53964 L
s
.0025 w
[ .01 .012 ] 0 setdash
.66153 .40832 m
.75109 .45378 L
s
.66153 .40832 m
.69877 .5249 L
s
.63975 .32946 m
.66153 .40832 L
s
.5 .27523 m
.66153 .40832 L
s
.5 .27523 m
.63975 .32946 L
s
.32583 .35751 m
.5 .27523 L
s
.0035 w
[ ] 0 setdash
.5 .27523 m
.56363 .2992 L
s
.42732 .29358 m
.5 .27523 L
s
.0025 w
[ .01 .012 ] 0 setdash
.5 .75807 m
.56558 .68627 L
s
.67262 .64122 m
.56558 .68627 L
s
.69877 .5249 m
.75109 .45378 L
s
.67262 .64122 m
.69877 .5249 L
s
.0035 w
[ ] 0 setdash
.31287 .60622 m
.36151 .669 L
s
.5 .75807 m
.36151 .669 L
s
.67262 .64122 m
.75109 .45378 L
s
.67262 .64122 m
.5 .75807 L
s
.67262 .64122 m
.65243 .6299 L
s
.32583 .35751 m
.36409 .39816 L
s
.32583 .35751 m
.42732 .29358 L
s
.28173 .47266 m
.32583 .35751 L
s
.63975 .32946 m
.75109 .45378 L
s
.56363 .2992 m
.63975 .32946 L
s
.28173 .47266 m
.36409 .39816 L
s
.31287 .60622 m
.28173 .47266 L
s
.42732 .29358 m
.56363 .2992 L
s
.42732 .29358 m
.36409 .39816 L
s
.5 .75807 m
.31287 .60622 L
s
.5 .75807 m
.42038 .60681 L
s
.56879 .56558 m
.5 .75807 L
s
.65243 .6299 m
.5 .75807 L
s
.31287 .60622 m
.36409 .39816 L
s
.42038 .60681 m
.31287 .60622 L
s
.56363 .2992 m
.75109 .45378 L
s
.58146 .41029 m
.75109 .45378 L
s
.56879 .56558 m
.75109 .45378 L
s
.65243 .6299 m
.75109 .45378 L
s
.58146 .41029 m
.56363 .2992 L
s
.36409 .39816 m
.56363 .2992 L
s
.65243 .6299 m
.56879 .56558 L
s
.42038 .60681 m
.36409 .39816 L
s
.56879 .56558 m
.42038 .60681 L
s
.36409 .39816 m
.58146 .41029 L
s
.56879 .56558 m
.58146 .41029 L
s
.56879 .56558 m
.36409 .39816 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.1,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016R000`400?l00000o`00003ooooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00R_ooool4o`00000300000?oooooooooo08Wooooo
0026ooooo`Co000000@00000ooooo`00000000000ol00029ooooo`00P_ooool4o`0000;ooooo0P00
00001Oooool00000ooooooooool0000000;ooooo0_l000000`00003oooooooooo`24ooooo`00O_oo
ool4o`0000;ooooo0P000002ooooo`0300000?oooooooooo00;ooooo00<00000ooooooooool00ooo
ool3o`0008Cooooo001jooooo`Co00001Oooool00`00003oooooooooo`07ooooo`0500000?oooooo
ooooooooo`0000001?ooool3o`00000300000?oooooooooo07kooooo001gooooo`co00001oooool0
1@00003oooooooooooooool0000000?ooooo00<00000ooooooooool01?ooool2o`0007oooooo001f
ooooo`03o`000?oooooo000000Gooooo0P000003oooooa?o00001Oooool3o`0007cooooo001doooo
o`;o000000?oooooo`000?ooool01?ooool00`00003oooooooooo`05ooooo`0300000?oooooooooo
00;ooooo00<00000ooooooooool02Oooool:o`0007[ooooo001booooo`;o00000_ooool00ol0003o
ooooooooo`0;ooooo`0300000?oooooooooo00?ooooo00<00000ooooooooool02Oooool00`00003o
ooooooooo`02ooooo`;o000000?oooooo`000?ooool00ol0001gooooo`00LOooool00ol0003ooooo
ooooo`02ooooo`04o`000?ooool00000000001Kooooo00<00000ooooooooool01?ooool01000003o
ooooo`000?l00003ooooo`05o`000?ooooooooooo`000?ooool00ol0001dooooo`00Koooool2o`00
00Cooooo00?o0000ooooo`0000002Oooool00`00003oooooooooo`0<ooooo`0300000?oooooooooo
00Cooooo0_l00005ooooo`05o`000?ooooooooooooooool000000oooool2o`0007;ooooo001^oooo
o`03o`000?oooooooooo00;ooooo0P0000000ol0003oooooooooo`08ooooo`0300000?oooooooooo
00Kooooo00<00000ooooooooool01Oooool01000003oooooooooooooool2o`0000Sooooo00Co0000
oooooooooooooooo0_l00003ooooo`?o0000Koooool006cooooo0_l00003ooooo`80000000?ooooo
o`000?ooool02Oooool00`00003oooooooooo`07ooooo`0300000?oooooooooo00Gooooo00@00000
ooooool0003o00001Oooool2000000?ooooo00?o0000ooooooooool00oooool00ol0003ooooooooo
o`03ooooo`;o0000KOooool006[ooooo0_l00007ooooo`03o`000?oooooooooo01;ooooo00<00000
ooooooooool01_ooool2o`0000Wooooo00@00000oooooooooooo00001_ooool00ol0003ooooooooo
o`04ooooo`?o000000<00000ooooooooool0Ioooool006Wooooo00Co0000oooooooooooooooo0P00
0004ooooo`03o`000?oooooooooo00Kooooo00<00000ooooooooool02Oooool00`00003ooooooooo
o`03ooooo`?o00003_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Kooooo0ol0
001Wooooo`00Ioooool2o`0000?ooooo00<00000ooooooooool00oooool00ol0003oooooooooo`06
ooooo`0300000?oooooooooo00kooooo0_l00004ooooo`0300000?oooooooooo00[ooooo00?o0000
ooooooooool01_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo06Cooooo001Uoooo
o`;o00002_ooool00ol0003oooooooooo`06ooooo`0300000?oooooooooo00gooooo0_l00006oooo
o`0300000?oooooooooo00[ooooo00?o000000000?ooool01oooool2o`0000Sooooo00?o0000oooo
ooooool0I?ooool006Cooooo00Co0000oooooooooooooooo0P000007ooooo`03o`000?oooooooooo
01?ooooo00<00000o`000?l000002Oooool00`00003oooooooooo`0:ooooo`03o`000000003ooooo
00Sooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`1Sooooo`00H_ooool2o`0000;o
oooo0P000008ooooo`03o`000?oooooooooo00Gooooo00<00000ooooooooool02oooool2o`0001So
oooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`05ooooo`0300000?l0003ooooo06?o
oooo001Qooooo`03o`0000000000000000cooooo00?o0000ooooooooool01?ooool00`00003ooooo
ooooo`0:ooooo`;o000000<00000ooooooooool05oooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00Kooooo00?o0000ooooooooool0HOooool005oooooo0_l000000`00003ooooooooo
o`0;ooooo`03o`000?oooooooooo00Cooooo00<00000ooooooooool02Oooool2o`0000;ooooo00<0
0000ooooooooool03?ooool00`00003oooooooooo`08ooooo`04o`000?ooooooooooooooo`800000
2?ooool2o`0000Oooooo00?o0000ooooooooool0H?ooool005gooooo0_l0000?ooooo`03o`000?oo
oooooooo00oooooo0_l0000Cooooo`0300000?oooooooooo00Sooooo00?o0000ooooooooool00ooo
ool00`00003oooooooooo`07ooooo`03o`000?oooooooooo00;ooooo00@00000oooooooooooo0000
HOooool005cooooo00?o00000000000000003oooool00ol0003oooooooooo`02ooooo`0300000?oo
oooooooo00Sooooo0_l0000Fooooo`0300000?oooooooooo00Oooooo00?o0000ooooooooool03_oo
ool01Ol0003oooooooooooooool0000000?ooooo00?o0000ooooooooool0G_ooool005_ooooo00?o
000000000?ooool03oooool00ol0003oooooooooo`02ooooo`0300000?oooooooooo00Oooooo0_l0
0007ooooo`0300000?oooooooooo00kooooo00<00000ooooooooool02?ooool00ol0003ooooooooo
o`05ooooo`0300000?oooooooooo00Kooooo00Go0000oooooooooooooooo00000003ooooo`03o`00
0?oooooooooo05gooooo001Kooooo`;o000000<00000ooooooooool03Oooool01Ol0003ooooooooo
ooooool0000000Sooooo0_l00009ooooo`0300000?oooooooooo01Wooooo00?o0000ooooooooool0
1_ooool00`00003oooooooooo`06ooooo`;o000000?ooooo00000?ooool00oooool00ol0003ooooo
ooooo`1Looooo`00F_ooool01Ol0003oooooooooool00000000000gooooo00?o0000ooooooooool0
2Oooool2o`0000_ooooo00<00000ooooooooool06Oooool00ol0003oooooooooo`07ooooo`030000
0?oooooooooo00Oooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`1Kooooo`00F_oo
ool01Ol0003ooooooooooooooooo000000cooooo00Go0000oooooooooooooooo00000006ooooo`;o
00003Oooool00`00003oooooooooo`0?ooooo`0300000?oooooooooo00Oooooo00?o0000oooooooo
ool04_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo05[ooooo001Jooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooo`0000002Oooool01?l0003oooooooooo`000004ooooo`?o
00008Oooool00`00003oooooooooo`07ooooo`03o`000?oooooooooo00Wooooo0P000008ooooo`03
o`000?oooooooooo00Cooooo00?o0000ooooooooool0FOooool005Wooooo00?o0000ooooooooool0
1?ooool00ol0003ooooo00000007ooooo`04o`000?oooooooooo000000?ooooo0_l0000Uooooo`03
00000?oooooooooo00Kooooo00?o0000ooooooooool02oooool00`00003oooooooooo`05ooooo`03
00000?l0003o000000Cooooo00?o0000ooooooooool0FOooool005Wooooo00?o000000000?ooool0
1Oooool00ol0003ooooo00000005ooooo`03o`000?oooooooooo00?ooooo0_l0000Cooooo`030000
0?oooooooooo017ooooo00<00000ooooooooool01_ooool00ol0003oooooooooo`0<ooooo`030000
0?oooooooooo00Cooooo00@00000oooooooooooo00001?ooool00ol0003oooooooooo`1Hooooo`00
FOooool00ol000000000ooooo`06ooooo`03o`000?oooooooooo00Cooooo00Co000000000?oooooo
oooo0_l0000Eooooo`0300000?oooooooooo01_ooooo00?o0000ooooooooool04_ooool01@00003o
oooooooooooooooo000000Cooooo00?o0000ooooooooool0Eoooool005Sooooo00?o000000000?oo
ool02?ooool00ol0003oooooooooo`0200000003o`000000003ooooo00;o00005_ooool00`00003o
ooooooooo`0Looooo`03o`000?oooooooooo00gooooo00<00000ooooooooool01oooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo05Kooooo001Hooooo`03o`000000003ooooo00Wooooo
00Co0000oooooooooooooooo0ol0000Hooooo`0300000?oooooooooo01Cooooo00<00000oooooooo
ool01Oooool00ol0003oooooooooo`0>ooooo`0300000?oooooooooo00Oooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`1Eooooo`00Eoooool00ol0003oooooooooo`0;ooooo`05o`00
0?oooooo0000o`0000000000<?ooool00`00003oooooooooo`05ooooo`03o`000?oooooooooo00oo
oooo00D00000oooooooooooooooo00000005ooooo`;o00000oooool00ol0003oooooooooo`1Doooo
o`00Eoooool00ol0003oooooooooo`0;ooooo`[o0000;?ooool00`00003oooooooooo`04ooooo`03
o`000?oooooooooo01?ooooo00<00000ooooooooool01Oooool01Ol0003ooooooooooooooooo0000
05Gooooo001Gooooo`03o`000000003ooooo00[ooooo00Go0000ooooool000000000o`000006oooo
o`oo00001?ooool00`00003oooooooooo`0Mooooo`03o`000?oooooooooo01;ooooo00<00000oooo
o`0000001oooool01Ol0003ooooooooooooooooo000005Cooooo001Fooooo`03o`000?ooool00000
00[ooooo00Co0000oooooooooooo00000_ooool01Ol0003oooooooooooooool00000013ooooo3ol0
000Fooooo`03o`000?oooooooooo01;ooooo0P000008ooooo`05o`000?ooooooooooooooool00000
Doooool005Kooooo00?o0000ooooo`0000002Oooool01_l0003oooooooooool0003oooooo`0000;o
oooo00Go0000oooooooooooooooo0000000Booooo`0300000?oooooooooo00Wooooo3ol00007oooo
o`03o`000?oooooooooo017ooooo10000008ooooo`;o00000_ooool00ol0003oooooooooo`1@oooo
o`00E_ooool00ol0003ooooo00000008ooooo`07o`000?ooooooooooooooool0003oooooo`000003
ooooo`05o`000?ooooooooooooooo`0000004Oooool00`00003oooooooooo`0Hooooo`[o00002_oo
ool3000000?ooooo00H00000ooooooooool00000ooooo`000009ooooo`04o`000?ooooooooooo`00
057ooooo001Eooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool00_ooool00ol0003o
ooooo`000004ooooo`;o0000;_ooool00`00003oooooooooo`04ooooo`03o`0000000000000000Co
00000`00000=ooooo`0300000?ooool0000000Wooooo00?o0000ooooool00000DOooool005Gooooo
00?o0000ooooooooool01oooool00ol0003oooooooooo`02ooooo`0400000?l0003oooooo`0000Ko
oooo00Go0000oooooooooooooooo0000000Yooooo`D000000_ooool00ol0003oooooooooo`04oooo
o`Co00003?ooool00`00003oooooooooo`02ooooo`8000001_ooool00ol0003oooooo`00001@oooo
o`00E?ooool01?l0003oooooooooo`000006ooooo`03o`000?oooooooooo00;ooooo00<00000o`00
0?ooool00_ooool00ol0003oooooooooo`04ooooo`05o`000?ooooooooooooooo`0000003?ooool0
0`00003oooooooooo`0Hooooo`0300000?ooool0000000Gooooo00?o0000ooooooooool02?ooool4
o`0000Kooooo00<00000ooooooooool01_ooool00`00003oooooooooo`04ooooo`?o0000Coooool0
05Cooooo00Co0000ooooooooool000001Oooool00ol0003oooooooooo`02ooooo`0300000?oooooo
000000?ooooo00?o0000ooooooooool01Oooool01Ol0003oooooooooooooool0000000_ooooo00<0
0000ooooooooool04_ooool4000000Gooooo00<00000ooooooooool00_ooool00ol0003ooooooooo
o`0<ooooo`Co00000_ooool00`00003oooooooooo`0?ooooo`;o0000C_ooool005Cooooo00?o0000
ooooo`0000001Oooool00ol0003oooooooooo`05ooooo`05o`000?ooooooooooooooool000002?oo
ool2o`0000cooooo00<00000ooooooooool03oooool2000000_ooooo00<00000ooooooooool00_oo
ool00ol0003oooooooooo`0@ooooo`Co000000?ooooo00000?ooool01oooool3000000Cooooo0_l0
001=ooooo`00Doooool01?l0003oooooooooo`000003ooooo`;o00002?ooool00ol0003ooooooooo
o`02ooooo`03o`000?oooooooooo00Oooooo00Go0000oooooooooooooooo0000000Gooooo`800000
4Oooool00ol0003oooooooooo`0Eooooo`Co00002Oooool00`00003oooooooooo`02ooooo`;o0000
C?ooool005?ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`05ooooo`0300000?oo
oooo000000Gooooo00?o0000ooooooooool02?ooool01Ol0003oooooooooooooool0000001;ooooo
0P00000Eooooo`03o`000?oooooooooo01Oooooo00<00000ooooool000000ol0000;ooooo`;o0000
Boooool005?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`06ooooo`0300000?oo
oooo000000Gooooo00?o0000ooooooooool02Oooool01Ol0003oooooooooooooool00000013ooooo
00<00000ooooooooool04_ooool01000003oooooooooool0000Iooooo`0300000?oooooooooo00?o
oooo1?l00004ooooo`8000000_ooool2o`0004[ooooo001Booooo`06o`000?ooooooooooooooo`00
003o00002?ooool01000003oooooooooool00005ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool01Oooool00`00003oooooooooo`04ooooo`8000006?ooool01000003oooooooooool0
000Cooooo`0300000?oooooooooo00gooooo1?l00002ooooo`0500000?ooooooooooooooool00000
BOooool005;ooooo00Go0000ooooooooooooooooo`000008ooooo`0500000?ooooooooooooooool0
00001_ooool00ol0003oooooooooo`0:ooooo`;o00000_ooool4000000Gooooo00<00000oooooooo
ool06?ooool01000003oooooooooool0000Cooooo`0300000?oooooooooo017ooooo1?l000001?oo
ool0000000000?l00018ooooo`00DOooool01Ol0003ooooooooooooooooo000000cooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00;ooooo0`00000N
ooooo`0400000?ooooooooooo`0001;ooooo00<00000ooooooooool01Oooool00`00003ooooooooo
o`0>ooooo`Go0000Aoooool0057ooooo00Go0000oooooooooooo000000000007ooooo`0300000?oo
oooooooo00;ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0=ooooo`03o`000?oo
oooooooo00<000008_ooool00ol0003oooooooooo`0Hooooo`0300000?oooooooooo01;ooooo0_l0
0016ooooo`00DOooool00ol0003oooooo`000009ooooo`0300000?oooooooooo00;ooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`0>ooooo`06o`000000003ooooo00000?ooool00000
8Oooool00ol0003oooooooooo`0Iooooo`0300000?oooooooooo00oooooo0_l000000ooooooo0000
ooooo`15ooooo`00D?ooool00ol0003oooooo`000009ooooo`0300000?oooooooooo00?ooooo00?o
0000ooooooooool01_ooool00ol0003oooooooooo`0:ooooo`0500000?ooooooooooooooool00000
8oooool00`00003oooooo`00000Aooooo`0300000?oooooooooo00Oooooo00<00000ooooooooool0
3_ooool01?l0003oooooooooool00017ooooo`00D?ooool2o`0000;ooooo00<00000ooooooooool0
1Oooool00`00003oooooooooo`02ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
2Oooool00`00003oooooooooo`03ooooo`;o00000oooool2000001cooooo00<00000ooooool00000
4Oooool00`00003oooooooooo`0Fooooo`;o000000Cooooo00000?oooooo0000Aoooool0053ooooo
00Go0000oooooooooooooooo0000000<ooooo`03o`000?oooooooooo00Oooooo00?o0000oooooooo
ool02?ooool00`00003oooooooooo`06ooooo`03o`000?oooooooooo00;ooooo00<00000oooooooo
ool06_ooool00`00003o0000ooooo`0?ooooo`0300000?oooooooooo01Gooooo0_l00003ooooo`03
00000?l0003o000004Oooooo001?ooooo`03o`000?oooooooooo00;ooooo00<00000ooooooooool0
2_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00?ooooo0P000009ooooo`040000
0?ooooooooooo`0000Cooooo00<00000ooooooooool06Oooool00ol0003oooooooooo`0?ooooo`03
00000?oooooooooo00Wooooo00<00000ooooooooool02?ooool00ol0003oooooooooo`02ooooo`03
00000?l0003o000004Sooooo001?ooooo`03o`000?oooooooooo00;ooooo00<00000ooooooooool0
0oooool00`00003oooooooooo`04ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
0_ooool00`00003oooooooooo`09ooooo`0500000?ooooooooooooooool000007oooool00ol0003o
ooooooooo`0Kooooo`0300000?oooooooooo00Kooooo0_l00006ooooo`;o0000B?ooool004oooooo
00?o0000ooooooooool02?ooool00`00003oooooooooo`03ooooo`03o`000?oooooooooo00Wooooo
00Go0000oooooooooooooooo0000000<ooooo`0300000?oooooooooo00;ooooo0_l00003ooooo`03
00000?oooooooooo01Oooooo00?o0000ooooooooool07?ooool00`00003oooooooooo`03ooooo`;o
00001oooool2o`0004Wooooo001?ooooo`;o00002?ooool00`00003oooooooooo`04ooooo`03o`00
0?oooooooooo00Wooooo00?o000000000?ooool03_ooool00`00003oooooooooo`04ooooo`05o`00
0?ooooooooooooooo`0000006?ooool00ol000000000ooooo`0>ooooo`0300000?oooooooooo00_o
oooo00<00000ooooooooool00_ooool00ol0003oooooooooo`05ooooo`0400000?oooooo0000o`00
04Wooooo001?ooooo`;o00000_ooool00`00003oooooooooo`0:ooooo`03o`000?oooooooooo00Wo
oooo00<00000o`000?ooool05_ooool01Ol0003oooooooooooooool0000001Oooooo00?o00000000
0?ooool03_ooool00`00003oooooooooo`0>ooooo`;o00001oooool01000003oooooo`000?l0001:
ooooo`00Coooool2o`0000;ooooo00<00000ooooooooool02_ooool00ol0003oooooooooo`08oooo
o`0300000?oooooo000001Sooooo00?o0000ooooooooool06?ooool00ol000000000ooooo`0=oooo
o`0300000?oooooooooo00gooooo0_l00008ooooo`0300000?oooooooooo00;o0000B_ooool004oo
oooo0_l000000oooool00000ooooo`03ooooo`0300000?oooooooooo00Gooooo00?o0000oooooooo
ool01Oooool2000000Cooooo00?o0000ooooooooool03Oooool00`00003oooooooooo`07ooooo`03
o`000?oooooooooo00;ooooo00<00000ooooooooool04_ooool00ol000000000ooooo`0=ooooo`03
00000?oooooooooo00cooooo00?o000000000?ooool02_ooool00ol0003oooooo`00001:ooooo`00
Coooool2o`000003ooooo`00003ooooo00?ooooo00<00000ooooooooool01Oooool00ol0003ooooo
ooooo`04ooooo`0300000?oooooooooo00Cooooo00?o0000ooooooooool03Oooool00`00003ooooo
ooooo`08ooooo`;o00000oooool00`00003oooooooooo`0Aooooo`03o`000?oooooooooo01[ooooo
0_l000000oooool00000ooooo`09ooooo`03o`000?oooooo000004_ooooo001?ooooo`03o`000?oo
oooo000000Cooooo00<00000ooooooooool01_ooool00ol0003oooooooooo`03ooooo`0300000?oo
oooooooo00Kooooo00?o0000ooooooooool02oooool00`00003oooooooooo`0;ooooo`05o`000?oo
ooooooooooooo`0000004_ooool00ol0003oooooooooo`0Hooooo`;o00001?ooool00`00003ooooo
ooooo`04ooooo`0600000?ooooooooooo`000?oooooo0000Boooool004oooooo00?o0000ooooool0
00001?ooool00`00003oooooooooo`05ooooo`03o`000?oooooooooo008000002oooool00ol0003o
ooooooooo`0;ooooo`0300000?oooooooooo00cooooo00?o0000ooooooooool04oooool00ol0003o
oooo0000000;ooooo`0300000?oooooooooo00Wooooo00?o0000ooooooooool02_ooool01P00003o
ooooooooool0003oooooo`0004cooooo001?ooooo`03o`000?oooooo000000cooooo00?o0000oooo
o`0000003Oooool00ol0003oooooooooo`0Kooooo`03o`000?oooooooooo00;ooooo00<00000oooo
ooooool03Oooool00ol0003ooooo0000000;ooooo`0300000?oooooooooo00Oooooo0_l0000<oooo
o`0700000?ooooooooooooooool0003oooooo`00001<ooooo`00Coooool00ol0003oooooo`000002
ooooo`0300000?oooooooooo00Oooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0K
ooooo`03o`000?oooooooooo00;ooooo00<00000ooooooooool02oooool01Ol0003ooooooooooooo
ool0000000Wooooo00<00000ooooooooool01_ooool2o`00017ooooo00Co0000oooooooooooo0000
C?ooool004oooooo00?o0000ooooool000000_ooool00`00003oooooooooo`05ooooo`80000000?o
0000ooooooooool03_ooool00ol0003oooooooooo`0:ooooo`0300000?oooooooooo00oooooo0_l0
0003ooooo`0300000?oooooooooo00[ooooo00Go0000oooooooooooooooo00000009ooooo`030000
0?oooooooooo00Gooooo00?o0000ooooooooool02_ooool00`00003oooooooooo`04ooooo`03o`00
0?oooooo000004gooooo001?ooooo`05o`000?ooool00000o`00000000001_ooool200000003oooo
ool0003ooooo013ooooo00?o0000ooooooooool02_ooool00`00003oooooooooo`0Aooooo`03o`00
0?oooooooooo00gooooo00?o0000ooooooooool04Oooool2o`0000gooooo00<00000ooooo`000000
0oooool01?l0003oooooooooool0001=ooooo`00Coooool01Ol0003oooooooooool00000000000Wo
oooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0:ooooo`0300000?oooooooooo01;o
oooo00?o0000ooooooooool00_ooool00`00003oooooooooo`07ooooo`03o`000?oooooooooo00oo
oooo0_l0000@ooooo`8000000_ooool01?l0003oooooooooool0001>ooooo`00Coooool01?l0003o
ooooooooool00003ooooo`8000001Oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo
00Wooooo00<00000ooooooooool04oooool00ol0003oooooooooo`02ooooo`0300000?oooooooooo
00Kooooo00?o0000ooooooooool00_ooool00`00003oooooooooo`05ooooo`0500000?oooooooooo
ooooool000004_ooool01@00003ooooooooooooooooo000000;ooooo00?o0000ooooooooool0C?oo
ool004oooooo00Co000000000?oooooo00000_ooool00`00003oooooooooo`05ooooo`03o`000?oo
oooooooo013ooooo00?o0000ooooooooool08?ooool00ol0003oooooooooo`02ooooo`0300000?oo
oooooooo00Gooooo00?o0000ooooooooool00_ooool00`00003oooooooooo`05ooooo`0400000?oo
oooo0000o`0001?ooooo00@00000oooooooooooo00000_ooool00ol0003oooooooooo`1=ooooo`00
Coooool01?l00000000000000?l00009ooooo`03o`000?oooooooooo017ooooo00?o0000oooooooo
ool08Oooool2o`0000[ooooo00?o0000ooooooooool00_ooool00`00003oooooooooo`04ooooo`03
00000?l0003o0000017ooooo0P0000000oooool00000ooooo`02ooooo`04o`000?ooooooooooo`00
04oooooo001?ooooo`05o`0000000000000000000?l000002?ooool00ol0003oooooooooo`0Aoooo
o`03o`000?oooooooooo00Sooooo00<00000ooooooooool06?ooool01?l0003oooooooooooooool2
000000Cooooo00?o0000ooooooooool00_ooool00`00003oooooooooo`04ooooo`03o`000?oooooo
oooo00oooooo0P000003ooooo`0400000?ooooooooooo`0000?ooooo00?o0000ooooooooool0COoo
ool004oooooo00Go000000000000003oooooo`000008ooooo`03o`000?oooooooooo01;ooooo00?o
0000ooooooooool01oooool00`00003oooooooooo`0Iooooo`03o`000?oooooooooo00;ooooo00D0
0000ooooooooooooooooo`000009ooooo`;o00003oooool00`00003oooooooooo`08ooooo`04o`00
0?ooooooooooo`00053ooooo001?ooooo`05o`000?ooool0000000000?l000000_ooool2000000Co
oooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`07ooooo`0300000?oooooooooo01[o
oooo00?o0000ooooooooool00_ooool01000003oooooooooool00007ooooo`;o00004?ooool00`00
003oooooooooo`08ooooo`05o`000?ooooooooooooooool00000D?ooool0053ooooo00Co00000000
0000003o00001?ooool01000003oooooooooool00002000001?ooooo00?o0000ooooooooool01ooo
ool00`00003oooooooooo`0Kooooo`;o00001Oooool00ol0003oooooooooo`03ooooo`0300000?l0
003ooooo00;ooooo00<00000ooooooooool02oooool00`00003oooooooooo`07ooooo`0300000?l0
003ooooo00;ooooo00?o0000ooooooooool0Coooool0053ooooo00Go000000000?ooooooooooo`00
0006ooooo`04o`000?oooooooooo000001?ooooo00?o0000ooooooooool09_ooool01Ol0003ooooo
oooooooooooo000000Gooooo0_l00004ooooo`0300000?oooooooooo00Kooooo0P00000=ooooo`03
00000?l0003ooooo00;ooooo00?o0000ooooooooool0Coooool0053ooooo00Go0000ooooo`00003o
ooooo`000006ooooo`03o`000?oooooooooo00Cooooo0`00000=ooooo`03o`000?oooooooooo02Oo
oooo00Go0000oooooooooooo000000000002ooooo`;o00000_ooool01000003oooooooooo`000008
ooooo`0300000?oooooooooo00cooooo00<00000o`000?ooool00oooool00ol0003oooooooooo`1?
ooooo`00DOooool01Ol000000000ooooool00000000000Gooooo00?o0000ooooooooool02_ooool4
000000Kooooo00?o0000ooooooooool01_ooool00`00003oooooooooo`0Oooooo`06o`000?oooooo
0000ooooo`00003o00001?ooool00`00003oooooooooo`0Hooooo`0300000?l0003ooooo00;ooooo
00?o0000ooooooooool0D?ooool0057ooooo00Ko0000oooooooooooo0000ooooo`000003ooooo`03
o`000?oooooooooo017ooooo100000000ol0003oooooooooo`06ooooo`0300000?oooooooooo023o
oooo1?l0000=ooooo`8000004Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo053o
oooo001Booooo`03o`000?oooooo000000Gooooo00?o0000ooooooooool05_ooool00ol000000000
00000002000000?ooooo00<00000ooooooooool07oooool4o`0000?ooooo00<00000ooooooooool0
0_ooool01000003oooooooooooooool2000001?ooooo00Go0000ooooooooooooooooo`00001Coooo
o`00D_ooool01?l0003ooooo00000?l00003ooooo`0300000?l0003ooooo01Oooooo00?o0000oooo
ooooool01?ooool2o`00008000000oooool4000001Gooooo0ol00002ooooo`03o`000?oooooo0000
00?ooooo00D00000ooooo`00003ooooo0000000Gooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool0DOooool005?ooooo00?o000000000?l000001?ooool00ol0003oooooooooo`0Foooo
o`03o`000?oooooooooo017ooooo10000002ooooo`@000000_ooool3000000Co00000P000002oooo
o`05o`000?ooooooooooooooool000000oooool5000001Gooooo00?o000000000?ooool00oooool0
0ol0003oooooooooo`1Aooooo`00Doooool00ol0003oooooo`000003ooooo`03o`000?ooool00000
01Oooooo00?o0000ooooooooool01Oooool00`00003oooooooooo`0Eooooo`?o00001_ooool01000
003oooooo`000?ooool3000000;o000000Cooooo00000000000000005oooool00ol000000000oooo
o`02ooooo`03o`000?oooooooooo05;ooooo001Cooooo`03o`000?oooooo000000?ooooo00?o0000
ooooooooool06?ooool00ol0003oooooooooo`04ooooo`0300000?oooooooooo01;ooooo0ol0000;
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooool000000P00000Eooooo`03o`000?ooool0
000000?ooooo00?o0000ooooooooool0D_ooool005Cooooo0_l00003ooooo`03o`000?oooooooooo
00;ooooo00<00000ooooooooool04oooool00ol0003oooooooooo`04ooooo`0300000?oooooooooo
00kooooo1?l0000=ooooo`03o`000?oooooooooo00Kooooo00Go000000000?oooooooooo0000000D
ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0Doooool005Cooooo00Ko0000oooo
ool000000000ooooool00005ooooo`0300000?oooooooooo01;ooooo00?o0000ooooooooool04_oo
ool3o`00017ooooo00?o0000ooooooooool00oooool2000000;ooooo0_l0000Eooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool0Doooool005Gooooo0_l000000`00003o0000ooooo`06
ooooo`0300000?oooooooooo01;ooooo00?o0000ooooooooool03Oooool4o`0001Cooooo00Co0000
oooooooooooooooo0P000006ooooo`05o`000?ooooooooooooooo`0000004?ooool00ol0003ooooo
00000002ooooo`03o`000?oooooooooo05Cooooo001Eooooo`;o000000?oooooo`000?ooool06ooo
ool00ol0003oooooooooo`0:ooooo`?o00005oooool00ol0003oooooooooo`07ooooo`0500000?oo
ooooooooooooool000000oooool00`00003oooooooooo`0<ooooo`04o`000?oooooooooo000000;o
oooo00?o0000ooooooooool0E?ooool005Kooooo00?o0000ooooool000002_ooool00`00003ooooo
ooooo`0?ooooo`03o`000?oooooooooo00?ooooo00@00000oooooooooooooooo0ol0000Jooooo`04
o`000?ooool00000000000Kooooo00<00000ooooooooool00_ooool2o`0000;ooooo00<00000oooo
ooooool02_ooool01?l0003oooooooooo`000003ooooo`03o`000?oooooooooo05Cooooo001Foooo
o`03o`000?oooooo000000_ooooo00<00000ooooooooool03_ooool00ol0003oooooooooo`03oooo
o`Co00007Oooool00ol000000000ooooo`07ooooo`0300000?oooooooooo00Cooooo00?o0000oooo
ooooool03?ooool01?l0003oooooooooo`000002ooooo`03o`000?oooooooooo05Gooooo001Foooo
o`;o00000_ooool00`00003oooooooooo`08ooooo`0300000?oooooooooo00kooooo00?o0000oooo
ool000000_l000000`00003oooooooooo`0Mooooo`03o`000?oooooooooo00Sooooo00<00000oooo
ooooool01Oooool01?l0003oooooooooo`000009ooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool0EOooool005Oooooo8Ol00003ooooo`0300000?oooooooooo01_ooooo00<00000oooo
ool000004oooool2o`000003ooooo`00003ooooo00Oooooo00?o0000ooooooooool00oooool00ol0
003oooooooooo`1Fooooo`00Eoooool01Ol0003oooooo`000?ooool0000000_ooooo0`00000<oooo
o`03o`000?oooooooooo01oooooo00@00000oooooooooooo00005Oooool00ol0003ooooo00000006
ooooo`05o`000?ooooooooooooooo`0000000_ooool00ol0003oooooooooo`1Fooooo`00F?ooool0
1Ol0003oooooo`000?ooool0000000gooooo00<00000ooooooooool02_ooool00ol0003ooooooooo
o`0Mooooo`0400000?ooooooooooo`0000[ooooo00<00000ooooooooool02_ooool00ol0003ooooo
ooooo`05ooooo`05o`000?ooooooooooooooo`0000000_ooool00ol0003oooooooooo`1Fooooo`00
FOooool00ol0003oooooo`00000Kooooo`03o`000?oooooooooo00;ooooo00<00000ooooooooool0
5Oooool00`00003oooooooooo`03ooooo`03o`000?oooooooooo00Sooooo00<00000ooooooooool0
2oooool2o`0000Cooooo00?o0000ooooooooool00_ooool00`00003oooooo`00001Iooooo`00F_oo
ool01?l0003oooooo`000?l0000Jooooo`05o`000?ooooooooooooooo`0000005_ooool00`00003o
ooooooooo`04ooooo`03o`000?oooooooooo00Oooooo00<00000ooooooooool03_ooool01?l00000
0000ooooool00005ooooo`0300000?oooooo000005Wooooo001Kooooo`04o`000?ooool00000o`00
00gooooo0P00000:ooooo`05o`000?ooooooooooooooo`0000005Oooool00`00003oooooooooo`04
ooooo`03o`000?oooooooooo00Sooooo00<00000ooooooooool03oooool00ol000000000o`000006
ooooo`03o`000?oooooooooo05Sooooo001Looooo`04o`000?ooool00000o`0000kooooo00<00000
ooooooooool02?ooool01?l0003oooooooooo`00000Looooo`03o`000?oooooooooo01[ooooo0ol0
0006ooooo`03o`000?oooooooooo05Sooooo001Looooo`05o`000?oooooooooo00000?l000006?oo
ool00ol0003oooooooooo`0Booooo`8000002Oooool00ol0003oooooooooo`0Iooooo`05o`000?oo
ooooooooooooool000000oooool00`00003o0000ooooo`1Jooooo`00GOooool01Ol0003ooooooooo
oooooooo000000oooooo00<00000ooooooooool01_ooool00ol0003oooooooooo`0?ooooo`800000
2_ooool00ol0003oooooooooo`08ooooo`0300000?oooooooooo00kooooo00?o0000ooooooooool0
0oooool2o`000003ooooo`00003o000005_ooooo001Nooooo`04o`000?ooooooooooooooo`;o0000
3_ooool00`00003oooooooooo`05ooooo`03o`000?ooool0000001_ooooo00?o0000ooooooooool0
2?ooool00`00003oooooooooo`0=ooooo`03o`000?oooooooooo00Kooooo00?o000000000?l00000
Foooool005oooooo00?o000000000?ooool00_ooool00ol0003oooooooooo`0<ooooo`0300000?oo
oooooooo00Gooooo00?o000000000?ooool02oooool2000000gooooo00?o0000ooooooooool01ooo
ool00`00003oooooooooo`0=ooooo`03o`000?oooooooooo00Oooooo0_l0001Looooo`00H?ooool0
0ol000000000ooooo`02ooooo`03o`000?oooooooooo01?ooooo00?o000000000?ooool02Oooool2
000000kooooo00?o0000ooooooooool02?ooool00`00003oooooooooo`0<ooooo`03o`000?oooooo
oooo00Kooooo00<00000o`000?ooool0GOooool0063ooooo00?o0000ooooo`0000000oooool00ol0
003oooooooooo`0=ooooo`0300000?oooooooooo00?ooooo00?o0000ooooooooool06?ooool00ol0
003oooooooooo`0Eooooo`;o00001Oooool200000003ooooool0003o000005oooooo001Qooooo`03
o`000?oooooooooo00?ooooo0_l0000>ooooo`0300000?oooooooooo00;ooooo00?o0000oooooooo
ool01Oooool00`00003oooooooooo`0@ooooo`03o`000?oooooooooo01Cooooo00?o0000oooooooo
ool00oooool2000000;ooooo00?o0000ooooooooool0Goooool006;ooooo00?o0000ooooooooool0
1?ooool00ol0003oooooooooo`0<ooooo`0300000?oooooooooo00;ooooo00?o0000ooooooooool0
0oooool00`00003oooooooooo`0@ooooo`03o`000?oooooooooo00Sooooo00<00000ooooooooool0
2Oooool01Ol0003oooooooooooooool0000000Cooooo0_l0001Rooooo`00Hoooool00ol000000000
ooooo`04ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool00_ooool00`00003ooooo
ooooo`0Aooooo`03o`000?oooooooooo00Sooooo00<00000ooooooooool02?ooool01Ol0003ooooo
ooooooooool0000000Cooooo00?o0000ooooooooool0H_ooool006Cooooo00?o0000ooooooooool0
1?ooool00ol0003oooooooooo`0=ooooo`0400000?ooool00000o`0001Kooooo00?o0000oooooooo
ool02?ooool00`00003oooooooooo`08ooooo`05o`000?ooooooooooooooo`0000000oooool2o`00
06Gooooo001Uooooo`;o00001Oooool2o`0000kooooo0P0000000ol000000000ooooo`0Dooooo`03
o`000?oooooooooo01;ooooo00?o000000000?ooool01Oooool00ol0003oooooooooo`1Uooooo`00
Ioooool01?l000000000000000000003ooooo`03o`0000000000000000?ooooo10000002ooooo`D0
000000?o000000000?ooool04oooool00ol0003oooooooooo`0@ooooo`;o00001_ooool2o`0006So
oooo001Xooooo`;o00001Oooool00ol0003oooooooooo`0;ooooo`0300000?oooooo000000?ooooo
1000000=ooooo`03o`000?oooooooooo00kooooo0P0000000ol0003oooooooooo`05ooooo`03o`00
0?oooooooooo06Sooooo001Zooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool02_oo
ool01000003oooooooooool00008ooooo`@000000_ooool3000000;ooooo00?o0000ooooooooool0
2?ooool01000003oooooooooooooool200000003ooooool0003ooooo00Gooooo0_l0001[ooooo`00
Joooool2o`0000Cooooo0_l0000;ooooo`0300000?oooooo0000017ooooo00<00000ooooool00000
0`000007ooooo`0300000?oooooooooo00?ooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`1[ooooo`00KOooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Wooooo00<0
0000ooooool000004Oooool00ol0003oooooooooo`02ooooo`0400000?ooooooooooooooo`D00000
0oooool00ol0003oooooooooo`03ooooo`;o0000K_ooool006kooooo0_l00004ooooo`03o`000?oo
oooooooo00_ooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`08ooooo`0300000?oo
oooooooo00;ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`1^ooooo`00L?ooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Wooooo00<00000o`000?ooool03oooool0
0ol0003oooooooooo`07ooooo`0400000?ooooooooooooooo`;o00001?ooool2o`00077ooooo001a
ooooo`;o00000oooool00ol0003oooooooooo`08ooooo`0300000?oooooo000000kooooo00?o0000
ooooooooool02oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo077ooooo001coooo
o`04o`000?ooooooooooooooo`;o00002Oooool00`00003o0000ooooo`0=ooooo`03o`000?oooooo
oooo00[ooooo00?o0000ooooooooool00_ooool2o`0007Cooooo001dooooo`;o00000oooool00ol0
003oooooooooo`06ooooo`0300000?oooooo000000gooooo00?o0000ooooooooool01Oooool01@00
003ooooooooooooooooo000000Cooooo00?o0000ooooooooool0M?ooool007Kooooo00Go0000oooo
ooooooooooooo`000009ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool01Oooool0
1@00003ooooooooooooooooo000000Cooooo00?o0000ooooooooool0MOooool007Oooooo0_l00002
ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`04
ooooo`0500000?ooooooooooooooool000000oooool2o`0007Sooooo001iooooo`03o`000?oooooo
oooo00;o00001_ooool00`00003o0000ooooo`0:ooooo`03o`000?oooooooooo00Oooooo00Go0000
ooooooooooooooooo`00001jooooo`00N_ooool2o`0000;ooooo00?o0000ooooooooool00oooool0
0`00003oooooo`000009ooooo`03o`000?oooooooooo00?ooooo00<00000ooooooooool00_l00002
ooooo`;o0000Noooool007cooooo00Co0000oooooooooooo00001Oooool00`00003o0000ooooo`08
ooooo`03o`000?oooooooooo00;ooooo00@00000oooooooooooo00000oooool00ol0003ooooooooo
o`1kooooo`00OOooool2o`000003ooooool0003ooooo00Gooooo00?o0000ooooooooool01_ooool0
1Ol0003oooooooooooooool0000000;ooooo00?o0000ooooooooool00_l0001nooooo`00Ooooool0
1?l0003oooooo`000?l00004ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?oo
ool01?l0003oooooooooool00020ooooo`00P?ooool2o`000003ooooool0003ooooo00;ooooo00<0
0000o`000?ooool01Oooool00ol0003oooooooooo`03ooooo`04o`000?oooooo0000o`00087ooooo
0022ooooo`03o`000?oooooo000000?ooooo00?o0000ooooooooool01?ooool02?l0003ooooooooo
o`00003oooooo`000?oooooo0000Poooool008?ooooo0ol00003ooooo`03o`000?oooooooooo00;o
oooo00Co0000ooooooooool000001?l00024ooooo`00QOooool2o`0000;ooooo00?o0000oooooooo
ool00_ooool01_l0003ooooo00000?l0003oooooo`0008Kooooo0026ooooo`?o000000?oooooo`00
0?ooool00_ooool00ol0003oooooo`000002o`0008Oooooo0028ooooo`?o000000@00000ooooool0
000000000_l00029ooooo`00ROooool3o`000004ooooool0003o0000o`0008[ooooo002;ooooo`03
o`000000003o000008cooooo002<ooooo`03o`000?oooooooooo08_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo0000\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-5.00005*^-6, -5.00005*^-6, \
0.00355875, 0.00355875}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.0025 w
[ .01 .012 ] 0 setdash
.47621 .45416 m
.63473 .56796 L
s
.47621 .45416 m
.5 .27523 L
s
.47621 .45416 m
.58185 .41311 L
s
.47119 .57044 m
.47621 .45416 L
s
.38662 .40027 m
.47621 .45416 L
s
.31094 .5517 m
.47621 .45416 L
s
.47119 .57044 m
.63473 .56796 L
s
.31094 .5517 m
.47119 .57044 L
s
.4747 .67248 m
.47119 .57044 L
s
.63473 .56796 m
.71242 .51198 L
s
.63473 .56796 m
.67184 .39558 L
s
.58185 .41311 m
.63473 .56796 L
s
.4747 .67248 m
.63473 .56796 L
s
.58835 .68293 m
.63473 .56796 L
s
.68388 .63248 m
.63473 .56796 L
s
.58185 .41311 m
.67184 .39558 L
s
.58185 .41311 m
.5 .27523 L
s
.38662 .40027 m
.5 .27523 L
s
.38662 .40027 m
.32197 .37174 L
s
.31094 .5517 m
.38662 .40027 L
s
.31094 .5517 m
.32197 .37174 L
s
.31094 .5517 m
.27803 .48748 L
s
.37742 .67486 m
.31094 .5517 L
s
.30901 .61606 m
.31094 .5517 L
s
.4747 .67248 m
.31094 .5517 L
s
.4747 .67248 m
.37742 .67486 L
s
.58835 .68293 m
.4747 .67248 L
s
.5 .75807 m
.4747 .67248 L
s
.5 .27523 m
.67184 .39558 L
s
.32197 .37174 m
.5 .27523 L
s
.0035 w
[ ] 0 setdash
.5 .27523 m
.62758 .31802 L
s
.5 .27523 m
.53006 .29504 L
s
.40391 .30106 m
.5 .27523 L
s
.0025 w
[ .01 .012 ] 0 setdash
.67184 .39558 m
.73211 .43653 L
s
.67184 .39558 m
.71242 .51198 L
s
.62758 .31802 m
.67184 .39558 L
s
.5 .75807 m
.58835 .68293 L
s
.68388 .63248 m
.58835 .68293 L
s
.71242 .51198 m
.73211 .43653 L
s
.68388 .63248 m
.71242 .51198 L
s
.0035 w
[ ] 0 setdash
.30901 .61606 m
.37742 .67486 L
s
.5 .75807 m
.37742 .67486 L
s
.32197 .37174 m
.32183 .41013 L
s
.32197 .37174 m
.40391 .30106 L
s
.27803 .48748 m
.32197 .37174 L
s
.68388 .63248 m
.73211 .43653 L
s
.68388 .63248 m
.5 .75807 L
s
.68388 .63248 m
.63934 .62256 L
s
.62758 .31802 m
.73211 .43653 L
s
.53006 .29504 m
.62758 .31802 L
s
.27803 .48748 m
.32183 .41013 L
s
.30901 .61606 m
.27803 .48748 L
s
.40391 .30106 m
.53006 .29504 L
s
.40391 .30106 m
.32183 .41013 L
s
.30901 .61606 m
.32183 .41013 L
s
.39483 .61165 m
.30901 .61606 L
s
.5 .75807 m
.30901 .61606 L
s
.5 .75807 m
.39483 .61165 L
s
.53252 .56266 m
.5 .75807 L
s
.63934 .62256 m
.5 .75807 L
s
.53006 .29504 m
.73211 .43653 L
s
.53855 .40574 m
.53006 .29504 L
s
.32183 .41013 m
.53006 .29504 L
s
.53855 .40574 m
.73211 .43653 L
s
.53252 .56266 m
.73211 .43653 L
s
.63934 .62256 m
.73211 .43653 L
s
.63934 .62256 m
.53252 .56266 L
s
.39483 .61165 m
.32183 .41013 L
s
.53252 .56266 m
.39483 .61165 L
s
.32183 .41013 m
.53855 .40574 L
s
.53252 .56266 m
.32183 .41013 L
s
.53252 .56266 m
.53855 .40574 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.1,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016R000`400?l00000o`00003oo`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00RP3oool5000008/0oooo00260?ooo`@0000000@0
ooooo`000?l0003o0000100000280?ooo`00PP3oool4000000050?ooool0003o00000?ooool00000
103oool2000000040?ooo`0000000000000008D0oooo001n0?ooo`@000000`3oool2o`000080oooo
00?o00000?ooo`3oool01@3oool200000080oooo0`0000220?ooo`00N`3oool3000000d0oooo00Go
00000?ooo`3oool0ooooo`0000020?ooo`03o`0000000000oooo00<0oooo0`00001o0?ooo`00M`3o
ool4000000H0oooo0_l000040?ooo`04o`00003oool0oooo0?ooo``00000103oool3000007`0oooo
001c0?ooo`@000000`3ooolA00000003o`00003oool0oooo0080oooo00Ko0000000000000000oooo
0000003oool5000000<0oooo0`00001i0?ooo`00L03oool:000000`0oooo00?o00000?ooo`3oool0
0P3oool00ol00000oooo0?ooo`020?ooo`070000003oool0oooo0?ooo`000000ooooo`0000020000
0080oooo100000020?ooo`<00000MP3oool006l0oooo00<000000?ooo`0000002P3oool2o`0000L0
oooo00?o00000?ooo`3oool01P3oool2000000@0oooo00H000000?ooo`3ooooo00000?ooo`000005
0?ooo`@0000000@0oooo0000000000000000L`3oool006h0oooo00<000000?ooo`0000002P3oool0
0ol00000oooo0?ooo`0>0?ooo`8000001P3oool01`000000oooo0?ooo`3ooooo00000?ooo`000000
203oool700000700oooo001]0?ooo`030000003oool0000001<0oooo00?o00000?ooo`3oool0103o
ool2000000H0oooo00?o00000?ooo`0000001P3oool2000000X0oooo1P00001]0?ooo`00K03oool0
0`000000oooo000000080?ooo`;o00002@3oool00ol00000oooo0?ooo`040?ooo`030000003ooooo
000000H0oooo00Co00000?ooo`3oool000001@3oool2o`0000030000003oool0oooo00/0oooo1@00
001Z0?ooo`00J`3oool010000000oooo0?ooo`0000060?ooo`;o00002P3oool00ol00000oooo0?oo
o`030?ooo`8000000P3oool00ol00000oooo0?ooo`050?ooo`03o`00003oool0000000L0oooo00?o
00000000000000003`3oool2000006T0oooo001Z0?ooo`040000003oool0oooo000001L0oooo0P00
00030?ooo`03o`00003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo06L0oooo001X0?ooo`8000000P3oool00`000000oooo0?ooo`02
0?ooo`;o0000403oool200000100oooo00<000000?ooo`3oool0203oool00ol0000000000000000>
0?ooo`030000003oool0oooo06H0oooo001W0?ooo`050000003oool0oooo0?ooo`000000103oool0
0ol00000oooo0?ooo`0<0?ooo`04o`00003oool0oooo00000180oooo00<000000?ooo`3oool02P3o
ool00ol0000000000?ooo`0=0?ooo`030000003oool0oooo06D0oooo001V0?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool0403oool01?l00000oooo00000000000C0?ooo`030000003o
ool0oooo00/0oooo00?o00000000003oool03@3oool00`000000oooo0?ooo`1T0?ooo`00I@3oool0
0`000000oooo0?ooo`020?ooo`040000003ooooo0000o`0000l0oooo00?o00000000000000002P3o
ool00ol00000oooo0?ooo`080?ooo`0300000?l00000oooo00d0oooo0P00000<0?ooo`800000I@3o
ool006@0oooo00<000000?ooo`3oool00P3oool00`00003o0000o`00000@0?ooo`800000303oool0
0ol00000oooo0?ooo`080?ooo`030000003oool0oooo00d0oooo0_l000000`000000oooo0?ooo`09
0?ooo`030000003oool0000006@0oooo001S0?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool03`3oool00ol0000000000?ooo`0<0?ooo`03o`00003oool0oooo00T0oooo00<000000?oo
o`3oool0403oool2000000X0oooo00<000000?ooo`000000H`3oool00640oooo0P0000030?ooo`;o
000000<000000?ooo`3oool03P3oool2000001X0oooo00@000000?ooo`3ooooo00004@3oool00`00
0000oooo0?ooo`070?ooo`040000003oool0oooo00000680oooo001P0?ooo`030000003oool0oooo
0080oooo00?o00000?ooo`0000003`3oool200000003o`00003oool0oooo01T0oooo00@000000?oo
o`3ooooo00004@3oool00ol0000000000000000:0?ooo`030000003oool0oooo0600oooo001O0?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool0303oool2000001l0oooo00@000000?oo
o`3ooooo00004P3oool00ol0000000000?ooo`090?ooo`030000003oool0oooo05l0oooo001N0?oo
o`030000003oool0oooo00;o00000P3oool00`000000oooo0?ooo`0;0?ooo`800000503oool00ol0
0000oooo0?ooo`0:0?ooo`050000003oool0oooo0?ooool000004P3oool00ol0000000000?ooo`06
0?ooo`040000003oool0oooo00000600oooo001M0?ooo`040000003ooooo0000o`0000@0oooo00<0
00000?ooo`3oool02P3oool01@000000oooo0?ooo`3ooooo00000180oooo00?o00000?ooo`3oool0
2P3oool00`000000oooo0?ooo`0F0?ooo`8000001@3oool01@000000oooo0?ooo`3oool0000005l0
oooo001L0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool02@3oool2000000<0oooo
00?o00000?ooo`3oool04@3oool00ol00000oooo0?ooo`0:0?ooo`030000003oool0oooo01H0oooo
0_l000000`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`000000GP3oool005/0oooo
00<00000o`00003oool01@3oool00`000000oooo0?ooo`080?ooo`800000103oool00ol00000oooo
0?ooo`0B0?ooo`03o`00003oool0oooo00X0oooo00<000000?ooo`3oool00P3oool00ol00000oooo
0?ooo`0D0?ooo`800000203oool00`000000oooo0?ooo`1K0?ooo`00FP3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo00H0oooo0P00000X0?ooo`030000003oool0oooo00<0oooo00?o
00000?ooo`3oool05@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo05X0oooo001J
0?ooo`0300000?l00000oooo00D0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`04
0?ooo`03o`00003oool0oooo0240oooo00<000000?ooo`3oool0103oool00ol00000oooo0?ooo`0E
0?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`1I0?ooo`00F@3oool2
000000<0oooo0ol000000`000000oooo0?ooo`050?ooo`8000001P3oool00ol00000oooo0?ooo`0D
0?ooo`03o`00003oool0oooo00/0oooo00<000000?ooo`3oool07@3oool2000000030?ooo`000000
oooo00@0oooo00<000000?ooo`3oool0F03oool005T0oooo0P0000050?ooo`0300000?l00000oooo
00@0oooo0P0000070?ooo`03o`00003oool0oooo01D0oooo00?o00000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0N0?ooo`04o`0000000000oooo000000@0oooo00<000000?ooo`3oool0F03oool0
05T0oooo0P0000050?ooo`050000003oool0oooo0?ooool000000P00000Q0?ooo`03o`00003oool0
oooo00/0oooo00<000000?ooo`3oool01@3oool00ol00000oooo0?ooo`0H0?ooo`8000001@3oool0
0`000000oooo0?ooo`1G0?ooo`00F03oool00`000000oooo000000040?ooo`030000003oool0oooo
0080oooo00<00000o`00003oool08@3oool00ol00000oooo0?ooo`0;0?ooo`030000003oool0oooo
00H0oooo00?o00000?ooo`3oool0603oool00ol0000000000?ooo`040?ooo`030000003oool0oooo
05H0oooo001H0?ooo`030000003oool0000000<0oooo00@000000?ooo`3oool0oooo0P0000020?oo
o`03o`00003oool0oooo00D0oooo00?o00000?ooo`3oool09P3oool00`000000oooo0?ooo`060?oo
o`03o`00003oool0oooo01T0oooo0P0000040?ooo`030000003oool0oooo05D0oooo001H0?ooo`03
00000?l0000000000080oooo00<000000?ooo`3oool00P0000080?ooo`;o000000<0ooooo`00003o
ool0:03oool00`000000oooo0?ooo`0Q0?ooo`;o00000P0000040?ooo`030000003oool0oooo05@0
oooo001G0?ooo`040000003oool0oooo00000080oooo0`00000<0?ooo`?o0000603oool00ol00000
oooo0?ooo`0=0?ooo`030000003oool0oooo01/0oooo1?l000030?ooo`040000003oool0oooo0000
00@0oooo00<000000?ooo`3oool0D`3oool005L0oooo00D000000?ooo`3oool000000?ooo`020000
00d0oooo00Go00000?ooo`3oool0ooooo`00000G0?ooo`03o`00003oool0oooo00d0oooo00<00000
0?ooo`3oool0203oool00ol00000oooo0?ooo`0:0?ooo`Co00002P3oool00`000000oooo0?ooo`02
000000<0oooo00<000000?ooo`3oool0DP3oool005H0oooo00@000000?ooo`3oool0oooo0`00000>
0?ooo`03o`00003oool0oooo00/0oooo8P0000070?ooo`03o`00003oool0oooo00@0oooo1?l0000?
0?ooo`03o`00003oool0oooo0080oooo0P0000030?ooo`030000003oool0oooo0540oooo001F0?oo
o`040000003oool0ooooo`0001l000003P3oool00ol00000oooo0?ooo`0=0?ooo`040000003oool0
oooo0?ooo`L0000000<0ooooo`00003oool00_l0000E0?ooo`03o`00003oool0oooo00@0oooo0P00
00000`3oool000000?ooo`1B0?ooo`00EP3oool01`000000oooo0?ooool0000000000?ooo`000000
3@3oool00ol00000oooo0?ooo`060?ooo`03o`00003oool0oooo0240oooo00<000000?ooo`3oool0
203oool700000180oooo00?o00000?ooo`3oool01P3oool2000000030?ooo`000000oooo0540oooo
001E0?ooo`040000003oool0oooo0?ooo`<0000000<0oooo0000003oool05@3oool00ol00000oooo
0?ooo`0P0?ooo`030000003oool0oooo00@0oooo0_l000030?ooo`03o`00003oool0oooo00<0oooo
1`00000;0?ooo`04o`00003oool0oooo000000L0oooo0`00001A0?ooo`00E@3oool010000000oooo
0?ooo`3oool300000080oooo0P00000G0?ooo`03o`00003oool0oooo00d0oooo00?o00000?ooo`3o
ool03@3oool00`000000oooo0?ooo`020?ooo`;o00001P3oool00ol00000oooo0?ooo`090?ooo`H0
0000203oool00`000000oooo0?ooo`050?ooo`@00000D03oool005D0oooo00D000000?ooo`3oool0
00000?ooo`02000000@0oooo00<000000?ooo`3oool01P3oool00ol00000oooo0?ooo`0<0?ooo`03
o`00003oool0oooo00`0oooo00?o00000?ooo`3oool03@3oool00`00003o0000o`00000L0?ooo`L0
00000P3oool00`000000oooo0?ooo`070?ooo`800000C`3oool005@0oooo00@000000?ooo`3oool0
00000P3oool00`000000oooo000000040?ooo`8000001@3oool00ol00000oooo0?ooo`0>0?ooo`03
o`00003oool0oooo00X0oooo00?o00000?ooo`3oool03P3oool00`000000oooo0?ooo`0P0?ooo`03
o`00003oool0oooo00L000001P3oool2000004h0oooo001D0?ooo`090000003oool0oooo0000003o
oooo00000000003oool0000000H0oooo00D000000?ooo`3oool0ooooo`00000N0?ooo`03o`00003o
ool0oooo00h0oooo00<000000?ooo`3oool02`3oool00ol00000oooo0?ooo`0B0?ooo`03o`00003o
ool0oooo00L0oooo1`0000000`3oool000000?ooo`1<0?ooo`00D`3oool010000000oooo0?ooo`00
00020?ooo`04o`0000000000oooo000000L0oooo00<000000?ooo`3oool05@3oool2o`0001@0oooo
0_l000030?ooo`030000003oool0oooo00/0oooo00?o00000?ooo`3oool04P3oool00ol00000oooo
0?ooo`030?ooo`030000003oool0oooo00P0oooo0`00001<0?ooo`00D`3oool010000000oooo0?oo
o`0000020?ooo`050000003oool0oooo0?ooo`0000001`3oool2000001L0oooo00?o00000?ooo`3o
ool0403oool00ol00000oooo0?ooo`030?ooo`030000003oool0oooo00`0oooo00?o00000?ooo`3o
ool04@3oool00ol00000oooo0?ooo`030?ooo`030000003oool0oooo00P0oooo00<000000?ooo`00
0000C03oool005<0oooo00<000000?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000P0
oooo00?o00000000003oool07@3oool00ol00000oooo0?ooo`040?ooo`;o0000203oool00`000000
oooo0?ooo`0<0?ooo`03o`00003oool0oooo01P0oooo00<000000?ooo`3oool01@3oool200000003
0?ooo`000000000004`0oooo001B0?ooo`040000003oool0oooo000000<0oooo00D000000?ooo`3o
ool0oooo000000080?ooo`03o`00003oool0000001P0oooo0ol000020?ooo`03o`00003oool0oooo
0080oooo0_l0000:0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool0103oool01@00
0000oooo0?ooo`3oool0000004d0oooo001B0?ooo`030000003oool0000000@0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`040?ooo`04o`00003oool0oooo0?ooo`8000006@3oool2
o`0000030?ooool0003o000000d0oooo00<000000?ooo`3oool0803oool00ol00000oooo0?ooo`0:
0?ooo`8000000`3oool2000004d0oooo001B0?ooo`8000001@3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo00@0oooo00?o00000?ooo`3oool00`3oool00`000000oooo0?ooo`0G0?oo
o`;o00003`3oool00`000000oooo0?ooo`0>0?ooo`03o`00003oool0oooo00l0oooo00?o00000?oo
o`3oool0203oool2000000D0oooo0P00001=0?ooo`00D@3oool00`000000oooo000000050?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool02`3oool2000001D0oooo0ol000000`3ooooo
00000?ooo`0=0?ooo`030000003oool0oooo00h0oooo00?o00000?ooo`3oool03P3oool00ol00000
oooo0?ooo`070?ooo`8000001P3oool00`000000oooo0000001=0?ooo`00D@3oool2000000D0oooo
00?o00000000003oool0103oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0100oooo
0_l000020?ooo`04o`00003oool0ooooo`0000d0oooo00<000000?ooo`3oool03`3oool00ol00000
oooo0?ooo`0=0?ooo`03o`00003oool0oooo00H0oooo0P0000070?ooo`<00000C@3oool00500oooo
00<000000?ooo`0000001@3oool00ol0000000000?ooo`040?ooo`050000003oool0oooo0?ooool0
00002`3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo00l0oooo00?o00000?ooo`3o
ool05@3oool010000000oooo0?ooo`0000050?ooo`040000003oool00000000004d0oooo001@0?oo
o`8000001`3oool00`000000oooo0?ooo`040?ooo`040000003oool0ooooo`0000`0oooo0P00000<
0?ooo`;o00002P3oool3o`0000T0oooo00<000000?ooo`3oool09@3oool2000000<0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0000001>0?ooo`00D03oool2000000L0oooo00<000000?oo
o`3oool0103oool00`000000ooooo`00000?0?ooo`030000003oool0oooo00P0oooo00?o00000?oo
o`3oool01@3oool00ol00000oooo0?ooo`050?ooo`03o`00003oool0oooo00H0oooo00<000000?oo
o`3oool07`3oool00ol00000oooo0?ooo`020?ooo`030000003oool0oooo00P0oooo00@000000?oo
o`3oool00000CP3oool004l0oooo0P0000070?ooo`03o`0000000000oooo00D0oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`060?ooo`03o`00003oool0oooo00H0oooo00?o00000?oo
o`3oool03P3oool00`000000oooo0?ooo`0@0?ooo`03o`00003oool0oooo00`0oooo00?o00000?oo
o`3oool00P00000;0?ooo`040000003oool0oooo000004h0oooo001?0?ooo`030000003oool0oooo
00H0oooo00?o00000000003oool01P3oool00`000000oooo0?ooo`0@0?ooo`8000000`3oool00ol0
0000oooo0?ooo`090?ooo`03o`00003oool0oooo00L0oooo0_l000050?ooo`030000003oool0oooo
0100oooo00?o00000?ooo`3oool02`3oool01?l00000oooo0?ooo`0000090?ooo`040000003oool0
oooo00000080oooo00<000000?ooo`3oool0C@3oool004l0oooo00<000000?ooo`3oool01P3oool0
0ol0000000000?ooo`050?ooo`03o`0000000000oooo01<0oooo00<000000?ooool00000303oool0
0ol00000oooo0?ooo`090?ooo`03o`00003oool0oooo0080oooo00<000000?ooo`3oool04@3oool0
0ol00000oooo0?ooo`0:0?ooo`03o`0000000000000000X0oooo00@000000?ooo`3oool000000P3o
ool00`000000oooo0?ooo`1=0?ooo`00CP3oool00`000000oooo0?ooo`070?ooo`03o`0000000000
oooo00D0oooo00?o00000000003oool0503oool2000001T0oooo00Go00000?ooo`3oool0oooo0000
000C0?ooo`03o`00003oool0oooo00T0oooo0P00000=0?ooo`8000000`3oool00`000000oooo0?oo
o`1=0?ooo`00CP3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00<0oooo00Co0000
0?ooo`3oool00000403oool2o`0000@0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?oo
o`0L0?ooo`030000003oool0oooo00d0oooo0P0000020?ooo`800000C`3oool004h0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`040?ooo`04o`00003oool0oooo000000l0oooo00?o
00000?ooo`3oool01@3oool00`000000oooo0?ooo`080?ooo`03o`00003oool0oooo00`0oooo0_l0
00000`000000oooo0?ooo`0J0?ooo`80000000<0ooooo`00003oool03@3oool01@000000oooo0?oo
o`3oool000000500oooo001?0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`0<0?ooo`03o`00003oool0oooo00L0oooo0P0000080?ooo`03o`00003o
ool0oooo00h0oooo00<000000?ooo`3oool04P3oool00ol00000oooo0?ooo`040?ooo`050000003o
ool0oooo0?ooool000003P3oool01@000000oooo0?ooo`3oool000000500oooo001?0?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0G0?ooo`030000
003oool0oooo00D0oooo00?o00000?ooo`3oool03P3oool00`00003o00000?ooo`0B0?ooo`03o`00
003oool0oooo0080oooo0P0000040?ooo`03o`00003oool0oooo00/0oooo00<000000?ooo`000000
0P3oool00`000000oooo0?ooo`1>0?ooo`00C`3oool00`00003o00000?ooo`060?ooo`030000003o
ool0oooo00<0oooo00?o00000?ooo`3oool00P3oool00`000000oooo0?ooo`080?ooo`;o00003P3o
ool00`000000oooo0?ooo`040?ooo`03o`00003oool0oooo00h0oooo00<000000?ooo`3oool04`3o
ool01?l00000oooo0?ooo`0000060?ooo`03o`00003oool0oooo00/0oooo00@000000?ooo`000000
oooo0P00001@0?ooo`00C`3oool00`00003o00000?ooo`060?ooo`030000003oool0oooo0080oooo
00?o00000?ooo`3oool00`3oool00`000000oooo0?ooo`060?ooo`;o00004@3oool2000001D0oooo
00<000000?ooo`3oool00ol0000@0?ooo`03o`0000000000000001@0oooo00@000000?ooo`3oool0
oooo0P00001A0?ooo`00C`3oool00`000000ooooo`0000060?ooo`050000003oool0oooo0?ooool0
00001`3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3o
ool00`3oool00ol00000oooo0?ooo`0=0?ooo`030000003oool0oooo01@0oooo00@000000?ooo`3o
ool0oooo0P00001A0?ooo`00D03oool00`00003o00000?ooo`050?ooo`030000003oool0oooo00T0
oooo00@000000?ooo`3oool0oooo0_l0000H0?ooo`030000003oool0oooo0140oooo00<000000?oo
o`3oool04@3oool2000000T0oooo00?o00000?ooo`3oool02P3oool00`000000oooo0?ooo`020?oo
o`800000D@3oool00500oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0:0?ooo`03
0000003ooooo000001/0oooo0P0000000ol00000oooo0?ooo`0>0?ooo`030000003oool0oooo00D0
oooo0_l000080?ooo`8000000`3oool00ol00000oooo0?ooo`050?ooo`03o`00003oool0oooo00X0
oooo00D000000?ooo`3oool0ooooo`00000200000540oooo001@0?ooo`030000003oool0oooo00@0
oooo00?o00000000003oool02`3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo00h0
oooo00<000000?ooo`3oool01`3oool00ol00000oooo0?ooo`040?ooo`030000003oool0oooo00<0
oooo00?o00000?ooo`3oool0103oool00ol00000oooo0?ooo`0:0?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool0D03oool00500oooo00@000000?ooo`3ooooo00000`3oool01Ol00000
00000?ooo`3ooooo000000L0oooo0_l000000`000000oooo0?ooo`0L0?ooo`04o`00003oool00000
000000h0oooo00<000000?ooo`3oool0203oool01?l00000oooo0?ooo`3oool2000000L0oooo00?o
00000?ooo`3oool00`3oool00ol00000oooo0?ooo`0:0?ooo`0300000?l0003o000000<0oooo00<0
00000?ooo`3oool0D03oool00500oooo00@000000?ooo`3ooooo00000`3oool01Ol0000000000?oo
o`3ooooo000000H0oooo00Go00000?ooo`3oool0oooo0000000Q0?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`070?ooo`03o`00003oool0oooo00l0
oooo00<00000o`00003oool0103oool00`000000oooo0?ooo`1@0?ooo`00D@3oool010000000oooo
0?ooool000030?ooo`030000003ooooo000000/0oooo00<000000?ooo`3oool0803oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo0P000002o`0001X0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`1@0?ooo`00D@3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00<0oooo0_l000060?ooo`030000003oool0oooo0240oooo0P0000090?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool00P3oool00ol00000oooo0?ooo`0;0?ooo`03o`00
003oool0oooo00L0oooo00?o00000000003oool01@3oool00`000000oooo0?ooo`1A0?ooo`00D@3o
ool00`000000oooo0?ooo`040?ooo`040000003oool0oooo0?ooo`;o00002@3oool00`000000oooo
0?ooo`0J0?ooo`03o`00003oool0oooo00D0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`070?ooo`8000003P3oool00ol00000oooo0?ooo`020?ooo`03o`00003oool0oooo00H0oooo
00?o00000?ooo`0000001P3oool00`000000oooo0?ooo`1A0?ooo`00D@3oool00`000000oooo0?oo
o`020?ooo`03o`000000003o000000h0oooo00<000000?ooo`3oool06P3oool00ol00000oooo0?oo
o`060?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`070?ooo`;o00001@3oool01Ol00000oooo0?ooo`3ooooo000000P0oooo00?o00000?ooo`000000
1P3oool2000005<0oooo001B0?ooo`060000003oool0oooo0?ooool0000000000_l0000=0?ooo`03
0000003oool0oooo01X0oooo00?o00000?ooo`3oool01`3oool2000000D0oooo00<000000?ooo`3o
ool0103oool2000000`0oooo00?o00000?ooo`3oool00`3oool01?l00000oooo0?ooool0000:0?oo
o`030000003oool0oooo00@0oooo0P00001C0?ooo`00DP3oool00`000000oooo0?ooo`020?ooo`03
00000?l00000oooo00h0oooo00<000000?ooo`3oool06@3oool00ol00000oooo0?ooo`090?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool2000000l0oooo00?o00000?ooo`3o
ool02`3oool01Ol00000oooo0?ooo`3oool0000000P0oooo00<000000?ooo`3oool0D@3oool00580
oooo00<000000?ooo`3oool00P3oool01000003o0000o`000?l000020?ooo`?o0000203oool00`00
0000oooo0?ooo`0V0?ooo`8000000P3oool01@000000oooo0?ooo`3oool0000001h0oooo00?o0000
0?ooo`3oool00P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0580oooo001B0?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool01P3oool00ol00000oooo0?ooo`04o`00
00030?ooo`000000oooo02T0oooo00@000000?ooo`000000oooo0P00000D0?ooo`;o00000`3oool0
0ol00000oooo0?ooo`020?ooo`03o`00003oool0oooo0080oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`1B0?ooo`00DP3oool00`000000oooo0?ooo`020?ooo`0500000?l00000oooo
0?ooool000003@3oool01000003o0000o`000?l000020?ooo`?o00004P3oool00ol00000oooo0?oo
o`0=0?ooo`<00000603oool01_l00000ooooo`000?l00000ooooo`0000L0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`1B0?ooo`00D`3oool01@000000oooo0?ooo`3oool0000000@0
oooo00?o00000?ooo`3oool02P3oool00`000000oooo0?ooo`060?ooo`04o`00003oool0oooo0?oo
o`?o00002`3oool00ol00000oooo0?ooo`0=0?ooo`<000006@3oool4o`0000L0oooo00<000000?oo
o`3oool01P3oool2000005@0oooo001C0?ooo`050000003oool0oooo0?ooo`0000000P3oool01?l0
0000oooo0?ooool0000<0?ooo`030000003oool0oooo00l0oooo1?l000040?ooo`03o`00003oool0
oooo00X0oooo0`0000000`3oool000000?ooo`0200000004o`00003oool0oooo0?ooo`?o00000`3o
ool4o`000080oooo1?l000020?ooo`Co0000203oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo05<0oooo001C0?ooo`050000003oool0oooo0?ooo`0000000P3oool00ol00000oooo0?oo
o`0=0?ooo`030000003oool0oooo01D0oooo1_l000020?ooo`Co00000`000003o`0000050?ooo`00
003o0000o`00003oool00P00000E0?ooo`;o000000<0ooooo`00003oool01@3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo05<0oooo001C0?ooo`050000003oool0oooo0?ooo`000000
0`3oool00ol00000oooo0?ooo`020?ooo`03o`00003oool0oooo00L0oooo00<000000?ooo`3oool0
5`3oool00ol00000oooo0?ooo`040?ooo`<000001`3oool00`000000oooo0?ooo`030?ooo`800000
4@3oool2o`0000040?ooool00000ooooo`0000H0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`1C0?ooo`00E03oool010000000oooo0?ooo`0000030?ooo`03o`00003oool0oooo00<0
oooo00?o00000?ooo`3oool01`3oool00`000000oooo0?ooo`0F0?ooo`04o`00003oool0oooo0?oo
o`<000002@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0100oooo00Go00000?oo
o`3oool0ooooo`0000040?ooo`030000003oool0oooo00L0oooo0P00001E0?ooo`00E03oool01000
0000oooo0?ooo`00000:0?ooo`03o`00003oool0oooo00H0oooo00<000000?ooo`3oool05P3oool0
1?l00000000000000000000<0?ooo`030000003oool0oooo00L0oooo0P00000;0?ooo`03o`00003o
ool0oooo0080oooo00?o00000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo05@0oooo001D0?ooo`040000003oool0oooo000001<0oooo00<000000?ooo`3oool0503o
ool3000000l0oooo00<000000?ooo`3oool02@3oool2000000P0oooo00?o00000?ooo`3oool02`3o
ool00`000000oooo0?ooo`070?ooo`800000EP3oool005@0oooo00@000000?ooo`3oool00000103o
ool00ol00000oooo0?ooo`060?ooo`;o00001@3oool00`000000oooo0?ooo`0@0?ooo`<000004P3o
ool00`000000oooo0?ooo`0;0?ooo`8000001@3oool00ol00000oooo0?ooo`0:0?ooo`03o`00003o
ool0000000T0oooo0P00001F0?ooo`00E03oool010000000oooo0?ooo`0000050?ooo`03o`00003o
ool0oooo00L0oooo00?o00000?ooo`3oool00P3oool00`000000oooo0?ooo`0=0?ooo`<000005@3o
ool00`000000oooo0?ooo`0=0?ooo`8000002@3oool00ol00000oooo0?ooo`050?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool0E03oool005D0oooo0P0000070?ooo`03o`00003oool0
oooo00/0oooo00<000000?ooo`3oool02P3oool3000000P0oooo00?o00000?ooo`3oool03@3oool0
0`000000oooo0?ooo`0>0?ooo`03o`0000000000000000L0oooo00?o00000?ooo`3oool01@3oool0
0`00003o00000?ooo`080?ooo`030000003oool0oooo05D0oooo001E0?ooo`8000004`3oool01?l0
0000oooo0?ooo`0000080?ooo`<000002`3oool00ol00000oooo0?ooo`0<0?ooo`030000003oool0
oooo00h0oooo00Co00000?ooo`3oool0oooo0P0000040?ooo`03o`00003oool0oooo00D0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`1E0?ooo`00E@3oool2000001@0oooo00?o0000
0?ooo`0000001@3oool3000000h0oooo00?o00000?ooo`3oool0303oool00`000000oooo0?ooo`0D
0?ooo`8000002P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo05D0oooo001E0?oo
o`800000203oool00ol00000oooo0?ooo`0:0?ooo`04o`0000000000oooo0?ooo`<000004@3oool0
0ol00000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00?o00000?ooo`3oool0203oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo0080oooo00?o00000?ooo`3oool01@3oool0
0`000000oooo0?ooo`1E0?ooo`00E@3oool2000000P0oooo00?o00000?ooo`3oool01P3oool80000
02<0oooo00<000000?ooo`3oool02P3oool00ol00000oooo0?ooo`0:0?ooo`8000001P3oool00`00
0000oooo0?ooo`030?ooo`03o`00003oool0oooo00<0oooo0P00001G0?ooo`00EP3oool00`000000
oooo0?ooo`030?ooo``000001P3oool00`00003o00000?ooo`0R0?ooo`030000003oool0oooo00T0
oooo00?o00000?ooo`3oool02`3oool01?l00000oooo0000000000030?ooo`030000003oool0oooo
00D0oooo00?o00000?ooo`3oool00P3oool00`000000oooo0?ooo`1F0?ooo`00EP3oool6000000D0
oooo00?o00000?ooo`3oool02`3oool00`00003o00000?ooo`0B0?ooo`03o`00003oool0oooo00`0
oooo00<000000?ooo`3oool01P3oool00ol00000oooo0?ooo`0>0?ooo`04o`00003oool0oooo0?oo
o`80000000<0oooo0000003oool02`3oool00`000000oooo0?ooo`1F0?ooo`00F03oool00`000000
oooo0?ooo`0E0?ooo`0300000?l00000oooo0140oooo00?o00000?ooo`3oool02`3oool00`000000
oooo0?ooo`060?ooo`03o`00003oool0oooo00h0oooo00?o00000?ooo`3oool0103oool3000000/0
oooo00<000000?ooo`3oool0EP3oool005T0oooo00<000000?ooo`3oool05@3oool00`000000oooo
0?ooo`0@0?ooo`03o`00003oool0oooo00/0oooo00<000000?ooo`3oool01@3oool00ol00000oooo
0?ooo`0E0?ooo`040000003oool0oooo0?ooo`D000000`3oool01?l00000oooo00000000001H0?oo
o`00FP3oool2000000H0oooo00?o00000?ooo`3oool0303oool00`000000oooo0?ooo`02o`0000h0
oooo00?o00000?ooo`3oool02`3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo00L0
oooo100000000ol0000000000?ooo`1H0?ooo`00F`3oool2000000H0oooo00?o00000?ooo`3oool0
303oool01@000000oooo0?ooo`3ooooo000001/0oooo00@000000?ooo`3oool0oooo0_l0000B0?oo
o`03o`00003oool0oooo00<0oooo00<000000?ooo`3oool0303oool2000005T0oooo001M0?ooo`03
0000003oool0oooo00@0oooo00?o00000?ooo`3oool0303oool00`000000oooo0?ooo`0L0?ooo`04
0000003ooooo0000o`0001@0oooo00?o00000?ooo`3oool00P3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo05T0oooo001N0?ooo`8000004`3oool00`000000oooo0?ooo`030?ooo`03
o`00003oool0oooo01H0oooo00<000000?ooo`3oool0503oool00ol00000oooo0?ooo`020?ooo`03
0000003oool0oooo00/0oooo0P00001L0?ooo`00G`3oool2000001<0oooo00<000000?ooo`3oool0
0`3oool00ol00000oooo0?ooo`080?ooo`03o`00003oool0oooo00T0oooo00<00000o`00003oool0
5@3oool01Ol00000oooo0?ooo`3oool0000000/0oooo0`00001N0?ooo`00H03oool2000000<0oooo
00?o00000?ooo`3oool03@3oool00`000000oooo0?ooo`030?ooo`03o`00003oool0oooo00L0oooo
00?o00000?ooo`3oool0203oool00ol0000000000?ooo`0I0?ooo`030000003oool0oooo00T0oooo
0`00001O0?ooo`00HP3oool2000000030?ooool00000oooo00l0oooo00<000000?ooo`3oool0303o
ool00ol00000oooo0?ooo`070?ooo`03o`00003oool0000001T0oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`1O0?ooo`00H`3oool2000000030?ooool00000oooo00h0oooo00<00000
0?ooo`3oool01@3oool00ol00000oooo0?ooo`0@0?ooo`030000003oool0oooo01@0oooo00?o0000
0?ooo`0000002@3oool2000000030?ooo`000000oooo0640oooo001T0?ooo`<0000000?o00000?oo
o`3oool03@3oool00`000000oooo0?ooo`050?ooo`03o`00003oool0oooo00T0oooo0_l000040?oo
o`030000003oool0oooo01@0oooo00?o00000000003oool01`3oool2000000030?ooo`0000000000
06<0oooo001U0?ooo`<00000403oool00`000000oooo0?ooo`050?ooo`03o`00003oool0oooo00L0
oooo00?o00000?ooo`3oool0103oool00`000000oooo0?ooo`0C0?ooo`03o`0000000000oooo00X0
oooo00<000000?ooo`3oool0H`3oool006L0oooo0P00000?0?ooo`030000003oool0oooo00X0oooo
00?o00000?ooo`3oool0203oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo00@0oooo
0P0000020?ooo`800000IP3oool006P0oooo0`00000>0?ooo`030000003oool0oooo00L0oooo1Ol0
00080?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0103oool01@000000oooo0?oo
o`3oool0000006P0oooo001Y0?ooo`030000003oool0000000h0oooo00<000000?ooo`3oool01`3o
ool2o`0000X0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`070?ooo`800000J@3o
ool006X0oooo0`0000030?ooo`?o00000`3oool4o`0000030?ooo`00003o000000?o00000P3oool2
o`0000030?ooool0003o00000080oooo1?l000030?ooo`0300000?l00000oooo0140oooo00<00000
0?ooool000000P3oool2000000<0oooo00<000000?ooo`3oool0J@3oool006`0oooo0`00000<0?oo
o`030000003oool0oooo0180oooo00<000000?ooool000000`3oool4o`0000T0oooo00@000000?oo
o`3ooooo00000P0000030?ooo`800000K03oool006d0oooo0`00000<0?ooo`030000003oool0oooo
0140oooo00<000000?ooo`3oool02@3oool4o`000080oooo00@00000o`000?l0000000001@3oool0
0`000000oooo0?ooo`1/0?ooo`00K`3oool2000000`0oooo00<000000?ooo`3oool01P3oool00ol0
0000oooo0?ooo`070?ooo`030000003oool0oooo00h0oooo00D000000?ooo`3oool0oooo00000004
0?ooo`030000003oool0oooo06d0oooo001`0?ooo`<000002P3oool00`000000oooo0?ooo`060?oo
o`03o`00003oool0oooo00H0oooo00<000000?ooo`3oool03P3oool01@000000oooo0?ooo`3oool0
000000<0oooo0P00001`0?ooo`00L@3oool3000000X0oooo00<000000?ooo`3oool01P3oool00ol0
0000oooo0?ooo`050?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`1`0?ooo`00L`3oool2000000X0oooo00<000000?ooo`3oool01@3oool00ol00000
oooo0?ooo`050?ooo`030000003oool0oooo00`0oooo00@000000?ooo`3oool000000`3oool20000
07<0oooo001d0?ooo`<000002@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0
oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`1c0?ooo`00MP3oool2000000P0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0:0?ooo`040000003oool0oooo0000
0080oooo0P00001f0?ooo`00M`3oool2000000P0oooo00<000000?ooo`3oool0103oool00ol00000
oooo0?ooo`040?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`1f0?ooo`00N03oool3000000L0oooo00<000000?ooo`3oool00`3oool00ol00000oooo
0?ooo`030?ooo`030000003oool0oooo00T0oooo00<000000?ooo`0000000P3oool2000007T0oooo
001j0?ooo`8000001P3oool00`000000oooo0?ooo`030?ooo`03o`00003oool0oooo00<0oooo00<0
00000?ooo`3oool0203oool00`000000oooo000000020?ooo`030000003oool0oooo07T0oooo001k
0?ooo`8000001P3oool00`000000oooo0?ooo`020?ooo`03o`00003oool0oooo00<0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo000000020?ooo`030000003oool0oooo07X0oooo001m0?oo
o`8000001@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00@000000?oo
o`3oool0oooo0P00001m0?ooo`00OP3oool2000000D0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`050?ooo`<0000000<0oooo0000003oool0OP3oool00800oooo0P0000030?ooo`05
0000003oool0oooo0?ooool00000103oool00`000000oooo0?ooo`040?ooo`80000000<0oooo0000
00000000P03oool00840oooo0P0000030?ooo`040000003oool0ooooo`0000<0oooo00<000000?oo
o`3oool0103oool2000000030?ooo`000000oooo0840oooo00220?ooo`8000000`3oool010000000
oooo0?ooool000020?ooo`030000003oool0oooo00<0oooo00@000000?ooo`0000000000P`3oool0
08@0oooo0P0000001@3oool000000?ooo`3ooooo00000080oooo00<000000?ooo`3oool00P3oool3
000008D0oooo00250?ooo`80000000<0oooo0000003oool00`3oool010000000oooo0?ooo`3oool3
000008H0oooo00270?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool00P0000280?oo
o`00R03oool300000004o`00003oool000000?ooo`800000R@3oool008T0oooo0P0000000ol00000
00000?ooo`02000008X0oooo002;0?ooo`<00000S03oool008`0oooo00<000000?ooo`3oool0R`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00001\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-5.00005*^-6, -5.00005*^-6, \
0.00355875, 0.00355875}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.0025 w
[ .01 .012 ] 0 setdash
.50377 .45486 m
.66737 .55927 L
s
.50377 .45486 m
.5 .27523 L
s
.50377 .45486 m
.60098 .40621 L
s
.50456 .57112 m
.50377 .45486 L
s
.40401 .40824 m
.50377 .45486 L
s
.34123 .56184 m
.50377 .45486 L
s
.50456 .57112 m
.66737 .55927 L
s
.34123 .56184 m
.50456 .57112 L
s
.504 .67296 m
.50456 .57112 L
s
.34123 .56184 m
.32366 .38575 L
s
.34123 .56184 m
.40401 .40824 L
s
.34123 .56184 m
.28124 .50193 L
s
.39633 .67987 m
.34123 .56184 L
s
.3111 .62572 m
.34123 .56184 L
s
.504 .67296 m
.34123 .56184 L
s
.66737 .55927 m
.72028 .49805 L
s
.66737 .55927 m
.67733 .38198 L
s
.60098 .40621 m
.66737 .55927 L
s
.504 .67296 m
.66737 .55927 L
s
.6091 .67859 m
.66737 .55927 L
s
.69003 .62312 m
.66737 .55927 L
s
.40401 .40824 m
.5 .27523 L
s
.40401 .40824 m
.32366 .38575 L
s
.60098 .40621 m
.67733 .38198 L
s
.60098 .40621 m
.5 .27523 L
s
.504 .67296 m
.39633 .67987 L
s
.6091 .67859 m
.504 .67296 L
s
.5 .75807 m
.504 .67296 L
s
.5 .27523 m
.67733 .38198 L
s
.32366 .38575 m
.5 .27523 L
s
.0035 w
[ ] 0 setdash
.5 .27523 m
.61086 .30766 L
s
.5 .27523 m
.49523 .29392 L
s
.38415 .31036 m
.5 .27523 L
s
.0025 w
[ .01 .012 ] 0 setdash
.32366 .38575 m
.28742 .42472 L
s
.32366 .38575 m
.38415 .31036 L
s
.28124 .50193 m
.32366 .38575 L
s
.3111 .62572 m
.39633 .67987 L
s
.5 .75807 m
.39633 .67987 L
s
.67733 .38198 m
.72028 .49805 L
s
.0035 w
[ ] 0 setdash
.67733 .38198 m
.70404 .42053 L
s
.61086 .30766 m
.67733 .38198 L
s
.0025 w
[ .01 .012 ] 0 setdash
.5 .75807 m
.6091 .67859 L
s
.69003 .62312 m
.6091 .67859 L
s
.0035 w
[ ] 0 setdash
.28124 .50193 m
.28742 .42472 L
s
.3111 .62572 m
.28124 .50193 L
s
.72028 .49805 m
.70404 .42053 L
s
.69003 .62312 m
.72028 .49805 L
s
.38415 .31036 m
.49523 .29392 L
s
.38415 .31036 m
.28742 .42472 L
s
.3111 .62572 m
.28742 .42472 L
s
.37335 .61763 m
.3111 .62572 L
s
.5 .75807 m
.3111 .62572 L
s
.61086 .30766 m
.70404 .42053 L
s
.49523 .29392 m
.61086 .30766 L
s
.69003 .62312 m
.70404 .42053 L
s
.69003 .62312 m
.5 .75807 L
s
.69003 .62312 m
.62124 .6159 L
s
.5 .75807 m
.37335 .61763 L
s
.49484 .56187 m
.5 .75807 L
s
.62124 .6159 m
.5 .75807 L
s
.49523 .29392 m
.70404 .42053 L
s
.49388 .40451 m
.49523 .29392 L
s
.28742 .42472 m
.49523 .29392 L
s
.37335 .61763 m
.28742 .42472 L
s
.49484 .56187 m
.37335 .61763 L
s
.62124 .6159 m
.70404 .42053 L
s
.62124 .6159 m
.49484 .56187 L
s
.28742 .42472 m
.49388 .40451 L
s
.49484 .56187 m
.28742 .42472 L
s
.49388 .40451 m
.70404 .42053 L
s
.49484 .56187 m
.70404 .42053 L
s
.49484 .56187 m
.49388 .40451 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.1,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016R000`400?l00000o`00003oo`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00RP3oool5000008/0oooo00270?ooo`<000000_l0
00000`00003o0000o`000003000008P0oooo00240?ooo`<000000`3oool01Ol00000oooo0000003o
oooo000000<0oooo100000240?ooo`00P03oool400000080oooo0_l000030?ooo`030000003oool0
oooo00<0oooo0_l000030?ooo`<00000P@3oool007d0oooo0`0000050?ooo`03o`00003oool0oooo
00<0oooo00<00000o`00003oool01@3oool00ol00000oooo0?ooo`030?ooo`@00000O@3oool007X0
oooo0`0000070?ooo`04o`00003oool0oooo0?ooo`P0000000Go00000?ooo`3oool0ooooo`000008
0?ooo`<00000NP3oool007L0oooo0`0000070?ooo`L0000000Ko00000000003oool00000o`000000
00020?ooo`P00000203oool3000007L0oooo001c0?ooo`@00000103oool6000000H0oooo0P000002
0?ooo`0300000?l00000oooo008000000P3oool00ol00000oooo0?ooo`030?ooo`P000000`3oool4
000007<0oooo001`0?ooo`<000000P3oool6000000@0oooo00?o00000?ooo`3oool00`3oool20000
00@0oooo00<000000?ooo`3oool00P3oool2000000L0oooo00?o00000?ooo`3oool0103oool:0000
0700oooo001]0?ooo`P000003`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool01`3oool00ol00000oooo0?ooo`090?ooo`@00000KP3oool006/0oooo
0`00000=0?ooo`;o00001@3oool2000000030?ooool00000oooo00@0oooo00<00000o`00003oool0
1@3oool2000000P0oooo00?o00000?ooo`3oool02`3oool00`000000oooo0?ooo`1/0?ooo`00J`3o
ool00`000000oooo0?ooo`0<0?ooo`03o`00003oool0oooo00@0oooo00@000000?ooo`3ooooo0000
1P3oool00`00003o00000?ooo`070?ooo`030000003oool0oooo00H0oooo00?o00000?ooo`3oool0
2`3oool00`000000oooo0?ooo`1[0?ooo`00JP3oool00`000000oooo0?ooo`0B0?ooo`8000000P3o
ool00ol00000oooo0?ooo`050?ooo`0300000?l00000oooo00P0oooo0P00000E0?ooo`030000003o
ool0oooo06X0oooo001Y0?ooo`030000003oool0oooo00/0oooo00?o00000?ooo`3oool00`3oool2
000000`0oooo00<00000o`00003oool02P3oool2000000L0oooo0ol0000:0?ooo`030000003oool0
oooo06T0oooo001X0?ooo`030000003oool0oooo00/0oooo00?o00000?ooo`3oool00`3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool01`3oool00ol0
0000oooo0?ooo`080?ooo`030000003oool0oooo06P0oooo001W0?ooo`030000003oool0oooo00/0
oooo00?o00000?ooo`3oool00P3oool2000000D0oooo00?o00000?ooo`3oool01`3oool00`000000
oooo0?ooo`0:0?ooo`03o`00003oool0oooo008000004P3oool2000006T0oooo001V0?ooo`030000
003oool0oooo00P0oooo0_l000060?ooo`030000003oool0oooo00@0oooo00?o00000?ooo`3oool0
203oool00`000000oooo0?ooo`0:0?ooo`03o`00003oool0oooo0080oooo0P0000070?ooo`?o0000
1`3oool2000006P0oooo001V0?ooo`030000003oool0oooo00L0oooo00?o00000?ooo`3oool0103o
ool2000000H0oooo00?o00000?ooo`3oool02@3oool00`00003o00000?ooo`0;0?ooo`03o`00003o
ool0oooo00<0oooo00<000000?ooo`3oool01`3oool00ol00000oooo0?ooo`050?ooo`800000I`3o
ool006D0oooo00<000000?ooo`3oool01`3oool00ol00000oooo0?ooo`030?ooo`800000503oool0
0`00003o00000?ooo`0B0?ooo`800000403oool2000006H0oooo001T0?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool0503oool00`00003o00000?ooo`0D0?ooo`030000003oool0oooo
00L0oooo0_l000050?ooo`800000I@3oool006<0oooo00<000000?ooo`3oool01P3oool2o`0000@0
oooo0P00000:0?ooo`03o`00003oool0oooo00X0oooo00<000000?ooo`3oool03@3oool00ol00000
oooo0?ooo`050?ooo`8000002@3oool00ol00000oooo0?ooo`030?ooo`800000I03oool00680oooo
00<000000?ooo`3oool01@3oool2o`0000D0oooo00<000000?ooo`3oool02@3oool00ol00000oooo
0?ooo`0:0?ooo`030000003oool0oooo00l0oooo00?o00000?ooo`3oool01P3oool2000000d0oooo
0P00001T0?ooo`00H@3oool00`000000oooo0?ooo`0;0?ooo`8000002`3oool00ol00000oooo0?oo
o`0;0?ooo`030000003oool0oooo0100oooo00?o00000?ooo`3oool01`3oool00`000000oooo0?oo
o`070?ooo`04o`00003oool0oooo0?ooo`800000H`3oool00600oooo00<000000?ooo`3oool00`3o
ool2o`0000D0oooo0P00000K0?ooo`030000003ooooo000001/0oooo0P0000080?ooo`04o`00003o
ool0oooo0?ooo`800000HP3oool00600oooo00<000000?ooo`3oool00P3oool00ol00000oooo0?oo
o`040?ooo`030000003oool0oooo01/0oooo00<000000?ooool000007@3oool00`000000oooo0?oo
o`060?ooo`04o`00003oool0oooo0?ooo`800000H@3oool005l0oooo00<000000?ooo`3oool0203o
ool2000000h0oooo00?o00000?ooo`3oool03@3oool010000000oooo0?ooool0000A0?ooo`03o`00
003oool0oooo00T0oooo0P0000090?ooo`;o00000P00001P0?ooo`00GP3oool01@000000oooo0?oo
o`3ooooo000000H0oooo00<000000?ooo`3oool03@3oool00ol00000oooo0?ooo`0>0?ooo`040000
003oool0ooooo`000180oooo00?o00000?ooo`3oool02P3oool2000000T0oooo00<000000?ooo`00
0000G`3oool005d0oooo00D000000?ooo`3oool0ooooo`0000050?ooo`8000003`3oool00ol00000
oooo0?ooo`0?0?ooo`030000003oool0oooo01@0oooo00?o00000?ooo`3oool02`3oool00`000000
oooo0?ooo`070?ooo`030000003oool0000005h0oooo001L0?ooo`050000003oool0oooo0?ooool0
00001@3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo02<0oooo0P0000080?ooo`03
0000003oool0000005d0oooo001K0?ooo`80000000?o00000?ooo`3oool0103oool2000002@0oooo
00@000000?ooo`3ooooo0000903oool00`000000oooo0?ooo`060?ooo`0300000?l00000000005`0
oooo001K0?ooo`030000003oool0oooo00@0oooo0P00000B0?ooo`03o`00003oool0oooo0140oooo
00@000000?ooo`3ooooo00005@3oool00ol00000oooo0?ooo`0=0?ooo`8000001`3oool00`00003o
00000000001K0?ooo`00FP3oool00`000000ooooo`000002o`000080oooo00<000000?ooo`3oool0
4P3oool00ol00000oooo0?ooo`0A0?ooo`040000003oool0ooooo`0001H0oooo00?o00000?ooo`3o
ool03P3oool2000000<0oooo0_l000000`000000oooo0000001K0?ooo`00F@3oool2000000@0oooo
0P00000D0?ooo`03o`00003oool0oooo0180oooo00@000000?ooo`3ooooo00005`3oool00ol00000
oooo0?ooo`0>0?ooo`03o`0000000000oooo00@0oooo00<000000?ooo`000000FP3oool005P0oooo
0`0000030?ooo`040000003oool0oooo0?ooo`?o00009@3oool00`000000oooo0?ooo`0W0?ooo`;o
00000P3oool2000000@0oooo0`00001I0?ooo`00E`3oool00`000000oooo000000020?ooo`800000
1`3oool00ol00000oooo0?ooo`0R0?ooo`030000003oool0oooo01X0oooo00?o00000?ooo`3oool0
1P3oool2o`0000P0oooo0P0000020?ooo`03o`0000000000000005T0oooo001F0?ooo`030000003o
ool0oooo00<00000303oool3o`0000P0oooo00?o00000?ooo`3oool0503oool010000000oooo0?oo
ool0000I0?ooo`03o`00003oool0oooo00@0oooo0_l0000<0?ooo`040000003ooooo00000?ooo`80
0000F03oool005D0oooo0P0000020?ooo`030000003ooooo000000l0oooo00?o00000?ooo`3oool0
0ol000000`3ooooo00000?ooo`0A0?ooo``000005`3oool01?l00000ooooo`000?l0000A0?ooo`80
000000@0oooo0000000000000000E`3oool005D0oooo00@000000?ooo`00000000000P3oool00ol0
0000oooo0?ooo`0C0?ooo`?o00001`3oool:000000D0oooo00@000000?ooo`3ooooo00000`3oool<
000000/0oooo0_l0000E0?ooo`@00000E`3oool005@0oooo00D000000?ooo`000000oooo0000000H
0?ooo`03o`0000000000000000L000003`3oool010000000oooo0?ooool0000?0?ooo``000005`3o
ool4000005H0oooo001C0?ooo`<000000P3oool00`000000oooo0?ooo`0=0?ooo`X00000603oool0
0`000000oooo0?ooo`0F0?ooo`;o0000103oool;000000h0oooo0P00001F0?ooo`00DP3oool20000
00<0oooo00<000000?ooo`3oool0103oool:000000P0oooo00?o00000?ooo`3oool0103oool2o`00
0140oooo00<000000?ooo`3oool09`3oool<000000@0oooo00<000000?ooo`3oool0D`3oool00540
oooo00@000000?ooo`3oool0oooo2@00000K0?ooo`03o`00003oool0oooo00h0oooo00@000000?oo
o`3ooooo00004@3oool2o`0001`0oooo00?o00000?ooo`3oool01P00001D0?ooo`00D03oool50000
00H0oooo00?o00000?ooo`3oool07P3oool2o`0000`0oooo00@000000?ooo`3ooooo0000403oool0
0ol00000oooo0?ooo`0:0?ooo`03o`00003oool0oooo00l0oooo00?o00000?ooo`3oool00P3oool2
000000030?ooo`000000oooo05<0oooo001@0?ooo`030000003oool0000000T0oooo00?o00000?oo
o`3oool03`3oool00ol00000oooo0?ooo`0=0?ooo`03o`00003oool0oooo00T0oooo00@000000?oo
o`3ooooo00007@3oool00ol00000oooo0?ooo`0?0?ooo`04o`00003oool0oooo0?ooo`D00000E03o
ool00500oooo0P0000001@3oool000000000003oool0000001L0oooo00?o00000?ooo`3oool03P3o
ool00ol00000oooo0?ooo`080?ooo`040000003oool0ooooo`0000`0oooo0_l0000@0?ooo`03o`00
003oool0oooo0140oooo00<000000?ooo`3oool01000001C0?ooo`00D03oool2000000<0oooo0P00
000F0?ooo`03o`00003oool0oooo0180oooo0_l000060?ooo`030000003oool0oooo00/0oooo0_l0
000B0?ooo`03o`00003oool0oooo00l0oooo0P0000040?ooo`<00000D`3oool00500oooo00<00000
0?ooo`0000000P3oool3000001D0oooo00?o00000?ooo`3oool0503oool00ol00000oooo0?ooo`03
0?ooo`030000003oool0oooo00P0oooo00?o00000?ooo`3oool09@3oool00`000000oooo0?ooo`03
0?ooo`040000003oool00000000005<0oooo001@0?ooo`<000001@3oool200000080oooo00?o0000
0?ooo`3oool0:`3oool00`000000oooo0?ooo`070?ooo`03o`00003oool0oooo02@0oooo0P000000
0ol00000oooo0?ooo`030?ooo`@00000D`3oool00500oooo0`0000070?ooo`030000003ooooo0000
02X0oooo0ol0000010000000oooo0?ooool000050?ooo`03o`00003oool0oooo01L0oooo00?o0000
0?ooo`3oool02P3oool010000000oooo0?ooool000040?ooo`060000003oool000000000003oool0
0000DP3oool00500oooo0P0000000`3oool00000000000060?ooo`8000003`3oool00ol00000oooo
0?ooo`0K0?ooo`050000003oool0ooooo`00003oool00_l0000L0?ooo`03o`00003oool0oooo00P0
oooo0P0000030?ooo`03o`00003oool0oooo0080oooo00H000000?ooo`00000000000?ooo`00001B
0?ooo`00D03oool2000000030?ooo`000000000000L0oooo00?o00000000003oool03@3oool00ol0
0000oooo0?ooo`0K0?ooo`030000003oool0oooo00;o00007`3oool00ol00000oooo0?ooo`060?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool00P0000000`3oool000000?ooo`1A0?oo
o`00D03oool2000000030?ooo`000000000000T0oooo0P00000;0?ooo`03o`00003oool0oooo01`0
oooo00<000000?ooo`3oool00_l0000O0?ooo`03o`00003oool0oooo00@0oooo0P00000:0?ooo`04
0000003oool0oooo00000080oooo00<000000?ooo`3oool0D03oool00500oooo0P0000000`3oool0
00000000000;0?ooo`030000003oool0oooo00P0oooo00?o00000?ooo`3oool0703oool01P00003o
00000?ooool00000ooooo`0002@0oooo00<000000?ooo`3oool01P3oool01Ol00000oooo0?ooo`3o
ool000000080oooo00D000000?ooo`3oool0oooo0000001A0?ooo`00D03oool2000000<0oooo00<0
00000?ooo`3oool01@3oool01?l00000oooo0?ooo`3oool2000002H0oooo00?o00000000003oool0
9P3oool2000000T0oooo00Co00000?ooo`3oool000000`3oool01@000000oooo0000003oool00000
0540oooo001?0?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool01@3oool00ol00000
oooo0?ooo`030?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool01@3oool3o`0001/0
oooo00?o00000000003oool02@3oool01Ol00000oooo0?ooo`3oool0000000<0oooo00D000000?oo
o`000000oooo0000001A0?ooo`00C`3oool010000000oooo0?ooo`0000030?ooo`030000003oool0
oooo00@0oooo00?o00000?ooo`3oool0103oool2000000@0oooo00?o00000?ooo`3oool06@3oool0
1Ol00000oooo0?ooo`3oool000000080oooo00?o00000?ooo`3oool01@3oool00ol00000oooo0?oo
o`0G0?ooo`8000002`3oool01?l00000oooo0?ooo`0000040?ooo`030000003oool0oooo00800000
D@3oool004l0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`040?ooo`03o`00
003oool0oooo00H0oooo0P0000020?ooo`03o`00003oool0oooo01P0oooo00?o00000?ooo`3oool0
0P3oool010000000oooo0?ooool0000P0?ooo`040000003oool0ooooo`0000d0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`0200000540oooo001?0?ooo`040000003oool000000000
00<0oooo00<000000?ooo`3oool03`3oool00`00003o00000?ooo`0I0?ooo`03o`00003oool0oooo
00<0oooo00@000000?ooo`3ooooo00002@3oool2o`0001<0oooo0P00000A0?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1>0?ooo`00C`3oool01000
0000oooo0000000000040?ooo`030000003oool0oooo00l0oooo0P00000E0?ooo`;o0000203oool0
10000000oooo0?ooool0000;0?ooo`03o`00003oool0oooo00l0oooo00<000000?ooo`3oool03P3o
ool00ol00000oooo000000050?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0CP3o
ool004l0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`030?ooo`03o`00003o
ool0oooo00/0oooo00<000000?ooo`3oool04@3oool00ol00000oooo0?ooo`090?ooo`030000003o
ool0oooo00`0oooo00?o00000?ooo`3oool0303oool2000000L0oooo00?o00000?ooo`3oool01`3o
ool00ol00000oooo000000050?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0CP3o
ool004l0oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`020?ooo`03o`00003o
ool0oooo00`0oooo0P00000@0?ooo`03o`00003oool0oooo00X0oooo00<000000?ooo`3oool03`3o
ool00ol00000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00?o00000?ooo`3oool01`3o
ool00ol0000000000?ooo`050?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0CP3o
ool004l0oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`030?ooo`03o`00003o
ool0oooo00H0oooo00?o00000?ooo`3oool0103oool00`000000oooo0?ooo`0J0?ooo`030000003o
ool0oooo0100oooo00?o00000?ooo`3oool01P3oool00`000000oooo0?ooo`090?ooo`03o`00003o
ool0oooo00H0oooo00?o00000000003oool01@3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo04d0oooo001?0?ooo`040000003oool0oooo000000H0oooo00<000000?ooo`3oool00P3o
ool00ol00000oooo0?ooo`060?ooo`03o`00003oool0oooo00D0oooo0P00000:0?ooo`;o00003P3o
ool00`000000ooooo`00000A0?ooo`03o`00003oool0oooo00<0oooo0P00000<0?ooo`03o`00003o
ool0oooo00H0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo04d0oooo001?0?ooo`050000003oool0oooo0?ooo`0000001@3oool00`000000oooo0?oo
o`0:0?ooo`03o`00003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool2o`000100oooo00<0
00000?ooool000005P3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`1=0?ooo`00C`3oool01@000000oooo0?ooo`3o
ool0000000H0oooo00<000000?ooo`3oool05@3oool2000001L0oooo00<000000?ooool00000503o
ool2000001P0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`03o`000000
0000oooo04h0oooo001?0?ooo`0500000?l00000oooo0?ooo`0000001P3oool01@000000oooo0?oo
o`3ooooo000001D0oooo00<000000?ooool00000503oool00`000000oooo0?ooo`0C0?ooo`040000
003oool0ooooo`000100oooo00?o00000?ooo`3oool00`3oool00`00003o00000?ooo`050?ooo`03
0000003oool0oooo0080oooo00?o00000000003oool0C`3oool004l0oooo00D000000?ooool00000
oooo000000060?ooo`050000003oool0oooo0?ooool000001P3oool00ol00000oooo0?ooo`0=0?oo
o`800000503oool00`000000oooo0?ooo`0A0?ooo`800000503oool00ol00000oooo0?ooo`030?oo
o`0300000?l00000oooo00D0oooo00L000000?ooo`3oool0ooooo`00003oool000000500oooo001@
0?ooo`040000003ooooo0000000000L0oooo00@000000?ooo`3ooooo00001P3oool00ol00000oooo
0?ooo`0<0?ooo`03o`00003oool0oooo008000004P3oool00`000000oooo0?ooo`0@0?ooo`030000
003oool0oooo00H0oooo0_l0000=0?ooo`07o`00003oool0oooo0?ooo`000000ooooo`0000060?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool0CP3oool00500oooo00@000000?ooo`3o
ool000001`3oool010000000oooo0?ooool000050?ooo`03o`00003oool0oooo0180oooo00<00000
0?ooo`3oool03`3oool00`000000ooooo`00000>0?ooo`8000002`3oool00ol00000oooo0?ooo`0:
0?ooo`05o`00003oool0oooo0?ooo`000000203oool00`000000ooooo`0000030?ooo`030000003o
ool0oooo04h0oooo001@0?ooo`040000003oool0oooo000000P0oooo00<000000?ooo`3oool01@3o
ool00ol00000oooo0?ooo`090?ooo`;o0000203oool2000000l0oooo00<000000?ooool000003@3o
ool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00L0oooo00<00000o`00003oool00P3o
ool00`000000oooo0?ooo`1?0?ooo`00D03oool01P000000oooo0?ooo`000000ooooo`0000H0oooo
00<000000?ooo`3oool0403oool00ol00000oooo0?ooo`0:0?ooo`030000003oool0oooo00`0oooo
00<000000?ooool000002`3oool200000140oooo0_l0000;0?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1?0?ooo`00D@3oool01P000000oooo0?oo
o`000000ooooo`0000H0oooo00<00000o`00003oool07@3oool2000000`0oooo00<000000?ooool0
00002P3oool00`000000oooo0?ooo`0C0?ooo`03o`00003oool0oooo00H0oooo00?o00000?ooo`00
00000P3oool00ol00000oooo0?ooo`040?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool0C`3oool00540oooo00@000000?ooo`3oool000000P3oool00ol00000oooo0?ooo`030?ooo`03
00000?l00000oooo00<0oooo00?o00000?ooo`3oool01P3oool00ol00000oooo0?ooo`0@0?ooo`03
0000003oool0oooo00T0oooo00<000000?ooo`3oool0203oool2000001L0oooo00?o00000?ooo`3o
ool01@3oool00ol0000000000?ooo`020?ooo`03o`00003oool0oooo00@0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`1?0?ooo`00D@3oool010000000oooo0?ooo`0000090?ooo`03
00000?l00000oooo0080oooo00?o00000?ooo`3oool01@3oool00ol00000oooo0?ooo`0B0?ooo`80
00002@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0200oooo00@000000?ooo`3o
oooo00001@3oool00ol00000oooo000000030?ooo`030000003oool0oooo0500oooo001A0?ooo`04
0000003oool0oooo000000@0oooo00?o00000?ooo`3oool00P3oool01@00003o00000?ooo`3ooooo
000000L0oooo00?o00000?ooo`3oool05@3oool00`000000oooo0?ooo`060?ooo`030000003ooooo
000000D0oooo0P00000L0?ooo`?o00000`3oool01@000000oooo0?ooo`3ooooo000000@0oooo00Co
00000?ooo`3oool000000`3oool00`000000oooo0?ooo`1@0?ooo`00D@3oool010000000oooo0?oo
o`0000050?ooo`05o`00003oool0oooo0?ooo`0000000`3oool00ol00000oooo0?ooo`020?ooo`03
o`00003oool0oooo01T0oooo0P0000060?ooo`030000003ooooo000000@0oooo00<000000?ooo`3o
ool07`3oool01?l00000oooo0?ooo`0000070?ooo`05o`00003oool0oooo0?ooo`0000000`3oool0
0`000000oooo0?ooo`1@0?ooo`00DP3oool00`000000oooo000000060?ooo`05o`00003oool0oooo
0?ooo`0000001P3oool00ol00000oooo0?ooo`0L0?ooo`800000103oool00`000000ooooo`000002
0?ooo`8000009@3oool010000000oooo0?ooool000080?ooo`050000003oool0oooo0?ooo`000000
DP3oool00580oooo00<000000?ooo`0000002P3oool00`000000oooo0?ooo`030?ooo`03o`00003o
ool0oooo01l0oooo00T000000?ooo`3oool0oooo0000003ooooo00000?ooo`0000009P3oool01000
003o0000o`00003oool2o`0000L0oooo00@000000?ooo`3oool00000D`3oool00580oooo00<00000
0?ooo`000000203oool01?l00000ooooo`000000000W0?ooo`80000000<0oooo0000003oool00P00
000W0?ooo`080000003oool0ooooo`00003ooooo00000?ooool000040?ooo`050000003oool0oooo
0?ooo`000000D`3oool00580oooo00@000000?ooo`3oool00000203oool2o`00000300000?l0003o
000002L0oooo0`00000X0?ooo`030000003oool0oooo00<0oooo0_l000050?ooo`050000003oool0
oooo0?ooo`000000D`3oool005<0oooo00<000000?ooo`0000002@3oool2o`0000030000003oool0
oooo02H0oooo0`0000000ol00000oooo0?ooo`0R0?ooo`?o000000<000000?ooo`3oool01?l00006
0?ooo`050000003oool0oooo0?ooo`000000D`3oool005<0oooo00<000000?ooo`0000002@3oool0
1?l00000oooo00000?l000030?ooo`?o00000`3oool4o`000080oooo0ol0000C0?ooo`80000000<0
oooo0000003oool00P00000C0?ooo`;o00000P3oool4o`000080oooo1?l000040?ooo`030000003o
ool0oooo00/0oooo00@000000?ooo`3oool00000E03oool005<0oooo00<000000?ooo`0000002@3o
ool01?l00000oooo0?ooo`00000B0?ooo`03o`00003oool0oooo00Co00000P3oool4o`000080oooo
0_l00002000000<0oooo00@000000?ooool00000oooo0P0000040?ooo`;o00000`3oool3o`0000<0
oooo0_l0000B0?ooo`030000003oool0oooo00;o00002@3oool010000000oooo0?ooo`00001D0?oo
o`00D`3oool00`000000oooo0000000;0?ooo`03o`000000003o000001l0oooo0`0000000`3ooooo
00000?ooo`020?ooo`0300000?l0003o000000?o00000`0000000ol00000oooo0?ooo`0M0?ooo`03
0000003ooooo00000080oooo00Co00000?ooo`3ooooo00001@3oool010000000oooo0?ooo`00001D
0?ooo`00E03oool2000000/0oooo00Co00000000003ooooo0000703oool2000000P0oooo00<00000
0?ooool000001P3oool2000001d0oooo00<000000?ooo`3oool00`3oool01?l00000oooo0?ooool0
00050?ooo`040000003oool0oooo000005@0oooo001D0?ooo`8000001`3oool00ol00000oooo0?oo
o`020?ooo`03o`0000000000oooo01X0oooo0P00000:0?ooo`030000003ooooo000000P0oooo0P00
000K0?ooo`030000003oool0oooo0080oooo00?o00000?ooo`3oool00P3oool00ol00000oooo0?oo
o`020?ooo`030000003oool0000005D0oooo001D0?ooo`8000001`3oool00ol00000oooo0?ooo`02
0?ooo`03o`0000000000oooo0080oooo0_l0000D0?ooo`800000303oool00`000000ooooo`00000:
0?ooo`800000603oool00`000000oooo0?ooo`080?ooo`03o`00003oool0oooo0080oooo00<00000
0?ooo`000000E@3oool005@0oooo00<000000?ooo`0000001@3oool00ol00000oooo0?ooo`050?oo
o`030000003oool0oooo0080oooo00?o00000?ooo`3oool03`3oool2000000h0oooo00<000000?oo
ool00000303oool2000001D0oooo00?o00000000003oool03P3oool00`000000oooo0000001E0?oo
o`00E@3oool2000000d0oooo00<000000?ooo`3oool04@3oool300000100oooo00<000000?ooo`3o
ool03P3oool3000001<0oooo00<000000?ooo`3oool00P3oool00ol00000oooo0?ooo`080?ooo`03
0000003oool0000005D0oooo001E0?ooo`800000303oool00ol00000oooo000000060?ooo`03o`00
003oool0oooo00L0oooo0P00000C0?ooo`030000003oool0oooo0140oooo0P00000<0?ooo`;o0000
0P3oool00`000000oooo0?ooo`030?ooo`03o`00003oool0oooo00@0oooo00Co00000?ooo`3oool0
oooo0P00001F0?ooo`00E@3oool2000000@0oooo00?o00000?ooo`3oool01@3oool00ol00000oooo
000000070?ooo`03o`00003oool0oooo00@0oooo0P00000E0?ooo`030000003ooooo000001<0oooo
0P0000090?ooo`03o`00003oool0oooo0080oooo00<000000?ooo`3oool00P3oool00ol00000oooo
0?ooo`050?ooo`04o`00003oool0oooo0?ooo`800000EP3oool005D0oooo0P0000040?ooo`03o`00
003oool0oooo00H0oooo00?o00000?ooo`0000001`3oool01?l00000oooo0?ooo`3oool2000001L0
oooo00<000000?ooool000005@3oool2000000/0oooo00<000000?ooo`3oool00P3oool00ol00000
oooo0?ooo`070?ooo`03o`00003oool0oooo00800000EP3oool005D0oooo0P0000030?ooo`03o`00
003oool0oooo00T0oooo00<000000?ooo`3oool01`3oool2000001T0oooo00<000000?ooool00000
5`3oool2000000030?ooool0003o000000H0oooo00<000000?ooo`3oool0303oool01Ol00000oooo
0000003oool0000005H0oooo001F0?ooo`050000003oool0oooo0?ooool000002`3oool00`000000
oooo0?ooo`040?ooo`<0000000@0ooooo`000?l0003o00005`3oool00`000000ooooo`00000I0?oo
o`<000001@3oool00`000000oooo0?ooo`0?0?ooo`800000E`3oool005H0oooo00<000000?ooo`3o
ool03@3oool00ol0000000000?ooo`020?ooo`8000001`3oool00ol00000oooo0?ooo`0D0?ooo`03
0000003oool0oooo01P0oooo00Co00000?ooo`3oool0oooo0P0000030?ooo`030000003oool0oooo
0080oooo00?o00000?ooo`3oool02P3oool2000005L0oooo001F0?ooo`8000003P3oool00ol00000
00000?ooo`0200000200oooo00<000000?ooo`3oool07P3oool2000000030?ooo`000000oooo00<0
oooo00?o00000?ooo`3oool02@3oool00ol0000000000000001G0?ooo`00EP3oool200000003o`00
003oool0oooo00T0oooo1@00000=0?ooo`;o00004`3oool00`000000ooooo`00000E0?ooo`;o0000
2@3oool6000000`0oooo00?o0000000000000000E`3oool005L0oooo00@00000o`00003oool0oooo
2@0000030?ooo`03o`0000000000oooo00h0oooo00?o00000?ooo`3oool0403oool00`000000oooo
o`00000C0?ooo`;o00002`3oool00`000000oooo0?ooo`020?ooo`03o`0000000000000000L00000
103oool00`000000oooo0?ooo`1F0?ooo`00E`3oool4000000h0oooo00<000000?ooo`3oool03@3o
ool00ol00000oooo0?ooo`0?0?ooo`030000003ooooo000001l0oooo00<000000?ooo`3oool03@3o
ool5000005P0oooo001H0?ooo`800000403oool00`000000oooo0?ooo`0N0?ooo`030000003ooooo
00000100oooo0_l0000<0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0F03oool0
05T0oooo0P00000=0?ooo`04o`00003oool0oooo000000l0oooo0ol0000=0?ooo`030000003oool0
oooo00l0oooo00?o00000?ooo`3oool02`3oool00`000000oooo0?ooo`030?ooo`03o`00003oool0
oooo00X0oooo00<000000?ooo`3oool0F@3oool005/0oooo0P00000<0?ooo`04o`00003oool0oooo
00000140oooo00?o00000?ooo`3oool02P3oool00`000000oooo0?ooo`0>0?ooo`03o`00003oool0
oooo00/0oooo00<000000?ooo`3oool0103oool00ol00000oooo0?ooo`080?ooo`800000G03oool0
05`0oooo0P00000<0?ooo`04o`00003oool0oooo000001d0oooo00<000000?ooo`3oool06`3oool0
0`000000oooo0?ooo`040?ooo`03o`00003oool0oooo00P0oooo00<000000?ooo`3oool0G03oool0
05h0oooo0P00000>0?ooo`030000003oool0oooo0100oooo00?o00000?ooo`3oool01`3oool00`00
0000ooooo`00000;0?ooo`;o00003@3oool00`000000oooo0?ooo`0>0?ooo`800000G`3oool00600
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0@0?ooo`03o`00003oool0oooo00H0
oooo00<000000?ooool000002P3oool00ol00000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool0G`3oool00640oooo0P0000080?ooo`03o`00003oool0oooo0080oooo
00<000000?ooo`3oool0403oool00ol00000oooo0?ooo`050?ooo`030000003ooooo000000T0oooo
00?o00000?ooo`3oool03@3oool00`000000oooo0?ooo`050?ooo`03o`00003oool0oooo00@0oooo
0P00001R0?ooo`00HP3oool2000000L0oooo00?o00000?ooo`3oool00`3oool00`000000oooo0?oo
o`0G0?ooo`030000003oool0oooo00H0oooo0_l0000@0?ooo`030000003oool0oooo00H0oooo00?o
00000?ooo`3oool00`3oool2000006<0oooo001T0?ooo`030000003oool0oooo00D0oooo00?o0000
0?ooo`3oool00P3oool00`000000oooo0?ooo`0B0?ooo`;o00000`3oool00`000000oooo0?ooo`05
0?ooo`03o`00003oool0oooo00l0oooo00<000000?ooo`3oool01P3oool00ol00000oooo0?ooo`03
0?ooo`030000003oool0oooo06<0oooo001U0?ooo`<00000103oool00ol00000oooo0?ooo`030?oo
o`030000003oool0oooo01<0oooo00Co00000?ooo`3oool000001P3oool00ol00000oooo0?ooo`0?
0?ooo`030000003oool0oooo00H0oooo00?o00000?ooo`3oool00P3oool2000006H0oooo001W0?oo
o`8000002P3oool00`000000oooo0?ooo`0F0?ooo`0300000?l00000oooo01@0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`1V0?ooo`00J03oool2000000X0oooo00<000000?ooo`3o
ool0503oool01Ol000000000o`00003ooooo000001<0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`1W0?ooo`00J@3oool2000000<0oooo00?o00000?ooo`3oool0103oool00`000000
oooo0?ooo`0D0?ooo`0300000?l0003o000001<0oooo00<000000?ooo`3oool01`3oool01?l00000
oooo00000000001Z0?ooo`00J`3oool300000003o`00003oool0oooo00D0oooo00<000000?ooo`3o
ool01`3oool2o`000080oooo1?l000020?ooo`;o000000<00000o`00003oool01?l000020?ooo`Co
00000P3oool3o`0000<0oooo00<000000?ooo`3oool0203oool2000006`0oooo001/0?ooo`<00000
00?o00000?ooo`3oool00ol000020?ooo`0300000?l0003o000000;o00000P3oool2o`0000`0oooo
00<000000?ooo`3oool03`3oool01?l00000oooo0000003oool3o`0000<0oooo0ol00002000006d0
oooo001^0?ooo`0300000?l00000oooo00L0oooo00<000000?ooo`3oool04@3oool00`00003o0000
0?ooo`0@0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0K@3oool006l0oooo00<0
00000?ooo`0000001`3oool00`000000oooo0?ooo`0@0?ooo`0300000?l00000oooo00l0oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`1^0?ooo`00L03oool3000000L0oooo00<00000
0?ooo`3oool03`3oool00`00003o00000?ooo`0>0?ooo`030000003oool0oooo00H0oooo0`00001a
0?ooo`00LP3oool2000000H0oooo00<000000?ooo`3oool03`3oool00`00003o00000?ooo`0>0?oo
o`030000003oool0oooo00D0oooo0P00001c0?ooo`00L`3oool2000000H0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00D0oooo0P00001d0?ooo`00
M@3oool2000000D0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00@0oooo0P00001f0?ooo`00MP3oool2000000D0oooo00<000000?ooo`3oool0303o
ool00`00003o00000?ooo`0;0?ooo`030000003oool0oooo00@0oooo0P00001g0?ooo`00M`3oool2
000000D0oooo00<000000?ooo`3oool02`3oool00`00003o00000?ooo`0:0?ooo`030000003oool0
oooo00@0oooo0P00001h0?ooo`00N@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
00X0oooo00<00000o`00003oool02@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
07P0oooo001j0?ooo`<000000`3oool00`000000oooo0?ooo`090?ooo`0300000?l00000oooo00P0
oooo00<000000?ooo`3oool00`3oool2000007/0oooo001l0?ooo`8000000`3oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`1k0?ooo`00O@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo07`0oooo001n
0?ooo`<000000P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00@00000
0?ooo`3oool0oooo0P00001o0?ooo`00P03oool2000000030?ooo`000000oooo00L0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`0200000840oooo00210?ooo`80000000<0oooo0000
003oool01P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00800000PP3oool008<0
oooo00<000000?ooo`0000001P3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo0000
08@0oooo00240?ooo`<000001@3oool00`000000oooo0?ooo`030?ooo`<00000Q@3oool008D0oooo
0`0000040?ooo`030000003oool0oooo0080oooo0`0000260?ooo`00Q`3oool2000000<0oooo00@0
00000?ooo`3oool0oooo0P0000280?ooo`00R03oool200000080oooo00<000000?ooo`3oool00P00
00290?ooo`00RP3oool01@000000oooo0000003oool0000008/0oooo002;0?ooo`<00000S03oool0
08`0oooo00<000000?ooo`3oool0R`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3o
ool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00001\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-5.00005*^-6, -5.00005*^-6, \
0.00355875, 0.00355875}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.0025 w
[ .01 .012 ] 0 setdash
.53124 .45363 m
.69667 .54859 L
s
.53124 .45363 m
.5 .27523 L
s
.53124 .45363 m
.61766 .39786 L
s
.53784 .56992 m
.53124 .45363 L
s
.42372 .41472 m
.53124 .45363 L
s
.37465 .56997 m
.53124 .45363 L
s
.37465 .56997 m
.33052 .39916 L
s
.37465 .56997 m
.53784 .56992 L
s
.37465 .56997 m
.42372 .41472 L
s
.37465 .56997 m
.29076 .51562 L
s
.41768 .68394 m
.37465 .56997 L
s
.31871 .63494 m
.37465 .56997 L
s
.53323 .67212 m
.37465 .56997 L
s
.53784 .56992 m
.69667 .54859 L
s
.53323 .67212 m
.53784 .56992 L
s
.42372 .41472 m
.5 .27523 L
s
.42372 .41472 m
.33052 .39916 L
s
.61766 .39786 m
.67754 .36786 L
s
.61766 .39786 m
.69667 .54859 L
s
.61766 .39786 m
.5 .27523 L
s
.69667 .54859 m
.72166 .48345 L
s
.69667 .54859 m
.67754 .36786 L
s
.53323 .67212 m
.69667 .54859 L
s
.62724 .67334 m
.69667 .54859 L
s
.69054 .61338 m
.69667 .54859 L
s
.53323 .67212 m
.41768 .68394 L
s
.62724 .67334 m
.53323 .67212 L
s
.5 .75807 m
.53323 .67212 L
s
.5 .27523 m
.67754 .36786 L
s
.33052 .39916 m
.5 .27523 L
s
.0035 w
[ ] 0 setdash
.5 .27523 m
.59003 .29883 L
s
.5 .27523 m
.46059 .29588 L
s
.36864 .32105 m
.5 .27523 L
s
.0025 w
[ .01 .012 ] 0 setdash
.33052 .39916 m
.2618 .44114 L
s
.33052 .39916 m
.36864 .32105 L
s
.29076 .51562 m
.33052 .39916 L
s
.31871 .63494 m
.41768 .68394 L
s
.5 .75807 m
.41768 .68394 L
s
.29076 .51562 m
.2618 .44114 L
s
.31871 .63494 m
.29076 .51562 L
s
.0035 w
[ ] 0 setdash
.5 .75807 m
.62724 .67334 L
s
.69054 .61338 m
.62724 .67334 L
s
.67754 .36786 m
.66737 .40657 L
s
.67754 .36786 m
.72166 .48345 L
s
.59003 .29883 m
.67754 .36786 L
s
.31871 .63494 m
.2618 .44114 L
s
.35658 .62451 m
.31871 .63494 L
s
.5 .75807 m
.31871 .63494 L
s
.36864 .32105 m
.46059 .29588 L
s
.36864 .32105 m
.2618 .44114 L
s
.72166 .48345 m
.66737 .40657 L
s
.69054 .61338 m
.72166 .48345 L
s
.59003 .29883 m
.66737 .40657 L
s
.46059 .29588 m
.59003 .29883 L
s
.69054 .61338 m
.66737 .40657 L
s
.69054 .61338 m
.5 .75807 L
s
.69054 .61338 m
.59857 .6102 L
s
.5 .75807 m
.35658 .62451 L
s
.45738 .56325 m
.5 .75807 L
s
.59857 .6102 m
.5 .75807 L
s
.46059 .29588 m
.66737 .40657 L
s
.44949 .40666 m
.46059 .29588 L
s
.2618 .44114 m
.46059 .29588 L
s
.2618 .44114 m
.44949 .40666 L
s
.35658 .62451 m
.2618 .44114 L
s
.45738 .56325 m
.2618 .44114 L
s
.45738 .56325 m
.35658 .62451 L
s
.59857 .6102 m
.66737 .40657 L
s
.59857 .6102 m
.45738 .56325 L
s
.44949 .40666 m
.66737 .40657 L
s
.45738 .56325 m
.44949 .40666 L
s
.45738 .56325 m
.66737 .40657 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.1,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016R000`400?l00000o`00003oo`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00R`3oool4000008/0oooo00280?ooo`<000001?l0
0004000008L0oooo00250?ooo`@0000000?o00000?ooo`3oool00P3oool00ol00000oooo0?ooo`02
0?ooo`@00000P`3oool00880oooo0`0000000`3oool000000?ooo`070?ooo`03o`00003ooooo0000
00;o00000`3oool5000007h0oooo001o0?ooo`<000000P3oool2000000;o00000P3oool00ol00000
oooo0?ooo`070?ooo`03o`00003oool0oooo00D0oooo1000001j0?ooo`00O03oool3000000<0oooo
0P0000000`3ooooo00000?ooo`030?ooo`04o`00003oool0ooooo`000180oooo1000001f0?ooo`00
N@3oool3000000<0oooo:000001c0?ooo`00M`3oool200000080oooo1@0000000`3oool00000o`00
0002000000<0oooo00?o00000?ooo`3oool00P3oool00ol00000oooo0?ooo`020?ooo`03o`00003o
ool0oooo00@0oooo00?o00000?ooo`3oool02@3oool00`000000oooo0000001b0?ooo`00M03oool3
000000040?ooo`000000000000000080oooo0P0000000`3ooooo0000000000030?ooo`800000303o
ool00ol00000oooo0?ooo`060?ooo`;o0000203oool00`000000oooo0000001a0?ooo`00L@3oool7
000000@0oooo00H000000?ooo`3ooooo00000?ooo`0000050?ooo`8000005@3oool00ol00000oooo
0?ooo`060?ooo`030000003oool000000700oooo001^0?ooo`H000001`3oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo00<0oooo00?o00000?ooo`000000303oool00ol00000oooo0?oo
o`060?ooo`03o`00003oool0oooo00D0oooo00<000000?ooo`3oool00P00001^0?ooo`00J`3oool5
000000T0oooo0P0000000`3ooooo0000o`0000030?ooo`030000003oool0oooo0080oooo00Co0000
0?ooo`3oool0oooo0P0000020?ooo`03o`00003oool0oooo00H0oooo00?o00000?ooo`3oool0203o
ool00ol00000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`000000K@3oool006P0oooo1@00
000;0?ooo`040000003oool0ooooo`0000@0oooo00<000000?ooo`3oool00P3oool00ol00000oooo
0?ooo`040?ooo`80000000?o00000?ooo`3oool01`3oool00ol00000oooo0?ooo`080?ooo`03o`00
003oool0oooo00<0oooo00D000000?ooo`3oool0oooo0000001/0?ooo`00I`3oool2000000d0oooo
0P0000020?ooo`03o`00003oool0oooo00<0oooo00<000000?ooo`3oool02`3oool2000001@0oooo
00?o00000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0000006/0oooo001W0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0=0?ooo`800000
203oool00ol00000oooo0?ooo`0:0?ooo`?o000000<000000?ooo`3oool00P3oool2000006T0oooo
001V0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool00_l000070?ooo`050000003o
ool0oooo0?ooool000003@3oool2000000L0oooo00?o00000?ooo`3oool0303oool00ol000000000
0?ooo`040?ooo`030000003oool0oooo06H0oooo001U0?ooo`8000002`3oool2000000030?ooool0
003o000000T0oooo00@000000?ooo`3ooooo0000403oool2000000H0oooo00?o00000?ooo`3oool0
3@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo06D0oooo001T0?ooo`8000002`3o
ool00`000000oooo0?ooo`0<0?ooo`030000003ooooo000000`0oooo00?o00000?ooo`3oool0103o
ool2000001@0oooo00<00000o`000?l00000103oool00`000000oooo0?ooo`1T0?ooo`00H`3oool2
000000X0oooo0P0000000`3ooooo0000o`00000<0?ooo`030000003oool0oooo00`0oooo00?o0000
0?ooo`3oool01P3oool00`000000oooo0?ooo`0B0?ooo`030000003ooooo000000@0oooo0P00001T
0?ooo`00HP3oool00`000000oooo0?ooo`090?ooo`040000003oool0ooooo`0000h0oooo00<00000
0?ooo`3oool0303oool00ol00000oooo0?ooo`070?ooo`8000000`3oool00ol00000oooo0?ooo`0=
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0H@3oool00640oooo00<000000?oo
o`3oool02@3oool010000000oooo0?ooool0000?0?ooo`0300000?l00000oooo00`0oooo00?o0000
0?ooo`3oool02@3oool200000080oooo00?o00000?ooo`3oool03@3oool00`000000oooo0?ooo`03
o`000080oooo00<000000?ooo`3oool0H03oool00600oooo00@000000?ooo`3oool000001`3oool2
000001<0oooo00<00000o`00003oool06P3oool2000000030?ooool00000oooo00d0oooo00<00000
0?ooo`3oool00`3oool01?l00000oooo0?ooo`00001Q0?ooo`00G`3oool01@000000oooo0?ooo`3o
ool0000000H0oooo00<000000?ooo`3oool00_l0000@0?ooo`0300000?l00000oooo01d0oooo0P00
000?0?ooo`030000003oool0oooo00H0oooo0P00001O0?ooo`00GP3oool01@000000oooo0?ooo`3o
ool0000000D0oooo0P0000020?ooo`03o`00003oool0oooo0100oooo00<000000?ooo`3oool03P3o
ool00ol00000oooo0?ooo`0>0?ooo`80000000?o00000?ooo`3oool02`3oool00`000000oooo0?oo
o`040?ooo`;o000000<0oooo0000003oool0G@3oool005d0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooool000004`3oool00`000000oooo0?oo
o`0>0?ooo`03o`00003oool0oooo0100oooo0P00000<0?ooo`030000003oool0oooo00H0oooo00?o
00000?ooo`000000G@3oool005d0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0F
0?ooo`030000003oool0oooo00h0oooo00?o00000?ooo`3oool04P3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0FP3oool005`0oooo00<000000?oo
o`3oool01@3oool200000080oooo0_l0000D0?ooo`03o`0000000000oooo00l0oooo00?o00000?oo
o`3oool04`3oool2000000/0oooo00<000000?ooo`3oool01`3oool00ol0000000000?ooo`1J0?oo
o`00F`3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo00000080oooo0_l0000E0?oo
o`03o`00003oool0000002P0oooo0P00000:0?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool0F@3oool005X0oooo00<000000?ooo`3oool00`3oool3000001T0oooo00Co00000?ooo`3o
ool000009`3oool00ol00000oooo0?ooo`02000000P0oooo00<000000?ooo`3oool00`3oool2o`00
0080oooo0P00001J0?ooo`00F@3oool00`000000oooo0?ooo`030?ooo`8000000P3oool2o`0001X0
oooo00<000000?ooo`3oool03`3oool00ol00000oooo0?ooo`0D0?ooo`04o`00003oool0oooo0?oo
o`8000001`3oool00`000000oooo0?ooo`02o`0000<0oooo00<000000?ooo`000000FP3oool005P0
oooo00<000000?ooo`3oool0103oool010000000oooo0?ooool0000L0?ooo`030000003oool0oooo
00l0oooo00?o00000?ooo`3oool05@3oool00ol00000oooo0?ooo`020?ooo`8000001@3oool00ol0
000000000?ooo`050?ooo`030000003oool0000005X0oooo001G0?ooo`030000003oool0oooo00<0
oooo0P0000020?ooo`03o`00003oool0oooo01L0oooo00Go00000?ooo`3oool0oooo0000000B0?oo
o`03o`00003oool0oooo01/0oooo0P0000020?ooo`03o`00003oool0000000H0oooo00@00000o`00
003oool00000F@3oool005H0oooo00<000000?ooo`3oool00`3oool00`000000oooo0000000L0?oo
o`05o`00003oool0oooo0?ooo`0000004P3oool00ol00000oooo0?ooo`0F0?ooo`03o`00003oool0
oooo00@0oooo0P0000030?ooo`030000003oool0oooo0080oooo00D000000?ooool00000oooo0000
001I0?ooo`00E@3oool00`000000oooo0?ooo`020?ooo`8000000P3oool00`00003o00000?ooo`0I
0?ooo`05o`00003oool0oooo0?ooo`000000;@3oool00ol00000oooo0?ooo`02o`0000<0oooo00D0
00000?ooo`3oool0oooo000000030?ooo`050000003oool0ooooo`0000000000F@3oool005@0oooo
00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000001`0oooo00Go00000?ooo`3o
ool0oooo0000000^0?ooo`;o00001P3oool200000080oooo00@000000?ooo`3oool000000P3oool0
0ol00000oooo0000001H0?ooo`00D`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
008000000_l0000O0?ooo`030000003oool0oooo0140oooo00?o00000?ooo`3oool05`3oool2o`00
00T0oooo0`0000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0EP3oool005<0
oooo00<000000?ooo`3oool00P0000020?ooo`030000003oool0000000D0oooo0ol0000I0?ooo`03
0000003oool0oooo0140oooo00?o00000?ooo`3oool05P3oool01?l00000oooo0?ooool0000:0?oo
o`<000001P3oool00`000000oooo0?ooo`1E0?ooo`00DP3oool010000000oooo0?ooo`0000060?oo
o`030000003oool0oooo00T0oooo0ol0000=0?ooo`03o`00003oool0oooo044000000`3oool01?l0
0000oooo0?ooo`00001G0?ooo`00D@3oool01@000000oooo000000000000oooo008000000`3oool0
0`000000ooooo`00000@0?ooo`?o0000103oool6000000<0oooo00<000000?ooo`3oool04P3oool0
0ol00000oooo0?ooo`0@0?ooo`;o00004@3oool00`000000oooo000000030?ooo`04o`00003oool0
oooo000005L0oooo001@0?ooo`030000003oool000000080oooo00<000000?ooo`3oool01@3oool0
0ol00000oooo0?ooo`0?0?ooo`H000001?l000050?ooo`030000003oool0oooo02@0oooo00?o0000
0?ooo`3oool0403oool00`000000oooo0000000200000080oooo00Go00000?ooo`3oool0oooo0000
001F0?ooo`00C`3oool00`000000oooo0000000<0?ooo`03o`00003oool0oooo00P0oooo1P000008
0?ooo`03o`00003ooooo000000@0oooo00<000000?ooo`3oool08`3oool00ol00000oooo0?ooo`09
0?ooo`03o`00003oool0oooo00<0oooo0P0000020?ooo`80000000@0oooo0000003ooooo00000`3o
ool00`000000oooo0?ooo`1D0?ooo`00CP3oool5000000L0oooo00D000000?ooo`3oool0ooooo`00
00040?ooo`H000003@3oool00ol00000oooo0?ooo`030?ooo`;o000000<000000?ooo`3oool04P3o
ool00ol00000oooo0?ooo`0J0?ooo`03o`00003oool0oooo0080oooo00<000000?ooo`3oool00P3o
ool200000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1D0?ooo`00C@3oool2
000000030?ooo`000000oooo00P0oooo00@000000?ooo`3oool0oooo1@00000K0?ooo`0300000?l0
0000oooo0180oooo00?o00000?ooo`3oool02`3oool2o`0000h0oooo00Co00000?ooo`3oool00000
103oool01P000000oooo0?ooo`000000oooo000000D0oooo00<000000?ooo`3oool0D`3oool004`0
oooo0P0000000`3oool000000?ooo`070?ooo`H00000803oool010000000oooo0?ooo`3oool3o`00
00l0oooo00?o00000?ooo`3oool0203oool2o`000140oooo0P0000050?ooo`040000003oool0oooo
00000080oooo00<00000o`00003oool00P3oool00`000000oooo0?ooo`1C0?ooo`00B`3oool30000
00@0oooo1P0000000`3oool000000?ooo`040?ooo`03o`00003oool0oooo01`0oooo00<000000?oo
o`3oool0103oool00ol00000oooo0?ooo`0<0?ooo`03o`00003oool0oooo01X0oooo00<000000?oo
o`3oool01@3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool0DP3oool004X0oooo2000000=0?ooo`03o`00003oool0oooo01<0oooo00?o00000?oo
o`3oool01P3oool00`000000oooo0?ooo`070?ooo`?o00004@3oool00ol00000oooo0?ooo`0A0?oo
o`040000003oool0ooooo`0000@0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool0DP3oool004T0oooo0`00000C0?ooo`03o`00003oool0
oooo01<0oooo00?o00000?ooo`3oool01P3oool00`000000oooo0?ooo`0:0?ooo`03o`00003oool0
oooo00d0oooo00?o00000?ooo`3oool0403oool2000000<0oooo00?o00000?ooo`3oool00P3oool0
1@000000oooo0?ooo`3oool0000000<0oooo00?o00000000003oool00P3oool00`000000oooo0?oo
o`1B0?ooo`00B@3oool00`000000oooo0000000<0?ooo`030000003oool0oooo00@0oooo00?o0000
0?ooo`3oool04P3oool00ol00000oooo0?ooo`070?ooo`030000003oool0oooo00d0oooo0_l00004
0?ooo`03o`00003oool0oooo00<0oooo00?o00000?ooo`3oool0403oool00`000000oooo0?ooo`04
0?ooo`05o`00003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`050000003o
ool0oooo0?ooo`000000D`3oool004T0oooo0P0000000`3oool000000000000:0?ooo`030000003o
ool0oooo02<0oooo00<000000?ooo`3oool03`3oool01Ol00000oooo0?ooo`3ooooo00000080oooo
00?o00000?ooo`3oool04P3oool00`000000oooo0?ooo`050?ooo`04o`00003oool0oooo000000@0
oooo00<000000?ooo`3oool0103oool010000000oooo0?ooo`00001C0?ooo`00B@3oool2000000<0
oooo0P0000070?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool04`3oool2o`0001<0
oooo0P00000;0?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0ooooo`0000020?oo
o`040000003oool0oooo000005<0oooo001:0?ooo`800000103oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00H0oooo00?o00000?ooo`3oool0703oool00`000000oooo0?ooo`0B0?oo
o`?o00004P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00<0oooo00@000000?oo
o`3ooooo00000`3oool010000000oooo0?ooo`00001B0?ooo`00BP3oool2000000D0oooo0P00000=
0?ooo`03o`00003oool0oooo0100oooo00?o00000?ooo`3oool02@3oool00`000000oooo0?ooo`0C
0?ooo`03o`00003ooooo00000100oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`04
0?ooo`050000003oool0oooo0?ooool000000`3oool00`000000oooo0000001B0?ooo`00B`3oool2
000000H0oooo00<000000?ooo`3oool02`3oool00ol00000oooo0?ooo`0?0?ooo`03o`00003oool0
oooo00T0oooo00<000000?ooo`3oool0403oool2o`0000030?ooool00000oooo00l0oooo0P00000>
0?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3oool0ooooo`0000030?ooo`040000003o
ool0oooo00000540oooo001;0?ooo`8000001`3oool3000000X0oooo00?o00000?ooo`3oool03P3o
ool00ol00000oooo0?ooo`0:0?ooo`030000003oool0oooo00h0oooo0_l000080?ooo`?o0000203o
ool00`000000oooo0?ooo`0>0?ooo`0300000?l00000oooo00@0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0000001A0?ooo`00B`3oool3000000P0oooo00<000000?ooo`3oool09P3oool0
0`000000oooo0?ooo`0K0?ooo`03o`00003oool0oooo00@0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo00L0oooo0P00001A0?ooo`00B`3oool00`00
0000oooo000000070?ooo`040000003oool00000000002H0oooo00<000000?ooo`3oool02`3oool2
o`0000H0oooo00?o00000?ooo`3oool02P3oool200000140oooo00<000000?ooo`3oool01@3oool0
1@000000oooo0?ooo`3ooooo000000H0oooo0P00001@0?ooo`00C03oool3000000H0oooo00@00000
0?ooo`3oool0oooo0P0000070?ooo`03o`00003oool0oooo00`0oooo00?o00000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0:0?ooo`03o`00003oool0oooo00H0oooo00?o00000?ooo`3oool01`3o
ool2o`0000030000003oool0oooo0140oooo00D000000?ooo`3oool0ooooo`0000030?ooo`050000
003oool0oooo0?ooool000001P3oool200000500oooo001<0?ooo`030000003oool0000000`0oooo
00<000000?ooo`3oool0103oool00ol00000oooo0?ooo`0<0?ooo`03o`00003oool0oooo00/0oooo
00<000000?ooo`3oool02@3oool00ol00000oooo0?ooo`070?ooo`03o`00003oool0oooo00P0oooo
00<00000o`00003oool04@3oool00`000000oooo0?ooo`020?ooo`05o`00003oool0oooo0?ooo`00
00000`3oool00ol00000oooo0?ooo`050?ooo`030000003oool0oooo04h0oooo001<0?ooo`040000
003oool0oooo000000`0oooo0P0000050?ooo`03o`00003oool0oooo00X0oooo00?o00000?ooo`3o
ool0303oool00`000000oooo0?ooo`0C0?ooo`03o`00003oool0oooo00H0oooo0P0000020?ooo`03
o`00003oool0oooo00l0oooo00<000000?ooo`3oool00`3oool01?l00000oooo0?ooo`0000030?oo
o`03o`00003oool0oooo00H0oooo00<000000?ooo`3oool0C@3oool004d0oooo0`0000040?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool00P3oool00ol00000oooo0?ooo`0:0?ooo`03
o`00003oool0oooo00`0oooo00<000000?ooo`3oool01`3oool00ol00000oooo0?ooo`0A0?ooo`03
0000003oool0oooo00D0oooo00?o00000?ooo`3oool0303oool00`000000oooo0?ooo`030?ooo`05
o`00003oool0oooo0?ooo`0000002`3oool00`000000oooo0?ooo`1=0?ooo`00C@3oool200000003
0?ooo`000000oooo0080oooo00<000000?ooo`3oool0203oool2000001h0oooo00<000000?ooo`3o
ool01P3oool00ol00000oooo0?ooo`0@0?ooo`8000002@3oool00ol00000oooo0?ooo`0:0?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`1=0?ooo`00
C@3oool01`000000oooo0000003oool000000?ooo`0000003@3oool00`000000oooo0?ooo`0K0?oo
o`030000003oool0oooo00D0oooo00?o00000?ooo`3oool02`3oool00ol00000oooo0?ooo`020?oo
o`030000003oool0oooo00X0oooo00?o00000?ooo`3oool02@3oool00`000000oooo0?ooo`080?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool0CP3oool004h0oooo0P000000103oool0
00000?ooo`00000>0?ooo`8000002`3oool00ol00000oooo0?ooo`0=0?ooo`030000003oool0oooo
01<0oooo00Go00000?ooo`3oool0oooo0000000@0?ooo`;o00001`3oool00`000000oooo0?ooo`05
0?ooo`04o`00003oool0oooo000000<0oooo00?o00000?ooo`3oool0103oool00`000000oooo0?oo
o`1>0?ooo`00CP3oool01@000000oooo0?ooo`3oool000000100oooo00?o00000000000000002@3o
ool00ol00000oooo0?ooo`0=0?ooo`040000003oool0oooo0?ooo`;o00004@3oool00ol000000000
0000000C0?ooo`03o`00003oool0oooo00<0oooo00<000000?ooo`3oool01`3oool00ol00000oooo
000000030?ooo`03o`00003oool0oooo00@0oooo00<000000?ooo`3oool0CP3oool004h0oooo00D0
00000?ooo`3oool0oooo0000000A0?ooo`03o`00003oool0000000L0oooo00?o00000?ooo`3oool0
3P3oool010000000oooo0?ooool0000C0?ooo`030000003oool0oooo01@0oooo00?o00000?ooo`3o
ool00P3oool00`000000oooo0?ooo`080?ooo`03o`0000000000oooo0080oooo00?o00000?ooo`3o
ool0103oool00`000000oooo0?ooo`1>0?ooo`00CP3oool010000000oooo0000003oool200000100
oooo00?o00000?ooo`3oool00P0000050?ooo`03o`00003oool0oooo00h0oooo00<000000?ooo`3o
ool04`3oool00`000000oooo0?ooo`0H0?ooo`03o`00003oool0000000/0oooo00<000000?ooo`3o
ool01`3oool00ol0000000000?ooo`1?0?ooo`00C`3oool2000000030?ooo`000000000001D0oooo
00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0A0?ooo`800000703oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0C`3oool004l0oooo00<0
00000?ooo`0000000P3oool00`000000oooo0?ooo`0C0?ooo`8000004P3oool00ol0000000000?oo
o`0A0?ooo`030000003oool0oooo01`0oooo00<00000o`00003oool02P3oool00ol0000000000?oo
o`070?ooo`030000003oool0oooo04l0oooo001?0?ooo`030000003oool0000000;o000000<00000
0?ooo`3oool03P3oool00ol00000oooo0?ooo`040?ooo`0300000?l00000oooo00h0oooo00?o0000
0?ooo`0000004@3oool00`000000oooo0?ooo`020?ooo`03o`00003oool0oooo01P0oooo00D00000
0?ooo`3oool0ooooo`0000080?ooo`05o`0000000000oooo0?ooool000000`3oool00ol00000oooo
0000001A0?ooo`00D03oool200000080oooo00?o00000000003oool03P3oool00ol00000oooo0?oo
o`050?ooo`800000403oool00`000000oooo0?ooo`0=0?ooo`8000001@3oool00ol00000oooo0?oo
o`0G0?ooo`030000003oool0oooo00<0oooo00?o00000?ooo`3oool01P3oool010000000oooo0?oo
ool000030?ooo`03o`00003oool000000540oooo001@0?ooo`030000003oool000000080oooo00<0
00000?ooo`3oool03P3oool00ol00000oooo0?ooo`030?ooo`03o`00003oool0oooo008000002@3o
ool00ol00000oooo0?ooo`020?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool01@3o
ool00ol00000oooo0?ooo`0G0?ooo`030000003oool0oooo00@0oooo00?o00000?ooo`3oool01@3o
ool01`00003o00000?ooo`3ooooo00000?ooool000000P3oool00`000000oooo0?ooo`1?0?ooo`00
D03oool00`000000oooo000000030?ooo`0300000?l00000oooo00d0oooo00?o00000?ooo`3oool0
0`3oool00ol00000oooo0?ooo`020?ooo`030000003oool0oooo00D0oooo00?o00000?ooo`3oool0
103oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0
303oool02@000000oooo0?ooo`3ooooo00000?ooool00000oooo0000001B0?ooo`00D03oool00`00
0000oooo0?ooo`030?ooo`030000003ooooo000001T0oooo0P0000040?ooo`03o`00003oool0oooo
00D0oooo00<000000?ooo`3oool0203oool200000280oooo00<000000?ooo`3oool0203oool3o`00
0080oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`1@0?ooo`00D@3oool00`000000
oooo0?ooo`030?ooo`030000003ooooo000001X0oooo00<000000?ooo`3oool02@3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool02`3oool01Ol00000
oooo0000003ooooo000000D0oooo00<000000?ooo`3oool0D03oool00540oooo00<000000?ooo`00
00000`3oool00`000000oooo0?ooo`020?ooo`03o`00003oool0oooo00P0oooo00Go00000?ooo`3o
ool0ooooo`0000080?ooo`03o`0000000000000000T0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`0:0?ooo`03o`00003oool0oooo01H0oooo00<000000?ooo`3oool03@3oool01000
0000ooooo`00003oool2o`000080oooo00<000000?ooo`3oool0D03oool00540oooo00<000000?oo
o`000000103oool00`000000oooo0?ooo`020?ooo`03o`00003oool0oooo00L0oooo00Go00000?oo
o`3oool0ooooo`0000070?ooo`05o`00003oool0oooo0?ooo`000000203oool00`000000oooo0?oo
o`040?ooo`8000003@3oool00ol00000oooo0?ooo`0E0?ooo`030000003oool0oooo00l0oooo00<0
0000o`000?l000000_l000000`3oool000000?ooo`1B0?ooo`00DP3oool2000000@0oooo00<00000
0?ooo`3oool00`3oool00ol00000oooo0?ooo`060?ooo`05o`00003oool0oooo0?ooool00000303o
ool2000000H0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0=0?ooo`03o`00003o
ool0oooo01D0oooo00<000000?ooo`3oool03`3oool010000000ooooo`000?l000020?ooo`030000
003oool0oooo0540oooo001B0?ooo`8000001@3oool00`000000oooo0?ooo`0;0?ooo`05o`00003o
ool0oooo0?ooool00000103oool00ol00000oooo0?ooo`070?ooo`800000103oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo00h0oooo00?o00000?ooo`3oool05@3oool00`000000oooo
0?ooo`0<0?ooo`;o000000<0oooo0000003oool00_l000020?ooo`030000003oool0oooo0540oooo
001B0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool3o`0000/0oooo00?o
00000?ooo`3oool02P3oool01@000000oooo0?ooo`3oool000000080oooo0P00000X0?ooo`030000
003oool0oooo00L0oooo0_l000020?ooo`;o00000`3oool010000000ooooo`000?l000020?ooo`03
0000003oool0oooo0540oooo001B0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
1`3oool00ol00000oooo0?ooo`070?ooo`03o`00003oool0oooo00`0oooo0P000000103oool00000
0?ooo`00000Z0?ooo`030000003ooooo000000?o00000P3oool2o`0000T0oooo00<000000?ooool0
00000`3oool00`000000oooo0?ooo`1A0?ooo`00D`3oool2000000D0oooo00<000000?ooo`3oool0
2`3oool00ol00000ooooo`00000D0?ooo`<00000503oool00ol00000oooo0?ooo`0@0?ooo`Co0000
00<000000?ooo`3oool03`3oool01ol0000000000?ooo`3ooooo00000?ooo`000000E03oool005<0
oooo0P0000060?ooo`030000003oool0oooo00P0oooo0ol000000`3ooooo0000o`00000C0?ooo`@0
00004`3oool00ol00000oooo0?ooo`060?ooo`;o00000P3oool4o`0000D0oooo00<000000?ooo`3o
ool03`3oool00ol00000oooo000000020?ooo`03o`00003oool0000005@0oooo001C0?ooo`030000
003oool0000000D0oooo00<000000?ooo`3oool02P3oool3o`0001<0oooo00<000000?ooo`000000
0P3oool300000140oooo0ol000030?ooo`;o00003@3oool00`000000oooo0?ooo`0>0?ooo`04o`00
003oool0oooo00000080oooo00?o00000?ooo`000000E03oool005@0oooo0P0000060?ooo`030000
003oool0oooo00X0oooo1?l000020?ooo`Co00000P3oool4o`000080oooo00Ko000000000000003o
00000?ooo`000004o`0000040?ooo`0000000000000000;o00000`3oool4o`000080oooo1?l0000D
0?ooo`030000003oool0oooo0140oooo00H000000?ooo`3ooooo00000?ooo`00001D0?ooo`00E03o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00X0oooo00?o00000?ooool000003P3o
ool2000000D0oooo00<000000?ooo`3oool01@3oool3000000/0oooo00?o00000?ooo`3oool04@3o
ool00`000000oooo0?ooo`0;0?ooo`;o0000103oool00ol00000oooo000000020?ooo`030000003o
ool0oooo05<0oooo001D0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool0
1_l00000oooo0?ooool00000ooooo`0000`0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`080?ooo`<00000203oool00ol00000oooo0?ooo`0A0?ooo`030000003oool0oooo00X0oooo
00?o00000?ooo`3oool0103oool00ol00000oooo000000020?ooo`030000003oool0oooo05<0oooo
001D0?ooo`030000003oool0000000L0oooo00<000000?ooo`3oool01@3oool01Ol00000oooo0?oo
o`3ooooo000000@0oooo00?o00000?ooo`3oool01@3oool2000000P0oooo00<000000?ooo`3oool0
2`3oool3000000@0oooo00?o00000?ooo`3oool04P3oool00`000000oooo0?ooo`0C0?ooo`040000
0?l00000oooo000005D0oooo001E0?ooo`8000001`3oool00`000000oooo0?ooo`040?ooo`03o`00
003oool0oooo00P0oooo00?o00000?ooo`3oool00P3oool2000000X0oooo00<000000?ooo`3oool0
3P3oool3000000030?ooool00000oooo0180oooo00<000000?ooo`3oool0203oool00ol00000oooo
0?ooo`090?ooo`0400000?l00000oooo000005D0oooo001E0?ooo`800000203oool00`000000oooo
0?ooo`0?0?ooo`04o`00003oool0oooo000000`0oooo00<000000?ooo`3oool04@3oool300000180
oooo00<000000?ooo`3oool01`3oool00ol00000oooo0?ooo`060?ooo`08o`00003oool0oooo0?oo
o`00003o00000?ooo`00001E0?ooo`00E@3oool2000000P0oooo00D000000?ooo`3oool0ooooo`00
00070?ooo`03o`00003oool0oooo00@0oooo0P00000>0?ooo`030000003oool0oooo01<0oooo0`00
000?0?ooo`030000003oool0oooo00H0oooo00?o00000?ooo`3oool01`3oool01ol00000oooo0?oo
o`3oool00000o`0000000000EP3oool005H0oooo00<000000?ooo`3oool01`3oool010000000oooo
0?ooool000070?ooo`03o`00003oool0oooo0080oooo0P0000020?ooo`;o0000303oool00`000000
oooo0?ooo`0A0?ooo`03o`00003oool0oooo0080oooo0`00000;0?ooo`030000003oool0oooo0100
oooo00?o00000?ooo`3oool00P3oool00`000000oooo0000001F0?ooo`00EP3oool00`000000oooo
0?ooo`070?ooo`030000003ooooo000000T0oooo00Co00000?ooo`3oool000001P3oool00ol00000
oooo0?ooo`090?ooo`030000003oool0oooo0140oooo00?o00000?ooo`3oool01@3oool3000000P0
oooo00<000000?ooo`3oool0103oool00ol00000oooo0?ooo`0>0?ooo`030000003oool0000005H0
oooo001F0?ooo`8000002@3oool00`000000oooo0?ooo`080?ooo`03o`0000000000000001<0oooo
00<000000?ooo`3oool04@3oool00ol00000oooo0?ooo`080?ooo`<000001@3oool00`000000oooo
0?ooo`030?ooo`03o`00003oool0oooo0100oooo0P00001F0?ooo`00E`3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00L0oooo0P00000<0?ooo`03o`00003oool0oooo00L0oooo00<0
00000?ooo`3oool0403oool00ol00000oooo0?ooo`0;0?ooo`<0000000<0oooo0000003oool0103o
ool00ol00000oooo0?ooo`090?ooo`03o`00003oool0oooo00D0oooo0P00001F0?ooo`00E`3oool2
000000H0oooo00Co00000?ooo`3oool000001`3oool00`000000oooo0?ooo`0=0?ooo`03o`00003o
ool0oooo00H0oooo00<000000?ooo`3oool08@3oool?000000@0oooo00?o00000?ooo`3oool01@3o
ool00`000000oooo0?ooo`1E0?ooo`00E`3oool2000000D0oooo00Go00000?ooo`3oool0oooo0000
00050?ooo`8000000`3oool00ol00000oooo0?ooo`0;0?ooo`03o`00003oool0oooo00D0oooo00<0
00000?ooo`3oool08P3oool010000000ooooo`000?l0000:0?ooo`d00000E`3oool005L0oooo00<0
00000?ooo`3oool00`3oool00ol00000oooo0?ooo`030?ooo`030000003oool0oooo008000001@3o
ool00ol00000oooo0?ooo`0>0?ooo`;o00000`3oool00`000000oooo0?ooo`0@0?ooo`03o`00003o
ool0oooo00h0oooo00<000000?ooool000003`3oool00ol00000oooo0?ooo`040?ooo`030000003o
ool0oooo05L0oooo001H0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`000000203oool0
0ol00000oooo0?ooo`0?0?ooo`04o`00003oool0oooo00000180oooo00?o00000?ooo`3oool03@3o
ool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo05P0oooo001H0?ooo`030000003oool0
oooo00L0oooo1000000K0?ooo`04o`00003oool0oooo00000140oooo00?o00000?ooo`3oool03@3o
ool00`000000oooo0?ooo`0>0?ooo`03o`00003oool0oooo00<0oooo0P00001K0?ooo`00F03oool0
10000000oooo0?ooool000020?ooo`@00000103oool00`000000oooo0?ooo`0K0?ooo`030000003o
ool0oooo00l0oooo00?o00000?ooo`3oool0303oool00`00003o00000?ooo`0?0?ooo`03o`00003o
ool0oooo0080oooo0P00001L0?ooo`00F@3oool00`00003o000000000002000000T0oooo00<00000
0?ooo`3oool01@3oool00ol00000oooo0?ooo`0A0?ooo`03o`000000003o000001h0oooo00<00000
0?ooo`3oool03`3oool00ol00000oooo0?ooo`020?ooo`800000G@3oool005T0oooo0`00000<0?oo
o`030000003oool0oooo00@0oooo00?o00000?ooo`3oool04P3oool00`000000ooooo`00000M0?oo
o`030000003oool0oooo00l0oooo00?o00000?ooo`3oool00`00001N0?ooo`00F`3oool2000000`0
oooo00<000000?ooo`3oool0103oool00ol00000oooo0?ooo`0A0?ooo`030000003oool0oooo00l0
oooo00?o00000?ooo`3oool0203oool00ol00000oooo0000000D0?ooo`030000003oool0000005l0
oooo001L0?ooo`800000303oool00`000000oooo0?ooo`030?ooo`03o`00003oool0oooo0180oooo
00D000000?ooo`3oool0ooooo`00000<0?ooo`03o`00003oool0oooo00L0oooo00?o00000?ooo`00
0000503oool00`000000oooo0000001P0?ooo`00GP3oool3000000X0oooo00<000000?ooo`3oool0
5`3oool00`000000oooo0?ooo`020?ooo`03o`00003oool0oooo00T0oooo00?o00000?ooo`3oool0
1P3oool01?l00000oooo0?ooo`00000A0?ooo`05o`000000000000000?ooo`000000H@3oool005l0
oooo0`00000:0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool00`3oool00ol00000
oooo0?ooo`080?ooo`03o`00003oool0oooo00P0oooo00<000000?ooo`3oool0403oool010000000
oooo0?ooo`00001R0?ooo`00H@3oool00`000000oooo0?ooo`02000000L0oooo00<000000?ooo`3o
ool00P3oool00ol00000oooo0?ooo`0@0?ooo`030000003oool0oooo01@0oooo00Go00000?ooo`3o
ool0oooo0000000B0?ooo`040000003oool0oooo000006<0oooo001R0?ooo`050000003oool0oooo
0?ooo`0000001`3oool01@000000oooo0?ooo`3ooooo000001<0oooo00<000000?ooo`3oool01@3o
ool2o`0000/0oooo00?o00000?ooo`3oool00P3oool00`000000oooo0?ooo`0?0?ooo`040000003o
ool0oooo000006@0oooo001S0?ooo`8000000P3oool00`000000oooo0?ooo`050?ooo`050000003o
ool0oooo0?ooool000004P3oool00`000000oooo0?ooo`070?ooo`03o`00003oool0oooo00L0oooo
00?o00000?ooo`3oool00P3oool00`000000oooo0?ooo`0>0?ooo`8000000P3oool00`000000oooo
0?ooo`1S0?ooo`00I@3oool00`000000oooo0?ooo`020?ooo`800000103oool010000000oooo0?oo
ool0000B0?ooo`030000003oool0oooo00`0oooo00?o00000?ooo`3oool01P3oool00`000000oooo
0?ooo`0>0?ooo`050000003ooooo00000?ooo`000000IP3oool006H0oooo0P0000040?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0:0?ooo`?o0000
00<0ooooo`000?l000001@3oool00`000000oooo0?ooo`0=0?ooo`050000003oool0ooooo`000000
0000I`3oool006P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0A0?ooo`030000
003oool0oooo00/0oooo1?l000020?ooo`?o000000<000000?ooo`3oool0303oool200000080oooo
00?o00000000003oool0I`3oool006T0oooo0P0000040?ooo`<0000000<0oooo00000?l000004P3o
ool00`000000oooo0?ooo`020?ooo`Co00000`3oool00ol00000ooooo`0000060?ooo`030000003o
ool0oooo0080oooo0ol000030?ooo`Co000000@000000?ooool0003o00000P00001Y0?ooo`00J`3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0000000d0oooo0_l000020?ooo`04o`000000
003o0000o`000180oooo00<000000?ooo`3oool02`3oool01@000000oooo0?ooo`3oool0000006/0
oooo001/0?ooo`8000001`3oool00`000000oooo0?ooo`020?ooo`Co00000P3oool2o`0000D0oooo
00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0:0?ooo`8000000P3oool2000006`0oooo
001^0?ooo`030000003oool0oooo00@0oooo00?o000000000?l000003`3oool00`000000oooo0?oo
o`0@0?ooo`030000003oool0oooo00X0oooo00D000000?ooo`3oool0oooo0000001^0?ooo`00K`3o
ool2000000H0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`090?ooo`03o`00003o
ool0oooo00<0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`02000006l0oooo001a
0?ooo`030000003oool0oooo00@0oooo0P00000>0?ooo`030000003oool0oooo00T0oooo00?o0000
0?ooo`3oool00P3oool00`000000oooo0?ooo`080?ooo`8000000P3oool00`000000oooo0?ooo`1_
0?ooo`00LP3oool2000000D0oooo0P00000=0?ooo`030000003oool0oooo00P0oooo00?o00000?oo
o`3oool00P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00800000LP3oool007@0
oooo00<000000?ooo`3oool00`3oool2000000`0oooo00<000000?ooo`3oool03@3oool00`000000
oooo0?ooo`070?ooo`040000003oool0oooo000007@0oooo001e0?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00H0
oooo0P0000000`3oool000000000001e0?ooo`00MP3oool2000000@0oooo0P00000;0?ooo`030000
003oool0oooo00D0oooo00?o00000?ooo`3oool00P3oool00`000000oooo0?ooo`060?ooo`040000
003oool0oooo000007L0oooo001h0?ooo`030000003oool0oooo0080oooo0P00000:0?ooo`030000
003oool0oooo00D0oooo00?o00000?ooo`3oool00P3oool00`000000oooo0?ooo`050?ooo`040000
003oool00000000007P0oooo001i0?ooo`8000000`3oool2000000T0oooo00<000000?ooo`3oool0
103oool00ol00000oooo0?ooo`020?ooo`030000003oool0oooo00@0oooo0P0000000`3oool00000
0?ooo`1i0?ooo`00N`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool0103oool01Ol00000oooo0?ooo`3oool0000000H0oooo00@000000?ooo`000000
0000N`3oool007`0oooo0P0000030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`030?ooo`030000003oool0000007d0oooo001n0?ooo`050000003o
ool0oooo0?ooo`0000001`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00<0oooo
0`00001n0?ooo`00O`3oool200000080oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`020?ooo`04o`00003oool0oooo000000@0oooo0`0000200?ooo`00P@3oool010000000oooo0?oo
o`0000050?ooo`030000003oool0oooo0080oooo00Co00000?ooo`3oool000000`3oool300000840
oooo00220?ooo`80000000<0oooo0000003oool00`3oool01@000000oooo0?ooo`3ooooo00000080
oooo00@000000?ooo`3oool0oooo0P0000230?ooo`00Q03oool3000000@0oooo00H000000?ooo`3o
oooo00000?ooo`0000020?ooo`<00000Q03oool008D0oooo00<000000?ooo`0000000`3oool00`00
0000oooo0?ooo`020?ooo`040000003oool00000000008H0oooo00260?ooo`<000000P3oool01P00
0000oooo0?ooo`3oool000000?ooo`800000Q`3oool008P0oooo0P000000103oool000000?ooool0
0003000008T0oooo00290?ooo`<0000000@0ooooo`00000000000000RP3oool008/0oooo0`00002<
0?ooo`00S03oool00`000000oooo0?ooo`2;0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3o
oolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3o
oolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3o
oolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3o
oolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3o
oolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3o
oolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3o
oolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3o
oolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3o
oolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3o
oolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3o
oolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3o
oolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3o
oolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-5.00005*^-6, -5.00005*^-6, \
0.00355875, 0.00355875}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.0025 w
[ .01 .012 ] 0 setdash
.4104 .57603 m
.55806 .45048 L
s
.4104 .57603 m
.34205 .4116 L
s
.4104 .57603 m
.5704 .56684 L
s
.4104 .57603 m
.44521 .41961 L
s
.4104 .57603 m
.30586 .5282 L
s
.4409 .687 m
.4104 .57603 L
s
.33127 .64347 m
.4104 .57603 L
s
.56177 .66998 m
.4104 .57603 L
s
.55806 .45048 m
.72174 .53604 L
s
.55806 .45048 m
.5 .27523 L
s
.55806 .45048 m
.63136 .38822 L
s
.5704 .56684 m
.55806 .45048 L
s
.44521 .41961 m
.55806 .45048 L
s
.5704 .56684 m
.72174 .53604 L
s
.56177 .66998 m
.5704 .56684 L
s
.44521 .41961 m
.5 .27523 L
s
.44521 .41961 m
.34205 .4116 L
s
.63136 .38822 m
.67212 .35366 L
s
.63136 .38822 m
.72174 .53604 L
s
.63136 .38822 m
.5 .27523 L
s
.56177 .66998 m
.72174 .53604 L
s
.56177 .66998 m
.4409 .687 L
s
.64223 .66726 m
.56177 .66998 L
s
.5 .75807 m
.56177 .66998 L
s
.34205 .4116 m
.5 .27523 L
s
.34205 .4116 m
.24533 .45861 L
s
.34205 .4116 m
.35775 .3327 L
s
.30586 .5282 m
.34205 .4116 L
s
.72174 .53604 m
.67212 .35366 L
s
.64223 .66726 m
.72174 .53604 L
s
.0035 w
[ ] 0 setdash
.72174 .53604 m
.716 .46862 L
s
.68501 .60355 m
.72174 .53604 L
s
.0025 w
[ .01 .012 ] 0 setdash
.5 .27523 m
.67212 .35366 L
s
.35775 .3327 m
.5 .27523 L
s
.0035 w
[ ] 0 setdash
.5 .27523 m
.56576 .2919 L
s
.5 .27523 m
.42762 .30083 L
s
.0025 w
[ .01 .012 ] 0 setdash
.33127 .64347 m
.4409 .687 L
s
.5 .75807 m
.4409 .687 L
s
.30586 .5282 m
.24533 .45861 L
s
.33127 .64347 m
.30586 .5282 L
s
.0035 w
[ ] 0 setdash
.33127 .64347 m
.24533 .45861 L
s
.34491 .63198 m
.33127 .64347 L
s
.5 .75807 m
.33127 .64347 L
s
.5 .75807 m
.64223 .66726 L
s
.68501 .60355 m
.64223 .66726 L
s
.35775 .3327 m
.42762 .30083 L
s
.35775 .3327 m
.24533 .45861 L
s
.67212 .35366 m
.62321 .39544 L
s
.67212 .35366 m
.716 .46862 L
s
.56576 .2919 m
.67212 .35366 L
s
.716 .46862 m
.62321 .39544 L
s
.68501 .60355 m
.716 .46862 L
s
.56576 .2919 m
.62321 .39544 L
s
.42762 .30083 m
.56576 .2919 L
s
.5 .75807 m
.34491 .63198 L
s
.42176 .56672 m
.5 .75807 L
s
.57206 .60573 m
.5 .75807 L
s
.68501 .60355 m
.5 .75807 L
s
.24533 .45861 m
.42762 .30083 L
s
.24533 .45861 m
.40739 .41207 L
s
.34491 .63198 m
.24533 .45861 L
s
.42176 .56672 m
.24533 .45861 L
s
.68501 .60355 m
.62321 .39544 L
s
.68501 .60355 m
.57206 .60573 L
s
.42762 .30083 m
.62321 .39544 L
s
.40739 .41207 m
.42762 .30083 L
s
.42176 .56672 m
.34491 .63198 L
s
.57206 .60573 m
.62321 .39544 L
s
.57206 .60573 m
.42176 .56672 L
s
.40739 .41207 m
.62321 .39544 L
s
.42176 .56672 m
.40739 .41207 L
s
.42176 .56672 m
.62321 .39544 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.1,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016R000`400?l00000o`00003ooooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00Roooool4o`0008_ooooo0028ooooo`Go00000_oo
ool3o`0008Sooooo0025ooooo`?o00000_ooool00ol0003oooooooooo`03o`0000;ooooo1?l00024
ooooo`00P_ooool3o`0000Kooooo00?o0000ooooooooool00_ooool01?l0003oooooooooo`000002
ooooo`Co0000P?ooool007oooooo0ol00005ooooo`05o`000?ooooooooooooooool000002?ooool0
0`00003oooooooooo`03ooooo`?o0000OOooool007cooooo0ol00007ooooo`05o`000?oooooooooo
ooooool000000oooool00ol0003oooooooooo`04ooooo`_o0000N_ooool007Wooooo0ol000000ooo
ool0000000000003oooooa?o00001Oooool01P00003ooooooooooooooooo0000ooooo`;o0000N?oo
ool007Oooooo2ol0000=ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01oooool0
1?l0003oooooooooool0001gooooo`00MOooool2o`00000300000?l0003ooooo00;o00001_ooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo0P0000001?l0003ooooooooooooo
ool2o`0007Gooooo001booooo`Co000000<00000ooooool000000oooool2o`0000?ooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`0Cooooo`0300000?l0003ooooo00?ooooo0_l0001c
ooooo`00L?ooool2o`00000300000?oooooo000000?ooooo00?o0000ooooooooool00oooool3o`00
00Sooooo00?o0000ooooooooool02oooool2o`0000Sooooo00Co000000000000000000000_ooool2
o`00077ooooo001^ooooo`;o000000@00000oooooooooooo00000oooool00ol0003oooooooooo`06
ooooo`;o00001_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Kooooo00?o0000
ooooooooool01Oooool01Ol0003oooooooooooooool0000000?ooooo00?o0000ooooooooool0K_oo
ool006cooooo0_l00003ooooo`;o00001?ooool00ol0003oooooooooo`04ooooo`04o`000?oooooo
ooooooooo`;o00001?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00oooooo00?o
0000ooooooooool01Oooool2o`0006kooooo001Zooooo`;o000000D00000ooooooooooooooooo`00
0006ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01?ooool2o`0000_ooooo00?o
0000ooooooooool03_ooool00ol0003oooooooooo`03ooooo`<0000000?oooooo`000?l00000K?oo
ool006Oooooo0ol000000`00003oooooooooo`02ooooo`03o`000?oooooooooo00Gooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`07ooooo`;o00002Oooool00ol0003oooooooooo`08
ooooo`;o00001Oooool00ol0003oooooooooo`05ooooo`0300000?oooooooooo00;o0000J_ooool0
06Gooooo0_l000000`00003oooooooooo`04ooooo`03o`000?oooooooooo00Kooooo00?o0000oooo
ooooool03?ooool01?l0003oooooo`000?l0000Dooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool01oooool2000000;o0000J?ooool006Cooooo00?o000000000?ooool01_ooool00ol0
003oooooooooo`06ooooo`04o`000?ooooooooooo`0000cooooo00Co0000oooooooooooooooo0_l0
000Hooooo`03o`000?oooooooooo00Wooooo00<00000ooooool00000Ioooool006Cooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`07ooooo`03o`000?oooooo000000cooooo00?o0000
ooooooooool01?ooool2o`0000Cooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0;
ooooo`;o0000IOooool006?ooooo0_l00005ooooo`;o00002_ooool2o`0001Kooooo0_l00002oooo
o`03o`000?oooooooooo00cooooo00Go0000ooooooooooooooooo`00000=ooooo`8000000_l0001S
ooooo`00H_ooool2o`0000Gooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0Goooo
o`;o000000?oooooo`000?ooool03Oooool01Ol0003ooooooooooooooooo000000oooooo00<00000
o`000?l00000HOooool0067ooooo00?o0000ooooool000001?ooool00ol0003oooooooooo`09oooo
o`03o`000?oooooo000000gooooo00?o0000ooooooooool02oooool3o`0000kooooo00Go0000oooo
ooooooooooooo`00000Aooooo`03o`000000003ooooo05kooooo001Pooooo`03o`000?oooooooooo
00Cooooo00?o0000ooooooooool02Oooool00ol0003oooooo`00000>ooooo`03o`000?oooooooooo
00kooooo0_l0000@ooooo`03o`000?oooooooooo013ooooo0_l0001Nooooo`00Goooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo00Wooooo00Co0000oooooooooooo00003Oooool00ol0
003oooooooooo`0Aooooo`;o00003?ooool2o`000003ooooool0003ooooo017ooooo0_l0001Moooo
o`00G_ooool00ol0003oooooooooo`02ooooo`?o00003oooool00ol0003oooooooooo`0;ooooo`03
o`000?oooooooooo00kooooo00?o0000ooooooooool00_ooool2o`0000cooooo0_l0000Aooooo`Co
0000G?ooool005gooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool07?ooool00ol0003oooooooooo`04ooooo`;o0000
2oooool2o`0000oooooo0_l00002ooooo`03o`000?oooooooooo05[ooooo001Looooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo01gooooo00?o0000ooooooooool01Oooool2o`0000[ooooo00?o0000ooooooooool03?oo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo05[ooooo001Kooooo`03o`000?oooooo
oooo00?ooooo0_l0000;ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool02oooool0
0ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00Oooooo0_l00009ooooo`03o`000?oooooo
oooo00[ooooo0_l00004ooooo`03o`000?oooooooooo05[ooooo001Jooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo
01cooooo0_l00008ooooo`03o`000?oooooooooo00Sooooo0_l00006ooooo`03o`000?oooooooooo
05Wooooo001Iooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool02Oooool00ol0003o
ooooooooo`06ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool07oooool2o`0000Ko
oooo0_l00008ooooo`;o00001oooool00ol0003oooooooooo`1Iooooo`00FOooool01?l0003ooooo
ooooooooool2o`0000;ooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`07ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0<ooooo`;o
00001Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Oooooo0_l0001Jooooo`00
F?ooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool01Oooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo01oooooo00?o0000ooooooooool03_ooool2o`0000?o
oooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`08ooooo`;o0000F_ooool005Oo
oooo00Go0000ooooooooooooooooo`000005ooooo`03o`000?oooooooooo00oooooo00?o0000oooo
ooooool08?ooool00ol0003oooooooooo`0@ooooo`;o00000_ooool01_l0003oooooooooool0003o
ooooo`0000cooooo00?o0000ooooooooool0F?ooool005Kooooo00Go0000ooooooooooooooooo`00
0006ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool04_ooool2o`000003ooooool0
003ooooo00;o00003_ooool00ol0003oooooooooo`1Gooooo`00EOooool01Ol0003ooooooooooooo
oooo000000_ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo02[ooooo1Ol0000>ooooo`03o`000?oooooooooo05Oooooo001Dooooo`03o`000?oooooo
oooo00;o00002oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00Wooooo00?o0000
ooooooooool09Oooool:o`000003ooooool0003ooooo00gooooo00?o0000ooooooooool0E_ooool0
05?ooooo00Co0000oooooooooooo00002Oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooo
oooo00Wooooo00?o0000ooooooooool05_ooool?o`0000Gooooo0_l000001?oooooo0000ooooool0
000>ooooo`;o0000F?ooool005;ooooo00Co0000oooooooooooo00002_ooool00ol0003oooooo`00
000?ooooo`03o`000?oooooooooo01Cooooo4?l0000Booooo`;o00000_ooool01?l0003ooooooooo
ool0000=ooooo`;o0000F?ooool0057ooooo00Co0000oooooooooooo00002oooool2o`00013ooooo
00?o0000ooooooooool01Oooool?o`0000oooooo00?o0000ooooooooool03oooool2o`0000;ooooo
00?o0000ooooool000000_ooool2o`0000cooooo0_l0001Gooooo`00D?ooool01?l0003ooooooooo
ool0000;ooooo`Go00003?ooool:o`0000Cooooo00?o0000ooooooooool0:Oooool01ol0003ooooo
oooooooooooo0000ooooool000001?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo
05Gooooo001?ooooo`04o`000?ooooooooooo`0000[ooooo1?l00003ooooo`03o`000?oooooooooo
00Co00000_ooool4o`000003ooooool0003ooooo00[ooooo00?o0000ooooooooool09oooool2o`00
00Cooooo00?o0000ooooool000001Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo
05Cooooo001?ooooo`?o00003Oooool00ol0003oooooooooo`07ooooo`Co00001Oooool00ol0003o
ooooo`000002o`0000?ooooo1Ol0000Xooooo`03o`000?oooooooooo00Cooooo00Co0000oooooooo
oooo00001Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo05Cooooo001>ooooo`;o
00002Oooool2o`0000Cooooo00?o0000ooooooooool01?ooool3o`0000Wooooo00?o0000oooooooo
ool02?ooool00ol0003oooooo`00000Iooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool01?ooool01Ol0003ooooooooooooooooo000000Kooooo0_l00007ooooo`04o`000?oooooooooo
o`0005Gooooo001=ooooo`;o00002?ooool2o`0000Sooooo1Ol0000<ooooo`03o`000?oooooooooo
00Oooooo00?o0000ooooooooool01?ooool2o`0001Cooooo00?o0000ooooooooool02Oooool00ol0
003oooooooooo`05ooooo`05o`000?ooooooooooooooool000001Oooool01?l0003oooooooooool0
0006ooooo`04o`000?ooooooooooo`0005Gooooo001<ooooo`;o00004Oooool3o`00013ooooo00?o
0000ooooooooool04?ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00Kooooo0_l0
0008ooooo`05o`000?ooooooooooooooool000001Oooool01Ol0003ooooooooooooooooo000000Ko
oooo00?o0000ooooool00000EOooool004_ooooo0_l00006ooooo`;o00001_ooool4o`0000?ooooo
00?o0000ooooooooool03_ooool00ol0003oooooooooo`0Booooo`Co00005_ooool2o`0000Wooooo
00?o0000ooooooooool00_ooool00ol0003oooooooooo`03ooooo`04o`000?ooooooooooooooo`;o
00001oooool00ol0003oooooooooo`1Booooo`00B_ooool2o`0000Kooooo00?o0000ooooooooool0
0_ooool4o`0000?ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`05ooooo`03o`00
0?oooooooooo013ooooo0ol0000@ooooo`;o00002Oooool00ol0003oooooooooo`03ooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo05;ooooo0019ooooo`03o`000?oooooooooo00;ooooo0_l00004ooooo`?o00001ooo
ool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool04ooo
ool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool02Ooo
ool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`1Aooooo`00B?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooo
oooo00Co00002Oooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00Gooooo00?o0000
ooooooooool05_ooool3o`0000Cooooo00?o0000ooooooooool00_l0000<ooooo`03o`000?oooooo
oooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`02ooooo`;o000000Gooooo
o`000?ooooooooooo`00001Cooooo`00Aoooool00ol0003oooooooooo`02ooooo`Co00004oooool0
0ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool06Oooool0
0ol0003oooooooooo`02ooooo`?o00003Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool01?ooool2o`0000;ooooo00?o0000ooooooooool0DOooool0
04Kooooo00?o0000ooooool000001?l0000Gooooo`03o`000?oooooooooo00cooooo00?o0000oooo
ooooool09?ooool5o`0000cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`06oooo
o`03o`000?oooooooooo00Cooooo0_l00002ooooo`03o`000?oooooooooo053ooooo0015ooooo`Co
00007?ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo02Gooooo0_l00002ooooo`03
o`000?oooooooooo00Wooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`05ooooo`03
o`000?oooooooooo00Gooooo00Co0000oooooooooooo0000D_ooool004Cooooo0_l0000Fooooo`03
o`000?oooooooooo01Cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Mooooo`;o
000000?oooooo`000?ooool03?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00ko
oooo0_l000000ooooooo0000ooooo`1@ooooo`00A?ooool3o`0001Gooooo00?o0000ooooooooool0
5?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo01cooooo00?o0000ooooooooool0
1_ooool2o`0000Oooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0@ooooo`;o0000
DOooool004Gooooo00Co0000ooooool0003o00004_ooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Kooooo`03o`00
0?oooooooooo00Wooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo00Oooooo00?o0000ooooooooool01?ooool01?l0003oooooooooool0001Aooooo`00
AOooool01?l0003oooooooooooooool2o`0001_ooooo00?o0000ooooooooool02_ooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`0:ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01_ooool00ol0003o
ooooooooo`04ooooo`05o`000?ooooooooooooooool00000D?ooool004Kooooo00?o000000000?oo
ool00_ooool00ol0003oooooooooo`0Iooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool07_ooool2o`0000Kooooo00?o0000ooooooooool01oooool4o`0000[ooooo00?o0000oooooooo
ool01oooool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool00000D?ooool004Ko
oooo0_l000001000003oooooooooooooool2o`0000cooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo01gooooo00?o0000ooooooooool01_ooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool04Oooool00ol0
003oooooooooo`1>ooooo`00Aoooool00ol0003ooooo00000004ooooo`03o`000?oooooooooo00Wo
oooo00?o0000ooooooooool05oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo01Oo
oooo00?o0000ooooooooool01oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool03oooool2o`00053ooooo0017ooooo`;o00001_ooool2o`0000Sooooo
00?o0000ooooooooool06?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo01Kooooo
00?o0000ooooooooool05?ooool01?l0003oooooooooooooool2o`0000Oooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`04ooooo`;o0000D?ooool004Sooooo00Co0000ooooooooool0
00001Oooool2o`0000Kooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`09ooooo`05
o`000?ooooooooooooooool000005oooool2o`0001Oooooo00?o0000ooooooooool00oooool00ol0
003oooooooooo`04ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool00_ooool01?l0
003oooooo`000?l0001@ooooo`00B?ooool2o`000003ooooo`00003ooooo00Kooooo00?o0000oooo
ooooool04_ooool00ol0003oooooooooo`09ooooo`05o`000?ooooooooooooooool000005_ooool2
o`0001Sooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`09ooooo`06o`000?oooooo
ooooooooool0003ooooo0_l0001@ooooo`00BOooool01?l0003oooooooooo`000007ooooo`;o0000
4oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo01Oooooo0_l0000>ooooo`03o`00
0?oooooooooo00Oooooo00?o0000ooooooooool01oooool3o`0000;ooooo00?o0000ooooooooool0
3Oooool00ol0003oooooo`00001@ooooo`00BOooool2o`0000;ooooo00<00000ooooooooool01_oo
ool3o`00013ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0Fooooo`03o`000?oo
oooooooo00kooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooo000000oooooo00?o0000ooooool00000D?ooool004[ooooo0_l0000<ooooo`03o`000?oooooo
oooo01Wooooo00?o0000ooooooooool05Oooool2o`00013ooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`0<ooooo`;o00002oooool01_l0003oooooooooool0003oooooo`00053ooooo
001:ooooo`;o00001?ooool00`00003oooooooooo`04ooooo`04o`000?oooooo0000o`0001Wooooo
00Co0000oooooooooooo00004_ooool2o`0001_ooooo00?o0000ooooooooool03_ooool2o`0000[o
oooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`1=ooooo`00B_ooool00ol0003o
ooooo`000003ooooo`0300000?oooooooooo00Cooooo00Go0000ooooooooooooooooo`00000?oooo
o`03o`000?oooooooooo00Kooooo00Co0000oooooooooooo00004_ooool00ol0003oooooooooo`0J
ooooo`03o`000?oooooooooo00kooooo00?o0000ooooool000002_ooool01_l0003oooooo`000?l0
003oooooo`0004oooooo001;ooooo`;o00001?ooool00`00003oooooooooo`08ooooo`;o00003Ooo
ool00ol0003oooooooooo`07ooooo`03o`000?oooooo0000013ooooo0_l0000Mooooo`03o`000?oo
oooooooo00kooooo00?o0000ooooooooool00_ooool2o`0000Oooooo00Go0000ooooool0003ooooo
o`00001?ooooo`00Boooool00ol0003oooooo`00000@ooooo`;o00003?ooool00ol0003ooooooooo
o`06ooooo`03o`000?oooooooooo00oooooo0_l0000Eooooo`03o`000?oooooooooo00Kooooo00?o
0000ooooooooool03oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Cooooo00?o
0000ooooooooool00_l0001?ooooo`00C?ooool2o`0000Sooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`0Booooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool05Oooool0
0ol0003oooooooooo`05ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool00000Coooool004cooooo00?o0000
ooooool000001Oooool00`00003oooooo`00000:ooooo`;o00004_ooool00ol0003oooooooooo`0=
ooooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0@
ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool00_l00002ooooo`03o`000?oooooo
oooo04gooooo001=ooooo`03o`000?oooooo000000Cooooo00<00000o`000?ooool03?ooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00Gooooo0_l0000=ooooo`03o`000?oooooooooo
01Oooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo
00Sooooo0_l00002ooooo`03o`000?oooooo000004oooooo001=ooooo`03o`000?oooooo000000Go
oooo00<00000o`000?ooool03?ooool2o`0000Oooooo00?o0000ooooooooool01Oooool2o`0000_o
oooo0_l0000Rooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool02?ooool01?l0003o
ooooooooooooool2o`0004oooooo001>ooooo`03o`000?oooooo000000Cooooo00<00000ooooool0
00003_ooool2o`0000Kooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`09ooooo`03
o`000?oooooooooo027ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo00?o0000Coooool004kooooo00?o0000ooooool000001Oooool01000003ooooo
ooooooooool2o`0000cooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`04ooooo`03
o`000?oooooooooo00Sooooo00?o0000ooooooooool07?ooool00ol0003oooooooooo`03ooooo`03
o`000?oooooooooo01;ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`02ooooo`03
o`000?oooooooooo04gooooo001?ooooo`03o`000?oooooo000000[ooooo00?o0000ooooooooool0
2_ooool2o`0000[ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Mooooo`03o`00
0?oooooooooo00?ooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`06ooooo`Co0000
00?oooooo`000?l00000Coooool004oooooo00?o0000ooooool000003Oooool2o`0000[ooooo0_l0
0008ooooo`03o`000?oooooooooo00Gooooo0_l0000Pooooo`03o`000?oooooooooo00?ooooo00?o
0000ooooooooool04oooool00ol0003oooooooooo`02ooooo`;o00000_ooool01?l0003ooooooooo
ooooool2o`00053ooooo001@ooooo`03o`000?oooooo000000Cooooo00<00000ooooooooool01ooo
ool00ol0003oooooooooo`09ooooo`03o`000?oooooo000000Gooooo00?o0000ooooooooool01?oo
ool2o`00027ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Cooooo`;o00000_oo
ool2o`0000Cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`1>ooooo`00D?ooool0
1?l0003oooooooooool00003ooooo`0300000?oooooooooo00Sooooo00?o0000ooooooooool02Ooo
ool2o`0000Gooooo0_l00004ooooo`;o00009oooool00ol0003oooooooooo`0Aooooo`;o000000?o
ooooo`000?ooool01oooool2o`0000;ooooo00?o0000ooooooooool0Coooool0057ooooo00?o0000
ooooool000000oooool00`00003oooooooooo`0;ooooo`?o00002?ooool01ol0003ooooooooooooo
oooo0000ooooool000000oooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo00_ooooo
1?l00006ooooo`03o`000?oooooooooo00Cooooo0_l00002ooooo`;o0000DOooool0057ooooo00Co
0000oooooooooooo00000_ooool00`00003oooooooooo`0>ooooo`03o`000?oooooooooo00Gooooo
0ol00003ooooo`03o`000?oooooooooo00;o00009?ooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo00Gooooo1?l0000<ooooo`03o`000?oooooooooo00Cooooo00Go0000oooooooooooo
ooooo`00001Booooo`00D_ooool00ol0003oooooo`00000Nooooo`;o000000Coooooo`000?oooooo
00009_ooool01Ol0003ooooooooooooooooo000000Cooooo0_l0000Booooo`03o`000?oooooooooo
00Cooooo00Go0000ooooooooooooooooo`00001Booooo`00D_ooool01?l0003oooooooooool0000E
ooooo`;o00002?ooool3o`0002Sooooo00Co0000ooooool0003o00000_ooool2o`0001Gooooo00?o
0000ooooooooool00_l000000ooooooo0000ooooo`02o`0005?ooooo001Cooooo`03o`000?oooooo
000001Oooooo00?o0000ooooooooool00_ooool2o`000003ooooool0003o000000;o00006_ooool2
o`0000?ooooo1?l00002ooooo`Co000000?oooooo`000?ooool06?ooool00ol0003oooooo`000002
ooooo`03o`000?oooooooooo00;o0000Doooool005?ooooo00Ko0000oooooooooooo0000ooooo`00
000Gooooo`Oo00000_ooool4o`0000Sooooo1?l00003ooooo`?o00000oooool00ol0003ooooooooo
o`0;ooooo`04o`000?ooooooooooo`0001Wooooo0_l00003ooooo`04o`000?oooooo0000o`0005Co
oooo001Dooooo`05o`000?ooooooooooo`00000000006_ooool5o`000003ooooool0003o000000So
00007Oooool00ol0003oooooo`00000Kooooo`07o`000?ooooooooooooooool0003oooooo`00001E
ooooo`00E?ooool01_l0003oooooooooool0003ooooo000001Oooooo0ol00003ooooo`03o`000?oo
oooooooo00Oooooo0ol0000Kooooo`04o`000?ooooooooooo`0001Wooooo00?o0000ooooool00000
0oooool00ol0003oooooo`00001Eooooo`00EOooool01?l0003oooooooooool0000Gooooo`;o0000
00Coooooo`000?oooooooooo0_l0000<ooooo`Co00005oooool01?l0003oooooooooool0000Hoooo
o`04o`000?ooooooooooo`0000?ooooo0_l0001Fooooo`00EOooool01?l0003oooooooooool0000F
ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool03Oooool4o`0001Kooooo00?o0000
ooooooooool05Oooool01Ol0003ooooooooooooooooo000000;ooooo0ol0001Fooooo`00E_ooool0
1?l0003oooooooooool0000Dooooo`03o`000?oooooooooo00Oooooo0_l0000Booooo`Co00004Ooo
ool00ol0003oooooooooo`0Kooooo`04o`000?oooooo0000o`0005Oooooo001Fooooo`04o`000?oo
ooooooooo`0001?ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo01Cooooo1?l0000=ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool0
1Oooool01?l0003oooooo`000?l0001Gooooo`00Eoooool01?l0003ooooo00000?l0000Aooooo`;o
00001_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooo000000;o00005_ooool3o`0000So
oooo00?o0000ooooool000005?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooo000005So
oooo001Gooooo`05o`000?oooooooooo00000?l000003_ooool2o`0000Wooooo00Go0000oooooooo
ooooooooo`000004ooooo`03o`000?oooooooooo01Kooooo1?l00004ooooo`03o`000?oooooo0000
01?ooooo00?o0000ooooooooool02?ooool2o`0005Sooooo001Gooooo`05o`000?oooooooooooooo
ool000003Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00;ooooo00?o0000oooo
ooooool07_ooool6o`0000oooooo4Ol0001Iooooo`00F?ooool01Ol0003ooooooooooooooooo0000
00_ooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`04ooooo`;o00007?oooolAo`00
00;ooooo00?o0000ooooooooool02Oooool3o`0005Wooooo001Hooooo`05o`000?oooooooooooooo
ool000002_ooool2o`0001;ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Joooo
o`03o`000?oooooooooo00kooooo00?o0000ooooooooool02Oooool3o`0005[ooooo001Iooooo`05
o`000?ooool00000ooooool000001oooool2o`0000oooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`0Qooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool02Oooool00ol0
003oooooo`00001Kooooo`00FOooool01Ol0003ooooo00000?oooooo000000Kooooo00?o0000oooo
ooooool03oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Oooooo00?o0000oooo
ooooool05_ooool00ol0003oooooooooo`0Iooooo`04o`000?ooooooooooo`0005_ooooo001Joooo
o`05o`000000003oooooooooool000001?ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooo
oooo00?ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0Dooooo`;o00003_ooool0
0ol0003oooooooooo`08ooooo`;o000000?oooooo`000?l00000G?ooool005[ooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`02o`0001;ooooo00?o0000ooooooooool00oooool00ol0
003oooooooooo`09ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool03?ooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00;o0000GOooool005_ooooo00Oo0000oooooooo
ooooooooo`000?oooooo000001_ooooo00?o0000ooooooooool07Oooool00ol0003oooooooooo`0<
ooooo`03o`000?oooooooooo00Sooooo00Ko0000oooooooooooo0000ooooool0001Mooooo`00Fooo
ool00ol0003oooooooooo`02ooooo`;o00006oooool00ol0003oooooooooo`0;ooooo`?o00003ooo
ool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0G?oo
ool005cooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0Booooo`03o`000?oo
oooooooo00Cooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0<ooooo`03o`000?oo
oooooooo00Wooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo05gooooo001Looooo`04o`000?oooooo0000o`0000?ooooo00?o0000ooooooooool04Ooo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo01_ooooo00?o0000ooooool000002Ooo
ool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00;ooooo0_l0001Oooooo`00GOooool2
o`0000Gooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooo
oooo00oooooo0ol00009ooooo`03o`000?oooooo000000Sooooo00?o0000ooooooooool02?ooool2
o`0000Gooooo00?o0000ooooooooool0G_ooool005oooooo00?o0000ooooooooool00oooool2o`00
017ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo
00Gooooo00Co0000oooooooooooo00004_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooo
oooo05oooooo001Pooooo`;o00001Oooool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo
01Wooooo00Co0000oooooooooooo00001Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooo
oooo00Cooooo0_l0001Qooooo`00H_ooool00ol00000000000000003ooooo`03o`000?oooooooooo
01Gooooo00?o0000ooooooooool04oooool01Ol0003ooooooooooooooooo000000Sooooo00?o0000
ooooooooool02Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo063ooooo001Soooo
o`03o`000?ooool0000000?ooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo01Cooooo00Co0000oooooooooooo00001oooool00ol0003oooooooooo`09
ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0HOooool006Cooooo0_l00002oooo
o`80000000?o0000ooooooooool03?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
01Gooooo0_l00004ooooo`03o`000?oooooooooo00_ooooo0_l00007ooooo`;o0000Hoooool006Ko
oooo00?o0000ooooooooool00_ooool2o`0000gooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`0Eooooo`03o`000?oooooo000000;ooooo0_l0000;ooooo`03o`000?oooooooooo00Oo
oooo00?o0000ooooooooool0H_ooool006Oooooo0_l00004ooooo`03o`0000000000000000[ooooo
00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Dooooo`04o`000?ooooooooooooooo`?o
00002?ooool2o`000003ooooool0003o000000?o00000_ooool4o`0006Gooooo001Yooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooo`0000004Oooool00ol0003oooooooooo`0Cooooo`03o`00
0?oooooooooo00?o000000Coooooo`000?l0003o00000oooool2o`0000;ooooo00?o0000oooooooo
ool01_ooool00ol0003oooooooooo`1Uooooo`00J_ooool2o`0000?ooooo00?o0000ooooooooool0
0_ooool00`00003oooooooooo`0;ooooo`03o`000?oooooooooo00oooooo1?l0000@ooooo`03o`00
0?oooooooooo00Gooooo0_l0001Xooooo`00K?ooool01?l0003oooooooooooooool2o`0000?ooooo
00<00000ooooooooool00oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo
0_l00002ooooo`Co00001Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Sooooo
00?o0000ooooooooool01Oooool00ol0003oooooooooo`1Xooooo`00KOooool00ol0003ooooooooo
o`02ooooo`05o`000?ooooooooooooooo`0000001?ooool00ol0003oooooooooo`05ooooo`?o0000
0_ooool2o`0000cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`07ooooo`;o0000
1_ooool2o`0006_ooooo001^ooooo`;o00000oooool00ol0003oooooooooo`03ooooo`8000001Ol0
0002ooooo`;o00004_ooool01Ol0003ooooooooooooooooo000000Wooooo00?o0000ooooooooool0
1Oooool00ol0003oooooooooo`1[ooooo`00L?ooool01Ol0003ooooooooooooooooo000000Kooooo
00?o0000ooooooooool01_ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00[ooooo
00?o0000ooooooooool01?ooool2o`0006kooooo001aooooo`;o00000_ooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool03_ooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00?ooooo0_l0001`ooooo`00Loooool00ol0003oooooooooo`02
o`0000cooooo00?o0000ooooooooool03_ooool01?l0003oooooooooool00008ooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool0L?ooool007Cooooo0_l00002ooooo`03o`000?oooooo
oooo00?ooooo00<00000ooooooooool01?ooool00ol0003oooooooooo`0<ooooo`05o`000?oooooo
ooooooooool000001_ooool2o`0000Cooooo0_l0001cooooo`00M_ooool01?l0003oooooooooool0
0005ooooo`0300000?oooooooooo00?ooooo00?o0000ooooooooool03?ooool01?l0003ooooooooo
ool00006ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0Loooool007Oooooo00Co
0000oooooooooooo00001Oooool00`00003oooooooooo`03ooooo`03o`000?oooooooooo00[ooooo
00?o0000ooooooooool01oooool00ol0003oooooooooo`02ooooo`;o0000M_ooool007Sooooo0_l0
00000ooooooo0000o`000009ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool01_oo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo07Kooooo001jooooo`04o`000?oooooo
ooooo`0000Wooooo00?o0000ooooooooool02?ooool01?l0003oooooooooool00005ooooo`04o`00
0?ooooooooooooooo`;o0000NOooool007_ooooo0_l000000ooooooo0000ooooo`02ooooo`030000
0?oooooooooo00;ooooo00?o0000ooooooooool02?ooool00ol0003oooooo`000005ooooo`05o`00
0?ooooooooooooooool00000Noooool007gooooo00?o0000ooooool000000oooool01@00003ooooo
oooooooooooo000000Wooooo00?o0000ooooool000001?ooool2o`0000;ooooo0_l0001looooo`00
O_ooool00ol0003oooooo`000003ooooo`0500000?ooooooooooooooool000002?ooool00ol0003o
ooooooooo`03ooooo`05o`000?ooooooooooooooool00000O_ooool007oooooo1?l00005ooooo`03
o`000?oooooooooo00Gooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02o`0007oo
oooo0021ooooo`03o`000?oooooo000000Gooooo00?o0000ooooooooool01?ooool2o`0000?ooooo
00Co0000oooooooooooo0000POooool008;ooooo0ol000001Oooool00000oooooooooooo000000Go
oooo00?o0000ooooool000000_ooool01?l0003oooooo`000?l00022ooooo`00Q?ooool2o`000004
ooooo`00003oooooo`0000Gooooo0_l000000ooooooo0000o`000002o`0008Cooooo0025ooooo`?o
000000<00000ooooool000001?ooool01Ol0003oooooo`000?oooooo000008Kooooo0027ooooo`;o
000000?oooooo`000?ooool00_ooool00ol0003oooooo`000002o`0008Oooooo0028ooooo`;o0000
00@00000o`000?oooooooooo0ol00029ooooo`00ROooool3o`000004ooooool0003o0000o`0008[o
oooo002;ooooo`03o`000?oooooo000008cooooo002<ooooo`03o`000?oooooooooo08_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo0000\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-5.00005*^-6, -5.00005*^-6, \
0.00355875, 0.00355875}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.0025 w
[ .01 .012 ] 0 setdash
.44775 .57999 m
.58364 .44545 L
s
.44775 .57999 m
.35769 .4228 L
s
.44775 .57999 m
.60159 .5619 L
s
.44775 .57999 m
.46794 .42283 L
s
.44775 .57999 m
.32577 .53944 L
s
.46544 .68902 m
.44775 .57999 L
s
.34815 .65113 m
.44775 .57999 L
s
.58904 .66657 m
.44775 .57999 L
s
.46794 .42283 m
.5 .27523 L
s
.46794 .42283 m
.58364 .44545 L
s
.46794 .42283 m
.35769 .4228 L
s
.58364 .44545 m
.74166 .52177 L
s
.58364 .44545 m
.5 .27523 L
s
.58364 .44545 m
.64158 .37749 L
s
.60159 .5619 m
.58364 .44545 L
s
.60159 .5619 m
.74166 .52177 L
s
.58904 .66657 m
.60159 .5619 L
s
.35769 .4228 m
.5 .27523 L
s
.35769 .4228 m
.23786 .47638 L
s
.35769 .4228 m
.35163 .34488 L
s
.32577 .53944 m
.35769 .4228 L
s
.32577 .53944 m
.23786 .47638 L
s
.34815 .65113 m
.32577 .53944 L
s
.58904 .66657 m
.74166 .52177 L
s
.58904 .66657 m
.46544 .68902 L
s
.6535 .66048 m
.58904 .66657 L
s
.5 .75807 m
.58904 .66657 L
s
.5 .27523 m
.66091 .33986 L
s
.64158 .37749 m
.5 .27523 L
s
.35163 .34488 m
.5 .27523 L
s
.0035 w
[ ] 0 setdash
.5 .27523 m
.53891 .28721 L
s
.5 .27523 m
.39764 .30851 L
s
.0025 w
[ .01 .012 ] 0 setdash
.64158 .37749 m
.66091 .33986 L
s
.64158 .37749 m
.74166 .52177 L
s
.34815 .65113 m
.46544 .68902 L
s
.5 .75807 m
.46544 .68902 L
s
.0035 w
[ ] 0 setdash
.74166 .52177 m
.70295 .45406 L
s
.74166 .52177 m
.66091 .33986 L
s
.6535 .66048 m
.74166 .52177 L
s
.67321 .59397 m
.74166 .52177 L
s
.0025 w
[ .01 .012 ] 0 setdash
.34815 .65113 m
.23786 .47638 L
s
.0035 w
[ ] 0 setdash
.33849 .63976 m
.34815 .65113 L
s
.5 .75807 m
.34815 .65113 L
s
.35163 .34488 m
.39764 .30851 L
s
.35163 .34488 m
.23786 .47638 L
s
.5 .75807 m
.6535 .66048 L
s
.67321 .59397 m
.6535 .66048 L
s
.66091 .33986 m
.57329 .3878 L
s
.66091 .33986 m
.70295 .45406 L
s
.53891 .28721 m
.66091 .33986 L
s
.23786 .47638 m
.39764 .30851 L
s
.23786 .47638 m
.3694 .42043 L
s
.33849 .63976 m
.23786 .47638 L
s
.38944 .5721 m
.23786 .47638 L
s
.53891 .28721 m
.57329 .3878 L
s
.39764 .30851 m
.53891 .28721 L
s
.5 .75807 m
.33849 .63976 L
s
.38944 .5721 m
.33849 .63976 L
s
.38944 .5721 m
.5 .75807 L
s
.54266 .6027 m
.5 .75807 L
s
.67321 .59397 m
.5 .75807 L
s
.39764 .30851 m
.57329 .3878 L
s
.3694 .42043 m
.39764 .30851 L
s
.70295 .45406 m
.57329 .3878 L
s
.67321 .59397 m
.70295 .45406 L
s
.67321 .59397 m
.57329 .3878 L
s
.67321 .59397 m
.54266 .6027 L
s
.3694 .42043 m
.57329 .3878 L
s
.38944 .5721 m
.3694 .42043 L
s
.38944 .5721 m
.57329 .3878 L
s
.54266 .6027 m
.38944 .5721 L
s
.54266 .6027 m
.57329 .3878 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.1,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016R000`400?l00000o`00003oo`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00RP3oool5000008/0oooo00270?ooo`@0000000Co
00000000003oool0oooo100000270?ooo`00Q03oool3000000@0oooo00?o00000?ooo`0000000`00
00000`3oool0000000000002000008@0oooo00210?ooo`<0000000<0oooo000000000000103oool0
1?l00000oooo0?ooo`0000020?ooo`030000003oool0oooo00D00000P@3oool007d0oooo10000003
0?ooo`050000003oool0oooo0?ooo`0000000P3oool00ol00000oooo00000006000000<0oooo1000
001o0?ooo`00NP3oool3000000<0oooo0P0000040?ooo`L000001P3oool2000000<0oooo0P000000
103oool0000000000000001l0?ooo`00M`3oool3000000@0oooo2@0000080?ooo`030000003oool0
oooo00<0oooo00H000000?ooo`3oool000000?ooo`0000030?ooo`800000NP3oool007@0oooo0`00
00020?ooo`L000003`3oool00`000000oooo0?ooo`040?ooo`030000003oool0000000@0oooo1@00
001h0?ooo`00L@3oool8000000030?ooo`000000000000P0oooo00<000000?ooo`3oool00`3oool0
0ol00000oooo0?ooo`030?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0103oool0
10000000oooo00000000001f0?ooo`00KP3oool4000000L0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`040?ooo`03o`00003oool0oooo00<0oooo00<000000?ooo`3oool01@3oool2
000000T0oooo1000001c0?ooo`00K@3oool010000000oooo0000003oool200000080oooo0P00000;
0?ooo`030000003oool0oooo00D0oooo00?o00000?ooo`3oool0303oool2000000/0oooo0`00001a
0?ooo`00K03oool010000000oooo0000000000030?ooo`<00000503oool00ol00000oooo0?ooo`0=
0?ooo`8000003@3oool2000006l0oooo001Z0?ooo`80000000<0oooo000000000000103oool00`00
0000oooo0?ooo`02000001X0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`020000
00`0oooo0`00001/0?ooo`00J@3oool01@000000oooo0?ooo`000000oooo00<000001`3oool20000
00H0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool0303oool2000006X0oooo001X0?ooo`050000003oool0oooo0000
003oool00P00000;0?ooo`<000000P3oool00`000000oooo0?ooo`070?ooo`03o`00003oool0oooo
00L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
00/0oooo1000001X0?ooo`00I`3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo
00`0oooo0P00000:0?ooo`03o`00003oool0oooo00l0oooo00<000000?ooo`3oool04`3oool30000
06H0oooo001U0?ooo`8000000P3oool200000080oooo00<000000?ooo`3oool03`3oool2000000L0
oooo00?o00000?ooo`3oool0403oool00`000000oooo0?ooo`040?ooo`800000403oool3000006<0
oooo001T0?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00<0oooo0P0000050?ooo`03o`00003oool0oooo00X0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0100oooo0P00001Q0?ooo`00
H`3oool3000000030?ooo`000000oooo00@0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`060?ooo`<000003`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool0403oool200000600oooo001R0?ooo`8000000P3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool2000000h0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`0F0?ooo`80000000<0oooo0000003oool0G`3o
ool00680oooo00@000000?ooo`3oool000001P3oool00`000000oooo0?ooo`0I0?ooo`800000303o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00L0oooo0`00000:0?ooo`800000103o
ool00`000000oooo0?ooo`1M0?ooo`00H@3oool2000000030?ooo`000000oooo00H0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`0=0?ooo`03o`00003oool0oooo008000004@3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0000001O0?ooo`00H03oool010000000oooo0?ooo`0000080?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool03@3oool00ol00000oooo0?ooo`020?ooo`<000003`3oool0
0`000000oooo0?ooo`0@0?ooo`8000001@3oool010000000oooo00000000001N0?ooo`00G`3oool0
0`000000oooo0?ooo`02000000P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0>
0?ooo`03o`00003oool0oooo00D0oooo0P0000060?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool02`3oool2000000030?ooo`000000000000H0oooo00D000000?ooo`3oool0oooo0000
001N0?ooo`00GP3oool010000000oooo0?ooo`0000090?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool06@3oool2000000D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`0<0?ooo`800000303oool00`000000oooo0?ooo`1L0?ooo`00G@3oool010000000oooo0?ooo`00
000:0?ooo`030000003oool0oooo02D0oooo0`0000030?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool02@3oool200000080oooo00<000000?ooo`3oool02@3oool2000005d0oooo001L
0?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo0200oooo0P0000070?ooo`030000003oool0oooo00L0oooo0P00
000:0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0F`3oool005`0oooo00<00000
0?ooo`000000103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool04@3oool00ol00000oooo0?ooo`0?0?ooo`8000001@3oool00`000000oooo0?ooo`05
0?ooo`800000203oool200000080oooo00<000000?ooo`3oool0103oool2000005`0oooo001K0?oo
o`030000003oool0000000D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo0180oooo00?o00000?ooo`3oool04@3oool2000000@0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`0:0?ooo`800000203oool00`000000oooo0?ooo`1J0?oo
o`00FP3oool00`000000oooo000000060?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool06@3oool00ol00000oooo0?ooo`0A0?ooo`030000003oool000000080000000<0oooo0000003o
ool00P3oool2000000h0oooo00<000000?ooo`3oool01P3oool2000005/0oooo001I0?ooo`030000
003oool0000000h0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0X0?ooo`030000
003oool0oooo0080oooo0P0000000`3oool000000000000@0?ooo`030000003oool0oooo00H0oooo
0P00001K0?ooo`00F03oool00`000000oooo0000000?0?ooo`050000003oool0oooo0?ooo`000000
;03oool00`000000oooo0?ooo`05000000h0oooo00D000000?ooo`3oool0oooo000000080?ooo`80
0000FP3oool005L0oooo00<000000?ooo`0000002@3oool00`000000oooo0?ooo`030?ooo`050000
003oool0oooo0?ooo`000000:P3oool600000080oooo0P0000000`3oool000000000000<0?ooo`03
0000003oool0oooo00X0oooo0P00001J0?ooo`00EP3oool00`000000oooo0000000:0?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool06@3oool00ol00000oooo0?ooo`0:0?ooo`H00000
1`3oool010000000oooo0000000000020?ooo`8000002@3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0000005T0oooo001E0?ooo`040000003oool0oooo000000/0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`0I0?ooo`03o`00003oool0oooo00D0oooo1@00000;0?ooo`80
00000P3oool2000000@0oooo0P0000070?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool01@3oool2000005T0oooo001E0?ooo`030000003oool0000000`0oooo00<000000?ooo`3oool0
0P3oool2000001T0oooo00?o00000?ooo`3oool01P00000@0?ooo`040000003oool0oooo00000080
oooo00<000000?ooo`3oool00`3oool2000000d0oooo00<000000?ooo`3oool0103oool2000005T0
oooo001D0?ooo`030000003oool000000140oooo0P00000G0?ooo`H000005@3oool01@000000oooo
0000003oool000000080oooo00<000000?ooo`3oool01@3oool00`000000oooo0000000;0?ooo`03
0000003oool0oooo00@0oooo0P00001H0?ooo`00D`3oool00`000000oooo0000000B0?ooo`030000
003oool0oooo0100oooo1P00000J0?ooo`060000003oool0oooo0000003oool000000`3oool00`00
0000oooo0?ooo`050?ooo`8000004P3oool2000005P0oooo001B0?ooo`030000003oool0000001<0
oooo00<000000?ooo`3oool02P3oool6000001l0oooo00<000000?ooo`3oool00`3oool01@000000
oooo0?ooo`3oool0000000L0oooo00@000000?ooo`0000000000403oool00`000000oooo0000001G
0?ooo`00D@3oool00`000000oooo0000000@0?ooo`050000003oool000000?ooo`0000001`3oool5
000000l0oooo00?o00000?ooo`3oool04P3oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool0203oool2000000T0oooo00<000000?ooo`3oool00`3oool2
000005L0oooo001@0?ooo`030000003oool000000140oooo0P000000103oool000000?ooo`3oool6
000001@0oooo00?o00000?ooo`3oool04@3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool02P3oool2000000L0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0000001F0?ooo`00C`3oool00`000000oooo0000000A0?ooo`80000000<0oooo0000
000000000P0000001?l00000oooo0?ooo`3oool3o`0000<0oooo1?l000020?ooo`Co00000P3oool6
o`000140oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`030?ooo`040000003oool0
oooo000000X0oooo0P0000060?ooo`030000003oool0oooo0080oooo00<000000?ooo`000000EP3o
ool004l0oooo0P00000@0?ooo`D0000000<0oooo0000003oool06P3oool01?l00000oooo0?ooool0
000?0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`000000103oool010000000oooo0?oo
o`00000<0?ooo`8000002P3oool00`000000oooo0000001E0?ooo`00CP3oool200000140oooo0P00
00001@3oool00000o`00003oool0000001/0oooo00?o00000?ooo`3oool00`3oool4o`0000P0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`8000003`3oool2000000P0oooo
00<000000?ooo`000000E@3oool004d0oooo0P00000>0?ooo`@000000P3oool01@000000oooo0?oo
o`3oool0000002L0oooo1?l000000`3oool000000?ooo`090?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool0403oool200000080oooo00<000000?ooo`3oool00P3oool00`000000oooo
0000001D0?ooo`00C03oool2000000h0oooo0P00000:0?ooo`030000003oool0oooo02P0oooo00<0
00000?ooool000000ol000060?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool0
4@3oool010000000oooo0?ooo`0000030?ooo`030000003oool0000005@0oooo001;0?ooo`800000
2`3oool4000000X0oooo00?o00000?ooo`0000006@3oool00ol00000oooo0?ooo`0=0?ooo`030000
003oool0oooo00H0oooo0ol000001@3oool000000?ooo`3oool000000080oooo00@000000?ooo`3o
ool00000503oool2000000070?ooo`000000oooo0?ooo`000000oooo0000001D0?ooo`00BP3oool2
000000/0oooo0P00000>0?ooo`03o`0000000000oooo01P0oooo00?o00000?ooo`3oool0303oool0
0`000000oooo0?ooo`0:0?ooo`03o`0000000000oooo00;o000000<000000?ooo`0000000P3oool0
0`000000oooo0?ooo`0D0?ooo`8000000`3oool00`000000oooo0000001C0?ooo`00B@3oool20000
00T0oooo0`00000;0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool05`3oool00ol0
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool00P3oool20000
00<0oooo00<000000?ooo`3oool05@3oool2000000040?ooo`000000oooo000005<0oooo00180?oo
o`800000203oool2000000h0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0G0?oo
o`03o`00003oool0oooo00X0oooo00<000000?ooo`3oool0303oool02@000000oooo0?ooo`3ooooo
00000?ooo`000000oooo000000020?ooo`030000003oool0oooo01H0oooo0`0000020?ooo`030000
003oool0oooo0500oooo00180?ooo`030000003oool0oooo00D0oooo0P00000@0?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`0=0?ooo`040000003o
ool0ooooo`000080oooo00<000000?ooo`3oool00P3oool2000001L0oooo00H000000?ooo`3oool0
00000?ooo`00001B0?ooo`00A`3oool00`000000oooo0?ooo`030?ooo`<00000603oool00`00003o
00000?ooo`0R0?ooo`030000003oool0oooo00h0oooo00<000000?ooool000002@3oool2000001L0
oooo00<000000?ooo`0000000P3oool00`000000oooo0?ooo`1?0?ooo`00AP3oool00`000000oooo
0?ooo`020?ooo`800000703oool00`00003o00000?ooo`0F0?ooo`03o`00003oool0oooo00L0oooo
00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0:0?ooo`800000603oool2000000030?oo
o`000000oooo0500oooo00150?ooo`030000003oool0oooo00@000007@3oool00`000000ooooo`00
000F0?ooo`03o`00003oool0oooo00H0oooo00<000000?ooo`3oool0403oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo00@0oooo00@000000?ooo`3oool0oooo0P00000C0?ooo`030000
003oool000000080oooo00<000000?ooo`3oool0CP3oool004@0oooo00<000000?ooo`0000000P00
000H0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool05@3oool00ol00000oooo0?oo
o`060?ooo`030000003oool0oooo0100oooo00?o00000000003oool0103oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0403oool2000000040?ooo`00
0000oooo00000500oooo00130?ooo`@000006P3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo01D0oooo00?o00000?ooo`3oool01@3oool00`000000oooo0?ooo`0@0?ooo`03o`00003o
ool0000000H0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0E0?ooo`040000003o
ool000000?ooo`800000D03oool00480oooo0P00000L0?ooo`030000003oool0oooo00H0oooo00D0
00000?ooo`3oool0ooooo`00000J0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo0`00000=0?ooo`030000
003oool0oooo0080000000<0oooo0000003oool0CP3oool00480oooo0`00000T0?ooo`050000003o
ool0oooo0?ooool000006@3oool00`000000oooo0?ooo`0@0?ooo`04o`00003oool0oooo000000l0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0080
oooo0P00001?0?ooo`00@`3oool400000280oooo00<000000?ooo`3oool00P3oool00ol00000oooo
0?ooo`0@0?ooo`03o`00003oool0oooo0080oooo00<000000?ooo`3oool0403oool01Ol00000oooo
0?ooo`3oool000000100oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`000000CP3oool004@0oooo00<000000?ooo`000000
0P00000F0?ooo`030000003oool0oooo00P0oooo00D000000?ooo`3oool0ooooo`00000B0?ooo`05
o`00003oool0oooo0?ooo`0000004P3oool00ol00000oooo0?ooo`020?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool00`3oool3000004h0oooo00140?ooo`060000003oool0oooo0000
003oool000005@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01<0oooo00Go0000
0?ooo`3oool0oooo0000000H0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103o
ool3000004d0oooo00150?ooo`030000003oool0oooo0080oooo0P00000B0?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool04`3oool01?l00000oooo0?ooo`00000I0?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0=0?ooo`<0000000<0
oooo0000003oool01P3oool2000004d0oooo00150?ooo`030000003oool0oooo0080oooo0`00000A
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool00`3oool00ol00000oooo0?ooo`0?
0?ooo`030000003oool0oooo0100oooo00?o00000?ooo`3oool0103oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool03`3oool2000000P0oooo0P00001<
0?ooo`00AP3oool00`000000oooo0?ooo`030?ooo`<000006`3oool00`000000oooo0?ooo`030?oo
o`03o`00003oool0oooo00h0oooo00<000000?ooo`3oool0403oool00ol00000oooo0?ooo`050?oo
o`030000003oool0oooo0140oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`070?oo
o`800000C03oool004L0oooo00<000000?ooo`3oool01@3oool2000001T0oooo00<000000?ooo`3o
ool0103oool00ol00000oooo0?ooo`0<0?ooo`030000003oool0oooo0100oooo00?o00000?ooo`3o
ool01P3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool00P0000050?ooo`<00000B`3oool004L0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0000000;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool04P3oool00`00003o0000
0?ooo`0J0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`0>0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool2000004/0oooo
00180?ooo`030000003oool0oooo00D0oooo00@000000?ooo`00000000002@3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo0100oooo00<000000?ooool00000403oool00ol00000oooo
0?ooo`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0B@3oool004T0oooo00<0
00000?ooo`3oool01@3oool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool01@3oool00ol00000oooo0?ooo`070?ooo`040000003oool0ooooo`0000l0
oooo00?o00000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`050?ooo`<000000P3oool00`000000
oooo0?ooo`180?ooo`00B@3oool00`000000oooo0?ooo`090?ooo`8000001P3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00D0oooo00?o00000?ooo`3oool01P3oool00`000000oooo
0?ooo`0@0?ooo`03o`00003oool0oooo00X0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02@3oool00`000000oooo
0000001:0?ooo`00BP3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo008000004P3o
ool00`000000oooo0?ooo`060?ooo`03o`00003oool0oooo00@0oooo00<000000?ooo`3oool07@3o
ool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3o
ool3000004T0oooo001;0?ooo`030000003oool0oooo00L0oooo00D000000?ooo`3oool0oooo0000
000A0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool00P3oool00ol00000oooo0?oo
o`0:0?ooo`03o`00003oool0oooo00`0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00P0oooo0P0000000`3oool00000000000190?ooo`00B`3oool0
0`000000oooo0?ooo`080?ooo`040000003oool0oooo0?ooo`<000003P3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00<0oooo00?o00000?ooo`3oool02@3oool00ol00000oooo0?oo
o`0=0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`040?ooo`800000103oool2000004X0oooo001<0?ooo`030000003oool0oooo00X0oooo00@00000
0?ooo`3oool000003P3oool00`000000oooo0?ooo`080?ooo`03o`00003oool0000000H0oooo00?o
00000?ooo`3oool0203oool00ol00000oooo0?ooo`0>0?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0080oooo0P00
00050?ooo`800000B`3oool004`0oooo0P00000<0?ooo`80000000<0oooo0000000000003@3oool0
0`000000oooo0?ooo`070?ooo`03o`0000000000oooo00H0oooo00?o00000?ooo`3oool06@3oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0203oool0
10000000oooo0000000000090?ooo`800000B`3oool004d0oooo0P00000<0?ooo`05o`00003oool0
oooo0?ooo`000000303oool00`000000oooo0?ooo`070?ooo`0300000?l00000oooo0280oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00L0oooo0P00
00090?ooo`<00000C03oool004h0oooo00<000000?ooo`3oool02P3oool00ol00000ooooo`000002
o`00008000002P3oool00`000000oooo0?ooo`060?ooo`030000003ooooo00000100oooo00?o0000
0?ooo`3oool0403oool00`000000oooo0?ooo`0H0?ooo`040000003oool0oooo0?ooo`@000000P3o
ool00`000000oooo0?ooo`070?ooo`<00000C@3oool004h0oooo00<000000?ooo`3oool03`3oool0
1?l00000oooo0000000000080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0403o
ool00ol00000oooo0?ooo`0@0?ooo`030000003oool0oooo01T0oooo0P0000080?ooo`030000003o
ool0oooo00H0oooo0P0000000`3oool000000?ooo`1<0?ooo`00C`3oool00`000000oooo0?ooo`0A
0?ooo`03o`000000003o000000H0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`08
0?ooo`03o`00003oool0oooo00D0oooo00?o00000?ooo`3oool04@3oool00`000000oooo0?ooo`0G
0?ooo`80000000<0oooo0000003oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0
000004h0oooo001@0?ooo`030000003oool0oooo0180oooo0P0000050?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool0103oool00ol00000oooo0?ooo`020?ooo`03o`00003oool0oooo
01T0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`050?ooo`8000001@3oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`0000000P3oool00`00
0000oooo0?ooo`1<0?ooo`00D03oool2000000X0oooo00<000000?ooo`3oool0203oool00`000000
ooooo`000002o`0000030000003oool0oooo0080oooo00<000000?ooo`3oool01@3oool00ol00000
oooo0?ooo`020?ooo`03o`00003oool0oooo00<0oooo00?o00000?ooo`3oool04`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00<0oooo0P0000080?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool00`3oool00`000000oooo000000020?ooo`030000003oool0oooo04d0
oooo001A0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool200000080oooo
00Go00000000003oool0oooo000000090?ooo`03o`00003oool0oooo00H0oooo00?o00000?ooo`3o
ool0503oool00`000000oooo0?ooo`0;0?ooo`04o`00000000000000000000`0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`020?ooo`030000003oool000000080oooo00<000000?oo
o`3oool0CP3oool00540oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0;0?ooo`80
000000@0oooo0000003oool000000_l0000@0?ooo`03o`00003oool0oooo01D0oooo00<000000?oo
o`3oool01@3oool4o`0001<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?oo
o`050000003oool0oooo0?ooo`000000D03oool00580oooo0P00000H0?ooo`<000000`3oool00ol0
0000oooo0?ooo`0S0?ooo`;o000000<000000?ooool000000ol000080?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool00`3oool01P000000oooo0?ooo`000000oooo000000<0oooo00<0
00000?ooo`3oool0C`3oool005<0oooo00<000000?ooo`3oool05`3oool3000000D0oooo0_l00005
0?ooo`03o`00003ooooo00000140oooo1?l000020?ooo`;o000000<0oooo0000003oool03@3oool0
0`000000oooo0?ooo`0?0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0000
00030?ooo`030000003oool0oooo0500oooo001C0?ooo`800000603oool00`000000oooo0?ooo`05
00000080oooo00?o00000?ooo`3oool00P3oool01?l00000ooooo`000?l000050?ooo`;o00000`3o
ool3o`0000`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0?0?ooo`090000003o
ool0oooo0?ooo`000000oooo0000003oool0000000@0oooo00<000000?ooo`3oool0D03oool005@0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0000000H0
oooo1@0000000`3ooooo0000o`000004o`000080oooo0_l0000D0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool0403oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool0D@3oool005D0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`0;0?ooo`040000003oool0oooo000000/0oooo1@0000000ol00000oooo0?ooo`0G0?oo
o`030000003oool0oooo01l0oooo00H000000?ooo`3oool000000?ooo`0000040?ooo`030000003o
ool0oooo0580oooo001E0?ooo`8000001`3oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool02@3oool01?l00000oooo0?ooo`3oool5000001D0oooo00<0
00000?ooo`3oool0803oool4000000D0oooo00<000000?ooo`3oool0DP3oool005H0oooo00<00000
0?ooo`3oool04@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00L0oooo00?o0000
0?ooo`3oool01`3oool400000140oooo00<000000?ooo`3oool0803oool3000000D0oooo00<00000
0?ooo`3oool0D`3oool005H0oooo0P00000A0?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool0103oool2o`0000D0oooo00?o00000?ooo`3oool00P3oool2o`0000<0oooo1@00000<0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool7000000D0oooo00<000000?oo
o`3oool0E03oool005L0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo0080oooo00?o00000?ooo`3oool01@3oool00ol00000oooo0?ooo`040?ooo`03
o`00003oool0oooo00D0oooo1@0000060?ooo`030000003oool0oooo00d0oooo00<000000?ooo`00
0000300000040?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool0E03oool005P0oooo
00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo
00D000000?ooo`3oool0ooooo`0000080?ooo`03o`00003oool0oooo0140oooo1@0000000`3oool0
00000?ooo`040?ooo``000003`3oool200000080oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`1E0?ooo`00F03oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`03o`00003oool0oooo00L0oooo
0_l0000=0?ooo`L000006P3oool200000080oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`1E0?ooo`00F@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool02@3oool00ol0000000000?ooo`0E0?ooo`03o`00003oool0oooo00/0oooo00<0
00000?ooo`3oool0703oool2000000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`1F0?ooo`00FP3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00T0oooo00?o0000
0?ooo`0000005`3oool00ol00000oooo0?ooo`0:0?ooo`030000003oool0oooo01`0oooo00<00000
0?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000005T0oooo001J0?ooo`8000002@3oool0
0`000000oooo0?ooo`080?ooo`05o`00003oool0oooo0?ooo`0000002P3oool00ol00000oooo0?oo
o`0<0?ooo`03o`00003oool0oooo00H0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0000000@0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`1G0?ooo`00F`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool0203oool00ol00000oooo0?ooo`0=0?ooo`03o`00003oool0oooo00D0oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`090?ooo`030000003oool0000000D0oooo00D00000
0?ooo`3oool0oooo0000001J0?ooo`00G03oool01@000000oooo0?ooo`3oool000000080oooo00<0
00000?ooo`3oool01`3oool2o`0000H0oooo00<000000?ooo`3oool01`3oool00ol00000oooo0?oo
o`0>0?ooo`03o`00003oool0oooo00@0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`090?ooo`030000003oool0000000H0oooo00@000000?ooo`3oool00000F`3oool005`0oooo0P00
00020?ooo`030000003oool0000000P0oooo0_l000080?ooo`030000003oool0oooo00L0oooo00?o
00000?ooo`3oool0503oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00X0oooo00<0
00000?ooo`3oool0103oool01@000000oooo0?ooo`3oool0000005/0oooo001M0?ooo`060000003o
ool0oooo0000003oool000004`3oool00`000000oooo0?ooo`0J0?ooo`;o000000<0oooo0000003o
ool0603oool00`000000oooo000000070?ooo`040000003oool0oooo000005`0oooo001M0?ooo`80
00000P3oool00`000000oooo0?ooo`040?ooo`;o00003@3oool00`000000oooo0?ooo`0K0?ooo`03
o`0000000000oooo01L0oooo00<000000?ooo`000000203oool00`000000oooo0000001M0?ooo`00
GP3oool00`000000oooo000000060?ooo`03o`00003oool0oooo00d0oooo00<000000?ooo`3oool0
1P3oool00ol00000oooo0?ooo`0C0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo000000080?ooo`040000003oool0oooo000005d0oooo001O0?ooo`800000
1@3oool00ol00000oooo0?ooo`0?0?ooo`030000003oool0oooo00D0oooo00?o00000?ooo`3oool0
4P3oool00`000000oooo0?ooo`02o`0000`0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`070?ooo`030000003oool0000005h0oooo001O0?ooo`<000005P3oool00`000000oooo0?oo
o`050?ooo`03o`00003oool0oooo0180oooo00<000000?ooo`3oool00P3oool00ol00000oooo0?oo
o`090?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool00`000000oooo0000
001N0?ooo`00H03oool3000000;o0000503oool00`000000oooo0?ooo`040?ooo`03o`00003oool0
oooo0180oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`020?ooo`<000002P3oool0
0`000000oooo0000001O0?ooo`00H@3oool4000001D0oooo00<000000?ooo`3oool0603oool00`00
0000oooo0?ooo`050?ooo`;o00002`3oool00`000000oooo0000000;0?ooo`800000H03oool006<0
oooo0`00000D0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0203oool00ol00000
oooo0?ooo`070?ooo`030000003oool0000000`0oooo0P00001P0?ooo`00I03oool00`000000oooo
0000000300000140oooo00<000000?ooo`3oool00`3oool00ol00000oooo0?ooo`0@0?ooo`030000
003oool0oooo00T0oooo00?o00000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo00X0oooo0P00001Q0?ooo`00I@3oool4000000030?ooo`000000oooo00l0oooo00<0
00000?ooo`3oool00`3oool00ol00000oooo0?ooo`0@0?ooo`030000003oool0oooo00`0oooo00Oo
00000?ooo`000000oooo0000003oool0000000X0oooo1000001R0?ooo`00I`3oool00`000000oooo
000000030?ooo`<00000303oool00`000000oooo0?ooo`020?ooo`03o`00003oool0oooo00l0oooo
00<000000?ooo`3oool03P3oool01_l0000000000000003oool000000?ooo`8000000P3oool40000
00<0oooo00<000000?ooo`3oool0HP3oool006P0oooo0`0000050?ooo`030000003oool0oooo00X0
oooo00D000000?ooo`3oool0ooooo`00000A0?ooo`030000003oool0oooo00`0oooo10000000103o
ool000000000000000090?ooo`800000I@3oool006X0oooo0`0000060?ooo`<000001`3oool00`00
0000oooo0?ooo`0C0?ooo`030000003oool0oooo00H0oooo100000030?ooo`040000003oool0oooo
000000/0oooo00<000000?ooo`3oool0I@3oool006/0oooo00<000000?ooo`000000203oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool00P3oool20000
00T0oooo0`00000:0?ooo`800000J03oool006`0oooo0`00000:0?ooo`<000000P3oool01@000000
oooo0?ooo`3ooooo000000l0oooo0P0000020?ooo`8000002P3oool2000000/0oooo00<000000?oo
o`3oool0J03oool006h0oooo0`00000;0?ooo`040000003oool0oooo00000080oooo00?o00000?oo
o`3oool01`3oool200000080oooo0`00000?0?ooo`030000003oool0oooo00P0oooo0P00001[0?oo
o`00K`3oool3000000d0oooo0P0000000`3ooooo00000?ooo`020?ooo`8000000P3oool2000000H0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`070?ooo`800000K@3oool00740oooo
0P00000=0?ooo`<0000000<0oooo000000000000303oool00`000000oooo0?ooo`0:0?ooo`800000
2@3oool00`000000oooo0?ooo`1]0?ooo`00LP3oool3000000`0oooo0P00000>0?ooo`030000003o
ool0oooo00X0oooo0P0000080?ooo`800000L03oool007<0oooo0`00000;0?ooo`030000003oool0
000000d0oooo00<000000?ooo`3oool02@3oool2000000P0oooo00<000000?ooo`3oool0L03oool0
07D0oooo0P00000;0?ooo`030000003oool0000000`0oooo00<000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`050?ooo`800000L`3oool007H0oooo0P00000:0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool0203oool2000000L0oooo00<000000?ooo`3oool0L`3oool007P0oooo
0P0000090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool01`3oool2000000H0oooo
0P00001f0?ooo`00N@3oool2000000T0oooo0P00000:0?ooo`030000003oool0oooo00H0oooo0P00
00060?ooo`030000003oool0oooo07H0oooo001j0?ooo`800000203oool2000000X0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`030?ooo`800000N@3oool007`0oooo0P0000070?oo
o`800000203oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0N@3oool007d0oooo0P0000060?ooo`800000203oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo0080oooo0P00001l0?ooo`00OP3oool2000000H0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
O03oool00800oooo0P0000040?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool00`3o
ool010000000oooo0?ooo`3oool2000007l0oooo00210?ooo`800000103oool2000000D0oooo00<0
00000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool000000840oooo00230?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`3oool200000080oooo
0P0000220?ooo`00Q03oool200000080oooo0P0000040?ooo`030000003oool0oooo0080000000<0
oooo000000000000Q03oool008D0oooo0P0000020?ooo`050000003oool0oooo0?ooo`0000000P3o
ool2000000030?ooo`000000oooo08D0oooo00270?ooo`030000003oool0000000<0oooo00<00000
0?ooo`3oool00`0000270?ooo`00R03oool4000000030?ooo`000000oooo00800000R@3oool008X0
oooo0P000000103oool0000000000000002:0?ooo`00R`3oool3000008`0oooo002<0?ooo`030000
003oool0oooo08/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0
oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0
oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0
oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0
oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0
oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0
oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0
oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0
oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0
oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0
oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0
oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0
oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0
oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo0000\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-5.00005*^-6, -5.00005*^-6, \
0.00355875, 0.00355875}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.0025 w
[ .01 .012 ] 0 setdash
.486 .58183 m
.60739 .43861 L
s
.486 .58183 m
.37684 .43254 L
s
.486 .58183 m
.63075 .55515 L
s
.486 .58183 m
.4914 .42433 L
s
.486 .58183 m
.34973 .54914 L
s
.49073 .68996 m
.486 .58183 L
s
.36872 .65777 m
.486 .58183 L
s
.6144 .66191 m
.486 .58183 L
s
.4914 .42433 m
.5 .27523 L
s
.4914 .42433 m
.60739 .43861 L
s
.4914 .42433 m
.37684 .43254 L
s
.60739 .43861 m
.75546 .50603 L
s
.60739 .43861 m
.5 .27523 L
s
.60739 .43861 m
.64786 .36592 L
s
.63075 .55515 m
.60739 .43861 L
s
.37684 .43254 m
.5 .27523 L
s
.37684 .43254 m
.23889 .49384 L
s
.37684 .43254 m
.35026 .35716 L
s
.34973 .54914 m
.37684 .43254 L
s
.63075 .55515 m
.75546 .50603 L
s
.6144 .66191 m
.63075 .55515 L
s
.34973 .54914 m
.23889 .49384 L
s
.36872 .65777 m
.34973 .54914 L
s
.64786 .36592 m
.5 .27523 L
s
.35026 .35716 m
.5 .27523 L
s
.0035 w
[ ] 0 setdash
.5 .27523 m
.64397 .32698 L
s
.5 .27523 m
.5105 .28499 L
s
.5 .27523 m
.37177 .31851 L
s
.0025 w
[ .01 .012 ] 0 setdash
.36872 .65777 m
.49073 .68996 L
s
.6144 .66191 m
.49073 .68996 L
s
.5 .75807 m
.49073 .68996 L
s
.6144 .66191 m
.75546 .50603 L
s
.66054 .65315 m
.6144 .66191 L
s
.5 .75807 m
.6144 .66191 L
s
.64786 .36592 m
.64397 .32698 L
s
.64786 .36592 m
.75546 .50603 L
s
.36872 .65777 m
.23889 .49384 L
s
.33724 .64758 m
.36872 .65777 L
s
.5 .75807 m
.36872 .65777 L
s
.35026 .35716 m
.37177 .31851 L
s
.35026 .35716 m
.23889 .49384 L
s
.0035 w
[ ] 0 setdash
.75546 .50603 m
.68244 .44034 L
s
.75546 .50603 m
.64397 .32698 L
s
.66054 .65315 m
.75546 .50603 L
s
.65519 .585 m
.75546 .50603 L
s
.23889 .49384 m
.37177 .31851 L
s
.23889 .49384 m
.337 .43125 L
s
.33724 .64758 m
.23889 .49384 L
s
.36165 .57909 m
.23889 .49384 L
s
.5 .75807 m
.66054 .65315 L
s
.65519 .585 m
.66054 .65315 L
s
.64397 .32698 m
.51982 .38415 L
s
.64397 .32698 m
.68244 .44034 L
s
.5105 .28499 m
.64397 .32698 L
s
.5 .75807 m
.33724 .64758 L
s
.36165 .57909 m
.33724 .64758 L
s
.37177 .31851 m
.51982 .38415 L
s
.37177 .31851 m
.5105 .28499 L
s
.337 .43125 m
.37177 .31851 L
s
.5105 .28499 m
.51982 .38415 L
s
.36165 .57909 m
.5 .75807 L
s
.51151 .60126 m
.5 .75807 L
s
.65519 .585 m
.5 .75807 L
s
.68244 .44034 m
.51982 .38415 L
s
.65519 .585 m
.68244 .44034 L
s
.337 .43125 m
.51982 .38415 L
s
.36165 .57909 m
.337 .43125 L
s
.65519 .585 m
.51982 .38415 L
s
.65519 .585 m
.51151 .60126 L
s
.36165 .57909 m
.51982 .38415 L
s
.51151 .60126 m
.36165 .57909 L
s
.51151 .60126 m
.51982 .38415 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.1,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016R000`400?l00000o`00003ooooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00Roooool3o`0008cooooo0028ooooo`?o00000_oo
ool4o`0008Wooooo0025ooooo`Co00000oooool3o`000003ooooool0003o000000;o0000Q_ooool0
08;ooooo0ol00005ooooo`03o`000?oooooo000000Go00000_ooool3o`0008?ooooo001oooooo`?o
00000_ooool2o`0000;ooooo1Ol00002ooooo`03o`000?oooooooooo00?o00000_ooool3o`00083o
oooo001looooo`?o00000oooool7o`0000?ooooo00Co0000oooooooooooo00001Oooool3o`0000;o
oooo0ol0001mooooo`00NOooool3o`0000Cooooo1?l0000;ooooo`03o`000?oooooooooo00Cooooo
00?o0000ooooool000000ol000001?oooooo0000o`000?l0001jooooo`00M_ooool3o`0000;ooooo
1Ol0000?ooooo`03o`000?oooooo000000[ooooo0ol000000ooooooo0000o`00001hooooo`00Looo
ool3o`000003ooooool0003o000000;o00000_ooool00ol0003oooooooooo`06ooooo`03o`000?oo
oooooooo00?ooooo00Co0000oooooooooooooooo0_l00007ooooo`;o00001?ooool6o`0007Gooooo
001`ooooo`Oo00003_ooool00ol0003oooooooooo`04ooooo`07o`000?ooooooooooooooool0003o
ooooo`000008ooooo`03o`000?oooooooooo00Gooooo1Ol0001booooo`00KOooool6o`0000Kooooo
0_l00009ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00_ooool00ol0003ooooo
o`00000Cooooo`Go0000Koooool006[ooooo1?l0000:ooooo`03o`000?oooooooooo013ooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`0;ooooo`;o00002Oooool5o`0006cooooo001X
ooooo`;o00009_ooool01Ol0003ooooooooooooooooo000000_ooooo00?o0000ooooooooool02_oo
ool4o`0006Wooooo001Xooooo`03o`000?oooooo000000;o00001oooool2o`0000cooooo00?o0000
ooooooooool02oooool01Ol0003ooooooooooooooooo000001_ooooo1?l0001Vooooo`00Ioooool2
o`0000Cooooo0_l00003ooooo`;o00003Oooool00ol0003oooooooooo`07ooooo`03o`000?oooooo
oooo00;ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0;ooooo`;o00003_ooool2
o`0006Gooooo001Vooooo`;o00001oooool2o`0000oooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`02ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool03?ooool00ol0
003oooooooooo`09ooooo`;o000000?oooooo`000?ooool0I?ooool006Gooooo00?o000000000?l0
00001_ooool2o`000004ooooool0003o0000o`0001Oooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`0Cooooo`03o`000?oooooooooo00Kooooo0_l00004ooooo`03o`000?oooooooooo
06;ooooo001Uooooo`03o`000?oooooo000000Gooooo00?o0000ooooooooool01?ooool2o`0001Go
oooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Eooooo`04o`000?oooooooooooooo
o`;o00001_ooool2o`0006?ooooo001Tooooo`03o`000?oooooo000000oooooo0_l00006ooooo`03
o`000?oooooooooo013ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0?ooooo`?o
00002?ooool2o`0006?ooooo001Sooooo`04o`000?ooooooooooo`0000;ooooo0_l0000=ooooo`?o
00000_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool03Oooool2o`000003ooooool0003ooooo00Sooooo00<00000o`000?l00000H_ooool006;ooooo
00Co000000000?oooooooooo0ol0000Booooo`;o00003_ooool00ol0003oooooooooo`03ooooo`03
o`000?oooooooooo00Gooooo00?o0000ooooooooool02_ooool2o`0000kooooo0_l0001Rooooo`00
H_ooool01?l000000000ooooool0000Gooooo`;o00003?ooool00ol0003oooooooooo`03ooooo`03
o`000?oooooooooo013ooooo0_l00008ooooo`;o00001_ooool00ol0003oooooo`00001Qooooo`00
HOooool00ol000000000o`000002o`0001Cooooo00?o0000ooooooooool00_ooool3o`0000Wooooo
00?o0000ooooooooool00oooool00ol0003oooooooooo`0>ooooo`;o00003?ooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooo0000063ooooo001Pooooo`03o`000?ooool0000000;ooooo00?o
0000ooooooooool04_ooool00ol0003oooooooooo`05ooooo`;o00001oooool00ol0003ooooooooo
o`03ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool00_ooool2o`0001?ooooo00D0
0000ooooool0003oooooo`00001Pooooo`00Goooool01_l0003ooooo00000?l0003oooooo`0001Co
oooo00?o0000ooooooooool02?ooool2o`0000_ooooo00?o0000ooooooooool02?ooool01?l0003o
ooooo`000?l0000Cooooo`;o000000<00000ooooool000000_ooool00ol0003oooooooooo`1Moooo
o`00Goooool01_l000000000ooooool0003oooooo`0001Cooooo00?o0000ooooooooool02_ooool3
o`0000Sooooo00?o0000ooooooooool02?ooool2o`0001Sooooo00<00000ooooool000000_ooool0
0ol0003oooooooooo`1Looooo`00G_ooool00ol0003oooooooooo`02ooooo`;o00009?ooool2o`00
00Oooooo00?o0000ooooooooool01?ooool3o`0001[ooooo00<00000ooooool000000_ooool00ol0
003oooooooooo`1Looooo`00GOooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo017o
oooo00?o0000ooooooooool04?ooool3o`0000Gooooo00?o0000ooooooooool00_ooool2o`0001co
oooo00Co0000ooooo`00003o00000oooool00ol0003oooooooooo`1Kooooo`00G?ooool00ol0003o
oooo00000004ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool04Oooool00ol0003o
ooooooooo`03o`0000;ooooo00?o0000ooooooooool00_l00007ooooo`03o`000?oooooooooo01Co
oooo00Go0000ooooo`00003oooooo`000002ooooo`03o`000?oooooooooo05_ooooo001Looooo`03
o`000000003ooooo00Cooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0Booooo`03
o`000?oooooooooo00?ooooo1Ol0000:ooooo`03o`000?oooooooooo01;ooooo00?o0000oooooooo
ool00_ooool01Ol0003ooooooooooooooooo000005cooooo001Kooooo`03o`000000003ooooo00Go
oooo0_l0000[ooooo`Co00003?ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00?o
oooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`1Iooooo`00F_ooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooo000002Oooooo1?l00002ooooo`03o`000?oooooo000000;o0000
8_ooool00`00003o0000ooooo`02ooooo`03o`000?oooooooooo05Wooooo001Iooooo`03o`000000
003ooooo00Kooooo00Co0000oooooooooooo00003Oooool00ol0003oooooooooo`0Cooooo`?o0000
1Oooool3o`0000?ooooo0ol0000Hooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
0_ooool00ol0003oooooooooo`1Hooooo`00FOooool00ol000000000ooooo`06ooooo`03o`000?oo
oooooooo00gooooo00?o0000ooooooooool04?ooool4o`000003ooooool0003ooooo00Cooooo00Go
0000ooooool0003oooooo`000005ooooo`?o00001Oooool00ol0003oooooooooo`0=ooooo`03o`00
0?oooooooooo00Gooooo00?o000000000?ooool00oooool00ol0003oooooooooo`1Gooooo`00F?oo
ool00ol000000000ooooo`06ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool03Ooo
ool4o`0000Gooooo00?o0000ooooooooool00_ooool01_l0003oooooooooool0003oooooo`0000So
oooo0ol00002ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool01oooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo05Oooooo001Gooooo`03o`000000003ooooo00Oooooo
00?o0000ooooooooool06_ooool3o`0000Wooooo00Go0000ooooooooooooooooo`000003ooooo`04
o`000?ooooooooooo`0000[ooooo0_l000000ooooooo0000ooooo`0;ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooo`0000000oooool00ol0003oooooooooo`1Fooooo`00E_ooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool04Oooool4o`0000co
oooo00Co0000oooooooooooo00001?ooool01Ol0003ooooooooooooooooo000000_ooooo0ol0000F
ooooo`04o`000?oooooooooo000000;ooooo00?o0000ooooooooool0E_ooool005Gooooo00?o0000
00000?ooool02?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Kooooo00?o0000
ooooooooool01?ooool4o`0001?ooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooo
oooo000000kooooo0ol0000Dooooo`04o`000?oooooooooo000000;ooooo00?o0000ooooooooool0
EOooool005Gooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo00Cooooo00Co0000oooooooooooooooo1?l0000Fooooo`03o`000?oooooooooo00?ooooo
00?o0000ooooooooool00_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00?o0000
1?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
E?ooool005Cooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooo000000;o00006?ooool2o`0000Kooooo00?o0000ooooooooool00oooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00?ooooo1?l0000=ooooo`03o`000?oooooooooo00Cooooo00?o
0000ooooooooool0E?ooool005?ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`09
ooooo`Co00006oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool02oooool00ol0003oooooooooo`04ooooo`Co00003?ooool01Ol0003ooooooooooooo
ool0000000;ooooo00?o0000ooooooooool0Doooool005;ooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`05ooooo`Co00007_ooool2o`0000Kooooo00?o0000ooooooooool01Oooool0
0ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00Oooooo0_l0000:ooooo`03o`000?oooooo
oooo00;ooooo00@00000oooooooooooo0000E?ooool005;ooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`02ooooo`?o000000Goooooo`000?ooooooooooo`00000Eooooo`?o00000ooo
ool6o`0000Cooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0Fooooo`?o00001ooo
ool00ol0003oooooooooo`03ooooo`0300000?oooooo000005Cooooo001Aooooo`03o`000000003o
oooo00[ooooo00?o0000ooooool000000ol00005ooooo`;o00002Oooool4o`0000;ooooo1?l0000:
ooooo`03o`000?oooooo000000Gooooo0ol00003ooooo`?o000000?oooooo`000?ooool03Oooool0
0ol0003oooooo`00000:ooooo`?o00001Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooo
oooo057ooooo001@ooooo`03o`000000003ooooo00[ooooo0ol00008ooooo`Co00000_ooool4o`00
01Gooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`05ooooo`03o`000?oooooo0000
00Co00002Oooool00ol0003oooooo`00000=ooooo`?o00000_ooool00ol0003oooooooooo`06oooo
o`03o`000?oooooooooo053ooooo001?ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooool0
00002?ooool01?l0003oooooo`000?l0000Kooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`03ooooo`Co00001?ooool00ol0003oooooooooo`0?oooo
o`?o00001_ooool00`00003oooooo`00001Booooo`00Coooool00ol0003oooooooooo`08ooooo`;o
00000_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo000001Wooooo00Go0000oooooooo
ooooooooo`000007ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02Oooool5o`00
01;ooooo0_l00004ooooo`0400000?ooooooooooo`00057ooooo001>ooooo`03o`000?oooooooooo
00Oooooo0_l00004ooooo`03o`000?oooooooooo00;ooooo0_l00004ooooo`03o`000?oooooooooo
01Sooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
00Wooooo00?o0000ooooooooool02Oooool2o`0000;ooooo00?o0000ooooooooool03oooool00ol0
003oooooo`000004ooooo`0300000?oooooo0000057ooooo001=ooooo`03o`000000003ooooo00Oo
oooo00?o0000ooooooooool01Oooool01?l0003oooooo`000?l0000Qooooo`03o`000?oooooooooo
00;ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo
00Oooooo00Co0000oooooooooooo00001?ooool2o`0000gooooo00Co0000oooooooooooo00001_oo
ool00ol0003oooooooooo`1>ooooo`00C?ooool00ol000000000ooooo`06ooooo`;o00001_ooool3
o`0000gooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`03ooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooo
oooo00[ooooo00Go0000ooooooooooooooooo`000006ooooo`03o`000?oooooooooo04gooooo001<
ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01Oooool01?l0003oooooooooool0
0008ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool04Oooool00ol0003ooooooooo
o`0<ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool07?ooool00ol0003ooooooooo
o`03ooooo`07o`000?ooooooooooooooo`00003oooooo`00001?ooooo`00Boooool00ol0003ooooo
ooooo`04ooooo`;o00002oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Cooooo
00?o0000ooooooooool03oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00cooooo
00?o0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Oooooo
0ol00006ooooo`03o`000?oooooooooo00Cooooo00Oo0000oooooooooooooooo00000?oooooo0000
04kooooo001:ooooo`03o`000?oooooooooo00?ooooo0_l00005ooooo`;o00001_ooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool01_ooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`05ooooo`07o`000?ooooooooooooooo`00003oooooo`00001=ooooo`00BOooool00ol0
00000000ooooo`03ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01_ooool00ol0
003oooooooooo`05ooooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool01_ooool00ol0
003oooooooooo`05ooooo`03o`000?oooooooooo00gooooo00Co0000oooooooooooo00001oooool0
0ol0003oooooooooo`0<ooooo`;o000000?oooooo`000?ooool01oooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo04_ooooo0019ooooo`04o`000?ooooooooooooooo`;o00000oooool2
o`0000cooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooo
oooo00Oooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0>ooooo`03o`000?oooooo
oooo00Oooooo00?o0000ooooooooool03_ooool2o`0000Wooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`1:ooooo`00B?ooool01Ol0003ooooooooooooooooo000000?ooooo0_l0000>
ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0I
ooooo`03o`000?oooooooooo00Sooooo0_l000000oooool00000o`00001<ooooo`00Aoooool00ol0
003oooooooooo`02o`0001Cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`08oooo
o`03o`000?oooooooooo00Sooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0>oooo
o`;o00006Oooool01?l0003oooooooooooooool2o`0000Sooooo00Co0000ooooo`00003o0000Booo
ool004Kooooo00Co000000000?oooooo00000_ooool2o`0001;ooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool03Ooo
ool01?l0003oooooooooool0000Hooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0
1_ooool01?l0003ooooo00000?l0001:ooooo`00A_ooool3o`0000;ooooo00?o0000ooooooooool0
4_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0
2oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00cooooo00Go0000oooooooooooo
ooooo`000007ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool03Oooool00ol0003o
ooooo`00001:ooooo`00AOooool3o`0001Sooooo00?o0000ooooooooool00oooool00ol0003ooooo
ooooo`0;ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool02oooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`0>ooooo`03o`000?oooooooooo00Kooooo0ol00005ooooo`03o`000?oooooo000004Wooooo
0014ooooo`;o00006oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooooooool03?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00gooooo00?o
0000ooooooooool02Oooool00ol0003oooooooooo`03ooooo`03o`000000003o000004Sooooo0013
ooooo`;o00007?ooool00ol0003oooooooooo`0Booooo`04o`000?ooooooooooo`0000oooooo00?o
0000ooooooooool01?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Kooooo00?o
0000ooooooooool05?ooool00ol0003oooooooooo`0<ooooo`;o00000_ooool2o`0004Sooooo0013
ooooo`?o00006oooool01Ol0003ooooooooooooooooo000001;ooooo00?o0000ooooooooool05Ooo
ool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool04_oo
ool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00;o0000Aoooool004Cooooo00Co0000
ooooool0003o00006Oooool01Ol0003ooooooooooooooooo0000017ooooo00?o0000ooooooooool0
5_ooool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0
4oooool00ol0003oooooooooo`15ooooo`00AOooool01?l0003oooooooooool0000Hooooo`05o`00
0?ooooooooooooooool000004Oooool2o`0001Oooooo00?o0000ooooooooool05Oooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool04_ooool3o`0004Ko
oooo0015ooooo`04o`000?ooooooooooooooo`?o00005_ooool01?l0003oooooooooool0000@oooo
o`03o`000?oooooo0000013ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`07oooo
o`03o`000?oooooooooo00cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0;oooo
o`03o`000?oooooooooo01Cooooo0_l00015ooooo`00A_ooool01?l000000000ooooooooool3o`00
01Gooooo00?o0000ooooooooool04?ooool01Ol0003ooooooooooooooooo000000oooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00kooooo00Go0000
ooooooooooooooooo`00000=ooooo`03o`000?oooooooooo013ooooo0_l000001?oooooo0000oooo
ool00015ooooo`00A_ooool00ol000000000ooooo`03ooooo`04o`000?ooooooooooo`0001;ooooo
00?o0000ooooooooool03oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00Cooooo
00?o0000ooooooooool01Oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00kooooo
00?o0000ooooooooool03oooool2o`0000;ooooo00?o0000ooooool00000A_ooool004Oooooo00?o
000000000?ooool00oooool2o`000003ooooool0003ooooo013ooooo00?o0000ooooool000003_oo
ool00ol0003oooooooooo`0Jooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool03Ooo
ool00ol0003oooooooooo`0;ooooo`;o00001Oooool00ol0003oooooo`000017ooooo`00B?ooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooo0000013ooooo00?o0000ooooool000003Oooool0
0ol0003oooooooooo`06ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool06Oooool0
0ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool00oooool2
o`0000;ooooo00?o0000ooooooooool0AOooool004Sooooo00?o0000ooooooooool01Oooool01?l0
003oooooooooooooool3o`0000_ooooo0_l0000>ooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool04Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo01?ooooo00Co0000
oooooooooooo00002oooool00ol0003oooooooooo`0?ooooo`05o`000?ooool00000ooooool00000
B?ooool004Wooooo00?o000000000?ooool01Oooool2o`0000Cooooo00?o0000ooooooooool02Ooo
ool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02Ooo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool05Ooo
ool00ol0003oooooo`00000;ooooo`03o`000?oooooooooo00Kooooo0_l00006ooooo`05o`000?oo
ool00000ooooool00000BOooool004[ooooo00?o000000000?ooool01_ooool00ol0003ooooooooo
o`0=ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool05_ooool00ol0003ooooooooo
o`04ooooo`05o`000?ooooooooooooooool000006Oooool2o`0000_ooooo00?o0000ooooooooool0
1?ooool2o`0000Kooooo0_l000001Oooool00000oooooooooooo000004Wooooo001:ooooo`03o`00
0?ooool0000000Oooooo0_l00004ooooo`;o00001oooool00ol0003oooooooooo`09ooooo`03o`00
0?oooooooooo01Kooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Kooooo`03o`00
0?oooooooooo00Wooooo00Co0000oooooooooooooooo0_l00009ooooo`03o`000?oooooooooo00?o
oooo00?o0000ooooooooool0B?ooool004_ooooo00?o0000ooooooooool02?ooool00ol0003ooooo
ooooo`03ooooo`03o`000?oooooooooo00?ooooo0_l0000:ooooo`03o`000?oooooooooo00kooooo
00?o0000ooooooooool01_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooo000001cooooo
00?o0000ooooooooool02?ooool01?l0003oooooo`000?l0000:ooooo`04o`000?oooooooooo0000
00;ooooo00?o0000ooooooooool0BOooool004_ooooo00?o0000ooooooooool02Oooool2o`0000Wo
oooo0_l0000:ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool03Oooool00ol0003o
ooooo`00000Mooooo`03o`000?oooooooooo00Gooooo0ol0000<ooooo`04o`000?oooooooooo0000
00?ooooo00?o0000ooooooooool0BOooool004cooooo00?o0000ooooo`0000002_ooool00ol0003o
ooooooooo`03ooooo`Go00002Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00co
oooo0_l0000Nooooo`03o`000?oooooooooo00?ooooo0_l00002ooooo`03o`000?oooooooooo00So
oooo0_l00002ooooo`0500000?ooooooooooooooool00000C?ooool004gooooo00?o0000ooooo`00
00002_ooool00ol0003oooooooooo`05ooooo`?o00001oooool00ol0003oooooooooo`0Iooooo`03
o`000?oooooooooo00Gooooo00?o0000ooooooooool07Oooool4o`0000Kooooo00?o0000oooooooo
ool01oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo04_ooooo001=ooooo`04o`00
0?oooooooooo000000[ooooo0_l00007ooooo`03o`000?oooooooooo00?o000000?oooooo`000?oo
ool06oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo01kooooo0_l00007ooooo`03
o`000?oooooooooo00Kooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`1;ooooo`00
C_ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
0oooool00ol0003oooooo`00000Looooo`?o00000_ooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo00Kooooo00?o0000ooooooooool00_ooool01@00003ooooooooooooooooo000004ko
oooo001?ooooo`03o`000?oooooooooo00cooooo0_l00002ooooo`03o`000?oooooo000000Cooooo
00Co0000oooooooooooooooo1?l0000Booooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool00_ooool01?l0003oooooooooool0000Eooooo`Co00002Oooool00ol0003oooooooooo`03oooo
o`03o`000?oooooooooo00Cooooo0_l00004ooooo`0500000?ooooooooooooooool00000Coooool0
04oooooo00Co0000ooooooooool000003Oooool01Ol0003oooooo`000?oooooo000000Cooooo00?o
0000ooooooooool01oooool3o`0000kooooo00?o0000ooooooooool01Oooool01Ol0003ooooooooo
oooooooo0000017ooooo0_l0000<ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo00?ooooo00<00000ooooooooool00_ooool00ol0003o
ooooooooo`1=ooooo`00D?ooool01?l0003oooooooooo`00000=ooooo`04o`000?oooooo0000o`00
00?ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`03o`0001?ooooo00?o0000oooo
ooooool02_ooool2o`0000;ooooo0_l0000>ooooo`05o`000?ooooooooooooooool000001?ooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0C_ooool0
057ooooo00Co0000ooooooooool000003Oooool2o`000004ooooool0003oooooo`0001Cooooo00?o
0000ooooooooool02Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo0_l0
0002ooooo`;o00005?ooool00ol0003oooooooooo`02ooooo`05o`000?ooooooooooooooool00000
0_ooool2o`0000[ooooo00?o0000ooooooooool0Coooool0057ooooo00?o0000ooooooooool04?oo
ool3o`0001Sooooo0ol00004ooooo`05o`000?oooooo0000ooooool000001?ooool3o`0000;ooooo
0_l0000Jooooo`03o`000?oooooooooo00?ooooo00Ko0000oooooooooooo0000ooooool00007oooo
o`0300000?oooooooooo00;ooooo00?o0000ooooooooool0Coooool005;ooooo00?o0000oooooooo
ool04?ooool5o`0001Sooooo00?o0000ooooooooool01ol00002ooooo`;o00009_ooool01Ol0003o
ooooo`000?oooooo000000Oooooo00<00000ooooooooool00_ooool00ol0003oooooooooo`1@oooo
o`00D_ooool01Ol0003oooooooooooooool0000000cooooo00?o0000ooooool000001?ooool7o`00
01Kooooo0ol00005ooooo`03o`000?oooooooooo02Gooooo0ol00007ooooo`0300000?oooooooooo
00;ooooo00?o0000ooooooooool0DOooool005?ooooo00Go0000oooooooooooooooo0000000;oooo
o`;o000000?oooooo`000?ooool02Oooool7o`0000kooooo00Co0000oooooooooooooooo0_l00003
ooooo`03o`000?oooooooooo01gooooo00Co0000oooooooooooooooo1_l0000=ooooo`03o`000?oo
oooooooo057ooooo001Dooooo`05o`000?ooooooooooooooo`0000002oooool01?l0003ooooooooo
ool0000@ooooo`Oo00003Oooool01?l0003oooooooooool0000Iooooo`[o00001Oooool00ol0003o
ooooooooo`04ooooo`0300000?oooooooooo00?ooooo00?o0000ooooooooool0D_ooool005Cooooo
00?o0000ooooooooool03Oooool01Ol0003ooooooooooooooooo000001Kooooo1ol00002ooooo`03
o`000?oooooooooo00;ooooo00?o0000ooooool000003_ooool;o`0000Kooooo00?o0000oooooooo
ool01Oooool2o`0000Gooooo00<00000ooooooooool01?ooool00ol0003oooooooooo`1Booooo`00
EOooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
5oooool01?l0003oooooooooooooool7o`0000;ooooo00?o0000ooooooooool00_ooool:o`00017o
oooo00?o0000ooooooooool01?ooool00ol0003oooooo`000004ooooo`0300000?oooooooooo00Co
oooo00?o0000ooooooooool0Doooool005Kooooo00Go0000oooooooooooooooo00000008ooooo`03
o`000?oooooooooo00?ooooo00?o0000ooooooooool05Oooool00ol0003oooooooooo`04ooooo`03
o`000?oooooooooo00;ooooo1ol0000Qooooo`04o`000?ooooooooooo`0000[ooooo00?o0000oooo
ooooool0E?ooool005Kooooo00?o0000ooooooooool00_ooool00`00003oooooooooo`05ooooo`;o
00001Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00Oooooo00?o0000oooooooo
ool01?ooool01?l0003oooooooooool0000Qooooo`05o`000?ooooooooooooooool000002_ooool0
0ol0003oooooooooo`1Dooooo`00Eoooool00ol0003oooooooooo`02ooooo`0300000?oooooooooo
00?ooooo00?o0000ooooool000001_ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo
00oooooo00?o0000ooooooooool07?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo
00;ooooo00?o0000ooooo`0000001oooool00ol0003oooooooooo`1Eooooo`00Eoooool00ol0003o
ooooooooo`08ooooo`04o`000?ooooooooooo`0000Kooooo00?o0000ooooooooool03Oooool00ol0
003oooooooooo`0@ooooo`03o`000?oooooooooo00?ooooo0_l0000Gooooo`05o`000?oooooooooo
ooooool000001Oooool00ol0003ooooo00000006ooooo`03o`000?oooooooooo05Kooooo001Hoooo
o`03o`000?oooooooooo00?ooooo00@00000oooooooooooo00000oooool00ol0003oooooooooo`04
ooooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05
ooooo`03o`000?oooooooooo01Cooooo00Co0000oooooooooooo00001_ooool00ol000000000oooo
o`06ooooo`03o`000?oooooooooo05Kooooo001Iooooo`03o`000?oooooooooo00;ooooo00@00000
oooooooooooo00002oooool00ol0003oooooooooo`08ooooo`;o00003_ooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo01cooooo00?o0000ooooool000001oooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo05Oooooo001Iooooo`03o`000?oooooooooo00?ooooo00<00000
ooooool000003?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00oooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo01;ooooo00?o0000
ooooooooool01?ooool01000003oooooooooool00005ooooo`03o`000?oooooooooo05Sooooo001J
ooooo`03o`000?oooooooooo00;ooooo00<00000o`000?ooool03Oooool00ol0003oooooooooo`0G
ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0A
ooooo`03o`000?oooooooooo00?ooooo00D00000ooooooooooooooooo`000005ooooo`03o`000?oo
oooooooo05Sooooo001Kooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`06ooooo`04o`000?ooooooooooooooo`;o00006Oooool00ol0003ooooooooo
o`0;ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool00oooool00`00003ooooooooo
o`02ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0FOooool005_ooooo00?o0000
ooooooooool00_ooool00ol000000000ooooo`03ooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooool000006oooool00ol0003oooooooooo`0>ooooo`;o00003?ooool00ol0003oooooooooo`09
ooooo`05o`000?ooooooooooooooool00000G?ooool005cooooo00Ko0000oooooooooooo0000oooo
o`000004ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool05Oooool00ol0003ooooo
ooooo`02ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool02?ooool2o`0000_ooooo
00Go0000ooooooooooooooooo`00001Looooo`00G?ooool01?l0003oooooooooool00002ooooo`03
00000?oooooooooo00Wooooo0_l00002ooooo`03o`000?oooooooooo01Cooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00Kooooo00?o0000ooooool0
00001?ooool00`00003oooooooooo`04ooooo`04o`000?ooooooooooo`0005gooooo001Mooooo`03
o`000?oooooo000000?ooooo00<00000ooooooooool01oooool00ol0003oooooooooo`02ooooo`03
o`000?oooooooooo01Cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Iooooo`03
o`000?oooooooooo00Cooooo00<00000ooooooooool01Oooool00ol0003oooooo`00001Nooooo`00
G_ooool2o`00000300000?oooooooooo00Wooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`0Cooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool04oooool3o`0000;ooooo
00?o0000ooooooooool01?ooool00`00003oooooooooo`06ooooo`03o`000?oooooo000005kooooo
001Pooooo`03o`000000003ooooo00;ooooo00<00000ooooool000003?ooool00ol0003ooooooooo
o`0Gooooo`03o`000?oooooooooo01Kooooo0_l0000@ooooo`;o0000Goooool0067ooooo0_l00000
1?ooool00000000000000003o`0000_ooooo00?o0000ooooooooool05_ooool00ol0003ooooooooo
o`0Fooooo`03o`000?oooooooooo00?ooooo00?o000000000?ooool02?ooool2o`00063ooooo001S
ooooo`04o`000?ooooooooooooooo`<000002oooool00ol0003oooooooooo`0Aooooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooooooool05Oooool01?l0003oooooooooooooool2o`000003oooo
o`00003ooooo00?ooooo0P000002ooooo`0300000?l0003ooooo067ooooo001Tooooo`03o`000?oo
oooooooo00@000002oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooooooool05Oooool00ol0003oooooooooo`02ooooo`0300000?l0003o000000;ooooo0P00
0003ooooo`;o0000Hoooool006Gooooo0_l00003ooooo`0300000?oooooooooo00<000001oooool0
0ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool05?ooool0
1?l0003oooooooooooooool2000000Wooooo00?o0000ooooooooool0Hoooool006Oooooo00?o0000
ooooooooool01_ooool00`00003oooooooooo`05ooooo`03o`000?oooooooooo00kooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`0Cooooo`03o`0000000000000000?ooooo0P000006
ooooo`;o0000I_ooool006Sooooo0_l00002ooooo`8000001Oooool4000000;ooooo00?o0000oooo
ooooool04_ooool00ol0003oooooooooo`0>ooooo`8000000_ooool00ol000000000ooooo`03oooo
o`0300000?oooooooooo00Gooooo00?o0000ooooooooool0I_ooool006[ooooo00Go0000oooooooo
oooooooo0000000:ooooo`03o`0000000000000001;ooooo00?o0000ooooooooool03?ooool20000
00?ooooo00?o0000ooooooooool00oooool00`00003oooooooooo`04ooooo`;o0000JOooool006_o
oooo0_l00002ooooo`0300000?oooooooooo00Sooooo00?o0000ooooo`0000004Oooool00ol0003o
ooooooooo`06ooooo`@000001_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo06Wo
oooo001]ooooo`03o`000?oooooooooo00_ooooo00Co0000oooooooooooooooo10000006ooooo`05
o`000?ooooooooooooooool000001Oooool2000000_ooooo00?o0000ooooooooool00oooool00`00
003oooooooooo`03ooooo`;o0000K?ooool006kooooo0_l000000oooool00000ooooo`09ooooo`03
o`000?oooooooooo00Kooooo0`0000000ooooooo0000ooooo`02ooooo`04o`000000003ooooooooo
o`8000003?ooool00ol0003oooooooooo`03ooooo`0300000?oooooooooo00?ooooo00?o0000oooo
ooooool0K?ooool0073ooooo00?o0000ooooo`0000002Oooool00ol0003oooooooooo`09ooooo`03
00000?l0003ooooo0080000000?o0000ooooooooool03_ooool00ol0003oooooooooo`03ooooo`03
00000?oooooooooo00;ooooo0_l0001_ooooo`00LOooool00ol0003ooooo00000009ooooo`03o`00
0?oooooooooo00Wooooo00Go0000ooooooooooooooooo`00000@ooooo`03o`000?oooooooooo00Oo
oooo00?o0000ooooooooool0Koooool007;ooooo0_l0000:ooooo`03o`000?oooooooooo00cooooo
00?o0000ooooooooool03Oooool01Ol0003oooooooooooooool0000000Cooooo0_l0001booooo`00
M?ooool00ol0003ooooo00000008ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0
3?ooool01Ol0003oooooooooooooool0000000Cooooo00?o0000ooooooooool0L_ooool007Gooooo
0_l000000`00003oooooooooo`05ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0
2oooool01Ol0003oooooooooooooool0000000?ooooo0_l0001eooooo`00Moooool00ol000000000
ooooo`06ooooo`03o`000?oooooooooo00Oooooo00@00000oooooooooooo00003?ooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo07Gooooo001hooooo`;o00001oooool00ol0003ooooo
ooooo`06ooooo`0400000?ooooooooooo`0000_ooooo00Co0000ooooooooool000000oooool2o`00
07Sooooo001jooooo`03o`0000000000000000Gooooo00?o0000ooooooooool01Oooool01000003o
ooooooooool0000:ooooo`04o`000?oooooooooo000000?ooooo00?o0000ooooooooool0N?ooool0
07_ooooo00?o0000ooooo`0000001?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo
00Oooooo00Co0000ooooooooool000000_ooool2o`0007_ooooo001looooo`;o00001Oooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool00oooool00ol0
003oooooooooo`1kooooo`00O_ooool00ol0003ooooo00000003ooooo`03o`000?oooooooooo00Ko
oooo00?o0000ooooooooool01Oooool01Ol0003ooooo00000000003ooooo00;o0000O_ooool007oo
oooo0_l000001@00003ooooooooooooooooo000000Gooooo00<00000ooooool000001oooool01Ol0
00000000oooooooooooo0000083ooooo0021ooooo`03o`000000003ooooo00;ooooo00?o0000oooo
ooooool00_ooool00`00003oooooo`000006ooooo`03o`000000003ooooo00;o0000POooool008;o
oooo0_l00002ooooo`03o`000?oooooooooo00;ooooo00<00000o`000?ooool01Oooool01?l0003o
ooooooooool00023ooooo`00Q?ooool01?l000000000ooooool00004ooooo`03o`000?oooooooooo
00?ooooo00Co000000000?l0003o0000Q?ooool008Gooooo0_l000000ooooooo0000ooooo`02oooo
o`03o`000?oooooooooo00;ooooo00?o000000000?l00000Q_ooool008Oooooo00?o0000ooooool0
00000_ooool01?l0003oooooooooooooool3o`0008Oooooo0028ooooo`;o00000_ooool00ol0003o
ooooooooo`02o`0008Wooooo0029ooooo`;o000000?oooooo`000?ooool00_l0002:ooooo`00Rooo
ool3o`0008cooooo002<ooooo`03o`000?oooooooooo08_ooooo003ooooooa_ooooo003ooooooa_o
oooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_o
oooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_o
oooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_o
oooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_o
oooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_o
oooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_o
oooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_o
oooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_o
oooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_o
oooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_o
oooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_o
oooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_o
oooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_o
oooo0000\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-5.00005*^-6, -5.00005*^-6, \
0.00355875, 0.00355875}}]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Unfolding the Polytope", "Section",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["UnfoldPolytope[facets1] ", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.383333,
  AnimationCycleOffset->0.0625,
  AnimationCycleRepetitions->Infinity]
}, Open  ]],

Cell[CellGroupData[{

Cell["Disconnect cddmathlink", "Section",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["Uninstall[cddml]", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \("/Users/fukuda/Math/cddmathlink"\)], "Output"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.1 for Macintosh",
ScreenRectangle->{{0, 1152}, {0, 746}},
AutoGeneratedPackage->None,
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{520, 624},
WindowMargins->{{274, Automatic}, {9, Automatic}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 133, 4, 252, "Title"],
Cell[1841, 56, 231, 4, 92, "Subtitle"],

Cell[CellGroupData[{
Cell[2097, 64, 110, 2, 56, "Section",
  InitializationCell->True],
Cell[2210, 68, 119, 2, 27, "Input",
  InitializationCell->True],
Cell[2332, 72, 112, 2, 27, "Input",
  InitializationCell->True],
Cell[2447, 76, 534, 13, 86, "Text",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[3006, 93, 83, 2, 27, "Input",
  InitializationCell->True],
Cell[3092, 97, 969, 16, 299, "Output"]
}, Open  ]],
Cell[4076, 116, 112, 2, 27, "Input",
  InitializationCell->True],
Cell[4191, 120, 418, 10, 68, "Text",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[4634, 134, 115, 2, 27, "Input",
  InitializationCell->True],
Cell[4752, 138, 84, 1, 27, "Output"]
}, Open  ]],
Cell[4851, 142, 437, 10, 86, "Text",
  InitializationCell->True],
Cell[5291, 154, 99, 2, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5415, 160, 94, 2, 27, "Input",
  InitializationCell->True],
Cell[5512, 164, 219, 4, 63, "Message"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5768, 173, 97, 2, 27, "Input",
  InitializationCell->True],
Cell[5868, 177, 222, 4, 63, "Message"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[6139, 187, 106, 1, 56, "Section"],

Cell[CellGroupData[{
Cell[6270, 192, 84, 1, 27, "Input"],
Cell[6357, 195, 726, 11, 187, "Output"]
}, Open  ]],
Cell[7098, 209, 176, 4, 50, "Text"],

Cell[CellGroupData[{
Cell[7299, 217, 130, 4, 42, "Input"],
Cell[7432, 223, 259, 4, 23, "Print"]
}, Open  ]],
Cell[7706, 230, 132, 4, 42, "Input"],

Cell[CellGroupData[{
Cell[7863, 238, 75, 1, 27, "Input"],
Cell[7941, 241, 41, 1, 27, "Output"]
}, Open  ]],
Cell[7997, 245, 162, 4, 42, "Input"],

Cell[CellGroupData[{
Cell[8184, 253, 83, 1, 27, "Input"],
Cell[8270, 256, 1633, 28, 243, "Output"]
}, Open  ]],
Cell[9918, 287, 286, 12, 177, "Input"],

Cell[CellGroupData[{
Cell[10229, 303, 98, 1, 27, "Input"],
Cell[10330, 306, 739, 10, 187, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[11118, 322, 86, 1, 56, "Section"],

Cell[CellGroupData[{
Cell[11229, 327, 77, 1, 46, "Subsection"],

Cell[CellGroupData[{
Cell[11331, 332, 167, 8, 70, "Input"],
Cell[11501, 342, 170, 6, 70, "Input"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[11720, 354, 92, 1, 30, "Subsection"],

Cell[CellGroupData[{
Cell[11837, 359, 260, 11, 147, "Input"],
Cell[12100, 372, 27476, 517, 290, 4617, 230, "GraphicsData", "PostScript", \
"Graphics"],
Cell[39579, 891, 28078, 525, 290, 4575, 230, "GraphicsData", "PostScript", \
"Graphics"],
Cell[67660, 1418, 26948, 511, 290, 4571, 230, "GraphicsData", "PostScript", \
"Graphics"],
Cell[94611, 1931, 26009, 499, 290, 4580, 230, "GraphicsData", "PostScript", \
"Graphics"],
Cell[120623, 2432, 27636, 519, 290, 4587, 230, "GraphicsData", "PostScript", \
"Graphics"],
Cell[148262, 2953, 27754, 521, 290, 4563, 230, "GraphicsData", "PostScript", \
"Graphics"],
Cell[176019, 3476, 27734, 520, 290, 4584, 230, "GraphicsData", "PostScript", \
"Graphics"],
Cell[203756, 3998, 4691, 234, 290, 4572, 230, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[208450, 4234, 28930, 535, 290, 4589, 230, "GraphicsData", "PostScript", \
"Graphics"],
Cell[237383, 4771, 4736, 234, 70, 4617, 230, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[242122, 5007, 4694, 234, 70, 4575, 230, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[246819, 5243, 4690, 234, 70, 4571, 230, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[251512, 5479, 4699, 234, 70, 4580, 230, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[256214, 5715, 4706, 234, 290, 4587, 230, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[260923, 5951, 4682, 234, 290, 4563, 230, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[265608, 6187, 27734, 520, 290, 4584, 230, "GraphicsData", "PostScript", \
"Graphics"],
Cell[293345, 6709, 29055, 537, 290, 4572, 230, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[322449, 7252, 106, 1, 30, "Subsection"],

Cell[CellGroupData[{
Cell[322580, 7257, 334, 13, 147, "Input"],
Cell[322917, 7272, 34287, 652, 290, 3040, 261, "GraphicsData", "PostScript", \
"Graphics"],
Cell[357207, 7926, 34393, 657, 290, 3065, 265, "GraphicsData", "PostScript", \
"Graphics"],
Cell[391603, 8585, 32309, 628, 290, 3030, 261, "GraphicsData", "PostScript", \
"Graphics"],
Cell[423915, 9215, 31029, 615, 290, 3071, 265, "GraphicsData", "PostScript", \
"Graphics"],
Cell[454947, 9832, 33813, 646, 290, 3032, 261, "GraphicsData", "PostScript", \
"Graphics"],
Cell[488763, 10480, 33771, 649, 290, 3047, 265, "GraphicsData", "PostScript", \
"Graphics"],
Cell[522537, 11131, 34320, 656, 290, 3061, 265, "GraphicsData", "PostScript", \
"Graphics"],
Cell[556860, 11789, 35334, 665, 290, 2994, 261, "GraphicsData", "PostScript", \
"Graphics"],
Cell[592197, 12456, 35474, 667, 290, 3032, 261, "GraphicsData", "PostScript", \
"Graphics"],
Cell[627674, 13125, 33704, 645, 290, 3040, 261, "GraphicsData", "PostScript", \
"Graphics"],
Cell[661381, 13772, 35106, 666, 290, 3065, 265, "GraphicsData", "PostScript", \
"Graphics"],
Cell[696490, 14440, 33151, 638, 290, 3030, 261, "GraphicsData", "PostScript", \
"Graphics"],
Cell[729644, 15080, 31118, 616, 290, 3071, 265, "GraphicsData", "PostScript", \
"Graphics"],
Cell[760765, 15698, 33999, 648, 290, 3032, 261, "GraphicsData", "PostScript", \
"Graphics"],
Cell[794767, 16348, 32836, 638, 290, 3047, 265, "GraphicsData", "PostScript", \
"Graphics"],
Cell[827606, 16988, 33441, 645, 290, 3061, 265, "GraphicsData", "PostScript", \
"Graphics"],
Cell[861050, 17635, 35108, 663, 290, 2994, 261, "GraphicsData", "PostScript", \
"Graphics"]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[896219, 18305, 74, 1, 56, "Section"],
Cell[896296, 18308, 179, 4, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[896512, 18317, 74, 1, 56, "Section"],

Cell[CellGroupData[{
Cell[896611, 18322, 66, 1, 27, "Input"],
Cell[896680, 18325, 66, 1, 27, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

