/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.ast;

import org.aspectj.org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ArrayInitializer
extends Expression {
    public Expression[] expressions;
    public ArrayBinding binding;

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.expressions != null) {
            int i = 0;
            int max = this.expressions.length;
            while (i < max) {
                flowInfo = this.expressions[i].analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
                ++i;
            }
        }
        return flowInfo;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc;
        block13: {
            pc = codeStream.position;
            int expressionLength = this.expressions == null ? 0 : this.expressions.length;
            codeStream.generateInlinedValue(expressionLength);
            codeStream.newArray(this.binding);
            if (this.expressions == null) break block13;
            int elementsTypeID = this.binding.dimensions > 1 ? -1 : this.binding.leafComponentType.id;
            int i = 0;
            while (i < expressionLength) {
                block15: {
                    Expression expr;
                    block14: {
                        expr = this.expressions[i];
                        if (expr.constant == ASTNode.NotAConstant) break block14;
                        switch (elementsTypeID) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 7: 
                            case 10: {
                                if (expr.constant.longValue() != 0L) {
                                    codeStream.dup();
                                    codeStream.generateInlinedValue(i);
                                    expr.generateCode(currentScope, codeStream, true);
                                    codeStream.arrayAtPut(elementsTypeID, false);
                                    break;
                                }
                                break block15;
                            }
                            case 8: 
                            case 9: {
                                double constantValue = expr.constant.doubleValue();
                                if (constantValue == -0.0 || constantValue != 0.0) {
                                    codeStream.dup();
                                    codeStream.generateInlinedValue(i);
                                    expr.generateCode(currentScope, codeStream, true);
                                    codeStream.arrayAtPut(elementsTypeID, false);
                                    break;
                                }
                                break block15;
                            }
                            case 5: {
                                if (expr.constant.booleanValue()) {
                                    codeStream.dup();
                                    codeStream.generateInlinedValue(i);
                                    expr.generateCode(currentScope, codeStream, true);
                                    codeStream.arrayAtPut(elementsTypeID, false);
                                    break;
                                }
                                break block15;
                            }
                            default: {
                                if (!(expr instanceof NullLiteral)) {
                                    codeStream.dup();
                                    codeStream.generateInlinedValue(i);
                                    expr.generateCode(currentScope, codeStream, true);
                                    codeStream.arrayAtPut(elementsTypeID, false);
                                    break;
                                }
                                break block15;
                            }
                        }
                        break block15;
                    }
                    if (!(expr instanceof NullLiteral)) {
                        codeStream.dup();
                        codeStream.generateInlinedValue(i);
                        expr.generateCode(currentScope, codeStream, true);
                        codeStream.arrayAtPut(elementsTypeID, false);
                    }
                }
                ++i;
            }
        }
        if (valueRequired) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        } else {
            codeStream.pop();
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        output.append('{');
        if (this.expressions != null) {
            int j = 20;
            int i = 0;
            while (i < this.expressions.length) {
                if (i > 0) {
                    output.append(", ");
                }
                this.expressions[i].printExpression(0, output);
                if (--j == 0) {
                    output.append('\n');
                    ASTNode.printIndent(indent + 1, output);
                    j = 20;
                }
                ++i;
            }
        }
        return output.append('}');
    }

    public TypeBinding resolveTypeExpecting(BlockScope scope, TypeBinding expectedTb) {
        this.constant = ASTNode.NotAConstant;
        TypeBinding leafComponentType = expectedTb.leafComponentType();
        if (leafComponentType.isBoundParameterizedType() || leafComponentType.isGenericType() || leafComponentType.isTypeVariable()) {
            scope.problemReporter().illegalGenericArray(leafComponentType, this);
        }
        if (expectedTb.isArrayType()) {
            this.binding = (ArrayBinding)expectedTb;
            if (this.expressions == null) {
                return this.binding;
            }
            TypeBinding expectedElementsTb = this.binding.elementsType();
            if (expectedElementsTb.isBaseType()) {
                int i = 0;
                int length = this.expressions.length;
                while (i < length) {
                    TypeBinding expressionTb;
                    Expression expression = this.expressions[i];
                    TypeBinding typeBinding = expressionTb = expression instanceof ArrayInitializer ? expression.resolveTypeExpecting(scope, expectedElementsTb) : expression.resolveType(scope);
                    if (expressionTb == null) {
                        return null;
                    }
                    if (expectedElementsTb != expressionTb) {
                        scope.compilationUnitScope().recordTypeConversion(expectedElementsTb, expressionTb);
                    }
                    if (!(expression.isConstantValueOfTypeAssignableToType(expressionTb, expectedElementsTb) || BaseTypeBinding.isWidening(expectedElementsTb.id, expressionTb.id) || scope.isBoxingCompatibleWith(expressionTb, expectedElementsTb))) {
                        scope.problemReporter().typeMismatchError(expressionTb, expectedElementsTb, expression);
                        return null;
                    }
                    expression.computeConversion(scope, expectedElementsTb, expressionTb);
                    ++i;
                }
            } else {
                int i = 0;
                int length = this.expressions.length;
                while (i < length) {
                    if (this.expressions[i].resolveTypeExpecting(scope, expectedElementsTb) == null) {
                        return null;
                    }
                    ++i;
                }
            }
            return this.binding;
        }
        TypeBinding leafElementType = null;
        int dim = 1;
        if (this.expressions == null) {
            leafElementType = scope.getJavaLangObject();
        } else {
            Expression currentExpression = this.expressions[0];
            while (currentExpression != null && currentExpression instanceof ArrayInitializer) {
                ++dim;
                Expression[] subExprs = ((ArrayInitializer)currentExpression).expressions;
                if (subExprs == null) {
                    leafElementType = scope.getJavaLangObject();
                    currentExpression = null;
                    break;
                }
                currentExpression = ((ArrayInitializer)currentExpression).expressions[0];
            }
            if (currentExpression != null) {
                leafElementType = currentExpression.resolveType(scope);
            }
        }
        if (leafElementType != null) {
            ArrayBinding probableTb = scope.createArrayType(leafElementType, dim);
            scope.problemReporter().typeMismatchError(probableTb, expectedTb, this);
        }
        return null;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope) && this.expressions != null) {
            int expressionsLength = this.expressions.length;
            int i = 0;
            while (i < expressionsLength) {
                this.expressions[i].traverse(visitor, scope);
                ++i;
            }
        }
        visitor.endVisit(this, scope);
    }
}

