/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.Message;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.CodeSignature;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.BetaException;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.IntMap;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.ast.Literal;
import org.aspectj.weaver.ast.Test;
import org.aspectj.weaver.internal.tools.PointcutExpressionImpl;
import org.aspectj.weaver.patterns.BindingTypePattern;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.ExactTypePattern;
import org.aspectj.weaver.patterns.ExposedState;
import org.aspectj.weaver.patterns.FastMatchInfo;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.NameBindingPointcut;
import org.aspectj.weaver.patterns.Pointcut;
import org.aspectj.weaver.patterns.TypePattern;
import org.aspectj.weaver.patterns.TypePatternList;

public class ArgsPointcut
extends NameBindingPointcut {
    TypePatternList arguments;

    public ArgsPointcut(TypePatternList arguments) {
        this.arguments = arguments;
        this.pointcutKind = (byte)4;
    }

    public Set couldMatchKinds() {
        return Shadow.ALL_SHADOW_KINDS;
    }

    public FuzzyBoolean fastMatch(FastMatchInfo type) {
        return FuzzyBoolean.MAYBE;
    }

    protected FuzzyBoolean matchInternal(Shadow shadow) {
        FuzzyBoolean ret = this.arguments.matches(shadow.getIWorld().resolve(shadow.getArgTypes()), TypePattern.DYNAMIC);
        return ret;
    }

    public FuzzyBoolean match(JoinPoint jp, JoinPoint.StaticPart jpsp) {
        FuzzyBoolean ret = this.arguments.matches(jp.getArgs(), TypePattern.DYNAMIC);
        if (ret == FuzzyBoolean.YES) {
            CodeSignature sig = (CodeSignature)jp.getSignature();
            Class[] pTypes = sig.getParameterTypes();
            ret = this.checkSignatureMatch(pTypes);
        }
        return ret;
    }

    private FuzzyBoolean checkSignatureMatch(Class[] pTypes) {
        Collection tps = this.arguments.getExactTypes();
        int sigIndex = 0;
        Iterator iter = tps.iterator();
        while (iter.hasNext()) {
            TypeX tp = (TypeX)iter.next();
            Class lookForClass = this.getPossiblyBoxed(tp);
            if (lookForClass == null) continue;
            boolean foundMatchInSig = false;
            while (sigIndex < pTypes.length && !foundMatchInSig) {
                if (pTypes[sigIndex++] != lookForClass) continue;
                foundMatchInSig = true;
            }
            if (foundMatchInSig) continue;
            return FuzzyBoolean.NO;
        }
        return FuzzyBoolean.YES;
    }

    public boolean matchesDynamically(Object thisObject, Object targetObject, Object[] args) {
        return this.arguments.matches(args, TypePattern.DYNAMIC) == FuzzyBoolean.YES;
    }

    public FuzzyBoolean matchesStatically(String joinpointKind, Member member, Class thisClass, Class targetClass, Member withinCode) {
        Class[] paramTypes = new Class[]{};
        if (member instanceof Method) {
            paramTypes = ((Method)member).getParameterTypes();
        } else if (member instanceof Constructor) {
            paramTypes = ((Constructor)member).getParameterTypes();
        } else if (member instanceof PointcutExpressionImpl.Handler) {
            paramTypes = new Class[]{((PointcutExpressionImpl.Handler)member).getHandledExceptionType()};
        } else if (member instanceof Field) {
            if (joinpointKind.equals(Shadow.FieldGet.getName())) {
                return FuzzyBoolean.NO;
            }
            paramTypes = new Class[]{((Field)member).getType()};
        } else {
            return FuzzyBoolean.NO;
        }
        return this.arguments.matchesArgsPatternSubset(paramTypes);
    }

    private Class getPossiblyBoxed(TypeX tp) {
        Class ret = (Class)ExactTypePattern.primitiveTypesMap.get(tp.getName());
        if (ret == null) {
            ret = (Class)ExactTypePattern.boxedPrimitivesMap.get(tp.getName());
        }
        return ret;
    }

    public List getBindingAnnotationTypePatterns() {
        return Collections.EMPTY_LIST;
    }

    public List getBindingTypePatterns() {
        ArrayList<TypePattern> l = new ArrayList<TypePattern>();
        TypePattern[] pats = this.arguments.getTypePatterns();
        for (int i = 0; i < pats.length; ++i) {
            if (!(pats[i] instanceof BindingTypePattern)) continue;
            l.add(pats[i]);
        }
        return l;
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeByte(4);
        this.arguments.write(s);
        this.writeLocation(s);
    }

    public static Pointcut read(VersionedDataInputStream s, ISourceContext context) throws IOException {
        ArgsPointcut ret = new ArgsPointcut(TypePatternList.read(s, context));
        ret.readLocation(context, s);
        return ret;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ArgsPointcut)) {
            return false;
        }
        ArgsPointcut o = (ArgsPointcut)other;
        return o.arguments.equals(this.arguments);
    }

    public int hashCode() {
        return this.arguments.hashCode();
    }

    public void resolveBindings(IScope scope, Bindings bindings) {
        this.arguments.resolveBindings(scope, bindings, true, true);
        if (this.arguments.ellipsisCount > 1) {
            scope.message(IMessage.ERROR, this, "uses more than one .. in args (compiler limitation)");
        }
    }

    public void resolveBindingsFromRTTI() {
        this.arguments.resolveBindingsFromRTTI(true, true);
        if (this.arguments.ellipsisCount > 1) {
            throw new UnsupportedOperationException("uses more than one .. in args (compiler limitation)");
        }
    }

    public void postRead(ResolvedTypeX enclosingType) {
        this.arguments.postRead(enclosingType);
    }

    public Pointcut concretize1(ResolvedTypeX inAspect, IntMap bindings) {
        if (this.isDeclare(bindings.getEnclosingAdvice())) {
            inAspect.getWorld().showMessage(IMessage.ERROR, WeaverMessages.format("argsInDeclare"), bindings.getEnclosingAdvice().getSourceLocation(), null);
            return Pointcut.makeMatchesNothing(Pointcut.CONCRETE);
        }
        TypePatternList args = this.arguments.resolveReferences(bindings);
        if (inAspect.crosscuttingMembers != null) {
            inAspect.crosscuttingMembers.exposeTypes(args.getExactTypes());
        }
        ArgsPointcut ret = new ArgsPointcut(args);
        ret.copyLocationFrom(this);
        return ret;
    }

    private Test findResidueNoEllipsis(Shadow shadow, ExposedState state, TypePattern[] patterns) {
        int len = shadow.getArgCount();
        if (patterns.length != len) {
            return Literal.FALSE;
        }
        Test ret = Literal.TRUE;
        for (int i = 0; i < len; ++i) {
            TypeX argType = shadow.getArgType(i);
            TypePattern type = patterns[i];
            if (!(type instanceof BindingTypePattern)) {
                ResolvedTypeX argRTX = shadow.getIWorld().resolve(argType, true);
                if (argRTX == ResolvedTypeX.MISSING) {
                    Message msg = new Message(WeaverMessages.format("cftArgType", argType.getName()), "", IMessage.ERROR, shadow.getSourceLocation(), null, new ISourceLocation[]{this.getSourceLocation()});
                }
                if (type.matchesInstanceof(argRTX).alwaysTrue()) {
                    continue;
                }
            } else {
                BindingTypePattern btp = (BindingTypePattern)type;
                if (state.get(btp.getFormalIndex()) != null && this.lastMatchedShadowId != shadow.shadowId) {
                    state.setErroneousVar(btp.getFormalIndex());
                }
            }
            ret = Test.makeAnd(ret, this.exposeStateForVar(shadow.getArgVar(i), type, state, shadow.getIWorld()));
        }
        return ret;
    }

    protected Test findResidueInternal(Shadow shadow, ExposedState state) {
        if (this.arguments.matches(shadow.getIWorld().resolve(shadow.getArgTypes()), TypePattern.DYNAMIC).alwaysFalse()) {
            return Literal.FALSE;
        }
        int ellipsisCount = this.arguments.ellipsisCount;
        if (ellipsisCount == 0) {
            return this.findResidueNoEllipsis(shadow, state, this.arguments.getTypePatterns());
        }
        if (ellipsisCount == 1) {
            TypePattern[] patternsWithEllipsis = this.arguments.getTypePatterns();
            TypePattern[] patternsWithoutEllipsis = new TypePattern[shadow.getArgCount()];
            int lenWithEllipsis = patternsWithEllipsis.length;
            int lenWithoutEllipsis = patternsWithoutEllipsis.length;
            int indexWithEllipsis = 0;
            int indexWithoutEllipsis = 0;
            while (indexWithoutEllipsis < lenWithoutEllipsis) {
                TypePattern p;
                if ((p = patternsWithEllipsis[indexWithEllipsis++]) == TypePattern.ELLIPSIS) {
                    int newLenWithoutEllipsis = lenWithoutEllipsis - (lenWithEllipsis - indexWithEllipsis);
                    while (indexWithoutEllipsis < newLenWithoutEllipsis) {
                        patternsWithoutEllipsis[indexWithoutEllipsis++] = TypePattern.ANY;
                    }
                    continue;
                }
                patternsWithoutEllipsis[indexWithoutEllipsis++] = p;
            }
            return this.findResidueNoEllipsis(shadow, state, patternsWithoutEllipsis);
        }
        throw new BetaException("unimplemented");
    }

    public String toString() {
        return "args" + this.arguments.toString() + "";
    }
}

