/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Member;
import java.util.HashSet;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.IntMap;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.ast.Literal;
import org.aspectj.weaver.ast.Test;
import org.aspectj.weaver.internal.tools.PointcutExpressionImpl;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.ExposedState;
import org.aspectj.weaver.patterns.FastMatchInfo;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.Pointcut;
import org.aspectj.weaver.patterns.TypePattern;

public class HandlerPointcut
extends Pointcut {
    TypePattern exceptionType;
    private static final Set MATCH_KINDS = new HashSet();

    public HandlerPointcut(TypePattern exceptionType) {
        this.exceptionType = exceptionType;
        this.pointcutKind = (byte)13;
    }

    public Set couldMatchKinds() {
        return MATCH_KINDS;
    }

    public FuzzyBoolean fastMatch(FastMatchInfo type) {
        return FuzzyBoolean.MAYBE;
    }

    protected FuzzyBoolean matchInternal(Shadow shadow) {
        if (shadow.getKind() != Shadow.ExceptionHandler) {
            return FuzzyBoolean.NO;
        }
        this.exceptionType.resolve(shadow.getIWorld());
        return this.exceptionType.matches(shadow.getSignature().getParameterTypes()[0].resolve(shadow.getIWorld()), TypePattern.STATIC);
    }

    public FuzzyBoolean match(JoinPoint jp, JoinPoint.StaticPart jpsp) {
        if (!jp.getKind().equals("exception-handler")) {
            return FuzzyBoolean.NO;
        }
        if (jp.getArgs().length > 0) {
            Object caughtException = jp.getArgs()[0];
            return this.exceptionType.matches(caughtException, TypePattern.STATIC);
        }
        return FuzzyBoolean.NO;
    }

    public boolean matchesDynamically(Object thisObject, Object targetObject, Object[] args) {
        if (args.length > 0) {
            return this.exceptionType.matches(args[0], TypePattern.STATIC) == FuzzyBoolean.YES;
        }
        return false;
    }

    public FuzzyBoolean matchesStatically(String joinpointKind, Member member, Class thisClass, Class targetClass, Member withinCode) {
        if (!(member instanceof PointcutExpressionImpl.Handler)) {
            return FuzzyBoolean.NO;
        }
        Class exceptionClass = ((PointcutExpressionImpl.Handler)member).getHandledExceptionType();
        return this.exceptionType.matches(exceptionClass, TypePattern.STATIC);
    }

    public boolean equals(Object other) {
        if (!(other instanceof HandlerPointcut)) {
            return false;
        }
        HandlerPointcut o = (HandlerPointcut)other;
        return o.exceptionType.equals(this.exceptionType);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.exceptionType.hashCode();
        return result;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("handler(");
        buf.append(this.exceptionType.toString());
        buf.append(")");
        return buf.toString();
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeByte(13);
        this.exceptionType.write(s);
        this.writeLocation(s);
    }

    public static Pointcut read(VersionedDataInputStream s, ISourceContext context) throws IOException {
        HandlerPointcut ret = new HandlerPointcut(TypePattern.read(s, context));
        ret.readLocation(context, s);
        return ret;
    }

    public void resolveBindings(IScope scope, Bindings bindings) {
        this.exceptionType = this.exceptionType.resolveBindings(scope, bindings, false, false);
    }

    public void resolveBindingsFromRTTI() {
        this.exceptionType = this.exceptionType.resolveBindingsFromRTTI(false, false);
    }

    protected Test findResidueInternal(Shadow shadow, ExposedState state) {
        return this.match(shadow).alwaysTrue() ? Literal.TRUE : Literal.FALSE;
    }

    public Pointcut concretize1(ResolvedTypeX inAspect, IntMap bindings) {
        HandlerPointcut ret = new HandlerPointcut(this.exceptionType);
        ret.copyLocationFrom(this);
        return ret;
    }

    static {
        MATCH_KINDS.add(Shadow.ExceptionHandler);
    }
}

