/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.Message;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.IntMap;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.ast.Literal;
import org.aspectj.weaver.ast.Test;
import org.aspectj.weaver.ast.Var;
import org.aspectj.weaver.patterns.AnnotationTypePattern;
import org.aspectj.weaver.patterns.BindingAnnotationTypePattern;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.ExactAnnotationTypePattern;
import org.aspectj.weaver.patterns.ExposedState;
import org.aspectj.weaver.patterns.FastMatchInfo;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.NameBindingPointcut;
import org.aspectj.weaver.patterns.Pointcut;

public class WithinAnnotationPointcut
extends NameBindingPointcut {
    private AnnotationTypePattern annotationTypePattern;
    private ShadowMunger munger;

    public WithinAnnotationPointcut(AnnotationTypePattern type) {
        this.annotationTypePattern = type;
    }

    public WithinAnnotationPointcut(AnnotationTypePattern type, ShadowMunger munger) {
        this(type);
        this.munger = munger;
    }

    public Set couldMatchKinds() {
        return Shadow.ALL_SHADOW_KINDS;
    }

    public FuzzyBoolean fastMatch(FastMatchInfo info) {
        return this.annotationTypePattern.fastMatches(info.getType());
    }

    protected FuzzyBoolean matchInternal(Shadow shadow) {
        ResolvedTypeX enclosingType = shadow.getIWorld().resolve(shadow.getEnclosingType(), true);
        if (enclosingType == ResolvedTypeX.MISSING) {
            Message msg = new Message(WeaverMessages.format("cantFindTypeWithinpcd", shadow.getEnclosingType().getName()), shadow.getSourceLocation(), true, new ISourceLocation[]{this.getSourceLocation()});
            shadow.getIWorld().getMessageHandler().handleMessage(msg);
        }
        this.annotationTypePattern.resolve(shadow.getIWorld());
        return this.annotationTypePattern.matches(enclosingType);
    }

    protected void resolveBindings(IScope scope, Bindings bindings) {
        this.annotationTypePattern = (ExactAnnotationTypePattern)this.annotationTypePattern.resolveBindings(scope, bindings, true);
    }

    protected void resolveBindingsFromRTTI() {
    }

    protected Pointcut concretize1(ResolvedTypeX inAspect, IntMap bindings) {
        ExactAnnotationTypePattern newType = (ExactAnnotationTypePattern)this.annotationTypePattern.remapAdviceFormals(bindings);
        WithinAnnotationPointcut ret = new WithinAnnotationPointcut(newType, bindings.getEnclosingAdvice());
        ret.copyLocationFrom(this);
        return ret;
    }

    protected Test findResidueInternal(Shadow shadow, ExposedState state) {
        if (this.annotationTypePattern instanceof BindingAnnotationTypePattern) {
            BindingAnnotationTypePattern btp = (BindingAnnotationTypePattern)this.annotationTypePattern;
            TypeX annotationType = btp.annotationType;
            Var var = shadow.getWithinAnnotationVar(annotationType);
            if (var == null) {
                throw new BCException("Impossible! annotation=[" + annotationType + "]  shadow=[" + shadow + " at " + shadow.getSourceLocation() + "]    pointcut is at [" + this.getSourceLocation() + "]");
            }
            if (state.get(btp.getFormalIndex()) != null && this.lastMatchedShadowId == shadow.shadowId) {
                state.setErroneousVar(btp.getFormalIndex());
            }
            state.set(btp.getFormalIndex(), var);
        }
        return Literal.TRUE;
    }

    public List getBindingAnnotationTypePatterns() {
        if (this.annotationTypePattern instanceof BindingAnnotationTypePattern) {
            ArrayList<AnnotationTypePattern> l = new ArrayList<AnnotationTypePattern>();
            l.add(this.annotationTypePattern);
            return l;
        }
        return Collections.EMPTY_LIST;
    }

    public List getBindingTypePatterns() {
        return Collections.EMPTY_LIST;
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeByte(17);
        this.annotationTypePattern.write(s);
        this.writeLocation(s);
    }

    public static Pointcut read(VersionedDataInputStream s, ISourceContext context) throws IOException {
        AnnotationTypePattern type = AnnotationTypePattern.read(s, context);
        WithinAnnotationPointcut ret = new WithinAnnotationPointcut((ExactAnnotationTypePattern)type);
        ret.readLocation(context, s);
        return ret;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WithinAnnotationPointcut)) {
            return false;
        }
        WithinAnnotationPointcut other = (WithinAnnotationPointcut)obj;
        return other.annotationTypePattern.equals(this.annotationTypePattern);
    }

    public int hashCode() {
        return 17 + 19 * this.annotationTypePattern.hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("@within(");
        String annPatt = this.annotationTypePattern.toString();
        buf.append(annPatt.startsWith("@") ? annPatt.substring(1) : annPatt);
        buf.append(")");
        return buf.toString();
    }
}

