/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.internal.localstore.SafeChunkyInputStream;
import org.eclipse.core.internal.localstore.SafeChunkyOutputStream;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.ModelObjectWriter;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ProjectDescriptionReader;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.resources.WorkspaceDescription;
import org.eclipse.core.internal.resources.WorkspaceDescriptionReader;
import org.eclipse.core.internal.utils.Assert;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class LocalMetaArea
implements ICoreConstants {
    protected IPath metaAreaLocation;
    static final String F_BACKUP_FILE_EXTENSION = ".bak";
    static final String F_DESCRIPTION = ".workspace";
    static final String F_HISTORY_STORE = ".history";
    static final String F_MARKERS = ".markers";
    static final String F_OLD_PROJECT = ".prj";
    static final String F_PROJECT_LOCATION = ".location";
    static final String F_PROJECTS = ".projects";
    static final String F_PROPERTIES = ".properties";
    static final String F_ROOT = ".root";
    static final String F_SAFE_TABLE = ".safetable";
    static final String F_SNAP = ".snap";
    static final String F_SNAP_EXTENSION = "snap";
    static final String F_SYNCINFO = ".syncinfo";
    static final String F_TREE = ".tree";

    public void clearOldDescription(IProject target) {
        Workspace.clear(this.getOldDescriptionLocationFor(target).toFile());
    }

    public void create(IProject target) {
        File file = this.locationFor(target).toFile();
        Workspace.clear(file);
        file.mkdirs();
    }

    public synchronized void createMetaArea() throws CoreException {
        File workspaceLocation = this.getLocation().toFile();
        Workspace.clear(workspaceLocation);
        if (!workspaceLocation.mkdirs()) {
            String message = Policy.bind("resources.writeWorkspaceMeta", workspaceLocation.toString());
            throw new ResourceException(568, null, message, null);
        }
    }

    public void delete(IProject target) throws CoreException {
        IPath path = this.locationFor(target);
        if (!Workspace.clear(path.toFile()) && path.toFile().exists()) {
            String message = Policy.bind("resources.deleteMeta", target.getFullPath().toString());
            throw new ResourceException(569, target.getFullPath(), message, null);
        }
    }

    public IPath getBackupLocationFor(IPath file) {
        return file.removeLastSegments(1).append(String.valueOf(file.lastSegment()) + F_BACKUP_FILE_EXTENSION);
    }

    public IPath getOldDescriptionLocationFor(IProject target) {
        return this.locationFor(target).append(F_OLD_PROJECT);
    }

    public IPath getHistoryStoreLocation() {
        return this.getLocation().append(F_HISTORY_STORE);
    }

    public IPath getLocation() {
        if (this.metaAreaLocation == null) {
            this.metaAreaLocation = ResourcesPlugin.getPlugin().getStateLocation();
        }
        return this.metaAreaLocation;
    }

    public IPath getMarkersLocationFor(IResource resource) {
        Assert.isNotNull(resource);
        Assert.isLegal(resource.getType() == 8 || resource.getType() == 4);
        return this.locationFor(resource).append(F_MARKERS);
    }

    public IPath getMarkersSnapshotLocationFor(IResource resource) {
        return this.getMarkersLocationFor(resource).addFileExtension(F_SNAP_EXTENSION);
    }

    public IPath getPropertyStoreLocation(IResource resource) {
        int type = resource.getType();
        Assert.isTrue(type != 1 && type != 2);
        return this.locationFor(resource).append(F_PROPERTIES);
    }

    public IPath getSafeTableLocationFor(String pluginId) {
        IPath prefix = this.getLocation().append(F_SAFE_TABLE);
        if (pluginId.equals("org.eclipse.core.resources")) {
            return prefix.append(pluginId);
        }
        int saveNumber = this.getWorkspace().getSaveManager().getSaveNumber(pluginId);
        return prefix.append(String.valueOf(pluginId) + "." + saveNumber);
    }

    public IPath getSnapshotLocationFor(IResource resource) {
        return this.getLocation().append(F_SNAP);
    }

    public IPath getSyncInfoLocationFor(IResource resource) {
        Assert.isNotNull(resource);
        Assert.isLegal(resource.getType() == 8 || resource.getType() == 4);
        return this.locationFor(resource).append(F_SYNCINFO);
    }

    public IPath getSyncInfoSnapshotLocationFor(IResource resource) {
        return this.getSyncInfoLocationFor(resource).addFileExtension(F_SNAP_EXTENSION);
    }

    public IPath getTreeLocationFor(IResource target, boolean updateSequenceNumber) {
        IPath key = target.getFullPath().append(F_TREE);
        String sequenceNumber = this.getWorkspace().getSaveManager().getMasterTable().getProperty(key.toString());
        if (sequenceNumber == null) {
            sequenceNumber = "0";
        }
        if (updateSequenceNumber) {
            int n = new Integer(sequenceNumber) + 1;
            n = n < 0 ? 1 : n;
            sequenceNumber = new Integer(n).toString();
            this.getWorkspace().getSaveManager().getMasterTable().setProperty(key.toString(), new Integer(sequenceNumber).toString());
        }
        return this.locationFor(target).append(String.valueOf(sequenceNumber) + F_TREE);
    }

    public IPath getWorkingLocation(IResource resource, String id) {
        return this.locationFor(resource).append(id);
    }

    protected Workspace getWorkspace() {
        return (Workspace)ResourcesPlugin.getWorkspace();
    }

    public IPath getOldWorkspaceDescriptionLocation() {
        return this.getLocation().append(F_DESCRIPTION);
    }

    public boolean hasSavedProject(IProject project) {
        return this.getOldDescriptionLocationFor(project).toFile().exists() || this.locationFor(project).append(F_PROJECT_LOCATION).toFile().exists();
    }

    public boolean hasSavedWorkspace() {
        return this.getLocation().toFile().exists() || this.getBackupLocationFor(this.getLocation()).toFile().exists();
    }

    public IPath locationFor(IResource resource) {
        if (resource.getType() == 8) {
            return this.getLocation().append(F_ROOT);
        }
        return this.getLocation().append(F_PROJECTS).append(resource.getProject().getName());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readPrivateDescription(IProject target, IProjectDescription description) {
        IPath locationFile = this.locationFor(target).append(F_PROJECT_LOCATION);
        File file = locationFile.toFile();
        if (!file.exists() && !(file = (locationFile = this.getBackupLocationFor(locationFile)).toFile()).exists()) {
            return;
        }
        try {
            SafeChunkyInputStream input = new SafeChunkyInputStream(file, 500);
            DataInputStream dataIn = new DataInputStream(input);
            try {
                try {
                    String location = dataIn.readUTF();
                    if (location.length() > 0) {
                        description.setLocation(Path.fromOSString(location));
                    }
                }
                catch (IOException e) {
                    String msg = Policy.bind("resources.exReadProjectLocation", target.getName());
                    ResourcesPlugin.getPlugin().getLog().log(new ResourceStatus(4, 567, target.getFullPath(), msg, (Throwable)e));
                }
                int numRefs = dataIn.readInt();
                IProject[] references = new IProject[numRefs];
                IWorkspaceRoot root = this.getWorkspace().getRoot();
                int i = 0;
                while (true) {
                    block10: {
                        if (i < numRefs) break block10;
                        description.setDynamicReferences(references);
                        break;
                    }
                    references[i] = root.getProject(dataIn.readUTF());
                    ++i;
                }
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                dataIn.close();
                throw throwable;
            }
            {
                Object var11_15 = null;
                dataIn.close();
                return;
            }
        }
        catch (IOException iOException) {}
    }

    public ProjectDescription readOldDescription(IProject project) throws CoreException {
        IPath path = this.getOldDescriptionLocationFor(project);
        if (!path.toFile().exists()) {
            return null;
        }
        IPath tempPath = this.getBackupLocationFor(path);
        ProjectDescription description = null;
        try {
            description = new ProjectDescriptionReader().read(path, tempPath);
        }
        catch (IOException e) {
            String msg = Policy.bind("resources.readMeta", project.getName());
            throw new ResourceException(567, project.getFullPath(), msg, e);
        }
        if (description == null) {
            String msg = Policy.bind("resources.readMeta", project.getName());
            throw new ResourceException(567, project.getFullPath(), msg, null);
        }
        return description;
    }

    public WorkspaceDescription readOldWorkspace() {
        IPath path = this.getOldWorkspaceDescriptionLocation();
        IPath tempPath = this.getBackupLocationFor(path);
        try {
            WorkspaceDescription oldDescription = (WorkspaceDescription)new WorkspaceDescriptionReader().read(path, tempPath);
            Workspace.clear(path.toFile());
            Workspace.clear(tempPath.toFile());
            return oldDescription;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writePrivateDescription(IProject target) throws CoreException {
        IPath location = this.locationFor(target).append(F_PROJECT_LOCATION);
        File file = location.toFile();
        Workspace.clear(file);
        ProjectDescription desc = ((Project)target).internalGetDescription();
        if (desc == null) {
            return;
        }
        IPath projectLocation = desc.getLocation();
        IProject[] references = desc.getDynamicReferences(false);
        int numRefs = references.length;
        if (projectLocation == null && numRefs == 0) {
            return;
        }
        try {
            SafeChunkyOutputStream output = new SafeChunkyOutputStream(file);
            DataOutputStream dataOut = new DataOutputStream(output);
            try {
                String locationString = projectLocation == null ? "" : projectLocation.toOSString();
                dataOut.writeUTF(locationString);
                dataOut.writeInt(numRefs);
                int i = 0;
                while (true) {
                    block8: {
                        if (i < numRefs) break block8;
                        output.succeed();
                        break;
                    }
                    dataOut.writeUTF(references[i].getName());
                    ++i;
                }
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                dataOut.close();
                throw throwable;
            }
            {
                Object var12_16 = null;
                dataOut.close();
                return;
            }
        }
        catch (IOException e) {
            String message = Policy.bind("resources.exSaveProjectLocation", target.getName());
            throw new ResourceException(566, null, message, e);
        }
    }

    public synchronized void write(WorkspaceDescription description) throws CoreException {
        IPath path = this.getOldWorkspaceDescriptionLocation();
        path.toFile().getParentFile().mkdirs();
        IPath tempPath = this.getBackupLocationFor(path);
        try {
            new ModelObjectWriter().write(description, path, tempPath);
        }
        catch (IOException e) {
            String message = Policy.bind("resources.writeWorkspaceMeta", path.toString());
            throw new ResourceException(568, null, message, e);
        }
    }
}

