/*
* This code is released under the GNU General Public License.  See COPYING for 
* details.  Copyright 2003 John Spray: spray_john@users.sourceforge.net
*/


#ifndef ARENA_H
#define ARENA_H

#include "Obstacle.h"
#include "Vector.h"
#include "LList.h"
#include "Quad.h"
#include "Game.h"

class Arena {
public: 
	Arena(Game* newgame);
	~Arena();
	void MakeObstacles();
	int Blocked(Vector s,float radius); //volume collision (sphere)
	int OutOfBounds(Vector s); //is it really far away from the origin?
	int Collision(Vector s,float radius); //surface collision (static sphere)
	int Collision(Vector p1,Vector p2); //surface collision (1 way ray p1->p2)
	Vector CollisionNearest(Vector p1,Vector p2); //surface collision (1 way ray p1->p2), returns closest collision point
	int Collision(Vector p1,Vector p2,float r); //surface collision (moving sphere from p1 to p2)
	void GenerateGeometry();
	Quad* GetLastQuad();
	LList<Obstacle> obstaclelist;
	LList<Quad> geomlist;
	float halfwidth;
	float wallheight;
	Game* game;
	Quad* lastquad;
	Quad virtualquad;
};

#endif
