/*
* This code is released under the GNU General Public License.  See COPYING for 
* details.  Copyright 2003 John Spray: spray_john@users.sourceforge.net
*/



#ifndef GAME_H
#define GAME_H

#include <SDL.h>

#include "LList.h"
#include "Vector.h"

class Events;
class Visual;
class Player;
class SoundCore;
class Missile;
class Arena;
class Ufo;
class Obstacle;
class PowerUp;
class Mine;

class Game{
public:
	Game(SDL_Surface* newscreen);
	~Game();
	int Happen();
	int quit;
	SDL_Surface* screen;
	Player* player;
	Player* player2;
	Events* evs;
	SoundCore* sound;
	Visual* visual;
	Arena* arena;
	LList<Missile>* missilelist;
	LList<Ufo>* ufolist;
	LList<Mine>* minelist;
	LList<PowerUp>* poweruplist;

	void NewMissile(Missile* newmissile);
	void NewUfo(Ufo* newufo);
	void NewMine(Mine* newmine);
	void NewPowerUp(PowerUp* newpowerup);
	void SpawnUfos();
	void UpdateMissiles();
	void UpdateUfos();
	void UpdateMines();
	void UpdatePowerUps();
	void IncScore(int);
	void ShowMenu();
	void GameOver(int quitstate);

	void Resize(int,int);


	float dtf;
	float timescale;
	int verbose;
	int score;
	long startticks; //these are used in Happen, but need to be accessible for temporal correction
	long ticks; ///...in things like ShowMenu, which otherwise causes a rift in spacetime for the simulation
	Vector g;

	float spawnticker;
	float spawndelay;
};

#endif //GAME_H
