/*
* This code is released under the GNU General Public License.  See COPYING for 
* details.  Copyright 2003 John Spray: spray_john@users.sourceforge.net
*/


#ifndef MINE_H
#define MINE_H

#include "Vector.h"
#include "Game.h"

enum MineOwnerType{
	MINE_PLAYER,
	MINE_ENEMY
};


class Mine {
public: 
	Mine();
	~Mine();
	void Physics();
	void Collide();
	Ufo* NearestUfo();
	void Die();
	void Live();
	void Explode();
	int Hurt(float pain);
	Game* game;

	Vector s;
	Vector v;
	Vector a;
	float spin;

	float spawneffect;
	float maxspawneffect;
	float collideradius;
	float collideradius2;
	float sniffradius;
	float hp;

	int alive;

	int soundid;
};

#endif
