/*
* This code is released under the GNU General Public License.  See COPYING for 
* details.  Copyright 2003 John Spray: spray_john@users.sourceforge.net
*/


#include <stdlib.h>
#include <math.h>
#include <SDL_opengl.h>

#ifndef M_2PI
#define M_2PI 6.28318
#endif

#include "Particle.h"
#include "Arena.h"


Particle::Particle()
{
	s=0.0f;
	v=0.0f;
	a=0.0f;
	res=1.0f;
	rad=5.0f;
	life=500.0f;
	diffuse=0.0f;
	blendmode=GL_ONE_MINUS_SRC_ALPHA;
	drawmode=PARTICLE_DRAW_SIMPLE;
	bounce=PARTICLE_BOUNCE_NONE;
	collide=0;
	if(rand()<RAND_MAX/2)
					spindir=1.0f;
	else
					spindir=-1.0f;
}

void Particle::Animate(float dtf)
{
	if(diffuse){
		Vector offset;
		offset.x=(float(rand())/float(RAND_MAX))*diffuse;
		offset.y=(float(rand())/float(RAND_MAX))*diffuse;
		offset.z=(float(rand())/float(RAND_MAX))*diffuse;
		if(rand()<RAND_MAX/2)
			offset*=-1;
		a+=(dtf*offset);
	}
	v*=pow(res,dtf);
	v+=dtf*a;
	s+=dtf*v;
	life-=dtf;
}


int Particle::Collide(Game *game)
{
	for(int j=0;j<2;j++){
	if(game->arena->Collision(s,s+v*game->dtf)){
		switch(bounce){
		case PARTICLE_BOUNCE_ONE:
			v=game->arena->GetLastQuad()->BounceVector(v,1.0f);
			return 0;
			break;
		case PARTICLE_BOUNCE_SLIDE:
			return 0;
			break;
		default:
		case PARTICLE_BOUNCE_NONE:
			s=game->arena->GetLastQuad()->PlaneIntersectionPoint(s,s+v*game->dtf);
			return 1;
			break;
		}
	}
	}
	return 0;
}

