#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include "chain.h"
#include "filedb.h"

#ifdef DEBUG
void dump_list(element *filechain)
{
element *e;
int i=0;

e=head(filechain);

while (e->next!=NULL)
 {
  i++;
  e=e->next;
  printf("Chaindump[%d] : %s\n", i, ((fileent *)e->cur)->name);
 }
}
#endif 

int strcomp(char *s1, char *s2)
{
int i,r;

r=0;
i=strlen(s1);
i=strlen(s2)<i?strlen(s2):i;

while ((*s1==*s2) && (i>0))
 {
  s1++;
  s2++;
  i--;
 }

if (*s1>*s2)
 r=1;
else
 if (*s2>*s1)
  r=-1;

return(r);
}

void addfile(char *s, element *filechain)
{
int i;
element *e=head(filechain);
fileent ent;
struct stat buf;

if (stat(s, &buf)==0)
{
 ent.name=(char *)strdup(s);
 ent.mtime=buf.st_mtime;
 ent.size=buf.st_size;
 ent.wasmod=1;
 while (e->next!=NULL)
  {
   i=strcomp(((fileent *)e->next->cur)->name,s);
   if ((i>0))
    {
     break;
    }
   e=e->next;
  }

 filechain=addelement(&ent,sizeof(ent),e);
 #ifdef DEBUG
  printf("Seems i have added successfully %s\n", s);
  dump_list(e); 
 #endif
} else
 {
  #ifdef DEBUG
   printf("Could'nt stat %s !\n");
  #endif 
 }
}

element *findfile(char *s, element *filechain)
{
element *r=head(filechain);
int i;

#ifdef DEBUG
printf("findfile called!!!\n");
#endif
while (r->next!=NULL)
{
 r=r->next; 
 if (r->cur!=NULL)
 {
  i=strcomp(((fileent *)r->cur)->name,s);
  #ifdef DEBUG
   printf("comparing '%s' and '%s'... i=%d\n", ((fileent *)r->cur)->name,s, i);
  #endif
  if (i>=0)
   break;
 }  
}

#ifdef DEBUG
printf("finished!!!\n");
#endif
return(i==0?r:NULL);
}

element *removefile(element *e, element *filechain)
{

free(((fileent *)e->cur)->name);
filechain=unchain(e);

return(filechain);
}

element *scanchain(element *filechain)
{
element *e=head(filechain);
fileent *f=NULL;
struct stat buf;

 while (e->next!=NULL)
  {
   if (e->cur!=NULL)
    {
     f=(fileent *)e->cur;
     if (stat(f->name, &buf)!=0)
      {
       #ifdef DEBUG
        printf("File '%s' ceased to exit.. RIP\n", f->name);
       #endif
       e=head(unchain(e));
      }
    }
   e=e->next;
  }

 return(e);
}

void killfilechain(element *c)
{
c=head(c);
while (c->next!=NULL)
{
 if (c!=NULL)
 {
  if (c->cur!=NULL)
   free(((fileent *)c->cur)->name);
//  free(c->cur);
 } 
 c=unchain(c);
} 
 
}

int checkfile(char *s, int run, element *filechain)
{
int r;
struct stat buf;
element *e=findfile(s, filechain);
fileent *fe;

fe=(e!=NULL)?((fileent *)e->cur):NULL;

#ifdef DEBUG
 printf("checkfile(s='%s', run=%d, filechain) called..\n", s, run);
#endif

if (stat(s, &buf)==0)
 {
  if (e!=NULL)
  { 
   fe->lastrun=run;
   if (buf.st_mtime>fe->mtime) 
   {
    r=1;
    fe->mtime=buf.st_mtime;
    fe->size=buf.st_size;
    fe->wasmod=1;
   } 
   else
   {
    if (fe->wasmod==1)
    { 
     r=2;
    } else 
    {
     r=0;
    } 
    fe->wasmod=0;
   } 

  } else
  { 
   r=-1;
   #ifdef DEBUG
   printf("calling addfile('%s', filechain)...\n", s);
   #endif
   addfile(s, filechain);
   
  }
 } else
 {
  r=-2;
  removefile(e, filechain);
 }

#ifdef DEBUG
 printf("returned %d\n", r);
#endif
return(r);
}
