package security

import (
    i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e "time"
    i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91 "github.com/microsoft/kiota-abstractions-go/serialization"
    iadcd81124412c61e647227ecfc4449d8bba17de0380ddda76f641a29edf2b242 "github.com/microsoftgraph/msgraph-sdk-go/models"
)

// Vulnerability 
type Vulnerability struct {
    iadcd81124412c61e647227ecfc4449d8bba17de0380ddda76f641a29edf2b242.Entity
}
// NewVulnerability instantiates a new vulnerability and sets the default values.
func NewVulnerability()(*Vulnerability) {
    m := &Vulnerability{
        Entity: *iadcd81124412c61e647227ecfc4449d8bba17de0380ddda76f641a29edf2b242.NewEntity(),
    }
    return m
}
// CreateVulnerabilityFromDiscriminatorValue creates a new instance of the appropriate class based on discriminator value
func CreateVulnerabilityFromDiscriminatorValue(parseNode i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode)(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, error) {
    return NewVulnerability(), nil
}
// GetActiveExploitsObserved gets the activeExploitsObserved property value. Indicates whether this vulnerability has any known exploits associated to known bad actors.
func (m *Vulnerability) GetActiveExploitsObserved()(*bool) {
    val, err := m.GetBackingStore().Get("activeExploitsObserved")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*bool)
    }
    return nil
}
// GetArticles gets the articles property value. Articles related to this vulnerability.
func (m *Vulnerability) GetArticles()([]Articleable) {
    val, err := m.GetBackingStore().Get("articles")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]Articleable)
    }
    return nil
}
// GetCommonWeaknessEnumerationIds gets the commonWeaknessEnumerationIds property value. Community-defined common weakness enumerations (CWE).
func (m *Vulnerability) GetCommonWeaknessEnumerationIds()([]string) {
    val, err := m.GetBackingStore().Get("commonWeaknessEnumerationIds")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]string)
    }
    return nil
}
// GetComponents gets the components property value. Components related to this vulnerability article.
func (m *Vulnerability) GetComponents()([]VulnerabilityComponentable) {
    val, err := m.GetBackingStore().Get("components")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]VulnerabilityComponentable)
    }
    return nil
}
// GetCreatedDateTime gets the createdDateTime property value. The date and time when this vulnerability article was first created.
func (m *Vulnerability) GetCreatedDateTime()(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time) {
    val, err := m.GetBackingStore().Get("createdDateTime")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)
    }
    return nil
}
// GetCvss2Summary gets the cvss2Summary property value. The cvss2Summary property
func (m *Vulnerability) GetCvss2Summary()(CvssSummaryable) {
    val, err := m.GetBackingStore().Get("cvss2Summary")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(CvssSummaryable)
    }
    return nil
}
// GetCvss3Summary gets the cvss3Summary property value. The cvss3Summary property
func (m *Vulnerability) GetCvss3Summary()(CvssSummaryable) {
    val, err := m.GetBackingStore().Get("cvss3Summary")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(CvssSummaryable)
    }
    return nil
}
// GetDescription gets the description property value. The description property
func (m *Vulnerability) GetDescription()(FormattedContentable) {
    val, err := m.GetBackingStore().Get("description")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(FormattedContentable)
    }
    return nil
}
// GetExploits gets the exploits property value. Known exploits for this vulnerability.
func (m *Vulnerability) GetExploits()([]Hyperlinkable) {
    val, err := m.GetBackingStore().Get("exploits")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]Hyperlinkable)
    }
    return nil
}
// GetExploitsAvailable gets the exploitsAvailable property value. Indicates whether this vulnerability has exploits in public sources (such as Packetstorm or Exploit-DB) online.
func (m *Vulnerability) GetExploitsAvailable()(*bool) {
    val, err := m.GetBackingStore().Get("exploitsAvailable")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*bool)
    }
    return nil
}
// GetFieldDeserializers the deserialization information for the current model
func (m *Vulnerability) GetFieldDeserializers()(map[string]func(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode)(error)) {
    res := m.Entity.GetFieldDeserializers()
    res["activeExploitsObserved"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetBoolValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetActiveExploitsObserved(val)
        }
        return nil
    }
    res["articles"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfObjectValues(CreateArticleFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]Articleable, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = v.(Articleable)
                }
            }
            m.SetArticles(res)
        }
        return nil
    }
    res["commonWeaknessEnumerationIds"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfPrimitiveValues("string")
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]string, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = *(v.(*string))
                }
            }
            m.SetCommonWeaknessEnumerationIds(res)
        }
        return nil
    }
    res["components"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfObjectValues(CreateVulnerabilityComponentFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]VulnerabilityComponentable, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = v.(VulnerabilityComponentable)
                }
            }
            m.SetComponents(res)
        }
        return nil
    }
    res["createdDateTime"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetTimeValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetCreatedDateTime(val)
        }
        return nil
    }
    res["cvss2Summary"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetObjectValue(CreateCvssSummaryFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            m.SetCvss2Summary(val.(CvssSummaryable))
        }
        return nil
    }
    res["cvss3Summary"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetObjectValue(CreateCvssSummaryFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            m.SetCvss3Summary(val.(CvssSummaryable))
        }
        return nil
    }
    res["description"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetObjectValue(CreateFormattedContentFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            m.SetDescription(val.(FormattedContentable))
        }
        return nil
    }
    res["exploits"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfObjectValues(CreateHyperlinkFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]Hyperlinkable, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = v.(Hyperlinkable)
                }
            }
            m.SetExploits(res)
        }
        return nil
    }
    res["exploitsAvailable"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetBoolValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetExploitsAvailable(val)
        }
        return nil
    }
    res["hasChatter"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetBoolValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetHasChatter(val)
        }
        return nil
    }
    res["lastModifiedDateTime"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetTimeValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetLastModifiedDateTime(val)
        }
        return nil
    }
    res["priorityScore"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetInt32Value()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetPriorityScore(val)
        }
        return nil
    }
    res["publishedDateTime"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetTimeValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetPublishedDateTime(val)
        }
        return nil
    }
    res["references"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfObjectValues(CreateHyperlinkFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]Hyperlinkable, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = v.(Hyperlinkable)
                }
            }
            m.SetReferences(res)
        }
        return nil
    }
    res["remediation"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetObjectValue(CreateFormattedContentFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            m.SetRemediation(val.(FormattedContentable))
        }
        return nil
    }
    res["severity"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetEnumValue(ParseVulnerabilitySeverity)
        if err != nil {
            return err
        }
        if val != nil {
            m.SetSeverity(val.(*VulnerabilitySeverity))
        }
        return nil
    }
    return res
}
// GetHasChatter gets the hasChatter property value. Indicates whether chatter about this vulnerability has been discovered online.
func (m *Vulnerability) GetHasChatter()(*bool) {
    val, err := m.GetBackingStore().Get("hasChatter")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*bool)
    }
    return nil
}
// GetLastModifiedDateTime gets the lastModifiedDateTime property value. The date and time when this vulnerability article was most recently updated.
func (m *Vulnerability) GetLastModifiedDateTime()(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time) {
    val, err := m.GetBackingStore().Get("lastModifiedDateTime")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)
    }
    return nil
}
// GetPriorityScore gets the priorityScore property value. A unique algorithm that reflects the priority of a vulnerability based on the CVSS score, exploits, chatter, and linkage to malware. This property also evaluates the recency of these components so users can understand which vulnerability should be remediated first.
func (m *Vulnerability) GetPriorityScore()(*int32) {
    val, err := m.GetBackingStore().Get("priorityScore")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*int32)
    }
    return nil
}
// GetPublishedDateTime gets the publishedDateTime property value. The date and time when this vulnerability article was published.
func (m *Vulnerability) GetPublishedDateTime()(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time) {
    val, err := m.GetBackingStore().Get("publishedDateTime")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)
    }
    return nil
}
// GetReferences gets the references property value. Reference links where further information can be learned about this vulnerability.
func (m *Vulnerability) GetReferences()([]Hyperlinkable) {
    val, err := m.GetBackingStore().Get("references")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]Hyperlinkable)
    }
    return nil
}
// GetRemediation gets the remediation property value. Any known remediation steps.
func (m *Vulnerability) GetRemediation()(FormattedContentable) {
    val, err := m.GetBackingStore().Get("remediation")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(FormattedContentable)
    }
    return nil
}
// GetSeverity gets the severity property value. The severity property
func (m *Vulnerability) GetSeverity()(*VulnerabilitySeverity) {
    val, err := m.GetBackingStore().Get("severity")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*VulnerabilitySeverity)
    }
    return nil
}
// Serialize serializes information the current object
func (m *Vulnerability) Serialize(writer i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.SerializationWriter)(error) {
    err := m.Entity.Serialize(writer)
    if err != nil {
        return err
    }
    {
        err = writer.WriteBoolValue("activeExploitsObserved", m.GetActiveExploitsObserved())
        if err != nil {
            return err
        }
    }
    if m.GetArticles() != nil {
        cast := make([]i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, len(m.GetArticles()))
        for i, v := range m.GetArticles() {
            if v != nil {
                cast[i] = v.(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable)
            }
        }
        err = writer.WriteCollectionOfObjectValues("articles", cast)
        if err != nil {
            return err
        }
    }
    if m.GetCommonWeaknessEnumerationIds() != nil {
        err = writer.WriteCollectionOfStringValues("commonWeaknessEnumerationIds", m.GetCommonWeaknessEnumerationIds())
        if err != nil {
            return err
        }
    }
    if m.GetComponents() != nil {
        cast := make([]i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, len(m.GetComponents()))
        for i, v := range m.GetComponents() {
            if v != nil {
                cast[i] = v.(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable)
            }
        }
        err = writer.WriteCollectionOfObjectValues("components", cast)
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteTimeValue("createdDateTime", m.GetCreatedDateTime())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteObjectValue("cvss2Summary", m.GetCvss2Summary())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteObjectValue("cvss3Summary", m.GetCvss3Summary())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteObjectValue("description", m.GetDescription())
        if err != nil {
            return err
        }
    }
    if m.GetExploits() != nil {
        cast := make([]i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, len(m.GetExploits()))
        for i, v := range m.GetExploits() {
            if v != nil {
                cast[i] = v.(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable)
            }
        }
        err = writer.WriteCollectionOfObjectValues("exploits", cast)
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteBoolValue("exploitsAvailable", m.GetExploitsAvailable())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteBoolValue("hasChatter", m.GetHasChatter())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteTimeValue("lastModifiedDateTime", m.GetLastModifiedDateTime())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteInt32Value("priorityScore", m.GetPriorityScore())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteTimeValue("publishedDateTime", m.GetPublishedDateTime())
        if err != nil {
            return err
        }
    }
    if m.GetReferences() != nil {
        cast := make([]i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, len(m.GetReferences()))
        for i, v := range m.GetReferences() {
            if v != nil {
                cast[i] = v.(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable)
            }
        }
        err = writer.WriteCollectionOfObjectValues("references", cast)
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteObjectValue("remediation", m.GetRemediation())
        if err != nil {
            return err
        }
    }
    if m.GetSeverity() != nil {
        cast := (*m.GetSeverity()).String()
        err = writer.WriteStringValue("severity", &cast)
        if err != nil {
            return err
        }
    }
    return nil
}
// SetActiveExploitsObserved sets the activeExploitsObserved property value. Indicates whether this vulnerability has any known exploits associated to known bad actors.
func (m *Vulnerability) SetActiveExploitsObserved(value *bool)() {
    err := m.GetBackingStore().Set("activeExploitsObserved", value)
    if err != nil {
        panic(err)
    }
}
// SetArticles sets the articles property value. Articles related to this vulnerability.
func (m *Vulnerability) SetArticles(value []Articleable)() {
    err := m.GetBackingStore().Set("articles", value)
    if err != nil {
        panic(err)
    }
}
// SetCommonWeaknessEnumerationIds sets the commonWeaknessEnumerationIds property value. Community-defined common weakness enumerations (CWE).
func (m *Vulnerability) SetCommonWeaknessEnumerationIds(value []string)() {
    err := m.GetBackingStore().Set("commonWeaknessEnumerationIds", value)
    if err != nil {
        panic(err)
    }
}
// SetComponents sets the components property value. Components related to this vulnerability article.
func (m *Vulnerability) SetComponents(value []VulnerabilityComponentable)() {
    err := m.GetBackingStore().Set("components", value)
    if err != nil {
        panic(err)
    }
}
// SetCreatedDateTime sets the createdDateTime property value. The date and time when this vulnerability article was first created.
func (m *Vulnerability) SetCreatedDateTime(value *i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)() {
    err := m.GetBackingStore().Set("createdDateTime", value)
    if err != nil {
        panic(err)
    }
}
// SetCvss2Summary sets the cvss2Summary property value. The cvss2Summary property
func (m *Vulnerability) SetCvss2Summary(value CvssSummaryable)() {
    err := m.GetBackingStore().Set("cvss2Summary", value)
    if err != nil {
        panic(err)
    }
}
// SetCvss3Summary sets the cvss3Summary property value. The cvss3Summary property
func (m *Vulnerability) SetCvss3Summary(value CvssSummaryable)() {
    err := m.GetBackingStore().Set("cvss3Summary", value)
    if err != nil {
        panic(err)
    }
}
// SetDescription sets the description property value. The description property
func (m *Vulnerability) SetDescription(value FormattedContentable)() {
    err := m.GetBackingStore().Set("description", value)
    if err != nil {
        panic(err)
    }
}
// SetExploits sets the exploits property value. Known exploits for this vulnerability.
func (m *Vulnerability) SetExploits(value []Hyperlinkable)() {
    err := m.GetBackingStore().Set("exploits", value)
    if err != nil {
        panic(err)
    }
}
// SetExploitsAvailable sets the exploitsAvailable property value. Indicates whether this vulnerability has exploits in public sources (such as Packetstorm or Exploit-DB) online.
func (m *Vulnerability) SetExploitsAvailable(value *bool)() {
    err := m.GetBackingStore().Set("exploitsAvailable", value)
    if err != nil {
        panic(err)
    }
}
// SetHasChatter sets the hasChatter property value. Indicates whether chatter about this vulnerability has been discovered online.
func (m *Vulnerability) SetHasChatter(value *bool)() {
    err := m.GetBackingStore().Set("hasChatter", value)
    if err != nil {
        panic(err)
    }
}
// SetLastModifiedDateTime sets the lastModifiedDateTime property value. The date and time when this vulnerability article was most recently updated.
func (m *Vulnerability) SetLastModifiedDateTime(value *i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)() {
    err := m.GetBackingStore().Set("lastModifiedDateTime", value)
    if err != nil {
        panic(err)
    }
}
// SetPriorityScore sets the priorityScore property value. A unique algorithm that reflects the priority of a vulnerability based on the CVSS score, exploits, chatter, and linkage to malware. This property also evaluates the recency of these components so users can understand which vulnerability should be remediated first.
func (m *Vulnerability) SetPriorityScore(value *int32)() {
    err := m.GetBackingStore().Set("priorityScore", value)
    if err != nil {
        panic(err)
    }
}
// SetPublishedDateTime sets the publishedDateTime property value. The date and time when this vulnerability article was published.
func (m *Vulnerability) SetPublishedDateTime(value *i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)() {
    err := m.GetBackingStore().Set("publishedDateTime", value)
    if err != nil {
        panic(err)
    }
}
// SetReferences sets the references property value. Reference links where further information can be learned about this vulnerability.
func (m *Vulnerability) SetReferences(value []Hyperlinkable)() {
    err := m.GetBackingStore().Set("references", value)
    if err != nil {
        panic(err)
    }
}
// SetRemediation sets the remediation property value. Any known remediation steps.
func (m *Vulnerability) SetRemediation(value FormattedContentable)() {
    err := m.GetBackingStore().Set("remediation", value)
    if err != nil {
        panic(err)
    }
}
// SetSeverity sets the severity property value. The severity property
func (m *Vulnerability) SetSeverity(value *VulnerabilitySeverity)() {
    err := m.GetBackingStore().Set("severity", value)
    if err != nil {
        panic(err)
    }
}
// Vulnerabilityable 
type Vulnerabilityable interface {
    iadcd81124412c61e647227ecfc4449d8bba17de0380ddda76f641a29edf2b242.Entityable
    i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable
    GetActiveExploitsObserved()(*bool)
    GetArticles()([]Articleable)
    GetCommonWeaknessEnumerationIds()([]string)
    GetComponents()([]VulnerabilityComponentable)
    GetCreatedDateTime()(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)
    GetCvss2Summary()(CvssSummaryable)
    GetCvss3Summary()(CvssSummaryable)
    GetDescription()(FormattedContentable)
    GetExploits()([]Hyperlinkable)
    GetExploitsAvailable()(*bool)
    GetHasChatter()(*bool)
    GetLastModifiedDateTime()(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)
    GetPriorityScore()(*int32)
    GetPublishedDateTime()(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)
    GetReferences()([]Hyperlinkable)
    GetRemediation()(FormattedContentable)
    GetSeverity()(*VulnerabilitySeverity)
    SetActiveExploitsObserved(value *bool)()
    SetArticles(value []Articleable)()
    SetCommonWeaknessEnumerationIds(value []string)()
    SetComponents(value []VulnerabilityComponentable)()
    SetCreatedDateTime(value *i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)()
    SetCvss2Summary(value CvssSummaryable)()
    SetCvss3Summary(value CvssSummaryable)()
    SetDescription(value FormattedContentable)()
    SetExploits(value []Hyperlinkable)()
    SetExploitsAvailable(value *bool)()
    SetHasChatter(value *bool)()
    SetLastModifiedDateTime(value *i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)()
    SetPriorityScore(value *int32)()
    SetPublishedDateTime(value *i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)()
    SetReferences(value []Hyperlinkable)()
    SetRemediation(value FormattedContentable)()
    SetSeverity(value *VulnerabilitySeverity)()
}
