//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSTableViewDropOperation(pub NSUInteger);
impl NSTableViewDropOperation {
    pub const NSTableViewDropOn: Self = Self(0);
    pub const NSTableViewDropAbove: Self = Self(1);
}

unsafe impl Encode for NSTableViewDropOperation {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSTableViewDropOperation {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSTableViewColumnAutoresizingStyle(pub NSUInteger);
impl NSTableViewColumnAutoresizingStyle {
    pub const NSTableViewNoColumnAutoresizing: Self = Self(0);
    pub const NSTableViewUniformColumnAutoresizingStyle: Self = Self(1);
    pub const NSTableViewSequentialColumnAutoresizingStyle: Self = Self(2);
    pub const NSTableViewReverseSequentialColumnAutoresizingStyle: Self = Self(3);
    pub const NSTableViewLastColumnOnlyAutoresizingStyle: Self = Self(4);
    pub const NSTableViewFirstColumnOnlyAutoresizingStyle: Self = Self(5);
}

unsafe impl Encode for NSTableViewColumnAutoresizingStyle {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSTableViewColumnAutoresizingStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSTableViewGridLineStyle(pub NSUInteger);
bitflags::bitflags! {
    impl NSTableViewGridLineStyle: NSUInteger {
        const NSTableViewGridNone = 0;
        const NSTableViewSolidVerticalGridLineMask = 1<<0;
        const NSTableViewSolidHorizontalGridLineMask = 1<<1;
        const NSTableViewDashedHorizontalGridLineMask = 1<<3;
    }
}

unsafe impl Encode for NSTableViewGridLineStyle {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSTableViewGridLineStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSTableViewRowSizeStyle(pub NSInteger);
impl NSTableViewRowSizeStyle {
    #[doc(alias = "NSTableViewRowSizeStyleDefault")]
    pub const Default: Self = Self(-1);
    #[doc(alias = "NSTableViewRowSizeStyleCustom")]
    pub const Custom: Self = Self(0);
    #[doc(alias = "NSTableViewRowSizeStyleSmall")]
    pub const Small: Self = Self(1);
    #[doc(alias = "NSTableViewRowSizeStyleMedium")]
    pub const Medium: Self = Self(2);
    #[doc(alias = "NSTableViewRowSizeStyleLarge")]
    pub const Large: Self = Self(3);
}

unsafe impl Encode for NSTableViewRowSizeStyle {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSTableViewRowSizeStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSTableViewStyle(pub NSInteger);
impl NSTableViewStyle {
    #[doc(alias = "NSTableViewStyleAutomatic")]
    pub const Automatic: Self = Self(0);
    #[doc(alias = "NSTableViewStyleFullWidth")]
    pub const FullWidth: Self = Self(1);
    #[doc(alias = "NSTableViewStyleInset")]
    pub const Inset: Self = Self(2);
    #[doc(alias = "NSTableViewStyleSourceList")]
    pub const SourceList: Self = Self(3);
    #[doc(alias = "NSTableViewStylePlain")]
    pub const Plain: Self = Self(4);
}

unsafe impl Encode for NSTableViewStyle {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSTableViewStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSTableViewSelectionHighlightStyle(pub NSInteger);
impl NSTableViewSelectionHighlightStyle {
    #[doc(alias = "NSTableViewSelectionHighlightStyleNone")]
    pub const None: Self = Self(-1);
    #[doc(alias = "NSTableViewSelectionHighlightStyleRegular")]
    pub const Regular: Self = Self(0);
    #[deprecated = "Set the NSTableView.style property to NSTableViewStyleSourceList instead."]
    #[doc(alias = "NSTableViewSelectionHighlightStyleSourceList")]
    pub const SourceList: Self = Self(1);
}

unsafe impl Encode for NSTableViewSelectionHighlightStyle {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSTableViewSelectionHighlightStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSTableViewDraggingDestinationFeedbackStyle(pub NSInteger);
impl NSTableViewDraggingDestinationFeedbackStyle {
    #[doc(alias = "NSTableViewDraggingDestinationFeedbackStyleNone")]
    pub const None: Self = Self(-1);
    #[doc(alias = "NSTableViewDraggingDestinationFeedbackStyleRegular")]
    pub const Regular: Self = Self(0);
    #[doc(alias = "NSTableViewDraggingDestinationFeedbackStyleSourceList")]
    pub const SourceList: Self = Self(1);
    #[doc(alias = "NSTableViewDraggingDestinationFeedbackStyleGap")]
    pub const Gap: Self = Self(2);
}

unsafe impl Encode for NSTableViewDraggingDestinationFeedbackStyle {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSTableViewDraggingDestinationFeedbackStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSTableRowActionEdge(pub NSInteger);
impl NSTableRowActionEdge {
    #[doc(alias = "NSTableRowActionEdgeLeading")]
    pub const Leading: Self = Self(0);
    #[doc(alias = "NSTableRowActionEdgeTrailing")]
    pub const Trailing: Self = Self(1);
}

unsafe impl Encode for NSTableRowActionEdge {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSTableRowActionEdge {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

pub type NSTableViewAutosaveName = NSString;

// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSTableViewAnimationOptions(pub NSUInteger);
bitflags::bitflags! {
    impl NSTableViewAnimationOptions: NSUInteger {
        const NSTableViewAnimationEffectNone = 0x0;
        const NSTableViewAnimationEffectFade = 0x1;
        const NSTableViewAnimationEffectGap = 0x2;
        const NSTableViewAnimationSlideUp = 0x10;
        const NSTableViewAnimationSlideDown = 0x20;
        const NSTableViewAnimationSlideLeft = 0x30;
        const NSTableViewAnimationSlideRight = 0x40;
    }
}

unsafe impl Encode for NSTableViewAnimationOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSTableViewAnimationOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
    pub struct NSTableView;

    #[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
    unsafe impl ClassType for NSTableView {
        #[inherits(NSView, NSResponder, NSObject)]
        type Super = NSControl;
        type Mutability = MainThreadOnly;
    }
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
unsafe impl NSAccessibility for NSTableView {}

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
unsafe impl NSAccessibilityElementProtocol for NSTableView {}

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
unsafe impl NSAccessibilityGroup for NSTableView {}

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
unsafe impl NSAccessibilityTable for NSTableView {}

#[cfg(all(
    feature = "NSAnimation",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
unsafe impl NSAnimatablePropertyContainer for NSTableView {}

#[cfg(all(
    feature = "NSAppearance",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
unsafe impl NSAppearanceCustomization for NSTableView {}

#[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
unsafe impl NSCoding for NSTableView {}

#[cfg(all(
    feature = "NSControl",
    feature = "NSDragging",
    feature = "NSResponder",
    feature = "NSView"
))]
unsafe impl NSDraggingDestination for NSTableView {}

#[cfg(all(
    feature = "NSControl",
    feature = "NSDragging",
    feature = "NSResponder",
    feature = "NSView"
))]
unsafe impl NSDraggingSource for NSTableView {}

#[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
unsafe impl NSObjectProtocol for NSTableView {}

#[cfg(all(
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSText",
    feature = "NSView"
))]
unsafe impl NSTextDelegate for NSTableView {}

#[cfg(all(
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSText",
    feature = "NSTextView",
    feature = "NSView"
))]
unsafe impl NSTextViewDelegate for NSTableView {}

#[cfg(all(
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSUserInterfaceItemIdentification",
    feature = "NSView"
))]
unsafe impl NSUserInterfaceItemIdentification for NSTableView {}

#[cfg(all(
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSUserInterfaceValidation",
    feature = "NSView"
))]
unsafe impl NSUserInterfaceValidations for NSTableView {}

extern_methods!(
    #[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
    unsafe impl NSTableView {
        #[method_id(@__retain_semantics Init initWithFrame:)]
        pub unsafe fn initWithFrame(this: Allocated<Self>, frame_rect: NSRect) -> Retained<Self>;

        #[method_id(@__retain_semantics Init initWithCoder:)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[method_id(@__retain_semantics Other dataSource)]
        pub unsafe fn dataSource(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn NSTableViewDataSource>>>;

        #[method(setDataSource:)]
        pub unsafe fn setDataSource(
            &self,
            data_source: Option<&ProtocolObject<dyn NSTableViewDataSource>>,
        );

        #[method_id(@__retain_semantics Other delegate)]
        pub unsafe fn delegate(&self) -> Option<Retained<ProtocolObject<dyn NSTableViewDelegate>>>;

        #[method(setDelegate:)]
        pub unsafe fn setDelegate(
            &self,
            delegate: Option<&ProtocolObject<dyn NSTableViewDelegate>>,
        );

        #[cfg(feature = "NSTableHeaderView")]
        #[method_id(@__retain_semantics Other headerView)]
        pub unsafe fn headerView(&self) -> Option<Retained<NSTableHeaderView>>;

        #[cfg(feature = "NSTableHeaderView")]
        #[method(setHeaderView:)]
        pub unsafe fn setHeaderView(&self, header_view: Option<&NSTableHeaderView>);

        #[method_id(@__retain_semantics Other cornerView)]
        pub unsafe fn cornerView(&self) -> Option<Retained<NSView>>;

        #[method(setCornerView:)]
        pub unsafe fn setCornerView(&self, corner_view: Option<&NSView>);

        #[method(allowsColumnReordering)]
        pub unsafe fn allowsColumnReordering(&self) -> bool;

        #[method(setAllowsColumnReordering:)]
        pub unsafe fn setAllowsColumnReordering(&self, allows_column_reordering: bool);

        #[method(allowsColumnResizing)]
        pub unsafe fn allowsColumnResizing(&self) -> bool;

        #[method(setAllowsColumnResizing:)]
        pub unsafe fn setAllowsColumnResizing(&self, allows_column_resizing: bool);

        #[method(columnAutoresizingStyle)]
        pub unsafe fn columnAutoresizingStyle(&self) -> NSTableViewColumnAutoresizingStyle;

        #[method(setColumnAutoresizingStyle:)]
        pub unsafe fn setColumnAutoresizingStyle(
            &self,
            column_autoresizing_style: NSTableViewColumnAutoresizingStyle,
        );

        #[method(gridStyleMask)]
        pub unsafe fn gridStyleMask(&self) -> NSTableViewGridLineStyle;

        #[method(setGridStyleMask:)]
        pub unsafe fn setGridStyleMask(&self, grid_style_mask: NSTableViewGridLineStyle);

        #[method(intercellSpacing)]
        pub unsafe fn intercellSpacing(&self) -> NSSize;

        #[method(setIntercellSpacing:)]
        pub unsafe fn setIntercellSpacing(&self, intercell_spacing: NSSize);

        #[method(usesAlternatingRowBackgroundColors)]
        pub unsafe fn usesAlternatingRowBackgroundColors(&self) -> bool;

        #[method(setUsesAlternatingRowBackgroundColors:)]
        pub unsafe fn setUsesAlternatingRowBackgroundColors(
            &self,
            uses_alternating_row_background_colors: bool,
        );

        #[cfg(feature = "NSColor")]
        #[method_id(@__retain_semantics Other backgroundColor)]
        pub unsafe fn backgroundColor(&self) -> Retained<NSColor>;

        #[cfg(feature = "NSColor")]
        #[method(setBackgroundColor:)]
        pub unsafe fn setBackgroundColor(&self, background_color: &NSColor);

        #[cfg(feature = "NSColor")]
        #[method_id(@__retain_semantics Other gridColor)]
        pub unsafe fn gridColor(&self) -> Retained<NSColor>;

        #[cfg(feature = "NSColor")]
        #[method(setGridColor:)]
        pub unsafe fn setGridColor(&self, grid_color: &NSColor);

        #[method(rowSizeStyle)]
        pub unsafe fn rowSizeStyle(&self) -> NSTableViewRowSizeStyle;

        #[method(setRowSizeStyle:)]
        pub unsafe fn setRowSizeStyle(&self, row_size_style: NSTableViewRowSizeStyle);

        #[method(effectiveRowSizeStyle)]
        pub unsafe fn effectiveRowSizeStyle(&self) -> NSTableViewRowSizeStyle;

        #[method(rowHeight)]
        pub unsafe fn rowHeight(&self) -> CGFloat;

        #[method(setRowHeight:)]
        pub unsafe fn setRowHeight(&self, row_height: CGFloat);

        #[method(noteHeightOfRowsWithIndexesChanged:)]
        pub unsafe fn noteHeightOfRowsWithIndexesChanged(&self, index_set: &NSIndexSet);

        #[cfg(feature = "NSTableColumn")]
        #[method_id(@__retain_semantics Other tableColumns)]
        pub unsafe fn tableColumns(&self) -> Retained<NSArray<NSTableColumn>>;

        #[method(numberOfColumns)]
        pub unsafe fn numberOfColumns(&self) -> NSInteger;

        #[method(numberOfRows)]
        pub unsafe fn numberOfRows(&self) -> NSInteger;

        #[cfg(feature = "NSTableColumn")]
        #[method(addTableColumn:)]
        pub unsafe fn addTableColumn(&self, table_column: &NSTableColumn);

        #[cfg(feature = "NSTableColumn")]
        #[method(removeTableColumn:)]
        pub unsafe fn removeTableColumn(&self, table_column: &NSTableColumn);

        #[method(moveColumn:toColumn:)]
        pub unsafe fn moveColumn_toColumn(&self, old_index: NSInteger, new_index: NSInteger);

        #[cfg(feature = "NSUserInterfaceItemIdentification")]
        #[method(columnWithIdentifier:)]
        pub unsafe fn columnWithIdentifier(
            &self,
            identifier: &NSUserInterfaceItemIdentifier,
        ) -> NSInteger;

        #[cfg(all(
            feature = "NSTableColumn",
            feature = "NSUserInterfaceItemIdentification"
        ))]
        #[method_id(@__retain_semantics Other tableColumnWithIdentifier:)]
        pub unsafe fn tableColumnWithIdentifier(
            &self,
            identifier: &NSUserInterfaceItemIdentifier,
        ) -> Option<Retained<NSTableColumn>>;

        #[method(tile)]
        pub unsafe fn tile(&self);

        #[method(sizeToFit)]
        pub unsafe fn sizeToFit(&self);

        #[method(sizeLastColumnToFit)]
        pub unsafe fn sizeLastColumnToFit(&self);

        #[method(scrollRowToVisible:)]
        pub unsafe fn scrollRowToVisible(&self, row: NSInteger);

        #[method(scrollColumnToVisible:)]
        pub unsafe fn scrollColumnToVisible(&self, column: NSInteger);

        #[method(reloadData)]
        pub unsafe fn reloadData(&self);

        #[method(noteNumberOfRowsChanged)]
        pub unsafe fn noteNumberOfRowsChanged(&self);

        #[method(reloadDataForRowIndexes:columnIndexes:)]
        pub unsafe fn reloadDataForRowIndexes_columnIndexes(
            &self,
            row_indexes: &NSIndexSet,
            column_indexes: &NSIndexSet,
        );

        #[method(editedColumn)]
        pub unsafe fn editedColumn(&self) -> NSInteger;

        #[method(editedRow)]
        pub unsafe fn editedRow(&self) -> NSInteger;

        #[method(clickedColumn)]
        pub unsafe fn clickedColumn(&self) -> NSInteger;

        #[method(clickedRow)]
        pub unsafe fn clickedRow(&self) -> NSInteger;

        #[method(doubleAction)]
        pub unsafe fn doubleAction(&self) -> Option<Sel>;

        #[method(setDoubleAction:)]
        pub unsafe fn setDoubleAction(&self, double_action: Option<Sel>);

        #[method_id(@__retain_semantics Other sortDescriptors)]
        pub unsafe fn sortDescriptors(&self) -> Retained<NSArray<NSSortDescriptor>>;

        #[method(setSortDescriptors:)]
        pub unsafe fn setSortDescriptors(&self, sort_descriptors: &NSArray<NSSortDescriptor>);

        #[cfg(all(feature = "NSImage", feature = "NSTableColumn"))]
        #[method(setIndicatorImage:inTableColumn:)]
        pub unsafe fn setIndicatorImage_inTableColumn(
            &self,
            image: Option<&NSImage>,
            table_column: &NSTableColumn,
        );

        #[cfg(all(feature = "NSImage", feature = "NSTableColumn"))]
        #[method_id(@__retain_semantics Other indicatorImageInTableColumn:)]
        pub unsafe fn indicatorImageInTableColumn(
            &self,
            table_column: &NSTableColumn,
        ) -> Option<Retained<NSImage>>;

        #[cfg(feature = "NSTableColumn")]
        #[method_id(@__retain_semantics Other highlightedTableColumn)]
        pub unsafe fn highlightedTableColumn(&self) -> Option<Retained<NSTableColumn>>;

        #[cfg(feature = "NSTableColumn")]
        #[method(setHighlightedTableColumn:)]
        pub unsafe fn setHighlightedTableColumn(
            &self,
            highlighted_table_column: Option<&NSTableColumn>,
        );

        #[method(verticalMotionCanBeginDrag)]
        pub unsafe fn verticalMotionCanBeginDrag(&self) -> bool;

        #[method(setVerticalMotionCanBeginDrag:)]
        pub unsafe fn setVerticalMotionCanBeginDrag(&self, vertical_motion_can_begin_drag: bool);

        #[method(canDragRowsWithIndexes:atPoint:)]
        pub unsafe fn canDragRowsWithIndexes_atPoint(
            &self,
            row_indexes: &NSIndexSet,
            mouse_down_point: NSPoint,
        ) -> bool;

        #[cfg(all(feature = "NSEvent", feature = "NSImage", feature = "NSTableColumn"))]
        #[method_id(@__retain_semantics Other dragImageForRowsWithIndexes:tableColumns:event:offset:)]
        pub unsafe fn dragImageForRowsWithIndexes_tableColumns_event_offset(
            &self,
            drag_rows: &NSIndexSet,
            table_columns: &NSArray<NSTableColumn>,
            drag_event: &NSEvent,
            drag_image_offset: NSPointPointer,
        ) -> Retained<NSImage>;

        #[cfg(feature = "NSDragging")]
        #[method(setDraggingSourceOperationMask:forLocal:)]
        pub unsafe fn setDraggingSourceOperationMask_forLocal(
            &self,
            mask: NSDragOperation,
            is_local: bool,
        );

        #[method(setDropRow:dropOperation:)]
        pub unsafe fn setDropRow_dropOperation(
            &self,
            row: NSInteger,
            drop_operation: NSTableViewDropOperation,
        );

        #[method(allowsMultipleSelection)]
        pub unsafe fn allowsMultipleSelection(&self) -> bool;

        #[method(setAllowsMultipleSelection:)]
        pub unsafe fn setAllowsMultipleSelection(&self, allows_multiple_selection: bool);

        #[method(allowsEmptySelection)]
        pub unsafe fn allowsEmptySelection(&self) -> bool;

        #[method(setAllowsEmptySelection:)]
        pub unsafe fn setAllowsEmptySelection(&self, allows_empty_selection: bool);

        #[method(allowsColumnSelection)]
        pub unsafe fn allowsColumnSelection(&self) -> bool;

        #[method(setAllowsColumnSelection:)]
        pub unsafe fn setAllowsColumnSelection(&self, allows_column_selection: bool);

        #[method(selectAll:)]
        pub unsafe fn selectAll(&self, sender: Option<&AnyObject>);

        #[method(deselectAll:)]
        pub unsafe fn deselectAll(&self, sender: Option<&AnyObject>);

        #[method(selectColumnIndexes:byExtendingSelection:)]
        pub unsafe fn selectColumnIndexes_byExtendingSelection(
            &self,
            indexes: &NSIndexSet,
            extend: bool,
        );

        #[method(selectRowIndexes:byExtendingSelection:)]
        pub unsafe fn selectRowIndexes_byExtendingSelection(
            &self,
            indexes: &NSIndexSet,
            extend: bool,
        );

        #[method_id(@__retain_semantics Other selectedColumnIndexes)]
        pub unsafe fn selectedColumnIndexes(&self) -> Retained<NSIndexSet>;

        #[method_id(@__retain_semantics Other selectedRowIndexes)]
        pub unsafe fn selectedRowIndexes(&self) -> Retained<NSIndexSet>;

        #[method(deselectColumn:)]
        pub unsafe fn deselectColumn(&self, column: NSInteger);

        #[method(deselectRow:)]
        pub unsafe fn deselectRow(&self, row: NSInteger);

        #[method(selectedColumn)]
        pub unsafe fn selectedColumn(&self) -> NSInteger;

        #[method(selectedRow)]
        pub unsafe fn selectedRow(&self) -> NSInteger;

        #[method(isColumnSelected:)]
        pub unsafe fn isColumnSelected(&self, column: NSInteger) -> bool;

        #[method(isRowSelected:)]
        pub unsafe fn isRowSelected(&self, row: NSInteger) -> bool;

        #[method(numberOfSelectedColumns)]
        pub unsafe fn numberOfSelectedColumns(&self) -> NSInteger;

        #[method(numberOfSelectedRows)]
        pub unsafe fn numberOfSelectedRows(&self) -> NSInteger;

        #[method(allowsTypeSelect)]
        pub unsafe fn allowsTypeSelect(&self) -> bool;

        #[method(setAllowsTypeSelect:)]
        pub unsafe fn setAllowsTypeSelect(&self, allows_type_select: bool);

        #[method(style)]
        pub unsafe fn style(&self) -> NSTableViewStyle;

        #[method(setStyle:)]
        pub unsafe fn setStyle(&self, style: NSTableViewStyle);

        #[method(effectiveStyle)]
        pub unsafe fn effectiveStyle(&self) -> NSTableViewStyle;

        #[method(selectionHighlightStyle)]
        pub unsafe fn selectionHighlightStyle(&self) -> NSTableViewSelectionHighlightStyle;

        #[method(setSelectionHighlightStyle:)]
        pub unsafe fn setSelectionHighlightStyle(
            &self,
            selection_highlight_style: NSTableViewSelectionHighlightStyle,
        );

        #[method(draggingDestinationFeedbackStyle)]
        pub unsafe fn draggingDestinationFeedbackStyle(
            &self,
        ) -> NSTableViewDraggingDestinationFeedbackStyle;

        #[method(setDraggingDestinationFeedbackStyle:)]
        pub unsafe fn setDraggingDestinationFeedbackStyle(
            &self,
            dragging_destination_feedback_style: NSTableViewDraggingDestinationFeedbackStyle,
        );

        #[method(rectOfColumn:)]
        pub unsafe fn rectOfColumn(&self, column: NSInteger) -> NSRect;

        #[method(rectOfRow:)]
        pub unsafe fn rectOfRow(&self, row: NSInteger) -> NSRect;

        #[method_id(@__retain_semantics Other columnIndexesInRect:)]
        pub unsafe fn columnIndexesInRect(&self, rect: NSRect) -> Retained<NSIndexSet>;

        #[method(rowsInRect:)]
        pub unsafe fn rowsInRect(&self, rect: NSRect) -> NSRange;

        #[method(columnAtPoint:)]
        pub unsafe fn columnAtPoint(&self, point: NSPoint) -> NSInteger;

        #[method(rowAtPoint:)]
        pub unsafe fn rowAtPoint(&self, point: NSPoint) -> NSInteger;

        #[method(frameOfCellAtColumn:row:)]
        pub unsafe fn frameOfCellAtColumn_row(&self, column: NSInteger, row: NSInteger) -> NSRect;

        #[method_id(@__retain_semantics Other autosaveName)]
        pub unsafe fn autosaveName(&self) -> Option<Retained<NSTableViewAutosaveName>>;

        #[method(setAutosaveName:)]
        pub unsafe fn setAutosaveName(&self, autosave_name: Option<&NSTableViewAutosaveName>);

        #[method(autosaveTableColumns)]
        pub unsafe fn autosaveTableColumns(&self) -> bool;

        #[method(setAutosaveTableColumns:)]
        pub unsafe fn setAutosaveTableColumns(&self, autosave_table_columns: bool);

        #[cfg(feature = "NSEvent")]
        #[method(editColumn:row:withEvent:select:)]
        pub unsafe fn editColumn_row_withEvent_select(
            &self,
            column: NSInteger,
            row: NSInteger,
            event: Option<&NSEvent>,
            select: bool,
        );

        #[method(drawRow:clipRect:)]
        pub unsafe fn drawRow_clipRect(&self, row: NSInteger, clip_rect: NSRect);

        #[method(highlightSelectionInClipRect:)]
        pub unsafe fn highlightSelectionInClipRect(&self, clip_rect: NSRect);

        #[method(drawGridInClipRect:)]
        pub unsafe fn drawGridInClipRect(&self, clip_rect: NSRect);

        #[method(drawBackgroundInClipRect:)]
        pub unsafe fn drawBackgroundInClipRect(&self, clip_rect: NSRect);

        #[method_id(@__retain_semantics Other viewAtColumn:row:makeIfNecessary:)]
        pub unsafe fn viewAtColumn_row_makeIfNecessary(
            &self,
            column: NSInteger,
            row: NSInteger,
            make_if_necessary: bool,
        ) -> Option<Retained<NSView>>;

        #[cfg(feature = "NSTableRowView")]
        #[method_id(@__retain_semantics Other rowViewAtRow:makeIfNecessary:)]
        pub unsafe fn rowViewAtRow_makeIfNecessary(
            &self,
            row: NSInteger,
            make_if_necessary: bool,
        ) -> Option<Retained<NSTableRowView>>;

        #[method(rowForView:)]
        pub unsafe fn rowForView(&self, view: &NSView) -> NSInteger;

        #[method(columnForView:)]
        pub unsafe fn columnForView(&self, view: &NSView) -> NSInteger;

        #[cfg(feature = "NSUserInterfaceItemIdentification")]
        #[method_id(@__retain_semantics Other makeViewWithIdentifier:owner:)]
        pub unsafe fn makeViewWithIdentifier_owner(
            &self,
            identifier: &NSUserInterfaceItemIdentifier,
            owner: Option<&AnyObject>,
        ) -> Option<Retained<NSView>>;

        #[cfg(all(feature = "NSTableRowView", feature = "block2"))]
        #[method(enumerateAvailableRowViewsUsingBlock:)]
        pub unsafe fn enumerateAvailableRowViewsUsingBlock(
            &self,
            handler: &block2::Block<dyn Fn(NonNull<NSTableRowView>, NSInteger) + '_>,
        );

        #[method(floatsGroupRows)]
        pub unsafe fn floatsGroupRows(&self) -> bool;

        #[method(setFloatsGroupRows:)]
        pub unsafe fn setFloatsGroupRows(&self, floats_group_rows: bool);

        #[method(rowActionsVisible)]
        pub unsafe fn rowActionsVisible(&self) -> bool;

        #[method(setRowActionsVisible:)]
        pub unsafe fn setRowActionsVisible(&self, row_actions_visible: bool);

        #[method(beginUpdates)]
        pub unsafe fn beginUpdates(&self);

        #[method(endUpdates)]
        pub unsafe fn endUpdates(&self);

        #[method(insertRowsAtIndexes:withAnimation:)]
        pub unsafe fn insertRowsAtIndexes_withAnimation(
            &self,
            indexes: &NSIndexSet,
            animation_options: NSTableViewAnimationOptions,
        );

        #[method(removeRowsAtIndexes:withAnimation:)]
        pub unsafe fn removeRowsAtIndexes_withAnimation(
            &self,
            indexes: &NSIndexSet,
            animation_options: NSTableViewAnimationOptions,
        );

        #[method(moveRowAtIndex:toIndex:)]
        pub unsafe fn moveRowAtIndex_toIndex(&self, old_index: NSInteger, new_index: NSInteger);

        #[method(hideRowsAtIndexes:withAnimation:)]
        pub unsafe fn hideRowsAtIndexes_withAnimation(
            &self,
            indexes: &NSIndexSet,
            row_animation: NSTableViewAnimationOptions,
        );

        #[method(unhideRowsAtIndexes:withAnimation:)]
        pub unsafe fn unhideRowsAtIndexes_withAnimation(
            &self,
            indexes: &NSIndexSet,
            row_animation: NSTableViewAnimationOptions,
        );

        #[method_id(@__retain_semantics Other hiddenRowIndexes)]
        pub unsafe fn hiddenRowIndexes(&self) -> Retained<NSIndexSet>;

        #[cfg(all(feature = "NSNib", feature = "NSUserInterfaceItemIdentification"))]
        #[method(registerNib:forIdentifier:)]
        pub unsafe fn registerNib_forIdentifier(
            &self,
            nib: Option<&NSNib>,
            identifier: &NSUserInterfaceItemIdentifier,
        );

        #[cfg(all(feature = "NSNib", feature = "NSUserInterfaceItemIdentification"))]
        #[method_id(@__retain_semantics Other registeredNibsByIdentifier)]
        pub unsafe fn registeredNibsByIdentifier(
            &self,
        ) -> Option<Retained<NSDictionary<NSUserInterfaceItemIdentifier, NSNib>>>;

        #[cfg(feature = "NSTableRowView")]
        #[method(didAddRowView:forRow:)]
        pub unsafe fn didAddRowView_forRow(&self, row_view: &NSTableRowView, row: NSInteger);

        #[cfg(feature = "NSTableRowView")]
        #[method(didRemoveRowView:forRow:)]
        pub unsafe fn didRemoveRowView_forRow(&self, row_view: &NSTableRowView, row: NSInteger);

        #[method(usesStaticContents)]
        pub unsafe fn usesStaticContents(&self) -> bool;

        #[method(setUsesStaticContents:)]
        pub unsafe fn setUsesStaticContents(&self, uses_static_contents: bool);

        #[cfg(feature = "NSUserInterfaceLayout")]
        #[method(userInterfaceLayoutDirection)]
        pub unsafe fn userInterfaceLayoutDirection(&self) -> NSUserInterfaceLayoutDirection;

        #[cfg(feature = "NSUserInterfaceLayout")]
        #[method(setUserInterfaceLayoutDirection:)]
        pub unsafe fn setUserInterfaceLayoutDirection(
            &self,
            user_interface_layout_direction: NSUserInterfaceLayoutDirection,
        );

        #[method(usesAutomaticRowHeights)]
        pub unsafe fn usesAutomaticRowHeights(&self) -> bool;

        #[method(setUsesAutomaticRowHeights:)]
        pub unsafe fn setUsesAutomaticRowHeights(&self, uses_automatic_row_heights: bool);
    }
);

extern_methods!(
    /// Methods declared on superclass `NSResponder`
    #[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
    unsafe impl NSTableView {
        #[method_id(@__retain_semantics Init init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;
    }
);

extern_methods!(
    /// Methods declared on superclass `NSObject`
    #[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
    unsafe impl NSTableView {
        #[method_id(@__retain_semantics New new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    }
);

extern_protocol!(
    #[cfg(feature = "NSControl")]
    pub unsafe trait NSTableViewDelegate: NSControlTextEditingDelegate {
        #[cfg(all(feature = "NSResponder", feature = "NSTableColumn", feature = "NSView"))]
        #[optional]
        #[method_id(@__retain_semantics Other tableView:viewForTableColumn:row:)]
        unsafe fn tableView_viewForTableColumn_row(
            &self,
            table_view: &NSTableView,
            table_column: Option<&NSTableColumn>,
            row: NSInteger,
        ) -> Option<Retained<NSView>>;

        #[cfg(all(
            feature = "NSResponder",
            feature = "NSTableRowView",
            feature = "NSView"
        ))]
        #[optional]
        #[method_id(@__retain_semantics Other tableView:rowViewForRow:)]
        unsafe fn tableView_rowViewForRow(
            &self,
            table_view: &NSTableView,
            row: NSInteger,
        ) -> Option<Retained<NSTableRowView>>;

        #[cfg(all(
            feature = "NSResponder",
            feature = "NSTableRowView",
            feature = "NSView"
        ))]
        #[optional]
        #[method(tableView:didAddRowView:forRow:)]
        unsafe fn tableView_didAddRowView_forRow(
            &self,
            table_view: &NSTableView,
            row_view: &NSTableRowView,
            row: NSInteger,
        );

        #[cfg(all(
            feature = "NSResponder",
            feature = "NSTableRowView",
            feature = "NSView"
        ))]
        #[optional]
        #[method(tableView:didRemoveRowView:forRow:)]
        unsafe fn tableView_didRemoveRowView_forRow(
            &self,
            table_view: &NSTableView,
            row_view: &NSTableRowView,
            row: NSInteger,
        );

        #[cfg(all(feature = "NSResponder", feature = "NSTableColumn", feature = "NSView"))]
        #[optional]
        #[method(tableView:willDisplayCell:forTableColumn:row:)]
        unsafe fn tableView_willDisplayCell_forTableColumn_row(
            &self,
            table_view: &NSTableView,
            cell: &AnyObject,
            table_column: Option<&NSTableColumn>,
            row: NSInteger,
        );

        #[cfg(all(feature = "NSResponder", feature = "NSTableColumn", feature = "NSView"))]
        #[optional]
        #[method(tableView:shouldEditTableColumn:row:)]
        unsafe fn tableView_shouldEditTableColumn_row(
            &self,
            table_view: &NSTableView,
            table_column: Option<&NSTableColumn>,
            row: NSInteger,
        ) -> bool;

        #[cfg(all(
            feature = "NSCell",
            feature = "NSResponder",
            feature = "NSTableColumn",
            feature = "NSView"
        ))]
        #[optional]
        #[method_id(@__retain_semantics Other tableView:toolTipForCell:rect:tableColumn:row:mouseLocation:)]
        unsafe fn tableView_toolTipForCell_rect_tableColumn_row_mouseLocation(
            &self,
            table_view: &NSTableView,
            cell: &NSCell,
            rect: NSRectPointer,
            table_column: Option<&NSTableColumn>,
            row: NSInteger,
            mouse_location: NSPoint,
        ) -> Retained<NSString>;

        #[cfg(all(feature = "NSResponder", feature = "NSTableColumn", feature = "NSView"))]
        #[optional]
        #[method(tableView:shouldShowCellExpansionForTableColumn:row:)]
        unsafe fn tableView_shouldShowCellExpansionForTableColumn_row(
            &self,
            table_view: &NSTableView,
            table_column: Option<&NSTableColumn>,
            row: NSInteger,
        ) -> bool;

        #[cfg(all(
            feature = "NSCell",
            feature = "NSResponder",
            feature = "NSTableColumn",
            feature = "NSView"
        ))]
        #[optional]
        #[method(tableView:shouldTrackCell:forTableColumn:row:)]
        unsafe fn tableView_shouldTrackCell_forTableColumn_row(
            &self,
            table_view: &NSTableView,
            cell: &NSCell,
            table_column: Option<&NSTableColumn>,
            row: NSInteger,
        ) -> bool;

        #[cfg(all(
            feature = "NSCell",
            feature = "NSResponder",
            feature = "NSTableColumn",
            feature = "NSView"
        ))]
        #[optional]
        #[method_id(@__retain_semantics Other tableView:dataCellForTableColumn:row:)]
        unsafe fn tableView_dataCellForTableColumn_row(
            &self,
            table_view: &NSTableView,
            table_column: Option<&NSTableColumn>,
            row: NSInteger,
        ) -> Option<Retained<NSCell>>;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[method(selectionShouldChangeInTableView:)]
        unsafe fn selectionShouldChangeInTableView(&self, table_view: &NSTableView) -> bool;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[method(tableView:shouldSelectRow:)]
        unsafe fn tableView_shouldSelectRow(
            &self,
            table_view: &NSTableView,
            row: NSInteger,
        ) -> bool;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[method_id(@__retain_semantics Other tableView:selectionIndexesForProposedSelection:)]
        unsafe fn tableView_selectionIndexesForProposedSelection(
            &self,
            table_view: &NSTableView,
            proposed_selection_indexes: &NSIndexSet,
        ) -> Retained<NSIndexSet>;

        #[cfg(all(feature = "NSResponder", feature = "NSTableColumn", feature = "NSView"))]
        #[optional]
        #[method(tableView:shouldSelectTableColumn:)]
        unsafe fn tableView_shouldSelectTableColumn(
            &self,
            table_view: &NSTableView,
            table_column: Option<&NSTableColumn>,
        ) -> bool;

        #[cfg(all(feature = "NSResponder", feature = "NSTableColumn", feature = "NSView"))]
        #[optional]
        #[method(tableView:mouseDownInHeaderOfTableColumn:)]
        unsafe fn tableView_mouseDownInHeaderOfTableColumn(
            &self,
            table_view: &NSTableView,
            table_column: &NSTableColumn,
        );

        #[cfg(all(feature = "NSResponder", feature = "NSTableColumn", feature = "NSView"))]
        #[optional]
        #[method(tableView:didClickTableColumn:)]
        unsafe fn tableView_didClickTableColumn(
            &self,
            table_view: &NSTableView,
            table_column: &NSTableColumn,
        );

        #[cfg(all(feature = "NSResponder", feature = "NSTableColumn", feature = "NSView"))]
        #[optional]
        #[method(tableView:didDragTableColumn:)]
        unsafe fn tableView_didDragTableColumn(
            &self,
            table_view: &NSTableView,
            table_column: &NSTableColumn,
        );

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[method(tableView:heightOfRow:)]
        unsafe fn tableView_heightOfRow(&self, table_view: &NSTableView, row: NSInteger)
            -> CGFloat;

        #[cfg(all(feature = "NSResponder", feature = "NSTableColumn", feature = "NSView"))]
        #[optional]
        #[method_id(@__retain_semantics Other tableView:typeSelectStringForTableColumn:row:)]
        unsafe fn tableView_typeSelectStringForTableColumn_row(
            &self,
            table_view: &NSTableView,
            table_column: Option<&NSTableColumn>,
            row: NSInteger,
        ) -> Option<Retained<NSString>>;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[method(tableView:nextTypeSelectMatchFromRow:toRow:forString:)]
        unsafe fn tableView_nextTypeSelectMatchFromRow_toRow_forString(
            &self,
            table_view: &NSTableView,
            start_row: NSInteger,
            end_row: NSInteger,
            search_string: &NSString,
        ) -> NSInteger;

        #[cfg(all(feature = "NSEvent", feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[method(tableView:shouldTypeSelectForEvent:withCurrentSearchString:)]
        unsafe fn tableView_shouldTypeSelectForEvent_withCurrentSearchString(
            &self,
            table_view: &NSTableView,
            event: &NSEvent,
            search_string: Option<&NSString>,
        ) -> bool;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[method(tableView:isGroupRow:)]
        unsafe fn tableView_isGroupRow(&self, table_view: &NSTableView, row: NSInteger) -> bool;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[method(tableView:sizeToFitWidthOfColumn:)]
        unsafe fn tableView_sizeToFitWidthOfColumn(
            &self,
            table_view: &NSTableView,
            column: NSInteger,
        ) -> CGFloat;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[method(tableView:shouldReorderColumn:toColumn:)]
        unsafe fn tableView_shouldReorderColumn_toColumn(
            &self,
            table_view: &NSTableView,
            column_index: NSInteger,
            new_column_index: NSInteger,
        ) -> bool;

        #[cfg(all(
            feature = "NSResponder",
            feature = "NSTableViewRowAction",
            feature = "NSView"
        ))]
        #[optional]
        #[method_id(@__retain_semantics Other tableView:rowActionsForRow:edge:)]
        unsafe fn tableView_rowActionsForRow_edge(
            &self,
            table_view: &NSTableView,
            row: NSInteger,
            edge: NSTableRowActionEdge,
        ) -> Retained<NSArray<NSTableViewRowAction>>;

        #[cfg(all(feature = "NSResponder", feature = "NSTableColumn", feature = "NSView"))]
        #[optional]
        #[method(tableView:userCanChangeVisibilityOfTableColumn:)]
        unsafe fn tableView_userCanChangeVisibilityOfTableColumn(
            &self,
            table_view: &NSTableView,
            column: &NSTableColumn,
        ) -> bool;

        #[cfg(all(feature = "NSResponder", feature = "NSTableColumn", feature = "NSView"))]
        #[optional]
        #[method(tableView:userDidChangeVisibilityOfTableColumns:)]
        unsafe fn tableView_userDidChangeVisibilityOfTableColumns(
            &self,
            table_view: &NSTableView,
            columns: &NSArray<NSTableColumn>,
        );

        #[optional]
        #[method(tableViewSelectionDidChange:)]
        unsafe fn tableViewSelectionDidChange(&self, notification: &NSNotification);

        #[optional]
        #[method(tableViewColumnDidMove:)]
        unsafe fn tableViewColumnDidMove(&self, notification: &NSNotification);

        #[optional]
        #[method(tableViewColumnDidResize:)]
        unsafe fn tableViewColumnDidResize(&self, notification: &NSNotification);

        #[optional]
        #[method(tableViewSelectionIsChanging:)]
        unsafe fn tableViewSelectionIsChanging(&self, notification: &NSNotification);
    }

    #[cfg(feature = "NSControl")]
    unsafe impl ProtocolType for dyn NSTableViewDelegate {}
);

extern "C" {
    pub static NSTableViewSelectionDidChangeNotification: &'static NSNotificationName;
}

extern "C" {
    pub static NSTableViewColumnDidMoveNotification: &'static NSNotificationName;
}

extern "C" {
    pub static NSTableViewColumnDidResizeNotification: &'static NSNotificationName;
}

extern "C" {
    pub static NSTableViewSelectionIsChangingNotification: &'static NSNotificationName;
}

extern "C" {
    #[cfg(feature = "NSUserInterfaceItemIdentification")]
    pub static NSTableViewRowViewKey: &'static NSUserInterfaceItemIdentifier;
}

extern_protocol!(
    pub unsafe trait NSTableViewDataSource: NSObjectProtocol {
        #[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[method(numberOfRowsInTableView:)]
        unsafe fn numberOfRowsInTableView(&self, table_view: &NSTableView) -> NSInteger;

        #[cfg(all(
            feature = "NSControl",
            feature = "NSResponder",
            feature = "NSTableColumn",
            feature = "NSView"
        ))]
        #[optional]
        #[method_id(@__retain_semantics Other tableView:objectValueForTableColumn:row:)]
        unsafe fn tableView_objectValueForTableColumn_row(
            &self,
            table_view: &NSTableView,
            table_column: Option<&NSTableColumn>,
            row: NSInteger,
        ) -> Option<Retained<AnyObject>>;

        #[cfg(all(
            feature = "NSControl",
            feature = "NSResponder",
            feature = "NSTableColumn",
            feature = "NSView"
        ))]
        #[optional]
        #[method(tableView:setObjectValue:forTableColumn:row:)]
        unsafe fn tableView_setObjectValue_forTableColumn_row(
            &self,
            table_view: &NSTableView,
            object: Option<&AnyObject>,
            table_column: Option<&NSTableColumn>,
            row: NSInteger,
        );

        #[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[method(tableView:sortDescriptorsDidChange:)]
        unsafe fn tableView_sortDescriptorsDidChange(
            &self,
            table_view: &NSTableView,
            old_descriptors: &NSArray<NSSortDescriptor>,
        );

        #[cfg(all(
            feature = "NSControl",
            feature = "NSPasteboard",
            feature = "NSResponder",
            feature = "NSView"
        ))]
        #[optional]
        #[method_id(@__retain_semantics Other tableView:pasteboardWriterForRow:)]
        unsafe fn tableView_pasteboardWriterForRow(
            &self,
            table_view: &NSTableView,
            row: NSInteger,
        ) -> Option<Retained<ProtocolObject<dyn NSPasteboardWriting>>>;

        #[cfg(all(
            feature = "NSControl",
            feature = "NSDraggingSession",
            feature = "NSResponder",
            feature = "NSView"
        ))]
        #[optional]
        #[method(tableView:draggingSession:willBeginAtPoint:forRowIndexes:)]
        unsafe fn tableView_draggingSession_willBeginAtPoint_forRowIndexes(
            &self,
            table_view: &NSTableView,
            session: &NSDraggingSession,
            screen_point: NSPoint,
            row_indexes: &NSIndexSet,
        );

        #[cfg(all(
            feature = "NSControl",
            feature = "NSDragging",
            feature = "NSDraggingSession",
            feature = "NSResponder",
            feature = "NSView"
        ))]
        #[optional]
        #[method(tableView:draggingSession:endedAtPoint:operation:)]
        unsafe fn tableView_draggingSession_endedAtPoint_operation(
            &self,
            table_view: &NSTableView,
            session: &NSDraggingSession,
            screen_point: NSPoint,
            operation: NSDragOperation,
        );

        #[cfg(all(
            feature = "NSControl",
            feature = "NSDragging",
            feature = "NSResponder",
            feature = "NSView"
        ))]
        #[optional]
        #[method(tableView:updateDraggingItemsForDrag:)]
        unsafe fn tableView_updateDraggingItemsForDrag(
            &self,
            table_view: &NSTableView,
            dragging_info: &ProtocolObject<dyn NSDraggingInfo>,
        );

        #[cfg(all(
            feature = "NSControl",
            feature = "NSPasteboard",
            feature = "NSResponder",
            feature = "NSView"
        ))]
        #[deprecated = "Use -tableView:pasteboardWriterForRow: instead"]
        #[optional]
        #[method(tableView:writeRowsWithIndexes:toPasteboard:)]
        unsafe fn tableView_writeRowsWithIndexes_toPasteboard(
            &self,
            table_view: &NSTableView,
            row_indexes: &NSIndexSet,
            pboard: &NSPasteboard,
        ) -> bool;

        #[cfg(all(
            feature = "NSControl",
            feature = "NSDragging",
            feature = "NSResponder",
            feature = "NSView"
        ))]
        #[optional]
        #[method(tableView:validateDrop:proposedRow:proposedDropOperation:)]
        unsafe fn tableView_validateDrop_proposedRow_proposedDropOperation(
            &self,
            table_view: &NSTableView,
            info: &ProtocolObject<dyn NSDraggingInfo>,
            row: NSInteger,
            drop_operation: NSTableViewDropOperation,
        ) -> NSDragOperation;

        #[cfg(all(
            feature = "NSControl",
            feature = "NSDragging",
            feature = "NSResponder",
            feature = "NSView"
        ))]
        #[optional]
        #[method(tableView:acceptDrop:row:dropOperation:)]
        unsafe fn tableView_acceptDrop_row_dropOperation(
            &self,
            table_view: &NSTableView,
            info: &ProtocolObject<dyn NSDraggingInfo>,
            row: NSInteger,
            drop_operation: NSTableViewDropOperation,
        ) -> bool;

        #[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
        #[deprecated = "Use NSFilePromiseReceiver objects instead"]
        #[optional]
        #[method_id(@__retain_semantics Other tableView:namesOfPromisedFilesDroppedAtDestination:forDraggedRowsWithIndexes:)]
        unsafe fn tableView_namesOfPromisedFilesDroppedAtDestination_forDraggedRowsWithIndexes(
            &self,
            table_view: &NSTableView,
            drop_destination: &NSURL,
            index_set: &NSIndexSet,
        ) -> Retained<NSArray<NSString>>;
    }

    unsafe impl ProtocolType for dyn NSTableViewDataSource {}
);

extern_methods!(
    /// NSDeprecated
    #[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
    unsafe impl NSTableView {
        #[deprecated]
        #[method(setDrawsGrid:)]
        pub unsafe fn setDrawsGrid(&self, flag: bool);

        #[deprecated]
        #[method(drawsGrid)]
        pub unsafe fn drawsGrid(&self) -> bool;

        #[deprecated]
        #[method(selectColumn:byExtendingSelection:)]
        pub unsafe fn selectColumn_byExtendingSelection(&self, column: NSInteger, extend: bool);

        #[deprecated]
        #[method(selectRow:byExtendingSelection:)]
        pub unsafe fn selectRow_byExtendingSelection(&self, row: NSInteger, extend: bool);

        #[deprecated]
        #[method_id(@__retain_semantics Other selectedColumnEnumerator)]
        pub unsafe fn selectedColumnEnumerator(&self) -> Retained<NSEnumerator>;

        #[deprecated]
        #[method_id(@__retain_semantics Other selectedRowEnumerator)]
        pub unsafe fn selectedRowEnumerator(&self) -> Retained<NSEnumerator>;

        #[cfg(all(feature = "NSEvent", feature = "NSImage"))]
        #[deprecated]
        #[method_id(@__retain_semantics Other dragImageForRows:event:dragImageOffset:)]
        pub unsafe fn dragImageForRows_event_dragImageOffset(
            &self,
            drag_rows: &NSArray,
            drag_event: &NSEvent,
            drag_image_offset: NSPointPointer,
        ) -> Option<Retained<NSImage>>;

        #[deprecated]
        #[method(setAutoresizesAllColumnsToFit:)]
        pub unsafe fn setAutoresizesAllColumnsToFit(&self, flag: bool);

        #[deprecated]
        #[method(autoresizesAllColumnsToFit)]
        pub unsafe fn autoresizesAllColumnsToFit(&self) -> bool;

        #[deprecated]
        #[method(columnsInRect:)]
        pub unsafe fn columnsInRect(&self, rect: NSRect) -> NSRange;

        #[cfg(feature = "NSCell")]
        #[deprecated = "Use View Based TableView and -viewAtColumn:row:"]
        #[method_id(@__retain_semantics Other preparedCellAtColumn:row:)]
        pub unsafe fn preparedCellAtColumn_row(
            &self,
            column: NSInteger,
            row: NSInteger,
        ) -> Option<Retained<NSCell>>;

        #[cfg(feature = "NSText")]
        #[deprecated = "Use a View Based TableView with an NSTextField"]
        #[method(textShouldBeginEditing:)]
        pub unsafe fn textShouldBeginEditing(&self, text_object: &NSText) -> bool;

        #[cfg(feature = "NSText")]
        #[deprecated = "Use a View Based TableView with an NSTextField"]
        #[method(textShouldEndEditing:)]
        pub unsafe fn textShouldEndEditing(&self, text_object: &NSText) -> bool;

        #[deprecated = "Use a View Based TableView with an NSTextField"]
        #[method(textDidBeginEditing:)]
        pub unsafe fn textDidBeginEditing(&self, notification: &NSNotification);

        #[deprecated = "Use a View Based TableView with an NSTextField"]
        #[method(textDidEndEditing:)]
        pub unsafe fn textDidEndEditing(&self, notification: &NSNotification);

        #[deprecated = "Use a View Based TableView with an NSTextField"]
        #[method(textDidChange:)]
        pub unsafe fn textDidChange(&self, notification: &NSNotification);

        #[cfg(feature = "NSCell")]
        #[deprecated = "Use a View Based TableView; observe the window’s firstResponder for focus change notifications"]
        #[method(shouldFocusCell:atColumn:row:)]
        pub unsafe fn shouldFocusCell_atColumn_row(
            &self,
            cell: &NSCell,
            column: NSInteger,
            row: NSInteger,
        ) -> bool;

        #[deprecated = "Use a View Based TableView and observe the window.firstResponder"]
        #[method(focusedColumn)]
        pub unsafe fn focusedColumn(&self) -> NSInteger;

        #[deprecated = "Use a View Based TableView; make a particular view the first responder with [window makeFirstResponder:view] to focus it."]
        #[method(setFocusedColumn:)]
        pub unsafe fn setFocusedColumn(&self, focused_column: NSInteger);

        #[deprecated = "Use a View Based TableView; directly interact with a particular view as required and call -performClick: on it, if necessary"]
        #[method(performClickOnCellAtColumn:row:)]
        pub unsafe fn performClickOnCellAtColumn_row(&self, column: NSInteger, row: NSInteger);
    }
);
