/*
 *$Id: psmark.c,v 1.3 2002/11/22 12:43:33 tino Exp $ PostScript manipulation program.
 *
 
 Copyright (C) 2001 Sherryl Manalo <sm@antitachyon.com> 
 and Martin Willner <mw@antitachyon.com>
   
 Lots of features where done by Geoff Youngs <g@intersect-uk.co.uk>.
 Big THX :-)

 ---

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

enum _value_type {
  value_none,
  value_int,
  value_double,
  value_colour,
  value_file_out,
  value_file_out_b,
  value_file_in,
  value_file_in_b,
  value_string
};

typedef struct _optionlist {
  char              single;
  char              * string;
  enum _value_type  type;
  void              * value;
} optionlist;


extern char ** options_process(int argc, char * argv[], struct _optionlist options[]);
extern void usage(char * error);

extern char *argv_files[];


char *s1a="gsave %matrix defaultmatrix setmatrix\n";
char *s1b="rotate 2";
char *s2a="mul -2";
char *s2ab="mul moveto";
char *font="Times-Roman";
char *s2b="findfont";
char *s3="scalefont setfont";
char *s4="setgray";
char *s5="show grestore";
   
char *progname = NULL;
   
void usage (char *error)
{
  if (error)
    {
      fprintf(stderr,"\nError: %s\n",error);
    }
  fprintf(stderr,"\n%s $Revision: 1.3 $ Copyright (c) 2001\n"
	  "Sherryl Manalo <sm@antitachyon.com>\n"
	  "and Martin Willner <mw@antitachyon.com>\n\n",
	  progname);
  fprintf(stderr,"%s comes with ABSOLUTELY NO WARRANTY; for details"
	  " read the COPYING file\nthat comes with this package.\n",
	  progname);
  fprintf(stderr,"\nusage: %s [<options>] \"string\"\n",
	  progname);
  fprintf(stderr,"\nOptions:\n"
	  "  -i  --infile     <filename>    Filename ('-' = stdin)  (default: stdin)\n"
	  "  -o  --outfile    <filename>    Filename ('-' = stdout) (default: stdout)\n"
	  "  -x  --x-pos      <x-offset>    Horizontal postion(1)   (default: 20)\n"
	  "  -y  --y-pos      <y-offset>    Vertical postion(1)     (default: 30)\n"
	  "  -b  --brightness <brightness>  Brightness of text      (default: 0.4)\n"
	  "  -s  --scale      <scale>       Scale/size of text      (default: 15)\n"
	  "  -r  --rotate     <rotate>      Angle of rotation       (default: 90)\n"
	  "  -f  --font       <ps-font>     Font name               (default: Times-Roman)\n"
	  "  -e  --eps                      Stamp inline EPS files  (default: off)\n"
	  "\n",
	  progname);
  fprintf(stderr,"example:\n %s -i test.ps -o output.ps -b 0.4 -s 15 \"vertical label\""
	  "\n\n",progname);
  fprintf(stderr,"Notes: The offsets are measured from the bottom left hand corner, but
	  they are not in sync with the page corner: some fiddling is required
	  to get text to appear right in the corner.\n"
	  );
	 
  exit(error ? EXIT_FAILURE : EXIT_SUCCESS);   	
}

void decode_colour(long c, double *r, double *g, double *b)
{
  *b = (double)(c & 0xFF) / 255;
  *g = (double)((c >> 8) & 0xFF) / 255;
  *r = (double)((c >> 16) & 0xFF) / 255;
}


int main(int argc, char **argv)
{
  FILE *in_fp = stdin, *out_fp = stdout;
  char buff[1024];
  char cstr[1024];
   
  double xpos=20;
  double ypos=30;
  long scale=15;
  long rotate=90;
  long colour=-1;
  double brightness=0.4;
  char *name="v0id";
  int skip = 0, eps = 0;
  char **strings;

  optionlist opts[] = {
    { 'x', "x-pos", value_double, &xpos },
    { 'y', "y-pos", value_double, &ypos },
    { 's', "scale", value_int, &scale },
    { 'r', "rotate", value_int, &rotate },
    { 'b', "brightness", value_double, &brightness },
    { 'c', "colour", value_colour, &colour },
    { 'i', "infile", value_file_in, &in_fp },
    { 'o', "outfile", value_file_out, &out_fp },
    { 'f', "font", value_string, &font },
    { 'e', "eps", value_none, &eps },
    {  0, 0, 0, 0 }
  };
      
  progname = argv[0];

  strings = options_process(argc, argv, opts);
      
  if (!strings[0])
    usage("No text supplied");
	
  if (colour != -1)
    {
      double red=0, green=0, blue=0;
      decode_colour(colour, &red, &green, &blue);
      sprintf(cstr,"gsave %%matrix defaultmatrix setmatrix\n"
	      " %d rotate 2 %f mul -2 %f mul moveto "
	      "/%s findfont %d scalefont setfont %f %f %f setrgbcolor (%s) show grestore", 
	      rotate, ypos, xpos, font, scale, red, green, blue, strings[0]);
    }
  else
    {
      sprintf(cstr,"gsave %%matrix defaultmatrix setmatrix\n"
	      " %d rotate 2 %f mul -2 %f mul moveto "
	      "/%s findfont %d scalefont setfont %f setgray (%s) show grestore", 
	      rotate, ypos, xpos, font, scale, brightness, strings[0]);
    }
         
  if (!in_fp)
    {
      usage("Unable to open infile\n");
    }
  if (!out_fp)
    {
      usage("Unable to open outfile\n");
    }
  
  do
    {
      buff[0] = 0; /* Prevent duplicate lines, spurious output for blank files etc */
      fgets(buff,1024,in_fp);

      if( strstr(buff,"showpage")!=NULL && strlen(buff)<12)
	{
	  if (skip==0)
	    {
	      fprintf(out_fp,"%s\n",cstr);
	      fprintf(out_fp,"showpage\n");
	    }
	} else {
	
	  fprintf(out_fp, "%s",buff);
	}




      if( strstr(buff,"%!PS-Adobe-")!=NULL && strstr(buff,"EPSF")!=NULL)
	{
	  skip = 1;
	}
	 
      if( strstr(buff,"%%Page:")!=NULL && strstr(buff,"?")==NULL )
	{
	  if (skip==0 || eps)
	    {
	      fprintf(out_fp, "%s\n",cstr);
	    }
	  skip = 0;
	}
      

    } while(!feof(in_fp));
   
  return 0;
}


/************************ Options handling routines **************************/

#ifndef MAX_INPUT_FILES
#define MAX_INPUT_FILES 512
#endif
 
char *argv_files[MAX_INPUT_FILES] = { 0 };

#define STD(s) (s[0] == '-' && s[1] == '\0')

static void * _option_value(const char * string, enum _value_type type) {
  long i;
  switch (type) {
  case value_int:
  case value_colour:
    sscanf(string,"%i",&i);
    return (void*)i;
    /*return (void*)atoi(string);*/
    break;
  case value_double:
    perror("Double type supplied to _option_value() - converting to long!");
    return (void*)atol(string);
    break;
  case value_string:
    return (void*)string;
    break;
  case value_file_in:
    return (void*)(STD(string) ? stdin : fopen(string,"r"));
    break;
  case value_file_in_b:
    return (void*)(STD(string) ? stdin : fopen(string,"rb"));
    break;
  case value_file_out:
    return (void*)(STD(string) ? stdout : fopen(string,"w"));
    break;
  case value_file_out_b:
    return (void*)(STD(string) ? stdout : fopen(string,"wb"));
    break;
  default:
    perror("Memory overwrite fault/bug - invalid option type supplied to _option_value()");
    break;
  }
  return (void*)0;
}

char **options_process(int argc, char * argv[], struct _optionlist options[])
{
  int i, in_opts = 1;
  int no_files = 0;

  for (i=1; i<argc; i++) {
    if (in_opts && argv[i][0] == '-' && argv[i][1] == '-') {
      /* '--' ends options */
      if (argv[i][2] == '\0') {
	in_opts = 0;
	continue;
      }

      /* long option */
      if (strcmp(&argv[i][2],"help")==0) {
	usage(NULL);
	continue;
      }
      if (options) {
	int c, found=0;
	for (c=0; options[c].value; c++) {
	  if (options[c].string && strcmp(options[c].string,&argv[i][2])==0) {
	    found=1;
	    break;
	  }
	}
	if (found) {
	  if (options[c].type == value_none) {
	    * ((int*)options[c].value) = -1;
	  } else if (options[c].type == value_double) {
	    *((double*)options[c].value) = atof(argv[++i]);
	  } else {
	    *((int*)options[c].value) = (int)_option_value(argv[++i], options[c].type);
	  }
	  continue;
	}
      }
      fprintf(stderr, "Invocation error: Unrecognised long option '%s'\n", argv[i]);
      usage(NULL);
      exit(EXIT_SUCCESS);

    } else if (in_opts && argv[i][0] == '-') {
      /* short option(s) */
      int h=i,j=0;

      while (argv[h][++j]) {
	int c,found=0;

	if (argv[h][j]=='h'||argv[h][j]=='?') {
	  usage(NULL);
	  exit(EXIT_SUCCESS);
	}

	for (c=0; options[c].value; c++) {
	  if (options[c].single && options[c].single == argv[h][j]) {
	    found=1;
	    break;
	  }
	}
	if (found) {
	  if (options[c].type == value_none) {
	    * ((int*)options[c].value ) = 1;
	  } else {
	    if ( i > h ) {
	      fprintf(stderr,
		      "Invocation error: option '%c' requires an argument\n",
		      argv[h][j]);
	      usage(NULL);
	      exit(EXIT_FAILURE);
	    }
	    if (options[c].type == value_double) {
	      *((double*)options[c].value) = atof(argv[++i]);
	    } else {
	      * ((int*)options[c].value ) = (int)_option_value( argv[++i], options[c].type );
	    }
	  }
	  continue;
	}
	if (argv[h][j] == 'h') {
	  usage(NULL);
	  exit(EXIT_SUCCESS);
	}

	fprintf(stderr,
		"Invocation error: short option '%c' is unrecognised\n",
		argv[h][j]);
	usage(NULL);
	exit(EXIT_FAILURE);
      }

    } else {
      /* arguments */
      argv_files[no_files] = argv[i];
      argv_files[++no_files] = NULL;
    }
  }
  return argv_files;
}
