// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_check

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceAllHTTPCheckDefaultsOKCode is the HTTP code returned for type ReplaceAllHTTPCheckDefaultsOK
const ReplaceAllHTTPCheckDefaultsOKCode int = 200

/*
ReplaceAllHTTPCheckDefaultsOK All HTTP checks lines replaced

swagger:response replaceAllHttpCheckDefaultsOK
*/
type ReplaceAllHTTPCheckDefaultsOK struct {

	/*
	  In: Body
	*/
	Payload models.HTTPChecks `json:"body,omitempty"`
}

// NewReplaceAllHTTPCheckDefaultsOK creates ReplaceAllHTTPCheckDefaultsOK with default headers values
func NewReplaceAllHTTPCheckDefaultsOK() *ReplaceAllHTTPCheckDefaultsOK {

	return &ReplaceAllHTTPCheckDefaultsOK{}
}

// WithPayload adds the payload to the replace all Http check defaults o k response
func (o *ReplaceAllHTTPCheckDefaultsOK) WithPayload(payload models.HTTPChecks) *ReplaceAllHTTPCheckDefaultsOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all Http check defaults o k response
func (o *ReplaceAllHTTPCheckDefaultsOK) SetPayload(payload models.HTTPChecks) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllHTTPCheckDefaultsOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.HTTPChecks{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceAllHTTPCheckDefaultsAcceptedCode is the HTTP code returned for type ReplaceAllHTTPCheckDefaultsAccepted
const ReplaceAllHTTPCheckDefaultsAcceptedCode int = 202

/*
ReplaceAllHTTPCheckDefaultsAccepted Configuration change accepted and reload requested

swagger:response replaceAllHttpCheckDefaultsAccepted
*/
type ReplaceAllHTTPCheckDefaultsAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload models.HTTPChecks `json:"body,omitempty"`
}

// NewReplaceAllHTTPCheckDefaultsAccepted creates ReplaceAllHTTPCheckDefaultsAccepted with default headers values
func NewReplaceAllHTTPCheckDefaultsAccepted() *ReplaceAllHTTPCheckDefaultsAccepted {

	return &ReplaceAllHTTPCheckDefaultsAccepted{}
}

// WithReloadID adds the reloadId to the replace all Http check defaults accepted response
func (o *ReplaceAllHTTPCheckDefaultsAccepted) WithReloadID(reloadID string) *ReplaceAllHTTPCheckDefaultsAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace all Http check defaults accepted response
func (o *ReplaceAllHTTPCheckDefaultsAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace all Http check defaults accepted response
func (o *ReplaceAllHTTPCheckDefaultsAccepted) WithPayload(payload models.HTTPChecks) *ReplaceAllHTTPCheckDefaultsAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all Http check defaults accepted response
func (o *ReplaceAllHTTPCheckDefaultsAccepted) SetPayload(payload models.HTTPChecks) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllHTTPCheckDefaultsAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.HTTPChecks{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceAllHTTPCheckDefaultsBadRequestCode is the HTTP code returned for type ReplaceAllHTTPCheckDefaultsBadRequest
const ReplaceAllHTTPCheckDefaultsBadRequestCode int = 400

/*
ReplaceAllHTTPCheckDefaultsBadRequest Bad request

swagger:response replaceAllHttpCheckDefaultsBadRequest
*/
type ReplaceAllHTTPCheckDefaultsBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceAllHTTPCheckDefaultsBadRequest creates ReplaceAllHTTPCheckDefaultsBadRequest with default headers values
func NewReplaceAllHTTPCheckDefaultsBadRequest() *ReplaceAllHTTPCheckDefaultsBadRequest {

	return &ReplaceAllHTTPCheckDefaultsBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace all Http check defaults bad request response
func (o *ReplaceAllHTTPCheckDefaultsBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceAllHTTPCheckDefaultsBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace all Http check defaults bad request response
func (o *ReplaceAllHTTPCheckDefaultsBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace all Http check defaults bad request response
func (o *ReplaceAllHTTPCheckDefaultsBadRequest) WithPayload(payload *models.Error) *ReplaceAllHTTPCheckDefaultsBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all Http check defaults bad request response
func (o *ReplaceAllHTTPCheckDefaultsBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllHTTPCheckDefaultsBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceAllHTTPCheckDefaultsDefault General Error

swagger:response replaceAllHttpCheckDefaultsDefault
*/
type ReplaceAllHTTPCheckDefaultsDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceAllHTTPCheckDefaultsDefault creates ReplaceAllHTTPCheckDefaultsDefault with default headers values
func NewReplaceAllHTTPCheckDefaultsDefault(code int) *ReplaceAllHTTPCheckDefaultsDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceAllHTTPCheckDefaultsDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace all HTTP check defaults default response
func (o *ReplaceAllHTTPCheckDefaultsDefault) WithStatusCode(code int) *ReplaceAllHTTPCheckDefaultsDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace all HTTP check defaults default response
func (o *ReplaceAllHTTPCheckDefaultsDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace all HTTP check defaults default response
func (o *ReplaceAllHTTPCheckDefaultsDefault) WithConfigurationVersion(configurationVersion string) *ReplaceAllHTTPCheckDefaultsDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace all HTTP check defaults default response
func (o *ReplaceAllHTTPCheckDefaultsDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace all HTTP check defaults default response
func (o *ReplaceAllHTTPCheckDefaultsDefault) WithPayload(payload *models.Error) *ReplaceAllHTTPCheckDefaultsDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all HTTP check defaults default response
func (o *ReplaceAllHTTPCheckDefaultsDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllHTTPCheckDefaultsDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
