// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_error_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// CreateHTTPErrorRuleBackendCreatedCode is the HTTP code returned for type CreateHTTPErrorRuleBackendCreated
const CreateHTTPErrorRuleBackendCreatedCode int = 201

/*
CreateHTTPErrorRuleBackendCreated HTTP Error Rule created

swagger:response createHttpErrorRuleBackendCreated
*/
type CreateHTTPErrorRuleBackendCreated struct {

	/*
	  In: Body
	*/
	Payload *models.HTTPErrorRule `json:"body,omitempty"`
}

// NewCreateHTTPErrorRuleBackendCreated creates CreateHTTPErrorRuleBackendCreated with default headers values
func NewCreateHTTPErrorRuleBackendCreated() *CreateHTTPErrorRuleBackendCreated {

	return &CreateHTTPErrorRuleBackendCreated{}
}

// WithPayload adds the payload to the create Http error rule backend created response
func (o *CreateHTTPErrorRuleBackendCreated) WithPayload(payload *models.HTTPErrorRule) *CreateHTTPErrorRuleBackendCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http error rule backend created response
func (o *CreateHTTPErrorRuleBackendCreated) SetPayload(payload *models.HTTPErrorRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPErrorRuleBackendCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateHTTPErrorRuleBackendAcceptedCode is the HTTP code returned for type CreateHTTPErrorRuleBackendAccepted
const CreateHTTPErrorRuleBackendAcceptedCode int = 202

/*
CreateHTTPErrorRuleBackendAccepted Configuration change accepted and reload requested

swagger:response createHttpErrorRuleBackendAccepted
*/
type CreateHTTPErrorRuleBackendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.HTTPErrorRule `json:"body,omitempty"`
}

// NewCreateHTTPErrorRuleBackendAccepted creates CreateHTTPErrorRuleBackendAccepted with default headers values
func NewCreateHTTPErrorRuleBackendAccepted() *CreateHTTPErrorRuleBackendAccepted {

	return &CreateHTTPErrorRuleBackendAccepted{}
}

// WithReloadID adds the reloadId to the create Http error rule backend accepted response
func (o *CreateHTTPErrorRuleBackendAccepted) WithReloadID(reloadID string) *CreateHTTPErrorRuleBackendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the create Http error rule backend accepted response
func (o *CreateHTTPErrorRuleBackendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the create Http error rule backend accepted response
func (o *CreateHTTPErrorRuleBackendAccepted) WithPayload(payload *models.HTTPErrorRule) *CreateHTTPErrorRuleBackendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http error rule backend accepted response
func (o *CreateHTTPErrorRuleBackendAccepted) SetPayload(payload *models.HTTPErrorRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPErrorRuleBackendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateHTTPErrorRuleBackendBadRequestCode is the HTTP code returned for type CreateHTTPErrorRuleBackendBadRequest
const CreateHTTPErrorRuleBackendBadRequestCode int = 400

/*
CreateHTTPErrorRuleBackendBadRequest Bad request

swagger:response createHttpErrorRuleBackendBadRequest
*/
type CreateHTTPErrorRuleBackendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateHTTPErrorRuleBackendBadRequest creates CreateHTTPErrorRuleBackendBadRequest with default headers values
func NewCreateHTTPErrorRuleBackendBadRequest() *CreateHTTPErrorRuleBackendBadRequest {

	return &CreateHTTPErrorRuleBackendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the create Http error rule backend bad request response
func (o *CreateHTTPErrorRuleBackendBadRequest) WithConfigurationVersion(configurationVersion string) *CreateHTTPErrorRuleBackendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create Http error rule backend bad request response
func (o *CreateHTTPErrorRuleBackendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create Http error rule backend bad request response
func (o *CreateHTTPErrorRuleBackendBadRequest) WithPayload(payload *models.Error) *CreateHTTPErrorRuleBackendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http error rule backend bad request response
func (o *CreateHTTPErrorRuleBackendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPErrorRuleBackendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateHTTPErrorRuleBackendConflictCode is the HTTP code returned for type CreateHTTPErrorRuleBackendConflict
const CreateHTTPErrorRuleBackendConflictCode int = 409

/*
CreateHTTPErrorRuleBackendConflict The specified resource already exists

swagger:response createHttpErrorRuleBackendConflict
*/
type CreateHTTPErrorRuleBackendConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateHTTPErrorRuleBackendConflict creates CreateHTTPErrorRuleBackendConflict with default headers values
func NewCreateHTTPErrorRuleBackendConflict() *CreateHTTPErrorRuleBackendConflict {

	return &CreateHTTPErrorRuleBackendConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the create Http error rule backend conflict response
func (o *CreateHTTPErrorRuleBackendConflict) WithConfigurationVersion(configurationVersion string) *CreateHTTPErrorRuleBackendConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create Http error rule backend conflict response
func (o *CreateHTTPErrorRuleBackendConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create Http error rule backend conflict response
func (o *CreateHTTPErrorRuleBackendConflict) WithPayload(payload *models.Error) *CreateHTTPErrorRuleBackendConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http error rule backend conflict response
func (o *CreateHTTPErrorRuleBackendConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPErrorRuleBackendConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CreateHTTPErrorRuleBackendDefault General Error

swagger:response createHttpErrorRuleBackendDefault
*/
type CreateHTTPErrorRuleBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateHTTPErrorRuleBackendDefault creates CreateHTTPErrorRuleBackendDefault with default headers values
func NewCreateHTTPErrorRuleBackendDefault(code int) *CreateHTTPErrorRuleBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &CreateHTTPErrorRuleBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the create HTTP error rule backend default response
func (o *CreateHTTPErrorRuleBackendDefault) WithStatusCode(code int) *CreateHTTPErrorRuleBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the create HTTP error rule backend default response
func (o *CreateHTTPErrorRuleBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the create HTTP error rule backend default response
func (o *CreateHTTPErrorRuleBackendDefault) WithConfigurationVersion(configurationVersion string) *CreateHTTPErrorRuleBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create HTTP error rule backend default response
func (o *CreateHTTPErrorRuleBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create HTTP error rule backend default response
func (o *CreateHTTPErrorRuleBackendDefault) WithPayload(payload *models.Error) *CreateHTTPErrorRuleBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create HTTP error rule backend default response
func (o *CreateHTTPErrorRuleBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPErrorRuleBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
