// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_response_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetAllHTTPResponseRuleFrontendOKCode is the HTTP code returned for type GetAllHTTPResponseRuleFrontendOK
const GetAllHTTPResponseRuleFrontendOKCode int = 200

/*
GetAllHTTPResponseRuleFrontendOK Successful operation

swagger:response getAllHttpResponseRuleFrontendOK
*/
type GetAllHTTPResponseRuleFrontendOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload models.HTTPResponseRules `json:"body,omitempty"`
}

// NewGetAllHTTPResponseRuleFrontendOK creates GetAllHTTPResponseRuleFrontendOK with default headers values
func NewGetAllHTTPResponseRuleFrontendOK() *GetAllHTTPResponseRuleFrontendOK {

	return &GetAllHTTPResponseRuleFrontendOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get all Http response rule frontend o k response
func (o *GetAllHTTPResponseRuleFrontendOK) WithConfigurationVersion(configurationVersion string) *GetAllHTTPResponseRuleFrontendOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all Http response rule frontend o k response
func (o *GetAllHTTPResponseRuleFrontendOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all Http response rule frontend o k response
func (o *GetAllHTTPResponseRuleFrontendOK) WithPayload(payload models.HTTPResponseRules) *GetAllHTTPResponseRuleFrontendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all Http response rule frontend o k response
func (o *GetAllHTTPResponseRuleFrontendOK) SetPayload(payload models.HTTPResponseRules) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllHTTPResponseRuleFrontendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.HTTPResponseRules{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetAllHTTPResponseRuleFrontendDefault General Error

swagger:response getAllHttpResponseRuleFrontendDefault
*/
type GetAllHTTPResponseRuleFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetAllHTTPResponseRuleFrontendDefault creates GetAllHTTPResponseRuleFrontendDefault with default headers values
func NewGetAllHTTPResponseRuleFrontendDefault(code int) *GetAllHTTPResponseRuleFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &GetAllHTTPResponseRuleFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get all HTTP response rule frontend default response
func (o *GetAllHTTPResponseRuleFrontendDefault) WithStatusCode(code int) *GetAllHTTPResponseRuleFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get all HTTP response rule frontend default response
func (o *GetAllHTTPResponseRuleFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get all HTTP response rule frontend default response
func (o *GetAllHTTPResponseRuleFrontendDefault) WithConfigurationVersion(configurationVersion string) *GetAllHTTPResponseRuleFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all HTTP response rule frontend default response
func (o *GetAllHTTPResponseRuleFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all HTTP response rule frontend default response
func (o *GetAllHTTPResponseRuleFrontendDefault) WithPayload(payload *models.Error) *GetAllHTTPResponseRuleFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all HTTP response rule frontend default response
func (o *GetAllHTTPResponseRuleFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllHTTPResponseRuleFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
