// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package maps

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetAllRuntimeMapFilesParams creates a new GetAllRuntimeMapFilesParams object
// with the default values initialized.
func NewGetAllRuntimeMapFilesParams() GetAllRuntimeMapFilesParams {

	var (
		// initialize parameters with default values

		includeUnmanagedDefault = bool(false)
	)

	return GetAllRuntimeMapFilesParams{
		IncludeUnmanaged: &includeUnmanagedDefault,
	}
}

// GetAllRuntimeMapFilesParams contains all the bound params for the get all runtime map files operation
// typically these are obtained from a http.Request
//
// swagger:parameters getAllRuntimeMapFiles
type GetAllRuntimeMapFilesParams struct {

	// HTTP Request Object
	HTTPRequest *http.Request `json:"-"`

	/*If true, also show unmanaged map files loaded in haproxy
	  In: query
	  Default: false
	*/
	IncludeUnmanaged *bool
}

// BindRequest both binds and validates a request, it assumes that complex things implement a Validatable(strfmt.Registry) error interface
// for simple values it will use straight method calls.
//
// To ensure default values, the struct must have been initialized with NewGetAllRuntimeMapFilesParams() beforehand.
func (o *GetAllRuntimeMapFilesParams) BindRequest(r *http.Request, route *middleware.MatchedRoute) error {
	var res []error

	o.HTTPRequest = r

	qs := runtime.Values(r.URL.Query())

	qIncludeUnmanaged, qhkIncludeUnmanaged, _ := qs.GetOK("include_unmanaged")
	if err := o.bindIncludeUnmanaged(qIncludeUnmanaged, qhkIncludeUnmanaged, route.Formats); err != nil {
		res = append(res, err)
	}
	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindIncludeUnmanaged binds and validates parameter IncludeUnmanaged from query.
func (o *GetAllRuntimeMapFilesParams) bindIncludeUnmanaged(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false

	if raw == "" { // empty values pass all other validations
		// Default values have been previously initialized by NewGetAllRuntimeMapFilesParams()
		return nil
	}

	value, err := swag.ConvertBool(raw)
	if err != nil {
		return errors.InvalidType("include_unmanaged", "query", "bool", raw)
	}
	o.IncludeUnmanaged = &value

	return nil
}
