// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package spoe

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetAllSpoeGroupOKCode is the HTTP code returned for type GetAllSpoeGroupOK
const GetAllSpoeGroupOKCode int = 200

/*
GetAllSpoeGroupOK Successful operation

swagger:response getAllSpoeGroupOK
*/
type GetAllSpoeGroupOK struct {
	/*Spoe configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload models.SpoeGroups `json:"body,omitempty"`
}

// NewGetAllSpoeGroupOK creates GetAllSpoeGroupOK with default headers values
func NewGetAllSpoeGroupOK() *GetAllSpoeGroupOK {

	return &GetAllSpoeGroupOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get all spoe group o k response
func (o *GetAllSpoeGroupOK) WithConfigurationVersion(configurationVersion string) *GetAllSpoeGroupOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all spoe group o k response
func (o *GetAllSpoeGroupOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all spoe group o k response
func (o *GetAllSpoeGroupOK) WithPayload(payload models.SpoeGroups) *GetAllSpoeGroupOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all spoe group o k response
func (o *GetAllSpoeGroupOK) SetPayload(payload models.SpoeGroups) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllSpoeGroupOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.SpoeGroups{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetAllSpoeGroupDefault General Error

swagger:response getAllSpoeGroupDefault
*/
type GetAllSpoeGroupDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetAllSpoeGroupDefault creates GetAllSpoeGroupDefault with default headers values
func NewGetAllSpoeGroupDefault(code int) *GetAllSpoeGroupDefault {
	if code <= 0 {
		code = 500
	}

	return &GetAllSpoeGroupDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get all spoe group default response
func (o *GetAllSpoeGroupDefault) WithStatusCode(code int) *GetAllSpoeGroupDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get all spoe group default response
func (o *GetAllSpoeGroupDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get all spoe group default response
func (o *GetAllSpoeGroupDefault) WithConfigurationVersion(configurationVersion string) *GetAllSpoeGroupDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all spoe group default response
func (o *GetAllSpoeGroupDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all spoe group default response
func (o *GetAllSpoeGroupDefault) WithPayload(payload *models.Error) *GetAllSpoeGroupDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all spoe group default response
func (o *GetAllSpoeGroupDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllSpoeGroupDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
