// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package spoe_transactions

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// CommitSpoeTransactionOKCode is the HTTP code returned for type CommitSpoeTransactionOK
const CommitSpoeTransactionOKCode int = 200

/*
CommitSpoeTransactionOK Transaction successfully committed

swagger:response commitSpoeTransactionOK
*/
type CommitSpoeTransactionOK struct {

	/*
	  In: Body
	*/
	Payload *models.SpoeTransaction `json:"body,omitempty"`
}

// NewCommitSpoeTransactionOK creates CommitSpoeTransactionOK with default headers values
func NewCommitSpoeTransactionOK() *CommitSpoeTransactionOK {

	return &CommitSpoeTransactionOK{}
}

// WithPayload adds the payload to the commit spoe transaction o k response
func (o *CommitSpoeTransactionOK) WithPayload(payload *models.SpoeTransaction) *CommitSpoeTransactionOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the commit spoe transaction o k response
func (o *CommitSpoeTransactionOK) SetPayload(payload *models.SpoeTransaction) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CommitSpoeTransactionOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CommitSpoeTransactionAcceptedCode is the HTTP code returned for type CommitSpoeTransactionAccepted
const CommitSpoeTransactionAcceptedCode int = 202

/*
CommitSpoeTransactionAccepted Configuration change accepted and reload requested

swagger:response commitSpoeTransactionAccepted
*/
type CommitSpoeTransactionAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.SpoeTransaction `json:"body,omitempty"`
}

// NewCommitSpoeTransactionAccepted creates CommitSpoeTransactionAccepted with default headers values
func NewCommitSpoeTransactionAccepted() *CommitSpoeTransactionAccepted {

	return &CommitSpoeTransactionAccepted{}
}

// WithReloadID adds the reloadId to the commit spoe transaction accepted response
func (o *CommitSpoeTransactionAccepted) WithReloadID(reloadID string) *CommitSpoeTransactionAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the commit spoe transaction accepted response
func (o *CommitSpoeTransactionAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the commit spoe transaction accepted response
func (o *CommitSpoeTransactionAccepted) WithPayload(payload *models.SpoeTransaction) *CommitSpoeTransactionAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the commit spoe transaction accepted response
func (o *CommitSpoeTransactionAccepted) SetPayload(payload *models.SpoeTransaction) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CommitSpoeTransactionAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CommitSpoeTransactionBadRequestCode is the HTTP code returned for type CommitSpoeTransactionBadRequest
const CommitSpoeTransactionBadRequestCode int = 400

/*
CommitSpoeTransactionBadRequest Bad request

swagger:response commitSpoeTransactionBadRequest
*/
type CommitSpoeTransactionBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCommitSpoeTransactionBadRequest creates CommitSpoeTransactionBadRequest with default headers values
func NewCommitSpoeTransactionBadRequest() *CommitSpoeTransactionBadRequest {

	return &CommitSpoeTransactionBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the commit spoe transaction bad request response
func (o *CommitSpoeTransactionBadRequest) WithConfigurationVersion(configurationVersion string) *CommitSpoeTransactionBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the commit spoe transaction bad request response
func (o *CommitSpoeTransactionBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the commit spoe transaction bad request response
func (o *CommitSpoeTransactionBadRequest) WithPayload(payload *models.Error) *CommitSpoeTransactionBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the commit spoe transaction bad request response
func (o *CommitSpoeTransactionBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CommitSpoeTransactionBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CommitSpoeTransactionNotFoundCode is the HTTP code returned for type CommitSpoeTransactionNotFound
const CommitSpoeTransactionNotFoundCode int = 404

/*
CommitSpoeTransactionNotFound The specified resource was not found

swagger:response commitSpoeTransactionNotFound
*/
type CommitSpoeTransactionNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCommitSpoeTransactionNotFound creates CommitSpoeTransactionNotFound with default headers values
func NewCommitSpoeTransactionNotFound() *CommitSpoeTransactionNotFound {

	return &CommitSpoeTransactionNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the commit spoe transaction not found response
func (o *CommitSpoeTransactionNotFound) WithConfigurationVersion(configurationVersion string) *CommitSpoeTransactionNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the commit spoe transaction not found response
func (o *CommitSpoeTransactionNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the commit spoe transaction not found response
func (o *CommitSpoeTransactionNotFound) WithPayload(payload *models.Error) *CommitSpoeTransactionNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the commit spoe transaction not found response
func (o *CommitSpoeTransactionNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CommitSpoeTransactionNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CommitSpoeTransactionDefault General Error

swagger:response commitSpoeTransactionDefault
*/
type CommitSpoeTransactionDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCommitSpoeTransactionDefault creates CommitSpoeTransactionDefault with default headers values
func NewCommitSpoeTransactionDefault(code int) *CommitSpoeTransactionDefault {
	if code <= 0 {
		code = 500
	}

	return &CommitSpoeTransactionDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the commit spoe transaction default response
func (o *CommitSpoeTransactionDefault) WithStatusCode(code int) *CommitSpoeTransactionDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the commit spoe transaction default response
func (o *CommitSpoeTransactionDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the commit spoe transaction default response
func (o *CommitSpoeTransactionDefault) WithConfigurationVersion(configurationVersion string) *CommitSpoeTransactionDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the commit spoe transaction default response
func (o *CommitSpoeTransactionDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the commit spoe transaction default response
func (o *CommitSpoeTransactionDefault) WithPayload(payload *models.Error) *CommitSpoeTransactionDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the commit spoe transaction default response
func (o *CommitSpoeTransactionDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CommitSpoeTransactionDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
