// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package stats

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/validate"
)

// NewGetStatsParams creates a new GetStatsParams object
//
// There are no default values defined in the spec.
func NewGetStatsParams() GetStatsParams {

	return GetStatsParams{}
}

// GetStatsParams contains all the bound params for the get stats operation
// typically these are obtained from a http.Request
//
// swagger:parameters getStats
type GetStatsParams struct {

	// HTTP Request Object
	HTTPRequest *http.Request `json:"-"`

	/*Object name to get stats for
	  In: query
	*/
	Name *string
	/*Object parent name to get stats for, in case the object is a server
	  In: query
	*/
	Parent *string
	/*Object type to get stats for (one of frontend, backend, server)
	  In: query
	*/
	Type *string
}

// BindRequest both binds and validates a request, it assumes that complex things implement a Validatable(strfmt.Registry) error interface
// for simple values it will use straight method calls.
//
// To ensure default values, the struct must have been initialized with NewGetStatsParams() beforehand.
func (o *GetStatsParams) BindRequest(r *http.Request, route *middleware.MatchedRoute) error {
	var res []error

	o.HTTPRequest = r

	qs := runtime.Values(r.URL.Query())

	qName, qhkName, _ := qs.GetOK("name")
	if err := o.bindName(qName, qhkName, route.Formats); err != nil {
		res = append(res, err)
	}

	qParent, qhkParent, _ := qs.GetOK("parent")
	if err := o.bindParent(qParent, qhkParent, route.Formats); err != nil {
		res = append(res, err)
	}

	qType, qhkType, _ := qs.GetOK("type")
	if err := o.bindType(qType, qhkType, route.Formats); err != nil {
		res = append(res, err)
	}
	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindName binds and validates parameter Name from query.
func (o *GetStatsParams) bindName(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false

	if raw == "" { // empty values pass all other validations
		return nil
	}
	o.Name = &raw

	return nil
}

// bindParent binds and validates parameter Parent from query.
func (o *GetStatsParams) bindParent(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false

	if raw == "" { // empty values pass all other validations
		return nil
	}
	o.Parent = &raw

	return nil
}

// bindType binds and validates parameter Type from query.
func (o *GetStatsParams) bindType(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false

	if raw == "" { // empty values pass all other validations
		return nil
	}
	o.Type = &raw

	if err := o.validateType(formats); err != nil {
		return err
	}

	return nil
}

// validateType carries on validations for parameter Type
func (o *GetStatsParams) validateType(formats strfmt.Registry) error {

	if err := validate.EnumCase("type", "query", *o.Type, []interface{}{"frontend", "backend", "server"}, true); err != nil {
		return err
	}

	return nil
}
