// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDeleteStorageSSLCertificateParams creates a new DeleteStorageSSLCertificateParams object
// with the default values initialized.
func NewDeleteStorageSSLCertificateParams() DeleteStorageSSLCertificateParams {

	var (
		// initialize parameters with default values

		forceReloadDefault = bool(false)

		skipReloadDefault = bool(false)
	)

	return DeleteStorageSSLCertificateParams{
		ForceReload: &forceReloadDefault,

		SkipReload: &skipReloadDefault,
	}
}

// DeleteStorageSSLCertificateParams contains all the bound params for the delete storage s s l certificate operation
// typically these are obtained from a http.Request
//
// swagger:parameters deleteStorageSSLCertificate
type DeleteStorageSSLCertificateParams struct {

	// HTTP Request Object
	HTTPRequest *http.Request `json:"-"`

	/*If set, do a force reload, do not wait for the configured reload-delay. Cannot be used when transaction is specified, as changes in transaction are not applied directly to configuration.
	  In: query
	  Default: false
	*/
	ForceReload *bool
	/*SSL certificate name
	  Required: true
	  In: path
	*/
	Name string
	/*If set, no reload will be initiated after update
	  In: query
	  Default: false
	*/
	SkipReload *bool
}

// BindRequest both binds and validates a request, it assumes that complex things implement a Validatable(strfmt.Registry) error interface
// for simple values it will use straight method calls.
//
// To ensure default values, the struct must have been initialized with NewDeleteStorageSSLCertificateParams() beforehand.
func (o *DeleteStorageSSLCertificateParams) BindRequest(r *http.Request, route *middleware.MatchedRoute) error {
	var res []error

	o.HTTPRequest = r

	qs := runtime.Values(r.URL.Query())

	qForceReload, qhkForceReload, _ := qs.GetOK("force_reload")
	if err := o.bindForceReload(qForceReload, qhkForceReload, route.Formats); err != nil {
		res = append(res, err)
	}

	rName, rhkName, _ := route.Params.GetOK("name")
	if err := o.bindName(rName, rhkName, route.Formats); err != nil {
		res = append(res, err)
	}

	qSkipReload, qhkSkipReload, _ := qs.GetOK("skip_reload")
	if err := o.bindSkipReload(qSkipReload, qhkSkipReload, route.Formats); err != nil {
		res = append(res, err)
	}
	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindForceReload binds and validates parameter ForceReload from query.
func (o *DeleteStorageSSLCertificateParams) bindForceReload(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false

	if raw == "" { // empty values pass all other validations
		// Default values have been previously initialized by NewDeleteStorageSSLCertificateParams()
		return nil
	}

	value, err := swag.ConvertBool(raw)
	if err != nil {
		return errors.InvalidType("force_reload", "query", "bool", raw)
	}
	o.ForceReload = &value

	return nil
}

// bindName binds and validates parameter Name from path.
func (o *DeleteStorageSSLCertificateParams) bindName(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: true
	// Parameter is provided by construction from the route
	o.Name = raw

	return nil
}

// bindSkipReload binds and validates parameter SkipReload from query.
func (o *DeleteStorageSSLCertificateParams) bindSkipReload(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false

	if raw == "" { // empty values pass all other validations
		// Default values have been previously initialized by NewDeleteStorageSSLCertificateParams()
		return nil
	}

	value, err := swag.ConvertBool(raw)
	if err != nil {
		return errors.InvalidType("skip_reload", "query", "bool", raw)
	}
	o.SkipReload = &value

	return nil
}
