// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package tcp_request_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceAllTCPRequestRuleFrontendOKCode is the HTTP code returned for type ReplaceAllTCPRequestRuleFrontendOK
const ReplaceAllTCPRequestRuleFrontendOKCode int = 200

/*
ReplaceAllTCPRequestRuleFrontendOK All TCP Request Rule lines replaced

swagger:response replaceAllTcpRequestRuleFrontendOK
*/
type ReplaceAllTCPRequestRuleFrontendOK struct {

	/*
	  In: Body
	*/
	Payload models.TCPRequestRules `json:"body,omitempty"`
}

// NewReplaceAllTCPRequestRuleFrontendOK creates ReplaceAllTCPRequestRuleFrontendOK with default headers values
func NewReplaceAllTCPRequestRuleFrontendOK() *ReplaceAllTCPRequestRuleFrontendOK {

	return &ReplaceAllTCPRequestRuleFrontendOK{}
}

// WithPayload adds the payload to the replace all Tcp request rule frontend o k response
func (o *ReplaceAllTCPRequestRuleFrontendOK) WithPayload(payload models.TCPRequestRules) *ReplaceAllTCPRequestRuleFrontendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all Tcp request rule frontend o k response
func (o *ReplaceAllTCPRequestRuleFrontendOK) SetPayload(payload models.TCPRequestRules) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllTCPRequestRuleFrontendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.TCPRequestRules{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceAllTCPRequestRuleFrontendAcceptedCode is the HTTP code returned for type ReplaceAllTCPRequestRuleFrontendAccepted
const ReplaceAllTCPRequestRuleFrontendAcceptedCode int = 202

/*
ReplaceAllTCPRequestRuleFrontendAccepted Configuration change accepted and reload requested

swagger:response replaceAllTcpRequestRuleFrontendAccepted
*/
type ReplaceAllTCPRequestRuleFrontendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload models.TCPRequestRules `json:"body,omitempty"`
}

// NewReplaceAllTCPRequestRuleFrontendAccepted creates ReplaceAllTCPRequestRuleFrontendAccepted with default headers values
func NewReplaceAllTCPRequestRuleFrontendAccepted() *ReplaceAllTCPRequestRuleFrontendAccepted {

	return &ReplaceAllTCPRequestRuleFrontendAccepted{}
}

// WithReloadID adds the reloadId to the replace all Tcp request rule frontend accepted response
func (o *ReplaceAllTCPRequestRuleFrontendAccepted) WithReloadID(reloadID string) *ReplaceAllTCPRequestRuleFrontendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace all Tcp request rule frontend accepted response
func (o *ReplaceAllTCPRequestRuleFrontendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace all Tcp request rule frontend accepted response
func (o *ReplaceAllTCPRequestRuleFrontendAccepted) WithPayload(payload models.TCPRequestRules) *ReplaceAllTCPRequestRuleFrontendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all Tcp request rule frontend accepted response
func (o *ReplaceAllTCPRequestRuleFrontendAccepted) SetPayload(payload models.TCPRequestRules) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllTCPRequestRuleFrontendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.TCPRequestRules{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceAllTCPRequestRuleFrontendBadRequestCode is the HTTP code returned for type ReplaceAllTCPRequestRuleFrontendBadRequest
const ReplaceAllTCPRequestRuleFrontendBadRequestCode int = 400

/*
ReplaceAllTCPRequestRuleFrontendBadRequest Bad request

swagger:response replaceAllTcpRequestRuleFrontendBadRequest
*/
type ReplaceAllTCPRequestRuleFrontendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceAllTCPRequestRuleFrontendBadRequest creates ReplaceAllTCPRequestRuleFrontendBadRequest with default headers values
func NewReplaceAllTCPRequestRuleFrontendBadRequest() *ReplaceAllTCPRequestRuleFrontendBadRequest {

	return &ReplaceAllTCPRequestRuleFrontendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace all Tcp request rule frontend bad request response
func (o *ReplaceAllTCPRequestRuleFrontendBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceAllTCPRequestRuleFrontendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace all Tcp request rule frontend bad request response
func (o *ReplaceAllTCPRequestRuleFrontendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace all Tcp request rule frontend bad request response
func (o *ReplaceAllTCPRequestRuleFrontendBadRequest) WithPayload(payload *models.Error) *ReplaceAllTCPRequestRuleFrontendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all Tcp request rule frontend bad request response
func (o *ReplaceAllTCPRequestRuleFrontendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllTCPRequestRuleFrontendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceAllTCPRequestRuleFrontendDefault General Error

swagger:response replaceAllTcpRequestRuleFrontendDefault
*/
type ReplaceAllTCPRequestRuleFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceAllTCPRequestRuleFrontendDefault creates ReplaceAllTCPRequestRuleFrontendDefault with default headers values
func NewReplaceAllTCPRequestRuleFrontendDefault(code int) *ReplaceAllTCPRequestRuleFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceAllTCPRequestRuleFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace all TCP request rule frontend default response
func (o *ReplaceAllTCPRequestRuleFrontendDefault) WithStatusCode(code int) *ReplaceAllTCPRequestRuleFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace all TCP request rule frontend default response
func (o *ReplaceAllTCPRequestRuleFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace all TCP request rule frontend default response
func (o *ReplaceAllTCPRequestRuleFrontendDefault) WithConfigurationVersion(configurationVersion string) *ReplaceAllTCPRequestRuleFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace all TCP request rule frontend default response
func (o *ReplaceAllTCPRequestRuleFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace all TCP request rule frontend default response
func (o *ReplaceAllTCPRequestRuleFrontendDefault) WithPayload(payload *models.Error) *ReplaceAllTCPRequestRuleFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all TCP request rule frontend default response
func (o *ReplaceAllTCPRequestRuleFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllTCPRequestRuleFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
