/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.data.order;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDRowIdentifier;
import org.jkiss.dbeaver.model.data.order.OrderingPolicy;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;

public final class OrderingUtils {
    private static final Log log = Log.getLog(OrderingUtils.class);

    private OrderingUtils() {
    }

    public static boolean addOrderingOnClientSide(@NotNull DBDDataFilter dataFilter, @Nullable DBDRowIdentifier rowIdentifier, @NotNull OrderingPolicy policy) {
        if (policy == OrderingPolicy.DEFAULT) {
            return false;
        }
        if (rowIdentifier == null || rowIdentifier.isIncomplete()) {
            return false;
        }
        for (DBDAttributeBinding binding : rowIdentifier.getAttributes()) {
            DBDAttributeConstraint constraint = dataFilter.getConstraint(binding);
            if (constraint == null) continue;
            constraint.setOrderPosition(dataFilter.getMaxOrderingPosition() + 1);
            constraint.setOrderDescending(policy == OrderingPolicy.PRIMARY_KEY_DESC);
        }
        return true;
    }

    public static void addOrderingOnServerSide(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntity entity, @NotNull DBDDataFilter dataFilter, @NotNull OrderingPolicy policy) {
        if (!entity.getDataSource().getSQLDialect().supportsOrderByIndex() || policy == OrderingPolicy.DEFAULT) {
            return;
        }
        List<Object> attrs = List.of();
        try {
            attrs = DBUtils.getBestTableIdentifier(monitor, entity);
        }
        catch (DBException exception) {
            log.warn("Can't get table identifier", exception);
        }
        if (attrs.isEmpty()) {
            return;
        }
        dataFilter.setOrder(String.join((CharSequence)",", attrs.stream().map(attr -> DBUtils.getQuotedIdentifier(entity.getDataSource(), attr.getName())).toList()) + " " + (policy == OrderingPolicy.PRIMARY_KEY_DESC ? "DESC" : "ASC"));
    }
}

