/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPAdaptable;
import org.jkiss.dbeaver.model.ai.engine.AIEngineProperties;
import org.jkiss.dbeaver.model.ai.registry.AIEngineDescriptor;
import org.jkiss.dbeaver.model.ai.registry.AIEngineRegistry;
import org.jkiss.dbeaver.model.ai.registry.AISettingsManager;

public class AISettings
implements DBPAdaptable {
    private boolean aiDisabled;
    private String activeEngine;
    private final Map<String, AIEngineProperties> engineConfigurations = new LinkedHashMap<String, AIEngineProperties>();
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();
    private final Set<String> resolvedSecrets = new HashSet<String>();
    private final Set<String> enabledFunctionCategories = new LinkedHashSet<String>();
    private final Set<String> enabledFunctions = new LinkedHashSet<String>();

    public Map<String, Object> getAllProperties() {
        return this.properties;
    }

    public <T> T getProperty(@NotNull String name, @Nullable T defaultValue) {
        return (T)this.properties.getOrDefault(name, defaultValue);
    }

    public void setProperty(@NotNull String name, @Nullable Object value) {
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, value);
        }
    }

    @NotNull
    public Set<String> getEnabledFunctions() {
        return new HashSet<String>(this.enabledFunctions);
    }

    public void setEnabledFunctions(@Nullable Set<String> functions) {
        this.enabledFunctions.clear();
        if (functions != null) {
            this.enabledFunctions.addAll(functions);
        }
    }

    public boolean isFunctionEnabled(@NotNull String functionId) {
        return this.enabledFunctions.contains(functionId);
    }

    public void enableFunction(@NotNull String functionId) {
        this.enabledFunctions.add(functionId);
    }

    public void disableFunction(@NotNull String functionId) {
        this.enabledFunctions.remove(functionId);
    }

    @NotNull
    public Set<String> getEnabledFunctionCategories() {
        return new HashSet<String>(this.enabledFunctionCategories);
    }

    public void setEnabledFunctionCategories(@Nullable Set<String> categories) {
        this.enabledFunctionCategories.clear();
        if (categories != null) {
            this.enabledFunctionCategories.addAll(categories);
        }
    }

    public boolean isFunctionCategoryEnabled(String category) {
        return this.enabledFunctionCategories.contains(category);
    }

    public void enableFunctionCategory(@NotNull String category) {
        this.enabledFunctionCategories.add(category);
    }

    public void disableFunctionCategory(@NotNull String category) {
        this.enabledFunctionCategories.remove(category);
    }

    public boolean isAiDisabled() {
        return this.aiDisabled;
    }

    public void setAiDisabled(boolean aiDisabled) {
        this.aiDisabled = aiDisabled;
    }

    public String activeEngine() {
        return this.activeEngine;
    }

    public void setActiveEngine(String activeEngine) {
        AIEngineDescriptor engineDescriptor = AIEngineRegistry.getInstance().getEngineDescriptor(activeEngine);
        if (engineDescriptor != null) {
            activeEngine = engineDescriptor.getId();
        }
        this.activeEngine = activeEngine;
    }

    public boolean hasConfiguration(String engineId) {
        return this.engineConfigurations.containsKey(engineId);
    }

    @NotNull
    public synchronized <T extends AIEngineProperties> T getEngineConfiguration(@NotNull String engineId) throws DBException {
        AIEngineDescriptor engineDescriptor = AIEngineRegistry.getInstance().getEngineDescriptor(engineId);
        if (engineDescriptor == null) {
            throw new DBException("AI engine " + engineId + " not found");
        }
        AIEngineProperties aiEngineSettings = this.engineConfigurations.get(engineId);
        if (aiEngineSettings == null) {
            aiEngineSettings = engineDescriptor.createPropertiesInstance();
        }
        if (aiEngineSettings != null && !AISettingsManager.saveSecretsAsPlainText() && !this.resolvedSecrets.contains(engineId)) {
            aiEngineSettings.resolveSecrets();
            this.resolvedSecrets.add(engineId);
        }
        return (T)aiEngineSettings;
    }

    public Map<String, AIEngineProperties> getEngineConfigurations() {
        return this.engineConfigurations;
    }

    public void setEngineConfiguration(@NotNull String engineId, @NotNull AIEngineProperties engineConfiguration) {
        this.engineConfigurations.put(engineId, engineConfiguration);
    }

    public void setEngineConfigurations(@NotNull Map<String, AIEngineProperties> engineConfigurations) {
        this.engineConfigurations.putAll(engineConfigurations);
    }

    public void saveSecrets() throws DBException {
        for (Map.Entry<String, AIEngineProperties> entry : this.engineConfigurations.entrySet()) {
            String engineId = entry.getKey();
            AIEngineProperties engineConfiguration = entry.getValue();
            if (!this.resolvedSecrets.contains(engineId)) continue;
            engineConfiguration.saveSecrets();
        }
    }

    public <T> T getAdapter(@NotNull Class<T> adapter) {
        return null;
    }
}

