#!/bin/sh

set -e
set -u
trap "exit 128" INT

script_path="${0}"
script_root="$(dirname "${script_path}")"

source_root="$(realpath "${script_root}/..")"
cache_path="${source_root}/.cache"

output_path="${cache_path}/output"
dll_file="${output_path}/GentooDotnetInfo.dll"

: "${DOTNET:=dotnet}"
: "${MAKE:=make}"

if [ -e "${dll_file}" ] ; then
    :
else
    "${MAKE}" -C "${source_root}" DOTNET="${DOTNET}" build
fi

exec "${DOTNET}" exec "${dll_file}" "${@}"
