#[allow(clippy::invisible_characters)]

#[test]
fn all_entities() {
	assert_eq!(super::consume(b"AElig"), Some(("Æ", 5)));
	assert_eq!(super::consume(b"AElig;"), Some(("Æ", 6)));
	assert_eq!(super::consume(b"AMP"), Some(("&", 3)));
	assert_eq!(super::consume(b"AMP;"), Some(("&", 4)));
	assert_eq!(super::consume(b"Aacute"), Some(("Á", 6)));
	assert_eq!(super::consume(b"Aacute;"), Some(("Á", 7)));
	assert_eq!(super::consume(b"Abreve;"), Some(("Ă", 7)));
	assert_eq!(super::consume(b"Acirc"), Some(("Â", 5)));
	assert_eq!(super::consume(b"Acirc;"), Some(("Â", 6)));
	assert_eq!(super::consume(b"Acy;"), Some(("А", 4)));
	assert_eq!(super::consume(b"Afr;"), Some(("𝔄", 4)));
	assert_eq!(super::consume(b"Agrave"), Some(("À", 6)));
	assert_eq!(super::consume(b"Agrave;"), Some(("À", 7)));
	assert_eq!(super::consume(b"Alpha;"), Some(("Α", 6)));
	assert_eq!(super::consume(b"Amacr;"), Some(("Ā", 6)));
	assert_eq!(super::consume(b"And;"), Some(("⩓", 4)));
	assert_eq!(super::consume(b"Aogon;"), Some(("Ą", 6)));
	assert_eq!(super::consume(b"Aopf;"), Some(("𝔸", 5)));
	assert_eq!(super::consume(b"ApplyFunction;"), Some(("⁡", 14)));
	assert_eq!(super::consume(b"Aring"), Some(("Å", 5)));
	assert_eq!(super::consume(b"Aring;"), Some(("Å", 6)));
	assert_eq!(super::consume(b"Ascr;"), Some(("𝒜", 5)));
	assert_eq!(super::consume(b"Assign;"), Some(("≔", 7)));
	assert_eq!(super::consume(b"Atilde"), Some(("Ã", 6)));
	assert_eq!(super::consume(b"Atilde;"), Some(("Ã", 7)));
	assert_eq!(super::consume(b"Auml"), Some(("Ä", 4)));
	assert_eq!(super::consume(b"Auml;"), Some(("Ä", 5)));
	assert_eq!(super::consume(b"Backslash;"), Some(("∖", 10)));
	assert_eq!(super::consume(b"Barv;"), Some(("⫧", 5)));
	assert_eq!(super::consume(b"Barwed;"), Some(("⌆", 7)));
	assert_eq!(super::consume(b"Bcy;"), Some(("Б", 4)));
	assert_eq!(super::consume(b"Because;"), Some(("∵", 8)));
	assert_eq!(super::consume(b"Bernoullis;"), Some(("ℬ", 11)));
	assert_eq!(super::consume(b"Beta;"), Some(("Β", 5)));
	assert_eq!(super::consume(b"Bfr;"), Some(("𝔅", 4)));
	assert_eq!(super::consume(b"Bopf;"), Some(("𝔹", 5)));
	assert_eq!(super::consume(b"Breve;"), Some(("˘", 6)));
	assert_eq!(super::consume(b"Bscr;"), Some(("ℬ", 5)));
	assert_eq!(super::consume(b"Bumpeq;"), Some(("≎", 7)));
	assert_eq!(super::consume(b"CHcy;"), Some(("Ч", 5)));
	assert_eq!(super::consume(b"COPY"), Some(("©", 4)));
	assert_eq!(super::consume(b"COPY;"), Some(("©", 5)));
	assert_eq!(super::consume(b"Cacute;"), Some(("Ć", 7)));
	assert_eq!(super::consume(b"Cap;"), Some(("⋒", 4)));
	assert_eq!(super::consume(b"CapitalDifferentialD;"), Some(("ⅅ", 21)));
	assert_eq!(super::consume(b"Cayleys;"), Some(("ℭ", 8)));
	assert_eq!(super::consume(b"Ccaron;"), Some(("Č", 7)));
	assert_eq!(super::consume(b"Ccedil"), Some(("Ç", 6)));
	assert_eq!(super::consume(b"Ccedil;"), Some(("Ç", 7)));
	assert_eq!(super::consume(b"Ccirc;"), Some(("Ĉ", 6)));
	assert_eq!(super::consume(b"Cconint;"), Some(("∰", 8)));
	assert_eq!(super::consume(b"Cdot;"), Some(("Ċ", 5)));
	assert_eq!(super::consume(b"Cedilla;"), Some(("¸", 8)));
	assert_eq!(super::consume(b"CenterDot;"), Some(("·", 10)));
	assert_eq!(super::consume(b"Cfr;"), Some(("ℭ", 4)));
	assert_eq!(super::consume(b"Chi;"), Some(("Χ", 4)));
	assert_eq!(super::consume(b"CircleDot;"), Some(("⊙", 10)));
	assert_eq!(super::consume(b"CircleMinus;"), Some(("⊖", 12)));
	assert_eq!(super::consume(b"CirclePlus;"), Some(("⊕", 11)));
	assert_eq!(super::consume(b"CircleTimes;"), Some(("⊗", 12)));
	assert_eq!(super::consume(b"ClockwiseContourIntegral;"), Some(("∲", 25)));
	assert_eq!(super::consume(b"CloseCurlyDoubleQuote;"), Some(("”", 22)));
	assert_eq!(super::consume(b"CloseCurlyQuote;"), Some(("’", 16)));
	assert_eq!(super::consume(b"Colon;"), Some(("∷", 6)));
	assert_eq!(super::consume(b"Colone;"), Some(("⩴", 7)));
	assert_eq!(super::consume(b"Congruent;"), Some(("≡", 10)));
	assert_eq!(super::consume(b"Conint;"), Some(("∯", 7)));
	assert_eq!(super::consume(b"ContourIntegral;"), Some(("∮", 16)));
	assert_eq!(super::consume(b"Copf;"), Some(("ℂ", 5)));
	assert_eq!(super::consume(b"Coproduct;"), Some(("∐", 10)));
	assert_eq!(super::consume(b"CounterClockwiseContourIntegral;"), Some(("∳", 32)));
	assert_eq!(super::consume(b"Cross;"), Some(("⨯", 6)));
	assert_eq!(super::consume(b"Cscr;"), Some(("𝒞", 5)));
	assert_eq!(super::consume(b"Cup;"), Some(("⋓", 4)));
	assert_eq!(super::consume(b"CupCap;"), Some(("≍", 7)));
	assert_eq!(super::consume(b"DD;"), Some(("ⅅ", 3)));
	assert_eq!(super::consume(b"DDotrahd;"), Some(("⤑", 9)));
	assert_eq!(super::consume(b"DJcy;"), Some(("Ђ", 5)));
	assert_eq!(super::consume(b"DScy;"), Some(("Ѕ", 5)));
	assert_eq!(super::consume(b"DZcy;"), Some(("Џ", 5)));
	assert_eq!(super::consume(b"Dagger;"), Some(("‡", 7)));
	assert_eq!(super::consume(b"Darr;"), Some(("↡", 5)));
	assert_eq!(super::consume(b"Dashv;"), Some(("⫤", 6)));
	assert_eq!(super::consume(b"Dcaron;"), Some(("Ď", 7)));
	assert_eq!(super::consume(b"Dcy;"), Some(("Д", 4)));
	assert_eq!(super::consume(b"Del;"), Some(("∇", 4)));
	assert_eq!(super::consume(b"Delta;"), Some(("Δ", 6)));
	assert_eq!(super::consume(b"Dfr;"), Some(("𝔇", 4)));
	assert_eq!(super::consume(b"DiacriticalAcute;"), Some(("´", 17)));
	assert_eq!(super::consume(b"DiacriticalDot;"), Some(("˙", 15)));
	assert_eq!(super::consume(b"DiacriticalDoubleAcute;"), Some(("˝", 23)));
	assert_eq!(super::consume(b"DiacriticalGrave;"), Some(("`", 17)));
	assert_eq!(super::consume(b"DiacriticalTilde;"), Some(("˜", 17)));
	assert_eq!(super::consume(b"Diamond;"), Some(("⋄", 8)));
	assert_eq!(super::consume(b"DifferentialD;"), Some(("ⅆ", 14)));
	assert_eq!(super::consume(b"Dopf;"), Some(("𝔻", 5)));
	assert_eq!(super::consume(b"Dot;"), Some(("¨", 4)));
	assert_eq!(super::consume(b"DotDot;"), Some(("⃜", 7)));
	assert_eq!(super::consume(b"DotEqual;"), Some(("≐", 9)));
	assert_eq!(super::consume(b"DoubleContourIntegral;"), Some(("∯", 22)));
	assert_eq!(super::consume(b"DoubleDot;"), Some(("¨", 10)));
	assert_eq!(super::consume(b"DoubleDownArrow;"), Some(("⇓", 16)));
	assert_eq!(super::consume(b"DoubleLeftArrow;"), Some(("⇐", 16)));
	assert_eq!(super::consume(b"DoubleLeftRightArrow;"), Some(("⇔", 21)));
	assert_eq!(super::consume(b"DoubleLeftTee;"), Some(("⫤", 14)));
	assert_eq!(super::consume(b"DoubleLongLeftArrow;"), Some(("⟸", 20)));
	assert_eq!(super::consume(b"DoubleLongLeftRightArrow;"), Some(("⟺", 25)));
	assert_eq!(super::consume(b"DoubleLongRightArrow;"), Some(("⟹", 21)));
	assert_eq!(super::consume(b"DoubleRightArrow;"), Some(("⇒", 17)));
	assert_eq!(super::consume(b"DoubleRightTee;"), Some(("⊨", 15)));
	assert_eq!(super::consume(b"DoubleUpArrow;"), Some(("⇑", 14)));
	assert_eq!(super::consume(b"DoubleUpDownArrow;"), Some(("⇕", 18)));
	assert_eq!(super::consume(b"DoubleVerticalBar;"), Some(("∥", 18)));
	assert_eq!(super::consume(b"DownArrow;"), Some(("↓", 10)));
	assert_eq!(super::consume(b"DownArrowBar;"), Some(("⤓", 13)));
	assert_eq!(super::consume(b"DownArrowUpArrow;"), Some(("⇵", 17)));
	assert_eq!(super::consume(b"DownBreve;"), Some(("̑", 10)));
	assert_eq!(super::consume(b"DownLeftRightVector;"), Some(("⥐", 20)));
	assert_eq!(super::consume(b"DownLeftTeeVector;"), Some(("⥞", 18)));
	assert_eq!(super::consume(b"DownLeftVector;"), Some(("↽", 15)));
	assert_eq!(super::consume(b"DownLeftVectorBar;"), Some(("⥖", 18)));
	assert_eq!(super::consume(b"DownRightTeeVector;"), Some(("⥟", 19)));
	assert_eq!(super::consume(b"DownRightVector;"), Some(("⇁", 16)));
	assert_eq!(super::consume(b"DownRightVectorBar;"), Some(("⥗", 19)));
	assert_eq!(super::consume(b"DownTee;"), Some(("⊤", 8)));
	assert_eq!(super::consume(b"DownTeeArrow;"), Some(("↧", 13)));
	assert_eq!(super::consume(b"Downarrow;"), Some(("⇓", 10)));
	assert_eq!(super::consume(b"Dscr;"), Some(("𝒟", 5)));
	assert_eq!(super::consume(b"Dstrok;"), Some(("Đ", 7)));
	assert_eq!(super::consume(b"ENG;"), Some(("Ŋ", 4)));
	assert_eq!(super::consume(b"ETH"), Some(("Ð", 3)));
	assert_eq!(super::consume(b"ETH;"), Some(("Ð", 4)));
	assert_eq!(super::consume(b"Eacute"), Some(("É", 6)));
	assert_eq!(super::consume(b"Eacute;"), Some(("É", 7)));
	assert_eq!(super::consume(b"Ecaron;"), Some(("Ě", 7)));
	assert_eq!(super::consume(b"Ecirc"), Some(("Ê", 5)));
	assert_eq!(super::consume(b"Ecirc;"), Some(("Ê", 6)));
	assert_eq!(super::consume(b"Ecy;"), Some(("Э", 4)));
	assert_eq!(super::consume(b"Edot;"), Some(("Ė", 5)));
	assert_eq!(super::consume(b"Efr;"), Some(("𝔈", 4)));
	assert_eq!(super::consume(b"Egrave"), Some(("È", 6)));
	assert_eq!(super::consume(b"Egrave;"), Some(("È", 7)));
	assert_eq!(super::consume(b"Element;"), Some(("∈", 8)));
	assert_eq!(super::consume(b"Emacr;"), Some(("Ē", 6)));
	assert_eq!(super::consume(b"EmptySmallSquare;"), Some(("◻", 17)));
	assert_eq!(super::consume(b"EmptyVerySmallSquare;"), Some(("▫", 21)));
	assert_eq!(super::consume(b"Eogon;"), Some(("Ę", 6)));
	assert_eq!(super::consume(b"Eopf;"), Some(("𝔼", 5)));
	assert_eq!(super::consume(b"Epsilon;"), Some(("Ε", 8)));
	assert_eq!(super::consume(b"Equal;"), Some(("⩵", 6)));
	assert_eq!(super::consume(b"EqualTilde;"), Some(("≂", 11)));
	assert_eq!(super::consume(b"Equilibrium;"), Some(("⇌", 12)));
	assert_eq!(super::consume(b"Escr;"), Some(("ℰ", 5)));
	assert_eq!(super::consume(b"Esim;"), Some(("⩳", 5)));
	assert_eq!(super::consume(b"Eta;"), Some(("Η", 4)));
	assert_eq!(super::consume(b"Euml"), Some(("Ë", 4)));
	assert_eq!(super::consume(b"Euml;"), Some(("Ë", 5)));
	assert_eq!(super::consume(b"Exists;"), Some(("∃", 7)));
	assert_eq!(super::consume(b"ExponentialE;"), Some(("ⅇ", 13)));
	assert_eq!(super::consume(b"Fcy;"), Some(("Ф", 4)));
	assert_eq!(super::consume(b"Ffr;"), Some(("𝔉", 4)));
	assert_eq!(super::consume(b"FilledSmallSquare;"), Some(("◼", 18)));
	assert_eq!(super::consume(b"FilledVerySmallSquare;"), Some(("▪", 22)));
	assert_eq!(super::consume(b"Fopf;"), Some(("𝔽", 5)));
	assert_eq!(super::consume(b"ForAll;"), Some(("∀", 7)));
	assert_eq!(super::consume(b"Fouriertrf;"), Some(("ℱ", 11)));
	assert_eq!(super::consume(b"Fscr;"), Some(("ℱ", 5)));
	assert_eq!(super::consume(b"GJcy;"), Some(("Ѓ", 5)));
	assert_eq!(super::consume(b"GT"), Some((">", 2)));
	assert_eq!(super::consume(b"GT;"), Some((">", 3)));
	assert_eq!(super::consume(b"Gamma;"), Some(("Γ", 6)));
	assert_eq!(super::consume(b"Gammad;"), Some(("Ϝ", 7)));
	assert_eq!(super::consume(b"Gbreve;"), Some(("Ğ", 7)));
	assert_eq!(super::consume(b"Gcedil;"), Some(("Ģ", 7)));
	assert_eq!(super::consume(b"Gcirc;"), Some(("Ĝ", 6)));
	assert_eq!(super::consume(b"Gcy;"), Some(("Г", 4)));
	assert_eq!(super::consume(b"Gdot;"), Some(("Ġ", 5)));
	assert_eq!(super::consume(b"Gfr;"), Some(("𝔊", 4)));
	assert_eq!(super::consume(b"Gg;"), Some(("⋙", 3)));
	assert_eq!(super::consume(b"Gopf;"), Some(("𝔾", 5)));
	assert_eq!(super::consume(b"GreaterEqual;"), Some(("≥", 13)));
	assert_eq!(super::consume(b"GreaterEqualLess;"), Some(("⋛", 17)));
	assert_eq!(super::consume(b"GreaterFullEqual;"), Some(("≧", 17)));
	assert_eq!(super::consume(b"GreaterGreater;"), Some(("⪢", 15)));
	assert_eq!(super::consume(b"GreaterLess;"), Some(("≷", 12)));
	assert_eq!(super::consume(b"GreaterSlantEqual;"), Some(("⩾", 18)));
	assert_eq!(super::consume(b"GreaterTilde;"), Some(("≳", 13)));
	assert_eq!(super::consume(b"Gscr;"), Some(("𝒢", 5)));
	assert_eq!(super::consume(b"Gt;"), Some(("≫", 3)));
	assert_eq!(super::consume(b"HARDcy;"), Some(("Ъ", 7)));
	assert_eq!(super::consume(b"Hacek;"), Some(("ˇ", 6)));
	assert_eq!(super::consume(b"Hat;"), Some(("^", 4)));
	assert_eq!(super::consume(b"Hcirc;"), Some(("Ĥ", 6)));
	assert_eq!(super::consume(b"Hfr;"), Some(("ℌ", 4)));
	assert_eq!(super::consume(b"HilbertSpace;"), Some(("ℋ", 13)));
	assert_eq!(super::consume(b"Hopf;"), Some(("ℍ", 5)));
	assert_eq!(super::consume(b"HorizontalLine;"), Some(("─", 15)));
	assert_eq!(super::consume(b"Hscr;"), Some(("ℋ", 5)));
	assert_eq!(super::consume(b"Hstrok;"), Some(("Ħ", 7)));
	assert_eq!(super::consume(b"HumpDownHump;"), Some(("≎", 13)));
	assert_eq!(super::consume(b"HumpEqual;"), Some(("≏", 10)));
	assert_eq!(super::consume(b"IEcy;"), Some(("Е", 5)));
	assert_eq!(super::consume(b"IJlig;"), Some(("Ĳ", 6)));
	assert_eq!(super::consume(b"IOcy;"), Some(("Ё", 5)));
	assert_eq!(super::consume(b"Iacute"), Some(("Í", 6)));
	assert_eq!(super::consume(b"Iacute;"), Some(("Í", 7)));
	assert_eq!(super::consume(b"Icirc"), Some(("Î", 5)));
	assert_eq!(super::consume(b"Icirc;"), Some(("Î", 6)));
	assert_eq!(super::consume(b"Icy;"), Some(("И", 4)));
	assert_eq!(super::consume(b"Idot;"), Some(("İ", 5)));
	assert_eq!(super::consume(b"Ifr;"), Some(("ℑ", 4)));
	assert_eq!(super::consume(b"Igrave"), Some(("Ì", 6)));
	assert_eq!(super::consume(b"Igrave;"), Some(("Ì", 7)));
	assert_eq!(super::consume(b"Im;"), Some(("ℑ", 3)));
	assert_eq!(super::consume(b"Imacr;"), Some(("Ī", 6)));
	assert_eq!(super::consume(b"ImaginaryI;"), Some(("ⅈ", 11)));
	assert_eq!(super::consume(b"Implies;"), Some(("⇒", 8)));
	assert_eq!(super::consume(b"Int;"), Some(("∬", 4)));
	assert_eq!(super::consume(b"Integral;"), Some(("∫", 9)));
	assert_eq!(super::consume(b"Intersection;"), Some(("⋂", 13)));
	assert_eq!(super::consume(b"InvisibleComma;"), Some(("⁣", 15)));
	assert_eq!(super::consume(b"InvisibleTimes;"), Some(("⁢", 15)));
	assert_eq!(super::consume(b"Iogon;"), Some(("Į", 6)));
	assert_eq!(super::consume(b"Iopf;"), Some(("𝕀", 5)));
	assert_eq!(super::consume(b"Iota;"), Some(("Ι", 5)));
	assert_eq!(super::consume(b"Iscr;"), Some(("ℐ", 5)));
	assert_eq!(super::consume(b"Itilde;"), Some(("Ĩ", 7)));
	assert_eq!(super::consume(b"Iukcy;"), Some(("І", 6)));
	assert_eq!(super::consume(b"Iuml"), Some(("Ï", 4)));
	assert_eq!(super::consume(b"Iuml;"), Some(("Ï", 5)));
	assert_eq!(super::consume(b"Jcirc;"), Some(("Ĵ", 6)));
	assert_eq!(super::consume(b"Jcy;"), Some(("Й", 4)));
	assert_eq!(super::consume(b"Jfr;"), Some(("𝔍", 4)));
	assert_eq!(super::consume(b"Jopf;"), Some(("𝕁", 5)));
	assert_eq!(super::consume(b"Jscr;"), Some(("𝒥", 5)));
	assert_eq!(super::consume(b"Jsercy;"), Some(("Ј", 7)));
	assert_eq!(super::consume(b"Jukcy;"), Some(("Є", 6)));
	assert_eq!(super::consume(b"KHcy;"), Some(("Х", 5)));
	assert_eq!(super::consume(b"KJcy;"), Some(("Ќ", 5)));
	assert_eq!(super::consume(b"Kappa;"), Some(("Κ", 6)));
	assert_eq!(super::consume(b"Kcedil;"), Some(("Ķ", 7)));
	assert_eq!(super::consume(b"Kcy;"), Some(("К", 4)));
	assert_eq!(super::consume(b"Kfr;"), Some(("𝔎", 4)));
	assert_eq!(super::consume(b"Kopf;"), Some(("𝕂", 5)));
	assert_eq!(super::consume(b"Kscr;"), Some(("𝒦", 5)));
	assert_eq!(super::consume(b"LJcy;"), Some(("Љ", 5)));
	assert_eq!(super::consume(b"LT"), Some(("<", 2)));
	assert_eq!(super::consume(b"LT;"), Some(("<", 3)));
	assert_eq!(super::consume(b"Lacute;"), Some(("Ĺ", 7)));
	assert_eq!(super::consume(b"Lambda;"), Some(("Λ", 7)));
	assert_eq!(super::consume(b"Lang;"), Some(("⟪", 5)));
	assert_eq!(super::consume(b"Laplacetrf;"), Some(("ℒ", 11)));
	assert_eq!(super::consume(b"Larr;"), Some(("↞", 5)));
	assert_eq!(super::consume(b"Lcaron;"), Some(("Ľ", 7)));
	assert_eq!(super::consume(b"Lcedil;"), Some(("Ļ", 7)));
	assert_eq!(super::consume(b"Lcy;"), Some(("Л", 4)));
	assert_eq!(super::consume(b"LeftAngleBracket;"), Some(("⟨", 17)));
	assert_eq!(super::consume(b"LeftArrow;"), Some(("←", 10)));
	assert_eq!(super::consume(b"LeftArrowBar;"), Some(("⇤", 13)));
	assert_eq!(super::consume(b"LeftArrowRightArrow;"), Some(("⇆", 20)));
	assert_eq!(super::consume(b"LeftCeiling;"), Some(("⌈", 12)));
	assert_eq!(super::consume(b"LeftDoubleBracket;"), Some(("⟦", 18)));
	assert_eq!(super::consume(b"LeftDownTeeVector;"), Some(("⥡", 18)));
	assert_eq!(super::consume(b"LeftDownVector;"), Some(("⇃", 15)));
	assert_eq!(super::consume(b"LeftDownVectorBar;"), Some(("⥙", 18)));
	assert_eq!(super::consume(b"LeftFloor;"), Some(("⌊", 10)));
	assert_eq!(super::consume(b"LeftRightArrow;"), Some(("↔", 15)));
	assert_eq!(super::consume(b"LeftRightVector;"), Some(("⥎", 16)));
	assert_eq!(super::consume(b"LeftTee;"), Some(("⊣", 8)));
	assert_eq!(super::consume(b"LeftTeeArrow;"), Some(("↤", 13)));
	assert_eq!(super::consume(b"LeftTeeVector;"), Some(("⥚", 14)));
	assert_eq!(super::consume(b"LeftTriangle;"), Some(("⊲", 13)));
	assert_eq!(super::consume(b"LeftTriangleBar;"), Some(("⧏", 16)));
	assert_eq!(super::consume(b"LeftTriangleEqual;"), Some(("⊴", 18)));
	assert_eq!(super::consume(b"LeftUpDownVector;"), Some(("⥑", 17)));
	assert_eq!(super::consume(b"LeftUpTeeVector;"), Some(("⥠", 16)));
	assert_eq!(super::consume(b"LeftUpVector;"), Some(("↿", 13)));
	assert_eq!(super::consume(b"LeftUpVectorBar;"), Some(("⥘", 16)));
	assert_eq!(super::consume(b"LeftVector;"), Some(("↼", 11)));
	assert_eq!(super::consume(b"LeftVectorBar;"), Some(("⥒", 14)));
	assert_eq!(super::consume(b"Leftarrow;"), Some(("⇐", 10)));
	assert_eq!(super::consume(b"Leftrightarrow;"), Some(("⇔", 15)));
	assert_eq!(super::consume(b"LessEqualGreater;"), Some(("⋚", 17)));
	assert_eq!(super::consume(b"LessFullEqual;"), Some(("≦", 14)));
	assert_eq!(super::consume(b"LessGreater;"), Some(("≶", 12)));
	assert_eq!(super::consume(b"LessLess;"), Some(("⪡", 9)));
	assert_eq!(super::consume(b"LessSlantEqual;"), Some(("⩽", 15)));
	assert_eq!(super::consume(b"LessTilde;"), Some(("≲", 10)));
	assert_eq!(super::consume(b"Lfr;"), Some(("𝔏", 4)));
	assert_eq!(super::consume(b"Ll;"), Some(("⋘", 3)));
	assert_eq!(super::consume(b"Lleftarrow;"), Some(("⇚", 11)));
	assert_eq!(super::consume(b"Lmidot;"), Some(("Ŀ", 7)));
	assert_eq!(super::consume(b"LongLeftArrow;"), Some(("⟵", 14)));
	assert_eq!(super::consume(b"LongLeftRightArrow;"), Some(("⟷", 19)));
	assert_eq!(super::consume(b"LongRightArrow;"), Some(("⟶", 15)));
	assert_eq!(super::consume(b"Longleftarrow;"), Some(("⟸", 14)));
	assert_eq!(super::consume(b"Longleftrightarrow;"), Some(("⟺", 19)));
	assert_eq!(super::consume(b"Longrightarrow;"), Some(("⟹", 15)));
	assert_eq!(super::consume(b"Lopf;"), Some(("𝕃", 5)));
	assert_eq!(super::consume(b"LowerLeftArrow;"), Some(("↙", 15)));
	assert_eq!(super::consume(b"LowerRightArrow;"), Some(("↘", 16)));
	assert_eq!(super::consume(b"Lscr;"), Some(("ℒ", 5)));
	assert_eq!(super::consume(b"Lsh;"), Some(("↰", 4)));
	assert_eq!(super::consume(b"Lstrok;"), Some(("Ł", 7)));
	assert_eq!(super::consume(b"Lt;"), Some(("≪", 3)));
	assert_eq!(super::consume(b"Map;"), Some(("⤅", 4)));
	assert_eq!(super::consume(b"Mcy;"), Some(("М", 4)));
	assert_eq!(super::consume(b"MediumSpace;"), Some((" ", 12)));
	assert_eq!(super::consume(b"Mellintrf;"), Some(("ℳ", 10)));
	assert_eq!(super::consume(b"Mfr;"), Some(("𝔐", 4)));
	assert_eq!(super::consume(b"MinusPlus;"), Some(("∓", 10)));
	assert_eq!(super::consume(b"Mopf;"), Some(("𝕄", 5)));
	assert_eq!(super::consume(b"Mscr;"), Some(("ℳ", 5)));
	assert_eq!(super::consume(b"Mu;"), Some(("Μ", 3)));
	assert_eq!(super::consume(b"NJcy;"), Some(("Њ", 5)));
	assert_eq!(super::consume(b"Nacute;"), Some(("Ń", 7)));
	assert_eq!(super::consume(b"Ncaron;"), Some(("Ň", 7)));
	assert_eq!(super::consume(b"Ncedil;"), Some(("Ņ", 7)));
	assert_eq!(super::consume(b"Ncy;"), Some(("Н", 4)));
	assert_eq!(super::consume(b"NegativeMediumSpace;"), Some(("​", 20)));
	assert_eq!(super::consume(b"NegativeThickSpace;"), Some(("​", 19)));
	assert_eq!(super::consume(b"NegativeThinSpace;"), Some(("​", 18)));
	assert_eq!(super::consume(b"NegativeVeryThinSpace;"), Some(("​", 22)));
	assert_eq!(super::consume(b"NestedGreaterGreater;"), Some(("≫", 21)));
	assert_eq!(super::consume(b"NestedLessLess;"), Some(("≪", 15)));
	assert_eq!(super::consume(b"NewLine;"), Some(("
", 8)));
	assert_eq!(super::consume(b"Nfr;"), Some(("𝔑", 4)));
	assert_eq!(super::consume(b"NoBreak;"), Some(("⁠", 8)));
	assert_eq!(super::consume(b"NonBreakingSpace;"), Some((" ", 17)));
	assert_eq!(super::consume(b"Nopf;"), Some(("ℕ", 5)));
	assert_eq!(super::consume(b"Not;"), Some(("⫬", 4)));
	assert_eq!(super::consume(b"NotCongruent;"), Some(("≢", 13)));
	assert_eq!(super::consume(b"NotCupCap;"), Some(("≭", 10)));
	assert_eq!(super::consume(b"NotDoubleVerticalBar;"), Some(("∦", 21)));
	assert_eq!(super::consume(b"NotElement;"), Some(("∉", 11)));
	assert_eq!(super::consume(b"NotEqual;"), Some(("≠", 9)));
	assert_eq!(super::consume(b"NotEqualTilde;"), Some(("≂̸", 14)));
	assert_eq!(super::consume(b"NotExists;"), Some(("∄", 10)));
	assert_eq!(super::consume(b"NotGreater;"), Some(("≯", 11)));
	assert_eq!(super::consume(b"NotGreaterEqual;"), Some(("≱", 16)));
	assert_eq!(super::consume(b"NotGreaterFullEqual;"), Some(("≧̸", 20)));
	assert_eq!(super::consume(b"NotGreaterGreater;"), Some(("≫̸", 18)));
	assert_eq!(super::consume(b"NotGreaterLess;"), Some(("≹", 15)));
	assert_eq!(super::consume(b"NotGreaterSlantEqual;"), Some(("⩾̸", 21)));
	assert_eq!(super::consume(b"NotGreaterTilde;"), Some(("≵", 16)));
	assert_eq!(super::consume(b"NotHumpDownHump;"), Some(("≎̸", 16)));
	assert_eq!(super::consume(b"NotHumpEqual;"), Some(("≏̸", 13)));
	assert_eq!(super::consume(b"NotLeftTriangle;"), Some(("⋪", 16)));
	assert_eq!(super::consume(b"NotLeftTriangleBar;"), Some(("⧏̸", 19)));
	assert_eq!(super::consume(b"NotLeftTriangleEqual;"), Some(("⋬", 21)));
	assert_eq!(super::consume(b"NotLess;"), Some(("≮", 8)));
	assert_eq!(super::consume(b"NotLessEqual;"), Some(("≰", 13)));
	assert_eq!(super::consume(b"NotLessGreater;"), Some(("≸", 15)));
	assert_eq!(super::consume(b"NotLessLess;"), Some(("≪̸", 12)));
	assert_eq!(super::consume(b"NotLessSlantEqual;"), Some(("⩽̸", 18)));
	assert_eq!(super::consume(b"NotLessTilde;"), Some(("≴", 13)));
	assert_eq!(super::consume(b"NotNestedGreaterGreater;"), Some(("⪢̸", 24)));
	assert_eq!(super::consume(b"NotNestedLessLess;"), Some(("⪡̸", 18)));
	assert_eq!(super::consume(b"NotPrecedes;"), Some(("⊀", 12)));
	assert_eq!(super::consume(b"NotPrecedesEqual;"), Some(("⪯̸", 17)));
	assert_eq!(super::consume(b"NotPrecedesSlantEqual;"), Some(("⋠", 22)));
	assert_eq!(super::consume(b"NotReverseElement;"), Some(("∌", 18)));
	assert_eq!(super::consume(b"NotRightTriangle;"), Some(("⋫", 17)));
	assert_eq!(super::consume(b"NotRightTriangleBar;"), Some(("⧐̸", 20)));
	assert_eq!(super::consume(b"NotRightTriangleEqual;"), Some(("⋭", 22)));
	assert_eq!(super::consume(b"NotSquareSubset;"), Some(("⊏̸", 16)));
	assert_eq!(super::consume(b"NotSquareSubsetEqual;"), Some(("⋢", 21)));
	assert_eq!(super::consume(b"NotSquareSuperset;"), Some(("⊐̸", 18)));
	assert_eq!(super::consume(b"NotSquareSupersetEqual;"), Some(("⋣", 23)));
	assert_eq!(super::consume(b"NotSubset;"), Some(("⊂⃒", 10)));
	assert_eq!(super::consume(b"NotSubsetEqual;"), Some(("⊈", 15)));
	assert_eq!(super::consume(b"NotSucceeds;"), Some(("⊁", 12)));
	assert_eq!(super::consume(b"NotSucceedsEqual;"), Some(("⪰̸", 17)));
	assert_eq!(super::consume(b"NotSucceedsSlantEqual;"), Some(("⋡", 22)));
	assert_eq!(super::consume(b"NotSucceedsTilde;"), Some(("≿̸", 17)));
	assert_eq!(super::consume(b"NotSuperset;"), Some(("⊃⃒", 12)));
	assert_eq!(super::consume(b"NotSupersetEqual;"), Some(("⊉", 17)));
	assert_eq!(super::consume(b"NotTilde;"), Some(("≁", 9)));
	assert_eq!(super::consume(b"NotTildeEqual;"), Some(("≄", 14)));
	assert_eq!(super::consume(b"NotTildeFullEqual;"), Some(("≇", 18)));
	assert_eq!(super::consume(b"NotTildeTilde;"), Some(("≉", 14)));
	assert_eq!(super::consume(b"NotVerticalBar;"), Some(("∤", 15)));
	assert_eq!(super::consume(b"Nscr;"), Some(("𝒩", 5)));
	assert_eq!(super::consume(b"Ntilde"), Some(("Ñ", 6)));
	assert_eq!(super::consume(b"Ntilde;"), Some(("Ñ", 7)));
	assert_eq!(super::consume(b"Nu;"), Some(("Ν", 3)));
	assert_eq!(super::consume(b"OElig;"), Some(("Œ", 6)));
	assert_eq!(super::consume(b"Oacute"), Some(("Ó", 6)));
	assert_eq!(super::consume(b"Oacute;"), Some(("Ó", 7)));
	assert_eq!(super::consume(b"Ocirc"), Some(("Ô", 5)));
	assert_eq!(super::consume(b"Ocirc;"), Some(("Ô", 6)));
	assert_eq!(super::consume(b"Ocy;"), Some(("О", 4)));
	assert_eq!(super::consume(b"Odblac;"), Some(("Ő", 7)));
	assert_eq!(super::consume(b"Ofr;"), Some(("𝔒", 4)));
	assert_eq!(super::consume(b"Ograve"), Some(("Ò", 6)));
	assert_eq!(super::consume(b"Ograve;"), Some(("Ò", 7)));
	assert_eq!(super::consume(b"Omacr;"), Some(("Ō", 6)));
	assert_eq!(super::consume(b"Omega;"), Some(("Ω", 6)));
	assert_eq!(super::consume(b"Omicron;"), Some(("Ο", 8)));
	assert_eq!(super::consume(b"Oopf;"), Some(("𝕆", 5)));
	assert_eq!(super::consume(b"OpenCurlyDoubleQuote;"), Some(("“", 21)));
	assert_eq!(super::consume(b"OpenCurlyQuote;"), Some(("‘", 15)));
	assert_eq!(super::consume(b"Or;"), Some(("⩔", 3)));
	assert_eq!(super::consume(b"Oscr;"), Some(("𝒪", 5)));
	assert_eq!(super::consume(b"Oslash"), Some(("Ø", 6)));
	assert_eq!(super::consume(b"Oslash;"), Some(("Ø", 7)));
	assert_eq!(super::consume(b"Otilde"), Some(("Õ", 6)));
	assert_eq!(super::consume(b"Otilde;"), Some(("Õ", 7)));
	assert_eq!(super::consume(b"Otimes;"), Some(("⨷", 7)));
	assert_eq!(super::consume(b"Ouml"), Some(("Ö", 4)));
	assert_eq!(super::consume(b"Ouml;"), Some(("Ö", 5)));
	assert_eq!(super::consume(b"OverBar;"), Some(("‾", 8)));
	assert_eq!(super::consume(b"OverBrace;"), Some(("⏞", 10)));
	assert_eq!(super::consume(b"OverBracket;"), Some(("⎴", 12)));
	assert_eq!(super::consume(b"OverParenthesis;"), Some(("⏜", 16)));
	assert_eq!(super::consume(b"PartialD;"), Some(("∂", 9)));
	assert_eq!(super::consume(b"Pcy;"), Some(("П", 4)));
	assert_eq!(super::consume(b"Pfr;"), Some(("𝔓", 4)));
	assert_eq!(super::consume(b"Phi;"), Some(("Φ", 4)));
	assert_eq!(super::consume(b"Pi;"), Some(("Π", 3)));
	assert_eq!(super::consume(b"PlusMinus;"), Some(("±", 10)));
	assert_eq!(super::consume(b"Poincareplane;"), Some(("ℌ", 14)));
	assert_eq!(super::consume(b"Popf;"), Some(("ℙ", 5)));
	assert_eq!(super::consume(b"Pr;"), Some(("⪻", 3)));
	assert_eq!(super::consume(b"Precedes;"), Some(("≺", 9)));
	assert_eq!(super::consume(b"PrecedesEqual;"), Some(("⪯", 14)));
	assert_eq!(super::consume(b"PrecedesSlantEqual;"), Some(("≼", 19)));
	assert_eq!(super::consume(b"PrecedesTilde;"), Some(("≾", 14)));
	assert_eq!(super::consume(b"Prime;"), Some(("″", 6)));
	assert_eq!(super::consume(b"Product;"), Some(("∏", 8)));
	assert_eq!(super::consume(b"Proportion;"), Some(("∷", 11)));
	assert_eq!(super::consume(b"Proportional;"), Some(("∝", 13)));
	assert_eq!(super::consume(b"Pscr;"), Some(("𝒫", 5)));
	assert_eq!(super::consume(b"Psi;"), Some(("Ψ", 4)));
	assert_eq!(super::consume(b"QUOT"), Some(("\"", 4)));
	assert_eq!(super::consume(b"QUOT;"), Some(("\"", 5)));
	assert_eq!(super::consume(b"Qfr;"), Some(("𝔔", 4)));
	assert_eq!(super::consume(b"Qopf;"), Some(("ℚ", 5)));
	assert_eq!(super::consume(b"Qscr;"), Some(("𝒬", 5)));
	assert_eq!(super::consume(b"RBarr;"), Some(("⤐", 6)));
	assert_eq!(super::consume(b"REG"), Some(("®", 3)));
	assert_eq!(super::consume(b"REG;"), Some(("®", 4)));
	assert_eq!(super::consume(b"Racute;"), Some(("Ŕ", 7)));
	assert_eq!(super::consume(b"Rang;"), Some(("⟫", 5)));
	assert_eq!(super::consume(b"Rarr;"), Some(("↠", 5)));
	assert_eq!(super::consume(b"Rarrtl;"), Some(("⤖", 7)));
	assert_eq!(super::consume(b"Rcaron;"), Some(("Ř", 7)));
	assert_eq!(super::consume(b"Rcedil;"), Some(("Ŗ", 7)));
	assert_eq!(super::consume(b"Rcy;"), Some(("Р", 4)));
	assert_eq!(super::consume(b"Re;"), Some(("ℜ", 3)));
	assert_eq!(super::consume(b"ReverseElement;"), Some(("∋", 15)));
	assert_eq!(super::consume(b"ReverseEquilibrium;"), Some(("⇋", 19)));
	assert_eq!(super::consume(b"ReverseUpEquilibrium;"), Some(("⥯", 21)));
	assert_eq!(super::consume(b"Rfr;"), Some(("ℜ", 4)));
	assert_eq!(super::consume(b"Rho;"), Some(("Ρ", 4)));
	assert_eq!(super::consume(b"RightAngleBracket;"), Some(("⟩", 18)));
	assert_eq!(super::consume(b"RightArrow;"), Some(("→", 11)));
	assert_eq!(super::consume(b"RightArrowBar;"), Some(("⇥", 14)));
	assert_eq!(super::consume(b"RightArrowLeftArrow;"), Some(("⇄", 20)));
	assert_eq!(super::consume(b"RightCeiling;"), Some(("⌉", 13)));
	assert_eq!(super::consume(b"RightDoubleBracket;"), Some(("⟧", 19)));
	assert_eq!(super::consume(b"RightDownTeeVector;"), Some(("⥝", 19)));
	assert_eq!(super::consume(b"RightDownVector;"), Some(("⇂", 16)));
	assert_eq!(super::consume(b"RightDownVectorBar;"), Some(("⥕", 19)));
	assert_eq!(super::consume(b"RightFloor;"), Some(("⌋", 11)));
	assert_eq!(super::consume(b"RightTee;"), Some(("⊢", 9)));
	assert_eq!(super::consume(b"RightTeeArrow;"), Some(("↦", 14)));
	assert_eq!(super::consume(b"RightTeeVector;"), Some(("⥛", 15)));
	assert_eq!(super::consume(b"RightTriangle;"), Some(("⊳", 14)));
	assert_eq!(super::consume(b"RightTriangleBar;"), Some(("⧐", 17)));
	assert_eq!(super::consume(b"RightTriangleEqual;"), Some(("⊵", 19)));
	assert_eq!(super::consume(b"RightUpDownVector;"), Some(("⥏", 18)));
	assert_eq!(super::consume(b"RightUpTeeVector;"), Some(("⥜", 17)));
	assert_eq!(super::consume(b"RightUpVector;"), Some(("↾", 14)));
	assert_eq!(super::consume(b"RightUpVectorBar;"), Some(("⥔", 17)));
	assert_eq!(super::consume(b"RightVector;"), Some(("⇀", 12)));
	assert_eq!(super::consume(b"RightVectorBar;"), Some(("⥓", 15)));
	assert_eq!(super::consume(b"Rightarrow;"), Some(("⇒", 11)));
	assert_eq!(super::consume(b"Ropf;"), Some(("ℝ", 5)));
	assert_eq!(super::consume(b"RoundImplies;"), Some(("⥰", 13)));
	assert_eq!(super::consume(b"Rrightarrow;"), Some(("⇛", 12)));
	assert_eq!(super::consume(b"Rscr;"), Some(("ℛ", 5)));
	assert_eq!(super::consume(b"Rsh;"), Some(("↱", 4)));
	assert_eq!(super::consume(b"RuleDelayed;"), Some(("⧴", 12)));
	assert_eq!(super::consume(b"SHCHcy;"), Some(("Щ", 7)));
	assert_eq!(super::consume(b"SHcy;"), Some(("Ш", 5)));
	assert_eq!(super::consume(b"SOFTcy;"), Some(("Ь", 7)));
	assert_eq!(super::consume(b"Sacute;"), Some(("Ś", 7)));
	assert_eq!(super::consume(b"Sc;"), Some(("⪼", 3)));
	assert_eq!(super::consume(b"Scaron;"), Some(("Š", 7)));
	assert_eq!(super::consume(b"Scedil;"), Some(("Ş", 7)));
	assert_eq!(super::consume(b"Scirc;"), Some(("Ŝ", 6)));
	assert_eq!(super::consume(b"Scy;"), Some(("С", 4)));
	assert_eq!(super::consume(b"Sfr;"), Some(("𝔖", 4)));
	assert_eq!(super::consume(b"ShortDownArrow;"), Some(("↓", 15)));
	assert_eq!(super::consume(b"ShortLeftArrow;"), Some(("←", 15)));
	assert_eq!(super::consume(b"ShortRightArrow;"), Some(("→", 16)));
	assert_eq!(super::consume(b"ShortUpArrow;"), Some(("↑", 13)));
	assert_eq!(super::consume(b"Sigma;"), Some(("Σ", 6)));
	assert_eq!(super::consume(b"SmallCircle;"), Some(("∘", 12)));
	assert_eq!(super::consume(b"Sopf;"), Some(("𝕊", 5)));
	assert_eq!(super::consume(b"Sqrt;"), Some(("√", 5)));
	assert_eq!(super::consume(b"Square;"), Some(("□", 7)));
	assert_eq!(super::consume(b"SquareIntersection;"), Some(("⊓", 19)));
	assert_eq!(super::consume(b"SquareSubset;"), Some(("⊏", 13)));
	assert_eq!(super::consume(b"SquareSubsetEqual;"), Some(("⊑", 18)));
	assert_eq!(super::consume(b"SquareSuperset;"), Some(("⊐", 15)));
	assert_eq!(super::consume(b"SquareSupersetEqual;"), Some(("⊒", 20)));
	assert_eq!(super::consume(b"SquareUnion;"), Some(("⊔", 12)));
	assert_eq!(super::consume(b"Sscr;"), Some(("𝒮", 5)));
	assert_eq!(super::consume(b"Star;"), Some(("⋆", 5)));
	assert_eq!(super::consume(b"Sub;"), Some(("⋐", 4)));
	assert_eq!(super::consume(b"Subset;"), Some(("⋐", 7)));
	assert_eq!(super::consume(b"SubsetEqual;"), Some(("⊆", 12)));
	assert_eq!(super::consume(b"Succeeds;"), Some(("≻", 9)));
	assert_eq!(super::consume(b"SucceedsEqual;"), Some(("⪰", 14)));
	assert_eq!(super::consume(b"SucceedsSlantEqual;"), Some(("≽", 19)));
	assert_eq!(super::consume(b"SucceedsTilde;"), Some(("≿", 14)));
	assert_eq!(super::consume(b"SuchThat;"), Some(("∋", 9)));
	assert_eq!(super::consume(b"Sum;"), Some(("∑", 4)));
	assert_eq!(super::consume(b"Sup;"), Some(("⋑", 4)));
	assert_eq!(super::consume(b"Superset;"), Some(("⊃", 9)));
	assert_eq!(super::consume(b"SupersetEqual;"), Some(("⊇", 14)));
	assert_eq!(super::consume(b"Supset;"), Some(("⋑", 7)));
	assert_eq!(super::consume(b"THORN"), Some(("Þ", 5)));
	assert_eq!(super::consume(b"THORN;"), Some(("Þ", 6)));
	assert_eq!(super::consume(b"TRADE;"), Some(("™", 6)));
	assert_eq!(super::consume(b"TSHcy;"), Some(("Ћ", 6)));
	assert_eq!(super::consume(b"TScy;"), Some(("Ц", 5)));
	assert_eq!(super::consume(b"Tab;"), Some(("	", 4)));
	assert_eq!(super::consume(b"Tau;"), Some(("Τ", 4)));
	assert_eq!(super::consume(b"Tcaron;"), Some(("Ť", 7)));
	assert_eq!(super::consume(b"Tcedil;"), Some(("Ţ", 7)));
	assert_eq!(super::consume(b"Tcy;"), Some(("Т", 4)));
	assert_eq!(super::consume(b"Tfr;"), Some(("𝔗", 4)));
	assert_eq!(super::consume(b"Therefore;"), Some(("∴", 10)));
	assert_eq!(super::consume(b"Theta;"), Some(("Θ", 6)));
	assert_eq!(super::consume(b"ThickSpace;"), Some(("  ", 11)));
	assert_eq!(super::consume(b"ThinSpace;"), Some((" ", 10)));
	assert_eq!(super::consume(b"Tilde;"), Some(("∼", 6)));
	assert_eq!(super::consume(b"TildeEqual;"), Some(("≃", 11)));
	assert_eq!(super::consume(b"TildeFullEqual;"), Some(("≅", 15)));
	assert_eq!(super::consume(b"TildeTilde;"), Some(("≈", 11)));
	assert_eq!(super::consume(b"Topf;"), Some(("𝕋", 5)));
	assert_eq!(super::consume(b"TripleDot;"), Some(("⃛", 10)));
	assert_eq!(super::consume(b"Tscr;"), Some(("𝒯", 5)));
	assert_eq!(super::consume(b"Tstrok;"), Some(("Ŧ", 7)));
	assert_eq!(super::consume(b"Uacute"), Some(("Ú", 6)));
	assert_eq!(super::consume(b"Uacute;"), Some(("Ú", 7)));
	assert_eq!(super::consume(b"Uarr;"), Some(("↟", 5)));
	assert_eq!(super::consume(b"Uarrocir;"), Some(("⥉", 9)));
	assert_eq!(super::consume(b"Ubrcy;"), Some(("Ў", 6)));
	assert_eq!(super::consume(b"Ubreve;"), Some(("Ŭ", 7)));
	assert_eq!(super::consume(b"Ucirc"), Some(("Û", 5)));
	assert_eq!(super::consume(b"Ucirc;"), Some(("Û", 6)));
	assert_eq!(super::consume(b"Ucy;"), Some(("У", 4)));
	assert_eq!(super::consume(b"Udblac;"), Some(("Ű", 7)));
	assert_eq!(super::consume(b"Ufr;"), Some(("𝔘", 4)));
	assert_eq!(super::consume(b"Ugrave"), Some(("Ù", 6)));
	assert_eq!(super::consume(b"Ugrave;"), Some(("Ù", 7)));
	assert_eq!(super::consume(b"Umacr;"), Some(("Ū", 6)));
	assert_eq!(super::consume(b"UnderBar;"), Some(("_", 9)));
	assert_eq!(super::consume(b"UnderBrace;"), Some(("⏟", 11)));
	assert_eq!(super::consume(b"UnderBracket;"), Some(("⎵", 13)));
	assert_eq!(super::consume(b"UnderParenthesis;"), Some(("⏝", 17)));
	assert_eq!(super::consume(b"Union;"), Some(("⋃", 6)));
	assert_eq!(super::consume(b"UnionPlus;"), Some(("⊎", 10)));
	assert_eq!(super::consume(b"Uogon;"), Some(("Ų", 6)));
	assert_eq!(super::consume(b"Uopf;"), Some(("𝕌", 5)));
	assert_eq!(super::consume(b"UpArrow;"), Some(("↑", 8)));
	assert_eq!(super::consume(b"UpArrowBar;"), Some(("⤒", 11)));
	assert_eq!(super::consume(b"UpArrowDownArrow;"), Some(("⇅", 17)));
	assert_eq!(super::consume(b"UpDownArrow;"), Some(("↕", 12)));
	assert_eq!(super::consume(b"UpEquilibrium;"), Some(("⥮", 14)));
	assert_eq!(super::consume(b"UpTee;"), Some(("⊥", 6)));
	assert_eq!(super::consume(b"UpTeeArrow;"), Some(("↥", 11)));
	assert_eq!(super::consume(b"Uparrow;"), Some(("⇑", 8)));
	assert_eq!(super::consume(b"Updownarrow;"), Some(("⇕", 12)));
	assert_eq!(super::consume(b"UpperLeftArrow;"), Some(("↖", 15)));
	assert_eq!(super::consume(b"UpperRightArrow;"), Some(("↗", 16)));
	assert_eq!(super::consume(b"Upsi;"), Some(("ϒ", 5)));
	assert_eq!(super::consume(b"Upsilon;"), Some(("Υ", 8)));
	assert_eq!(super::consume(b"Uring;"), Some(("Ů", 6)));
	assert_eq!(super::consume(b"Uscr;"), Some(("𝒰", 5)));
	assert_eq!(super::consume(b"Utilde;"), Some(("Ũ", 7)));
	assert_eq!(super::consume(b"Uuml"), Some(("Ü", 4)));
	assert_eq!(super::consume(b"Uuml;"), Some(("Ü", 5)));
	assert_eq!(super::consume(b"VDash;"), Some(("⊫", 6)));
	assert_eq!(super::consume(b"Vbar;"), Some(("⫫", 5)));
	assert_eq!(super::consume(b"Vcy;"), Some(("В", 4)));
	assert_eq!(super::consume(b"Vdash;"), Some(("⊩", 6)));
	assert_eq!(super::consume(b"Vdashl;"), Some(("⫦", 7)));
	assert_eq!(super::consume(b"Vee;"), Some(("⋁", 4)));
	assert_eq!(super::consume(b"Verbar;"), Some(("‖", 7)));
	assert_eq!(super::consume(b"Vert;"), Some(("‖", 5)));
	assert_eq!(super::consume(b"VerticalBar;"), Some(("∣", 12)));
	assert_eq!(super::consume(b"VerticalLine;"), Some(("|", 13)));
	assert_eq!(super::consume(b"VerticalSeparator;"), Some(("❘", 18)));
	assert_eq!(super::consume(b"VerticalTilde;"), Some(("≀", 14)));
	assert_eq!(super::consume(b"VeryThinSpace;"), Some((" ", 14)));
	assert_eq!(super::consume(b"Vfr;"), Some(("𝔙", 4)));
	assert_eq!(super::consume(b"Vopf;"), Some(("𝕍", 5)));
	assert_eq!(super::consume(b"Vscr;"), Some(("𝒱", 5)));
	assert_eq!(super::consume(b"Vvdash;"), Some(("⊪", 7)));
	assert_eq!(super::consume(b"Wcirc;"), Some(("Ŵ", 6)));
	assert_eq!(super::consume(b"Wedge;"), Some(("⋀", 6)));
	assert_eq!(super::consume(b"Wfr;"), Some(("𝔚", 4)));
	assert_eq!(super::consume(b"Wopf;"), Some(("𝕎", 5)));
	assert_eq!(super::consume(b"Wscr;"), Some(("𝒲", 5)));
	assert_eq!(super::consume(b"Xfr;"), Some(("𝔛", 4)));
	assert_eq!(super::consume(b"Xi;"), Some(("Ξ", 3)));
	assert_eq!(super::consume(b"Xopf;"), Some(("𝕏", 5)));
	assert_eq!(super::consume(b"Xscr;"), Some(("𝒳", 5)));
	assert_eq!(super::consume(b"YAcy;"), Some(("Я", 5)));
	assert_eq!(super::consume(b"YIcy;"), Some(("Ї", 5)));
	assert_eq!(super::consume(b"YUcy;"), Some(("Ю", 5)));
	assert_eq!(super::consume(b"Yacute"), Some(("Ý", 6)));
	assert_eq!(super::consume(b"Yacute;"), Some(("Ý", 7)));
	assert_eq!(super::consume(b"Ycirc;"), Some(("Ŷ", 6)));
	assert_eq!(super::consume(b"Ycy;"), Some(("Ы", 4)));
	assert_eq!(super::consume(b"Yfr;"), Some(("𝔜", 4)));
	assert_eq!(super::consume(b"Yopf;"), Some(("𝕐", 5)));
	assert_eq!(super::consume(b"Yscr;"), Some(("𝒴", 5)));
	assert_eq!(super::consume(b"Yuml;"), Some(("Ÿ", 5)));
	assert_eq!(super::consume(b"ZHcy;"), Some(("Ж", 5)));
	assert_eq!(super::consume(b"Zacute;"), Some(("Ź", 7)));
	assert_eq!(super::consume(b"Zcaron;"), Some(("Ž", 7)));
	assert_eq!(super::consume(b"Zcy;"), Some(("З", 4)));
	assert_eq!(super::consume(b"Zdot;"), Some(("Ż", 5)));
	assert_eq!(super::consume(b"ZeroWidthSpace;"), Some(("​", 15)));
	assert_eq!(super::consume(b"Zeta;"), Some(("Ζ", 5)));
	assert_eq!(super::consume(b"Zfr;"), Some(("ℨ", 4)));
	assert_eq!(super::consume(b"Zopf;"), Some(("ℤ", 5)));
	assert_eq!(super::consume(b"Zscr;"), Some(("𝒵", 5)));
	assert_eq!(super::consume(b"aacute"), Some(("á", 6)));
	assert_eq!(super::consume(b"aacute;"), Some(("á", 7)));
	assert_eq!(super::consume(b"abreve;"), Some(("ă", 7)));
	assert_eq!(super::consume(b"ac;"), Some(("∾", 3)));
	assert_eq!(super::consume(b"acE;"), Some(("∾̳", 4)));
	assert_eq!(super::consume(b"acd;"), Some(("∿", 4)));
	assert_eq!(super::consume(b"acirc"), Some(("â", 5)));
	assert_eq!(super::consume(b"acirc;"), Some(("â", 6)));
	assert_eq!(super::consume(b"acute"), Some(("´", 5)));
	assert_eq!(super::consume(b"acute;"), Some(("´", 6)));
	assert_eq!(super::consume(b"acy;"), Some(("а", 4)));
	assert_eq!(super::consume(b"aelig"), Some(("æ", 5)));
	assert_eq!(super::consume(b"aelig;"), Some(("æ", 6)));
	assert_eq!(super::consume(b"af;"), Some(("⁡", 3)));
	assert_eq!(super::consume(b"afr;"), Some(("𝔞", 4)));
	assert_eq!(super::consume(b"agrave"), Some(("à", 6)));
	assert_eq!(super::consume(b"agrave;"), Some(("à", 7)));
	assert_eq!(super::consume(b"alefsym;"), Some(("ℵ", 8)));
	assert_eq!(super::consume(b"aleph;"), Some(("ℵ", 6)));
	assert_eq!(super::consume(b"alpha;"), Some(("α", 6)));
	assert_eq!(super::consume(b"amacr;"), Some(("ā", 6)));
	assert_eq!(super::consume(b"amalg;"), Some(("⨿", 6)));
	assert_eq!(super::consume(b"amp"), Some(("&", 3)));
	assert_eq!(super::consume(b"amp;"), Some(("&", 4)));
	assert_eq!(super::consume(b"and;"), Some(("∧", 4)));
	assert_eq!(super::consume(b"andand;"), Some(("⩕", 7)));
	assert_eq!(super::consume(b"andd;"), Some(("⩜", 5)));
	assert_eq!(super::consume(b"andslope;"), Some(("⩘", 9)));
	assert_eq!(super::consume(b"andv;"), Some(("⩚", 5)));
	assert_eq!(super::consume(b"ang;"), Some(("∠", 4)));
	assert_eq!(super::consume(b"ange;"), Some(("⦤", 5)));
	assert_eq!(super::consume(b"angle;"), Some(("∠", 6)));
	assert_eq!(super::consume(b"angmsd;"), Some(("∡", 7)));
	assert_eq!(super::consume(b"angmsdaa;"), Some(("⦨", 9)));
	assert_eq!(super::consume(b"angmsdab;"), Some(("⦩", 9)));
	assert_eq!(super::consume(b"angmsdac;"), Some(("⦪", 9)));
	assert_eq!(super::consume(b"angmsdad;"), Some(("⦫", 9)));
	assert_eq!(super::consume(b"angmsdae;"), Some(("⦬", 9)));
	assert_eq!(super::consume(b"angmsdaf;"), Some(("⦭", 9)));
	assert_eq!(super::consume(b"angmsdag;"), Some(("⦮", 9)));
	assert_eq!(super::consume(b"angmsdah;"), Some(("⦯", 9)));
	assert_eq!(super::consume(b"angrt;"), Some(("∟", 6)));
	assert_eq!(super::consume(b"angrtvb;"), Some(("⊾", 8)));
	assert_eq!(super::consume(b"angrtvbd;"), Some(("⦝", 9)));
	assert_eq!(super::consume(b"angsph;"), Some(("∢", 7)));
	assert_eq!(super::consume(b"angst;"), Some(("Å", 6)));
	assert_eq!(super::consume(b"angzarr;"), Some(("⍼", 8)));
	assert_eq!(super::consume(b"aogon;"), Some(("ą", 6)));
	assert_eq!(super::consume(b"aopf;"), Some(("𝕒", 5)));
	assert_eq!(super::consume(b"ap;"), Some(("≈", 3)));
	assert_eq!(super::consume(b"apE;"), Some(("⩰", 4)));
	assert_eq!(super::consume(b"apacir;"), Some(("⩯", 7)));
	assert_eq!(super::consume(b"ape;"), Some(("≊", 4)));
	assert_eq!(super::consume(b"apid;"), Some(("≋", 5)));
	assert_eq!(super::consume(b"apos;"), Some(("'", 5)));
	assert_eq!(super::consume(b"approx;"), Some(("≈", 7)));
	assert_eq!(super::consume(b"approxeq;"), Some(("≊", 9)));
	assert_eq!(super::consume(b"aring"), Some(("å", 5)));
	assert_eq!(super::consume(b"aring;"), Some(("å", 6)));
	assert_eq!(super::consume(b"ascr;"), Some(("𝒶", 5)));
	assert_eq!(super::consume(b"ast;"), Some(("*", 4)));
	assert_eq!(super::consume(b"asymp;"), Some(("≈", 6)));
	assert_eq!(super::consume(b"asympeq;"), Some(("≍", 8)));
	assert_eq!(super::consume(b"atilde"), Some(("ã", 6)));
	assert_eq!(super::consume(b"atilde;"), Some(("ã", 7)));
	assert_eq!(super::consume(b"auml"), Some(("ä", 4)));
	assert_eq!(super::consume(b"auml;"), Some(("ä", 5)));
	assert_eq!(super::consume(b"awconint;"), Some(("∳", 9)));
	assert_eq!(super::consume(b"awint;"), Some(("⨑", 6)));
	assert_eq!(super::consume(b"bNot;"), Some(("⫭", 5)));
	assert_eq!(super::consume(b"backcong;"), Some(("≌", 9)));
	assert_eq!(super::consume(b"backepsilon;"), Some(("϶", 12)));
	assert_eq!(super::consume(b"backprime;"), Some(("‵", 10)));
	assert_eq!(super::consume(b"backsim;"), Some(("∽", 8)));
	assert_eq!(super::consume(b"backsimeq;"), Some(("⋍", 10)));
	assert_eq!(super::consume(b"barvee;"), Some(("⊽", 7)));
	assert_eq!(super::consume(b"barwed;"), Some(("⌅", 7)));
	assert_eq!(super::consume(b"barwedge;"), Some(("⌅", 9)));
	assert_eq!(super::consume(b"bbrk;"), Some(("⎵", 5)));
	assert_eq!(super::consume(b"bbrktbrk;"), Some(("⎶", 9)));
	assert_eq!(super::consume(b"bcong;"), Some(("≌", 6)));
	assert_eq!(super::consume(b"bcy;"), Some(("б", 4)));
	assert_eq!(super::consume(b"bdquo;"), Some(("„", 6)));
	assert_eq!(super::consume(b"becaus;"), Some(("∵", 7)));
	assert_eq!(super::consume(b"because;"), Some(("∵", 8)));
	assert_eq!(super::consume(b"bemptyv;"), Some(("⦰", 8)));
	assert_eq!(super::consume(b"bepsi;"), Some(("϶", 6)));
	assert_eq!(super::consume(b"bernou;"), Some(("ℬ", 7)));
	assert_eq!(super::consume(b"beta;"), Some(("β", 5)));
	assert_eq!(super::consume(b"beth;"), Some(("ℶ", 5)));
	assert_eq!(super::consume(b"between;"), Some(("≬", 8)));
	assert_eq!(super::consume(b"bfr;"), Some(("𝔟", 4)));
	assert_eq!(super::consume(b"bigcap;"), Some(("⋂", 7)));
	assert_eq!(super::consume(b"bigcirc;"), Some(("◯", 8)));
	assert_eq!(super::consume(b"bigcup;"), Some(("⋃", 7)));
	assert_eq!(super::consume(b"bigodot;"), Some(("⨀", 8)));
	assert_eq!(super::consume(b"bigoplus;"), Some(("⨁", 9)));
	assert_eq!(super::consume(b"bigotimes;"), Some(("⨂", 10)));
	assert_eq!(super::consume(b"bigsqcup;"), Some(("⨆", 9)));
	assert_eq!(super::consume(b"bigstar;"), Some(("★", 8)));
	assert_eq!(super::consume(b"bigtriangledown;"), Some(("▽", 16)));
	assert_eq!(super::consume(b"bigtriangleup;"), Some(("△", 14)));
	assert_eq!(super::consume(b"biguplus;"), Some(("⨄", 9)));
	assert_eq!(super::consume(b"bigvee;"), Some(("⋁", 7)));
	assert_eq!(super::consume(b"bigwedge;"), Some(("⋀", 9)));
	assert_eq!(super::consume(b"bkarow;"), Some(("⤍", 7)));
	assert_eq!(super::consume(b"blacklozenge;"), Some(("⧫", 13)));
	assert_eq!(super::consume(b"blacksquare;"), Some(("▪", 12)));
	assert_eq!(super::consume(b"blacktriangle;"), Some(("▴", 14)));
	assert_eq!(super::consume(b"blacktriangledown;"), Some(("▾", 18)));
	assert_eq!(super::consume(b"blacktriangleleft;"), Some(("◂", 18)));
	assert_eq!(super::consume(b"blacktriangleright;"), Some(("▸", 19)));
	assert_eq!(super::consume(b"blank;"), Some(("␣", 6)));
	assert_eq!(super::consume(b"blk12;"), Some(("▒", 6)));
	assert_eq!(super::consume(b"blk14;"), Some(("░", 6)));
	assert_eq!(super::consume(b"blk34;"), Some(("▓", 6)));
	assert_eq!(super::consume(b"block;"), Some(("█", 6)));
	assert_eq!(super::consume(b"bne;"), Some(("=⃥", 4)));
	assert_eq!(super::consume(b"bnequiv;"), Some(("≡⃥", 8)));
	assert_eq!(super::consume(b"bnot;"), Some(("⌐", 5)));
	assert_eq!(super::consume(b"bopf;"), Some(("𝕓", 5)));
	assert_eq!(super::consume(b"bot;"), Some(("⊥", 4)));
	assert_eq!(super::consume(b"bottom;"), Some(("⊥", 7)));
	assert_eq!(super::consume(b"bowtie;"), Some(("⋈", 7)));
	assert_eq!(super::consume(b"boxDL;"), Some(("╗", 6)));
	assert_eq!(super::consume(b"boxDR;"), Some(("╔", 6)));
	assert_eq!(super::consume(b"boxDl;"), Some(("╖", 6)));
	assert_eq!(super::consume(b"boxDr;"), Some(("╓", 6)));
	assert_eq!(super::consume(b"boxH;"), Some(("═", 5)));
	assert_eq!(super::consume(b"boxHD;"), Some(("╦", 6)));
	assert_eq!(super::consume(b"boxHU;"), Some(("╩", 6)));
	assert_eq!(super::consume(b"boxHd;"), Some(("╤", 6)));
	assert_eq!(super::consume(b"boxHu;"), Some(("╧", 6)));
	assert_eq!(super::consume(b"boxUL;"), Some(("╝", 6)));
	assert_eq!(super::consume(b"boxUR;"), Some(("╚", 6)));
	assert_eq!(super::consume(b"boxUl;"), Some(("╜", 6)));
	assert_eq!(super::consume(b"boxUr;"), Some(("╙", 6)));
	assert_eq!(super::consume(b"boxV;"), Some(("║", 5)));
	assert_eq!(super::consume(b"boxVH;"), Some(("╬", 6)));
	assert_eq!(super::consume(b"boxVL;"), Some(("╣", 6)));
	assert_eq!(super::consume(b"boxVR;"), Some(("╠", 6)));
	assert_eq!(super::consume(b"boxVh;"), Some(("╫", 6)));
	assert_eq!(super::consume(b"boxVl;"), Some(("╢", 6)));
	assert_eq!(super::consume(b"boxVr;"), Some(("╟", 6)));
	assert_eq!(super::consume(b"boxbox;"), Some(("⧉", 7)));
	assert_eq!(super::consume(b"boxdL;"), Some(("╕", 6)));
	assert_eq!(super::consume(b"boxdR;"), Some(("╒", 6)));
	assert_eq!(super::consume(b"boxdl;"), Some(("┐", 6)));
	assert_eq!(super::consume(b"boxdr;"), Some(("┌", 6)));
	assert_eq!(super::consume(b"boxh;"), Some(("─", 5)));
	assert_eq!(super::consume(b"boxhD;"), Some(("╥", 6)));
	assert_eq!(super::consume(b"boxhU;"), Some(("╨", 6)));
	assert_eq!(super::consume(b"boxhd;"), Some(("┬", 6)));
	assert_eq!(super::consume(b"boxhu;"), Some(("┴", 6)));
	assert_eq!(super::consume(b"boxminus;"), Some(("⊟", 9)));
	assert_eq!(super::consume(b"boxplus;"), Some(("⊞", 8)));
	assert_eq!(super::consume(b"boxtimes;"), Some(("⊠", 9)));
	assert_eq!(super::consume(b"boxuL;"), Some(("╛", 6)));
	assert_eq!(super::consume(b"boxuR;"), Some(("╘", 6)));
	assert_eq!(super::consume(b"boxul;"), Some(("┘", 6)));
	assert_eq!(super::consume(b"boxur;"), Some(("└", 6)));
	assert_eq!(super::consume(b"boxv;"), Some(("│", 5)));
	assert_eq!(super::consume(b"boxvH;"), Some(("╪", 6)));
	assert_eq!(super::consume(b"boxvL;"), Some(("╡", 6)));
	assert_eq!(super::consume(b"boxvR;"), Some(("╞", 6)));
	assert_eq!(super::consume(b"boxvh;"), Some(("┼", 6)));
	assert_eq!(super::consume(b"boxvl;"), Some(("┤", 6)));
	assert_eq!(super::consume(b"boxvr;"), Some(("├", 6)));
	assert_eq!(super::consume(b"bprime;"), Some(("‵", 7)));
	assert_eq!(super::consume(b"breve;"), Some(("˘", 6)));
	assert_eq!(super::consume(b"brvbar"), Some(("¦", 6)));
	assert_eq!(super::consume(b"brvbar;"), Some(("¦", 7)));
	assert_eq!(super::consume(b"bscr;"), Some(("𝒷", 5)));
	assert_eq!(super::consume(b"bsemi;"), Some(("⁏", 6)));
	assert_eq!(super::consume(b"bsim;"), Some(("∽", 5)));
	assert_eq!(super::consume(b"bsime;"), Some(("⋍", 6)));
	assert_eq!(super::consume(b"bsol;"), Some(("\\", 5)));
	assert_eq!(super::consume(b"bsolb;"), Some(("⧅", 6)));
	assert_eq!(super::consume(b"bsolhsub;"), Some(("⟈", 9)));
	assert_eq!(super::consume(b"bull;"), Some(("•", 5)));
	assert_eq!(super::consume(b"bullet;"), Some(("•", 7)));
	assert_eq!(super::consume(b"bump;"), Some(("≎", 5)));
	assert_eq!(super::consume(b"bumpE;"), Some(("⪮", 6)));
	assert_eq!(super::consume(b"bumpe;"), Some(("≏", 6)));
	assert_eq!(super::consume(b"bumpeq;"), Some(("≏", 7)));
	assert_eq!(super::consume(b"cacute;"), Some(("ć", 7)));
	assert_eq!(super::consume(b"cap;"), Some(("∩", 4)));
	assert_eq!(super::consume(b"capand;"), Some(("⩄", 7)));
	assert_eq!(super::consume(b"capbrcup;"), Some(("⩉", 9)));
	assert_eq!(super::consume(b"capcap;"), Some(("⩋", 7)));
	assert_eq!(super::consume(b"capcup;"), Some(("⩇", 7)));
	assert_eq!(super::consume(b"capdot;"), Some(("⩀", 7)));
	assert_eq!(super::consume(b"caps;"), Some(("∩︀", 5)));
	assert_eq!(super::consume(b"caret;"), Some(("⁁", 6)));
	assert_eq!(super::consume(b"caron;"), Some(("ˇ", 6)));
	assert_eq!(super::consume(b"ccaps;"), Some(("⩍", 6)));
	assert_eq!(super::consume(b"ccaron;"), Some(("č", 7)));
	assert_eq!(super::consume(b"ccedil"), Some(("ç", 6)));
	assert_eq!(super::consume(b"ccedil;"), Some(("ç", 7)));
	assert_eq!(super::consume(b"ccirc;"), Some(("ĉ", 6)));
	assert_eq!(super::consume(b"ccups;"), Some(("⩌", 6)));
	assert_eq!(super::consume(b"ccupssm;"), Some(("⩐", 8)));
	assert_eq!(super::consume(b"cdot;"), Some(("ċ", 5)));
	assert_eq!(super::consume(b"cedil"), Some(("¸", 5)));
	assert_eq!(super::consume(b"cedil;"), Some(("¸", 6)));
	assert_eq!(super::consume(b"cemptyv;"), Some(("⦲", 8)));
	assert_eq!(super::consume(b"cent"), Some(("¢", 4)));
	assert_eq!(super::consume(b"cent;"), Some(("¢", 5)));
	assert_eq!(super::consume(b"centerdot;"), Some(("·", 10)));
	assert_eq!(super::consume(b"cfr;"), Some(("𝔠", 4)));
	assert_eq!(super::consume(b"chcy;"), Some(("ч", 5)));
	assert_eq!(super::consume(b"check;"), Some(("✓", 6)));
	assert_eq!(super::consume(b"checkmark;"), Some(("✓", 10)));
	assert_eq!(super::consume(b"chi;"), Some(("χ", 4)));
	assert_eq!(super::consume(b"cir;"), Some(("○", 4)));
	assert_eq!(super::consume(b"cirE;"), Some(("⧃", 5)));
	assert_eq!(super::consume(b"circ;"), Some(("ˆ", 5)));
	assert_eq!(super::consume(b"circeq;"), Some(("≗", 7)));
	assert_eq!(super::consume(b"circlearrowleft;"), Some(("↺", 16)));
	assert_eq!(super::consume(b"circlearrowright;"), Some(("↻", 17)));
	assert_eq!(super::consume(b"circledR;"), Some(("®", 9)));
	assert_eq!(super::consume(b"circledS;"), Some(("Ⓢ", 9)));
	assert_eq!(super::consume(b"circledast;"), Some(("⊛", 11)));
	assert_eq!(super::consume(b"circledcirc;"), Some(("⊚", 12)));
	assert_eq!(super::consume(b"circleddash;"), Some(("⊝", 12)));
	assert_eq!(super::consume(b"cire;"), Some(("≗", 5)));
	assert_eq!(super::consume(b"cirfnint;"), Some(("⨐", 9)));
	assert_eq!(super::consume(b"cirmid;"), Some(("⫯", 7)));
	assert_eq!(super::consume(b"cirscir;"), Some(("⧂", 8)));
	assert_eq!(super::consume(b"clubs;"), Some(("♣", 6)));
	assert_eq!(super::consume(b"clubsuit;"), Some(("♣", 9)));
	assert_eq!(super::consume(b"colon;"), Some((":", 6)));
	assert_eq!(super::consume(b"colone;"), Some(("≔", 7)));
	assert_eq!(super::consume(b"coloneq;"), Some(("≔", 8)));
	assert_eq!(super::consume(b"comma;"), Some((",", 6)));
	assert_eq!(super::consume(b"commat;"), Some(("@", 7)));
	assert_eq!(super::consume(b"comp;"), Some(("∁", 5)));
	assert_eq!(super::consume(b"compfn;"), Some(("∘", 7)));
	assert_eq!(super::consume(b"complement;"), Some(("∁", 11)));
	assert_eq!(super::consume(b"complexes;"), Some(("ℂ", 10)));
	assert_eq!(super::consume(b"cong;"), Some(("≅", 5)));
	assert_eq!(super::consume(b"congdot;"), Some(("⩭", 8)));
	assert_eq!(super::consume(b"conint;"), Some(("∮", 7)));
	assert_eq!(super::consume(b"copf;"), Some(("𝕔", 5)));
	assert_eq!(super::consume(b"coprod;"), Some(("∐", 7)));
	assert_eq!(super::consume(b"copy"), Some(("©", 4)));
	assert_eq!(super::consume(b"copy;"), Some(("©", 5)));
	assert_eq!(super::consume(b"copysr;"), Some(("℗", 7)));
	assert_eq!(super::consume(b"crarr;"), Some(("↵", 6)));
	assert_eq!(super::consume(b"cross;"), Some(("✗", 6)));
	assert_eq!(super::consume(b"cscr;"), Some(("𝒸", 5)));
	assert_eq!(super::consume(b"csub;"), Some(("⫏", 5)));
	assert_eq!(super::consume(b"csube;"), Some(("⫑", 6)));
	assert_eq!(super::consume(b"csup;"), Some(("⫐", 5)));
	assert_eq!(super::consume(b"csupe;"), Some(("⫒", 6)));
	assert_eq!(super::consume(b"ctdot;"), Some(("⋯", 6)));
	assert_eq!(super::consume(b"cudarrl;"), Some(("⤸", 8)));
	assert_eq!(super::consume(b"cudarrr;"), Some(("⤵", 8)));
	assert_eq!(super::consume(b"cuepr;"), Some(("⋞", 6)));
	assert_eq!(super::consume(b"cuesc;"), Some(("⋟", 6)));
	assert_eq!(super::consume(b"cularr;"), Some(("↶", 7)));
	assert_eq!(super::consume(b"cularrp;"), Some(("⤽", 8)));
	assert_eq!(super::consume(b"cup;"), Some(("∪", 4)));
	assert_eq!(super::consume(b"cupbrcap;"), Some(("⩈", 9)));
	assert_eq!(super::consume(b"cupcap;"), Some(("⩆", 7)));
	assert_eq!(super::consume(b"cupcup;"), Some(("⩊", 7)));
	assert_eq!(super::consume(b"cupdot;"), Some(("⊍", 7)));
	assert_eq!(super::consume(b"cupor;"), Some(("⩅", 6)));
	assert_eq!(super::consume(b"cups;"), Some(("∪︀", 5)));
	assert_eq!(super::consume(b"curarr;"), Some(("↷", 7)));
	assert_eq!(super::consume(b"curarrm;"), Some(("⤼", 8)));
	assert_eq!(super::consume(b"curlyeqprec;"), Some(("⋞", 12)));
	assert_eq!(super::consume(b"curlyeqsucc;"), Some(("⋟", 12)));
	assert_eq!(super::consume(b"curlyvee;"), Some(("⋎", 9)));
	assert_eq!(super::consume(b"curlywedge;"), Some(("⋏", 11)));
	assert_eq!(super::consume(b"curren"), Some(("¤", 6)));
	assert_eq!(super::consume(b"curren;"), Some(("¤", 7)));
	assert_eq!(super::consume(b"curvearrowleft;"), Some(("↶", 15)));
	assert_eq!(super::consume(b"curvearrowright;"), Some(("↷", 16)));
	assert_eq!(super::consume(b"cuvee;"), Some(("⋎", 6)));
	assert_eq!(super::consume(b"cuwed;"), Some(("⋏", 6)));
	assert_eq!(super::consume(b"cwconint;"), Some(("∲", 9)));
	assert_eq!(super::consume(b"cwint;"), Some(("∱", 6)));
	assert_eq!(super::consume(b"cylcty;"), Some(("⌭", 7)));
	assert_eq!(super::consume(b"dArr;"), Some(("⇓", 5)));
	assert_eq!(super::consume(b"dHar;"), Some(("⥥", 5)));
	assert_eq!(super::consume(b"dagger;"), Some(("†", 7)));
	assert_eq!(super::consume(b"daleth;"), Some(("ℸ", 7)));
	assert_eq!(super::consume(b"darr;"), Some(("↓", 5)));
	assert_eq!(super::consume(b"dash;"), Some(("‐", 5)));
	assert_eq!(super::consume(b"dashv;"), Some(("⊣", 6)));
	assert_eq!(super::consume(b"dbkarow;"), Some(("⤏", 8)));
	assert_eq!(super::consume(b"dblac;"), Some(("˝", 6)));
	assert_eq!(super::consume(b"dcaron;"), Some(("ď", 7)));
	assert_eq!(super::consume(b"dcy;"), Some(("д", 4)));
	assert_eq!(super::consume(b"dd;"), Some(("ⅆ", 3)));
	assert_eq!(super::consume(b"ddagger;"), Some(("‡", 8)));
	assert_eq!(super::consume(b"ddarr;"), Some(("⇊", 6)));
	assert_eq!(super::consume(b"ddotseq;"), Some(("⩷", 8)));
	assert_eq!(super::consume(b"deg"), Some(("°", 3)));
	assert_eq!(super::consume(b"deg;"), Some(("°", 4)));
	assert_eq!(super::consume(b"delta;"), Some(("δ", 6)));
	assert_eq!(super::consume(b"demptyv;"), Some(("⦱", 8)));
	assert_eq!(super::consume(b"dfisht;"), Some(("⥿", 7)));
	assert_eq!(super::consume(b"dfr;"), Some(("𝔡", 4)));
	assert_eq!(super::consume(b"dharl;"), Some(("⇃", 6)));
	assert_eq!(super::consume(b"dharr;"), Some(("⇂", 6)));
	assert_eq!(super::consume(b"diam;"), Some(("⋄", 5)));
	assert_eq!(super::consume(b"diamond;"), Some(("⋄", 8)));
	assert_eq!(super::consume(b"diamondsuit;"), Some(("♦", 12)));
	assert_eq!(super::consume(b"diams;"), Some(("♦", 6)));
	assert_eq!(super::consume(b"die;"), Some(("¨", 4)));
	assert_eq!(super::consume(b"digamma;"), Some(("ϝ", 8)));
	assert_eq!(super::consume(b"disin;"), Some(("⋲", 6)));
	assert_eq!(super::consume(b"div;"), Some(("÷", 4)));
	assert_eq!(super::consume(b"divide"), Some(("÷", 6)));
	assert_eq!(super::consume(b"divide;"), Some(("÷", 7)));
	assert_eq!(super::consume(b"divideontimes;"), Some(("⋇", 14)));
	assert_eq!(super::consume(b"divonx;"), Some(("⋇", 7)));
	assert_eq!(super::consume(b"djcy;"), Some(("ђ", 5)));
	assert_eq!(super::consume(b"dlcorn;"), Some(("⌞", 7)));
	assert_eq!(super::consume(b"dlcrop;"), Some(("⌍", 7)));
	assert_eq!(super::consume(b"dollar;"), Some(("$", 7)));
	assert_eq!(super::consume(b"dopf;"), Some(("𝕕", 5)));
	assert_eq!(super::consume(b"dot;"), Some(("˙", 4)));
	assert_eq!(super::consume(b"doteq;"), Some(("≐", 6)));
	assert_eq!(super::consume(b"doteqdot;"), Some(("≑", 9)));
	assert_eq!(super::consume(b"dotminus;"), Some(("∸", 9)));
	assert_eq!(super::consume(b"dotplus;"), Some(("∔", 8)));
	assert_eq!(super::consume(b"dotsquare;"), Some(("⊡", 10)));
	assert_eq!(super::consume(b"doublebarwedge;"), Some(("⌆", 15)));
	assert_eq!(super::consume(b"downarrow;"), Some(("↓", 10)));
	assert_eq!(super::consume(b"downdownarrows;"), Some(("⇊", 15)));
	assert_eq!(super::consume(b"downharpoonleft;"), Some(("⇃", 16)));
	assert_eq!(super::consume(b"downharpoonright;"), Some(("⇂", 17)));
	assert_eq!(super::consume(b"drbkarow;"), Some(("⤐", 9)));
	assert_eq!(super::consume(b"drcorn;"), Some(("⌟", 7)));
	assert_eq!(super::consume(b"drcrop;"), Some(("⌌", 7)));
	assert_eq!(super::consume(b"dscr;"), Some(("𝒹", 5)));
	assert_eq!(super::consume(b"dscy;"), Some(("ѕ", 5)));
	assert_eq!(super::consume(b"dsol;"), Some(("⧶", 5)));
	assert_eq!(super::consume(b"dstrok;"), Some(("đ", 7)));
	assert_eq!(super::consume(b"dtdot;"), Some(("⋱", 6)));
	assert_eq!(super::consume(b"dtri;"), Some(("▿", 5)));
	assert_eq!(super::consume(b"dtrif;"), Some(("▾", 6)));
	assert_eq!(super::consume(b"duarr;"), Some(("⇵", 6)));
	assert_eq!(super::consume(b"duhar;"), Some(("⥯", 6)));
	assert_eq!(super::consume(b"dwangle;"), Some(("⦦", 8)));
	assert_eq!(super::consume(b"dzcy;"), Some(("џ", 5)));
	assert_eq!(super::consume(b"dzigrarr;"), Some(("⟿", 9)));
	assert_eq!(super::consume(b"eDDot;"), Some(("⩷", 6)));
	assert_eq!(super::consume(b"eDot;"), Some(("≑", 5)));
	assert_eq!(super::consume(b"eacute"), Some(("é", 6)));
	assert_eq!(super::consume(b"eacute;"), Some(("é", 7)));
	assert_eq!(super::consume(b"easter;"), Some(("⩮", 7)));
	assert_eq!(super::consume(b"ecaron;"), Some(("ě", 7)));
	assert_eq!(super::consume(b"ecir;"), Some(("≖", 5)));
	assert_eq!(super::consume(b"ecirc"), Some(("ê", 5)));
	assert_eq!(super::consume(b"ecirc;"), Some(("ê", 6)));
	assert_eq!(super::consume(b"ecolon;"), Some(("≕", 7)));
	assert_eq!(super::consume(b"ecy;"), Some(("э", 4)));
	assert_eq!(super::consume(b"edot;"), Some(("ė", 5)));
	assert_eq!(super::consume(b"ee;"), Some(("ⅇ", 3)));
	assert_eq!(super::consume(b"efDot;"), Some(("≒", 6)));
	assert_eq!(super::consume(b"efr;"), Some(("𝔢", 4)));
	assert_eq!(super::consume(b"eg;"), Some(("⪚", 3)));
	assert_eq!(super::consume(b"egrave"), Some(("è", 6)));
	assert_eq!(super::consume(b"egrave;"), Some(("è", 7)));
	assert_eq!(super::consume(b"egs;"), Some(("⪖", 4)));
	assert_eq!(super::consume(b"egsdot;"), Some(("⪘", 7)));
	assert_eq!(super::consume(b"el;"), Some(("⪙", 3)));
	assert_eq!(super::consume(b"elinters;"), Some(("⏧", 9)));
	assert_eq!(super::consume(b"ell;"), Some(("ℓ", 4)));
	assert_eq!(super::consume(b"els;"), Some(("⪕", 4)));
	assert_eq!(super::consume(b"elsdot;"), Some(("⪗", 7)));
	assert_eq!(super::consume(b"emacr;"), Some(("ē", 6)));
	assert_eq!(super::consume(b"empty;"), Some(("∅", 6)));
	assert_eq!(super::consume(b"emptyset;"), Some(("∅", 9)));
	assert_eq!(super::consume(b"emptyv;"), Some(("∅", 7)));
	assert_eq!(super::consume(b"emsp13;"), Some((" ", 7)));
	assert_eq!(super::consume(b"emsp14;"), Some((" ", 7)));
	assert_eq!(super::consume(b"emsp;"), Some((" ", 5)));
	assert_eq!(super::consume(b"eng;"), Some(("ŋ", 4)));
	assert_eq!(super::consume(b"ensp;"), Some((" ", 5)));
	assert_eq!(super::consume(b"eogon;"), Some(("ę", 6)));
	assert_eq!(super::consume(b"eopf;"), Some(("𝕖", 5)));
	assert_eq!(super::consume(b"epar;"), Some(("⋕", 5)));
	assert_eq!(super::consume(b"eparsl;"), Some(("⧣", 7)));
	assert_eq!(super::consume(b"eplus;"), Some(("⩱", 6)));
	assert_eq!(super::consume(b"epsi;"), Some(("ε", 5)));
	assert_eq!(super::consume(b"epsilon;"), Some(("ε", 8)));
	assert_eq!(super::consume(b"epsiv;"), Some(("ϵ", 6)));
	assert_eq!(super::consume(b"eqcirc;"), Some(("≖", 7)));
	assert_eq!(super::consume(b"eqcolon;"), Some(("≕", 8)));
	assert_eq!(super::consume(b"eqsim;"), Some(("≂", 6)));
	assert_eq!(super::consume(b"eqslantgtr;"), Some(("⪖", 11)));
	assert_eq!(super::consume(b"eqslantless;"), Some(("⪕", 12)));
	assert_eq!(super::consume(b"equals;"), Some(("=", 7)));
	assert_eq!(super::consume(b"equest;"), Some(("≟", 7)));
	assert_eq!(super::consume(b"equiv;"), Some(("≡", 6)));
	assert_eq!(super::consume(b"equivDD;"), Some(("⩸", 8)));
	assert_eq!(super::consume(b"eqvparsl;"), Some(("⧥", 9)));
	assert_eq!(super::consume(b"erDot;"), Some(("≓", 6)));
	assert_eq!(super::consume(b"erarr;"), Some(("⥱", 6)));
	assert_eq!(super::consume(b"escr;"), Some(("ℯ", 5)));
	assert_eq!(super::consume(b"esdot;"), Some(("≐", 6)));
	assert_eq!(super::consume(b"esim;"), Some(("≂", 5)));
	assert_eq!(super::consume(b"eta;"), Some(("η", 4)));
	assert_eq!(super::consume(b"eth"), Some(("ð", 3)));
	assert_eq!(super::consume(b"eth;"), Some(("ð", 4)));
	assert_eq!(super::consume(b"euml"), Some(("ë", 4)));
	assert_eq!(super::consume(b"euml;"), Some(("ë", 5)));
	assert_eq!(super::consume(b"euro;"), Some(("€", 5)));
	assert_eq!(super::consume(b"excl;"), Some(("!", 5)));
	assert_eq!(super::consume(b"exist;"), Some(("∃", 6)));
	assert_eq!(super::consume(b"expectation;"), Some(("ℰ", 12)));
	assert_eq!(super::consume(b"exponentiale;"), Some(("ⅇ", 13)));
	assert_eq!(super::consume(b"fallingdotseq;"), Some(("≒", 14)));
	assert_eq!(super::consume(b"fcy;"), Some(("ф", 4)));
	assert_eq!(super::consume(b"female;"), Some(("♀", 7)));
	assert_eq!(super::consume(b"ffilig;"), Some(("ﬃ", 7)));
	assert_eq!(super::consume(b"fflig;"), Some(("ﬀ", 6)));
	assert_eq!(super::consume(b"ffllig;"), Some(("ﬄ", 7)));
	assert_eq!(super::consume(b"ffr;"), Some(("𝔣", 4)));
	assert_eq!(super::consume(b"filig;"), Some(("ﬁ", 6)));
	assert_eq!(super::consume(b"fjlig;"), Some(("fj", 6)));
	assert_eq!(super::consume(b"flat;"), Some(("♭", 5)));
	assert_eq!(super::consume(b"fllig;"), Some(("ﬂ", 6)));
	assert_eq!(super::consume(b"fltns;"), Some(("▱", 6)));
	assert_eq!(super::consume(b"fnof;"), Some(("ƒ", 5)));
	assert_eq!(super::consume(b"fopf;"), Some(("𝕗", 5)));
	assert_eq!(super::consume(b"forall;"), Some(("∀", 7)));
	assert_eq!(super::consume(b"fork;"), Some(("⋔", 5)));
	assert_eq!(super::consume(b"forkv;"), Some(("⫙", 6)));
	assert_eq!(super::consume(b"fpartint;"), Some(("⨍", 9)));
	assert_eq!(super::consume(b"frac12"), Some(("½", 6)));
	assert_eq!(super::consume(b"frac12;"), Some(("½", 7)));
	assert_eq!(super::consume(b"frac13;"), Some(("⅓", 7)));
	assert_eq!(super::consume(b"frac14"), Some(("¼", 6)));
	assert_eq!(super::consume(b"frac14;"), Some(("¼", 7)));
	assert_eq!(super::consume(b"frac15;"), Some(("⅕", 7)));
	assert_eq!(super::consume(b"frac16;"), Some(("⅙", 7)));
	assert_eq!(super::consume(b"frac18;"), Some(("⅛", 7)));
	assert_eq!(super::consume(b"frac23;"), Some(("⅔", 7)));
	assert_eq!(super::consume(b"frac25;"), Some(("⅖", 7)));
	assert_eq!(super::consume(b"frac34"), Some(("¾", 6)));
	assert_eq!(super::consume(b"frac34;"), Some(("¾", 7)));
	assert_eq!(super::consume(b"frac35;"), Some(("⅗", 7)));
	assert_eq!(super::consume(b"frac38;"), Some(("⅜", 7)));
	assert_eq!(super::consume(b"frac45;"), Some(("⅘", 7)));
	assert_eq!(super::consume(b"frac56;"), Some(("⅚", 7)));
	assert_eq!(super::consume(b"frac58;"), Some(("⅝", 7)));
	assert_eq!(super::consume(b"frac78;"), Some(("⅞", 7)));
	assert_eq!(super::consume(b"frasl;"), Some(("⁄", 6)));
	assert_eq!(super::consume(b"frown;"), Some(("⌢", 6)));
	assert_eq!(super::consume(b"fscr;"), Some(("𝒻", 5)));
	assert_eq!(super::consume(b"gE;"), Some(("≧", 3)));
	assert_eq!(super::consume(b"gEl;"), Some(("⪌", 4)));
	assert_eq!(super::consume(b"gacute;"), Some(("ǵ", 7)));
	assert_eq!(super::consume(b"gamma;"), Some(("γ", 6)));
	assert_eq!(super::consume(b"gammad;"), Some(("ϝ", 7)));
	assert_eq!(super::consume(b"gap;"), Some(("⪆", 4)));
	assert_eq!(super::consume(b"gbreve;"), Some(("ğ", 7)));
	assert_eq!(super::consume(b"gcirc;"), Some(("ĝ", 6)));
	assert_eq!(super::consume(b"gcy;"), Some(("г", 4)));
	assert_eq!(super::consume(b"gdot;"), Some(("ġ", 5)));
	assert_eq!(super::consume(b"ge;"), Some(("≥", 3)));
	assert_eq!(super::consume(b"gel;"), Some(("⋛", 4)));
	assert_eq!(super::consume(b"geq;"), Some(("≥", 4)));
	assert_eq!(super::consume(b"geqq;"), Some(("≧", 5)));
	assert_eq!(super::consume(b"geqslant;"), Some(("⩾", 9)));
	assert_eq!(super::consume(b"ges;"), Some(("⩾", 4)));
	assert_eq!(super::consume(b"gescc;"), Some(("⪩", 6)));
	assert_eq!(super::consume(b"gesdot;"), Some(("⪀", 7)));
	assert_eq!(super::consume(b"gesdoto;"), Some(("⪂", 8)));
	assert_eq!(super::consume(b"gesdotol;"), Some(("⪄", 9)));
	assert_eq!(super::consume(b"gesl;"), Some(("⋛︀", 5)));
	assert_eq!(super::consume(b"gesles;"), Some(("⪔", 7)));
	assert_eq!(super::consume(b"gfr;"), Some(("𝔤", 4)));
	assert_eq!(super::consume(b"gg;"), Some(("≫", 3)));
	assert_eq!(super::consume(b"ggg;"), Some(("⋙", 4)));
	assert_eq!(super::consume(b"gimel;"), Some(("ℷ", 6)));
	assert_eq!(super::consume(b"gjcy;"), Some(("ѓ", 5)));
	assert_eq!(super::consume(b"gl;"), Some(("≷", 3)));
	assert_eq!(super::consume(b"glE;"), Some(("⪒", 4)));
	assert_eq!(super::consume(b"gla;"), Some(("⪥", 4)));
	assert_eq!(super::consume(b"glj;"), Some(("⪤", 4)));
	assert_eq!(super::consume(b"gnE;"), Some(("≩", 4)));
	assert_eq!(super::consume(b"gnap;"), Some(("⪊", 5)));
	assert_eq!(super::consume(b"gnapprox;"), Some(("⪊", 9)));
	assert_eq!(super::consume(b"gne;"), Some(("⪈", 4)));
	assert_eq!(super::consume(b"gneq;"), Some(("⪈", 5)));
	assert_eq!(super::consume(b"gneqq;"), Some(("≩", 6)));
	assert_eq!(super::consume(b"gnsim;"), Some(("⋧", 6)));
	assert_eq!(super::consume(b"gopf;"), Some(("𝕘", 5)));
	assert_eq!(super::consume(b"grave;"), Some(("`", 6)));
	assert_eq!(super::consume(b"gscr;"), Some(("ℊ", 5)));
	assert_eq!(super::consume(b"gsim;"), Some(("≳", 5)));
	assert_eq!(super::consume(b"gsime;"), Some(("⪎", 6)));
	assert_eq!(super::consume(b"gsiml;"), Some(("⪐", 6)));
	assert_eq!(super::consume(b"gt"), Some((">", 2)));
	assert_eq!(super::consume(b"gt;"), Some((">", 3)));
	assert_eq!(super::consume(b"gtcc;"), Some(("⪧", 5)));
	assert_eq!(super::consume(b"gtcir;"), Some(("⩺", 6)));
	assert_eq!(super::consume(b"gtdot;"), Some(("⋗", 6)));
	assert_eq!(super::consume(b"gtlPar;"), Some(("⦕", 7)));
	assert_eq!(super::consume(b"gtquest;"), Some(("⩼", 8)));
	assert_eq!(super::consume(b"gtrapprox;"), Some(("⪆", 10)));
	assert_eq!(super::consume(b"gtrarr;"), Some(("⥸", 7)));
	assert_eq!(super::consume(b"gtrdot;"), Some(("⋗", 7)));
	assert_eq!(super::consume(b"gtreqless;"), Some(("⋛", 10)));
	assert_eq!(super::consume(b"gtreqqless;"), Some(("⪌", 11)));
	assert_eq!(super::consume(b"gtrless;"), Some(("≷", 8)));
	assert_eq!(super::consume(b"gtrsim;"), Some(("≳", 7)));
	assert_eq!(super::consume(b"gvertneqq;"), Some(("≩︀", 10)));
	assert_eq!(super::consume(b"gvnE;"), Some(("≩︀", 5)));
	assert_eq!(super::consume(b"hArr;"), Some(("⇔", 5)));
	assert_eq!(super::consume(b"hairsp;"), Some((" ", 7)));
	assert_eq!(super::consume(b"half;"), Some(("½", 5)));
	assert_eq!(super::consume(b"hamilt;"), Some(("ℋ", 7)));
	assert_eq!(super::consume(b"hardcy;"), Some(("ъ", 7)));
	assert_eq!(super::consume(b"harr;"), Some(("↔", 5)));
	assert_eq!(super::consume(b"harrcir;"), Some(("⥈", 8)));
	assert_eq!(super::consume(b"harrw;"), Some(("↭", 6)));
	assert_eq!(super::consume(b"hbar;"), Some(("ℏ", 5)));
	assert_eq!(super::consume(b"hcirc;"), Some(("ĥ", 6)));
	assert_eq!(super::consume(b"hearts;"), Some(("♥", 7)));
	assert_eq!(super::consume(b"heartsuit;"), Some(("♥", 10)));
	assert_eq!(super::consume(b"hellip;"), Some(("…", 7)));
	assert_eq!(super::consume(b"hercon;"), Some(("⊹", 7)));
	assert_eq!(super::consume(b"hfr;"), Some(("𝔥", 4)));
	assert_eq!(super::consume(b"hksearow;"), Some(("⤥", 9)));
	assert_eq!(super::consume(b"hkswarow;"), Some(("⤦", 9)));
	assert_eq!(super::consume(b"hoarr;"), Some(("⇿", 6)));
	assert_eq!(super::consume(b"homtht;"), Some(("∻", 7)));
	assert_eq!(super::consume(b"hookleftarrow;"), Some(("↩", 14)));
	assert_eq!(super::consume(b"hookrightarrow;"), Some(("↪", 15)));
	assert_eq!(super::consume(b"hopf;"), Some(("𝕙", 5)));
	assert_eq!(super::consume(b"horbar;"), Some(("―", 7)));
	assert_eq!(super::consume(b"hscr;"), Some(("𝒽", 5)));
	assert_eq!(super::consume(b"hslash;"), Some(("ℏ", 7)));
	assert_eq!(super::consume(b"hstrok;"), Some(("ħ", 7)));
	assert_eq!(super::consume(b"hybull;"), Some(("⁃", 7)));
	assert_eq!(super::consume(b"hyphen;"), Some(("‐", 7)));
	assert_eq!(super::consume(b"iacute"), Some(("í", 6)));
	assert_eq!(super::consume(b"iacute;"), Some(("í", 7)));
	assert_eq!(super::consume(b"ic;"), Some(("⁣", 3)));
	assert_eq!(super::consume(b"icirc"), Some(("î", 5)));
	assert_eq!(super::consume(b"icirc;"), Some(("î", 6)));
	assert_eq!(super::consume(b"icy;"), Some(("и", 4)));
	assert_eq!(super::consume(b"iecy;"), Some(("е", 5)));
	assert_eq!(super::consume(b"iexcl"), Some(("¡", 5)));
	assert_eq!(super::consume(b"iexcl;"), Some(("¡", 6)));
	assert_eq!(super::consume(b"iff;"), Some(("⇔", 4)));
	assert_eq!(super::consume(b"ifr;"), Some(("𝔦", 4)));
	assert_eq!(super::consume(b"igrave"), Some(("ì", 6)));
	assert_eq!(super::consume(b"igrave;"), Some(("ì", 7)));
	assert_eq!(super::consume(b"ii;"), Some(("ⅈ", 3)));
	assert_eq!(super::consume(b"iiiint;"), Some(("⨌", 7)));
	assert_eq!(super::consume(b"iiint;"), Some(("∭", 6)));
	assert_eq!(super::consume(b"iinfin;"), Some(("⧜", 7)));
	assert_eq!(super::consume(b"iiota;"), Some(("℩", 6)));
	assert_eq!(super::consume(b"ijlig;"), Some(("ĳ", 6)));
	assert_eq!(super::consume(b"imacr;"), Some(("ī", 6)));
	assert_eq!(super::consume(b"image;"), Some(("ℑ", 6)));
	assert_eq!(super::consume(b"imagline;"), Some(("ℐ", 9)));
	assert_eq!(super::consume(b"imagpart;"), Some(("ℑ", 9)));
	assert_eq!(super::consume(b"imath;"), Some(("ı", 6)));
	assert_eq!(super::consume(b"imof;"), Some(("⊷", 5)));
	assert_eq!(super::consume(b"imped;"), Some(("Ƶ", 6)));
	assert_eq!(super::consume(b"in;"), Some(("∈", 3)));
	assert_eq!(super::consume(b"incare;"), Some(("℅", 7)));
	assert_eq!(super::consume(b"infin;"), Some(("∞", 6)));
	assert_eq!(super::consume(b"infintie;"), Some(("⧝", 9)));
	assert_eq!(super::consume(b"inodot;"), Some(("ı", 7)));
	assert_eq!(super::consume(b"int;"), Some(("∫", 4)));
	assert_eq!(super::consume(b"intcal;"), Some(("⊺", 7)));
	assert_eq!(super::consume(b"integers;"), Some(("ℤ", 9)));
	assert_eq!(super::consume(b"intercal;"), Some(("⊺", 9)));
	assert_eq!(super::consume(b"intlarhk;"), Some(("⨗", 9)));
	assert_eq!(super::consume(b"intprod;"), Some(("⨼", 8)));
	assert_eq!(super::consume(b"iocy;"), Some(("ё", 5)));
	assert_eq!(super::consume(b"iogon;"), Some(("į", 6)));
	assert_eq!(super::consume(b"iopf;"), Some(("𝕚", 5)));
	assert_eq!(super::consume(b"iota;"), Some(("ι", 5)));
	assert_eq!(super::consume(b"iprod;"), Some(("⨼", 6)));
	assert_eq!(super::consume(b"iquest"), Some(("¿", 6)));
	assert_eq!(super::consume(b"iquest;"), Some(("¿", 7)));
	assert_eq!(super::consume(b"iscr;"), Some(("𝒾", 5)));
	assert_eq!(super::consume(b"isin;"), Some(("∈", 5)));
	assert_eq!(super::consume(b"isinE;"), Some(("⋹", 6)));
	assert_eq!(super::consume(b"isindot;"), Some(("⋵", 8)));
	assert_eq!(super::consume(b"isins;"), Some(("⋴", 6)));
	assert_eq!(super::consume(b"isinsv;"), Some(("⋳", 7)));
	assert_eq!(super::consume(b"isinv;"), Some(("∈", 6)));
	assert_eq!(super::consume(b"it;"), Some(("⁢", 3)));
	assert_eq!(super::consume(b"itilde;"), Some(("ĩ", 7)));
	assert_eq!(super::consume(b"iukcy;"), Some(("і", 6)));
	assert_eq!(super::consume(b"iuml"), Some(("ï", 4)));
	assert_eq!(super::consume(b"iuml;"), Some(("ï", 5)));
	assert_eq!(super::consume(b"jcirc;"), Some(("ĵ", 6)));
	assert_eq!(super::consume(b"jcy;"), Some(("й", 4)));
	assert_eq!(super::consume(b"jfr;"), Some(("𝔧", 4)));
	assert_eq!(super::consume(b"jmath;"), Some(("ȷ", 6)));
	assert_eq!(super::consume(b"jopf;"), Some(("𝕛", 5)));
	assert_eq!(super::consume(b"jscr;"), Some(("𝒿", 5)));
	assert_eq!(super::consume(b"jsercy;"), Some(("ј", 7)));
	assert_eq!(super::consume(b"jukcy;"), Some(("є", 6)));
	assert_eq!(super::consume(b"kappa;"), Some(("κ", 6)));
	assert_eq!(super::consume(b"kappav;"), Some(("ϰ", 7)));
	assert_eq!(super::consume(b"kcedil;"), Some(("ķ", 7)));
	assert_eq!(super::consume(b"kcy;"), Some(("к", 4)));
	assert_eq!(super::consume(b"kfr;"), Some(("𝔨", 4)));
	assert_eq!(super::consume(b"kgreen;"), Some(("ĸ", 7)));
	assert_eq!(super::consume(b"khcy;"), Some(("х", 5)));
	assert_eq!(super::consume(b"kjcy;"), Some(("ќ", 5)));
	assert_eq!(super::consume(b"kopf;"), Some(("𝕜", 5)));
	assert_eq!(super::consume(b"kscr;"), Some(("𝓀", 5)));
	assert_eq!(super::consume(b"lAarr;"), Some(("⇚", 6)));
	assert_eq!(super::consume(b"lArr;"), Some(("⇐", 5)));
	assert_eq!(super::consume(b"lAtail;"), Some(("⤛", 7)));
	assert_eq!(super::consume(b"lBarr;"), Some(("⤎", 6)));
	assert_eq!(super::consume(b"lE;"), Some(("≦", 3)));
	assert_eq!(super::consume(b"lEg;"), Some(("⪋", 4)));
	assert_eq!(super::consume(b"lHar;"), Some(("⥢", 5)));
	assert_eq!(super::consume(b"lacute;"), Some(("ĺ", 7)));
	assert_eq!(super::consume(b"laemptyv;"), Some(("⦴", 9)));
	assert_eq!(super::consume(b"lagran;"), Some(("ℒ", 7)));
	assert_eq!(super::consume(b"lambda;"), Some(("λ", 7)));
	assert_eq!(super::consume(b"lang;"), Some(("⟨", 5)));
	assert_eq!(super::consume(b"langd;"), Some(("⦑", 6)));
	assert_eq!(super::consume(b"langle;"), Some(("⟨", 7)));
	assert_eq!(super::consume(b"lap;"), Some(("⪅", 4)));
	assert_eq!(super::consume(b"laquo"), Some(("«", 5)));
	assert_eq!(super::consume(b"laquo;"), Some(("«", 6)));
	assert_eq!(super::consume(b"larr;"), Some(("←", 5)));
	assert_eq!(super::consume(b"larrb;"), Some(("⇤", 6)));
	assert_eq!(super::consume(b"larrbfs;"), Some(("⤟", 8)));
	assert_eq!(super::consume(b"larrfs;"), Some(("⤝", 7)));
	assert_eq!(super::consume(b"larrhk;"), Some(("↩", 7)));
	assert_eq!(super::consume(b"larrlp;"), Some(("↫", 7)));
	assert_eq!(super::consume(b"larrpl;"), Some(("⤹", 7)));
	assert_eq!(super::consume(b"larrsim;"), Some(("⥳", 8)));
	assert_eq!(super::consume(b"larrtl;"), Some(("↢", 7)));
	assert_eq!(super::consume(b"lat;"), Some(("⪫", 4)));
	assert_eq!(super::consume(b"latail;"), Some(("⤙", 7)));
	assert_eq!(super::consume(b"late;"), Some(("⪭", 5)));
	assert_eq!(super::consume(b"lates;"), Some(("⪭︀", 6)));
	assert_eq!(super::consume(b"lbarr;"), Some(("⤌", 6)));
	assert_eq!(super::consume(b"lbbrk;"), Some(("❲", 6)));
	assert_eq!(super::consume(b"lbrace;"), Some(("{", 7)));
	assert_eq!(super::consume(b"lbrack;"), Some(("[", 7)));
	assert_eq!(super::consume(b"lbrke;"), Some(("⦋", 6)));
	assert_eq!(super::consume(b"lbrksld;"), Some(("⦏", 8)));
	assert_eq!(super::consume(b"lbrkslu;"), Some(("⦍", 8)));
	assert_eq!(super::consume(b"lcaron;"), Some(("ľ", 7)));
	assert_eq!(super::consume(b"lcedil;"), Some(("ļ", 7)));
	assert_eq!(super::consume(b"lceil;"), Some(("⌈", 6)));
	assert_eq!(super::consume(b"lcub;"), Some(("{", 5)));
	assert_eq!(super::consume(b"lcy;"), Some(("л", 4)));
	assert_eq!(super::consume(b"ldca;"), Some(("⤶", 5)));
	assert_eq!(super::consume(b"ldquo;"), Some(("“", 6)));
	assert_eq!(super::consume(b"ldquor;"), Some(("„", 7)));
	assert_eq!(super::consume(b"ldrdhar;"), Some(("⥧", 8)));
	assert_eq!(super::consume(b"ldrushar;"), Some(("⥋", 9)));
	assert_eq!(super::consume(b"ldsh;"), Some(("↲", 5)));
	assert_eq!(super::consume(b"le;"), Some(("≤", 3)));
	assert_eq!(super::consume(b"leftarrow;"), Some(("←", 10)));
	assert_eq!(super::consume(b"leftarrowtail;"), Some(("↢", 14)));
	assert_eq!(super::consume(b"leftharpoondown;"), Some(("↽", 16)));
	assert_eq!(super::consume(b"leftharpoonup;"), Some(("↼", 14)));
	assert_eq!(super::consume(b"leftleftarrows;"), Some(("⇇", 15)));
	assert_eq!(super::consume(b"leftrightarrow;"), Some(("↔", 15)));
	assert_eq!(super::consume(b"leftrightarrows;"), Some(("⇆", 16)));
	assert_eq!(super::consume(b"leftrightharpoons;"), Some(("⇋", 18)));
	assert_eq!(super::consume(b"leftrightsquigarrow;"), Some(("↭", 20)));
	assert_eq!(super::consume(b"leftthreetimes;"), Some(("⋋", 15)));
	assert_eq!(super::consume(b"leg;"), Some(("⋚", 4)));
	assert_eq!(super::consume(b"leq;"), Some(("≤", 4)));
	assert_eq!(super::consume(b"leqq;"), Some(("≦", 5)));
	assert_eq!(super::consume(b"leqslant;"), Some(("⩽", 9)));
	assert_eq!(super::consume(b"les;"), Some(("⩽", 4)));
	assert_eq!(super::consume(b"lescc;"), Some(("⪨", 6)));
	assert_eq!(super::consume(b"lesdot;"), Some(("⩿", 7)));
	assert_eq!(super::consume(b"lesdoto;"), Some(("⪁", 8)));
	assert_eq!(super::consume(b"lesdotor;"), Some(("⪃", 9)));
	assert_eq!(super::consume(b"lesg;"), Some(("⋚︀", 5)));
	assert_eq!(super::consume(b"lesges;"), Some(("⪓", 7)));
	assert_eq!(super::consume(b"lessapprox;"), Some(("⪅", 11)));
	assert_eq!(super::consume(b"lessdot;"), Some(("⋖", 8)));
	assert_eq!(super::consume(b"lesseqgtr;"), Some(("⋚", 10)));
	assert_eq!(super::consume(b"lesseqqgtr;"), Some(("⪋", 11)));
	assert_eq!(super::consume(b"lessgtr;"), Some(("≶", 8)));
	assert_eq!(super::consume(b"lesssim;"), Some(("≲", 8)));
	assert_eq!(super::consume(b"lfisht;"), Some(("⥼", 7)));
	assert_eq!(super::consume(b"lfloor;"), Some(("⌊", 7)));
	assert_eq!(super::consume(b"lfr;"), Some(("𝔩", 4)));
	assert_eq!(super::consume(b"lg;"), Some(("≶", 3)));
	assert_eq!(super::consume(b"lgE;"), Some(("⪑", 4)));
	assert_eq!(super::consume(b"lhard;"), Some(("↽", 6)));
	assert_eq!(super::consume(b"lharu;"), Some(("↼", 6)));
	assert_eq!(super::consume(b"lharul;"), Some(("⥪", 7)));
	assert_eq!(super::consume(b"lhblk;"), Some(("▄", 6)));
	assert_eq!(super::consume(b"ljcy;"), Some(("љ", 5)));
	assert_eq!(super::consume(b"ll;"), Some(("≪", 3)));
	assert_eq!(super::consume(b"llarr;"), Some(("⇇", 6)));
	assert_eq!(super::consume(b"llcorner;"), Some(("⌞", 9)));
	assert_eq!(super::consume(b"llhard;"), Some(("⥫", 7)));
	assert_eq!(super::consume(b"lltri;"), Some(("◺", 6)));
	assert_eq!(super::consume(b"lmidot;"), Some(("ŀ", 7)));
	assert_eq!(super::consume(b"lmoust;"), Some(("⎰", 7)));
	assert_eq!(super::consume(b"lmoustache;"), Some(("⎰", 11)));
	assert_eq!(super::consume(b"lnE;"), Some(("≨", 4)));
	assert_eq!(super::consume(b"lnap;"), Some(("⪉", 5)));
	assert_eq!(super::consume(b"lnapprox;"), Some(("⪉", 9)));
	assert_eq!(super::consume(b"lne;"), Some(("⪇", 4)));
	assert_eq!(super::consume(b"lneq;"), Some(("⪇", 5)));
	assert_eq!(super::consume(b"lneqq;"), Some(("≨", 6)));
	assert_eq!(super::consume(b"lnsim;"), Some(("⋦", 6)));
	assert_eq!(super::consume(b"loang;"), Some(("⟬", 6)));
	assert_eq!(super::consume(b"loarr;"), Some(("⇽", 6)));
	assert_eq!(super::consume(b"lobrk;"), Some(("⟦", 6)));
	assert_eq!(super::consume(b"longleftarrow;"), Some(("⟵", 14)));
	assert_eq!(super::consume(b"longleftrightarrow;"), Some(("⟷", 19)));
	assert_eq!(super::consume(b"longmapsto;"), Some(("⟼", 11)));
	assert_eq!(super::consume(b"longrightarrow;"), Some(("⟶", 15)));
	assert_eq!(super::consume(b"looparrowleft;"), Some(("↫", 14)));
	assert_eq!(super::consume(b"looparrowright;"), Some(("↬", 15)));
	assert_eq!(super::consume(b"lopar;"), Some(("⦅", 6)));
	assert_eq!(super::consume(b"lopf;"), Some(("𝕝", 5)));
	assert_eq!(super::consume(b"loplus;"), Some(("⨭", 7)));
	assert_eq!(super::consume(b"lotimes;"), Some(("⨴", 8)));
	assert_eq!(super::consume(b"lowast;"), Some(("∗", 7)));
	assert_eq!(super::consume(b"lowbar;"), Some(("_", 7)));
	assert_eq!(super::consume(b"loz;"), Some(("◊", 4)));
	assert_eq!(super::consume(b"lozenge;"), Some(("◊", 8)));
	assert_eq!(super::consume(b"lozf;"), Some(("⧫", 5)));
	assert_eq!(super::consume(b"lpar;"), Some(("(", 5)));
	assert_eq!(super::consume(b"lparlt;"), Some(("⦓", 7)));
	assert_eq!(super::consume(b"lrarr;"), Some(("⇆", 6)));
	assert_eq!(super::consume(b"lrcorner;"), Some(("⌟", 9)));
	assert_eq!(super::consume(b"lrhar;"), Some(("⇋", 6)));
	assert_eq!(super::consume(b"lrhard;"), Some(("⥭", 7)));
	assert_eq!(super::consume(b"lrm;"), Some(("‎", 4)));
	assert_eq!(super::consume(b"lrtri;"), Some(("⊿", 6)));
	assert_eq!(super::consume(b"lsaquo;"), Some(("‹", 7)));
	assert_eq!(super::consume(b"lscr;"), Some(("𝓁", 5)));
	assert_eq!(super::consume(b"lsh;"), Some(("↰", 4)));
	assert_eq!(super::consume(b"lsim;"), Some(("≲", 5)));
	assert_eq!(super::consume(b"lsime;"), Some(("⪍", 6)));
	assert_eq!(super::consume(b"lsimg;"), Some(("⪏", 6)));
	assert_eq!(super::consume(b"lsqb;"), Some(("[", 5)));
	assert_eq!(super::consume(b"lsquo;"), Some(("‘", 6)));
	assert_eq!(super::consume(b"lsquor;"), Some(("‚", 7)));
	assert_eq!(super::consume(b"lstrok;"), Some(("ł", 7)));
	assert_eq!(super::consume(b"lt"), Some(("<", 2)));
	assert_eq!(super::consume(b"lt;"), Some(("<", 3)));
	assert_eq!(super::consume(b"ltcc;"), Some(("⪦", 5)));
	assert_eq!(super::consume(b"ltcir;"), Some(("⩹", 6)));
	assert_eq!(super::consume(b"ltdot;"), Some(("⋖", 6)));
	assert_eq!(super::consume(b"lthree;"), Some(("⋋", 7)));
	assert_eq!(super::consume(b"ltimes;"), Some(("⋉", 7)));
	assert_eq!(super::consume(b"ltlarr;"), Some(("⥶", 7)));
	assert_eq!(super::consume(b"ltquest;"), Some(("⩻", 8)));
	assert_eq!(super::consume(b"ltrPar;"), Some(("⦖", 7)));
	assert_eq!(super::consume(b"ltri;"), Some(("◃", 5)));
	assert_eq!(super::consume(b"ltrie;"), Some(("⊴", 6)));
	assert_eq!(super::consume(b"ltrif;"), Some(("◂", 6)));
	assert_eq!(super::consume(b"lurdshar;"), Some(("⥊", 9)));
	assert_eq!(super::consume(b"luruhar;"), Some(("⥦", 8)));
	assert_eq!(super::consume(b"lvertneqq;"), Some(("≨︀", 10)));
	assert_eq!(super::consume(b"lvnE;"), Some(("≨︀", 5)));
	assert_eq!(super::consume(b"mDDot;"), Some(("∺", 6)));
	assert_eq!(super::consume(b"macr"), Some(("¯", 4)));
	assert_eq!(super::consume(b"macr;"), Some(("¯", 5)));
	assert_eq!(super::consume(b"male;"), Some(("♂", 5)));
	assert_eq!(super::consume(b"malt;"), Some(("✠", 5)));
	assert_eq!(super::consume(b"maltese;"), Some(("✠", 8)));
	assert_eq!(super::consume(b"map;"), Some(("↦", 4)));
	assert_eq!(super::consume(b"mapsto;"), Some(("↦", 7)));
	assert_eq!(super::consume(b"mapstodown;"), Some(("↧", 11)));
	assert_eq!(super::consume(b"mapstoleft;"), Some(("↤", 11)));
	assert_eq!(super::consume(b"mapstoup;"), Some(("↥", 9)));
	assert_eq!(super::consume(b"marker;"), Some(("▮", 7)));
	assert_eq!(super::consume(b"mcomma;"), Some(("⨩", 7)));
	assert_eq!(super::consume(b"mcy;"), Some(("м", 4)));
	assert_eq!(super::consume(b"mdash;"), Some(("—", 6)));
	assert_eq!(super::consume(b"measuredangle;"), Some(("∡", 14)));
	assert_eq!(super::consume(b"mfr;"), Some(("𝔪", 4)));
	assert_eq!(super::consume(b"mho;"), Some(("℧", 4)));
	assert_eq!(super::consume(b"micro"), Some(("µ", 5)));
	assert_eq!(super::consume(b"micro;"), Some(("µ", 6)));
	assert_eq!(super::consume(b"mid;"), Some(("∣", 4)));
	assert_eq!(super::consume(b"midast;"), Some(("*", 7)));
	assert_eq!(super::consume(b"midcir;"), Some(("⫰", 7)));
	assert_eq!(super::consume(b"middot"), Some(("·", 6)));
	assert_eq!(super::consume(b"middot;"), Some(("·", 7)));
	assert_eq!(super::consume(b"minus;"), Some(("−", 6)));
	assert_eq!(super::consume(b"minusb;"), Some(("⊟", 7)));
	assert_eq!(super::consume(b"minusd;"), Some(("∸", 7)));
	assert_eq!(super::consume(b"minusdu;"), Some(("⨪", 8)));
	assert_eq!(super::consume(b"mlcp;"), Some(("⫛", 5)));
	assert_eq!(super::consume(b"mldr;"), Some(("…", 5)));
	assert_eq!(super::consume(b"mnplus;"), Some(("∓", 7)));
	assert_eq!(super::consume(b"models;"), Some(("⊧", 7)));
	assert_eq!(super::consume(b"mopf;"), Some(("𝕞", 5)));
	assert_eq!(super::consume(b"mp;"), Some(("∓", 3)));
	assert_eq!(super::consume(b"mscr;"), Some(("𝓂", 5)));
	assert_eq!(super::consume(b"mstpos;"), Some(("∾", 7)));
	assert_eq!(super::consume(b"mu;"), Some(("μ", 3)));
	assert_eq!(super::consume(b"multimap;"), Some(("⊸", 9)));
	assert_eq!(super::consume(b"mumap;"), Some(("⊸", 6)));
	assert_eq!(super::consume(b"nGg;"), Some(("⋙̸", 4)));
	assert_eq!(super::consume(b"nGt;"), Some(("≫⃒", 4)));
	assert_eq!(super::consume(b"nGtv;"), Some(("≫̸", 5)));
	assert_eq!(super::consume(b"nLeftarrow;"), Some(("⇍", 11)));
	assert_eq!(super::consume(b"nLeftrightarrow;"), Some(("⇎", 16)));
	assert_eq!(super::consume(b"nLl;"), Some(("⋘̸", 4)));
	assert_eq!(super::consume(b"nLt;"), Some(("≪⃒", 4)));
	assert_eq!(super::consume(b"nLtv;"), Some(("≪̸", 5)));
	assert_eq!(super::consume(b"nRightarrow;"), Some(("⇏", 12)));
	assert_eq!(super::consume(b"nVDash;"), Some(("⊯", 7)));
	assert_eq!(super::consume(b"nVdash;"), Some(("⊮", 7)));
	assert_eq!(super::consume(b"nabla;"), Some(("∇", 6)));
	assert_eq!(super::consume(b"nacute;"), Some(("ń", 7)));
	assert_eq!(super::consume(b"nang;"), Some(("∠⃒", 5)));
	assert_eq!(super::consume(b"nap;"), Some(("≉", 4)));
	assert_eq!(super::consume(b"napE;"), Some(("⩰̸", 5)));
	assert_eq!(super::consume(b"napid;"), Some(("≋̸", 6)));
	assert_eq!(super::consume(b"napos;"), Some(("ŉ", 6)));
	assert_eq!(super::consume(b"napprox;"), Some(("≉", 8)));
	assert_eq!(super::consume(b"natur;"), Some(("♮", 6)));
	assert_eq!(super::consume(b"natural;"), Some(("♮", 8)));
	assert_eq!(super::consume(b"naturals;"), Some(("ℕ", 9)));
	assert_eq!(super::consume(b"nbsp"), Some((" ", 4)));
	assert_eq!(super::consume(b"nbsp;"), Some((" ", 5)));
	assert_eq!(super::consume(b"nbump;"), Some(("≎̸", 6)));
	assert_eq!(super::consume(b"nbumpe;"), Some(("≏̸", 7)));
	assert_eq!(super::consume(b"ncap;"), Some(("⩃", 5)));
	assert_eq!(super::consume(b"ncaron;"), Some(("ň", 7)));
	assert_eq!(super::consume(b"ncedil;"), Some(("ņ", 7)));
	assert_eq!(super::consume(b"ncong;"), Some(("≇", 6)));
	assert_eq!(super::consume(b"ncongdot;"), Some(("⩭̸", 9)));
	assert_eq!(super::consume(b"ncup;"), Some(("⩂", 5)));
	assert_eq!(super::consume(b"ncy;"), Some(("н", 4)));
	assert_eq!(super::consume(b"ndash;"), Some(("–", 6)));
	assert_eq!(super::consume(b"ne;"), Some(("≠", 3)));
	assert_eq!(super::consume(b"neArr;"), Some(("⇗", 6)));
	assert_eq!(super::consume(b"nearhk;"), Some(("⤤", 7)));
	assert_eq!(super::consume(b"nearr;"), Some(("↗", 6)));
	assert_eq!(super::consume(b"nearrow;"), Some(("↗", 8)));
	assert_eq!(super::consume(b"nedot;"), Some(("≐̸", 6)));
	assert_eq!(super::consume(b"nequiv;"), Some(("≢", 7)));
	assert_eq!(super::consume(b"nesear;"), Some(("⤨", 7)));
	assert_eq!(super::consume(b"nesim;"), Some(("≂̸", 6)));
	assert_eq!(super::consume(b"nexist;"), Some(("∄", 7)));
	assert_eq!(super::consume(b"nexists;"), Some(("∄", 8)));
	assert_eq!(super::consume(b"nfr;"), Some(("𝔫", 4)));
	assert_eq!(super::consume(b"ngE;"), Some(("≧̸", 4)));
	assert_eq!(super::consume(b"nge;"), Some(("≱", 4)));
	assert_eq!(super::consume(b"ngeq;"), Some(("≱", 5)));
	assert_eq!(super::consume(b"ngeqq;"), Some(("≧̸", 6)));
	assert_eq!(super::consume(b"ngeqslant;"), Some(("⩾̸", 10)));
	assert_eq!(super::consume(b"nges;"), Some(("⩾̸", 5)));
	assert_eq!(super::consume(b"ngsim;"), Some(("≵", 6)));
	assert_eq!(super::consume(b"ngt;"), Some(("≯", 4)));
	assert_eq!(super::consume(b"ngtr;"), Some(("≯", 5)));
	assert_eq!(super::consume(b"nhArr;"), Some(("⇎", 6)));
	assert_eq!(super::consume(b"nharr;"), Some(("↮", 6)));
	assert_eq!(super::consume(b"nhpar;"), Some(("⫲", 6)));
	assert_eq!(super::consume(b"ni;"), Some(("∋", 3)));
	assert_eq!(super::consume(b"nis;"), Some(("⋼", 4)));
	assert_eq!(super::consume(b"nisd;"), Some(("⋺", 5)));
	assert_eq!(super::consume(b"niv;"), Some(("∋", 4)));
	assert_eq!(super::consume(b"njcy;"), Some(("њ", 5)));
	assert_eq!(super::consume(b"nlArr;"), Some(("⇍", 6)));
	assert_eq!(super::consume(b"nlE;"), Some(("≦̸", 4)));
	assert_eq!(super::consume(b"nlarr;"), Some(("↚", 6)));
	assert_eq!(super::consume(b"nldr;"), Some(("‥", 5)));
	assert_eq!(super::consume(b"nle;"), Some(("≰", 4)));
	assert_eq!(super::consume(b"nleftarrow;"), Some(("↚", 11)));
	assert_eq!(super::consume(b"nleftrightarrow;"), Some(("↮", 16)));
	assert_eq!(super::consume(b"nleq;"), Some(("≰", 5)));
	assert_eq!(super::consume(b"nleqq;"), Some(("≦̸", 6)));
	assert_eq!(super::consume(b"nleqslant;"), Some(("⩽̸", 10)));
	assert_eq!(super::consume(b"nles;"), Some(("⩽̸", 5)));
	assert_eq!(super::consume(b"nless;"), Some(("≮", 6)));
	assert_eq!(super::consume(b"nlsim;"), Some(("≴", 6)));
	assert_eq!(super::consume(b"nlt;"), Some(("≮", 4)));
	assert_eq!(super::consume(b"nltri;"), Some(("⋪", 6)));
	assert_eq!(super::consume(b"nltrie;"), Some(("⋬", 7)));
	assert_eq!(super::consume(b"nmid;"), Some(("∤", 5)));
	assert_eq!(super::consume(b"nopf;"), Some(("𝕟", 5)));
	assert_eq!(super::consume(b"not"), Some(("¬", 3)));
	assert_eq!(super::consume(b"not;"), Some(("¬", 4)));
	assert_eq!(super::consume(b"notin;"), Some(("∉", 6)));
	assert_eq!(super::consume(b"notinE;"), Some(("⋹̸", 7)));
	assert_eq!(super::consume(b"notindot;"), Some(("⋵̸", 9)));
	assert_eq!(super::consume(b"notinva;"), Some(("∉", 8)));
	assert_eq!(super::consume(b"notinvb;"), Some(("⋷", 8)));
	assert_eq!(super::consume(b"notinvc;"), Some(("⋶", 8)));
	assert_eq!(super::consume(b"notni;"), Some(("∌", 6)));
	assert_eq!(super::consume(b"notniva;"), Some(("∌", 8)));
	assert_eq!(super::consume(b"notnivb;"), Some(("⋾", 8)));
	assert_eq!(super::consume(b"notnivc;"), Some(("⋽", 8)));
	assert_eq!(super::consume(b"npar;"), Some(("∦", 5)));
	assert_eq!(super::consume(b"nparallel;"), Some(("∦", 10)));
	assert_eq!(super::consume(b"nparsl;"), Some(("⫽⃥", 7)));
	assert_eq!(super::consume(b"npart;"), Some(("∂̸", 6)));
	assert_eq!(super::consume(b"npolint;"), Some(("⨔", 8)));
	assert_eq!(super::consume(b"npr;"), Some(("⊀", 4)));
	assert_eq!(super::consume(b"nprcue;"), Some(("⋠", 7)));
	assert_eq!(super::consume(b"npre;"), Some(("⪯̸", 5)));
	assert_eq!(super::consume(b"nprec;"), Some(("⊀", 6)));
	assert_eq!(super::consume(b"npreceq;"), Some(("⪯̸", 8)));
	assert_eq!(super::consume(b"nrArr;"), Some(("⇏", 6)));
	assert_eq!(super::consume(b"nrarr;"), Some(("↛", 6)));
	assert_eq!(super::consume(b"nrarrc;"), Some(("⤳̸", 7)));
	assert_eq!(super::consume(b"nrarrw;"), Some(("↝̸", 7)));
	assert_eq!(super::consume(b"nrightarrow;"), Some(("↛", 12)));
	assert_eq!(super::consume(b"nrtri;"), Some(("⋫", 6)));
	assert_eq!(super::consume(b"nrtrie;"), Some(("⋭", 7)));
	assert_eq!(super::consume(b"nsc;"), Some(("⊁", 4)));
	assert_eq!(super::consume(b"nsccue;"), Some(("⋡", 7)));
	assert_eq!(super::consume(b"nsce;"), Some(("⪰̸", 5)));
	assert_eq!(super::consume(b"nscr;"), Some(("𝓃", 5)));
	assert_eq!(super::consume(b"nshortmid;"), Some(("∤", 10)));
	assert_eq!(super::consume(b"nshortparallel;"), Some(("∦", 15)));
	assert_eq!(super::consume(b"nsim;"), Some(("≁", 5)));
	assert_eq!(super::consume(b"nsime;"), Some(("≄", 6)));
	assert_eq!(super::consume(b"nsimeq;"), Some(("≄", 7)));
	assert_eq!(super::consume(b"nsmid;"), Some(("∤", 6)));
	assert_eq!(super::consume(b"nspar;"), Some(("∦", 6)));
	assert_eq!(super::consume(b"nsqsube;"), Some(("⋢", 8)));
	assert_eq!(super::consume(b"nsqsupe;"), Some(("⋣", 8)));
	assert_eq!(super::consume(b"nsub;"), Some(("⊄", 5)));
	assert_eq!(super::consume(b"nsubE;"), Some(("⫅̸", 6)));
	assert_eq!(super::consume(b"nsube;"), Some(("⊈", 6)));
	assert_eq!(super::consume(b"nsubset;"), Some(("⊂⃒", 8)));
	assert_eq!(super::consume(b"nsubseteq;"), Some(("⊈", 10)));
	assert_eq!(super::consume(b"nsubseteqq;"), Some(("⫅̸", 11)));
	assert_eq!(super::consume(b"nsucc;"), Some(("⊁", 6)));
	assert_eq!(super::consume(b"nsucceq;"), Some(("⪰̸", 8)));
	assert_eq!(super::consume(b"nsup;"), Some(("⊅", 5)));
	assert_eq!(super::consume(b"nsupE;"), Some(("⫆̸", 6)));
	assert_eq!(super::consume(b"nsupe;"), Some(("⊉", 6)));
	assert_eq!(super::consume(b"nsupset;"), Some(("⊃⃒", 8)));
	assert_eq!(super::consume(b"nsupseteq;"), Some(("⊉", 10)));
	assert_eq!(super::consume(b"nsupseteqq;"), Some(("⫆̸", 11)));
	assert_eq!(super::consume(b"ntgl;"), Some(("≹", 5)));
	assert_eq!(super::consume(b"ntilde"), Some(("ñ", 6)));
	assert_eq!(super::consume(b"ntilde;"), Some(("ñ", 7)));
	assert_eq!(super::consume(b"ntlg;"), Some(("≸", 5)));
	assert_eq!(super::consume(b"ntriangleleft;"), Some(("⋪", 14)));
	assert_eq!(super::consume(b"ntrianglelefteq;"), Some(("⋬", 16)));
	assert_eq!(super::consume(b"ntriangleright;"), Some(("⋫", 15)));
	assert_eq!(super::consume(b"ntrianglerighteq;"), Some(("⋭", 17)));
	assert_eq!(super::consume(b"nu;"), Some(("ν", 3)));
	assert_eq!(super::consume(b"num;"), Some(("#", 4)));
	assert_eq!(super::consume(b"numero;"), Some(("№", 7)));
	assert_eq!(super::consume(b"numsp;"), Some((" ", 6)));
	assert_eq!(super::consume(b"nvDash;"), Some(("⊭", 7)));
	assert_eq!(super::consume(b"nvHarr;"), Some(("⤄", 7)));
	assert_eq!(super::consume(b"nvap;"), Some(("≍⃒", 5)));
	assert_eq!(super::consume(b"nvdash;"), Some(("⊬", 7)));
	assert_eq!(super::consume(b"nvge;"), Some(("≥⃒", 5)));
	assert_eq!(super::consume(b"nvgt;"), Some((">⃒", 5)));
	assert_eq!(super::consume(b"nvinfin;"), Some(("⧞", 8)));
	assert_eq!(super::consume(b"nvlArr;"), Some(("⤂", 7)));
	assert_eq!(super::consume(b"nvle;"), Some(("≤⃒", 5)));
	assert_eq!(super::consume(b"nvlt;"), Some(("<⃒", 5)));
	assert_eq!(super::consume(b"nvltrie;"), Some(("⊴⃒", 8)));
	assert_eq!(super::consume(b"nvrArr;"), Some(("⤃", 7)));
	assert_eq!(super::consume(b"nvrtrie;"), Some(("⊵⃒", 8)));
	assert_eq!(super::consume(b"nvsim;"), Some(("∼⃒", 6)));
	assert_eq!(super::consume(b"nwArr;"), Some(("⇖", 6)));
	assert_eq!(super::consume(b"nwarhk;"), Some(("⤣", 7)));
	assert_eq!(super::consume(b"nwarr;"), Some(("↖", 6)));
	assert_eq!(super::consume(b"nwarrow;"), Some(("↖", 8)));
	assert_eq!(super::consume(b"nwnear;"), Some(("⤧", 7)));
	assert_eq!(super::consume(b"oS;"), Some(("Ⓢ", 3)));
	assert_eq!(super::consume(b"oacute"), Some(("ó", 6)));
	assert_eq!(super::consume(b"oacute;"), Some(("ó", 7)));
	assert_eq!(super::consume(b"oast;"), Some(("⊛", 5)));
	assert_eq!(super::consume(b"ocir;"), Some(("⊚", 5)));
	assert_eq!(super::consume(b"ocirc"), Some(("ô", 5)));
	assert_eq!(super::consume(b"ocirc;"), Some(("ô", 6)));
	assert_eq!(super::consume(b"ocy;"), Some(("о", 4)));
	assert_eq!(super::consume(b"odash;"), Some(("⊝", 6)));
	assert_eq!(super::consume(b"odblac;"), Some(("ő", 7)));
	assert_eq!(super::consume(b"odiv;"), Some(("⨸", 5)));
	assert_eq!(super::consume(b"odot;"), Some(("⊙", 5)));
	assert_eq!(super::consume(b"odsold;"), Some(("⦼", 7)));
	assert_eq!(super::consume(b"oelig;"), Some(("œ", 6)));
	assert_eq!(super::consume(b"ofcir;"), Some(("⦿", 6)));
	assert_eq!(super::consume(b"ofr;"), Some(("𝔬", 4)));
	assert_eq!(super::consume(b"ogon;"), Some(("˛", 5)));
	assert_eq!(super::consume(b"ograve"), Some(("ò", 6)));
	assert_eq!(super::consume(b"ograve;"), Some(("ò", 7)));
	assert_eq!(super::consume(b"ogt;"), Some(("⧁", 4)));
	assert_eq!(super::consume(b"ohbar;"), Some(("⦵", 6)));
	assert_eq!(super::consume(b"ohm;"), Some(("Ω", 4)));
	assert_eq!(super::consume(b"oint;"), Some(("∮", 5)));
	assert_eq!(super::consume(b"olarr;"), Some(("↺", 6)));
	assert_eq!(super::consume(b"olcir;"), Some(("⦾", 6)));
	assert_eq!(super::consume(b"olcross;"), Some(("⦻", 8)));
	assert_eq!(super::consume(b"oline;"), Some(("‾", 6)));
	assert_eq!(super::consume(b"olt;"), Some(("⧀", 4)));
	assert_eq!(super::consume(b"omacr;"), Some(("ō", 6)));
	assert_eq!(super::consume(b"omega;"), Some(("ω", 6)));
	assert_eq!(super::consume(b"omicron;"), Some(("ο", 8)));
	assert_eq!(super::consume(b"omid;"), Some(("⦶", 5)));
	assert_eq!(super::consume(b"ominus;"), Some(("⊖", 7)));
	assert_eq!(super::consume(b"oopf;"), Some(("𝕠", 5)));
	assert_eq!(super::consume(b"opar;"), Some(("⦷", 5)));
	assert_eq!(super::consume(b"operp;"), Some(("⦹", 6)));
	assert_eq!(super::consume(b"oplus;"), Some(("⊕", 6)));
	assert_eq!(super::consume(b"or;"), Some(("∨", 3)));
	assert_eq!(super::consume(b"orarr;"), Some(("↻", 6)));
	assert_eq!(super::consume(b"ord;"), Some(("⩝", 4)));
	assert_eq!(super::consume(b"order;"), Some(("ℴ", 6)));
	assert_eq!(super::consume(b"orderof;"), Some(("ℴ", 8)));
	assert_eq!(super::consume(b"ordf"), Some(("ª", 4)));
	assert_eq!(super::consume(b"ordf;"), Some(("ª", 5)));
	assert_eq!(super::consume(b"ordm"), Some(("º", 4)));
	assert_eq!(super::consume(b"ordm;"), Some(("º", 5)));
	assert_eq!(super::consume(b"origof;"), Some(("⊶", 7)));
	assert_eq!(super::consume(b"oror;"), Some(("⩖", 5)));
	assert_eq!(super::consume(b"orslope;"), Some(("⩗", 8)));
	assert_eq!(super::consume(b"orv;"), Some(("⩛", 4)));
	assert_eq!(super::consume(b"oscr;"), Some(("ℴ", 5)));
	assert_eq!(super::consume(b"oslash"), Some(("ø", 6)));
	assert_eq!(super::consume(b"oslash;"), Some(("ø", 7)));
	assert_eq!(super::consume(b"osol;"), Some(("⊘", 5)));
	assert_eq!(super::consume(b"otilde"), Some(("õ", 6)));
	assert_eq!(super::consume(b"otilde;"), Some(("õ", 7)));
	assert_eq!(super::consume(b"otimes;"), Some(("⊗", 7)));
	assert_eq!(super::consume(b"otimesas;"), Some(("⨶", 9)));
	assert_eq!(super::consume(b"ouml"), Some(("ö", 4)));
	assert_eq!(super::consume(b"ouml;"), Some(("ö", 5)));
	assert_eq!(super::consume(b"ovbar;"), Some(("⌽", 6)));
	assert_eq!(super::consume(b"par;"), Some(("∥", 4)));
	assert_eq!(super::consume(b"para"), Some(("¶", 4)));
	assert_eq!(super::consume(b"para;"), Some(("¶", 5)));
	assert_eq!(super::consume(b"parallel;"), Some(("∥", 9)));
	assert_eq!(super::consume(b"parsim;"), Some(("⫳", 7)));
	assert_eq!(super::consume(b"parsl;"), Some(("⫽", 6)));
	assert_eq!(super::consume(b"part;"), Some(("∂", 5)));
	assert_eq!(super::consume(b"pcy;"), Some(("п", 4)));
	assert_eq!(super::consume(b"percnt;"), Some(("%", 7)));
	assert_eq!(super::consume(b"period;"), Some((".", 7)));
	assert_eq!(super::consume(b"permil;"), Some(("‰", 7)));
	assert_eq!(super::consume(b"perp;"), Some(("⊥", 5)));
	assert_eq!(super::consume(b"pertenk;"), Some(("‱", 8)));
	assert_eq!(super::consume(b"pfr;"), Some(("𝔭", 4)));
	assert_eq!(super::consume(b"phi;"), Some(("φ", 4)));
	assert_eq!(super::consume(b"phiv;"), Some(("ϕ", 5)));
	assert_eq!(super::consume(b"phmmat;"), Some(("ℳ", 7)));
	assert_eq!(super::consume(b"phone;"), Some(("☎", 6)));
	assert_eq!(super::consume(b"pi;"), Some(("π", 3)));
	assert_eq!(super::consume(b"pitchfork;"), Some(("⋔", 10)));
	assert_eq!(super::consume(b"piv;"), Some(("ϖ", 4)));
	assert_eq!(super::consume(b"planck;"), Some(("ℏ", 7)));
	assert_eq!(super::consume(b"planckh;"), Some(("ℎ", 8)));
	assert_eq!(super::consume(b"plankv;"), Some(("ℏ", 7)));
	assert_eq!(super::consume(b"plus;"), Some(("+", 5)));
	assert_eq!(super::consume(b"plusacir;"), Some(("⨣", 9)));
	assert_eq!(super::consume(b"plusb;"), Some(("⊞", 6)));
	assert_eq!(super::consume(b"pluscir;"), Some(("⨢", 8)));
	assert_eq!(super::consume(b"plusdo;"), Some(("∔", 7)));
	assert_eq!(super::consume(b"plusdu;"), Some(("⨥", 7)));
	assert_eq!(super::consume(b"pluse;"), Some(("⩲", 6)));
	assert_eq!(super::consume(b"plusmn"), Some(("±", 6)));
	assert_eq!(super::consume(b"plusmn;"), Some(("±", 7)));
	assert_eq!(super::consume(b"plussim;"), Some(("⨦", 8)));
	assert_eq!(super::consume(b"plustwo;"), Some(("⨧", 8)));
	assert_eq!(super::consume(b"pm;"), Some(("±", 3)));
	assert_eq!(super::consume(b"pointint;"), Some(("⨕", 9)));
	assert_eq!(super::consume(b"popf;"), Some(("𝕡", 5)));
	assert_eq!(super::consume(b"pound"), Some(("£", 5)));
	assert_eq!(super::consume(b"pound;"), Some(("£", 6)));
	assert_eq!(super::consume(b"pr;"), Some(("≺", 3)));
	assert_eq!(super::consume(b"prE;"), Some(("⪳", 4)));
	assert_eq!(super::consume(b"prap;"), Some(("⪷", 5)));
	assert_eq!(super::consume(b"prcue;"), Some(("≼", 6)));
	assert_eq!(super::consume(b"pre;"), Some(("⪯", 4)));
	assert_eq!(super::consume(b"prec;"), Some(("≺", 5)));
	assert_eq!(super::consume(b"precapprox;"), Some(("⪷", 11)));
	assert_eq!(super::consume(b"preccurlyeq;"), Some(("≼", 12)));
	assert_eq!(super::consume(b"preceq;"), Some(("⪯", 7)));
	assert_eq!(super::consume(b"precnapprox;"), Some(("⪹", 12)));
	assert_eq!(super::consume(b"precneqq;"), Some(("⪵", 9)));
	assert_eq!(super::consume(b"precnsim;"), Some(("⋨", 9)));
	assert_eq!(super::consume(b"precsim;"), Some(("≾", 8)));
	assert_eq!(super::consume(b"prime;"), Some(("′", 6)));
	assert_eq!(super::consume(b"primes;"), Some(("ℙ", 7)));
	assert_eq!(super::consume(b"prnE;"), Some(("⪵", 5)));
	assert_eq!(super::consume(b"prnap;"), Some(("⪹", 6)));
	assert_eq!(super::consume(b"prnsim;"), Some(("⋨", 7)));
	assert_eq!(super::consume(b"prod;"), Some(("∏", 5)));
	assert_eq!(super::consume(b"profalar;"), Some(("⌮", 9)));
	assert_eq!(super::consume(b"profline;"), Some(("⌒", 9)));
	assert_eq!(super::consume(b"profsurf;"), Some(("⌓", 9)));
	assert_eq!(super::consume(b"prop;"), Some(("∝", 5)));
	assert_eq!(super::consume(b"propto;"), Some(("∝", 7)));
	assert_eq!(super::consume(b"prsim;"), Some(("≾", 6)));
	assert_eq!(super::consume(b"prurel;"), Some(("⊰", 7)));
	assert_eq!(super::consume(b"pscr;"), Some(("𝓅", 5)));
	assert_eq!(super::consume(b"psi;"), Some(("ψ", 4)));
	assert_eq!(super::consume(b"puncsp;"), Some((" ", 7)));
	assert_eq!(super::consume(b"qfr;"), Some(("𝔮", 4)));
	assert_eq!(super::consume(b"qint;"), Some(("⨌", 5)));
	assert_eq!(super::consume(b"qopf;"), Some(("𝕢", 5)));
	assert_eq!(super::consume(b"qprime;"), Some(("⁗", 7)));
	assert_eq!(super::consume(b"qscr;"), Some(("𝓆", 5)));
	assert_eq!(super::consume(b"quaternions;"), Some(("ℍ", 12)));
	assert_eq!(super::consume(b"quatint;"), Some(("⨖", 8)));
	assert_eq!(super::consume(b"quest;"), Some(("?", 6)));
	assert_eq!(super::consume(b"questeq;"), Some(("≟", 8)));
	assert_eq!(super::consume(b"quot"), Some(("\"", 4)));
	assert_eq!(super::consume(b"quot;"), Some(("\"", 5)));
	assert_eq!(super::consume(b"rAarr;"), Some(("⇛", 6)));
	assert_eq!(super::consume(b"rArr;"), Some(("⇒", 5)));
	assert_eq!(super::consume(b"rAtail;"), Some(("⤜", 7)));
	assert_eq!(super::consume(b"rBarr;"), Some(("⤏", 6)));
	assert_eq!(super::consume(b"rHar;"), Some(("⥤", 5)));
	assert_eq!(super::consume(b"race;"), Some(("∽̱", 5)));
	assert_eq!(super::consume(b"racute;"), Some(("ŕ", 7)));
	assert_eq!(super::consume(b"radic;"), Some(("√", 6)));
	assert_eq!(super::consume(b"raemptyv;"), Some(("⦳", 9)));
	assert_eq!(super::consume(b"rang;"), Some(("⟩", 5)));
	assert_eq!(super::consume(b"rangd;"), Some(("⦒", 6)));
	assert_eq!(super::consume(b"range;"), Some(("⦥", 6)));
	assert_eq!(super::consume(b"rangle;"), Some(("⟩", 7)));
	assert_eq!(super::consume(b"raquo"), Some(("»", 5)));
	assert_eq!(super::consume(b"raquo;"), Some(("»", 6)));
	assert_eq!(super::consume(b"rarr;"), Some(("→", 5)));
	assert_eq!(super::consume(b"rarrap;"), Some(("⥵", 7)));
	assert_eq!(super::consume(b"rarrb;"), Some(("⇥", 6)));
	assert_eq!(super::consume(b"rarrbfs;"), Some(("⤠", 8)));
	assert_eq!(super::consume(b"rarrc;"), Some(("⤳", 6)));
	assert_eq!(super::consume(b"rarrfs;"), Some(("⤞", 7)));
	assert_eq!(super::consume(b"rarrhk;"), Some(("↪", 7)));
	assert_eq!(super::consume(b"rarrlp;"), Some(("↬", 7)));
	assert_eq!(super::consume(b"rarrpl;"), Some(("⥅", 7)));
	assert_eq!(super::consume(b"rarrsim;"), Some(("⥴", 8)));
	assert_eq!(super::consume(b"rarrtl;"), Some(("↣", 7)));
	assert_eq!(super::consume(b"rarrw;"), Some(("↝", 6)));
	assert_eq!(super::consume(b"ratail;"), Some(("⤚", 7)));
	assert_eq!(super::consume(b"ratio;"), Some(("∶", 6)));
	assert_eq!(super::consume(b"rationals;"), Some(("ℚ", 10)));
	assert_eq!(super::consume(b"rbarr;"), Some(("⤍", 6)));
	assert_eq!(super::consume(b"rbbrk;"), Some(("❳", 6)));
	assert_eq!(super::consume(b"rbrace;"), Some(("}", 7)));
	assert_eq!(super::consume(b"rbrack;"), Some(("]", 7)));
	assert_eq!(super::consume(b"rbrke;"), Some(("⦌", 6)));
	assert_eq!(super::consume(b"rbrksld;"), Some(("⦎", 8)));
	assert_eq!(super::consume(b"rbrkslu;"), Some(("⦐", 8)));
	assert_eq!(super::consume(b"rcaron;"), Some(("ř", 7)));
	assert_eq!(super::consume(b"rcedil;"), Some(("ŗ", 7)));
	assert_eq!(super::consume(b"rceil;"), Some(("⌉", 6)));
	assert_eq!(super::consume(b"rcub;"), Some(("}", 5)));
	assert_eq!(super::consume(b"rcy;"), Some(("р", 4)));
	assert_eq!(super::consume(b"rdca;"), Some(("⤷", 5)));
	assert_eq!(super::consume(b"rdldhar;"), Some(("⥩", 8)));
	assert_eq!(super::consume(b"rdquo;"), Some(("”", 6)));
	assert_eq!(super::consume(b"rdquor;"), Some(("”", 7)));
	assert_eq!(super::consume(b"rdsh;"), Some(("↳", 5)));
	assert_eq!(super::consume(b"real;"), Some(("ℜ", 5)));
	assert_eq!(super::consume(b"realine;"), Some(("ℛ", 8)));
	assert_eq!(super::consume(b"realpart;"), Some(("ℜ", 9)));
	assert_eq!(super::consume(b"reals;"), Some(("ℝ", 6)));
	assert_eq!(super::consume(b"rect;"), Some(("▭", 5)));
	assert_eq!(super::consume(b"reg"), Some(("®", 3)));
	assert_eq!(super::consume(b"reg;"), Some(("®", 4)));
	assert_eq!(super::consume(b"rfisht;"), Some(("⥽", 7)));
	assert_eq!(super::consume(b"rfloor;"), Some(("⌋", 7)));
	assert_eq!(super::consume(b"rfr;"), Some(("𝔯", 4)));
	assert_eq!(super::consume(b"rhard;"), Some(("⇁", 6)));
	assert_eq!(super::consume(b"rharu;"), Some(("⇀", 6)));
	assert_eq!(super::consume(b"rharul;"), Some(("⥬", 7)));
	assert_eq!(super::consume(b"rho;"), Some(("ρ", 4)));
	assert_eq!(super::consume(b"rhov;"), Some(("ϱ", 5)));
	assert_eq!(super::consume(b"rightarrow;"), Some(("→", 11)));
	assert_eq!(super::consume(b"rightarrowtail;"), Some(("↣", 15)));
	assert_eq!(super::consume(b"rightharpoondown;"), Some(("⇁", 17)));
	assert_eq!(super::consume(b"rightharpoonup;"), Some(("⇀", 15)));
	assert_eq!(super::consume(b"rightleftarrows;"), Some(("⇄", 16)));
	assert_eq!(super::consume(b"rightleftharpoons;"), Some(("⇌", 18)));
	assert_eq!(super::consume(b"rightrightarrows;"), Some(("⇉", 17)));
	assert_eq!(super::consume(b"rightsquigarrow;"), Some(("↝", 16)));
	assert_eq!(super::consume(b"rightthreetimes;"), Some(("⋌", 16)));
	assert_eq!(super::consume(b"ring;"), Some(("˚", 5)));
	assert_eq!(super::consume(b"risingdotseq;"), Some(("≓", 13)));
	assert_eq!(super::consume(b"rlarr;"), Some(("⇄", 6)));
	assert_eq!(super::consume(b"rlhar;"), Some(("⇌", 6)));
	assert_eq!(super::consume(b"rlm;"), Some(("‏", 4)));
	assert_eq!(super::consume(b"rmoust;"), Some(("⎱", 7)));
	assert_eq!(super::consume(b"rmoustache;"), Some(("⎱", 11)));
	assert_eq!(super::consume(b"rnmid;"), Some(("⫮", 6)));
	assert_eq!(super::consume(b"roang;"), Some(("⟭", 6)));
	assert_eq!(super::consume(b"roarr;"), Some(("⇾", 6)));
	assert_eq!(super::consume(b"robrk;"), Some(("⟧", 6)));
	assert_eq!(super::consume(b"ropar;"), Some(("⦆", 6)));
	assert_eq!(super::consume(b"ropf;"), Some(("𝕣", 5)));
	assert_eq!(super::consume(b"roplus;"), Some(("⨮", 7)));
	assert_eq!(super::consume(b"rotimes;"), Some(("⨵", 8)));
	assert_eq!(super::consume(b"rpar;"), Some((")", 5)));
	assert_eq!(super::consume(b"rpargt;"), Some(("⦔", 7)));
	assert_eq!(super::consume(b"rppolint;"), Some(("⨒", 9)));
	assert_eq!(super::consume(b"rrarr;"), Some(("⇉", 6)));
	assert_eq!(super::consume(b"rsaquo;"), Some(("›", 7)));
	assert_eq!(super::consume(b"rscr;"), Some(("𝓇", 5)));
	assert_eq!(super::consume(b"rsh;"), Some(("↱", 4)));
	assert_eq!(super::consume(b"rsqb;"), Some(("]", 5)));
	assert_eq!(super::consume(b"rsquo;"), Some(("’", 6)));
	assert_eq!(super::consume(b"rsquor;"), Some(("’", 7)));
	assert_eq!(super::consume(b"rthree;"), Some(("⋌", 7)));
	assert_eq!(super::consume(b"rtimes;"), Some(("⋊", 7)));
	assert_eq!(super::consume(b"rtri;"), Some(("▹", 5)));
	assert_eq!(super::consume(b"rtrie;"), Some(("⊵", 6)));
	assert_eq!(super::consume(b"rtrif;"), Some(("▸", 6)));
	assert_eq!(super::consume(b"rtriltri;"), Some(("⧎", 9)));
	assert_eq!(super::consume(b"ruluhar;"), Some(("⥨", 8)));
	assert_eq!(super::consume(b"rx;"), Some(("℞", 3)));
	assert_eq!(super::consume(b"sacute;"), Some(("ś", 7)));
	assert_eq!(super::consume(b"sbquo;"), Some(("‚", 6)));
	assert_eq!(super::consume(b"sc;"), Some(("≻", 3)));
	assert_eq!(super::consume(b"scE;"), Some(("⪴", 4)));
	assert_eq!(super::consume(b"scap;"), Some(("⪸", 5)));
	assert_eq!(super::consume(b"scaron;"), Some(("š", 7)));
	assert_eq!(super::consume(b"sccue;"), Some(("≽", 6)));
	assert_eq!(super::consume(b"sce;"), Some(("⪰", 4)));
	assert_eq!(super::consume(b"scedil;"), Some(("ş", 7)));
	assert_eq!(super::consume(b"scirc;"), Some(("ŝ", 6)));
	assert_eq!(super::consume(b"scnE;"), Some(("⪶", 5)));
	assert_eq!(super::consume(b"scnap;"), Some(("⪺", 6)));
	assert_eq!(super::consume(b"scnsim;"), Some(("⋩", 7)));
	assert_eq!(super::consume(b"scpolint;"), Some(("⨓", 9)));
	assert_eq!(super::consume(b"scsim;"), Some(("≿", 6)));
	assert_eq!(super::consume(b"scy;"), Some(("с", 4)));
	assert_eq!(super::consume(b"sdot;"), Some(("⋅", 5)));
	assert_eq!(super::consume(b"sdotb;"), Some(("⊡", 6)));
	assert_eq!(super::consume(b"sdote;"), Some(("⩦", 6)));
	assert_eq!(super::consume(b"seArr;"), Some(("⇘", 6)));
	assert_eq!(super::consume(b"searhk;"), Some(("⤥", 7)));
	assert_eq!(super::consume(b"searr;"), Some(("↘", 6)));
	assert_eq!(super::consume(b"searrow;"), Some(("↘", 8)));
	assert_eq!(super::consume(b"sect"), Some(("§", 4)));
	assert_eq!(super::consume(b"sect;"), Some(("§", 5)));
	assert_eq!(super::consume(b"semi;"), Some((";", 5)));
	assert_eq!(super::consume(b"seswar;"), Some(("⤩", 7)));
	assert_eq!(super::consume(b"setminus;"), Some(("∖", 9)));
	assert_eq!(super::consume(b"setmn;"), Some(("∖", 6)));
	assert_eq!(super::consume(b"sext;"), Some(("✶", 5)));
	assert_eq!(super::consume(b"sfr;"), Some(("𝔰", 4)));
	assert_eq!(super::consume(b"sfrown;"), Some(("⌢", 7)));
	assert_eq!(super::consume(b"sharp;"), Some(("♯", 6)));
	assert_eq!(super::consume(b"shchcy;"), Some(("щ", 7)));
	assert_eq!(super::consume(b"shcy;"), Some(("ш", 5)));
	assert_eq!(super::consume(b"shortmid;"), Some(("∣", 9)));
	assert_eq!(super::consume(b"shortparallel;"), Some(("∥", 14)));
	assert_eq!(super::consume(b"shy"), Some(("­", 3)));
	assert_eq!(super::consume(b"shy;"), Some(("­", 4)));
	assert_eq!(super::consume(b"sigma;"), Some(("σ", 6)));
	assert_eq!(super::consume(b"sigmaf;"), Some(("ς", 7)));
	assert_eq!(super::consume(b"sigmav;"), Some(("ς", 7)));
	assert_eq!(super::consume(b"sim;"), Some(("∼", 4)));
	assert_eq!(super::consume(b"simdot;"), Some(("⩪", 7)));
	assert_eq!(super::consume(b"sime;"), Some(("≃", 5)));
	assert_eq!(super::consume(b"simeq;"), Some(("≃", 6)));
	assert_eq!(super::consume(b"simg;"), Some(("⪞", 5)));
	assert_eq!(super::consume(b"simgE;"), Some(("⪠", 6)));
	assert_eq!(super::consume(b"siml;"), Some(("⪝", 5)));
	assert_eq!(super::consume(b"simlE;"), Some(("⪟", 6)));
	assert_eq!(super::consume(b"simne;"), Some(("≆", 6)));
	assert_eq!(super::consume(b"simplus;"), Some(("⨤", 8)));
	assert_eq!(super::consume(b"simrarr;"), Some(("⥲", 8)));
	assert_eq!(super::consume(b"slarr;"), Some(("←", 6)));
	assert_eq!(super::consume(b"smallsetminus;"), Some(("∖", 14)));
	assert_eq!(super::consume(b"smashp;"), Some(("⨳", 7)));
	assert_eq!(super::consume(b"smeparsl;"), Some(("⧤", 9)));
	assert_eq!(super::consume(b"smid;"), Some(("∣", 5)));
	assert_eq!(super::consume(b"smile;"), Some(("⌣", 6)));
	assert_eq!(super::consume(b"smt;"), Some(("⪪", 4)));
	assert_eq!(super::consume(b"smte;"), Some(("⪬", 5)));
	assert_eq!(super::consume(b"smtes;"), Some(("⪬︀", 6)));
	assert_eq!(super::consume(b"softcy;"), Some(("ь", 7)));
	assert_eq!(super::consume(b"sol;"), Some(("/", 4)));
	assert_eq!(super::consume(b"solb;"), Some(("⧄", 5)));
	assert_eq!(super::consume(b"solbar;"), Some(("⌿", 7)));
	assert_eq!(super::consume(b"sopf;"), Some(("𝕤", 5)));
	assert_eq!(super::consume(b"spades;"), Some(("♠", 7)));
	assert_eq!(super::consume(b"spadesuit;"), Some(("♠", 10)));
	assert_eq!(super::consume(b"spar;"), Some(("∥", 5)));
	assert_eq!(super::consume(b"sqcap;"), Some(("⊓", 6)));
	assert_eq!(super::consume(b"sqcaps;"), Some(("⊓︀", 7)));
	assert_eq!(super::consume(b"sqcup;"), Some(("⊔", 6)));
	assert_eq!(super::consume(b"sqcups;"), Some(("⊔︀", 7)));
	assert_eq!(super::consume(b"sqsub;"), Some(("⊏", 6)));
	assert_eq!(super::consume(b"sqsube;"), Some(("⊑", 7)));
	assert_eq!(super::consume(b"sqsubset;"), Some(("⊏", 9)));
	assert_eq!(super::consume(b"sqsubseteq;"), Some(("⊑", 11)));
	assert_eq!(super::consume(b"sqsup;"), Some(("⊐", 6)));
	assert_eq!(super::consume(b"sqsupe;"), Some(("⊒", 7)));
	assert_eq!(super::consume(b"sqsupset;"), Some(("⊐", 9)));
	assert_eq!(super::consume(b"sqsupseteq;"), Some(("⊒", 11)));
	assert_eq!(super::consume(b"squ;"), Some(("□", 4)));
	assert_eq!(super::consume(b"square;"), Some(("□", 7)));
	assert_eq!(super::consume(b"squarf;"), Some(("▪", 7)));
	assert_eq!(super::consume(b"squf;"), Some(("▪", 5)));
	assert_eq!(super::consume(b"srarr;"), Some(("→", 6)));
	assert_eq!(super::consume(b"sscr;"), Some(("𝓈", 5)));
	assert_eq!(super::consume(b"ssetmn;"), Some(("∖", 7)));
	assert_eq!(super::consume(b"ssmile;"), Some(("⌣", 7)));
	assert_eq!(super::consume(b"sstarf;"), Some(("⋆", 7)));
	assert_eq!(super::consume(b"star;"), Some(("☆", 5)));
	assert_eq!(super::consume(b"starf;"), Some(("★", 6)));
	assert_eq!(super::consume(b"straightepsilon;"), Some(("ϵ", 16)));
	assert_eq!(super::consume(b"straightphi;"), Some(("ϕ", 12)));
	assert_eq!(super::consume(b"strns;"), Some(("¯", 6)));
	assert_eq!(super::consume(b"sub;"), Some(("⊂", 4)));
	assert_eq!(super::consume(b"subE;"), Some(("⫅", 5)));
	assert_eq!(super::consume(b"subdot;"), Some(("⪽", 7)));
	assert_eq!(super::consume(b"sube;"), Some(("⊆", 5)));
	assert_eq!(super::consume(b"subedot;"), Some(("⫃", 8)));
	assert_eq!(super::consume(b"submult;"), Some(("⫁", 8)));
	assert_eq!(super::consume(b"subnE;"), Some(("⫋", 6)));
	assert_eq!(super::consume(b"subne;"), Some(("⊊", 6)));
	assert_eq!(super::consume(b"subplus;"), Some(("⪿", 8)));
	assert_eq!(super::consume(b"subrarr;"), Some(("⥹", 8)));
	assert_eq!(super::consume(b"subset;"), Some(("⊂", 7)));
	assert_eq!(super::consume(b"subseteq;"), Some(("⊆", 9)));
	assert_eq!(super::consume(b"subseteqq;"), Some(("⫅", 10)));
	assert_eq!(super::consume(b"subsetneq;"), Some(("⊊", 10)));
	assert_eq!(super::consume(b"subsetneqq;"), Some(("⫋", 11)));
	assert_eq!(super::consume(b"subsim;"), Some(("⫇", 7)));
	assert_eq!(super::consume(b"subsub;"), Some(("⫕", 7)));
	assert_eq!(super::consume(b"subsup;"), Some(("⫓", 7)));
	assert_eq!(super::consume(b"succ;"), Some(("≻", 5)));
	assert_eq!(super::consume(b"succapprox;"), Some(("⪸", 11)));
	assert_eq!(super::consume(b"succcurlyeq;"), Some(("≽", 12)));
	assert_eq!(super::consume(b"succeq;"), Some(("⪰", 7)));
	assert_eq!(super::consume(b"succnapprox;"), Some(("⪺", 12)));
	assert_eq!(super::consume(b"succneqq;"), Some(("⪶", 9)));
	assert_eq!(super::consume(b"succnsim;"), Some(("⋩", 9)));
	assert_eq!(super::consume(b"succsim;"), Some(("≿", 8)));
	assert_eq!(super::consume(b"sum;"), Some(("∑", 4)));
	assert_eq!(super::consume(b"sung;"), Some(("♪", 5)));
	assert_eq!(super::consume(b"sup1"), Some(("¹", 4)));
	assert_eq!(super::consume(b"sup1;"), Some(("¹", 5)));
	assert_eq!(super::consume(b"sup2"), Some(("²", 4)));
	assert_eq!(super::consume(b"sup2;"), Some(("²", 5)));
	assert_eq!(super::consume(b"sup3"), Some(("³", 4)));
	assert_eq!(super::consume(b"sup3;"), Some(("³", 5)));
	assert_eq!(super::consume(b"sup;"), Some(("⊃", 4)));
	assert_eq!(super::consume(b"supE;"), Some(("⫆", 5)));
	assert_eq!(super::consume(b"supdot;"), Some(("⪾", 7)));
	assert_eq!(super::consume(b"supdsub;"), Some(("⫘", 8)));
	assert_eq!(super::consume(b"supe;"), Some(("⊇", 5)));
	assert_eq!(super::consume(b"supedot;"), Some(("⫄", 8)));
	assert_eq!(super::consume(b"suphsol;"), Some(("⟉", 8)));
	assert_eq!(super::consume(b"suphsub;"), Some(("⫗", 8)));
	assert_eq!(super::consume(b"suplarr;"), Some(("⥻", 8)));
	assert_eq!(super::consume(b"supmult;"), Some(("⫂", 8)));
	assert_eq!(super::consume(b"supnE;"), Some(("⫌", 6)));
	assert_eq!(super::consume(b"supne;"), Some(("⊋", 6)));
	assert_eq!(super::consume(b"supplus;"), Some(("⫀", 8)));
	assert_eq!(super::consume(b"supset;"), Some(("⊃", 7)));
	assert_eq!(super::consume(b"supseteq;"), Some(("⊇", 9)));
	assert_eq!(super::consume(b"supseteqq;"), Some(("⫆", 10)));
	assert_eq!(super::consume(b"supsetneq;"), Some(("⊋", 10)));
	assert_eq!(super::consume(b"supsetneqq;"), Some(("⫌", 11)));
	assert_eq!(super::consume(b"supsim;"), Some(("⫈", 7)));
	assert_eq!(super::consume(b"supsub;"), Some(("⫔", 7)));
	assert_eq!(super::consume(b"supsup;"), Some(("⫖", 7)));
	assert_eq!(super::consume(b"swArr;"), Some(("⇙", 6)));
	assert_eq!(super::consume(b"swarhk;"), Some(("⤦", 7)));
	assert_eq!(super::consume(b"swarr;"), Some(("↙", 6)));
	assert_eq!(super::consume(b"swarrow;"), Some(("↙", 8)));
	assert_eq!(super::consume(b"swnwar;"), Some(("⤪", 7)));
	assert_eq!(super::consume(b"szlig"), Some(("ß", 5)));
	assert_eq!(super::consume(b"szlig;"), Some(("ß", 6)));
	assert_eq!(super::consume(b"target;"), Some(("⌖", 7)));
	assert_eq!(super::consume(b"tau;"), Some(("τ", 4)));
	assert_eq!(super::consume(b"tbrk;"), Some(("⎴", 5)));
	assert_eq!(super::consume(b"tcaron;"), Some(("ť", 7)));
	assert_eq!(super::consume(b"tcedil;"), Some(("ţ", 7)));
	assert_eq!(super::consume(b"tcy;"), Some(("т", 4)));
	assert_eq!(super::consume(b"tdot;"), Some(("⃛", 5)));
	assert_eq!(super::consume(b"telrec;"), Some(("⌕", 7)));
	assert_eq!(super::consume(b"tfr;"), Some(("𝔱", 4)));
	assert_eq!(super::consume(b"there4;"), Some(("∴", 7)));
	assert_eq!(super::consume(b"therefore;"), Some(("∴", 10)));
	assert_eq!(super::consume(b"theta;"), Some(("θ", 6)));
	assert_eq!(super::consume(b"thetasym;"), Some(("ϑ", 9)));
	assert_eq!(super::consume(b"thetav;"), Some(("ϑ", 7)));
	assert_eq!(super::consume(b"thickapprox;"), Some(("≈", 12)));
	assert_eq!(super::consume(b"thicksim;"), Some(("∼", 9)));
	assert_eq!(super::consume(b"thinsp;"), Some((" ", 7)));
	assert_eq!(super::consume(b"thkap;"), Some(("≈", 6)));
	assert_eq!(super::consume(b"thksim;"), Some(("∼", 7)));
	assert_eq!(super::consume(b"thorn"), Some(("þ", 5)));
	assert_eq!(super::consume(b"thorn;"), Some(("þ", 6)));
	assert_eq!(super::consume(b"tilde;"), Some(("˜", 6)));
	assert_eq!(super::consume(b"times"), Some(("×", 5)));
	assert_eq!(super::consume(b"times;"), Some(("×", 6)));
	assert_eq!(super::consume(b"timesb;"), Some(("⊠", 7)));
	assert_eq!(super::consume(b"timesbar;"), Some(("⨱", 9)));
	assert_eq!(super::consume(b"timesd;"), Some(("⨰", 7)));
	assert_eq!(super::consume(b"tint;"), Some(("∭", 5)));
	assert_eq!(super::consume(b"toea;"), Some(("⤨", 5)));
	assert_eq!(super::consume(b"top;"), Some(("⊤", 4)));
	assert_eq!(super::consume(b"topbot;"), Some(("⌶", 7)));
	assert_eq!(super::consume(b"topcir;"), Some(("⫱", 7)));
	assert_eq!(super::consume(b"topf;"), Some(("𝕥", 5)));
	assert_eq!(super::consume(b"topfork;"), Some(("⫚", 8)));
	assert_eq!(super::consume(b"tosa;"), Some(("⤩", 5)));
	assert_eq!(super::consume(b"tprime;"), Some(("‴", 7)));
	assert_eq!(super::consume(b"trade;"), Some(("™", 6)));
	assert_eq!(super::consume(b"triangle;"), Some(("▵", 9)));
	assert_eq!(super::consume(b"triangledown;"), Some(("▿", 13)));
	assert_eq!(super::consume(b"triangleleft;"), Some(("◃", 13)));
	assert_eq!(super::consume(b"trianglelefteq;"), Some(("⊴", 15)));
	assert_eq!(super::consume(b"triangleq;"), Some(("≜", 10)));
	assert_eq!(super::consume(b"triangleright;"), Some(("▹", 14)));
	assert_eq!(super::consume(b"trianglerighteq;"), Some(("⊵", 16)));
	assert_eq!(super::consume(b"tridot;"), Some(("◬", 7)));
	assert_eq!(super::consume(b"trie;"), Some(("≜", 5)));
	assert_eq!(super::consume(b"triminus;"), Some(("⨺", 9)));
	assert_eq!(super::consume(b"triplus;"), Some(("⨹", 8)));
	assert_eq!(super::consume(b"trisb;"), Some(("⧍", 6)));
	assert_eq!(super::consume(b"tritime;"), Some(("⨻", 8)));
	assert_eq!(super::consume(b"trpezium;"), Some(("⏢", 9)));
	assert_eq!(super::consume(b"tscr;"), Some(("𝓉", 5)));
	assert_eq!(super::consume(b"tscy;"), Some(("ц", 5)));
	assert_eq!(super::consume(b"tshcy;"), Some(("ћ", 6)));
	assert_eq!(super::consume(b"tstrok;"), Some(("ŧ", 7)));
	assert_eq!(super::consume(b"twixt;"), Some(("≬", 6)));
	assert_eq!(super::consume(b"twoheadleftarrow;"), Some(("↞", 17)));
	assert_eq!(super::consume(b"twoheadrightarrow;"), Some(("↠", 18)));
	assert_eq!(super::consume(b"uArr;"), Some(("⇑", 5)));
	assert_eq!(super::consume(b"uHar;"), Some(("⥣", 5)));
	assert_eq!(super::consume(b"uacute"), Some(("ú", 6)));
	assert_eq!(super::consume(b"uacute;"), Some(("ú", 7)));
	assert_eq!(super::consume(b"uarr;"), Some(("↑", 5)));
	assert_eq!(super::consume(b"ubrcy;"), Some(("ў", 6)));
	assert_eq!(super::consume(b"ubreve;"), Some(("ŭ", 7)));
	assert_eq!(super::consume(b"ucirc"), Some(("û", 5)));
	assert_eq!(super::consume(b"ucirc;"), Some(("û", 6)));
	assert_eq!(super::consume(b"ucy;"), Some(("у", 4)));
	assert_eq!(super::consume(b"udarr;"), Some(("⇅", 6)));
	assert_eq!(super::consume(b"udblac;"), Some(("ű", 7)));
	assert_eq!(super::consume(b"udhar;"), Some(("⥮", 6)));
	assert_eq!(super::consume(b"ufisht;"), Some(("⥾", 7)));
	assert_eq!(super::consume(b"ufr;"), Some(("𝔲", 4)));
	assert_eq!(super::consume(b"ugrave"), Some(("ù", 6)));
	assert_eq!(super::consume(b"ugrave;"), Some(("ù", 7)));
	assert_eq!(super::consume(b"uharl;"), Some(("↿", 6)));
	assert_eq!(super::consume(b"uharr;"), Some(("↾", 6)));
	assert_eq!(super::consume(b"uhblk;"), Some(("▀", 6)));
	assert_eq!(super::consume(b"ulcorn;"), Some(("⌜", 7)));
	assert_eq!(super::consume(b"ulcorner;"), Some(("⌜", 9)));
	assert_eq!(super::consume(b"ulcrop;"), Some(("⌏", 7)));
	assert_eq!(super::consume(b"ultri;"), Some(("◸", 6)));
	assert_eq!(super::consume(b"umacr;"), Some(("ū", 6)));
	assert_eq!(super::consume(b"uml"), Some(("¨", 3)));
	assert_eq!(super::consume(b"uml;"), Some(("¨", 4)));
	assert_eq!(super::consume(b"uogon;"), Some(("ų", 6)));
	assert_eq!(super::consume(b"uopf;"), Some(("𝕦", 5)));
	assert_eq!(super::consume(b"uparrow;"), Some(("↑", 8)));
	assert_eq!(super::consume(b"updownarrow;"), Some(("↕", 12)));
	assert_eq!(super::consume(b"upharpoonleft;"), Some(("↿", 14)));
	assert_eq!(super::consume(b"upharpoonright;"), Some(("↾", 15)));
	assert_eq!(super::consume(b"uplus;"), Some(("⊎", 6)));
	assert_eq!(super::consume(b"upsi;"), Some(("υ", 5)));
	assert_eq!(super::consume(b"upsih;"), Some(("ϒ", 6)));
	assert_eq!(super::consume(b"upsilon;"), Some(("υ", 8)));
	assert_eq!(super::consume(b"upuparrows;"), Some(("⇈", 11)));
	assert_eq!(super::consume(b"urcorn;"), Some(("⌝", 7)));
	assert_eq!(super::consume(b"urcorner;"), Some(("⌝", 9)));
	assert_eq!(super::consume(b"urcrop;"), Some(("⌎", 7)));
	assert_eq!(super::consume(b"uring;"), Some(("ů", 6)));
	assert_eq!(super::consume(b"urtri;"), Some(("◹", 6)));
	assert_eq!(super::consume(b"uscr;"), Some(("𝓊", 5)));
	assert_eq!(super::consume(b"utdot;"), Some(("⋰", 6)));
	assert_eq!(super::consume(b"utilde;"), Some(("ũ", 7)));
	assert_eq!(super::consume(b"utri;"), Some(("▵", 5)));
	assert_eq!(super::consume(b"utrif;"), Some(("▴", 6)));
	assert_eq!(super::consume(b"uuarr;"), Some(("⇈", 6)));
	assert_eq!(super::consume(b"uuml"), Some(("ü", 4)));
	assert_eq!(super::consume(b"uuml;"), Some(("ü", 5)));
	assert_eq!(super::consume(b"uwangle;"), Some(("⦧", 8)));
	assert_eq!(super::consume(b"vArr;"), Some(("⇕", 5)));
	assert_eq!(super::consume(b"vBar;"), Some(("⫨", 5)));
	assert_eq!(super::consume(b"vBarv;"), Some(("⫩", 6)));
	assert_eq!(super::consume(b"vDash;"), Some(("⊨", 6)));
	assert_eq!(super::consume(b"vangrt;"), Some(("⦜", 7)));
	assert_eq!(super::consume(b"varepsilon;"), Some(("ϵ", 11)));
	assert_eq!(super::consume(b"varkappa;"), Some(("ϰ", 9)));
	assert_eq!(super::consume(b"varnothing;"), Some(("∅", 11)));
	assert_eq!(super::consume(b"varphi;"), Some(("ϕ", 7)));
	assert_eq!(super::consume(b"varpi;"), Some(("ϖ", 6)));
	assert_eq!(super::consume(b"varpropto;"), Some(("∝", 10)));
	assert_eq!(super::consume(b"varr;"), Some(("↕", 5)));
	assert_eq!(super::consume(b"varrho;"), Some(("ϱ", 7)));
	assert_eq!(super::consume(b"varsigma;"), Some(("ς", 9)));
	assert_eq!(super::consume(b"varsubsetneq;"), Some(("⊊︀", 13)));
	assert_eq!(super::consume(b"varsubsetneqq;"), Some(("⫋︀", 14)));
	assert_eq!(super::consume(b"varsupsetneq;"), Some(("⊋︀", 13)));
	assert_eq!(super::consume(b"varsupsetneqq;"), Some(("⫌︀", 14)));
	assert_eq!(super::consume(b"vartheta;"), Some(("ϑ", 9)));
	assert_eq!(super::consume(b"vartriangleleft;"), Some(("⊲", 16)));
	assert_eq!(super::consume(b"vartriangleright;"), Some(("⊳", 17)));
	assert_eq!(super::consume(b"vcy;"), Some(("в", 4)));
	assert_eq!(super::consume(b"vdash;"), Some(("⊢", 6)));
	assert_eq!(super::consume(b"vee;"), Some(("∨", 4)));
	assert_eq!(super::consume(b"veebar;"), Some(("⊻", 7)));
	assert_eq!(super::consume(b"veeeq;"), Some(("≚", 6)));
	assert_eq!(super::consume(b"vellip;"), Some(("⋮", 7)));
	assert_eq!(super::consume(b"verbar;"), Some(("|", 7)));
	assert_eq!(super::consume(b"vert;"), Some(("|", 5)));
	assert_eq!(super::consume(b"vfr;"), Some(("𝔳", 4)));
	assert_eq!(super::consume(b"vltri;"), Some(("⊲", 6)));
	assert_eq!(super::consume(b"vnsub;"), Some(("⊂⃒", 6)));
	assert_eq!(super::consume(b"vnsup;"), Some(("⊃⃒", 6)));
	assert_eq!(super::consume(b"vopf;"), Some(("𝕧", 5)));
	assert_eq!(super::consume(b"vprop;"), Some(("∝", 6)));
	assert_eq!(super::consume(b"vrtri;"), Some(("⊳", 6)));
	assert_eq!(super::consume(b"vscr;"), Some(("𝓋", 5)));
	assert_eq!(super::consume(b"vsubnE;"), Some(("⫋︀", 7)));
	assert_eq!(super::consume(b"vsubne;"), Some(("⊊︀", 7)));
	assert_eq!(super::consume(b"vsupnE;"), Some(("⫌︀", 7)));
	assert_eq!(super::consume(b"vsupne;"), Some(("⊋︀", 7)));
	assert_eq!(super::consume(b"vzigzag;"), Some(("⦚", 8)));
	assert_eq!(super::consume(b"wcirc;"), Some(("ŵ", 6)));
	assert_eq!(super::consume(b"wedbar;"), Some(("⩟", 7)));
	assert_eq!(super::consume(b"wedge;"), Some(("∧", 6)));
	assert_eq!(super::consume(b"wedgeq;"), Some(("≙", 7)));
	assert_eq!(super::consume(b"weierp;"), Some(("℘", 7)));
	assert_eq!(super::consume(b"wfr;"), Some(("𝔴", 4)));
	assert_eq!(super::consume(b"wopf;"), Some(("𝕨", 5)));
	assert_eq!(super::consume(b"wp;"), Some(("℘", 3)));
	assert_eq!(super::consume(b"wr;"), Some(("≀", 3)));
	assert_eq!(super::consume(b"wreath;"), Some(("≀", 7)));
	assert_eq!(super::consume(b"wscr;"), Some(("𝓌", 5)));
	assert_eq!(super::consume(b"xcap;"), Some(("⋂", 5)));
	assert_eq!(super::consume(b"xcirc;"), Some(("◯", 6)));
	assert_eq!(super::consume(b"xcup;"), Some(("⋃", 5)));
	assert_eq!(super::consume(b"xdtri;"), Some(("▽", 6)));
	assert_eq!(super::consume(b"xfr;"), Some(("𝔵", 4)));
	assert_eq!(super::consume(b"xhArr;"), Some(("⟺", 6)));
	assert_eq!(super::consume(b"xharr;"), Some(("⟷", 6)));
	assert_eq!(super::consume(b"xi;"), Some(("ξ", 3)));
	assert_eq!(super::consume(b"xlArr;"), Some(("⟸", 6)));
	assert_eq!(super::consume(b"xlarr;"), Some(("⟵", 6)));
	assert_eq!(super::consume(b"xmap;"), Some(("⟼", 5)));
	assert_eq!(super::consume(b"xnis;"), Some(("⋻", 5)));
	assert_eq!(super::consume(b"xodot;"), Some(("⨀", 6)));
	assert_eq!(super::consume(b"xopf;"), Some(("𝕩", 5)));
	assert_eq!(super::consume(b"xoplus;"), Some(("⨁", 7)));
	assert_eq!(super::consume(b"xotime;"), Some(("⨂", 7)));
	assert_eq!(super::consume(b"xrArr;"), Some(("⟹", 6)));
	assert_eq!(super::consume(b"xrarr;"), Some(("⟶", 6)));
	assert_eq!(super::consume(b"xscr;"), Some(("𝓍", 5)));
	assert_eq!(super::consume(b"xsqcup;"), Some(("⨆", 7)));
	assert_eq!(super::consume(b"xuplus;"), Some(("⨄", 7)));
	assert_eq!(super::consume(b"xutri;"), Some(("△", 6)));
	assert_eq!(super::consume(b"xvee;"), Some(("⋁", 5)));
	assert_eq!(super::consume(b"xwedge;"), Some(("⋀", 7)));
	assert_eq!(super::consume(b"yacute"), Some(("ý", 6)));
	assert_eq!(super::consume(b"yacute;"), Some(("ý", 7)));
	assert_eq!(super::consume(b"yacy;"), Some(("я", 5)));
	assert_eq!(super::consume(b"ycirc;"), Some(("ŷ", 6)));
	assert_eq!(super::consume(b"ycy;"), Some(("ы", 4)));
	assert_eq!(super::consume(b"yen"), Some(("¥", 3)));
	assert_eq!(super::consume(b"yen;"), Some(("¥", 4)));
	assert_eq!(super::consume(b"yfr;"), Some(("𝔶", 4)));
	assert_eq!(super::consume(b"yicy;"), Some(("ї", 5)));
	assert_eq!(super::consume(b"yopf;"), Some(("𝕪", 5)));
	assert_eq!(super::consume(b"yscr;"), Some(("𝓎", 5)));
	assert_eq!(super::consume(b"yucy;"), Some(("ю", 5)));
	assert_eq!(super::consume(b"yuml"), Some(("ÿ", 4)));
	assert_eq!(super::consume(b"yuml;"), Some(("ÿ", 5)));
	assert_eq!(super::consume(b"zacute;"), Some(("ź", 7)));
	assert_eq!(super::consume(b"zcaron;"), Some(("ž", 7)));
	assert_eq!(super::consume(b"zcy;"), Some(("з", 4)));
	assert_eq!(super::consume(b"zdot;"), Some(("ż", 5)));
	assert_eq!(super::consume(b"zeetrf;"), Some(("ℨ", 7)));
	assert_eq!(super::consume(b"zeta;"), Some(("ζ", 5)));
	assert_eq!(super::consume(b"zfr;"), Some(("𝔷", 4)));
	assert_eq!(super::consume(b"zhcy;"), Some(("ж", 5)));
	assert_eq!(super::consume(b"zigrarr;"), Some(("⇝", 8)));
	assert_eq!(super::consume(b"zopf;"), Some(("𝕫", 5)));
	assert_eq!(super::consume(b"zscr;"), Some(("𝓏", 5)));
	assert_eq!(super::consume(b"zwj;"), Some(("‍", 4)));
	assert_eq!(super::consume(b"zwnj;"), Some(("‌", 5)));
}
