// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
	"github.com/go-acme/jdcloud-sdk-go/core"
)

type DescribeDomainQueryTrafficRequest struct {
	core.JDCloudRequest

	/* 实例所属的地域ID  */
	RegionId string `json:"regionId"`

	/* 域名ID，请使用describeDomains接口获取。  */
	DomainId string `json:"domainId"`

	/* 主域名，请使用describeDomains接口获取  */
	DomainName string `json:"domainName"`

	/* 时间段的起始时间, UTC时间格式，例如2017-11-10T23:00:00Z  */
	Start string `json:"start"`

	/* 时间段的终止时间, UTC时间格式，例如2017-11-10T23:00:00Z  */
	End string `json:"end"`
}

/*
 * param regionId: 实例所属的地域ID (Required)
 * param domainId: 域名ID，请使用describeDomains接口获取。 (Required)
 * param domainName: 主域名，请使用describeDomains接口获取 (Required)
 * param start: 时间段的起始时间, UTC时间格式，例如2017-11-10T23:00:00Z (Required)
 * param end: 时间段的终止时间, UTC时间格式，例如2017-11-10T23:00:00Z (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewDescribeDomainQueryTrafficRequest(
	regionId string,
	domainId string,
	domainName string,
	start string,
	end string,
) *DescribeDomainQueryTrafficRequest {

	return &DescribeDomainQueryTrafficRequest{
		JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/domain/{domainId}/queryTraffic",
			Method:  "GET",
			Header:  nil,
			Version: "v2",
		},
		RegionId:   regionId,
		DomainId:   domainId,
		DomainName: domainName,
		Start:      start,
		End:        end,
	}
}

/*
 * param regionId: 实例所属的地域ID (Required)
 * param domainId: 域名ID，请使用describeDomains接口获取。 (Required)
 * param domainName: 主域名，请使用describeDomains接口获取 (Required)
 * param start: 时间段的起始时间, UTC时间格式，例如2017-11-10T23:00:00Z (Required)
 * param end: 时间段的终止时间, UTC时间格式，例如2017-11-10T23:00:00Z (Required)
 */
func NewDescribeDomainQueryTrafficRequestWithAllParams(
	regionId string,
	domainId string,
	domainName string,
	start string,
	end string,
) *DescribeDomainQueryTrafficRequest {

	return &DescribeDomainQueryTrafficRequest{
		JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/domain/{domainId}/queryTraffic",
			Method:  "GET",
			Header:  nil,
			Version: "v2",
		},
		RegionId:   regionId,
		DomainId:   domainId,
		DomainName: domainName,
		Start:      start,
		End:        end,
	}
}

/* This constructor has better compatible ability when API parameters changed */
func NewDescribeDomainQueryTrafficRequestWithoutParam() *DescribeDomainQueryTrafficRequest {

	return &DescribeDomainQueryTrafficRequest{
		JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/domain/{domainId}/queryTraffic",
			Method:  "GET",
			Header:  nil,
			Version: "v2",
		},
	}
}

/* param regionId: 实例所属的地域ID(Required) */
func (r *DescribeDomainQueryTrafficRequest) SetRegionId(regionId string) {
	r.RegionId = regionId
}

/* param domainId: 域名ID，请使用describeDomains接口获取。(Required) */
func (r *DescribeDomainQueryTrafficRequest) SetDomainId(domainId string) {
	r.DomainId = domainId
}

/* param domainName: 主域名，请使用describeDomains接口获取(Required) */
func (r *DescribeDomainQueryTrafficRequest) SetDomainName(domainName string) {
	r.DomainName = domainName
}

/* param start: 时间段的起始时间, UTC时间格式，例如2017-11-10T23:00:00Z(Required) */
func (r *DescribeDomainQueryTrafficRequest) SetStart(start string) {
	r.Start = start
}

/* param end: 时间段的终止时间, UTC时间格式，例如2017-11-10T23:00:00Z(Required) */
func (r *DescribeDomainQueryTrafficRequest) SetEnd(end string) {
	r.End = end
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r DescribeDomainQueryTrafficRequest) GetRegionId() string {
	return r.RegionId
}

type DescribeDomainQueryTrafficResponse struct {
	RequestID string                           `json:"requestId"`
	Error     core.ErrorResponse               `json:"error"`
	Result    DescribeDomainQueryTrafficResult `json:"result"`
}

type DescribeDomainQueryTrafficResult struct {
	Time    []int64   `json:"time"`
	Unit    string    `json:"unit"`
	Traffic []float64 `json:"traffic"`
}
