#include "lastfm-priv.h"
#include <stdlib.h>

LASTFM_TAG_INFO *_new_LASTFM_TAG_INFO(){
	LASTFM_TAG_INFO *a;
	a = malloc(sizeof(LASTFM_TAG_INFO));
	a->name = NULL;
	a->url = NULL;
	a->summary = NULL;
	a->reach = 0;
	a->count = 0;
	return a;
}

void LASTFM_free_tag_info(LASTFM_TAG_INFO *t){
	if(t == NULL) return;
	if(t->name)    free(t->name);
	if(t->url)     free(t->url);
	if(t->summary) free(t->summary);
	free(t);
}

void LASTFM_print_tag_info(FILE *out, LASTFM_TAG_INFO *a){
	if(a == NULL) return;
	fprintf(out,"name    = %s\n",a->name);
	fprintf(out,"count   = %u\n",a->count);
	fprintf(out,"url     = %s\n",a->url);
	fprintf(out,"summary = %s\n",a->summary);
}

static void free_LASTFM_TAG_INFO(LASTFM_TAG_INFO *a, void *udata){
	LASTFM_free_tag_info(a);
}

void LASTFM_free_tag_info_list(LFMList *list){
	LFMList_foreach(list,(LFMFunc)free_LASTFM_TAG_INFO,NULL);
	LFMList_free(list);
}
