/*
  Copyright (c) 2012 Christopher Howard

  This file is part of the Recursive Remove Library.
  
  the Recursive Remove Library is free software: you can redistribute it and/or modify
  it under the terms of the GNU Lesser General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  the Recursive Remove Library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public License
  along with the Recursive Remove Library.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef _RREMOVE_H_
#define _RREMOVE_H_

#include <stdio.h>

/* return values for rrmdir */

#define RR_OKAY 0
#define RR_FILEERR -1

/* bit flags for rremove */

/* treat first remove failure as a serious error and return immediately with errno
   default: remove all files possible */
#define RR_STOP_ON_ERR 0x1
/* ignore filesystem boundaries
   default: refuse to remove files not on the same file system as the root file */
#define RR_IGNORE_FS 0x2

/*
   ERRSTREAM is the destination for error messages (e.g., stderr).
   Returns -1 if some file removals failed, but the recursion completed.
   Returns a postive errno for a more serious error. Either way, an error is
   provided to errstream, unless errstream is set to NULL, in which case no
   error messages are generated. Returns 0 otherwise.
*/
extern int rremove(const char * pathname, int flags, FILE * errstream);

#endif /* _RREMOVE_H_ */
