/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.api.internal;

import java.util.ArrayList;
import java.util.Collection;
import org.sonarsource.scanner.api.internal.ServerConnection;
import org.sonarsource.scanner.api.internal.cache.Logger;

class BootstrapIndexDownloader {
    private final ServerConnection conn;
    private final Logger logger;

    BootstrapIndexDownloader(ServerConnection conn, Logger logger) {
        this.conn = conn;
        this.logger = logger;
    }

    Collection<JarEntry> getIndex() {
        String index;
        try {
            this.logger.debug("Get bootstrap index...");
            index = this.conn.downloadString("/batch/index");
            this.logger.debug("Get bootstrap completed");
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to get bootstrap index from server", e);
        }
        return BootstrapIndexDownloader.parse(index);
    }

    private static Collection<JarEntry> parse(String index) {
        String[] lines;
        ArrayList<JarEntry> entries = new ArrayList<JarEntry>();
        for (String line : lines = index.split("[\r\n]+")) {
            try {
                line = line.trim();
                String[] libAndHash = line.split("\\|");
                String filename = libAndHash[0];
                String hash = libAndHash[1];
                entries.add(new JarEntry(filename, hash));
            }
            catch (Exception e) {
                throw new IllegalStateException("Fail to parse entry in bootstrap index: " + line);
            }
        }
        return entries;
    }

    static class JarEntry {
        private String filename;
        private String hash;

        JarEntry(String filename, String hash) {
            this.filename = filename;
            this.hash = hash;
        }

        public String getFilename() {
            return this.filename;
        }

        public String getHash() {
            return this.hash;
        }
    }
}

