:octicons-tag-24: v3.6.0

An alternative way to configure mocks is to use the `#!go //mockery:generate` directive. Mockery parses the doc comments and allows you to override configuration of specific interfaces in the source code. For example:

```yaml title=".mockery.yml"
all: false
packages:
    github.com/vektra/mockery/v3/internal/fixtures/directive_comments_example:
```

We set the top-level `#!yaml all: false` (which is the default value, anyway) to ensure that interfaces are by default not generated. We can then specify the doc comment directive to include the interface:

```go title="interface.go"
package directivecommentsexample

// Requester is an interface that defines a method for making HTTP requests.
//
//mockery:generate: true
type Requester interface {
	Get(path string) (string, error)
}
```

<div class="result" markdown>
``` title=""
2025-11-11T14:40:22.897665000-05:00 INF adding interface to collection collection=/Users/landonclipp/git/LandonTClipp/mockery/internal/fixtures/directive_comments_example/mocks_test.go interface=Requester package-path=github.com/vektra/mockery/v3/internal/fixtures/directive_comments_example version=v0.0.0-dev
```
</div>

We can also specify any config value that mockery supports. For example, let's rename the mock's structname:

```
// Requester is an interface that defines a method for making HTTP requests.
//
//mockery:generate: true
//mockery:structname: MockFoo
type Requester interface {
	Get(path string) (string, error)
}
```

The new `structname` is applied as expected:

```go
// MockFoo is an autogenerated mock type for the Requester type
type MockFoo struct {
	mock.Mock
}
```

!!! note

    The `#!yaml generate:` parameter is only effectual from within the doc comment itself. It has no effect if specified within the mockery config file.