/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

//
//Copyright 2024 The Kubernetes Authors.
//
//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.

// To regenerate api.pb.go run `hack/update-codegen.sh protobindings`

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v4.23.4
// source: staging/src/k8s.io/kubelet/pkg/apis/dra/v1beta1/api.proto

package v1beta1

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	DRAPlugin_NodePrepareResources_FullMethodName   = "/k8s.io.kubelet.pkg.apis.dra.v1beta1.DRAPlugin/NodePrepareResources"
	DRAPlugin_NodeUnprepareResources_FullMethodName = "/k8s.io.kubelet.pkg.apis.dra.v1beta1.DRAPlugin/NodeUnprepareResources"
)

// DRAPluginClient is the client API for DRAPlugin service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type DRAPluginClient interface {
	// NodePrepareResources prepares several ResourceClaims
	// for use on the node. If an error is returned, the
	// response is ignored. Failures for individual claims
	// can be reported inside NodePrepareResourcesResponse.
	NodePrepareResources(ctx context.Context, in *NodePrepareResourcesRequest, opts ...grpc.CallOption) (*NodePrepareResourcesResponse, error)
	// NodeUnprepareResources is the opposite of NodePrepareResources.
	// The same error handling rules apply,
	NodeUnprepareResources(ctx context.Context, in *NodeUnprepareResourcesRequest, opts ...grpc.CallOption) (*NodeUnprepareResourcesResponse, error)
}

type dRAPluginClient struct {
	cc grpc.ClientConnInterface
}

func NewDRAPluginClient(cc grpc.ClientConnInterface) DRAPluginClient {
	return &dRAPluginClient{cc}
}

func (c *dRAPluginClient) NodePrepareResources(ctx context.Context, in *NodePrepareResourcesRequest, opts ...grpc.CallOption) (*NodePrepareResourcesResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(NodePrepareResourcesResponse)
	err := c.cc.Invoke(ctx, DRAPlugin_NodePrepareResources_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dRAPluginClient) NodeUnprepareResources(ctx context.Context, in *NodeUnprepareResourcesRequest, opts ...grpc.CallOption) (*NodeUnprepareResourcesResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(NodeUnprepareResourcesResponse)
	err := c.cc.Invoke(ctx, DRAPlugin_NodeUnprepareResources_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DRAPluginServer is the server API for DRAPlugin service.
// All implementations must embed UnimplementedDRAPluginServer
// for forward compatibility.
type DRAPluginServer interface {
	// NodePrepareResources prepares several ResourceClaims
	// for use on the node. If an error is returned, the
	// response is ignored. Failures for individual claims
	// can be reported inside NodePrepareResourcesResponse.
	NodePrepareResources(context.Context, *NodePrepareResourcesRequest) (*NodePrepareResourcesResponse, error)
	// NodeUnprepareResources is the opposite of NodePrepareResources.
	// The same error handling rules apply,
	NodeUnprepareResources(context.Context, *NodeUnprepareResourcesRequest) (*NodeUnprepareResourcesResponse, error)
	mustEmbedUnimplementedDRAPluginServer()
}

// UnimplementedDRAPluginServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedDRAPluginServer struct{}

func (UnimplementedDRAPluginServer) NodePrepareResources(context.Context, *NodePrepareResourcesRequest) (*NodePrepareResourcesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method NodePrepareResources not implemented")
}
func (UnimplementedDRAPluginServer) NodeUnprepareResources(context.Context, *NodeUnprepareResourcesRequest) (*NodeUnprepareResourcesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method NodeUnprepareResources not implemented")
}
func (UnimplementedDRAPluginServer) mustEmbedUnimplementedDRAPluginServer() {}
func (UnimplementedDRAPluginServer) testEmbeddedByValue()                   {}

// UnsafeDRAPluginServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to DRAPluginServer will
// result in compilation errors.
type UnsafeDRAPluginServer interface {
	mustEmbedUnimplementedDRAPluginServer()
}

func RegisterDRAPluginServer(s grpc.ServiceRegistrar, srv DRAPluginServer) {
	// If the following call pancis, it indicates UnimplementedDRAPluginServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&DRAPlugin_ServiceDesc, srv)
}

func _DRAPlugin_NodePrepareResources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NodePrepareResourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DRAPluginServer).NodePrepareResources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DRAPlugin_NodePrepareResources_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DRAPluginServer).NodePrepareResources(ctx, req.(*NodePrepareResourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DRAPlugin_NodeUnprepareResources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NodeUnprepareResourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DRAPluginServer).NodeUnprepareResources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DRAPlugin_NodeUnprepareResources_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DRAPluginServer).NodeUnprepareResources(ctx, req.(*NodeUnprepareResourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// DRAPlugin_ServiceDesc is the grpc.ServiceDesc for DRAPlugin service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var DRAPlugin_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "k8s.io.kubelet.pkg.apis.dra.v1beta1.DRAPlugin",
	HandlerType: (*DRAPluginServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "NodePrepareResources",
			Handler:    _DRAPlugin_NodePrepareResources_Handler,
		},
		{
			MethodName: "NodeUnprepareResources",
			Handler:    _DRAPlugin_NodeUnprepareResources_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "staging/src/k8s.io/kubelet/pkg/apis/dra/v1beta1/api.proto",
}
