/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.converter.jaxb;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlRootElement;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jaxb.JaxbRequestConverter;
import retrofit2.converter.jaxb.JaxbResponseConverter;

public final class JaxbConverterFactory
extends Converter.Factory {
    static final MediaType XML = MediaType.get("application/xml; charset=utf-8");
    @Nullable
    private final JAXBContext context;

    public static JaxbConverterFactory create() {
        return new JaxbConverterFactory(null);
    }

    public static JaxbConverterFactory create(JAXBContext context) {
        if (context == null) {
            throw new NullPointerException("context == null");
        }
        return new JaxbConverterFactory(context);
    }

    private JaxbConverterFactory(@Nullable JAXBContext context) {
        this.context = context;
    }

    @Override
    @Nullable
    public Converter<?, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
        if (type instanceof Class && ((Class)type).isAnnotationPresent(XmlRootElement.class)) {
            return new JaxbRequestConverter(this.contextForType((Class)type), (Class)type);
        }
        return null;
    }

    @Override
    @Nullable
    public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
        if (type instanceof Class && ((Class)type).isAnnotationPresent(XmlRootElement.class)) {
            return new JaxbResponseConverter(this.contextForType((Class)type), (Class)type);
        }
        return null;
    }

    private JAXBContext contextForType(Class<?> type) {
        try {
            return this.context != null ? this.context : JAXBContext.newInstance(type);
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

