/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.util.spec.validator;

import java.io.IOException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.extractor.clientConfiguration.util.spec.FileSpec;
import org.jfrog.build.extractor.clientConfiguration.util.spec.Spec;
import org.jfrog.build.extractor.clientConfiguration.util.spec.validator.SpecsValidator;

public class UploadSpecValidator
extends SpecsValidator {
    @Override
    public void validate(Spec spec) throws IOException {
        if (ArrayUtils.isEmpty(spec.getFiles())) {
            throw new IllegalArgumentException("Spec must contain at least one fileSpec.");
        }
        for (FileSpec fileSpec : spec.getFiles()) {
            boolean isAql = StringUtils.isNotBlank(fileSpec.getAql());
            boolean isPattern = StringUtils.isNotBlank(fileSpec.getPattern());
            if (!isAql && !isPattern) {
                throw new IllegalArgumentException("Upload Spec must contain AQL or Pattern key");
            }
            if (StringUtils.isBlank(fileSpec.getTarget())) {
                throw new IllegalArgumentException("The argument 'target' is missing from the upload spec.");
            }
            if (StringUtils.isBlank(fileSpec.getPattern())) {
                throw new IllegalArgumentException("The argument 'pattern' is missing from the upload spec.");
            }
            UploadSpecValidator.validateQueryInputs(fileSpec);
        }
    }
}

