/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.marshal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubySymbol;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.UnmarshalStream;

public class UnmarshalCache {
    private final Ruby runtime;
    private final List<IRubyObject> links = new ArrayList<IRubyObject>();
    private final List<RubySymbol> symbols = new ArrayList<RubySymbol>();
    private final Map<IRubyObject, IRubyObject> partials = new IdentityHashMap<IRubyObject, IRubyObject>();

    public UnmarshalCache(Ruby runtime2) {
        this.runtime = runtime2;
    }

    public boolean isPartialObject(IRubyObject value2) {
        return this.partials.containsKey(value2);
    }

    public void markAsPartialObject(IRubyObject value2) {
        this.partials.put(value2, value2);
    }

    public void noLongerPartial(IRubyObject value2) {
        this.partials.remove(value2);
    }

    public IRubyObject readSymbolLink(UnmarshalStream input) throws IOException {
        try {
            return this.symbols.get(input.unmarshalInt());
        }
        catch (IndexOutOfBoundsException e) {
            throw this.runtime.newTypeError("bad symbol");
        }
    }

    public IRubyObject readDataLink(UnmarshalStream input) throws IOException {
        int index2 = input.unmarshalInt();
        try {
            return this.links.get(index2);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.runtime.newArgumentError("dump format error (unlinked, index: " + index2 + ")");
        }
    }

    public void registerDataLink(IRubyObject value2) {
        this.links.add(value2);
    }

    public void registerSymbolLink(RubySymbol value2) {
        this.symbols.add(value2);
    }

    @Deprecated
    public IRubyObject readLink(UnmarshalStream input, int type2) throws IOException {
        return type2 == 64 ? this.readDataLink(input) : this.readSymbolLink(input);
    }

    @Deprecated
    public void register(IRubyObject value2) {
        this.selectCache(value2).add(value2);
    }

    @Deprecated
    public boolean isLinkType(int c) {
        return c == 59 || c == 64;
    }

    @Deprecated
    private List selectCache(IRubyObject value2) {
        return value2 instanceof RubySymbol ? this.symbols : this.links;
    }
}

