   /*******************************************************/
   /*      "C" Language Integrated Production System      */
   /*                                                     */
   /*             CLIPS Version 6.40  08/25/16            */
   /*                                                     */
   /*         DEFFACTS BASIC COMMANDS HEADER FILE         */
   /*******************************************************/

/*************************************************************/
/* Purpose: Implements core commands for the deffacts        */
/*   construct such as clear, reset, save, undeffacts,       */
/*   ppdeffacts, list-deffacts, and get-deffacts-list.       */
/*                                                           */
/* Principal Programmer(s):                                  */
/*      Gary D. Riley                                        */
/*                                                           */
/* Contributing Programmer(s):                               */
/*      Brian L. Dantes                                      */
/*                                                           */
/* Revision History:                                         */
/*                                                           */
/*      6.23: Corrected compilation errors for files         */
/*            generated by constructs-to-c. DR0861           */
/*                                                           */
/*      6.24: Renamed BOOLEAN macro type to intBool.         */
/*                                                           */
/*      6.30: Removed conditional code for unsupported       */
/*            compilers/operating systems (IBM_MCW,          */
/*            MAC_MCW, and IBM_TBC).                         */
/*                                                           */
/*            Added const qualifiers to remove C++           */
/*            deprecation warnings.                          */
/*                                                           */
/*            Converted API macros to function calls.        */
/*                                                           */
/*      6.40: Removed LOCALE definition.                     */
/*                                                           */
/*            Pragma once and other inclusion changes.       */
/*                                                           */
/*            Added support for booleans with <stdbool.h>.   */
/*                                                           */
/*            Removed use of void pointers for specific      */
/*            data structures.                               */
/*                                                           */
/*            ALLOW_ENVIRONMENT_GLOBALS no longer supported. */
/*                                                           */
/*            UDF redesign.                                  */
/*                                                           */
/*************************************************************/

#ifndef _H_dffctbsc

#pragma once

#define _H_dffctbsc

#include "dffctdef.h"
#include "evaluatn.h"

   void                           DeffactsBasicCommands(Environment *);
   void                           UndeffactsCommand(Environment *,UDFContext *,UDFValue *);
   bool                           Undeffacts(Deffacts *,Environment *);
   void                           GetDeffactsListFunction(Environment *,UDFContext *,UDFValue *);
   void                           GetDeffactsList(Environment *,CLIPSValue *,Defmodule *);
   void                           DeffactsModuleFunction(Environment *,UDFContext *,UDFValue *);
   void                           PPDeffactsCommand(Environment *,UDFContext *,UDFValue *);
   bool                           PPDeffacts(Environment *,const char *,const char *);
   void                           ListDeffactsCommand(Environment *,UDFContext *,UDFValue *);
   void                           ListDeffacts(Environment *,const char *,Defmodule *);

#endif /* _H_dffctbsc */

