//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;

use crate::*;

/// Define what type of document this is.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsxmldocumentcontentkind?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSXMLDocumentContentKind(pub NSUInteger);
impl NSXMLDocumentContentKind {
    #[doc(alias = "NSXMLDocumentXMLKind")]
    pub const XMLKind: Self = Self(0);
    #[doc(alias = "NSXMLDocumentXHTMLKind")]
    pub const XHTMLKind: Self = Self(1);
    #[doc(alias = "NSXMLDocumentHTMLKind")]
    pub const HTMLKind: Self = Self(2);
    #[doc(alias = "NSXMLDocumentTextKind")]
    pub const TextKind: Self = Self(3);
}

unsafe impl Encode for NSXMLDocumentContentKind {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSXMLDocumentContentKind {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// An XML Document
    ///
    /// Note: if the application of a method would result in more than one element in the children array, an exception is thrown. Trying to add a document, namespace, attribute, or node with a parent also throws an exception. To add a node with a parent first detach or create a copy of it.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsxmldocument?language=objc)
    #[unsafe(super(NSXMLNode, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(feature = "NSXMLNode")]
    pub struct NSXMLDocument;
);

#[cfg(all(feature = "NSObject", feature = "NSXMLNode"))]
extern_conformance!(
    unsafe impl NSCopying for NSXMLDocument {}
);

#[cfg(all(feature = "NSObject", feature = "NSXMLNode"))]
unsafe impl CopyingHelper for NSXMLDocument {
    type Result = Self;
}

#[cfg(feature = "NSXMLNode")]
extern_conformance!(
    unsafe impl NSObjectProtocol for NSXMLDocument {}
);

#[cfg(feature = "NSXMLNode")]
impl NSXMLDocument {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[cfg(all(
            feature = "NSError",
            feature = "NSString",
            feature = "NSXMLNodeOptions"
        ))]
        /// Returns a document created from either XML or HTML, if the HTMLTidy option is set. Parse errors are returned in
        /// <tt>
        /// error
        /// </tt>
        /// .
        #[unsafe(method(initWithXMLString:options:error:_))]
        #[unsafe(method_family = init)]
        pub fn initWithXMLString_options_error(
            this: Allocated<Self>,
            string: &NSString,
            mask: NSXMLNodeOptions,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(all(feature = "NSError", feature = "NSURL", feature = "NSXMLNodeOptions"))]
        /// Returns a document created from the contents of an XML or HTML URL. Connection problems such as 404, parse errors are returned in
        /// <tt>
        /// error
        /// </tt>
        /// .
        #[unsafe(method(initWithContentsOfURL:options:error:_))]
        #[unsafe(method_family = init)]
        pub fn initWithContentsOfURL_options_error(
            this: Allocated<Self>,
            url: &NSURL,
            mask: NSXMLNodeOptions,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(all(feature = "NSData", feature = "NSError", feature = "NSXMLNodeOptions"))]
        /// Returns a document created from data. Parse errors are returned in
        /// <tt>
        /// error
        /// </tt>
        /// .
        #[unsafe(method(initWithData:options:error:_))]
        #[unsafe(method_family = init)]
        pub fn initWithData_options_error(
            this: Allocated<Self>,
            data: &NSData,
            mask: NSXMLNodeOptions,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(feature = "NSXMLElement")]
        /// Returns a document with a single child, the root element.
        #[unsafe(method(initWithRootElement:))]
        #[unsafe(method_family = init)]
        pub fn initWithRootElement(
            this: Allocated<Self>,
            element: Option<&NSXMLElement>,
        ) -> Retained<Self>;

        /// # Safety
        ///
        /// `cls` probably has further requirements.
        #[unsafe(method(replacementClassForClass:))]
        #[unsafe(method_family = none)]
        pub unsafe fn replacementClassForClass(cls: &AnyClass) -> &'static AnyClass;

        #[cfg(feature = "NSString")]
        /// Sets the character encoding to an IANA type.
        #[unsafe(method(characterEncoding))]
        #[unsafe(method_family = none)]
        pub fn characterEncoding(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        /// Setter for [`characterEncoding`][Self::characterEncoding].
        ///
        /// This is [copied][crate::NSCopying::copy] when set.
        #[unsafe(method(setCharacterEncoding:))]
        #[unsafe(method_family = none)]
        pub fn setCharacterEncoding(&self, character_encoding: Option<&NSString>);

        #[cfg(feature = "NSString")]
        /// Sets the XML version. Should be 1.0 or 1.1.
        #[unsafe(method(version))]
        #[unsafe(method_family = none)]
        pub fn version(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        /// Setter for [`version`][Self::version].
        ///
        /// This is [copied][crate::NSCopying::copy] when set.
        #[unsafe(method(setVersion:))]
        #[unsafe(method_family = none)]
        pub fn setVersion(&self, version: Option<&NSString>);

        /// Set whether this document depends on an external DTD. If this option is set the standalone declaration will appear on output.
        #[unsafe(method(isStandalone))]
        #[unsafe(method_family = none)]
        pub fn isStandalone(&self) -> bool;

        /// Setter for [`isStandalone`][Self::isStandalone].
        #[unsafe(method(setStandalone:))]
        #[unsafe(method_family = none)]
        pub fn setStandalone(&self, standalone: bool);

        /// The kind of document.
        #[unsafe(method(documentContentKind))]
        #[unsafe(method_family = none)]
        pub fn documentContentKind(&self) -> NSXMLDocumentContentKind;

        /// Setter for [`documentContentKind`][Self::documentContentKind].
        #[unsafe(method(setDocumentContentKind:))]
        #[unsafe(method_family = none)]
        pub fn setDocumentContentKind(&self, document_content_kind: NSXMLDocumentContentKind);

        #[cfg(feature = "NSString")]
        /// Set the MIME type, eg text/xml.
        #[unsafe(method(MIMEType))]
        #[unsafe(method_family = none)]
        pub fn MIMEType(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        /// Setter for [`MIMEType`][Self::MIMEType].
        ///
        /// This is [copied][crate::NSCopying::copy] when set.
        #[unsafe(method(setMIMEType:))]
        #[unsafe(method_family = none)]
        pub fn setMIMEType(&self, mime_type: Option<&NSString>);

        #[cfg(feature = "NSXMLDTD")]
        /// Set the associated DTD. This DTD will be output with the document.
        #[unsafe(method(DTD))]
        #[unsafe(method_family = none)]
        pub fn DTD(&self) -> Option<Retained<NSXMLDTD>>;

        #[cfg(feature = "NSXMLDTD")]
        /// Setter for [`DTD`][Self::DTD].
        ///
        /// This is [copied][crate::NSCopying::copy] when set.
        #[unsafe(method(setDTD:))]
        #[unsafe(method_family = none)]
        pub fn setDTD(&self, dtd: Option<&NSXMLDTD>);

        #[cfg(feature = "NSXMLElement")]
        /// Set the root element. Removes all other children including comments and processing-instructions.
        #[unsafe(method(setRootElement:))]
        #[unsafe(method_family = none)]
        pub fn setRootElement(&self, root: &NSXMLElement);

        #[cfg(feature = "NSXMLElement")]
        /// The root element.
        #[unsafe(method(rootElement))]
        #[unsafe(method_family = none)]
        pub fn rootElement(&self) -> Option<Retained<NSXMLElement>>;

        /// Inserts a child at a particular index.
        #[unsafe(method(insertChild:atIndex:))]
        #[unsafe(method_family = none)]
        pub fn insertChild_atIndex(&self, child: &NSXMLNode, index: NSUInteger);

        #[cfg(feature = "NSArray")]
        /// Insert several children at a particular index.
        #[unsafe(method(insertChildren:atIndex:))]
        #[unsafe(method_family = none)]
        pub fn insertChildren_atIndex(&self, children: &NSArray<NSXMLNode>, index: NSUInteger);

        /// Removes a child at a particular index.
        #[unsafe(method(removeChildAtIndex:))]
        #[unsafe(method_family = none)]
        pub fn removeChildAtIndex(&self, index: NSUInteger);

        #[cfg(feature = "NSArray")]
        /// Removes all existing children and replaces them with the new children. Set children to nil to simply remove all children.
        #[unsafe(method(setChildren:))]
        #[unsafe(method_family = none)]
        pub fn setChildren(&self, children: Option<&NSArray<NSXMLNode>>);

        /// Adds a child to the end of the existing children.
        #[unsafe(method(addChild:))]
        #[unsafe(method_family = none)]
        pub fn addChild(&self, child: &NSXMLNode);

        /// Replaces a child at a particular index with another child.
        #[unsafe(method(replaceChildAtIndex:withNode:))]
        #[unsafe(method_family = none)]
        pub fn replaceChildAtIndex_withNode(&self, index: NSUInteger, node: &NSXMLNode);

        #[cfg(feature = "NSData")]
        /// Invokes XMLDataWithOptions with NSXMLNodeOptionsNone.
        #[unsafe(method(XMLData))]
        #[unsafe(method_family = none)]
        pub fn XMLData(&self) -> Retained<NSData>;

        #[cfg(all(feature = "NSData", feature = "NSXMLNodeOptions"))]
        /// The representation of this node as it would appear in an XML document, encoded based on characterEncoding.
        #[unsafe(method(XMLDataWithOptions:))]
        #[unsafe(method_family = none)]
        pub fn XMLDataWithOptions(&self, options: NSXMLNodeOptions) -> Retained<NSData>;

        #[cfg(all(
            feature = "NSData",
            feature = "NSDictionary",
            feature = "NSError",
            feature = "NSString"
        ))]
        /// Applies XSLT with arguments (NSString key/value pairs) to this document, returning a new document.
        #[unsafe(method(objectByApplyingXSLT:arguments:error:_))]
        #[unsafe(method_family = none)]
        pub fn objectByApplyingXSLT_arguments_error(
            &self,
            xslt: &NSData,
            arguments: Option<&NSDictionary<NSString, NSString>>,
        ) -> Result<Retained<AnyObject>, Retained<NSError>>;

        #[cfg(all(feature = "NSDictionary", feature = "NSError", feature = "NSString"))]
        /// Applies XSLT as expressed by a string with arguments (NSString key/value pairs) to this document, returning a new document.
        #[unsafe(method(objectByApplyingXSLTString:arguments:error:_))]
        #[unsafe(method_family = none)]
        pub fn objectByApplyingXSLTString_arguments_error(
            &self,
            xslt: &NSString,
            arguments: Option<&NSDictionary<NSString, NSString>>,
        ) -> Result<Retained<AnyObject>, Retained<NSError>>;

        #[cfg(all(
            feature = "NSDictionary",
            feature = "NSError",
            feature = "NSString",
            feature = "NSURL"
        ))]
        /// Applies the XSLT at a URL with arguments (NSString key/value pairs) to this document, returning a new document. Error may contain a connection error from the URL.
        #[unsafe(method(objectByApplyingXSLTAtURL:arguments:error:_))]
        #[unsafe(method_family = none)]
        pub fn objectByApplyingXSLTAtURL_arguments_error(
            &self,
            xslt_url: &NSURL,
            argument: Option<&NSDictionary<NSString, NSString>>,
        ) -> Result<Retained<AnyObject>, Retained<NSError>>;

        #[cfg(feature = "NSError")]
        #[unsafe(method(validateAndReturnError:_))]
        #[unsafe(method_family = none)]
        pub fn validateAndReturnError(&self) -> Result<(), Retained<NSError>>;
    );
}

/// Methods declared on superclass `NSXMLNode`.
#[cfg(feature = "NSXMLNode")]
impl NSXMLDocument {
    extern_methods!(
        /// Invokes
        ///
        /// ```text
        ///  initWithKind:options:
        /// ```
        ///
        /// with options set to NSXMLNodeOptionsNone
        #[unsafe(method(initWithKind:))]
        #[unsafe(method_family = init)]
        pub fn initWithKind(this: Allocated<Self>, kind: NSXMLNodeKind) -> Retained<Self>;

        #[cfg(feature = "NSXMLNodeOptions")]
        /// Inits a node with fidelity options as description NSXMLNodeOptions.h
        #[unsafe(method(initWithKind:options:))]
        #[unsafe(method_family = init)]
        pub fn initWithKind_options(
            this: Allocated<Self>,
            kind: NSXMLNodeKind,
            options: NSXMLNodeOptions,
        ) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(feature = "NSXMLNode")]
impl NSXMLDocument {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

#[cfg(feature = "NSXMLNode")]
impl DefaultRetained for NSXMLDocument {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}
