[38;2;117;113;94m//[0m[38;2;117;113;94m Copyright 2018 Schuyler Eldridge[0m
[38;2;117;113;94m//[0m
[38;2;117;113;94m//[0m[38;2;117;113;94m Licensed under the Apache License, Version 2.0 (the "License");[0m
[38;2;117;113;94m//[0m[38;2;117;113;94m you may not use this file except in compliance with the License.[0m
[38;2;117;113;94m//[0m[38;2;117;113;94m You may obtain a copy of the License at[0m
[38;2;117;113;94m//[0m
[38;2;117;113;94m//[0m[38;2;117;113;94m     http://www.apache.org/licenses/LICENSE-2.0[0m
[38;2;117;113;94m//[0m
[38;2;117;113;94m//[0m[38;2;117;113;94m Unless required by applicable law or agreed to in writing, software[0m
[38;2;117;113;94m//[0m[38;2;117;113;94m distributed under the License is distributed on an "AS IS" BASIS,[0m
[38;2;117;113;94m//[0m[38;2;117;113;94m WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.[0m
[38;2;117;113;94m//[0m[38;2;117;113;94m See the License for the specific language governing permissions and[0m
[38;2;117;113;94m//[0m[38;2;117;113;94m limitations under the License.[0m

[38;2;117;113;94m//[0m[38;2;117;113;94m Implements a fixed-point parameterized pipelined division[0m
[38;2;117;113;94m//[0m[38;2;117;113;94m operation. Outputs are expected to be on range [-1,1), techincally[0m
[38;2;117;113;94m//[0m[38;2;117;113;94m [-1,2^(BITS-1)-1/2^(BITS-1)]. There is no convergent rounding.[0m
[38;2;117;113;94m//[0m
[38;2;117;113;94m//[0m[38;2;117;113;94m [TODO] Implement optional convergent rounding and some form of[0m
[38;2;117;113;94m//[0m[38;2;117;113;94m variable output binary point placement. There are arguments in[0m
[38;2;117;113;94m//[0m[38;2;117;113;94m these changes that make sense (specifically, adding an additional[0m
[38;2;117;113;94m//[0m[38;2;117;113;94m bit results in a gain of one value when all the other 2^6 values[0m
[38;2;117;113;94m//[0m[38;2;117;113;94m greater than 1 aren't used). Other improvements that are needed: 1)[0m
[38;2;117;113;94m//[0m[38;2;117;113;94m quotient_gen is getting smaller by one bit in every stage, it would[0m
[38;2;117;113;94m//[0m[38;2;117;113;94m make more sense to generate this as such, 2) there's some weird[0m
[38;2;117;113;94m//[0m[38;2;117;113;94m initial behavior after rst_n is deasserted, you get weird output on[0m
[38;2;117;113;94m//[0m[38;2;117;113;94m the quotient line for a number of cycles.[0m
[38;2;117;113;94m//[0m
[38;2;117;113;94m//[0m[38;2;117;113;94m [TODO] This doesn't exactly behave as expected if you specify[0m
[38;2;117;113;94m//[0m[38;2;117;113;94m different BITS and STAGES parameters (which for a functional[0m
[38;2;117;113;94m//[0m[38;2;117;113;94m module, should be implemented). Note, that this technically works,[0m
[38;2;117;113;94m//[0m[38;2;117;113;94m but needs more investigation to fully understand its properties.[0m

[38;2;190;132;255m`timescale[0m[38;2;248;248;242m 1ns [0m[38;2;249;38;114m/[0m[38;2;248;248;242m 1ps[0m
[3;38;2;102;217;239mmodule[0m[38;2;248;248;242m [0m[38;2;166;226;46mdiv_pipelined[0m
[38;2;248;248;242m  [0m[38;2;249;38;114m([0m
[38;2;248;248;242m   [0m[3;38;2;166;226;46minput[0m[38;2;248;248;242m                 clk[0m[38;2;249;38;114m,[0m
[38;2;248;248;242m   [0m[3;38;2;166;226;46minput[0m[38;2;248;248;242m                 rst_n[0m[38;2;249;38;114m,[0m
[38;2;248;248;242m   [0m[3;38;2;166;226;46minput[0m[38;2;248;248;242m                 start[0m[38;2;249;38;114m,[0m
[38;2;248;248;242m   [0m[3;38;2;166;226;46minput[0m[38;2;248;248;242m [0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;190;132;255m0[0m[38;2;249;38;114m][0m[38;2;248;248;242m      dividend[0m[38;2;249;38;114m,[0m
[38;2;248;248;242m   [0m[3;38;2;166;226;46minput[0m[38;2;248;248;242m [0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;190;132;255m0[0m[38;2;249;38;114m][0m[38;2;248;248;242m      divisor[0m[38;2;249;38;114m,[0m
[38;2;248;248;242m   [0m[3;38;2;166;226;46moutput[0m[38;2;248;248;242m [0m[3;38;2;102;217;239mreg[0m[38;2;248;248;242m            data_valid[0m[38;2;249;38;114m,[0m
[38;2;248;248;242m   [0m[3;38;2;166;226;46moutput[0m[38;2;248;248;242m [0m[3;38;2;102;217;239mreg[0m[38;2;248;248;242m            div_by_zero[0m[38;2;249;38;114m,[0m
[38;2;248;248;242m   [0m[3;38;2;166;226;46moutput[0m[38;2;248;248;242m [0m[3;38;2;102;217;239mreg[0m[38;2;248;248;242m [0m[38;2;249;38;114m[[0m[38;2;248;248;242mSTAGES[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;190;132;255m0[0m[38;2;249;38;114m][0m[38;2;248;248;242m quotient[0m
[38;2;248;248;242m   [0m[38;2;117;113;94m//[0m[38;2;117;113;94m   output reg [7:0]      quotient_correct[0m
[38;2;248;248;242m   [0m[38;2;249;38;114m)[0m[38;2;249;38;114m;[0m

[38;2;248;248;242m  [0m[38;2;117;113;94m//[0m[38;2;117;113;94m WARNING!!! THESE PARAMETERS ARE INTENDED TO BE MODIFIED IN A TOP[0m
[38;2;248;248;242m  [0m[38;2;117;113;94m//[0m[38;2;117;113;94m LEVEL MODULE. LOCAL CHANGES HERE WILL, MOST LIKELY, BE[0m
[38;2;248;248;242m  [0m[38;2;117;113;94m//[0m[38;2;117;113;94m OVERWRITTEN![0m
[38;2;248;248;242m  [0m[3;38;2;102;217;239mparameter[0m
[38;2;248;248;242m    BITS  [0m[38;2;249;38;114m=[0m[38;2;248;248;242m [0m[38;2;190;132;255m8[0m[38;2;249;38;114m,[0m
[38;2;248;248;242m    STAGES  [0m[38;2;249;38;114m=[0m[38;2;248;248;242m BITS[0m[38;2;249;38;114m;[0m

[38;2;248;248;242m  [0m[38;2;117;113;94m//[0m[38;2;117;113;94m y = a/bQ[0m

[38;2;248;248;242m  [0m[3;38;2;102;217;239mreg[0m[38;2;248;248;242m [0m[38;2;249;38;114m[[0m[38;2;248;248;242mSTAGES[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;190;132;255m0[0m[38;2;249;38;114m][0m[38;2;248;248;242m       start_gen[0m[38;2;249;38;114m,[0m[38;2;248;248;242m negative_quotient_gen[0m[38;2;249;38;114m,[0m[38;2;248;248;242m div_by_zero_gen[0m[38;2;249;38;114m;[0m
[38;2;248;248;242m  [0m[3;38;2;102;217;239mreg[0m[38;2;248;248;242m [0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;249;38;114m([0m[38;2;248;248;242mSTAGES[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m)[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;190;132;255m0[0m[38;2;249;38;114m][0m[38;2;248;248;242m dividend_gen[0m[38;2;249;38;114m,[0m[38;2;248;248;242m divisor_gen[0m[38;2;249;38;114m,[0m[38;2;248;248;242m quotient_gen[0m[38;2;249;38;114m;[0m
[38;2;248;248;242m  [0m[3;38;2;102;217;239mwire[0m[38;2;248;248;242m [0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;190;132;255m0[0m[38;2;249;38;114m][0m[38;2;248;248;242m             pad_dividend[0m[38;2;249;38;114m;[0m
[38;2;248;248;242m  [0m[3;38;2;102;217;239mwire[0m[38;2;248;248;242m [0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m-[0m[38;2;190;132;255m2[0m[38;2;249;38;114m:[0m[38;2;190;132;255m0[0m[38;2;249;38;114m][0m[38;2;248;248;242m             pad_divisor[0m[38;2;249;38;114m;[0m

[38;2;248;248;242m  [0m[38;2;249;38;114massign[0m[38;2;248;248;242m pad_dividend  [0m[38;2;249;38;114m=[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;249;38;114m;[0m
[38;2;248;248;242m  [0m[38;2;249;38;114massign[0m[38;2;248;248;242m pad_divisor  [0m[38;2;249;38;114m=[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;249;38;114m;[0m

[38;2;248;248;242m  [0m[38;2;117;113;94m//[0m[38;2;117;113;94m sign conversion stage[0m
[38;2;248;248;242m  [0m[38;2;249;38;114malways[0m[38;2;248;248;242m [0m[38;2;249;38;114m@[0m[38;2;248;248;242m [0m[38;2;249;38;114m([0m[38;2;249;38;114mposedge[0m[38;2;248;248;242m clk [0m[3;38;2;166;226;46mor[0m[38;2;248;248;242m [0m[38;2;249;38;114mnegedge[0m[38;2;248;248;242m rst_n[0m[38;2;249;38;114m)[0m
[38;2;248;248;242m    [0m[38;2;249;38;114mbegin[0m
[38;2;248;248;242m      [0m[38;2;249;38;114mif[0m[38;2;248;248;242m [0m[38;2;249;38;114m([0m[38;2;249;38;114m![0m[38;2;248;248;242mrst_n[0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114mbegin[0m
[38;2;248;248;242m        div_by_zero_gen[0m[38;2;249;38;114m[[0m[38;2;190;132;255m0[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;249;38;114m;[0m
[38;2;248;248;242m        start_gen[0m[38;2;249;38;114m[[0m[38;2;190;132;255m0[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m[38;2;249;38;114m<=[0m[38;2;190;132;255m0[0m[38;2;249;38;114m;[0m
[38;2;248;248;242m        negative_quotient_gen[0m[38;2;249;38;114m[[0m[38;2;190;132;255m0[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;249;38;114m;[0m
[38;2;248;248;242m        dividend_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;190;132;255m0[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;249;38;114m;[0m
[38;2;248;248;242m        divisor_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;190;132;255m0[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;249;38;114m;[0m[38;2;248;248;242m [0m[38;2;249;38;114mend[0m
[38;2;248;248;242m      [0m[38;2;249;38;114melse[0m[38;2;248;248;242m [0m[38;2;249;38;114mbegin[0m
[38;2;248;248;242m        div_by_zero_gen[0m[38;2;249;38;114m[[0m[38;2;190;132;255m0[0m[38;2;249;38;114m][0m[38;2;248;248;242m       [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m [0m[38;2;249;38;114m([0m[38;2;248;248;242mdivisor [0m[38;2;249;38;114m==[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;249;38;114m)[0m[38;2;249;38;114m;[0m
[38;2;248;248;242m        start_gen[0m[38;2;249;38;114m[[0m[38;2;190;132;255m0[0m[38;2;249;38;114m][0m[38;2;248;248;242m             [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m start[0m[38;2;249;38;114m;[0m
[38;2;248;248;242m        negative_quotient_gen[0m[38;2;249;38;114m[[0m[38;2;190;132;255m0[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m dividend[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m[38;2;249;38;114m^[0m[38;2;248;248;242m divisor[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m][0m[38;2;249;38;114m;[0m
[38;2;248;248;242m        dividend_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;190;132;255m0[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m [0m[38;2;249;38;114m([0m[38;2;248;248;242mdividend[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m][0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114m?[0m[38;2;248;248;242m [0m[38;2;249;38;114m~[0m[38;2;249;38;114m{[0m[38;2;248;248;242mdividend[0m[38;2;249;38;114m,[0m[38;2;248;248;242mpad_dividend[0m[38;2;249;38;114m}[0m[38;2;248;248;242m [0m[38;2;249;38;114m+[0m[38;2;248;248;242m [0m[38;2;190;132;255m1[0m[38;2;248;248;242m [0m[38;2;249;38;114m:[0m[38;2;248;248;242m [0m[38;2;249;38;114m{[0m[38;2;248;248;242mdividend[0m[38;2;249;38;114m,[0m[38;2;248;248;242mpad_dividend[0m[38;2;249;38;114m}[0m[38;2;249;38;114m;[0m
[38;2;248;248;242m        divisor_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;190;132;255m0[0m[38;2;249;38;114m][0m[38;2;248;248;242m  [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m [0m[38;2;249;38;114m([0m[38;2;248;248;242mdivisor [0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m][0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114m?[0m[38;2;248;248;242m [0m[38;2;249;38;114m~[0m[38;2;249;38;114m{[0m[38;2;190;132;255m1'b1[0m[38;2;249;38;114m,[0m[38;2;248;248;242mdivisor[0m[38;2;249;38;114m,[0m[38;2;248;248;242m pad_divisor[0m[38;2;249;38;114m}[0m[38;2;248;248;242m [0m[38;2;249;38;114m+[0m[38;2;248;248;242m [0m[38;2;190;132;255m1[0m[38;2;248;248;242m [0m[38;2;249;38;114m:[0m[38;2;248;248;242m [0m[38;2;249;38;114m{[0m[38;2;190;132;255m1'b0[0m[38;2;249;38;114m,[0m[38;2;248;248;242mdivisor[0m[38;2;249;38;114m,[0m[38;2;248;248;242m pad_divisor[0m[38;2;249;38;114m}[0m[38;2;249;38;114m;[0m
[38;2;248;248;242m      [0m[38;2;249;38;114mend[0m
[38;2;248;248;242m    [0m[38;2;249;38;114mend[0m

[38;2;248;248;242m  [0m[38;2;117;113;94m//[0m[38;2;117;113;94m first computation stage[0m
[38;2;248;248;242m  [0m[38;2;249;38;114malways[0m[38;2;248;248;242m [0m[38;2;249;38;114m@[0m[38;2;248;248;242m [0m[38;2;249;38;114m([0m[38;2;249;38;114mposedge[0m[38;2;248;248;242m clk [0m[3;38;2;166;226;46mor[0m[38;2;248;248;242m [0m[38;2;249;38;114mnegedge[0m[38;2;248;248;242m rst_n[0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114mbegin[0m
[38;2;248;248;242m    [0m[38;2;249;38;114mif[0m[38;2;248;248;242m [0m[38;2;249;38;114m([0m[38;2;249;38;114m![0m[38;2;248;248;242mrst_n[0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114mbegin[0m
[38;2;248;248;242m      div_by_zero_gen[0m[38;2;249;38;114m[[0m[38;2;190;132;255m1[0m[38;2;249;38;114m][0m[38;2;248;248;242m              [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;249;38;114m;[0m
[38;2;248;248;242m      start_gen[0m[38;2;249;38;114m[[0m[38;2;190;132;255m1[0m[38;2;249;38;114m][0m[38;2;248;248;242m                    [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;249;38;114m;[0m
[38;2;248;248;242m      negative_quotient_gen[0m[38;2;249;38;114m[[0m[38;2;190;132;255m1[0m[38;2;249;38;114m][0m[38;2;248;248;242m        [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;249;38;114m;[0m
[38;2;248;248;242m      divisor_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m][0m[38;2;248;248;242m  [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;249;38;114m;[0m
[38;2;248;248;242m      quotient_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;190;132;255m0[0m[38;2;249;38;114m][0m[38;2;248;248;242m        [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;249;38;114m;[0m
[38;2;248;248;242m      dividend_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;249;38;114m;[0m
[38;2;248;248;242m    [0m[38;2;249;38;114mend[0m
[38;2;248;248;242m    [0m[38;2;249;38;114melse[0m[38;2;248;248;242m [0m[38;2;249;38;114mbegin[0m
[38;2;248;248;242m      div_by_zero_gen[0m[38;2;249;38;114m[[0m[38;2;190;132;255m1[0m[38;2;249;38;114m][0m[38;2;248;248;242m             [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m div_by_zero_gen[0m[38;2;249;38;114m[[0m[38;2;190;132;255m0[0m[38;2;249;38;114m][0m[38;2;249;38;114m;[0m
[38;2;248;248;242m      start_gen[0m[38;2;249;38;114m[[0m[38;2;190;132;255m1[0m[38;2;249;38;114m][0m[38;2;248;248;242m                   [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m start_gen[0m[38;2;249;38;114m[[0m[38;2;190;132;255m0[0m[38;2;249;38;114m][0m[38;2;249;38;114m;[0m
[38;2;248;248;242m      negative_quotient_gen[0m[38;2;249;38;114m[[0m[38;2;190;132;255m1[0m[38;2;249;38;114m][0m[38;2;248;248;242m       [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m negative_quotient_gen[0m[38;2;249;38;114m[[0m[38;2;190;132;255m0[0m[38;2;249;38;114m][0m[38;2;249;38;114m;[0m
[38;2;248;248;242m      divisor_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m divisor_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;190;132;255m0[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m[38;2;249;38;114m>[0m[38;2;249;38;114m>[0m[38;2;248;248;242m [0m[38;2;190;132;255m1[0m[38;2;249;38;114m;[0m
[38;2;248;248;242m      [0m[38;2;249;38;114mif[0m[38;2;248;248;242m [0m[38;2;249;38;114m([0m[38;2;248;248;242m dividend_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;190;132;255m0[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m[38;2;249;38;114m>=[0m[38;2;248;248;242m divisor_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;190;132;255m0[0m[38;2;249;38;114m][0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114mbegin[0m
[38;2;248;248;242m        quotient_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;190;132;255m0[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m [0m[38;2;190;132;255m1[0m[38;2;248;248;242m [0m[38;2;249;38;114m<[0m[38;2;249;38;114m<[0m[38;2;248;248;242m STAGES [0m[38;2;249;38;114m-[0m[38;2;248;248;242m [0m[38;2;190;132;255m2[0m[38;2;249;38;114m;[0m
[38;2;248;248;242m        dividend_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m dividend_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;190;132;255m0[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m[38;2;249;38;114m-[0m[38;2;248;248;242m divisor_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;190;132;255m0[0m[38;2;249;38;114m][0m[38;2;249;38;114m;[0m
[38;2;248;248;242m      [0m[38;2;249;38;114mend[0m
[38;2;248;248;242m      [0m[38;2;249;38;114melse[0m[38;2;248;248;242m [0m[38;2;249;38;114mbegin[0m
[38;2;248;248;242m        quotient_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;190;132;255m0[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;249;38;114m;[0m
[38;2;248;248;242m        dividend_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m dividend_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;190;132;255m0[0m[38;2;249;38;114m][0m[38;2;249;38;114m;[0m
[38;2;248;248;242m      [0m[38;2;249;38;114mend[0m
[38;2;248;248;242m    [0m[38;2;249;38;114mend[0m[38;2;248;248;242m [0m[38;2;117;113;94m//[0m[38;2;117;113;94m else: !if(!rst_n)[0m
[38;2;248;248;242m  [0m[38;2;249;38;114mend[0m[38;2;248;248;242m [0m[38;2;117;113;94m//[0m[38;2;117;113;94m always @ (posedge clk)[0m

[38;2;248;248;242m  [0m[38;2;249;38;114mgenerate[0m
[38;2;248;248;242m    [0m[38;2;249;38;114mgenvar[0m[38;2;248;248;242m            i[0m[38;2;249;38;114m;[0m
[38;2;248;248;242m    [0m[38;2;249;38;114mfor[0m[38;2;248;248;242m [0m[38;2;249;38;114m([0m[38;2;248;248;242mi [0m[38;2;249;38;114m=[0m[38;2;248;248;242m [0m[38;2;190;132;255m1[0m[38;2;249;38;114m;[0m[38;2;248;248;242m i [0m[38;2;249;38;114m<[0m[38;2;248;248;242m STAGES [0m[38;2;249;38;114m-[0m[38;2;248;248;242m [0m[38;2;190;132;255m2[0m[38;2;249;38;114m;[0m[38;2;248;248;242m i [0m[38;2;249;38;114m=[0m[38;2;248;248;242m i [0m[38;2;249;38;114m+[0m[38;2;248;248;242m [0m[38;2;190;132;255m1[0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114mbegin[0m[38;2;248;248;242m [0m[38;2;249;38;114m:[0m[38;2;248;248;242m pipeline[0m
[38;2;248;248;242m      [0m[38;2;249;38;114malways[0m[38;2;248;248;242m [0m[38;2;249;38;114m@[0m[38;2;248;248;242m [0m[38;2;249;38;114m([0m[38;2;249;38;114mposedge[0m[38;2;248;248;242m clk [0m[3;38;2;166;226;46mor[0m[38;2;248;248;242m [0m[38;2;249;38;114mnegedge[0m[38;2;248;248;242m rst_n[0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114mbegin[0m
[38;2;248;248;242m        [0m[38;2;249;38;114mif[0m[38;2;248;248;242m [0m[38;2;249;38;114m([0m[38;2;249;38;114m![0m[38;2;248;248;242mrst_n[0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114mbegin[0m
[38;2;248;248;242m          div_by_zero_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mi[0m[38;2;249;38;114m+[0m[38;2;190;132;255m1[0m[38;2;249;38;114m][0m[38;2;248;248;242m                     [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;249;38;114m;[0m
[38;2;248;248;242m          start_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mi[0m[38;2;249;38;114m+[0m[38;2;190;132;255m1[0m[38;2;249;38;114m][0m[38;2;248;248;242m                           [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;249;38;114m;[0m
[38;2;248;248;242m          negative_quotient_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mi[0m[38;2;249;38;114m+[0m[38;2;190;132;255m1[0m[38;2;249;38;114m][0m[38;2;248;248;242m               [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;249;38;114m;[0m
[38;2;248;248;242m          divisor_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;249;38;114m([0m[38;2;248;248;242mi[0m[38;2;249;38;114m+[0m[38;2;190;132;255m2[0m[38;2;249;38;114m)[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;249;38;114m([0m[38;2;248;248;242mi[0m[38;2;249;38;114m+[0m[38;2;190;132;255m1[0m[38;2;249;38;114m)[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;249;38;114m;[0m
[38;2;248;248;242m          quotient_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;249;38;114m([0m[38;2;248;248;242mi[0m[38;2;249;38;114m+[0m[38;2;190;132;255m1[0m[38;2;249;38;114m)[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;248;248;242mi[0m[38;2;249;38;114m][0m[38;2;248;248;242m     [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;249;38;114m;[0m
[38;2;248;248;242m          dividend_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;249;38;114m([0m[38;2;248;248;242mi[0m[38;2;249;38;114m+[0m[38;2;190;132;255m2[0m[38;2;249;38;114m)[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;249;38;114m([0m[38;2;248;248;242mi[0m[38;2;249;38;114m+[0m[38;2;190;132;255m1[0m[38;2;249;38;114m)[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;249;38;114m;[0m
[38;2;248;248;242m        [0m[38;2;249;38;114mend[0m
[38;2;248;248;242m        [0m[38;2;249;38;114melse[0m[38;2;248;248;242m [0m[38;2;249;38;114mbegin[0m
[38;2;248;248;242m          div_by_zero_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mi[0m[38;2;249;38;114m+[0m[38;2;190;132;255m1[0m[38;2;249;38;114m][0m[38;2;248;248;242m                     [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m div_by_zero_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mi[0m[38;2;249;38;114m][0m[38;2;249;38;114m;[0m
[38;2;248;248;242m          start_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mi[0m[38;2;249;38;114m+[0m[38;2;190;132;255m1[0m[38;2;249;38;114m][0m[38;2;248;248;242m                           [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m start_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mi[0m[38;2;249;38;114m][0m[38;2;249;38;114m;[0m
[38;2;248;248;242m          negative_quotient_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mi[0m[38;2;249;38;114m+[0m[38;2;190;132;255m1[0m[38;2;249;38;114m][0m[38;2;248;248;242m               [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m negative_quotient_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mi[0m[38;2;249;38;114m][0m[38;2;249;38;114m;[0m
[38;2;248;248;242m          divisor_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;249;38;114m([0m[38;2;248;248;242mi[0m[38;2;249;38;114m+[0m[38;2;190;132;255m2[0m[38;2;249;38;114m)[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;249;38;114m([0m[38;2;248;248;242mi[0m[38;2;249;38;114m+[0m[38;2;190;132;255m1[0m[38;2;249;38;114m)[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m divisor_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;249;38;114m([0m[38;2;248;248;242mi[0m[38;2;249;38;114m+[0m[38;2;190;132;255m1[0m[38;2;249;38;114m)[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;248;248;242mi[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m[38;2;249;38;114m>[0m[38;2;249;38;114m>[0m[38;2;248;248;242m [0m[38;2;190;132;255m1[0m[38;2;249;38;114m;[0m
[38;2;248;248;242m          [0m[38;2;249;38;114mif[0m[38;2;248;248;242m [0m[38;2;249;38;114m([0m[38;2;248;248;242mdividend_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;249;38;114m([0m[38;2;248;248;242mi[0m[38;2;249;38;114m+[0m[38;2;190;132;255m1[0m[38;2;249;38;114m)[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;248;248;242mi[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m[38;2;249;38;114m>=[0m[38;2;248;248;242m divisor_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;249;38;114m([0m[38;2;248;248;242mi[0m[38;2;249;38;114m+[0m[38;2;190;132;255m1[0m[38;2;249;38;114m)[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;248;248;242mi[0m[38;2;249;38;114m][0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114mbegin[0m
[38;2;248;248;242m            quotient_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;249;38;114m([0m[38;2;248;248;242mi[0m[38;2;249;38;114m+[0m[38;2;190;132;255m1[0m[38;2;249;38;114m)[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;248;248;242mi[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m quotient_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;248;248;242mi[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;249;38;114m([0m[38;2;248;248;242mi[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m)[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m[38;2;249;38;114m|[0m[38;2;248;248;242m [0m[38;2;249;38;114m([0m[38;2;190;132;255m1[0m[38;2;248;248;242m [0m[38;2;249;38;114m<[0m[38;2;249;38;114m<[0m[38;2;248;248;242m [0m[38;2;249;38;114m([0m[38;2;248;248;242mSTAGES[0m[38;2;249;38;114m-[0m[38;2;190;132;255m2[0m[38;2;249;38;114m-[0m[38;2;248;248;242mi[0m[38;2;249;38;114m)[0m[38;2;249;38;114m)[0m[38;2;249;38;114m;[0m
[38;2;248;248;242m            dividend_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;249;38;114m([0m[38;2;248;248;242mi[0m[38;2;249;38;114m+[0m[38;2;190;132;255m2[0m[38;2;249;38;114m)[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;249;38;114m([0m[38;2;248;248;242mi[0m[38;2;249;38;114m+[0m[38;2;190;132;255m1[0m[38;2;249;38;114m)[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m dividend_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;249;38;114m([0m[38;2;248;248;242mi[0m[38;2;249;38;114m+[0m[38;2;190;132;255m1[0m[38;2;249;38;114m)[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;248;248;242mi[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m[38;2;249;38;114m-[0m[38;2;248;248;242m divisor_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;249;38;114m([0m[38;2;248;248;242mi[0m[38;2;249;38;114m+[0m[38;2;190;132;255m1[0m[38;2;249;38;114m)[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;248;248;242mi[0m[38;2;249;38;114m][0m[38;2;249;38;114m;[0m
[38;2;248;248;242m          [0m[38;2;249;38;114mend[0m
[38;2;248;248;242m          [0m[38;2;249;38;114melse[0m[38;2;248;248;242m [0m[38;2;249;38;114mbegin[0m
[38;2;248;248;242m            quotient_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;249;38;114m([0m[38;2;248;248;242mi[0m[38;2;249;38;114m+[0m[38;2;190;132;255m1[0m[38;2;249;38;114m)[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;248;248;242mi[0m[38;2;249;38;114m][0m[38;2;248;248;242m     [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m quotient_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;248;248;242mi[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;249;38;114m([0m[38;2;248;248;242mi[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m)[0m[38;2;249;38;114m][0m[38;2;249;38;114m;[0m
[38;2;248;248;242m            dividend_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;249;38;114m([0m[38;2;248;248;242mi[0m[38;2;249;38;114m+[0m[38;2;190;132;255m2[0m[38;2;249;38;114m)[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;249;38;114m([0m[38;2;248;248;242mi[0m[38;2;249;38;114m+[0m[38;2;190;132;255m1[0m[38;2;249;38;114m)[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m dividend_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;249;38;114m([0m[38;2;248;248;242mi[0m[38;2;249;38;114m+[0m[38;2;190;132;255m1[0m[38;2;249;38;114m)[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;248;248;242mi[0m[38;2;249;38;114m][0m[38;2;249;38;114m;[0m
[38;2;248;248;242m          [0m[38;2;249;38;114mend[0m
[38;2;248;248;242m        [0m[38;2;249;38;114mend[0m[38;2;248;248;242m [0m[38;2;117;113;94m//[0m[38;2;117;113;94m else: !if(!rst_n)[0m
[38;2;248;248;242m      [0m[38;2;249;38;114mend[0m[38;2;248;248;242m [0m[38;2;117;113;94m//[0m[38;2;117;113;94m always @ (posedge clk or negedge rst_n)[0m
[38;2;248;248;242m    [0m[38;2;249;38;114mend[0m[38;2;248;248;242m [0m[38;2;117;113;94m//[0m[38;2;117;113;94m block: pipeline[0m
[38;2;248;248;242m  [0m[38;2;249;38;114mendgenerate[0m

[38;2;248;248;242m  [0m[38;2;117;113;94m//[0m[38;2;117;113;94m last computation stage[0m
[38;2;248;248;242m  [0m[38;2;249;38;114malways[0m[38;2;248;248;242m [0m[38;2;249;38;114m@[0m[38;2;248;248;242m [0m[38;2;249;38;114m([0m[38;2;249;38;114mposedge[0m[38;2;248;248;242m clk [0m[3;38;2;166;226;46mor[0m[38;2;248;248;242m [0m[38;2;249;38;114mnegedge[0m[38;2;248;248;242m rst_n[0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114mbegin[0m
[38;2;248;248;242m    [0m[38;2;249;38;114mif[0m[38;2;248;248;242m [0m[38;2;249;38;114m([0m[38;2;249;38;114m![0m[38;2;248;248;242mrst_n[0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114mbegin[0m
[38;2;248;248;242m      div_by_zero_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mSTAGES[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m][0m[38;2;248;248;242m                           [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;249;38;114m;[0m
[38;2;248;248;242m      start_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mSTAGES[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m][0m[38;2;248;248;242m                                 [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;249;38;114m;[0m
[38;2;248;248;242m      negative_quotient_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mSTAGES[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m][0m[38;2;248;248;242m                     [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;249;38;114m;[0m
[38;2;248;248;242m      quotient_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;249;38;114m([0m[38;2;248;248;242mSTAGES[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m)[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;249;38;114m([0m[38;2;248;248;242mSTAGES[0m[38;2;249;38;114m-[0m[38;2;190;132;255m2[0m[38;2;249;38;114m)[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;249;38;114m;[0m
[38;2;248;248;242m    [0m[38;2;249;38;114mend[0m
[38;2;248;248;242m    [0m[38;2;249;38;114melse[0m[38;2;248;248;242m [0m[38;2;249;38;114mbegin[0m
[38;2;248;248;242m      div_by_zero_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mSTAGES[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m][0m[38;2;248;248;242m       [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m div_by_zero_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mSTAGES[0m[38;2;249;38;114m-[0m[38;2;190;132;255m2[0m[38;2;249;38;114m][0m[38;2;249;38;114m;[0m
[38;2;248;248;242m      start_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mSTAGES[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m][0m[38;2;248;248;242m             [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m start_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mSTAGES[0m[38;2;249;38;114m-[0m[38;2;190;132;255m2[0m[38;2;249;38;114m][0m[38;2;249;38;114m;[0m
[38;2;248;248;242m      negative_quotient_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mSTAGES[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m negative_quotient_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mSTAGES[0m[38;2;249;38;114m-[0m[38;2;190;132;255m2[0m[38;2;249;38;114m][0m[38;2;249;38;114m;[0m
[38;2;248;248;242m      [0m[38;2;249;38;114mif[0m[38;2;248;248;242m [0m[38;2;249;38;114m([0m[38;2;248;248;242m dividend_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;249;38;114m([0m[38;2;248;248;242mSTAGES[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m)[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;249;38;114m([0m[38;2;248;248;242mSTAGES[0m[38;2;249;38;114m-[0m[38;2;190;132;255m2[0m[38;2;249;38;114m)[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m[38;2;249;38;114m>=[0m[38;2;248;248;242m divisor_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;249;38;114m([0m[38;2;248;248;242mSTAGES[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m)[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;249;38;114m([0m[38;2;248;248;242mSTAGES[0m[38;2;249;38;114m-[0m[38;2;190;132;255m2[0m[38;2;249;38;114m)[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m[38;2;249;38;114m)[0m
[38;2;248;248;242m        quotient_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;249;38;114m([0m[38;2;248;248;242mSTAGES[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m)[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;249;38;114m([0m[38;2;248;248;242mSTAGES[0m[38;2;249;38;114m-[0m[38;2;190;132;255m2[0m[38;2;249;38;114m)[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m quotient_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;249;38;114m([0m[38;2;248;248;242mSTAGES[0m[38;2;249;38;114m-[0m[38;2;190;132;255m2[0m[38;2;249;38;114m)[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;249;38;114m([0m[38;2;248;248;242mSTAGES[0m[38;2;249;38;114m-[0m[38;2;190;132;255m3[0m[38;2;249;38;114m)[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m[38;2;249;38;114m|[0m[38;2;248;248;242m [0m[38;2;190;132;255m1[0m[38;2;249;38;114m;[0m
[38;2;248;248;242m      [0m[38;2;249;38;114melse[0m
[38;2;248;248;242m        quotient_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;249;38;114m([0m[38;2;248;248;242mSTAGES[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m)[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;249;38;114m([0m[38;2;248;248;242mSTAGES[0m[38;2;249;38;114m-[0m[38;2;190;132;255m2[0m[38;2;249;38;114m)[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m quotient_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;249;38;114m([0m[38;2;248;248;242mSTAGES[0m[38;2;249;38;114m-[0m[38;2;190;132;255m2[0m[38;2;249;38;114m)[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;249;38;114m([0m[38;2;248;248;242mSTAGES[0m[38;2;249;38;114m-[0m[38;2;190;132;255m3[0m[38;2;249;38;114m)[0m[38;2;249;38;114m][0m[38;2;249;38;114m;[0m
[38;2;248;248;242m    [0m[38;2;249;38;114mend[0m[38;2;248;248;242m [0m[38;2;117;113;94m//[0m[38;2;117;113;94m else: !if(!rst_n)[0m
[38;2;248;248;242m  [0m[38;2;249;38;114mend[0m[38;2;248;248;242m [0m[38;2;117;113;94m//[0m[38;2;117;113;94m always @ (posedge clk)[0m

[38;2;248;248;242m  [0m[38;2;117;113;94m//[0m[38;2;117;113;94m sign conversion stage[0m
[38;2;248;248;242m  [0m[38;2;249;38;114malways[0m[38;2;248;248;242m [0m[38;2;249;38;114m@[0m[38;2;248;248;242m [0m[38;2;249;38;114m([0m[38;2;249;38;114mposedge[0m[38;2;248;248;242m clk [0m[3;38;2;166;226;46mor[0m[38;2;248;248;242m [0m[38;2;249;38;114mnegedge[0m[38;2;248;248;242m rst_n[0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114mbegin[0m
[38;2;248;248;242m    [0m[38;2;249;38;114mif[0m[38;2;248;248;242m [0m[38;2;249;38;114m([0m[38;2;249;38;114m![0m[38;2;248;248;242mrst_n[0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114mbegin[0m
[38;2;248;248;242m      div_by_zero [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;249;38;114m;[0m
[38;2;248;248;242m      data_valid  [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;249;38;114m;[0m
[38;2;248;248;242m      quotient    [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;249;38;114m;[0m
[38;2;248;248;242m    [0m[38;2;249;38;114mend[0m
[38;2;248;248;242m    [0m[38;2;249;38;114melse[0m[38;2;248;248;242m [0m[38;2;249;38;114mbegin[0m
[38;2;248;248;242m      div_by_zero [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m div_by_zero_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mSTAGES[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m][0m[38;2;249;38;114m;[0m
[38;2;248;248;242m      data_valid  [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m start_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mSTAGES[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m][0m[38;2;249;38;114m;[0m
[38;2;248;248;242m      quotient    [0m[38;2;249;38;114m<=[0m[38;2;248;248;242m [0m[38;2;249;38;114m([0m[38;2;248;248;242mnegative_quotient_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mSTAGES[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m][0m[38;2;249;38;114m)[0m[38;2;248;248;242m [0m[38;2;249;38;114m?[0m[38;2;248;248;242m [0m[38;2;249;38;114m~[0m[38;2;248;248;242mquotient_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;249;38;114m([0m[38;2;248;248;242mSTAGES[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m)[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;249;38;114m([0m[38;2;248;248;242mSTAGES[0m[38;2;249;38;114m-[0m[38;2;190;132;255m2[0m[38;2;249;38;114m)[0m[38;2;249;38;114m][0m[38;2;248;248;242m [0m[38;2;249;38;114m+[0m[38;2;248;248;242m [0m[38;2;190;132;255m1[0m[38;2;248;248;242m [0m[38;2;249;38;114m:[0m[38;2;248;248;242m quotient_gen[0m[38;2;249;38;114m[[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;249;38;114m([0m[38;2;248;248;242mSTAGES[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m)[0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m[38;2;249;38;114m:[0m[38;2;248;248;242mBITS[0m[38;2;249;38;114m*[0m[38;2;190;132;255m2[0m[38;2;249;38;114m*[0m[38;2;249;38;114m([0m[38;2;248;248;242mSTAGES[0m[38;2;249;38;114m-[0m[38;2;190;132;255m2[0m[38;2;249;38;114m)[0m[38;2;249;38;114m][0m[38;2;249;38;114m;[0m
[38;2;248;248;242m    [0m[38;2;249;38;114mend[0m
[38;2;248;248;242m  [0m[38;2;249;38;114mend[0m

[3;38;2;102;217;239mendmodule[0m
