/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.progress.UIJob;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.controls.ProgressLoaderVisualizer;

public class ProgressPainter {
    private final Control control;
    private PaintListener loadingListener;

    public ProgressPainter(final Control control) {
        this.control = control;
        this.loadingListener = new PaintListener(){
            int drawCount = 0;

            public void paintControl(PaintEvent e) {
                if (ProgressPainter.this.loadingListener == null) {
                    return;
                }
                ++this.drawCount;
                Image image = DBeaverIcons.getImage((DBPImage)ProgressLoaderVisualizer.PROGRESS_IMAGES[this.drawCount % ProgressLoaderVisualizer.PROGRESS_IMAGES.length]);
                Rectangle bounds = control.getBounds();
                Rectangle imageBounds = image.getBounds();
                e.gc.drawImage(image, bounds.x + bounds.width / 2 - imageBounds.width / 2, bounds.y + bounds.height / 2 - imageBounds.height - 5);
                new UIJob("Repaint"){
                    {
                        this.setSystem(true);
                    }

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (!control.isDisposed()) {
                            control.redraw();
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule(200L);
            }
        };
        control.addPaintListener(this.loadingListener);
    }

    public void close() {
        if (this.loadingListener != null) {
            if (!this.control.isDisposed()) {
                this.control.removePaintListener(this.loadingListener);
            }
            this.loadingListener = null;
        }
    }
}

