/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.managers.image;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.ui.IEditorPart;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.data.IStreamValueEditor;
import org.jkiss.dbeaver.ui.data.IStreamValueManager;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.managers.image.ImageEditorPart;
import org.jkiss.dbeaver.ui.data.managers.image.ImagePanelEditor;

public class ImageStreamValueManager
implements IStreamValueManager {
    private static final Log log = Log.getLog(ImageStreamValueManager.class);

    public IStreamValueManager.MatchType matchesTo(@NotNull DBRProgressMonitor monitor, @NotNull DBSTypedObject attribute, @Nullable DBDContent value) {
        ImageDetector imageDetector = new ImageDetector(value);
        if (!DBUtils.isNullValue((Object)value)) {
            try {
                imageDetector.run(monitor);
            }
            catch (Throwable e) {
                return IStreamValueManager.MatchType.NONE;
            }
        }
        return imageDetector.isImage() ? IStreamValueManager.MatchType.PRIMARY : IStreamValueManager.MatchType.NONE;
    }

    public IStreamValueEditor createPanelEditor(@NotNull IValueController controller) throws DBException {
        return new ImagePanelEditor();
    }

    public IEditorPart createEditorPart(@NotNull IValueController controller) {
        return new ImageEditorPart(controller);
    }

    private static class ImageDetector
    implements DBRRunnableWithProgress {
        private final DBDContent content;
        private boolean isImage;

        private ImageDetector(DBDContent content) {
            this.content = content;
        }

        public boolean isImage() {
            return this.isImage;
        }

        public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            block9: {
                if (!this.content.isNull()) {
                    try {
                        DBDContentStorage contents = this.content.getContents(monitor);
                        if (contents == null) break block9;
                        try (InputStream contentStream = contents.getContentStream();){
                            new ImageLoader().load(contentStream);
                        }
                        this.isImage = true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

