/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.hyperlink.MultipleHyperlinkPresenter;
import org.eclipse.jface.text.hyperlink.URLHyperlinkDetector;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceListener;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.parser.SQLParserPartitions;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLContentFormatter;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.addins.SQLEditorQuickAssistProcessor;
import org.jkiss.dbeaver.ui.editors.sql.addins.SQLEditorQuickFixProcessorsRegistry;
import org.jkiss.dbeaver.ui.editors.sql.indent.SQLAutoIndentStrategy;
import org.jkiss.dbeaver.ui.editors.sql.indent.SQLCommentAutoIndentStrategy;
import org.jkiss.dbeaver.ui.editors.sql.indent.SQLStringAutoIndentStrategy;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLCompletionProcessor;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLCompletionSorterUI;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLContentAssistant;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLContextInformer;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLDoubleClickStrategy;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLFormattingStrategy;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLHyperlinkDetector;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLInformationProvider;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLReconcilingStrategy;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLRuleScanner;
import org.jkiss.dbeaver.ui.editors.sql.util.SQLAnnotationHover;
import org.jkiss.utils.ArrayUtils;

public class SQLEditorSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    private static final Log log = Log.getLog(SQLEditorSourceViewerConfiguration.class);
    @Nullable
    private final SQLReconcilingStrategy reconcilingStrategy;
    private final SQLEditorBase editor;
    private final SQLRuleScanner ruleManager;
    private final SQLContextInformer contextInformer;
    private final IPreferenceStore preferenceStore;
    private IContentAssistProcessor completionProcessor;
    private SQLHyperlinkDetector hyperlinkDetector;

    public SQLEditorSourceViewerConfiguration(SQLEditorBase editor, IPreferenceStore preferenceStore) {
        this(editor, preferenceStore, new SQLReconcilingStrategy(editor));
    }

    public SQLEditorSourceViewerConfiguration(SQLEditorBase editor, IPreferenceStore preferenceStore, @Nullable SQLReconcilingStrategy reconcilingStrategy) {
        super(preferenceStore);
        this.editor = editor;
        this.preferenceStore = preferenceStore;
        this.ruleManager = editor.getRuleScanner();
        this.contextInformer = new SQLContextInformer(editor, editor.getSyntaxManager());
        this.hyperlinkDetector = new SQLHyperlinkDetector(this.contextInformer);
        this.reconcilingStrategy = reconcilingStrategy;
    }

    public IPreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    public SQLContextInformer getContextInformer() {
        return this.contextInformer;
    }

    public SQLHyperlinkDetector getHyperlinkDetector() {
        return this.hyperlinkDetector;
    }

    public IUndoManager getUndoManager(ISourceViewer sourceViewer) {
        return new TextViewerUndoManager(200);
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new SQLAnnotationHover(this.getSQLEditor());
    }

    @Nullable
    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if ("__dftl_partition_content_type".equals(contentType)) {
            return new IAutoEditStrategy[]{new SQLAutoIndentStrategy("___sql_partitioning", sourceViewer, this.editor.getSyntaxManager())};
        }
        if ("sql_comment".equals(contentType) || "sql_multiline_comment".equals(contentType)) {
            return new IAutoEditStrategy[]{new SQLCommentAutoIndentStrategy("___sql_partitioning")};
        }
        if ("sql_character".equals(contentType)) {
            return new IAutoEditStrategy[]{new SQLStringAutoIndentStrategy("sql_character")};
        }
        return new IAutoEditStrategy[0];
    }

    public IQuickAssistAssistant getQuickAssistAssistant(@NotNull ISourceViewer sourceViewer) {
        Object quickAssistAssistant = super.getQuickAssistAssistant(sourceViewer);
        if (quickAssistAssistant == null) {
            quickAssistAssistant = new QuickAssistAssistant(this){
                {
                    this.setRestoreCompletionProposalSize(EditorsPlugin.getDefault().getDialogSettingsSection("quick_assist_proposal_size"));
                    this.setInformationControlCreator(p -> new DefaultInformationControl(p, EditorsPlugin.getAdditionalInfoAffordanceString()));
                }
            };
        }
        SQLEditorQuickAssistProcessor quickAssistProcessor = new SQLEditorQuickAssistProcessor(this.editor);
        if (quickAssistAssistant.getQuickAssistProcessor() != null) {
            quickAssistProcessor.appendProcessor(quickAssistAssistant.getQuickAssistProcessor());
        }
        quickAssistProcessor.appendProcessors(SQLEditorQuickFixProcessorsRegistry.getInstance().getQuickFixProcessorDescriptors());
        quickAssistAssistant.setQuickAssistProcessor((IQuickAssistProcessor)quickAssistProcessor);
        return quickAssistAssistant;
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return "___sql_partitioning";
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        try {
            return this.createContentAssistant(sourceViewer);
        }
        catch (Throwable e) {
            log.error((Object)"Error creating content assistant", e);
            return null;
        }
    }

    @NotNull
    private SQLContentAssistant createContentAssistant(ISourceViewer sourceViewer) {
        DBPPreferenceStore store;
        DBPPreferenceStore configStore = store = this.editor.getActivePreferenceStore();
        SQLContentAssistant assistant = new SQLContentAssistant(this.editor);
        assistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        if (this.completionProcessor == null) {
            this.completionProcessor = new SQLCompletionProcessor(this.editor);
        }
        try {
            assistant.addContentAssistProcessor(this.completionProcessor, "__dftl_partition_content_type");
            assistant.addContentAssistProcessor(this.completionProcessor, "sql_quoted");
            assistant.addContentAssistProcessor(this.completionProcessor, "sql_character");
        }
        catch (Throwable e2) {
            assistant.setContentAssistProcessor(this.completionProcessor, "__dftl_partition_content_type");
        }
        this.configureContentAssistant(store, assistant);
        assistant.setSorter(new SQLCompletionSorterUI(this.editor));
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        Color foreground = new Color((Device)UIUtils.getDisplay(), 0, 0, 0);
        Color background = new Color((Device)UIUtils.getDisplay(), 255, 255, 255);
        assistant.setContextInformationPopupOrientation(20);
        assistant.setContextInformationPopupForeground(foreground);
        assistant.setContextInformationPopupBackground(background);
        assistant.enableAutoInsert(store.getBoolean("SQLEditor.ContentAssistant.insert.single.proposal"));
        assistant.setShowEmptyList(true);
        DBPPreferenceListener prefListener = event -> {
            switch (event.getProperty()) {
                case "SQLEditor.ContentAssistant.auto.activation.enable": {
                    assistant.enableAutoActivation(SQLEditorUtils.isSQLSyntaxParserApplied(this.editor.getEditorInput()) && configStore.getBoolean("SQLEditor.ContentAssistant.auto.activation.enable"));
                    break;
                }
                case "SQLEditor.ContentAssistant.auto.activation.delay": {
                    assistant.setAutoActivationDelay(configStore.getInt("SQLEditor.ContentAssistant.auto.activation.delay"));
                    break;
                }
                case "SQLEditor.ContentAssistant.insert.single.proposal": {
                    assistant.enableAutoInsert(configStore.getBoolean("SQLEditor.ContentAssistant.insert.single.proposal"));
                }
            }
        };
        ((SQLCompletionProcessor)this.completionProcessor).initAssistant(assistant);
        configStore.addPropertyChangeListener(prefListener);
        this.editor.getTextViewer().getControl().addDisposeListener(e -> configStore.removePropertyChangeListener(prefListener));
        return assistant;
    }

    private void configureContentAssistant(DBPPreferenceStore store, SQLContentAssistant assistant) {
        assistant.enableAutoActivation(store.getBoolean("SQLEditor.ContentAssistant.auto.activation.enable"));
        assistant.setAutoActivationDelay(store.getInt("SQLEditor.ContentAssistant.auto.activation.delay"));
        assistant.setProposalPopupOrientation(10);
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return parent -> new DefaultInformationControl(parent, false);
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        SQLContentFormatter formatter = new SQLContentFormatter(this.editor);
        formatter.setDocumentPartitioning("___sql_partitioning");
        formatter.enablePartitionAwareFormatting(true);
        SQLFormattingStrategy formattingStrategy = new SQLFormattingStrategy(sourceViewer, this, this.editor.getSyntaxManager());
        for (String ct : SQLParserPartitions.SQL_CONTENT_TYPES) {
            formatter.setFormattingStrategy((IFormattingStrategy)formattingStrategy, ct);
        }
        return formatter;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        return new SQLDoubleClickStrategy();
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        String docPartitioning = this.getConfiguredDocumentPartitioning(sourceViewer);
        reconciler.setDocumentPartitioning(docPartitioning);
        this.addContentTypeDamageRepairer(reconciler, "__dftl_partition_content_type");
        this.addContentTypeDamageRepairer(reconciler, "sql_multiline_comment", "org.jkiss.dbeaver.sql.editor.color.comment.foreground");
        this.addContentTypeDamageRepairer(reconciler, "sql_comment", "org.jkiss.dbeaver.sql.editor.color.comment.foreground");
        SQLEditorBase sqlEditor = this.getSQLEditor();
        if (SQLEditorUtils.isSQLSyntaxParserApplied(sqlEditor.getEditorInput())) {
            this.addContentTypeDamageRepairer(reconciler, "sql_character");
            if (sqlEditor.isAdvancedHighlightingEnabled()) {
                this.addContentTypeDamageRepairer(reconciler, "sql_quoted");
            } else {
                this.addContentTypeDamageRepairer(reconciler, "sql_quoted", "org.jkiss.dbeaver.sql.editor.color.datatype.foreground");
            }
        } else {
            this.addContentTypeDamageRepairer(reconciler, "sql_character", "org.jkiss.dbeaver.sql.editor.color.string.foreground");
            this.addContentTypeDamageRepairer(reconciler, "sql_quoted", "org.jkiss.dbeaver.sql.editor.color.datatype.foreground");
        }
        this.addContentTypeDamageRepairer(reconciler, "sql_command");
        return reconciler;
    }

    private void addContentTypeDamageRepairer(@NotNull PresentationReconciler reconciler, @NotNull String contentType) {
        this.addContentTypeDamageRepairer(reconciler, contentType, (ITokenScanner)this.ruleManager);
    }

    private void addContentTypeDamageRepairer(@NotNull PresentationReconciler reconciler, @NotNull String contentType, @NotNull String colorId) {
        Color color = this.ruleManager.getColor(colorId);
        if (UIStyles.isDarkHighContrastTheme()) {
            color = UIStyles.getInvertedColor((Color)color);
        }
        this.addContentTypeDamageRepairer(reconciler, contentType, (ITokenScanner)new SingleTokenScanner(new TextAttribute(color)));
    }

    private void addContentTypeDamageRepairer(@NotNull PresentationReconciler reconciler, @NotNull String contentType, @NotNull ITokenScanner scanner) {
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer(scanner);
        reconciler.setDamager((IPresentationDamager)dr, contentType);
        reconciler.setRepairer((IPresentationRepairer)dr, contentType);
    }

    public SQLEditorBase getSQLEditor() {
        return this.editor;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new SQLAnnotationHover(this.getSQLEditor());
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return SQLParserPartitions.SQL_CONTENT_TYPES;
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        SQLDialect dialect = this.editor.getSQLDialect();
        return (String[])ArrayUtils.add(String.class, (Object[])dialect.getSingleLineComments(), (Object)"");
    }

    public IInformationPresenter getInformationPresenter(ISourceViewer sourceViewer) {
        String[] contentTypes;
        InformationPresenter presenter = new InformationPresenter(this.getInformationControlCreator(sourceViewer));
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        SQLInformationProvider provider = new SQLInformationProvider(this.getSQLEditor(), this.contextInformer);
        for (String contentType : contentTypes = this.getConfiguredContentTypes(sourceViewer)) {
            presenter.setInformationProvider((IInformationProvider)provider, contentType);
        }
        presenter.setSizeConstraints(60, 10, true, true);
        return presenter;
    }

    public IHyperlinkPresenter getHyperlinkPresenter(ISourceViewer sourceViewer) {
        return new MultipleHyperlinkPresenter(this, this.editor.getViewerConfiguration().getPreferenceStore()){};
    }

    @Nullable
    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        if (sourceViewer == null) {
            return null;
        }
        return new IHyperlinkDetector[]{this.hyperlinkDetector, new URLHyperlinkDetector()};
    }

    void onDataSourceChange() {
        this.contextInformer.refresh(this.editor.getSyntaxManager());
        this.hyperlinkDetector.dispose();
        if (this.reconcilingStrategy != null) {
            this.reconcilingStrategy.onDataSourceChange();
        }
    }

    void saveFoldingState() {
        if (this.reconcilingStrategy != null) {
            this.reconcilingStrategy.saveState();
        }
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (this.reconcilingStrategy == null) {
            return null;
        }
        return new MonoReconciler((IReconcilingStrategy)this.reconcilingStrategy, true);
    }

    static class SingleTokenScanner
    extends BufferedRuleBasedScanner {
        public SingleTokenScanner(TextAttribute attribute) {
            this.setDefaultReturnToken((IToken)new Token((Object)attribute));
        }
    }
}

