/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateImpl;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.chrono.ChronoZonedDateTimeImpl;
import java.time.chrono.Chronology;
import java.time.chrono.Ser;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.ValueRange;
import java.util.Objects;

final class ChronoLocalDateTimeImpl<D extends ChronoLocalDate>
implements ChronoLocalDateTime<D>,
Temporal,
TemporalAdjuster,
Serializable {
    private static final long serialVersionUID = 4556003607393004514L;
    static final int HOURS_PER_DAY = 24;
    static final int MINUTES_PER_HOUR = 60;
    static final int MINUTES_PER_DAY = 1440;
    static final int SECONDS_PER_MINUTE = 60;
    static final int SECONDS_PER_HOUR = 3600;
    static final int SECONDS_PER_DAY = 86400;
    static final long MILLIS_PER_DAY = 86400000L;
    static final long MICROS_PER_DAY = 86400000000L;
    static final long NANOS_PER_SECOND = 1000000000L;
    static final long NANOS_PER_MINUTE = 60000000000L;
    static final long NANOS_PER_HOUR = 3600000000000L;
    static final long NANOS_PER_DAY = 86400000000000L;
    private final transient D date;
    private final transient LocalTime time;

    static <R extends ChronoLocalDate> ChronoLocalDateTimeImpl<R> of(R r, LocalTime localTime) {
        return new ChronoLocalDateTimeImpl<R>(r, localTime);
    }

    static <R extends ChronoLocalDate> ChronoLocalDateTimeImpl<R> ensureValid(Chronology chronology, Temporal temporal) {
        ChronoLocalDateTimeImpl chronoLocalDateTimeImpl = (ChronoLocalDateTimeImpl)temporal;
        if (!chronology.equals(chronoLocalDateTimeImpl.getChronology())) {
            throw new ClassCastException("Chronology mismatch, required: " + chronology.getId() + ", actual: " + chronoLocalDateTimeImpl.getChronology().getId());
        }
        return chronoLocalDateTimeImpl;
    }

    private ChronoLocalDateTimeImpl(D d, LocalTime localTime) {
        Objects.requireNonNull(d, "date");
        Objects.requireNonNull(localTime, "time");
        this.date = d;
        this.time = localTime;
    }

    private ChronoLocalDateTimeImpl<D> with(Temporal temporal, LocalTime localTime) {
        if (this.date == temporal && this.time == localTime) {
            return this;
        }
        Object d = ChronoLocalDateImpl.ensureValid(this.date.getChronology(), temporal);
        return new ChronoLocalDateTimeImpl(d, localTime);
    }

    @Override
    public D toLocalDate() {
        return this.date;
    }

    @Override
    public LocalTime toLocalTime() {
        return this.time;
    }

    @Override
    public boolean isSupported(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)temporalField;
            return chronoField.isDateBased() || chronoField.isTimeBased();
        }
        return temporalField != null && temporalField.isSupportedBy(this);
    }

    @Override
    public ValueRange range(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)temporalField;
            return chronoField.isTimeBased() ? this.time.range(temporalField) : this.date.range(temporalField);
        }
        return temporalField.rangeRefinedBy(this);
    }

    @Override
    public int get(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)temporalField;
            return chronoField.isTimeBased() ? this.time.get(temporalField) : this.date.get(temporalField);
        }
        return this.range(temporalField).checkValidIntValue(this.getLong(temporalField), temporalField);
    }

    @Override
    public long getLong(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)temporalField;
            return chronoField.isTimeBased() ? this.time.getLong(temporalField) : this.date.getLong(temporalField);
        }
        return temporalField.getFrom(this);
    }

    @Override
    public ChronoLocalDateTimeImpl<D> with(TemporalAdjuster temporalAdjuster) {
        if (temporalAdjuster instanceof ChronoLocalDate) {
            return this.with((ChronoLocalDate)temporalAdjuster, this.time);
        }
        if (temporalAdjuster instanceof LocalTime) {
            return this.with((Temporal)this.date, (LocalTime)temporalAdjuster);
        }
        if (temporalAdjuster instanceof ChronoLocalDateTimeImpl) {
            return ChronoLocalDateTimeImpl.ensureValid(this.date.getChronology(), (ChronoLocalDateTimeImpl)temporalAdjuster);
        }
        return ChronoLocalDateTimeImpl.ensureValid(this.date.getChronology(), (ChronoLocalDateTimeImpl)temporalAdjuster.adjustInto(this));
    }

    @Override
    public ChronoLocalDateTimeImpl<D> with(TemporalField temporalField, long l) {
        if (temporalField instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)temporalField;
            if (chronoField.isTimeBased()) {
                return this.with((Temporal)this.date, this.time.with(temporalField, l));
            }
            return this.with(this.date.with(temporalField, l), this.time);
        }
        return ChronoLocalDateTimeImpl.ensureValid(this.date.getChronology(), temporalField.adjustInto(this, l));
    }

    @Override
    public ChronoLocalDateTimeImpl<D> plus(long l, TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            ChronoUnit chronoUnit = (ChronoUnit)temporalUnit;
            switch (chronoUnit) {
                case NANOS: {
                    return this.plusNanos(l);
                }
                case MICROS: {
                    return super.plusNanos(l % 86400000000L * 1000L);
                }
                case MILLIS: {
                    return super.plusNanos(l % 86400000L * 1000000L);
                }
                case SECONDS: {
                    return this.plusSeconds(l);
                }
                case MINUTES: {
                    return this.plusMinutes(l);
                }
                case HOURS: {
                    return this.plusHours(l);
                }
                case HALF_DAYS: {
                    return super.plusHours(l % 256L * 12L);
                }
            }
            return this.with(this.date.plus(l, temporalUnit), this.time);
        }
        return ChronoLocalDateTimeImpl.ensureValid(this.date.getChronology(), temporalUnit.addTo(this, l));
    }

    private ChronoLocalDateTimeImpl<D> plusDays(long l) {
        return this.with(this.date.plus(l, ChronoUnit.DAYS), this.time);
    }

    private ChronoLocalDateTimeImpl<D> plusHours(long l) {
        return this.plusWithOverflow(this.date, l, 0L, 0L, 0L);
    }

    private ChronoLocalDateTimeImpl<D> plusMinutes(long l) {
        return this.plusWithOverflow(this.date, 0L, l, 0L, 0L);
    }

    ChronoLocalDateTimeImpl<D> plusSeconds(long l) {
        return this.plusWithOverflow(this.date, 0L, 0L, l, 0L);
    }

    private ChronoLocalDateTimeImpl<D> plusNanos(long l) {
        return this.plusWithOverflow(this.date, 0L, 0L, 0L, l);
    }

    private ChronoLocalDateTimeImpl<D> plusWithOverflow(D d, long l, long l2, long l3, long l4) {
        if ((l | l2 | l3 | l4) == 0L) {
            return this.with((Temporal)d, this.time);
        }
        long l5 = l4 / 86400000000000L + l3 / 86400L + l2 / 1440L + l / 24L;
        long l6 = l4 % 86400000000000L + l3 % 86400L * 1000000000L + l2 % 1440L * 60000000000L + l % 24L * 3600000000000L;
        long l7 = this.time.toNanoOfDay();
        long l8 = Math.floorMod(l6, 86400000000000L);
        LocalTime localTime = l8 == l7 ? this.time : LocalTime.ofNanoOfDay(l8);
        return this.with(d.plus(l5 += Math.floorDiv(l6 += l7, 86400000000000L), ChronoUnit.DAYS), localTime);
    }

    @Override
    public ChronoZonedDateTime<D> atZone(ZoneId zoneId) {
        return ChronoZonedDateTimeImpl.ofBest(this, zoneId, null);
    }

    @Override
    public long until(Temporal temporal, TemporalUnit temporalUnit) {
        Objects.requireNonNull(temporal, "endExclusive");
        ChronoLocalDateTime<? extends ChronoLocalDate> chronoLocalDateTime = this.getChronology().localDateTime(temporal);
        if (temporalUnit instanceof ChronoUnit) {
            if (temporalUnit.isTimeBased()) {
                long l = chronoLocalDateTime.getLong(ChronoField.EPOCH_DAY) - this.date.getLong(ChronoField.EPOCH_DAY);
                switch ((ChronoUnit)temporalUnit) {
                    case NANOS: {
                        l = Math.multiplyExact(l, 86400000000000L);
                        break;
                    }
                    case MICROS: {
                        l = Math.multiplyExact(l, 86400000000L);
                        break;
                    }
                    case MILLIS: {
                        l = Math.multiplyExact(l, 86400000L);
                        break;
                    }
                    case SECONDS: {
                        l = Math.multiplyExact(l, 86400L);
                        break;
                    }
                    case MINUTES: {
                        l = Math.multiplyExact(l, 1440L);
                        break;
                    }
                    case HOURS: {
                        l = Math.multiplyExact(l, 24L);
                        break;
                    }
                    case HALF_DAYS: {
                        l = Math.multiplyExact(l, 2L);
                    }
                }
                return Math.addExact(l, this.time.until(chronoLocalDateTime.toLocalTime(), temporalUnit));
            }
            ChronoLocalDate chronoLocalDate = chronoLocalDateTime.toLocalDate();
            if (chronoLocalDateTime.toLocalTime().isBefore(this.time)) {
                chronoLocalDate = chronoLocalDate.minus(1L, ChronoUnit.DAYS);
            }
            return this.date.until(chronoLocalDate, temporalUnit);
        }
        Objects.requireNonNull(temporalUnit, "unit");
        return temporalUnit.between(this, chronoLocalDateTime);
    }

    private Object writeReplace() {
        return new Ser(2, this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.date);
        objectOutput.writeObject(this.time);
    }

    static ChronoLocalDateTime<?> readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        ChronoLocalDate chronoLocalDate = (ChronoLocalDate)objectInput.readObject();
        LocalTime localTime = (LocalTime)objectInput.readObject();
        return chronoLocalDate.atTime(localTime);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ChronoLocalDateTime) {
            return this.compareTo((ChronoLocalDateTime)object) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.toLocalDate().hashCode() ^ this.toLocalTime().hashCode();
    }

    @Override
    public String toString() {
        return this.toLocalDate().toString() + 'T' + this.toLocalTime().toString();
    }
}

