/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.classfile;

import org.mozilla.classfile.ConstantPool;
import org.mozilla.classfile.TypeInfo;

final class SuperBlock {
    private int index;
    private int start;
    private int end;
    private int[] locals;
    private int[] stack;
    private boolean isInitialized;
    private boolean isInQueue;

    SuperBlock(int n, int n2, int n3, int[] nArray) {
        this.index = n;
        this.start = n2;
        this.end = n3;
        this.locals = new int[nArray.length];
        System.arraycopy(nArray, 0, this.locals, 0, nArray.length);
        this.stack = new int[0];
        this.isInitialized = false;
        this.isInQueue = false;
    }

    int getIndex() {
        return this.index;
    }

    int[] getLocals() {
        int[] nArray = new int[this.locals.length];
        System.arraycopy(this.locals, 0, nArray, 0, this.locals.length);
        return nArray;
    }

    int[] getTrimmedLocals() {
        int n;
        for (n = this.locals.length - 1; n >= 0 && this.locals[n] == 0 && !TypeInfo.isTwoWords(this.locals[n - 1]); --n) {
        }
        int n2 = ++n;
        for (int i = 0; i < n; ++i) {
            if (!TypeInfo.isTwoWords(this.locals[i])) continue;
            --n2;
        }
        int[] nArray = new int[n2];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            nArray[n3] = this.locals[n4];
            if (TypeInfo.isTwoWords(this.locals[n4])) {
                ++n4;
            }
            ++n3;
            ++n4;
        }
        return nArray;
    }

    int[] getStack() {
        int[] nArray = new int[this.stack.length];
        System.arraycopy(this.stack, 0, nArray, 0, this.stack.length);
        return nArray;
    }

    boolean merge(int[] nArray, int n, int[] nArray2, int n2, ConstantPool constantPool) {
        if (!this.isInitialized) {
            System.arraycopy(nArray, 0, this.locals, 0, n);
            this.stack = new int[n2];
            System.arraycopy(nArray2, 0, this.stack, 0, n2);
            this.isInitialized = true;
            return true;
        }
        if (this.locals.length == n && this.stack.length == n2) {
            boolean bl = this.mergeState(this.locals, nArray, n, constantPool);
            boolean bl2 = this.mergeState(this.stack, nArray2, n2, constantPool);
            return bl || bl2;
        }
        throw new IllegalArgumentException("bad merge attempt");
    }

    private boolean mergeState(int[] nArray, int[] nArray2, int n, ConstantPool constantPool) {
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            nArray[i] = TypeInfo.merge(nArray[i], nArray2[i], constantPool);
            if (n2 == nArray[i]) continue;
            bl = true;
        }
        return bl;
    }

    int getStart() {
        return this.start;
    }

    int getEnd() {
        return this.end;
    }

    public String toString() {
        return "sb " + this.index;
    }

    boolean isInitialized() {
        return this.isInitialized;
    }

    void setInitialized(boolean bl) {
        this.isInitialized = bl;
    }

    boolean isInQueue() {
        return this.isInQueue;
    }

    void setInQueue(boolean bl) {
        this.isInQueue = bl;
    }
}

