/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.ConsString;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.DefiningClassLoader;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.xml.XMLLib;

public class ContextFactory {
    private static volatile boolean hasCustomGlobal;
    private static ContextFactory global;
    private volatile boolean sealed;
    private final Object listenersLock = new Object();
    private volatile Object listeners;
    private boolean disabledListening;
    private ClassLoader applicationClassLoader;

    public static ContextFactory getGlobal() {
        return global;
    }

    public static boolean hasExplicitGlobal() {
        return hasCustomGlobal;
    }

    public static synchronized void initGlobal(ContextFactory contextFactory) {
        if (contextFactory == global) {
            return;
        }
        if (contextFactory == null) {
            throw new IllegalArgumentException();
        }
        if (hasCustomGlobal) {
            throw new IllegalStateException();
        }
        hasCustomGlobal = true;
        global = contextFactory;
    }

    public static synchronized GlobalSetter getGlobalSetter() {
        if (hasCustomGlobal) {
            throw new IllegalStateException();
        }
        hasCustomGlobal = true;
        class GlobalSetterImpl
        implements GlobalSetter {
            GlobalSetterImpl() {
            }

            @Override
            public void setContextFactoryGlobal(ContextFactory contextFactory) {
                global = contextFactory == null ? new ContextFactory() : contextFactory;
            }

            @Override
            public ContextFactory getContextFactoryGlobal() {
                return global;
            }
        }
        return new GlobalSetterImpl();
    }

    protected Context makeContext() {
        return new Context(this);
    }

    protected boolean hasFeature(Context context, int n) {
        switch (n) {
            case 1: {
                int n2 = context.getLanguageVersion();
                return n2 == 100 || n2 == 110 || n2 == 120;
            }
            case 2: {
                return false;
            }
            case 3: {
                return true;
            }
            case 4: {
                int n3 = context.getLanguageVersion();
                return n3 == 120;
            }
            case 5: {
                return true;
            }
            case 6: {
                int n4 = context.getLanguageVersion();
                return n4 == 0 || n4 >= 160;
            }
            case 7: {
                return false;
            }
            case 8: {
                return false;
            }
            case 9: {
                return false;
            }
            case 10: {
                return false;
            }
            case 11: {
                return false;
            }
            case 12: {
                return false;
            }
            case 13: {
                return false;
            }
            case 14: {
                return true;
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    private boolean isDom3Present() {
        Class<?> clazz = Kit.classOrNull("org.w3c.dom.Node");
        if (clazz == null) {
            return false;
        }
        try {
            clazz.getMethod("getUserData", String.class);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    protected XMLLib.Factory getE4xImplementationFactory() {
        if (this.isDom3Present()) {
            return XMLLib.Factory.create("org.mozilla.javascript.xmlimpl.XMLLibImpl");
        }
        return null;
    }

    protected GeneratedClassLoader createClassLoader(final ClassLoader classLoader) {
        return AccessController.doPrivileged(new PrivilegedAction<DefiningClassLoader>(){

            @Override
            public DefiningClassLoader run() {
                return new DefiningClassLoader(classLoader);
            }
        });
    }

    public final ClassLoader getApplicationClassLoader() {
        return this.applicationClassLoader;
    }

    public final void initApplicationClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException("loader is null");
        }
        if (!Kit.testIfCanLoadRhinoClasses(classLoader)) {
            throw new IllegalArgumentException("Loader can not resolve Rhino classes");
        }
        if (this.applicationClassLoader != null) {
            throw new IllegalStateException("applicationClassLoader can only be set once");
        }
        this.checkNotSealed();
        this.applicationClassLoader = classLoader;
    }

    protected Object doTopCall(Callable callable, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Object object = callable.call(context, scriptable, scriptable2, objectArray);
        return object instanceof ConsString ? object.toString() : object;
    }

    protected void observeInstructionCount(Context context, int n) {
    }

    protected void onContextCreated(Context context) {
        Listener listener;
        Object object = this.listeners;
        int n = 0;
        while ((listener = (Listener)Kit.getListener(object, n)) != null) {
            listener.contextCreated(context);
            ++n;
        }
    }

    protected void onContextReleased(Context context) {
        Listener listener;
        Object object = this.listeners;
        int n = 0;
        while ((listener = (Listener)Kit.getListener(object, n)) != null) {
            listener.contextReleased(context);
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addListener(Listener listener) {
        this.checkNotSealed();
        Object object = this.listenersLock;
        synchronized (object) {
            if (this.disabledListening) {
                throw new IllegalStateException();
            }
            this.listeners = Kit.addListener(this.listeners, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeListener(Listener listener) {
        this.checkNotSealed();
        Object object = this.listenersLock;
        synchronized (object) {
            if (this.disabledListening) {
                throw new IllegalStateException();
            }
            this.listeners = Kit.removeListener(this.listeners, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void disableContextListening() {
        this.checkNotSealed();
        Object object = this.listenersLock;
        synchronized (object) {
            this.disabledListening = true;
            this.listeners = null;
        }
    }

    public final boolean isSealed() {
        return this.sealed;
    }

    public final void seal() {
        this.checkNotSealed();
        this.sealed = true;
    }

    protected final void checkNotSealed() {
        if (this.sealed) {
            throw new IllegalStateException();
        }
    }

    public final Object call(ContextAction contextAction) {
        return Context.call(this, contextAction);
    }

    public Context enterContext() {
        return this.enterContext(null);
    }

    @Deprecated
    public final Context enter() {
        return this.enterContext(null);
    }

    @Deprecated
    public final void exit() {
        Context.exit();
    }

    public final Context enterContext(Context context) {
        return Context.enter(context, this);
    }

    static {
        global = new ContextFactory();
    }

    public static interface GlobalSetter {
        public void setContextFactoryGlobal(ContextFactory var1);

        public ContextFactory getContextFactoryGlobal();
    }

    public static interface Listener {
        public void contextCreated(Context var1);

        public void contextReleased(Context var1);
    }
}

