/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.curve.tess;

import com.jogamp.graph.geom.Triangle;
import com.jogamp.graph.geom.Vertex;
import com.jogamp.opengl.math.VectorUtil;
import com.jogamp.opengl.math.geom.AABBox;
import java.util.ArrayList;
import jogamp.graph.curve.tess.GraphOutline;
import jogamp.graph.curve.tess.GraphVertex;
import jogamp.graph.curve.tess.HEdge;

public class Loop {
    private HEdge root = null;
    private AABBox box = new AABBox();
    private GraphOutline initialOutline = null;

    public Loop(GraphOutline graphOutline, VectorUtil.Winding winding) {
        this.initialOutline = graphOutline;
        this.root = this.initFromPolyline(this.initialOutline, winding);
    }

    public HEdge getHEdge() {
        return this.root;
    }

    public Triangle cut(boolean bl) {
        if (this.isSimplex()) {
            Triangle triangle = new Triangle(this.root.getGraphPoint().getPoint(), this.root.getNext().getGraphPoint().getPoint(), this.root.getNext().getNext().getGraphPoint().getPoint());
            triangle.setVerticesBoundary(this.checkVerticesBoundary(this.root));
            return triangle;
        }
        HEdge hEdge = this.root.getPrev();
        HEdge hEdge2 = this.root.getNext();
        HEdge hEdge3 = this.findClosestValidNeighbor(hEdge2.getNext(), bl);
        if (hEdge3 == null) {
            this.root = this.root.getNext();
            return null;
        }
        GraphVertex graphVertex = this.root.getGraphPoint();
        GraphVertex graphVertex2 = hEdge2.getGraphPoint();
        GraphVertex graphVertex3 = hEdge3.getGraphPoint();
        HEdge hEdge4 = new HEdge(graphVertex3, HEdge.INNER);
        HEdge.connect(hEdge4, this.root);
        HEdge.connect(hEdge2, hEdge4);
        HEdge hEdge5 = hEdge4.getSibling();
        if (hEdge5 == null) {
            hEdge5 = new HEdge(hEdge4.getNext().getGraphPoint(), HEdge.INNER);
            HEdge.makeSiblings(hEdge4, hEdge5);
        }
        HEdge.connect(hEdge, hEdge5);
        HEdge.connect(hEdge5, hEdge3);
        Triangle triangle = this.createTriangle(graphVertex.getPoint(), graphVertex2.getPoint(), graphVertex3.getPoint(), this.root);
        this.root = hEdge3;
        return triangle;
    }

    public boolean isSimplex() {
        return this.root.getNext().getNext().getNext() == this.root;
    }

    private HEdge initFromPolyline(GraphOutline graphOutline, VectorUtil.Winding winding) {
        int n;
        int n2;
        ArrayList<GraphVertex> arrayList = graphOutline.getGraphPoint();
        if (arrayList.size() < 3) {
            throw new IllegalArgumentException("outline's vertices < 3: " + arrayList.size());
        }
        VectorUtil.Winding winding2 = VectorUtil.getWinding(arrayList.get(0).getPoint(), arrayList.get(1).getPoint(), arrayList.get(2).getPoint());
        boolean bl = winding2 != winding && winding == VectorUtil.Winding.CW;
        int n3 = winding == VectorUtil.Winding.CCW ? HEdge.BOUNDARY : HEdge.HOLE;
        HEdge hEdge = null;
        HEdge hEdge2 = null;
        if (!bl) {
            n2 = arrayList.size();
            n = 0;
        } else {
            n2 = -1;
            n = arrayList.size() - 1;
        }
        while (n != n2) {
            GraphVertex graphVertex = arrayList.get(n);
            this.box.resize(graphVertex.getX(), graphVertex.getY(), graphVertex.getZ());
            HEdge hEdge3 = new HEdge(graphVertex, n3);
            graphVertex.addEdge(hEdge3);
            if (hEdge2 != null) {
                hEdge2.setNext(hEdge3);
                hEdge3.setPrev(hEdge2);
            } else {
                hEdge = hEdge3;
            }
            if (!bl) {
                if (n == arrayList.size() - 1) {
                    hEdge3.setNext(hEdge);
                    hEdge.setPrev(hEdge3);
                }
                ++n;
            } else {
                if (n == 0) {
                    hEdge3.setNext(hEdge);
                    hEdge.setPrev(hEdge3);
                }
                --n;
            }
            hEdge2 = hEdge3;
        }
        return hEdge;
    }

    public void addConstraintCurve(GraphOutline graphOutline) {
        this.initFromPolyline(graphOutline, VectorUtil.Winding.CW);
        GraphVertex graphVertex = this.locateClosestVertex(graphOutline);
        HEdge hEdge = graphVertex.findBoundEdge();
        HEdge hEdge2 = hEdge.getPrev();
        HEdge hEdge3 = new HEdge(this.root.getGraphPoint(), HEdge.INNER);
        HEdge.connect(this.root.getPrev(), hEdge3);
        HEdge.connect(hEdge3, hEdge);
        HEdge hEdge4 = hEdge3.getSibling();
        if (hEdge4 == null) {
            hEdge4 = new HEdge(hEdge3.getNext().getGraphPoint(), HEdge.INNER);
            HEdge.makeSiblings(hEdge3, hEdge4);
        }
        HEdge.connect(hEdge2, hEdge4);
        HEdge.connect(hEdge4, this.root);
    }

    private GraphVertex locateClosestVertex(GraphOutline graphOutline) {
        HEdge hEdge = null;
        GraphVertex graphVertex = null;
        float f = Float.MAX_VALUE;
        boolean bl = false;
        ArrayList<GraphVertex> arrayList = this.initialOutline.getGraphPoint();
        ArrayList<GraphVertex> arrayList2 = graphOutline.getGraphPoint();
        for (int i = 0; i < arrayList.size() - 1; ++i) {
            GraphVertex graphVertex2 = arrayList.get(i);
            GraphVertex graphVertex3 = arrayList.get(i + 1);
            for (int j = 0; j < arrayList2.size(); ++j) {
                GraphVertex graphVertex4 = arrayList2.get(j);
                float f2 = VectorUtil.computeLength(graphVertex2.getCoord(), graphVertex4.getCoord());
                if (!(f2 < f)) continue;
                for (GraphVertex graphVertex5 : arrayList2) {
                    if (graphVertex5 != graphVertex2 && graphVertex5 != graphVertex3 && graphVertex5 != graphVertex4 && (bl = VectorUtil.inCircle(graphVertex2.getPoint(), graphVertex3.getPoint(), graphVertex4.getPoint(), graphVertex5.getPoint()))) break;
                }
                if (bl) continue;
                graphVertex = graphVertex4;
                f = f2;
                hEdge = graphVertex2.findBoundEdge();
            }
        }
        if (hEdge != null) {
            this.root = hEdge;
        }
        return graphVertex;
    }

    private HEdge findClosestValidNeighbor(HEdge hEdge, boolean bl) {
        HEdge hEdge2 = this.root.getNext();
        if (!VectorUtil.ccw(this.root.getGraphPoint().getPoint(), hEdge2.getGraphPoint().getPoint(), hEdge.getGraphPoint().getPoint())) {
            return null;
        }
        HEdge hEdge3 = hEdge;
        boolean bl2 = false;
        if (bl) {
            Vertex vertex = hEdge3.getGraphPoint().getPoint();
            HEdge hEdge4 = hEdge3.getNext();
            while (hEdge4 != hEdge3) {
                if (hEdge4.getGraphPoint() == this.root.getGraphPoint() || hEdge4.getGraphPoint() == hEdge2.getGraphPoint() || hEdge4.getGraphPoint().getPoint() == vertex) {
                    hEdge4 = hEdge4.getNext();
                    continue;
                }
                bl2 = VectorUtil.inCircle(this.root.getGraphPoint().getPoint(), hEdge2.getGraphPoint().getPoint(), vertex, hEdge4.getGraphPoint().getPoint());
                if (bl2) break;
                hEdge4 = hEdge4.getNext();
            }
        }
        if (!bl2) {
            return hEdge3;
        }
        return null;
    }

    private Triangle createTriangle(Vertex vertex, Vertex vertex2, Vertex vertex3, HEdge hEdge) {
        Triangle triangle = new Triangle(vertex, vertex2, vertex3);
        triangle.setVerticesBoundary(this.checkVerticesBoundary(hEdge));
        return triangle;
    }

    private boolean[] checkVerticesBoundary(HEdge hEdge) {
        boolean[] blArray = new boolean[3];
        HEdge hEdge2 = hEdge;
        HEdge hEdge3 = hEdge.getNext();
        HEdge hEdge4 = hEdge.getNext().getNext();
        if (hEdge2.getGraphPoint().isBoundaryContained()) {
            blArray[0] = true;
        }
        if (hEdge3.getGraphPoint().isBoundaryContained()) {
            blArray[1] = true;
        }
        if (hEdge4.getGraphPoint().isBoundaryContained()) {
            blArray[2] = true;
        }
        return blArray;
    }

    public boolean checkInside(Vertex vertex) {
        if (!this.box.contains(vertex.getX(), vertex.getY(), vertex.getZ())) {
            return false;
        }
        boolean bl = false;
        HEdge hEdge = this.root;
        HEdge hEdge2 = this.root.getNext();
        do {
            Vertex vertex2 = hEdge.getGraphPoint().getPoint();
            Vertex vertex3 = hEdge2.getGraphPoint().getPoint();
            if (vertex3.getY() > vertex.getY() != vertex2.getY() > vertex.getY() && vertex.getX() < (vertex2.getX() - vertex3.getX()) * (vertex.getY() - vertex3.getY()) / (vertex2.getY() - vertex3.getY()) + vertex3.getX()) {
                bl = !bl;
            }
            hEdge = hEdge2;
            hEdge2 = hEdge.getNext();
        } while (hEdge != this.root);
        return bl;
    }

    public int computeLoopSize() {
        int n = 0;
        HEdge hEdge = this.root;
        do {
            ++n;
        } while ((hEdge = hEdge.getNext()) != this.root);
        return n;
    }
}

