/*  ---------------------------------------------------------------
    xhkeys. Jul 2002
    Copyright (C) 2002,  Michael Glickman  <wmalms@yahoo.com>
    License: GPL
    --------------------------------------------------------------- */

#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "xhkeys_conf.h"

#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#ifdef USE_DMALLOC
#include <dmalloc.h>
#endif

#include "xhkeys.h"
// #include "plugin_common.h"

/* resources.c */
extern CmdDescr *Commands;
extern int btnTimeout;


// system.h
extern char **environ;

// xhkeys.c
extern Display *dpy;
extern Window root_wnd;

// common.c
extern const char *SpecCodeNames[];
extern const int SpecCodeCount;

#ifdef PLUGIN_SUPPORT
extern PluginData *Plugins;
extern int PluginCount;
extern int maxPlugins;
#endif

#ifdef OSD_SUPPORT
extern int osdEnabled;
#endif

static Bool parse_parm_plusminus(char *parm, int *valPtr, short *dirPtr, char **sepPtr)
{
  short dir = 0;
  int val = 0;
  char *sep;
  
  while (*parm == ' ') parm++;
  
  if (*parm == '+') { dir = 1; parm++; }
  if (*parm == '-') { dir = -1; parm++; }
  if (*parm == '=') { dir = 2; parm++; }

  val = strtol(parm, &sep, 0);
  if (sepPtr == NULL) {
    if (*sep != ' ' && *sep != '\0') return False;
  } else
	*sepPtr=sep;
  
  *valPtr = val;
  *dirPtr = dir;
  return True;	
}


static Bool wnd_rotate(Window main_wnd, char *parm, int type_modifier, const char *title)
{
  int value;
  short dir;
  Window cur;

  if (parse_parm_plusminus(parm, &value, &dir, NULL) == False)
  {  value = 1; dir = 1; }

  if (value <= 0) value = 1;
  if (dir >= 0) dir = 1; else dir = -1;

  while (--value >= 0) {
    cur = findVisibleWindow(main_wnd, dir);
	if (cur == None) return False;
	if (dir >= 0) XRaiseWindow(dpy, cur);
	        else  XLowerWindow(dpy, cur);

  }
  
#ifdef OSD_SUPPORT    
    if (type_modifier != 2) {
	if (title == NULL || *title=='\0')
	    title = "Rotate Windows";
	ShowOSDText(title);
    }	
#endif
  
  return True;  
}  

static Bool wnd_close(char *parm)
{
    int revTo;
    Window wnd;
    int style;
    long state;
    char schr;
    static const char *AllArgs = "FS";
#ifdef OSD_SUPPORT    
    XClassHint   xch;
    char titleFull[61];
#endif

    schr = toupper(*parm);
    style = 0;		// Input focus

    if (schr != '\0' && strchr(" \t#", schr) == NULL) {
	char *sptr = strchr(AllArgs, schr);
	if (sptr == NULL) {
	    log_message(True, "WndClose invalid argument: I or S expected");
	    return False;
	}    
	style = sptr - AllArgs;
    } 

    // Select windows
    if (style == 0) {
	// State: WithdrawnState(0), NormalState(1), IconicState(2)    
        if (XGetInputFocus(dpy, &wnd, &revTo) == False) return False;
    } else {
	XEvent xev;
	char *errMsg;
	short res;
	
#ifdef OSD_SUPPORT    
	ShowOSDText("Click a window to close");
#endif	
	for (res = 0; ; res++) {
	    XBell(dpy, 50); 
	    if (res == 2) break;
	    usleep(200000);
	}    
    
	res = getMouseEvent(&xev, btnTimeout, &errMsg);
        if (res != 1) {
	    if (res == 2) errMsg = "Cancelled on time-out";	

#ifdef OSD_SUPPORT    
	    if (osdEnabled)
	        ShowOSDText(errMsg);
	    else	
#endif
		log_message(True, errMsg);

	    return False;	
	}
	
	// It's OK !	
	wnd = xev.xbutton.subwindow;
	if (wnd != None) wnd = findClientWindow(wnd, -1);
    }    


    if (wnd == None || wnd == root_wnd ||
	GetWindowState(wnd, &state) == False ||
	state <= 0) return False;
	  
#ifdef OSD_SUPPORT    
    if (XGetClassHint(dpy, wnd, &xch)) 	
        snprintf(titleFull, sizeof(titleFull), "'%s' closed", xch.res_name);
    else
        snprintf(titleFull, sizeof(titleFull), "Application closed");

    titleFull[sizeof(titleFull)-1] = '\0';
#endif

    if (XKillClient(dpy, wnd) == False) return False;
	  

#ifdef OSD_SUPPORT    
    ShowOSDText(titleFull);
#endif	    

    return True;
}

#ifdef OSD_SUPPORT
static Bool show_version(void)
{
    char message[41];
//    strncpy(message, "xhkeys " VERSION_TEXT " " __DATE__, sizeof(message));
    strncpy(message, "xhkeys " VERSION_TEXT " " RELEASE_DATE " wmalms.tripod.com ", sizeof(message));
    ShowOSDText(message);
    return True;
}
#endif

#ifdef PLUGIN_SUPPORT
static Bool kill_pugin(int type_modifier, const char *title)
{
    Bool   success = DiscontinuePlugin(True);
# ifdef OSD_SUPPORT
    if (success) {
	if (type_modifier == 2)
	    HideOSD();
	else {
	    if (title == NULL || *title=='\0')
		title = "Plugin terminated";
	    ShowOSDText(title);
	}   
    }	    	
# endif

    return success;
}
#endif

static Bool ProcessSpecCommandByCode(int code, char *parm, int type_modifier, const char *title)
{
  Bool success = False;

    switch(code)
    {
	case SPEC_WNDROTATE:
//	    XCirculateSubwindowsUp(dpy, wnd);
	    success = wnd_rotate(root_wnd, parm, type_modifier, title);
	    break;

	case SPEC_WNDCLOSE:
	    success = wnd_close(parm);
	    break;

#ifdef PLUGIN_SUPPORT
	case SPEC_KILLPLUGIN:
	    success = kill_pugin(type_modifier, title);
	    break;
#endif

#ifdef OSD_SUPPORT
	case SPEC_VERSION:
//	    XCirculateSubwindowsUp(dpy, wnd);
	    success = show_version();
	    break;
#endif
  }

  return success;
  
}


// Returns 1-success, 0-fail, (-1)-quit command
int ProcessSpecFunction(int cmdIndex)
{
  char *cmdCopy, *argPtr, *cmdNext;
  int type_modifier = Commands[cmdIndex].type_modifier;
  int i, rc = 0;
  char *title = NULL;
 
  
    cmdCopy = strdup(Commands[cmdIndex].command);
    if (cmdCopy == NULL) goto OutOfHere;

    cmdNext = strpbrk(cmdCopy, "#\t");
    if (cmdNext != NULL) *cmdNext = '\0';
    
    cmdNext = cmdCopy;

    if (type_modifier == 1) 
	title = strsep(&cmdNext, ";");

    argPtr = strsep(&cmdNext, " ;,");
    if (argPtr == NULL) goto OutOfHere;  
  
    for (i=0; i<SpecCodeCount && strcasecmp(SpecCodeNames[i], argPtr);  i++);

    if (i < SpecCodeCount) {
	
	if (i==SPEC_QUIT) {
#ifdef OSD_SUPPORT  
    	    if (type_modifier != 2) {
		if (title == NULL || *title=='\0')
		    title = "xhkeys quit";
		ShowOSDText(title); usleep(500000);   
	    }	
#endif      
    	    rc=-1; 
	}
	else {
	    
	    argPtr = strsep(&cmdNext, "");
	    if (argPtr) { while (*argPtr == ' ') argPtr++; }
	    else argPtr = "";
  
	    if (ProcessSpecCommandByCode(i, argPtr, type_modifier, title)) rc = 1;
	}   
#ifdef PLUGIN_SUPPORT
	goto OutOfHere;
#endif
    }	

#ifdef PLUGIN_SUPPORT

# if defined(MIXER_SUPPORT)  
    if (strncasecmp(argPtr, "cd", 2) == 0) {
	rc = CallPluginByName(cmdIndex, "xhkeys_cdaudio", argPtr+2, cmdNext, 0);	
	goto OutOfHere;
    }	
#  if defined(MIXER_SUPPORT)
    else	
#  endif
# endif

# if defined(MIXER_SUPPORT)  
    if (strncasecmp(argPtr, "snd", 3) == 0) {
	rc = CallPluginByName(cmdIndex, "xhkeys_mixer", argPtr+3, cmdNext, 0);	
	goto OutOfHere;
    }	
# endif

#endif
  
OutOfHere:
  if (cmdCopy) free(cmdCopy);    
  return rc;
}  


Bool ProcessExtApp(const char * command, int type_modifier)
{
  int pid;
  const char *title = command;
  int titleLen = -1;

  if (command == NULL) return False;    
  
  if (type_modifier == 1) {
    // Explicit title
    command = strchr(command, ';');
    if (command == NULL) return False;

    titleLen = command-title;

    if (titleLen == 0) {
	command = title;
	titleLen = strlen(title);
    } else {
	titleLen = command-title;
	command++;
    }
  } else {
    // No explicit title
    titleLen = strlen(title);
  }
    
  pid = fork();

  if (pid == 0) {
	char *shell, *sh_name;
	char * argv[4];
	char cmdcopy[512];
	
	shell = getenv("SHELL");
	if (shell == NULL)  shell = "/bin/sh";
  
	sh_name = strrchr(shell, '/');
	if (sh_name == NULL) sh_name = shell; else sh_name++;

	strncpy(cmdcopy, command, sizeof(cmdcopy));
	argv[0] = sh_name;
	argv[1] = "-c";
	argv[2] = cmdcopy;
	argv[3] = NULL;
	freopen("/dev/null", "w", stdout);
	freopen("/dev/null", "r", stdin);
	execve(shell, argv, environ);

	XBell(dpy, 50);
  } else 
  if (pid == -1)
    return False;
#ifdef OSD_SUPPORT    
  else 
  if (type_modifier != 2) {
    // Parent process  
    PrepareOSD();
    ShowOSD(title, titleLen);     
  }        
#endif


  return True;
}
