/*
 * Decompiled with CFR 0.152.
 */
package org.cachebench;

import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cachebench.CacheWrapper;
import org.cachebench.cluster.ClusterBarrier;
import org.cachebench.config.CacheWarmupConfig;
import org.cachebench.config.ConfigBuilder;
import org.cachebench.config.Configuration;
import org.cachebench.config.Report;
import org.cachebench.config.TestCase;
import org.cachebench.config.TestConfig;
import org.cachebench.reportgenerators.ClusterAwareReportGenerator;
import org.cachebench.reportgenerators.ReportGenerator;
import org.cachebench.tests.CacheTest;
import org.cachebench.tests.ClusteredCacheTest;
import org.cachebench.tests.StatisticTest;
import org.cachebench.tests.results.BaseTestResult;
import org.cachebench.tests.results.StatisticTestResult;
import org.cachebench.tests.results.TestResult;
import org.cachebench.utils.Instantiator;
import org.cachebench.warmup.CacheWarmup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheBenchmarkRunner {
    private Configuration conf;
    private Log log = LogFactory.getLog(CacheBenchmarkRunner.class);
    private Log errorLogger = LogFactory.getLog((String)"CacheException");
    String cacheProductName;
    String configuraton;
    int clusterSize;
    Map<String, String> systemParams = new HashMap<String, String>();
    boolean localOnly;

    public static void main(String[] args) {
        String conf = null;
        if (args.length == 1) {
            conf = args[0];
        }
        if (conf != null && conf.toLowerCase().endsWith(".xml")) {
            new CacheBenchmarkRunner(conf);
        } else {
            new CacheBenchmarkRunner();
        }
    }

    private void initJVMParams(String defaultCfgFile) {
        boolean useFlatCache = Boolean.getBoolean("cacheBenchFwk.useFlatCache");
        String overallCfg = System.getProperty("cacheBenchFwk.fwkCfgFile", defaultCfgFile);
        String configuraton = System.getProperty("cacheBenchFwk.cacheConfigFile");
        String cacheProductName = System.getProperty("cacheBenchFwk.cacheProductName");
        String suffix = System.getProperty("cacheBenchFwk.productSuffix");
        if (suffix != null && !suffix.trim().equals("")) {
            cacheProductName = cacheProductName + suffix;
        }
        String clusterSize = System.getProperty("clusterSize");
        this.localOnly = Boolean.getBoolean("localOnly");
        this.systemParams.put("fwk.config", overallCfg);
        if (configuraton != null) {
            this.systemParams.put("config", configuraton);
        }
        if (cacheProductName != null) {
            this.systemParams.put("cacheProductName", cacheProductName);
        }
        if (clusterSize != null) {
            this.systemParams.put("clusterSize", clusterSize);
        }
        if (this.localOnly) {
            this.systemParams.put("localOnly", "TRUE");
        }
        if (useFlatCache) {
            this.systemParams.put("cacheBenchFwk.useFlatCache", "TRUE");
        }
    }

    private CacheBenchmarkRunner() {
        this("cachebench.xml");
    }

    private CacheBenchmarkRunner(String s) {
        this.initJVMParams(s);
        s = this.systemParams.get("fwk.config");
        URL confFile = ConfigBuilder.findConfigFile(s);
        if (confFile == null) {
            this.log.warn((Object)("Unable to locate a configuration file " + s + "; Application terminated"));
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Using configuration " + confFile));
            }
            this.log.debug((Object)"Parsing configuration");
            try {
                this.conf = ConfigBuilder.parseConfiguration(confFile);
                this.log.info((Object)"Starting Benchmarking....");
                List<TestResult> results = this.runTests();
                if (results != null && results.size() != 0) {
                    this.generateReports(results);
                } else {
                    this.log.warn((Object)"No Results to be reported");
                }
                this.log.info((Object)"Benchmarking Completed.  Hope you enjoyed using this! \n");
            }
            catch (Throwable e) {
                this.log.warn((Object)("Unable to parse configuration file " + confFile + ". Application terminated"), e);
                this.errorLogger.fatal((Object)("Unable to parse configuration file " + confFile), e);
            }
        }
    }

    CacheWrapper newCache(TestCase test) throws Exception {
        CacheWrapper cache = this.getCacheWrapperInstance(test);
        if (cache != null) {
            Map<String, String> params = test.getParams();
            params.putAll(this.systemParams);
            this.log.info((Object)("Initialising cache with params " + params));
            cache.init(params);
            cache.setUp();
        }
        return cache;
    }

    private List<TestResult> runTests() throws Exception {
        ArrayList<TestResult> results = new ArrayList<TestResult>();
        for (TestCase test : this.conf.getTestCases()) {
            CacheWrapper cache = null;
            try {
                cache = this.newCache(test);
                if (cache == null) continue;
                cache.setUp();
                this.warmupCache(test, cache);
                List<TestResult> resultsForCache = this.runTestsOnCache(cache, test);
                if (!this.localOnly) {
                    this.barrier("AFTER_TEST_RUN");
                }
                this.shutdownCache(cache);
                results.addAll(resultsForCache);
            }
            catch (Exception e) {
                try {
                    this.shutdownCache(cache);
                }
                catch (Exception e1) {
                    // empty catch block
                }
                this.log.warn((Object)"Unable to Initialize or Setup the Cache - Not performing any tests", (Throwable)e);
                this.errorLogger.error((Object)("Unable to Initialize or Setup the Cache: " + test.getCacheWrapper()), (Throwable)e);
                this.errorLogger.error((Object)"Skipping this test");
            }
        }
        return results;
    }

    private void barrier(String messageName) throws Exception {
        ClusterBarrier barrier = new ClusterBarrier();
        this.log.trace((Object)("Using following cluster config: " + this.conf.getClusterConfig()));
        barrier.setConfig(this.conf.getClusterConfig());
        barrier.setAcknowledge(true);
        barrier.barrier(messageName);
        this.log.info((Object)("Barrier for '" + messageName + "' finished"));
    }

    private void warmupCache(TestCase test, CacheWrapper cache) throws Exception {
        if (!this.localOnly) {
            this.barrier("BEFORE_WARMUP");
        }
        this.log.info((Object)"Warming up..");
        CacheWarmupConfig warmupConfig = test.getCacheWarmupConfig();
        this.log.trace((Object)("Warmup config is: " + warmupConfig));
        CacheWarmup warmup = (CacheWarmup)Instantiator.getInstance().createClass(warmupConfig.getWarmupClass());
        warmup.setConfigParams(warmupConfig.getParams());
        warmup.warmup(cache);
        this.log.info((Object)"Warmup ended!");
        if (!this.localOnly) {
            this.barrier("AFTER_WARMUP");
        }
    }

    private TestResult executeTestTasks(CacheWrapper cache, TestResult testResult) {
        try {
            if (this.conf.isEmptyCacheBetweenTests()) {
                cache.empty();
            }
            if (this.conf.isGcBetweenTestsEnabled()) {
                System.gc();
                Thread.sleep(this.conf.getSleepBetweenTests());
            }
        }
        catch (InterruptedException e) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return testResult;
    }

    private List<TestResult> runTestsOnCache(CacheWrapper cache, TestCase testCase) {
        ArrayList<TestResult> results = new ArrayList<TestResult>();
        for (TestConfig testConfig : testCase.getTests()) {
            TestResult result;
            CacheTest testInstance = this.getCacheTest(testConfig);
            if (testInstance instanceof ClusteredCacheTest && this.localOnly) {
                this.log.warn((Object)"Skipping replicated tests since this is in local mode!");
                continue;
            }
            if (testInstance == null) continue;
            String testName = testConfig.getName();
            String testCaseName = testCase.getName();
            try {
                if (testInstance instanceof StatisticTest) {
                    int repeat = testConfig.getRepeat();
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)("Running test " + repeat + " times"));
                    }
                    StatisticTestResult str = new StatisticTestResult();
                    for (int i = 0; i < repeat; ++i) {
                        ((StatisticTest)((Object)testInstance)).doCumulativeTest(testName, cache, testCaseName, this.conf.getSampleSize(), this.conf.getNumThreads(), str);
                        if (this.conf.isEmptyCacheBetweenTests()) {
                            if (this.conf.isLocalOnly()) {
                                this.shutdownCache(cache);
                                if (i != repeat - 1) {
                                    cache = this.newCache(testCase);
                                }
                            } else {
                                cache.empty();
                            }
                        }
                        if (!this.conf.isGcBetweenTestsEnabled()) continue;
                        System.gc();
                        Thread.sleep(this.conf.getSleepBetweenTests());
                    }
                    result = str;
                } else {
                    result = testInstance.doTest(testName, cache, testCaseName, this.conf.getSampleSize(), this.conf.getNumThreads());
                }
            }
            catch (Exception e) {
                result = new BaseTestResult();
                result.setTestName(testCaseName);
                result.setTestTime(new Date());
                result.setTestType(testName);
                result.setTestPassed(false);
                result.setErrorMsg("Failed to Execute - See logs for details : " + e.getMessage());
                this.log.warn((Object)("Test case : " + testCaseName + ", Test : " + testName + " - Failed due to"), (Throwable)e);
                this.errorLogger.error((Object)("Test case : " + testCaseName + ", Test : " + testName + " - Failed : " + e.getMessage()), (Throwable)e);
            }
            if (!result.isTestPassed() && testCase.isStopOnFailure()) {
                this.log.warn((Object)("The test '" + testCase + "/" + testName + "' failed, exiting..."));
                System.exit(1);
            }
            this.executeTestTasks(cache, result);
            if (result.isSkipReport()) continue;
            results.add(result);
        }
        return results;
    }

    private void generateReports(List<TestResult> results) {
        this.log.info((Object)"Generating Reports...");
        for (Report report : this.conf.getReports()) {
            try {
                ReportGenerator generator = this.getReportGenerator(report);
                if (generator != null) {
                    if (generator instanceof ClusterAwareReportGenerator && this.localOnly) {
                        throw new IllegalArgumentException("Configured to run in local mode only, cannot use a clustered report generator!");
                    }
                    Map<String, String> params = report.getParams();
                    params.putAll(this.systemParams);
                    generator.setConfigParams(params);
                    generator.setResults(results);
                    generator.setClusterConfig(this.conf.getClusterConfig());
                    generator.setOutputFile(report.getOutputFile());
                    generator.generate();
                    this.log.info((Object)"Report Generation Completed");
                    continue;
                }
                this.log.info((Object)"Report not generated - See logs for reasons!!");
            }
            catch (Exception e) {
                this.log.warn((Object)("Unable to generate Report : " + report.getGenerator() + " - See logs for reasons"));
                this.log.warn((Object)"Skipping this report");
                this.errorLogger.error((Object)("Unable to generate Report : " + report.getGenerator()), (Throwable)e);
                this.errorLogger.error((Object)"Skipping this report");
            }
        }
    }

    private CacheWrapper getCacheWrapperInstance(TestCase testCaseClass) {
        CacheWrapper cache = null;
        try {
            cache = (CacheWrapper)Instantiator.getInstance().createClass(testCaseClass.getCacheWrapper());
        }
        catch (Exception e) {
            this.log.warn((Object)("Unable to instantiate CacheWrapper class: " + testCaseClass.getCacheWrapper() + " - Not Running any tests"));
            this.errorLogger.error((Object)("Unable to instantiate CacheWrapper class: " + testCaseClass.getCacheWrapper()), (Throwable)e);
            this.errorLogger.error((Object)"Skipping this test");
        }
        return cache;
    }

    private ReportGenerator getReportGenerator(Report reportClass) {
        ReportGenerator report = null;
        try {
            report = (ReportGenerator)Instantiator.getInstance().createClass(reportClass.getGenerator());
        }
        catch (Exception e) {
            this.log.warn((Object)("Unable to instantiate ReportGenerator class: " + reportClass.getGenerator() + " - Not generating the report"));
            this.errorLogger.error((Object)("Unable to instantiate ReportGenerator class: " + reportClass.getGenerator()), (Throwable)e);
            this.errorLogger.error((Object)"Skipping this report");
        }
        return report;
    }

    private CacheTest getCacheTest(TestConfig testConfig) {
        CacheTest cacheTestClass = null;
        try {
            cacheTestClass = (CacheTest)Instantiator.getInstance().createClass(testConfig.getTestClass());
            this.conf.setLocalOnly(this.localOnly);
            cacheTestClass.setConfiguration(this.conf);
        }
        catch (Exception e) {
            this.log.warn((Object)("Unable to instantiate CacheTest class: " + testConfig.getTestClass() + " - Not Running any tests"));
            this.errorLogger.error((Object)("Unable to instantiate CacheTest class: " + testConfig.getTestClass()), (Throwable)e);
            this.errorLogger.error((Object)"Skipping this Test");
        }
        return cacheTestClass;
    }

    private void shutdownCache(CacheWrapper cache) {
        try {
            cache.tearDown();
        }
        catch (Exception e) {
            this.log.warn((Object)"Cache Shutdown - Failed.");
            this.errorLogger.error((Object)"Cache Shutdown failed : ", (Throwable)e);
        }
    }
}

